"""Fluent Solver TUI Commands"""
#
# This is an auto-generated file.  DO NOT EDIT!
#
# pylint: disable=line-too-long

from ansys.fluent.core.services.datamodel_tui import PyMenu, TUIMenu



class main_menu(TUIMenu):
    """
    Fluent solver main menu.
    """
    def __init__(self, path, service):
        self.path = path
        self.service = service
        self.views = self.__class__.views(path + ["views"], service)
        self.icing = self.__class__.icing(path + ["icing"], service)
        self.file = self.__class__.file(path + ["file"], service)
        self.solution = self.__class__.solution(path + ["solution"], service)
        self.turbo_post = self.__class__.turbo_post(path + ["turbo_post"], service)
        self.display = self.__class__.display(path + ["display"], service)
        self.parameters__and__customization = self.__class__.parameters__and__customization(path + ["parameters__and__customization"], service)
        self.solve = self.__class__.solve(path + ["solve"], service)
        self.surface = self.__class__.surface(path + ["surface"], service)
        self.adjoint = self.__class__.adjoint(path + ["adjoint"], service)
        self.preferences = self.__class__.preferences(path + ["preferences"], service)
        self.plot = self.__class__.plot(path + ["plot"], service)
        self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
        self.setup = self.__class__.setup(path + ["setup"], service)
        self.simulation_reports = self.__class__.simulation_reports(path + ["simulation_reports"], service)
        self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
        self.mesh = self.__class__.mesh(path + ["mesh"], service)
        self.parallel = self.__class__.parallel(path + ["parallel"], service)
        self.report = self.__class__.report(path + ["report"], service)
        self.define = self.__class__.define(path + ["define"], service)
        self.results = self.__class__.results(path + ["results"], service)
        self.server = self.__class__.server(path + ["server"], service)
        super().__init__(path, service)
    def print_license_usage(self, *args, **kwargs):
        """
        Print license usage information.
        """
        return PyMenu(self.service, "/print_license_usage").execute(*args, **kwargs)
    def close_fluent(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/close_fluent").execute(*args, **kwargs)
    def switch_to_meshing_mode(self, *args, **kwargs):
        """
        Switches from the solution mode to the meshing mode. This text command is only available if you have not yet read a mesh or a case file.
        """
        return PyMenu(self.service, "/switch_to_meshing_mode").execute(*args, **kwargs)
    def exit(self, *args, **kwargs):
        """
        Exit program.
        """
        return PyMenu(self.service, "/exit").execute(*args, **kwargs)

    class views(TUIMenu):
        """
        Enter the view manipulation menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.display_states = self.__class__.display_states(path + ["display_states"], service)
            self.camera = self.__class__.camera(path + ["camera"], service)
            super().__init__(path, service)
        def default_view(self, *args, **kwargs):
            """
            Resets view to front and center.
            """
            return PyMenu(self.service, "/views/default_view").execute(*args, **kwargs)
        def restore_view(self, *args, **kwargs):
            """
            Uses a saved view.
            """
            return PyMenu(self.service, "/views/restore_view").execute(*args, **kwargs)
        def auto_scale(self, *args, **kwargs):
            """
            Scales and centers the current scene without changing its orientation.
            """
            return PyMenu(self.service, "/views/auto_scale").execute(*args, **kwargs)
        def list_views(self, *args, **kwargs):
            """
            Lists predefined and saved views.
            """
            return PyMenu(self.service, "/views/list_views").execute(*args, **kwargs)
        def next_view(self, *args, **kwargs):
            """
            .
            """
            return PyMenu(self.service, "/views/next_view").execute(*args, **kwargs)
        def read_views(self, *args, **kwargs):
            """
            Reads views from a view file.
            """
            return PyMenu(self.service, "/views/read_views").execute(*args, **kwargs)
        def last_view(self, *args, **kwargs):
            """
            Returns to the camera position before the last manipulation.
            """
            return PyMenu(self.service, "/views/last_view").execute(*args, **kwargs)
        def delete_view(self, *args, **kwargs):
            """
            Removes a view from the list.
            """
            return PyMenu(self.service, "/views/delete_view").execute(*args, **kwargs)
        def save_view(self, *args, **kwargs):
            """
            Saves the current view to the view list.
            """
            return PyMenu(self.service, "/views/save_view").execute(*args, **kwargs)
        def write_views(self, *args, **kwargs):
            """
            Writes selected views to a view file.
            """
            return PyMenu(self.service, "/views/write_views").execute(*args, **kwargs)

        class display_states(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete object.
                """
                return PyMenu(self.service, "/views/display_states/delete").execute(*args, **kwargs)
            def restore_state(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/restore_state").execute(*args, **kwargs)
            def use_active(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/use_active").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Rename object.
                """
                return PyMenu(self.service, "/views/display_states/rename").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/list").execute(*args, **kwargs)
            def new(self, *args, **kwargs):
                """
                Create a new display-states object.
                """
                return PyMenu(self.service, "/views/display_states/new").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/copy").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit display-states object.
                """
                return PyMenu(self.service, "/views/display_states/edit").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/write").execute(*args, **kwargs)
            def read(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/display_states/read").execute(*args, **kwargs)

        class camera(TUIMenu):
            """
            Enters the camera menu to modify the current viewing parameters.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def field(self, *args, **kwargs):
                """
                Sets the field of view (width and height).
                """
                return PyMenu(self.service, "/views/camera/field").execute(*args, **kwargs)
            def target(self, *args, **kwargs):
                """
                Sets the point to be the center of the camera view.
                """
                return PyMenu(self.service, "/views/camera/target").execute(*args, **kwargs)
            def position(self, *args, **kwargs):
                """
                Sets the camera position.
                """
                return PyMenu(self.service, "/views/camera/position").execute(*args, **kwargs)
            def projection(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/views/camera/projection").execute(*args, **kwargs)
            def orbit_camera(self, *args, **kwargs):
                """
                Adjusts the camera position without modifying the target.
                """
                return PyMenu(self.service, "/views/camera/orbit_camera").execute(*args, **kwargs)
            def zoom_camera(self, *args, **kwargs):
                """
                Adjusts the camera’s field of view. This operation is similar to dollying the camera in or out of the scene. Dollying causes objects in front to move past you. Zooming changes the perspective effect in the scene (and can be disconcerting).
                """
                return PyMenu(self.service, "/views/camera/zoom_camera").execute(*args, **kwargs)
            def up_vector(self, *args, **kwargs):
                """
                Sets the camera up-vector.
                """
                return PyMenu(self.service, "/views/camera/up_vector").execute(*args, **kwargs)
            def roll_camera(self, *args, **kwargs):
                """
                Adjusts the camera up-vector.
                """
                return PyMenu(self.service, "/views/camera/roll_camera").execute(*args, **kwargs)
            def pan_camera(self, *args, **kwargs):
                """
                Adjusts the camera target without modifying the position.
                """
                return PyMenu(self.service, "/views/camera/pan_camera").execute(*args, **kwargs)
            def dolly_camera(self, *args, **kwargs):
                """
                Adjusts the camera position and target.
                """
                return PyMenu(self.service, "/views/camera/dolly_camera").execute(*args, **kwargs)

    class icing(TUIMenu):
        """
        FENSAP-ICE options.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def settings(self, *args, **kwargs):
            """
            Global settings menu.
            """
            return PyMenu(self.service, "/icing/settings").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            File menu.
            """
            return PyMenu(self.service, "/icing/file").execute(*args, **kwargs)
        def multishot(self, *args, **kwargs):
            """
            Multi-shot accretion menu.
            """
            return PyMenu(self.service, "/icing/multishot").execute(*args, **kwargs)
        def flow(self, *args, **kwargs):
            """
            Flow solver menu.
            """
            return PyMenu(self.service, "/icing/flow").execute(*args, **kwargs)
        def drop(self, *args, **kwargs):
            """
            Droplet impingement menu.
            """
            return PyMenu(self.service, "/icing/drop").execute(*args, **kwargs)
        def ice(self, *args, **kwargs):
            """
            Ice accretion menu.
            """
            return PyMenu(self.service, "/icing/ice").execute(*args, **kwargs)

    class file(TUIMenu):
        """
        Enter the file menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.parametric_project = self.__class__.parametric_project(path + ["parametric_project"], service)
            self.interpolate = self.__class__.interpolate(path + ["interpolate"], service)
            self.transient_export = self.__class__.transient_export(path + ["transient_export"], service)
            self.export = self.__class__.export(path + ["export"], service)
            self.em_mapping = self.__class__.em_mapping(path + ["em_mapping"], service)
            self.auto_save = self.__class__.auto_save(path + ["auto_save"], service)
            self.cffio_options = self.__class__.cffio_options(path + ["cffio_options"], service)
            self.import_ = self.__class__.import_(path + ["import"], service)
            self.solution_files = self.__class__.solution_files(path + ["solution_files"], service)
            self.table_manager = self.__class__.table_manager(path + ["table_manager"], service)
            self.fsi = self.__class__.fsi(path + ["fsi"], service)
            self.project = self.__class__.project(path + ["project[beta]"], service)
            super().__init__(path, service)
        def read_case_info(self, *args, **kwargs):
            """
            Read basic case info.
            """
            return PyMenu(self.service, "/file/read_case_info").execute(*args, **kwargs)
        def read_data(self, *args, **kwargs):
            """
            Reads a data file.
            """
            return PyMenu(self.service, "/file/read_data").execute(*args, **kwargs)
        def write_field_functions(self, *args, **kwargs):
            """
            Writes the currently defined custom field functions to a file.
            """
            return PyMenu(self.service, "/file/write_field_functions").execute(*args, **kwargs)
        def write_circumferential_averaged_profile(self, *args, **kwargs):
            """
            Write surface data as a boundary profile file. To use \*.csv format specify filename with .csv suffix.
            """
            return PyMenu(self.service, "/file/write_circumferential_averaged_profile").execute(*args, **kwargs)
        def read_macros(self, *args, **kwargs):
            """
            Reads macro definitions from a file.
            """
            return PyMenu(self.service, "/file/read_macros").execute(*args, **kwargs)
        def confirm_overwrite(self, *args, **kwargs):
            """
            Indicate whether or not to confirm attempts to overwrite existing files.
            """
            return PyMenu(self.service, "/file/confirm_overwrite").execute(*args, **kwargs)
        def single_precision_coordinates(self, *args, **kwargs):
            """
            Specifies whether the nodal coordinates should be written in single precision (rather than the default double precision). This text command is only available in the single-precision version of ANSYS Fluent.
            """
            return PyMenu(self.service, "/file/single_precision_coordinates").execute(*args, **kwargs)
        def read_case(self, *args, **kwargs):
            """
            Read a case file.
            """
            return PyMenu(self.service, "/file/read_case").execute(*args, **kwargs)
        def read_journal(self, *args, **kwargs):
            """
            Read a journal file.
            """
            return PyMenu(self.service, "/file/read_journal").execute(*args, **kwargs)
        def read_isat_table(self, *args, **kwargs):
            """
            Reads ISAT Table.
            """
            return PyMenu(self.service, "/file/read_isat_table").execute(*args, **kwargs)
        def read_profile(self, *args, **kwargs):
            """
            Reads boundary profile data.
            """
            return PyMenu(self.service, "/file/read_profile").execute(*args, **kwargs)
        def write_boundary_mesh(self, *args, **kwargs):
            """
            Writes the boundary mesh to a file.
            """
            return PyMenu(self.service, "/file/write_boundary_mesh").execute(*args, **kwargs)
        def read_settings(self, *args, **kwargs):
            """
            Reads and sets boundary conditions from a specified file.
            """
            return PyMenu(self.service, "/file/read_settings").execute(*args, **kwargs)
        def data_file_options(self, *args, **kwargs):
            """
            Sets derived quantities to be written in data file.
            """
            return PyMenu(self.service, "/file/data_file_options").execute(*args, **kwargs)
        def write_fan_profile(self, *args, **kwargs):
            """
            Computes radial profiles for a fan zone and writes them to a profile file.
            """
            return PyMenu(self.service, "/file/write_fan_profile").execute(*args, **kwargs)
        def stop_journal(self, *args, **kwargs):
            """
            Stop recording input and close the journal file.
            """
            return PyMenu(self.service, "/file/stop_journal").execute(*args, **kwargs)
        def execute_macro(self, *args, **kwargs):
            """
            Runs a previously defined macro.
            """
            return PyMenu(self.service, "/file/execute_macro").execute(*args, **kwargs)
        def sync_workbench(self, *args, **kwargs):
            """
            Directly updates Workbench with the most recent Fluent changes. This command is only available when running ANSYS Fluent in Workbench.
            """
            return PyMenu(self.service, "/file/sync_workbench").execute(*args, **kwargs)
        def start_journal(self, *args, **kwargs):
            """
            Start recording all input in a file.
            """
            return PyMenu(self.service, "/file/start_journal").execute(*args, **kwargs)
        def set_target_reference_frame_for_write_profiles(self, *args, **kwargs):
            """
            Set reference frame options, which will be used for position transformation during writing of profiles.
            """
            return PyMenu(self.service, "/file/set_target_reference_frame_for_write_profiles").execute(*args, **kwargs)
        def write_selected_defined_profiles(self, *args, **kwargs):
            """
            Set profile names, only these profile names which will be used during writing of \*.csv profiles.
            """
            return PyMenu(self.service, "/file/write_selected_defined_profiles").execute(*args, **kwargs)
        def write_pdat(self, *args, **kwargs):
            """
            Enables / disables the attempt to save .pdat files. Note that this text command is no longer supported.
            """
            return PyMenu(self.service, "/file/write_pdat").execute(*args, **kwargs)
        def write_case(self, *args, **kwargs):
            """
            Write a case file.
            """
            return PyMenu(self.service, "/file/write_case").execute(*args, **kwargs)
        def set_tui_version(self, *args, **kwargs):
            """
            Set the version of the TUI commands.
            """
            return PyMenu(self.service, "/file/set_tui_version").execute(*args, **kwargs)
        def write_currently_defined_profiles(self, *args, **kwargs):
            """
            Write currently defined profiles. To use \*.csv format specify filename with .csv suffix.
            """
            return PyMenu(self.service, "/file/write_currently_defined_profiles").execute(*args, **kwargs)
        def read_case_data(self, *args, **kwargs):
            """
            Reads a case and a data file.
            """
            return PyMenu(self.service, "/file/read_case_data").execute(*args, **kwargs)
        def write_merge_profiles(self, *args, **kwargs):
            """
            Writes a .csv file with the selected surfaces consolidated into one set of data points.
            """
            return PyMenu(self.service, "/file/write_merge_profiles").execute(*args, **kwargs)
        def read_surface_clusters(self, *args, **kwargs):
            """
            Reads surface clusters from a file.
            """
            return PyMenu(self.service, "/file/read_surface_clusters").execute(*args, **kwargs)
        def close_without_save(self, *args, **kwargs):
            """
            Exits ANSYS Fluent without saving data in Workbench. This command is only available when running ANSYS Fluent in Workbench.
            """
            return PyMenu(self.service, "/file/close_without_save").execute(*args, **kwargs)
        def reload_setup(self, *args, **kwargs):
            """
            Discards any changes in the current ANSYS Fluent in Workbench session and removes any corresponding data from the Solution cell. This command is only available when running ANSYS Fluent in Workbench.
            """
            return PyMenu(self.service, "/file/reload_setup").execute(*args, **kwargs)
        def read_case_settings(self, *args, **kwargs):
            """
            Read a case file while skipping mesh elements.
            """
            return PyMenu(self.service, "/file/read_case_settings").execute(*args, **kwargs)
        def stop_transcript(self, *args, **kwargs):
            """
            Stop recording input and output and close the transcript file.
            """
            return PyMenu(self.service, "/file/stop_transcript").execute(*args, **kwargs)
        def write_cleanup_script(self, *args, **kwargs):
            """
            Writes the cleanup-script-file for ANSYS Fluent.
            """
            return PyMenu(self.service, "/file/write_cleanup_script").execute(*args, **kwargs)
        def replace_mesh(self, *args, **kwargs):
            """
            Replaces the mesh with a new one while preserving settings.
            """
            return PyMenu(self.service, "/file/replace_mesh").execute(*args, **kwargs)
        def write_injections(self, *args, **kwargs):
            """
            Writes out selected DPM injections to a file.
            """
            return PyMenu(self.service, "/file/write_injections").execute(*args, **kwargs)
        def async_optimize(self, *args, **kwargs):
            """
            Chooses whether to optimize file I/O using scratch disks and asynchronous operations.
            """
            return PyMenu(self.service, "/file/async_optimize").execute(*args, **kwargs)
        def read_field_functions(self, *args, **kwargs):
            """
            Reads custom field function definitions from a file.
            """
            return PyMenu(self.service, "/file/read_field_functions").execute(*args, **kwargs)
        def export_to_cfd_post(self, *args, **kwargs):
            """
            Exports data files that are compatible with CFD-Post and EnSight (that is, .cdat and .cst files) and opens CFD-Post, if desired.
            """
            return PyMenu(self.service, "/file/export_to_cfd_post").execute(*args, **kwargs)
        def write_macros(self, *args, **kwargs):
            """
            Writes the currently defined macros to a file.
            """
            return PyMenu(self.service, "/file/write_macros").execute(*args, **kwargs)
        def stop_macro(self, *args, **kwargs):
            """
            Stops recording input to a macro.
            """
            return PyMenu(self.service, "/file/stop_macro").execute(*args, **kwargs)
        def set_batch_options(self, *args, **kwargs):
            """
            Sets the batch options.
            """
            return PyMenu(self.service, "/file/set_batch_options").execute(*args, **kwargs)
        def write_pdf(self, *args, **kwargs):
            """
            Writes a pdf file.
            """
            return PyMenu(self.service, "/file/write_pdf").execute(*args, **kwargs)
        def load_act_tool(self, *args, **kwargs):
            """
            Load ACT Start Page.
            """
            return PyMenu(self.service, "/file/load_act_tool").execute(*args, **kwargs)
        def read_transient_table(self, *args, **kwargs):
            """
            Reads table of transient boundary profile data.
            """
            return PyMenu(self.service, "/file/read_transient_table").execute(*args, **kwargs)
        def cff_files(self, *args, **kwargs):
            """
            Indicate whether to write ANSYS common fluids format (CFF) files or legacy case and data files.
            """
            return PyMenu(self.service, "/file/cff_files").execute(*args, **kwargs)
        def show_configuration(self, *args, **kwargs):
            """
            Display current release and version information.
            """
            return PyMenu(self.service, "/file/show_configuration").execute(*args, **kwargs)
        def write_profile(self, *args, **kwargs):
            """
            Writes surface data as a boundary profile file.
            """
            return PyMenu(self.service, "/file/write_profile").execute(*args, **kwargs)
        def write_case_data(self, *args, **kwargs):
            """
            Writes a case and a data file.
            """
            return PyMenu(self.service, "/file/write_case_data").execute(*args, **kwargs)
        def set_err_on_inval_cmd(self, *args, **kwargs):
            """
            Set whether to abort journal replay on invalid command.
            """
            return PyMenu(self.service, "/file/set_err_on_inval_cmd").execute(*args, **kwargs)
        def start_transcript(self, *args, **kwargs):
            """
            Start recording input and output in a file.
            """
            return PyMenu(self.service, "/file/start_transcript").execute(*args, **kwargs)
        def write_flamelet(self, *args, **kwargs):
            """
            Writes a flamelet file.
            """
            return PyMenu(self.service, "/file/write_flamelet").execute(*args, **kwargs)
        def binary_legacy_files(self, *args, **kwargs):
            """
            Indicate whether to write binary or text format case and data files.
            """
            return PyMenu(self.service, "/file/binary_legacy_files").execute(*args, **kwargs)
        def write_data(self, *args, **kwargs):
            """
            Writes a data file.
            """
            return PyMenu(self.service, "/file/write_data").execute(*args, **kwargs)
        def read_viewfactors(self, *args, **kwargs):
            """
            Reads view factors from a file.
            """
            return PyMenu(self.service, "/file/read_viewfactors").execute(*args, **kwargs)
        def read_rays(self, *args, **kwargs):
            """
            Reads a ray file.
            """
            return PyMenu(self.service, "/file/read_rays").execute(*args, **kwargs)
        def read_pdf(self, *args, **kwargs):
            """
            Reads a PDF file.
            """
            return PyMenu(self.service, "/file/read_pdf").execute(*args, **kwargs)
        def define_macro(self, *args, **kwargs):
            """
            Saves input to a named macro.
            """
            return PyMenu(self.service, "/file/define_macro").execute(*args, **kwargs)
        def read_injections(self, *args, **kwargs):
            """
            Reads all DPM injections from a file.
            """
            return PyMenu(self.service, "/file/read_injections").execute(*args, **kwargs)
        def write_isat_table(self, *args, **kwargs):
            """
            Writes ISAT Table.
            """
            return PyMenu(self.service, "/file/write_isat_table").execute(*args, **kwargs)
        def set_idle_timeout(self, *args, **kwargs):
            """
            Set the idle timeout.
            """
            return PyMenu(self.service, "/file/set_idle_timeout").execute(*args, **kwargs)
        def write_settings(self, *args, **kwargs):
            """
            Writes out current boundary conditions in use.
            """
            return PyMenu(self.service, "/file/write_settings").execute(*args, **kwargs)

        class parametric_project(TUIMenu):
            """
            Enter to open, save, archive parametric project.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def save(self, *args, **kwargs):
                """
                Save Project.
                """
                return PyMenu(self.service, "/file/parametric_project/save").execute(*args, **kwargs)
            def save_as(self, *args, **kwargs):
                """
                Save As Project.
                """
                return PyMenu(self.service, "/file/parametric_project/save_as").execute(*args, **kwargs)
            def archive(self, *args, **kwargs):
                """
                Archive Project.
                """
                return PyMenu(self.service, "/file/parametric_project/archive").execute(*args, **kwargs)
            def save_a_copy(self, *args, **kwargs):
                """
                Save a Copy.
                """
                return PyMenu(self.service, "/file/parametric_project/save_a_copy").execute(*args, **kwargs)
            def open(self, *args, **kwargs):
                """
                Open project.
                """
                return PyMenu(self.service, "/file/parametric_project/open").execute(*args, **kwargs)

        class interpolate(TUIMenu):
            """
            Interpolates data to/from another grid.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def zone_selection(self, *args, **kwargs):
                """
                Defines a list of cell zone IDs. If specified, interpolation data will be read/written for these cell zones only.
                """
                return PyMenu(self.service, "/file/interpolate/zone_selection").execute(*args, **kwargs)
            def read_data(self, *args, **kwargs):
                """
                Reads and interpolates data.
                """
                return PyMenu(self.service, "/file/interpolate/read_data").execute(*args, **kwargs)
            def write_data(self, *args, **kwargs):
                """
                Writes data for interpolation.
                """
                return PyMenu(self.service, "/file/interpolate/write_data").execute(*args, **kwargs)

        class transient_export(TUIMenu):
            """
            Enter the export menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.settings = self.__class__.settings(path + ["settings"], service)
                super().__init__(path, service)
            def ensight_dvs_surfaces(self, *args, **kwargs):
                """
                Write post-processing data(geometry, velocity and scalars) for surfaces using EnSight Dynamic Visualization Store Interface.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_dvs_surfaces").execute(*args, **kwargs)
            def ascii(self, *args, **kwargs):
                """
                Writes an ASCII file.
                """
                return PyMenu(self.service, "/file/transient_export/ascii").execute(*args, **kwargs)
            def fieldview_xdb(self, *args, **kwargs):
                """
                Write a FieldView XDB format file.
                """
                return PyMenu(self.service, "/file/transient_export/fieldview_xdb").execute(*args, **kwargs)
            def ensight_gold_from_existing_files(self, *args, **kwargs):
                """
                Writes EnSight Gold files using ANSYS Fluent case files.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_gold_from_existing_files").execute(*args, **kwargs)
            def fieldview_unstruct_surfaces(self, *args, **kwargs):
                """
                Writes FIELDVIEW unstructured combined file for surfaces.
                """
                return PyMenu(self.service, "/file/transient_export/fieldview_unstruct_surfaces").execute(*args, **kwargs)
            def ensight_gold_transient(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_gold_transient").execute(*args, **kwargs)
            def ensight_gold_parallel_surfaces(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files for surfaces in a parallel format suitable for ANSYS Ensight Enterprise.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_gold_parallel_surfaces").execute(*args, **kwargs)
            def taitherm(self, *args, **kwargs):
                """
                Writes a TAITherm file.
                """
                return PyMenu(self.service, "/file/transient_export/taitherm").execute(*args, **kwargs)
            def common_fluids_format_post(self, *args, **kwargs):
                """
                Write an CFF Post-Only file.
                """
                return PyMenu(self.service, "/file/transient_export/common_fluids_format_post").execute(*args, **kwargs)
            def cgns(self, *args, **kwargs):
                """
                Writes a CGNS file.
                """
                return PyMenu(self.service, "/file/transient_export/cgns").execute(*args, **kwargs)
            def fieldview_unstruct_data(self, *args, **kwargs):
                """
                Writes a FIELDVIEW unstructured results only file.
                """
                return PyMenu(self.service, "/file/transient_export/fieldview_unstruct_data").execute(*args, **kwargs)
            def dx(self, *args, **kwargs):
                """
                Writes an IBM Data Explorer format file.
                """
                return PyMenu(self.service, "/file/transient_export/dx").execute(*args, **kwargs)
            def ensight_dvs_volume(self, *args, **kwargs):
                """
                Write post-processing data(geometry, velocity and scalars) for cell zones and boundaries attached to them using EnSight Dynamic Visualization Store Interface.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_dvs_volume").execute(*args, **kwargs)
            def cdat_for_cfd_post__and__ensight(self, *args, **kwargs):
                """
                Write a CDAT for CFD-Post & EnSight file.
                """
                return PyMenu(self.service, "/file/transient_export/cdat_for_cfd_post__and__ensight").execute(*args, **kwargs)
            def fieldview_unstruct_mesh(self, *args, **kwargs):
                """
                Writes a FIELDVIEW unstructured mesh only file.
                """
                return PyMenu(self.service, "/file/transient_export/fieldview_unstruct_mesh").execute(*args, **kwargs)
            def nastran(self, *args, **kwargs):
                """
                Writes a NASTRAN file.
                """
                return PyMenu(self.service, "/file/transient_export/nastran").execute(*args, **kwargs)
            def fieldview_unstruct(self, *args, **kwargs):
                """
                Writes a FIELDVIEW unstructured combined file.
                """
                return PyMenu(self.service, "/file/transient_export/fieldview_unstruct").execute(*args, **kwargs)
            def fast(self, *args, **kwargs):
                """
                Writes a FAST/Plot3D unstructured mesh velocity scalar file.
                """
                return PyMenu(self.service, "/file/transient_export/fast").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits transient exports.
                """
                return PyMenu(self.service, "/file/transient_export/edit").execute(*args, **kwargs)
            def tecplot(self, *args, **kwargs):
                """
                Write a Tecplot+3DV format file.
                """
                return PyMenu(self.service, "/file/transient_export/tecplot").execute(*args, **kwargs)
            def patran_neutral(self, *args, **kwargs):
                """
                Writes a PATRAN neutral file.
                """
                return PyMenu(self.service, "/file/transient_export/patran_neutral").execute(*args, **kwargs)
            def avs(self, *args, **kwargs):
                """
                Writes an AVS UCD file.
                """
                return PyMenu(self.service, "/file/transient_export/avs").execute(*args, **kwargs)
            def abaqus(self, *args, **kwargs):
                """
                Writes an ABAQUS file.
                """
                return PyMenu(self.service, "/file/transient_export/abaqus").execute(*args, **kwargs)
            def ideas(self, *args, **kwargs):
                """
                Writes an I-deas universal file.
                """
                return PyMenu(self.service, "/file/transient_export/ideas").execute(*args, **kwargs)
            def mechanical_apdl_input(self, *args, **kwargs):
                """
                Writes a Mechanical APDL input file.
                """
                return PyMenu(self.service, "/file/transient_export/mechanical_apdl_input").execute(*args, **kwargs)
            def ensight_gold_parallel_volume(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files for cell zones in a parallel format suitable for ANSYS Ensight Enterprise.
                """
                return PyMenu(self.service, "/file/transient_export/ensight_gold_parallel_volume").execute(*args, **kwargs)
            def fast_solution(self, *args, **kwargs):
                """
                Writes a FAST/Plot3D unstructured solution file.
                """
                return PyMenu(self.service, "/file/transient_export/fast_solution").execute(*args, **kwargs)
            def particle_history_data(self, *args, **kwargs):
                """
                Sets up an automatic particle-history data export.
                """
                return PyMenu(self.service, "/file/transient_export/particle_history_data").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes transient exports.
                """
                return PyMenu(self.service, "/file/transient_export/delete").execute(*args, **kwargs)

            class settings(TUIMenu):
                """
                Enters the automatic export settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def cfd_post_compatible(self, *args, **kwargs):
                    """
                    Specifies when case files are written with the .cdat and .cst files exported for Ansys CFD-Post. Note that this setting is ignored if the Write Case File Every Time option is enabled in the Automatic Export dialog box, which is always the case starting in Release 2021 R1.
                    """
                    return PyMenu(self.service, "/file/transient_export/settings/cfd_post_compatible").execute(*args, **kwargs)

        class export(TUIMenu):
            """
            Enter the export menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.settings = self.__class__.settings(path + ["settings"], service)
                super().__init__(path, service)
            def ensight_gold_parallel_volume(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files for cell zones in a parallel format suitable for ANSYS Ensight Enterprise.
                """
                return PyMenu(self.service, "/file/export/ensight_gold_parallel_volume").execute(*args, **kwargs)
            def fieldview_data(self, *args, **kwargs):
                """
                Writes FIELDVIEW case and data files.
                """
                return PyMenu(self.service, "/file/export/fieldview_data").execute(*args, **kwargs)
            def ensight_dvs_surfaces(self, *args, **kwargs):
                """
                Write post-processing data(geometry, velocity and scalars) for surfaces using EnSight Dynamic Visualization Store Interface.
                """
                return PyMenu(self.service, "/file/export/ensight_dvs_surfaces").execute(*args, **kwargs)
            def ensight_gold_parallel_surfaces(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files for surfaces in a parallel format suitable for ANSYS Ensight Enterprise.
                """
                return PyMenu(self.service, "/file/export/ensight_gold_parallel_surfaces").execute(*args, **kwargs)
            def patran_neutral(self, *args, **kwargs):
                """
                Writes a PATRAN neutral file.
                """
                return PyMenu(self.service, "/file/export/patran_neutral").execute(*args, **kwargs)
            def ensight_gold(self, *args, **kwargs):
                """
                Writes EnSight Gold geometry, velocity, and scalar files.
                """
                return PyMenu(self.service, "/file/export/ensight_gold").execute(*args, **kwargs)
            def ascii(self, *args, **kwargs):
                """
                Writes an ASCII file.
                """
                return PyMenu(self.service, "/file/export/ascii").execute(*args, **kwargs)
            def fieldview(self, *args, **kwargs):
                """
                Writes FIELDVIEW case and data files.
                """
                return PyMenu(self.service, "/file/export/fieldview").execute(*args, **kwargs)
            def gambit(self, *args, **kwargs):
                """
                Writes GAMBIT neutral file.
                """
                return PyMenu(self.service, "/file/export/gambit").execute(*args, **kwargs)
            def cdat_for_cfd_post__and__ensight(self, *args, **kwargs):
                """
                Write a CDAT for CFD-Post & EnSight file.
                """
                return PyMenu(self.service, "/file/export/cdat_for_cfd_post__and__ensight").execute(*args, **kwargs)
            def custom_heat_flux(self, *args, **kwargs):
                """
                Writes a generic file for heat transfer.
                """
                return PyMenu(self.service, "/file/export/custom_heat_flux").execute(*args, **kwargs)
            def fast_scalar(self, *args, **kwargs):
                """
                Writes FAST/Plot3D unstructured scalar function file.
                """
                return PyMenu(self.service, "/file/export/fast_scalar").execute(*args, **kwargs)
            def icemcfd_for_icepak(self, *args, **kwargs):
                """
                Writes a binary ICEM CFD domain file.
                """
                return PyMenu(self.service, "/file/export/icemcfd_for_icepak").execute(*args, **kwargs)
            def fieldview_unstruct_surfaces(self, *args, **kwargs):
                """
                Writes FIELDVIEW unstructured file for surfaces. You are prompted to select either [1], [2] or [3] to write either mesh-only, results-only, or combined for surfaces (respectively).
                """
                return PyMenu(self.service, "/file/export/fieldview_unstruct_surfaces").execute(*args, **kwargs)
            def abaqus(self, *args, **kwargs):
                """
                Writes an ABAQUS file.
                """
                return PyMenu(self.service, "/file/export/abaqus").execute(*args, **kwargs)
            def mechanical_apdl(self, *args, **kwargs):
                """
                Write an Mechanical APDL file.
                """
                return PyMenu(self.service, "/file/export/mechanical_apdl").execute(*args, **kwargs)
            def taitherm(self, *args, **kwargs):
                """
                Exports TAITherm file.
                """
                return PyMenu(self.service, "/file/export/taitherm").execute(*args, **kwargs)
            def common_fluids_format_post(self, *args, **kwargs):
                """
                Writes common fluids format files (.cas.post and .dat.post) for mesh and data, respectively. These files are saved in the hierarchical data format.
                """
                return PyMenu(self.service, "/file/export/common_fluids_format_post").execute(*args, **kwargs)
            def fast_velocity(self, *args, **kwargs):
                """
                Writes FAST/Plot3D unstructured vector function file.
                """
                return PyMenu(self.service, "/file/export/fast_velocity").execute(*args, **kwargs)
            def avs(self, *args, **kwargs):
                """
                Writes an AVS UCD file.
                """
                return PyMenu(self.service, "/file/export/avs").execute(*args, **kwargs)
            def fieldview_unstruct_mesh(self, *args, **kwargs):
                """
                Writes FIELDVIEW unstructured mesh-only file.
                """
                return PyMenu(self.service, "/file/export/fieldview_unstruct_mesh").execute(*args, **kwargs)
            def fieldview_unstruct_data(self, *args, **kwargs):
                """
                Writes FIELDVIEW unstructured results-only file.
                """
                return PyMenu(self.service, "/file/export/fieldview_unstruct_data").execute(*args, **kwargs)
            def fieldview_xdb(self, *args, **kwargs):
                """
                Write a FieldView XDB format file.
                """
                return PyMenu(self.service, "/file/export/fieldview_xdb").execute(*args, **kwargs)
            def ensight_dvs_volume(self, *args, **kwargs):
                """
                Write post-processing data(geometry, velocity and scalars) for cell zones and boundaries attached to them using EnSight Dynamic Visualization Store Interface.
                """
                return PyMenu(self.service, "/file/export/ensight_dvs_volume").execute(*args, **kwargs)
            def ensight(self, *args, **kwargs):
                """
                Writes EnSight geometry, velocity, and scalar files.
                """
                return PyMenu(self.service, "/file/export/ensight").execute(*args, **kwargs)
            def fast_mesh(self, *args, **kwargs):
                """
                Writes FAST/Plot3D unstructured mesh file.
                """
                return PyMenu(self.service, "/file/export/fast_mesh").execute(*args, **kwargs)
            def mechanical_apdl_input(self, *args, **kwargs):
                """
                Writes a Mechanical APDL Input file.
                """
                return PyMenu(self.service, "/file/export/mechanical_apdl_input").execute(*args, **kwargs)
            def tecplot(self, *args, **kwargs):
                """
                Writes a Tecplot+3DV format file.
                """
                return PyMenu(self.service, "/file/export/tecplot").execute(*args, **kwargs)
            def fast_solution(self, *args, **kwargs):
                """
                Writes FAST/Plot3D unstructured solution file.
                """
                return PyMenu(self.service, "/file/export/fast_solution").execute(*args, **kwargs)
            def patran_nodal(self, *args, **kwargs):
                """
                Writes a PATRAN nodal results file.
                """
                return PyMenu(self.service, "/file/export/patran_nodal").execute(*args, **kwargs)
            def nastran(self, *args, **kwargs):
                """
                Write a NASTRAN file.
                """
                return PyMenu(self.service, "/file/export/nastran").execute(*args, **kwargs)
            def particle_history_data(self, *args, **kwargs):
                """
                Exports particle-history data.
                """
                return PyMenu(self.service, "/file/export/particle_history_data").execute(*args, **kwargs)
            def system_coupling_definition_file_settings(self, *args, **kwargs):
                """
                Enters the system coupling file (.scp) menu.
                """
                return PyMenu(self.service, "/file/export/system_coupling_definition_file_settings").execute(*args, **kwargs)
            def fieldview_unstruct(self, *args, **kwargs):
                """
                Writes FIELDVIEW unstructured combined file.
                """
                return PyMenu(self.service, "/file/export/fieldview_unstruct").execute(*args, **kwargs)
            def ideas(self, *args, **kwargs):
                """
                Writes an I-deas universal file.
                """
                return PyMenu(self.service, "/file/export/ideas").execute(*args, **kwargs)
            def dx(self, *args, **kwargs):
                """
                Writes an IBM Data Explorer format file.
                """
                return PyMenu(self.service, "/file/export/dx").execute(*args, **kwargs)
            def cgns(self, *args, **kwargs):
                """
                Write a CGNS file.
                """
                return PyMenu(self.service, "/file/export/cgns").execute(*args, **kwargs)

            class settings(TUIMenu):
                """
                Enter the export settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_cgns_export_filetype(self, *args, **kwargs):
                    """
                    Select HDF5 or ADF as file format for CGNS.
                    """
                    return PyMenu(self.service, "/file/export/settings/set_cgns_export_filetype").execute(*args, **kwargs)

        class em_mapping(TUIMenu):
            """
            Enters the electromagnetic loss mapping menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def maintain_loss_on_initialization(self, *args, **kwargs):
                """
                Maintains the loss data provided by Maxwell even if solution is initialized.
                """
                return PyMenu(self.service, "/file/em_mapping/maintain_loss_on_initialization").execute(*args, **kwargs)
            def volumetric_energy_source(self, *args, **kwargs):
                """
                Loss data provided by Ansoft will be assigned to Fluent for selected cell zones.
                """
                return PyMenu(self.service, "/file/em_mapping/volumetric_energy_source").execute(*args, **kwargs)
            def remove_loss_only(self, *args, **kwargs):
                """
                Removes the loss data provided by Maxwell and keeps all other solution data.
                """
                return PyMenu(self.service, "/file/em_mapping/remove_loss_only").execute(*args, **kwargs)
            def surface_energy_source(self, *args, **kwargs):
                """
                Loss data provided by Ansoft will be assigned to Fluent for selected wall zones.
                """
                return PyMenu(self.service, "/file/em_mapping/surface_energy_source").execute(*args, **kwargs)

        class auto_save(TUIMenu):
            """
            Enters the auto save menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def max_files(self, *args, **kwargs):
                """
                Sets the maximum number of files. Once the maximum is reached, files will be erased as new files are written.
                """
                return PyMenu(self.service, "/file/auto_save/max_files").execute(*args, **kwargs)
            def append_file_name_with(self, *args, **kwargs):
                """
                Sets the suffix for auto-saved files. The file name can be appended by flow-time, time-step value, or by user-specified flags in file name.
                """
                return PyMenu(self.service, "/file/auto_save/append_file_name_with").execute(*args, **kwargs)
            def save_data_file_every(self, *args, **kwargs):
                """
                Specifies the type and frequency of the data file to be saved.
                """
                return PyMenu(self.service, "/file/auto_save/save_data_file_every").execute(*args, **kwargs)
            def case_frequency(self, *args, **kwargs):
                """
                Specifies the frequency (in iterations, time steps, or flow time) with which case files are saved.
                """
                return PyMenu(self.service, "/file/auto_save/case_frequency").execute(*args, **kwargs)
            def retain_most_recent_files(self, *args, **kwargs):
                """
                Sets autosave to retain the 5 most recent files.
                """
                return PyMenu(self.service, "/file/auto_save/retain_most_recent_files").execute(*args, **kwargs)
            def data_frequency(self, *args, **kwargs):
                """
                Specifies the frequency (in iterations, time steps, or flow time) with which data files are saved.
                """
                return PyMenu(self.service, "/file/auto_save/data_frequency").execute(*args, **kwargs)
            def root_name(self, *args, **kwargs):
                """
                Specifies the root name for the files that are saved.
                """
                return PyMenu(self.service, "/file/auto_save/root_name").execute(*args, **kwargs)

        class cffio_options(TUIMenu):
            """
            Enters the cffio options menu, which provides options for the I/O of case and data files in the Common Fluids Format (CFF).
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def io_mode(self, *args, **kwargs):
                """
                Sets the I/O mode for writing CFF files.
                1. HOST: I/O is done serially by the host process.
                2. NODE0: I/O is done serially by the node 0 process.
                3. PARALLEL INDEPENDENT: I/O is done in parallel using the independent mode of MPI I/O.
                4. PARALLEL COLLECTIVE: I/O is done in parallel using the collective mode of MPI I/O.
                """
                return PyMenu(self.service, "/file/cffio_options/io_mode").execute(*args, **kwargs)
            def single_precision_data(self, *args, **kwargs):
                """
                Specifies whether the double-precision solver saves single-precision data when writing CFF data files, in order to reduce the size of the files.
                """
                return PyMenu(self.service, "/file/cffio_options/single_precision_data").execute(*args, **kwargs)
            def compression_level(self, *args, **kwargs):
                """
                Sets the compression level for CFF files. The compression level can be set between 0 and 9 with 0 being least compression (fastest) and 9 being highest compression (slowest).
                """
                return PyMenu(self.service, "/file/cffio_options/compression_level").execute(*args, **kwargs)

        class import_(TUIMenu):
            """
            Enter the import menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.tecplot = self.__class__.tecplot(path + ["tecplot"], service)
                self.cgns = self.__class__.cgns(path + ["cgns"], service)
                self.mechanical_apdl = self.__class__.mechanical_apdl(path + ["mechanical_apdl"], service)
                self.cfx = self.__class__.cfx(path + ["cfx"], service)
                self.patran = self.__class__.patran(path + ["patran"], service)
                self.plot3d = self.__class__.plot3d(path + ["plot3d"], service)
                self.partition = self.__class__.partition(path + ["partition"], service)
                self.nastran = self.__class__.nastran(path + ["nastran"], service)
                self.lstc = self.__class__.lstc(path + ["lstc"], service)
                self.abaqus = self.__class__.abaqus(path + ["abaqus"], service)
                super().__init__(path, service)
            def fluent4_case(self, *args, **kwargs):
                """
                Imports a formatted ANSYS Fluent 4 case file.
                """
                return PyMenu(self.service, "/file/import/fluent4_case").execute(*args, **kwargs)
            def marc_post(self, *args, **kwargs):
                """
                Reads a MARC POST file as a case file.
                """
                return PyMenu(self.service, "/file/import/marc_post").execute(*args, **kwargs)
            def fmu_file(self, *args, **kwargs):
                """
                Enters the import FMU file menu.
                """
                return PyMenu(self.service, "/file/import/fmu_file").execute(*args, **kwargs)
            def ensight(self, *args, **kwargs):
                """
                Reads an EnSight file as a case file.
                """
                return PyMenu(self.service, "/file/import/ensight").execute(*args, **kwargs)
            def chemkin_mechanism(self, *args, **kwargs):
                """
                Reads a CHEMKIN mechanism file.
                """
                return PyMenu(self.service, "/file/import/chemkin_mechanism").execute(*args, **kwargs)
            def gambit(self, *args, **kwargs):
                """
                Imports a GAMBIT neutral file.
                """
                return PyMenu(self.service, "/file/import/gambit").execute(*args, **kwargs)
            def chemkin_report_each_line(self, *args, **kwargs):
                """
                Enables/disables reporting after reading each line.
                """
                return PyMenu(self.service, "/file/import/chemkin_report_each_line").execute(*args, **kwargs)
            def ptc_mechanica(self, *args, **kwargs):
                """
                Reads a PTC Mechanica Design file as a case file.
                """
                return PyMenu(self.service, "/file/import/ptc_mechanica").execute(*args, **kwargs)
            def ideas_universal(self, *args, **kwargs):
                """
                Imports an I-deas Universal file.
                """
                return PyMenu(self.service, "/file/import/ideas_universal").execute(*args, **kwargs)
            def flamelet(self, *args, **kwargs):
                """
                Imports a flamelet file.
                """
                return PyMenu(self.service, "/file/import/flamelet").execute(*args, **kwargs)
            def fidap(self, *args, **kwargs):
                """
                Imports a FIDAP neutral file.
                """
                return PyMenu(self.service, "/file/import/fidap").execute(*args, **kwargs)
            def prebfc_structured(self, *args, **kwargs):
                """
                Imports a formatted PreBFC structured mesh file.
                """
                return PyMenu(self.service, "/file/import/prebfc_structured").execute(*args, **kwargs)
            def hypermesh(self, *args, **kwargs):
                """
                Reads a HYPERMESH file as a case file.
                """
                return PyMenu(self.service, "/file/import/hypermesh").execute(*args, **kwargs)

            class tecplot(TUIMenu):
                """
                Enters the Tecplot menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mesh(self, *args, **kwargs):
                    """
                    Reads a Tecplot binary file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/tecplot/mesh").execute(*args, **kwargs)

            class cgns(TUIMenu):
                """
                Imports a CGNS file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mesh_data(self, *args, **kwargs):
                    """
                    Imports a CGNS mesh file and data file.
                    """
                    return PyMenu(self.service, "/file/import/cgns/mesh_data").execute(*args, **kwargs)
                def data(self, *args, **kwargs):
                    """
                    Reads data from CGNS file.
                    """
                    return PyMenu(self.service, "/file/import/cgns/data").execute(*args, **kwargs)
                def mesh(self, *args, **kwargs):
                    """
                    Imports a CGNS mesh file.
                    """
                    return PyMenu(self.service, "/file/import/cgns/mesh").execute(*args, **kwargs)

            class mechanical_apdl(TUIMenu):
                """
                Imports a Mechanical APDL file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def result(self, *args, **kwargs):
                    """
                    Reads a Mechanical APDL result file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/mechanical_apdl/result").execute(*args, **kwargs)
                def input(self, *args, **kwargs):
                    """
                    Reads a Mechanical APDL file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/mechanical_apdl/input").execute(*args, **kwargs)

            class cfx(TUIMenu):
                """
                Imports a CFX file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def result(self, *args, **kwargs):
                    """
                    Reads a CFX definition file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/cfx/result").execute(*args, **kwargs)
                def definition(self, *args, **kwargs):
                    """
                    Reads a CFX definition file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/cfx/definition").execute(*args, **kwargs)

            class patran(TUIMenu):
                """
                Imports a PATRAN neutral file (zones defined by named components).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def neutral(self, *args, **kwargs):
                    """
                    Reads a PATRAN Neutral file (zones defined by named components) as a case file.
                    """
                    return PyMenu(self.service, "/file/import/patran/neutral").execute(*args, **kwargs)

            class plot3d(TUIMenu):
                """
                Imports a PLOT3D file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mesh(self, *args, **kwargs):
                    """
                    Reads a PLOT3D file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/plot3d/mesh").execute(*args, **kwargs)

            class partition(TUIMenu):
                """
                Enters the partition menu to set conditions for partitioning an ANSYS Fluent case file during read.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def metis(self, *args, **kwargs):
                    """
                    Reads and partitions an ANSYS Fluent case file.
                    """
                    return PyMenu(self.service, "/file/import/partition/metis").execute(*args, **kwargs)
                def metis_zone(self, *args, **kwargs):
                    """
                    Reads and partitions an ANSYS Fluent case file.
                    """
                    return PyMenu(self.service, "/file/import/partition/metis_zone").execute(*args, **kwargs)

            class nastran(TUIMenu):
                """
                Imports a NASTRAN file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def bulkdata(self, *args, **kwargs):
                    """
                    Reads a NASTRAN file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/nastran/bulkdata").execute(*args, **kwargs)
                def output2(self, *args, **kwargs):
                    """
                    Reads a NASTRAN op2 file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/nastran/output2").execute(*args, **kwargs)

            class lstc(TUIMenu):
                """
                Imports an LSTC file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def state(self, *args, **kwargs):
                    """
                    Reads an LSTC result file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/lstc/state").execute(*args, **kwargs)
                def input(self, *args, **kwargs):
                    """
                    Reads an LSTC input file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/lstc/input").execute(*args, **kwargs)

            class abaqus(TUIMenu):
                """
                Imports an ABAQUS file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def odb(self, *args, **kwargs):
                    """
                    Reads an ABAQUS odb file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/abaqus/odb").execute(*args, **kwargs)
                def fil(self, *args, **kwargs):
                    """
                    Reads an ABAQUS .fil result file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/abaqus/fil").execute(*args, **kwargs)
                def input(self, *args, **kwargs):
                    """
                    Reads an ABAQUS input file as a case file.
                    """
                    return PyMenu(self.service, "/file/import/abaqus/input").execute(*args, **kwargs)

        class solution_files(TUIMenu):
            """
            Enters the solution files menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def print_solution_files(self, *args, **kwargs):
                """
                Prints a list of available solution files.
                """
                return PyMenu(self.service, "/file/solution_files/print_solution_files").execute(*args, **kwargs)
            def delete_solution(self, *args, **kwargs):
                """
                Deletes solution files.
                """
                return PyMenu(self.service, "/file/solution_files/delete_solution").execute(*args, **kwargs)
            def load_solution(self, *args, **kwargs):
                """
                Loads a solution file.
                """
                return PyMenu(self.service, "/file/solution_files/load_solution").execute(*args, **kwargs)

        class table_manager(TUIMenu):
            """
            Enters the table file manager menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def read_matrix_data_file(self, *args, **kwargs):
                """
                Imports a “matrix” type table from a file into local storage.
                """
                return PyMenu(self.service, "/file/table_manager/read_matrix_data_file").execute(*args, **kwargs)
            def read_rgp_file(self, *args, **kwargs):
                """
                Imports a set of Real Gas Property (RGP) tables from a file into local storage.
                """
                return PyMenu(self.service, "/file/table_manager/read_rgp_file").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Renames a locally-stored table.
                """
                return PyMenu(self.service, "/file/table_manager/rename").execute(*args, **kwargs)
            def list_matrix_data(self, *args, **kwargs):
                """
                Lists the data of a “matrix” type locally-stored table.
                """
                return PyMenu(self.service, "/file/table_manager/list_matrix_data").execute(*args, **kwargs)
            def store_in_case_file(self, *args, **kwargs):
                """
                Sets the persistence mode for RGP tables (embedded in case file or rely on external file).
                """
                return PyMenu(self.service, "/file/table_manager/store_in_case_file").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a locally-stored table.
                """
                return PyMenu(self.service, "/file/table_manager/list_properties").execute(*args, **kwargs)
            def list_tables(self, *args, **kwargs):
                """
                Lists all locally-stored tables.
                """
                return PyMenu(self.service, "/file/table_manager/list_tables").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a table from local storage.
                """
                return PyMenu(self.service, "/file/table_manager/delete").execute(*args, **kwargs)

        class fsi(TUIMenu):
            """
            Enters the fluid-structure interaction menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def display_fsi_mesh(self, *args, **kwargs):
                """
                Displays the mesh for a fluid-structure interaction.
                """
                return PyMenu(self.service, "/file/fsi/display_fsi_mesh").execute(*args, **kwargs)
            def write_fsi_mesh(self, *args, **kwargs):
                """
                Writes a fluid-structure interaction mesh file.
                """
                return PyMenu(self.service, "/file/fsi/write_fsi_mesh").execute(*args, **kwargs)
            def conserve_force(self, *args, **kwargs):
                """
                Conserve the forces for linear line, tri and tet elements.
                """
                return PyMenu(self.service, "/file/fsi/conserve_force").execute(*args, **kwargs)
            def read_fsi_mesh(self, *args, **kwargs):
                """
                Reads an FEM mesh for one-way data mapping from ANSYS Fluent.
                """
                return PyMenu(self.service, "/file/fsi/read_fsi_mesh").execute(*args, **kwargs)

        class project(TUIMenu):
            """
            Enter to create new project, open project, save and archive project.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def save_as_copy(self, *args, **kwargs):
                """
                Save As Copy.
                """
                return PyMenu(self.service, "/file/project[beta]/save_as_copy").execute(*args, **kwargs)
            def archive(self, *args, **kwargs):
                """
                Archive Project.
                """
                return PyMenu(self.service, "/file/project[beta]/archive").execute(*args, **kwargs)
            def save(self, *args, **kwargs):
                """
                Save Project.
                """
                return PyMenu(self.service, "/file/project[beta]/save").execute(*args, **kwargs)
            def save_as(self, *args, **kwargs):
                """
                Save As Project.
                """
                return PyMenu(self.service, "/file/project[beta]/save_as").execute(*args, **kwargs)
            def new(self, *args, **kwargs):
                """
                Create New Project.
                """
                return PyMenu(self.service, "/file/project[beta]/new").execute(*args, **kwargs)
            def open(self, *args, **kwargs):
                """
                Open project.
                """
                return PyMenu(self.service, "/file/project[beta]/open").execute(*args, **kwargs)

    class solution(TUIMenu):
        """
        Enter solution menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            self.expert = self.__class__.expert(path + ["expert"], service)
            self.calculation_activities = self.__class__.calculation_activities(path + ["calculation_activities"], service)
            self.controls = self.__class__.controls(path + ["controls"], service)
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.run_calculation = self.__class__.run_calculation(path + ["run_calculation"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            self.methods = self.__class__.methods(path + ["methods"], service)
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            super().__init__(path, service)

        class report_definitions(TUIMenu):
            """
            Manage report definitions.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def rename(self, *args, **kwargs):
                """
                Rename selected report definition with new name.
                """
                return PyMenu(self.service, "/solution/report_definitions/rename").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all report definition objects.
                """
                return PyMenu(self.service, "/solution/report_definitions/delete_all").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes selected report definition.
                """
                return PyMenu(self.service, "/solution/report_definitions/compute").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solution/report_definitions/add").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/solution/report_definitions/list").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/edit").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/delete").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/solution/report_definitions/list_properties").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Makes a copy of selected report definition with new name.
                """
                return PyMenu(self.service, "/solution/report_definitions/copy").execute(*args, **kwargs)

        class expert(TUIMenu):
            """
            Enter expert options for solution.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                super().__init__(path, service)
            def open_channel_controls(self, *args, **kwargs):
                """
                Set additional open channel controls.
                """
                return PyMenu(self.service, "/solution/expert/open_channel_controls").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Set damping function in flow direction.
                """
                return PyMenu(self.service, "/solution/expert/numerical_beach_controls").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Setting pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solution/expert/bc_pressure_extrapolations").execute(*args, **kwargs)
            def show_all_discretization_schemes(self, *args, **kwargs):
                """
                Allow selection of all applicable discretization schemes?.
                """
                return PyMenu(self.service, "/solution/expert/show_all_discretization_schemes").execute(*args, **kwargs)
            def equation_ordering(self, *args, **kwargs):
                """
                Set the equation order.
                """
                return PyMenu(self.service, "/solution/expert/equation_ordering").execute(*args, **kwargs)
            def retain_cell_residuals(self, *args, **kwargs):
                """
                Retain cell residuals for postprocessing?.
                """
                return PyMenu(self.service, "/solution/expert/retain_cell_residuals").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solution/expert/surface_tension_expert").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Control the display of limiter warning diagnostics.
                """
                return PyMenu(self.service, "/solution/expert/limiter_warnings").execute(*args, **kwargs)
            def linearized_mass_transfer_udf(self, *args, **kwargs):
                """
                Use linearized mass transfer UDFs?.
                """
                return PyMenu(self.service, "/solution/expert/linearized_mass_transfer_udf").execute(*args, **kwargs)
            def alternate_wall_temp_formulation(self, *args, **kwargs):
                """
                Alternate formulation for wall temperatures?.
                """
                return PyMenu(self.service, "/solution/expert/alternate_wall_temp_formulation").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Set all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solution/expert/set_all_species_together").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Set anisotropic drag parameters for Eulerian multiphase.
                """
                return PyMenu(self.service, "/solution/expert/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def correction_form(self, *args, **kwargs):
                """
                Discretize momentum equations in correction form for the pressure-based solver.
                """
                return PyMenu(self.service, "/solution/expert/correction_form").execute(*args, **kwargs)
            def bcd_weights_freeze(self, *args, **kwargs):
                """
                At each timestep, freeze BCD scheme weights after specified iteration
                in order to improve timestep convergence.
                """
                return PyMenu(self.service, "/solution/expert/bcd_weights_freeze").execute(*args, **kwargs)
            def energy_numerical_noise_filter(self, *args, **kwargs):
                """
                The energy equation numerical noise filter can be enabled to eliminate non-physical numerical noise in the energy field.
                The numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present.
                Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive.
                """
                return PyMenu(self.service, "/solution/expert/energy_numerical_noise_filter").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Set reference density option for Eulerian multiphase.
                """
                return PyMenu(self.service, "/solution/expert/mp_reference_density").execute(*args, **kwargs)
            def explicit_under_relaxation_value(self, *args, **kwargs):
                """
                Explicit under-relaxation value.
                """
                return PyMenu(self.service, "/solution/expert/explicit_under_relaxation_value").execute(*args, **kwargs)
            def singhal_et_al_cavitation_model(self, *args, **kwargs):
                """
                Use Singhal-et-al cavitation model?.
                """
                return PyMenu(self.service, "/solution/expert/singhal_et_al_cavitation_model").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Set Explicit VOF controls.
                """
                return PyMenu(self.service, "/solution/expert/vof_explicit_controls").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Control the display of warning diagnostics for boundaries with reversed flow, etc.
                """
                return PyMenu(self.service, "/solution/expert/flow_warnings").execute(*args, **kwargs)
            def retain_temporary_solver_mem(self, *args, **kwargs):
                """
                Retain temporary solver memory?.
                """
                return PyMenu(self.service, "/solution/expert/retain_temporary_solver_mem").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solution/expert/material_property_warnings").execute(*args, **kwargs)
            def bcd_boundedness(self, *args, **kwargs):
                """
                BCD scheme boundedness strength, constant or expression (0 to 1).
                """
                return PyMenu(self.service, "/solution/expert/bcd_boundedness").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Set surface-tension calculation options.
                """
                return PyMenu(self.service, "/solution/expert/surface_tension").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Enable/Disable reconstruction. When disabled, accuracy will be first-order.
                """
                return PyMenu(self.service, "/solution/expert/disable_reconstruction").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Lock the temperature for all solid and shell cell zones in the domain.
                """
                return PyMenu(self.service, "/solution/expert/lock_solid_temperature").execute(*args, **kwargs)

            class non_reflecting_boundary_treatment(TUIMenu):
                """
                Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                    """
                    return PyMenu(self.service, "/solution/expert/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)

            class secondary_gradient_limiting(TUIMenu):
                """
                Enter the Secondary Gradient Limiting Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def mesh_quality_limits(self, *args, **kwargs):
                    """
                    Specify minimum and maximum mesh quality limits.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)
                def energy(self, *args, **kwargs):
                    """
                    Enable/disable secondary gradient limiting at coupled walls for energy equation.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/energy").execute(*args, **kwargs)
                def uds(self, *args, **kwargs):
                    """
                    Enable/disable secondary gradient limiting at coupled walls for user-defined scalars.
                    """
                    return PyMenu(self.service, "/solution/expert/secondary_gradient_limiting/uds").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enter the divergence prevention menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable divergence prevention.
                    """
                    return PyMenu(self.service, "/solution/expert/divergence_prevention/enable").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Enter the open-channel-wave-options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Set stokes wave theory variants.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Set bufer layer height between phases for segregated velocity inputs.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solution/expert/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enter Poor Mesh Numerics Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    super().__init__(path, service)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Reset marking of poor cell elements.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Solution correction on meshes of poor quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/enable").execute(*args, **kwargs)
                def user_defined_on_register_auto(self, *args, **kwargs):
                    """
                    Set up the application of poor mesh numerics to cells in a register during the calculation at a specified frequency.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register_auto").execute(*args, **kwargs)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Relocate select cell centroids, to improve orthogonality metrics and solution stability.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Set quality threshold.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics on cells with low quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics based on solution and cell quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Print poor cells count.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enable/disable poor mesh numerics based on cell gradient quality.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Include cells in register in poor mesh numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solution/expert/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Enable/disable pressure-discontinuity-sensor visualization.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Expert high-speed-numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/expert").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable/disable high-speed-numerics.
                    """
                    return PyMenu(self.service, "/solution/expert/high_speed_numerics/enable").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Enter previous defaults menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2019R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2022R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2021R2.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)
                def undo_2023r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2023R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2023r1_default_changes").execute(*args, **kwargs)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2021R1.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2019R3.
                    """
                    return PyMenu(self.service, "/solution/expert/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)

        class calculation_activities(TUIMenu):
            """
            Enter calculation activities menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.animate = self.__class__.animate(path + ["animate"], service)
                self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
                self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
                self.solution_strategy = self.__class__.solution_strategy(path + ["solution_strategy"], service)
                self.auto_save = self.__class__.auto_save(path + ["auto_save"], service)
                super().__init__(path, service)

            class animate(TUIMenu):
                """
                Enter the animation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.objects = self.__class__.objects(path + ["objects"], service)
                    self.define = self.__class__.define(path + ["define"], service)
                    super().__init__(path, service)

                class objects(TUIMenu):
                    """
                    Enter to define, edit, delete solution animation objects.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def edit(self, *args, **kwargs):
                        """
                        Edit graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/edit").execute(*args, **kwargs)
                    def clear_history(self, *args, **kwargs):
                        """
                        Clear object history.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/clear_history").execute(*args, **kwargs)
                    def copy(self, *args, **kwargs):
                        """
                        Copy graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/copy").execute(*args, **kwargs)
                    def create(self, *args, **kwargs):
                        """
                        Create new graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/create").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete graphics object.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/objects/delete").execute(*args, **kwargs)

                class define(TUIMenu):
                    """
                    Enter the animation definition menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def edit_monitor(self, *args, **kwargs):
                        """
                        Change animation monitor attributes.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/define/edit_monitor").execute(*args, **kwargs)
                    def define_monitor(self, *args, **kwargs):
                        """
                        Define new animation.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/animate/define/define_monitor").execute(*args, **kwargs)

            class cell_register_operations(TUIMenu):
                """
                Manage Cell Register Operations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/add").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/list").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/list_properties").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/cell_register_operations/delete").execute(*args, **kwargs)

            class execute_commands(TUIMenu):
                """
                Enter the execute-monitor-commands menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def add_edit(self, *args, **kwargs):
                    """
                    Add or edit execute-commands.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/add_edit").execute(*args, **kwargs)
                def disable(self, *args, **kwargs):
                    """
                    Disable an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/disable").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copy an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/copy").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/delete").execute(*args, **kwargs)
                def export(self, *args, **kwargs):
                    """
                    Export execute-commands to a TSV file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/export").execute(*args, **kwargs)
                def import_(self, *args, **kwargs):
                    """
                    Import execute-commands from a TSV file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/import").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable an execute-command.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/execute_commands/enable").execute(*args, **kwargs)

            class solution_strategy(TUIMenu):
                """
                Enter the automatic initialization and case modification strategy menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.automatic_case_modification = self.__class__.automatic_case_modification(path + ["automatic_case_modification"], service)
                    super().__init__(path, service)
                def continue_strategy_execution(self, *args, **kwargs):
                    """
                    Continue execution of the automatic initialization and case modification strategy defined at present.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/continue_strategy_execution").execute(*args, **kwargs)
                def delete_modification(self, *args, **kwargs):
                    """
                    Delete a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/delete_modification").execute(*args, **kwargs)
                def copy_modification(self, *args, **kwargs):
                    """
                    Copy a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/copy_modification").execute(*args, **kwargs)
                def import_modifications(self, *args, **kwargs):
                    """
                    Import a list of case modifications from a tsv file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/import_modifications").execute(*args, **kwargs)
                def enable_strategy(self, *args, **kwargs):
                    """
                    Specify whether automatic initialization and case modification should be enabled.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/enable_strategy").execute(*args, **kwargs)
                def export_modifications(self, *args, **kwargs):
                    """
                    Export all case modifications to a tsv file.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/export_modifications").execute(*args, **kwargs)
                def enable_modification(self, *args, **kwargs):
                    """
                    Enable a single defined case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/enable_modification").execute(*args, **kwargs)
                def disable_modification(self, *args, **kwargs):
                    """
                    Disable a single defined case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/disable_modification").execute(*args, **kwargs)
                def execute_strategy(self, *args, **kwargs):
                    """
                    Execute the automatic initialization and case modification strategy defined at present.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/execute_strategy").execute(*args, **kwargs)
                def automatic_initialization(self, *args, **kwargs):
                    """
                    Define how the case is to be initialized automatically.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_initialization").execute(*args, **kwargs)
                def add_edit_modification(self, *args, **kwargs):
                    """
                    Define a single case modification.
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/add_edit_modification").execute(*args, **kwargs)

                class automatic_case_modification(TUIMenu):
                    """
                    Define how the case is to be modified as the solution progresses.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def original_settings(self, *args, **kwargs):
                        """
                        Specify modification to be performed after initialization to restore to original settings.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/original_settings").execute(*args, **kwargs)
                    def before_init_modification(self, *args, **kwargs):
                        """
                        Specify modification to be performed before initialization.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/before_init_modification").execute(*args, **kwargs)
                    def modifications(self, *args, **kwargs):
                        """
                        Specify modifications to be performed during solution.
                        """
                        return PyMenu(self.service, "/solution/calculation_activities/solution_strategy/automatic_case_modification/modifications").execute(*args, **kwargs)

            class auto_save(TUIMenu):
                """
                Enter the auto save menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def case_frequency(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/case_frequency").execute(*args, **kwargs)
                def save_data_file_every(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/save_data_file_every").execute(*args, **kwargs)
                def max_files(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/max_files").execute(*args, **kwargs)
                def append_file_name_with(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/append_file_name_with").execute(*args, **kwargs)
                def retain_most_recent_files(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/retain_most_recent_files").execute(*args, **kwargs)
                def data_frequency(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/data_frequency").execute(*args, **kwargs)
                def root_name(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/calculation_activities/auto_save/root_name").execute(*args, **kwargs)

        class controls(TUIMenu):
            """
            Enter the controls menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.query = self.__class__.query(path + ["query"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                super().__init__(path, service)
            def courant_number(self, *args, **kwargs):
                """
                Set the fine mesh Courant number (time step factor).
                """
                return PyMenu(self.service, "/solution/controls/courant_number").execute(*args, **kwargs)
            def equations(self, *args, **kwargs):
                """
                Enter the equations menu.
                """
                return PyMenu(self.service, "/solution/controls/equations").execute(*args, **kwargs)
            def p_v_controls(self, *args, **kwargs):
                """
                Set P-V-Controls.
                """
                return PyMenu(self.service, "/solution/controls/p_v_controls").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Set solver limits for the values of various solution variables.
                """
                return PyMenu(self.service, "/solution/controls/limits").execute(*args, **kwargs)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enter the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solution/controls/relaxation_factor").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Set controls to default values.
                """
                return PyMenu(self.service, "/solution/controls/set_controls_to_default").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enter the under-relaxation menu.
                """
                return PyMenu(self.service, "/solution/controls/under_relaxation").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter controls query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                    self.advanced = self.__class__.advanced(path + ["advanced"], service)
                    super().__init__(path, service)
                def limits(self, *args, **kwargs):
                    """
                    Get solver limits for the values of various solution variables.
                    """
                    return PyMenu(self.service, "/solution/controls/query/limits").execute(*args, **kwargs)
                def relaxation_factor(self, *args, **kwargs):
                    """
                    Enter the relaxation-factor menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/relaxation_factor").execute(*args, **kwargs)
                def p_v_controls(self, *args, **kwargs):
                    """
                    Get P-V-Controls.
                    """
                    return PyMenu(self.service, "/solution/controls/query/p_v_controls").execute(*args, **kwargs)
                def courant_number(self, *args, **kwargs):
                    """
                    Get the fine mesh Courant number (time step factor).
                    """
                    return PyMenu(self.service, "/solution/controls/query/courant_number").execute(*args, **kwargs)
                def equations(self, *args, **kwargs):
                    """
                    Enter the equations menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/equations").execute(*args, **kwargs)
                def under_relaxation(self, *args, **kwargs):
                    """
                    Enter under relaxation menu.
                    """
                    return PyMenu(self.service, "/solution/controls/query/under_relaxation").execute(*args, **kwargs)

                class acoustics_wave_equation_controls(TUIMenu):
                    """
                    Enter menu for acoustics wave equation solver controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def max_iterations_per_timestep(self, *args, **kwargs):
                        """
                        Specify maximum number of iterations per timestep.
                        """
                        return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                    def relative_convergence_criterion(self, *args, **kwargs):
                        """
                        Specify convergence tolerance for the timestep iterations
                        as the target residual reduction factor.
                        """
                        return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter menu for expert controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def under_relaxation_factor(self, *args, **kwargs):
                            """
                            Specify under-relaxation factor to be used in
                            the diagonal matrix elements of implicit solver.
                            """
                            return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)
                        def explicit_relaxation_factor(self, *args, **kwargs):
                            """
                            Specify explicit relaxation factor to be applied to
                            the solution correction when updating solution in the timestep iterations.
                            """
                            return PyMenu(self.service, "/solution/controls/query/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)

                class advanced(TUIMenu):
                    """
                    Controls advanced options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                        super().__init__(path, service)
                    def multi_grid_amg(self, *args, **kwargs):
                        """
                        Get the parameters that govern the algebraic multigrid procedure.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_amg").execute(*args, **kwargs)
                    def multi_grid_fas(self, *args, **kwargs):
                        """
                        Get the coefficients that govern the FAS multigrid procedure.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_fas").execute(*args, **kwargs)
                    def multi_grid_controls(self, *args, **kwargs):
                        """
                        Enter the multi-grid-controls menu.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_grid_controls").execute(*args, **kwargs)
                    def multi_stage(self, *args, **kwargs):
                        """
                        Set the multiple-stage time stepping scheme coefficients.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/multi_stage").execute(*args, **kwargs)
                    def correction_tolerance(self, *args, **kwargs):
                        """
                        Enter the correction tolerance menu.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/correction_tolerance").execute(*args, **kwargs)
                    def relaxation_method(self, *args, **kwargs):
                        """
                        Set the solver relaxation method.
                        """
                        return PyMenu(self.service, "/solution/controls/query/advanced/relaxation_method").execute(*args, **kwargs)

                    class amg_options(TUIMenu):
                        """
                        Enter AMG options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def conservative_amg_coarsening(self, *args, **kwargs):
                            """
                            Use conservative AMG coarsening?.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                        def amg_gpgpu_options(self, *args, **kwargs):
                            """
                            Amg gpu options.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                        def laplace_coarsening(self, *args, **kwargs):
                            """
                            Get AMG laplace coarsening options.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/laplace_coarsening").execute(*args, **kwargs)
                        def aggressive_amg_coarsening(self, *args, **kwargs):
                            """
                            Use aggressive AMG coarsening.
                            """
                            return PyMenu(self.service, "/solution/controls/query/advanced/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    self.models = self.__class__.models(path + ["models"], service)
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    super().__init__(path, service)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solution/controls/contact_solution_controls/verbosity").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solution/controls/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enter menu for acoustics wave equation solver controls.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter menu for expert controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specify explicit relaxation factor to be applied to
                        the solution correction when updating solution in the timestep iterations.
                        """
                        return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specify under-relaxation factor to be used in
                        the diagonal matrix elements of implicit solver.
                        """
                        return PyMenu(self.service, "/solution/controls/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Controls advanced options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                    self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                    super().__init__(path, service)
                def multi_stage(self, *args, **kwargs):
                    """
                    Set the multiple-stage time stepping scheme coefficients.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_stage").execute(*args, **kwargs)
                def correction_tolerance(self, *args, **kwargs):
                    """
                    Enter the correction tolerance menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/correction_tolerance").execute(*args, **kwargs)
                def multi_grid_amg(self, *args, **kwargs):
                    """
                    Set the parameters that govern the algebraic multigrid procedure.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_amg").execute(*args, **kwargs)
                def multi_grid_fas(self, *args, **kwargs):
                    """
                    Set the coefficients that govern the FAS multigrid procedure.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_fas").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Set the solver relaxation method.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/relaxation_method").execute(*args, **kwargs)
                def slope_limiter_set(self, *args, **kwargs):
                    """
                    Enter the slope limiter set menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/slope_limiter_set").execute(*args, **kwargs)
                def multi_grid_controls(self, *args, **kwargs):
                    """
                    Enter the multi-grid-controls menu.
                    """
                    return PyMenu(self.service, "/solution/controls/advanced/multi_grid_controls").execute(*args, **kwargs)

                class fast_transient_settings(TUIMenu):
                    """
                    Enter the fast transient settings menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rk2(self, *args, **kwargs):
                        """
                        Enable the use of a two-stage Runge-Kutta scheme for time integration.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/fast_transient_settings/rk2").execute(*args, **kwargs)

                class amg_options(TUIMenu):
                    """
                    Enter AMG options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def laplace_coarsening(self, *args, **kwargs):
                        """
                        Set AMG laplace coarsening options.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/laplace_coarsening").execute(*args, **kwargs)
                    def amg_gpgpu_options(self, *args, **kwargs):
                        """
                        Set GPGPU AMG solver options.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                    def conservative_amg_coarsening(self, *args, **kwargs):
                        """
                        Use conservative AMG coarsening?.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                    def aggressive_amg_coarsening(self, *args, **kwargs):
                        """
                        Use aggressive AMG coarsening.
                        """
                        return PyMenu(self.service, "/solution/controls/advanced/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)

        class monitors(TUIMenu):
            """
            Enter the monitors menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                self.residual = self.__class__.residual(path + ["residual"], service)
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                super().__init__(path, service)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solution/monitors/convergence_conditions").execute(*args, **kwargs)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solution/monitors/set_average_over").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/clear_data").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/edit").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/list_properties").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/delete_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/add").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/list").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_files/delete").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enter the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Set normalization factors for currently-monitored residuals.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/normalization_factors").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Delete the residual history and reset iteration counter to unity.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/reset").execute(*args, **kwargs)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Set relative convergence criteria for residuals which are
                    currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Set convergence criteria for residuals which are
                    currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def criterion_type(self, *args, **kwargs):
                    """
                    Set convergence criterion type.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/criterion_type").execute(*args, **kwargs)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Set the number of iterations through which normalization
                    factors will be maximized.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_maximize_norms").execute(*args, **kwargs)
                def n_display(self, *args, **kwargs):
                    """
                    Set the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_display").execute(*args, **kwargs)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Scale the continuity residuals locally based on the enhanced formulation.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Choose whether or not residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/plot").execute(*args, **kwargs)
                def normalize(self, *args, **kwargs):
                    """
                    Choose whether or not to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/normalize").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Choose which currently-monitored residuals
                    should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/check_convergence").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Set number of residuals to be saved with data.
                    History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/n_save").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Choose which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/monitor").execute(*args, **kwargs)
                def re_normalize(self, *args, **kwargs):
                    """
                    Renormalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/re_normalize").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Enable/disable scaling of residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Choose whether or not residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solution/monitors/residual/print").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/delete_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/add").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/delete").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/plot").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/clear_data").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/edit").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/axes").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/curves").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solution/monitors/report_plots/list").execute(*args, **kwargs)

        class run_calculation(TUIMenu):
            """
            Enter run calculation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                super().__init__(path, service)
            def mesh_motion(self, *args, **kwargs):
                """
                Perform mesh motion.
                """
                return PyMenu(self.service, "/solution/run_calculation/mesh_motion").execute(*args, **kwargs)
            def multistage_time_iterate(self, *args, **kwargs):
                """
                Perform unsteady iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/multistage_time_iterate").execute(*args, **kwargs)
            def reporting_interval(self, *args, **kwargs):
                """
                Set number of solver iterations before returning to scheme.
                """
                return PyMenu(self.service, "/solution/run_calculation/reporting_interval").execute(*args, **kwargs)
            def dual_time_iterate(self, *args, **kwargs):
                """
                Perform unsteady iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/dual_time_iterate").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Set options for second-order time formulation.
                """
                return PyMenu(self.service, "/solution/run_calculation/second_order_time_options").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enter the max-corrections menu.
                """
                return PyMenu(self.service, "/solution/run_calculation/max_corrections").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Set iteration options.
                """
                return PyMenu(self.service, "/solution/run_calculation/data_sampling").execute(*args, **kwargs)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/adaptive_time_stepping").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enter the residual tolerance menu.
                """
                return PyMenu(self.service, "/solution/run_calculation/residual_tolerance").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/variable_time_stepping").execute(*args, **kwargs)
            def iterate(self, *args, **kwargs):
                """
                Perform a specified number of iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/iterate").execute(*args, **kwargs)
            def solution_steering(self, *args, **kwargs):
                """
                Enable solution steering for density-based solver.
                """
                return PyMenu(self.service, "/solution/run_calculation/solution_steering").execute(*args, **kwargs)
            def update_physical_time(self, *args, **kwargs):
                """
                Update the solution to the next physical time level.
                """
                return PyMenu(self.service, "/solution/run_calculation/update_physical_time").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Set Solution Steering Parameters.
                """
                return PyMenu(self.service, "/solution/run_calculation/set_solution_steering").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solution/run_calculation/time_step").execute(*args, **kwargs)
            def residual_verbosity(self, *args, **kwargs):
                """
                Set the residual report verbosity.
                """
                return PyMenu(self.service, "/solution/run_calculation/residual_verbosity").execute(*args, **kwargs)
            def summary(self, *args, **kwargs):
                """
                Print report summary.
                """
                return PyMenu(self.service, "/solution/run_calculation/summary").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Set number of iterations.
                """
                return PyMenu(self.service, "/solution/run_calculation/number_of_iterations").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Data sampling options for statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dft_datasets = self.__class__.dft_datasets(path + ["dft_datasets"], service)
                    super().__init__(path, service)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/remove_dataset").execute(*args, **kwargs)
                def add_rtdft_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/add_rtdft_datasets").execute(*args, **kwargs)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/add_datasets").execute(*args, **kwargs)
                def list_datasets(self, *args, **kwargs):
                    """
                    List dataset.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/list_datasets").execute(*args, **kwargs)

                class dft_datasets(TUIMenu):
                    """
                    Data sampling options for runtime discrete Fourier transform.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def freq_step_and_sampling(self, *args, **kwargs):
                        """
                        Specify either the band resolution or the sampling timesteps number. The other value will be computed consistently.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/freq_step_and_sampling").execute(*args, **kwargs)
                    def freq_tone_and_sampling(self, *args, **kwargs):
                        """
                        Specify single tone frequency and sampling duration as the number of tone periods.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/freq_tone_and_sampling").execute(*args, **kwargs)
                    def quantities(self, *args, **kwargs):
                        """
                        Select quantities for a new DFT dataset. Enter () to complete the quantity selection.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/quantities").execute(*args, **kwargs)
                    def zones(self, *args, **kwargs):
                        """
                        Select zones for a new DFT dataset.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/zones").execute(*args, **kwargs)
                    def freq_min_max(self, *args, **kwargs):
                        """
                        Specify the minimum and the maximum frequency for a band.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/freq_min_max").execute(*args, **kwargs)
                    def band_or_tone(self, *args, **kwargs):
                        """
                        Specify, whether a new dataset is for DFT in a frequency band resolved by many harmonics or for a single tone.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/band_or_tone").execute(*args, **kwargs)
                    def add_datasets(self, *args, **kwargs):
                        """
                        Add DFT datasets.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/data_sampling_options/dft_datasets/add_datasets").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enter into the transient controls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enter the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Set Max Iterations/Time step.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Set inceremtal number of Time steps.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/number_of_time_steps").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Specify a different time step size for solid zones.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/solid_time_step_size").execute(*args, **kwargs)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Set maximum flow time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/max_flow_time").execute(*args, **kwargs)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Improve prediction of flow field at time step n+1 for rotating mesh.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Set the time-stepping parameters for user-defined time stepping method.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def time_step_size(self, *args, **kwargs):
                    """
                    Set the physical time step size.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/time_step_size").execute(*args, **kwargs)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Set total number of Time steps.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial condition at time step n+1.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/predict_next_time").execute(*args, **kwargs)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Set Multiphase-specific adaptive time stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Set Duration Specification Method: [0] Incremental Time Steps, [1] Total Time Steps, [2] Total Time, [3] Incremental Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/duration_specification_method").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Set number of time step size for acoustic export.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Set Total Simulation Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/total_time").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Set Error-based adaptive time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial condition at time step n+1.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Use specified time step or courant number.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/specified_time_step").execute(*args, **kwargs)
                def incremental_time(self, *args, **kwargs):
                    """
                    Set Incremental Time.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/incremental_time").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Enable user-specified fixed time stepping method.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Set period- or frequency-based fixed time-stepping parameters.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/fixed_periodic").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    Undo the previous time step.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/undo_timestep").execute(*args, **kwargs)
                def solution_status(self, *args, **kwargs):
                    """
                    Activate the simulation status panel.
                    """
                    return PyMenu(self.service, "/solution/run_calculation/transient_controls/solution_status").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Set Multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def verbosity(self, *args, **kwargs):
                        """
                        Set verbosity to print multiphase specific time scales.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Include physics driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Set physics based time scale options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Include gravity based time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Include acoustic time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Include viscous time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Include surface tension based time scale.
                            """
                            return PyMenu(self.service, "/solution/run_calculation/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)

        class cell_registers(TUIMenu):
            """
            Manage Cell Registers.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def adapt(self, *args, **kwargs):
                """
                Adapt cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/adapt").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                List properties of an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/list_properties").execute(*args, **kwargs)
            def apply_poor_mesh_numerics(self, *args, **kwargs):
                """
                Apply poor mesh numerics to cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
            def refine(self, *args, **kwargs):
                """
                Refine cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/refine").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                List objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solution/cell_registers/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/edit").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/display").execute(*args, **kwargs)
            def coarsen(self, *args, **kwargs):
                """
                Coarsen cell register objects.
                """
                return PyMenu(self.service, "/solution/cell_registers/coarsen").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an object.
                """
                return PyMenu(self.service, "/solution/cell_registers/delete").execute(*args, **kwargs)

        class methods(TUIMenu):
            """
            Enter the methods menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                self.query = self.__class__.query(path + ["query"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                self.expert = self.__class__.expert(path + ["expert"], service)
                super().__init__(path, service)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Enable/disable the second-order unsteady solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_2nd_order").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Set gradient options.
                """
                return PyMenu(self.service, "/solution/methods/gradient_scheme").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Enable/disable first-order unsteady solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_1st_order").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Set ggnb options.
                """
                return PyMenu(self.service, "/solution/methods/nb_gradient_boundary_option").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Enable/disable bounded second-order unsteady formulation.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Enable/disable the unsteady global-time-step solution model.
                """
                return PyMenu(self.service, "/solution/methods/unsteady_global_time").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enable/disable accelerated non-iterative time marching.
                """
                return PyMenu(self.service, "/solution/methods/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enable/disable frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/solution/methods/frozen_flux").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solution/methods/reduced_rank_extrapolation").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solution/methods/flux_type").execute(*args, **kwargs)
            def residual_smoothing(self, *args, **kwargs):
                """
                Set residual smoothing factor and number of iterations.
                """
                return PyMenu(self.service, "/solution/methods/residual_smoothing").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enable convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solution/methods/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Set solution methods to default values.
                """
                return PyMenu(self.service, "/solution/methods/set_solution_methods_to_default").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Set VOF numeric options.
                """
                return PyMenu(self.service, "/solution/methods/vof_numerics").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enable/disable the noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/solution/methods/noniterative_time_advance").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enter the discretization-scheme menu.
                """
                return PyMenu(self.service, "/solution/methods/discretization_scheme").execute(*args, **kwargs)
            def p_v_coupling(self, *args, **kwargs):
                """
                Select the pressure velocity coupling scheme.
                """
                return PyMenu(self.service, "/solution/methods/p_v_coupling").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Set phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solution/methods/phase_based_vof_discretization").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solution/methods/reduced_rank_extrapolation_options").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Enter the multiphase numerics options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    super().__init__(path, service)

                class compressible_flow(TUIMenu):
                    """
                    Multiphase compressible numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Multiphase enhanced compressible flow numerics options.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Multiphase compressible flow BC alternate method.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Multiphase viscous flow numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Multiphase options for viscosity averaging.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Multiphase interphase heat and mass transfer numerics options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Alternative treatment of latent heat source due to mass transfer.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Interfacial area density menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Minimum vof seeding for non-zero area density in heat and mass transfer.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Interfacial area density gradient-symmetric mechanism.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Cavitation numerics options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Maximum limit on vapor pressure after turbulence and thermal correction.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Evaporation coefficient for Schnerr-Sauer model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Minimum vapor pressure limit for cavitation model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Condensation coefficient for Schnerr-Sauer model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enable/disable turbulent diffusion treatment between phases participating in cavitation.
                            This treatment is generally recommended for better solution stability.
                            However, in case of numerical difficulties, it can be disabled.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Boiling advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Allow generalized two-resistance framework for boiling model.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Under-relaxation factor for boiling heat flux.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes expert options of min/max superheat along with wetting fraction controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Stability controls for multiphase flow.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        self.num_ventilation = self.__class__.num_ventilation(path + ["num_ventilation"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        super().__init__(path, service)

                    class hybrid_nita(TUIMenu):
                        """
                        Hybrid NITA stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Set hybrid nita start-up controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Set number of outer iterations in hybrid nita.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Set Hybrid NITA instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Set Courant Number limit for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Set velocity limit for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Set number of outer iterations for unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Set Courant Number type for detection of unstable event.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enable instability detector for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)

                    class anti_diffusion(TUIMenu):
                        """
                        Anti Diffusion Menu for VOF/Multi-Fluid VOF Models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Set cosine exponent in dynamic strength treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Set maximum value of dynamic anti-diffusion strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enable dynamic strength to reduce compression in the tangential direction to the interface.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)

                    class num_ventilation(TUIMenu):
                        """
                        Numerical Ventilation Menu for VOF Model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def trapped_phase_vof_min(self, *args, **kwargs):
                            """
                            Set trapped phase minimum volume fraction to activate numerical ventilation treatment for trapped phase.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_min").execute(*args, **kwargs)
                        def enable(self, *args, **kwargs):
                            """
                            Enable numerical ventilation treatment to remove trapped phase adjacent to wall.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/enable").execute(*args, **kwargs)
                        def trapped_phase_vof_max(self, *args, **kwargs):
                            """
                            Set trapped phase maximum volume fraction to activate numerical ventilation treatment for non-trapped phases.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_max").execute(*args, **kwargs)
                        def tau_estimation_options(self, *args, **kwargs):
                            """
                            Set time step size option for numerical ventilation treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/tau_estimation_options").execute(*args, **kwargs)
                        def near_wall_treatment_options(self, *args, **kwargs):
                            """
                            Set near wall treatment options.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/num_ventilation/near_wall_treatment_options").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Equation Order Menu for Homogeneous Multiphase Flow Models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            Solve flow equation at the end of iteration as an alternative.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Pressure velocity coupling controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            super().__init__(path, service)

                        class skewness_correction(TUIMenu):
                            """
                            Skewness correction related stabiity controls for multiphase flow.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Use limited pressure correction gradient in skewness corrections for better stability.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Set Rhie-Chow related stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Use low order velocity interpolation in flux calculation.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                        class coupled_vof(TUIMenu):
                            """
                            Set Coupled VOF stability controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Set buoynacy force linerization options in coupled vof.
                                """
                                return PyMenu(self.service, "/solution/methods/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class solution_stabilization(TUIMenu):
                    """
                    VOF solution stabilization menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        super().__init__(path, service)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        Execute advanced stabilization for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        Execute additional stability controls for VOF.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Velocity limiting related stabiity controls for VOF.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Enter max velocity magnitude.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            Enable verbosity to print number of velocity limited cells during iterations.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enable velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Additional advanced stability controls for VOF.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Blended Compressive discretization scheme for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solution/methods/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)

                class boiling_parameters(TUIMenu):
                    """
                    Multiphase boiling parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def thin_film(self, *args, **kwargs):
                        """
                        Multiphase boiling thin film effects.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        Multiphase boiling liquid volume fraction effects.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)

                class default_controls(TUIMenu):
                    """
                    Multiphase default controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Activate multiphase defaults for loaded case.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Multiphase miscellaneous porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Multiphase relative permeability fix option.
                        """
                        return PyMenu(self.service, "/solution/methods/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enter the nita expert controls menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Set skewness neighbor coupling for nita.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Select a hybrid NITA settings option for faster performance and better robustness.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set nita verbosity option.
                    """
                    return PyMenu(self.service, "/solution/methods/nita_expert_controls/set_verbosity").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter methods query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def p_v_coupling(self, *args, **kwargs):
                    """
                    Get the pressure velocity coupling scheme.
                    """
                    return PyMenu(self.service, "/solution/methods/query/p_v_coupling").execute(*args, **kwargs)
                def discretization_scheme(self, *args, **kwargs):
                    """
                    Enter the discretization-scheme menu.
                    """
                    return PyMenu(self.service, "/solution/methods/query/discretization_scheme").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enter warped-face-gradient-correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solution/methods/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable Warped-Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solution/methods/warped_face_gradient_correction/enable").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enter the pseudo time method menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def formulation(self, *args, **kwargs):
                    """
                    Select the pseudo time step size formulation for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/formulation").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Adjust the settings for the local time step formulation.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enter the advanced options menu to define pseudo time settings for equations.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/advanced_options").execute(*args, **kwargs)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set the verbosity for the pseudo time method.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/verbosity").execute(*args, **kwargs)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enter the relaxation factors menu to set the pseudo time explicit relaxation factors for equations.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Adjust the settings for the global time step formulation.
                    """
                    return PyMenu(self.service, "/solution/methods/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enable/Disable High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets relaxation factor.
                        """
                        return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/expert").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Select Variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solution/methods/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Enter overset solver options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enable solver to run with orphans present.
                    """
                    return PyMenu(self.service, "/solution/methods/overset/orphan_cell_treatment").execute(*args, **kwargs)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Choose the interpolation method for overset interface(s).
                    """
                    return PyMenu(self.service, "/solution/methods/overset/interpolation_method").execute(*args, **kwargs)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    High order pressure extrapolation at overset interface.
                    """
                    return PyMenu(self.service, "/solution/methods/overset/high_order_pressure").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solution/methods/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solution/methods/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)

            class expert(TUIMenu):
                """
                Enter expert menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def numerics(self, *args, **kwargs):
                    """
                    Set numeric options.
                    """
                    return PyMenu(self.service, "/solution/methods/expert/numerics").execute(*args, **kwargs)
                def reactions(self, *args, **kwargs):
                    """
                    Enable/disable the species reaction sources and set relaxation factor.
                    """
                    return PyMenu(self.service, "/solution/methods/expert/reactions").execute(*args, **kwargs)

        class initialize(TUIMenu):
            """
            Enter the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                super().__init__(path, service)
            def lwf_initialization(self, *args, **kwargs):
                """
                Delete wall film particles and initialize wall film variables to zero.
                """
                return PyMenu(self.service, "/solution/initialize/lwf_initialization").execute(*args, **kwargs)
            def set_hyb_initialization(self, *args, **kwargs):
                """
                Enter the settings for hybrid initialization method.
                """
                return PyMenu(self.service, "/solution/initialize/set_hyb_initialization").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Reset discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solution/initialize/dpm_reset").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                List default values.
                """
                return PyMenu(self.service, "/solution/initialize/list_defaults").execute(*args, **kwargs)
            def initialize_flow(self, *args, **kwargs):
                """
                Initialize the flow field with the current default values.
                """
                return PyMenu(self.service, "/solution/initialize/initialize_flow").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solution/initialize/levelset_auto_init").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Set reference frame absolute or relative.
                """
                return PyMenu(self.service, "/solution/initialize/reference_frame").execute(*args, **kwargs)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enter the set full-multigrid for initialization menu.
                """
                return PyMenu(self.service, "/solution/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initialize statistics.
                """
                return PyMenu(self.service, "/solution/initialize/init_flow_statistics").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Display the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solution/initialize/show_time_sampled").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initialize turbulent velocity fluctuations.
                """
                return PyMenu(self.service, "/solution/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Open channel automatic initialization.
                """
                return PyMenu(self.service, "/solution/initialize/open_channel_auto_init").execute(*args, **kwargs)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Display the amount of simulated iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solution/initialize/show_iterations_sampled").execute(*args, **kwargs)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initialize using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solution/initialize/hyb_initialization").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specify number of timesteps for ramping of sources
                and initialize acoustics model variables.
                During ramping the sound sources are multiplied by a factor smoothly growing from 0 to 1.
                """
                return PyMenu(self.service, "/solution/initialize/init_acoustics_options").execute(*args, **kwargs)
            def set_defaults(self, *args, **kwargs):
                """
                Enter the set defaults menu.
                """
                return PyMenu(self.service, "/solution/initialize/set_defaults").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initialize using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solution/initialize/fmg_initialization").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Correct wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solution/initialize/repair_wall_distance").execute(*args, **kwargs)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solution/initialize/patch").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Localized initialization of turbulent flow variables for VOF/Mixture multiphase flow models.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Turbulent flow parameters for localized initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Localized initialization of turbulent flow variables for VOF/Mixture multiphase flow models.
                    """
                    return PyMenu(self.service, "/solution/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enter the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_options(self, *args, **kwargs):
                    """
                    Patch and smoothing options for volume fraction.
                    """
                    return PyMenu(self.service, "/solution/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solution/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solution/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enter the compute defaults menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def fluid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/fluid").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/network_end").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/overset").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/intake_fan").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/network").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/interface").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/exhaust_fan").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/geometry").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/fan").execute(*args, **kwargs)
                def radiator(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/radiator").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/degassing").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/axis").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/outlet_vent").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/wall").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/outflow").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_far_field").execute(*args, **kwargs)
                def all_zones(self, *args, **kwargs):
                    """
                    Initialize the flow field with the default values.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/all_zones").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/recirculation_outlet").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/porous_jump").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_inlet").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/velocity_inlet").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/interior").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/pressure_outlet").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/periodic").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/shadow").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/symmetry").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/dummy_entry").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/mass_flow_inlet").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/rans_les_interface").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/solid").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/mass_flow_outlet").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solution/initialize/compute_defaults/inlet_vent").execute(*args, **kwargs)

    class turbo_post(TUIMenu):
        """
        Enter the turbo menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def compute_report(self, *args, **kwargs):
            """
            Computes turbomachinery quantities.
            """
            return PyMenu(self.service, "/turbo_post/compute_report").execute(*args, **kwargs)
        def two_d_contours(self, *args, **kwargs):
            """
            Display 2d contours.
            """
            return PyMenu(self.service, "/turbo_post/two_d_contours").execute(*args, **kwargs)
        def avg_contours(self, *args, **kwargs):
            """
            Displays average contours.
            """
            return PyMenu(self.service, "/turbo_post/avg_contours").execute(*args, **kwargs)
        def xy_plot_avg(self, *args, **kwargs):
            """
            Displays average XY plots.
            """
            return PyMenu(self.service, "/turbo_post/xy_plot_avg").execute(*args, **kwargs)
        def current_topology(self, *args, **kwargs):
            """
            Sets the current turbo topology for global use.
            """
            return PyMenu(self.service, "/turbo_post/current_topology").execute(*args, **kwargs)
        def write_report(self, *args, **kwargs):
            """
            Writes the turbo report to file.
            """
            return PyMenu(self.service, "/turbo_post/write_report").execute(*args, **kwargs)

    class display(TUIMenu):
        """
        Enter the display menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.objects = self.__class__.objects(path + ["objects"], service)
            self.display_states = self.__class__.display_states(path + ["display_states"], service)
            self.pdf_data = self.__class__.pdf_data(path + ["pdf_data"], service)
            self.surface = self.__class__.surface(path + ["surface"], service)
            self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
            self.flamelet_data = self.__class__.flamelet_data(path + ["flamelet_data"], service)
            self.embedded_windows = self.__class__.embedded_windows(path + ["embedded_windows"], service)
            self.views = self.__class__.views(path + ["views"], service)
            self.view_sync = self.__class__.view_sync(path + ["view_sync"], service)
            self.define = self.__class__.define(path + ["define"], service)
            self.update_scene = self.__class__.update_scene(path + ["update_scene"], service)
            self.inverse_dft = self.__class__.inverse_dft(path + ["inverse_dft"], service)
            self.set = self.__class__.set(path + ["set"], service)
            self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
            super().__init__(path, service)
        def contour(self, *args, **kwargs):
            """
            Prompts for a scalar field and minimum and maximum values, and then displays a contour plot.
            """
            return PyMenu(self.service, "/display/contour").execute(*args, **kwargs)
        def save_picture(self, *args, **kwargs):
            """
            Generate a "hardcopy" of the active window.
            """
            return PyMenu(self.service, "/display/save_picture").execute(*args, **kwargs)
        def mesh(self, *args, **kwargs):
            """
            Displays the entire mesh. For 3D, you will be asked to confirm that you really want to draw the entire mesh (not just themesh-outline).
            """
            return PyMenu(self.service, "/display/mesh").execute(*args, **kwargs)
        def close_window(self, *args, **kwargs):
            """
            Close a "user" graphics window. User windows are specified by number (1-50), with the associated number corresponding to the order, left-to-right, that the windows were created in.
            """
            return PyMenu(self.service, "/display/close_window").execute(*args, **kwargs)
        def set_window(self, *args, **kwargs):
            """
            Sets a "user" graphics window to be the active window. User windows are specified by number (1-50), with the associated number corresponding to the order, left-to-right, that the windows were created in.
            """
            return PyMenu(self.service, "/display/set_window").execute(*args, **kwargs)
        def velocity_vector(self, *args, **kwargs):
            """
            Prompts for a scalar field by which to color the vectors, the minimum and maximum values, and the scale factor, and then draws the velocity vectors.
            """
            return PyMenu(self.service, "/display/velocity_vector").execute(*args, **kwargs)
        def vector(self, *args, **kwargs):
            """
            Displays vectors of a space vector variable.
            """
            return PyMenu(self.service, "/display/vector").execute(*args, **kwargs)
        def profile(self, *args, **kwargs):
            """
            Displays profiles of a flow variable.
            """
            return PyMenu(self.service, "/display/profile").execute(*args, **kwargs)
        def set_window_by_name(self, *args, **kwargs):
            """
            Sets the specified graphics window as active. The graphics windows specified using this command are "reserved" windows, that is, residual monitors, report plots, and animation definitions. The name will match the name you provided when creating the object (report plots and animation definitions).
            """
            return PyMenu(self.service, "/display/set_window_by_name").execute(*args, **kwargs)
        def add_custom_vector(self, *args, **kwargs):
            """
            Adds new custom vector definition.
            """
            return PyMenu(self.service, "/display/add_custom_vector").execute(*args, **kwargs)
        def reacting_channel_curves(self, *args, **kwargs):
            """
            Plots the reacting channel variables.
            """
            return PyMenu(self.service, "/display/reacting_channel_curves").execute(*args, **kwargs)
        def close_window_by_name(self, *args, **kwargs):
            """
            Close a reserved graphics window (windows used for residuals, report plots, and animation definitions).
            """
            return PyMenu(self.service, "/display/close_window_by_name").execute(*args, **kwargs)
        def surface_cells(self, *args, **kwargs):
            """
            Draws the cells on the specified surfaces. You can include a wildcard (\*) within the surface names.
            """
            return PyMenu(self.service, "/display/surface_cells").execute(*args, **kwargs)
        def switch_to_primary_volume(self, *args, **kwargs):
            """
            Switch to primary volume.
            """
            return PyMenu(self.service, "/display/switch_to_primary_volume").execute(*args, **kwargs)
        def surface_mesh(self, *args, **kwargs):
            """
            Draws the mesh defined by the specified surfaces. You can include a wildcard (\*) within the surface names.
            """
            return PyMenu(self.service, "/display/surface_mesh").execute(*args, **kwargs)
        def display_custom_vector(self, *args, **kwargs):
            """
            Displays custom vector.
            """
            return PyMenu(self.service, "/display/display_custom_vector").execute(*args, **kwargs)
        def graphics_window_layout(self, *args, **kwargs):
            """
            Arranges the graphics window layout.
            """
            return PyMenu(self.service, "/display/graphics_window_layout").execute(*args, **kwargs)
        def multigrid_coarsening(self, *args, **kwargs):
            """
            Displays a coarse mesh level from the last multigrid coarsening.
            """
            return PyMenu(self.service, "/display/multigrid_coarsening").execute(*args, **kwargs)
        def set_list_tree_separator(self, *args, **kwargs):
            """
            Set the separator character for list tree.
            """
            return PyMenu(self.service, "/display/set_list_tree_separator").execute(*args, **kwargs)
        def hsf_file(self, *args, **kwargs):
            """
            Loads an HSF file for viewing.
            """
            return PyMenu(self.service, "/display/hsf_file").execute(*args, **kwargs)
        def re_render(self, *args, **kwargs):
            """
            Re-renders the last contour, profile, or vector plot with updated surfaces, meshed, lights, colormap, rendering options, and so on, without recalculating the contour data.
            """
            return PyMenu(self.service, "/display/re_render").execute(*args, **kwargs)
        def annotate(self, *args, **kwargs):
            """
            Add a text annotation string to the active graphics window.
            """
            return PyMenu(self.service, "/display/annotate").execute(*args, **kwargs)
        def mesh_partition_boundary(self, *args, **kwargs):
            """
            Displays mesh partition boundaries.
            """
            return PyMenu(self.service, "/display/mesh_partition_boundary").execute(*args, **kwargs)
        def update_layout(self, *args, **kwargs):
            """
            Update the fluent layout.
            """
            return PyMenu(self.service, "/display/update_layout").execute(*args, **kwargs)
        def re_scale(self, *args, **kwargs):
            """
            Re-renders the last contour, profile, or vector plot with updated scale, surfaces, meshes, lights, colormap, rendering options, and so on, but without recalculating the field data.
            """
            return PyMenu(self.service, "/display/re_scale").execute(*args, **kwargs)
        def switch_to_post_processing_volume(self, *args, **kwargs):
            """
            Switch to post processing volume.
            """
            return PyMenu(self.service, "/display/switch_to_post_processing_volume").execute(*args, **kwargs)
        def clear_annotations(self, *args, **kwargs):
            """
            Removes all annotations and attachment lines from the active graphics window.
            """
            return PyMenu(self.service, "/display/clear_annotations").execute(*args, **kwargs)
        def zone_mesh(self, *args, **kwargs):
            """
            Draws the mesh defined by specified face zones. Zone names can be indicated using wildcards (\*).
            """
            return PyMenu(self.service, "/display/zone_mesh").execute(*args, **kwargs)
        def mesh_outline(self, *args, **kwargs):
            """
            Displays the mesh boundaries.
            """
            return PyMenu(self.service, "/display/mesh_outline").execute(*args, **kwargs)
        def open_window(self, *args, **kwargs):
            """
            Opens a graphics window.
            """
            return PyMenu(self.service, "/display/open_window").execute(*args, **kwargs)

        class objects(TUIMenu):
            """
            Enter to add, edit, delete or display graphics objects.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete graphics object.
                """
                return PyMenu(self.service, "/display/objects/delete").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy graphics object.
                """
                return PyMenu(self.service, "/display/objects/copy").execute(*args, **kwargs)
            def add_to_graphics(self, *args, **kwargs):
                """
                Add graphics object to existing graphics.
                """
                return PyMenu(self.service, "/display/objects/add_to_graphics").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create new graphics object.
                """
                return PyMenu(self.service, "/display/objects/create").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit graphics object.
                """
                return PyMenu(self.service, "/display/objects/edit").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display graphics object.
                """
                return PyMenu(self.service, "/display/objects/display").execute(*args, **kwargs)

        class display_states(TUIMenu):
            """
            Enter the display state manipulation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def copy(self, *args, **kwargs):
                """
                Create a new display state with settings copied from an existing display state.
                """
                return PyMenu(self.service, "/display/display_states/copy").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit a particular display state setting.
                """
                return PyMenu(self.service, "/display/display_states/edit").execute(*args, **kwargs)
            def read(self, *args, **kwargs):
                """
                Read display states from a file.
                """
                return PyMenu(self.service, "/display/display_states/read").execute(*args, **kwargs)
            def use_active(self, *args, **kwargs):
                """
                Update an existing display state's settings to match those of the active graphics window.
                """
                return PyMenu(self.service, "/display/display_states/use_active").execute(*args, **kwargs)
            def apply(self, *args, **kwargs):
                """
                Apply a display state to the active window.
                """
                return PyMenu(self.service, "/display/display_states/apply").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                Write display states to a file.
                """
                return PyMenu(self.service, "/display/display_states/write").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create a new display state.
                """
                return PyMenu(self.service, "/display/display_states/create").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete a display state.
                """
                return PyMenu(self.service, "/display/display_states/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Print the names of the available display states to the console.
                """
                return PyMenu(self.service, "/display/display_states/list").execute(*args, **kwargs)

        class pdf_data(TUIMenu):
            """
            Enters the PDF data menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def plot_1d_slice(self, *args, **kwargs):
                """
                Enables/disables a plot of the 1D-slice.
                """
                return PyMenu(self.service, "/display/pdf_data/plot_1d_slice").execute(*args, **kwargs)
            def carpet_plot(self, *args, **kwargs):
                """
                Enables/disables the display of a carpet plot of a property.
                """
                return PyMenu(self.service, "/display/pdf_data/carpet_plot").execute(*args, **kwargs)
            def write_to_file(self, *args, **kwargs):
                """
                Enables/disables writing the 1D-slice to file instead of plot.
                """
                return PyMenu(self.service, "/display/pdf_data/write_to_file").execute(*args, **kwargs)
            def draw_number_box(self, *args, **kwargs):
                """
                Enables/disables the display of the numbers box.
                """
                return PyMenu(self.service, "/display/pdf_data/draw_number_box").execute(*args, **kwargs)

        class surface(TUIMenu):
            """
            Enters the data surface-manipulation menu. For a description of the items in this menu, see surface/.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.query = self.__class__.query(path + ["query"], service)
                self.post_processing_volume = self.__class__.post_processing_volume(path + ["post_processing_volume"], service)
                super().__init__(path, service)
            def line_surface(self, *args, **kwargs):
                """
                Define a "line" surface by specifying the two endpoint coordinates.
                """
                return PyMenu(self.service, "/display/surface/line_surface").execute(*args, **kwargs)
            def zone_surface(self, *args, **kwargs):
                """
                Define a data surface on a mesh zone.
                """
                return PyMenu(self.service, "/display/surface/zone_surface").execute(*args, **kwargs)
            def ellipsoid_slice(self, *args, **kwargs):
                """
                Extract a ellipsoid slice.
                """
                return PyMenu(self.service, "/display/surface/ellipsoid_slice").execute(*args, **kwargs)
            def mouse_plane(self, *args, **kwargs):
                """
                Define a plane surface using the mouse to select three points.
                """
                return PyMenu(self.service, "/display/surface/mouse_plane").execute(*args, **kwargs)
            def ungroup_surface(self, *args, **kwargs):
                """
                Ungroup the surface(if grouped).
                """
                return PyMenu(self.service, "/display/surface/ungroup_surface").execute(*args, **kwargs)
            def quadric_slice(self, *args, **kwargs):
                """
                Extract a quadric slice.
                """
                return PyMenu(self.service, "/display/surface/quadric_slice").execute(*args, **kwargs)
            def mouse_line(self, *args, **kwargs):
                """
                Define a line surface using the mouse to select two points.
                """
                return PyMenu(self.service, "/display/surface/mouse_line").execute(*args, **kwargs)
            def multiple_plane_surfaces(self, *args, **kwargs):
                """
                Create multiple plane surfaces at specified spacing.
                """
                return PyMenu(self.service, "/display/surface/multiple_plane_surfaces").execute(*args, **kwargs)
            def reset_zone_surfaces(self, *args, **kwargs):
                """
                Reset case surface list.
                """
                return PyMenu(self.service, "/display/surface/reset_zone_surfaces").execute(*args, **kwargs)
            def partition_surface(self, *args, **kwargs):
                """
                Define a data surface on mesh faces on the partition boundary.
                """
                return PyMenu(self.service, "/display/surface/partition_surface").execute(*args, **kwargs)
            def multiple_iso_surfaces(self, *args, **kwargs):
                """
                Create multiple iso-surfaces from the data field at specified spacing.
                """
                return PyMenu(self.service, "/display/surface/multiple_iso_surfaces").execute(*args, **kwargs)
            def delete_surface(self, *args, **kwargs):
                """
                Remove a defined data surface.
                """
                return PyMenu(self.service, "/display/surface/delete_surface").execute(*args, **kwargs)
            def mouse_rake(self, *args, **kwargs):
                """
                Define a "rake" surface using the mouse to select the end points.
                """
                return PyMenu(self.service, "/display/surface/mouse_rake").execute(*args, **kwargs)
            def circle_slice(self, *args, **kwargs):
                """
                Extract a circular slice.
                """
                return PyMenu(self.service, "/display/surface/circle_slice").execute(*args, **kwargs)
            def transform_surface(self, *args, **kwargs):
                """
                Transform surface.
                """
                return PyMenu(self.service, "/display/surface/transform_surface").execute(*args, **kwargs)
            def line_slice(self, *args, **kwargs):
                """
                Extract a linear slice.
                """
                return PyMenu(self.service, "/display/surface/line_slice").execute(*args, **kwargs)
            def expression_volume(self, *args, **kwargs):
                """
                Create volume with boolean expression.
                """
                return PyMenu(self.service, "/display/surface/expression_volume").execute(*args, **kwargs)
            def create_imprint_surface(self, *args, **kwargs):
                """
                Imprint surface.
                """
                return PyMenu(self.service, "/display/surface/create_imprint_surface").execute(*args, **kwargs)
            def group_surfaces(self, *args, **kwargs):
                """
                Group a set of surfaces.
                """
                return PyMenu(self.service, "/display/surface/group_surfaces").execute(*args, **kwargs)
            def multiple_zone_surfaces(self, *args, **kwargs):
                """
                Create multiple data surfaces at a time.
                """
                return PyMenu(self.service, "/display/surface/multiple_zone_surfaces").execute(*args, **kwargs)
            def plane_slice(self, *args, **kwargs):
                """
                Extract a planar slice.
                """
                return PyMenu(self.service, "/display/surface/plane_slice").execute(*args, **kwargs)
            def sphere_slice(self, *args, **kwargs):
                """
                Extract a spherical slice.
                """
                return PyMenu(self.service, "/display/surface/sphere_slice").execute(*args, **kwargs)
            def list_surfaces(self, *args, **kwargs):
                """
                List the number of facets in the defined surfaces.
                """
                return PyMenu(self.service, "/display/surface/list_surfaces").execute(*args, **kwargs)
            def plane(self, *args, **kwargs):
                """
                Create a plane given 3 points bounded by the domain.
                """
                return PyMenu(self.service, "/display/surface/plane").execute(*args, **kwargs)
            def rename_surface(self, *args, **kwargs):
                """
                Rename a defined data surface.
                """
                return PyMenu(self.service, "/display/surface/rename_surface").execute(*args, **kwargs)
            def iso_clip(self, *args, **kwargs):
                """
                Clip a data surface (surface, curve, or point) between two iso-values.
                """
                return PyMenu(self.service, "/display/surface/iso_clip").execute(*args, **kwargs)
            def plane_surface(self, *args, **kwargs):
                """
                Create a plane from a coordinate plane, point and normal, or three points.
                """
                return PyMenu(self.service, "/display/surface/plane_surface").execute(*args, **kwargs)
            def cone_slice(self, *args, **kwargs):
                """
                Extract a cone slice.
                """
                return PyMenu(self.service, "/display/surface/cone_slice").execute(*args, **kwargs)
            def point_array(self, *args, **kwargs):
                """
                Extract a rectangular array of data points.
                """
                return PyMenu(self.service, "/display/surface/point_array").execute(*args, **kwargs)
            def structural_point_surface(self, *args, **kwargs):
                """
                Define a "structural point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/display/surface/structural_point_surface").execute(*args, **kwargs)
            def rake_surface(self, *args, **kwargs):
                """
                Define a "rake" surface by specifying the end points.
                """
                return PyMenu(self.service, "/display/surface/rake_surface").execute(*args, **kwargs)
            def edit_surface(self, *args, **kwargs):
                """
                Edit a defined data surface.
                """
                return PyMenu(self.service, "/display/surface/edit_surface").execute(*args, **kwargs)
            def surface_cells(self, *args, **kwargs):
                """
                Extract all cells intersected by a data surface.
                """
                return PyMenu(self.service, "/display/surface/surface_cells").execute(*args, **kwargs)
            def point_surface(self, *args, **kwargs):
                """
                Define a "point" surface by specifying the coordinates.
                """
                return PyMenu(self.service, "/display/surface/point_surface").execute(*args, **kwargs)
            def closest_point_search(self, *args, **kwargs):
                """
                Enable the point surface algorithm to look for the nearest point instead of reporting a creation failure.
                """
                return PyMenu(self.service, "/display/surface/closest_point_search").execute(*args, **kwargs)
            def iso_surface(self, *args, **kwargs):
                """
                Extract an iso-surface (surface, curve, or point) from the curent data field.
                """
                return PyMenu(self.service, "/display/surface/iso_surface").execute(*args, **kwargs)

            class query(TUIMenu):
                """
                Enter surface query menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def list_surfaces(self, *args, **kwargs):
                    """
                    List surfaces.
                    """
                    return PyMenu(self.service, "/display/surface/query/list_surfaces").execute(*args, **kwargs)
                def named_surface_list(self, *args, **kwargs):
                    """
                    Create named list of surfaces.
                    """
                    return PyMenu(self.service, "/display/surface/query/named_surface_list").execute(*args, **kwargs)
                def list_queries(self, *args, **kwargs):
                    """
                    List all saved queries.
                    """
                    return PyMenu(self.service, "/display/surface/query/list_queries").execute(*args, **kwargs)
                def delete_query(self, *args, **kwargs):
                    """
                    Delete saved query.
                    """
                    return PyMenu(self.service, "/display/surface/query/delete_query").execute(*args, **kwargs)
                def list_named_selection(self, *args, **kwargs):
                    """
                    List named selection of surface type.
                    """
                    return PyMenu(self.service, "/display/surface/query/list_named_selection").execute(*args, **kwargs)

            class post_processing_volume(TUIMenu):
                """
                Enter post-processing volume menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create_from_file(self, *args, **kwargs):
                    """
                    Read post-processing mesh from file.
                    """
                    return PyMenu(self.service, "/display/surface/post_processing_volume/create_from_file").execute(*args, **kwargs)
                def create_octree(self, *args, **kwargs):
                    """
                    Create post-processing octree mesh based on current case.
                    """
                    return PyMenu(self.service, "/display/surface/post_processing_volume/create_octree").execute(*args, **kwargs)

        class path_lines(TUIMenu):
            """
            Enters the pathlines menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_to_files(self, *args, **kwargs):
                """
                Writes pathlines to a file.
                """
                return PyMenu(self.service, "/display/path_lines/write_to_files").execute(*args, **kwargs)
            def path_lines(self, *args, **kwargs):
                """
                Displays pathlines from a surface.
                """
                return PyMenu(self.service, "/display/path_lines/path_lines").execute(*args, **kwargs)
            def plot_write_xy_plot(self, *args, **kwargs):
                """
                Plots or writes an XY plot of pathlines.
                """
                return PyMenu(self.service, "/display/path_lines/plot_write_xy_plot").execute(*args, **kwargs)

        class flamelet_data(TUIMenu):
            """
            Displays flamelet data.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def carpet_plot(self, *args, **kwargs):
                """
                Enables/disables display of carpet plot of a property.
                """
                return PyMenu(self.service, "/display/flamelet_data/carpet_plot").execute(*args, **kwargs)
            def write_to_file(self, *args, **kwargs):
                """
                Enables/disables writing the 1D-slice to file instead of plot.
                """
                return PyMenu(self.service, "/display/flamelet_data/write_to_file").execute(*args, **kwargs)
            def plot_1d_slice(self, *args, **kwargs):
                """
                Enables/disables plot of the 1D-slice.
                """
                return PyMenu(self.service, "/display/flamelet_data/plot_1d_slice").execute(*args, **kwargs)
            def draw_number_box(self, *args, **kwargs):
                """
                Enables/disables display of the numbers box.
                """
                return PyMenu(self.service, "/display/flamelet_data/draw_number_box").execute(*args, **kwargs)

        class embedded_windows(TUIMenu):
            """
            Enter the embedded window menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def close_all(self, *args, **kwargs):
                """
                Close all the embedded windows within the specified parent window.
                """
                return PyMenu(self.service, "/display/embedded_windows/close_all").execute(*args, **kwargs)
            def close(self, *args, **kwargs):
                """
                Close an embedded window.
                """
                return PyMenu(self.service, "/display/embedded_windows/close").execute(*args, **kwargs)
            def embed_in(self, *args, **kwargs):
                """
                Specify a window to embed and a parent window to receive the embedded window.
                """
                return PyMenu(self.service, "/display/embedded_windows/embed_in").execute(*args, **kwargs)
            def move_out_all(self, *args, **kwargs):
                """
                Move all the embedded windows out of the specified parent window.
                """
                return PyMenu(self.service, "/display/embedded_windows/move_out_all").execute(*args, **kwargs)
            def move_out(self, *args, **kwargs):
                """
                Move an embedded window out of the parent window, returning the embedded window to a non-embedded state.
                """
                return PyMenu(self.service, "/display/embedded_windows/move_out").execute(*args, **kwargs)

        class views(TUIMenu):
            """
            Enter the view manipulation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.display_states = self.__class__.display_states(path + ["display_states"], service)
                self.camera = self.__class__.camera(path + ["camera"], service)
                super().__init__(path, service)
            def list_views(self, *args, **kwargs):
                """
                Lists all predefined and saved views.
                """
                return PyMenu(self.service, "/display/views/list_views").execute(*args, **kwargs)
            def save_view(self, *args, **kwargs):
                """
                Saves the currently displayed view into the list of stored views.
                """
                return PyMenu(self.service, "/display/views/save_view").execute(*args, **kwargs)
            def last_view(self, *args, **kwargs):
                """
                Returns to the camera position before the last manipulation.
                """
                return PyMenu(self.service, "/display/views/last_view").execute(*args, **kwargs)
            def delete_view(self, *args, **kwargs):
                """
                Deletes a particular view from the list of stored views.
                """
                return PyMenu(self.service, "/display/views/delete_view").execute(*args, **kwargs)
            def write_views(self, *args, **kwargs):
                """
                Writes views to an external view file.
                """
                return PyMenu(self.service, "/display/views/write_views").execute(*args, **kwargs)
            def restore_view(self, *args, **kwargs):
                """
                Sets the current view to one of the stored views.
                """
                return PyMenu(self.service, "/display/views/restore_view").execute(*args, **kwargs)
            def default_view(self, *args, **kwargs):
                """
                Resets the view to front and center.
                """
                return PyMenu(self.service, "/display/views/default_view").execute(*args, **kwargs)
            def read_views(self, *args, **kwargs):
                """
                Reads views from an external view file.
                """
                return PyMenu(self.service, "/display/views/read_views").execute(*args, **kwargs)
            def next_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/display/views/next_view").execute(*args, **kwargs)
            def auto_scale(self, *args, **kwargs):
                """
                Scales and centers the current scene without changing its orientation.
                """
                return PyMenu(self.service, "/display/views/auto_scale").execute(*args, **kwargs)

            class display_states(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def read(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/read").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit display-states object.
                    """
                    return PyMenu(self.service, "/display/views/display_states/edit").execute(*args, **kwargs)
                def use_active(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/use_active").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete object.
                    """
                    return PyMenu(self.service, "/display/views/display_states/delete").execute(*args, **kwargs)
                def restore_state(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/restore_state").execute(*args, **kwargs)
                def rename(self, *args, **kwargs):
                    """
                    Rename object.
                    """
                    return PyMenu(self.service, "/display/views/display_states/rename").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/write").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/copy").execute(*args, **kwargs)
                def new(self, *args, **kwargs):
                    """
                    Create a new display-states object.
                    """
                    return PyMenu(self.service, "/display/views/display_states/new").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/views/display_states/list").execute(*args, **kwargs)

            class camera(TUIMenu):
                """
                Contains commands to set the camera options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def field(self, *args, **kwargs):
                    """
                    Enables you to set the field of view (width and height) of the scene.
                    """
                    return PyMenu(self.service, "/display/views/camera/field").execute(*args, **kwargs)
                def target(self, *args, **kwargs):
                    """
                    Sets the point the camera will look at.
                    """
                    return PyMenu(self.service, "/display/views/camera/target").execute(*args, **kwargs)
                def projection(self, *args, **kwargs):
                    """
                    Lets you switch between perspective and orthographic views.
                    """
                    return PyMenu(self.service, "/display/views/camera/projection").execute(*args, **kwargs)
                def up_vector(self, *args, **kwargs):
                    """
                    Sets the camera up-vector.
                    """
                    return PyMenu(self.service, "/display/views/camera/up_vector").execute(*args, **kwargs)
                def pan_camera(self, *args, **kwargs):
                    """
                    Gives you the effect of sweeping the camera across the scene. The camera remains at its position but its target changes.
                    """
                    return PyMenu(self.service, "/display/views/camera/pan_camera").execute(*args, **kwargs)
                def orbit_camera(self, *args, **kwargs):
                    """
                    Enables you to move the camera around the target. Gives the effect of circling around the target.
                    """
                    return PyMenu(self.service, "/display/views/camera/orbit_camera").execute(*args, **kwargs)
                def roll_camera(self, *args, **kwargs):
                    """
                    Lets you adjust the camera up-vector.
                    """
                    return PyMenu(self.service, "/display/views/camera/roll_camera").execute(*args, **kwargs)
                def zoom_camera(self, *args, **kwargs):
                    """
                    Adjusts the camera’s field of view. This operation is similar to dollying the camera in or out of the scene. Dollying causes objects in front to move past you. Zooming changes the perspective effect in the scene (and can be disconcerting).
                    """
                    return PyMenu(self.service, "/display/views/camera/zoom_camera").execute(*args, **kwargs)
                def position(self, *args, **kwargs):
                    """
                    Sets the camera position.
                    """
                    return PyMenu(self.service, "/display/views/camera/position").execute(*args, **kwargs)
                def dolly_camera(self, *args, **kwargs):
                    """
                    Enables you to move the camera left, right, up, down, in, and out.
                    """
                    return PyMenu(self.service, "/display/views/camera/dolly_camera").execute(*args, **kwargs)

        class view_sync(TUIMenu):
            """
            Synchronize window views.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def stop(self, *args, **kwargs):
                """
                Stop view synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/stop").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add list of window ids for synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/add").execute(*args, **kwargs)
            def remove_all(self, *args, **kwargs):
                """
                Unsynchronize all windows.
                """
                return PyMenu(self.service, "/display/view_sync/remove_all").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Print window ids of open windows.
                """
                return PyMenu(self.service, "/display/view_sync/list").execute(*args, **kwargs)
            def add_all(self, *args, **kwargs):
                """
                Synchronize all windows.
                """
                return PyMenu(self.service, "/display/view_sync/add_all").execute(*args, **kwargs)
            def remove(self, *args, **kwargs):
                """
                Remove list of window ids from synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/remove").execute(*args, **kwargs)
            def start(self, *args, **kwargs):
                """
                Start view synchronization.
                """
                return PyMenu(self.service, "/display/view_sync/start").execute(*args, **kwargs)

        class define(TUIMenu):
            """
            Enter Display define menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.material = self.__class__.material(path + ["material"], service)
                super().__init__(path, service)

            class material(TUIMenu):
                """
                Add, Edit, Remove materials in case file.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def new(self, *args, **kwargs):
                    """
                    Create new material.
                    """
                    return PyMenu(self.service, "/display/define/material/new").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copy to new material.
                    """
                    return PyMenu(self.service, "/display/define/material/copy").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit material.
                    """
                    return PyMenu(self.service, "/display/define/material/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Remove  material.
                    """
                    return PyMenu(self.service, "/display/define/material/delete").execute(*args, **kwargs)

        class update_scene(TUIMenu):
            """
            Enter the scene options menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def time(self, *args, **kwargs):
                """
                Change time-step value.
                """
                return PyMenu(self.service, "/display/update_scene/time").execute(*args, **kwargs)
            def pathline(self, *args, **kwargs):
                """
                Change pathline attributes.
                """
                return PyMenu(self.service, "/display/update_scene/pathline").execute(*args, **kwargs)
            def set_frame(self, *args, **kwargs):
                """
                Change frame options.
                """
                return PyMenu(self.service, "/display/update_scene/set_frame").execute(*args, **kwargs)
            def overlays(self, *args, **kwargs):
                """
                Enable/disable the overlays option.
                """
                return PyMenu(self.service, "/display/update_scene/overlays").execute(*args, **kwargs)
            def draw_frame(self, *args, **kwargs):
                """
                Enable/disable drawing of the bounding frame.
                """
                return PyMenu(self.service, "/display/update_scene/draw_frame").execute(*args, **kwargs)
            def select_geometry(self, *args, **kwargs):
                """
                Select geometry to be updated.
                """
                return PyMenu(self.service, "/display/update_scene/select_geometry").execute(*args, **kwargs)
            def iso_sweep(self, *args, **kwargs):
                """
                Change iso-sweep values.
                """
                return PyMenu(self.service, "/display/update_scene/iso_sweep").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete selected geometries.
                """
                return PyMenu(self.service, "/display/update_scene/delete").execute(*args, **kwargs)
            def display(self, *args, **kwargs):
                """
                Display selected geometries.
                """
                return PyMenu(self.service, "/display/update_scene/display").execute(*args, **kwargs)
            def transform(self, *args, **kwargs):
                """
                Apply transformation matrix on selected geometries.
                """
                return PyMenu(self.service, "/display/update_scene/transform").execute(*args, **kwargs)

        class inverse_dft(TUIMenu):
            """
            Reconstruct DFT signal.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def set(self, *args, **kwargs):
                """
                Set reconstruction parameters.
                """
                return PyMenu(self.service, "/display/inverse_dft/set").execute(*args, **kwargs)
            def reconstruct(self, *args, **kwargs):
                """
                Make inverse DFT recontruction.
                """
                return PyMenu(self.service, "/display/inverse_dft/reconstruct").execute(*args, **kwargs)

        class set(TUIMenu):
            """
            Enter the set menu to set display parameters.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.particle_tracks = self.__class__.particle_tracks(path + ["particle_tracks"], service)
                self.path_lines = self.__class__.path_lines(path + ["path_lines"], service)
                self.titles = self.__class__.titles(path + ["titles"], service)
                self.contours = self.__class__.contours(path + ["contours"], service)
                self.picture = self.__class__.picture(path + ["picture"], service)
                self.rendering_options = self.__class__.rendering_options(path + ["rendering_options"], service)
                self.colors = self.__class__.colors(path + ["colors"], service)
                self.velocity_vectors = self.__class__.velocity_vectors(path + ["velocity_vectors"], service)
                self.lights = self.__class__.lights(path + ["lights"], service)
                self.windows = self.__class__.windows(path + ["windows"], service)
                super().__init__(path, service)
            def nodewt_based_interp(self, *args, **kwargs):
                """
                Disables/enables the use of node weights for node-based gradients in postprocessing.
                """
                return PyMenu(self.service, "/display/set/nodewt_based_interp").execute(*args, **kwargs)
            def mesh_surfaces(self, *args, **kwargs):
                """
                Sets surface IDs to be drawn as meshes. You can include a wildcard  (\*) within the surface names.
                """
                return PyMenu(self.service, "/display/set/mesh_surfaces").execute(*args, **kwargs)
            def mesh_level(self, *args, **kwargs):
                """
                Sets coarse mesh level to be drawn.
                """
                return PyMenu(self.service, "/display/set/mesh_level").execute(*args, **kwargs)
            def overlays(self, *args, **kwargs):
                """
                Enable/disable overlays.
                """
                return PyMenu(self.service, "/display/set/overlays").execute(*args, **kwargs)
            def reset_graphics(self, *args, **kwargs):
                """
                Reset the graphics system.
                """
                return PyMenu(self.service, "/display/set/reset_graphics").execute(*args, **kwargs)
            def color_map(self, *args, **kwargs):
                """
                Enters the color map menu, which contains names of predefined and user-defined (in the Colormap Editor panel) colormaps that can be selected. It prompts you for the name of the colormap to be used.
                """
                return PyMenu(self.service, "/display/set/color_map").execute(*args, **kwargs)
            def periodic_instancing(self, *args, **kwargs):
                """
                Sets the number of periodic repetitions.
                """
                return PyMenu(self.service, "/display/set/periodic_instancing").execute(*args, **kwargs)
            def mesh_partitions(self, *args, **kwargs):
                """
                Enables/disables option to draw mesh partition boundaries.
                """
                return PyMenu(self.service, "/display/set/mesh_partitions").execute(*args, **kwargs)
            def filled_mesh(self, *args, **kwargs):
                """
                Determines whether the meshes are drawn as wireframe or solid.
                """
                return PyMenu(self.service, "/display/set/filled_mesh").execute(*args, **kwargs)
            def marker_symbol(self, *args, **kwargs):
                """
                Sets the type of markers used to represent points.
                """
                return PyMenu(self.service, "/display/set/marker_symbol").execute(*args, **kwargs)
            def mesh_zones(self, *args, **kwargs):
                """
                Sets zone IDs to be drawn as meshes.
                """
                return PyMenu(self.service, "/display/set/mesh_zones").execute(*args, **kwargs)
            def line_weight(self, *args, **kwargs):
                """
                Set the line-weight factor for the window.
                """
                return PyMenu(self.service, "/display/set/line_weight").execute(*args, **kwargs)
            def marker_size(self, *args, **kwargs):
                """
                Sets the size of markers used to represent points.
                """
                return PyMenu(self.service, "/display/set/marker_size").execute(*args, **kwargs)
            def n_stream_func(self, *args, **kwargs):
                """
                Sets number of iterations used in computing stream function.
                """
                return PyMenu(self.service, "/display/set/n_stream_func").execute(*args, **kwargs)
            def element_shrink(self, *args, **kwargs):
                """
                Sets shrinkage of both faces and cells. A value of zero indicates no shrinkage, while a value of one will shrink each face or cell to a point.
                """
                return PyMenu(self.service, "/display/set/element_shrink").execute(*args, **kwargs)
            def proximity_zones(self, *args, **kwargs):
                """
                Sets zones to be used for boundary cell distance and boundary proximity.
                """
                return PyMenu(self.service, "/display/set/proximity_zones").execute(*args, **kwargs)
            def zero_angle_dir(self, *args, **kwargs):
                """
                Sets the vector having zero angular coordinates.
                """
                return PyMenu(self.service, "/display/set/zero_angle_dir").execute(*args, **kwargs)
            def render_mesh(self, *args, **kwargs):
                """
                Enables/disables rendering the mesh on top of contours, vectors, and so on.
                """
                return PyMenu(self.service, "/display/set/render_mesh").execute(*args, **kwargs)
            def mirror_zones(self, *args, **kwargs):
                """
                Sets the zones about which the domain is mirrored (symmetry planes).
                """
                return PyMenu(self.service, "/display/set/mirror_zones").execute(*args, **kwargs)
            def duplicate_node_display(self, *args, **kwargs):
                """
                Set flag to remove duplicate nodes in mesh display.
                """
                return PyMenu(self.service, "/display/set/duplicate_node_display").execute(*args, **kwargs)
            def mesh_display_configuration(self, *args, **kwargs):
                """
                Changes the default mesh display. If set tomeshing, it draws the mesh on edges and faces of the outline surfaces, colored by their zone ID with lighting enabled. If set tosolution, it draws the mesh on edges and faces of the outline surfaces, colored by their zone type with lighting enabled. If set to post-processing, it draws the object outline with lighting disabled. If set toclassic, it draws the mesh on all edges of the outline surfaces.  This only applies for 3D cases.
                """
                return PyMenu(self.service, "/display/set/mesh_display_configuration").execute(*args, **kwargs)

            class particle_tracks(TUIMenu):
                """
                Enters the particle-tracks menu to set parameters for display of particle tracks.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.sphere_settings = self.__class__.sphere_settings(path + ["sphere_settings"], service)
                    self.filter_settings = self.__class__.filter_settings(path + ["filter_settings"], service)
                    self.vector_settings = self.__class__.vector_settings(path + ["vector_settings"], service)
                    super().__init__(path, service)
                def arrow_space(self, *args, **kwargs):
                    """
                    Sets the spacing factor for arrows drawn on particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/arrow_space").execute(*args, **kwargs)
                def arrow_scale(self, *args, **kwargs):
                    """
                    Sets the scale factor for arrows drawn on particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/arrow_scale").execute(*args, **kwargs)
                def report_variables(self, *args, **kwargs):
                    """
                    Sets the report variables.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_variables").execute(*args, **kwargs)
                def sphere_attrib(self, *args, **kwargs):
                    """
                    Specifies the size and number of slices to be used in drawing spheres.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/sphere_attrib").execute(*args, **kwargs)
                def coarsen_factor(self, *args, **kwargs):
                    """
                    Sets the coarsening factor for particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/coarsen_factor").execute(*args, **kwargs)
                def history_filename(self, *args, **kwargs):
                    """
                    Specifies the name of the particle history file.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/history_filename").execute(*args, **kwargs)
                def radius(self, *args, **kwargs):
                    """
                    Sets the radius for particle track (ribbon/cylinder only) cross-section.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/radius").execute(*args, **kwargs)
                def display(self, *args, **kwargs):
                    """
                    Determines whether particle tracks shall be displayed or only tracked.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/display").execute(*args, **kwargs)
                def report_default_variables(self, *args, **kwargs):
                    """
                    Sets the report variables to default.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_default_variables").execute(*args, **kwargs)
                def report_type(self, *args, **kwargs):
                    """
                    Sets the report type for particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_type").execute(*args, **kwargs)
                def track_single_particle_stream(self, *args, **kwargs):
                    """
                    Specifies the stream ID to be tracked.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/track_single_particle_stream").execute(*args, **kwargs)
                def style(self, *args, **kwargs):
                    """
                    Sets the display style for particle track (line/ribbon/cylinder/sphere).
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/style").execute(*args, **kwargs)
                def particle_skip(self, *args, **kwargs):
                    """
                    Specifies how many particle tracks should be displayed.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/particle_skip").execute(*args, **kwargs)
                def twist_factor(self, *args, **kwargs):
                    """
                    Sets the scale factor for twisting (ribbons only).
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/twist_factor").execute(*args, **kwargs)
                def line_width(self, *args, **kwargs):
                    """
                    Sets the width for particle track.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/line_width").execute(*args, **kwargs)
                def report_to(self, *args, **kwargs):
                    """
                    Specifies the destination for the report (console, file, none).
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/report_to").execute(*args, **kwargs)
                def marker_size(self, *args, **kwargs):
                    """
                    Sets the size of markers used to represent particle tracks.
                    """
                    return PyMenu(self.service, "/display/set/particle_tracks/marker_size").execute(*args, **kwargs)

                class sphere_settings(TUIMenu):
                    """
                    Provide sphere specific input.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def vary_diameter(self, *args, **kwargs):
                        """
                        Specifies whether the spheres can vary with another variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/vary_diameter").execute(*args, **kwargs)
                    def maximum(self, *args, **kwargs):
                        """
                        Sets the maximum value of the sphere to be displayed.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/maximum").execute(*args, **kwargs)
                    def smooth_parameter(self, *args, **kwargs):
                        """
                        Specifies number of slices to be used in drawing spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/smooth_parameter").execute(*args, **kwargs)
                    def size_variable(self, *args, **kwargs):
                        """
                        Selects a particle variable to size the spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/size_variable").execute(*args, **kwargs)
                    def diameter(self, *args, **kwargs):
                        """
                        Diameter of the spheres whenvary-diameter is disabled.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/diameter").execute(*args, **kwargs)
                    def minimum(self, *args, **kwargs):
                        """
                        Sets the minimum value of the sphere to be displayed.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/minimum").execute(*args, **kwargs)
                    def scale_factor(self, *args, **kwargs):
                        """
                        Specifies a scale factor to enlarge/reduce the size of spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/scale_factor").execute(*args, **kwargs)
                    def auto_range(self, *args, **kwargs):
                        """
                        Specifies whether displayed spheres should include auto range of variable to size spheres.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/sphere_settings/auto_range").execute(*args, **kwargs)

                class filter_settings(TUIMenu):
                    """
                    Set filter for particle display.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def minimum(self, *args, **kwargs):
                        """
                        Specifies the lower bound for the filter variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/minimum").execute(*args, **kwargs)
                    def filter_variable(self, *args, **kwargs):
                        """
                        Selects a variable used for filtering of particles.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/filter_variable").execute(*args, **kwargs)
                    def maximum(self, *args, **kwargs):
                        """
                        Specifies the upper bound for the filter variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/maximum").execute(*args, **kwargs)
                    def inside(self, *args, **kwargs):
                        """
                        Specifies whether filter variable must be inside min/max to be displayed (else outside min/max).
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/inside").execute(*args, **kwargs)
                    def enable_filtering(self, *args, **kwargs):
                        """
                        Specifies whether particle display is filtered.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/filter_settings/enable_filtering").execute(*args, **kwargs)

                class vector_settings(TUIMenu):
                    """
                    Set vector specific input.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def vector_variable(self, *args, **kwargs):
                        """
                        Selects a particle vector function to specify vector direction.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/vector_variable").execute(*args, **kwargs)
                    def length_to_head_ratio(self, *args, **kwargs):
                        """
                        Specifies ratio of length to head for vectors and length to diameter for cylinders.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/length_to_head_ratio").execute(*args, **kwargs)
                    def scale_factor(self, *args, **kwargs):
                        """
                        Specifies a scale factor to enlarge/reduce the length of vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/scale_factor").execute(*args, **kwargs)
                    def style(self, *args, **kwargs):
                        """
                        Enables and sets the display style for particle vectors (none/vector/centered-vector/centered-cylinder).
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/style").execute(*args, **kwargs)
                    def vector_length(self, *args, **kwargs):
                        """
                        Specifies the length of constant vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/vector_length").execute(*args, **kwargs)
                    def constant_color(self, *args, **kwargs):
                        """
                        Specifies a constant color for the vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/constant_color").execute(*args, **kwargs)
                    def vector_length_variable(self, *args, **kwargs):
                        """
                        Selects a particle variable to specify the length of vectors.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/vector_length_variable").execute(*args, **kwargs)
                    def color_variable(self, *args, **kwargs):
                        """
                        Specifies whether the vectors should be colored by variable specified in /display/particle-track/particle-track (if false use a constant color).
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/color_variable").execute(*args, **kwargs)
                    def length_variable(self, *args, **kwargs):
                        """
                        Specifies whether the displayed vectors have length varying with another variable.
                        """
                        return PyMenu(self.service, "/display/set/particle_tracks/vector_settings/length_variable").execute(*args, **kwargs)

            class path_lines(TUIMenu):
                """
                Sets parameters for display of pathlines.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def track_in_phase(self, *args, **kwargs):
                    """
                    Selects the phase in which particle pathlines will be computed (Multiphase Eulerian Model only).
                    """
                    return PyMenu(self.service, "/display/set/path_lines/track_in_phase").execute(*args, **kwargs)
                def line_width(self, *args, **kwargs):
                    """
                    Sets the width for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/line_width").execute(*args, **kwargs)
                def step_size(self, *args, **kwargs):
                    """
                    Sets the step length between particle positions for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/step_size").execute(*args, **kwargs)
                def radius(self, *args, **kwargs):
                    """
                    Sets the radius for pathline (ribbons/cylinder only) cross-section.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/radius").execute(*args, **kwargs)
                def relative_pathlines(self, *args, **kwargs):
                    """
                    Enables/disables the tracking of pathlines in a relative coordinate system.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/relative_pathlines").execute(*args, **kwargs)
                def sphere_attrib(self, *args, **kwargs):
                    """
                    Specifies the size and number of slices to be used in drawing spheres.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/sphere_attrib").execute(*args, **kwargs)
                def maximum_steps(self, *args, **kwargs):
                    """
                    Sets the maximum number of steps to take for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/maximum_steps").execute(*args, **kwargs)
                def arrow_space(self, *args, **kwargs):
                    """
                    Sets the spacing factor for arrows drawn on pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/arrow_space").execute(*args, **kwargs)
                def style(self, *args, **kwargs):
                    """
                    Selects the pathline style (line, point, ribbon, triangle, cylinder).
                    """
                    return PyMenu(self.service, "/display/set/path_lines/style").execute(*args, **kwargs)
                def display_steps(self, *args, **kwargs):
                    """
                    Sets the display stepping for pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/display_steps").execute(*args, **kwargs)
                def error_control(self, *args, **kwargs):
                    """
                    Sets error control during pathline computation.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/error_control").execute(*args, **kwargs)
                def arrow_scale(self, *args, **kwargs):
                    """
                    Sets the scale factor for arrows drawn on pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/arrow_scale").execute(*args, **kwargs)
                def reverse(self, *args, **kwargs):
                    """
                    Sets direction of path tracking.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/reverse").execute(*args, **kwargs)
                def maximum_error(self, *args, **kwargs):
                    """
                    Sets the maximum error allowed while computing the pathlines.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/maximum_error").execute(*args, **kwargs)
                def marker_size(self, *args, **kwargs):
                    """
                    Sets the marker size for particle drawing.
                    """
                    return PyMenu(self.service, "/display/set/path_lines/marker_size").execute(*args, **kwargs)
                def twist_factor(self, *args, **kwargs):
                    """
                    Sets the scale factor for twisting (ribbons only).
                    """
                    return PyMenu(self.service, "/display/set/path_lines/twist_factor").execute(*args, **kwargs)

            class titles(TUIMenu):
                """
                Set problem title.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def left_bottom(self, *args, **kwargs):
                    """
                    Set the title text for left bottom in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/left_bottom").execute(*args, **kwargs)
                def right_middle(self, *args, **kwargs):
                    """
                    Set the title text for right middle in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/right_middle").execute(*args, **kwargs)
                def left_top(self, *args, **kwargs):
                    """
                    Set the title text for left top in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/left_top").execute(*args, **kwargs)
                def right_bottom(self, *args, **kwargs):
                    """
                    Set the title text for right bottom in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/right_bottom").execute(*args, **kwargs)
                def right_top(self, *args, **kwargs):
                    """
                    Set the title text for right top in title segment.
                    """
                    return PyMenu(self.service, "/display/set/titles/right_top").execute(*args, **kwargs)

            class contours(TUIMenu):
                """
                Enters the contour options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def line_contours(self, *args, **kwargs):
                    """
                    Turns the line contours option on/off (deselects filled-contours?).
                    """
                    return PyMenu(self.service, "/display/set/contours/line_contours").execute(*args, **kwargs)
                def log_scale(self, *args, **kwargs):
                    """
                    Specifies a decimal or logarithmic color scale for contours.
                    """
                    return PyMenu(self.service, "/display/set/contours/log_scale").execute(*args, **kwargs)
                def filled_contours(self, *args, **kwargs):
                    """
                    Turns the filled contours option on/off (deselects line-contours?).
                    """
                    return PyMenu(self.service, "/display/set/contours/filled_contours").execute(*args, **kwargs)
                def render_mesh(self, *args, **kwargs):
                    """
                    Determines whether or not to render the mesh on top of contours, vectors, and so on.
                    """
                    return PyMenu(self.service, "/display/set/contours/render_mesh").execute(*args, **kwargs)
                def node_values(self, *args, **kwargs):
                    """
                    Sets the option to use scalar field at nodes when computing the contours.
                    """
                    return PyMenu(self.service, "/display/set/contours/node_values").execute(*args, **kwargs)
                def n_contour(self, *args, **kwargs):
                    """
                    Sets the number of contour levels.
                    """
                    return PyMenu(self.service, "/display/set/contours/n_contour").execute(*args, **kwargs)
                def auto_range(self, *args, **kwargs):
                    """
                    Enables/disables auto-computation of the contour range.
                    """
                    return PyMenu(self.service, "/display/set/contours/auto_range").execute(*args, **kwargs)
                def coloring(self, *args, **kwargs):
                    """
                    Specifies whether contours are displayed in bands or with smooth transitions. Note that you can only display smooth contours if node-values are enabled.
                    """
                    return PyMenu(self.service, "/display/set/contours/coloring").execute(*args, **kwargs)
                def surfaces(self, *args, **kwargs):
                    """
                    Sets the surfaces on which contours are drawn. You can include a wildcard (\*) within the surface names.
                    """
                    return PyMenu(self.service, "/display/set/contours/surfaces").execute(*args, **kwargs)
                def clip_to_range(self, *args, **kwargs):
                    """
                    Turns the clip to range option for filled contours on/off.
                    """
                    return PyMenu(self.service, "/display/set/contours/clip_to_range").execute(*args, **kwargs)
                def global_range(self, *args, **kwargs):
                    """
                    Turns the global range for contours on/off.
                    """
                    return PyMenu(self.service, "/display/set/contours/global_range").execute(*args, **kwargs)

            class picture(TUIMenu):
                """
                Enter the hardcopy/save-picture options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.driver = self.__class__.driver(path + ["driver"], service)
                    self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                    super().__init__(path, service)
                def preview(self, *args, **kwargs):
                    """
                    Display a preview image of a hardcopy.
                    """
                    return PyMenu(self.service, "/display/set/picture/preview").execute(*args, **kwargs)
                def set_standard_resolution(self, *args, **kwargs):
                    """
                    Select from pre-defined resolution list.
                    """
                    return PyMenu(self.service, "/display/set/picture/set_standard_resolution").execute(*args, **kwargs)
                def dpi(self, *args, **kwargs):
                    """
                    Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                    """
                    return PyMenu(self.service, "/display/set/picture/dpi").execute(*args, **kwargs)
                def use_window_resolution(self, *args, **kwargs):
                    """
                    Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                    """
                    return PyMenu(self.service, "/display/set/picture/use_window_resolution").execute(*args, **kwargs)
                def x_resolution(self, *args, **kwargs):
                    """
                    Set the width of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/display/set/picture/x_resolution").execute(*args, **kwargs)
                def jpeg_hardcopy_quality(self, *args, **kwargs):
                    """
                    To set jpeg hardcopy quality.
                    """
                    return PyMenu(self.service, "/display/set/picture/jpeg_hardcopy_quality").execute(*args, **kwargs)
                def invert_background(self, *args, **kwargs):
                    """
                    Use a white background when the picture is saved.
                    """
                    return PyMenu(self.service, "/display/set/picture/invert_background").execute(*args, **kwargs)
                def landscape(self, *args, **kwargs):
                    """
                    Plot hardcopies in landscape or portrait orientation.
                    """
                    return PyMenu(self.service, "/display/set/picture/landscape").execute(*args, **kwargs)
                def y_resolution(self, *args, **kwargs):
                    """
                    Set the height of raster-formatted images in pixels (0 implies current window size).
                    """
                    return PyMenu(self.service, "/display/set/picture/y_resolution").execute(*args, **kwargs)

                class driver(TUIMenu):
                    """
                    Enter the set hardcopy driver menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.post_format = self.__class__.post_format(path + ["post_format"], service)
                        super().__init__(path, service)
                    def hsf(self, *args, **kwargs):
                        """
                        Use HSF output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/hsf").execute(*args, **kwargs)
                    def glb(self, *args, **kwargs):
                        """
                        Use GLB output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/glb").execute(*args, **kwargs)
                    def vrml(self, *args, **kwargs):
                        """
                        Use VRML output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/vrml").execute(*args, **kwargs)
                    def jpeg(self, *args, **kwargs):
                        """
                        Produce JPEG output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/jpeg").execute(*args, **kwargs)
                    def options(self, *args, **kwargs):
                        """
                        Set the hardcopy options. Available options are:
                        "no gamma correction", disables gamma correction of colors,
                        "physical size = (width,height)", where width and height
                        are the actual measurements of the printable area of the page
                        in centimeters.
                        "subscreen = (left,right,bottom,top)", where left,right,
                        bottom, and top are numbers in [-1,1] describing a subwindow on
                        the page in which to place the hardcopy.
                        The options may be combined by separating them with commas.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/options").execute(*args, **kwargs)
                    def png(self, *args, **kwargs):
                        """
                        Use PNG output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/png").execute(*args, **kwargs)
                    def avz(self, *args, **kwargs):
                        """
                        Use AVZ output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/avz").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        List the current hardcopy driver.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/list").execute(*args, **kwargs)
                    def tiff(self, *args, **kwargs):
                        """
                        Use TIFF output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/tiff").execute(*args, **kwargs)
                    def eps(self, *args, **kwargs):
                        """
                        Produce encapsulated PostScript (EPS) output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/eps").execute(*args, **kwargs)
                    def dump_window(self, *args, **kwargs):
                        """
                        Set the command used to dump the graphics window to a file.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/dump_window").execute(*args, **kwargs)
                    def post_script(self, *args, **kwargs):
                        """
                        Produce PostScript output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/post_script").execute(*args, **kwargs)
                    def ppm(self, *args, **kwargs):
                        """
                        Produce PPM output for hardcopies.
                        """
                        return PyMenu(self.service, "/display/set/picture/driver/ppm").execute(*args, **kwargs)

                    class post_format(TUIMenu):
                        """
                        Enter the PostScript driver format menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def fast_raster(self, *args, **kwargs):
                            """
                            Use the new raster format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/fast_raster").execute(*args, **kwargs)
                        def vector(self, *args, **kwargs):
                            """
                            Use vector format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/vector").execute(*args, **kwargs)
                        def rle_raster(self, *args, **kwargs):
                            """
                            Use the run-length encoded raster format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/rle_raster").execute(*args, **kwargs)
                        def raster(self, *args, **kwargs):
                            """
                            Use the original raster format.
                            """
                            return PyMenu(self.service, "/display/set/picture/driver/post_format/raster").execute(*args, **kwargs)

                class color_mode(TUIMenu):
                    """
                    Enter the hardcopy color mode menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def gray_scale(self, *args, **kwargs):
                        """
                        Convert color to grayscale for hardcopy.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/gray_scale").execute(*args, **kwargs)
                    def list(self, *args, **kwargs):
                        """
                        Display the current hardcopy color mode.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/list").execute(*args, **kwargs)
                    def color(self, *args, **kwargs):
                        """
                        Plot hardcopies in color.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/color").execute(*args, **kwargs)
                    def mono_chrome(self, *args, **kwargs):
                        """
                        Convert color to monochrome (black and white) for hardcopy.
                        """
                        return PyMenu(self.service, "/display/set/picture/color_mode/mono_chrome").execute(*args, **kwargs)

            class rendering_options(TUIMenu):
                """
                Enter the rendering options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_rendering_options(self, *args, **kwargs):
                    """
                    Set the rendering options.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/set_rendering_options").execute(*args, **kwargs)
                def hidden_surface_method(self, *args, **kwargs):
                    """
                    Specify the method to perform hidden line and hidden surface rendering.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/hidden_surface_method").execute(*args, **kwargs)
                def auto_spin(self, *args, **kwargs):
                    """
                    Enable/disable mouse view rotations to continue to spin the display after the button is released.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/auto_spin").execute(*args, **kwargs)
                def driver(self, *args, **kwargs):
                    """
                    Change the current graphics driver.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/driver").execute(*args, **kwargs)
                def color_map_alignment(self, *args, **kwargs):
                    """
                    Set the color bar alignment.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/color_map_alignment").execute(*args, **kwargs)
                def animation_option(self, *args, **kwargs):
                    """
                    Using Wireframe / All option during animation.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/animation_option").execute(*args, **kwargs)
                def device_info(self, *args, **kwargs):
                    """
                    List information for the graphics device.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/device_info").execute(*args, **kwargs)
                def surface_edge_visibility(self, *args, **kwargs):
                    """
                    Set edge visibility flags for surfaces.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/surface_edge_visibility").execute(*args, **kwargs)
                def help_text_color(self, *args, **kwargs):
                    """
                    Set the color of screen help text.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/help_text_color").execute(*args, **kwargs)
                def hidden_surfaces(self, *args, **kwargs):
                    """
                    Enable/disable hidden surface removal.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/hidden_surfaces").execute(*args, **kwargs)
                def outer_face_cull(self, *args, **kwargs):
                    """
                    Enable/disable discarding outer faces during display.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/outer_face_cull").execute(*args, **kwargs)
                def show_colormap(self, *args, **kwargs):
                    """
                    Enable/Disable colormap.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/show_colormap").execute(*args, **kwargs)
                def face_displacement(self, *args, **kwargs):
                    """
                    Set face displacement value in Z-buffer units along the Camera Z-axis.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/face_displacement").execute(*args, **kwargs)
                def double_buffering(self, *args, **kwargs):
                    """
                    Enable/disable double-buffering.
                    """
                    return PyMenu(self.service, "/display/set/rendering_options/double_buffering").execute(*args, **kwargs)

            class colors(TUIMenu):
                """
                Enter the color options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.by_surface = self.__class__.by_surface(path + ["by_surface"], service)
                    self.by_type = self.__class__.by_type(path + ["by_type"], service)
                    super().__init__(path, service)
                def show_user_colors(self, *args, **kwargs):
                    """
                    List currently defined user colors.
                    """
                    return PyMenu(self.service, "/display/set/colors/show_user_colors").execute(*args, **kwargs)
                def rans_les_interface_faces(self, *args, **kwargs):
                    """
                    Set the color of RANS/LES interface faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/rans_les_interface_faces").execute(*args, **kwargs)
                def internal_faces(self, *args, **kwargs):
                    """
                    Set the color of internal interface faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/internal_faces").execute(*args, **kwargs)
                def outlet_faces(self, *args, **kwargs):
                    """
                    Set the color of outlet faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/outlet_faces").execute(*args, **kwargs)
                def skip_label(self, *args, **kwargs):
                    """
                    Set the number of labels to be skipped in the colopmap scale.
                    """
                    return PyMenu(self.service, "/display/set/colors/skip_label").execute(*args, **kwargs)
                def inlet_faces(self, *args, **kwargs):
                    """
                    Set the color of inlet faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/inlet_faces").execute(*args, **kwargs)
                def foreground(self, *args, **kwargs):
                    """
                    Set the foreground (text and window frame) color.
                    """
                    return PyMenu(self.service, "/display/set/colors/foreground").execute(*args, **kwargs)
                def free_surface_faces(self, *args, **kwargs):
                    """
                    Set the color of free-surface faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/free_surface_faces").execute(*args, **kwargs)
                def automatic_skip(self, *args, **kwargs):
                    """
                    Determine whether to skip labels in the colopmap scale automatically.
                    """
                    return PyMenu(self.service, "/display/set/colors/automatic_skip").execute(*args, **kwargs)
                def traction_faces(self, *args, **kwargs):
                    """
                    Set the color of traction faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/traction_faces").execute(*args, **kwargs)
                def overset_faces(self, *args, **kwargs):
                    """
                    Set the color of overset faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/overset_faces").execute(*args, **kwargs)
                def symmetry_faces(self, *args, **kwargs):
                    """
                    Set the color of symmetric faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/symmetry_faces").execute(*args, **kwargs)
                def reset_colors(self, *args, **kwargs):
                    """
                    Reset individual mesh surface colors to the defaults.
                    """
                    return PyMenu(self.service, "/display/set/colors/reset_colors").execute(*args, **kwargs)
                def interface_faces(self, *args, **kwargs):
                    """
                    Set the color of mesh Interfaces.
                    """
                    return PyMenu(self.service, "/display/set/colors/interface_faces").execute(*args, **kwargs)
                def surface(self, *args, **kwargs):
                    """
                    Set the color of surfaces.
                    """
                    return PyMenu(self.service, "/display/set/colors/surface").execute(*args, **kwargs)
                def graphics_color_theme(self, *args, **kwargs):
                    """
                    Enter the graphics color theme menu.
                    """
                    return PyMenu(self.service, "/display/set/colors/graphics_color_theme").execute(*args, **kwargs)
                def axis_faces(self, *args, **kwargs):
                    """
                    Set the color of axisymmetric faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/axis_faces").execute(*args, **kwargs)
                def reset_user_colors(self, *args, **kwargs):
                    """
                    Reset all user colors.
                    """
                    return PyMenu(self.service, "/display/set/colors/reset_user_colors").execute(*args, **kwargs)
                def far_field_faces(self, *args, **kwargs):
                    """
                    Set the color of far field faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/far_field_faces").execute(*args, **kwargs)
                def interior_faces(self, *args, **kwargs):
                    """
                    Set the color of interior faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/interior_faces").execute(*args, **kwargs)
                def wall_faces(self, *args, **kwargs):
                    """
                    Set the color of wall faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/wall_faces").execute(*args, **kwargs)
                def periodic_faces(self, *args, **kwargs):
                    """
                    Set the color of periodic faces.
                    """
                    return PyMenu(self.service, "/display/set/colors/periodic_faces").execute(*args, **kwargs)
                def user_color(self, *args, **kwargs):
                    """
                    Explicitly set color of display zone.
                    """
                    return PyMenu(self.service, "/display/set/colors/user_color").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List available colors.
                    """
                    return PyMenu(self.service, "/display/set/colors/list").execute(*args, **kwargs)
                def color_by_type(self, *args, **kwargs):
                    """
                    Determine whether to color meshes by type or by surface (ID).
                    """
                    return PyMenu(self.service, "/display/set/colors/color_by_type").execute(*args, **kwargs)
                def background(self, *args, **kwargs):
                    """
                    Set the background (window) color.
                    """
                    return PyMenu(self.service, "/display/set/colors/background").execute(*args, **kwargs)

                class by_surface(TUIMenu):
                    """
                    Enter the surface(s) color and material assignment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list_surfaces_by_color(self, *args, **kwargs):
                        """
                        To list the surfaces by its color.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/list_surfaces_by_color").execute(*args, **kwargs)
                    def reset(self, *args, **kwargs):
                        """
                        To reset colors and/or materials to the defaults.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/reset").execute(*args, **kwargs)
                    def surfaces(self, *args, **kwargs):
                        """
                        Select the surface(s) to specify colors and/or materials.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/surfaces").execute(*args, **kwargs)
                    def list_surfaces_by_material(self, *args, **kwargs):
                        """
                        To list the surfaces by its material.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_surface/list_surfaces_by_material").execute(*args, **kwargs)

                class by_type(TUIMenu):
                    """
                    Enter the zone type color and material assignment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.type_name = self.__class__.type_name(path + ["type_name"], service)
                        super().__init__(path, service)
                    def only_list_case_boundaries(self, *args, **kwargs):
                        """
                        Only list the boundary types that are assigned in this case.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_type/only_list_case_boundaries").execute(*args, **kwargs)
                    def reset(self, *args, **kwargs):
                        """
                        To reset colors and/or materials to the defaults.
                        """
                        return PyMenu(self.service, "/display/set/colors/by_type/reset").execute(*args, **kwargs)

                    class type_name(TUIMenu):
                        """
                        Select the boundary type to specify colors and/or materials.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def inlet(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/inlet").execute(*args, **kwargs)
                        def wall(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/wall").execute(*args, **kwargs)
                        def traction(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/traction").execute(*args, **kwargs)
                        def surface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/surface").execute(*args, **kwargs)
                        def rans_les_interface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/rans_les_interface").execute(*args, **kwargs)
                        def free_surface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/free_surface").execute(*args, **kwargs)
                        def interface(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/interface").execute(*args, **kwargs)
                        def symmetry(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/symmetry").execute(*args, **kwargs)
                        def far_field(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/far_field").execute(*args, **kwargs)
                        def outlet(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/outlet").execute(*args, **kwargs)
                        def internal(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/internal").execute(*args, **kwargs)
                        def axis(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/axis").execute(*args, **kwargs)
                        def overset(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/overset").execute(*args, **kwargs)
                        def interior(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/interior").execute(*args, **kwargs)
                        def periodic(self, *args, **kwargs):
                            """
                            Set the material and/or color for the selected boundary type.
                            """
                            return PyMenu(self.service, "/display/set/colors/by_type/type_name/periodic").execute(*args, **kwargs)

            class velocity_vectors(TUIMenu):
                """
                Enters the menu to set parameters for display of velocity vectors.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def log_scale(self, *args, **kwargs):
                    """
                    Toggles whether color scale is logarithmic or linear.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/log_scale").execute(*args, **kwargs)
                def scale(self, *args, **kwargs):
                    """
                    Sets the value by which the vector length will be scaled.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/scale").execute(*args, **kwargs)
                def component_z(self, *args, **kwargs):
                    """
                    Sets the option to use only the  component of the velocity vectors during display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/component_z").execute(*args, **kwargs)
                def node_values(self, *args, **kwargs):
                    """
                    Enables/disables the plotting of node values. Cell values will be plotted if "no".
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/node_values").execute(*args, **kwargs)
                def style(self, *args, **kwargs):
                    """
                    Specifies the vector style that will be used when the vectors are displayed. You can choose from:3d arrow,3d arrowhead, cone,filled-arrow, arrow,harpoon, or headless.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/style").execute(*args, **kwargs)
                def scale_head(self, *args, **kwargs):
                    """
                    Sets the value by which the vector head will be scaled.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/scale_head").execute(*args, **kwargs)
                def surfaces(self, *args, **kwargs):
                    """
                    Sets surfaces on which vectors are drawn. You can include a wildcard (\*) within the surface names.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/surfaces").execute(*args, **kwargs)
                def constant_length(self, *args, **kwargs):
                    """
                    Sets the option to draw velocity vectors of constant length. This shows only the direction of the velocity vectors.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/constant_length").execute(*args, **kwargs)
                def color(self, *args, **kwargs):
                    """
                    Sets the color of all velocity vectors to the color specified. The color scale is ignored. This is useful when overlaying a vector plot over a contour plot.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/color").execute(*args, **kwargs)
                def color_levels(self, *args, **kwargs):
                    """
                    Sets the number of colors used from the colormap.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/color_levels").execute(*args, **kwargs)
                def component_y(self, *args, **kwargs):
                    """
                    Sets the option to use only the  component of the velocity vectors during display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/component_y").execute(*args, **kwargs)
                def component_x(self, *args, **kwargs):
                    """
                    Sets the option to use only the  component of the velocity vectors during display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/component_x").execute(*args, **kwargs)
                def render_mesh(self, *args, **kwargs):
                    """
                    Enables/disables rendering the mesh on top of contours, vectors, and so on.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/render_mesh").execute(*args, **kwargs)
                def global_range(self, *args, **kwargs):
                    """
                    Turns global range for vectors on/off.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/global_range").execute(*args, **kwargs)
                def relative(self, *args, **kwargs):
                    """
                    Toggles the display of relative velocity vectors.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/relative").execute(*args, **kwargs)
                def in_plane(self, *args, **kwargs):
                    """
                    Toggles the display of velocity vector components in the plane of the surface selected for display.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/in_plane").execute(*args, **kwargs)
                def auto_scale(self, *args, **kwargs):
                    """
                    Auto-scales all vectors so that vector overlap is minimal.
                    """
                    return PyMenu(self.service, "/display/set/velocity_vectors/auto_scale").execute(*args, **kwargs)

            class lights(TUIMenu):
                """
                Enter the lights menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def lights_on(self, *args, **kwargs):
                    """
                    Turn all active lighting on/off.
                    """
                    return PyMenu(self.service, "/display/set/lights/lights_on").execute(*args, **kwargs)
                def lighting_interpolation(self, *args, **kwargs):
                    """
                    Set lighting interpolation method.
                    """
                    return PyMenu(self.service, "/display/set/lights/lighting_interpolation").execute(*args, **kwargs)
                def set_light(self, *args, **kwargs):
                    """
                    Add or modify a directional, colored light.
                    """
                    return PyMenu(self.service, "/display/set/lights/set_light").execute(*args, **kwargs)
                def headlight_on(self, *args, **kwargs):
                    """
                    Turn the light that moves with the camera on or off.
                    """
                    return PyMenu(self.service, "/display/set/lights/headlight_on").execute(*args, **kwargs)
                def set_ambient_color(self, *args, **kwargs):
                    """
                    Set the ambient light color for the scene.
                    """
                    return PyMenu(self.service, "/display/set/lights/set_ambient_color").execute(*args, **kwargs)

            class windows(TUIMenu):
                """
                Enter the window options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.text = self.__class__.text(path + ["text"], service)
                    self.xy = self.__class__.xy(path + ["xy"], service)
                    self.video = self.__class__.video(path + ["video"], service)
                    self.axes = self.__class__.axes(path + ["axes"], service)
                    self.scale = self.__class__.scale(path + ["scale"], service)
                    self.main = self.__class__.main(path + ["main"], service)
                    super().__init__(path, service)
                def logo_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/set/windows/logo_color").execute(*args, **kwargs)
                def aspect_ratio(self, *args, **kwargs):
                    """
                    Sets the aspect ratio of the active window.
                    """
                    return PyMenu(self.service, "/display/set/windows/aspect_ratio").execute(*args, **kwargs)
                def ruler(self, *args, **kwargs):
                    """
                    Turns the ruler on/off. Note that if you are running Fluent in 3D, then the view must be set toorthographic.
                    """
                    return PyMenu(self.service, "/display/set/windows/ruler").execute(*args, **kwargs)
                def logo(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/display/set/windows/logo").execute(*args, **kwargs)

                class text(TUIMenu):
                    """
                    Enters the text window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def company(self, *args, **kwargs):
                        """
                        Shows or hides the company name in the picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/company").execute(*args, **kwargs)
                    def application(self, *args, **kwargs):
                        """
                        Shows or hides the application name in the picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/application").execute(*args, **kwargs)
                    def date(self, *args, **kwargs):
                        """
                        Shows or hides the date in the picture.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/date").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Sets the bottom boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/bottom").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Sets the left boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/left").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Sets whether or not to draw a border around the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/border").execute(*args, **kwargs)
                    def alignment(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/display/set/windows/text/alignment").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Controls the visibility of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/visible").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        Enables/disables the transparency of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/clear").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        Sets the top boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/top").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Sets the right boundary of the text window.
                        """
                        return PyMenu(self.service, "/display/set/windows/text/right").execute(*args, **kwargs)

                class xy(TUIMenu):
                    """
                    Enters the XY plot window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def right(self, *args, **kwargs):
                        """
                        Sets the right boundary of the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/right").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Sets the left boundary of the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/left").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Sets the bottom boundary of the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/bottom").execute(*args, **kwargs)
                    def top(self, *args, **kwargs):
                        """
                        Sets the top boundary of the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/top").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Sets whether or not to draw a border around the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/border").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Controls the visibility of the XY plot window.
                        """
                        return PyMenu(self.service, "/display/set/windows/xy/visible").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Contains options for modifying a video. This menu is not relevant for the meshing mode.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def color_filter(self, *args, **kwargs):
                        """
                        Sets the video color filter. For example, to change the color filter from its default setting  to PAL video with a saturation of 80percentage and a brightness of 90percentage, you would  enter "video=pal,sat=.8,gain=.9" after selecting the color-filter command.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/color_filter").execute(*args, **kwargs)
                    def on(self, *args, **kwargs):
                        """
                        Enables or disables the video picture settings.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/on").execute(*args, **kwargs)
                    def foreground(self, *args, **kwargs):
                        """
                        Sets the foreground (text) color of the graphics window. The color is specified as a string of three comma-separated numbers between 0 and 1, representing red, green, and blue. For example, to change the foreground from white (default) to gray, you would enter ".5,.5,.5" after selecting the foreground command.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/foreground").execute(*args, **kwargs)
                    def background(self, *args, **kwargs):
                        """
                        Sets the background color of the graphics window. The color is specified as a string of three comma-separated numbers between 0 and 1, representing red, green, and blue. For example, to change the background from black (default) to gray, you would enter ".5,.5,.5" after selecting the background command.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/background").execute(*args, **kwargs)
                    def pixel_size(self, *args, **kwargs):
                        """
                        Sets the window size in pixels.
                        """
                        return PyMenu(self.service, "/display/set/windows/video/pixel_size").execute(*args, **kwargs)

                class axes(TUIMenu):
                    """
                    Enters the axes window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def bottom(self, *args, **kwargs):
                        """
                        Sets the bottom boundary of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/bottom").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Sets the right boundary of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/right").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        Sets the transparency of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/clear").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Controls the visibility of the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/visible").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Sets whether or not to draw a border around the axes window.
                        """
                        return PyMenu(self.service, "/display/set/windows/axes/border").execute(*args, **kwargs)

                class scale(TUIMenu):
                    """
                    Enters the color scale window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def top(self, *args, **kwargs):
                        """
                        Sets the top boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/top").execute(*args, **kwargs)
                    def margin(self, *args, **kwargs):
                        """
                        Sets the margin of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/margin").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Sets the number format of the color scale window (for example, percentage0.2e).
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/format").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Sets whether or not to draw a border around the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/border").execute(*args, **kwargs)
                    def clear(self, *args, **kwargs):
                        """
                        Sets the transparency of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/clear").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Controls the visibility of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/visible").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Sets the left boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/left").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Sets the bottom boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/bottom").execute(*args, **kwargs)
                    def font_size(self, *args, **kwargs):
                        """
                        Sets the font size of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/font_size").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Sets the right boundary of the color scale window.
                        """
                        return PyMenu(self.service, "/display/set/windows/scale/right").execute(*args, **kwargs)

                class main(TUIMenu):
                    """
                    Enters the main view window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def top(self, *args, **kwargs):
                        """
                        Sets the top boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/top").execute(*args, **kwargs)
                    def left(self, *args, **kwargs):
                        """
                        Sets the left boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/left").execute(*args, **kwargs)
                    def visible(self, *args, **kwargs):
                        """
                        Controls the visibility of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/visible").execute(*args, **kwargs)
                    def border(self, *args, **kwargs):
                        """
                        Sets whether or not to draw a border around the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/border").execute(*args, **kwargs)
                    def bottom(self, *args, **kwargs):
                        """
                        Sets the bottom boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/bottom").execute(*args, **kwargs)
                    def right(self, *args, **kwargs):
                        """
                        Sets the right boundary of the main viewing window.
                        """
                        return PyMenu(self.service, "/display/set/windows/main/right").execute(*args, **kwargs)

        class particle_tracks(TUIMenu):
            """
            Enters the particle tracks menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def particle_tracks(self, *args, **kwargs):
                """
                Calculates and displays particle tracks from defined injections.
                """
                return PyMenu(self.service, "/display/particle_tracks/particle_tracks").execute(*args, **kwargs)
            def plot_write_xy_plot(self, *args, **kwargs):
                """
                Plots or writes an XY plot of particle tracks.
                """
                return PyMenu(self.service, "/display/particle_tracks/plot_write_xy_plot").execute(*args, **kwargs)

    class parameters__and__customization(TUIMenu):
        """
        Enter Parameters and custom menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.parameters = self.__class__.parameters(path + ["parameters"], service)
            self.user_defined = self.__class__.user_defined(path + ["user_defined"], service)
            super().__init__(path, service)

        class parameters(TUIMenu):
            """
            Enter the parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.input_parameters = self.__class__.input_parameters(path + ["input_parameters"], service)
                self.list_parameters = self.__class__.list_parameters(path + ["list_parameters"], service)
                self.output_parameters = self.__class__.output_parameters(path + ["output_parameters"], service)
                super().__init__(path, service)
            def enable_in_TUI(self, *args, **kwargs):
                """
                Enable/disable parameters in the text user interface.
                """
                return PyMenu(self.service, "/parameters__and__customization/parameters/enable_in_TUI").execute(*args, **kwargs)

            class input_parameters(TUIMenu):
                """
                Enter the input-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advance = self.__class__.advance(path + ["advance"], service)
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit an input parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/edit").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an input parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/delete").execute(*args, **kwargs)

                class advance(TUIMenu):
                    """
                    Define custom variable to use input parameter.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def list(self, *args, **kwargs):
                        """
                        List of custom-input-parameters.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/list").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete selected custom-input-parameters.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/delete").execute(*args, **kwargs)
                    def use_in(self, *args, **kwargs):
                        """
                        Use input parameter in solver-udf or in scheme-procedure.
                        """
                        return PyMenu(self.service, "/parameters__and__customization/parameters/input_parameters/advance/use_in").execute(*args, **kwargs)

            class list_parameters(TUIMenu):
                """
                Enter list-param menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def input_parameters(self, *args, **kwargs):
                    """
                    List all input parameters.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/list_parameters/input_parameters").execute(*args, **kwargs)
                def output_parameters(self, *args, **kwargs):
                    """
                    List all output parameters.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/list_parameters/output_parameters").execute(*args, **kwargs)

            class output_parameters(TUIMenu):
                """
                Enter the output-parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_all_to_file(self, *args, **kwargs):
                    """
                    Write all parameter values to file.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/write_all_to_file").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/delete").execute(*args, **kwargs)
                def create(self, *args, **kwargs):
                    """
                    Create an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/create").execute(*args, **kwargs)
                def write_to_file(self, *args, **kwargs):
                    """
                    Write parameter value to file.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/write_to_file").execute(*args, **kwargs)
                def rename(self, *args, **kwargs):
                    """
                    Rename an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/rename").execute(*args, **kwargs)
                def print_to_console(self, *args, **kwargs):
                    """
                    Print parameter value to console.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/print_to_console").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an output parameter.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/edit").execute(*args, **kwargs)
                def print_all_to_console(self, *args, **kwargs):
                    """
                    Print all parameter values to console.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/parameters/output_parameters/print_all_to_console").execute(*args, **kwargs)

        class user_defined(TUIMenu):
            """
            Enter the user-defined functions and scalars menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.real_gas_models = self.__class__.real_gas_models(path + ["real_gas_models"], service)
                super().__init__(path, service)
            def user_defined_node_memory(self, *args, **kwargs):
                """
                Allocate user-defined node memory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_node_memory").execute(*args, **kwargs)
            def one_D_coupling(self, *args, **kwargs):
                """
                Load 1D library.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/one_D_coupling").execute(*args, **kwargs)
            def use_built_in_compiler(self, *args, **kwargs):
                """
                Enable/disable the use of the built-in compiler.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/use_built_in_compiler").execute(*args, **kwargs)
            def fan_model(self, *args, **kwargs):
                """
                Configure user-defined fan model.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/fan_model").execute(*args, **kwargs)
            def user_defined_scalars(self, *args, **kwargs):
                """
                Define user-defined scalars.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_scalars").execute(*args, **kwargs)
            def interpreted_functions(self, *args, **kwargs):
                """
                Load interpreted user-defined functions.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/interpreted_functions").execute(*args, **kwargs)
            def enable_udf_on_gpu(self, *args, **kwargs):
                """
                Compile UDFs with OpenCL support.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/enable_udf_on_gpu").execute(*args, **kwargs)
            def user_defined_memory(self, *args, **kwargs):
                """
                Allocate user-defined memory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/user_defined_memory").execute(*args, **kwargs)
            def function_hooks(self, *args, **kwargs):
                """
                Hook up user-defined functions.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/function_hooks").execute(*args, **kwargs)
            def execute_on_demand(self, *args, **kwargs):
                """
                Execute UDFs on demand.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/execute_on_demand").execute(*args, **kwargs)
            def compile_customized_addon_module(self, *args, **kwargs):
                """
                Compile customized addon module?.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/compile_customized_addon_module").execute(*args, **kwargs)
            def auto_compile_compiled_udfs(self, *args, **kwargs):
                """
                For this Fluent session, specify whether to allow auto-compilation of compiled UDF when a case file (or settings file) is read.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/auto_compile_compiled_udfs").execute(*args, **kwargs)
            def compiled_functions(self, *args, **kwargs):
                """
                Open user-defined function library.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/compiled_functions").execute(*args, **kwargs)
            def use_contributed_cpp(self, *args, **kwargs):
                """
                Enable/disable use of cpp from the Fluent.Inc/contrib directory.
                """
                return PyMenu(self.service, "/parameters__and__customization/user_defined/use_contributed_cpp").execute(*args, **kwargs)

            class real_gas_models(TUIMenu):
                """
                Enable/configure real gas model.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def user_defined_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Load user-defined multispecies real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/user_defined_multispecies_real_gas_model").execute(*args, **kwargs)
                def user_defined_real_gas_model(self, *args, **kwargs):
                    """
                    Load user-defined real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/user_defined_real_gas_model").execute(*args, **kwargs)
                def nist_real_gas_model(self, *args, **kwargs):
                    """
                    Load NIST real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_real_gas_model").execute(*args, **kwargs)
                def nist_multispecies_real_gas_model(self, *args, **kwargs):
                    """
                    Load NIST real gas library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_multispecies_real_gas_model").execute(*args, **kwargs)
                def set_state(self, *args, **kwargs):
                    """
                    Select state for NIST real gas model.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/set_state").execute(*args, **kwargs)
                def nist_settings(self, *args, **kwargs):
                    """
                    Select refprop library.
                    """
                    return PyMenu(self.service, "/parameters__and__customization/user_defined/real_gas_models/nist_settings").execute(*args, **kwargs)

    class solve(TUIMenu):
        """
        Enter the solve menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.report_files = self.__class__.report_files(path + ["report_files"], service)
            self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
            self.monitors = self.__class__.monitors(path + ["monitors"], service)
            self.initialize = self.__class__.initialize(path + ["initialize"], service)
            self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
            self.cell_registers = self.__class__.cell_registers(path + ["cell_registers"], service)
            self.animate = self.__class__.animate(path + ["animate"], service)
            self.set = self.__class__.set(path + ["set"], service)
            self.execute_commands = self.__class__.execute_commands(path + ["execute_commands"], service)
            self.cell_register_operations = self.__class__.cell_register_operations(path + ["cell_register_operations"], service)
            super().__init__(path, service)
        def iterate_steady_2way_fsi(self, *args, **kwargs):
            """
            Perform a specified number of steps.
            """
            return PyMenu(self.service, "/solve/iterate_steady_2way_fsi").execute(*args, **kwargs)
        def dpm_update(self, *args, **kwargs):
            """
            Updates discrete phase source terms.
            """
            return PyMenu(self.service, "/solve/dpm_update").execute(*args, **kwargs)
        def patch(self, *args, **kwargs):
            """
            Patches a value for a flow variable in the domain. You can either provide a numerical value, which you can enter directly, or you can enter an expression, which must be entered within quotation marks.
            """
            return PyMenu(self.service, "/solve/patch").execute(*args, **kwargs)
        def iterate(self, *args, **kwargs):
            """
            Performs a specified number of iterations.  This option is still available during transient simulations, since it can be used to add more iterations to the same time step after interrupting iterations within a time step.
            """
            return PyMenu(self.service, "/solve/iterate").execute(*args, **kwargs)
        def multistage_time_iterate(self, *args, **kwargs):
            """
            Perform unsteady iterations.
            """
            return PyMenu(self.service, "/solve/multistage_time_iterate").execute(*args, **kwargs)
        def mesh_motion(self, *args, **kwargs):
            """
            Performs mesh motion.
            """
            return PyMenu(self.service, "/solve/mesh_motion").execute(*args, **kwargs)
        def convergence_conditions(self, *args, **kwargs):
            """
            Enters the convergence conditions menu.
            """
            return PyMenu(self.service, "/solve/convergence_conditions").execute(*args, **kwargs)
        def update_physical_time(self, *args, **kwargs):
            """
            Advances the unsteady solution to the next physical time level. Using this command in conjunction with theiterate command allows you to manually advance the solution in time (rather than doing it automatically with the dual-time-iterate command).
            """
            return PyMenu(self.service, "/solve/update_physical_time").execute(*args, **kwargs)
        def dual_time_iterate(self, *args, **kwargs):
            """
            Performs unsteady iterations for a specified number of time steps.
            """
            return PyMenu(self.service, "/solve/dual_time_iterate").execute(*args, **kwargs)

        class report_files(TUIMenu):
            """
            Enters the report files menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list(self, *args, **kwargs):
                """
                Lists all defined report files.
                """
                return PyMenu(self.service, "/solve/report_files/list").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report file.
                """
                return PyMenu(self.service, "/solve/report_files/add").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report file object.
                """
                return PyMenu(self.service, "/solve/report_files/delete").execute(*args, **kwargs)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report file.
                """
                return PyMenu(self.service, "/solve/report_files/clear_data").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report file.
                """
                return PyMenu(self.service, "/solve/report_files/list_properties").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report file.
                """
                return PyMenu(self.service, "/solve/report_files/edit").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report file objects.
                """
                return PyMenu(self.service, "/solve/report_files/delete_all").execute(*args, **kwargs)

        class report_definitions(TUIMenu):
            """
            Enters the report definitions menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def edit(self, *args, **kwargs):
                """
                Edits a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/list_properties").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/delete").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solve/report_definitions/add").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Creates a copy of a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/copy").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report definition objects.
                """
                return PyMenu(self.service, "/solve/report_definitions/delete_all").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report definitions.
                """
                return PyMenu(self.service, "/solve/report_definitions/list").execute(*args, **kwargs)
            def rename(self, *args, **kwargs):
                """
                Renames a report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/rename").execute(*args, **kwargs)
            def compute(self, *args, **kwargs):
                """
                Computes selected report definition.
                """
                return PyMenu(self.service, "/solve/report_definitions/compute").execute(*args, **kwargs)

        class monitors(TUIMenu):
            """
            Sets solution monitors.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_plots = self.__class__.report_plots(path + ["report_plots"], service)
                self.report_files = self.__class__.report_files(path + ["report_files"], service)
                self.residual = self.__class__.residual(path + ["residual"], service)
                super().__init__(path, service)
            def convergence_conditions(self, *args, **kwargs):
                """
                Manage convergence report.
                """
                return PyMenu(self.service, "/solve/monitors/convergence_conditions").execute(*args, **kwargs)
            def set_average_over(self, *args, **kwargs):
                """
                Set the average over input for monitors.
                """
                return PyMenu(self.service, "/solve/monitors/set_average_over").execute(*args, **kwargs)

            class report_plots(TUIMenu):
                """
                Manage report plots.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def clear_data(self, *args, **kwargs):
                    """
                    Clear report plot data.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/clear_data").execute(*args, **kwargs)
                def curves(self, *args, **kwargs):
                    """
                    Set curves options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/curves").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list_properties").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/edit").execute(*args, **kwargs)
                def axes(self, *args, **kwargs):
                    """
                    Set axes options of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/axes").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Plot.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/plot").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all plot objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete_all").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/add").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/list").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_plots/delete").execute(*args, **kwargs)

            class report_files(TUIMenu):
                """
                Manage report files.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def edit(self, *args, **kwargs):
                    """
                    Edit an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/edit").execute(*args, **kwargs)
                def list_properties(self, *args, **kwargs):
                    """
                    List properties of an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list_properties").execute(*args, **kwargs)
                def clear_data(self, *args, **kwargs):
                    """
                    Delete the report file from the system.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/clear_data").execute(*args, **kwargs)
                def delete_all(self, *args, **kwargs):
                    """
                    Delete all report file objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete_all").execute(*args, **kwargs)
                def list(self, *args, **kwargs):
                    """
                    List objects.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/list").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Delete an object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/delete").execute(*args, **kwargs)
                def add(self, *args, **kwargs):
                    """
                    Add a new object.
                    """
                    return PyMenu(self.service, "/solve/monitors/report_files/add").execute(*args, **kwargs)

            class residual(TUIMenu):
                """
                Enters the residual monitors menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def n_maximize_norms(self, *args, **kwargs):
                    """
                    Sets the number of iterations through which normalization factors will be maximized.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_maximize_norms").execute(*args, **kwargs)
                def relative_conv_criteria(self, *args, **kwargs):
                    """
                    Sets relative convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/relative_conv_criteria").execute(*args, **kwargs)
                def scale_by_coefficient(self, *args, **kwargs):
                    """
                    Chooses whether to scale residuals by coefficient sum in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/scale_by_coefficient").execute(*args, **kwargs)
                def n_save(self, *args, **kwargs):
                    """
                    Sets number of residuals to be saved with data. History is automatically compacted when buffer becomes full.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_save").execute(*args, **kwargs)
                def n_display(self, *args, **kwargs):
                    """
                    Sets the number of most recent residuals to display in plots.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/n_display").execute(*args, **kwargs)
                def reset(self, *args, **kwargs):
                    """
                    Chooses whether to delete the residual history and reset iteration counter to 1.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/reset").execute(*args, **kwargs)
                def check_convergence(self, *args, **kwargs):
                    """
                    Chooses which currently monitored residuals should be checked for convergence.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/check_convergence").execute(*args, **kwargs)
                def enhanced_continuity_residual(self, *args, **kwargs):
                    """
                    Enables/disables an enhanced formulation for the local scaling of the continuity residuals with the pressure-based solver, so that the absolute mass flow rate at each cell is used. This text command is only available when the computing of the local scale is enabled through the solve/monitors/residual/scale-by-coefficient? text command.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/enhanced_continuity_residual").execute(*args, **kwargs)
                def convergence_criteria(self, *args, **kwargs):
                    """
                    Sets convergence criteria for residuals that are currently being both monitored and checked.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/convergence_criteria").execute(*args, **kwargs)
                def normalize(self, *args, **kwargs):
                    """
                    Chooses whether to normalize residuals in printed and plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalize").execute(*args, **kwargs)
                def print(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be printed during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/print").execute(*args, **kwargs)
                def plot(self, *args, **kwargs):
                    """
                    Chooses whether residuals will be plotted during iteration.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/plot").execute(*args, **kwargs)
                def re_normalize(self, *args, **kwargs):
                    """
                    Re-normalize residuals by maximum values.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/re_normalize").execute(*args, **kwargs)
                def monitor(self, *args, **kwargs):
                    """
                    Chooses which residuals to monitor as printed and/or plotted output.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/monitor").execute(*args, **kwargs)
                def criterion_type(self, *args, **kwargs):
                    """
                    Sets convergence criterion type.
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/criterion_type").execute(*args, **kwargs)
                def normalization_factors(self, *args, **kwargs):
                    """
                    Sets normalization factors for currently monitored residuals (if normalize? is set to yes).
                    """
                    return PyMenu(self.service, "/solve/monitors/residual/normalization_factors").execute(*args, **kwargs)

        class initialize(TUIMenu):
            """
            Enters the flow initialization menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mp_localized_turb_init = self.__class__.mp_localized_turb_init(path + ["mp_localized_turb_init"], service)
                self.set_fmg_options = self.__class__.set_fmg_options(path + ["set_fmg_options"], service)
                self.vof_patch_smooth_options = self.__class__.vof_patch_smooth_options(path + ["vof_patch_smooth_options"], service)
                self.compute_defaults = self.__class__.compute_defaults(path + ["compute_defaults"], service)
                super().__init__(path, service)
            def initialize_flow(self, *args, **kwargs):
                """
                Initializes the flow field with the current default values.
                """
                return PyMenu(self.service, "/solve/initialize/initialize_flow").execute(*args, **kwargs)
            def init_turb_vel_fluctuations(self, *args, **kwargs):
                """
                Initializes instantaneous velocity field out of steady state RANS results, for use before enabling a scale resolving simulation such as LES.
                """
                return PyMenu(self.service, "/solve/initialize/init_turb_vel_fluctuations").execute(*args, **kwargs)
            def list_defaults(self, *args, **kwargs):
                """
                Lists default values.
                """
                return PyMenu(self.service, "/solve/initialize/list_defaults").execute(*args, **kwargs)
            def init_acoustics_options(self, *args, **kwargs):
                """
                Specifies the number of timesteps for ramping of sound sources and re-initializes the acoustics wave equation solution. For the initialized acoustics solution, Fluent reports the current state of the sound sources ramping.
                """
                return PyMenu(self.service, "/solve/initialize/init_acoustics_options").execute(*args, **kwargs)
            def lwf_initialization(self, *args, **kwargs):
                """
                Deletes wall film particles and initializes wall film variables to zero. This option is available only with the wall-film DPM boundary condition.
                """
                return PyMenu(self.service, "/solve/initialize/lwf_initialization").execute(*args, **kwargs)
            def open_channel_auto_init(self, *args, **kwargs):
                """
                Opens channel automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/open_channel_auto_init").execute(*args, **kwargs)
            def fmg_initialization(self, *args, **kwargs):
                """
                Initializes using the full-multigrid initialization (FMG).
                """
                return PyMenu(self.service, "/solve/initialize/fmg_initialization").execute(*args, **kwargs)
            def set_hyb_initialization(self, *args, **kwargs):
                """
                Enters the hybrid initialization menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_hyb_initialization").execute(*args, **kwargs)
            def set_fmg_initialization(self, *args, **kwargs):
                """
                Enters the set full-multigrid for initialization menu. Initial values for each variable can be set within this menu.
                """
                return PyMenu(self.service, "/solve/initialize/set_fmg_initialization").execute(*args, **kwargs)
            def repair_wall_distance(self, *args, **kwargs):
                """
                Corrects wall distance at very high aspect ratio hexahedral/polyhedral cells.
                """
                return PyMenu(self.service, "/solve/initialize/repair_wall_distance").execute(*args, **kwargs)
            def show_time_sampled(self, *args, **kwargs):
                """
                Displays the amount of simulated time covered by the data sampled for unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_time_sampled").execute(*args, **kwargs)
            def set_defaults(self, *args, **kwargs):
                """
                Sets default initial values.
                """
                return PyMenu(self.service, "/solve/initialize/set_defaults").execute(*args, **kwargs)
            def hyb_initialization(self, *args, **kwargs):
                """
                Initializes using the hybrid initialization method.
                """
                return PyMenu(self.service, "/solve/initialize/hyb_initialization").execute(*args, **kwargs)
            def patch(self, *args, **kwargs):
                """
                Patch a value for a flow variable in the domain.
                """
                return PyMenu(self.service, "/solve/initialize/patch").execute(*args, **kwargs)
            def init_flow_statistics(self, *args, **kwargs):
                """
                Initializes unsteady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/init_flow_statistics").execute(*args, **kwargs)
            def dpm_reset(self, *args, **kwargs):
                """
                Resets discrete phase source terms to zero.
                """
                return PyMenu(self.service, "/solve/initialize/dpm_reset").execute(*args, **kwargs)
            def reference_frame(self, *args, **kwargs):
                """
                Sets reference frame to absolute or relative.
                """
                return PyMenu(self.service, "/solve/initialize/reference_frame").execute(*args, **kwargs)
            def levelset_auto_init(self, *args, **kwargs):
                """
                Levelset function automatic initialization.
                """
                return PyMenu(self.service, "/solve/initialize/levelset_auto_init").execute(*args, **kwargs)
            def show_iterations_sampled(self, *args, **kwargs):
                """
                Displays the number of iterations covered by the data sampled for steady statistics.
                """
                return PyMenu(self.service, "/solve/initialize/show_iterations_sampled").execute(*args, **kwargs)

            class mp_localized_turb_init(TUIMenu):
                """
                Enters the menu for localized turbulent flow initialization.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables localized initialization of turbulent flow variables.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/enable").execute(*args, **kwargs)
                def turb_init_parameters(self, *args, **kwargs):
                    """
                    Sets values for the turbulent intensity and turbulent viscosity ratio for localized initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/mp_localized_turb_init/turb_init_parameters").execute(*args, **kwargs)

            class set_fmg_options(TUIMenu):
                """
                Enter the full-multigrid option menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def viscous_terms(self, *args, **kwargs):
                    """
                    Enable/disable viscous terms during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/viscous_terms").execute(*args, **kwargs)
                def species_reactions(self, *args, **kwargs):
                    """
                    Enable/disable species volumetric reactions during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/species_reactions").execute(*args, **kwargs)
                def set_turbulent_viscosity_ratio(self, *args, **kwargs):
                    """
                    Set turbulent viscosity ratio used during FMG initialization.
                    """
                    return PyMenu(self.service, "/solve/initialize/set_fmg_options/set_turbulent_viscosity_ratio").execute(*args, **kwargs)

            class vof_patch_smooth_options(TUIMenu):
                """
                Enters the vof patch/smooth options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_options(self, *args, **kwargs):
                    """
                    Sets options for patching and smoothing volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/set_options").execute(*args, **kwargs)
                def execute_smoothing(self, *args, **kwargs):
                    """
                    Execute volumetric smoothing for volume fraction.
                    """
                    return PyMenu(self.service, "/solve/initialize/vof_patch_smooth_options/execute_smoothing").execute(*args, **kwargs)

            class compute_defaults(TUIMenu):
                """
                Enters the compute default values menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def radiator(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/radiator").execute(*args, **kwargs)
                def recirculation_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_outlet").execute(*args, **kwargs)
                def axis(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/axis").execute(*args, **kwargs)
                def intake_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/intake_fan").execute(*args, **kwargs)
                def solid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/solid").execute(*args, **kwargs)
                def overset(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/overset").execute(*args, **kwargs)
                def network_end(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/network_end").execute(*args, **kwargs)
                def pressure_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_inlet").execute(*args, **kwargs)
                def periodic(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/periodic").execute(*args, **kwargs)
                def mass_flow_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/mass_flow_outlet").execute(*args, **kwargs)
                def fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/fan").execute(*args, **kwargs)
                def pressure_far_field(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_far_field").execute(*args, **kwargs)
                def symmetry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/symmetry").execute(*args, **kwargs)
                def inlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/inlet_vent").execute(*args, **kwargs)
                def rans_les_interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/rans_les_interface").execute(*args, **kwargs)
                def all_zones(self, *args, **kwargs):
                    """
                    Initializes the flow field with the default values.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/all_zones").execute(*args, **kwargs)
                def velocity_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/velocity_inlet").execute(*args, **kwargs)
                def recirculation_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/recirculation_inlet").execute(*args, **kwargs)
                def geometry(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/geometry").execute(*args, **kwargs)
                def wall(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/wall").execute(*args, **kwargs)
                def network(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/network").execute(*args, **kwargs)
                def exhaust_fan(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/exhaust_fan").execute(*args, **kwargs)
                def mass_flow_inlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/mass_flow_inlet").execute(*args, **kwargs)
                def dummy_entry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/dummy_entry").execute(*args, **kwargs)
                def degassing(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/degassing").execute(*args, **kwargs)
                def shadow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/shadow").execute(*args, **kwargs)
                def interior(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/interior").execute(*args, **kwargs)
                def outflow(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/outflow").execute(*args, **kwargs)
                def fluid(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/fluid").execute(*args, **kwargs)
                def outlet_vent(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/outlet_vent").execute(*args, **kwargs)
                def interface(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/interface").execute(*args, **kwargs)
                def pressure_outlet(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/pressure_outlet").execute(*args, **kwargs)
                def porous_jump(self, *args, **kwargs):
                    """
                    Compute flow-initialization defaults from a zone of this type.
                    """
                    return PyMenu(self.service, "/solve/initialize/compute_defaults/porous_jump").execute(*args, **kwargs)

        class report_plots(TUIMenu):
            """
            Enters the report plots menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def clear_data(self, *args, **kwargs):
                """
                Clears the data associated with a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/clear_data").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a report plot object.
                """
                return PyMenu(self.service, "/solve/report_plots/delete").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Defines the curves for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/curves").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Defines the axes for a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/axes").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/list_properties").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Deletes all of the report plot objects.
                """
                return PyMenu(self.service, "/solve/report_plots/delete_all").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Creates a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/add").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits a report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/edit").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plots the specified report plot.
                """
                return PyMenu(self.service, "/solve/report_plots/plot").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all defined report plots.
                """
                return PyMenu(self.service, "/solve/report_plots/list").execute(*args, **kwargs)

        class cell_registers(TUIMenu):
            """
            Enters the cell registers menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def display(self, *args, **kwargs):
                """
                Displays a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/display").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/delete").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an object.
                """
                return PyMenu(self.service, "/solve/cell_registers/edit").execute(*args, **kwargs)
            def refine(self, *args, **kwargs):
                """
                Refine the mesh based on a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/refine").execute(*args, **kwargs)
            def adapt(self, *args, **kwargs):
                """
                Adapt cell register objects.
                """
                return PyMenu(self.service, "/solve/cell_registers/adapt").execute(*args, **kwargs)
            def apply_poor_mesh_numerics(self, *args, **kwargs):
                """
                Applies poor mesh numerics to the mesh of a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/apply_poor_mesh_numerics").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists all of the currently defined cell registers.
                """
                return PyMenu(self.service, "/solve/cell_registers/list").execute(*args, **kwargs)
            def coarsen(self, *args, **kwargs):
                """
                Coarsen the mesh based on a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/coarsen").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a cell register.
                """
                return PyMenu(self.service, "/solve/cell_registers/list_properties").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Add a new object.
                """
                return PyMenu(self.service, "/solve/cell_registers/add").execute(*args, **kwargs)

        class animate(TUIMenu):
            """
            Enters the animation menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.pulse = self.__class__.pulse(path + ["pulse"], service)
                self.define = self.__class__.define(path + ["define"], service)
                self.playback = self.__class__.playback(path + ["playback"], service)
                self.objects = self.__class__.objects(path + ["objects"], service)
                super().__init__(path, service)

            class pulse(TUIMenu):
                """
                Enter the pulse animation menu (only available when one or more particle track or pathline graphics objects are defined).
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.hardcopy = self.__class__.hardcopy(path + ["hardcopy"], service)
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def pulse_mode(self, *args, **kwargs):
                    """
                    Set whether the pulse is a single pulse or continuous.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/pulse_mode").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Select a pathline or particle track graphics object, specify whether you want to write a video file or picture files, and enter the destination directory for the files. Continuous pulse animations result in a 5 second video. Single pulse animations run for a full cycle.
                    """
                    return PyMenu(self.service, "/solve/animate/pulse/write").execute(*args, **kwargs)

                class hardcopy(TUIMenu):
                    """
                    Hardcopy options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.color_mode = self.__class__.color_mode(path + ["color_mode"], service)
                        self.driver = self.__class__.driver(path + ["driver"], service)
                        super().__init__(path, service)
                    def x_resolution(self, *args, **kwargs):
                        """
                        Set the width of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/x_resolution").execute(*args, **kwargs)
                    def jpeg_hardcopy_quality(self, *args, **kwargs):
                        """
                        To set jpeg hardcopy quality.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/jpeg_hardcopy_quality").execute(*args, **kwargs)
                    def invert_background(self, *args, **kwargs):
                        """
                        Use a white background when the picture is saved.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/invert_background").execute(*args, **kwargs)
                    def landscape(self, *args, **kwargs):
                        """
                        Plot hardcopies in landscape or portrait orientation.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/landscape").execute(*args, **kwargs)
                    def preview(self, *args, **kwargs):
                        """
                        Display a preview image of a hardcopy.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/preview").execute(*args, **kwargs)
                    def dpi(self, *args, **kwargs):
                        """
                        Set the DPI for EPS and Postscript files, specifies the resolution in dots per inch (DPI) instead of setting the width and height.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/dpi").execute(*args, **kwargs)
                    def use_window_resolution(self, *args, **kwargs):
                        """
                        Use the currently active window's resolution for hardcopy (ignores the x-resolution and y-resolution in this case).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/use_window_resolution").execute(*args, **kwargs)
                    def y_resolution(self, *args, **kwargs):
                        """
                        Set the height of raster-formatted images in pixels (0 implies current window size).
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/y_resolution").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/hardcopy/set_standard_resolution").execute(*args, **kwargs)

                    class color_mode(TUIMenu):
                        """
                        Enter the hardcopy color mode menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def list(self, *args, **kwargs):
                            """
                            Display the current hardcopy color mode.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/list").execute(*args, **kwargs)
                        def gray_scale(self, *args, **kwargs):
                            """
                            Convert color to grayscale for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/gray_scale").execute(*args, **kwargs)
                        def color(self, *args, **kwargs):
                            """
                            Plot hardcopies in color.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/color").execute(*args, **kwargs)
                        def mono_chrome(self, *args, **kwargs):
                            """
                            Convert color to monochrome (black and white) for hardcopy.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/color_mode/mono_chrome").execute(*args, **kwargs)

                    class driver(TUIMenu):
                        """
                        Enter the set hardcopy driver menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.post_format = self.__class__.post_format(path + ["post_format"], service)
                            super().__init__(path, service)
                        def post_script(self, *args, **kwargs):
                            """
                            Produce PostScript output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_script").execute(*args, **kwargs)
                        def glb(self, *args, **kwargs):
                            """
                            Use GLB output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/glb").execute(*args, **kwargs)
                        def png(self, *args, **kwargs):
                            """
                            Use PNG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/png").execute(*args, **kwargs)
                        def jpeg(self, *args, **kwargs):
                            """
                            Produce JPEG output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/jpeg").execute(*args, **kwargs)
                        def dump_window(self, *args, **kwargs):
                            """
                            Set the command used to dump the graphics window to a file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/dump_window").execute(*args, **kwargs)
                        def tiff(self, *args, **kwargs):
                            """
                            Use TIFF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/tiff").execute(*args, **kwargs)
                        def vrml(self, *args, **kwargs):
                            """
                            Use VRML output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/vrml").execute(*args, **kwargs)
                        def ppm(self, *args, **kwargs):
                            """
                            Produce PPM output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/ppm").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            List the current hardcopy driver.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/list").execute(*args, **kwargs)
                        def hsf(self, *args, **kwargs):
                            """
                            Use HSF output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/hsf").execute(*args, **kwargs)
                        def avz(self, *args, **kwargs):
                            """
                            Use AVZ output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/avz").execute(*args, **kwargs)
                        def eps(self, *args, **kwargs):
                            """
                            Produce encapsulated PostScript (EPS) output for hardcopies.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/eps").execute(*args, **kwargs)
                        def options(self, *args, **kwargs):
                            """
                            Set the hardcopy options. Available options are:
                            "no gamma correction", disables gamma correction of colors,
                            "physical size = (width,height)", where width and height
                            are the actual measurements of the printable area of the page
                            in centimeters.
                            "subscreen = (left,right,bottom,top)", where left,right,
                            bottom, and top are numbers in [-1,1] describing a subwindow on
                            the page in which to place the hardcopy.
                            The options may be combined by separating them with commas.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/options").execute(*args, **kwargs)

                        class post_format(TUIMenu):
                            """
                            Enter the PostScript driver format menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def fast_raster(self, *args, **kwargs):
                                """
                                Use the new raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/fast_raster").execute(*args, **kwargs)
                            def raster(self, *args, **kwargs):
                                """
                                Use the original raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/raster").execute(*args, **kwargs)
                            def vector(self, *args, **kwargs):
                                """
                                Use vector format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/vector").execute(*args, **kwargs)
                            def rle_raster(self, *args, **kwargs):
                                """
                                Use the run-length encoded raster format.
                                """
                                return PyMenu(self.service, "/solve/animate/pulse/hardcopy/driver/post_format/rle_raster").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enter the video window options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def fps(self, *args, **kwargs):
                        """
                        Set the Frame Per Sec(FPS) for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/fps").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/quality").execute(*args, **kwargs)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/height").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/width").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/set_standard_resolution").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Set scale by which video resolution will expand.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/scale").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Exporting video file name.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/name").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Set format for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/format").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Enable original resolution.
                        """
                        return PyMenu(self.service, "/solve/animate/pulse/video/use_original_resolution").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/compression_method").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/pulse/video/advance_quality/enable_h264").execute(*args, **kwargs)

            class define(TUIMenu):
                """
                Enters the animation definition menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def define_monitor(self, *args, **kwargs):
                    """
                    Defines new animation.
                    """
                    return PyMenu(self.service, "/solve/animate/define/define_monitor").execute(*args, **kwargs)
                def edit_monitor(self, *args, **kwargs):
                    """
                    Changes animation monitor attributes.
                    """
                    return PyMenu(self.service, "/solve/animate/define/edit_monitor").execute(*args, **kwargs)

            class playback(TUIMenu):
                """
                Enters the animation playback menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.video = self.__class__.video(path + ["video"], service)
                    super().__init__(path, service)
                def play(self, *args, **kwargs):
                    """
                    Plays the selected animation.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/play").execute(*args, **kwargs)
                def read(self, *args, **kwargs):
                    """
                    Reads new animation from file or already defined animations.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/read").execute(*args, **kwargs)
                def set_custom_frames(self, *args, **kwargs):
                    """
                    Specify a custom start frame, increment, and end frame for video export.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/set_custom_frames").execute(*args, **kwargs)
                def stored_view(self, *args, **kwargs):
                    """
                    Plays the 3D animation sequence using the view stored in the sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/stored_view").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes animation sequence.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/delete").execute(*args, **kwargs)
                def write(self, *args, **kwargs):
                    """
                    Writes animation sequence to the file.
                    """
                    return PyMenu(self.service, "/solve/animate/playback/write").execute(*args, **kwargs)

                class video(TUIMenu):
                    """
                    Enters the video menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.advance_quality = self.__class__.advance_quality(path + ["advance_quality"], service)
                        super().__init__(path, service)
                    def height(self, *args, **kwargs):
                        """
                        Set the height for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/height").execute(*args, **kwargs)
                    def quality(self, *args, **kwargs):
                        """
                        Set quality for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/quality").execute(*args, **kwargs)
                    def format(self, *args, **kwargs):
                        """
                        Specifies what format the video file will be written in (MP4 | AVI |  FLV | MOV | MPEG).
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/format").execute(*args, **kwargs)
                    def use_original_resolution(self, *args, **kwargs):
                        """
                        Controls whether the resolution of the saved video file matches that  of the images used to create it.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/use_original_resolution").execute(*args, **kwargs)
                    def name(self, *args, **kwargs):
                        """
                        Sets the name of the saved video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/name").execute(*args, **kwargs)
                    def set_standard_resolution(self, *args, **kwargs):
                        """
                        Select from pre-defined resolution list.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/set_standard_resolution").execute(*args, **kwargs)
                    def width(self, *args, **kwargs):
                        """
                        Set the width for exporting video file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/width").execute(*args, **kwargs)
                    def scale(self, *args, **kwargs):
                        """
                        Expands or collapses the resolution based on this scaling  factor.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/scale").execute(*args, **kwargs)
                    def fps(self, *args, **kwargs):
                        """
                        Sets the target frames per second (FPS) for the saved video  file.
                        """
                        return PyMenu(self.service, "/solve/animate/playback/video/fps").execute(*args, **kwargs)

                    class advance_quality(TUIMenu):
                        """
                        Advance Quality setting.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def bitrate(self, *args, **kwargs):
                            """
                            Set video bitrate(kbits/sec) for exporting video file.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate").execute(*args, **kwargs)
                        def bitrate_scale(self, *args, **kwargs):
                            """
                            Mp4 bitrate scale - Best-64000 High-32000 Medium-16000 Low-8000.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/bitrate_scale").execute(*args, **kwargs)
                        def enable_h264(self, *args, **kwargs):
                            """
                            H264 encoding flag.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/enable_h264").execute(*args, **kwargs)
                        def compression_method(self, *args, **kwargs):
                            """
                            Compression methode for Microsoft AVI movie.
                            """
                            return PyMenu(self.service, "/solve/animate/playback/video/advance_quality/compression_method").execute(*args, **kwargs)

            class objects(TUIMenu):
                """
                Enters the object manipulation menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def create(self, *args, **kwargs):
                    """
                    Creates new solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/create").execute(*args, **kwargs)
                def clear_history(self, *args, **kwargs):
                    """
                    Clears solution animation object history.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/clear_history").execute(*args, **kwargs)
                def delete(self, *args, **kwargs):
                    """
                    Deletes solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/delete").execute(*args, **kwargs)
                def copy(self, *args, **kwargs):
                    """
                    Copies solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/copy").execute(*args, **kwargs)
                def edit(self, *args, **kwargs):
                    """
                    Edits solution animation object.
                    """
                    return PyMenu(self.service, "/solve/animate/objects/edit").execute(*args, **kwargs)

        class set(TUIMenu):
            """
            Enters the set solution parameters menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.pseudo_time_method = self.__class__.pseudo_time_method(path + ["pseudo_time_method"], service)
                self.multiphase_numerics = self.__class__.multiphase_numerics(path + ["multiphase_numerics"], service)
                self.high_order_term_relaxation = self.__class__.high_order_term_relaxation(path + ["high_order_term_relaxation"], service)
                self.transient_controls = self.__class__.transient_controls(path + ["transient_controls"], service)
                self.open_channel_wave_options = self.__class__.open_channel_wave_options(path + ["open_channel_wave_options"], service)
                self.acoustics_wave_equation_controls = self.__class__.acoustics_wave_equation_controls(path + ["acoustics_wave_equation_controls"], service)
                self.overset = self.__class__.overset(path + ["overset"], service)
                self.data_sampling_options = self.__class__.data_sampling_options(path + ["data_sampling_options"], service)
                self.fast_transient_settings = self.__class__.fast_transient_settings(path + ["fast_transient_settings"], service)
                self.advanced = self.__class__.advanced(path + ["advanced"], service)
                self.warped_face_gradient_correction = self.__class__.warped_face_gradient_correction(path + ["warped_face_gradient_correction"], service)
                self.previous_defaults = self.__class__.previous_defaults(path + ["previous_defaults"], service)
                self.contact_solution_controls = self.__class__.contact_solution_controls(path + ["contact_solution_controls"], service)
                self.amg_options = self.__class__.amg_options(path + ["amg_options"], service)
                self.poor_mesh_numerics = self.__class__.poor_mesh_numerics(path + ["poor_mesh_numerics"], service)
                self.high_speed_numerics = self.__class__.high_speed_numerics(path + ["high_speed_numerics"], service)
                self.enhanced_les_numerics = self.__class__.enhanced_les_numerics(path + ["enhanced_les_numerics"], service)
                self.nita_expert_controls = self.__class__.nita_expert_controls(path + ["nita_expert_controls"], service)
                self.divergence_prevention = self.__class__.divergence_prevention(path + ["divergence_prevention"], service)
                super().__init__(path, service)
            def p_v_controls_advanced(self, *args, **kwargs):
                """
                Set advanced pressure-velocity coupling controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls_advanced").execute(*args, **kwargs)
            def second_order_time_options(self, *args, **kwargs):
                """
                Enables / disables the variable time step size formulation for second-order implicit transient formulations. If you disable the variable time step size formulation, note that any change in the time step size will introduce an error proportional to the change in the time step size ratio.
                """
                return PyMenu(self.service, "/solve/set/second_order_time_options").execute(*args, **kwargs)
            def cfl_based_adaptive_time_stepping(self, *args, **kwargs):
                """
                Set CFL-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/cfl_based_adaptive_time_stepping").execute(*args, **kwargs)
            def max_corrections(self, *args, **kwargs):
                """
                Enters the max-corrections menu.
                """
                return PyMenu(self.service, "/solve/set/max_corrections").execute(*args, **kwargs)
            def equation_ordering(self, *args, **kwargs):
                """
                Sets the order in which the model equations are solved, which can affect the convergence speed when you are using the pressure-based solver. The standard method is enabled by default and corresponds to the ordering shown in  and  in the Theory Guide; alternatively, you can select theoptimized-for-volumetric-expansion method, which is recommended for flows in which the density is strongly dependent on thermal effects, chemical composition, and so on (such as combustion simulations). This text command is not available for steady simulations and/or when a multiphase model is enabled.
                """
                return PyMenu(self.service, "/solve/set/equation_ordering").execute(*args, **kwargs)
            def reduced_rank_extrapolation(self, *args, **kwargs):
                """
                Enable Reduced Rank Extrapolation method to accelerate solution time.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation").execute(*args, **kwargs)
            def solution_steering(self, *args, **kwargs):
                """
                Enables solution steering for the density-based solver.
                """
                return PyMenu(self.service, "/solve/set/solution_steering").execute(*args, **kwargs)
            def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                """
                Enables convergence acceleration for stretched meshes to improve the convergence of the implicit density based solver on meshes with high cell stretching.
                """
                return PyMenu(self.service, "/solve/set/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
            def courant_number(self, *args, **kwargs):
                """
                Sets the fine-grid Courant number (time step factor). This command is available only for the coupled solvers.
                """
                return PyMenu(self.service, "/solve/set/courant_number").execute(*args, **kwargs)
            def stiff_chemistry(self, *args, **kwargs):
                """
                Sets solver options for stiff chemistry solutions.
                """
                return PyMenu(self.service, "/solve/set/stiff_chemistry").execute(*args, **kwargs)
            def limiter_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when quantities are being limited. By default, limiter warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/limiter_warnings").execute(*args, **kwargs)
            def mp_mfluid_aniso_drag(self, *args, **kwargs):
                """
                Sets anisotropic drag parameters for the Eulerian multiphase model.
                """
                return PyMenu(self.service, "/solve/set/mp_mfluid_aniso_drag").execute(*args, **kwargs)
            def multi_stage(self, *args, **kwargs):
                """
                Sets the multi-stage coefficients and the dissipation and viscous evaluation stages. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_stage").execute(*args, **kwargs)
            def material_property_warnings(self, *args, **kwargs):
                """
                Control the display of material property warning diagnostics:
                0 - off (no messages)
                1 - messages per material
                2 - messages per material and per property.
                """
                return PyMenu(self.service, "/solve/set/material_property_warnings").execute(*args, **kwargs)
            def variable_time_stepping(self, *args, **kwargs):
                """
                Set Multiphase-Specific Adaptive time stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/variable_time_stepping").execute(*args, **kwargs)
            def numerics(self, *args, **kwargs):
                """
                Sets numerics options.
                """
                return PyMenu(self.service, "/solve/set/numerics").execute(*args, **kwargs)
            def p_v_controls(self, *args, **kwargs):
                """
                Sets pressure-velocity controls.
                """
                return PyMenu(self.service, "/solve/set/p_v_controls").execute(*args, **kwargs)
            def flux_type(self, *args, **kwargs):
                """
                Enter the flux type.
                """
                return PyMenu(self.service, "/solve/set/flux_type").execute(*args, **kwargs)
            def reactions(self, *args, **kwargs):
                """
                Enables the species reaction sources and sets relaxation factor.
                """
                return PyMenu(self.service, "/solve/set/reactions").execute(*args, **kwargs)
            def flow_warnings(self, *args, **kwargs):
                """
                Specifies whether or not to print warning messages when reversed flow occurs at inlets and outlets, and when mass-flow inlets develop supersonic regions. By default, flow warnings are printed.
                """
                return PyMenu(self.service, "/solve/set/flow_warnings").execute(*args, **kwargs)
            def lock_solid_temperature(self, *args, **kwargs):
                """
                Specifies whether you want to lock (or “freeze”) the temperature values for all the cells in solid zones (including those to which you have a hooked an energy source through a UDF) and in walls that have shell conduction enabled, so that the values do not change during further solver iterations.
                """
                return PyMenu(self.service, "/solve/set/lock_solid_temperature").execute(*args, **kwargs)
            def data_sampling(self, *args, **kwargs):
                """
                Enables data sampling for steady or unsteady flow statistics.
                """
                return PyMenu(self.service, "/solve/set/data_sampling").execute(*args, **kwargs)
            def surface_tension_expert(self, *args, **kwargs):
                """
                Set surface-tension expert options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension_expert").execute(*args, **kwargs)
            def set_solution_methods_to_default(self, *args, **kwargs):
                """
                Sets the solution methods to the default settings.
                """
                return PyMenu(self.service, "/solve/set/set_solution_methods_to_default").execute(*args, **kwargs)
            def reporting_interval(self, *args, **kwargs):
                """
                Sets the number of iterations for which convergence monitors are reported. The default is 1 (after every iteration).
                """
                return PyMenu(self.service, "/solve/set/reporting_interval").execute(*args, **kwargs)
            def multi_grid_controls(self, *args, **kwargs):
                """
                Sets multigrid parameters and termination criteria.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_controls").execute(*args, **kwargs)
            def moving_mesh_numerics(self, *args, **kwargs):
                """
                Transient options for sliding, moving, and/or dynamic mesh.
                """
                return PyMenu(self.service, "/solve/set/moving_mesh_numerics").execute(*args, **kwargs)
            def under_relaxation(self, *args, **kwargs):
                """
                Enters the under-relaxation menu, which allows you to set the under-relaxation factor for each equation that is being solved in a segregated manner.
                """
                return PyMenu(self.service, "/solve/set/under_relaxation").execute(*args, **kwargs)
            def enable_output_dp_dt(self, *args, **kwargs):
                """
                Controls whether the output field variabledp-dt will be available for transient simulation postprocessing. If you select no, pressure fields at the previous time steps will not be stored in memory which reduces memory usage.
                """
                return PyMenu(self.service, "/solve/set/enable_output_dp_dt").execute(*args, **kwargs)
            def bc_pressure_extrapolations(self, *args, **kwargs):
                """
                Sets pressure extrapolations schemes on boundaries.
                """
                return PyMenu(self.service, "/solve/set/bc_pressure_extrapolations").execute(*args, **kwargs)
            def vof_explicit_controls(self, *args, **kwargs):
                """
                Sets the sub time step calculation method for VOF calculations.
                """
                return PyMenu(self.service, "/solve/set/vof_explicit_controls").execute(*args, **kwargs)
            def number_of_iterations(self, *args, **kwargs):
                """
                Sets the number of iterations for a steady-state simulation without starting the calculation.
                """
                return PyMenu(self.service, "/solve/set/number_of_iterations").execute(*args, **kwargs)
            def set_controls_to_default(self, *args, **kwargs):
                """
                Sets controls to default values.
                """
                return PyMenu(self.service, "/solve/set/set_controls_to_default").execute(*args, **kwargs)
            def gradient_scheme(self, *args, **kwargs):
                """
                Sets gradient options.
                """
                return PyMenu(self.service, "/solve/set/gradient_scheme").execute(*args, **kwargs)
            def nb_gradient_boundary_option(self, *args, **kwargs):
                """
                Switches between the modified treatment of node-based gradients at boundary cells and the legacy treatment (R14.5.7 and earlier). If using the density-based solver, you can also specify the extended treatment. For details, see .
                """
                return PyMenu(self.service, "/solve/set/nb_gradient_boundary_option").execute(*args, **kwargs)
            def relaxation_factor(self, *args, **kwargs):
                """
                Enters the relaxation-factor menu.
                """
                return PyMenu(self.service, "/solve/set/relaxation_factor").execute(*args, **kwargs)
            def reduced_rank_extrapolation_options(self, *args, **kwargs):
                """
                Reduced Rank Extrapolation options.
                """
                return PyMenu(self.service, "/solve/set/reduced_rank_extrapolation_options").execute(*args, **kwargs)
            def time_step(self, *args, **kwargs):
                """
                Set the time step.
                """
                return PyMenu(self.service, "/solve/set/time_step").execute(*args, **kwargs)
            def set_all_species_together(self, *args, **kwargs):
                """
                Sets all species discretizations and URFs together.
                """
                return PyMenu(self.service, "/solve/set/set_all_species_together").execute(*args, **kwargs)
            def numerical_beach_controls(self, *args, **kwargs):
                """
                Sets damping function in flow direction. This command appears only when the VOF model is enabled. Select the damping function to be used:
                Index
                Damping Function
                0
                Linear
                1
                Quadratic
                2
                Cubic
                3
                Cosine.
                """
                return PyMenu(self.service, "/solve/set/numerical_beach_controls").execute(*args, **kwargs)
            def multi_grid_fas(self, *args, **kwargs):
                """
                Sets the parameters that control the FAS multigrid solver. This command appears only when the explicit coupled solver is used.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_fas").execute(*args, **kwargs)
            def disable_reconstruction(self, *args, **kwargs):
                """
                Completely disables reconstruction, resulting in totally first-order accuracy.
                """
                return PyMenu(self.service, "/solve/set/disable_reconstruction").execute(*args, **kwargs)
            def discretization_scheme(self, *args, **kwargs):
                """
                Enters the discretization scheme menu. This allows you to select the discretization scheme for the convection terms in the solution equations. The following text commands can make a selection from a subset of the models in the following table:.
                """
                return PyMenu(self.service, "/solve/set/discretization_scheme").execute(*args, **kwargs)
            def accelerated_non_iterative_time_marching(self, *args, **kwargs):
                """
                Enables a modified NITA scheme and other setting changes that can speed up the simulation. This option is only available with the Large Eddy Simulation (LES) turbulence model, and is intended for unreacting flow simulations that use a constant-density fluid.
                """
                return PyMenu(self.service, "/solve/set/accelerated_non_iterative_time_marching").execute(*args, **kwargs)
            def slope_limiter_set(self, *args, **kwargs):
                """
                Selects a new Fluent solver slope limiter.
                """
                return PyMenu(self.service, "/solve/set/slope_limiter_set").execute(*args, **kwargs)
            def phase_based_vof_discretization(self, *args, **kwargs):
                """
                Sets phase based slope limiter for VOF compressive scheme.
                """
                return PyMenu(self.service, "/solve/set/phase_based_vof_discretization").execute(*args, **kwargs)
            def p_v_coupling(self, *args, **kwargs):
                """
                Selects which pressure-velocity coupling scheme is to be used. Five schemes are available:.
                """
                return PyMenu(self.service, "/solve/set/p_v_coupling").execute(*args, **kwargs)
            def multi_grid_amg(self, *args, **kwargs):
                """
                Sets the parameters that govern the algebraic multigrid procedure.
                """
                return PyMenu(self.service, "/solve/set/multi_grid_amg").execute(*args, **kwargs)
            def adaptive_time_stepping(self, *args, **kwargs):
                """
                Set Error-based adaptive time-stepping parameters.
                """
                return PyMenu(self.service, "/solve/set/adaptive_time_stepping").execute(*args, **kwargs)
            def open_channel_controls(self, *args, **kwargs):
                """
                For flows that do not transition from sub-critical to super-critical, or vice-versa, you can speed-up the solution calculation by updating the frequency of Froude number during run time.
                """
                return PyMenu(self.service, "/solve/set/open_channel_controls").execute(*args, **kwargs)
            def residual_tolerance(self, *args, **kwargs):
                """
                Enters the residual tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/residual_tolerance").execute(*args, **kwargs)
            def limits(self, *args, **kwargs):
                """
                Sets solver limits for various solution variables, in order to improve the stability of the solution.
                """
                return PyMenu(self.service, "/solve/set/limits").execute(*args, **kwargs)
            def surface_tension(self, *args, **kwargs):
                """
                Sets surface-tension calculation options.
                """
                return PyMenu(self.service, "/solve/set/surface_tension").execute(*args, **kwargs)
            def mp_reference_density(self, *args, **kwargs):
                """
                Sets the reference density method for the Eulerian multiphase model. The following options are available:
                0 (default): Averaged density of the phase
                1: Cell density of the phase
                1: Constant value of 1
                1: Cell density of the phase
                See  for more information.
                """
                return PyMenu(self.service, "/solve/set/mp_reference_density").execute(*args, **kwargs)
            def residual_smoothing(self, *args, **kwargs):
                """
                Sets the implicit residual smoothing parameters. This command is available only for the explicit coupled solver.
                """
                return PyMenu(self.service, "/solve/set/residual_smoothing").execute(*args, **kwargs)
            def set_solution_steering(self, *args, **kwargs):
                """
                Sets solution steering parameters.
                """
                return PyMenu(self.service, "/solve/set/set_solution_steering").execute(*args, **kwargs)
            def relaxation_method(self, *args, **kwargs):
                """
                Sets the solver relaxation method.
                """
                return PyMenu(self.service, "/solve/set/relaxation_method").execute(*args, **kwargs)
            def heterogeneous_stiff_chemistry(self, *args, **kwargs):
                """
                Sets the heterogeneous stiff-chemistry solver.
                """
                return PyMenu(self.service, "/solve/set/heterogeneous_stiff_chemistry").execute(*args, **kwargs)
            def vof_numerics(self, *args, **kwargs):
                """
                Sets VOF numeric options.
                """
                return PyMenu(self.service, "/solve/set/vof_numerics").execute(*args, **kwargs)
            def residual_verbosity(self, *args, **kwargs):
                """
                Sets the amount of residual information to be printed. A value of 0 (the default) prints residuals at the end of each fine grid iteration. A value of 1 prints residuals after every stage of the fine grid iteration. A value of 2 prints residuals after every stage on every grid level.
                """
                return PyMenu(self.service, "/solve/set/residual_verbosity").execute(*args, **kwargs)
            def expert(self, *args, **kwargs):
                """
                Sets expert options.
                """
                return PyMenu(self.service, "/solve/set/expert").execute(*args, **kwargs)
            def correction_tolerance(self, *args, **kwargs):
                """
                Enters the correction tolerance menu.
                """
                return PyMenu(self.service, "/solve/set/correction_tolerance").execute(*args, **kwargs)
            def equations(self, *args, **kwargs):
                """
                Selects the equations to be solved.
                """
                return PyMenu(self.service, "/solve/set/equations").execute(*args, **kwargs)

            class pseudo_time_method(TUIMenu):
                """
                Enters the pseudo time method menu. This menu is only available for cases that use a pressure-based segregated solver (SIMPLE, SIMPLEC, or PISO) or for steady-state cases that use the pressure-based coupled solver or the density-based implicit solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def relaxation_bounds(self, *args, **kwargs):
                    """
                    Select relaxation bounding scheme for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_bounds").execute(*args, **kwargs)
                def global_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time settings for the calculation when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/global_time_step_settings").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Sets the verbosity of the messages related to the pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/verbosity").execute(*args, **kwargs)
                def formulation(self, *args, **kwargs):
                    """
                    Enables and sets the pseudo time step size formulation or disables the pseudo time method option.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/formulation").execute(*args, **kwargs)
                def relaxation_factors(self, *args, **kwargs):
                    """
                    Enters the relaxation factors menu, where you can set the pseudo time explicit relaxation factors for individual equations. These factors only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_factors").execute(*args, **kwargs)
                def relaxation_method(self, *args, **kwargs):
                    """
                    Select relaxation definition for pseudo time method.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/relaxation_method").execute(*args, **kwargs)
                def convergence_acceleration_for_stretched_meshes(self, *args, **kwargs):
                    """
                    Enable convergence acceleration for stretched meshes to improve the convergence of the implicit pressure based solver on meshes with high cell stretching.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/convergence_acceleration_for_stretched_meshes").execute(*args, **kwargs)
                def advanced_options(self, *args, **kwargs):
                    """
                    Enters the advanced options menu, which allows you to enable / disable the pseudo time method for individual equations and define their pseudo time scale factors or under-relaxation factors, respectively. These settings only apply when the global time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/advanced_options").execute(*args, **kwargs)
                def local_time_step_settings(self, *args, **kwargs):
                    """
                    Defines the pseudo time Courant number when the local time step formulation is selected.
                    """
                    return PyMenu(self.service, "/solve/set/pseudo_time_method/local_time_step_settings").execute(*args, **kwargs)

            class multiphase_numerics(TUIMenu):
                """
                Sets multiphase numerics options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.default_controls = self.__class__.default_controls(path + ["default_controls"], service)
                    self.porous_media = self.__class__.porous_media(path + ["porous_media"], service)
                    self.advanced_stability_controls = self.__class__.advanced_stability_controls(path + ["advanced_stability_controls"], service)
                    self.viscous_flow = self.__class__.viscous_flow(path + ["viscous_flow"], service)
                    self.compressible_flow = self.__class__.compressible_flow(path + ["compressible_flow"], service)
                    self.boiling_parameters = self.__class__.boiling_parameters(path + ["boiling_parameters"], service)
                    self.face_pressure_controls = self.__class__.face_pressure_controls(path + ["face_pressure_controls"], service)
                    self.heat_mass_transfer = self.__class__.heat_mass_transfer(path + ["heat_mass_transfer"], service)
                    self.solution_stabilization = self.__class__.solution_stabilization(path + ["solution_stabilization"], service)
                    super().__init__(path, service)

                class default_controls(TUIMenu):
                    """
                    Enters the default controls menu. This menu is available only for multiphase flows.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def recommended_defaults_for_existing_cases(self, *args, **kwargs):
                        """
                        Applies the multiphase defaults (version 2020 R1) to the loaded case  file.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/recommended_defaults_for_existing_cases").execute(*args, **kwargs)
                    def revert_to_pre_r20_point_1_default_settings(self, *args, **kwargs):
                        """
                        Revert to pre-R20.1 multiphase flow default settings.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/default_controls/revert_to_pre_r20_point_1_default_settings").execute(*args, **kwargs)

                class porous_media(TUIMenu):
                    """
                    Enters the porous media numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def relative_permeability(self, *args, **kwargs):
                        """
                        Allows you to fix the saturation (volume fraction) of the phase at  its user-specified residual saturation value.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/relative_permeability").execute(*args, **kwargs)
                    def capillary_pressure_as_diffusion(self, *args, **kwargs):
                        """
                        Model capillary pressure as diffusion.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/porous_media/capillary_pressure_as_diffusion").execute(*args, **kwargs)

                class advanced_stability_controls(TUIMenu):
                    """
                    Enters the menu for the stability controls for multiphase flows. For more information about the below option, see  and .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.num_ventilation = self.__class__.num_ventilation(path + ["num_ventilation"], service)
                        self.hybrid_nita = self.__class__.hybrid_nita(path + ["hybrid_nita"], service)
                        self.anti_diffusion = self.__class__.anti_diffusion(path + ["anti_diffusion"], service)
                        self.equation_order = self.__class__.equation_order(path + ["equation_order"], service)
                        self.pseudo_time = self.__class__.pseudo_time(path + ["pseudo_time"], service)
                        self.p_v_coupling = self.__class__.p_v_coupling(path + ["p_v_coupling"], service)
                        super().__init__(path, service)

                    class num_ventilation(TUIMenu):
                        """
                        Numerical Ventilation Menu for VOF Model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def enable(self, *args, **kwargs):
                            """
                            Enable numerical ventilation treatment to remove trapped phase adjacent to wall.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/enable").execute(*args, **kwargs)
                        def near_wall_treatment_options(self, *args, **kwargs):
                            """
                            Set near wall treatment options.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/near_wall_treatment_options").execute(*args, **kwargs)
                        def trapped_phase_vof_min(self, *args, **kwargs):
                            """
                            Set trapped phase minimum volume fraction to activate numerical ventilation treatment for trapped phase.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_min").execute(*args, **kwargs)
                        def trapped_phase_vof_max(self, *args, **kwargs):
                            """
                            Set trapped phase maximum volume fraction to activate numerical ventilation treatment for non-trapped phases.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/trapped_phase_vof_max").execute(*args, **kwargs)
                        def tau_estimation_options(self, *args, **kwargs):
                            """
                            Set time step size option for numerical ventilation treatment.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/num_ventilation/tau_estimation_options").execute(*args, **kwargs)

                    class hybrid_nita(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.instability_detector = self.__class__.instability_detector(path + ["instability_detector"], service)
                            super().__init__(path, service)
                        def initial_outer_iterations(self, *args, **kwargs):
                            """
                            Allows you to change the number of initial time-steps and the number of initial outer iterations to control solution stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/initial_outer_iterations").execute(*args, **kwargs)
                        def outer_iterations(self, *args, **kwargs):
                            """
                            Sets the number of outer iterations.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/outer_iterations").execute(*args, **kwargs)

                        class instability_detector(TUIMenu):
                            """
                            Enters the menu for the instability detector controls.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def enable_instability_detector(self, *args, **kwargs):
                                """
                                Enables/disables the instability detector to deal with  possible instability problems. Once this option is enabled,  additional instability detection options become  available.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/enable_instability_detector").execute(*args, **kwargs)
                            def unstable_event_outer_iterations(self, *args, **kwargs):
                                """
                                Sets the number of outer iterations for an unstable  event.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/unstable_event_outer_iterations").execute(*args, **kwargs)
                            def set_cfl_type(self, *args, **kwargs):
                                """
                                Selects the CFL number type for detection of an unstable  event. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_type").execute(*args, **kwargs)
                            def set_cfl_limit(self, *args, **kwargs):
                                """
                                Sets the Courant number limit for detecting unstable  events. This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_cfl_limit").execute(*args, **kwargs)
                            def set_velocity_limit(self, *args, **kwargs):
                                """
                                Sets the velocity limit for detecting unstable events.  This command becomes available once the enable-instability-detector? text  option has been enabled.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/hybrid_nita/instability_detector/set_velocity_limit").execute(*args, **kwargs)

                    class anti_diffusion(TUIMenu):
                        """
                        Enters the anti-diffusion menu. This item is available for VOF cases  with the Interfacial Anti-Diffusion option  enabled.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_dynamic_strength_exponent(self, *args, **kwargs):
                            """
                            Sets the cosine exponent in the dynamic strength treatment in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_dynamic_strength_exponent").execute(*args, **kwargs)
                        def set_maximum_dynamic_strength(self, *args, **kwargs):
                            """
                            Sets the maximum value of dynamic anti-diffusion strength in ).
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/set_maximum_dynamic_strength").execute(*args, **kwargs)
                        def enable_dynamic_strength(self, *args, **kwargs):
                            """
                            Enables dynamic strength to reduce compression in the direction tangential to the interface.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/anti_diffusion/enable_dynamic_strength").execute(*args, **kwargs)

                    class equation_order(TUIMenu):
                        """
                        Enters the equation order menu for homogeneous multiphase flow  models.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def solve_flow_last(self, *args, **kwargs):
                            """
                            When enabled, solves the flow equation at the end of the iteration. This improves the behavior at the start of new time-step if the solution does not converge properly.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_flow_last").execute(*args, **kwargs)
                        def solve_exp_vof_at_end(self, *args, **kwargs):
                            """
                            Solve Explicit VOF at the end of time-step as an alternative.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/equation_order/solve_exp_vof_at_end").execute(*args, **kwargs)

                    class pseudo_time(TUIMenu):
                        """
                        Pseudo-Time stability controls for multiphase flow.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.auto_dt_advanced_controls = self.__class__.auto_dt_advanced_controls(path + ["auto_dt_advanced_controls"], service)
                            super().__init__(path, service)
                        def smoothed_density_stabilization_method(self, *args, **kwargs):
                            """
                            Set smoothed density stabilization method.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/smoothed_density_stabilization_method").execute(*args, **kwargs)
                        def false_time_step_linearization(self, *args, **kwargs):
                            """
                            Set false time-step linearization for added stability.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/false_time_step_linearization").execute(*args, **kwargs)

                        class auto_dt_advanced_controls(TUIMenu):
                            """
                            Set automatic time-stepping controls for better solution stability.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def dt_factor_min(self, *args, **kwargs):
                                """
                                Set minimum limit for reduction in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_min").execute(*args, **kwargs)
                            def max_velocity_ratio(self, *args, **kwargs):
                                """
                                Set velocity ratio to freeze the time step size for better solution stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/max_velocity_ratio").execute(*args, **kwargs)
                            def dt_factor_max(self, *args, **kwargs):
                                """
                                Set maximum limit for increase in pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_factor_max").execute(*args, **kwargs)
                            def dt_max(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_max").execute(*args, **kwargs)
                            def enable(self, *args, **kwargs):
                                """
                                Enable advanced automatic time stepping for better stability.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/enable").execute(*args, **kwargs)
                            def dt_init_limit(self, *args, **kwargs):
                                """
                                Set maximum value for pseudo time step size during first iteration.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/pseudo_time/auto_dt_advanced_controls/dt_init_limit").execute(*args, **kwargs)

                    class p_v_coupling(TUIMenu):
                        """
                        Enters the menu for the pressure-velocity coupling controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.skewness_correction = self.__class__.skewness_correction(path + ["skewness_correction"], service)
                            self.coupled_vof = self.__class__.coupled_vof(path + ["coupled_vof"], service)
                            self.rhie_chow_flux = self.__class__.rhie_chow_flux(path + ["rhie_chow_flux"], service)
                            super().__init__(path, service)

                        class skewness_correction(TUIMenu):
                            """
                            Enters the skewness correction menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def limit_pressure_correction_gradient(self, *args, **kwargs):
                                """
                                Enables/disables the limited pressure correction  gradient in skewness terms for the PISO, SIMPLEC, or  fractional step pressure-coupling schemes.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/skewness_correction/limit_pressure_correction_gradient").execute(*args, **kwargs)

                        class coupled_vof(TUIMenu):
                            """
                            Enters the stability control menu for VOF cases that involve the Coupled pressure-velocity coupling scheme.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def buoyancy_force_linearization(self, *args, **kwargs):
                                """
                                Allows you to use the linearized buoyancy force and the  blended treatment for the buoyancy force.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/coupled_vof/buoyancy_force_linearization").execute(*args, **kwargs)

                        class rhie_chow_flux(TUIMenu):
                            """
                            Enters the stability controls menu for the Rhie-Chow interpolation.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def low_order_rhie_chow(self, *args, **kwargs):
                                """
                                Enables/disables the low-order velocity interpolation in  the flux calculation.
                                """
                                return PyMenu(self.service, "/solve/set/multiphase_numerics/advanced_stability_controls/p_v_coupling/rhie_chow_flux/low_order_rhie_chow").execute(*args, **kwargs)

                class viscous_flow(TUIMenu):
                    """
                    Enters the viscous multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def viscosity_averaging(self, *args, **kwargs):
                        """
                        Forces harmonic averaging of cell viscosities to calculate face  viscosity used in momentum equation. This can improve convergence for  highly viscous flow applications (the VOF model only).
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/viscosity_averaging").execute(*args, **kwargs)
                    def turb_visc_based_damping(self, *args, **kwargs):
                        """
                        Turbulence viscosity based damping controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/turb_visc_based_damping").execute(*args, **kwargs)
                    def interfacial_artificial_viscosity(self, *args, **kwargs):
                        """
                        Interfacial artifical viscosity controls.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/viscous_flow/interfacial_artificial_viscosity").execute(*args, **kwargs)

                class compressible_flow(TUIMenu):
                    """
                    Enters the compressible multiphase flow numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def alternate_bc_formulation(self, *args, **kwargs):
                        """
                        Enables an alternative formulation for compressible phases at an  inlet boundary. This formulation calculates static temperature and  pressure using an iterative method based on fundamental thermodynamic  relations.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/alternate_bc_formulation").execute(*args, **kwargs)
                    def enhanced_numerics(self, *args, **kwargs):
                        """
                        Enables an enhanced numerical treatment that provides better  stability at startup and during calculation of compressible  flows.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/compressible_flow/enhanced_numerics").execute(*args, **kwargs)

                class boiling_parameters(TUIMenu):
                    """
                    Enters the menu for the multiphase boiling model parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def liquid_vof_factor(self, *args, **kwargs):
                        """
                        When enabled, considers liquid volume fraction effects by multiplying the heat transfer coefficients by the local liquid volume fraction.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/liquid_vof_factor").execute(*args, **kwargs)
                    def thin_film(self, *args, **kwargs):
                        """
                        When enabled, includes multiphase boiling thin film effects using .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/boiling_parameters/thin_film").execute(*args, **kwargs)

                class face_pressure_controls(TUIMenu):
                    """
                    Enter the face pressure expert controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def face_pressure_options(self, *args, **kwargs):
                        """
                        Set face pressure options.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/face_pressure_controls/face_pressure_options").execute(*args, **kwargs)

                class heat_mass_transfer(TUIMenu):
                    """
                    Enters the menu for the multiphase heat mass transfer parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.boiling = self.__class__.boiling(path + ["boiling"], service)
                        self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                        self.area_density = self.__class__.area_density(path + ["area_density"], service)
                        self.evaporation_condensation = self.__class__.evaporation_condensation(path + ["evaporation_condensation"], service)
                        super().__init__(path, service)
                    def alternative_energy_treatment(self, *args, **kwargs):
                        """
                        Enables the alternative treatment of the energy sources. For more  information, see .
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/alternative_energy_treatment").execute(*args, **kwargs)

                    class boiling(TUIMenu):
                        """
                        Enters the menu for the advanced boiling options for the  semi-mechanistic boiling model.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def heat_flux_relaxation_factor(self, *args, **kwargs):
                            """
                            Sets the under-relaxation factor for boiling heat flux. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/heat_flux_relaxation_factor").execute(*args, **kwargs)
                        def two_resistance_boiling_framework(self, *args, **kwargs):
                            """
                            Enables/disables the two-resistance boiling framework to improve the robustness and accuracy of the solution of cases with multiple boiling mechanisms. For more information about this item, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/two_resistance_boiling_framework").execute(*args, **kwargs)
                        def show_expert_options(self, *args, **kwargs):
                            """
                            Exposes the expert options for the semi-mechanistic boiling model. For more information about these options, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/boiling/show_expert_options").execute(*args, **kwargs)

                    class cavitation(TUIMenu):
                        """
                        Enters the cavitation heat mass transfer menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def display_clipped_pressure(self, *args, **kwargs):
                            """
                            Clipped pressure is just used for the properties evaluation. Mass Transfer Rate uses unclipped pressure.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/display_clipped_pressure").execute(*args, **kwargs)
                        def schnerr_evap_coeff(self, *args, **kwargs):
                            """
                            Sets the evaporation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 1.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_evap_coeff").execute(*args, **kwargs)
                        def max_vapor_pressure_ratio(self, *args, **kwargs):
                            """
                            Sets the maximum limit on the vapor pressure after the turbulence and thermal correction. The default value is five times the vapor pressure, with consideration of turbulent and thermal effects for each cell and phase.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/max_vapor_pressure_ratio").execute(*args, **kwargs)
                        def schnerr_cond_coeff(self, *args, **kwargs):
                            """
                            Sets the condensation coefficient for the Schnerr-Sauer model (  in ). The default and recommended value of 0.2.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/schnerr_cond_coeff").execute(*args, **kwargs)
                        def turbulent_diffusion(self, *args, **kwargs):
                            """
                            Enables/disables the turbulent diffusion treatment for a cavitating turbulent flow. See  for details.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/turbulent_diffusion").execute(*args, **kwargs)
                        def min_vapor_pressure(self, *args, **kwargs):
                            """
                            Sets the minimum vapor pressure limit for the cavitation mass-transfer model. The default value is 1 Pa.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/cavitation/min_vapor_pressure").execute(*args, **kwargs)

                    class area_density(TUIMenu):
                        """
                        Enters the menu for the area density.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def ia_grad_sym(self, *args, **kwargs):
                            """
                            Enables/disables the interfacial area density Gradient-Symmetric model. For more information about this model, see .
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/ia_grad_sym").execute(*args, **kwargs)
                        def vof_min_seeding(self, *args, **kwargs):
                            """
                            Sets the minimum volume fraction for the area density and cavitation. This may be useful, for example, in cases when a species mass transfer model (such as the Symmetric model or Particle model) do not consider evaporation or condensation if the volume fraction of one of the phases is zero. The seeding allows for a phase change to occur in the fluid flow. The default value is 1e-6.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/area_density/vof_min_seeding").execute(*args, **kwargs)

                    class evaporation_condensation(TUIMenu):
                        """
                        Evaporation-condensation advanced options menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def vof_from_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_min_limit").execute(*args, **kwargs)
                        def vof_to_min_limit(self, *args, **kwargs):
                            """
                            Minimum volume fraction below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_min_limit").execute(*args, **kwargs)
                        def max_rel_humidity(self, *args, **kwargs):
                            """
                            Maximum value of relative humidity to limit condensation rate.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/max_rel_humidity").execute(*args, **kwargs)
                        def vof_to_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_to_max_limit").execute(*args, **kwargs)
                        def vof_from_max_limit(self, *args, **kwargs):
                            """
                            Maximum volume fraction above which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/vof_from_max_limit").execute(*args, **kwargs)
                        def ia_norm_min_limit(self, *args, **kwargs):
                            """
                            Minimum normalized area density below which mass transfer rate is set to zero.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/heat_mass_transfer/evaporation_condensation/ia_norm_min_limit").execute(*args, **kwargs)

                class solution_stabilization(TUIMenu):
                    """
                    Enters the solution-stabilization numerics menu. This item is available only for the VOF model.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.additional_stabilization_controls = self.__class__.additional_stabilization_controls(path + ["additional_stabilization_controls"], service)
                        self.velocity_limiting_treatment = self.__class__.velocity_limiting_treatment(path + ["velocity_limiting_treatment"], service)
                        super().__init__(path, service)
                    def execute_advanced_stabilization(self, *args, **kwargs):
                        """
                        When enabled, modifies solver settings for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_advanced_stabilization").execute(*args, **kwargs)
                    def execute_settings_optimization(self, *args, **kwargs):
                        """
                        Execute optimized settings for VOF.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_settings_optimization").execute(*args, **kwargs)
                    def execute_additional_stability_controls(self, *args, **kwargs):
                        """
                        When enabled, uses additional controls for improved solution  stability.
                        """
                        return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/execute_additional_stability_controls").execute(*args, **kwargs)

                    class additional_stabilization_controls(TUIMenu):
                        """
                        Enters the menu for additional advanced stability controls.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def pseudo_time_stabilization(self, *args, **kwargs):
                            """
                            Pseudo-Time Momentum stabilization and False Time Step Linearization methods for VOF.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/pseudo_time_stabilization").execute(*args, **kwargs)
                        def blended_compressive_scheme(self, *args, **kwargs):
                            """
                            Enables/disables the blended compressive discretization scheme.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/additional_stabilization_controls/blended_compressive_scheme").execute(*args, **kwargs)

                    class velocity_limiting_treatment(TUIMenu):
                        """
                        Enters the menu for the velocity-limiting-treatment.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def set_velocity_and_vof_cutoffs(self, *args, **kwargs):
                            """
                            Set phase based velocity limiting controls.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_and_vof_cutoffs").execute(*args, **kwargs)
                        def set_damping_strength(self, *args, **kwargs):
                            """
                            Enter damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strength").execute(*args, **kwargs)
                        def set_damping_strengths(self, *args, **kwargs):
                            """
                            Set phase based damping strength.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_damping_strengths").execute(*args, **kwargs)
                        def verbosity(self, *args, **kwargs):
                            """
                            When enabled, the solver prints the number of velocity limited cells at each iteration.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/verbosity").execute(*args, **kwargs)
                        def enable_velocity_limiting(self, *args, **kwargs):
                            """
                            Enables/disables the velocity limiting treatment.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/enable_velocity_limiting").execute(*args, **kwargs)
                        def set_velocity_cutoff(self, *args, **kwargs):
                            """
                            Specifies the maximum velocity magnitude.
                            """
                            return PyMenu(self.service, "/solve/set/multiphase_numerics/solution_stabilization/velocity_limiting_treatment/set_velocity_cutoff").execute(*args, **kwargs)

            class high_order_term_relaxation(TUIMenu):
                """
                Enter High Order Relaxation Menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.options = self.__class__.options(path + ["options"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Order Term Relaxation.
                    """
                    return PyMenu(self.service, "/solve/set/high_order_term_relaxation/enable").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    High Order Term Relaxation Options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.variables = self.__class__.variables(path + ["variables"], service)
                        super().__init__(path, service)
                    def expert(self, *args, **kwargs):
                        """
                        Enter high order relaxation option with respect to diffusion gradient.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/expert").execute(*args, **kwargs)
                    def relaxation_factor(self, *args, **kwargs):
                        """
                        Sets the relaxation factor.
                        """
                        return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/relaxation_factor").execute(*args, **kwargs)

                    class variables(TUIMenu):
                        """
                        Selects the variables.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def select(self, *args, **kwargs):
                            """
                            Select variables for high order term relaxation.
                            """
                            return PyMenu(self.service, "/solve/set/high_order_term_relaxation/options/variables/select").execute(*args, **kwargs)

            class transient_controls(TUIMenu):
                """
                Enters the transient controls menu, which allows you to define settings related to time advancement for transient flow calculations.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.multiphase_specific_time_constraints = self.__class__.multiphase_specific_time_constraints(path + ["multiphase_specific_time_constraints"], service)
                    super().__init__(path, service)
                def incremental_time(self, *args, **kwargs):
                    """
                    Sets the amount of incremental (that is, additional) time to run the simulation, regardless of how much time has already been run in previous calculations. This text command is only available when the solve/set/transient-controls/duration-specification-method is set to3.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/incremental_time").execute(*args, **kwargs)
                def undo_timestep(self, *args, **kwargs):
                    """
                    When enabled, if the truncation error within a time step exceeds the specified tolerance Fluent will automatically undo the current calculation and make another attempt with the time step reduced by 1/2. This will be attempted up to 5 times after which Fluent will accept the result and proceed to the next time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/undo_timestep").execute(*args, **kwargs)
                def cfl_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent as the calculation proceeds such that the Courant–Friedrichs–Lewy (CFL) condition is satisfied, using the specified Courant number.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping").execute(*args, **kwargs)
                def multiphase_specific_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the convective time scale (global Courant number): the time-step-size calculation depends on the mesh density and velocity in interfacial cells. This method is available for all multiphase models using the implicit or explicit volume fraction formulation, except for the wet steam model.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_stepping").execute(*args, **kwargs)
                def solid_time_step_size(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size used for solid zones is independent from that used for fluid zones. This text command is only available when both a solid zone exists and energy is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solid_time_step_size").execute(*args, **kwargs)
                def rotating_mesh_flow_predictor(self, *args, **kwargs):
                    """
                    Enables / disables an option that allows for better prediction of the flow field in rotating fluid zones at every time step, in order to speed up the calculation. This text command is only available for transient simulations.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/rotating_mesh_flow_predictor").execute(*args, **kwargs)
                def total_time(self, *args, **kwargs):
                    """
                    Sets the total amount of time that the simulation will be run (which includes any time that has already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to2.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_time").execute(*args, **kwargs)
                def cfl_based_time_stepping_advanced_options(self, *args, **kwargs):
                    """
                    Set CFL-based adaptive time-stepping advanced parameters.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/cfl_based_time_stepping_advanced_options").execute(*args, **kwargs)
                def fixed_periodic(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which a specified period or frequency is the basis for determining the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_periodic").execute(*args, **kwargs)
                def fixed_user_specified(self, *args, **kwargs):
                    """
                    Allows you to specify that a fixed time stepping method is used in which you directly specify the time step size and number of time steps.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/fixed_user_specified").execute(*args, **kwargs)
                def total_number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the total number of time steps that the simulation will run (which includes any time steps that have already been run in previous calculations). This text command is only available when the solve/set/transient-controls/duration-specification-method is set to1.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/total_number_of_time_steps").execute(*args, **kwargs)
                def duration_specification_method(self, *args, **kwargs):
                    """
                    Sets the method by which you will specify the duration of the calculation. The duration can be defined by the total time, the total number of time steps, the incremental time, or the number of incremental time steps. In this context, "total" indicates that Fluent will consider the amount of time / steps that have already been solved and stop appropriately, whereas "incremental" indicates that the solution will proceed for a specified amount of time / steps regardless of what has previously been calculated. This text command is only available when the time stepping is adaptive or based on a user-defined function.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/duration_specification_method").execute(*args, **kwargs)
                def error_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that an adaptive time stepping method is used in which the time step gets modified by ANSYS Fluent  based on the specified truncation error tolerance.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/error_based_time_stepping").execute(*args, **kwargs)
                def predict_next_time(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing the next time step. The predictor algorithm is a computation that sets a better initial condition for the time step. It uses the rate of change between the prediction and the correction as an indicator for whether the next time step should be larger, smaller, or the same as the current one.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/predict_next_time").execute(*args, **kwargs)
                def number_of_time_steps(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation without starting the calculation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/number_of_time_steps").execute(*args, **kwargs)
                def max_iterations_per_time_step(self, *args, **kwargs):
                    """
                    Sets the number of time steps for a transient simulation.  This option is available when automatic initialization and case modification is enabled.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_iterations_per_time_step").execute(*args, **kwargs)
                def udf_based_time_stepping(self, *args, **kwargs):
                    """
                    Allows you to specify that the time step size is defined by a user-defined function (UDF) that uses theDEFINE_DELTAT macro.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/udf_based_time_stepping").execute(*args, **kwargs)
                def max_flow_time(self, *args, **kwargs):
                    """
                    Sets the maximum flow time.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/max_flow_time").execute(*args, **kwargs)
                def extrapolate_vars(self, *args, **kwargs):
                    """
                    Applies a predictor algorithm for computing initial conditions at time step n+1. The predictor algorithm is a computation that sets a better initial condition for the time step.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_vars").execute(*args, **kwargs)
                def time_step_size(self, *args, **kwargs):
                    """
                    Sets the magnitude of the (physical) time step . This text command is only available when the solve/set/transient-controls/fixed-user-specified text command is set toyes.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size").execute(*args, **kwargs)
                def specified_time_step(self, *args, **kwargs):
                    """
                    Specifies whether to define the transient advancement either directly by entering a time step size / period / frequency (using the text commands available in thesolve/set/transient-controls menu) or indirectly by entering a Courant number value (using the solve/set/courant-number text command). This text command is only available for the density-based solver when both the explicit formulation and explicit transient formulation are used.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/specified_time_step").execute(*args, **kwargs)
                def solution_status(self, *args, **kwargs):
                    """
                    Allows you to open theSimulation Status dialog box, which reports details about the simulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/solution_status").execute(*args, **kwargs)
                def extrapolate_eqn_vars(self, *args, **kwargs):
                    """
                    Enters the extrapolation menu.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/extrapolate_eqn_vars").execute(*args, **kwargs)
                def time_step_size_for_acoustic_export(self, *args, **kwargs):
                    """
                    Specifies the time interval for acoustic data sampling. This text command is only available when both the Ffowcs Williams and Hawkings model is selected and the density-based solver is used with the explicit formulation and explicit transient formulation.
                    """
                    return PyMenu(self.service, "/solve/set/transient_controls/time_step_size_for_acoustic_export").execute(*args, **kwargs)

                class multiphase_specific_time_constraints(TUIMenu):
                    """
                    Enters the menu for setting multiphase-specific time constraints.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.time_scale_options = self.__class__.time_scale_options(path + ["time_scale_options"], service)
                        super().__init__(path, service)
                    def moving_mesh_cfl_constraint(self, *args, **kwargs):
                        """
                        Enable time step size constraints based on moving mesh courant number.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/moving_mesh_cfl_constraint").execute(*args, **kwargs)
                    def physics_based_constraint(self, *args, **kwargs):
                        """
                        Enables/disables the physics-driven time-step constraints.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/physics_based_constraint").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        When enabled, various time scales (depending on the selection) are  printed to the console window at every time step. This text command is  available with the moving mesh CFL constraint and with the physics-based  constraint.
                        """
                        return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/verbosity").execute(*args, **kwargs)

                    class time_scale_options(TUIMenu):
                        """
                        Enters the menu for choosing the time-scale options. This menu  becomes available after you enable the physics-driven time-step  constraints using the solve/set/transient-controls/multiphase-specific-time-constraints/physics-based-constraint?  text command.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def surface_tension_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the surface-tension-driven time scale. This option is available only if the surface tension force modeling is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/surface_tension_scale").execute(*args, **kwargs)
                        def gravity_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the gravitational time scale. This option is available only if gravity is enabled.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/gravity_scale").execute(*args, **kwargs)
                        def viscous_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the viscous time scale. This option is disabled by default. This command is not available with inviscid flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/viscous_scale").execute(*args, **kwargs)
                        def acoustic_scale(self, *args, **kwargs):
                            """
                            Allows you to Include the acoustic time scale. This option is available only for compressible flows.
                            """
                            return PyMenu(self.service, "/solve/set/transient_controls/multiphase_specific_time_constraints/time_scale_options/acoustic_scale").execute(*args, **kwargs)

            class open_channel_wave_options(TUIMenu):
                """
                Sets buffer layer height, verbosity, and open channel wave theory formulation.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Sets the open channel wave verbosity.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_verbosity").execute(*args, **kwargs)
                def stokes_wave_variants(self, *args, **kwargs):
                    """
                    Specifies which open channel wave theory formulation Fluent uses.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/stokes_wave_variants").execute(*args, **kwargs)
                def set_buffer_layer_ht(self, *args, **kwargs):
                    """
                    Sets the buffer layer height.
                    """
                    return PyMenu(self.service, "/solve/set/open_channel_wave_options/set_buffer_layer_ht").execute(*args, **kwargs)

            class acoustics_wave_equation_controls(TUIMenu):
                """
                Enters the menu to specify parameters of the acoustics wave equation solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def relative_convergence_criterion(self, *args, **kwargs):
                    """
                    Specify convergence tolerance for the timestep iterations
                    as the target residual reduction factor.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/relative_convergence_criterion").execute(*args, **kwargs)
                def max_iterations_per_timestep(self, *args, **kwargs):
                    """
                    Specify maximum number of iterations per timestep.
                    """
                    return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/max_iterations_per_timestep").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enters the menu to specify the expert parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def explicit_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the explicit relaxation factor. Should be used only with  bad meshes, when iterations do not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/explicit_relaxation_factor").execute(*args, **kwargs)
                    def under_relaxation_factor(self, *args, **kwargs):
                        """
                        Specifies the implicit under-relaxation factor. Should be used only  with bad meshes, when the AMG linear solver does not converge.
                        """
                        return PyMenu(self.service, "/solve/set/acoustics_wave_equation_controls/expert/under_relaxation_factor").execute(*args, **kwargs)

            class overset(TUIMenu):
                """
                Specifies overset meshing solver options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    super().__init__(path, service)
                def interpolation_method(self, *args, **kwargs):
                    """
                    Selects the interpolation method for overset interfaces. Note that the least squares method is recommended for sliding mesh cases.
                    """
                    return PyMenu(self.service, "/solve/set/overset/interpolation_method").execute(*args, **kwargs)
                def high_order_pressure(self, *args, **kwargs):
                    """
                    Uses the pressure gradient of the donor cell in the interpolation of pressure for its receptor cell.
                    """
                    return PyMenu(self.service, "/solve/set/overset/high_order_pressure").execute(*args, **kwargs)
                def orphan_cell_treatment(self, *args, **kwargs):
                    """
                    Enables/disables a numerical treatment that attempts to assign reasonable data values to orphan cells.
                    """
                    return PyMenu(self.service, "/solve/set/overset/orphan_cell_treatment").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter overset expert solver options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mass_flux_correction_method(self, *args, **kwargs):
                        """
                        Enter mass flux correction option at overset interfaces.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/mass_flux_correction_method").execute(*args, **kwargs)
                    def hybrid_mode_selection(self, *args, **kwargs):
                        """
                        Mode for hybrid interpolation.
                        """
                        return PyMenu(self.service, "/solve/set/overset/expert/hybrid_mode_selection").execute(*args, **kwargs)

            class data_sampling_options(TUIMenu):
                """
                Enter the menu for specifying quantities and zones for steady and unsteady flow statistics.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.dft_datasets = self.__class__.dft_datasets(path + ["dft_datasets"], service)
                    super().__init__(path, service)
                def add_rtdft_datasets(self, *args, **kwargs):
                    """
                    Specify zone and quantity combinations for sampling Fourier coefficients of unsteady flows.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_rtdft_datasets").execute(*args, **kwargs)
                def remove_dataset(self, *args, **kwargs):
                    """
                    Remove dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/remove_dataset").execute(*args, **kwargs)
                def add_datasets(self, *args, **kwargs):
                    """
                    Add a dataset. After providing the zones for a dataset, press [Enter] to move onto selecting quantities. Enter () to complete the quantity selection for this dataset.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/add_datasets").execute(*args, **kwargs)
                def list_datasets(self, *args, **kwargs):
                    """
                    Lists the combinations of zones and quantities that are defined for sampling steady and unsteady flow statistics.
                    """
                    return PyMenu(self.service, "/solve/set/data_sampling_options/list_datasets").execute(*args, **kwargs)

                class dft_datasets(TUIMenu):
                    """
                    Data sampling options for runtime discrete Fourier transform.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def band_or_tone(self, *args, **kwargs):
                        """
                        Specify, whether a new dataset is for DFT in a frequency band resolved by many harmonics or for a single tone.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/band_or_tone").execute(*args, **kwargs)
                    def add_datasets(self, *args, **kwargs):
                        """
                        Add DFT datasets.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/add_datasets").execute(*args, **kwargs)
                    def freq_min_max(self, *args, **kwargs):
                        """
                        Specify the minimum and the maximum frequency for a band.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_min_max").execute(*args, **kwargs)
                    def freq_step_and_sampling(self, *args, **kwargs):
                        """
                        Specify either the band resolution or the sampling timesteps number. The other value will be computed consistently.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_step_and_sampling").execute(*args, **kwargs)
                    def quantities(self, *args, **kwargs):
                        """
                        Select quantities for a new DFT dataset. Enter () to complete the quantity selection.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/quantities").execute(*args, **kwargs)
                    def freq_tone_and_sampling(self, *args, **kwargs):
                        """
                        Specify single tone frequency and sampling duration as the number of tone periods.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/freq_tone_and_sampling").execute(*args, **kwargs)
                    def zones(self, *args, **kwargs):
                        """
                        Select zones for a new DFT dataset.
                        """
                        return PyMenu(self.service, "/solve/set/data_sampling_options/dft_datasets/zones").execute(*args, **kwargs)

            class fast_transient_settings(TUIMenu):
                """
                Enters the fast transient settings menu. This menu is only available for transient cases that use the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def rk2(self, *args, **kwargs):
                    """
                    Allows you to enable the use of a two-stage Runge-Kutta scheme for time integration, or revert to the default multi-stage Runge-Kutta scheme. This text command is only available for transient cases that use the density-based explicit formulation.
                    """
                    return PyMenu(self.service, "/solve/set/fast_transient_settings/rk2").execute(*args, **kwargs)

            class advanced(TUIMenu):
                """
                Enters the advanced settings menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.turbomachinery_specific_numerics = self.__class__.turbomachinery_specific_numerics(path + ["turbomachinery_specific_numerics"], service)
                    self.non_reflecting_boundary_treatment = self.__class__.non_reflecting_boundary_treatment(path + ["non_reflecting_boundary_treatment"], service)
                    self.secondary_gradient_limiting = self.__class__.secondary_gradient_limiting(path + ["secondary_gradient_limiting"], service)
                    super().__init__(path, service)
                def bcd_boundedness(self, *args, **kwargs):
                    """
                    Specifies the BCD scheme parameter, which controls the boundedness strength of the BCD scheme in the pressure-based solver, as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_boundedness").execute(*args, **kwargs)
                def energy_numerical_noise_filter(self, *args, **kwargs):
                    """
                    Enables/disables a filter to eliminate non-physical numerical noise in the energy field. Numerical noise can appear in solution fields where large variations in specific heat or combustion with phase change are present. Using the energy equation numerical noise filter increases robustness, but may make the solution slightly more diffusive. This text command is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_numerical_noise_filter").execute(*args, **kwargs)
                def skewness_correction_enhanced(self, *args, **kwargs):
                    """
                    Enable enhanced skewness correction scheme.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/skewness_correction_enhanced").execute(*args, **kwargs)
                def anisotropic_solid_heat_transfer(self, *args, **kwargs):
                    """
                    Set up the heat transfer for anisotropic solid zones.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/anisotropic_solid_heat_transfer").execute(*args, **kwargs)
                def retain_cell_residuals(self, *args, **kwargs):
                    """
                    Enables/disables the retention of cell residuals for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_cell_residuals").execute(*args, **kwargs)
                def linearized_mass_transfer_udf(self, *args, **kwargs):
                    """
                    Enables/disables the use of a linearized mass transfer user-defined function (that is, the DEFINE_LINEARIZED_MASS_TRANSFER macro), as opposed to a mass transfer user-defined function (that is, the DEFINE_MASS_TRANSFER macro).
                    """
                    return PyMenu(self.service, "/solve/set/advanced/linearized_mass_transfer_udf").execute(*args, **kwargs)
                def show_all_discretization_schemes(self, *args, **kwargs):
                    """
                    Enables/disables the availability of all applicable discretization schemes.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/show_all_discretization_schemes").execute(*args, **kwargs)
                def alternate_wall_temp_formulation(self, *args, **kwargs):
                    """
                    Enables/disables an alternate formulation for wall temperatures.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/alternate_wall_temp_formulation").execute(*args, **kwargs)
                def explicit_under_relaxation_value(self, *args, **kwargs):
                    """
                    Explicit under-relaxation value.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/explicit_under_relaxation_value").execute(*args, **kwargs)
                def correction_form(self, *args, **kwargs):
                    """
                    S.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/correction_form").execute(*args, **kwargs)
                def bcd_weights_freeze(self, *args, **kwargs):
                    """
                    Enables/disables freezing of weighting coefficients of the central differencing and the upwind components of the BCD scheme. This dialog command requires the iteration number, after which the BCD scheme weights are to be frozen at each timestep. Freezing the BCD weighting coefficients may help to improve convergence of the timestep iterations as described in .
                    """
                    return PyMenu(self.service, "/solve/set/advanced/bcd_weights_freeze").execute(*args, **kwargs)
                def energy_reconstruction_gradient_limiting(self, *args, **kwargs):
                    """
                    Enable limiting of reconstruction gradient for the energy equation.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/energy_reconstruction_gradient_limiting").execute(*args, **kwargs)
                def singhal_et_al_cavitation_model(self, *args, **kwargs):
                    """
                    Enables/disables the availability of the Singhal et al. cavitation model option, which can then be enabled in the Multiphase Model dialog box or by using the following text command: define/phases/set-domain-properties/interaction-domain/heat-mass-reaction/cavitation/cavitation?.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/singhal_et_al_cavitation_model").execute(*args, **kwargs)
                def retain_temporary_solver_mem(self, *args, **kwargs):
                    """
                    Enables/disables the retention of temporary solver memory, which retains gradient data and makes some advanced options available for postprocessing.
                    """
                    return PyMenu(self.service, "/solve/set/advanced/retain_temporary_solver_mem").execute(*args, **kwargs)

                class turbomachinery_specific_numerics(TUIMenu):
                    """
                    Enter turbomachinery specific numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Activate/deactivate turbomachinery specific numerics.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbomachinery_specific_numerics/enable").execute(*args, **kwargs)
                    def settings(self, *args, **kwargs):
                        """
                        Adjust settings for turbomachinery specific numerics.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/turbomachinery_specific_numerics/settings").execute(*args, **kwargs)

                class non_reflecting_boundary_treatment(TUIMenu):
                    """
                    Enter non reflecting boundary treatment using minimal pressure reflection approach menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def velocity_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/velocity_inlet").execute(*args, **kwargs)
                    def pressure_outlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_outlet").execute(*args, **kwargs)
                    def pressure_inlet(self, *args, **kwargs):
                        """
                        Enabling the use of minimal pressure reflection treatment. This treatment will minimize pressure wave reflections from the boundaries on which this option is active, but not necessarily fully eliminating them. The reflections would be of an acceptable limit in order to not contaminate the solution, the simulation will gain from the robustness of the new algorithm compared to traditional non-reflecting boundary condition treatment.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/non_reflecting_boundary_treatment/pressure_inlet").execute(*args, **kwargs)

                class secondary_gradient_limiting(TUIMenu):
                    """
                    Enters the secondary gradient limiting menu. This menu is only available when the define/models/solver/pressure-based text command is enabled.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def energy(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the energy  calculations on coupled two-sided walls. This limiting can help prevent  divergence when the cells on such walls have poor orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/energy").execute(*args, **kwargs)
                    def uds(self, *args, **kwargs):
                        """
                        Enables/disables secondary gradient limiting for the user-defined  scalar (UDS) calculations on coupled two-sided walls. This limiting can  help prevent divergence when the cells on such walls have poor  orthogonality.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/uds").execute(*args, **kwargs)
                    def mesh_quality_limits(self, *args, **kwargs):
                        """
                        Defines the mesh quality limits used when applying secondary  gradient limiting to faces on coupled two-sided walls. Shifting this  range closer to 1 will decrease the risk of divergence, but at the cost  of accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/advanced/secondary_gradient_limiting/mesh_quality_limits").execute(*args, **kwargs)

            class warped_face_gradient_correction(TUIMenu):
                """
                Enters the warped-face gradient correction menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def turbulence_options(self, *args, **kwargs):
                    """
                    Set turbulence Warped Face Gradient Correction.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/turbulence_options").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables gradient enhancement computations and specifies whether Fluent uses fast or memory saving mode.
                    """
                    return PyMenu(self.service, "/solve/set/warped_face_gradient_correction/enable").execute(*args, **kwargs)

            class previous_defaults(TUIMenu):
                """
                Provides text commands that allow you to undo enhancements to the default solver behavior.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def undo_2021r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2021 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r1_default_changes").execute(*args, **kwargs)
                def undo_2022r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2022 R1 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2022r1_default_changes").execute(*args, **kwargs)
                def undo_2019r3_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R3 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r3_default_changes").execute(*args, **kwargs)
                def undo_r19_point_0_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in R19.0.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_r19_point_0_default_changes").execute(*args, **kwargs)
                def undo_2019r1_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo enhancements introduced in version 2019 R1 of ANSYS Fluent, including:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2019r1_default_changes").execute(*args, **kwargs)
                def undo_2021r2_default_changes(self, *args, **kwargs):
                    """
                    Allows you to undo the following enhancements introduced in version 2021 R2 of ANSYS Fluent:.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2021r2_default_changes").execute(*args, **kwargs)
                def undo_2023r1_default_changes(self, *args, **kwargs):
                    """
                    Undo default changes introduced in 2023R1.
                    """
                    return PyMenu(self.service, "/solve/set/previous_defaults/undo_2023r1_default_changes").execute(*args, **kwargs)

            class contact_solution_controls(TUIMenu):
                """
                Solver controls for contact marks method.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.models = self.__class__.models(path + ["models"], service)
                    self.parameters = self.__class__.parameters(path + ["parameters"], service)
                    self.amg = self.__class__.amg(path + ["amg"], service)
                    self.transient = self.__class__.transient(path + ["transient"], service)
                    self.spatial = self.__class__.spatial(path + ["spatial"], service)
                    self.miscellaneous = self.__class__.miscellaneous(path + ["miscellaneous"], service)
                    self.methods = self.__class__.methods(path + ["methods"], service)
                    super().__init__(path, service)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Automatic solver settings adjustment for solution stabilization during contact process.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/solution_stabilization").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Specify verbosity level for contact solution controls.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/verbosity").execute(*args, **kwargs)
                def set_settings_to_default(self, *args, **kwargs):
                    """
                    Set contact solution stabilization to default.
                    """
                    return PyMenu(self.service, "/solve/set/contact_solution_controls/set_settings_to_default").execute(*args, **kwargs)

                class models(TUIMenu):
                    """
                    Model control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ramp_scalars(self, *args, **kwargs):
                        """
                        Ramp all scalar transport equations for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_scalars").execute(*args, **kwargs)
                    def ramp_flow(self, *args, **kwargs):
                        """
                        Ramp flow for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_flow").execute(*args, **kwargs)
                    def ramp_turbulence(self, *args, **kwargs):
                        """
                        Ramp turbulence for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/ramp_turbulence").execute(*args, **kwargs)
                    def model_ramping(self, *args, **kwargs):
                        """
                        Activate model ramping for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/models/model_ramping").execute(*args, **kwargs)

                class parameters(TUIMenu):
                    """
                    Parameters used in stabilization strategy.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def extrapolation_method(self, *args, **kwargs):
                        """
                        Solution extrapolation method for cells changing status from contact to non-contact [0-none, 1-local extrapolation].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/extrapolation_method").execute(*args, **kwargs)
                    def iterations(self, *args, **kwargs):
                        """
                        Specify additional iterations to accomodate contact solution stabilization.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/iterations").execute(*args, **kwargs)
                    def persistence_fixed_time_steps(self, *args, **kwargs):
                        """
                        Specify fixed time-steps for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_time_steps").execute(*args, **kwargs)
                    def persistence_fixed_duration(self, *args, **kwargs):
                        """
                        Specify fixed time for solution stabilization persistence after trigger.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/persistence_fixed_duration").execute(*args, **kwargs)
                    def solution_stabilization_persistence(self, *args, **kwargs):
                        """
                        Persistence of the solution stabilization based on events [0-contact based, 1-always on].
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/parameters/solution_stabilization_persistence").execute(*args, **kwargs)

                class amg(TUIMenu):
                    """
                    AMG control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def increase_pre_sweeps(self, *args, **kwargs):
                        """
                        Allow increase in AMG pre-sweep.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/increase_pre_sweeps").execute(*args, **kwargs)
                    def enforce_laplace_coarsening(self, *args, **kwargs):
                        """
                        Enforce the use of laplace coarsening in AMG.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/enforce_laplace_coarsening").execute(*args, **kwargs)
                    def specify_coarsening_rate(self, *args, **kwargs):
                        """
                        Modify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/specify_coarsening_rate").execute(*args, **kwargs)
                    def pre_sweeps(self, *args, **kwargs):
                        """
                        Specify the number of AMG pre-sweeps.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/pre_sweeps").execute(*args, **kwargs)
                    def coarsen_rate(self, *args, **kwargs):
                        """
                        Specify AMG coarsening rate.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/amg/coarsen_rate").execute(*args, **kwargs)

                class transient(TUIMenu):
                    """
                    Transient discretization control options .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def time_scale_modification_method(self, *args, **kwargs):
                        """
                        Enter time scale modification method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_method").execute(*args, **kwargs)
                    def transient_scheme(self, *args, **kwargs):
                        """
                        Specify temporal scheme to be used.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_scheme").execute(*args, **kwargs)
                    def time_scale_modification_factor(self, *args, **kwargs):
                        """
                        Specify time-scale modification factor.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/time_scale_modification_factor").execute(*args, **kwargs)
                    def transient_parameters_specify(self, *args, **kwargs):
                        """
                        Allow transient parameter specification.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/transient/transient_parameters_specify").execute(*args, **kwargs)

                class spatial(TUIMenu):
                    """
                    Spatial discretization control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rhie_chow_flux_specify(self, *args, **kwargs):
                        """
                        Allow specification of the the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_flux_specify").execute(*args, **kwargs)
                    def first_to_second_order_blending(self, *args, **kwargs):
                        """
                        Set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending").execute(*args, **kwargs)
                    def flow_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for momentum.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/flow_skew_diffusion_exclude").execute(*args, **kwargs)
                    def scheme(self, *args, **kwargs):
                        """
                        Set advection scheme for contact event stability.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scheme").execute(*args, **kwargs)
                    def scalars_skew_diffusion_exclude(self, *args, **kwargs):
                        """
                        Exclude skew diffusion discretization contribution for scalars.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/scalars_skew_diffusion_exclude").execute(*args, **kwargs)
                    def first_to_second_order_blending_list(self, *args, **kwargs):
                        """
                        List set factor to control first order to second order blending.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/first_to_second_order_blending_list").execute(*args, **kwargs)
                    def rhie_chow_method(self, *args, **kwargs):
                        """
                        Enter the rhie-chow flux method.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/spatial/rhie_chow_method").execute(*args, **kwargs)

                class miscellaneous(TUIMenu):
                    """
                    Miscellaneous.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def compute_statistics(self, *args, **kwargs):
                        """
                        Compute solution statistics for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/compute_statistics").execute(*args, **kwargs)
                    def statistics_level(self, *args, **kwargs):
                        """
                        Solution statistics level for contact updates.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/miscellaneous/statistics_level").execute(*args, **kwargs)

                class methods(TUIMenu):
                    """
                    Methods control options.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def pressure_velocity_coupling_method(self, *args, **kwargs):
                        """
                        Specify pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_method").execute(*args, **kwargs)
                    def gradient_controls(self, *args, **kwargs):
                        """
                        Modify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/gradient_controls").execute(*args, **kwargs)
                    def specify_gradient_method(self, *args, **kwargs):
                        """
                        Specify gradient method for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/specify_gradient_method").execute(*args, **kwargs)
                    def pressure_velocity_coupling_controls(self, *args, **kwargs):
                        """
                        Enable pressure-velocity coupling method change for solver stability and accuracy.
                        """
                        return PyMenu(self.service, "/solve/set/contact_solution_controls/methods/pressure_velocity_coupling_controls").execute(*args, **kwargs)

            class amg_options(TUIMenu):
                """
                Enters the AMG options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def amg_gpgpu_options(self, *args, **kwargs):
                    """
                    Set GPGPU AMG solver options.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/amg_gpgpu_options").execute(*args, **kwargs)
                def conservative_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of conservative coarsening techniques for scalar and/or coupled equations that can improve parallel performance and/or convergence for some difficult cases.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/conservative_amg_coarsening").execute(*args, **kwargs)
                def laplace_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables Laplace coarsening for scalar and/or coupled equations.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/laplace_coarsening").execute(*args, **kwargs)
                def aggressive_amg_coarsening(self, *args, **kwargs):
                    """
                    Enables / disables the use of a version of the AMG solver that is optimized for high coarsening rates. This option is recommended if the AMG solver diverges with the default settings.
                    """
                    return PyMenu(self.service, "/solve/set/amg_options/aggressive_amg_coarsening").execute(*args, **kwargs)

            class poor_mesh_numerics(TUIMenu):
                """
                Enters the poor mesh numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.solution_based_pmn = self.__class__.solution_based_pmn(path + ["solution_based_pmn"], service)
                    super().__init__(path, service)
                def enhanced_pmn(self, *args, **kwargs):
                    """
                    This option is available with the density-based solver. When enabled, it will apply quality-based poor-mesh-numerics order=1 on any cells with a quality-measure below 0.2. In addition, their CFL number is limited to 1.0.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enhanced_pmn").execute(*args, **kwargs)
                def orthogonality_enhancing_cell_centroids(self, *args, **kwargs):
                    """
                    Enables/disables the relocation of select cell centroids, to improve the orthogonality metrics and solution stability. It is applied to cells when the criterion value is equal to or less than a threshold value defined as part of the text command. Note that the enhanced metrics are only apparent when reporting the quality in the solution mode of Fluent, and not in the meshing mode.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/orthogonality_enhancing_cell_centroids").execute(*args, **kwargs)
                def reset_poor_elements(self, *args, **kwargs):
                    """
                    Resets the list of poor cells included by the default, cell quality, user-defined, cell gradient quality, and solution and cell quality criteria.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/reset_poor_elements").execute(*args, **kwargs)
                def set_quality_threshold(self, *args, **kwargs):
                    """
                    Sets the orthogonal quality threshold used for applying poor mesh numerics when the solve/set/poor-mesh-numerics/cell-quality-based? text command is enabled. By default, cells with an orthogonal quality of 0.05 or lower are corrected.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/set_quality_threshold").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells (those with an orthogonal quality of 0, as well as those identified by other enabled criteria), and defines whether the local solution correction is 0th, 1st, or 2nd order.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/enable").execute(*args, **kwargs)
                def user_defined_on_register_auto(self, *args, **kwargs):
                    """
                    Set up the application of poor mesh numerics to cells in a register during the calculation at a specified frequency.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register_auto").execute(*args, **kwargs)
                def user_defined_on_register(self, *args, **kwargs):
                    """
                    Includes a register for the poor mesh numerics or not.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/user_defined_on_register").execute(*args, **kwargs)
                def solution_and_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the solution and cell quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command, and at a specified frequency (of iterations or time steps). This criterion is only available with the pressure-based solver.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_and_quality_based").execute(*args, **kwargs)
                def cell_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the application of poor mesh numerics on cells with an orthogonal quality that is equal to or less than the threshold defined by the solve/set/poor-mesh-numerics/set-quality-threshold text command (which by default is set to 0.05).
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/cell_quality_based").execute(*args, **kwargs)
                def print_poor_elements_count(self, *args, **kwargs):
                    """
                    Prints out a listing of the poor cells for each criterion: default, cell quality, and user-defined, and (if enabled) cell gradient quality and solution and cell quality.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/print_poor_elements_count").execute(*args, **kwargs)
                def gradient_quality_based(self, *args, **kwargs):
                    """
                    Enables/disables the detection and treatment of poor cells using a criterion based on the cell gradient quality. Poor mesh numerics are applied when the criterion value is equal to or less than a threshold value defined as part of this text command. This criterion is only available with the pressure-based solver, and is not supported for cases that have periodic boundaries.
                    """
                    return PyMenu(self.service, "/solve/set/poor_mesh_numerics/gradient_quality_based").execute(*args, **kwargs)

                class solution_based_pmn(TUIMenu):
                    """
                    Solution based poor-mesh numerics menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable solution based treatment.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/enable").execute(*args, **kwargs)
                    def mark_cfl_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_limit").execute(*args, **kwargs)
                    def mark_cfl_jump(self, *args, **kwargs):
                        """
                        Mark cells exceeding cfl jump in neighborhood.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_cfl_jump").execute(*args, **kwargs)
                    def mark_velocity_limit(self, *args, **kwargs):
                        """
                        Mark cells exceeding velocity limit.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_velocity_limit").execute(*args, **kwargs)
                    def mark_primary_solution_limits(self, *args, **kwargs):
                        """
                        Mark cells violating solution limits.
                        """
                        return PyMenu(self.service, "/solve/set/poor_mesh_numerics/solution_based_pmn/mark_primary_solution_limits").execute(*args, **kwargs)

            class high_speed_numerics(TUIMenu):
                """
                Enter high-speed-numerics menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables/disables High Speed Numerics.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/enable").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Sets the level of stabilization used to achieve fast convergence. Enter a number 0-5 corresponding to the Mach number range that best characterizes the flow.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/expert").execute(*args, **kwargs)
                def visualize_pressure_discontinuity_sensor(self, *args, **kwargs):
                    """
                    Makes available the Pressure Discontinuity Sensor which is a binary identifier equal to 1 if a cell is in proximity of a pressure discontinuity.
                    """
                    return PyMenu(self.service, "/solve/set/high_speed_numerics/visualize_pressure_discontinuity_sensor").execute(*args, **kwargs)

            class enhanced_les_numerics(TUIMenu):
                """
                Enter enhanced LES options menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def optimized_advection(self, *args, **kwargs):
                    """
                    Use advection scheme optimized for LES.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_advection").execute(*args, **kwargs)
                def optimized_cd(self, *args, **kwargs):
                    """
                    Use optimized central difference discretization.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_cd").execute(*args, **kwargs)
                def optimized_algorithm(self, *args, **kwargs):
                    """
                    Use solver algorithm optimized for LES.
                    """
                    return PyMenu(self.service, "/solve/set/enhanced_les_numerics/optimized_algorithm").execute(*args, **kwargs)

            class nita_expert_controls(TUIMenu):
                """
                Enters the NITA expert control menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def skewness_neighbor_coupling(self, *args, **kwargs):
                    """
                    Enables/disables coupling of the neighbor and skewness corrections.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/skewness_neighbor_coupling").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Setting this to 1, enables the verbosity for NITA diagnostics. The default value of 0 disables verbosity output for NITA diagnostics.
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/set_verbosity").execute(*args, **kwargs)
                def hybrid_nita_settings(self, *args, **kwargs):
                    """
                    Enables and sets hybrid NITA options. For more details, see .
                    """
                    return PyMenu(self.service, "/solve/set/nita_expert_controls/hybrid_nita_settings").execute(*args, **kwargs)

            class divergence_prevention(TUIMenu):
                """
                Enters the divergence prevention menu. This menu is only available for the density-based solver.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    Enables a divergence prevention option so that Fluent applies under-relaxation to the variables in select cells where the temperature and/or pressure values are approaching the minimum and/or maximum limits.
                    """
                    return PyMenu(self.service, "/solve/set/divergence_prevention/enable").execute(*args, **kwargs)

        class execute_commands(TUIMenu):
            """
            Enters the execute commands menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def delete(self, *args, **kwargs):
                """
                Delete an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/delete").execute(*args, **kwargs)
            def add_edit(self, *args, **kwargs):
                """
                Adds or edits execute commands.
                """
                return PyMenu(self.service, "/solve/execute_commands/add_edit").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/disable").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enables an execute command.
                """
                return PyMenu(self.service, "/solve/execute_commands/enable").execute(*args, **kwargs)
            def export(self, *args, **kwargs):
                """
                Export execute-commands to a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/export").execute(*args, **kwargs)
            def import_(self, *args, **kwargs):
                """
                Import execute-commands from a TSV file.
                """
                return PyMenu(self.service, "/solve/execute_commands/import").execute(*args, **kwargs)
            def copy(self, *args, **kwargs):
                """
                Copy an execute-command.
                """
                return PyMenu(self.service, "/solve/execute_commands/copy").execute(*args, **kwargs)

        class cell_register_operations(TUIMenu):
            """
            Enters the cell register operations menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def add(self, *args, **kwargs):
                """
                Creates a new cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/add").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Deletes a cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/delete").execute(*args, **kwargs)
            def list(self, *args, **kwargs):
                """
                Lists the currently defined cell register operations.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edits an existing cell register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/edit").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Lists the properties of a report register operation.
                """
                return PyMenu(self.service, "/solve/cell_register_operations/list_properties").execute(*args, **kwargs)

    class surface(TUIMenu):
        """
        Enter the data surface manipulation menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.post_processing_volume = self.__class__.post_processing_volume(path + ["post_processing_volume"], service)
            self.query = self.__class__.query(path + ["query"], service)
            super().__init__(path, service)
        def rake_surface(self, *args, **kwargs):
            """
            Extracts a “rake" surface, given the coordinates of the endpoints.
            """
            return PyMenu(self.service, "/surface/rake_surface").execute(*args, **kwargs)
        def closest_point_search(self, *args, **kwargs):
            """
            Enable the point surface algorithm to look for the nearest point instead of reporting a creation failure.
            """
            return PyMenu(self.service, "/surface/closest_point_search").execute(*args, **kwargs)
        def line_surface(self, *args, **kwargs):
            """
            Defines a “line" surface by specifying the two endpoint coordinates.
            """
            return PyMenu(self.service, "/surface/line_surface").execute(*args, **kwargs)
        def plane_surface(self, *args, **kwargs):
            """
            Create a plane from a coordinate plane, point and normal, or three points.
            """
            return PyMenu(self.service, "/surface/plane_surface").execute(*args, **kwargs)
        def plane_slice(self, *args, **kwargs):
            """
            Extracts a planar slice.
            """
            return PyMenu(self.service, "/surface/plane_slice").execute(*args, **kwargs)
        def line_slice(self, *args, **kwargs):
            """
            Extracts a linear slice in 2D, given the normal to the line and a distance from the origin.
            """
            return PyMenu(self.service, "/surface/line_slice").execute(*args, **kwargs)
        def mouse_line(self, *args, **kwargs):
            """
            Extracts a line surface that you define by using the mouse to select the endpoints.
            """
            return PyMenu(self.service, "/surface/mouse_line").execute(*args, **kwargs)
        def plane(self, *args, **kwargs):
            """
            Create a plane given 3 points bounded by the domain.
            """
            return PyMenu(self.service, "/surface/plane").execute(*args, **kwargs)
        def expression_volume(self, *args, **kwargs):
            """
            Create volume with boolean expression.
            """
            return PyMenu(self.service, "/surface/expression_volume").execute(*args, **kwargs)
        def edit_surface(self, *args, **kwargs):
            """
            Allows you to edit any of the listed available surfaces.
            """
            return PyMenu(self.service, "/surface/edit_surface").execute(*args, **kwargs)
        def ellipsoid_slice(self, *args, **kwargs):
            """
            Extract a ellipsoid slice.
            """
            return PyMenu(self.service, "/surface/ellipsoid_slice").execute(*args, **kwargs)
        def transform_surface(self, *args, **kwargs):
            """
            Transforms surface.
            """
            return PyMenu(self.service, "/surface/transform_surface").execute(*args, **kwargs)
        def create_imprint_surface(self, *args, **kwargs):
            """
            Imprint surface.
            """
            return PyMenu(self.service, "/surface/create_imprint_surface").execute(*args, **kwargs)
        def zone_surface(self, *args, **kwargs):
            """
            Creates a surface of a designated zone and gives it a specified name.
            """
            return PyMenu(self.service, "/surface/zone_surface").execute(*args, **kwargs)
        def delete_surface(self, *args, **kwargs):
            """
            Removes a defined data surface.
            """
            return PyMenu(self.service, "/surface/delete_surface").execute(*args, **kwargs)
        def group_surfaces(self, *args, **kwargs):
            """
            Group a set of surfaces.
            """
            return PyMenu(self.service, "/surface/group_surfaces").execute(*args, **kwargs)
        def multiple_iso_surfaces(self, *args, **kwargs):
            """
            Creates multiple iso-surfaces at once. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_iso_surfaces").execute(*args, **kwargs)
        def structural_point_surface(self, *args, **kwargs):
            """
            Defines a structural “point" surface by specifying the coordinates.
            """
            return PyMenu(self.service, "/surface/structural_point_surface").execute(*args, **kwargs)
        def list_surfaces(self, *args, **kwargs):
            """
            Displays the ID and name, and the number of point, curve, and surface facets of the current surfaces.
            """
            return PyMenu(self.service, "/surface/list_surfaces").execute(*args, **kwargs)
        def mouse_plane(self, *args, **kwargs):
            """
            Extracts a planar surface defined by selecting three points with the mouse.
            """
            return PyMenu(self.service, "/surface/mouse_plane").execute(*args, **kwargs)
        def iso_clip(self, *args, **kwargs):
            """
            Clips a data surface (surface, curve, or point) between two isovalues.
            """
            return PyMenu(self.service, "/surface/iso_clip").execute(*args, **kwargs)
        def point_array(self, *args, **kwargs):
            """
            Extracts a rectangular array of data points.
            """
            return PyMenu(self.service, "/surface/point_array").execute(*args, **kwargs)
        def cone_slice(self, *args, **kwargs):
            """
            Extract a cone slice.
            """
            return PyMenu(self.service, "/surface/cone_slice").execute(*args, **kwargs)
        def sphere_slice(self, *args, **kwargs):
            """
            Extracts a spherical slice.
            """
            return PyMenu(self.service, "/surface/sphere_slice").execute(*args, **kwargs)
        def iso_surface(self, *args, **kwargs):
            """
            Extracts an iso-surface (surface, curve, or point) from the current data field.
            """
            return PyMenu(self.service, "/surface/iso_surface").execute(*args, **kwargs)
        def multiple_plane_surfaces(self, *args, **kwargs):
            """
            Creates multiple planes at once. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_plane_surfaces").execute(*args, **kwargs)
        def quadric_slice(self, *args, **kwargs):
            """
            Extracts a quadric slice.
            """
            return PyMenu(self.service, "/surface/quadric_slice").execute(*args, **kwargs)
        def partition_surface(self, *args, **kwargs):
            """
            Defines a data surface consisting of mesh faces on the partition boundary.
            """
            return PyMenu(self.service, "/surface/partition_surface").execute(*args, **kwargs)
        def surface_cells(self, *args, **kwargs):
            """
            Extracts all cells intersected by a data surface.
            """
            return PyMenu(self.service, "/surface/surface_cells").execute(*args, **kwargs)
        def ungroup_surface(self, *args, **kwargs):
            """
            Ungroup the surface(if grouped).
            """
            return PyMenu(self.service, "/surface/ungroup_surface").execute(*args, **kwargs)
        def rename_surface(self, *args, **kwargs):
            """
            Renames a defined data surface.
            """
            return PyMenu(self.service, "/surface/rename_surface").execute(*args, **kwargs)
        def point_surface(self, *args, **kwargs):
            """
            Defines a “point" surface by specifying the coordinates.
            """
            return PyMenu(self.service, "/surface/point_surface").execute(*args, **kwargs)
        def circle_slice(self, *args, **kwargs):
            """
            Extracts a circular slice.
            """
            return PyMenu(self.service, "/surface/circle_slice").execute(*args, **kwargs)
        def reset_zone_surfaces(self, *args, **kwargs):
            """
            Recreates missing surface zones by resetting the case surface list.
            """
            return PyMenu(self.service, "/surface/reset_zone_surfaces").execute(*args, **kwargs)
        def mouse_rake(self, *args, **kwargs):
            """
            Extracts a “rake" surface that you define by using the mouse to select the endpoints.
            """
            return PyMenu(self.service, "/surface/mouse_rake").execute(*args, **kwargs)
        def multiple_zone_surfaces(self, *args, **kwargs):
            """
            Creates multiple data surfaces at one time. Accepts zone names, lists of zone ID’s, and wildcards.
            """
            return PyMenu(self.service, "/surface/multiple_zone_surfaces").execute(*args, **kwargs)

        class post_processing_volume(TUIMenu):
            """
            Enter post-processing volume menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def create_octree(self, *args, **kwargs):
                """
                Create post-processing octree mesh based on current case.
                """
                return PyMenu(self.service, "/surface/post_processing_volume/create_octree").execute(*args, **kwargs)
            def create_from_file(self, *args, **kwargs):
                """
                Read post-processing mesh from file.
                """
                return PyMenu(self.service, "/surface/post_processing_volume/create_from_file").execute(*args, **kwargs)

        class query(TUIMenu):
            """
            Enter surface query menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list_surfaces(self, *args, **kwargs):
                """
                List surfaces.
                """
                return PyMenu(self.service, "/surface/query/list_surfaces").execute(*args, **kwargs)
            def delete_query(self, *args, **kwargs):
                """
                Delete saved query.
                """
                return PyMenu(self.service, "/surface/query/delete_query").execute(*args, **kwargs)
            def list_named_selection(self, *args, **kwargs):
                """
                List named selection of surface type.
                """
                return PyMenu(self.service, "/surface/query/list_named_selection").execute(*args, **kwargs)
            def named_surface_list(self, *args, **kwargs):
                """
                Create named list of surfaces.
                """
                return PyMenu(self.service, "/surface/query/named_surface_list").execute(*args, **kwargs)
            def list_queries(self, *args, **kwargs):
                """
                List all saved queries.
                """
                return PyMenu(self.service, "/surface/query/list_queries").execute(*args, **kwargs)

    class adjoint(TUIMenu):
        """
        Adjoint.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            super().__init__(path, service)
        def expert(self, *args, **kwargs):
            """
            Provides text commands that allow you to undo enhancements to the default adjoint solver behavior.
            """
            return PyMenu(self.service, "/adjoint/expert").execute(*args, **kwargs)
        def utilities(self, *args, **kwargs):
            """
            Enters the utilities menu.
            """
            return PyMenu(self.service, "/adjoint/utilities").execute(*args, **kwargs)
        def monitors(self, *args, **kwargs):
            """
            Menu to configure monitors for the adjoint solver.
            """
            return PyMenu(self.service, "/adjoint/monitors").execute(*args, **kwargs)
        def optimizer(self, *args, **kwargs):
            """
            Enters the optimizer menu, where you can use a gradient-based optimizer to optimize the geometry to meet multiple goals for multiple observables at multiple operating conditions.
            """
            return PyMenu(self.service, "/adjoint/optimizer").execute(*args, **kwargs)
        def run(self, *args, **kwargs):
            """
            Menu to initialize and compute the adjoint solution.
            """
            return PyMenu(self.service, "/adjoint/run").execute(*args, **kwargs)
        def geometry(self, *args, **kwargs):
            """
            Geometry menu.
            """
            return PyMenu(self.service, "/adjoint/geometry").execute(*args, **kwargs)
        def controls(self, *args, **kwargs):
            """
            Menu to configure adjoint solver controls.
            """
            return PyMenu(self.service, "/adjoint/controls").execute(*args, **kwargs)
        def observable(self, *args, **kwargs):
            """
            Menu to create and configure observables of interest.
            """
            return PyMenu(self.service, "/adjoint/observable").execute(*args, **kwargs)
        def multi_objective(self, *args, **kwargs):
            """
            Multi-Objective menu.
            """
            return PyMenu(self.service, "/adjoint/multi_objective").execute(*args, **kwargs)
        def methods(self, *args, **kwargs):
            """
            Menu to configure adjoint solver settings.
            """
            return PyMenu(self.service, "/adjoint/methods").execute(*args, **kwargs)
        def design_tool(self, *args, **kwargs):
            """
            Enters the design-tool menu.
            """
            return PyMenu(self.service, "/adjoint/design_tool").execute(*args, **kwargs)
        def morphing(self, *args, **kwargs):
            """
            Morphing menu.
            """
            return PyMenu(self.service, "/adjoint/morphing").execute(*args, **kwargs)
        def reporting(self, *args, **kwargs):
            """
            Menu to report sensitivity data from the adjoint solution.
            """
            return PyMenu(self.service, "/adjoint/reporting").execute(*args, **kwargs)
        def postprocess_options(self, *args, **kwargs):
            """
            Postprocess options.
            """
            return PyMenu(self.service, "/adjoint/postprocess_options").execute(*args, **kwargs)

    class preferences(TUIMenu):
        """
        Set preferences.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.appearance = self.__class__.appearance(path + ["appearance"], service)
            self.gpuapp = self.__class__.gpuapp(path + ["gpuapp"], service)
            self.mat_pro_app = self.__class__.mat_pro_app(path + ["mat_pro_app"], service)
            self.graphics = self.__class__.graphics(path + ["graphics"], service)
            self.navigation = self.__class__.navigation(path + ["navigation"], service)
            self.simulation = self.__class__.simulation(path + ["simulation"], service)
            self.general = self.__class__.general(path + ["general"], service)
            self.parametric_study = self.__class__.parametric_study(path + ["parametric_study"], service)
            self.turbo_workflow = self.__class__.turbo_workflow(path + ["turbo_workflow"], service)
            self.meshing_workflow = self.__class__.meshing_workflow(path + ["meshing_workflow"], service)
            super().__init__(path, service)

        class appearance(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.selections = self.__class__.selections(path + ["selections"], service)
                self.charts = self.__class__.charts(path + ["charts"], service)
                self.ansys_logo = self.__class__.ansys_logo(path + ["ansys_logo"], service)
                super().__init__(path, service)
            def graphics_title_window_framecolor(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_title_window_framecolor").execute(*args, **kwargs)
            def solution_mode_edge_color_in_meshing_mode(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/solution_mode_edge_color_in_meshing_mode").execute(*args, **kwargs)
            def number_of_files_recently_used(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/number_of_files_recently_used").execute(*args, **kwargs)
            def show_enabled_models(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/show_enabled_models").execute(*args, **kwargs)
            def titles(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/titles").execute(*args, **kwargs)
            def application_font_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/application_font_size").execute(*args, **kwargs)
            def color_theme(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/color_theme").execute(*args, **kwargs)
            def graphics_wall_face_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_wall_face_color").execute(*args, **kwargs)
            def pastel_color_value(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/pastel_color_value").execute(*args, **kwargs)
            def surface_emissivity(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/surface_emissivity").execute(*args, **kwargs)
            def custom_title_bar(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/custom_title_bar").execute(*args, **kwargs)
            def number_of_pastel_colors(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/number_of_pastel_colors").execute(*args, **kwargs)
            def model_color_scheme(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/model_color_scheme").execute(*args, **kwargs)
            def pastel_color_saturation(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/pastel_color_saturation").execute(*args, **kwargs)
            def show_interface_children_zone(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/show_interface_children_zone").execute(*args, **kwargs)
            def completer(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/completer").execute(*args, **kwargs)
            def ruler(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/ruler").execute(*args, **kwargs)
            def axis_triad(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/axis_triad").execute(*args, **kwargs)
            def graphics_background_style(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_background_style").execute(*args, **kwargs)
            def titles_border_offset(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/titles_border_offset").execute(*args, **kwargs)
            def graphics_default_manual_node_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_default_manual_node_color").execute(*args, **kwargs)
            def surface_specularity_for_contours(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/surface_specularity_for_contours").execute(*args, **kwargs)
            def graphics_edge_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_edge_color").execute(*args, **kwargs)
            def graphics_default_manual_face_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_default_manual_face_color").execute(*args, **kwargs)
            def graphics_background_color2(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_background_color2").execute(*args, **kwargs)
            def graphics_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_view").execute(*args, **kwargs)
            def graphics_partition_boundary_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_partition_boundary_color").execute(*args, **kwargs)
            def default_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/default_view").execute(*args, **kwargs)
            def quick_property_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/quick_property_view").execute(*args, **kwargs)
            def graphics_surface_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_surface_color").execute(*args, **kwargs)
            def group_by_tree_view(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/group_by_tree_view").execute(*args, **kwargs)
            def graphics_color_theme(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_color_theme").execute(*args, **kwargs)
            def graphics_background_color1(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_background_color1").execute(*args, **kwargs)
            def graphics_foreground_color(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/graphics_foreground_color").execute(*args, **kwargs)
            def show_model_edges(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/show_model_edges").execute(*args, **kwargs)
            def surface_specularity(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/appearance/surface_specularity").execute(*args, **kwargs)

            class selections(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def highlight_gloss(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_gloss").execute(*args, **kwargs)
                def probe_tooltip_show_delay_timer(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/probe_tooltip_show_delay_timer").execute(*args, **kwargs)
                def highlight_specular_component(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_specular_component").execute(*args, **kwargs)
                def general_displacement(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/general_displacement").execute(*args, **kwargs)
                def highlight_face_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_face_color").execute(*args, **kwargs)
                def mouse_hover_probe_values_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/mouse_hover_probe_values_enabled").execute(*args, **kwargs)
                def highlight_transparency(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_transparency").execute(*args, **kwargs)
                def highlight_edge_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_edge_color").execute(*args, **kwargs)
                def highlight_edge_weight(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/highlight_edge_weight").execute(*args, **kwargs)
                def mouse_over_highlight_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/mouse_over_highlight_enabled").execute(*args, **kwargs)
                def probe_tooltip_hide_delay_timer(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/selections/probe_tooltip_hide_delay_timer").execute(*args, **kwargs)

            class charts(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.text_color = self.__class__.text_color(path + ["text_color"], service)
                    self.font = self.__class__.font(path + ["font"], service)
                    super().__init__(path, service)
                def print_plot_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/print_plot_data").execute(*args, **kwargs)
                def legend_visibility(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/legend_visibility").execute(*args, **kwargs)
                def print_residuals_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/print_residuals_data").execute(*args, **kwargs)
                def curve_colors(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/curve_colors").execute(*args, **kwargs)
                def tooltip_interpolation(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/tooltip_interpolation").execute(*args, **kwargs)
                def plots_behavior(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/plots_behavior").execute(*args, **kwargs)
                def modern_plots_points_threshold(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/modern_plots_points_threshold").execute(*args, **kwargs)
                def legend_alignment(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/legend_alignment").execute(*args, **kwargs)
                def enable_open_glfor_modern_plots(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/enable_open_glfor_modern_plots").execute(*args, **kwargs)
                def threshold(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/threshold").execute(*args, **kwargs)
                def modern_plots_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/charts/modern_plots_enabled").execute(*args, **kwargs)

                class text_color(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def title(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/title").execute(*args, **kwargs)
                    def axes(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/axes").execute(*args, **kwargs)
                    def legend(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/legend").execute(*args, **kwargs)
                    def axes_titles(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/text_color/axes_titles").execute(*args, **kwargs)

                class font(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def legend(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/legend").execute(*args, **kwargs)
                    def axes(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/axes").execute(*args, **kwargs)
                    def title(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/title").execute(*args, **kwargs)
                    def axes_titles(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/appearance/charts/font/axes_titles").execute(*args, **kwargs)

            class ansys_logo(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def visible(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/ansys_logo/visible").execute(*args, **kwargs)
                def color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/appearance/ansys_logo/color").execute(*args, **kwargs)

        class gpuapp(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def alpha_features(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/gpuapp/alpha_features").execute(*args, **kwargs)

        class mat_pro_app(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def beta_features(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/mat_pro_app/beta_features").execute(*args, **kwargs)
            def focus(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/mat_pro_app/focus").execute(*args, **kwargs)
            def warning(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/mat_pro_app/warning").execute(*args, **kwargs)

        class graphics(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.lighting = self.__class__.lighting(path + ["lighting"], service)
                self.vector_settings = self.__class__.vector_settings(path + ["vector_settings"], service)
                self.material_effects = self.__class__.material_effects(path + ["material_effects"], service)
                self.colormap_settings = self.__class__.colormap_settings(path + ["colormap_settings"], service)
                self.embedded_windows = self.__class__.embedded_windows(path + ["embedded_windows"], service)
                self.hardcopy_settings = self.__class__.hardcopy_settings(path + ["hardcopy_settings"], service)
                self.performance = self.__class__.performance(path + ["performance"], service)
                self.transparency = self.__class__.transparency(path + ["transparency"], service)
                self.meshing_mode = self.__class__.meshing_mode(path + ["meshing_mode"], service)
                self.export_video_settings = self.__class__.export_video_settings(path + ["export_video_settings"], service)
                self.manage_hoops_memory = self.__class__.manage_hoops_memory(path + ["manage_hoops_memory"], service)
                self.graphics_effects = self.__class__.graphics_effects(path + ["graphics_effects"], service)
                self.boundary_markers = self.__class__.boundary_markers(path + ["boundary_markers"], service)
                super().__init__(path, service)
            def plot_legend_margin(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/plot_legend_margin").execute(*args, **kwargs)
            def graphics_window_point_symbol(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/graphics_window_point_symbol").execute(*args, **kwargs)
            def higher_resolution_graphics_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/higher_resolution_graphics_window_line_width").execute(*args, **kwargs)
            def show_hidden_surfaces(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/show_hidden_surfaces").execute(*args, **kwargs)
            def scroll_wheel_event_end_timer(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/scroll_wheel_event_end_timer").execute(*args, **kwargs)
            def rotation_centerpoint_visible(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/rotation_centerpoint_visible").execute(*args, **kwargs)
            def marker_drawing_mode(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/marker_drawing_mode").execute(*args, **kwargs)
            def show_hidden_lines(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/show_hidden_lines").execute(*args, **kwargs)
            def hidden_surface_removal_method(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/hidden_surface_removal_method").execute(*args, **kwargs)
            def set_camera_normal_to_surface_increments(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/set_camera_normal_to_surface_increments").execute(*args, **kwargs)
            def test_use_external_function(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/test_use_external_function").execute(*args, **kwargs)
            def force_key_frame_animation_markers_to_off(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/force_key_frame_animation_markers_to_off").execute(*args, **kwargs)
            def max_graphics_text_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/max_graphics_text_size").execute(*args, **kwargs)
            def switch_to_open_glfor_remote_visualization(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/switch_to_open_glfor_remote_visualization").execute(*args, **kwargs)
            def min_graphics_text_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/min_graphics_text_size").execute(*args, **kwargs)
            def point_tool_size(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/point_tool_size").execute(*args, **kwargs)
            def double_buffering(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/double_buffering").execute(*args, **kwargs)
            def remove_partition_lines(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/remove_partition_lines").execute(*args, **kwargs)
            def enable_non_object_based_workflow(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/enable_non_object_based_workflow").execute(*args, **kwargs)
            def lower_resolution_graphics_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/lower_resolution_graphics_window_line_width").execute(*args, **kwargs)
            def animation_option(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/animation_option").execute(*args, **kwargs)
            def remove_partition_lines_tolerance(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/remove_partition_lines_tolerance").execute(*args, **kwargs)
            def event_poll_timeout(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/event_poll_timeout").execute(*args, **kwargs)
            def graphics_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/graphics_window_line_width").execute(*args, **kwargs)
            def event_poll_interval(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/event_poll_interval").execute(*args, **kwargs)
            def text_window_line_width(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/graphics/text_window_line_width").execute(*args, **kwargs)

            class lighting(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def ambient_light_intensity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/ambient_light_intensity").execute(*args, **kwargs)
                def headlight(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/headlight").execute(*args, **kwargs)
                def headlight_intensity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/headlight_intensity").execute(*args, **kwargs)
                def lighting_method(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/lighting/lighting_method").execute(*args, **kwargs)

            class vector_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def arrowhead3_dradius1_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/arrowhead3_dradius1_factor").execute(*args, **kwargs)
                def arrow3_dradius1_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/arrow3_dradius1_factor").execute(*args, **kwargs)
                def arrow3_dradius2_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/arrow3_dradius2_factor").execute(*args, **kwargs)
                def line_arrow3_dperpendicular_radius(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/vector_settings/line_arrow3_dperpendicular_radius").execute(*args, **kwargs)

            class material_effects(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def tiling_style(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/material_effects/tiling_style").execute(*args, **kwargs)
                def decimation_filter(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/material_effects/decimation_filter").execute(*args, **kwargs)
                def parameterization_source(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/material_effects/parameterization_source").execute(*args, **kwargs)

            class colormap_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def major_length_to_screen_ratio_when_horizontal(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/major_length_to_screen_ratio_when_horizontal").execute(*args, **kwargs)
                def log_scale(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/log_scale").execute(*args, **kwargs)
                def border_style(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/border_style").execute(*args, **kwargs)
                def aspect_ratio_when_vertical(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/aspect_ratio_when_vertical").execute(*args, **kwargs)
                def text_font_automatic_units(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_units").execute(*args, **kwargs)
                def auto_refit_on_resize(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/auto_refit_on_resize").execute(*args, **kwargs)
                def text_font_name(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_name").execute(*args, **kwargs)
                def skip_value(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/skip_value").execute(*args, **kwargs)
                def levels(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/levels").execute(*args, **kwargs)
                def margin_from_edge_to_screen_ratio(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/margin_from_edge_to_screen_ratio").execute(*args, **kwargs)
                def text_font_fixed_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_size").execute(*args, **kwargs)
                def text_font_automatic_vertical_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_vertical_size").execute(*args, **kwargs)
                def type(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/type").execute(*args, **kwargs)
                def text_font_fixed_units(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_units").execute(*args, **kwargs)
                def labels(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/labels").execute(*args, **kwargs)
                def text_truncation_limit_for_vertical_colormaps(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_truncation_limit_for_vertical_colormaps").execute(*args, **kwargs)
                def min_size_scale_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/min_size_scale_factor").execute(*args, **kwargs)
                def text_truncation_limit_for_horizontal_colormaps(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_truncation_limit_for_horizontal_colormaps").execute(*args, **kwargs)
                def number_format_precision(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/number_format_precision").execute(*args, **kwargs)
                def use_no_sub_windows(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/use_no_sub_windows").execute(*args, **kwargs)
                def text_font_fixed_vertical_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_vertical_size").execute(*args, **kwargs)
                def aspect_ratio_when_horizontal(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/aspect_ratio_when_horizontal").execute(*args, **kwargs)
                def max_size_scale_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/max_size_scale_factor").execute(*args, **kwargs)
                def text_font_automatic_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_size").execute(*args, **kwargs)
                def text_font_fixed_horizontal_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_fixed_horizontal_size").execute(*args, **kwargs)
                def colormap(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/colormap").execute(*args, **kwargs)
                def alignment(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/alignment").execute(*args, **kwargs)
                def automatic_resize(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/automatic_resize").execute(*args, **kwargs)
                def preserve_aspect_ratio_for_hardcopy(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/preserve_aspect_ratio_for_hardcopy").execute(*args, **kwargs)
                def show_colormap(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/show_colormap").execute(*args, **kwargs)
                def major_length_to_screen_ratio_when_vertical(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/major_length_to_screen_ratio_when_vertical").execute(*args, **kwargs)
                def text_behavior(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_behavior").execute(*args, **kwargs)
                def text_font_automatic_horizontal_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/text_font_automatic_horizontal_size").execute(*args, **kwargs)
                def isolines_position_offset(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/isolines_position_offset").execute(*args, **kwargs)
                def number_format_type(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/colormap_settings/number_format_type").execute(*args, **kwargs)

            class embedded_windows(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def default_embedded_windows_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/default_embedded_windows_view").execute(*args, **kwargs)
                def default_embedded_mesh_windows_view(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/default_embedded_mesh_windows_view").execute(*args, **kwargs)
                def show_border_for_embedded_window(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/show_border_for_embedded_window").execute(*args, **kwargs)
                def save_embedded_window_layout(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/embedded_windows/save_embedded_window_layout").execute(*args, **kwargs)

            class hardcopy_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def post_script_permission_override(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/post_script_permission_override").execute(*args, **kwargs)
                def hardcopy_line_width(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/hardcopy_line_width").execute(*args, **kwargs)
                def save_embedded_hardcopies_separately(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/save_embedded_hardcopies_separately").execute(*args, **kwargs)
                def export_edges_for_avz(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/export_edges_for_avz").execute(*args, **kwargs)
                def transparent_embedded_windows(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/transparent_embedded_windows").execute(*args, **kwargs)
                def hardcopy_driver(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/hardcopy_driver").execute(*args, **kwargs)
                def hardware_image_accel(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/hardware_image_accel").execute(*args, **kwargs)
                def save_embedded_windows_in_hardcopy(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/hardcopy_settings/save_embedded_windows_in_hardcopy").execute(*args, **kwargs)

            class performance(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.fast_display_mode = self.__class__.fast_display_mode(path + ["fast_display_mode"], service)
                    self.minimum_frame_rate = self.__class__.minimum_frame_rate(path + ["minimum_frame_rate"], service)
                    super().__init__(path, service)
                def ratio_of_target_frame_rate_to_classify_heavy_geometry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/performance/ratio_of_target_frame_rate_to_classify_heavy_geometry").execute(*args, **kwargs)
                def optimize_for(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/performance/optimize_for").execute(*args, **kwargs)
                def ratio_of_target_frame_rate_to_declassify_heavy_geometry(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/performance/ratio_of_target_frame_rate_to_declassify_heavy_geometry").execute(*args, **kwargs)

                class fast_display_mode(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def silhouette_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/silhouette_shown").execute(*args, **kwargs)
                    def perimeter_edges_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/perimeter_edges_shown").execute(*args, **kwargs)
                    def faces_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/faces_shown").execute(*args, **kwargs)
                    def transparency(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/transparency").execute(*args, **kwargs)
                    def nodes_shown(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/nodes_shown").execute(*args, **kwargs)
                    def markers_decimation(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/markers_decimation").execute(*args, **kwargs)
                    def culling(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/culling").execute(*args, **kwargs)
                    def status(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/fast_display_mode/status").execute(*args, **kwargs)

                class minimum_frame_rate(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def fixed_culling_value(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/fixed_culling_value").execute(*args, **kwargs)
                    def maximum_culling_threshold(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/maximum_culling_threshold").execute(*args, **kwargs)
                    def enabled(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/enabled").execute(*args, **kwargs)
                    def minimum_culling_threshold(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/minimum_culling_threshold").execute(*args, **kwargs)
                    def target_fps(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/target_fps").execute(*args, **kwargs)
                    def dynamic_adjustment(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/performance/minimum_frame_rate/dynamic_adjustment").execute(*args, **kwargs)

            class transparency(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def depth_peeling_layers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/depth_peeling_layers").execute(*args, **kwargs)
                def depth_peeling_preference(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/depth_peeling_preference").execute(*args, **kwargs)
                def zsort_options(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/zsort_options").execute(*args, **kwargs)
                def quick_moves(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/quick_moves").execute(*args, **kwargs)
                def algorithm_for_modern_drivers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/transparency/algorithm_for_modern_drivers").execute(*args, **kwargs)

            class meshing_mode(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def graphics_window_display_timeout_value(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/meshing_mode/graphics_window_display_timeout_value").execute(*args, **kwargs)
                def graphics_window_display_timeout(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/meshing_mode/graphics_window_display_timeout").execute(*args, **kwargs)

            class export_video_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.advanced_video_quality_options = self.__class__.advanced_video_quality_options(path + ["advanced_video_quality_options"], service)
                    super().__init__(path, service)
                def video_resoution_y(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_resoution_y").execute(*args, **kwargs)
                def video_use_frame_resolution(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_use_frame_resolution").execute(*args, **kwargs)
                def video_smooth_scaling(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_smooth_scaling").execute(*args, **kwargs)
                def video_fps(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_fps").execute(*args, **kwargs)
                def video_scale(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_scale").execute(*args, **kwargs)
                def video_resoution_x(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_resoution_x").execute(*args, **kwargs)
                def video_format(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_format").execute(*args, **kwargs)
                def video_quality(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/export_video_settings/video_quality").execute(*args, **kwargs)

                class advanced_video_quality_options(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def compression_method(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/compression_method").execute(*args, **kwargs)
                    def bit_rate_quality(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/bit_rate_quality").execute(*args, **kwargs)
                    def bitrate(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/bitrate").execute(*args, **kwargs)
                    def enable_h264(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/graphics/export_video_settings/advanced_video_quality_options/enable_h264").execute(*args, **kwargs)

            class manage_hoops_memory(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/manage_hoops_memory/enabled").execute(*args, **kwargs)
                def hsfimport_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/manage_hoops_memory/hsfimport_limit").execute(*args, **kwargs)

            class graphics_effects(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def show_marker_reflections(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/show_marker_reflections").execute(*args, **kwargs)
                def grid_plane_offset(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_offset").execute(*args, **kwargs)
                def reflections_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/reflections_enabled").execute(*args, **kwargs)
                def ambient_occlusion_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/ambient_occlusion_enabled").execute(*args, **kwargs)
                def bloom_blur(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/bloom_blur").execute(*args, **kwargs)
                def ambient_occlusion_strength(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/ambient_occlusion_strength").execute(*args, **kwargs)
                def shadow_map_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/shadow_map_enabled").execute(*args, **kwargs)
                def bloom_strength(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/bloom_strength").execute(*args, **kwargs)
                def grid_plane_size_factor(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_size_factor").execute(*args, **kwargs)
                def ambient_occlusion_quality(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/ambient_occlusion_quality").execute(*args, **kwargs)
                def bloom_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/bloom_enabled").execute(*args, **kwargs)
                def grid_plane_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_enabled").execute(*args, **kwargs)
                def grid_plane_count(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_plane_count").execute(*args, **kwargs)
                def grid_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/grid_color").execute(*args, **kwargs)
                def plane_direction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/plane_direction").execute(*args, **kwargs)
                def anti_aliasing(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/anti_aliasing").execute(*args, **kwargs)
                def update_after_mouse_release(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/update_after_mouse_release").execute(*args, **kwargs)
                def show_edge_reflections(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/show_edge_reflections").execute(*args, **kwargs)
                def simple_shadows_enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/graphics_effects/simple_shadows_enabled").execute(*args, **kwargs)

            class boundary_markers(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def show_inlet_markers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/show_inlet_markers").execute(*args, **kwargs)
                def enabled(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/enabled").execute(*args, **kwargs)
                def outlet_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/outlet_color").execute(*args, **kwargs)
                def markers_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/markers_limit").execute(*args, **kwargs)
                def exclude_from_bounding(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/exclude_from_bounding").execute(*args, **kwargs)
                def marker_fraction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/marker_fraction").execute(*args, **kwargs)
                def scale_marker(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/scale_marker").execute(*args, **kwargs)
                def color_option(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/color_option").execute(*args, **kwargs)
                def inlet_color(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/inlet_color").execute(*args, **kwargs)
                def show_outlet_markers(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/show_outlet_markers").execute(*args, **kwargs)
                def marker_size_limiting_scale_multiplier(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/graphics/boundary_markers/marker_size_limiting_scale_multiplier").execute(*args, **kwargs)

        class navigation(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.mouse_mapping = self.__class__.mouse_mapping(path + ["mouse_mapping"], service)
                super().__init__(path, service)

            class mouse_mapping(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.additional = self.__class__.additional(path + ["additional"], service)
                    self.basic = self.__class__.basic(path + ["basic"], service)
                    super().__init__(path, service)
                def mousemaptheme(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/navigation/mouse_mapping/mousemaptheme").execute(*args, **kwargs)

                class additional(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def ctrlmmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlmmbdrag").execute(*args, **kwargs)
                    def ctrlrmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlrmbdrag").execute(*args, **kwargs)
                    def ctrllmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrllmbdrag").execute(*args, **kwargs)
                    def shiftlmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftlmbdrag").execute(*args, **kwargs)
                    def mousewheelsensitivity(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/mousewheelsensitivity").execute(*args, **kwargs)
                    def mouseprobe(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/mouseprobe").execute(*args, **kwargs)
                    def ctrlrmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlrmbclick").execute(*args, **kwargs)
                    def shiftlmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftlmbclick").execute(*args, **kwargs)
                    def mousewheel(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/mousewheel").execute(*args, **kwargs)
                    def shiftrmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftrmbdrag").execute(*args, **kwargs)
                    def ctrllmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrllmbclick").execute(*args, **kwargs)
                    def ctrlmmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/ctrlmmbclick").execute(*args, **kwargs)
                    def reversewheeldirection(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/reversewheeldirection").execute(*args, **kwargs)
                    def shiftmmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftmmbclick").execute(*args, **kwargs)
                    def shiftrmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftrmbclick").execute(*args, **kwargs)
                    def shiftmmbdrag(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/additional/shiftmmbdrag").execute(*args, **kwargs)

                class basic(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/rmbclick").execute(*args, **kwargs)
                    def lmb(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/lmb").execute(*args, **kwargs)
                    def mmb(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/mmb").execute(*args, **kwargs)
                    def rmb(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/rmb").execute(*args, **kwargs)
                    def mmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/mmbclick").execute(*args, **kwargs)
                    def lmbclick(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/preferences/navigation/mouse_mapping/basic/lmbclick").execute(*args, **kwargs)

        class simulation(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.report_definitions = self.__class__.report_definitions(path + ["report_definitions"], service)
                super().__init__(path, service)
            def flow_model(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/simulation/flow_model").execute(*args, **kwargs)
            def local_residual_scaling(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/simulation/local_residual_scaling").execute(*args, **kwargs)

            class report_definitions(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def automatic_plot_file(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/simulation/report_definitions/automatic_plot_file").execute(*args, **kwargs)
                def report_plot_history_data_size(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/simulation/report_definitions/report_plot_history_data_size").execute(*args, **kwargs)

        class general(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def enable_parametric_study(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/enable_parametric_study").execute(*args, **kwargs)
            def laplace_auto_partition_default(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/laplace_auto_partition_default").execute(*args, **kwargs)
            def automatic_transcript(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/automatic_transcript").execute(*args, **kwargs)
            def key_behavioral_changes_message(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/key_behavioral_changes_message").execute(*args, **kwargs)
            def initial_physics_volume_definitions(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/initial_physics_volume_definitions").execute(*args, **kwargs)
            def flow_model(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/flow_model").execute(*args, **kwargs)
            def advanced_partition(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/advanced_partition").execute(*args, **kwargs)
            def dock_editor(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/dock_editor").execute(*args, **kwargs)
            def idle_timeout(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/idle_timeout").execute(*args, **kwargs)
            def qaservice_message(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/qaservice_message").execute(*args, **kwargs)
            def default_ioformat(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/default_ioformat").execute(*args, **kwargs)
            def utlmode(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/utlmode").execute(*args, **kwargs)
            def utlcreate_physics_on_mode_change(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/general/utlcreate_physics_on_mode_change").execute(*args, **kwargs)

        class parametric_study(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.update_options = self.__class__.update_options(path + ["update_options"], service)
                self.layout_options = self.__class__.layout_options(path + ["layout_options"], service)
                super().__init__(path, service)

            class update_options(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def save_project_after_dpupdate(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/save_project_after_dpupdate").execute(*args, **kwargs)
                def capture_sim_report_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/capture_sim_report_data").execute(*args, **kwargs)
                def write_data(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/write_data").execute(*args, **kwargs)
                def auto_refresh_time(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/auto_refresh_time").execute(*args, **kwargs)
                def enable_auto_refresh(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/update_options/enable_auto_refresh").execute(*args, **kwargs)

            class layout_options(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def current_case_parameters(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/layout_options/current_case_parameters").execute(*args, **kwargs)
                def parametric_study_tree(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/parametric_study/layout_options/parametric_study_tree").execute(*args, **kwargs)

        class turbo_workflow(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.face_zone_settings = self.__class__.face_zone_settings(path + ["face_zone_settings"], service)
                self.graphics_settings = self.__class__.graphics_settings(path + ["graphics_settings"], service)
                self.cell_zone_settings = self.__class__.cell_zone_settings(path + ["cell_zone_settings"], service)
                super().__init__(path, service)
            def save_checkpoint_files(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/turbo_workflow/save_checkpoint_files").execute(*args, **kwargs)
            def checkpointing_option(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/turbo_workflow/checkpointing_option").execute(*args, **kwargs)

            class face_zone_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def periodic2_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/periodic2_region").execute(*args, **kwargs)
                def interior_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/interior_region").execute(*args, **kwargs)
                def symmetry_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/symmetry_region").execute(*args, **kwargs)
                def tip1_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/tip1_region").execute(*args, **kwargs)
                def fzsearch_order(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/fzsearch_order").execute(*args, **kwargs)
                def outlet_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/outlet_region").execute(*args, **kwargs)
                def blade_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/blade_region").execute(*args, **kwargs)
                def shroud_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/shroud_region").execute(*args, **kwargs)
                def periodic1_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/periodic1_region").execute(*args, **kwargs)
                def inlet_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/inlet_region").execute(*args, **kwargs)
                def hub_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/hub_region").execute(*args, **kwargs)
                def tip2_region(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/face_zone_settings/tip2_region").execute(*args, **kwargs)

            class graphics_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def auto_draw(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/graphics_settings/auto_draw").execute(*args, **kwargs)

            class cell_zone_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def stationary(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/cell_zone_settings/stationary").execute(*args, **kwargs)
                def czsearch_order(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/cell_zone_settings/czsearch_order").execute(*args, **kwargs)
                def rotating(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/turbo_workflow/cell_zone_settings/rotating").execute(*args, **kwargs)

        class meshing_workflow(TUIMenu):
            """
            .
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.draw_settings = self.__class__.draw_settings(path + ["draw_settings"], service)
                super().__init__(path, service)
            def templates_folder(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/templates_folder").execute(*args, **kwargs)
            def save_checkpoint_files(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/save_checkpoint_files").execute(*args, **kwargs)
            def temp_folder(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/temp_folder").execute(*args, **kwargs)
            def verbosity(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/verbosity").execute(*args, **kwargs)
            def checkpointing_option(self, *args, **kwargs):
                """
                .
                """
                return PyMenu(self.service, "/preferences/meshing_workflow/checkpointing_option").execute(*args, **kwargs)

            class draw_settings(TUIMenu):
                """
                .
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def face_zone_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/meshing_workflow/draw_settings/face_zone_limit").execute(*args, **kwargs)
                def auto_draw(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/meshing_workflow/draw_settings/auto_draw").execute(*args, **kwargs)
                def facet_limit(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/preferences/meshing_workflow/draw_settings/facet_limit").execute(*args, **kwargs)

    class plot(TUIMenu):
        """
        Enter the XY plot menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.ansys_sound_analysis = self.__class__.ansys_sound_analysis(path + ["ansys_sound_analysis"], service)
            self.flamelet_curves = self.__class__.flamelet_curves(path + ["flamelet_curves"], service)
            self.cumulative_plot = self.__class__.cumulative_plot(path + ["cumulative_plot"], service)
            super().__init__(path, service)
        def circum_avg_radial(self, *args, **kwargs):
            """
            Computes iso-radial band surfaces and plots data vs. radius on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_radial").execute(*args, **kwargs)
        def residuals(self, *args, **kwargs):
            """
            Contains commands that allow you to select the variables for which you want to display XY plots of residual histories in the active graphics window.
            """
            return PyMenu(self.service, "/plot/residuals").execute(*args, **kwargs)
        def plot_direction(self, *args, **kwargs):
            """
            Sets plot direction for XY plot.
            """
            return PyMenu(self.service, "/plot/plot_direction").execute(*args, **kwargs)
        def fft(self, *args, **kwargs):
            """
            Plots fast Fourier transform (FFT) of file data. If you respond yes to Acoustic Analysis?, then additional Y axis functions are made available.
            """
            return PyMenu(self.service, "/plot/fft").execute(*args, **kwargs)
        def datasources(self, *args, **kwargs):
            """
            Enters the menu for creating and modifying plots containing multiple data sources.
            """
            return PyMenu(self.service, "/plot/datasources").execute(*args, **kwargs)
        def solution_set(self, *args, **kwargs):
            """
            Sets solution plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/solution_set").execute(*args, **kwargs)
        def file_set(self, *args, **kwargs):
            """
            Sets file plot parameters.
            """
            return PyMenu(self.service, "/plot/file_set").execute(*args, **kwargs)
        def solution(self, *args, **kwargs):
            """
            Plots solution on surfaces and/or zones. Zone and surface names can be indicated using a  wildcard (\*).
            """
            return PyMenu(self.service, "/plot/solution").execute(*args, **kwargs)
        def residuals_set(self, *args, **kwargs):
            """
            Sets residual plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/residuals_set").execute(*args, **kwargs)
        def plot(self, *args, **kwargs):
            """
            Plots solution on surfaces.
            """
            return PyMenu(self.service, "/plot/plot").execute(*args, **kwargs)
        def label_alignment(self, *args, **kwargs):
            """
            Set the orientation of XY plot axis labels as either horizontal or axis-aligned.
            """
            return PyMenu(self.service, "/plot/label_alignment").execute(*args, **kwargs)
        def set_boundary_val_off(self, *args, **kwargs):
            """
            Disables the use of boundary face values when node values are disabled in solution XY plots. This option is disabled by default, that is, boundary face values are used when node values are disabled.
            """
            return PyMenu(self.service, "/plot/set_boundary_val_off").execute(*args, **kwargs)
        def file_list(self, *args, **kwargs):
            """
            Plots data from multiple external files.
            """
            return PyMenu(self.service, "/plot/file_list").execute(*args, **kwargs)
        def circum_avg_axial(self, *args, **kwargs):
            """
            Computes iso-axial band surfaces and plots data vs. axial coordinate on them.
            """
            return PyMenu(self.service, "/plot/circum_avg_axial").execute(*args, **kwargs)
        def histogram_set(self, *args, **kwargs):
            """
            Sets histogram plot parameters. Sub-menu items are the same as file-set/ above.
            """
            return PyMenu(self.service, "/plot/histogram_set").execute(*args, **kwargs)
        def change_fft_ref_pressure(self, *args, **kwargs):
            """
            Changes reference acoustic pressure.
            """
            return PyMenu(self.service, "/plot/change_fft_ref_pressure").execute(*args, **kwargs)
        def fft_set(self, *args, **kwargs):
            """
            Enter the menu to set histogram plot parameters.
            """
            return PyMenu(self.service, "/plot/fft_set").execute(*args, **kwargs)
        def file(self, *args, **kwargs):
            """
            Plots data from an external file.
            """
            return PyMenu(self.service, "/plot/file").execute(*args, **kwargs)
        def histogram(self, *args, **kwargs):
            """
            Plots a histogram of the specified solution variable using the defined range and number of intervals.
            """
            return PyMenu(self.service, "/plot/histogram").execute(*args, **kwargs)
        def display_profile_data(self, *args, **kwargs):
            """
            Plots profile data.
            """
            return PyMenu(self.service, "/plot/display_profile_data").execute(*args, **kwargs)

        class ansys_sound_analysis(TUIMenu):
            """
            Enter the Ansys sound analysis menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def print_indicators(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before printing the acoustics indicators.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/print_indicators").execute(*args, **kwargs)
            def write_files(self, *args, **kwargs):
                """
                Read in a pressure signal or spectrum file, then optionally read in a frequency response function (FRF) or transfer function file, before writing a WAV, output pressure, and/or acoustic indicators file.
                """
                return PyMenu(self.service, "/plot/ansys_sound_analysis/write_files").execute(*args, **kwargs)

        class flamelet_curves(TUIMenu):
            """
            Enters the flamelet curves menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def write_to_file(self, *args, **kwargs):
                """
                Writes curve to a file instead of plot.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/write_to_file").execute(*args, **kwargs)
            def plot_curves(self, *args, **kwargs):
                """
                Plots of a curve property.
                """
                return PyMenu(self.service, "/plot/flamelet_curves/plot_curves").execute(*args, **kwargs)

        class cumulative_plot(TUIMenu):
            """
            Plot the development of force, force coefficient, moment, or moment coefficient across the specified wall zones.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def list(self, *args, **kwargs):
                """
                Print the names of the existing cumulative plot objects to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/edit").execute(*args, **kwargs)
            def plot(self, *args, **kwargs):
                """
                Plot a cumulative plot in the graphics window.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/plot").execute(*args, **kwargs)
            def add(self, *args, **kwargs):
                """
                Create a new cumulative plot.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/add").execute(*args, **kwargs)
            def list_properties(self, *args, **kwargs):
                """
                Print the properties of the specified cumulative plot object to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/list_properties").execute(*args, **kwargs)
            def curves(self, *args, **kwargs):
                """
                Set curves options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/curves").execute(*args, **kwargs)
            def print(self, *args, **kwargs):
                """
                Print the value of a cumulative plot to the console.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/print").execute(*args, **kwargs)
            def write(self, *args, **kwargs):
                """
                Write a cumulative plot to a file.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/write").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an existing cumulative plot object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/delete").execute(*args, **kwargs)
            def axes(self, *args, **kwargs):
                """
                Set axes options of an object.
                """
                return PyMenu(self.service, "/plot/cumulative_plot/axes").execute(*args, **kwargs)

    class turbo_workflow(TUIMenu):
        """
        Enter the turbo workflow menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.workflow = self.__class__.workflow(path + ["workflow"], service)
            super().__init__(path, service)

        class workflow(TUIMenu):
            """
            Enter the workflow menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                super().__init__(path, service)
            def enable(self, *args, **kwargs):
                """
                Enable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/enable").execute(*args, **kwargs)
            def reset(self, *args, **kwargs):
                """
                Reset the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/reset").execute(*args, **kwargs)
            def disable(self, *args, **kwargs):
                """
                Disable the workflow.
                """
                return PyMenu(self.service, "/turbo_workflow/workflow/disable").execute(*args, **kwargs)

    class setup(TUIMenu):
        """
        Enter setup menu.
        """
        def __init__(self, path, service):
            self.path = path
            self.service = service
            self.gap_model = self.__class__.gap_model(path + ["gap_model"], service)
            self.models = self.__class__.models(path + ["models"], service)
            self.turbo_model = self.__class__.turbo_model(path + ["turbo_model"], service)
            self.mesh_interfaces = self.__class__.mesh_interfaces(path + ["mesh_interfaces"], service)
            self.named_expressions = self.__class__.named_expressions(path + ["named_expressions"], service)
            self.reference_frames = self.__class__.reference_frames(path + ["reference_frames"], service)
            self.boundary_conditions = self.__class__.boundary_conditions(path + ["boundary_conditions"], service)
            self.overset_interfaces = self.__class__.overset_interfaces(path + ["overset_interfaces"], service)
            self.reference_values = self.__class__.reference_values(path + ["reference_values"], service)
            self.operating_conditions = self.__class__.operating_conditions(path + ["operating_conditions"], service)
            self.mixing_planes = self.__class__.mixing_planes(path + ["mixing_planes"], service)
            self.materials = self.__class__.materials(path + ["materials"], service)
            self.dynamic_mesh = self.__class__.dynamic_mesh(path + ["dynamic_mesh"], service)
            self.expert = self.__class__.expert(path + ["expert"], service)
            super().__init__(path, service)

        class gap_model(TUIMenu):
            """
            Enter the narrow-gaps menu.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.advanced_options = self.__class__.advanced_options(path + ["advanced_options"], service)
                super().__init__(path, service)
            def list_gap_cell_zones(self, *args, **kwargs):
                """
                List name of the gap cells zones that can be used as exclided cell zones in gaps creation.
                """
                return PyMenu(self.service, "/setup/gap_model/list_gap_cell_zones").execute(*args, **kwargs)
            def edit(self, *args, **kwargs):
                """
                Edit an exiting gap object.
                """
                return PyMenu(self.service, "/setup/gap_model/edit").execute(*args, **kwargs)
            def list_gap_face_zones(self, *args, **kwargs):
                """
                List name of the gap face zones that can be used for gaps creation.
                """
                return PyMenu(self.service, "/setup/gap_model/list_gap_face_zones").execute(*args, **kwargs)
            def render_gap_regions(self, *args, **kwargs):
                """
                Update gap regions for postprocessing.
                """
                return PyMenu(self.service, "/setup/gap_model/render_gap_regions").execute(*args, **kwargs)
            def create(self, *args, **kwargs):
                """
                Create a gap object.
                """
                return PyMenu(self.service, "/setup/gap_model/create").execute(*args, **kwargs)
            def delete(self, *args, **kwargs):
                """
                Delete an exiting gap object.
                """
                return PyMenu(self.service, "/setup/gap_model/delete").execute(*args, **kwargs)
            def list_gap_regions(self, *args, **kwargs):
                """
                List gap regions.
                """
                return PyMenu(self.service, "/setup/gap_model/list_gap_regions").execute(*args, **kwargs)
            def delete_all(self, *args, **kwargs):
                """
                Delete all of the exiting gap objects.
                """
                return PyMenu(self.service, "/setup/gap_model/delete_all").execute(*args, **kwargs)
            def enable(self, *args, **kwargs):
                """
                Enable/Disable gap model.
                """
                return PyMenu(self.service, "/setup/gap_model/enable").execute(*args, **kwargs)

            class advanced_options(TUIMenu):
                """
                Show options.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def extend_gap_regions(self, *args, **kwargs):
                    """
                    Extend gap regions for better convergence.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/extend_gap_regions").execute(*args, **kwargs)
                def update_gap_regions(self, *args, **kwargs):
                    """
                    Update gap regions and gap model solution information.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/update_gap_regions").execute(*args, **kwargs)
                def solution_stabilization(self, *args, **kwargs):
                    """
                    Set solution stabilization level for gap model.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/solution_stabilization").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    Set the verbosity for gap model.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/verbosity").execute(*args, **kwargs)
                def reduce_gap_regions(self, *args, **kwargs):
                    """
                    Using a more restrictive algorithm for marking cells in gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/reduce_gap_regions").execute(*args, **kwargs)
                def render_flow_modeling_gaps(self, *args, **kwargs):
                    """
                    Render solution inside flow modeling gap cells.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/render_flow_modeling_gaps").execute(*args, **kwargs)
                def revert_controls_to_default(self, *args, **kwargs):
                    """
                    Revert gap stabilization and any related solver settings to default.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/revert_controls_to_default").execute(*args, **kwargs)
                def expert(self, *args, **kwargs):
                    """
                    Enable expert options for gap model.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/expert").execute(*args, **kwargs)
                def precise_gap_marking(self, *args, **kwargs):
                    """
                    Mark cells in gap regions using more accurate search algorithm.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/precise_gap_marking").execute(*args, **kwargs)
                def flow_blocking_stabilization_parameters(self, *args, **kwargs):
                    """
                    Adjust stabilization settings for the sponge layer used for blocked gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/flow_blocking_stabilization_parameters").execute(*args, **kwargs)
                def clear_gap_regions(self, *args, **kwargs):
                    """
                    Clear gap model solution information and marks.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/clear_gap_regions").execute(*args, **kwargs)
                def cell_check_distance_factor(self, *args, **kwargs):
                    """
                    Enter value of the cell distance factor.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/cell_check_distance_factor").execute(*args, **kwargs)
                def render_gap_interface(self, *args, **kwargs):
                    """
                    Render gap interface.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/render_gap_interface").execute(*args, **kwargs)
                def check_cfl_condition(self, *args, **kwargs):
                    """
                    Check time step size for better convergence.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/check_cfl_condition").execute(*args, **kwargs)
                def enhanced_data_interpolation(self, *args, **kwargs):
                    """
                    Use enhanced data interpolation for updating information in gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/enhanced_data_interpolation").execute(*args, **kwargs)
                def alternative_marking(self, *args, **kwargs):
                    """
                    Mark gap regions using an alternative marking algorithm.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/alternative_marking").execute(*args, **kwargs)
                def include_coupled_walls(self, *args, **kwargs):
                    """
                    Include coupled walls in gap face zones.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/include_coupled_walls").execute(*args, **kwargs)
                def sponge_layer(self, *args, **kwargs):
                    """
                    Set advanced settings for gap sponge layer.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/sponge_layer").execute(*args, **kwargs)
                def fill_data_in_gap_regions(self, *args, **kwargs):
                    """
                    Interpolate solution data into the whole gap regions.
                    """
                    return PyMenu(self.service, "/setup/gap_model/advanced_options/fill_data_in_gap_regions").execute(*args, **kwargs)

        class models(TUIMenu):
            """
            Enter the models menu to configure the solver.
            """
            def __init__(self, path, service):
                self.path = path
                self.service = service
                self.nox_parameters = self.__class__.nox_parameters(path + ["nox_parameters"], service)
                self.viscous = self.__class__.viscous(path + ["viscous"], service)
                self.optics = self.__class__.optics(path + ["optics"], service)
                self.two_temperature = self.__class__.two_temperature(path + ["two_temperature"], service)
                self.dpm = self.__class__.dpm(path + ["dpm"], service)
                self.species = self.__class__.species(path + ["species"], service)
                self.cht = self.__class__.cht(path + ["cht"], service)
                self.shell_conduction = self.__class__.shell_conduction(path + ["shell_conduction"], service)
                self.heat_exchanger = self.__class__.heat_exchanger(path + ["heat_exchanger"], service)
                self.radiation = self.__class__.radiation(path + ["radiation"], service)
                self.eulerian_wallfilm = self.__class__.eulerian_wallfilm(path + ["eulerian_wallfilm"], service)
                self.structure = self.__class__.structure(path + ["structure"], service)
                self.electrolysis = self.__class__.electrolysis(path + ["electrolysis"], service)
                self.multiphase = self.__class__.multiphase(path + ["multiphase"], service)
                self.solver = self.__class__.solver(path + ["solver"], service)
                self.acoustics = self.__class__.acoustics(path + ["acoustics"], service)
                self.system_coupling_settings = self.__class__.system_coupling_settings(path + ["system_coupling_settings"], service)
                self.soot_parameters = self.__class__.soot_parameters(path + ["soot_parameters"], service)
                super().__init__(path, service)
            def nox(self, *args, **kwargs):
                """
                Enable/disable the NOx model.
                """
                return PyMenu(self.service, "/setup/models/nox").execute(*args, **kwargs)
            def unsteady_2nd_order(self, *args, **kwargs):
                """
                Enable/disable the second-order unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_2nd_order").execute(*args, **kwargs)
            def potential_and_li_ion_battery(self, *args, **kwargs):
                """
                Enable/disable the electric-potential model.
                """
                return PyMenu(self.service, "/setup/models/potential_and_li_ion_battery").execute(*args, **kwargs)
            def soot(self, *args, **kwargs):
                """
                Enable/disable the soot model.
                """
                return PyMenu(self.service, "/setup/models/soot").execute(*args, **kwargs)
            def crevice_model(self, *args, **kwargs):
                """
                Enable/disable the crevice model.
                """
                return PyMenu(self.service, "/setup/models/crevice_model").execute(*args, **kwargs)
            def swirl(self, *args, **kwargs):
                """
                Enable/disable axisymmetric swirl velocity.
                """
                return PyMenu(self.service, "/setup/models/swirl").execute(*args, **kwargs)
            def addon_module(self, *args, **kwargs):
                """
                Load addon module.
                """
                return PyMenu(self.service, "/setup/models/addon_module").execute(*args, **kwargs)
            def unsteady_2nd_order_bounded(self, *args, **kwargs):
                """
                Enable/disable bounded second-order unsteady formulation.
                """
                return PyMenu(self.service, "/setup/models/unsteady_2nd_order_bounded").execute(*args, **kwargs)
            def ablation(self, *args, **kwargs):
                """
                Enable/disable ablation model.
                """
                return PyMenu(self.service, "/setup/models/ablation").execute(*args, **kwargs)
            def vbm(self, *args, **kwargs):
                """
                Enable/disable Virtual Blade Model.
                """
                return PyMenu(self.service, "/setup/models/vbm").execute(*args, **kwargs)
            def unsteady_1st_order(self, *args, **kwargs):
                """
                Enable/disable first-order unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_1st_order").execute(*args, **kwargs)
            def noniterative_time_advance(self, *args, **kwargs):
                """
                Enable/disable the noniterative time advancement scheme.
                """
                return PyMenu(self.service, "/setup/models/noniterative_time_advance").execute(*args, **kwargs)
            def crevice_model_controls(self, *args, **kwargs):
                """
                Enter the crevice model controls menu.
                """
                return PyMenu(self.service, "/setup/models/crevice_model_controls").execute(*args, **kwargs)
            def unsteady_structure_euler(self, *args, **kwargs):
                """
                Enable/disable Backward Euler unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_structure_euler").execute(*args, **kwargs)
            def battery_model(self, *args, **kwargs):
                """
                Enter battery model menu.
                """
                return PyMenu(self.service, "/setup/models/battery_model").execute(*args, **kwargs)
            def unsteady_structure_newmark(self, *args, **kwargs):
                """
                Enable/disable Newmark unsteady solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_structure_newmark").execute(*args, **kwargs)
            def energy(self, *args, **kwargs):
                """
                Enable/disable the energy model.
                """
                return PyMenu(self.service, "/setup/models/energy").execute(*args, **kwargs)
            def steady(self, *args, **kwargs):
                """
                Enable/disable the steady solution model.
                """
                return PyMenu(self.service, "/setup/models/steady").execute(*args, **kwargs)
            def frozen_flux(self, *args, **kwargs):
                """
                Enable/disable frozen flux formulation for transient flows.
                """
                return PyMenu(self.service, "/setup/models/frozen_flux").execute(*args, **kwargs)
            def virtual_blade_model(self, *args, **kwargs):
                """
                Enter VBM model menu.
                """
                return PyMenu(self.service, "/setup/models/virtual_blade_model").execute(*args, **kwargs)
            def unsteady_global_time(self, *args, **kwargs):
                """
                Enable/disable the unsteady global-time-step solution model.
                """
                return PyMenu(self.service, "/setup/models/unsteady_global_time").execute(*args, **kwargs)
            def axisymmetric(self, *args, **kwargs):
                """
                Enable/disable the axisymmetric model.
                """
                return PyMenu(self.service, "/setup/models/axisymmetric").execute(*args, **kwargs)
            def solidification_melting(self, *args, **kwargs):
                """
                Enable/disable the solidification and melting model.
                """
                return PyMenu(self.service, "/setup/models/solidification_melting").execute(*args, **kwargs)

            class nox_parameters(TUIMenu):
                """
                Enter the NOx parameters menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def nox_chemistry(self, *args, **kwargs):
                    """
                    Select NOx chemistry model.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_chemistry").execute(*args, **kwargs)
                def nox_expert(self, *args, **kwargs):
                    """
                    Select additional nox equations.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_expert").execute(*args, **kwargs)
                def nox_turbulence_interaction(self, *args, **kwargs):
                    """
                    Set NOx-turbulence interaction model.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/nox_turbulence_interaction").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/nox_parameters/inlet_diffusion").execute(*args, **kwargs)

            class viscous(TUIMenu):
                """
                Enter the viscous model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.near_wall_treatment = self.__class__.near_wall_treatment(path + ["near_wall_treatment"], service)
                    self.geko_options = self.__class__.geko_options(path + ["geko_options"], service)
                    self.multiphase_turbulence = self.__class__.multiphase_turbulence(path + ["multiphase_turbulence"], service)
                    self.transition_model_options = self.__class__.transition_model_options(path + ["transition_model_options"], service)
                    self.turbulence_expert = self.__class__.turbulence_expert(path + ["turbulence_expert"], service)
                    super().__init__(path, service)
                def large_eddy_simulation(self, *args, **kwargs):
                    """
                    Enable/disable large eddy simulation.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/large_eddy_simulation").execute(*args, **kwargs)
                def v2f(self, *args, **kwargs):
                    """
                    Enable/disable the V2F turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/v2f").execute(*args, **kwargs)
                def curvature_correction_ccurv(self, *args, **kwargs):
                    """
                    Set the curvature correction coefficient CCURV.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/curvature_correction_ccurv").execute(*args, **kwargs)
                def des_limiter_option(self, *args, **kwargs):
                    """
                    Select DES limiter option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/des_limiter_option").execute(*args, **kwargs)
                def les_subgrid_dynamic_fvar(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                def mixing_length(self, *args, **kwargs):
                    """
                    Enable/disable the mixing-length (algebraic) turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/mixing_length").execute(*args, **kwargs)
                def les_dynamic_energy_flux(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic sub-grid scale turbulent Prandtl Number.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_dynamic_energy_flux").execute(*args, **kwargs)
                def rng_swirl_model(self, *args, **kwargs):
                    """
                    Enable/disable swirl corrections for rng-model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rng_swirl_model").execute(*args, **kwargs)
                def les_subgrid_smagorinsky(self, *args, **kwargs):
                    """
                    Enable/disable the Smagorinsky-Lilly subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_smagorinsky").execute(*args, **kwargs)
                def les_subgrid_wmles(self, *args, **kwargs):
                    """
                    Enable/disable the WMLES subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wmles").execute(*args, **kwargs)
                def ke_easm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_easm").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Select user-defined functions to define the turbulent viscosity and the turbulent Prandtl and Schmidt numbers.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/user_defined").execute(*args, **kwargs)
                def kw_low_re_correction(self, *args, **kwargs):
                    """
                    Enable/disable the k-omega low Re option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_low_re_correction").execute(*args, **kwargs)
                def zero_equation_hvac(self, *args, **kwargs):
                    """
                    Enable/disable the zero-equation HVAC turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/zero_equation_hvac").execute(*args, **kwargs)
                def sa_damping(self, *args, **kwargs):
                    """
                    Enable/disable the full low-Reynolds number form of Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_damping").execute(*args, **kwargs)
                def kw_geko(self, *args, **kwargs):
                    """
                    Enable/disable the GEKO turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_geko").execute(*args, **kwargs)
                def kw_wj_bsl_earsm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_wj_bsl_earsm").execute(*args, **kwargs)
                def sa_alternate_prod(self, *args, **kwargs):
                    """
                    Enable/disable strain/vorticity production in Spalart-Allmaras model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_alternate_prod").execute(*args, **kwargs)
                def ke_standard(self, *args, **kwargs):
                    """
                    Enable/disable the standard k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_standard").execute(*args, **kwargs)
                def les_subgrid_wale(self, *args, **kwargs):
                    """
                    Enable/disable the WALE subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wale").execute(*args, **kwargs)
                def laminar(self, *args, **kwargs):
                    """
                    Enable/disable the laminar flow model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/laminar").execute(*args, **kwargs)
                def rsm_wall_echo(self, *args, **kwargs):
                    """
                    Enable/disable wall-echo effects in RSM model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_wall_echo").execute(*args, **kwargs)
                def low_pressure_boundary_slip(self, *args, **kwargs):
                    """
                    Enable/disable the slip boundary formulation for low-pressure gas systems.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/low_pressure_boundary_slip").execute(*args, **kwargs)
                def k_kl_w(self, *args, **kwargs):
                    """
                    Enable/disable the k-kl-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/k_kl_w").execute(*args, **kwargs)
                def rsm_omega_based(self, *args, **kwargs):
                    """
                    Enable/disable the Stress-omega model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_omega_based").execute(*args, **kwargs)
                def les_subgrid_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_rng").execute(*args, **kwargs)
                def rsm_solve_tke(self, *args, **kwargs):
                    """
                    Enable/disable the solution of T.K.E. in RSM model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_solve_tke").execute(*args, **kwargs)
                def spalart_allmaras(self, *args, **kwargs):
                    """
                    Enable/disable the Spalart-Allmaras turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/spalart_allmaras").execute(*args, **kwargs)
                def rsm_or_earsm_geko_option(self, *args, **kwargs):
                    """
                    Enable/disable the GEKO option for RSM or EARSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_or_earsm_geko_option").execute(*args, **kwargs)
                def corner_flow_correction(self, *args, **kwargs):
                    """
                    Enable/disable the corner flow correction.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/corner_flow_correction").execute(*args, **kwargs)
                def user_defined_transition(self, *args, **kwargs):
                    """
                    Set user-defined transition correlations.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/user_defined_transition").execute(*args, **kwargs)
                def les_dynamic_scalar_flux(self, *args, **kwargs):
                    """
                    Enable/disable the dynamic sub-grid scale turbulent Schmidt Number.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_dynamic_scalar_flux").execute(*args, **kwargs)
                def rsm_ssg_pressure_strain(self, *args, **kwargs):
                    """
                    Enable/disable the quadratic pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_ssg_pressure_strain").execute(*args, **kwargs)
                def rsm_bsl_based(self, *args, **kwargs):
                    """
                    Enable/disable the Stress-BSL model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_bsl_based").execute(*args, **kwargs)
                def turb_buoyancy_effects(self, *args, **kwargs):
                    """
                    Select buoyancy effects on turbulence.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/turb_buoyancy_effects").execute(*args, **kwargs)
                def kw_standard(self, *args, **kwargs):
                    """
                    Enable/disable the standard k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_standard").execute(*args, **kwargs)
                def ke1e(self, *args, **kwargs):
                    """
                    Enable/disable the KE1E turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke1e").execute(*args, **kwargs)
                def inviscid(self, *args, **kwargs):
                    """
                    Enable/disable the inviscid flow model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/inviscid").execute(*args, **kwargs)
                def ke_rng(self, *args, **kwargs):
                    """
                    Enable/disable the RNG k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_rng").execute(*args, **kwargs)
                def kw_sst(self, *args, **kwargs):
                    """
                    Enable/disable the SST k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_sst").execute(*args, **kwargs)
                def kw_easm(self, *args, **kwargs):
                    """
                    Enable/disable the EASM k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_easm").execute(*args, **kwargs)
                def les_subgrid_wmles_s_minus_omega(self, *args, **kwargs):
                    """
                    Enable/disable the WMLES S-Omega subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_wmles_s_minus_omega").execute(*args, **kwargs)
                def detached_eddy_simulation(self, *args, **kwargs):
                    """
                    Enable/disable detached eddy simulation.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/detached_eddy_simulation").execute(*args, **kwargs)
                def kw_bsl(self, *args, **kwargs):
                    """
                    Enable/disable the BSL k-omega turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_bsl").execute(*args, **kwargs)
                def rsm_linear_pressure_strain(self, *args, **kwargs):
                    """
                    Enable/disable the linear pressure-strain model in RSM.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rsm_linear_pressure_strain").execute(*args, **kwargs)
                def ke_realizable(self, *args, **kwargs):
                    """
                    Enable/disable the realizable k-epsilon turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/ke_realizable").execute(*args, **kwargs)
                def kw_shear_correction(self, *args, **kwargs):
                    """
                    Enable/disable the k-omega shear-flow correction option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/kw_shear_correction").execute(*args, **kwargs)
                def corner_flow_correction_ccorner(self, *args, **kwargs):
                    """
                    Set the corner flow correction coefficient CCORNER.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/corner_flow_correction_ccorner").execute(*args, **kwargs)
                def curvature_correction(self, *args, **kwargs):
                    """
                    Enable/disable the curvature correction.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/curvature_correction").execute(*args, **kwargs)
                def reynolds_stress_model(self, *args, **kwargs):
                    """
                    Enable/disable the RSM turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/reynolds_stress_model").execute(*args, **kwargs)
                def les_subgrid_tke(self, *args, **kwargs):
                    """
                    Enable/disable the kinetic energy transport subgrid-scale model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/les_subgrid_tke").execute(*args, **kwargs)
                def trans_sst_roughness_correlation(self, *args, **kwargs):
                    """
                    Enable/disable the Transition-SST roughness correlation option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/trans_sst_roughness_correlation").execute(*args, **kwargs)
                def sa_enhanced_wall_treatment(self, *args, **kwargs):
                    """
                    Enable/disable the enhanced wall treatment for the Spalart-Allmaras model.
                    If disabled, no smooth blending between the viscous sublayer and the
                    log-law formulation is employed, as was done in versions previous to Fluent14.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sa_enhanced_wall_treatment").execute(*args, **kwargs)
                def turb_compressibility(self, *args, **kwargs):
                    """
                    Enable/disable the compressibility correction option.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/turb_compressibility").execute(*args, **kwargs)
                def transition_sst(self, *args, **kwargs):
                    """
                    Enable/disable the transition SST turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/transition_sst").execute(*args, **kwargs)
                def add_transition_model(self, *args, **kwargs):
                    """
                    Enable/disable a transition model to account for transitional effects.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/add_transition_model").execute(*args, **kwargs)
                def sas(self, *args, **kwargs):
                    """
                    Enable/disable the SAS turbulence model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/sas").execute(*args, **kwargs)
                def rng_differential_visc(self, *args, **kwargs):
                    """
                    Enable/disable the differential-viscosity model.
                    """
                    return PyMenu(self.service, "/setup/models/viscous/rng_differential_visc").execute(*args, **kwargs)

                class near_wall_treatment(TUIMenu):
                    """
                    Enter the near wall treatment menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def wf_thermal_effects(self, *args, **kwargs):
                        """
                        Enable/disable wall function thermal effects.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wf_thermal_effects").execute(*args, **kwargs)
                    def user_defined_wall_functions(self, *args, **kwargs):
                        """
                        Enable user defined wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/user_defined_wall_functions").execute(*args, **kwargs)
                    def non_equilibrium_wall_fn(self, *args, **kwargs):
                        """
                        Enable/disable non-equilibrium wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/non_equilibrium_wall_fn").execute(*args, **kwargs)
                    def werner_wengle_wall_fn(self, *args, **kwargs):
                        """
                        Enable/disable Werner-Wengle wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/werner_wengle_wall_fn").execute(*args, **kwargs)
                    def enhanced_wall_treatment(self, *args, **kwargs):
                        """
                        Enable/disable enhanced wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/enhanced_wall_treatment").execute(*args, **kwargs)
                    def wf_pressure_gradient_effects(self, *args, **kwargs):
                        """
                        Enable/disable wall function pressure-gradient effects.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wf_pressure_gradient_effects").execute(*args, **kwargs)
                    def wall_omega_treatment(self, *args, **kwargs):
                        """
                        Set wall omega treatment.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/wall_omega_treatment").execute(*args, **kwargs)
                    def menter_lechner(self, *args, **kwargs):
                        """
                        Enable/disable near wall treatment Menter-Lechner.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/menter_lechner").execute(*args, **kwargs)
                    def scalable_wall_functions(self, *args, **kwargs):
                        """
                        Enable/disable scalable wall functions.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/near_wall_treatment/scalable_wall_functions").execute(*args, **kwargs)

                class geko_options(TUIMenu):
                    """
                    Enter the GEKO options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def cmix(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CMIX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cmix").execute(*args, **kwargs)
                    def geko_defaults(self, *args, **kwargs):
                        """
                        Set GEKO options to default.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/geko_defaults").execute(*args, **kwargs)
                    def csep(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CSEP.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/csep").execute(*args, **kwargs)
                    def cnw(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CNW.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cnw").execute(*args, **kwargs)
                    def wall_distance_free(self, *args, **kwargs):
                        """
                        Enable/disable wall-distance-free version of GEKO model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/wall_distance_free").execute(*args, **kwargs)
                    def cbf_tur(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CBF_TUR.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cbf_tur").execute(*args, **kwargs)
                    def blending_function(self, *args, **kwargs):
                        """
                        Set the GEKO model blending function.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/blending_function").execute(*args, **kwargs)
                    def cjet_aux(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CJET_AUX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cjet_aux").execute(*args, **kwargs)
                    def cjet(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CJET.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cjet").execute(*args, **kwargs)
                    def creal(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CREAL.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/creal").execute(*args, **kwargs)
                    def cnw_sub(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CNW_SUB.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cnw_sub").execute(*args, **kwargs)
                    def cbf_lam(self, *args, **kwargs):
                        """
                        Set the GEKO model coefficient CBF_LAM.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/geko_options/cbf_lam").execute(*args, **kwargs)

                class multiphase_turbulence(TUIMenu):
                    """
                    Enter the multiphase turbulence menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def turbulence_multiphase_models(self, *args, **kwargs):
                        """
                        Select the k-epsilon multiphase model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/turbulence_multiphase_models").execute(*args, **kwargs)
                    def multiphase_options(self, *args, **kwargs):
                        """
                        Enable/disable multiphase options.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/multiphase_options").execute(*args, **kwargs)
                    def rsm_multiphase_models(self, *args, **kwargs):
                        """
                        Enable/disable the Reynolds Stress multiphase model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/rsm_multiphase_models").execute(*args, **kwargs)
                    def subgrid_turbulence_contribution_aiad(self, *args, **kwargs):
                        """
                        Enable/disable the Subgrid Turbulence Contribution for the AIAD model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/multiphase_turbulence/subgrid_turbulence_contribution_aiad").execute(*args, **kwargs)

                class transition_model_options(TUIMenu):
                    """
                    Enter the transition model options menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def critical_reynolds_number_correlation(self, *args, **kwargs):
                        """
                        Set the critical Reynolds number correlation.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/critical_reynolds_number_correlation").execute(*args, **kwargs)
                    def clambda_scale(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CLAMBDA_SCALE.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/clambda_scale").execute(*args, **kwargs)
                    def crossflow_transition(self, *args, **kwargs):
                        """
                        Enable/disable crossflow transition for the intermittency transition model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/crossflow_transition").execute(*args, **kwargs)
                    def rec_c1(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_C1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_c1").execute(*args, **kwargs)
                    def rec_max(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_MAX.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_max").execute(*args, **kwargs)
                    def cbubble_c2(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CBUBBLE_C2.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cbubble_c2").execute(*args, **kwargs)
                    def cfpg_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CFPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cfpg_hightu").execute(*args, **kwargs)
                    def cfpg_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CFPG_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cfpg_lowtu").execute(*args, **kwargs)
                    def ctu_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CTU_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/ctu_lowtu").execute(*args, **kwargs)
                    def cbubble_c1(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CBUBBLE_C1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/cbubble_c1").execute(*args, **kwargs)
                    def ctu_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CTU_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/ctu_hightu").execute(*args, **kwargs)
                    def rv1_switch(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient RV1_SWITCH.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rv1_switch").execute(*args, **kwargs)
                    def rec_c2(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient REC_C2.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/rec_c2").execute(*args, **kwargs)
                    def capg_lowtu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CAPG_LOWTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/capg_lowtu").execute(*args, **kwargs)
                    def capg_hightu(self, *args, **kwargs):
                        """
                        Set the algebraic transition model coefficient CAPG_HIGHTU.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/transition_model_options/capg_hightu").execute(*args, **kwargs)

                class turbulence_expert(TUIMenu):
                    """
                    Enter the turbulence expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rke_cmu_rotation_term(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of omega in the Cmu definition.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/rke_cmu_rotation_term").execute(*args, **kwargs)
                    def low_re_ke_index(self, *args, **kwargs):
                        """
                        Enable/disable the low-Re k-epsilon model version.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/low_re_ke_index").execute(*args, **kwargs)
                    def sbes_update_interval_k_omega(self, *args, **kwargs):
                        """
                        Set an integer value how often the k and omega equations are updated in a transient SBES run.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_update_interval_k_omega").execute(*args, **kwargs)
                    def production_limiter(self, *args, **kwargs):
                        """
                        Enable/disable the Production Limiter.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/production_limiter").execute(*args, **kwargs)
                    def sbes_sgs_option(self, *args, **kwargs):
                        """
                        Select SBES subgrid-scale model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_sgs_option").execute(*args, **kwargs)
                    def sbes_sdes_hybrid_model(self, *args, **kwargs):
                        """
                        Select the SBES / SDES hybrid model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_sdes_hybrid_model").execute(*args, **kwargs)
                    def sbes_les_subgrid_dynamic_fvar(self, *args, **kwargs):
                        """
                        Enable/disable the dynamic subgrid-scale mixture fraction variance model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/sbes_les_subgrid_dynamic_fvar").execute(*args, **kwargs)
                    def turb_non_newtonian(self, *args, **kwargs):
                        """
                        Enable/disable turbulence for non-Newtonian fluids.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_non_newtonian").execute(*args, **kwargs)
                    def kw_add_des(self, *args, **kwargs):
                        """
                        Enable/disable DES-mode with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_add_des").execute(*args, **kwargs)
                    def turbulence_damping(self, *args, **kwargs):
                        """
                        Enable/disable turbulence damping and set turbulence damping parameters.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turbulence_damping").execute(*args, **kwargs)
                    def kato_launder_model(self, *args, **kwargs):
                        """
                        Enable/disable Kato-Launder modification for production.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kato_launder_model").execute(*args, **kwargs)
                    def thermal_p_function(self, *args, **kwargs):
                        """
                        Enable/disable the Jayatilleke P function.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/thermal_p_function").execute(*args, **kwargs)
                    def low_re_ke(self, *args, **kwargs):
                        """
                        Enable/disable the low-Re k-epsilon turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/low_re_ke").execute(*args, **kwargs)
                    def turb_add_sbes_sdes(self, *args, **kwargs):
                        """
                        Enable/disable SBES / SDES with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_add_sbes_sdes").execute(*args, **kwargs)
                    def kw_add_sas(self, *args, **kwargs):
                        """
                        Enable/disable the SAS-mode with the current turbulence model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_add_sas").execute(*args, **kwargs)
                    def kw_vorticity_based_production(self, *args, **kwargs):
                        """
                        Enable/disable vorticity based production.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/kw_vorticity_based_production").execute(*args, **kwargs)
                    def non_newtonian_modification(self, *args, **kwargs):
                        """
                        Enable/disable non-Newtonian modification for Lam-Bremhorst model.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/non_newtonian_modification").execute(*args, **kwargs)
                    def restore_sst_v61(self, *args, **kwargs):
                        """
                        Enable/disable SST formulation of v6.1.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/restore_sst_v61").execute(*args, **kwargs)
                    def turb_pk_compressible(self, *args, **kwargs):
                        """
                        Enable/disable turbulent production due to compressible divergence.
                        """
                        return PyMenu(self.service, "/setup/models/viscous/turbulence_expert/turb_pk_compressible").execute(*args, **kwargs)

            class optics(TUIMenu):
                """
                Enter the optics model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.statistics = self.__class__.statistics(path + ["statistics"], service)
                    self.beams = self.__class__.beams(path + ["beams"], service)
                    super().__init__(path, service)
                def enable(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/models/optics/enable").execute(*args, **kwargs)
                def verbosity(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/models/optics/verbosity").execute(*args, **kwargs)
                def report(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/models/optics/report").execute(*args, **kwargs)
                def index_of_refraction(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/models/optics/index_of_refraction").execute(*args, **kwargs)
                def sampling_iterations(self, *args, **kwargs):
                    """
                    .
                    """
                    return PyMenu(self.service, "/setup/models/optics/sampling_iterations").execute(*args, **kwargs)

                class statistics(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def statistics_controls(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/setup/models/optics/statistics/statistics_controls").execute(*args, **kwargs)
                    def reset_statistics(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/setup/models/optics/statistics/reset_statistics").execute(*args, **kwargs)

                class beams(TUIMenu):
                    """
                    .
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def rename(self, *args, **kwargs):
                        """
                        Rename object.
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/rename").execute(*args, **kwargs)
                    def add(self, *args, **kwargs):
                        """
                        Create a new beams object.
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/add").execute(*args, **kwargs)
                    def edit(self, *args, **kwargs):
                        """
                        Edit beams object.
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/edit").execute(*args, **kwargs)
                    def copy(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/copy").execute(*args, **kwargs)
                    def list_beam_parameters(self, *args, **kwargs):
                        """
                        .
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/list_beam_parameters").execute(*args, **kwargs)
                    def delete(self, *args, **kwargs):
                        """
                        Delete object.
                        """
                        return PyMenu(self.service, "/setup/models/optics/beams/delete").execute(*args, **kwargs)

            class two_temperature(TUIMenu):
                """
                Define two-temperature model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def robustness_enhancement(self, *args, **kwargs):
                    """
                    Apply robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/robustness_enhancement").execute(*args, **kwargs)
                def enable(self, *args, **kwargs):
                    """
                    Enable/disable the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/enable").execute(*args, **kwargs)
                def nasa9_enhancement(self, *args, **kwargs):
                    """
                    Apply nasa9 robustness enhancements in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/nasa9_enhancement").execute(*args, **kwargs)
                def weak_ionization(self, *args, **kwargs):
                    """
                    Apply weak ionization in the two-temperature model.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/weak_ionization").execute(*args, **kwargs)
                def set_verbosity(self, *args, **kwargs):
                    """
                    Set two-temperature model verbosity option.
                    """
                    return PyMenu(self.service, "/setup/models/two_temperature/set_verbosity").execute(*args, **kwargs)

            class dpm(TUIMenu):
                """
                Enter the dispersed phase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.splash_options = self.__class__.splash_options(path + ["splash_options"], service)
                    self.parallel = self.__class__.parallel(path + ["parallel"], service)
                    self.collisions = self.__class__.collisions(path + ["collisions"], service)
                    self.interaction = self.__class__.interaction(path + ["interaction"], service)
                    self.erosion_dynamic_mesh = self.__class__.erosion_dynamic_mesh(path + ["erosion_dynamic_mesh"], service)
                    self.options = self.__class__.options(path + ["options"], service)
                    self.stripping_options = self.__class__.stripping_options(path + ["stripping_options"], service)
                    self.numerics = self.__class__.numerics(path + ["numerics"], service)
                    super().__init__(path, service)
                def injections(self, *args, **kwargs):
                    """
                    Enter the injections menu.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/injections").execute(*args, **kwargs)
                def user_defined(self, *args, **kwargs):
                    """
                    Set DPM user-defined functions.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/user_defined").execute(*args, **kwargs)
                def spray_model(self, *args, **kwargs):
                    """
                    Enter the spray model menu.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/spray_model").execute(*args, **kwargs)
                def unsteady_tracking(self, *args, **kwargs):
                    """
                    Enable/disable unsteady particle tracking.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/unsteady_tracking").execute(*args, **kwargs)
                def clear_particles_from_domain(self, *args, **kwargs):
                    """
                    Remove/keep all particles currently in the domain.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/clear_particles_from_domain").execute(*args, **kwargs)
                def fill_injection_material_sources(self, *args, **kwargs):
                    """
                    Initialize the DPM sources corresponding to each material.
                    """
                    return PyMenu(self.service, "/setup/models/dpm/fill_injection_material_sources").execute(*args, **kwargs)

                class splash_options(TUIMenu):
                    """
                    Enter the splash options menu to set optional parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def splash_pdf_limiting(self, *args, **kwargs):
                        """
                        Select splash pdf limiting method.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/splash_options/splash_pdf_limiting").execute(*args, **kwargs)
                    def orourke_splash_fraction(self, *args, **kwargs):
                        """
                        Select splash fraction method.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/splash_options/orourke_splash_fraction").execute(*args, **kwargs)

                class parallel(TUIMenu):
                    """
                    Enter the parallel menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        super().__init__(path, service)
                    def use_hybrid(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to hybrid.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_hybrid").execute(*args, **kwargs)
                    def report(self, *args, **kwargs):
                        """
                        Print particle workpile statistics.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/report").execute(*args, **kwargs)
                    def hybrid_2domain(self, *args, **kwargs):
                        """
                        Use DPM domain to simulate particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_2domain").execute(*args, **kwargs)
                    def hybrid_collision_unidirectional(self, *args, **kwargs):
                        """
                        A faster, yet potentially somewhat less accurate, modification to the beta feature
                        that allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_unidirectional").execute(*args, **kwargs)
                    def use_message_passing(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to message passing.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_message_passing").execute(*args, **kwargs)
                    def fix_source_term_accumulation_order(self, *args, **kwargs):
                        """
                        Enforce deterministic order of source term accumulation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/fix_source_term_accumulation_order").execute(*args, **kwargs)
                    def enable_workpile(self, *args, **kwargs):
                        """
                        Enable/disable the particle workpile algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/enable_workpile").execute(*args, **kwargs)
                    def hybrid_workpile(self, *args, **kwargs):
                        """
                        Optimize multi-thread load balancing within each partition in hybrid-parallel DPM tracking.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_workpile").execute(*args, **kwargs)
                    def hybrid_collision_variant(self, *args, **kwargs):
                        """
                        Further reduce the residual risk of dead-locks in the experimental feature that
                        allows 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_variant").execute(*args, **kwargs)
                    def n_threads(self, *args, **kwargs):
                        """
                        Set the number of processors to use for DPM.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/n_threads").execute(*args, **kwargs)
                    def use_shared_memory(self, *args, **kwargs):
                        """
                        Set DPM parallel-mode to shared memory.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/use_shared_memory").execute(*args, **kwargs)
                    def hybrid_collision_model(self, *args, **kwargs):
                        """
                        An EXPERIMENTAL feature to allow 'hybrid' DPM parallel tracking with the collision / coalescence model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/parallel/hybrid_collision_model").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the menu to set expert DPM parallel options.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def partition_method_hybrid_2domain(self, *args, **kwargs):
                            """
                            Set DPM Domain partition method.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/parallel/expert/partition_method_hybrid_2domain").execute(*args, **kwargs)

                class collisions(TUIMenu):
                    """
                    Enter the DEM collisions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.collision_partners = self.__class__.collision_partners(path + ["collision_partners"], service)
                        super().__init__(path, service)
                    def max_particle_velocity(self, *args, **kwargs):
                        """
                        Set the maximum particle velocity that may arise from collisions.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/max_particle_velocity").execute(*args, **kwargs)
                    def collision_pair_settings(self, *args, **kwargs):
                        """
                        Supply settings for collisions to a pair of collision partners.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/collision_pair_settings").execute(*args, **kwargs)
                    def collision_mesh(self, *args, **kwargs):
                        """
                        Input for the collision mesh.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/collision_mesh").execute(*args, **kwargs)
                    def dem_collisions(self, *args, **kwargs):
                        """
                        Enable/disable the DEM collision model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/dem_collisions").execute(*args, **kwargs)
                    def list_all_pair_settings(self, *args, **kwargs):
                        """
                        For each pair of collision partners, lists the collision laws and their parameters.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/collisions/list_all_pair_settings").execute(*args, **kwargs)

                    class collision_partners(TUIMenu):
                        """
                        Manage collision partners.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def copy(self, *args, **kwargs):
                            """
                            Copy a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/copy").execute(*args, **kwargs)
                        def delete(self, *args, **kwargs):
                            """
                            Delete a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/delete").execute(*args, **kwargs)
                        def list(self, *args, **kwargs):
                            """
                            Lists all known collision partners.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/list").execute(*args, **kwargs)
                        def rename(self, *args, **kwargs):
                            """
                            Rename a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/rename").execute(*args, **kwargs)
                        def create(self, *args, **kwargs):
                            """
                            Create a collision partner.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/collisions/collision_partners/create").execute(*args, **kwargs)

                class interaction(TUIMenu):
                    """
                    Enter the interaction menu to set parameters for coupled discrete phase calculations.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def keep_linearized_dpm_source_terms_constant(self, *args, **kwargs):
                        """
                        Keep linearized DPM source terms constant until the next DPM Update.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/keep_linearized_dpm_source_terms_constant").execute(*args, **kwargs)
                    def replace_dpm_mass_source_by_mixture_fraction(self, *args, **kwargs):
                        """
                        Recalculate the mixture fraction source terms as function of the primary mixture fraction?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/replace_dpm_mass_source_by_mixture_fraction").execute(*args, **kwargs)
                    def linearized_dpm_source_terms_limiter(self, *args, **kwargs):
                        """
                        Relative limit for DPM source linear coefficient with respect to fluid linear Ap coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_source_terms_limiter").execute(*args, **kwargs)
                    def enable_drag_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM drag coefficient due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_drag_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def min_vf_threshold_for_dpm_src_scaling(self, *args, **kwargs):
                        """
                        Minimum DPM volume fraction below which no DPM source scaling is applied.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/min_vf_threshold_for_dpm_src_scaling").execute(*args, **kwargs)
                    def ddpm_energy_coupling_via_source_term(self, *args, **kwargs):
                        """
                        Energy coupling in DDPM established via source term.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_energy_coupling_via_source_term").execute(*args, **kwargs)
                    def reset_sources_at_timestep(self, *args, **kwargs):
                        """
                        Enable/disable flush of DPM source terms at beginning of every time step.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/reset_sources_at_timestep").execute(*args, **kwargs)
                    def implicit_momentum_coupling(self, *args, **kwargs):
                        """
                        Enable/disable implicit treatment for the DPM momentum source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/implicit_momentum_coupling").execute(*args, **kwargs)
                    def choice_of_eulerian_phase_for_interaction(self, *args, **kwargs):
                        """
                        Enable/disable the option to choose for every injection the Eulerian phase for the DPM continuous phase interaction.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/choice_of_eulerian_phase_for_interaction").execute(*args, **kwargs)
                    def enable_flow_blocking_by_particles(self, *args, **kwargs):
                        """
                        Enable/disable inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_flow_blocking_by_particles").execute(*args, **kwargs)
                    def implicit_source_term_coupling(self, *args, **kwargs):
                        """
                        Enable/disable implicit treatment for all DPM source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/implicit_source_term_coupling").execute(*args, **kwargs)
                    def dpm_iteration_interval(self, *args, **kwargs):
                        """
                        Set the number of continuous phase iterations per DPM iteration.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/dpm_iteration_interval").execute(*args, **kwargs)
                    def linearized_dpm_source_terms(self, *args, **kwargs):
                        """
                        Perform a linearization of all DPM source terms to increase numerical robustness.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_source_terms").execute(*args, **kwargs)
                    def max_vf_allowed_for_blocking(self, *args, **kwargs):
                        """
                        Maximum DPM volume fraction used in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/max_vf_allowed_for_blocking").execute(*args, **kwargs)
                    def linearized_dpm_species_source_terms(self, *args, **kwargs):
                        """
                        Perform linearization of species source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_species_source_terms").execute(*args, **kwargs)
                    def ddpm_enhanced_inter_phase_exchange(self, *args, **kwargs):
                        """
                        Enhanced Eulerian inter-phase exchange.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_enhanced_inter_phase_exchange").execute(*args, **kwargs)
                    def update_dpm_sources_every_flow_iteration(self, *args, **kwargs):
                        """
                        Enable/disable the update of DPM source terms every flow iteration.
                        (if not, the terms will be updated every DPM iteration).
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/update_dpm_sources_every_flow_iteration").execute(*args, **kwargs)
                    def linear_growth_of_dpm_source_term(self, *args, **kwargs):
                        """
                        Enable/disable the linear growth of DPM source terms every DPM iteration.
                        .
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linear_growth_of_dpm_source_term").execute(*args, **kwargs)
                    def underrelaxation_factor(self, *args, **kwargs):
                        """
                        Set the under-relaxation factor.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/underrelaxation_factor").execute(*args, **kwargs)
                    def coupled_calculations(self, *args, **kwargs):
                        """
                        Enable/disable coupling of continuous and discrete phase calculations.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/coupled_calculations").execute(*args, **kwargs)
                    def linearized_dpm_mixture_fraction_source_terms(self, *args, **kwargs):
                        """
                        Perform a linearization of mixture fraction source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/linearized_dpm_mixture_fraction_source_terms").execute(*args, **kwargs)
                    def enable_source_scaling_due_to_flow_blocking(self, *args, **kwargs):
                        """
                        Enable/disable scaling of DPM source terms due to inclusion of DPM volume fraction in continuous flow.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/enable_source_scaling_due_to_flow_blocking").execute(*args, **kwargs)
                    def ddpm_iad_particle(self, *args, **kwargs):
                        """
                        Enable/disable the non-default interfacial area method IA-particle.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/interaction/ddpm_iad_particle").execute(*args, **kwargs)

                class erosion_dynamic_mesh(TUIMenu):
                    """
                    Enter the erosion-dynamic mesh interactions menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.run_parameters = self.__class__.run_parameters(path + ["run_parameters"], service)
                        self.general_parameters = self.__class__.general_parameters(path + ["general_parameters"], service)
                        super().__init__(path, service)
                    def run_simulation(self, *args, **kwargs):
                        """
                        Perform coupled erosion-dynamic mesh simulation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_simulation").execute(*args, **kwargs)
                    def enable_erosion_dynamic_mesh_coupling(self, *args, **kwargs):
                        """
                        Enable mesh deformation due to wall erosion.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/enable_erosion_dynamic_mesh_coupling").execute(*args, **kwargs)

                    class run_parameters(TUIMenu):
                        """
                        Enter the erosion-dynamic mesh run menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def flow_simulation_control(self, *args, **kwargs):
                            """
                            Set number of iterations per flow simulation step.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/flow_simulation_control").execute(*args, **kwargs)
                        def autosave_graphics(self, *args, **kwargs):
                            """
                            Set the iteration increment to save graphics files.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_graphics").execute(*args, **kwargs)
                        def autosave_files(self, *args, **kwargs):
                            """
                            Set the iteration increment to save data files.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/autosave_files").execute(*args, **kwargs)
                        def simulation_termination(self, *args, **kwargs):
                            """
                            Set total time of erosion.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/simulation_termination").execute(*args, **kwargs)
                        def mesh_motion_time_step(self, *args, **kwargs):
                            """
                            Set the mesh motion time stepping parameters and method.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/run_parameters/mesh_motion_time_step").execute(*args, **kwargs)

                    class general_parameters(TUIMenu):
                        """
                        Enter the erosion-dynamic mesh setup menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def erosion_settings(self, *args, **kwargs):
                            """
                            Set erosion modelling specific settings.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/erosion_settings").execute(*args, **kwargs)
                        def participating_walls(self, *args, **kwargs):
                            """
                            Specify all participating walls.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/participating_walls").execute(*args, **kwargs)
                        def dynamic_mesh_settings(self, *args, **kwargs):
                            """
                            Perform dynamic mesh related setup.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/erosion_dynamic_mesh/general_parameters/dynamic_mesh_settings").execute(*args, **kwargs)

                class options(TUIMenu):
                    """
                    Enter the options menu to set optional DPM models.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def set_minimum_particle_diameter(self, *args, **kwargs):
                        """
                        Set the minimum particle diameter.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/set_minimum_particle_diameter").execute(*args, **kwargs)
                    def maximum_udf_species(self, *args, **kwargs):
                        """
                        Maximum number of species that can interact with particles in the DPM UDFs.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/maximum_udf_species").execute(*args, **kwargs)
                    def set_thermolysis_limit(self, *args, **kwargs):
                        """
                        Set the thermolysis limit.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/set_thermolysis_limit").execute(*args, **kwargs)
                    def stagger_temporally(self, *args, **kwargs):
                        """
                        Stagger transient parcels for their first time step?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_temporally").execute(*args, **kwargs)
                    def include_lwf_particles_in_dpm_concentration(self, *args, **kwargs):
                        """
                        Include LWF particle mass in DPM Concentration.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/include_lwf_particles_in_dpm_concentration").execute(*args, **kwargs)
                    def pressure_gradient_force(self, *args, **kwargs):
                        """
                        Enable/disable pressure gradient force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/pressure_gradient_force").execute(*args, **kwargs)
                    def init_erosion_accretion_rate(self, *args, **kwargs):
                        """
                        Initialize erosion/accretion rates with Zero.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/init_erosion_accretion_rate").execute(*args, **kwargs)
                    def remove_wall_film_temperature_limiter(self, *args, **kwargs):
                        """
                        Remove the wall film temperature limiter.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/remove_wall_film_temperature_limiter").execute(*args, **kwargs)
                    def stagger_spatially_atomizer_injections(self, *args, **kwargs):
                        """
                        Spatially stagger atomizer injections?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_spatially_atomizer_injections").execute(*args, **kwargs)
                    def vaporization_options(self, *args, **kwargs):
                        """
                        Set Vaporization options.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/vaporization_options").execute(*args, **kwargs)
                    def staggering_factor(self, *args, **kwargs):
                        """
                        Set the staggering factor between 0 and 1 to control the amount of staggering.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/staggering_factor").execute(*args, **kwargs)
                    def track_in_absolute_frame(self, *args, **kwargs):
                        """
                        Enable/disable tracking in absolute frame.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/track_in_absolute_frame").execute(*args, **kwargs)
                    def ensemble_average(self, *args, **kwargs):
                        """
                        Set ensemble average cloud properties.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/ensemble_average").execute(*args, **kwargs)
                    def step_report_sig_figures(self, *args, **kwargs):
                        """
                        Set significant figures in the step-by-step report.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/step_report_sig_figures").execute(*args, **kwargs)
                    def brownian_motion(self, *args, **kwargs):
                        """
                        Enable/disable Brownian motion of particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/brownian_motion").execute(*args, **kwargs)
                    def stagger_radius(self, *args, **kwargs):
                        """
                        Provide a stagger radius for non atomizer injections.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_radius").execute(*args, **kwargs)
                    def current_positions_in_sample_file_format(self, *args, **kwargs):
                        """
                        Write the current positions (step-by-step history report for unsteady tracking) in the sampling file format.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/current_positions_in_sample_file_format").execute(*args, **kwargs)
                    def treat_multicomponent_saturation_temperature_failure(self, *args, **kwargs):
                        """
                        Dump multicomponent particle mass if the saturation temperature cannot be determined.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/treat_multicomponent_saturation_temperature_failure").execute(*args, **kwargs)
                    def allow_supercritical_pressure_vaporization(self, *args, **kwargs):
                        """
                        Skip the pressure dependent boiling point calculation to allow supercritical pressure conditions for vaporization.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/allow_supercritical_pressure_vaporization").execute(*args, **kwargs)
                    def stagger_spatially_standard_injections(self, *args, **kwargs):
                        """
                        Spatially stagger non-atomizer injections?.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/stagger_spatially_standard_injections").execute(*args, **kwargs)
                    def erosion_accretion(self, *args, **kwargs):
                        """
                        Enable/disable erosion/accretion.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/erosion_accretion").execute(*args, **kwargs)
                    def lowest_volatiles_mass_fraction(self, *args, **kwargs):
                        """
                        Set the lowest volatiles mass fraction.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/lowest_volatiles_mass_fraction").execute(*args, **kwargs)
                    def enable_contour_plots(self, *args, **kwargs):
                        """
                        Enable contour and vector plots of particle data.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/enable_contour_plots").execute(*args, **kwargs)
                    def uniform_mass_distribution_for_injections(self, *args, **kwargs):
                        """
                        A uniform mass distribution will be enabled for all solid cone and atomizer injections.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/uniform_mass_distribution_for_injections").execute(*args, **kwargs)
                    def convective_film_heat_transfer(self, *args, **kwargs):
                        """
                        Enable/disable convection/conduction film to wall heat transfer model.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/convective_film_heat_transfer").execute(*args, **kwargs)
                    def thermophoretic_force(self, *args, **kwargs):
                        """
                        Enable/disable thermophoretic force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/thermophoretic_force").execute(*args, **kwargs)
                    def saffman_lift_force(self, *args, **kwargs):
                        """
                        Enable/disable Saffman lift force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/saffman_lift_force").execute(*args, **kwargs)
                    def virtual_mass_force(self, *args, **kwargs):
                        """
                        Enable/disable virtual mass force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/virtual_mass_force").execute(*args, **kwargs)
                    def scr_urea_deposition_risk_analysis(self, *args, **kwargs):
                        """
                        Options to activate and configure the SCR urea deposition risk analysis.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/scr_urea_deposition_risk_analysis").execute(*args, **kwargs)
                    def use_absolute_pressure_for_vaporization(self, *args, **kwargs):
                        """
                        Enable/disable using Absolute Pressure for Vaporization.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/use_absolute_pressure_for_vaporization").execute(*args, **kwargs)
                    def two_way_coupling(self, *args, **kwargs):
                        """
                        Enable/disable calculation of DPM sources in TKE equation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/two_way_coupling").execute(*args, **kwargs)
                    def particle_radiation(self, *args, **kwargs):
                        """
                        Enable/disable particle radiation.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/particle_radiation").execute(*args, **kwargs)
                    def vaporization_heat_transfer_averaging(self, *args, **kwargs):
                        """
                        Enable/disable correction for Vaporization heat transfer.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/options/vaporization_heat_transfer_averaging").execute(*args, **kwargs)

                class stripping_options(TUIMenu):
                    """
                    Enter the stripping options menu to set optional parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mass_coefficient(self, *args, **kwargs):
                        """
                        Set the stripping mass coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/stripping_options/mass_coefficient").execute(*args, **kwargs)
                    def diameter_coefficient(self, *args, **kwargs):
                        """
                        Set the stripping diameter coefficient.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/stripping_options/diameter_coefficient").execute(*args, **kwargs)

                class numerics(TUIMenu):
                    """
                    Enter the numerics menu to set numerical solution parameters.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.high_resolution_tracking = self.__class__.high_resolution_tracking(path + ["high_resolution_tracking"], service)
                        super().__init__(path, service)
                    def minimum_liquid_fraction(self, *args, **kwargs):
                        """
                        Evaporate droplet completely when the remaining mass is below this fraction of initial mass.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/minimum_liquid_fraction").execute(*args, **kwargs)
                    def predictor_corrector(self, *args, **kwargs):
                        """
                        Enable predictor/corrector approach to track particles.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/predictor_corrector").execute(*args, **kwargs)
                    def tracking_parameters(self, *args, **kwargs):
                        """
                        Set parameters for the (initial) tracking step length.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_parameters").execute(*args, **kwargs)
                    def enable_node_based_averaging(self, *args, **kwargs):
                        """
                        Enable node based averaging of DPM variables.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/enable_node_based_averaging").execute(*args, **kwargs)
                    def gaussian_factor(self, *args, **kwargs):
                        """
                        Set a factor for the gaussian kernel for node-based averaging.~%Large values give small size, small values give large size of kernel.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/gaussian_factor").execute(*args, **kwargs)
                    def vaporization_limiting_factors(self, *args, **kwargs):
                        """
                        Set Vaporization Fractional Change Limits.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/vaporization_limiting_factors").execute(*args, **kwargs)
                    def average_DDPM_variables(self, *args, **kwargs):
                        """
                        Average DDPM specific variables like volume fractions and velocities on nodes.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_DDPM_variables").execute(*args, **kwargs)
                    def underrelax_film_height(self, *args, **kwargs):
                        """
                        Define underrelaxation factor for film height.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/underrelax_film_height").execute(*args, **kwargs)
                    def verbosity(self, *args, **kwargs):
                        """
                        Adjust the DPM tracker's verbosity level.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/verbosity").execute(*args, **kwargs)
                    def tracking_statistics(self, *args, **kwargs):
                        """
                        Control the format of the one-line tracking statistics printed after every DPM tracking pass.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_statistics").execute(*args, **kwargs)
                    def granular_stress_tensor(self, *args, **kwargs):
                        """
                        Enable granular stress tensor to be considered with solid pressure gradient as collision force.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/granular_stress_tensor").execute(*args, **kwargs)
                    def tracking_scheme(self, *args, **kwargs):
                        """
                        Specify a tracking scheme.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/tracking_scheme").execute(*args, **kwargs)
                    def mppic_settings(self, *args, **kwargs):
                        """
                        Enable PIC and MPPIC to compute DPM and DDPM source terms.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/mppic_settings").execute(*args, **kwargs)
                    def average_kernel(self, *args, **kwargs):
                        """
                        Specify a kernel for the averaging.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_kernel").execute(*args, **kwargs)
                    def average_each_step(self, *args, **kwargs):
                        """
                        Do the averaging after each integration step for higher accuracy at a higher cost.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_each_step").execute(*args, **kwargs)
                    def enhanced_packing_limit_numerics(self, *args, **kwargs):
                        """
                        Enable enhanced packing limit numerics to avoid exceeding of packing limit for granular phases.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/enhanced_packing_limit_numerics").execute(*args, **kwargs)
                    def error_control(self, *args, **kwargs):
                        """
                        Set the adapt integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/error_control").execute(*args, **kwargs)
                    def automated_scheme_selection(self, *args, **kwargs):
                        """
                        Enable/disable the adaptation of integration step length based on a maximum error.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/automated_scheme_selection").execute(*args, **kwargs)
                    def coupled_heat_mass_update(self, *args, **kwargs):
                        """
                        Enable/disable coupled heat and mass update.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/coupled_heat_mass_update").execute(*args, **kwargs)
                    def drag_law(self, *args, **kwargs):
                        """
                        Set the drag law.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/drag_law").execute(*args, **kwargs)
                    def average_source_terms(self, *args, **kwargs):
                        """
                        Average DPM source terms on nodes.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/average_source_terms").execute(*args, **kwargs)
                    def dynamic_interaction(self, *args, **kwargs):
                        """
                        Enable/disable dynamic interaction range.
                        """
                        return PyMenu(self.service, "/setup/models/dpm/numerics/dynamic_interaction").execute(*args, **kwargs)

                    class high_resolution_tracking(TUIMenu):
                        """
                        Enter the high resolution tracking menu.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.barycentric_interpolation = self.__class__.barycentric_interpolation(path + ["barycentric_interpolation"], service)
                            self.particle_relocation = self.__class__.particle_relocation(path + ["particle_relocation"], service)
                            super().__init__(path, service)
                        def remove_stuck_particles(self, *args, **kwargs):
                            """
                            Remove particles that are stuck at edges or faces.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/remove_stuck_particles").execute(*args, **kwargs)
                        def sliding_interface_crossover_fraction(self, *args, **kwargs):
                            """
                            Move the particle a fraction of the distance to the subtet center when crossing a sliding interface.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/sliding_interface_crossover_fraction").execute(*args, **kwargs)
                        def use_particle_timestep_for_intersection_tolerance(self, *args, **kwargs):
                            """
                            Use the particle timestep for the axisymmetric subtet intersection tolerance.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_particle_timestep_for_intersection_tolerance").execute(*args, **kwargs)
                        def set_subtet_intersection_tolerance(self, *args, **kwargs):
                            """
                            Set the tolerance for subtet intersection calculations.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/set_subtet_intersection_tolerance").execute(*args, **kwargs)
                        def enable_automatic_intersection_tolerance(self, *args, **kwargs):
                            """
                            Enable automatic scaling of subtet intersection tolerance.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_automatic_intersection_tolerance").execute(*args, **kwargs)
                        def always_use_face_centroid_with_periodics(self, *args, **kwargs):
                            """
                            Use quad face centroids when creating subtets if the case contains periodic boundaries.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/always_use_face_centroid_with_periodics").execute(*args, **kwargs)
                        def enable_high_resolution_tracking(self, *args, **kwargs):
                            """
                            Enable high resolution tracking.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_high_resolution_tracking").execute(*args, **kwargs)
                        def boundary_layer_tracking(self, *args, **kwargs):
                            """
                            Adjust the particle timestep to account for high aspect ratio cells.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/boundary_layer_tracking").execute(*args, **kwargs)
                        def check_subtet_validity(self, *args, **kwargs):
                            """
                            Test for inverted subtets due to warped cells.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/check_subtet_validity").execute(*args, **kwargs)
                        def use_quad_face_centroid(self, *args, **kwargs):
                            """
                            Use quad face centroids when creating subtets.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_quad_face_centroid").execute(*args, **kwargs)
                        def set_film_spreading_parameter(self, *args, **kwargs):
                            """
                            Set the spreading parameter for Lagrangian wallfilm particles.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/set_film_spreading_parameter").execute(*args, **kwargs)
                        def use_velocity_based_error_control(self, *args, **kwargs):
                            """
                            Use adaptive time stepping based upon the particle velocity.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_velocity_based_error_control").execute(*args, **kwargs)
                        def project_wall_film_particles_to_film(self, *args, **kwargs):
                            """
                            Project existing particles to film to track using high resolution tracking?.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/project_wall_film_particles_to_film").execute(*args, **kwargs)
                        def use_barycentric_sampling(self, *args, **kwargs):
                            """
                            Use barycentric coordinates when sampling at planes.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/use_barycentric_sampling").execute(*args, **kwargs)
                        def enable_barycentric_intersections(self, *args, **kwargs):
                            """
                            Use barycentric coordinates for intersection calculations.
                            """
                            return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/enable_barycentric_intersections").execute(*args, **kwargs)

                        class barycentric_interpolation(TUIMenu):
                            """
                            Enter the barycentric interpolation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def enable_transient_variable_interpolation(self, *args, **kwargs):
                                """
                                Enable transient variable interpolation.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/enable_transient_variable_interpolation").execute(*args, **kwargs)
                            def user_interpolation_function(self, *args, **kwargs):
                                """
                                Enter user interpolation function.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/user_interpolation_function").execute(*args, **kwargs)
                            def interpolate_temperature(self, *args, **kwargs):
                                """
                                Enable interpolation of temperature to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_temperature").execute(*args, **kwargs)
                            def nodal_reconstruction_frequency(self, *args, **kwargs):
                                """
                                Update nodal reconstruction every N'th DPM iteration.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/nodal_reconstruction_frequency").execute(*args, **kwargs)
                            def interpolate_flow_solution_gradients(self, *args, **kwargs):
                                """
                                Enable interpolation of flow solution gradients.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_solution_gradients").execute(*args, **kwargs)
                            def interpolate_flow_density(self, *args, **kwargs):
                                """
                                Enable interpolation of flow density to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_density").execute(*args, **kwargs)
                            def precompute_pdf_species(self, *args, **kwargs):
                                """
                                Precompute cell values of PDF species mass fractions prior to particle tracking.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/precompute_pdf_species").execute(*args, **kwargs)
                            def interpolate_flow_cp(self, *args, **kwargs):
                                """
                                Enable interpolation of flow specific heat to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_cp").execute(*args, **kwargs)
                            def interpolate_wallfilm_properties(self, *args, **kwargs):
                                """
                                Enable interpolation of wallfilm properties to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_wallfilm_properties").execute(*args, **kwargs)
                            def zero_nodal_velocity_on_walls(self, *args, **kwargs):
                                """
                                Set the nodal velocity on all walls to zero.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/zero_nodal_velocity_on_walls").execute(*args, **kwargs)
                            def interpolate_flow_viscosity(self, *args, **kwargs):
                                """
                                Enable interpolation of flow viscosity to the particle position.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/barycentric_interpolation/interpolate_flow_viscosity").execute(*args, **kwargs)

                        class particle_relocation(TUIMenu):
                            """
                            Enter the particle relocation menu.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def enhanced_wallfilm_location_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating film particles on faces.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_wallfilm_location_method").execute(*args, **kwargs)
                            def wallfilm_relocation_tolerance_scale_factor(self, *args, **kwargs):
                                """
                                Set the relocation tolerance scaling factor for wallfilm particles after remeshing.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/wallfilm_relocation_tolerance_scale_factor").execute(*args, **kwargs)
                            def load_legacy_particles(self, *args, **kwargs):
                                """
                                Load particles that were tracked without high-resolution tracking enabled.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/load_legacy_particles").execute(*args, **kwargs)
                            def enhanced_cell_relocation_method(self, *args, **kwargs):
                                """
                                Enable enhanced method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/enhanced_cell_relocation_method").execute(*args, **kwargs)
                            def use_legacy_particle_location_method(self, *args, **kwargs):
                                """
                                Enable legacy method of locating particles in cells.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/use_legacy_particle_location_method").execute(*args, **kwargs)
                            def overset_relocation_robustness_level(self, *args, **kwargs):
                                """
                                Set the robustness level for particle relocation in overset meshes.
                                """
                                return PyMenu(self.service, "/setup/models/dpm/numerics/high_resolution_tracking/particle_relocation/overset_relocation_robustness_level").execute(*args, **kwargs)

            class species(TUIMenu):
                """
                Enter the species models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.CHEMKIN_CFD_parameters = self.__class__.CHEMKIN_CFD_parameters(path + ["CHEMKIN_CFD_parameters"], service)
                    super().__init__(path, service)
                def epdf_energy(self, *args, **kwargs):
                    """
                    Enable/disable EPDF energy  option.
                    """
                    return PyMenu(self.service, "/setup/models/species/epdf_energy").execute(*args, **kwargs)
                def premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable the premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/premixed_combustion").execute(*args, **kwargs)
                def clear_isat_table(self, *args, **kwargs):
                    """
                    Clear the ISAT table.
                    """
                    return PyMenu(self.service, "/setup/models/species/clear_isat_table").execute(*args, **kwargs)
                def combustion_numerics(self, *args, **kwargs):
                    """
                    Set combustion numerics options.
                    """
                    return PyMenu(self.service, "/setup/models/species/combustion_numerics").execute(*args, **kwargs)
                def liquid_energy_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable energy diffusion for liquid regime.
                    """
                    return PyMenu(self.service, "/setup/models/species/liquid_energy_diffusion").execute(*args, **kwargs)
                def pdf_transport_expert(self, *args, **kwargs):
                    """
                    Enable/disable PDF transport expert user.
                    """
                    return PyMenu(self.service, "/setup/models/species/pdf_transport_expert").execute(*args, **kwargs)
                def premixed_model(self, *args, **kwargs):
                    """
                    Set premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/premixed_model").execute(*args, **kwargs)
                def mixing_model(self, *args, **kwargs):
                    """
                    Set PDF transport mixing model.
                    """
                    return PyMenu(self.service, "/setup/models/species/mixing_model").execute(*args, **kwargs)
                def off(self, *args, **kwargs):
                    """
                    Enable/disable solution of species models.
                    """
                    return PyMenu(self.service, "/setup/models/species/off").execute(*args, **kwargs)
                def ignition_model(self, *args, **kwargs):
                    """
                    Enable/disable the ignition model.
                    """
                    return PyMenu(self.service, "/setup/models/species/ignition_model").execute(*args, **kwargs)
                def reacting_channel_model_options(self, *args, **kwargs):
                    """
                    Set Reacting Channel Model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/reacting_channel_model_options").execute(*args, **kwargs)
                def combustion_expert(self, *args, **kwargs):
                    """
                    Set combustion expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/combustion_expert").execute(*args, **kwargs)
                def species_transport_expert(self, *args, **kwargs):
                    """
                    Set species transport expert options.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_transport_expert").execute(*args, **kwargs)
                def volumetric_reactions(self, *args, **kwargs):
                    """
                    Enable/disable volumetric reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/volumetric_reactions").execute(*args, **kwargs)
                def relax_to_equil(self, *args, **kwargs):
                    """
                    Enable/disable the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/setup/models/species/relax_to_equil").execute(*args, **kwargs)
                def CHEMKIN_CFD(self, *args, **kwargs):
                    """
                    Enable/disable CHEMKIN-CFD.
                    """
                    return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD").execute(*args, **kwargs)
                def species_migration(self, *args, **kwargs):
                    """
                    Enable/disable ion species migration in electric field.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_migration").execute(*args, **kwargs)
                def init_unsteady_flamelet_prob(self, *args, **kwargs):
                    """
                    Initialize Unsteady Flamelet Probability.
                    """
                    return PyMenu(self.service, "/setup/models/species/init_unsteady_flamelet_prob").execute(*args, **kwargs)
                def set_turb_chem_interaction(self, *args, **kwargs):
                    """
                    Set Eddy-Dissipation Concept model constants.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_turb_chem_interaction").execute(*args, **kwargs)
                def inlet_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable inclusion of diffusion at inlets.
                    """
                    return PyMenu(self.service, "/setup/models/species/inlet_diffusion").execute(*args, **kwargs)
                def stiff_chemistry(self, *args, **kwargs):
                    """
                    Enable/disable stiff chemistry option.
                    """
                    return PyMenu(self.service, "/setup/models/species/stiff_chemistry").execute(*args, **kwargs)
                def multicomponent_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable multicomponent diffusion.
                    """
                    return PyMenu(self.service, "/setup/models/species/multicomponent_diffusion").execute(*args, **kwargs)
                def set_premixed_combustion(self, *args, **kwargs):
                    """
                    Set premixed combustion parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_premixed_combustion").execute(*args, **kwargs)
                def non_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Set PDF parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion_parameters").execute(*args, **kwargs)
                def surf_reaction_netm_params(self, *args, **kwargs):
                    """
                    Set the surface reaction parameters for the Non-Equilibrium Thermal Model.
                    """
                    return PyMenu(self.service, "/setup/models/species/surf_reaction_netm_params").execute(*args, **kwargs)
                def spark_model(self, *args, **kwargs):
                    """
                    Set spark model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/spark_model").execute(*args, **kwargs)
                def surf_reaction_aggressiveness_factor(self, *args, **kwargs):
                    """
                    Set the surface reaction aggressiveness factor.
                    """
                    return PyMenu(self.service, "/setup/models/species/surf_reaction_aggressiveness_factor").execute(*args, **kwargs)
                def pdf_transport(self, *args, **kwargs):
                    """
                    Enable/disable the composition PDF transport combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/pdf_transport").execute(*args, **kwargs)
                def particle_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable particle surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/particle_surface_reactions").execute(*args, **kwargs)
                def non_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Set PDF expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion_expert").execute(*args, **kwargs)
                def non_premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable the non-premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/non_premixed_combustion").execute(*args, **kwargs)
                def partially_premixed_combustion(self, *args, **kwargs):
                    """
                    Enable/disable partially premixed combustion model.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion").execute(*args, **kwargs)
                def partially_premixed_combustion_grids(self, *args, **kwargs):
                    """
                    Set user specified grid parameters for PDF and flamelet.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_grids").execute(*args, **kwargs)
                def wall_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable wall surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/wall_surface_reactions").execute(*args, **kwargs)
                def reactor_network_model(self, *args, **kwargs):
                    """
                    Enable/disable the Reactor Network model.
                    """
                    return PyMenu(self.service, "/setup/models/species/reactor_network_model").execute(*args, **kwargs)
                def save_gradients(self, *args, **kwargs):
                    """
                    Enable/disable storage of species mass fraction gradients.
                    """
                    return PyMenu(self.service, "/setup/models/species/save_gradients").execute(*args, **kwargs)
                def diffusion_energy_source(self, *args, **kwargs):
                    """
                    Enable/disable diffusion energy source.
                    """
                    return PyMenu(self.service, "/setup/models/species/diffusion_energy_source").execute(*args, **kwargs)
                def import_flamelet_for_restart(self, *args, **kwargs):
                    """
                    Import Flamelet File for Restart.
                    """
                    return PyMenu(self.service, "/setup/models/species/import_flamelet_for_restart").execute(*args, **kwargs)
                def decoupled_detailed_chemistry(self, *args, **kwargs):
                    """
                    Enable/disable the Decoupled Detailed Chemistry model.
                    """
                    return PyMenu(self.service, "/setup/models/species/decoupled_detailed_chemistry").execute(*args, **kwargs)
                def reacting_channel_model(self, *args, **kwargs):
                    """
                    Enable/Disable the Reacting Channel Model.
                    """
                    return PyMenu(self.service, "/setup/models/species/reacting_channel_model").execute(*args, **kwargs)
                def integration_parameters(self, *args, **kwargs):
                    """
                    Set ISAT parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/integration_parameters").execute(*args, **kwargs)
                def full_tabulation(self, *args, **kwargs):
                    """
                    Enable/disable building of a full 2 mixture fraction table.
                    """
                    return PyMenu(self.service, "/setup/models/species/full_tabulation").execute(*args, **kwargs)
                def mass_deposition_source(self, *args, **kwargs):
                    """
                    Enable/disable mass deposition source due to surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/mass_deposition_source").execute(*args, **kwargs)
                def coal_calculator(self, *args, **kwargs):
                    """
                    Set up coal modeling inputs.
                    """
                    return PyMenu(self.service, "/setup/models/species/coal_calculator").execute(*args, **kwargs)
                def set_multi_regime_fgm(self, *args, **kwargs):
                    """
                    Set-multi-regim-fgm-parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/set_multi_regime_fgm").execute(*args, **kwargs)
                def inert_transport_model(self, *args, **kwargs):
                    """
                    Enable/disable the inert transport model.
                    """
                    return PyMenu(self.service, "/setup/models/species/inert_transport_model").execute(*args, **kwargs)
                def re_calc_par_premix_props(self, *args, **kwargs):
                    """
                    Re-calculate partially-premixed properties.
                    """
                    return PyMenu(self.service, "/setup/models/species/re_calc_par_premix_props").execute(*args, **kwargs)
                def heat_of_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable heat of surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/heat_of_surface_reactions").execute(*args, **kwargs)
                def electro_chemical_surface_reactions(self, *args, **kwargs):
                    """
                    Enable/disable electrochemical surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/electro_chemical_surface_reactions").execute(*args, **kwargs)
                def thermal_diffusion(self, *args, **kwargs):
                    """
                    Enable/disable thermal diffusion.
                    """
                    return PyMenu(self.service, "/setup/models/species/thermal_diffusion").execute(*args, **kwargs)
                def partially_premixed_properties(self, *args, **kwargs):
                    """
                    Set/Change partially premixed mixture properties.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_properties").execute(*args, **kwargs)
                def liquid_micro_mixing(self, *args, **kwargs):
                    """
                    Enable/disable liquid micro mixing option.
                    """
                    return PyMenu(self.service, "/setup/models/species/liquid_micro_mixing").execute(*args, **kwargs)
                def thickened_flame_model(self, *args, **kwargs):
                    """
                    Enable/disable the Relaxation to Chemical Equilibrium model.
                    """
                    return PyMenu(self.service, "/setup/models/species/thickened_flame_model").execute(*args, **kwargs)
                def ignition_model_controls(self, *args, **kwargs):
                    """
                    Set ignition model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/ignition_model_controls").execute(*args, **kwargs)
                def reaction_diffusion_balance(self, *args, **kwargs):
                    """
                    Enable/disable reaction diffusion balance at reacting surface for surface reactions.
                    """
                    return PyMenu(self.service, "/setup/models/species/reaction_diffusion_balance").execute(*args, **kwargs)
                def flamelet_expert(self, *args, **kwargs):
                    """
                    Set flamelet expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/flamelet_expert").execute(*args, **kwargs)
                def partially_premixed_combustion_expert(self, *args, **kwargs):
                    """
                    Set PDF expert parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_expert").execute(*args, **kwargs)
                def species_transport(self, *args, **kwargs):
                    """
                    Enable/disable the species transport model.
                    """
                    return PyMenu(self.service, "/setup/models/species/species_transport").execute(*args, **kwargs)
                def partially_premixed_combustion_parameters(self, *args, **kwargs):
                    """
                    Set PDF parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/partially_premixed_combustion_parameters").execute(*args, **kwargs)
                def inert_transport_controls(self, *args, **kwargs):
                    """
                    Set inert transport model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/species/inert_transport_controls").execute(*args, **kwargs)

                class CHEMKIN_CFD_parameters(TUIMenu):
                    """
                    Enter the expert CHEMKIN-CFD parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def basic_options(self, *args, **kwargs):
                        """
                        Set basic parameter options.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/basic_options").execute(*args, **kwargs)
                    def list_cell_monitors(self, *args, **kwargs):
                        """
                        List cell monitors.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/list_cell_monitors").execute(*args, **kwargs)
                    def add_cell_monitor(self, *args, **kwargs):
                        """
                        Add a monitor cell for debug output.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/add_cell_monitor").execute(*args, **kwargs)
                    def advanced_options(self, *args, **kwargs):
                        """
                        Set advanced parameter options.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/advanced_options").execute(*args, **kwargs)
                    def delete_cell_monitors(self, *args, **kwargs):
                        """
                        Delete cell monitors.
                        """
                        return PyMenu(self.service, "/setup/models/species/CHEMKIN_CFD_parameters/delete_cell_monitors").execute(*args, **kwargs)

            class cht(TUIMenu):
                """
                Enter the mapped interface model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.explicit_time_averaged_coupling = self.__class__.explicit_time_averaged_coupling(path + ["explicit_time_averaged_coupling"], service)
                    super().__init__(path, service)
                def read_mi_type_wall(self, *args, **kwargs):
                    """
                    Read mapped interface data settings from a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/cht/read_mi_type_wall").execute(*args, **kwargs)
                def implicit_coupling(self, *args, **kwargs):
                    """
                    Enable/disable implicit coupling for mapped interface.
                    """
                    return PyMenu(self.service, "/setup/models/cht/implicit_coupling").execute(*args, **kwargs)
                def write_mi_type_wall(self, *args, **kwargs):
                    """
                    Write mapped interface settings to a scv file.
                    """
                    return PyMenu(self.service, "/setup/models/cht/write_mi_type_wall").execute(*args, **kwargs)

                class explicit_time_averaged_coupling(TUIMenu):
                    """
                    Enter the explcit time averaged thermal coupling menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def mapped_interfaces(self, *args, **kwargs):
                        """
                        Select fluid-solid mapped interfaces for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/mapped_interfaces").execute(*args, **kwargs)
                    def coupling_controls(self, *args, **kwargs):
                        """
                        Specify explcit coupling controls.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/coupling_controls").execute(*args, **kwargs)
                    def conformal_coupled_walls(self, *args, **kwargs):
                        """
                        Select fluid-solid coupled walls (without shell) for explicit coupling using time averaged thermal variables.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/conformal_coupled_walls").execute(*args, **kwargs)
                    def fuse_explicit_cht_zones(self, *args, **kwargs):
                        """
                        Fuse slitted conformal coupled walls marked for transient explicit thermal coupling.
                        """
                        return PyMenu(self.service, "/setup/models/cht/explicit_time_averaged_coupling/fuse_explicit_cht_zones").execute(*args, **kwargs)

            class shell_conduction(TUIMenu):
                """
                Enter the shell conduction model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    super().__init__(path, service)
                def write_csv(self, *args, **kwargs):
                    """
                    Write shell conduction settings to a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/write_csv").execute(*args, **kwargs)
                def settings(self, *args, **kwargs):
                    """
                    Enter Multi-layer Shell Conduction data.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/settings").execute(*args, **kwargs)
                def enhanced_encapsulation(self, *args, **kwargs):
                    """
                    Enable/disable enhanced encapsulation for shell conduction and S2S models. This is not applicable if coupled sliding interface walls exists.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/enhanced_encapsulation").execute(*args, **kwargs)
                def read_csv(self, *args, **kwargs):
                    """
                    Read shell conduction settings from a csv file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/read_csv").execute(*args, **kwargs)
                def save_shell_zones(self, *args, **kwargs):
                    """
                    Enable/Disable saving shell zones to case file.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/save_shell_zones").execute(*args, **kwargs)
                def multi_layer_shell(self, *args, **kwargs):
                    """
                    Enable/disable multi layer shell conduction model.
                    """
                    return PyMenu(self.service, "/setup/models/shell_conduction/multi_layer_shell").execute(*args, **kwargs)

            class heat_exchanger(TUIMenu):
                """
                Enter the heat exchanger menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.macro_model = self.__class__.macro_model(path + ["macro_model"], service)
                    self.dual_cell_model = self.__class__.dual_cell_model(path + ["dual_cell_model"], service)
                    super().__init__(path, service)

                class macro_model(TUIMenu):
                    """
                    Enter the heat macro-model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def heat_exchanger_zone(self, *args, **kwargs):
                        """
                        Define heat-exchanger zone.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_zone").execute(*args, **kwargs)
                    def heat_exchanger_macro_report(self, *args, **kwargs):
                        """
                        Report heat-exchanger information for all the macros.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_macro_report").execute(*args, **kwargs)
                    def delete_heat_exchanger_group(self, *args, **kwargs):
                        """
                        Delete heat-exchanger group.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/delete_heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger_report(self, *args, **kwargs):
                        """
                        Report heat-exchanger information.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_report").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plot NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/plot_NTU").execute(*args, **kwargs)
                    def heat_exchanger_model(self, *args, **kwargs):
                        """
                        Define heat-exchanger core model.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_model").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Write NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/write_NTU").execute(*args, **kwargs)
                    def heat_exchanger_group(self, *args, **kwargs):
                        """
                        Define heat-exchanger group.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger_group").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enable/disable heat-exchanger model.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/macro_model/heat_exchanger").execute(*args, **kwargs)

                class dual_cell_model(TUIMenu):
                    """
                    Enter the dual cell model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def add_heat_exchanger(self, *args, **kwargs):
                        """
                        Add heat-exchanger.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/add_heat_exchanger").execute(*args, **kwargs)
                    def write_NTU(self, *args, **kwargs):
                        """
                        Write NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/write_NTU").execute(*args, **kwargs)
                    def plot_NTU(self, *args, **kwargs):
                        """
                        Plot NTU vs primary mass flow rate for each auxiliary mass flow rate.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/plot_NTU").execute(*args, **kwargs)
                    def heat_exchanger(self, *args, **kwargs):
                        """
                        Enable/disable the dual cell heat-exchanger model.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/heat_exchanger").execute(*args, **kwargs)
                    def delete_heat_exchanger(self, *args, **kwargs):
                        """
                        Delete heat-exchanger.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/delete_heat_exchanger").execute(*args, **kwargs)
                    def modify_heat_exchanger(self, *args, **kwargs):
                        """
                        Modify heat-exchanger.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/modify_heat_exchanger").execute(*args, **kwargs)
                    def alternative_formulation(self, *args, **kwargs):
                        """
                        Enable/disable alternative formulation for heat transfer calculations.
                        """
                        return PyMenu(self.service, "/setup/models/heat_exchanger/dual_cell_model/alternative_formulation").execute(*args, **kwargs)

            class radiation(TUIMenu):
                """
                Enter the radiation models menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.s2s_parameters = self.__class__.s2s_parameters(path + ["s2s_parameters"], service)
                    self.dtrm_parameters = self.__class__.dtrm_parameters(path + ["dtrm_parameters"], service)
                    self.solar_parameters = self.__class__.solar_parameters(path + ["solar_parameters"], service)
                    super().__init__(path, service)
                def radiation_iteration_parameters(self, *args, **kwargs):
                    """
                    Set iteration parameters for radiation models.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/radiation_iteration_parameters").execute(*args, **kwargs)
                def target_cells_per_volume_cluster(self, *args, **kwargs):
                    """
                    Enter cells per volume cluster for Monte Carlo radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/target_cells_per_volume_cluster").execute(*args, **kwargs)
                def mc_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for montecarlo radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/mc_model_parameters").execute(*args, **kwargs)
                def beta_radiation_features(self, *args, **kwargs):
                    """
                    Enable Radiation Models with Non-Iterative Time Advancement (NITA) as Beta features in FL12.0.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/beta_radiation_features").execute(*args, **kwargs)
                def apply_full_solar_irradiation(self, *args, **kwargs):
                    """
                    Enable/disable application of solar irradiation to first band with DO model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/apply_full_solar_irradiation").execute(*args, **kwargs)
                def s2s(self, *args, **kwargs):
                    """
                    Enable/disable the S2S radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/s2s").execute(*args, **kwargs)
                def radiation_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for radiation models.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/radiation_model_parameters").execute(*args, **kwargs)
                def mc_under_relaxation(self, *args, **kwargs):
                    """
                    Set under-relaxation factor for montecarlo radiation sources used in the energy equation.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/mc_under_relaxation").execute(*args, **kwargs)
                def wsggm_cell_based(self, *args, **kwargs):
                    """
                    Enable/disable WSGGM cell based method.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/wsggm_cell_based").execute(*args, **kwargs)
                def do_acceleration(self, *args, **kwargs):
                    """
                    Enable/disable acceleration of computation of DO model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/do_acceleration").execute(*args, **kwargs)
                def montecarlo(self, *args, **kwargs):
                    """
                    Enable/disable the Monte Carlo radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/montecarlo").execute(*args, **kwargs)
                def solar_irradiation(self, *args, **kwargs):
                    """
                    Enable/disable the Solar irradiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solar_irradiation").execute(*args, **kwargs)
                def solution_method_for_do_coupling(self, *args, **kwargs):
                    """
                    Enable the solution method for DO/Energy  Coupling.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solution_method_for_do_coupling").execute(*args, **kwargs)
                def rosseland(self, *args, **kwargs):
                    """
                    Enable/disable the Rosseland radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/rosseland").execute(*args, **kwargs)
                def blending_factor(self, *args, **kwargs):
                    """
                    Set numeric option for Discrete Ordinate model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/blending_factor").execute(*args, **kwargs)
                def non_gray_model_parameters(self, *args, **kwargs):
                    """
                    Set parameters for non-gray model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/non_gray_model_parameters").execute(*args, **kwargs)
                def method_partially_specular_wall(self, *args, **kwargs):
                    """
                    Set method for partially specular wall with discrete ordinate model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/method_partially_specular_wall").execute(*args, **kwargs)
                def discrete_ordinates(self, *args, **kwargs):
                    """
                    Enable/disable the discrete ordinates radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/discrete_ordinates").execute(*args, **kwargs)
                def solar(self, *args, **kwargs):
                    """
                    Enable/disable the solar model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solar").execute(*args, **kwargs)
                def fast_second_order_discrete_ordinate(self, *args, **kwargs):
                    """
                    Enable/disable the fast-second-order option for Discrete Ordinate Model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/fast_second_order_discrete_ordinate").execute(*args, **kwargs)
                def solar_calculator(self, *args, **kwargs):
                    """
                    Calculate sun direction and intensity.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/solar_calculator").execute(*args, **kwargs)
                def discrete_transfer(self, *args, **kwargs):
                    """
                    Enable/disable discrete the transfer radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/discrete_transfer").execute(*args, **kwargs)
                def p1(self, *args, **kwargs):
                    """
                    Enable/disable the P1 radiation model.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/p1").execute(*args, **kwargs)
                def do_coupling(self, *args, **kwargs):
                    """
                    Enabled DO Energy Coupling.
                    """
                    return PyMenu(self.service, "/setup/models/radiation/do_coupling").execute(*args, **kwargs)

                class s2s_parameters(TUIMenu):
                    """
                    Enter the S2S parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def read_vf_file(self, *args, **kwargs):
                        """
                        Read an S2S file.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/read_vf_file").execute(*args, **kwargs)
                    def enable_mesh_interface_clustering(self, *args, **kwargs):
                        """
                        Enable clustering on mesh interfaces?.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/enable_mesh_interface_clustering").execute(*args, **kwargs)
                    def compute_write_vf(self, *args, **kwargs):
                        """
                        Compute/write surface clusters and view factors for S2S radiation model.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_write_vf").execute(*args, **kwargs)
                    def print_zonewise_radiation(self, *args, **kwargs):
                        """
                        Prints the zonewise incoming radiation, viewfactors, and average temperature.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/print_zonewise_radiation").execute(*args, **kwargs)
                    def print_thread_clusters(self, *args, **kwargs):
                        """
                        Prints the following for all boundary threads: thread-id, number of faces, faces per surface cluster, and the number of surface clusters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/print_thread_clusters").execute(*args, **kwargs)
                    def use_new_cluster_algorithm(self, *args, **kwargs):
                        """
                        Use the new surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/use_new_cluster_algorithm").execute(*args, **kwargs)
                    def split_angle(self, *args, **kwargs):
                        """
                        Set the split angle for the clustering algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/split_angle").execute(*args, **kwargs)
                    def compute_fpsc_values(self, *args, **kwargs):
                        """
                        Compute only fpsc values based on current settings.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_fpsc_values").execute(*args, **kwargs)
                    def set_vf_parameters(self, *args, **kwargs):
                        """
                        Set the parameters needed for the view factor calculations.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/set_vf_parameters").execute(*args, **kwargs)
                    def use_old_cluster_algorithm(self, *args, **kwargs):
                        """
                        Use the old surface clustering algorithm.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/use_old_cluster_algorithm").execute(*args, **kwargs)
                    def compute_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write view factors from existing surface clusters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_vf_accelerated").execute(*args, **kwargs)
                    def compute_vf_only(self, *args, **kwargs):
                        """
                        Compute/write view factors only.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_vf_only").execute(*args, **kwargs)
                    def set_global_faces_per_surface_cluster(self, *args, **kwargs):
                        """
                        Set global value of faces per surface cluster for all boundary zones.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/set_global_faces_per_surface_cluster").execute(*args, **kwargs)
                    def compute_clusters_and_vf_accelerated(self, *args, **kwargs):
                        """
                        Compute/Write surface cluster first and then view factors.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/compute_clusters_and_vf_accelerated").execute(*args, **kwargs)
                    def non_participating_boundary_zones_temperature(self, *args, **kwargs):
                        """
                        Set temperature for the non-participating boundary zones.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/s2s_parameters/non_participating_boundary_zones_temperature").execute(*args, **kwargs)

                class dtrm_parameters(TUIMenu):
                    """
                    Enter the DTRM parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def make_globs(self, *args, **kwargs):
                        """
                        Make globs (coarser mesh) for radiation.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/make_globs").execute(*args, **kwargs)
                    def ray_trace(self, *args, **kwargs):
                        """
                        Create DTRM rays for radiation.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/ray_trace").execute(*args, **kwargs)
                    def controls(self, *args, **kwargs):
                        """
                        Set DTRM solution controls.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/controls").execute(*args, **kwargs)
                    def check_ray_file(self, *args, **kwargs):
                        """
                        Read DTRM rays file.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/dtrm_parameters/check_ray_file").execute(*args, **kwargs)

                class solar_parameters(TUIMenu):
                    """
                    Enter the solar parameters menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def illumination_parameters(self, *args, **kwargs):
                        """
                        Set illumination parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/illumination_parameters").execute(*args, **kwargs)
                    def iteration_parameters(self, *args, **kwargs):
                        """
                        Set update parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/iteration_parameters").execute(*args, **kwargs)
                    def scattering_fraction(self, *args, **kwargs):
                        """
                        Set scattering fraction parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/scattering_fraction").execute(*args, **kwargs)
                    def autoread_solar_data(self, *args, **kwargs):
                        """
                        Set autoread solar data parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/autoread_solar_data").execute(*args, **kwargs)
                    def quad_tree_parameters(self, *args, **kwargs):
                        """
                        Set quad-tree refinement parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/quad_tree_parameters").execute(*args, **kwargs)
                    def solar_thread_control(self, *args, **kwargs):
                        """
                        Solar thread control.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/solar_thread_control").execute(*args, **kwargs)
                    def sol_on_demand(self, *args, **kwargs):
                        """
                        Enable  solar load on demand.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sol_on_demand").execute(*args, **kwargs)
                    def use_direction_from_sol_calc(self, *args, **kwargs):
                        """
                        Set direction computed from solar calculator.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/use_direction_from_sol_calc").execute(*args, **kwargs)
                    def autosave_solar_data(self, *args, **kwargs):
                        """
                        Set autosave solar data parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/autosave_solar_data").execute(*args, **kwargs)
                    def sol_adjacent_fluidcells(self, *args, **kwargs):
                        """
                        Enable solar load for adjacent fluid cells.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sol_adjacent_fluidcells").execute(*args, **kwargs)
                    def sun_direction_vector(self, *args, **kwargs):
                        """
                        Set sun direction vector.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sun_direction_vector").execute(*args, **kwargs)
                    def ground_reflectivity(self, *args, **kwargs):
                        """
                        Set ground reflectivity parameters.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/ground_reflectivity").execute(*args, **kwargs)
                    def sol_camera_pos(self, *args, **kwargs):
                        """
                        Set camera position based on sun direction vector.
                        """
                        return PyMenu(self.service, "/setup/models/radiation/solar_parameters/sol_camera_pos").execute(*args, **kwargs)

            class eulerian_wallfilm(TUIMenu):
                """
                Enter the Eulerian wall film model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.coupled_solution = self.__class__.coupled_solution(path + ["coupled_solution"], service)
                    self.implicit_options = self.__class__.implicit_options(path + ["implicit_options"], service)
                    super().__init__(path, service)
                def initialize_wallfilm_model(self, *args, **kwargs):
                    """
                    Initialize Eulerian wall film model.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/initialize_wallfilm_model").execute(*args, **kwargs)
                def film_material(self, *args, **kwargs):
                    """
                    Set film material and properties.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/film_material").execute(*args, **kwargs)
                def enable_wallfilm_model(self, *args, **kwargs):
                    """
                    Enable Eulerian wall film model.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/enable_wallfilm_model").execute(*args, **kwargs)
                def solution_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model solution options.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/solution_options").execute(*args, **kwargs)
                def enable_film_vof_transition_message(self, *args, **kwargs):
                    """
                    Enable film-VOF transition message.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/enable_film_vof_transition_message").execute(*args, **kwargs)
                def list_film_walls(self, *args, **kwargs):
                    """
                    List film walls.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/list_film_walls").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Set Eulerian wall film model options.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/model_options").execute(*args, **kwargs)
                def solve_wallfilm_equation(self, *args, **kwargs):
                    """
                    Activate Eulerian wall film equations.
                    """
                    return PyMenu(self.service, "/setup/models/eulerian_wallfilm/solve_wallfilm_equation").execute(*args, **kwargs)

                class coupled_solution(TUIMenu):
                    """
                    Enter Eulerian wall film coupled solution menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def enable_curvature_smoothing(self, *args, **kwargs):
                        """
                        Enable Eulerian wall film curvature smoothing.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/coupled_solution/enable_curvature_smoothing").execute(*args, **kwargs)
                    def enable_coupled_solution(self, *args, **kwargs):
                        """
                        Enable Eulerian wall film coupled solution.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/coupled_solution/enable_coupled_solution").execute(*args, **kwargs)

                class implicit_options(TUIMenu):
                    """
                    Enter Implicit Scheme Option (beta).
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def relative_error_residual(self, *args, **kwargs):
                        """
                        Enable relative error residual.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/implicit_options/relative_error_residual").execute(*args, **kwargs)
                    def new_implicit_scheme(self, *args, **kwargs):
                        """
                        Enable alternative implicit scheme.
                        """
                        return PyMenu(self.service, "/setup/models/eulerian_wallfilm/implicit_options/new_implicit_scheme").execute(*args, **kwargs)

            class structure(TUIMenu):
                """
                Enter the structure model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.expert = self.__class__.expert(path + ["expert"], service)
                    self.controls = self.__class__.controls(path + ["controls"], service)
                    super().__init__(path, service)
                def nonlinear_elasticity(self, *args, **kwargs):
                    """
                    Enable the nonlinear elasticity model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/nonlinear_elasticity").execute(*args, **kwargs)
                def structure_off(self, *args, **kwargs):
                    """
                    Disable the structural model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/structure_off").execute(*args, **kwargs)
                def linear_elasticity(self, *args, **kwargs):
                    """
                    Enable the linear elasticity model.
                    """
                    return PyMenu(self.service, "/setup/models/structure/linear_elasticity").execute(*args, **kwargs)
                def thermal_effects(self, *args, **kwargs):
                    """
                    Enable structure thermal effects.
                    """
                    return PyMenu(self.service, "/setup/models/structure/thermal_effects").execute(*args, **kwargs)

                class expert(TUIMenu):
                    """
                    Enter the structure expert menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def include_pop_in_fsi_force(self, *args, **kwargs):
                        """
                        Enable inclusion of operating p into fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/include_pop_in_fsi_force").execute(*args, **kwargs)
                    def explicit_fsi_force(self, *args, **kwargs):
                        """
                        Enable explicit fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/explicit_fsi_force").execute(*args, **kwargs)
                    def starting_t_re_initialization(self, *args, **kwargs):
                        """
                        Set starting T-field re-initialization method.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/starting_t_re_initialization").execute(*args, **kwargs)
                    def steady_2way_fsi(self, *args, **kwargs):
                        """
                        Enable steady 2-way fsi workflow.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/steady_2way_fsi").execute(*args, **kwargs)
                    def include_viscous_fsi_force(self, *args, **kwargs):
                        """
                        Enable inclusion of viscous fsi force.
                        """
                        return PyMenu(self.service, "/setup/models/structure/expert/include_viscous_fsi_force").execute(*args, **kwargs)

                class controls(TUIMenu):
                    """
                    Enter the structure controls menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def unsteady_damping_rayleigh(self, *args, **kwargs):
                        """
                        Enable/disable Newmark unsteady solution model.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/unsteady_damping_rayleigh").execute(*args, **kwargs)
                    def amg_stabilization(self, *args, **kwargs):
                        """
                        Set the AMG stabilization method for structural solver.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/amg_stabilization").execute(*args, **kwargs)
                    def enhanced_strain(self, *args, **kwargs):
                        """
                        Enable enhanced strain element.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/enhanced_strain").execute(*args, **kwargs)
                    def numerical_damping_factor(self, *args, **kwargs):
                        """
                        Set structure damping parameters.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/numerical_damping_factor").execute(*args, **kwargs)
                    def max_iter(self, *args, **kwargs):
                        """
                        Set the maximum number of iterations for structural solver.
                        """
                        return PyMenu(self.service, "/setup/models/structure/controls/max_iter").execute(*args, **kwargs)

            class electrolysis(TUIMenu):
                """
                Enter the electrolysis model setup menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.anode_setup = self.__class__.anode_setup(path + ["anode_setup"], service)
                    self.cathode_setup = self.__class__.cathode_setup(path + ["cathode_setup"], service)
                    self.membrane_setup = self.__class__.membrane_setup(path + ["membrane_setup"], service)
                    super().__init__(path, service)
                def parameters(self, *args, **kwargs):
                    """
                    Specify electrolysis model parameters.
                    """
                    return PyMenu(self.service, "/setup/models/electrolysis/parameters").execute(*args, **kwargs)
                def model_options(self, *args, **kwargs):
                    """
                    Specify electrolysis model options.
                    """
                    return PyMenu(self.service, "/setup/models/electrolysis/model_options").execute(*args, **kwargs)
                def electrical_tabs_setup(self, *args, **kwargs):
                    """
                    Specify settings for the electrical tabs.
                    """
                    return PyMenu(self.service, "/setup/models/electrolysis/electrical_tabs_setup").execute(*args, **kwargs)

                class anode_setup(TUIMenu):
                    """
                    Enter the menu for the anode controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/current_collector").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/catalyst_layer").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/flow_channel").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/porous_layer").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/anode_setup/electrolyte").execute(*args, **kwargs)

                class cathode_setup(TUIMenu):
                    """
                    Enter the menu for the cathode controls.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/catalyst_layer").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/current_collector").execute(*args, **kwargs)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/flow_channel").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/porous_layer").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/cathode_setup/electrolyte").execute(*args, **kwargs)

                class membrane_setup(TUIMenu):
                    """
                    Specify parameters for electrolyte.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        super().__init__(path, service)
                    def flow_channel(self, *args, **kwargs):
                        """
                        Set parameters for the flow channel.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/flow_channel").execute(*args, **kwargs)
                    def electrolyte(self, *args, **kwargs):
                        """
                        Set parameters for the electrolyte.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/electrolyte").execute(*args, **kwargs)
                    def catalyst_layer(self, *args, **kwargs):
                        """
                        Set parameters for the catalyst layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/catalyst_layer").execute(*args, **kwargs)
                    def porous_layer(self, *args, **kwargs):
                        """
                        Set parameters for the porous layer.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/porous_layer").execute(*args, **kwargs)
                    def current_collector(self, *args, **kwargs):
                        """
                        Set parameters for the current collector.
                        """
                        return PyMenu(self.service, "/setup/models/electrolysis/membrane_setup/current_collector").execute(*args, **kwargs)

            class multiphase(TUIMenu):
                """
                Define multiphase model menu.
                """
                def __init__(self, path, service):
                    self.path = path
                    self.service = service
                    self.flow_regime_modeling = self.__class__.flow_regime_modeling(path + ["flow_regime_modeling"], service)
                    self.population_balance = self.__class__.population_balance(path + ["population_balance"], service)
                    self.phases = self.__class__.phases(path + ["phases"], service)
                    self.hybrid_models = self.__class__.hybrid_models(path + ["hybrid_models"], service)
                    self.wet_steam = self.__class__.wet_steam(path + ["wet_steam"], service)
                    self.explicit_expert_options = self.__class__.explicit_expert_options(path + ["explicit_expert_options"], service)
                    self.sub_models = self.__class__.sub_models(path + ["sub_models"], service)
                    super().__init__(path, service)
                def volume_fraction_parameters(self, *args, **kwargs):
                    """
                    Volume fraction parameters.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/volume_fraction_parameters").execute(*args, **kwargs)
                def vof_sub_models(self, *args, **kwargs):
                    """
                    VOF sub-models.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/vof_sub_models").execute(*args, **kwargs)
                def body_force_formulation(self, *args, **kwargs):
                    """
                    Body force formulation.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/body_force_formulation").execute(*args, **kwargs)
                def number_of_phases(self, *args, **kwargs):
                    """
                    Specify the number of phases.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/number_of_phases").execute(*args, **kwargs)
                def regime_transition_modeling(self, *args, **kwargs):
                    """
                    Regime-transition-modeling-options.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/regime_transition_modeling").execute(*args, **kwargs)
                def mixture_parameters(self, *args, **kwargs):
                    """
                    Mixture parameters.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/mixture_parameters").execute(*args, **kwargs)
                def interface_modeling_options(self, *args, **kwargs):
                    """
                    Interface Modeling Options.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/interface_modeling_options").execute(*args, **kwargs)
                def coupled_level_set(self, *args, **kwargs):
                    """
                    Coupled level set.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/coupled_level_set").execute(*args, **kwargs)
                def model(self, *args, **kwargs):
                    """
                    Specify multiphase model.
                    """
                    return PyMenu(self.service, "/setup/models/multiphase/model").execute(*args, **kwargs)

                class flow_regime_modeling(TUIMenu):
                    """
                    Flow Regime Modeling.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.aiad_parameters = self.__class__.aiad_parameters(path + ["aiad_parameters"], service)
                        super().__init__(path, service)
                    def enable(self, *args, **kwargs):
                        """
                        Enable flow regime modeling framework including phase state and morphology.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/enable").execute(*args, **kwargs)

                    class aiad_parameters(TUIMenu):
                        """
                        AIAD parameters.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def delta_grad(self, *args, **kwargs):
                            """
                            Parameter for determining transition width for free surface blending factor.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/delta_grad").execute(*args, **kwargs)
                        def delta_vf(self, *args, **kwargs):
                            """
                            Parameter for transition width for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/delta_vf").execute(*args, **kwargs)
                        def critical_vf(self, *args, **kwargs):
                            """
                            Critical volume fraction for bubbly and droplet flow blending factors.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/critical_vf").execute(*args, **kwargs)
                        def ncells_fs(self, *args, **kwargs):
                            """
                            Parameter for determining interfacial width.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/flow_regime_modeling/aiad_parameters/ncells_fs").execute(*args, **kwargs)

                class population_balance(TUIMenu):
                    """
                    Enter the population balance model menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.expert = self.__class__.expert(path + ["expert"], service)
                        self.phenomena = self.__class__.phenomena(path + ["phenomena"], service)
                        super().__init__(path, service)
                    def model(self, *args, **kwargs):
                        """
                        Select the population balance model.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/model").execute(*args, **kwargs)
                    def size_calculator(self, *args, **kwargs):
                        """
                        Calculate fluid particle diameters using different methods.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/size_calculator").execute(*args, **kwargs)
                    def include_expansion(self, *args, **kwargs):
                        """
                        Set expansion.
                        """
                        return PyMenu(self.service, "/setup/models/multiphase/population_balance/include_expansion").execute(*args, **kwargs)

                    class expert(TUIMenu):
                        """
                        Enter the expert menu for quadrature-based population balance method.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.qmom = self.__class__.qmom(path + ["qmom"], service)
                            super().__init__(path, service)

                        class qmom(TUIMenu):
                            """
                            .
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                super().__init__(path, service)
                            def inversion_algorithm(self, *args, **kwargs):
                                """
                                Select the inversion algorithm for quadrature-based population balance method.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/inversion_algorithm").execute(*args, **kwargs)
                            def print_realizable_moment_warning(self, *args, **kwargs):
                                """
                                Print the information for realizable moments in the population balance model.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/print_realizable_moment_warning").execute(*args, **kwargs)
                            def realizable_moments(self, *args, **kwargs):
                                """
                                Set the population balance model.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/realizable_moments").execute(*args, **kwargs)
                            def retain_qmom_sources_for_low_vof(self, *args, **kwargs):
                                """
                                Retain qmom source calculation for low secondary phase vof.
                                """
                                return PyMenu(self.service, "/setup/models/multiphase/population_balance/expert/qmom/retain_qmom_sources_for_low_vof").execute(*args, **kwargs)

                    class phenomena(TUIMenu):
                        """
                        Enter the phenomena menu for population balance.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            super().__init__(path, service)
                        def growth(self, *args, **kwargs):
                            """
                            Set the growth rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/growth").execute(*args, **kwargs)
                        def breakage_factor(self, *args, **kwargs):
                            """
                            Set a factor which controls the intensity of the selected breakage kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage_factor").execute(*args, **kwargs)
                        def aggregation_factor(self, *args, **kwargs):
                            """
                            Set a factor which controls the intensity of the selected aggregation kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/aggregation_factor").execute(*args, **kwargs)
                        def breakage_aggregation_vof_cutoff(self, *args, **kwargs):
                            """
                            Control vof cut-off for breakage and aggregation.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage_aggregation_vof_cutoff").execute(*args, **kwargs)
                        def nucleation(self, *args, **kwargs):
                            """
                            Set the nucleantion rate.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/nucleation").execute(*args, **kwargs)
                        def aggregation(self, *args, **kwargs):
                            """
                            Set the aggregation kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/aggregation").execute(*args, **kwargs)
                        def breakage(self, *args, **kwargs):
                            """
                            Set the breakage kernel.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/population_balance/phenomena/breakage").execute(*args, **kwargs)

                class phases(TUIMenu):
                    """
                    Enter the phases menu.
                    """
                    def __init__(self, path, service):
                        self.path = path
                        self.service = service
                        self.set_domain_properties = self.__class__.set_domain_properties(path + ["set_domain_properties"], service)
                        self.iac_expert = self.__class__.iac_expert(path + ["iac_expert"], service)
                        super().__init__(path, service)

                    class set_domain_properties(TUIMenu):
                        """
                        Enter the menu to set domain properties.
                        """
                        def __init__(self, path, service):
                            self.path = path
                            self.service = service
                            self.interaction_domain = self.__class__.interaction_domain(path + ["interaction_domain"], service)
                            super().__init__(path, service)
                        def phase_domains(self, *args, **kwargs):
                            """
                            Enter the menu to select a specific phase domain.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/phase_domains").execute(*args, **kwargs)
                        def change_phases_names(self, *args, **kwargs):
                            """
                            Change names for all defined phases?.
                            """
                            return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/change_phases_names").execute(*args, **kwargs)

                        class interaction_domain(TUIMenu):
                            """
                            Enter the menu to set the interaction domain properties.
                            """
                            def __init__(self, path, service):
                                self.path = path
                                self.service = service
                                self.interfacial_area = self.__class__.interfacial_area(path + ["interfacial_area"], service)
                                self.heat_mass_reactions = self.__class__.heat_mass_reactions(path + ["heat_mass_reactions"], service)
                                self.numerics = self.__class__.numerics(path + ["numerics"], service)
                                self.forces = self.__class__.forces(path + ["forces"], service)
                                self.model_transition = self.__class__.model_transition(path + ["model_transition"], service)
                                super().__init__(path, service)

                            class interfacial_area(TUIMenu):
                                """
                                Enter the menu to set interfacial area models.
                                """
                                def __init__(self, path, service):
                                    self.path = path
                                    self.service = service
                                    self.cavitation = self.__class__.cavitation(path + ["cavitation"], service)
                                    self.surface_tension = self.__class__.surface_tension(path + ["surface_tension"], service)
                                    self.interphase_viscous_dissipation = self.__class__.interphase_viscous_dissipation(path + ["interphase_viscous_dissipation"], service)
                                    self.lift = self.__class__.lift(path + ["lift"], service)
                                    self.virtual_mass = self.__class__.virtual_mass(path + ["virtual_mass"], service)
                                    self.interphase_discretization = self.__class__.interphase_discretization(path + ["interphase_discretization"], service)
                                    super().__init__(path, service)
                                def wall_lubrication(self, *args, **kwargs):
                                    """
                                    Specify the wall lubrication model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/wall_lubrication").execute(*args, **kwargs)
                                def restitution(self, *args, **kwargs):
                                    """
                                    Specify the restitution coefficient for collisions between each pair of granular phases and for collisions between particles of the same granular phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/restitution").execute(*args, **kwargs)
                                def interfacial_area(self, *args, **kwargs):
                                    """
                                    Set the interfacial area parameters for each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/interfacial_area").execute(*args, **kwargs)
                                def reactions(self, *args, **kwargs):
                                    """
                                    Define multiple heterogeneous reactions and stoichiometry.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/reactions").execute(*args, **kwargs)
                                def mass_transfer(self, *args, **kwargs):
                                    """
                                    Specify the mass transfer mechanisms.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/mass_transfer").execute(*args, **kwargs)
                                def turbulence_interaction(self, *args, **kwargs):
                                    """
                                    Specify the turbulence interaction model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulence_interaction").execute(*args, **kwargs)
                                def drag(self, *args, **kwargs):
                                    """
                                    Specify the drag function for each pair of phases. It also enables drag modification and allow specifying the drag factor.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/drag").execute(*args, **kwargs)
                                def turbulent_dispersion(self, *args, **kwargs):
                                    """
                                    Specify the turbulent dispersion model for each primary-secondary phase pair.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/turbulent_dispersion").execute(*args, **kwargs)
                                def model_transition(self, *args, **kwargs):
                                    """
                                    Set the model transition mechanism.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/model_transition").execute(*args, **kwargs)
                                def heat_coeff(self, *args, **kwargs):
                                    """
                                    Specify the heat transfer coefficient function between each pair of phases.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/heat_coeff").execute(*args, **kwargs)
                                def slip_velocity(self, *args, **kwargs):
                                    """
                                    Specify the slip velocity function for each secondary phase with respect to the primary phase.
                                    """
                                    return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/slip_velocity").execute(*args, **kwargs)

                                class cavitation(TUIMenu):
                                    """
                                    Enter the menu to set cavitation models.
                                    """
                                    def __init__(self, path, service):
                                        self.path = path
                                        self.service = service
                                        super().__init__(path, service)
                                    def wall_adhesion(self, *args, **kwargs):
                                        """
                                        Enable the specification for a wall adhesion angle?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/wall_adhesion").execute(*args, **kwargs)
                                    def interphase_visc_disp(self, *args, **kwargs):
                                        """
                                        Enable the interfacial viscous dissipation method, which introduces an artificial viscous damping term in the momentum equation?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/interphase_visc_disp").execute(*args, **kwargs)
                                    def vmass_implicit(self, *args, **kwargs):
                                        """
                                        Enable the implicit method for the virtual mass force?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit").execute(*args, **kwargs)
                                    def lift(self, *args, **kwargs):
                                        """
                                        .
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift").execute(*args, **kwargs)
                                    def cavitation(self, *args, **kwargs):
                                        """
                                        Set the vaporization pressure, the surface tension coefficient, and the non-condensable gas mass fraction.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/cavitation").execute(*args, **kwargs)
                                    def lift_shaver_podowski(self, *args, **kwargs):
                                        """
                                        Include the Shaver-Podowski correction for Lift.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/lift_shaver_podowski").execute(*args, **kwargs)
                                    def sfc_modeling(self, *args, **kwargs):
                                        """
                                        Include the effects of surface tension along the fluid-fluid interface?.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_modeling").execute(*args, **kwargs)
                                    def slope_limiter(self, *args, **kwargs):
                                        """
                                        Specify the slope limiter to set a specific discretization scheme. 0: first order upwind, 1: second order reconstruction bounded by the global minimum/maximum of the volume fraction, 2: compressive. Value between 0 and 2: blended scheme.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/slope_limiter").execute(*args, **kwargs)
                                    def vmass_implicit_options(self, *args, **kwargs):
                                        """
                                        Select the virtual mass implicit option.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/vmass_implicit_options").execute(*args, **kwargs)
                                    def sfc_model_type(self, *args, **kwargs):
                                        """
                                        Select the surface tension model.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/sfc_model_type").execute(*args, **kwargs)
                                    def visc_disp_factor(self, *args, **kwargs):
                                        """
                                        Set the dissipation intensity.
                                        """
                                        return PyMenu(self.service, "/setup/models/multiphase/phases/set_domain_properties/interaction_domain/interfacial_area/cavitation/visc_disp_factor").execute(*args, **kwargs)
                                    def jump_adhesion(self, *args, **kwargs):
                                      