"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Schema = void 0;
/**
 * @see https://docs.aws.amazon.com/athena/latest/ug/data-types.html
 * @experimental
 */
class Schema {
    /**
     * (experimental) Creates a decimal type.
     *
     * TODO: Bounds
     *
     * @param precision the total number of digits.
     * @param scale the number of digits in fractional part, the default is 0.
     * @experimental
     */
    static decimal(precision, scale) {
        return {
            isPrimitive: true,
            inputString: scale !== undefined ? `decimal(${precision},${scale})` : `decimal(${precision})`,
        };
    }
    /**
     * (experimental) Fixed length character data, with a specified length between 1 and 255.
     *
     * @param length length between 1 and 255.
     * @experimental
     */
    static char(length) {
        if (length <= 0 || length > 255) {
            throw new Error(`char length must be (inclusively) between 1 and 255, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`char length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `char(${length})`,
        };
    }
    /**
     * (experimental) Variable length character data, with a specified length between 1 and 65535.
     *
     * @param length length between 1 and 65535.
     * @experimental
     */
    static varchar(length) {
        if (length <= 0 || length > 65535) {
            throw new Error(`varchar length must be (inclusively) between 1 and 65535, but was ${length}`);
        }
        if (length % 1 !== 0) {
            throw new Error(`varchar length must be a positive integer, was ${length}`);
        }
        return {
            isPrimitive: true,
            inputString: `varchar(${length})`,
        };
    }
    /**
     * (experimental) Creates an array of some other type.
     *
     * @param itemType type contained by the array.
     * @experimental
     */
    static array(itemType) {
        return {
            isPrimitive: false,
            inputString: `array<${itemType.inputString}>`,
        };
    }
    /**
     * (experimental) Creates a map of some primitive key type to some value type.
     *
     * @param keyType type of key, must be a primitive.
     * @param valueType type fo the value indexed by the key.
     * @experimental
     */
    static map(keyType, valueType) {
        if (!keyType.isPrimitive) {
            throw new Error(`the key type of a 'map' must be a primitive, but was ${keyType.inputString}`);
        }
        return {
            isPrimitive: false,
            inputString: `map<${keyType.inputString},${valueType.inputString}>`,
        };
    }
    /**
     * (experimental) Creates a nested structure containing individually named and typed columns.
     *
     * @param columns the columns of the structure.
     * @experimental
     */
    static struct(columns) {
        return {
            isPrimitive: false,
            inputString: `struct<${columns.map(column => {
                if (column.comment === undefined) {
                    return `${column.name}:${column.type.inputString}`;
                }
                else {
                    return `${column.name}:${column.type.inputString} COMMENT '${column.comment}'`;
                }
            }).join(',')}>`,
        };
    }
}
exports.Schema = Schema;
/**
 * @experimental
 */
Schema.BOOLEAN = {
    isPrimitive: true,
    inputString: 'boolean',
};
/**
 * @experimental
 */
Schema.BINARY = {
    isPrimitive: true,
    inputString: 'binary',
};
/**
 * (experimental) A 64-bit signed INTEGER in two’s complement format, with a minimum value of -2^63 and a maximum value of 2^63-1.
 *
 * @experimental
 */
Schema.BIG_INT = {
    isPrimitive: true,
    inputString: 'bigint',
};
/**
 * @experimental
 */
Schema.DOUBLE = {
    isPrimitive: true,
    inputString: 'double',
};
/**
 * @experimental
 */
Schema.FLOAT = {
    isPrimitive: true,
    inputString: 'float',
};
/**
 * (experimental) A 32-bit signed INTEGER in two’s complement format, with a minimum value of -2^31 and a maximum value of 2^31-1.
 *
 * @experimental
 */
Schema.INTEGER = {
    isPrimitive: true,
    inputString: 'int',
};
/**
 * (experimental) A 16-bit signed INTEGER in two’s complement format, with a minimum value of -2^15 and a maximum value of 2^15-1.
 *
 * @experimental
 */
Schema.SMALL_INT = {
    isPrimitive: true,
    inputString: 'smallint',
};
/**
 * (experimental) A 8-bit signed INTEGER in two’s complement format, with a minimum value of -2^7 and a maximum value of 2^7-1.
 *
 * @experimental
 */
Schema.TINY_INT = {
    isPrimitive: true,
    inputString: 'tinyint',
};
/**
 * (experimental) Date type.
 *
 * @experimental
 */
Schema.DATE = {
    isPrimitive: true,
    inputString: 'date',
};
/**
 * (experimental) Timestamp type (date and time).
 *
 * @experimental
 */
Schema.TIMESTAMP = {
    isPrimitive: true,
    inputString: 'timestamp',
};
/**
 * (experimental) Arbitrary-length string type.
 *
 * @experimental
 */
Schema.STRING = {
    isPrimitive: true,
    inputString: 'string',
};
//# sourceMappingURL=data:application/json;base64,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