import * as cdk from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) A Service Catalog AppRegistry Attribute Group.
 *
 * @experimental
 */
export interface IAttributeGroup extends cdk.IResource {
    /**
     * (experimental) The ARN of the attribute group.
     *
     * @experimental
     * @attribute true
     */
    readonly attributeGroupArn: string;
    /**
     * (experimental) The ID of the attribute group.
     *
     * @experimental
     * @attribute true
     */
    readonly attributeGroupId: string;
}
/**
 * (experimental) Properties for a Service Catalog AppRegistry Attribute Group.
 *
 * @experimental
 */
export interface AttributeGroupProps {
    /**
     * (experimental) Enforces a particular physical attribute group name.
     *
     * @experimental
     */
    readonly attributeGroupName: string;
    /**
     * (experimental) Description for attribute group.
     *
     * @default - No description provided
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) A JSON of nested key-value pairs that represent the attributes in the group.
     *
     * Attributes maybe an empty JSON '{}', but must be explicitly stated.
     *
     * @experimental
     */
    readonly attributes: {
        [key: string]: any;
    };
}
declare abstract class AttributeGroupBase extends cdk.Resource implements IAttributeGroup {
    abstract readonly attributeGroupArn: string;
    abstract readonly attributeGroupId: string;
}
/**
 * (experimental) A Service Catalog AppRegistry Attribute Group.
 *
 * @experimental
 */
export declare class AttributeGroup extends AttributeGroupBase implements IAttributeGroup {
    /**
     * (experimental) Imports an attribute group construct that represents an external attribute group.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attributeGroupArn the Amazon Resource Name of the existing AppRegistry attribute group.
     * @experimental
     */
    static fromAttributeGroupArn(scope: Construct, id: string, attributeGroupArn: string): IAttributeGroup;
    /**
     * (experimental) The ARN of the attribute group.
     *
     * @experimental
     */
    readonly attributeGroupArn: string;
    /**
     * (experimental) The ID of the attribute group.
     *
     * @experimental
     */
    readonly attributeGroupId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: AttributeGroupProps);
    private validateAttributeGroupProps;
}
export {};
