# mypy-boto3-codedeploy

[![PyPI - mypy-boto3-codedeploy](https://img.shields.io/pypi/v/mypy-boto3-codedeploy.svg?color=blue)](https://pypi.org/project/mypy-boto3-codedeploy)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codedeploy.svg?color=blue)](https://pypi.org/project/mypy-boto3-codedeploy)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.CodeDeploy 1.16.1](https://boto3.amazonaws.com/v1/documentation/api/1.16.1/reference/services/codedeploy.html#CodeDeploy) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-codedeploy](#mypy-boto3-codedeploy)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CodeDeploy` service.

```bash
python -m pip install boto3-stubs[codedeploy]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[codedeploy]` in your environment: `python -m pip install 'boto3-stubs[codedeploy]'`

Both type checking and auto-complete should work for `CodeDeploy` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[codedeploy]` in your environment: `python -m pip install 'boto3-stubs[codedeploy]'`

Both type checking and auto-complete should work for `CodeDeploy` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[codedeploy]` in your environment: `python -m pip install 'boto3-stubs[codedeploy]'`
- Run `mypy` as usual

Type checking should work for `CodeDeploy` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[codedeploy]` in your environment: `python -m pip install 'boto3-stubs[codedeploy]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CodeDeploy` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CodeDeployClient` provides annotations for `boto3.client("codedeploy")`.

```python
import boto3

from mypy_boto3_codedeploy import CodeDeployClient

client: CodeDeployClient = boto3.client("codedeploy")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeDeployClient = session.client("codedeploy")
```

### Paginators annotations

`mypy_boto3_codedeploy.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_codedeploy import CodeDeployClient
from mypy_boto3_codedeploy.paginator import (
    ListApplicationRevisionsPaginator,
    ListApplicationsPaginator,
    ListDeploymentConfigsPaginator,
    ListDeploymentGroupsPaginator,
    ListDeploymentInstancesPaginator,
    ListDeploymentsPaginator,
    ListDeploymentTargetsPaginator,
    ListGitHubAccountTokenNamesPaginator,
    ListOnPremisesInstancesPaginator,
)

client: CodeDeployClient = boto3.client("codedeploy")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_application_revisions_paginator: ListApplicationRevisionsPaginator = client.get_paginator("list_application_revisions")
list_applications_paginator: ListApplicationsPaginator = client.get_paginator("list_applications")
list_deployment_configs_paginator: ListDeploymentConfigsPaginator = client.get_paginator("list_deployment_configs")
list_deployment_groups_paginator: ListDeploymentGroupsPaginator = client.get_paginator("list_deployment_groups")
list_deployment_instances_paginator: ListDeploymentInstancesPaginator = client.get_paginator("list_deployment_instances")
list_deployment_targets_paginator: ListDeploymentTargetsPaginator = client.get_paginator("list_deployment_targets")
list_deployments_paginator: ListDeploymentsPaginator = client.get_paginator("list_deployments")
list_git_hub_account_token_names_paginator: ListGitHubAccountTokenNamesPaginator = client.get_paginator("list_git_hub_account_token_names")
list_on_premises_instances_paginator: ListOnPremisesInstancesPaginator = client.get_paginator("list_on_premises_instances")
```


### Waiters annotations

`mypy_boto3_codedeploy.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_codedeploy import CodeDeployClient
from mypy_boto3_codedeploy.waiter import DeploymentSuccessfulWaiter

client: CodeDeployClient = boto3.client("codedeploy")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
deployment_successful_waiter: DeploymentSuccessfulWaiter = client.get_waiter("deployment_successful")
```





### Typed dictionations

`mypy_boto3_codedeploy.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_codedeploy.type_defs import (
    AlarmConfigurationTypeDef,
    AlarmTypeDef,
    ApplicationInfoTypeDef,
    AppSpecContentTypeDef,
    AutoRollbackConfigurationTypeDef,
    AutoScalingGroupTypeDef,
    BatchGetApplicationRevisionsOutputTypeDef,
    BatchGetApplicationsOutputTypeDef,
    BatchGetDeploymentGroupsOutputTypeDef,
    BatchGetDeploymentInstancesOutputTypeDef,
    BatchGetDeploymentsOutputTypeDef,
    BatchGetDeploymentTargetsOutputTypeDef,
    BatchGetOnPremisesInstancesOutputTypeDef,
    BlueGreenDeploymentConfigurationTypeDef,
    BlueInstanceTerminationOptionTypeDef,
    CloudFormationTargetTypeDef,
    CreateApplicationOutputTypeDef,
    CreateDeploymentConfigOutputTypeDef,
    CreateDeploymentGroupOutputTypeDef,
    CreateDeploymentOutputTypeDef,
    DeleteDeploymentGroupOutputTypeDef,
    DeleteGitHubAccountTokenOutputTypeDef,
    DeploymentConfigInfoTypeDef,
    DeploymentGroupInfoTypeDef,
    DeploymentInfoTypeDef,
    DeploymentOverviewTypeDef,
    DeploymentReadyOptionTypeDef,
    DeploymentStyleTypeDef,
    DeploymentTargetTypeDef,
    DiagnosticsTypeDef,
    EC2TagFilterTypeDef,
    EC2TagSetTypeDef,
    ECSServiceTypeDef,
    ECSTargetTypeDef,
    ECSTaskSetTypeDef,
    ELBInfoTypeDef,
    ErrorInformationTypeDef,
    GenericRevisionInfoTypeDef,
    GetApplicationOutputTypeDef,
    GetApplicationRevisionOutputTypeDef,
    GetDeploymentConfigOutputTypeDef,
    GetDeploymentGroupOutputTypeDef,
    GetDeploymentInstanceOutputTypeDef,
    GetDeploymentOutputTypeDef,
    GetDeploymentTargetOutputTypeDef,
    GetOnPremisesInstanceOutputTypeDef,
    GitHubLocationTypeDef,
    GreenFleetProvisioningOptionTypeDef,
    InstanceInfoTypeDef,
    InstanceSummaryTypeDef,
    InstanceTargetTypeDef,
    LambdaFunctionInfoTypeDef,
    LambdaTargetTypeDef,
    LastDeploymentInfoTypeDef,
    LifecycleEventTypeDef,
    ListApplicationRevisionsOutputTypeDef,
    ListApplicationsOutputTypeDef,
    ListDeploymentConfigsOutputTypeDef,
    ListDeploymentGroupsOutputTypeDef,
    ListDeploymentInstancesOutputTypeDef,
    ListDeploymentsOutputTypeDef,
    ListDeploymentTargetsOutputTypeDef,
    ListGitHubAccountTokenNamesOutputTypeDef,
    ListOnPremisesInstancesOutputTypeDef,
    ListTagsForResourceOutputTypeDef,
    LoadBalancerInfoTypeDef,
    MinimumHealthyHostsTypeDef,
    OnPremisesTagSetTypeDef,
    PaginatorConfigTypeDef,
    PutLifecycleEventHookExecutionStatusOutputTypeDef,
    RawStringTypeDef,
    ResponseMetadata,
    RevisionInfoTypeDef,
    RevisionLocationTypeDef,
    RollbackInfoTypeDef,
    S3LocationTypeDef,
    StopDeploymentOutputTypeDef,
    TagFilterTypeDef,
    TagTypeDef,
    TargetGroupInfoTypeDef,
    TargetGroupPairInfoTypeDef,
    TargetInstancesTypeDef,
    TimeBasedCanaryTypeDef,
    TimeBasedLinearTypeDef,
    TimeRangeTypeDef,
    TrafficRouteTypeDef,
    TrafficRoutingConfigTypeDef,
    TriggerConfigTypeDef,
    UpdateDeploymentGroupOutputTypeDef,
    WaiterConfigTypeDef,
)

def get_structure() -> AlarmConfigurationTypeDef:
    return {
      ...
    }
```
