/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.1.1
 *
 *     
 */

#include "sipAPI_core.h"

        #include <wx/platinfo.h>

        #include <wx/platinfo.h>


PyDoc_STRVAR(doc_wxPlatformInfo_GetBitness, "GetBitness() -> Bitness\n"
"\n"
"Returns the architecture bitness ID of this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetBitness(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetBitness(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxBitness sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetBitness();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxBitness);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetBitness, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetArch, "GetArch(arch) -> Architecture");

extern "C" {static PyObject *meth_wxPlatformInfo_GetArch(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetArch(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* arch;
        int archState = 0;

        static const char *sipKwdList[] = {
            sipName_arch,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &arch, &archState))
        {
             ::wxArchitecture sipRes;

            if (sipDeprecated(sipName_PlatformInformation,sipName_GetArch) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxPlatformInfo::GetArch(*arch);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(arch), sipType_wxString, archState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxArchitecture);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetArch, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetEndianness, "GetEndianness() -> Endianness\n"
"\n"
"Returns the endianness ID of this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetEndianness(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetEndianness(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxEndianness sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEndianness();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxEndianness);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetEndianness, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOperatingSystemId, "GetOperatingSystemId() -> OperatingSystemId\n"
"\n"
"Returns the operating system ID of this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOperatingSystemId(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOperatingSystemId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxOperatingSystemId sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOperatingSystemId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxOperatingSystemId);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOperatingSystemId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetPortId, "GetPortId() -> PortId\n"
"\n"
"Returns the wxWidgets port ID associated with this wxPlatformInfo\n"
"instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetPortId(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetPortId(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxPortId sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPortId();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxPortId);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetPortId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetArchName, "GetArchName() -> String");

extern "C" {static PyObject *meth_wxPlatformInfo_GetArchName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetArchName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            if (sipDeprecated(sipName_PlatformInformation,sipName_GetArchName) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetArchName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetArchName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetBitnessName, "GetBitnessName(bitness) -> String\n"
"GetBitnessName() -> String\n"
"\n"
"Returns the name for the given wxBitness enumeration value.\n"
"");

extern "C" {static PyObject *meth_wxPlatformInfo_GetBitnessName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetBitnessName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxBitness bitness;

        static const char *sipKwdList[] = {
            sipName_bitness,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "E", sipType_wxBitness, &bitness))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxPlatformInfo::GetBitnessName(bitness));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, SIP_NULLPTR, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetBitnessName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetBitnessName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetEndiannessName, "GetEndiannessName() -> String\n"
"\n"
"Returns the name for the endianness of this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetEndiannessName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetEndiannessName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetEndiannessName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetEndiannessName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOperatingSystemFamilyName, "GetOperatingSystemFamilyName() -> String\n"
"\n"
"Returns the operating system family name of the OS associated with\n"
"this wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOperatingSystemFamilyName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOperatingSystemFamilyName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetOperatingSystemFamilyName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOperatingSystemFamilyName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOperatingSystemIdName, "GetOperatingSystemIdName() -> String\n"
"\n"
"Returns the operating system name of the OS associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOperatingSystemIdName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOperatingSystemIdName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetOperatingSystemIdName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOperatingSystemIdName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetPortIdName, "GetPortIdName() -> String\n"
"\n"
"Returns the name of the wxWidgets port ID associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetPortIdName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetPortIdName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPortIdName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetPortIdName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetPortIdShortName, "GetPortIdShortName() -> String\n"
"\n"
"Returns the short name of the wxWidgets port ID associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetPortIdShortName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetPortIdShortName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetPortIdShortName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetPortIdShortName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOperatingSystemDirectory, "GetOperatingSystemDirectory() -> String\n"
"\n"
"Returns the operating system directory.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOperatingSystemDirectory(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOperatingSystemDirectory(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxPlatformInfo::GetOperatingSystemDirectory());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOperatingSystemDirectory, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetArchitecture, "GetArchitecture() -> Architecture");

extern "C" {static PyObject *meth_wxPlatformInfo_GetArchitecture(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetArchitecture(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxArchitecture sipRes;

            if (sipDeprecated(sipName_PlatformInformation,sipName_GetArchitecture) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetArchitecture();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxArchitecture);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetArchitecture, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetCpuArchitectureName, "GetCpuArchitectureName() -> String\n"
"\n"
"Returns the CPU architecture name, if available.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetCpuArchitectureName(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetCpuArchitectureName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetCpuArchitectureName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetCpuArchitectureName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOSMajorVersion, "GetOSMajorVersion() -> int\n"
"\n"
"Returns the run-time major version of the OS associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOSMajorVersion(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOSMajorVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOSMajorVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOSMajorVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOSMinorVersion, "GetOSMinorVersion() -> int\n"
"\n"
"Returns the run-time minor version of the OS associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOSMinorVersion(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOSMinorVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOSMinorVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOSMinorVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOSMicroVersion, "GetOSMicroVersion() -> int\n"
"\n"
"Returns the run-time micro version of the OS associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOSMicroVersion(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOSMicroVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetOSMicroVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOSMicroVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetOperatingSystemDescription, "GetOperatingSystemDescription() -> String\n"
"\n"
"Returns the description of the operating system of this wxPlatformInfo\n"
"instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetOperatingSystemDescription(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetOperatingSystemDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetOperatingSystemDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetOperatingSystemDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetLinuxDistributionInfo, "GetLinuxDistributionInfo() -> LinuxDistributionInfo\n"
"\n"
"Returns the Linux distribution info associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetLinuxDistributionInfo(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetLinuxDistributionInfo(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxLinuxDistributionInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxLinuxDistributionInfo(sipCpp->GetLinuxDistributionInfo());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxLinuxDistributionInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetLinuxDistributionInfo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetDesktopEnvironment, "GetDesktopEnvironment() -> String\n"
"\n"
"Returns the desktop environment associated with this wxPlatformInfo\n"
"instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetDesktopEnvironment(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetDesktopEnvironment(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString(sipCpp->GetDesktopEnvironment());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetDesktopEnvironment, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetToolkitMajorVersion, "GetToolkitMajorVersion() -> int\n"
"\n"
"Returns the run-time major version of the toolkit associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetToolkitMajorVersion(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetToolkitMajorVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetToolkitMajorVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetToolkitMajorVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetToolkitMinorVersion, "GetToolkitMinorVersion() -> int\n"
"\n"
"Returns the run-time minor version of the toolkit associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetToolkitMinorVersion(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetToolkitMinorVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetToolkitMinorVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetToolkitMinorVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_GetToolkitMicroVersion, "GetToolkitMicroVersion() -> int\n"
"\n"
"Returns the run-time micro version of the toolkit associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_GetToolkitMicroVersion(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_GetToolkitMicroVersion(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetToolkitMicroVersion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_GetToolkitMicroVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetArchitecture, "SetArchitecture(n)");

extern "C" {static PyObject *meth_wxPlatformInfo_SetArchitecture(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetArchitecture(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxArchitecture n;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxArchitecture, &n))
        {
            if (sipDeprecated(sipName_PlatformInformation,sipName_SetArchitecture) < 0)
                return SIP_NULLPTR;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetArchitecture(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetArchitecture, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetBitness, "SetBitness(n)\n"
"\n"
"Sets the architecture bitness enum value associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetBitness(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetBitness(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxBitness n;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxBitness, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetBitness(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetBitness, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetEndianness, "SetEndianness(n)\n"
"\n"
"Sets the endianness enum value associated with this wxPlatformInfo\n"
"instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetEndianness(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetEndianness(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxEndianness n;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxEndianness, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEndianness(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetEndianness, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetOSVersion, "SetOSVersion(major, minor, micro=0)\n"
"\n"
"Sets the version of the operating system associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetOSVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetOSVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int major;
        int minor;
        int micro = 0;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_major,
            sipName_minor,
            sipName_micro,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii|i", &sipSelf, sipType_wxPlatformInfo, &sipCpp, &major, &minor, &micro))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOSVersion(major,minor,micro);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetOSVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetOperatingSystemId, "SetOperatingSystemId(n)\n"
"\n"
"Sets the operating system associated with this wxPlatformInfo\n"
"instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetOperatingSystemId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetOperatingSystemId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxOperatingSystemId n;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxOperatingSystemId, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOperatingSystemId(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetOperatingSystemId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetPortId, "SetPortId(n)\n"
"\n"
"Sets the wxWidgets port ID associated with this wxPlatformInfo\n"
"instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetPortId(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetPortId(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxPortId n;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_n,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxPortId, &n))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPortId(n);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetPortId, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetToolkitVersion, "SetToolkitVersion(major, minor, micro=0)\n"
"\n"
"Sets the version of the toolkit associated with this wxPlatformInfo\n"
"instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetToolkitVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetToolkitVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int major;
        int minor;
        int micro = 0;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_major,
            sipName_minor,
            sipName_micro,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii|i", &sipSelf, sipType_wxPlatformInfo, &sipCpp, &major, &minor, &micro))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetToolkitVersion(major,minor,micro);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetToolkitVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetOperatingSystemDescription, "SetOperatingSystemDescription(desc)\n"
"\n"
"Sets the operating system description associated with this\n"
"wxPlatformInfo instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetOperatingSystemDescription(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetOperatingSystemDescription(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* desc;
        int descState = 0;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_desc,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxString, &desc, &descState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetOperatingSystemDescription(*desc);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(desc), sipType_wxString, descState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetOperatingSystemDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetDesktopEnvironment, "SetDesktopEnvironment(de)\n"
"\n"
"Sets the desktop environment associated with this wxPlatformInfo\n"
"instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetDesktopEnvironment(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetDesktopEnvironment(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* de;
        int deState = 0;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_de,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxString, &de, &deState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDesktopEnvironment(*de);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(de), sipType_wxString, deState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetDesktopEnvironment, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_SetLinuxDistributionInfo, "SetLinuxDistributionInfo(di)\n"
"\n"
"Sets the linux distribution info associated with this wxPlatformInfo\n"
"instance.");

extern "C" {static PyObject *meth_wxPlatformInfo_SetLinuxDistributionInfo(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_SetLinuxDistributionInfo(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxLinuxDistributionInfo* di;
         ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_di,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxPlatformInfo, &sipCpp, sipType_wxLinuxDistributionInfo, &di))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetLinuxDistributionInfo(*di);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_SetLinuxDistributionInfo, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_CheckOSVersion, "CheckOSVersion(major, minor, micro=0) -> bool\n"
"\n"
"Returns true if the OS version is at least major.minor.micro.");

extern "C" {static PyObject *meth_wxPlatformInfo_CheckOSVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_CheckOSVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int major;
        int minor;
        int micro = 0;
        const  ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_major,
            sipName_minor,
            sipName_micro,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii|i", &sipSelf, sipType_wxPlatformInfo, &sipCpp, &major, &minor, &micro))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CheckOSVersion(major,minor,micro);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_CheckOSVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_CheckToolkitVersion, "CheckToolkitVersion(major, minor, micro=0) -> bool\n"
"\n"
"Returns true if the toolkit version is at least major.minor.micro.");

extern "C" {static PyObject *meth_wxPlatformInfo_CheckToolkitVersion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_CheckToolkitVersion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int major;
        int minor;
        int micro = 0;
        const  ::wxPlatformInfo *sipCpp;

        static const char *sipKwdList[] = {
            sipName_major,
            sipName_minor,
            sipName_micro,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii|i", &sipSelf, sipType_wxPlatformInfo, &sipCpp, &major, &minor, &micro))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CheckToolkitVersion(major,minor,micro);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_CheckToolkitVersion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_IsOk, "IsOk() -> bool\n"
"\n"
"Returns true if this instance is fully initialized with valid values.");

extern "C" {static PyObject *meth_wxPlatformInfo_IsOk(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_IsOk(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsOk();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_IsOk, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_IsUsingUniversalWidgets, "IsUsingUniversalWidgets() -> bool\n"
"\n"
"Returns true if this wxPlatformInfo describes wxUniversal build.");

extern "C" {static PyObject *meth_wxPlatformInfo_IsUsingUniversalWidgets(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_IsUsingUniversalWidgets(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPlatformInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsUsingUniversalWidgets();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_IsUsingUniversalWidgets, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPlatformInfo_Get, "Get() -> PlatformInfo\n"
"\n"
"Returns the global wxPlatformInfo object, initialized with the values\n"
"for the currently running platform.");

extern "C" {static PyObject *meth_wxPlatformInfo_Get(PyObject *, PyObject *);}
static PyObject *meth_wxPlatformInfo_Get(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
             ::wxPlatformInfo*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPlatformInfo( ::wxPlatformInfo::Get());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPlatformInfo,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PlatformInformation, sipName_Get, SIP_NULLPTR);

    return SIP_NULLPTR;
}


extern "C" {static PyObject *slot_wxPlatformInfo___eq__(PyObject *,PyObject *);}
static PyObject *slot_wxPlatformInfo___eq__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxPlatformInfo *sipCpp = reinterpret_cast< ::wxPlatformInfo *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxPlatformInfo));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo* t;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxPlatformInfo, &t))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxPlatformInfo::operator==(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, eq_slot, sipType_wxPlatformInfo, sipSelf, sipArg);
}


extern "C" {static PyObject *slot_wxPlatformInfo___ne__(PyObject *,PyObject *);}
static PyObject *slot_wxPlatformInfo___ne__(PyObject *sipSelf,PyObject *sipArg)
{
     ::wxPlatformInfo *sipCpp = reinterpret_cast< ::wxPlatformInfo *>(sipGetCppPtr((sipSimpleWrapper *)sipSelf,sipType_wxPlatformInfo));

    if (!sipCpp)
        return SIP_NULLPTR;

    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxPlatformInfo* t;

        if (sipParseArgs(&sipParseErr, sipArg, "1J9", sipType_wxPlatformInfo, &t))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp-> ::wxPlatformInfo::operator!=(*t);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    Py_XDECREF(sipParseErr);

    if (sipParseErr == Py_None)
        return SIP_NULLPTR;

    return sipPySlotExtend(&sipModuleAPI__core, ne_slot, sipType_wxPlatformInfo, sipSelf, sipArg);
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPlatformInfo(void *, int);}
static void release_wxPlatformInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxPlatformInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxPlatformInfo(Py_ssize_t);}
static void *array_wxPlatformInfo(Py_ssize_t sipNrElem)
{
    return new  ::wxPlatformInfo[sipNrElem];
}


extern "C" {static void assign_wxPlatformInfo(void *, Py_ssize_t, void *);}
static void assign_wxPlatformInfo(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxPlatformInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxPlatformInfo *>(sipSrc);
}


extern "C" {static void *copy_wxPlatformInfo(const void *, Py_ssize_t);}
static void *copy_wxPlatformInfo(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxPlatformInfo(reinterpret_cast<const  ::wxPlatformInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxPlatformInfo(sipSimpleWrapper *);}
static void dealloc_wxPlatformInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPlatformInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxPlatformInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxPlatformInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxPlatformInfo *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPlatformInfo();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
         ::wxPortId pid;
        int tkMajor = -1;
        int tkMinor = -1;
         ::wxOperatingSystemId id = wxOS_UNKNOWN;
        int osMajor = -1;
        int osMinor = -1;
         ::wxBitness bitness = wxBITNESS_INVALID;
         ::wxEndianness endian = wxENDIAN_INVALID;

        static const char *sipKwdList[] = {
            sipName_pid,
            sipName_tkMajor,
            sipName_tkMinor,
            sipName_id,
            sipName_osMajor,
            sipName_osMinor,
            sipName_bitness,
            sipName_endian,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "E|iiEiiEE", sipType_wxPortId, &pid, &tkMajor, &tkMinor, sipType_wxOperatingSystemId, &id, &osMajor, &osMinor, sipType_wxBitness, &bitness, sipType_wxEndianness, &endian))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPlatformInfo(pid,tkMajor,tkMinor,id,osMajor,osMinor,bitness,endian);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxPlatformInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxPlatformInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxPlatformInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's Python slots. */
static sipPySlotDef slots_wxPlatformInfo[] = {
    {(void *)slot_wxPlatformInfo___eq__, eq_slot},
    {(void *)slot_wxPlatformInfo___ne__, ne_slot},
    {0, (sipPySlotType)0}
};


static PyMethodDef methods_wxPlatformInfo[] = {
    {sipName_CheckOSVersion, SIP_MLMETH_CAST(meth_wxPlatformInfo_CheckOSVersion), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_CheckOSVersion},
    {sipName_CheckToolkitVersion, SIP_MLMETH_CAST(meth_wxPlatformInfo_CheckToolkitVersion), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_CheckToolkitVersion},
    {sipName_Get, meth_wxPlatformInfo_Get, METH_VARARGS, doc_wxPlatformInfo_Get},
    {sipName_GetArch, SIP_MLMETH_CAST(meth_wxPlatformInfo_GetArch), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_GetArch},
    {sipName_GetArchName, meth_wxPlatformInfo_GetArchName, METH_VARARGS, doc_wxPlatformInfo_GetArchName},
    {sipName_GetArchitecture, meth_wxPlatformInfo_GetArchitecture, METH_VARARGS, doc_wxPlatformInfo_GetArchitecture},
    {sipName_GetBitness, meth_wxPlatformInfo_GetBitness, METH_VARARGS, doc_wxPlatformInfo_GetBitness},
    {sipName_GetBitnessName, SIP_MLMETH_CAST(meth_wxPlatformInfo_GetBitnessName), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_GetBitnessName},
    {sipName_GetCpuArchitectureName, meth_wxPlatformInfo_GetCpuArchitectureName, METH_VARARGS, doc_wxPlatformInfo_GetCpuArchitectureName},
    {sipName_GetDesktopEnvironment, meth_wxPlatformInfo_GetDesktopEnvironment, METH_VARARGS, doc_wxPlatformInfo_GetDesktopEnvironment},
    {sipName_GetEndianness, meth_wxPlatformInfo_GetEndianness, METH_VARARGS, doc_wxPlatformInfo_GetEndianness},
    {sipName_GetEndiannessName, meth_wxPlatformInfo_GetEndiannessName, METH_VARARGS, doc_wxPlatformInfo_GetEndiannessName},
    {sipName_GetLinuxDistributionInfo, meth_wxPlatformInfo_GetLinuxDistributionInfo, METH_VARARGS, doc_wxPlatformInfo_GetLinuxDistributionInfo},
    {sipName_GetOSMajorVersion, meth_wxPlatformInfo_GetOSMajorVersion, METH_VARARGS, doc_wxPlatformInfo_GetOSMajorVersion},
    {sipName_GetOSMicroVersion, meth_wxPlatformInfo_GetOSMicroVersion, METH_VARARGS, doc_wxPlatformInfo_GetOSMicroVersion},
    {sipName_GetOSMinorVersion, meth_wxPlatformInfo_GetOSMinorVersion, METH_VARARGS, doc_wxPlatformInfo_GetOSMinorVersion},
    {sipName_GetOperatingSystemDescription, meth_wxPlatformInfo_GetOperatingSystemDescription, METH_VARARGS, doc_wxPlatformInfo_GetOperatingSystemDescription},
    {sipName_GetOperatingSystemDirectory, meth_wxPlatformInfo_GetOperatingSystemDirectory, METH_VARARGS, doc_wxPlatformInfo_GetOperatingSystemDirectory},
    {sipName_GetOperatingSystemFamilyName, meth_wxPlatformInfo_GetOperatingSystemFamilyName, METH_VARARGS, doc_wxPlatformInfo_GetOperatingSystemFamilyName},
    {sipName_GetOperatingSystemId, meth_wxPlatformInfo_GetOperatingSystemId, METH_VARARGS, doc_wxPlatformInfo_GetOperatingSystemId},
    {sipName_GetOperatingSystemIdName, meth_wxPlatformInfo_GetOperatingSystemIdName, METH_VARARGS, doc_wxPlatformInfo_GetOperatingSystemIdName},
    {sipName_GetPortId, meth_wxPlatformInfo_GetPortId, METH_VARARGS, doc_wxPlatformInfo_GetPortId},
    {sipName_GetPortIdName, meth_wxPlatformInfo_GetPortIdName, METH_VARARGS, doc_wxPlatformInfo_GetPortIdName},
    {sipName_GetPortIdShortName, meth_wxPlatformInfo_GetPortIdShortName, METH_VARARGS, doc_wxPlatformInfo_GetPortIdShortName},
    {sipName_GetToolkitMajorVersion, meth_wxPlatformInfo_GetToolkitMajorVersion, METH_VARARGS, doc_wxPlatformInfo_GetToolkitMajorVersion},
    {sipName_GetToolkitMicroVersion, meth_wxPlatformInfo_GetToolkitMicroVersion, METH_VARARGS, doc_wxPlatformInfo_GetToolkitMicroVersion},
    {sipName_GetToolkitMinorVersion, meth_wxPlatformInfo_GetToolkitMinorVersion, METH_VARARGS, doc_wxPlatformInfo_GetToolkitMinorVersion},
    {sipName_IsOk, meth_wxPlatformInfo_IsOk, METH_VARARGS, doc_wxPlatformInfo_IsOk},
    {sipName_IsUsingUniversalWidgets, meth_wxPlatformInfo_IsUsingUniversalWidgets, METH_VARARGS, doc_wxPlatformInfo_IsUsingUniversalWidgets},
    {sipName_SetArchitecture, SIP_MLMETH_CAST(meth_wxPlatformInfo_SetArchitecture), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_SetArchitecture},
    {sipName_SetBitness, SIP_MLMETH_CAST(meth_wxPlatformInfo_SetBitness), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_SetBitness},
    {sipName_SetDesktopEnvironment, SIP_MLMETH_CAST(meth_wxPlatformInfo_SetDesktopEnvironment), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_SetDesktopEnvironment},
    {sipName_SetEndianness, SIP_MLMETH_CAST(meth_wxPlatformInfo_SetEndianness), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_SetEndianness},
    {sipName_SetLinuxDistributionInfo, SIP_MLMETH_CAST(meth_wxPlatformInfo_SetLinuxDistributionInfo), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_SetLinuxDistributionInfo},
    {sipName_SetOSVersion, SIP_MLMETH_CAST(meth_wxPlatformInfo_SetOSVersion), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_SetOSVersion},
    {sipName_SetOperatingSystemDescription, SIP_MLMETH_CAST(meth_wxPlatformInfo_SetOperatingSystemDescription), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_SetOperatingSystemDescription},
    {sipName_SetOperatingSystemId, SIP_MLMETH_CAST(meth_wxPlatformInfo_SetOperatingSystemId), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_SetOperatingSystemId},
    {sipName_SetPortId, SIP_MLMETH_CAST(meth_wxPlatformInfo_SetPortId), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_SetPortId},
    {sipName_SetToolkitVersion, SIP_MLMETH_CAST(meth_wxPlatformInfo_SetToolkitVersion), METH_VARARGS|METH_KEYWORDS, doc_wxPlatformInfo_SetToolkitVersion}
};

sipVariableDef variables_wxPlatformInfo[] = {
    {PropertyVariable, sipName_ToolkitMinorVersion, &methods_wxPlatformInfo[26], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ToolkitMicroVersion, &methods_wxPlatformInfo[25], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ToolkitMajorVersion, &methods_wxPlatformInfo[24], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PortIdShortName, &methods_wxPlatformInfo[23], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PortIdName, &methods_wxPlatformInfo[22], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_PortId, &methods_wxPlatformInfo[21], &methods_wxPlatformInfo[37], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OperatingSystemIdName, &methods_wxPlatformInfo[20], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OperatingSystemId, &methods_wxPlatformInfo[19], &methods_wxPlatformInfo[36], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OperatingSystemFamilyName, &methods_wxPlatformInfo[18], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OperatingSystemDescription, &methods_wxPlatformInfo[16], &methods_wxPlatformInfo[35], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OSMinorVersion, &methods_wxPlatformInfo[15], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OSMicroVersion, &methods_wxPlatformInfo[14], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_OSMajorVersion, &methods_wxPlatformInfo[13], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_LinuxDistributionInfo, &methods_wxPlatformInfo[12], &methods_wxPlatformInfo[33], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_EndiannessName, &methods_wxPlatformInfo[11], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Endianness, &methods_wxPlatformInfo[10], &methods_wxPlatformInfo[32], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_DesktopEnvironment, &methods_wxPlatformInfo[9], &methods_wxPlatformInfo[31], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_CpuArchitectureName, &methods_wxPlatformInfo[8], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_BitnessName, &methods_wxPlatformInfo[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Bitness, &methods_wxPlatformInfo[6], &methods_wxPlatformInfo[30], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Architecture, &methods_wxPlatformInfo[5], &methods_wxPlatformInfo[29], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_ArchName, &methods_wxPlatformInfo[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxPlatformInfo, "PlatformInfo()\n"
"PlatformInfo(pid, tkMajor=-1, tkMinor=-1, id=OS_UNKNOWN, osMajor=-1, osMinor=-1, bitness=BITNESS_INVALID, endian=ENDIAN_INVALID)\n"
"\n"
"This class holds information about the operating system, the toolkit\n"
"and the basic architecture bitness of the machine where the\n"
"application is currently running.");


sipClassTypeDef sipTypeDef__core_wxPlatformInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxPlatformInfo,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_PlatformInformation,
        {0, 0, 1},
        39, methods_wxPlatformInfo,
        0, SIP_NULLPTR,
        22, variables_wxPlatformInfo,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxPlatformInfo,
    -1,
    -1,
    SIP_NULLPTR,
    slots_wxPlatformInfo,
    init_type_wxPlatformInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxPlatformInfo,
    assign_wxPlatformInfo,
    array_wxPlatformInfo,
    copy_wxPlatformInfo,
    release_wxPlatformInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
