#pragma once
/**********************************************
 **************** Compression ***************** 
 **********************************************/
#pragma region Compressor functions
/**
* \ingroup NotExposedCompressor  Fonctions et variables lies  la compression
* @{
*/
//Compressor variables
static int zero_blocks; /**< Nombre de zero_block conscutifs*/
static int newbits;
static unsigned long packed_bits; 
static unsigned long global_packed_bits;
static unsigned long packed_value;
static unsigned long global_packed_value;
static unsigned char *global_bptr;
static unsigned char *bptr;
static int nbBlock;

void initCompressor();
/**
 * \brief encodage de un ou plusieurs blocs "zero_bloc"
 * \param maxOrEnd La valeur 'true' indique que l'encodage est dclench en raison d'un nombre important de blocs (#MAX_ZERO_BLOCKS) ou de la fin de l'encoding
 */
void encodeZeroBlock(bool maxOrEnd);
/**
 * \brief encodage du MSB selon le principe des squences fondamentales
 * \param data Borne infrieur du bloc  encoder
 * \param end Borne suprieure (exclue) du bloc  encoder
 * \param lsbSize 
 */
void encodeMSB(unsigned int* data,unsigned int* end,int lsbSize);
/**
 * \brief encodage du LSB, cas Ksplit inclus dans [1,5]
 * \param data Borne infrieur du bloc  encoder
 * \param end Borne suprieure (exclue) du bloc  encoder
 * \param lsbSize 
 */
void encodeLSB(unsigned int* data,unsigned int* end,int lsbSize);
/**
 * \brief encodage du LSB, cas Ksplit inclus dans [6,8]
 * \param data Borne infrieur du bloc  encoder
 * \param end Borne suprieure (exclue) du bloc  encoder
 * \param lsbSize 
 */
void encodeLSBHO(unsigned int* data,unsigned int* end,int lsbSize);
/**
 * \brief Encodage du bloc de rfrence. Appele une seule fois pour le premier bloc
 * \param data Borne infrieur du bloc  encoder
 * \param end Borne suprieure (exclue) du bloc  encoder
 */
void encodeReferenceBlock(unsigned int* data,unsigned int* end);
/**
 * \brief Encodage d'un bloc quelconque.
 * \param data Borne infrieur du bloc  encoder
 * \param end Borne suprieure (exclue) du bloc  encoder
 * \param blockNro Indice du bloc ( partir de 1)
 */
void encodeNormalBlock(unsigned int* data, unsigned int* end,int blockNro);
/**
 * /brief vidage du tampon  la fin de la compression
 */
static void flush();  
/**
 * \brief recherche l'encodeur le plus performant pour un bloc de donnes
 * \param sigma Borne infrieur du bloc  analyser 
 * \param end Borne suprieure (exclue) du bloc  analyser
 * \return rfrence de l'encodeur choisi (ID_ZERO, ID_LOW, ID_FS, ID_Kn)
 */
static int find_winner16(unsigned int *sigma, unsigned int *end);
/**
 * \brief recherche l'encodeur le plus performant pour le bloc de donnes de rfrence
 * \param sigma Borne infrieur du bloc  analyser 
 * \param end Borne suprieure (exclue) du bloc  analyser
 * \return rfrence de l'encodeur choisi (ID_ZERO, ID_LOW, ID_FS, ID_Kn)
 */
static int find_ref_winner16(unsigned int *sigma, unsigned int *end);
/**
 * \brief Calcul le nombre de bits ncessaires pour un encodage tendu (ID_LOW)
 * \param sigma Borne infrieur du bloc  analyser 
 * \param end Borne suprieure (exclue) du bloc  analyser
 * \return 
 */
static unsigned int c_ext2(unsigned int* sigma, unsigned int* end);
/**@}*/ // End of group Compressor
#pragma endregion

/**********************************************
 **************** Decompression ****************
 **********************************************/
#pragma region Uncompressor functions
/**
* \ingroup NotExposedUncompressor 
* @{
*/
//Uncompressor variables
static int data_bits;
static unsigned int data_word;
static unsigned char *input_ptr;
#ifdef  GAUSS
static unsigned char *input_ptr_end;
#endif
static int leading_zeros[256];
void initUncompressor();
/**
* \brief fonction comptant le nombre de 0 conscutifs
* Cette fonction est utilise pour dcoder les encodages FS
* \return le nombre de 0 trouvs	
*/
/**
 * \brief Decodage d'une squence fondamentale
 * \return Valeur dcode
 */
int decodeFS();
/**
 * \brief dcodage de un ou plusieurs bloc de type 'Zero_Bloc'
 * \return Nombre de bloc de ce type dcods
 */
int decodeZeroBlock();
/**
 * \brief dcodage du bloc de rfrence (la fonction n'est appele qu'un fois en dbut de dcompression)
 * \param data Borne infrieur du bloc destination  dcoder
 * \param end Borne suprieure (exclue) du bloc destination  dcoder
 * \return Nombre de bloc dcods (1 dans le cas gnral, plus dans le cas o le bloc de rfrence est de type 'Zero_Bloc')
 */
int decodeReferenceBlock(unsigned int* data,unsigned int* end);
/**
 * \brief dcodage d'un bloc normal
 * \param data Borne infrieur du bloc destination  dcoder
 * \param end Borne suprieure (exclue) du bloc destination  dcoder
 * \param alreadyDecodedBlock Nombre de bloc dj dcods
 * \return Nombre de nouveaux bloc s dcods
 */
int decodeNormalBlock(unsigned int* data,unsigned int* end, int alreadyDecodedBlock);
/**
 * /brief Rempli le buffer de travail avec la suite des donnes  dcoder
 */
static void fillDataBuffer();
/**@}*/ // End of group Uncompressor
#pragma endregion




