/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk.internal;

import com.amazonaws.services.sagemaker.sparksdk.S3DataPath;
import com.amazonaws.services.sagemaker.sparksdk.internal.DataUploadResult;
import com.amazonaws.services.sagemaker.sparksdk.internal.ManifestDataUploadResult;
import com.amazonaws.services.sagemaker.sparksdk.internal.ObjectPrefixUploadResult;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.Writer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.spark.sql.Dataset;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h!\u0002\u0010 \u0001\u0005Z\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007IQ\u0001\u001b\t\u0011\u0001\u0003!\u0011!Q\u0001\u000eUB\u0001\"\u0011\u0001\u0003\u0006\u0004%)A\u0011\u0005\t\u0017\u0002\u0011\t\u0011)A\u0007\u0007\")A\n\u0001C\u0001\u001b\"9!\u000b\u0001b\u0001\n\u001b\u0019\u0006BB,\u0001A\u00035A\u000bC\u0004Y\u0001\t\u0007IQB-\t\ru\u0003\u0001\u0015!\u0004[\u0011\u001dq\u0006A1A\u0005\u000e}Caa\u0019\u0001!\u0002\u001b\u0001\u0007b\u00023\u0001\u0005\u0004%i!\u001a\u0005\u0007S\u0002\u0001\u000bQ\u00024\t\u000f)\u0004!\u0019!C\u0007W\"1q\u000e\u0001Q\u0001\u000e1Dq\u0001\u001d\u0001C\u0002\u00135\u0011\u000f\u0003\u0004v\u0001\u0001\u0006iA\u001d\u0005\bm\u0002\u0011\r\u0011\"\u0004x\u0011\u0019Y\b\u0001)A\u0007q\"9A\u0010\u0001b\u0001\n\u001bi\bbBA\u0002\u0001\u0001\u0006iA \u0005\b\u0003\u000b\u0001A\u0011AA\u0004\u0011!\ty\u0005\u0001C\u0001?\u0005E\u0003\u0002CA/\u0001\u0011\u0005\u0011%a\u0018\t\u0011\u0005]\u0004\u0001\"\u0001 \u0003sB\u0001\"a\"\u0001\t\u0003y\u0012\u0011\u0012\u0005\t\u0003c\u0003A\u0011A\u0010\u00024\"A\u0011Q\u0018\u0001\u0005\u0002}\ty\f\u0003\u0005\u0002Z\u0002!\taHAn\u00051!\u0015\r^1Va2|\u0017\rZ3s\u0015\t\u0001\u0013%\u0001\u0005j]R,'O\\1m\u0015\t\u00113%\u0001\u0005ta\u0006\u00148n\u001d3l\u0015\t!S%A\u0005tC\u001e,W.Y6fe*\u0011aeJ\u0001\tg\u0016\u0014h/[2fg*\u0011\u0001&K\u0001\nC6\f'p\u001c8boNT\u0011AK\u0001\u0004G>l7C\u0001\u0001-!\ti\u0003'D\u0001/\u0015\u0005y\u0013!B:dC2\f\u0017BA\u0019/\u0005\u0019\te.\u001f*fM\u0006QA-\u0019;b\r>\u0014X.\u0019;\u0004\u0001U\tQ\u0007\u0005\u00027{9\u0011qg\u000f\t\u0003q9j\u0011!\u000f\u0006\u0003uM\na\u0001\u0010:p_Rt\u0014B\u0001\u001f/\u0003\u0019\u0001&/\u001a3fM&\u0011ah\u0010\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005qr\u0013a\u00033bi\u00064uN]7bi\u0002\n\u0011\u0003Z1uC\u001a{'/\\1u\u001fB$\u0018n\u001c8t+\u0005\u0019\u0005\u0003\u0002#JkUj\u0011!\u0012\u0006\u0003\r\u001e\u000b\u0011\"[7nkR\f'\r\\3\u000b\u0005!s\u0013AC2pY2,7\r^5p]&\u0011!*\u0012\u0002\u0004\u001b\u0006\u0004\u0018A\u00053bi\u00064uN]7bi>\u0003H/[8og\u0002\na\u0001P5oSRtDc\u0001(Q#B\u0011q\nA\u0007\u0002?!)!'\u0002a\u0001k!)\u0011)\u0002a\u0001\u0007\u00061R*\u00198jM\u0016\u001cH\u000fV3na\u001aKG.\u001a)sK\u001aL\u00070F\u0001U\u001f\u0005)\u0016%\u0001,\u0002%M\fw-Z7bW\u0016\u0014X&\\1oS\u001a,7\u000f^\u0001\u0018\u001b\u0006t\u0017NZ3tiR+W\u000e\u001d$jY\u0016\u0004&/\u001a4jq\u0002\n\u0011#T1oS\u001a,7\u000f^&fsN+hMZ5y+\u0005Qv\"A.\"\u0003q\u000bQBL7b]&4Wm\u001d;/ib$\u0018AE'b]&4Wm\u001d;LKf\u001cVO\u001a4jq\u0002\n\u0001\u0003\u0013#G'\u001a{G\u000eZ3s'V4g-\u001b=\u0016\u0003\u0001|\u0011!Y\u0011\u0002E\u0006AAEZ8mI\u0016\u0014H%A\tI\t\u001a\u001bfi\u001c7eKJ\u001cVO\u001a4jq\u0002\n\u0011\u0003S1e_>\u00048+^2dKN\u001ch)\u001b7f+\u00051w\"A4\"\u0003!\f\u0001bX*V\u0007\u000e+5kU\u0001\u0013\u0011\u0006$wn\u001c9Tk\u000e\u001cWm]:GS2,\u0007%\u0001\u0006Tg\u0019\u001b6k\u00195f[\u0016,\u0012\u0001\\\b\u0002[\u0006\na.A\u0002tg\u0005\f1bU\u001aG'N\u001b\u0007.Z7fA\u0005YQ)\u0014*G'N\u001b\u0007.Z7f+\u0005\u0011x\"A:\"\u0003Q\f!a]\u001a\u0002\u0019\u0015k%KR*TG\",W.\u001a\u0011\u0002\u001b\u0015k'OZ:Qe>\u0004XM\u001d;z+\u0005Ax\"A=\"\u0003i\f!BZ:/gNr\u0013.\u001c9m\u00039)UN\u001d4t!J|\u0007/\u001a:us\u0002\na\"R7s\rN\u001bE.Y:t\u001d\u0006lW-F\u0001\u007f\u001f\u0005y\u0018EAA\u0001\u00035)UN\u001d$jY\u0016\u001c\u0016p\u001d;f[\u0006yQ)\u001c:G'\u000ec\u0017m]:OC6,\u0007%\u0001\u0006va2|\u0017\r\u001a#bi\u0006$b!!\u0003\u0002\u0010\u0005m\u0001cA(\u0002\f%\u0019\u0011QB\u0010\u0003!\u0011\u000bG/Y+qY>\fGMU3tk2$\bbBA\t-\u0001\u0007\u00111C\u0001\u0010S:\u0004X\u000f^*4\t\u0006$\u0018\rU1uQB!\u0011QCA\f\u001b\u0005\t\u0013bAA\rC\tQ1k\r#bi\u0006\u0004\u0016\r\u001e5\t\u000f\u0005ua\u00031\u0001\u0002 \u00059A-\u0019;bg\u0016$\b\u0007BA\u0011\u0003{\u0001b!a\t\u00026\u0005eRBAA\u0013\u0015\u0011\t9#!\u000b\u0002\u0007M\fHN\u0003\u0003\u0002,\u00055\u0012!B:qCJ\\'\u0002BA\u0018\u0003c\ta!\u00199bG\",'BAA\u001a\u0003\ry'oZ\u0005\u0005\u0003o\t)CA\u0004ECR\f7/\u001a;\u0011\t\u0005m\u0012Q\b\u0007\u0001\t1\ty$a\u0007\u0002\u0002\u0003\u0005)\u0011AA!\u0005\ryF%M\t\u0005\u0003\u0007\nI\u0005E\u0002.\u0003\u000bJ1!a\u0012/\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!LA&\u0013\r\tiE\f\u0002\u0004\u0003:L\u0018aC4fi\u001a\u001b6k\u00195f[\u0016$2!NA*\u0011\u001d\t)f\u0006a\u0001\u0003/\nQa\u001c8F\u001bJ\u00032!LA-\u0013\r\tYF\f\u0002\b\u0005>|G.Z1o\u0003%9(/\u001b;f\t\u0006$\u0018\r\u0006\u0004\u0002b\u0005\u001d\u00141\u000f\t\u0004[\u0005\r\u0014bAA3]\t!QK\\5u\u0011\u001d\ti\u0002\u0007a\u0001\u0003S\u0002D!a\u001b\u0002pA1\u00111EA\u001b\u0003[\u0002B!a\u000f\u0002p\u0011a\u0011\u0011OA4\u0003\u0003\u0005\tQ!\u0001\u0002B\t\u0019q\f\n\u001a\t\r\u0005U\u0004\u00041\u00016\u0003!Ig\u000e];u+JK\u0015AC;tS:<W)\u0014*G'R!\u0011qKA>\u0011\u001d\ti\"\u0007a\u0001\u0003{\u0002D!a \u0002\u0004B1\u00111EA\u001b\u0003\u0003\u0003B!a\u000f\u0002\u0004\u0012a\u0011QQA>\u0003\u0003\u0005\tQ!\u0001\u0002B\t\u0019q\fJ\u001a\u0002'\u001d,G\u000fS1e_>\u0004h)\u001b7fgf\u001cH/Z7\u0015\r\u0005-\u00151TAS!\u0011\ti)a&\u000e\u0005\u0005=%\u0002BAI\u0003'\u000b!AZ:\u000b\t\u0005U\u0015QF\u0001\u0007Q\u0006$wn\u001c9\n\t\u0005e\u0015q\u0012\u0002\u000b\r&dWmU=ti\u0016l\u0007bBAO5\u0001\u0007\u0011qT\u0001\nS:\u0004X\u000f\u001e)bi\"\u0004B!!$\u0002\"&!\u00111UAH\u0005\u0011\u0001\u0016\r\u001e5\t\u000f\u0005u!\u00041\u0001\u0002(B\"\u0011\u0011VAW!\u0019\t\u0019#!\u000e\u0002,B!\u00111HAW\t1\ty+!*\u0002\u0002\u0003\u0005)\u0011AA!\u0005\ryF\u0005N\u0001\u0017oJLG/Z!oIV\u0003Hn\\1e\u001b\u0006t\u0017NZ3tiR)Q'!.\u0002:\"9\u0011qW\u000eA\u0002\u0005}\u0015AD:bO\u0016l\u0017m[3s\u0013:\u0004X\u000f\u001e\u0005\b\u0003w[\u0002\u0019AAF\u0003!A\u0017\rZ8pa\u001a\u001b\u0016!D<sSR,W*\u00198jM\u0016\u001cH\u000f\u0006\u0005\u0002b\u0005\u0005\u00171YAc\u0011\u001d\t9\f\ba\u0001\u0003?Cq!a/\u001d\u0001\u0004\tY\tC\u0004\u0002Hr\u0001\r!!3\u0002\u001d5\fg.\u001b4fgR<&/\u001b;feB!\u00111ZAk\u001b\t\tiM\u0003\u0003\u0002P\u0006E\u0017AA5p\u0015\t\t\u0019.\u0001\u0003kCZ\f\u0017\u0002BAl\u0003\u001b\u0014aa\u0016:ji\u0016\u0014\u0018aE5t\u0011\u0006$wn\u001c9Ta\u0016\u001c\u0017.\u00197GS2,G\u0003BA,\u0003;Da!a8\u001e\u0001\u0004)\u0014\u0001\u00034jY\u0016t\u0015-\\3")
public class DataUploader {
    private final String dataFormat;
    private final Map<String, String> dataFormatOptions;

    public final String dataFormat() {
        return this.dataFormat;
    }

    public final Map<String, String> dataFormatOptions() {
        return this.dataFormatOptions;
    }

    private final String ManifestTempFilePrefix() {
        return "sagemaker-manifest";
    }

    private final String ManifestKeySuffix() {
        return ".manifest.txt";
    }

    private final String HDFSFolderSuffix() {
        return "$folder$";
    }

    private final String HadoopSuccessFile() {
        return "_SUCCESS";
    }

    private final String S3FSScheme() {
        return "s3a";
    }

    private final String EMRFSScheme() {
        return "s3";
    }

    private final String EmrfsProperty() {
        return "fs.s3.impl";
    }

    private final String EmrFSClassName() {
        return "EmrFileSystem";
    }

    public DataUploadResult uploadData(S3DataPath inputS3DataPath, Dataset<?> dataset) {
        String inputDataBucket = inputS3DataPath.bucket();
        String inputDataObjectPath = inputS3DataPath.objectPath();
        boolean onEMR = this.usingEMRFS(dataset);
        String fsScheme = this.getFSScheme(onEMR);
        String inputURI = new StringBuilder(4).append(fsScheme).append("://").append(inputDataBucket).append("/").append(inputDataObjectPath).toString();
        this.writeData(dataset, inputURI);
        if (onEMR) {
            Path inputPath = new Path(inputURI);
            FileSystem hadoopFS = this.getHadoopFilesystem(inputPath, dataset);
            String manifestKey = this.writeAndUploadManifest(inputPath, hadoopFS);
            return new ManifestDataUploadResult(new S3DataPath(String.valueOf(inputDataBucket), String.valueOf(manifestKey)));
        }
        return new ObjectPrefixUploadResult(new S3DataPath(inputDataBucket, inputDataObjectPath));
    }

    public String getFSScheme(boolean onEMR) {
        if (onEMR) {
            return "s3";
        }
        return "s3a";
    }

    public void writeData(Dataset<?> dataset, String inputURI) {
        dataset.sparkSession().sparkContext().hadoopConfiguration().set("mapreduce.fileoutputcommitter.marksuccessfuljobs", "false");
        dataset.write().format(this.dataFormat()).options(this.dataFormatOptions()).save(inputURI);
    }

    public boolean usingEMRFS(Dataset<?> dataset) {
        String fileSystemClassName = dataset.sparkSession().sparkContext().hadoopConfiguration().get("fs.s3.impl");
        return fileSystemClassName != null && fileSystemClassName.contains("EmrFileSystem");
    }

    public FileSystem getHadoopFilesystem(Path inputPath, Dataset<?> dataset) {
        return inputPath.getFileSystem(dataset.sparkSession().sparkContext().hadoopConfiguration());
    }

    public String writeAndUploadManifest(Path sagemakerInput, FileSystem hadoopFS) {
        File tempFile = File.createTempFile("sagemaker-manifest", "sagemaker-manifest");
        try (FileWriter manifestWriter = new FileWriter(tempFile);){
            this.writeManifest(sagemakerInput, hadoopFS, manifestWriter);
        }
        Path manifestPath = new Path(new StringBuilder(13).append(sagemakerInput.toUri().getPath()).append(".manifest.txt").toString());
        hadoopFS.copyFromLocalFile(true, new Path(tempFile.getAbsolutePath()), manifestPath);
        return new StringOps(Predef$.MODULE$.augmentString(manifestPath.toUri().getPath())).stripPrefix("/");
    }

    public void writeManifest(Path sagemakerInput, FileSystem hadoopFS, Writer manifestWriter) {
        RemoteIterator hadoopFSIterator = hadoopFS.listFiles(sagemakerInput, true);
        scala.collection.mutable.StringBuilder manifestStringBuilder = new scala.collection.mutable.StringBuilder(new StringBuilder(18).append("[{\"prefix\": \"").append(sagemakerInput).append("/\"}, ").toString());
        Predef$.MODULE$.require(hadoopFSIterator.hasNext(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("No files found at ").append(sagemakerInput).append(".").toString());
        ListBuffer fileNames = (ListBuffer)ListBuffer$.MODULE$.empty();
        while (hadoopFSIterator.hasNext()) {
            Path nextFile = ((FileStatus)hadoopFSIterator.next()).getPath();
            String fileName = nextFile.getName();
            if (this.isHadoopSpecialFile(fileName)) continue;
            fileNames.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(2).append("\"").append(fileName).append("\"").toString()}));
        }
        Predef$.MODULE$.require(fileNames.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("No non-hadoop files found at ").append(sagemakerInput).append(".").toString());
        manifestStringBuilder.append(fileNames.mkString(", "));
        manifestWriter.write(manifestStringBuilder.append("]").toString());
    }

    public boolean isHadoopSpecialFile(String fileName) {
        return fileName.endsWith("$folder$") || fileName.equals("_SUCCESS");
    }

    public DataUploader(String dataFormat, Map<String, String> dataFormatOptions) {
        this.dataFormat = dataFormat;
        this.dataFormatOptions = dataFormatOptions;
    }
}

