/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.sparksdk;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.SdkBaseException;
import com.amazonaws.retry.RetryUtils;
import com.amazonaws.services.sagemaker.AmazonSageMaker;
import com.amazonaws.services.sagemaker.model.ContainerDefinition;
import com.amazonaws.services.sagemaker.model.CreateEndpointConfigRequest;
import com.amazonaws.services.sagemaker.model.CreateEndpointRequest;
import com.amazonaws.services.sagemaker.model.CreateModelRequest;
import com.amazonaws.services.sagemaker.model.DescribeEndpointRequest;
import com.amazonaws.services.sagemaker.model.DescribeEndpointResult;
import com.amazonaws.services.sagemaker.model.EndpointStatus;
import com.amazonaws.services.sagemaker.model.ProductionVariant;
import com.amazonaws.services.sagemaker.sparksdk.CreatedResources;
import com.amazonaws.services.sagemaker.sparksdk.EndpointCreationPolicy$;
import com.amazonaws.services.sagemaker.sparksdk.NamePolicy;
import com.amazonaws.services.sagemaker.sparksdk.S3DataPath;
import com.amazonaws.services.sagemaker.sparksdk.SageMakerModel$;
import com.amazonaws.services.sagemaker.sparksdk.exceptions.SageMakerSparkSDKException;
import com.amazonaws.services.sagemaker.sparksdk.internal.InternalUtils$;
import com.amazonaws.services.sagemaker.sparksdk.internal.SystemTimeProvider;
import com.amazonaws.services.sagemaker.sparksdk.internal.TimeProvider;
import com.amazonaws.services.sagemaker.sparksdk.transformation.RequestRowSerializer;
import com.amazonaws.services.sagemaker.sparksdk.transformation.ResponseRowDeserializer;
import com.amazonaws.services.sagemaker.sparksdk.transformation.util.RequestBatchIteratorFactory$;
import java.io.Serializable;
import java.time.Duration;
import java.util.Map;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.Params;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r%w!\u00020`\u0011\u0003Qg!\u00027`\u0011\u0003i\u0007\"B<\u0002\t\u0003A\bbB=\u0002\u0001\u0004%\tA\u001f\u0005\n\u0003\u000f\t\u0001\u0019!C\u0001\u0003\u0013Aq!!\u0006\u0002A\u0003&1\u0010\u0003\u0005\u0002\u0018\u0005\u0001\r\u0011\"\u0001{\u0011%\tI\"\u0001a\u0001\n\u0003\tY\u0002C\u0004\u0002 \u0005\u0001\u000b\u0015B>\t\u000f\u0005\u0005\u0012\u0001\"\u0001\u0002$!I1\u0011E\u0001\u0012\u0002\u0013\u000511\u0005\u0005\n\u0007o\t\u0011\u0013!C\u0001\u0007sA\u0011b!\u0010\u0002#\u0003%\taa\u0010\t\u0013\r\r\u0013!%A\u0005\u0002\r\u0015\u0003\"CB%\u0003E\u0005I\u0011AB&\u0011%\u0019y%AI\u0001\n\u0003\u0019\t\u0006C\u0004\u0004V\u0005!\taa\u0016\t\u0013\rM\u0014!%A\u0005\u0002\r\r\u0002\"CB;\u0003E\u0005I\u0011AB\u001d\u0011%\u00199(AI\u0001\n\u0003\u0019y\u0004C\u0005\u0004z\u0005\t\n\u0011\"\u0001\u0004F!I11P\u0001\u0012\u0002\u0013\u000511\n\u0005\n\u0007{\n\u0011\u0013!C\u0001\u0007#Bqaa \u0002\t\u0003\u0019\t\tC\u0005\u0004\u0014\u0006\t\n\u0011\"\u0001\u0004$!I1QS\u0001\u0012\u0002\u0013\u00051q\b\u0005\n\u0007/\u000b\u0011\u0013!C\u0001\u0007\u000bB\u0011b!'\u0002#\u0003%\taa\u0013\t\u0013\rm\u0015!%A\u0005\u0002\rE\u0003\"CBO\u0003E\u0005I\u0011ABP\u0011%\u0019\u0019+AI\u0001\n\u0003\u0019y\nC\u0005\u0004&\u0006\t\n\u0011\"\u0001\u0004(\"I11V\u0001\u0012\u0002\u0013\u000511\u0005\u0005\n\u0007[\u000b\u0011\u0013!C\u0001\u0007?C\u0011ba,\u0002#\u0003%\ta!\u000f\t\u0013\rE\u0016!%A\u0005\u0002\r}\u0002\"CBZ\u0003E\u0005I\u0011AB#\u0011%\u0019),AI\u0001\n\u0003\u0019Y\u0005C\u0005\u00048\u0006\t\n\u0011\"\u0001\u0004R!I1\u0011X\u0001\u0002\u0002\u0013%11\u0018\u0004\u0006Y~\u0003\u0011q\u0005\u0005\u000b\u0003\u0003B#Q1A\u0005\u0002\u0005\r\u0003BCA1Q\t\u0005\t\u0015!\u0003\u0002F!Q\u00111\r\u0015\u0003\u0006\u0004%\t!!\u001a\t\u0015\u0005=\u0004F!A!\u0002\u0013\t9\u0007\u0003\u0006\u0002r!\u0012)\u0019!C\u0001\u0003gB!\"!!)\u0005\u0003\u0005\u000b\u0011BA;\u0011)\t\u0019\t\u000bBC\u0002\u0013\u0005\u0011Q\u0011\u0005\u000b\u0003\u001bC#\u0011!Q\u0001\n\u0005\u001d\u0005BCAHQ\t\u0015\r\u0011\"\u0001\u0002D!Q\u0011\u0011\u0013\u0015\u0003\u0002\u0003\u0006I!!\u0012\t\u0015\u0005M\u0005F!b\u0001\n\u0003\t\u0019\u0005\u0003\u0006\u0002\u0016\"\u0012\t\u0011)A\u0005\u0003\u000bB!\"a&)\u0005\u000b\u0007I\u0011AAM\u0011)\t\u0019\u000b\u000bB\u0001B\u0003%\u00111\u0014\u0005\u000b\u0003KC#Q1A\u0005\u0002\u0005\u001d\u0006BCAXQ\t\u0005\t\u0015!\u0003\u0002*\"Q\u0011\u0011\u0017\u0015\u0003\u0006\u0004%\t!a\u0011\t\u0015\u0005M\u0006F!A!\u0002\u0013\t)\u0005\u0003\u0006\u00026\"\u0012)\u0019!C\u0001\u0003oC!\"a7)\u0005\u0003\u0005\u000b\u0011BA]\u0011)\ti\u000e\u000bBC\u0002\u0013\u0005\u0011q\u001c\u0005\u000b\u0003SD#\u0011!Q\u0001\n\u0005\u0005\bBCAvQ\t\u0015\r\u0011\"\u0001\u0002n\"Q\u0011Q\u001f\u0015\u0003\u0002\u0003\u0006I!a<\t\u0015\u0005]\bF!b\u0001\n\u0003\tI\u0010\u0003\u0006\u0003\u0002!\u0012\t\u0011)A\u0005\u0003wD!Ba\u0001)\u0005\u000b\u0007I\u0011\tB\u0003\u0011)\u00119\u0001\u000bB\u0001B\u0003%\u00111\n\u0005\u0007o\"\"\tA!\u0003\t\u0015\t\u001d\u0002\u00061A\u0005\u0002}\u0013I\u0003\u0003\u0006\u00038!\u0002\r\u0011\"\u0001`\u0005sA\u0001B!\u0010)A\u0003&!1\u0006\u0005\n\u0005\u007fA\u0003\u0019!C\u0005\u0003\u0007B\u0011B!\u0011)\u0001\u0004%IAa\u0011\t\u0011\t\u001d\u0003\u0006)Q\u0005\u0003\u000bB\u0011B!\u0013)\u0001\u0004%I!a\u0011\t\u0013\t-\u0003\u00061A\u0005\n\t5\u0003\u0002\u0003B)Q\u0001\u0006K!!\u0012\t\u0013\tM\u0003\u00061A\u0005\n\u0005\r\u0003\"\u0003B+Q\u0001\u0007I\u0011\u0002B,\u0011!\u0011Y\u0006\u000bQ!\n\u0005\u0015\u0003b\u0002B/Q\u0011\u0005\u00111\t\u0005\b\u0005?BC\u0011\u0002B1\u0011\u001d\u0011\u0019\u0007\u000bC\u0001\u0005KBqA!\u001c)\t\u0013\u0011)\u0001C\u0005\u0003p!\u0012\r\u0011\"\u0004\u0003r!A!\u0011\u0010\u0015!\u0002\u001b\u0011\u0019\bC\u0004\u0003|!\"IA!\u0002\t\u000f\tu\u0004\u0006\"\u0003\u0003\u0006!9!q\u0010\u0015\u0005\n\t\u0005\u0005b\u0002BCQ\u0011\u0005#q\u0011\u0005\b\u0005\u001fDC\u0011\tBi\u0011\u001d\u0011\t\u0010\u000bC!\u0005g\fabU1hK6\u000b7.\u001a:N_\u0012,GN\u0003\u0002aC\u0006A1\u000f]1sWN$7N\u0003\u0002cG\u0006I1/Y4f[\u0006\\WM\u001d\u0006\u0003I\u0016\f\u0001b]3sm&\u001cWm\u001d\u0006\u0003M\u001e\f\u0011\"Y7bu>t\u0017m^:\u000b\u0003!\f1aY8n\u0007\u0001\u0001\"a[\u0001\u000e\u0003}\u0013abU1hK6\u000b7.\u001a:N_\u0012,GnE\u0002\u0002]R\u0004\"a\u001c:\u000e\u0003AT\u0011!]\u0001\u0006g\u000e\fG.Y\u0005\u0003gB\u0014a!\u00118z%\u00164\u0007CA8v\u0013\t1\bO\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004=S:LGO\u0010\u000b\u0002U\u00069RI\u001c3q_&tGo\u0011:fCRLwN\u001c+j[\u0016|W\u000f^\u000b\u0002wB\u0019A0a\u0001\u000e\u0003uT!A`@\u0002\tQLW.\u001a\u0006\u0003\u0003\u0003\tAA[1wC&\u0019\u0011QA?\u0003\u0011\u0011+(/\u0019;j_:\f1$\u00128ea>Lg\u000e^\"sK\u0006$\u0018n\u001c8US6,w.\u001e;`I\u0015\fH\u0003BA\u0006\u0003#\u00012a\\A\u0007\u0013\r\ty\u0001\u001d\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0014\u0011\t\t\u00111\u0001|\u0003\rAH%M\u0001\u0019\u000b:$\u0007o\\5oi\u000e\u0013X-\u0019;j_:$\u0016.\\3pkR\u0004\u0013\u0001F#oIB|\u0017N\u001c;Q_2d\u0017J\u001c;feZ\fG.\u0001\rF]\u0012\u0004x.\u001b8u!>dG.\u00138uKJ4\u0018\r\\0%KF$B!a\u0003\u0002\u001e!A\u00111C\u0004\u0002\u0002\u0003\u000710A\u000bF]\u0012\u0004x.\u001b8u!>dG.\u00138uKJ4\u0018\r\u001c\u0011\u0002\u001f\u0019\u0014x.\u001c+sC&t\u0017N\\4K_\n$B$!\n\u0004\u0006\r%11BB\u0007\u0007\u001f\u0019\tba\u0005\u0004\u0016\r]1\u0011DB\u000e\u0007;\u0019y\u0002\u0005\u0002lQM\u0019\u0001&!\u000b\u0011\r\u0005-\u0012QHA\u0013\u001b\t\tiC\u0003\u0003\u00020\u0005E\u0012AA7m\u0015\u0011\t\u0019$!\u000e\u0002\u000bM\u0004\u0018M]6\u000b\t\u0005]\u0012\u0011H\u0001\u0007CB\f7\r[3\u000b\u0005\u0005m\u0012aA8sO&!\u0011qHA\u0017\u0005\u0015iu\u000eZ3m\u0003Q)g\u000e\u001a9pS:$\u0018J\\:uC:\u001cW\rV=qKV\u0011\u0011Q\t\t\u0006_\u0006\u001d\u00131J\u0005\u0004\u0003\u0013\u0002(AB(qi&|g\u000e\u0005\u0003\u0002N\u0005mc\u0002BA(\u0003/\u00022!!\u0015q\u001b\t\t\u0019FC\u0002\u0002V%\fa\u0001\u0010:p_Rt\u0014bAA-a\u00061\u0001K]3eK\u001aLA!!\u0018\u0002`\t11\u000b\u001e:j]\u001eT1!!\u0017q\u0003U)g\u000e\u001a9pS:$\u0018J\\:uC:\u001cW\rV=qK\u0002\nA$\u001a8ea>Lg\u000e^%oSRL\u0017\r\\%ogR\fgnY3D_VtG/\u0006\u0002\u0002hA)q.a\u0012\u0002jA\u0019q.a\u001b\n\u0007\u00055\u0004OA\u0002J]R\fQ$\u001a8ea>Lg\u000e^%oSRL\u0017\r\\%ogR\fgnY3D_VtG\u000fI\u0001\u0015e\u0016\fX/Z:u%><8+\u001a:jC2L'0\u001a:\u0016\u0005\u0005U\u0004\u0003BA<\u0003{j!!!\u001f\u000b\u0007\u0005mt,\u0001\bue\u0006t7OZ8s[\u0006$\u0018n\u001c8\n\t\u0005}\u0014\u0011\u0010\u0002\u0015%\u0016\fX/Z:u%><8+\u001a:jC2L'0\u001a:\u0002+I,\u0017/^3tiJ{woU3sS\u0006d\u0017N_3sA\u00059\"/Z:q_:\u001cXMU8x\t\u0016\u001cXM]5bY&TXM]\u000b\u0003\u0003\u000f\u0003B!a\u001e\u0002\n&!\u00111RA=\u0005]\u0011Vm\u001d9p]N,'k\\<EKN,'/[1mSj,'/\u0001\rsKN\u0004xN\\:f%><H)Z:fe&\fG.\u001b>fe\u0002\nA#\u001a=jgRLgnZ#oIB|\u0017N\u001c;OC6,\u0017!F3ySN$\u0018N\\4F]\u0012\u0004x.\u001b8u\u001d\u0006lW\rI\u0001\u000b[>$W\r\\%nC\u001e,\u0017aC7pI\u0016d\u0017*\\1hK\u0002\n\u0011\"\\8eK2\u0004\u0016\r\u001e5\u0016\u0005\u0005m\u0005#B8\u0002H\u0005u\u0005cA6\u0002 &\u0019\u0011\u0011U0\u0003\u0015M\u001bD)\u0019;b!\u0006$\b.\u0001\u0006n_\u0012,G\u000eU1uQ\u0002\n\u0011$\\8eK2,eN^5s_:lWM\u001c;WCJL\u0017M\u00197fgV\u0011\u0011\u0011\u0016\t\t\u0003\u001b\nY+a\u0013\u0002L%!\u0011QVA0\u0005\ri\u0015\r]\u0001\u001b[>$W\r\\#om&\u0014xN\\7f]R4\u0016M]5bE2,7\u000fI\u0001\u0016[>$W\r\\#yK\u000e,H/[8o%>dW-\u0011*O\u0003Yiw\u000eZ3m\u000bb,7-\u001e;j_:\u0014v\u000e\\3B%:\u0003\u0013AF3oIB|\u0017N\u001c;De\u0016\fG/[8o!>d\u0017nY=\u0016\u0005\u0005e\u0006\u0003BA^\u0003+tA!!0\u0002R:!\u0011qXAh\u001d\u0011\t\t-!4\u000f\t\u0005\r\u00171\u001a\b\u0005\u0003\u000b\fIM\u0004\u0003\u0002R\u0005\u001d\u0017\"\u00015\n\u0005\u0019<\u0017B\u00013f\u0013\t\u00117-\u0003\u0002aC&\u0019\u00111[0\u0002-\u0015sG\r]8j]R\u001c%/Z1uS>t\u0007k\u001c7jGfLA!a6\u0002Z\n1RI\u001c3q_&tGo\u0011:fCRLwN\u001c)pY&\u001c\u0017PC\u0002\u0002T~\u000bq#\u001a8ea>Lg\u000e^\"sK\u0006$\u0018n\u001c8Q_2L7-\u001f\u0011\u0002\u001fM\fw-Z7bW\u0016\u00148\t\\5f]R,\"!!9\u0011\t\u0005\r\u0018Q]\u0007\u0002C&\u0019\u0011q]1\u0003\u001f\u0005k\u0017M_8o'\u0006<W-T1lKJ\f\u0001c]1hK6\f7.\u001a:DY&,g\u000e\u001e\u0011\u0002#A\u0014X\r]3oIJ+7/\u001e7u%><8/\u0006\u0002\u0002pB\u0019q.!=\n\u0007\u0005M\bOA\u0004C_>dW-\u00198\u0002%A\u0014X\r]3oIJ+7/\u001e7u%><8\u000fI\u0001\u000b]\u0006lW\rU8mS\u000eLXCAA~!\rY\u0017Q`\u0005\u0004\u0003\u007f|&A\u0003(b[\u0016\u0004v\u000e\\5ds\u0006Ya.Y7f!>d\u0017nY=!\u0003\r)\u0018\u000eZ\u000b\u0003\u0003\u0017\nA!^5eAQq\u0012Q\u0005B\u0006\u0005\u001b\u0011yA!\u0005\u0003\u0014\tU!q\u0003B\r\u00057\u0011iBa\b\u0003\"\t\r\"Q\u0005\u0005\b\u0003\u0003*\u0005\u0019AA#\u0011\u001d\t\u0019'\u0012a\u0001\u0003OBq!!\u001dF\u0001\u0004\t)\bC\u0004\u0002\u0004\u0016\u0003\r!a\"\t\u0013\u0005=U\t%AA\u0002\u0005\u0015\u0003\"CAJ\u000bB\u0005\t\u0019AA#\u0011%\t9*\u0012I\u0001\u0002\u0004\tY\nC\u0005\u0002&\u0016\u0003\n\u00111\u0001\u0002*\"I\u0011\u0011W#\u0011\u0002\u0003\u0007\u0011Q\t\u0005\n\u0003k+\u0005\u0013!a\u0001\u0003sC\u0011\"!8F!\u0003\u0005\r!!9\t\u0013\u0005-X\t%AA\u0002\u0005=\b\"CA|\u000bB\u0005\t\u0019AA~\u0011%\u0011\u0019!\u0012I\u0001\u0002\u0004\tY%\u0001\u0007uS6,\u0007K]8wS\u0012,'/\u0006\u0002\u0003,A!!Q\u0006B\u001a\u001b\t\u0011yCC\u0002\u00032}\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\u0005k\u0011yC\u0001\u0007US6,\u0007K]8wS\u0012,'/\u0001\tuS6,\u0007K]8wS\u0012,'o\u0018\u0013fcR!\u00111\u0002B\u001e\u0011%\t\u0019bRA\u0001\u0002\u0004\u0011Y#A\u0007uS6,\u0007K]8wS\u0012,'\u000fI\u0001\u0011GJ,\u0017\r^3e\u001b>$W\r\u001c(b[\u0016\fAc\u0019:fCR,G-T8eK2t\u0015-\\3`I\u0015\fH\u0003BA\u0006\u0005\u000bB\u0011\"a\u0005K\u0003\u0003\u0005\r!!\u0012\u0002#\r\u0014X-\u0019;fI6{G-\u001a7OC6,\u0007%A\rde\u0016\fG/\u001a3F]\u0012\u0004x.\u001b8u\u0007>tg-[4OC6,\u0017!H2sK\u0006$X\rZ#oIB|\u0017N\u001c;D_:4\u0017n\u001a(b[\u0016|F%Z9\u0015\t\u0005-!q\n\u0005\n\u0003'i\u0015\u0011!a\u0001\u0003\u000b\n!d\u0019:fCR,G-\u00128ea>Lg\u000e^\"p]\u001aLwMT1nK\u0002\n1c\u0019:fCR,G-\u00128ea>Lg\u000e\u001e(b[\u0016\fqc\u0019:fCR,G-\u00128ea>Lg\u000e\u001e(b[\u0016|F%Z9\u0015\t\u0005-!\u0011\f\u0005\n\u0003'\u0001\u0016\u0011!a\u0001\u0003\u000b\nAc\u0019:fCR,G-\u00128ea>Lg\u000e\u001e(b[\u0016\u0004\u0013\u0001D3oIB|\u0017N\u001c;OC6,\u0017aH2sK\u0006$XmU1hK6\u000b7.\u001a:I_N$\u0018N\\4SKN|WO]2fgR\u0011\u00111B\u0001\u0014O\u0016$8I]3bi\u0016$'+Z:pkJ\u001cWm]\u000b\u0003\u0005O\u00022a\u001bB5\u0013\r\u0011Yg\u0018\u0002\u0011\u0007J,\u0017\r^3e%\u0016\u001cx.\u001e:dKN\f1b\u0019:fCR,Wj\u001c3fY\u0006Ya+\u0019:jC:$h*Y7f+\t\u0011\u0019h\u0004\u0002\u0003v\u0005\u0012!qO\u0001\f\u00032d'+Z9vKN$8/\u0001\u0007WCJL\u0017M\u001c;OC6,\u0007%\u0001\u000bde\u0016\fG/Z#oIB|\u0017N\u001c;D_:4\u0017nZ\u0001\u000fGJ,\u0017\r^3F]\u0012\u0004x.\u001b8u\u0003]\tw/Y5u\u000b:$\u0007o\\5oi\u000e{W\u000e\u001d7fi&|g\u000e\u0006\u0003\u0002\f\t\r\u0005b\u0002B/5\u0002\u0007\u00111J\u0001\niJ\fgn\u001d4pe6$BA!#\u0003,B!!1\u0012BS\u001d\u0011\u0011iIa(\u000f\t\t=%1\u0014\b\u0005\u0005#\u0013IJ\u0004\u0003\u0003\u0014\n]e\u0002BA)\u0005+K!!a\u000f\n\t\u0005]\u0012\u0011H\u0005\u0005\u0003g\t)$\u0003\u0003\u0003\u001e\u0006E\u0012aA:rY&!!\u0011\u0015BR\u0003\u001d\u0001\u0018mY6bO\u0016TAA!(\u00022%!!q\u0015BU\u0005%!\u0015\r^1Ge\u0006lWM\u0003\u0003\u0003\"\n\r\u0006b\u0002BW7\u0002\u0007!qV\u0001\bI\u0006$\u0018m]3ua\u0011\u0011\tL!0\u0011\r\tM&Q\u0017B]\u001b\t\u0011\u0019+\u0003\u0003\u00038\n\r&a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0005w\u0013i\f\u0004\u0001\u0005\u0019\t}&1VA\u0001\u0002\u0003\u0015\tA!1\u0003\u0007}#\u0013'\u0005\u0003\u0003D\n%\u0007cA8\u0003F&\u0019!q\u00199\u0003\u000f9{G\u000f[5oOB\u0019qNa3\n\u0007\t5\u0007OA\u0002B]f\fq\u0002\u001e:b]N4wN]7TG\",W.\u0019\u000b\u0005\u0005'\u0014y\u000e\u0005\u0003\u0003V\nmWB\u0001Bl\u0015\u0011\u0011INa)\u0002\u000bQL\b/Z:\n\t\tu'q\u001b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007b\u0002Bq9\u0002\u0007!1[\u0001\u0007g\u000eDW-\\1)\u0007q\u0013)\u000f\u0005\u0003\u0003h\n5XB\u0001Bu\u0015\u0011\u0011Y/!\r\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003p\n%(\u0001\u0004#fm\u0016dw\u000e]3s\u0003BL\u0017\u0001B2paf$B!!\n\u0003v\"9!q_/A\u0002\te\u0018!B3yiJ\f\u0007\u0003\u0002B~\u0007\u0003i!A!@\u000b\t\t}\u0018QF\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0007\u0007\u0011iP\u0001\u0005QCJ\fW.T1q\u0011\u001d\u00199!\u0003a\u0001\u0003\u0017\nq\u0002\u001e:bS:Lgn\u001a&pE:\u000bW.\u001a\u0005\b\u0003'K\u0001\u0019AA&\u0011\u001d\t\t,\u0003a\u0001\u0003\u0017Bq!!\u0011\n\u0001\u0004\tY\u0005C\u0004\u0002d%\u0001\r!!\u001b\t\u000f\u0005E\u0014\u00021\u0001\u0002v!9\u00111Q\u0005A\u0002\u0005\u001d\u0005\"CAS\u0013A\u0005\t\u0019AAU\u0011%\t),\u0003I\u0001\u0002\u0004\tI\fC\u0005\u0002^&\u0001\n\u00111\u0001\u0002b\"I\u00111^\u0005\u0011\u0002\u0003\u0007\u0011q\u001e\u0005\n\u0003oL\u0001\u0013!a\u0001\u0003wD\u0011Ba\u0001\n!\u0003\u0005\r!a\u0013\u00023\u0019\u0014x.\u001c+sC&t\u0017N\\4K_\n$C-\u001a4bk2$H\u0005O\u000b\u0003\u0007KQC!!+\u0004(-\u00121\u0011\u0006\t\u0005\u0007W\u0019\u0019$\u0004\u0002\u0004.)!1qFB\u0019\u0003%)hn\u00195fG.,GMC\u0002\u0003lBLAa!\u000e\u0004.\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u00023\u0019\u0014x.\u001c+sC&t\u0017N\\4K_\n$C-\u001a4bk2$H%O\u000b\u0003\u0007wQC!!/\u0004(\u0005QbM]8n)J\f\u0017N\\5oO*{'\r\n3fM\u0006,H\u000e\u001e\u00132aU\u00111\u0011\t\u0016\u0005\u0003C\u001c9#\u0001\u000ege>lGK]1j]&twMS8cI\u0011,g-Y;mi\u0012\n\u0014'\u0006\u0002\u0004H)\"\u0011q^B\u0014\u0003i1'o\\7Ue\u0006Lg.\u001b8h\u0015>\u0014G\u0005Z3gCVdG\u000fJ\u00193+\t\u0019iE\u000b\u0003\u0002|\u000e\u001d\u0012A\u00074s_6$&/Y5oS:<'j\u001c2%I\u00164\u0017-\u001e7uIE\u001aTCAB*U\u0011\tYea\n\u0002\u001f\u0019\u0014x.\\'pI\u0016d7k\r)bi\"$B$!\n\u0004Z\rm3QLB0\u0007C\u001a\u0019g!\u001a\u0004h\r%41NB7\u0007_\u001a\t\bC\u0004\u0002\u0018B\u0001\r!a\u0013\t\u000f\u0005M\u0005\u00031\u0001\u0002L!9\u0011\u0011\u0017\tA\u0002\u0005-\u0003bBA!!\u0001\u0007\u00111\n\u0005\b\u0003G\u0002\u0002\u0019AA5\u0011\u001d\t\t\b\u0005a\u0001\u0003kBq!a!\u0011\u0001\u0004\t9\tC\u0005\u0002&B\u0001\n\u00111\u0001\u0002*\"I\u0011Q\u0017\t\u0011\u0002\u0003\u0007\u0011\u0011\u0018\u0005\n\u0003;\u0004\u0002\u0013!a\u0001\u0003CD\u0011\"a;\u0011!\u0003\u0005\r!a<\t\u0013\u0005]\b\u0003%AA\u0002\u0005m\b\"\u0003B\u0002!A\u0005\t\u0019AA&\u0003e1'o\\7N_\u0012,GnU\u001aQCRDG\u0005Z3gCVdG\u000f\n\u001d\u00023\u0019\u0014x.\\'pI\u0016d7k\r)bi\"$C-\u001a4bk2$H%O\u0001\u001bMJ|W.T8eK2\u001c6\u0007U1uQ\u0012\"WMZ1vYR$\u0013\u0007M\u0001\u001bMJ|W.T8eK2\u001c6\u0007U1uQ\u0012\"WMZ1vYR$\u0013'M\u0001\u001bMJ|W.T8eK2\u001c6\u0007U1uQ\u0012\"WMZ1vYR$\u0013GM\u0001\u001bMJ|W.T8eK2\u001c6\u0007U1uQ\u0012\"WMZ1vYR$\u0013gM\u0001\rMJ|W.\u00128ea>Lg\u000e\u001e\u000b\u0013\u0003K\u0019\u0019i!\"\u0004\b\u000e%51RBG\u0007\u001f\u001b\t\nC\u0004\u0003^]\u0001\r!a\u0013\t\u000f\u0005Et\u00031\u0001\u0002v!9\u00111Q\fA\u0002\u0005\u001d\u0005\"CAS/A\u0005\t\u0019AAU\u0011%\tin\u0006I\u0001\u0002\u0004\t\t\u000fC\u0005\u0002l^\u0001\n\u00111\u0001\u0002p\"I\u0011q_\f\u0011\u0002\u0003\u0007\u00111 \u0005\n\u0005\u00079\u0002\u0013!a\u0001\u0003\u0017\naC\u001a:p[\u0016sG\r]8j]R$C-\u001a4bk2$H\u0005N\u0001\u0017MJ|W.\u00128ea>Lg\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%k\u00051bM]8n\u000b:$\u0007o\\5oi\u0012\"WMZ1vYR$c'\u0001\fge>lWI\u001c3q_&tG\u000f\n3fM\u0006,H\u000e\u001e\u00138\u0003Y1'o\\7F]\u0012\u0004x.\u001b8uI\u0011,g-Y;mi\u0012B\u0014a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0004\"*\"\u0011QIB\u0014\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%m\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"a!++\t\u0005m5qE\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001d\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u0013:\u0003q!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%cA\nA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0014'\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u001a\u00029\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132g\u0005aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\"\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"a!0\u0011\t\r}6QY\u0007\u0003\u0007\u0003T1aa1\u0000\u0003\u0011a\u0017M\\4\n\t\r\u001d7\u0011\u0019\u0002\u0007\u001f\nTWm\u0019;")
public class SageMakerModel
extends Model<SageMakerModel> {
    private final Option<String> endpointInstanceType;
    private final Option<Object> endpointInitialInstanceCount;
    private final RequestRowSerializer requestRowSerializer;
    private final ResponseRowDeserializer responseRowDeserializer;
    private final Option<String> existingEndpointName;
    private final Option<String> modelImage;
    private final Option<S3DataPath> modelPath;
    private final scala.collection.immutable.Map<String, String> modelEnvironmentVariables;
    private final Option<String> modelExecutionRoleARN;
    private final Enumeration.Value endpointCreationPolicy;
    private final AmazonSageMaker sagemakerClient;
    private final boolean prependResultRows;
    private final NamePolicy namePolicy;
    private final String uid;
    private TimeProvider timeProvider;
    private Option<String> createdModelName;
    private Option<String> createdEndpointConfigName;
    private Option<String> createdEndpointName;

    public static String $lessinit$greater$default$14() {
        return SageMakerModel$.MODULE$.$lessinit$greater$default$14();
    }

    public static NamePolicy $lessinit$greater$default$13() {
        return SageMakerModel$.MODULE$.$lessinit$greater$default$13();
    }

    public static boolean $lessinit$greater$default$12() {
        return SageMakerModel$.MODULE$.$lessinit$greater$default$12();
    }

    public static AmazonSageMaker $lessinit$greater$default$11() {
        return SageMakerModel$.MODULE$.$lessinit$greater$default$11();
    }

    public static Enumeration.Value $lessinit$greater$default$10() {
        return SageMakerModel$.MODULE$.$lessinit$greater$default$10();
    }

    public static Option<String> $lessinit$greater$default$9() {
        return SageMakerModel$.MODULE$.$lessinit$greater$default$9();
    }

    public static scala.collection.immutable.Map<String, String> $lessinit$greater$default$8() {
        return SageMakerModel$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<S3DataPath> $lessinit$greater$default$7() {
        return SageMakerModel$.MODULE$.$lessinit$greater$default$7();
    }

    public static Option<String> $lessinit$greater$default$6() {
        return SageMakerModel$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<String> $lessinit$greater$default$5() {
        return SageMakerModel$.MODULE$.$lessinit$greater$default$5();
    }

    public static String fromEndpoint$default$8() {
        return SageMakerModel$.MODULE$.fromEndpoint$default$8();
    }

    public static NamePolicy fromEndpoint$default$7() {
        return SageMakerModel$.MODULE$.fromEndpoint$default$7();
    }

    public static boolean fromEndpoint$default$6() {
        return SageMakerModel$.MODULE$.fromEndpoint$default$6();
    }

    public static AmazonSageMaker fromEndpoint$default$5() {
        return SageMakerModel$.MODULE$.fromEndpoint$default$5();
    }

    public static scala.collection.immutable.Map<String, String> fromEndpoint$default$4() {
        return SageMakerModel$.MODULE$.fromEndpoint$default$4();
    }

    public static SageMakerModel fromEndpoint(String string, RequestRowSerializer requestRowSerializer, ResponseRowDeserializer responseRowDeserializer, scala.collection.immutable.Map<String, String> map, AmazonSageMaker amazonSageMaker, boolean bl, NamePolicy namePolicy, String string2) {
        return SageMakerModel$.MODULE$.fromEndpoint(string, requestRowSerializer, responseRowDeserializer, map, amazonSageMaker, bl, namePolicy, string2);
    }

    public static String fromModelS3Path$default$13() {
        return SageMakerModel$.MODULE$.fromModelS3Path$default$13();
    }

    public static NamePolicy fromModelS3Path$default$12() {
        return SageMakerModel$.MODULE$.fromModelS3Path$default$12();
    }

    public static boolean fromModelS3Path$default$11() {
        return SageMakerModel$.MODULE$.fromModelS3Path$default$11();
    }

    public static AmazonSageMaker fromModelS3Path$default$10() {
        return SageMakerModel$.MODULE$.fromModelS3Path$default$10();
    }

    public static Enumeration.Value fromModelS3Path$default$9() {
        return SageMakerModel$.MODULE$.fromModelS3Path$default$9();
    }

    public static scala.collection.immutable.Map<String, String> fromModelS3Path$default$8() {
        return SageMakerModel$.MODULE$.fromModelS3Path$default$8();
    }

    public static SageMakerModel fromModelS3Path(String string, String string2, String string3, String string4, int n, RequestRowSerializer requestRowSerializer, ResponseRowDeserializer responseRowDeserializer, scala.collection.immutable.Map<String, String> map, Enumeration.Value value, AmazonSageMaker amazonSageMaker, boolean bl, NamePolicy namePolicy, String string5) {
        return SageMakerModel$.MODULE$.fromModelS3Path(string, string2, string3, string4, n, requestRowSerializer, responseRowDeserializer, map, value, amazonSageMaker, bl, namePolicy, string5);
    }

    public static String fromTrainingJob$default$13() {
        return SageMakerModel$.MODULE$.fromTrainingJob$default$13();
    }

    public static NamePolicy fromTrainingJob$default$12() {
        return SageMakerModel$.MODULE$.fromTrainingJob$default$12();
    }

    public static boolean fromTrainingJob$default$11() {
        return SageMakerModel$.MODULE$.fromTrainingJob$default$11();
    }

    public static AmazonSageMaker fromTrainingJob$default$10() {
        return SageMakerModel$.MODULE$.fromTrainingJob$default$10();
    }

    public static Enumeration.Value fromTrainingJob$default$9() {
        return SageMakerModel$.MODULE$.fromTrainingJob$default$9();
    }

    public static scala.collection.immutable.Map<String, String> fromTrainingJob$default$8() {
        return SageMakerModel$.MODULE$.fromTrainingJob$default$8();
    }

    public static SageMakerModel fromTrainingJob(String string, String string2, String string3, String string4, int n, RequestRowSerializer requestRowSerializer, ResponseRowDeserializer responseRowDeserializer, scala.collection.immutable.Map<String, String> map, Enumeration.Value value, AmazonSageMaker amazonSageMaker, boolean bl, NamePolicy namePolicy, String string5) {
        return SageMakerModel$.MODULE$.fromTrainingJob(string, string2, string3, string4, n, requestRowSerializer, responseRowDeserializer, map, value, amazonSageMaker, bl, namePolicy, string5);
    }

    public static void EndpointPollInterval_$eq(Duration duration) {
        SageMakerModel$.MODULE$.EndpointPollInterval_$eq(duration);
    }

    public static Duration EndpointPollInterval() {
        return SageMakerModel$.MODULE$.EndpointPollInterval();
    }

    public static void EndpointCreationTimeout_$eq(Duration duration) {
        SageMakerModel$.MODULE$.EndpointCreationTimeout_$eq(duration);
    }

    public static Duration EndpointCreationTimeout() {
        return SageMakerModel$.MODULE$.EndpointCreationTimeout();
    }

    public Option<String> endpointInstanceType() {
        return this.endpointInstanceType;
    }

    public Option<Object> endpointInitialInstanceCount() {
        return this.endpointInitialInstanceCount;
    }

    public RequestRowSerializer requestRowSerializer() {
        return this.requestRowSerializer;
    }

    public ResponseRowDeserializer responseRowDeserializer() {
        return this.responseRowDeserializer;
    }

    public Option<String> existingEndpointName() {
        return this.existingEndpointName;
    }

    public Option<String> modelImage() {
        return this.modelImage;
    }

    public Option<S3DataPath> modelPath() {
        return this.modelPath;
    }

    public scala.collection.immutable.Map<String, String> modelEnvironmentVariables() {
        return this.modelEnvironmentVariables;
    }

    public Option<String> modelExecutionRoleARN() {
        return this.modelExecutionRoleARN;
    }

    public Enumeration.Value endpointCreationPolicy() {
        return this.endpointCreationPolicy;
    }

    public AmazonSageMaker sagemakerClient() {
        return this.sagemakerClient;
    }

    public boolean prependResultRows() {
        return this.prependResultRows;
    }

    public NamePolicy namePolicy() {
        return this.namePolicy;
    }

    public String uid() {
        return this.uid;
    }

    public TimeProvider timeProvider() {
        return this.timeProvider;
    }

    public void timeProvider_$eq(TimeProvider x$1) {
        this.timeProvider = x$1;
    }

    private Option<String> createdModelName() {
        return this.createdModelName;
    }

    private void createdModelName_$eq(Option<String> x$1) {
        this.createdModelName = x$1;
    }

    private Option<String> createdEndpointConfigName() {
        return this.createdEndpointConfigName;
    }

    private void createdEndpointConfigName_$eq(Option<String> x$1) {
        this.createdEndpointConfigName = x$1;
    }

    private Option<String> createdEndpointName() {
        return this.createdEndpointName;
    }

    private void createdEndpointName_$eq(Option<String> x$1) {
        this.createdEndpointName = x$1;
    }

    public Option<String> endpointName() {
        if (this.existingEndpointName().isEmpty() && this.createdEndpointName().isEmpty()) {
            return None$.MODULE$;
        }
        return new Some(this.existingEndpointName().getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)this.createdEndpointName().get()));
    }

    private void createSageMakerHostingResources() {
        long startingEndpointCreationTime = this.timeProvider().currentTimeMillis();
        try {
            try {
                this.createdModelName_$eq((Option<String>)Option$.MODULE$.apply((Object)this.createModel()));
                this.createdEndpointConfigName_$eq((Option<String>)Option$.MODULE$.apply((Object)this.createEndpointConfig()));
                this.createdEndpointName_$eq((Option<String>)Option$.MODULE$.apply((Object)this.createEndpoint()));
                this.awaitEndpointCompletion((String)this.createdEndpointName().get());
            }
            catch (Throwable t) {
                throw new SageMakerSparkSDKException("SageMaker resource creation failed.", t, this.getCreatedResources());
            }
        }
        finally {
            long endpointCreationTime = this.timeProvider().getElapsedTimeInSeconds(startingEndpointCreationTime);
            this.log().info(new StringBuilder(26).append("Endpoint Creation Time: ").append(endpointCreationTime).append(" s").toString());
        }
    }

    public CreatedResources getCreatedResources() {
        return new CreatedResources(this.createdModelName(), this.createdEndpointConfigName(), this.endpointName());
    }

    private String createModel() {
        String modelName = this.namePolicy().modelName();
        ContainerDefinition containerDefinition = new ContainerDefinition().withContainerHostname(modelName).withImage((String)this.modelImage().get()).withEnvironment((Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.modelEnvironmentVariables()).asJava()).withModelDataUrl(((S3DataPath)this.modelPath().get()).toS3UriString());
        CreateModelRequest request = new CreateModelRequest().withModelName(modelName).withPrimaryContainer(containerDefinition).withExecutionRoleArn((String)this.modelExecutionRoleARN().orNull(Predef$.MODULE$.$conforms()));
        InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)request);
        this.log().info(new StringBuilder(22).append("Create model request: ").append(request.toString()).toString());
        this.sagemakerClient().createModel(request);
        this.log().info(new StringBuilder(14).append("Created model ").append(modelName).toString());
        return modelName;
    }

    private final String VariantName() {
        return "AllRequests";
    }

    private String createEndpointConfig() {
        String endpointConfigName = this.namePolicy().endpointConfigName();
        ProductionVariant productionVariant = new ProductionVariant().withModelName(this.namePolicy().modelName()).withInstanceType((String)this.endpointInstanceType().get()).withInitialInstanceCount(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)this.endpointInitialInstanceCount().get()))).withVariantName("AllRequests");
        CreateEndpointConfigRequest request = new CreateEndpointConfigRequest().withEndpointConfigName(endpointConfigName).withProductionVariants(new ProductionVariant[]{productionVariant}).withEndpointConfigName(this.namePolicy().endpointConfigName());
        InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)request);
        this.log().info(new StringBuilder(31).append("Create EndpointConfig request: ").append(request.toString()).toString());
        this.sagemakerClient().createEndpointConfig(request);
        this.log().info(new StringBuilder(24).append("Created endpoint config ").append(endpointConfigName).toString());
        return endpointConfigName;
    }

    private String createEndpoint() {
        String endpointName = this.namePolicy().endpointName();
        CreateEndpointRequest request = new CreateEndpointRequest().withEndpointConfigName(this.namePolicy().endpointConfigName()).withEndpointName(endpointName);
        InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)request);
        this.log().info(new StringBuilder(25).append("Create Endpoint request: ").append(request.toString()).toString());
        this.sagemakerClient().createEndpoint(request);
        this.log().info(new StringBuilder(17).append("Created endpoint ").append(endpointName).toString());
        return endpointName;
    }

    private void awaitEndpointCompletion(String endpointName) {
        long startTime = this.timeProvider().currentTimeMillis();
        DescribeEndpointRequest describeEndpointRequest = new DescribeEndpointRequest().withEndpointName(endpointName);
        InternalUtils$.MODULE$.applyUserAgent((AmazonWebServiceRequest)describeEndpointRequest);
        this.log().info(new StringBuilder(51).append("Begin waiting for endpoint completion for endpoint ").append(endpointName).toString());
        while (this.timeProvider().currentTimeMillis() - startTime < SageMakerModel$.MODULE$.EndpointCreationTimeout().toMillis()) {
            try {
                DescribeEndpointResult response = this.sagemakerClient().describeEndpoint(describeEndpointRequest);
                EndpointStatus currentStatus = EndpointStatus.fromValue((String)response.getEndpointStatus());
                this.log().info(new StringBuilder(26).append("Endpoint creation status: ").append(currentStatus).toString());
                EndpointStatus endpointStatus = currentStatus;
                if (EndpointStatus.InService.equals(endpointStatus)) {
                    return;
                }
                if (EndpointStatus.Failed.equals(endpointStatus)) {
                    String message = new StringBuilder(33).append("Endpoint '").append(endpointName).append("' failed for reason:").append(" '").append(response.getFailureReason()).append("'").toString();
                    throw new RuntimeException(message);
                }
            }
            catch (SdkBaseException e) {
                if (!RetryUtils.isRetryableServiceException((SdkBaseException)e)) {
                    throw e;
                }
                this.log().warn(new StringBuilder(21).append("Retryable exception: ").append(e.getMessage()).toString());
            }
            catch (Throwable t) {
                throw t;
            }
            this.timeProvider().sleep(SageMakerModel$.MODULE$.EndpointPollInterval().toMillis());
        }
        throw new RuntimeException(new StringBuilder(66).append("Timed out after ").append(SageMakerModel$.MODULE$.EndpointCreationTimeout().toString()).append(" while waiting for Endpoint '").append(endpointName).append("' to finish creating.").toString());
    }

    public Dataset<Row> transform(Dataset<?> dataset) {
        Enumeration.Value value = this.endpointCreationPolicy();
        Enumeration.Value value2 = EndpointCreationPolicy$.MODULE$.CREATE_ON_TRANSFORM();
        if (!(value != null ? !value.equals(value2) : value2 != null) && this.endpointName().isEmpty()) {
            this.createSageMakerHostingResources();
        }
        Dataset dataFrame = dataset.toDF();
        this.requestRowSerializer().setSchema(dataFrame.schema());
        StructType resultSchema = this.transformSchema(dataFrame.schema());
        Predef$.MODULE$.require(this.endpointName().nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Endpoint name is empty. Create an endpoint to set the endpoint name.");
        Dataset resultDF = dataFrame.mapPartitions(RequestBatchIteratorFactory$.MODULE$.createRequestBatchIterator((String)this.endpointName().get(), this.requestRowSerializer(), this.responseRowDeserializer(), this.prependResultRows()), (Encoder)RowEncoder$.MODULE$.apply(resultSchema));
        return resultDF;
    }

    @DeveloperApi
    public StructType transformSchema(StructType schema) {
        this.requestRowSerializer().validateSchema(schema);
        if (this.prependResultRows()) {
            return new StructType((StructField[])((Seq)schema.$plus$plus((GenTraversableOnce)this.responseRowDeserializer().schema(), Seq$.MODULE$.canBuildFrom())).seq().toArray(ClassTag$.MODULE$.apply(StructField.class)));
        }
        return this.responseRowDeserializer().schema();
    }

    public SageMakerModel copy(ParamMap extra) {
        SageMakerModel that = (SageMakerModel)((Object)this.getClass().getConstructor(Option.class, Option.class, RequestRowSerializer.class, ResponseRowDeserializer.class, Option.class, Option.class, Option.class, scala.collection.immutable.Map.class, Option.class, Enumeration.Value.class, AmazonSageMaker.class, Boolean.TYPE, NamePolicy.class, String.class).newInstance(this.endpointInstanceType(), this.endpointInitialInstanceCount(), this.requestRowSerializer(), this.responseRowDeserializer(), this.endpointName(), this.modelImage(), this.modelPath(), this.modelEnvironmentVariables(), this.modelExecutionRoleARN(), EndpointCreationPolicy$.MODULE$.DO_NOT_CREATE(), this.sagemakerClient(), BoxesRunTime.boxToBoolean((boolean)this.prependResultRows()), this.namePolicy(), this.uid()));
        return (SageMakerModel)this.copyValues((Params)that, extra);
    }

    public SageMakerModel(Option<String> endpointInstanceType, Option<Object> endpointInitialInstanceCount, RequestRowSerializer requestRowSerializer, ResponseRowDeserializer responseRowDeserializer, Option<String> existingEndpointName, Option<String> modelImage, Option<S3DataPath> modelPath, scala.collection.immutable.Map<String, String> modelEnvironmentVariables, Option<String> modelExecutionRoleARN, Enumeration.Value endpointCreationPolicy, AmazonSageMaker sagemakerClient, boolean prependResultRows, NamePolicy namePolicy, String uid) {
        block1: {
            this.endpointInstanceType = endpointInstanceType;
            this.endpointInitialInstanceCount = endpointInitialInstanceCount;
            this.requestRowSerializer = requestRowSerializer;
            this.responseRowDeserializer = responseRowDeserializer;
            this.existingEndpointName = existingEndpointName;
            this.modelImage = modelImage;
            this.modelPath = modelPath;
            this.modelEnvironmentVariables = modelEnvironmentVariables;
            this.modelExecutionRoleARN = modelExecutionRoleARN;
            this.endpointCreationPolicy = endpointCreationPolicy;
            this.sagemakerClient = sagemakerClient;
            this.prependResultRows = prependResultRows;
            this.namePolicy = namePolicy;
            this.uid = uid;
            if (existingEndpointName.nonEmpty()) {
                Enumeration.Value value = endpointCreationPolicy;
                Enumeration.Value value2 = EndpointCreationPolicy$.MODULE$.DO_NOT_CREATE();
                Predef$.MODULE$.require(!(value != null ? !value.equals(value2) : value2 != null), (Function0 & Serializable & scala.Serializable)() -> "SageMakerModel's endpoint creation policy must be DO_NOT_CREATE if creating an SageMakerModel from an existing endpoint.");
            }
            this.timeProvider = new SystemTimeProvider();
            this.createdModelName = Option$.MODULE$.empty();
            this.createdEndpointConfigName = Option$.MODULE$.empty();
            this.createdEndpointName = Option$.MODULE$.empty();
            Enumeration.Value value = endpointCreationPolicy;
            Enumeration.Value value3 = EndpointCreationPolicy$.MODULE$.CREATE_ON_CONSTRUCT();
            if (value != null ? !value.equals(value3) : value3 != null) break block1;
            this.createSageMakerHostingResources();
        }
    }
}

