/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.commit;

import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3a.S3AFileSystem;
import org.apache.hadoop.fs.s3a.Statistic;
import org.apache.hadoop.fs.s3a.commit.MagicCommitPaths;
import org.apache.hadoop.fs.s3a.commit.PutTracker;
import org.apache.hadoop.fs.s3a.commit.magic.MagicCommitTracker;
import org.apache.hadoop.fs.s3a.impl.StoreContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagicCommitIntegration {
    private static final Logger LOG = LoggerFactory.getLogger(MagicCommitIntegration.class);
    private final S3AFileSystem owner;
    private final boolean magicCommitEnabled;
    private final StoreContext storeContext;

    public MagicCommitIntegration(S3AFileSystem owner, boolean magicCommitEnabled) {
        this.owner = owner;
        this.magicCommitEnabled = magicCommitEnabled;
        this.storeContext = owner.createStoreContext();
    }

    public String keyOfFinalDestination(List<String> elements, String key) {
        if (this.isMagicCommitPath(elements)) {
            return MagicCommitPaths.elementsToKey(this.finalDestination(elements));
        }
        return key;
    }

    public PutTracker createTracker(Path path, String key) {
        PutTracker tracker;
        List<String> elements = MagicCommitPaths.splitPathToElements(path);
        if (this.isMagicFile(elements)) {
            if (this.isMagicCommitPath(elements)) {
                String destKey = this.keyOfFinalDestination(elements, key);
                String pendingsetPath = key + ".pending";
                this.storeContext.incrementStatistic(Statistic.COMMITTER_MAGIC_FILES_CREATED);
                tracker = new MagicCommitTracker(path, this.storeContext.getBucket(), key, destKey, pendingsetPath, this.owner.getWriteOperationHelper());
                LOG.debug("Created {}", (Object)tracker);
            } else {
                LOG.warn("File being created has a \"magic\" path, but the filesystem has magic file support disabled: {}", (Object)path);
                tracker = new PutTracker(key);
            }
        } else {
            tracker = new PutTracker(key);
        }
        return tracker;
    }

    private List<String> finalDestination(List<String> elements) {
        return this.magicCommitEnabled ? MagicCommitPaths.finalDestination(elements) : elements;
    }

    public boolean isMagicCommitEnabled() {
        return this.magicCommitEnabled;
    }

    public boolean isMagicCommitPath(Path path) {
        return this.isMagicCommitPath(MagicCommitPaths.splitPathToElements(path));
    }

    private boolean isMagicCommitPath(List<String> elements) {
        return this.magicCommitEnabled && this.isMagicFile(elements);
    }

    private boolean isMagicFile(List<String> elements) {
        return MagicCommitPaths.isMagicPath(elements) && !this.isCommitMetadataFile(elements);
    }

    private boolean isCommitMetadataFile(List<String> elements) {
        String last = elements.get(elements.size() - 1);
        return last.endsWith(".pending") || last.endsWith(".pendingset");
    }
}

