# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['generator']

package_data = \
{'': ['*']}

install_requires = \
['GitPython>=3.1.27,<4.0.0', 'python-hcl2>=3.0.5,<4.0.0']

entry_points = \
{'console_scripts': ['terragrunt-generator = generator.main:main']}

setup_kwargs = {
    'name': 'terragrunt-generator',
    'version': '0.5.4',
    'description': '',
    'long_description': '# terragrunt-generator\n\n**terragrunt-generator** provide a way to generate a ```terragrunt.hcl``` file with documented inputs who\'s coming from variables exposed by terraform module.\n\nThe result is easily configurable with a **yaml** file.\n## Requirements\n\n- python3.6+\n\n## Instalation\n\n```\n$ pip install terragrunt-generator\n```\n\n## Example\n\n```\n$ terragrunt-generator -u https://github.com/terraform-google-modules/terraform-google-project-factory.git -v v13.1.0\n# terraform-google-project-factory v13.1.0\n#\n# yaml config\n# ```\n# terraform-google-project-factory:\n#   enabled: true\n#   random_project_id: false\n#   org_id:\n#   domain: ""\n#   name:\n#   project_id: ""\n#   svpc_host_project_id: ""\n#   enable_shared_vpc_host_project: false\n#   billing_account:\n#   folder_id: ""\n#   group_name: ""\n#   group_role: "roles/editor"\n#   create_project_sa: true\n#   project_sa_name: "project-service-account"\n#   sa_role: ""\n#   activate_apis: ["compute.googleapis.com"]\n#   activate_api_identities: []\n#   usage_bucket_name: ""\n#   usage_bucket_prefix: ""\n#   shared_vpc_subnets: []\n#   labels: {}\n#   bucket_project: ""\n#   bucket_name: ""\n#   bucket_location: "US"\n#   bucket_versioning: false\n#   bucket_labels: {}\n#   bucket_force_destroy: false\n#   bucket_ula: true\n#   bucket_pap: "inherited"\n#   auto_create_network: false\n#   lien: false\n#   disable_services_on_destroy: true\n#   default_service_account: "disable"\n#   disable_dependent_services: true\n#   budget_amount:\n#   budget_display_name:\n#   budget_alert_pubsub_topic:\n#   budget_monitoring_notification_channels: []\n#   budget_alert_spent_percents: [0.5, 0.7, 1.0]\n#   budget_alert_spend_basis: "CURRENT_SPEND"\n#   budget_labels: {}\n#   vpc_service_control_attach_enabled: false\n#   vpc_service_control_perimeter_name:\n#   grant_services_security_admin_role: false\n#   grant_network_role: true\n#   consumer_quotas: []\n#   default_network_tier: ""\n#   essential_contacts: {}\n#   language_tag: "en-US"\n# ```\n#\ninclude {\n    path = "${{find_in_parent_folders()}}"\n}\n\nlocals {\n    all = merge(\n        yamldecode(file(find_in_parent_folders("config.yaml"))),\n    )\n}\n\nterraform {\n    source = lookup(local.all["terraform-google-project-factory"], "enabled", true) == true ? "https://github.com/terraform-google-modules/terraform-google-project-factory.git?ref=v13.1.0" : null\n}\n\ninputs = merge({\n    # billing_account - The ID of the billing account to associate this project with - required\n    billing_account = lookup(local.all["terraform-google-project-factory"], "billing_account", "None")\n    # name - The name for the project - required\n    name = lookup(local.all["terraform-google-project-factory"], "name", "None")\n    # org_id - The organization ID. - required\n    org_id = lookup(local.all["terraform-google-project-factory"], "org_id", "None")\n    # activate_api_identities - The list of service identities (Google Managed service account for the API) to force-create for the project (e.g. in order to grant additional roles).\n    #    APIs in this list will automatically be appended to `activate_apis`.\n    #    Not including the API in this list will follow the default behaviour for identity creation (which is usually when the first resource using the API is created).\n    #    Any roles (e.g. service agent role) must be explicitly listed. See https://cloud.google.com/iam/docs/understanding-roles#service-agent-roles-roles for a list of related roles.\n    activate_api_identities = lookup(local.all["terraform-google-project-factory"], "activate_api_identities", [])\n    # activate_apis - The list of apis to activate within the project\n    activate_apis = lookup(local.all["terraform-google-project-factory"], "activate_apis", ["compute.googleapis.com"])\n    # auto_create_network - Create the default network\n    auto_create_network = lookup(local.all["terraform-google-project-factory"], "auto_create_network", false)\n    # bucket_force_destroy - Force the deletion of all objects within the GCS bucket when deleting the bucket (optional)\n    bucket_force_destroy = lookup(local.all["terraform-google-project-factory"], "bucket_force_destroy", false)\n    # bucket_labels -  A map of key/value label pairs to assign to the bucket (optional)\n    bucket_labels = lookup(local.all["terraform-google-project-factory"], "bucket_labels", {})\n    # bucket_location - The location for a GCS bucket to create (optional)\n    bucket_location = lookup(local.all["terraform-google-project-factory"], "bucket_location", "US")\n    # bucket_name - A name for a GCS bucket to create (in the bucket_project project), useful for Terraform state (optional)\n    bucket_name = lookup(local.all["terraform-google-project-factory"], "bucket_name", "")\n    # bucket_pap - Enable Public Access Prevention. Possible values are "enforced" or "inherited".\n    bucket_pap = lookup(local.all["terraform-google-project-factory"], "bucket_pap", "inherited")\n    # bucket_project - A project to create a GCS bucket (bucket_name) in, useful for Terraform state (optional)\n    bucket_project = lookup(local.all["terraform-google-project-factory"], "bucket_project", "")\n    # bucket_ula - Enable Uniform Bucket Level Access\n    bucket_ula = lookup(local.all["terraform-google-project-factory"], "bucket_ula", true)\n    # bucket_versioning - Enable versioning for a GCS bucket to create (optional)\n    bucket_versioning = lookup(local.all["terraform-google-project-factory"], "bucket_versioning", false)\n    # budget_alert_spend_basis - The type of basis used to determine if spend has passed the threshold\n    budget_alert_spend_basis = lookup(local.all["terraform-google-project-factory"], "budget_alert_spend_basis", "CURRENT_SPEND")\n    # budget_alert_spent_percents - A list of percentages of the budget to alert on when threshold is exceeded\n    budget_alert_spent_percents = lookup(local.all["terraform-google-project-factory"], "budget_alert_spent_percents", [0.5, 0.7, 1.0])\n    # budget_labels - A single label and value pair specifying that usage from only this set of labeled resources should be included in the budget.\n    budget_labels = lookup(local.all["terraform-google-project-factory"], "budget_labels", {})\n    # budget_monitoring_notification_channels - A list of monitoring notification channels in the form `[projects/{project_id}/notificationChannels/{channel_id}]`. A maximum of 5 channels are allowed.\n    budget_monitoring_notification_channels = lookup(local.all["terraform-google-project-factory"], "budget_monitoring_notification_channels", [])\n    # consumer_quotas - The quotas configuration you want to override for the project.\n    consumer_quotas = lookup(local.all["terraform-google-project-factory"], "consumer_quotas", [])\n    # create_project_sa - Whether the default service account for the project shall be created\n    create_project_sa = lookup(local.all["terraform-google-project-factory"], "create_project_sa", true)\n    # default_network_tier - Default Network Service Tier for resources created in this project. If unset, the value will not be modified. See https://cloud.google.com/network-tiers/docs/using-network-service-tiers and https://cloud.google.com/network-tiers.\n    default_network_tier = lookup(local.all["terraform-google-project-factory"], "default_network_tier", "")\n    # default_service_account - Project default service account setting: can be one of `delete`, `deprivilege`, `disable`, or `keep`.\n    default_service_account = lookup(local.all["terraform-google-project-factory"], "default_service_account", "disable")\n    # disable_dependent_services - Whether services that are enabled and which depend on this service should also be disabled when this service is destroyed.\n    disable_dependent_services = lookup(local.all["terraform-google-project-factory"], "disable_dependent_services", true)\n    # disable_services_on_destroy - Whether project services will be disabled when the resources are destroyed\n    disable_services_on_destroy = lookup(local.all["terraform-google-project-factory"], "disable_services_on_destroy", true)\n    # domain - The domain name (optional).\n    domain = lookup(local.all["terraform-google-project-factory"], "domain", "")\n    # enable_shared_vpc_host_project - If this project is a shared VPC host project. If true, you must *not* set svpc_host_project_id variable. Default is false.\n    enable_shared_vpc_host_project = lookup(local.all["terraform-google-project-factory"], "enable_shared_vpc_host_project", false)\n    # essential_contacts - A mapping of users or groups to be assigned as Essential Contacts to the project, specifying a notification category\n    essential_contacts = lookup(local.all["terraform-google-project-factory"], "essential_contacts", {})\n    # folder_id - The ID of a folder to host this project\n    folder_id = lookup(local.all["terraform-google-project-factory"], "folder_id", "")\n    # grant_network_role - Whether or not to grant networkUser role on the host project/subnets\n    grant_network_role = lookup(local.all["terraform-google-project-factory"], "grant_network_role", true)\n    # grant_services_security_admin_role - Whether or not to grant Kubernetes Engine Service Agent the Security Admin role on the host project so it can manage firewall rules\n    grant_services_security_admin_role = lookup(local.all["terraform-google-project-factory"], "grant_services_security_admin_role", false)\n    # group_name - A group to control the project by being assigned group_role (defaults to project editor)\n    group_name = lookup(local.all["terraform-google-project-factory"], "group_name", "")\n    # group_role - The role to give the controlling group (group_name) over the project (defaults to project editor)\n    group_role = lookup(local.all["terraform-google-project-factory"], "group_role", "roles/editor")\n    # labels - Map of labels for project\n    labels = lookup(local.all["terraform-google-project-factory"], "labels", {})\n    # language_tag - Language code to be used for essential contacts notifications\n    language_tag = lookup(local.all["terraform-google-project-factory"], "language_tag", "en-US")\n    # lien - Add a lien on the project to prevent accidental deletion\n    lien = lookup(local.all["terraform-google-project-factory"], "lien", false)\n    # project_id - The ID to give the project. If not provided, the `name` will be used.\n    project_id = lookup(local.all["terraform-google-project-factory"], "project_id", "")\n    # project_sa_name - Default service account name for the project.\n    project_sa_name = lookup(local.all["terraform-google-project-factory"], "project_sa_name", "project-service-account")\n    # random_project_id - Adds a suffix of 4 random characters to the `project_id`\n    random_project_id = lookup(local.all["terraform-google-project-factory"], "random_project_id", false)\n    # sa_role - A role to give the default Service Account for the project (defaults to none)\n    sa_role = lookup(local.all["terraform-google-project-factory"], "sa_role", "")\n    # shared_vpc_subnets - List of subnets fully qualified subnet IDs (ie. projects/$project_id/regions/$region/subnetworks/$subnet_id)\n    shared_vpc_subnets = lookup(local.all["terraform-google-project-factory"], "shared_vpc_subnets", [])\n    # svpc_host_project_id - The ID of the host project which hosts the shared VPC\n    svpc_host_project_id = lookup(local.all["terraform-google-project-factory"], "svpc_host_project_id", "")\n    # usage_bucket_name - Name of a GCS bucket to store GCE usage reports in (optional)\n    usage_bucket_name = lookup(local.all["terraform-google-project-factory"], "usage_bucket_name", "")\n    # usage_bucket_prefix - Prefix in the GCS bucket to store GCE usage reports in (optional)\n    usage_bucket_prefix = lookup(local.all["terraform-google-project-factory"], "usage_bucket_prefix", "")\n    # vpc_service_control_attach_enabled - Whether the project will be attached to a VPC Service Control Perimeter\n    vpc_service_control_attach_enabled = lookup(local.all["terraform-google-project-factory"], "vpc_service_control_attach_enabled", false)\n\n},\n  # budget_alert_pubsub_topic - Enable versioning for a GCS bucket to create (optional)\n  (lookup(local.all["terraform-google-project-factory"], "budget_alert_pubsub_topic", null) == null ? {} : { budget_alert_pubsub_topic =  lookup(local.all["terraform-google-project-factory"], "budget_alert_pubsub_topic") }),\n  # budget_amount - A list of percentages of the budget to alert on when threshold is exceeded\n  (lookup(local.all["terraform-google-project-factory"], "budget_amount", null) == null ? {} : { budget_amount =  lookup(local.all["terraform-google-project-factory"], "budget_amount") }),\n  # budget_display_name - A list of percentages of the budget to alert on when threshold is exceeded\n  (lookup(local.all["terraform-google-project-factory"], "budget_display_name", null) == null ? {} : { budget_display_name =  lookup(local.all["terraform-google-project-factory"], "budget_display_name") }),\n  # vpc_service_control_perimeter_name - Whether the project will be attached to a VPC Service Control Perimeter\n  (lookup(local.all["terraform-google-project-factory"], "vpc_service_control_perimeter_name", null) == null ? {} : { vpc_service_control_perimeter_name =  lookup(local.all["terraform-google-project-factory"], "vpc_service_control_perimeter_name") })\n)\n\n```\n',
    'author': 'Chris',
    'author_email': 'goabonga@pm.me',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
