# -*- coding: utf-8 -*-
#
# SOMA - Copyright (C) CEA, 2015
# Distributed under the terms of the CeCILL-B license, as published by
# the CEA-CNRS-INRIA. Refer to the LICENSE file or to
# http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.html
# for details.
#

# Soma import
from .Str import StrControlWidget
from .Bytes import BytesControlWidget
from .Float import FloatControlWidget
from .Int import IntControlWidget
from .Enum import EnumControlWidget
from .List import ListControlWidget
from .List_offscreen import OffscreenListControlWidget
from .List_File_offscreen import OffscreenListFileControlWidget
from .Bool import BoolControlWidget
from .File import FileControlWidget
from .Directory import DirectoryControlWidget
from .Dict import DictControlWidget
from .Controller import ControllerControlWidget
from .Compound import CompoundControlWidget
from .non_editable import NonEditableControlWidget

import sys

# Define a structure that will contain the mapping between the string trait
# descriptions and the associated control classes
controls = {}


def range_editor(trait):
    t = type(trait.default)
    if t is int:
        return IntControlWidget
    if sys.version_info[0] >= 3:
        long = int  # this is only a trick to fool flake8
    elif t is long:
        return IntControlWidget
    return FloatControlWidget


# Register all control class
controls["Str"] = StrControlWidget
controls["Unicode"] = StrControlWidget
controls["Bytes"] = BytesControlWidget
controls["String"] = StrControlWidget
controls["Any"] = StrControlWidget
controls["Float"] = FloatControlWidget
controls["Int"] = IntControlWidget
controls["Enum"] = EnumControlWidget
controls["Bool"] = BoolControlWidget
controls["File"] = FileControlWidget
controls["Directory"] = DirectoryControlWidget
controls["List"] = ListControlWidget
controls["Instance"] = ControllerControlWidget
controls["TraitInstance"] = ControllerControlWidget
controls["ControllerTrait"] = ControllerControlWidget
controls["Dict"] = DictControlWidget
controls["Compound"] = CompoundControlWidget
controls["List_File"] = OffscreenListFileControlWidget
controls["Range"] = range_editor
controls["unknown"] = NonEditableControlWidget
controls["Undefined"] = NonEditableControlWidget
# nipype types
controls["ImageFileSPM"] = FileControlWidget
