"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""
import builtins
import collections.abc
import feast.core.Entity_pb2
import feast.core.FeatureTable_pb2
import feast.core.Feature_pb2
import feast.core.OnlineStore_pb2
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing

if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class GetEntityRequest(google.protobuf.message.Message):
    """Request for a single entity"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    PROJECT_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of entity (required)."""
    project: builtins.str
    """Name of project the entity belongs to. If omitted will default to 'default' project."""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        project: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "project", b"project"]) -> None: ...

global___GetEntityRequest = GetEntityRequest

class GetEntityResponse(google.protobuf.message.Message):
    """Response containing a single entity"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> feast.core.Entity_pb2.Entity: ...
    def __init__(
        self,
        *,
        entity: feast.core.Entity_pb2.Entity | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> None: ...

global___GetEntityResponse = GetEntityResponse

class ListEntitiesRequest(google.protobuf.message.Message):
    """Retrieves details for all versions of a specific entity"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Filter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class LabelsEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        PROJECT_FIELD_NUMBER: builtins.int
        LABELS_FIELD_NUMBER: builtins.int
        project: builtins.str
        """Optional. Specifies the name of the project to list Entities in.
        It is NOT possible to provide an asterisk with a string in order to do pattern matching.
        If unspecified, this field will default to the default project 'default'.
        """
        @property
        def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """Optional. User defined metadata for entity.
            Entities with all matching labels will be returned.
            """
        def __init__(
            self,
            *,
            project: builtins.str = ...,
            labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["labels", b"labels", "project", b"project"]) -> None: ...

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___ListEntitiesRequest.Filter: ...
    def __init__(
        self,
        *,
        filter: global___ListEntitiesRequest.Filter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> None: ...

global___ListEntitiesRequest = ListEntitiesRequest

class ListEntitiesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITIES_FIELD_NUMBER: builtins.int
    @property
    def entities(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[feast.core.Entity_pb2.Entity]: ...
    def __init__(
        self,
        *,
        entities: collections.abc.Iterable[feast.core.Entity_pb2.Entity] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["entities", b"entities"]) -> None: ...

global___ListEntitiesResponse = ListEntitiesResponse

class ListFeaturesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Filter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class LabelsEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        LABELS_FIELD_NUMBER: builtins.int
        ENTITIES_FIELD_NUMBER: builtins.int
        PROJECT_FIELD_NUMBER: builtins.int
        @property
        def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """User defined metadata for feature.
            Features with all matching labels will be returned.
            """
        @property
        def entities(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
            """List of entities contained within the featureSet that the feature belongs to.
            Only feature tables with these entities will be searched for features.
            """
        project: builtins.str
        """Name of project that the feature tables belongs to. Filtering on projects is disabled. 
        It is NOT possible to provide an asterisk with a string in order to do pattern matching.
        If unspecified this field will default to the default project 'default'.
        """
        def __init__(
            self,
            *,
            labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
            entities: collections.abc.Iterable[builtins.str] | None = ...,
            project: builtins.str = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["entities", b"entities", "labels", b"labels", "project", b"project"]) -> None: ...

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___ListFeaturesRequest.Filter: ...
    def __init__(
        self,
        *,
        filter: global___ListFeaturesRequest.Filter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> None: ...

global___ListFeaturesRequest = ListFeaturesRequest

class ListFeaturesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class FeaturesEntry(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        KEY_FIELD_NUMBER: builtins.int
        VALUE_FIELD_NUMBER: builtins.int
        key: builtins.str
        @property
        def value(self) -> feast.core.Feature_pb2.FeatureSpec: ...
        def __init__(
            self,
            *,
            key: builtins.str = ...,
            value: feast.core.Feature_pb2.FeatureSpec | None = ...,
        ) -> None: ...
        def HasField(self, field_name: typing_extensions.Literal["value", b"value"]) -> builtins.bool: ...
        def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

    FEATURES_FIELD_NUMBER: builtins.int
    @property
    def features(self) -> google.protobuf.internal.containers.MessageMap[builtins.str, feast.core.Feature_pb2.FeatureSpec]: ...
    def __init__(
        self,
        *,
        features: collections.abc.Mapping[builtins.str, feast.core.Feature_pb2.FeatureSpec] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["features", b"features"]) -> None: ...

global___ListFeaturesResponse = ListFeaturesResponse

class ApplyEntityRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    SPEC_FIELD_NUMBER: builtins.int
    PROJECT_FIELD_NUMBER: builtins.int
    @property
    def spec(self) -> feast.core.Entity_pb2.EntitySpec:
        """If project is unspecified, will default to 'default' project.
        If project specified does not exist, the project would be automatically created.
        """
    project: builtins.str
    """Name of project that this entity belongs to."""
    def __init__(
        self,
        *,
        spec: feast.core.Entity_pb2.EntitySpec | None = ...,
        project: builtins.str = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["spec", b"spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project", b"project", "spec", b"spec"]) -> None: ...

global___ApplyEntityRequest = ApplyEntityRequest

class ApplyEntityResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ENTITY_FIELD_NUMBER: builtins.int
    @property
    def entity(self) -> feast.core.Entity_pb2.Entity: ...
    def __init__(
        self,
        *,
        entity: feast.core.Entity_pb2.Entity | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["entity", b"entity"]) -> None: ...

global___ApplyEntityResponse = ApplyEntityResponse

class GetFeastCoreVersionRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___GetFeastCoreVersionRequest = GetFeastCoreVersionRequest

class GetFeastCoreVersionResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    VERSION_FIELD_NUMBER: builtins.int
    version: builtins.str
    def __init__(
        self,
        *,
        version: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["version", b"version"]) -> None: ...

global___GetFeastCoreVersionResponse = GetFeastCoreVersionResponse

class CreateProjectRequest(google.protobuf.message.Message):
    """Request to create a project"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of project (required)"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___CreateProjectRequest = CreateProjectRequest

class CreateProjectResponse(google.protobuf.message.Message):
    """Response for creation of a project"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___CreateProjectResponse = CreateProjectResponse

class ArchiveProjectRequest(google.protobuf.message.Message):
    """Request for the archival of a project"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of project to be archived"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___ArchiveProjectRequest = ArchiveProjectRequest

class ArchiveProjectResponse(google.protobuf.message.Message):
    """Response for archival of a project"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ArchiveProjectResponse = ArchiveProjectResponse

class ListProjectsRequest(google.protobuf.message.Message):
    """Request for listing of projects"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListProjectsRequest = ListProjectsRequest

class ListProjectsResponse(google.protobuf.message.Message):
    """Response for listing of projects"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECTS_FIELD_NUMBER: builtins.int
    @property
    def projects(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]:
        """List of project names (archived projects are filtered out)"""
    def __init__(
        self,
        *,
        projects: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["projects", b"projects"]) -> None: ...

global___ListProjectsResponse = ListProjectsResponse

class ApplyFeatureTableRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_FIELD_NUMBER: builtins.int
    TABLE_SPEC_FIELD_NUMBER: builtins.int
    project: builtins.str
    """Optional. Name of the Project to apply the Feature Table to.
    If unspecified, will apply FeatureTable to the default project.
    """
    @property
    def table_spec(self) -> feast.core.FeatureTable_pb2.FeatureTableSpec:
        """Feature Table specification to apply"""
    def __init__(
        self,
        *,
        project: builtins.str = ...,
        table_spec: feast.core.FeatureTable_pb2.FeatureTableSpec | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table_spec", b"table_spec"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["project", b"project", "table_spec", b"table_spec"]) -> None: ...

global___ApplyFeatureTableRequest = ApplyFeatureTableRequest

class ApplyFeatureTableResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_FIELD_NUMBER: builtins.int
    @property
    def table(self) -> feast.core.FeatureTable_pb2.FeatureTable: ...
    def __init__(
        self,
        *,
        table: feast.core.FeatureTable_pb2.FeatureTable | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["table", b"table"]) -> None: ...

global___ApplyFeatureTableResponse = ApplyFeatureTableResponse

class GetFeatureTableRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    project: builtins.str
    """Optional. Name of the Project to retrieve the Feature Table from.
    If unspecified, will apply FeatureTable to the default project.
    """
    name: builtins.str
    """Name of the FeatureTable to retrieve."""
    def __init__(
        self,
        *,
        project: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "project", b"project"]) -> None: ...

global___GetFeatureTableRequest = GetFeatureTableRequest

class GetFeatureTableResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLE_FIELD_NUMBER: builtins.int
    @property
    def table(self) -> feast.core.FeatureTable_pb2.FeatureTable:
        """The Feature Table retrieved."""
    def __init__(
        self,
        *,
        table: feast.core.FeatureTable_pb2.FeatureTable | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["table", b"table"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["table", b"table"]) -> None: ...

global___GetFeatureTableResponse = GetFeatureTableResponse

class ListFeatureTablesRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class Filter(google.protobuf.message.Message):
        DESCRIPTOR: google.protobuf.descriptor.Descriptor

        class LabelsEntry(google.protobuf.message.Message):
            DESCRIPTOR: google.protobuf.descriptor.Descriptor

            KEY_FIELD_NUMBER: builtins.int
            VALUE_FIELD_NUMBER: builtins.int
            key: builtins.str
            value: builtins.str
            def __init__(
                self,
                *,
                key: builtins.str = ...,
                value: builtins.str = ...,
            ) -> None: ...
            def ClearField(self, field_name: typing_extensions.Literal["key", b"key", "value", b"value"]) -> None: ...

        PROJECT_FIELD_NUMBER: builtins.int
        LABELS_FIELD_NUMBER: builtins.int
        project: builtins.str
        """Optional. Specifies the name of the project to list Feature Tables in.
        If unspecified would list Feature Tables in the default project.
        """
        @property
        def labels(self) -> google.protobuf.internal.containers.ScalarMap[builtins.str, builtins.str]:
            """Optional. Feature Tables with all matching labels will be returned.
            If unspecified would list Feature Tables without filtering by labels.
            """
        def __init__(
            self,
            *,
            project: builtins.str = ...,
            labels: collections.abc.Mapping[builtins.str, builtins.str] | None = ...,
        ) -> None: ...
        def ClearField(self, field_name: typing_extensions.Literal["labels", b"labels", "project", b"project"]) -> None: ...

    FILTER_FIELD_NUMBER: builtins.int
    @property
    def filter(self) -> global___ListFeatureTablesRequest.Filter:
        """Filter used when listing Feature Tables"""
    def __init__(
        self,
        *,
        filter: global___ListFeatureTablesRequest.Filter | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["filter", b"filter"]) -> None: ...

global___ListFeatureTablesRequest = ListFeatureTablesRequest

class ListFeatureTablesResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TABLES_FIELD_NUMBER: builtins.int
    @property
    def tables(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[feast.core.FeatureTable_pb2.FeatureTable]:
        """List of matching Feature Tables"""
    def __init__(
        self,
        *,
        tables: collections.abc.Iterable[feast.core.FeatureTable_pb2.FeatureTable] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["tables", b"tables"]) -> None: ...

global___ListFeatureTablesResponse = ListFeatureTablesResponse

class DeleteFeatureTableRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PROJECT_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    project: builtins.str
    """Optional. Name of the Project to delete the Feature Table from.
    If unspecified, will delete FeatureTable from the default project.
    """
    name: builtins.str
    """Name of the FeatureTable to delete."""
    def __init__(
        self,
        *,
        project: builtins.str = ...,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name", "project", b"project"]) -> None: ...

global___DeleteFeatureTableRequest = DeleteFeatureTableRequest

class DeleteFeatureTableResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___DeleteFeatureTableResponse = DeleteFeatureTableResponse

class ListOnlineStoresRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ListOnlineStoresRequest = ListOnlineStoresRequest

class ListOnlineStoresResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ONLINE_STORE_FIELD_NUMBER: builtins.int
    @property
    def online_store(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[feast.core.OnlineStore_pb2.OnlineStore]: ...
    def __init__(
        self,
        *,
        online_store: collections.abc.Iterable[feast.core.OnlineStore_pb2.OnlineStore] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["online_store", b"online_store"]) -> None: ...

global___ListOnlineStoresResponse = ListOnlineStoresResponse

class GetOnlineStoreRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___GetOnlineStoreRequest = GetOnlineStoreRequest

class GetOnlineStoreResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[GetOnlineStoreResponse._Status.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        ACTIVE: GetOnlineStoreResponse._Status.ValueType  # 0
        """Requested online store is active"""
        ARCHIVED: GetOnlineStoreResponse._Status.ValueType  # 1
        """Requested online store is archived"""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    ACTIVE: GetOnlineStoreResponse.Status.ValueType  # 0
    """Requested online store is active"""
    ARCHIVED: GetOnlineStoreResponse.Status.ValueType  # 1
    """Requested online store is archived"""

    ONLINE_STORE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    @property
    def online_store(self) -> feast.core.OnlineStore_pb2.OnlineStore: ...
    status: global___GetOnlineStoreResponse.Status.ValueType
    def __init__(
        self,
        *,
        online_store: feast.core.OnlineStore_pb2.OnlineStore | None = ...,
        status: global___GetOnlineStoreResponse.Status.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["online_store", b"online_store"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["online_store", b"online_store", "status", b"status"]) -> None: ...

global___GetOnlineStoreResponse = GetOnlineStoreResponse

class RegisterOnlineStoreRequest(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    ONLINE_STORE_FIELD_NUMBER: builtins.int
    @property
    def online_store(self) -> feast.core.OnlineStore_pb2.OnlineStore: ...
    def __init__(
        self,
        *,
        online_store: feast.core.OnlineStore_pb2.OnlineStore | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["online_store", b"online_store"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["online_store", b"online_store"]) -> None: ...

global___RegisterOnlineStoreRequest = RegisterOnlineStoreRequest

class RegisterOnlineStoreResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    class _Status:
        ValueType = typing.NewType("ValueType", builtins.int)
        V: typing_extensions.TypeAlias = ValueType

    class _StatusEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[RegisterOnlineStoreResponse._Status.ValueType], builtins.type):  # noqa: F821
        DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
        NO_CHANGE: RegisterOnlineStoreResponse._Status.ValueType  # 0
        """Existing store properties matching the given online store is identical to the given request"""
        REGISTERED: RegisterOnlineStoreResponse._Status.ValueType  # 1
        """New online store created or existing properties updated."""
        UPDATED: RegisterOnlineStoreResponse._Status.ValueType  # 2
        """Existing online store updated."""

    class Status(_Status, metaclass=_StatusEnumTypeWrapper): ...
    NO_CHANGE: RegisterOnlineStoreResponse.Status.ValueType  # 0
    """Existing store properties matching the given online store is identical to the given request"""
    REGISTERED: RegisterOnlineStoreResponse.Status.ValueType  # 1
    """New online store created or existing properties updated."""
    UPDATED: RegisterOnlineStoreResponse.Status.ValueType  # 2
    """Existing online store updated."""

    ONLINE_STORE_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    @property
    def online_store(self) -> feast.core.OnlineStore_pb2.OnlineStore: ...
    status: global___RegisterOnlineStoreResponse.Status.ValueType
    def __init__(
        self,
        *,
        online_store: feast.core.OnlineStore_pb2.OnlineStore | None = ...,
        status: global___RegisterOnlineStoreResponse.Status.ValueType = ...,
    ) -> None: ...
    def HasField(self, field_name: typing_extensions.Literal["online_store", b"online_store"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing_extensions.Literal["online_store", b"online_store", "status", b"status"]) -> None: ...

global___RegisterOnlineStoreResponse = RegisterOnlineStoreResponse

class ArchiveOnlineStoreRequest(google.protobuf.message.Message):
    """Request for the archival of an online store"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    name: builtins.str
    """Name of online store to be archived"""
    def __init__(
        self,
        *,
        name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing_extensions.Literal["name", b"name"]) -> None: ...

global___ArchiveOnlineStoreRequest = ArchiveOnlineStoreRequest

class ArchiveOnlineStoreResponse(google.protobuf.message.Message):
    """Response for archival of an online store"""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(
        self,
    ) -> None: ...

global___ArchiveOnlineStoreResponse = ArchiveOnlineStoreResponse
