# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['structlog_sentry_logger']

package_data = \
{'': ['*']}

install_requires = \
['gitpython>=3.1.7,<4.0.0',
 'orjson>=3.4.0,<4.0.0',
 'python-dotenv>=0.14.0,<0.15.0',
 'sentry-sdk>0.17.0',
 'structlog-sentry>=1.2.2,<2.0.0',
 'structlog>=20.1.0,<21.0.0']

setup_kwargs = {
    'name': 'structlog-sentry-logger',
    'version': '0.5.0',
    'description': 'Log without the setup via a pre-configured structlog logger with optional Sentry integration',
    'long_description': 'Structlog-Sentry-Logger\n==============================\n![CI](https://github.com/TeoZosa/structlog-sentry-logger/workflows/CI/badge.svg)\n[![codecov](https://codecov.io/gh/TeoZosa/structlog-sentry-logger/branch/master/graph/badge.svg?token=3HF21UWY82)](undefined)\n[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)\n![GitHub](https://img.shields.io/github/license/teozosa/structlog-sentry-logger?style=plastic)\n![PyPI - Python Version](https://img.shields.io/pypi/pyversions/structlog-sentry-logger?style=plastic)\n![PyPI](https://img.shields.io/pypi/v/structlog-sentry-logger?color=informational&style=plastic)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n\nA multi-purpose, pre-configured [`structlog`](https://www.structlog.org/en/stable/) logger\nwith (optional) [Sentry](https://sentry.io/welcome/) integration\nvia [`structlog-sentry`](https://github.com/kiwicom/structlog-sentry).\n\nWhy\n------------\n1. Makes logging as easy as using print statements, but prettier and less smelly!\n2. Highly opinionated! There are only [two (2) distinct configurations](#output-formatting--storage).\n3. Structured logs in JSON format means they are ready to be ingested by many of your\nfavorite log analysis tools!\n\nWhat You Get\n------------\n\n### Powerful Automatic Context Fields\nThe pre-configured options include:\n\n1. Timestamps\n    - `DATETIME_FORMAT = "%Y-%m-%d %H:%M:%S"`\n2. Log levels\n    - Added to the JSON context for filtering and categorization\n3. Logger names\n    - Automatically assigned to namespaced versions of the initializing\npython modules (`.py` files), relative to your project directory.\n        - e.g., the logger in `docs_src/sentry_integration.py` is named `docs_src.sentry_integration`\n\nWith fields sorted by key for easier at-a-glance analysis.\n\n### Performance\n`structlog-sentry-logger` is fully-tuned and leverages [`ORJSON`](https://github.com/ijl/orjson)\nas the JSON serializer for lightning-fast logging. It\'s 2020, you don\'t have to let your obligate cross-cutting concerns\ncripple performance any longer!  \n\nFor further reference, see:\n- "[`ORJSON`: Serialize](https://github.com/ijl/orjson#serialize)" for benchmarks\n- "[`structlog`: Performance](https://www.structlog.org/en/stable/performance.html)" for salient performance-related configurations.\n\n### Built-in Sentry Integration (Optional)\nAutomatically add much richer context to your Sentry reports.\n- Your entire logging context is sent as a Sentry event when the `structlog-sentry-logger`\nlog level is `error` or higher.\n    - i.e., `logger.error("")`, `logger.exception("")`\n- See [`structlog-sentry`](https://github.com/kiwicom/structlog-sentry) for more details.\n\n------------\nTable of Contents\n\n- [Installation](#installation)\n- [Usage](#usage)\n  * [Pure `structlog` Logging (Without Sentry)](#pure-structlog-logging-without-sentry)\n  * [Sentry Integration](#sentry-integration)\n    + [Log Custom Context Directly to Sentry](#log-custom-context-directly-to-sentry)\n- [Output: Formatting & Storage](#output-formatting--storage)\n- [Summary](#summary)\n- [Further Reading](#further-reading)\n    + [`structlog`](#structlog-structured-logging-for-python)\n    + [`Sentry`](#sentry-monitor-and-fix-crashes-in-realtime)\n    + [`structlog-sentry`](#structlog-sentry-provides-the-structlog-sentryprocessor-for-sentry-integration)\n\nInstallation\n==============================\n ```shell script\npip install structlog-sentry-logger\n```\n\nUsage\n==============================\nPure `structlog` Logging (Without Sentry)\n------------\nAt the top of your Python module, import and instantiate the logger:\n```python\nimport structlog_sentry_logger\n\nLOGGER = structlog_sentry_logger.get_logger()\n```\nNow anytime you want to print anything, don\'t. Instead do this:\n```python\nLOG_MSG = "Information that\'s useful for future me and others"\nLOGGER.info(LOG_MSG, extra_field="extra_value")\n```\n###### Note: all the regular [Python logging levels](https://docs.python.org/3/library/logging.html#levels) are supported.\nWhich automatically produces this:\n```\n{\n    "event": "Information that\'s useful for future me and others",\n    "extra_field": "extra_value",\n    "level": "info",\n    "logger": "docs_src.pure_structlog_logging_without_sentry",\n    "sentry": "skipped",\n    "timestamp": "2020-10-18 15:30:05"\n}\n```\n\nSentry Integration\n------------\nExport your [Sentry DSN](https://docs.sentry.io/platforms/python/#configure)\ninto your local environment.\n\n- An easy way to do this is to put it into a local `.env` file and use\n[`python-dotenv`](https://github.com/theskumar/python-dotenv) to populate your environment:\n ```shell script\n# On the command line:\nSENTRY_DSN=YOUR_SENTRY_DSN\n echo "SENTRY_DSN=${SENTRY_DSN}" >> .env\n```\n\nThen load the `.env` file in your Python code prior to instantiating the logger, e.g.:\n```python\nfrom dotenv import find_dotenv, load_dotenv\nload_dotenv(find_dotenv())\n\nimport structlog_sentry_logger\nLOGGER = structlog_sentry_logger.get_logger()\n```\n\n### Log Custom Context Directly to Sentry\nWith `structlog`, you can even incorporate custom messages in your exception handling which will automatically be reported to Sentry (thanks to the `structlog-sentry` module):\n```python\nimport uuid\n\nimport structlog_sentry_logger\n\nLOGGER = structlog_sentry_logger.get_logger()\n\ncurr_user_logger = LOGGER.bind(uuid=uuid.uuid4().hex)  # LOGGER instance with bound UUID\ntry:\n    curr_user_logger.warn("A dummy error for testing purposes is about to be thrown!")\n    x = 1 / 0\nexcept ZeroDivisionError as err:\n    ERR_MSG = (\n        "I threw an error on purpose for this example!\\n"\n        "Now throwing another that explicitly chains from that one!"\n    )\n    curr_user_logger.exception(ERR_MSG)\n    raise RuntimeError(ERR_MSG) from err\n```\n\n```\n{\n    "event": "A dummy error for testing purposes is about to be thrown!",\n    "level": "warning",\n    "logger": "docs_src.sentry_integration",\n    "sentry": "skipped",\n    "timestamp": "2020-10-18 15:29:55",\n    "uuid": "181e0e00b9034732af4fed2b8424fb11"\n}\n{\n    "event": "I threw an error on purpose for this example!\\nNow throwing another that explicitly chains from that one!",\n    "exception": \'Traceback (most recent call last):\\n  File "/app/structlog-sentry-logger/docs_src/sentry_integration.py", line 10, in <module>\\n    x = 1 / 0\\nZeroDivisionError: division by zero\',\n    "level": "error",\n    "logger": "docs_src.sentry_integration",\n    "sentry": "sent",\n    "sentry_id": null,\n    "timestamp": "2020-10-18 15:29:55",\n    "uuid": "181e0e00b9034732af4fed2b8424fb11"\n}\nTraceback (most recent call last):\n  File "/app/structlog-sentry-logger/docs_src/sentry_integration.py", line 10, in <module>\n    x = 1 / 0\nZeroDivisionError: division by zero\n\nThe above exception was the direct cause of the following exception:\n\nTraceback (most recent call last):\n  File "/app/structlog-sentry-logger/docs_src/sentry_integration.py", line 17, in <module>\n    raise RuntimeError(ERR_MSG) from err\nRuntimeError: I threw an error on purpose for this example!\nNow throwing another that explicitly chains from that one!\n```\n\nOutput: Formatting & Storage\n==============================\nThe default behavior is to stream JSON logs directly to the standard output\nstream [like a proper 12 Factor App](https://12factor.net/logs).\n\nFor local development, it often helps to prettify logging to stdout and save\nJSON logs to a `.logs` folder at the root of your project directory for later\ndebugging. To enable this behavior, set the following environment variable\n(e.g. via [`python-dotenv`](https://github.com/theskumar/python-dotenv) as in\nthe [Sentry Integration](#sentry-integration) section):\n```bash\nCI_ENVIRONMENT_SLUG=dev-local\n```\nIn doing so, with our previous exception handling example we would get:\n\n<img src=".static/Output_Formatting_example.png">\n\nSummary\n==============================\nThat\'s it. Now no excuses.\nGet out there and program with pride knowing no one\nwill laugh at you in production! For not logging properly, that is. You\'re on your own\nfor that other [observability](https://devops.com/metrics-logs-and-traces-the-golden-triangle-of-observability-in-monitoring/) stuff.\n\nFurther Reading\n==============================\n<img src="https://www.structlog.org/en/stable/_static/structlog_logo_small.png" width="200">\n\n### [`structlog`](https://www.structlog.org/en/stable/#): Structured Logging for Python\n\n<img src="https://camo.githubusercontent.com/2dfeafbee0904d6df16ddf7200993dace1629e60/68747470733a2f2f73656e7472792d6272616e642e73746f726167652e676f6f676c65617069732e636f6d2f73656e7472792d6c6f676f2d626c61636b2e706e67" width="400">\n\n### [`Sentry`](https://sentry.io/welcome/): Monitor and fix crashes in realtime.\n\n### [`structlog-sentry`](https://github.com/kiwicom/structlog-sentry): Provides the [`structlog`](https://www.structlog.org/en/stable/#) `SentryProcessor` for [Sentry](https://sentry.io/welcome/) integration.\n',
    'author': 'Teo Zosa',
    'author_email': 'teo@sonosim.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/TeoZosa/structlog-sentry-logger',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.6.1,<4.0.0',
}


setup(**setup_kwargs)
