"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CenRouteService = exports.CenRouteServiceProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const cen_generated_1 = require("./cen.generated");
Object.defineProperty(exports, "CenRouteServiceProperty", { enumerable: true, get: function () { return cen_generated_1.RosCenRouteService; } });
/**
 * A ROS resource type:  `ALIYUN::CEN::CenRouteService`
 */
class CenRouteService extends ros.Resource {
    /**
     * Create a new `ALIYUN::CEN::CenRouteService`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosCenRouteService = new cen_generated_1.RosCenRouteService(this, id, {
            conflictIgnore: props.conflictIgnore === undefined || props.conflictIgnore === null ? false : props.conflictIgnore,
            description: props.description,
            hostRegionId: props.hostRegionId,
            cenId: props.cenId,
            accessRegionId: props.accessRegionId,
            host: props.host,
            hostVpcId: props.hostVpcId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosCenRouteService;
        this.attrId = rosCenRouteService.attrId;
    }
}
exports.CenRouteService = CenRouteService;
//# sourceMappingURL=data:application/json;base64,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