# Generated by Django 3.0.3 on 2020-06-02 14:12

from django.contrib.contenttypes.models import ContentType
from django.core.exceptions import ObjectDoesNotExist
from django.db import migrations


def register_content_type(apps, schema_editor):
    """Registers AlertSettings if not yet registered"""
    try:
        ContentType.objects.get(app_label='monitoring', model='alertsettings')
    except ObjectDoesNotExist:
        ct = ContentType(app_label='monitoring', model='alertsettings')
        ct.save()


def unregister_content_type(apps, schema_editor):
    ct = ContentType.objects.get(app_label='monitoring', model='alertsettings')
    ct.delete()


class Migration(migrations.Migration):

    dependencies = [('monitoring', '0010_rename_threshold_alert_settings')]

    operations = [migrations.RunPython(register_content_type, unregister_content_type)]
