# Generated by Django 3.1.2 on 2020-11-16 09:03
# TODO: The ``replaces`` attribute needs to be removed in 0.2 release as explained in django
# docs https://docs.djangoproject.com/en/dev/topics/migrations/#migration-squashing

import uuid

import django.core.validators
import django.db.migrations.operations.special
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import swapper
from django.conf import settings
from django.db import migrations, models

from ..configuration import CHART_CONFIGURATION_CHOICES, METRIC_CONFIGURATION_CHOICES


class Migration(migrations.Migration):

    replaces = [
        ('monitoring', '0001_initial'),
        ('monitoring', '0002_is_healthy'),
        ('monitoring', '0003_graph_type'),
        ('monitoring', '0004_move_notifications'),
        ('monitoring', '0005_metric_is_heathy_unknown'),
        ('monitoring', '0006_add_configuration'),
        ('monitoring', '0007_fill_configuration'),
        ('monitoring', '0008_remove_graph_fields'),
        ('monitoring', '0009_allow_float_threshold'),
        ('monitoring', '0010_rename_threshold_alert_settings'),
        ('monitoring', '0011_alert_settings_contenttype_registration'),
        ('monitoring', '0012_rename_graph_chart'),
        ('monitoring', '0013_create_chart_alertsettings'),
        ('monitoring', '0014_data_migration'),
        ('monitoring', '0015_delete_models'),
        ('monitoring', '0016_metric_configuration'),
        ('monitoring', '0017_merge_traffic_metrics_and_fill_metric_config'),
        ('monitoring', '0018_alertsettings_is_active'),
        ('monitoring', '0019_rename_alertsettings_fields'),
        ('monitoring', '0020_make_alertsettings_fields_null'),
        ('monitoring', '0021_resources_threshold_values'),
        ('monitoring', '0022_delete_resources_metric_data'),
        ('monitoring', '0023_alert_settings_tolerance_remove_default'),
    ]

    initial = True

    dependencies = [
        ('monitoring', '__first__'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
        ('openwisp_notifications', '0003_notification_notification_type'),
        swapper.dependency('monitoring', 'Metric'),
        swapper.dependency('monitoring', 'AlertSettings'),
        swapper.dependency('monitoring', 'Chart'),
    ]

    operations = [
        migrations.CreateModel(
            name='Metric',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                ('name', models.CharField(max_length=64)),
                (
                    'configuration',
                    models.CharField(
                        choices=METRIC_CONFIGURATION_CHOICES, max_length=16, null=True
                    ),
                ),
                (
                    'key',
                    models.SlugField(
                        blank=True,
                        help_text='leave blank to determine automatically',
                        max_length=64,
                    ),
                ),
                ('field_name', models.CharField(default='value', max_length=16)),
                (
                    'object_id',
                    models.CharField(blank=True, db_index=True, max_length=36),
                ),
                (
                    'content_type',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to='contenttypes.contenttype',
                    ),
                ),
                (
                    'is_healthy',
                    models.BooleanField(
                        blank=True, db_index=True, default=None, null=True
                    ),
                ),
            ],
            options={
                'abstract': False,
                'swappable': swapper.swappable_setting('monitoring', 'Metric'),
                'unique_together': {('key', 'field_name', 'content_type', 'object_id')},
            },
        ),
        migrations.CreateModel(
            name='Chart',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'configuration',
                    models.CharField(
                        choices=CHART_CONFIGURATION_CHOICES, max_length=16, null=True
                    ),
                ),
                (
                    'metric',
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name('monitoring', 'Metric'),
                    ),
                ),
            ],
            options={
                'abstract': False,
                'swappable': swapper.swappable_setting('monitoring', 'Chart'),
            },
        ),
        migrations.CreateModel(
            name='AlertSettings',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'custom_operator',
                    models.CharField(
                        blank=True,
                        choices=[('<', 'less than'), ('>', 'greater than')],
                        max_length=1,
                        null=True,
                        verbose_name='operator',
                    ),
                ),
                (
                    'custom_threshold',
                    models.FloatField(
                        blank=True,
                        help_text='threshold value',
                        null=True,
                        verbose_name='threshold value',
                    ),
                ),
                (
                    'custom_tolerance',
                    models.PositiveIntegerField(
                        blank=True,
                        help_text='for how many minutes should the threshold value be crossed before'
                        ' an alert is sent? A value of zero means the alert is sent immediately',
                        null=True,
                        validators=[django.core.validators.MaxValueValidator(10080)],
                        verbose_name='threshold tolerance',
                    ),
                ),
                (
                    'metric',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name('monitoring', 'Metric'),
                    ),
                ),
                (
                    'is_active',
                    models.BooleanField(
                        default=True,
                        help_text='whether alerts are enabled for this metric, uncheck to disable'
                        ' this alert for this object and all users',
                        verbose_name='Alerts enabled',
                    ),
                ),
            ],
            options={
                'verbose_name': 'Alert settings',
                'verbose_name_plural': 'Alert settings',
                'abstract': False,
                'swappable': swapper.swappable_setting('monitoring', 'AlertSettings'),
            },
        ),
    ]
