# -*- coding: utf-8 -*-
# Generated by Django 1.11.9 on 2018-02-18 19:32
from __future__ import unicode_literals

import uuid

import django.core.validators
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import swapper
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
        swapper.dependency('monitoring', 'Metric'),
        swapper.dependency('monitoring', 'Threshold'),
        swapper.dependency('monitoring', 'Graph'),
    ]

    operations = [
        migrations.CreateModel(
            name='Graph',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                ('description', models.CharField(blank=True, max_length=64)),
                ('query', models.TextField(blank=True)),
            ],
            options={
                'abstract': False,
                'swappable': swapper.swappable_setting('monitoring', 'Graph'),
            },
        ),
        migrations.CreateModel(
            name='Metric',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'health',
                    models.CharField(
                        choices=[('ok', 'ok'), ('problem', 'problem')],
                        default='ok',
                        max_length=8,
                    ),
                ),
                ('name', models.CharField(max_length=64)),
                ('description', models.TextField(blank=True)),
                (
                    'key',
                    models.SlugField(
                        blank=True,
                        help_text='leave blank to determine automatically',
                        max_length=64,
                    ),
                ),
                ('field_name', models.CharField(default='value', max_length=16)),
                (
                    'object_id',
                    models.CharField(blank=True, db_index=True, max_length=36),
                ),
                (
                    'content_type',
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to='contenttypes.ContentType',
                    ),
                ),
            ],
            options={
                'abstract': False,
                'swappable': swapper.swappable_setting('monitoring', 'Metric'),
            },
        ),
        migrations.CreateModel(
            name='NotificationUser',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'receive',
                    models.BooleanField(
                        default=True,
                        help_text='note: non-superadmin users receive notifications '
                        'only for organizations of which they are member of.',
                        verbose_name='receive notifications',
                    ),
                ),
                (
                    'email',
                    models.BooleanField(
                        default=True,
                        help_text='note: non-superadmin users receive notifications only '
                        'for organizations of which they are member of.',
                        verbose_name='email notifications',
                    ),
                ),
                (
                    'user',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                'verbose_name': 'user notification settings',
                'verbose_name_plural': 'user notification settings',
            },
        ),
        migrations.CreateModel(
            name='Threshold',
            fields=[
                (
                    'id',
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    'created',
                    model_utils.fields.AutoCreatedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='created',
                    ),
                ),
                (
                    'modified',
                    model_utils.fields.AutoLastModifiedField(
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name='modified',
                    ),
                ),
                (
                    'operator',
                    models.CharField(
                        choices=[('<', 'less than'), ('>', 'greater than')],
                        max_length=1,
                    ),
                ),
                ('value', models.IntegerField(help_text='threshold value')),
                (
                    'seconds',
                    models.PositiveIntegerField(
                        default=0,
                        help_text='for how long should the threshold value be crossed '
                        'before triggering an alert? The maximum allowed is 604800 seconds (7 days)',
                        validators=[django.core.validators.MaxValueValidator(604800)],
                    ),
                ),
                (
                    'metric',
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=swapper.get_model_name('monitoring', 'Metric'),
                    ),
                ),
            ],
            options={
                'abstract': False,
                'swappable': swapper.swappable_setting('monitoring', 'Threshold'),
            },
        ),
        migrations.AddField(
            model_name='graph',
            name='metric',
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to=swapper.get_model_name('monitoring', 'Metric'),
            ),
        ),
        migrations.AlterUniqueTogether(
            name='metric',
            unique_together=set([('key', 'field_name', 'content_type', 'object_id')]),
        ),
    ]
