"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = exports.DomainProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const waf_generated_1 = require("./waf.generated");
Object.defineProperty(exports, "DomainProperty", { enumerable: true, get: function () { return waf_generated_1.RosDomain; } });
/**
 * A ROS resource type:  `ALIYUN::WAF::Domain`
 */
class Domain extends ros.Resource {
    /**
     * Create a new `ALIYUN::WAF::Domain`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosDomain = new waf_generated_1.RosDomain(this, id, {
            httpToUserIp: props.httpToUserIp,
            httpPort: props.httpPort,
            isAccessProduct: props.isAccessProduct,
            resourceGroupId: props.resourceGroupId,
            domainName: props.domainName,
            instanceId: props.instanceId,
            sourceIps: props.sourceIps,
            readTime: props.readTime,
            clusterType: props.clusterType,
            loadBalancing: props.loadBalancing,
            logHeaders: props.logHeaders,
            writeTime: props.writeTime,
            http2Port: props.http2Port,
            connectionTime: props.connectionTime,
            httpsRedirect: props.httpsRedirect,
            httpsPort: props.httpsPort,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDomain;
        this.attrClusterType = rosDomain.attrClusterType;
        this.attrCname = rosDomain.attrCname;
        this.attrDomainName = rosDomain.attrDomainName;
        this.attrHttp2Port = rosDomain.attrHttp2Port;
        this.attrHttpPort = rosDomain.attrHttpPort;
        this.attrHttpToUserIp = rosDomain.attrHttpToUserIp;
        this.attrHttpsPort = rosDomain.attrHttpsPort;
        this.attrHttpsRedirect = rosDomain.attrHttpsRedirect;
        this.attrInstanceId = rosDomain.attrInstanceId;
        this.attrIsAccessProduct = rosDomain.attrIsAccessProduct;
        this.attrLoadBalancing = rosDomain.attrLoadBalancing;
        this.attrLogHeaders = rosDomain.attrLogHeaders;
        this.attrResourceGroupId = rosDomain.attrResourceGroupId;
        this.attrSourceIps = rosDomain.attrSourceIps;
        this.attrVersion = rosDomain.attrVersion;
    }
}
exports.Domain = Domain;
//# sourceMappingURL=data:application/json;base64,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