"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.InstanceType = exports.InstanceSize = exports.InstanceArchitecture = exports.InstanceClass = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * What class and generation of instance to use.
 *
 * We have both symbolic and concrete enums for every type.
 *
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 *
 * @stability stable
 */
var InstanceClass;
(function (InstanceClass) {
    InstanceClass["STANDARD3"] = "m3";
    /**
     * Standard instances, 3rd generation
     */
    InstanceClass["M3"] = "m3";
    InstanceClass["STANDARD4"] = "m4";
    /**
     * Standard instances, 4th generation
     */
    InstanceClass["M4"] = "m4";
    InstanceClass["STANDARD5"] = "m5";
    /**
     * Standard instances, 5th generation
     */
    InstanceClass["M5"] = "m5";
    InstanceClass["STANDARD5_NVME_DRIVE"] = "m5d";
    /**
     * Standard instances with local NVME drive, 5th generation
     */
    InstanceClass["M5D"] = "m5d";
    InstanceClass["STANDARD5_AMD"] = "m5a";
    /**
     * Standard instances based on AMD EPYC, 5th generation
     */
    InstanceClass["M5A"] = "m5a";
    InstanceClass["STANDARD5_AMD_NVME_DRIVE"] = "m5ad";
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["M5AD"] = "m5ad";
    InstanceClass["MEMORY3"] = "r3";
    /**
     * Memory optimized instances, 3rd generation
     */
    InstanceClass["R3"] = "r3";
    InstanceClass["MEMORY4"] = "r4";
    /**
     * Memory optimized instances, 4th generation
     */
    InstanceClass["R4"] = "r4";
    InstanceClass["MEMORY5"] = "r5";
    /**
     * Memory optimized instances, 5th generation
     */
    InstanceClass["R5"] = "r5";
    InstanceClass["MEMORY5_HIGH_PERFORMANCE"] = "r5n";
    /**
     * Memory optimized instances for high performance computing, 5th generation
     */
    InstanceClass["R5N"] = "r5n";
    InstanceClass["MEMORY5_NVME_DRIVE"] = "r5d";
    /**
     * Memory optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["R5D"] = "r5d";
    InstanceClass["MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE"] = "r5dn";
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation
     */
    InstanceClass["R5DN"] = "r5dn";
    InstanceClass["MEMORY5_AMD"] = "r5a";
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["R5A"] = "r5a";
    InstanceClass["MEMORY5_AMD_NVME_DRIVE"] = "r5ad";
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation
     */
    InstanceClass["R5AD"] = "r5ad";
    InstanceClass["MEMORY5_EBS_OPTIMIZED"] = "r5b";
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation
     */
    InstanceClass["R5B"] = "r5b";
    InstanceClass["MEMORY6_GRAVITON"] = "r6g";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors
     */
    InstanceClass["R6G"] = "r6g";
    InstanceClass["MEMORY6_GRAVITON2_NVME_DRIVE"] = "r6gd";
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["R6GD"] = "r6gd";
    InstanceClass["COMPUTE3"] = "c3";
    /**
     * Compute optimized instances, 3rd generation
     */
    InstanceClass["C3"] = "c3";
    InstanceClass["COMPUTE4"] = "c4";
    /**
     * Compute optimized instances, 4th generation
     */
    InstanceClass["C4"] = "c4";
    InstanceClass["COMPUTE5"] = "c5";
    /**
     * Compute optimized instances, 5th generation
     */
    InstanceClass["C5"] = "c5";
    InstanceClass["COMPUTE5_NVME_DRIVE"] = "c5d";
    InstanceClass["COMPUTE5_AMD"] = "c5a";
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation
     */
    InstanceClass["C5A"] = "c5a";
    /**
     * Compute optimized instances with local NVME drive, 5th generation
     */
    InstanceClass["C5D"] = "c5d";
    InstanceClass["COMPUTE5_HIGH_PERFORMANCE"] = "c5n";
    /**
     * Compute optimized instances for high performance computing, 5th generation
     */
    InstanceClass["C5N"] = "c5n";
    InstanceClass["COMPUTE6_GRAVITON2"] = "c6g";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     */
    InstanceClass["C6G"] = "c6g";
    InstanceClass["COMPUTE6_GRAVITON2_NVME_DRIVE"] = "c6gd";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and local NVME drive
     */
    InstanceClass["C6GD"] = "c6gd";
    InstanceClass["COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWITH"] = "c6gn";
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors
     * and high network bandwidth capabilities
     */
    InstanceClass["C6GN"] = "c6gn";
    InstanceClass["STORAGE2"] = "d2";
    /**
     * Storage-optimized instances, 2nd generation
     */
    InstanceClass["D2"] = "d2";
    InstanceClass["STORAGE_COMPUTE_1"] = "h1";
    /**
     * Storage/compute balanced instances, 1st generation
     */
    InstanceClass["H1"] = "h1";
    InstanceClass["IO3"] = "i3";
    /**
     * I/O-optimized instances, 3rd generation
     */
    InstanceClass["I3"] = "i3";
    InstanceClass["IO3_DENSE_NVME_DRIVE"] = "i3en";
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation
     */
    InstanceClass["I3EN"] = "i3en";
    InstanceClass["BURSTABLE2"] = "t2";
    /**
     * Burstable instances, 2nd generation
     */
    InstanceClass["T2"] = "t2";
    InstanceClass["BURSTABLE3"] = "t3";
    /**
     * Burstable instances, 3rd generation
     */
    InstanceClass["T3"] = "t3";
    InstanceClass["BURSTABLE3_AMD"] = "t3a";
    /**
     * Burstable instances based on AMD EPYC, 3rd generation
     */
    InstanceClass["T3A"] = "t3a";
    InstanceClass["BURSTABLE4_GRAVITON"] = "t4g";
    /**
     * Burstable instances, 4th generation with Graviton2 processors
     */
    InstanceClass["T4G"] = "t4g";
    InstanceClass["MEMORY_INTENSIVE_1"] = "x1";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1"] = "x1";
    InstanceClass["MEMORY_INTENSIVE_1_EXTENDED"] = "x1e";
    /**
     * Memory-intensive instances, 1st generation
     */
    InstanceClass["X1E"] = "x1e";
    InstanceClass["FPGA1"] = "f1";
    /**
     * Instances with customizable hardware acceleration, 1st generation
     */
    InstanceClass["F1"] = "f1";
    InstanceClass["GRAPHICS3"] = "g3";
    /**
     * Graphics-optimized instances, 3rd generation
     */
    InstanceClass["G3"] = "g3";
    InstanceClass["GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE"] = "g4dn";
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation
     */
    InstanceClass["G4DN"] = "g4dn";
    InstanceClass["PARALLEL2"] = "p2";
    /**
     * Parallel-processing optimized instances, 2nd generation
     */
    InstanceClass["P2"] = "p2";
    InstanceClass["PARALLEL3"] = "p3";
    /**
     * Parallel-processing optimized instances, 3nd generation
     */
    InstanceClass["P3"] = "p3";
    InstanceClass["ARM1"] = "a1";
    /**
     * Arm processor based instances, 1st generation
     */
    InstanceClass["A1"] = "a1";
    InstanceClass["STANDARD6_GRAVITON"] = "m6g";
    /**
     * Arm processor based instances, 2nd generation
     */
    InstanceClass["M6G"] = "m6g";
    InstanceClass["STANDARD6_GRAVITON2_NVME_DRIVE"] = "m6gd";
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive
     */
    InstanceClass["M6GD"] = "m6gd";
    InstanceClass["HIGH_COMPUTE_MEMORY1"] = "z1d";
    /**
     * High memory and compute capacity instances, 1st generation
     */
    InstanceClass["Z1D"] = "z1d";
    InstanceClass["INFERENCE1"] = "inf1";
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation
     */
    InstanceClass["INF1"] = "inf1";
})(InstanceClass = exports.InstanceClass || (exports.InstanceClass = {}));
/**
 * Identifies an instance's CPU architecture.
 *
 * @stability stable
 */
var InstanceArchitecture;
(function (InstanceArchitecture) {
    InstanceArchitecture["ARM_64"] = "arm64";
    InstanceArchitecture["X86_64"] = "x86_64";
})(InstanceArchitecture = exports.InstanceArchitecture || (exports.InstanceArchitecture = {}));
/**
 * What size of instance to use.
 *
 * @stability stable
 */
var InstanceSize;
(function (InstanceSize) {
    InstanceSize["NANO"] = "nano";
    InstanceSize["MICRO"] = "micro";
    InstanceSize["SMALL"] = "small";
    InstanceSize["MEDIUM"] = "medium";
    InstanceSize["LARGE"] = "large";
    InstanceSize["XLARGE"] = "xlarge";
    InstanceSize["XLARGE2"] = "2xlarge";
    InstanceSize["XLARGE4"] = "4xlarge";
    InstanceSize["XLARGE6"] = "6xlarge";
    InstanceSize["XLARGE8"] = "8xlarge";
    InstanceSize["XLARGE9"] = "9xlarge";
    InstanceSize["XLARGE10"] = "10xlarge";
    InstanceSize["XLARGE12"] = "12xlarge";
    InstanceSize["XLARGE16"] = "16xlarge";
    InstanceSize["XLARGE18"] = "18xlarge";
    InstanceSize["XLARGE24"] = "24xlarge";
    InstanceSize["XLARGE32"] = "32xlarge";
    InstanceSize["METAL"] = "metal";
})(InstanceSize = exports.InstanceSize || (exports.InstanceSize = {}));
/**
 * Instance type for EC2 instances.
 *
 * This class takes a literal string, good if you already
 * know the identifier of the type you want.
 *
 * @stability stable
 */
class InstanceType {
    /**
     * @stability stable
     */
    constructor(instanceTypeIdentifier) {
        this.instanceTypeIdentifier = instanceTypeIdentifier;
    }
    /**
     * Instance type for EC2 instances.
     *
     * This class takes a combination of a class and size.
     *
     * Be aware that not all combinations of class and size are available, and not all
     * classes are available in all regions.
     *
     * @stability stable
     */
    static of(instanceClass, instanceSize) {
        return new InstanceType(`${instanceClass}.${instanceSize}`);
    }
    /**
     * Return the instance type as a dotted string.
     *
     * @stability stable
     */
    toString() {
        return this.instanceTypeIdentifier;
    }
    /**
     * The instance's CPU architecture.
     *
     * @stability stable
     */
    get architecture() {
        // capture the family, generation, capabilities, and size portions of the instance type id
        const instanceTypeComponents = this.instanceTypeIdentifier.match(/^([a-z]+)(\d{1,2})([a-z]*)\.([a-z0-9]+)$/);
        if (instanceTypeComponents == null) {
            throw new Error('Malformed instance type identifier');
        }
        const family = instanceTypeComponents[1];
        const capabilities = instanceTypeComponents[3];
        // Instance family `a` are first-gen Graviton instances
        // Capability `g` indicates the instance is Graviton2 powered
        if (family === 'a' || capabilities.includes('g')) {
            return InstanceArchitecture.ARM_64;
        }
        return InstanceArchitecture.X86_64;
    }
}
exports.InstanceType = InstanceType;
_a = JSII_RTTI_SYMBOL_1;
InstanceType[_a] = { fqn: "@aws-cdk/aws-ec2.InstanceType", version: "1.101.0" };
//# sourceMappingURL=data:application/json;base64,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