A [Language Server](https://microsoft.github.io/language-server-protocol/) for [zc.buildout](http://www.buildout.org/).

This language server is implemented using [pygls](https://github.com/openlawlibrary/pygls).

# Installation

## Standalone

Needs a python >= 3.6.

```bash
python -m pip install zc.buildout.languageserver
```

Then configure your editor to run `buildoutls` ( or `python3 -m buildoutls` ).

## From vscode extension

On activation, the extension automatically installs the extension on the python configured in the extension preferences.

The automatic installation does not seem to work with theia and the python egg has to be installed beforehand.

# Features

## Completions

- `${` complete sections.
- `${section:` complete `section`'s options. If `section` uses a known recipe, dynamic options from the recipe are also completed.
- `${buildout:extends}` completes filenames.
- `${buildout:parts}` and `<=` option completes parts.

## Diagnostics

- non existant section and options in `${section:option}` references.
- required options not defined for a a few "known recipes".

## Symbols

- Sections and options are shown are displayed in outline as symbols.

## Links

- `${buildout:extends}` are links.

## Go to definitions

- from `${section:options}` we can go to the location where `option` is defined in `section`, or to `section` header if it's not defined.
- from `<= section` we can go to `section`.

## Hover

- Hover on an option show the option value.

## Find references

- Find references of the current symbol. A bit simple, it only look for references and does not check if profiles really `extends` each other. It does not look in templates either.

## Template support

- "current" buildout profile is guessed, then completions and diagnostics should work on any files.

## Jinja2 support

- Jinja syntax is syntax highlighted and jinja syntax markers are ignored when parsing buildout.

## SlapOS support

- SlapOS instance buildout (ie. buildout generated by buildout) is understood, `${` and `$${` are treated separatly for completions and diagnostics.
