# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KoyebServiceArgs', 'KoyebService']

@pulumi.input_type
class KoyebServiceArgs:
    def __init__(__self__, *,
                 app_name: pulumi.Input[str],
                 definition: pulumi.Input['KoyebServiceDefinitionArgs'],
                 messages: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a KoyebService resource.
        :param pulumi.Input[str] app_name: The app name the service is assigned to
        :param pulumi.Input['KoyebServiceDefinitionArgs'] definition: The service deployment definition
        :param pulumi.Input[str] messages: The status messages of the service
        """
        pulumi.set(__self__, "app_name", app_name)
        pulumi.set(__self__, "definition", definition)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Input[str]:
        """
        The app name the service is assigned to
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Input['KoyebServiceDefinitionArgs']:
        """
        The service deployment definition
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: pulumi.Input['KoyebServiceDefinitionArgs']):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[str]]:
        """
        The status messages of the service
        """
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "messages", value)


@pulumi.input_type
class _KoyebServiceState:
    def __init__(__self__, *,
                 active_deployment: Optional[pulumi.Input[str]] = None,
                 app_id: Optional[pulumi.Input[str]] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input['KoyebServiceDefinitionArgs']] = None,
                 latest_deployment: Optional[pulumi.Input[str]] = None,
                 messages: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 organization_id: Optional[pulumi.Input[str]] = None,
                 paused_at: Optional[pulumi.Input[str]] = None,
                 resumed_at: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 terminated_at: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KoyebService resources.
        :param pulumi.Input[str] active_deployment: The service active deployment ID
        :param pulumi.Input[str] app_id: The app id the service is assigned to
        :param pulumi.Input[str] app_name: The app name the service is assigned to
        :param pulumi.Input[str] created_at: The date and time of when the service was created
        :param pulumi.Input['KoyebServiceDefinitionArgs'] definition: The service deployment definition
        :param pulumi.Input[str] latest_deployment: The service latest deployment ID
        :param pulumi.Input[str] messages: The status messages of the service
        :param pulumi.Input[str] name: The service name
        :param pulumi.Input[str] organization_id: The organization ID owning the service
        :param pulumi.Input[str] paused_at: The date and time of when the service was last updated
        :param pulumi.Input[str] resumed_at: The date and time of when the service was last updated
        :param pulumi.Input[str] status: The status of the service
        :param pulumi.Input[str] terminated_at: The date and time of when the service was last updated
        :param pulumi.Input[str] updated_at: The date and time of when the service was last updated
        :param pulumi.Input[str] version: The version of the service
        """
        if active_deployment is not None:
            pulumi.set(__self__, "active_deployment", active_deployment)
        if app_id is not None:
            pulumi.set(__self__, "app_id", app_id)
        if app_name is not None:
            pulumi.set(__self__, "app_name", app_name)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if definition is not None:
            pulumi.set(__self__, "definition", definition)
        if latest_deployment is not None:
            pulumi.set(__self__, "latest_deployment", latest_deployment)
        if messages is not None:
            pulumi.set(__self__, "messages", messages)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if organization_id is not None:
            pulumi.set(__self__, "organization_id", organization_id)
        if paused_at is not None:
            pulumi.set(__self__, "paused_at", paused_at)
        if resumed_at is not None:
            pulumi.set(__self__, "resumed_at", resumed_at)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if terminated_at is not None:
            pulumi.set(__self__, "terminated_at", terminated_at)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="activeDeployment")
    def active_deployment(self) -> Optional[pulumi.Input[str]]:
        """
        The service active deployment ID
        """
        return pulumi.get(self, "active_deployment")

    @active_deployment.setter
    def active_deployment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "active_deployment", value)

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> Optional[pulumi.Input[str]]:
        """
        The app id the service is assigned to
        """
        return pulumi.get(self, "app_id")

    @app_id.setter
    def app_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_id", value)

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> Optional[pulumi.Input[str]]:
        """
        The app name the service is assigned to
        """
        return pulumi.get(self, "app_name")

    @app_name.setter
    def app_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "app_name", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of when the service was created
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def definition(self) -> Optional[pulumi.Input['KoyebServiceDefinitionArgs']]:
        """
        The service deployment definition
        """
        return pulumi.get(self, "definition")

    @definition.setter
    def definition(self, value: Optional[pulumi.Input['KoyebServiceDefinitionArgs']]):
        pulumi.set(self, "definition", value)

    @property
    @pulumi.getter(name="latestDeployment")
    def latest_deployment(self) -> Optional[pulumi.Input[str]]:
        """
        The service latest deployment ID
        """
        return pulumi.get(self, "latest_deployment")

    @latest_deployment.setter
    def latest_deployment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "latest_deployment", value)

    @property
    @pulumi.getter
    def messages(self) -> Optional[pulumi.Input[str]]:
        """
        The status messages of the service
        """
        return pulumi.get(self, "messages")

    @messages.setter
    def messages(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "messages", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The service name
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> Optional[pulumi.Input[str]]:
        """
        The organization ID owning the service
        """
        return pulumi.get(self, "organization_id")

    @organization_id.setter
    def organization_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "organization_id", value)

    @property
    @pulumi.getter(name="pausedAt")
    def paused_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "paused_at")

    @paused_at.setter
    def paused_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "paused_at", value)

    @property
    @pulumi.getter(name="resumedAt")
    def resumed_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "resumed_at")

    @resumed_at.setter
    def resumed_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resumed_at", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the service
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="terminatedAt")
    def terminated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "terminated_at")

    @terminated_at.setter
    def terminated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "terminated_at", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the service
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


class KoyebService(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input[pulumi.InputType['KoyebServiceDefinitionArgs']]] = None,
                 messages: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_koyeb as koyeb

        my_service = koyeb.KoyebService("my-service",
            app_name=koyeb_app["my_app"]["name"],
            definition=koyeb.KoyebServiceDefinitionArgs(
                name="my-service",
                instance_types=koyeb.KoyebServiceDefinitionInstanceTypesArgs(
                    type="micro",
                ),
                ports=[koyeb.KoyebServiceDefinitionPortArgs(
                    port=3000,
                    protocol="http",
                )],
                scalings=koyeb.KoyebServiceDefinitionScalingsArgs(
                    min=1,
                    max=1,
                ),
                envs=[koyeb.KoyebServiceDefinitionEnvArgs(
                    key="FOO",
                    value="BAR",
                )],
                routes=[koyeb.KoyebServiceDefinitionRouteArgs(
                    path="/",
                    port=3000,
                )],
                regions=["par"],
                docker=koyeb.KoyebServiceDefinitionDockerArgs(
                    image="koyeb/demo",
                ),
            ),
            opts=pulumi.ResourceOptions(depends_on=[koyeb_app["my-app"]]))
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] app_name: The app name the service is assigned to
        :param pulumi.Input[pulumi.InputType['KoyebServiceDefinitionArgs']] definition: The service deployment definition
        :param pulumi.Input[str] messages: The status messages of the service
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KoyebServiceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_koyeb as koyeb

        my_service = koyeb.KoyebService("my-service",
            app_name=koyeb_app["my_app"]["name"],
            definition=koyeb.KoyebServiceDefinitionArgs(
                name="my-service",
                instance_types=koyeb.KoyebServiceDefinitionInstanceTypesArgs(
                    type="micro",
                ),
                ports=[koyeb.KoyebServiceDefinitionPortArgs(
                    port=3000,
                    protocol="http",
                )],
                scalings=koyeb.KoyebServiceDefinitionScalingsArgs(
                    min=1,
                    max=1,
                ),
                envs=[koyeb.KoyebServiceDefinitionEnvArgs(
                    key="FOO",
                    value="BAR",
                )],
                routes=[koyeb.KoyebServiceDefinitionRouteArgs(
                    path="/",
                    port=3000,
                )],
                regions=["par"],
                docker=koyeb.KoyebServiceDefinitionDockerArgs(
                    image="koyeb/demo",
                ),
            ),
            opts=pulumi.ResourceOptions(depends_on=[koyeb_app["my-app"]]))
        ```

        :param str resource_name: The name of the resource.
        :param KoyebServiceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KoyebServiceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_name: Optional[pulumi.Input[str]] = None,
                 definition: Optional[pulumi.Input[pulumi.InputType['KoyebServiceDefinitionArgs']]] = None,
                 messages: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.plugin_download_url is None:
            opts.plugin_download_url = _utilities.get_plugin_download_url()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KoyebServiceArgs.__new__(KoyebServiceArgs)

            if app_name is None and not opts.urn:
                raise TypeError("Missing required property 'app_name'")
            __props__.__dict__["app_name"] = app_name
            if definition is None and not opts.urn:
                raise TypeError("Missing required property 'definition'")
            __props__.__dict__["definition"] = definition
            __props__.__dict__["messages"] = messages
            __props__.__dict__["active_deployment"] = None
            __props__.__dict__["app_id"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["latest_deployment"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["organization_id"] = None
            __props__.__dict__["paused_at"] = None
            __props__.__dict__["resumed_at"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["terminated_at"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["version"] = None
        super(KoyebService, __self__).__init__(
            'koyeb:index/koyebService:KoyebService',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_deployment: Optional[pulumi.Input[str]] = None,
            app_id: Optional[pulumi.Input[str]] = None,
            app_name: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            definition: Optional[pulumi.Input[pulumi.InputType['KoyebServiceDefinitionArgs']]] = None,
            latest_deployment: Optional[pulumi.Input[str]] = None,
            messages: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            organization_id: Optional[pulumi.Input[str]] = None,
            paused_at: Optional[pulumi.Input[str]] = None,
            resumed_at: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            terminated_at: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None) -> 'KoyebService':
        """
        Get an existing KoyebService resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] active_deployment: The service active deployment ID
        :param pulumi.Input[str] app_id: The app id the service is assigned to
        :param pulumi.Input[str] app_name: The app name the service is assigned to
        :param pulumi.Input[str] created_at: The date and time of when the service was created
        :param pulumi.Input[pulumi.InputType['KoyebServiceDefinitionArgs']] definition: The service deployment definition
        :param pulumi.Input[str] latest_deployment: The service latest deployment ID
        :param pulumi.Input[str] messages: The status messages of the service
        :param pulumi.Input[str] name: The service name
        :param pulumi.Input[str] organization_id: The organization ID owning the service
        :param pulumi.Input[str] paused_at: The date and time of when the service was last updated
        :param pulumi.Input[str] resumed_at: The date and time of when the service was last updated
        :param pulumi.Input[str] status: The status of the service
        :param pulumi.Input[str] terminated_at: The date and time of when the service was last updated
        :param pulumi.Input[str] updated_at: The date and time of when the service was last updated
        :param pulumi.Input[str] version: The version of the service
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KoyebServiceState.__new__(_KoyebServiceState)

        __props__.__dict__["active_deployment"] = active_deployment
        __props__.__dict__["app_id"] = app_id
        __props__.__dict__["app_name"] = app_name
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["definition"] = definition
        __props__.__dict__["latest_deployment"] = latest_deployment
        __props__.__dict__["messages"] = messages
        __props__.__dict__["name"] = name
        __props__.__dict__["organization_id"] = organization_id
        __props__.__dict__["paused_at"] = paused_at
        __props__.__dict__["resumed_at"] = resumed_at
        __props__.__dict__["status"] = status
        __props__.__dict__["terminated_at"] = terminated_at
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["version"] = version
        return KoyebService(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeDeployment")
    def active_deployment(self) -> pulumi.Output[str]:
        """
        The service active deployment ID
        """
        return pulumi.get(self, "active_deployment")

    @property
    @pulumi.getter(name="appId")
    def app_id(self) -> pulumi.Output[str]:
        """
        The app id the service is assigned to
        """
        return pulumi.get(self, "app_id")

    @property
    @pulumi.getter(name="appName")
    def app_name(self) -> pulumi.Output[str]:
        """
        The app name the service is assigned to
        """
        return pulumi.get(self, "app_name")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date and time of when the service was created
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def definition(self) -> pulumi.Output['outputs.KoyebServiceDefinition']:
        """
        The service deployment definition
        """
        return pulumi.get(self, "definition")

    @property
    @pulumi.getter(name="latestDeployment")
    def latest_deployment(self) -> pulumi.Output[str]:
        """
        The service latest deployment ID
        """
        return pulumi.get(self, "latest_deployment")

    @property
    @pulumi.getter
    def messages(self) -> pulumi.Output[str]:
        """
        The status messages of the service
        """
        return pulumi.get(self, "messages")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The service name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="organizationId")
    def organization_id(self) -> pulumi.Output[str]:
        """
        The organization ID owning the service
        """
        return pulumi.get(self, "organization_id")

    @property
    @pulumi.getter(name="pausedAt")
    def paused_at(self) -> pulumi.Output[str]:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "paused_at")

    @property
    @pulumi.getter(name="resumedAt")
    def resumed_at(self) -> pulumi.Output[str]:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "resumed_at")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the service
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="terminatedAt")
    def terminated_at(self) -> pulumi.Output[str]:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "terminated_at")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The date and time of when the service was last updated
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The version of the service
        """
        return pulumi.get(self, "version")

