"use strict";
/**
 *  Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const core_1 = require("@aws-solutions-constructs/core");
const integ_tests_alpha_1 = require("@aws-cdk/integ-tests-alpha");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, (0, core_1.generateIntegStackName)(__filename));
(0, core_1.SetConsistentFeatureFlags)(stack);
stack.templateOptions.description = 'Integration Test for aws-apigateway-sqs';
new lib_1.ApiGatewayToSqs(stack, 'test-api-gateway-sqs-integration-responses', {
    allowReadOperation: true,
    readIntegrationResponses: [
        {
            statusCode: '200',
            responseTemplates: {
                'text/html': 'OK'
            }
        }
    ],
    readMethodResponses: [{
            statusCode: '200'
        },
        {
            statusCode: '403'
        }],
    allowCreateOperation: true,
    createIntegrationResponses: [
        {
            statusCode: '201',
            responseTemplates: {
                'text/html': 'OK'
            }
        }
    ],
    createMethodResponses: [{
            statusCode: '201'
        }]
});
// Synth
new integ_tests_alpha_1.IntegTest(stack, 'Integ', { testCases: [
        stack
    ] });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuYXBpc3FzLWN1c3RvbS1tZXRob2QtcmVzcG9uc2VzLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcuYXBpc3FzLWN1c3RvbS1tZXRob2QtcmVzcG9uc2VzLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7Ozs7Ozs7Ozs7R0FXRzs7QUFFSCxVQUFVO0FBQ1YsNkNBQXlDO0FBQ3pDLGdDQUF5QztBQUN6Qyx5REFBbUc7QUFDbkcsa0VBQXVEO0FBRXZELFFBQVE7QUFDUixNQUFNLEdBQUcsR0FBRyxJQUFJLGlCQUFHLEVBQUUsQ0FBQztBQUN0QixNQUFNLEtBQUssR0FBRyxJQUFJLG1CQUFLLENBQUMsR0FBRyxFQUFFLElBQUEsNkJBQXNCLEVBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQztBQUNqRSxJQUFBLGdDQUF5QixFQUFDLEtBQUssQ0FBQyxDQUFDO0FBQ2pDLEtBQUssQ0FBQyxlQUFlLENBQUMsV0FBVyxHQUFHLHlDQUF5QyxDQUFDO0FBRTlFLElBQUkscUJBQWUsQ0FBQyxLQUFLLEVBQUUsNENBQTRDLEVBQUU7SUFDdkUsa0JBQWtCLEVBQUUsSUFBSTtJQUN4Qix3QkFBd0IsRUFBRTtRQUN4QjtZQUNFLFVBQVUsRUFBRSxLQUFLO1lBQ2pCLGlCQUFpQixFQUFFO2dCQUNqQixXQUFXLEVBQUUsSUFBSTthQUNsQjtTQUNGO0tBQ0Y7SUFDRCxtQkFBbUIsRUFBRSxDQUFDO1lBQ3BCLFVBQVUsRUFBRSxLQUFLO1NBQ2xCO1FBQ0Q7WUFDRSxVQUFVLEVBQUUsS0FBSztTQUNsQixDQUFDO0lBQ0Ysb0JBQW9CLEVBQUUsSUFBSTtJQUMxQiwwQkFBMEIsRUFBRTtRQUMxQjtZQUNFLFVBQVUsRUFBRSxLQUFLO1lBQ2pCLGlCQUFpQixFQUFFO2dCQUNqQixXQUFXLEVBQUUsSUFBSTthQUNsQjtTQUNGO0tBQ0Y7SUFDRCxxQkFBcUIsRUFBRSxDQUFDO1lBQ3RCLFVBQVUsRUFBRSxLQUFLO1NBQ2xCLENBQUM7Q0FDSCxDQUFDLENBQUM7QUFFSCxRQUFRO0FBQ1IsSUFBSSw2QkFBUyxDQUFDLEtBQUssRUFBRSxPQUFPLEVBQUUsRUFBRSxTQUFTLEVBQUU7UUFDekMsS0FBSztLQUNOLEVBQUUsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG4gKlxuICogIExpY2Vuc2VkIHVuZGVyIHRoZSBBcGFjaGUgTGljZW5zZSwgVmVyc2lvbiAyLjAgKHRoZSBcIkxpY2Vuc2VcIikuIFlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2VcbiAqICB3aXRoIHRoZSBMaWNlbnNlLiBBIGNvcHkgb2YgdGhlIExpY2Vuc2UgaXMgbG9jYXRlZCBhdFxuICpcbiAqICAgICAgaHR0cDovL3d3dy5hcGFjaGUub3JnL2xpY2Vuc2VzL0xJQ0VOU0UtMi4wXG4gKlxuICogIG9yIGluIHRoZSAnbGljZW5zZScgZmlsZSBhY2NvbXBhbnlpbmcgdGhpcyBmaWxlLiBUaGlzIGZpbGUgaXMgZGlzdHJpYnV0ZWQgb24gYW4gJ0FTIElTJyBCQVNJUywgV0lUSE9VVCBXQVJSQU5USUVTXG4gKiAgT1IgQ09ORElUSU9OUyBPRiBBTlkgS0lORCwgZXhwcmVzcyBvciBpbXBsaWVkLiBTZWUgdGhlIExpY2Vuc2UgZm9yIHRoZSBzcGVjaWZpYyBsYW5ndWFnZSBnb3Zlcm5pbmcgcGVybWlzc2lvbnNcbiAqICBhbmQgbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKi9cblxuLy8gSW1wb3J0c1xuaW1wb3J0IHsgQXBwLCBTdGFjayB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuaW1wb3J0IHsgQXBpR2F0ZXdheVRvU3FzIH0gZnJvbSBcIi4uL2xpYlwiO1xuaW1wb3J0IHsgZ2VuZXJhdGVJbnRlZ1N0YWNrTmFtZSwgU2V0Q29uc2lzdGVudEZlYXR1cmVGbGFncyB9IGZyb20gJ0Bhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvY29yZSc7XG5pbXBvcnQgeyBJbnRlZ1Rlc3QgfSBmcm9tICdAYXdzLWNkay9pbnRlZy10ZXN0cy1hbHBoYSc7XG5cbi8vIFNldHVwXG5jb25zdCBhcHAgPSBuZXcgQXBwKCk7XG5jb25zdCBzdGFjayA9IG5ldyBTdGFjayhhcHAsIGdlbmVyYXRlSW50ZWdTdGFja05hbWUoX19maWxlbmFtZSkpO1xuU2V0Q29uc2lzdGVudEZlYXR1cmVGbGFncyhzdGFjayk7XG5zdGFjay50ZW1wbGF0ZU9wdGlvbnMuZGVzY3JpcHRpb24gPSAnSW50ZWdyYXRpb24gVGVzdCBmb3IgYXdzLWFwaWdhdGV3YXktc3FzJztcblxubmV3IEFwaUdhdGV3YXlUb1NxcyhzdGFjaywgJ3Rlc3QtYXBpLWdhdGV3YXktc3FzLWludGVncmF0aW9uLXJlc3BvbnNlcycsIHtcbiAgYWxsb3dSZWFkT3BlcmF0aW9uOiB0cnVlLFxuICByZWFkSW50ZWdyYXRpb25SZXNwb25zZXM6IFtcbiAgICB7XG4gICAgICBzdGF0dXNDb2RlOiAnMjAwJyxcbiAgICAgIHJlc3BvbnNlVGVtcGxhdGVzOiB7XG4gICAgICAgICd0ZXh0L2h0bWwnOiAnT0snXG4gICAgICB9XG4gICAgfVxuICBdLFxuICByZWFkTWV0aG9kUmVzcG9uc2VzOiBbe1xuICAgIHN0YXR1c0NvZGU6ICcyMDAnXG4gIH0sXG4gIHtcbiAgICBzdGF0dXNDb2RlOiAnNDAzJ1xuICB9XSxcbiAgYWxsb3dDcmVhdGVPcGVyYXRpb246IHRydWUsXG4gIGNyZWF0ZUludGVncmF0aW9uUmVzcG9uc2VzOiBbXG4gICAge1xuICAgICAgc3RhdHVzQ29kZTogJzIwMScsXG4gICAgICByZXNwb25zZVRlbXBsYXRlczoge1xuICAgICAgICAndGV4dC9odG1sJzogJ09LJ1xuICAgICAgfVxuICAgIH1cbiAgXSxcbiAgY3JlYXRlTWV0aG9kUmVzcG9uc2VzOiBbe1xuICAgIHN0YXR1c0NvZGU6ICcyMDEnXG4gIH1dXG59KTtcblxuLy8gU3ludGhcbm5ldyBJbnRlZ1Rlc3Qoc3RhY2ssICdJbnRlZycsIHsgdGVzdENhc2VzOiBbXG4gIHN0YWNrXG5dIH0pO1xuIl19