"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LayerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const lambda_generated_1 = require("./lambda.generated");
const runtime_1 = require("./runtime");
/**
 * A reference to a Lambda Layer version.
 */
class LayerVersionBase extends core_1.Resource {
    addPermission(id, permission) {
        if (permission.organizationId != null && permission.accountId !== '*') {
            throw new Error(`OrganizationId can only be specified if AwsAccountId is '*', but it is ${permission.accountId}`);
        }
        new lambda_generated_1.CfnLayerVersionPermission(this, id, {
            action: 'lambda:GetLayerVersion',
            layerVersionArn: this.layerVersionArn,
            principal: permission.accountId,
            organizationId: permission.organizationId,
        });
    }
}
/**
 * Defines a new Lambda Layer version.
 */
class LayerVersion extends LayerVersionBase {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, {
            physicalName: props.layerVersionName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_LayerVersionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.compatibleRuntimes && props.compatibleRuntimes.length === 0) {
            throw new Error('Attempted to define a Lambda layer that supports no runtime!');
        }
        // Allow usage of the code in this context...
        const code = props.code.bind(this);
        if (code.inlineCode) {
            throw new Error('Inline code is not supported for AWS Lambda layers');
        }
        if (!code.s3Location) {
            throw new Error('Code must define an S3 location');
        }
        const resource = new lambda_generated_1.CfnLayerVersion(this, 'Resource', {
            compatibleRuntimes: props.compatibleRuntimes && props.compatibleRuntimes.map(r => r.name),
            compatibleArchitectures: (_b = props.compatibleArchitectures) === null || _b === void 0 ? void 0 : _b.map(a => a.name),
            content: {
                s3Bucket: code.s3Location.bucketName,
                s3Key: code.s3Location.objectKey,
                s3ObjectVersion: code.s3Location.objectVersion,
            },
            description: props.description,
            layerName: this.physicalName,
            licenseInfo: props.license,
        });
        if (props.removalPolicy) {
            resource.applyRemovalPolicy(props.removalPolicy);
        }
        props.code.bindToResource(resource, {
            resourceProperty: 'Content',
        });
        this.layerVersionArn = resource.ref;
        this.compatibleRuntimes = props.compatibleRuntimes;
    }
    /**
     * Imports a layer version by ARN. Assumes it is compatible with all Lambda runtimes.
     */
    static fromLayerVersionArn(scope, id, layerVersionArn) {
        return LayerVersion.fromLayerVersionAttributes(scope, id, {
            layerVersionArn,
            compatibleRuntimes: runtime_1.Runtime.ALL,
        });
    }
    /**
     * Imports a Layer that has been defined externally.
     *
     * @param scope the parent Construct that will use the imported layer.
     * @param id    the id of the imported layer in the construct tree.
     * @param attrs the properties of the imported layer.
     */
    static fromLayerVersionAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_LayerVersionAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromLayerVersionAttributes);
            }
            throw error;
        }
        if (attrs.compatibleRuntimes && attrs.compatibleRuntimes.length === 0) {
            throw new Error('Attempted to import a Lambda layer that supports no runtime!');
        }
        class Import extends LayerVersionBase {
            constructor() {
                super(...arguments);
                this.layerVersionArn = attrs.layerVersionArn;
                this.compatibleRuntimes = attrs.compatibleRuntimes;
            }
        }
        return new Import(scope, id);
    }
}
exports.LayerVersion = LayerVersion;
_a = JSII_RTTI_SYMBOL_1;
LayerVersion[_a] = { fqn: "@aws-cdk/aws-lambda.LayerVersion", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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