"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInsightsVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const architecture_1 = require("./architecture");
// To add new versions, update fact-tables.ts `CLOUDWATCH_LAMBDA_INSIGHTS_ARNS` and create a new `public static readonly VERSION_A_B_C_D`
/**
 * Version of CloudWatch Lambda Insights
 */
class LambdaInsightsVersion {
    constructor() {
        /**
         * The arn of the Lambda Insights extension
         */
        this.layerVersionArn = '';
    }
    /**
     * Use the insights extension associated with the provided ARN. Make sure the ARN is associated
     * with same region as your function
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-extension-versions.html
     */
    static fromInsightVersionArn(arn) {
        class InsightsArn extends LambdaInsightsVersion {
            constructor() {
                super(...arguments);
                this.layerVersionArn = arn;
            }
            _bind(_scope, _function) {
                return { arn };
            }
        }
        return new InsightsArn();
    }
    // Use the verison to build the object. Not meant to be called by the user -- user should use e.g. VERSION_1_0_54_0
    static fromInsightsVersion(insightsVersion) {
        class InsightsVersion extends LambdaInsightsVersion {
            constructor() {
                super(...arguments);
                this.layerVersionArn = core_1.Lazy.uncachedString({
                    produce: (context) => getVersionArn(context.scope, insightsVersion),
                });
            }
            _bind(_scope, _function) {
                var _b, _c;
                const arch = (_c = (_b = _function.architecture) === null || _b === void 0 ? void 0 : _b.name) !== null && _c !== void 0 ? _c : architecture_1.Architecture.X86_64.name;
                // Check if insights version is valid. This should only happen if one of the public static readonly versions are set incorrectly
                // or if the version is not available for the Lambda Architecture
                const versionExists = region_info_1.RegionInfo.regions.some(regionInfo => regionInfo.cloudwatchLambdaInsightsArn(insightsVersion, arch));
                if (!versionExists) {
                    throw new Error(`Insights version ${insightsVersion} does not exist.`);
                }
                return {
                    arn: getVersionArn(_scope, insightsVersion, arch),
                };
            }
        }
        return new InsightsVersion();
    }
}
exports.LambdaInsightsVersion = LambdaInsightsVersion;
_a = JSII_RTTI_SYMBOL_1;
LambdaInsightsVersion[_a] = { fqn: "@aws-cdk/aws-lambda.LambdaInsightsVersion", version: "1.159.0" };
/**
 * Version 1.0.54.0
 */
LambdaInsightsVersion.VERSION_1_0_54_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.54.0');
/**
 * Version 1.0.86.0
 */
LambdaInsightsVersion.VERSION_1_0_86_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.86.0');
/**
 * Version 1.0.89.0
 */
LambdaInsightsVersion.VERSION_1_0_89_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.89.0');
/**
 * Version 1.0.98.0
 */
LambdaInsightsVersion.VERSION_1_0_98_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.98.0');
/**
 * Version 1.0.119.0
 */
LambdaInsightsVersion.VERSION_1_0_119_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.119.0');
/**
 * Version 1.0.135.0
 */
LambdaInsightsVersion.VERSION_1_0_135_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.135.0');
/**
 * Function to retrieve the correct Lambda Insights ARN from RegionInfo,
 * or create a mapping to look it up at stack deployment time.
 *
 * This function is run on CDK synthesis.
 */
function getVersionArn(scope, insightsVersion, architecture) {
    const scopeStack = core_1.Stack.of(scope);
    const region = scopeStack.region;
    const arch = architecture !== null && architecture !== void 0 ? architecture : architecture_1.Architecture.X86_64.name;
    // Region is defined, look up the arn, or throw an error if the version isn't supported by a region
    if (region !== undefined && !core_1.Token.isUnresolved(region)) {
        const arn = region_info_1.RegionInfo.get(region).cloudwatchLambdaInsightsArn(insightsVersion, arch);
        if (arn === undefined) {
            throw new Error(`Insights version ${insightsVersion} is not supported in region ${region}`);
        }
        return arn;
    }
    // Otherwise, need to add a mapping to be looked up at deployment time
    return scopeStack.regionalFact(region_info_1.FactName.cloudwatchLambdaInsightsVersion(insightsVersion, arch));
}
//# sourceMappingURL=data:application/json;base64,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