"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StartingPosition = exports.EventSourceMapping = exports.SourceAccessConfigurationType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("@aws-cdk/core");
const lambda_generated_1 = require("./lambda.generated");
/**
 * The type of authentication protocol or the VPC components for your event source's SourceAccessConfiguration
 * @see https://docs.aws.amazon.com/lambda/latest/dg/API_SourceAccessConfiguration.html#SSS-Type-SourceAccessConfiguration-Type
 */
class SourceAccessConfigurationType {
    constructor(type) {
        this.type = type;
    }
    /** A custom source access configuration property */
    static of(name) {
        return new SourceAccessConfigurationType(name);
    }
}
exports.SourceAccessConfigurationType = SourceAccessConfigurationType;
_a = JSII_RTTI_SYMBOL_1;
SourceAccessConfigurationType[_a] = { fqn: "@aws-cdk/aws-lambda.SourceAccessConfigurationType", version: "1.159.0" };
/**
 * (MQ) The Secrets Manager secret that stores your broker credentials.
 */
SourceAccessConfigurationType.BASIC_AUTH = new SourceAccessConfigurationType('BASIC_AUTH');
/**
 * The subnets associated with your VPC. Lambda connects to these subnets to fetch data from your Self-Managed Apache Kafka cluster.
 */
SourceAccessConfigurationType.VPC_SUBNET = new SourceAccessConfigurationType('VPC_SUBNET');
/**
 * The VPC security group used to manage access to your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.VPC_SECURITY_GROUP = new SourceAccessConfigurationType('VPC_SECURITY_GROUP');
/**
 * The Secrets Manager ARN of your secret key used for SASL SCRAM-256 authentication of your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.SASL_SCRAM_256_AUTH = new SourceAccessConfigurationType('SASL_SCRAM_256_AUTH');
/**
 * The Secrets Manager ARN of your secret key used for SASL SCRAM-512 authentication of your Self-Managed Apache Kafka brokers.
 */
SourceAccessConfigurationType.SASL_SCRAM_512_AUTH = new SourceAccessConfigurationType('SASL_SCRAM_512_AUTH');
/**
 * The Secrets Manager ARN of your secret key containing the certificate chain (X.509 PEM), private key (PKCS#8 PEM),
 * and private key password (optional) used for mutual TLS authentication of your MSK/Apache Kafka brokers.
 */
SourceAccessConfigurationType.CLIENT_CERTIFICATE_TLS_AUTH = new SourceAccessConfigurationType('CLIENT_CERTIFICATE_TLS_AUTH');
/**
 * Defines a Lambda EventSourceMapping resource.
 *
 * Usually, you won't need to define the mapping yourself. This will usually be done by
 * event sources. For example, to add an SQS event source to a function:
 *
 *    import { SqsEventSource } from '@aws-cdk/aws-lambda-event-sources';
 *    lambda.addEventSource(new SqsEventSource(sqs));
 *
 * The `SqsEventSource` class will automatically create the mapping, and will also
 * modify the Lambda's execution role so it can consume messages from the queue.
 */
class EventSourceMapping extends cdk.Resource {
    constructor(scope, id, props) {
        var _c, _d, _e, _f, _g;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_EventSourceMappingProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.eventSourceArn == undefined && props.kafkaBootstrapServers == undefined) {
            throw new Error('Either eventSourceArn or kafkaBootstrapServers must be set');
        }
        if (props.eventSourceArn !== undefined && props.kafkaBootstrapServers !== undefined) {
            throw new Error('eventSourceArn and kafkaBootstrapServers are mutually exclusive');
        }
        if (props.kafkaBootstrapServers && (((_c = props.kafkaBootstrapServers) === null || _c === void 0 ? void 0 : _c.length) < 1)) {
            throw new Error('kafkaBootStrapServers must not be empty if set');
        }
        if (props.maxBatchingWindow && props.maxBatchingWindow.toSeconds() > 300) {
            throw new Error(`maxBatchingWindow cannot be over 300 seconds, got ${props.maxBatchingWindow.toSeconds()}`);
        }
        if (props.maxRecordAge && (props.maxRecordAge.toSeconds() < 60 || props.maxRecordAge.toDays({ integral: false }) > 7)) {
            throw new Error('maxRecordAge must be between 60 seconds and 7 days inclusive');
        }
        props.retryAttempts !== undefined && cdk.withResolved(props.retryAttempts, (attempts) => {
            if (attempts < 0 || attempts > 10000) {
                throw new Error(`retryAttempts must be between 0 and 10000 inclusive, got ${attempts}`);
            }
        });
        props.parallelizationFactor !== undefined && cdk.withResolved(props.parallelizationFactor, (factor) => {
            if (factor < 1 || factor > 10) {
                throw new Error(`parallelizationFactor must be between 1 and 10 inclusive, got ${factor}`);
            }
        });
        if (props.tumblingWindow && !cdk.Token.isUnresolved(props.tumblingWindow) && props.tumblingWindow.toSeconds() > 900) {
            throw new Error(`tumblingWindow cannot be over 900 seconds, got ${props.tumblingWindow.toSeconds()}`);
        }
        let destinationConfig;
        if (props.onFailure) {
            destinationConfig = {
                onFailure: props.onFailure.bind(this, props.target),
            };
        }
        let selfManagedEventSource;
        if (props.kafkaBootstrapServers) {
            selfManagedEventSource = { endpoints: { kafkaBootstrapServers: props.kafkaBootstrapServers } };
        }
        const cfnEventSourceMapping = new lambda_generated_1.CfnEventSourceMapping(this, 'Resource', {
            batchSize: props.batchSize,
            bisectBatchOnFunctionError: props.bisectBatchOnError,
            destinationConfig,
            enabled: props.enabled,
            eventSourceArn: props.eventSourceArn,
            functionName: props.target.functionName,
            startingPosition: props.startingPosition,
            functionResponseTypes: props.reportBatchItemFailures ? ['ReportBatchItemFailures'] : undefined,
            maximumBatchingWindowInSeconds: (_d = props.maxBatchingWindow) === null || _d === void 0 ? void 0 : _d.toSeconds(),
            maximumRecordAgeInSeconds: (_e = props.maxRecordAge) === null || _e === void 0 ? void 0 : _e.toSeconds(),
            maximumRetryAttempts: props.retryAttempts,
            parallelizationFactor: props.parallelizationFactor,
            topics: props.kafkaTopic !== undefined ? [props.kafkaTopic] : undefined,
            tumblingWindowInSeconds: (_f = props.tumblingWindow) === null || _f === void 0 ? void 0 : _f.toSeconds(),
            sourceAccessConfigurations: (_g = props.sourceAccessConfigurations) === null || _g === void 0 ? void 0 : _g.map((o) => { return { type: o.type.type, uri: o.uri }; }),
            selfManagedEventSource,
        });
        this.eventSourceMappingId = cfnEventSourceMapping.ref;
    }
    /**
     * Import an event source into this stack from its event source id.
     */
    static fromEventSourceMappingId(scope, id, eventSourceMappingId) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.eventSourceMappingId = eventSourceMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.EventSourceMapping = EventSourceMapping;
_b = JSII_RTTI_SYMBOL_1;
EventSourceMapping[_b] = { fqn: "@aws-cdk/aws-lambda.EventSourceMapping", version: "1.159.0" };
/**
 * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start
 * reading.
 */
var StartingPosition;
(function (StartingPosition) {
    /**
     * Start reading at the last untrimmed record in the shard in the system,
     * which is the oldest data record in the shard.
     */
    StartingPosition["TRIM_HORIZON"] = "TRIM_HORIZON";
    /**
     * Start reading just after the most recent record in the shard, so that you
     * always read the most recent data in the shard
     */
    StartingPosition["LATEST"] = "LATEST";
})(StartingPosition = exports.StartingPosition || (exports.StartingPosition = {}));
//# sourceMappingURL=data:application/json;base64,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