"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EventInvokeConfig = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const destination_1 = require("./destination");
const lambda_generated_1 = require("./lambda.generated");
/**
 * Configure options for asynchronous invocation on a version or an alias
 *
 * By default, Lambda retries an asynchronous invocation twice if the function
 * returns an error. It retains events in a queue for up to six hours. When an
 * event fails all processing attempts or stays in the asynchronous invocation
 * queue for too long, Lambda discards it.
 */
class EventInvokeConfig extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_lambda_EventInvokeConfigProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        if (props.maxEventAge && (props.maxEventAge.toSeconds() < 60 || props.maxEventAge.toSeconds() > 21600)) {
            throw new Error('`maximumEventAge` must represent a `Duration` that is between 60 and 21600 seconds.');
        }
        if (props.retryAttempts && (props.retryAttempts < 0 || props.retryAttempts > 2)) {
            throw new Error('`retryAttempts` must be between 0 and 2.');
        }
        new lambda_generated_1.CfnEventInvokeConfig(this, 'Resource', {
            destinationConfig: props.onFailure || props.onSuccess
                ? {
                    ...props.onFailure ? { onFailure: props.onFailure.bind(this, props.function, { type: destination_1.DestinationType.FAILURE }) } : {},
                    ...props.onSuccess ? { onSuccess: props.onSuccess.bind(this, props.function, { type: destination_1.DestinationType.SUCCESS }) } : {},
                }
                : undefined,
            functionName: props.function.functionName,
            maximumEventAgeInSeconds: props.maxEventAge && props.maxEventAge.toSeconds(),
            maximumRetryAttempts: (_b = props.retryAttempts) !== null && _b !== void 0 ? _b : undefined,
            qualifier: props.qualifier || '$LATEST',
        });
    }
}
exports.EventInvokeConfig = EventInvokeConfig;
_a = JSII_RTTI_SYMBOL_1;
EventInvokeConfig[_a] = { fqn: "@aws-cdk/aws-lambda.EventInvokeConfig", version: "1.159.0" };
//# sourceMappingURL=data:application/json;base64,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