"""  X-ray photo-absorption cross-sections for inelastic scattering from NIST
The cross sections are given in atoms/nm^3 not barns!!
See xsec_xrpa function in eels_tools for usage.

for pyTEMLib by Gerd

copyright 2022, Gerd Duscher
"""

import numpy as np

x_sections = {'1': {'name': 'H',
                    'barns': 16738200000.0,
                    'NumEdges': 1,
                    'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 13.6, 'factor': 1.0},
                    'ene': np.array([13.668, 13.872, 13.9601, 14.92335, 15.95306, 17.05382, 18.23053, 19.48844,
                                     20.83314, 22.27063, 23.8073, 25.45001, 27.20606, 29.08327, 31.09002, 33.23523,
                                     35.52846, 37.97993, 40.60054, 43.40198, 46.39671, 49.59809, 53.02035, 56.67876,
                                     60.58959, 64.77028, 69.23942, 74.01695, 79.12411, 84.58368, 90.41995, 96.65893,
                                     103.3284, 110.4581, 118.0797, 126.2272, 134.9368, 144.2475, 154.2005, 164.8404,
                                     176.2144, 188.3732, 201.3709, 215.2655, 230.1188, 245.997, 262.9708, 281.1158,
                                     300.5128, 321.2482, 343.4143, 367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                     512.4891, 547.8508, 585.6525, 626.0625, 669.2609, 715.4399, 764.8052, 817.5768,
                                     873.9896, 934.2948, 998.7612, 1067.676, 1141.345, 1220.098, 1304.285, 1394.281,
                                     1490.486, 1593.329, 1703.269, 1820.795, 1946.43, 2080.733, 2224.304, 2377.781,
                                     2541.848, 2717.235, 2904.724]),
                    'dat': np.array([4.86679903e+16, 4.68602647e+16, 4.61087195e+16, 3.88493622e+16,
                                     3.26930522e+16, 2.74791029e+16, 2.30702611e+16, 1.93443377e+16,
                                     1.62022428e+16, 1.35547617e+16, 1.13269073e+16, 9.45440489e+15,
                                     7.88285529e+15, 6.56505680e+15, 5.46184204e+15, 4.53889769e+15,
                                     3.76810358e+15, 3.12485456e+15, 2.58856263e+15, 2.14232222e+15,
                                     1.77106894e+15, 1.46273456e+15, 1.20689117e+15, 9.94818179e+14,
                                     8.19217723e+14, 6.73963623e+14, 5.53950729e+14, 4.54894061e+14,
                                     3.73194907e+14, 3.05907343e+14, 2.50520639e+14, 2.04992735e+14,
                                     1.67582858e+14, 1.36890021e+14, 1.11722464e+14, 9.11076964e+13,
                                     7.42355908e+13, 6.04399664e+13, 4.91701363e+13, 3.99708216e+13,
                                     3.24670865e+13, 2.63526221e+13, 2.13730076e+13, 1.73223632e+13,
                                     1.40301266e+13, 1.13551949e+13, 9.18391558e+12, 7.42288955e+12,
                                     5.99562324e+12, 4.83951577e+12, 3.90401777e+12, 3.14728375e+12,
                                     2.53566992e+12, 2.04172564e+12, 1.64305519e+12, 1.32146415e+12,
                                     1.06222291e+12, 8.53363651e+11, 6.85211693e+11, 5.49916823e+11,
                                     4.41101785e+11, 3.53644690e+11, 2.83394464e+11, 2.26986730e+11,
                                     1.81726637e+11, 1.45423155e+11, 1.16323795e+11, 9.30074821e+10,
                                     7.43343462e+10, 5.93871336e+10, 4.74276897e+10, 3.78618084e+10,
                                     3.02157986e+10, 2.41046818e+10, 1.92238227e+10, 1.53258307e+10,
                                     1.22147014e+10, 9.73225901e+09, 7.75212995e+09, 6.17321554e+09,
                                     4.91467028e+09, 3.91171734e+09, 3.11280305e+09])},
              '2': {'name': 'He',
                    'barns': 66471400000.0,
                    'NumEdges': 1,
                    'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 24.6, 'factor': 1.0,
                           'shape': 'hydrogenic'},
                    'ene': np.array([24.723, 25.092, 25.45001, 27.20606, 29.08327,
                                     31.09002, 33.23523, 35.52846, 37.97993, 40.60054,
                                     43.40198, 46.39671, 49.59809, 53.02035, 56.67876,
                                     60.58959, 64.77028, 69.23942, 74.01695, 79.12411,
                                     84.58368, 90.41995, 96.65893, 103.3284, 110.4581,
                                     118.0797, 126.2272, 134.9368, 144.2475, 154.2005,
                                     164.8404, 176.2144, 188.3732, 201.3709, 215.2655,
                                     230.1188, 245.997, 262.9708, 281.1158, 300.5128,
                                     321.2482, 343.4143, 367.1099, 392.4405, 419.5189,
                                     448.4657, 479.4098, 512.4891, 547.8508, 585.6525,
                                     626.0625, 669.2609, 715.4399, 764.8052, 817.5768,
                                     873.9896, 934.2948, 998.7612, 1067.676, 1141.345,
                                     1220.098, 1304.285, 1394.281, 1490.486, 1593.329,
                                     1703.269, 1820.795, 1946.43, 2080.733, 2224.304,
                                     2377.781, 2541.848, 2717.235, 2904.724]),
                    'dat': np.array([5.62766814e+16, 5.47165976e+16, 5.32622034e+16, 4.68683194e+16,
                                     4.11757087e+16, 3.61165705e+16, 3.16277568e+16, 2.76527671e+16,
                                     2.41384242e+16, 2.10368687e+16, 1.83042294e+16, 1.59012883e+16,
                                     1.37914861e+16, 1.19429164e+16, 1.03250026e+16, 8.91182060e+15,
                                     7.68010556e+15, 6.60772246e+15, 5.67605932e+15, 4.86796651e+15,
                                     4.16815561e+15, 3.56326587e+15, 3.04126596e+15, 2.59152047e+15,
                                     2.20478987e+15, 1.87276522e+15, 1.58813469e+15, 1.34464995e+15,
                                     1.13666094e+15, 9.59248773e+14, 8.08292224e+14, 6.80002422e+14,
                                     5.71108975e+14, 4.78906496e+14, 4.00942191e+14, 3.35135505e+14,
                                     2.79678416e+14, 2.33022140e+14, 1.93837250e+14, 1.60980437e+14,
                                     1.33481218e+14, 1.10502055e+14, 9.13317036e+13, 7.53652733e+13,
                                     6.20922642e+13, 5.10733002e+13, 4.19427887e+13, 3.43889788e+13,
                                     2.81506379e+13, 2.30064163e+13, 1.87721881e+13, 1.52930750e+13,
                                     1.24387931e+13, 1.01003292e+13, 8.18861177e+12, 6.62839507e+12,
                                     5.35666424e+12, 4.32197043e+12, 3.46867707e+12, 2.78103043e+12,
                                     2.22772250e+12, 1.78296236e+12, 1.42574506e+12, 1.13912038e+12,
                                     9.09461695e+11, 7.25468860e+11, 5.78314474e+11, 4.60660096e+11,
                                     3.66689478e+11, 2.91689797e+11, 2.31878832e+11, 1.84218838e+11,
                                     1.46270316e+11, 1.16065712e+11])},
              '3': {'name': 'Li',
                    'barns': 115258000000.0,
                    'NumEdges': 2,
                    'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5.34, 'factor': 1.0},
                    'K1': {'filename': 'Li.K1', 'excl before': 5, 'excl after': 50, 'onset': 54.75, 'factor': 1.0,
                           'shape': 'hydrogenic'},
                    'ene': np.array([5.3667, 5.4468, 10.69, 11.42761, 12.21612,
                                     13.05903, 13.9601, 14.92335, 15.95306, 17.05382,
                                     18.23053, 19.48844, 20.83314, 22.27063, 23.8073,
                                     25.45001, 27.20606, 29.08327, 31.09002, 33.23523,
                                     35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                     49.59809, 53.02035, 53.655, 54.47625, 54.69525,
                                     55.02375, 55.845, 56.67876, 60.58959, 64.77028,
                                     69.23942, 74.01695, 79.12411, 84.58368, 90.41995,
                                     96.65893, 103.3284, 110.4581, 118.0797, 126.2272,
                                     134.9368, 144.2475, 154.2005, 164.8404, 176.2144,
                                     188.3732, 201.3709, 215.2655, 230.1188, 245.997,
                                     262.9708, 281.1158, 300.5128, 321.2482, 343.4143,
                                     367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                     512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                     715.4399, 764.8052, 817.5768, 873.9896, 934.2948,
                                     998.7612, 1067.676, 1141.345, 1220.098, 1304.285,
                                     1394.281, 1490.486, 1593.329, 1703.269, 1820.795,
                                     1946.43, 2080.733, 2224.304, 2377.781, 2541.848,
                                     2717.235, 2904.724]),
                    'dat': np.array([1.40211357e+16, 1.40960534e+16, 1.15995651e+16, 1.08358656e+16,
                                     1.00561452e+16, 9.27561807e+15, 8.50753875e+15, 7.76239578e+15,
                                     7.04860299e+15, 6.37192327e+15, 5.73662118e+15, 5.14523238e+15,
                                     4.59879420e+15, 4.09661509e+15, 3.63673567e+15, 3.21823388e+15,
                                     2.83961135e+15, 2.49913921e+15, 2.19416655e+15, 1.92227292e+15,
                                     1.68080741e+15, 1.46711908e+15, 1.27844174e+15, 1.11234343e+15,
                                     9.66507485e+14, 8.38732466e+14, 7.27001361e+14, 7.08629236e+14,
                                     6.85796626e+14, 6.79883890e+14, 3.28635135e+16, 3.25142818e+16,
                                     3.21673552e+16, 3.06551703e+16, 2.88940280e+16, 2.67594499e+16,
                                     2.44012712e+16, 2.19531913e+16, 1.95189423e+16, 1.71780523e+16,
                                     1.49846926e+16, 1.29711353e+16, 1.11547845e+16, 9.53909785e+15,
                                     8.11865826e+15, 6.88182466e+15, 5.81349826e+15, 4.89673613e+15,
                                     4.11436483e+15, 3.44967194e+15, 2.88721290e+15, 2.41281097e+15,
                                     2.01355726e+15, 1.67827174e+15, 1.39692696e+15, 1.16145487e+15,
                                     9.64559625e+14, 8.00236294e+14, 6.63263687e+14, 5.49238947e+14,
                                     4.54393139e+14, 3.75602770e+14, 3.10216907e+14, 2.55988018e+14,
                                     2.11071975e+14, 1.73901270e+14, 1.43161962e+14, 1.17759099e+14,
                                     9.67982787e+13, 7.95118839e+13, 6.52683002e+13, 5.35431039e+13,
                                     4.38971619e+13, 3.59697166e+13, 2.94599448e+13, 2.41165839e+13,
                                     1.95904023e+13, 1.58664163e+13, 1.28501144e+13, 1.04073364e+13,
                                     8.42881754e+12, 6.82650082e+12, 5.52869574e+12, 4.47777330e+12,
                                     3.62647771e+12, 2.93711961e+12, 2.37869460e+12, 1.92653747e+12,
                                     1.56024755e+12, 1.26357345e+12, 1.02328358e+12, 8.28670443e+11])},
              '4': {'name': 'Be',
                    'barns': 149651000000.0,
                    'NumEdges': 2,
                    'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8.42, 'factor': 1.0},
                    'K1': {'filename': 'Be.K1', 'excl before': 5, 'excl after': 50, 'onset': 111, 'factor': 1.0,
                           'shape': 'hydrogenic'},
                    'ene': np.array([8.4621, 8.5884, 10.69, 11.42761, 12.21612, 1305903, 11.39601, 14.92335, 15.95306,
                                     17.05382, 18.23053, 19.48844, 20.83314, 22.27063, 23.80730, 25.45001, 27.20606,
                                     29.08327, 31.09002, 33.23523, 35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                     49.59809, 53.02035, 56.67876, 60.58959, 64.77028, 69.23942, 74.01695, 79.12411,
                                     84.58368, 90.41995, 96.65893, 103.3284, 108.7800, 110.4581, 110.8890, 111.5550,
                                     113.2200, 118.0797, 126.2272, 134.9368, 144.2475, 154.2005, 164.8404, 176.2144,
                                     188.3732, 201.3709, 215.2655, 230.1188, 245.9970, 262.9708, 281.1158, 300.5128,
                                     321.2482, 343.4143, 367.1099, 392.4405, 419.5189, 448.4657, 479.4098, 512.4891,
                                     547.8508, 585.6525, 626.0625, 669.2609, 715.4399, 764.8052, 817.5768, 873.9896,
                                     934.2948, 998.7612, 1067.676, 1141.345, 1220.098, 1304.285, 1394.281, 1490.486,
                                     1593.329, 1703.269, 1820.795, 1946.430, 2080.733, 2224.304, 2377.781, 2541.848,
                                     2717.235, 2904.724]),
                    'dat': np.array([5.37E+04, 5.59E+04, 9.28E+04, 1.01E+05, 1.07E+05, 1.10E+05, 1.10E+05, 1.09E+05, 1.06E+05,
                                     1.01E+05, 9.59E+04, 8.98E+04, 8.33E+04, 7.68E+04, 7.03E+04, 6.40E+04, 5.81E+04, 5.25E+04,
                                     4.72E+04, 4.24E+04, 3.80E+04, 3.40E+04, 3.03E+04, 2.70E+04, 2.40E+04, 2.12E+04, 1.88E+04,
                                     1.66E+04, 1.47E+04, 1.29E+04, 1.14E+04, 1.00E+04, 8.77E+03, 7.68E+03, 6.72E+03, 5.87E+03,
                                     5.12E+03, 4.61E+03, 4.46E+03, 4.43E+03, 1.70E+05, 1.65E+05, 1.51E+05, 1.31E+05, 1.14E+05,
                                     9.80E+04, 8.42E+04, 7.21E+04, 6.16E+04, 5.24E+04, 4.45E+04, 3.77E+04, 3.19E+04, 2.69E+04,
                                     2.27E+04, 1.90E+04, 1.60E+04, 1.34E+04, 1.12E+04, 9.36E+03, 7.81E+03, 6.51E+03, 5.42E+03,
                                     4.50E+03, 3.74E+03, 3.10E+03, 2.56E+03, 2.12E+03, 1.75E+03, 1.45E+03, 1.19E+03, 9.85E+02,
                                     8.12E+02, 6.69E+02, 5.51E+02, 4.50E+02, 3.68E+02, 3.01E+02, 2.46E+02, 2.01E+02, 1.64E+02,
                                     1.34E+02, 1.10E+02, 8.98E+01, 7.34E+01, 6.00E+01, 4.87E+01, 3.95E+01, 3.21E+01, 2.61E+01,
                                     2.12E+01]) * 1.49651E+11},
              '5': {'name': 'B',
                    'barns': 179503999999.99997,
                    'NumEdges': 2,
                    'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 13.469999999999999,
                           'factor': 1.0},
                    'K1': {'filename': 'B.K1', 'excl before': 5, 'excl after': 50, 'onset': 188.0, 'factor': 1.0,
                           'shape': 'hydrogenic'},
                    'ene': np.array([4.7235, 4.794, 10.69, 11.42761, 12.21612,
                                     13.05903, 13.2006, 13.40265, 13.45653, 13.53735,
                                     13.7394, 13.9601, 14.92335, 15.95306, 17.05382,
                                     18.23053, 19.48844, 20.83314, 22.27063, 23.8073,
                                     25.45001, 27.20606, 29.08327, 31.09002, 33.23523,
                                     35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                     49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                     69.23942, 74.01695, 79.12411, 84.58368, 90.41995,
                                     96.65893, 103.3284, 110.4581, 118.0797, 126.2272,
                                     134.9368, 144.2475, 154.2005, 164.8404, 176.2144,
                                     184.24, 187.06, 187.812, 188.3732, 188.94,
                                     191.76, 201.3709, 215.2655, 230.1188, 245.997,
                                     262.9708, 281.1158, 300.5128, 321.2482, 343.4143,
                                     367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                     512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                     715.4399, 764.8052, 817.5768, 873.9896, 934.2948,
                                     998.7612, 1067.676, 1141.345, 1220.098, 1304.285,
                                     1394.281, 1490.486, 1593.329, 1703.269, 1820.795,
                                     1946.43, 2080.733, 2224.304, 2377.781, 2541.848,
                                     2717.235, 2904.724]),
                    'dat': np.array([1.73384709e+17, 1.68319106e+17, 4.17741709e+16, 3.70675760e+16,
                                     3.27899957e+16, 2.89145043e+16, 2.83239362e+16, 2.75089880e+16,
                                     2.72971733e+16, 3.39872874e+16, 3.34739059e+16, 3.29533443e+16,
                                     3.11062482e+16, 2.96127749e+16, 2.82646998e+16, 2.69920165e+16,
                                     2.57318984e+16, 2.44484448e+16, 2.31237053e+16, 2.17576798e+16,
                                     2.03593437e+16, 1.89430571e+16, 1.75265911e+16, 1.61291524e+16,
                                     1.47677941e+16, 1.34574149e+16, 1.22096826e+16, 1.10330339e+16,
                                     9.93339235e+15, 8.91327112e+15, 7.97374718e+15, 7.11320501e+15,
                                     6.32841352e+15, 5.61416710e+15, 4.96741419e+15, 4.38492371e+15,
                                     3.86202856e+15, 3.39477965e+15, 2.97833037e+15, 2.60639808e+15,
                                     2.27431568e+15, 1.98172416e+15, 1.72431542e+15, 1.49840964e+15,
                                     1.30047058e+15, 1.12735692e+15, 9.76196603e+14, 8.44404766e+14,
                                     7.29665810e+14, 6.29933387e+14, 5.70768869e+14, 5.51849147e+14,
                                     5.46948688e+14, 1.46983260e+16, 1.46076765e+16, 1.41693277e+16,
                                     1.28133545e+16, 1.11570711e+16, 9.66072578e+15, 8.32072842e+15,
                                     7.13187342e+15, 6.08769866e+15, 5.17833139e+15, 4.39138586e+15,
                                     3.71429677e+15, 3.13413984e+15, 2.63906781e+15, 2.21795142e+15,
                                     1.86073846e+15, 1.55866913e+15, 1.30370165e+15, 1.08892512e+15,
                                     9.08362042e+14, 7.56788864e+14, 6.29753883e+14, 5.23451614e+14,
                                     4.34597134e+14, 3.60372230e+14, 2.98515152e+14, 2.47051355e+14,
                                     2.04347354e+14, 1.67545444e+14, 1.37356461e+14, 1.12606449e+14,
                                     9.23153171e+13, 7.56824765e+13, 6.20455576e+13, 5.08660485e+13,
                                     4.17005742e+13, 3.41865368e+13, 2.80277546e+13, 2.29783070e+13,
                                     1.88371498e+13, 1.54434471e+13, 1.26607761e+13, 1.03796393e+13,
                                     8.50956662e+12])},
              '6': {'name': 'C',
                    'barns': 199447000000.0,
                    'NumEdges': 3,
                    'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6.4, 'factor': 0.5},
                    'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 19.509999999999998,
                           'factor': 1.0},
                    'K1': {'filename': 'C.K1', 'excl before': 5, 'excl after': 50, 'onset': 283.8, 'factor': 1.0,
                           'shape': 'hydrogenic'},
                    'ene': np.array([6.432, 6.528, 10.69, 11.42761, 12.21612,
                                     13.05903, 13.9601, 14.92335, 15.95306, 17.05382,
                                     18.23053, 19.1198, 19.41245, 19.48844, 19.49049,
                                     19.60755, 19.9002, 20.83314, 22.27063, 23.8073,
                                     25.45001, 27.20606, 29.08327, 31.09002, 33.23523,
                                     35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                     49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                     69.23942, 74.01695, 79.12411, 84.58368, 90.41995,
                                     96.65893, 103.3284, 110.4581, 118.0797, 126.2272,
                                     134.9368, 144.2475, 154.2005, 164.8404, 176.2144,
                                     188.3732, 201.3709, 215.2655, 230.1188, 245.997,
                                     262.9708, 278.124, 281.1158, 282.381, 283.5162,
                                     285.219, 289.476, 300.5128, 321.2482, 343.4143,
                                     367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                     512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                     715.4399, 764.8052, 817.5768, 873.9896, 934.2948,
                                     998.7612, 1067.676, 1141.345, 1220.098, 1304.285,
                                     1394.281, 1490.486, 1593.329, 1703.269, 1820.795,
                                     1946.43]),
                    'dat': np.array([2.13986686e+17, 2.09778355e+17, 1.13682796e+17, 1.04769509e+17,
                                     9.63648125e+16, 8.84148551e+16, 8.08917143e+16, 7.37794342e+16,
                                     6.70660482e+16, 6.07495617e+16, 5.48259858e+16, 5.08410348e+16,
                                     4.96104468e+16, 4.92993095e+16, 4.92893371e+16, 5.43173960e+16,
                                     5.33421002e+16, 5.04840246e+16, 4.67443934e+16, 4.33258718e+16,
                                     4.01566590e+16, 3.71829042e+16, 3.43587347e+16, 3.16701891e+16,
                                     2.91072952e+16, 2.66640694e+16, 2.43405119e+16, 2.21386170e+16,
                                     2.00623737e+16, 1.81155716e+16, 1.62990083e+16, 1.46146784e+16,
                                     1.30613851e+16, 1.16371341e+16, 1.03381358e+16, 9.15900513e+15,
                                     8.09395815e+15, 7.13561532e+15, 6.27480207e+15, 5.50393941e+15,
                                     4.81684450e+15, 4.20653668e+15, 3.66643420e+15, 3.19015476e+15,
                                     2.76154316e+15, 2.38438888e+15, 2.05609912e+15, 1.77106942e+15,
                                     1.52393464e+15, 1.31004767e+15, 1.12520020e+15, 9.65662540e+14,
                                     8.28163778e+14, 7.09772039e+14, 6.07934401e+14, 5.20456946e+14,
                                     4.56613962e+14, 4.45345206e+14, 4.40678146e+14, 4.36569538e+14,
                                     9.64944531e+15, 9.36024716e+15, 8.66816607e+15, 7.55325734e+15,
                                     6.54026602e+15, 5.62679876e+15, 4.81345390e+15, 4.09943364e+15,
                                     3.47855513e+15, 2.94284048e+15, 2.48311515e+15, 2.09060345e+15,
                                     1.75674912e+15, 1.47371388e+15, 1.23435754e+15, 1.03243740e+15,
                                     8.62388883e+14, 7.19445218e+14, 5.99477848e+14, 4.98916670e+14,
                                     4.14750036e+14, 3.44145798e+14, 2.85129431e+14, 2.34549672e+14,
                                     1.92953006e+14, 1.58729895e+14, 1.30575956e+14, 1.07418165e+14,
                                     8.83669878e+13, 7.26944426e+13, 5.98021885e+13])},
              '7': {'name': 'N',
                    'barns': 232587000000.0,
                    'NumEdges': 3,
                    'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9.2, 'factor': 0.5},
                    'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 26.31, 'factor': 1.0},
                    'K1': {'filename': 'N.K1', 'excl before': 5, 'excl after': 50, 'onset': 401.6, 'factor': 1.0,
                           'shape': 'hydrogenic'},
                    'ene': np.array([9.246, 9.384, 10.69, 11.42761, 12.21612,
                                     13.05903, 13.9601, 14.92335, 15.95306, 17.05382,
                                     18.23053, 19.48844, 20.83314, 22.27063, 23.8073,
                                     25.45001, 25.7838, 26.17845, 26.28369, 26.44155,
                                     26.8362, 27.20606, 29.08327, 31.09002, 33.23523,
                                     35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                     49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                     69.23942, 74.01695, 79.12411, 84.58368, 90.41995,
                                     96.65893, 103.3284, 110.4581, 118.0797, 126.2272,
                                     134.9368, 144.2475, 154.2005, 164.8404, 176.2144,
                                     188.3732, 201.3709, 215.2655, 230.1188, 245.997,
                                     262.9708, 281.1158, 300.5128, 321.2482, 343.4143,
                                     367.1099, 392.4405, 393.568, 399.592, 401.1984,
                                     403.608, 409.632, 419.5189, 448.4657, 479.4098,
                                     512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                     715.4399, 764.8052, 817.5768, 873.9896, 934.2948,
                                     998.7612, 1067.676, 1141.345, 1220.098, 1304.285,
                                     1394.281, 1490.486, 1593.329, 1703.269, 1820.795,
                                     1946.43, 2080.733, 2224.304, 2377.781, 2541.848,
                                     2717.235, 2904.724]),
                    'dat': np.array([1.72419069e+17, 1.70453709e+17, 1.54100517e+17, 1.46276290e+17,
                                     1.38721864e+17, 1.31379093e+17, 1.24206110e+17, 1.17170353e+17,
                                     1.10253216e+17, 1.03452372e+17, 9.67631696e+16, 9.02018903e+16,
                                     8.37755115e+16, 7.75096178e+16, 7.14228160e+16, 6.55383649e+16,
                                     6.44149696e+16, 6.31171342e+16, 6.27752313e+16, 6.63268348e+16,
                                     6.52313500e+16, 6.42358777e+16, 5.96097222e+16, 5.52859299e+16,
                                     5.11737917e+16, 4.72547008e+16, 4.35077242e+16, 3.98956481e+16,
                                     3.64301018e+16, 3.31227147e+16, 2.99851160e+16, 2.70312611e+16,
                                     2.42681276e+16, 2.17001345e+16, 1.93317011e+16, 1.71609666e+16,
                                     1.51837445e+16, 1.33932898e+16, 1.17805316e+16, 1.03354685e+16,
                                     9.04623878e+15, 7.90074780e+15, 6.88620331e+15, 5.98888266e+15,
                                     5.19808686e+15, 4.50358208e+15, 3.89536708e+15, 3.36460354e+15,
                                     2.90198800e+15, 2.49542592e+15, 2.13412528e+15, 1.82343556e+15,
                                     1.55677457e+15, 1.32818806e+15, 1.13248936e+15, 9.65119756e+14,
                                     8.22125269e+14, 7.00040353e+14, 5.95911153e+14, 5.07132695e+14,
                                     4.31472144e+14, 3.67068803e+14, 3.64533605e+14, 3.51345922e+14,
                                     3.47950152e+14, 6.97947070e+15, 6.75944339e+15, 6.41986637e+15,
                                     5.55673602e+15, 4.78943150e+15, 4.10539314e+15, 3.50229505e+15,
                                     2.97618325e+15, 2.52054532e+15, 2.12865948e+15, 1.79322251e+15,
                                     1.50734983e+15, 1.26462204e+15, 1.05915468e+15, 8.85691296e+14,
                                     7.39580143e+14, 6.16262515e+14, 5.12784559e+14, 4.26169160e+14,
                                     3.53811344e+14, 2.93501535e+14, 2.43309261e+14, 2.01578501e+14,
                                     1.66155501e+14, 1.36868146e+14, 1.12741897e+14, 9.28696632e+13,
                                     7.65025160e+13, 6.30194476e+13, 5.19134184e+13, 4.27657717e+13,
                                     3.52299529e+13])},
              '8': {'name': 'O',
                    'barns': 265676000000.0,
                    'NumEdges': 4,
                    'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7.1000000000000005,
                           'factor': 1.0, 'twin': 'L2'},
                    'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7.1000000000000005,
                           'factor': 0.5},
                    'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 23.7, 'factor': 1.0},
                    'K1': {'filename': 'O.K1', 'excl before': 5, 'excl after': 50, 'onset': 532.0, 'factor': 1.0,
                           'shape': 'hydrogenic'},
                    'dat': np.array([2.14347397e+17, 2.14137513e+17, 1.87176712e+17, 1.78834486e+17,
                                     1.70290346e+17, 1.61738235e+17, 1.53310993e+17, 1.45093634e+17,
                                     1.37133981e+17, 1.29455945e+17, 1.22059525e+17, 1.14936751e+17,
                                     1.08074340e+17, 1.01453694e+17, 9.74021351e+16, 9.59595144e+16,
                                     9.55795978e+16, 9.87437989e+16, 9.87039475e+16, 9.74579271e+16,
                                     9.32469625e+16, 8.80476832e+16, 8.30104662e+16, 7.80290412e+16,
                                     7.30848108e+16, 6.81910589e+16, 6.33610692e+16, 5.86187526e+16,
                                     5.39906767e+16, 4.95087226e+16, 4.51968011e+16, 4.10788231e+16,
                                     3.71786994e+16, 3.35123706e+16, 3.00904638e+16, 2.69182923e+16,
                                     2.40006385e+16, 2.13305947e+16, 1.89028474e+16, 1.67067696e+16,
                                     1.47304058e+16, 1.29564872e+16, 1.13706671e+16, 9.95886486e+15,
                                     8.70673387e+15, 7.57893925e+15, 6.50560821e+15, 5.57627356e+15,
                                     4.77419772e+15, 4.08317444e+15, 3.48938858e+15, 2.97982202e+15,
                                     2.54344919e+15, 2.17001500e+15, 1.85085842e+15, 1.57832798e+15,
                                     1.34580835e+15, 1.14750778e+15, 9.78511276e+14, 8.34488316e+14,
                                     7.11825707e+14, 6.07335336e+14, 5.18360444e+14, 4.42111432e+14,
                                     3.74018673e+14, 3.16207575e+14, 3.02790937e+14, 2.91420004e+14,
                                     2.88471001e+14, 5.36718655e+15, 5.19715391e+15, 5.09035216e+15,
                                     4.40411105e+15, 3.79146220e+15, 3.23912179e+15, 2.75293471e+15,
                                     2.33191795e+15, 1.97155503e+15, 1.66546971e+15, 1.40253017e+15,
                                     1.17776828e+15, 9.82735524e+14, 8.19477622e+14, 6.82999861e+14,
                                     5.68998289e+14, 4.73859714e+14, 3.94502292e+14, 3.28322401e+14,
                                     2.73194631e+14, 2.27253937e+14, 1.89015190e+14, 1.57192519e+14,
                                     1.30043088e+14, 1.07301223e+14, 8.85365270e+13, 7.30555865e+13,
                                     6.02818844e+13]),
                    'ene': np.array([7.1355, 7.242, 10.69, 11.42761, 12.21612,
                                     13.05903, 13.9601, 14.92335, 15.95306, 17.05382,
                                     18.23053, 19.48844, 20.83314, 22.27063, 23.226,
                                     23.5815, 23.6763, 23.8073, 23.8185, 24.174,
                                     25.45001, 27.20606, 29.08327, 31.09002, 33.23523,
                                     35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                     49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                     69.23942, 74.01695, 79.12411, 84.58368, 90.41995,
                                     96.65893, 103.3284, 110.4581, 118.0797, 126.2272,
                                     134.9368, 144.2475, 154.2005, 164.8404, 176.2144,
                                     188.3732, 201.3709, 215.2655, 230.1188, 245.997,
                                     262.9708, 281.1158, 300.5128, 321.2482, 343.4143,
                                     367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                     512.4891, 521.36, 529.34, 531.468, 534.66,
                                     542.64, 547.8508, 585.6525, 626.0625, 669.2609,
                                     715.4399, 764.8052, 817.5768, 873.9896, 934.2948,
                                     998.7612, 1067.676, 1141.345, 1220.098, 1304.285,
                                     1394.281, 1490.486, 1593.329, 1703.269, 1820.795,
                                     1946.43, 2080.733, 2224.304, 2377.781, 2541.848,
                                     2717.235, 2904.724])},
              '9': {'name': 'F',
                    'barns': 315476000000.0,
                    'NumEdges': 4,
                    'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8.6, 'factor': 1.0,
                           'twin': 'L2'},

                    'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8.6, 'factor': 0.5},
                    'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 31.0, 'factor': 1.0},
                    'K1': {'filename': 'F.K1', 'excl before': 5, 'excl after': 50, 'onset': 685.4, 'factor': 1.0,
                           'shape': 'hydrogenic'},
                    'dat': np.array([1.72202575e+17, 1.72426563e+17, 1.73035431e+17, 1.71019540e+17,
                                     1.68054065e+17, 1.64321984e+17, 1.59981034e+17, 1.55170025e+17,
                                     1.49996219e+17, 1.44557413e+17, 1.38919857e+17, 1.33146646e+17,
                                     1.27278792e+17, 1.21357308e+17, 1.15407430e+17, 1.09457553e+17,
                                     1.03526604e+17, 9.76335125e+16, 9.38099434e+16, 9.24849442e+16,
                                     9.21379206e+16, 9.44345858e+16, 9.42673836e+16, 9.30969676e+16,
                                     8.92166128e+16, 8.41721516e+16, 7.91655474e+16, 7.41968004e+16,
                                     6.92879939e+16, 6.44549016e+16, 5.97196068e+16, 5.51073477e+16,
                                     5.06433623e+16, 4.63434244e+16, 4.22359269e+16, 3.83334888e+16,
                                     3.46550386e+16, 3.12075169e+16, 2.80000724e+16, 2.50345980e+16,
                                     2.23095163e+16, 1.98197797e+16, 1.75578168e+16, 1.55129013e+16,
                                     1.36730453e+16, 1.20224749e+16, 1.05476246e+16, 9.23524442e+15,
                                     8.02823325e+15, 6.88116251e+15, 5.88678216e+15, 5.02805649e+15,
                                     4.28858074e+15, 3.65321208e+15, 3.10873205e+15, 2.64315257e+15,
                                     2.24571591e+15, 1.90702087e+15, 1.61873890e+15, 1.37361405e+15,
                                     1.16543144e+15, 9.88764879e+14, 8.38882232e+14, 7.11808499e+14,
                                     6.04104992e+14, 5.12869333e+14, 4.35546166e+14, 3.69769420e+14,
                                     3.11854336e+14, 2.62860913e+14, 2.60428593e+14, 2.50472170e+14,
                                     2.47907350e+14, 4.32959262e+15, 4.17816414e+15, 3.95259880e+15,
                                     3.36707535e+15, 2.86467982e+15, 2.43307710e+15, 2.06359161e+15,
                                     1.74849418e+15, 1.47507113e+15, 1.24319627e+15, 1.04075532e+15,
                                     8.69041737e+14, 7.25121586e+14, 6.04672849e+14, 5.03941362e+14,
                                     4.19772366e+14, 3.49547408e+14, 2.90966670e+14, 2.42143604e+14,
                                     2.01469283e+14, 1.67602935e+14, 1.39415154e+14, 1.15962668e+14,
                                     9.58920850e+13]),
                    'ene': np.array([8.643, 8.772, 10.69, 11.42761, 12.21612,
                                     13.05903, 13.9601, 14.92335, 15.95306, 17.05382,
                                     18.23053, 19.48844, 20.83314, 22.27063, 23.8073,
                                     25.45001, 27.20606, 29.08327, 30.38, 30.845,
                                     30.969, 31.09002, 31.155, 31.62, 33.23523,
                                     35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                     49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                     69.23942, 74.01695, 79.12411, 84.58368, 90.41995,
                                     96.65893, 103.3284, 110.4581, 118.0797, 126.2272,
                                     134.9368, 144.2475, 154.2005, 164.8404, 176.2144,
                                     188.3732, 201.3709, 215.2655, 230.1188, 245.997,
                                     262.9708, 281.1158, 300.5128, 321.2482, 343.4143,
                                     367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                     512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                     671.692, 681.973, 684.7146, 688.827, 699.108,
                                     715.4399, 764.8052, 817.5768, 873.9896, 934.2948,
                                     998.7612, 1067.676, 1141.345, 1220.098, 1304.285,
                                     1394.281, 1490.486, 1593.329, 1703.269, 1820.795,
                                     1946.43, 2080.733, 2224.304, 2377.781, 2541.848,
                                     2717.235, 2904.724])},
              '10': {'name': 'Ne',
                     'barns': 335080000000.0,
                     'NumEdges': 4,
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 18.3, 'factor': 1.0,
                            'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 18.3, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 45.0, 'factor': 1.0},
                     'K1': {'filename': 'Ne.K1', 'excl before': 5, 'excl after': 50, 'onset': 866.9, 'factor': 1.0,
                            'shape': 'hydrogenic'},
                     'dat': np.array([8.39006812e+16, 8.43161804e+16, 8.55358716e+16, 8.74357752e+16,
                                      8.91882436e+16, 9.06726480e+16, 9.17884644e+16, 9.24485720e+16,
                                      9.25893056e+16, 9.21637540e+16, 9.11417600e+16, 8.95166220e+16,
                                      8.73050940e+16, 8.45440348e+16, 8.12770048e+16, 8.04292524e+16,
                                      7.95982540e+16, 7.93771012e+16, 8.08414008e+16, 8.00841200e+16,
                                      7.95278872e+16, 7.59257772e+16, 7.20958128e+16, 6.80580988e+16,
                                      6.38729496e+16, 5.95906272e+16, 5.52714460e+16, 5.09623172e+16,
                                      4.66833456e+16, 4.24747408e+16, 3.84001680e+16, 3.45132400e+16,
                                      3.08441140e+16, 2.74229472e+16, 2.42644831e+16, 2.13750883e+16,
                                      1.87537574e+16, 1.63937890e+16, 1.42834552e+16, 1.24076773e+16,
                                      1.07497015e+16, 9.29109824e+15, 8.01176280e+15, 6.89494116e+15,
                                      5.92320916e+15, 5.08048296e+15, 4.35201904e+15, 3.72340896e+15,
                                      3.18272387e+15, 2.71823598e+15, 2.31992638e+15, 1.95820752e+15,
                                      1.65147529e+15, 1.39195583e+15, 1.17271298e+15, 9.87681808e+14,
                                      8.31702068e+14, 7.00283692e+14, 5.89673784e+14, 4.96555052e+14,
                                      4.18246856e+14, 3.52370128e+14, 2.96988106e+14, 2.50408635e+14,
                                      2.26956386e+14, 2.18056661e+14, 2.15764714e+14, 3.42284220e+15,
                                      3.39871644e+15, 3.31102600e+15, 2.92655521e+15, 2.51330105e+15,
                                      2.13040513e+15, 1.79824033e+15, 1.51332180e+15, 1.27099195e+15,
                                      1.06625807e+15, 8.93021708e+14, 7.45016872e+14, 6.21405860e+14,
                                      5.18167712e+14, 4.31985136e+14, 3.60043460e+14, 2.99980370e+14,
                                      2.49875858e+14, 2.08088031e+14, 1.73246412e+14, 1.44215081e+14]),
                     'ene': np.array([18.3915, 18.666, 19.48844, 20.83314, 22.27063,
                                      23.8073, 25.45001, 27.20606, 29.08327, 31.09002,
                                      33.23523, 35.52846, 37.97993, 40.60054, 43.40198,
                                      44.1, 44.775, 44.955, 45.225, 45.9,
                                      46.39671, 49.59809, 53.02035, 56.67876, 60.58959,
                                      64.77028, 69.23942, 74.01695, 79.12411, 84.58368,
                                      90.41995, 96.65893, 103.3284, 110.4581, 118.0797,
                                      126.2272, 134.9368, 144.2475, 154.2005, 164.8404,
                                      176.2144, 188.3732, 201.3709, 215.2655, 230.1188,
                                      245.997, 262.9708, 281.1158, 300.5128, 321.2482,
                                      343.4143, 367.1099, 392.4405, 419.5189, 448.4657,
                                      479.4098, 512.4891, 547.8508, 585.6525, 626.0625,
                                      669.2609, 715.4399, 764.8052, 817.5768, 849.562,
                                      862.5655, 866.0331, 871.2345, 873.9896, 884.238,
                                      934.2948, 998.7612, 1067.676, 1141.345, 1220.098,
                                      1304.285, 1394.281, 1490.486, 1593.329, 1703.269,
                                      1820.795, 1946.43, 2080.733, 2224.304, 2377.781,
                                      2541.848, 2717.235, 2904.724])},
              '11': {'name': 'Na',
                     'barns': 381755000000.0,
                     'NumEdges': 4,
                     'L3': {'filename': 'Na.L3', 'excl before': 5, 'excl after': 50, 'onset': 31.099999999999998,
                            'factor': 1.0, 'twin': 'L2', 'shape': 'hydrogenic'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 31.099999999999998,
                            'factor': 0.5},
                     'L1': {'filename': 'Na.L1', 'excl before': 5, 'excl after': 50, 'onset': 63.3, 'factor': 1.0},
                     'K1': {'filename': 'Na.K1', 'excl before': 5, 'excl after': 50, 'onset': 1072.1000000000001,
                            'factor': 1.0, 'shape': 'hydrogenic'},
                     'dat': np.array([3.29809597e+16, 3.43190110e+16, 3.88931994e+16, 4.62763411e+16,
                                      5.34457000e+16, 5.98820893e+16, 6.52648348e+16, 6.93725186e+16,
                                      7.20715264e+16, 7.33427706e+16, 7.32435143e+16, 7.19073718e+16,
                                      7.11744022e+16, 7.06323101e+16, 7.04834256e+16, 7.31099000e+16,
                                      7.26059834e+16, 7.24952745e+16, 6.97580912e+16, 6.63948296e+16,
                                      6.25009286e+16, 5.82367252e+16, 5.37549216e+16, 4.91891318e+16,
                                      4.46576999e+16, 4.02484296e+16, 3.60315639e+16, 3.20620754e+16,
                                      2.83559979e+16, 2.49354731e+16, 2.18169165e+16, 1.90033821e+16,
                                      1.64876167e+16, 1.42554952e+16, 1.22886934e+16, 1.05650696e+16,
                                      9.06248194e+15, 7.75802511e+15, 6.62955733e+15, 5.65608208e+15,
                                      4.81812986e+15, 4.09928519e+15, 3.48370525e+15, 2.95760869e+15,
                                      2.50881751e+15, 2.12652805e+15, 1.80134914e+15, 1.52503487e+15,
                                      1.29048460e+15, 1.09159025e+15, 9.22778186e+14, 7.75229878e+14,
                                      6.51044977e+14, 5.46634985e+14, 4.58945861e+14, 3.85381672e+14,
                                      3.23690064e+14, 2.71962262e+14, 2.28610164e+14, 1.98734018e+14,
                                      1.90117808e+14, 1.88483896e+14, 2.17046805e+15, 2.30316609e+15,
                                      2.58482493e+15, 2.34221963e+15, 1.89033623e+15, 1.46177807e+15,
                                      1.19317525e+15, 9.89738013e+14, 8.32607655e+14, 7.06628505e+14,
                                      6.01569529e+14, 5.11398998e+14, 4.29398024e+14, 3.57670077e+14,
                                      2.97936872e+14, 2.48190378e+14, 2.06758508e+14, 1.71556879e+14,
                                      1.41818165e+14, 1.17240778e+14, 9.69275945e+13]),
                     'ene': np.array([31.2555, 31.722, 33.23523, 35.52846, 37.97993,
                                                             40.60054, 43.40198, 46.39671, 49.59809, 53.02035,
                                                             56.67876, 60.58959, 62.034, 62.9835, 63.2367,
                                                             63.6165, 64.566, 64.77028, 69.23942, 74.01695,
                                                             79.12411, 84.58368, 90.41995, 96.65893, 103.3284,
                                                             110.4581, 118.0797, 126.2272, 134.9368, 144.2475,
                                                             154.2005, 164.8404, 176.2144, 188.3732, 201.3709,
                                                             215.2655, 230.1188, 245.997, 262.9708, 281.1158,
                                                             300.5128, 321.2482, 343.4143, 367.1099, 392.4405,
                                                             419.5189, 448.4657, 479.4098, 512.4891, 547.8508,
                                                             585.6525, 626.0625, 669.2609, 715.4399, 764.8052,
                                                             817.5768, 873.9896, 934.2948, 998.7612, 1050.658,
                                                             1067.676, 1071.028, 1077.461, 1093.542, 1141.345,
                                                             1220.098, 1304.285, 1394.281, 1490.486, 1593.329,
                                                             1703.269, 1820.795, 1946.43, 2080.733, 2224.304,
                                                             2377.781, 2541.848, 2717.235, 2904.724, 3105.15,
                                                             3319.406, 3548.445, 3793.288])},
              '12': {'name': 'Mg',
                     'barns': 403594000000.0,
                     'NumEdges': 4,
                     'L3': {'filename': 'Mg.L3', 'excl before': 5, 'excl after': 50, 'onset': 51.4, 'factor': 1.0,
                            'twin': 'L2', 'shape': 'hydrogenic'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 51.4, 'factor': 0.5},
                     'L1': {'filename': 'Mg.L1', 'excl before': 5, 'excl after': 50, 'onset': 89.39999999999999,
                            'factor': 1.0},
                     'K1': {'filename': 'Mg.K1', 'excl before': 5, 'excl after': 50, 'onset': 1305.0, 'factor': 1.0,
                            'shape': 'hydrogenic'},
                     'dat': np.array([2.31400620e+16, 2.46091442e+16, 2.57848135e+16, 3.40201490e+16,
                                      4.32289533e+16, 5.14743788e+16, 5.79762781e+16, 6.22664823e+16,
                                      6.42279492e+16, 6.40180803e+16, 6.31543891e+16, 6.26377888e+16,
                                      6.24884590e+16, 6.69481727e+16, 6.67019804e+16, 6.63548895e+16,
                                      6.34449768e+16, 5.92516351e+16, 5.44529025e+16, 4.93877978e+16,
                                      4.43105853e+16, 3.94057074e+16, 3.47938387e+16, 3.05427831e+16,
                                      2.66832137e+16, 2.32203772e+16, 2.01413586e+16, 1.74235566e+16,
                                      1.50354909e+16, 1.29428560e+16, 1.11165931e+16, 9.52966153e+15,
                                      8.15461677e+15, 6.96683963e+15, 5.94292165e+15, 5.06227954e+15,
                                      4.30634798e+15, 3.65789350e+15, 3.10291139e+15, 2.62880952e+15,
                                      2.22452941e+15, 1.88038481e+15, 1.58798095e+15, 1.33993208e+15,
                                      1.12978068e+15, 9.52078246e+14, 8.01941278e+14, 6.75253121e+14,
                                      5.68502508e+14, 4.78581765e+14, 4.02891746e+14, 3.38611330e+14,
                                      2.80744022e+14, 2.33023068e+14, 1.93664581e+14, 1.70102763e+14,
                                      1.63152874e+14, 1.61163156e+14, 2.10938404e+15, 2.09525825e+15,
                                      2.00428816e+15, 1.72112661e+15, 1.42731018e+15, 1.16965577e+15,
                                      9.74639151e+14, 8.16067068e+14, 6.85827284e+14, 5.77341217e+14,
                                      4.86007895e+14, 4.08679284e+14, 3.41791651e+14, 2.85054406e+14,
                                      2.36788600e+14, 1.95961031e+14, 1.62180213e+14, 1.34227293e+14]),
                     'ene': np.array([51.657, 52.428, 53.02035, 56.67876, 60.58959,
                                      64.77028, 69.23942, 74.01695, 79.12411, 84.58368,
                                      87.612, 88.953, 89.3106, 89.847, 90.41995,
                                      91.188, 96.65893, 103.3284, 110.4581, 118.0797,
                                      126.2272, 134.9368, 144.2475, 154.2005, 164.8404,
                                      176.2144, 188.3732, 201.3709, 215.2655, 230.1188,
                                      245.997, 262.9708, 281.1158, 300.5128, 321.2482,
                                      343.4143, 367.1099, 392.4405, 419.5189, 448.4657,
                                      479.4098, 512.4891, 547.8508, 585.6525, 626.0625,
                                      669.2609, 715.4399, 764.8052, 817.5768, 873.9896,
                                      934.2948, 998.7612, 1067.676, 1141.345, 1220.098,
                                      1278.9, 1298.475, 1304.285, 1311.525, 1331.1,
                                      1394.281, 1490.486, 1593.329, 1703.269, 1820.795,
                                      1946.43, 2080.733, 2224.304, 2377.781, 2541.848,
                                      2717.235, 2904.724, 3105.15, 3319.406, 3548.445,
                                      3793.288])},
              '13': {'name': 'Al',
                     'barns': 448039000000.0,
                     'NumEdges': 5,
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8.37567, 'factor': 1.0},
                     'L3': {'filename': 'Al.L3', 'excl before': 5, 'excl after': 50, 'onset': 73.1, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 73.1, 'factor': 0.5},
                     'L1': {'filename': 'Al.L1', 'excl before': 5, 'excl after': 50, 'onset': 117.7, 'factor': 1.0},
                     'K1': {'filename': 'Al.K1', 'excl before': 5, 'excl after': 50, 'onset': 1559.6,
                            'factor': 1.0, 'shape': 'hydrogenic'},
                     'dat': np.array([8.56605764e+15, 7.39846801e+15, 1.19953481e+15, 9.20272106e+14,
                                      7.81738447e+14, 7.21297986e+14, 7.10769070e+14, 7.37068959e+14,
                                      7.94283539e+14, 8.79769380e+14, 9.92406385e+14, 1.13116406e+15,
                                      1.29429506e+15, 1.47875272e+15, 1.67960860e+15, 1.89009733e+15,
                                      2.10175095e+15, 2.30480222e+15, 2.48921508e+15, 2.64549108e+15,
                                      2.76104034e+15, 2.82493070e+15, 2.83796863e+15, 2.80432090e+15,
                                      2.73084251e+15, 2.62259629e+15, 2.48155361e+15, 2.32088682e+15,
                                      2.14857102e+15, 1.97159562e+15, 1.79578512e+15, 1.70801428e+15,
                                      1.66943812e+15, 1.65935724e+15, 3.73565957e+16, 3.78991710e+16,
                                      3.84404021e+16, 4.31546684e+16, 4.85674276e+16, 5.23892003e+16,
                                      5.43784934e+16, 5.45935522e+16, 5.32673567e+16, 5.17305829e+16,
                                      5.10854068e+16, 5.09061912e+16, 5.57494928e+16, 5.56688458e+16,
                                      5.49519834e+16, 5.22637494e+16, 4.82269180e+16, 4.38912446e+16,
                                      3.94807486e+16, 3.51679252e+16, 3.10750890e+16, 2.72779584e+16,
                                      2.38150650e+16, 2.06985057e+16, 1.79233522e+16, 1.54725788e+16,
                                      1.33219916e+16, 1.14451563e+16, 9.81339822e+15, 8.39669890e+15,
                                      7.17131223e+15, 6.11438823e+15, 5.20576514e+15, 4.42586365e+15,
                                      3.75833035e+15, 3.18788709e+15, 2.70086870e+15, 2.28571576e+15,
                                      1.93243701e+15, 1.63238529e+15, 1.37785434e+15, 1.16234758e+15,
                                      9.80085312e+14, 8.26139112e+14, 6.96207802e+14, 5.86707070e+14,
                                      4.94500644e+14, 4.11649272e+14, 3.42897688e+14, 2.85889206e+14,
                                      2.38571807e+14, 1.98996522e+14, 1.65451842e+14, 1.54394239e+14,
                                      1.48085850e+14, 1.46463949e+14, 1.80824060e+15, 1.77194944e+15,
                                      1.76809631e+15, 1.56087827e+15, 1.31768270e+15, 1.09572418e+15,
                                      9.11132110e+14, 7.63503260e+14, 6.40830182e+14, 5.38453270e+14,
                                      4.52384978e+14, 3.79780258e+14, 3.17686533e+14, 2.63276677e+14,
                                      2.18087464e+14, 1.80667246e+14]),
                     'ene': np.array([8.417543, 8.543178, 10.69, 11.42761, 12.21612,
                                      13.05903, 13.9601, 14.92335, 15.95306, 17.05382,
                                      18.23053, 19.48844, 20.83314, 22.27063, 23.8073,
                                      25.45001, 27.20606, 29.08327, 31.09002, 33.23523,
                                      35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                      49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                      69.23942, 71.638, 72.7345, 73.0269, 73.4655,
                                      74.01695, 74.562, 79.12411, 84.58368, 90.41995,
                                      96.65893, 103.3284, 110.4581, 115.346, 117.1115,
                                      117.5823, 118.0797, 118.2885, 120.054, 126.2272,
                                      134.9368, 144.2475, 154.2005, 164.8404, 176.2144,
                                      188.3732, 201.3709, 215.2655, 230.1188, 245.997,
                                      262.9708, 281.1158, 300.5128, 321.2482, 343.4143,
                                      367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                      512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                      715.4399, 764.8052, 817.5768, 873.9896, 934.2948,
                                      998.7612, 1067.676, 1141.345, 1220.098, 1304.285,
                                      1394.281, 1490.486, 1528.408, 1551.802, 1558.04,
                                      1567.398, 1590.792, 1593.329, 1703.269, 1820.795,
                                      1946.43, 2080.733, 2224.304, 2377.781, 2541.848,
                                      2717.235, 2904.724, 3105.15, 3319.406, 3548.445,
                                      3793.288])},
              '14': {'name': 'Si',
                     'barns': 466370999999.99994,
                     'NumEdges': 6,
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5.08305, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 11.357199999999999,
                            'factor': 1.0},
                     'L3': {'filename': 'Si.L3', 'excl before': 5, 'excl after': 50, 'onset': 99.2, 'factor': 1.0,
                            'XU': 0.3, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 99.2, 'factor': 0.5},
                     'L1': {'filename': 'Si.L1', 'excl before': 5, 'excl after': 50, 'onset': 148.7, 'factor': 1.0},
                     'K1': {'filename': 'Si.K1', 'excl before': 5, 'excl after': 50, 'onset': 1838.9, 'factor': 1.0,
                            'shape': 'hydrogenic'},
                     'ene': np.array([5.108469, 5.184715, 10.69, 11.13003, 11.30038,
                                      11.34581, 11.41396, 11.42761, 11.58431, 12.21612,
                                      13.05903, 13.9601, 14.92335, 15.95306, 17.05382,
                                      18.23053, 19.48844, 20.83314, 22.27063, 23.8073,
                                      25.45001, 27.20606, 29.08327, 31.09002, 33.23523,
                                      35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                      49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                      69.23942, 74.01695, 79.12411, 84.58368, 90.41995,
                                      96.65893, 97.216, 98.704, 99.1008, 99.696,
                                      101.184, 103.3284, 110.4581, 118.0797, 126.2272,
                                      134.9368, 144.2475, 145.726, 147.9565, 148.5513,
                                      149.4435, 151.674, 154.2005, 164.8404, 176.2144,
                                      188.3732, 201.3709, 215.2655, 230.1188, 245.997,
                                      262.9708, 281.1158, 300.5128, 321.2482, 343.4143,
                                      367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                      512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                      715.4399, 764.8052, 817.5768, 873.9896, 934.2948,
                                      998.7612, 1067.676, 1141.345, 1220.098, 1304.285,
                                      1394.281, 1490.486, 1593.329, 1703.269, 1802.122,
                                      1820.795, 1829.705, 1837.061, 1848.094, 1875.678,
                                      1946.43, 2080.733, 2224.304, 2377.781, 2541.848,
                                      2717.235, 2904.724, 3105.15, 3319.406, 3548.445,
                                      3793.288]),
                     'dat': np.array([2.52138817e+17, 2.62487590e+17, 3.23381651e+16, 2.57282890e+16,
                                      2.36310186e+16, 2.31086830e+16, 2.30718397e+16, 2.29249329e+16,
                                      2.13285449e+16, 1.62432356e+16, 1.18229712e+16, 8.90348876e+15,
                                      6.97691016e+15, 5.71117927e+15, 4.89083268e+15, 4.37507299e+15,
                                      4.07095246e+15, 3.91523118e+15, 3.86682187e+15, 3.89163281e+15,
                                      3.96317412e+15, 4.06092548e+15, 4.16884373e+15, 4.27401039e+15,
                                      4.36635185e+15, 4.43821962e+15, 4.48429708e+15, 4.50131962e+15,
                                      4.48798141e+15, 4.44409590e+15, 4.36784424e+15, 4.26193138e+15,
                                      4.13074122e+15, 3.97893746e+15, 3.81104390e+15, 3.63116461e+15,
                                      3.44317046e+15, 3.25032605e+15, 3.05556952e+15, 2.86132600e+15,
                                      2.66059992e+15, 2.64017287e+15, 2.58640029e+15, 2.57226925e+15,
                                      5.05079793e+16, 5.07644833e+16, 5.11282527e+16, 5.23035076e+16,
                                      5.24993835e+16, 5.13194648e+16, 4.90295832e+16, 4.59226196e+16,
                                      4.53946877e+16, 4.45869331e+16, 4.43696042e+16, 4.86658138e+16,
                                      4.78123549e+16, 4.68469669e+16, 4.28072613e+16, 3.86733488e+16,
                                      3.45912034e+16, 3.06802162e+16, 2.70182711e+16, 2.36478079e+16,
                                      2.05930779e+16, 1.78568792e+16, 1.54280191e+16, 1.32887753e+16,
                                      1.14158293e+16, 9.78446358e+15, 8.36902759e+15, 7.14573646e+15,
                                      6.09080526e+15, 5.18184818e+15, 4.40184268e+15, 3.73390614e+15,
                                      3.16339449e+15, 2.67720273e+15, 2.26343837e+15, 1.91179464e+15,
                                      1.61341047e+15, 1.36077730e+15, 1.14713275e+15, 9.66787083e+14,
                                      8.14703500e+14, 6.86591386e+14, 5.70278459e+14, 4.73972847e+14,
                                      3.94312017e+14, 3.28339175e+14, 2.73657175e+14, 2.28293268e+14,
                                      1.90624483e+14, 1.59316997e+14, 1.36991818e+14, 1.33274841e+14,
                                      1.31549268e+14, 1.30150155e+14, 1.54336155e+15, 1.50148143e+15,
                                      1.39636141e+15, 1.18490880e+15, 9.93137044e+14, 8.29440823e+14,
                                      6.96198629e+14, 5.85342242e+14, 4.92161316e+14, 4.12332592e+14,
                                      3.44456957e+14, 2.87778889e+14, 2.39458190e+14]), },
              '15': {'name': 'P',
                     'barns': 514332000000.0,
                     'NumEdges': 7,
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6.33669, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6.38493, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 14.461500000000001,
                            'factor': 1.0},
                     'L3': {'filename': 'P.L3', 'excl before': 5, 'excl after': 50, 'onset': 132.20000000000002,
                            'factor': 1.0,
                            'XU': 0.29, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 132.20000000000002,
                            'factor': 0.5},
                     'L1': {'filename': 'P.L1', 'excl before': 5, 'excl after': 50, 'onset': 189.29999999999998,
                            'factor': 1.0},
                     'K1': {'filename': 'P.K1', 'excl before': 5, 'excl after': 50, 'onset': 2145.5, 'factor': 1.0,
                            'shape': 'hydrogenic'},
                     'ene': np.array([6.353005, 6.368374, 6.378545, 6.416855, 6.463425,
                                      6.512629, 10.69, 11.42761, 12.21612, 13.05903,
                                      13.9601, 14.17226, 14.38918, 14.44703, 14.5338,
                                      14.75072, 14.92335, 15.95306, 17.05382, 18.23053,
                                      19.48844, 20.83314, 22.27063, 23.8073, 25.45001,
                                      27.20606, 29.08327, 31.09002, 33.23523, 35.52846,
                                      37.97993, 40.60054, 43.40198, 46.39671, 49.59809,
                                      53.02035, 56.67876, 60.58959, 64.77028, 69.23942,
                                      74.01695, 79.12411, 84.58368, 90.41995, 96.65893,
                                      103.3284, 110.4581, 118.0797, 126.2272, 129.556,
                                      131.539, 132.0678, 132.861, 134.9368, 144.2475,
                                      154.2005, 164.8404, 176.2144, 185.514, 188.3732,
                                      189.1107, 190.2465, 193.086, 201.3709, 215.2655,
                                      230.1188, 245.997, 262.9708, 281.1158, 300.5128,
                                      321.2482, 343.4143, 367.1099, 392.4405, 419.5189,
                                      448.4657, 479.4098, 512.4891, 547.8508, 585.6525,
                                      626.0625, 669.2609, 715.4399, 764.8052, 817.5768,
                                      873.9896, 934.2948, 998.7612, 1067.676, 1141.345,
                                      1220.098, 1304.285, 1394.281, 1490.486, 1593.329,
                                      1703.269, 1820.795, 1946.43, 2080.733, 2102.59,
                                      2134.772, 2143.354, 2156.227, 2188.41, 2224.304,
                                      2377.781, 2541.848, 2717.235, 2904.724, 3105.15,
                                      3319.406, 3548.445, 3793.288]),
                     'dat': np.array([1.03848774e+17, 1.04913441e+17, 1.05623220e+17, 3.17898323e+17,
                                      3.27727207e+17, 3.38363593e+17, 2.00867219e+17, 1.36925465e+17,
                                      9.17053956e+16, 6.10769250e+16, 4.08533908e+16, 3.73574762e+16,
                                      3.41634744e+16, 3.33708888e+16, 3.22373011e+16, 2.95895200e+16,
                                      2.76813482e+16, 1.91326361e+16, 1.36040814e+16, 1.00598196e+16,
                                      7.84973498e+15, 6.55876166e+15, 5.90658869e+15, 5.68336860e+15,
                                      5.72554382e+15, 5.90401703e+15, 6.12260813e+15, 6.31085364e+15,
                                      6.43069300e+15, 6.46772490e+15, 6.42709267e+15, 6.32011162e+15,
                                      6.16169736e+15, 5.96779420e+15, 5.75486075e+15, 5.53626965e+15,
                                      5.31922154e+15, 5.10767679e+15, 4.90286979e+15, 4.70541774e+15,
                                      4.51444626e+15, 4.32825808e+15, 4.14495015e+15, 3.96261946e+15,
                                      3.77998017e+15, 3.59605504e+15, 3.41063836e+15, 3.22393584e+15,
                                      2.97335329e+15, 2.87125839e+15, 2.81226451e+15, 2.79673168e+15,
                                      5.53061200e+16, 5.46374884e+16, 5.18549522e+16, 4.88949716e+16,
                                      4.53933993e+16, 4.15626546e+16, 3.85064938e+16, 3.75925259e+16,
                                      3.73595335e+16, 4.10611809e+16, 4.01456699e+16, 3.75719526e+16,
                                      3.36033669e+16, 2.98250840e+16, 2.62921375e+16, 2.30415593e+16,
                                      2.00877506e+16, 1.74332831e+16, 1.50709563e+16, 1.29843113e+16,
                                      1.11538038e+16, 9.55628856e+15, 8.16913516e+15, 6.96868427e+15,
                                      5.93436262e+15, 5.04513402e+15, 4.28253396e+15, 3.62922946e+15,
                                      3.07117924e+15, 2.59578217e+15, 2.19177438e+15, 1.84912641e+15,
                                      1.55888886e+15, 1.31339820e+15, 1.10627670e+15, 9.31815284e+14,
                                      7.72680964e+14, 6.41217704e+14, 5.32642219e+14, 4.42870712e+14,
                                      3.68616601e+14, 3.07128210e+14, 2.56152766e+14, 2.13854102e+14,
                                      1.78720083e+14, 1.49506026e+14, 1.25193552e+14, 1.21773244e+14,
                                      1.16969383e+14, 1.15734987e+14, 1.32173037e+15, 1.28099528e+15,
                                      1.23773996e+15, 1.05381483e+15, 8.85679704e+14, 7.42438242e+14,
                                      6.23936149e+14, 5.23487110e+14, 4.37984558e+14, 3.66497553e+14,
                                      3.06526442e+14])},
              '16': {'name': 'S',
                     'barns': 532369000000.0,
                     'NumEdges': 7,
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7.73488, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7.81363, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 17.688200000000002,
                            'factor': 1.0},
                     'L3': {'filename': 'S.L3', 'excl before': 5, 'excl after': 50, 'onset': 164.8, 'factor': 1.0,
                            'XU': 0.22, 'twin': 'L2'},

                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 164.8, 'factor': 0.5},
                     'L1': {'filename': 'S.L1', 'excl before': 5, 'excl after': 50, 'onset': 229.2, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2472.0, 'factor': 1.0,
                            'shape': 'hydrogenic'},
                     'ene': np.array([7.774563, 7.805818, 7.8527, 7.889576, 7.969904,
                                      10.69, 11.42761, 12.21612, 13.05903, 13.9601,
                                      14.92335, 15.95306, 17.05382, 17.33447, 17.59979,
                                      17.67054, 17.77667, 18.04199, 18.23053, 19.48844,
                                      20.83314, 22.27063, 23.8073, 25.45001, 27.20606,
                                      29.08327, 31.09002, 33.23523, 35.52846, 37.97993,
                                      40.60054, 43.40198, 46.39671, 49.59809, 53.02035,
                                      56.67876, 60.58959, 64.77028, 69.23942, 74.01695,
                                      79.12411, 84.58368, 90.41995, 96.65893, 103.3284,
                                      110.4581, 118.0797, 126.2272, 134.9368, 144.2475,
                                      154.2005, 161.504, 163.976, 164.6352, 164.8404,
                                      165.624, 168.096, 176.2144, 188.3732, 201.3709,
                                      215.2655, 224.616, 228.054, 228.9708, 230.1188,
                                      230.346, 233.784, 245.997, 262.9708, 281.1158,
                                      300.5128, 321.2482, 343.4143, 367.1099, 392.4405,
                                      419.5189, 448.4657, 479.4098, 512.4891, 547.8508,
                                      585.6525, 626.0625, 669.2609, 715.4399, 764.8052,
                                      817.5768, 873.9896, 934.2948, 998.7612, 1067.676,
                                      1141.345, 1220.098, 1304.285, 1394.281, 1490.486,
                                      1593.329, 1703.269, 1820.795, 1946.43, 2080.733,
                                      2224.304, 2377.781, 2422.56, 2459.64, 2469.528,
                                      2484.36, 2521.44, 2541.848, 2717.235, 2904.724,
                                      3105.15, 3319.406, 3548.445, 3793.288]),
                     'dat': np.array([1.60780762e+17, 1.64358281e+17, 3.28503615e+17, 3.37096051e+17,
                                      3.56442340e+17, 6.56623925e+17, 5.28482706e+17, 3.92984148e+17,
                                      2.76198361e+17, 1.87042524e+17, 1.24041977e+17, 8.16547572e+16,
                                      5.39396271e+16, 4.88166402e+16, 4.45204224e+16, 4.34556844e+16,
                                      4.19304472e+16, 3.83843373e+16, 3.60967477e+16, 2.46561379e+16,
                                      1.73371289e+16, 1.26863533e+16, 9.80091329e+15, 8.11170645e+15,
                                      7.23595945e+15, 6.89471092e+15, 6.87075431e+15, 7.00224946e+15,
                                      7.17047806e+15, 7.29824662e+15, 7.34669220e+15, 7.31102348e+15,
                                      7.19816125e+15, 7.02460896e+15, 6.81112899e+15, 6.57528952e+15,
                                      6.33199689e+15, 6.09775453e+15, 5.87628902e+15, 5.66706800e+15,
                                      5.46955911e+15, 5.28099401e+15, 5.09849791e+15, 4.91823777e+15,
                                      4.73685965e+15, 4.55159524e+15, 4.36063448e+15, 4.16312558e+15,
                                      3.95922825e+15, 3.74979429e+15, 3.45140146e+15, 3.23483375e+15,
                                      3.16466752e+15, 3.14619432e+15, 5.63406113e+16, 5.59466582e+16,
                                      5.47275332e+16, 5.10084034e+16, 4.61063496e+16, 4.13741216e+16,
                                      3.68532440e+16, 3.41099466e+16, 3.31586032e+16, 3.29099868e+16,
                                      3.62607173e+16, 3.61978978e+16, 3.52603960e+16, 3.21609437e+16,
                                      2.83912388e+16, 2.49361640e+16, 2.17983811e+16, 1.89741635e+16,
                                      1.64502021e+16, 1.42110581e+16, 1.22370338e+16, 1.05073670e+16,
                                      8.99916558e+15, 7.68900547e+15, 6.55612424e+15, 5.57922712e+15,
                                      4.74026681e+15, 4.02103629e+15, 3.40609686e+15, 2.88080837e+15,
                                      2.43329899e+15, 2.05318752e+15, 1.73115751e+15, 1.45879753e+15,
                                      1.22886736e+15, 1.01852837e+15, 8.44816366e+14, 7.01449394e+14,
                                      5.83050529e+14, 4.85131899e+14, 4.04100013e+14, 3.36968282e+14,
                                      2.81293132e+14, 2.35067532e+14, 1.96651785e+14, 1.64688350e+14,
                                      1.38069900e+14, 1.15875437e+14, 1.10354770e+14, 1.06058552e+14,
                                      1.04956548e+14, 1.14475306e+15, 1.10647573e+15, 1.08619247e+15,
                                      9.21796924e+14, 7.74969553e+14, 6.51566419e+14, 5.46742963e+14,
                                      4.57587127e+14, 3.83002230e+14]),
                     },
              '17': {'name': 'Cl',
                     'barns': 588711000000.0,
                     'NumEdges': 7,
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6.8, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6.8, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 17.5, 'factor': 1.0},
                     'L3': {'filename': 'Cl.L3', 'excl before': 5, 'excl after': 50, 'onset': 200.0, 'factor': 1.0,
                            'XU': 0.3, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 201.6, 'factor': 0.5},
                     'L1': {'filename': 'Cl.L1', 'excl before': 5, 'excl after': 50, 'onset': 270.2, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2822.4, 'factor': 1.0},
                     'ene': np.array([6.834, 6.936, 10.69, 11.42761, 12.21612,
                                      13.05903, 13.9601, 14.92335, 15.95306, 17.05382,
                                      17.15, 17.4125, 17.4825, 17.5875, 17.85,
                                      18.23053, 19.48844, 20.83314, 22.27063, 23.8073,
                                      25.45001, 27.20606, 29.08327, 31.09002, 33.23523,
                                      35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                      49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                      69.23942, 74.01695, 79.12411, 84.58368, 90.41995,
                                      96.65893, 103.3284, 110.4581, 118.0797, 126.2272,
                                      134.9368, 144.2475, 154.2005, 164.8404, 176.2144,
                                      188.3732, 196., 197.568, 199., 199.8,
                                      200.592, 201., 201.3709, 201.3984, 202.608,
                                      204., 205.632, 215.2655, 230.1188, 245.997,
                                      262.9708, 264.796, 268.849, 269.9298, 271.551,
                                      275.604, 281.1158, 300.5128, 321.2482, 343.4143,
                                      367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                      512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                      715.4399, 764.8052, 817.5768, 873.9896, 934.2948,
                                      998.7612, 1067.676, 1141.345, 1220.098, 1304.285,
                                      1394.281, 1490.486, 1593.329, 1703.269, 1820.795,
                                      1946.43, 2080.733, 2224.304, 2377.781, 2541.848,
                                      2717.235, 2765.952, 2808.288, 2819.578, 2836.512,
                                      2878.848, 2904.724, 3105.15, 3319.406, 3548.445,
                                      3793.288]),
                     'dat': np.array([4.31001210e+17, 4.68213633e+17, 6.94973336e+17, 5.24341339e+17,
                                      3.80790049e+17, 2.69976977e+17, 1.89093973e+17, 1.32136184e+17,
                                      9.28632731e+16, 6.60533742e+16, 6.42283701e+16, 5.95893274e+16,
                                      5.84289780e+16, 5.68212083e+16, 5.29139334e+16, 4.78981157e+16,
                                      3.55222330e+16, 2.71095528e+16, 2.14025884e+16, 1.75612491e+16,
                                      1.50144853e+16, 1.33602074e+16, 1.23270196e+16, 1.17082844e+16,
                                      1.13432835e+16, 1.11207508e+16, 1.09694521e+16, 1.08428792e+16,
                                      1.07174838e+16, 1.05797254e+16, 1.04266605e+16, 1.02571118e+16,
                                      1.00728452e+16, 9.87503831e+15, 9.66427978e+15, 9.44056960e+15,
                                      9.20155293e+15, 8.94605236e+15, 8.67230174e+15, 8.38030108e+15,
                                      8.06946168e+15, 7.74096094e+15, 7.39538758e+15, 7.03568516e+15,
                                      6.66479723e+15, 6.15497350e+15, 5.62642877e+15, 5.11425020e+15,
                                      4.62314748e+15, 4.15718273e+15, 3.71959384e+15, 3.47368926e+15,
                                      3.42565044e+15, 3.38255679e+15, 3.35871400e+15, 3.72777692e+16,
                                      3.71270592e+16, 3.69910670e+16, 3.69810589e+16, 5.31352887e+16,
                                      5.24152952e+16, 5.15899224e+16, 4.70904042e+16, 4.12068264e+16,
                                      3.59967341e+16, 3.13724092e+16, 3.09238114e+16, 2.99577367e+16,
                                      2.97069458e+16, 3.26775815e+16, 3.17379987e+16, 3.05199557e+16,
                                      2.67157052e+16, 2.33247298e+16, 2.02993440e+16, 1.76107009e+16,
                                      1.52328971e+16, 1.31376747e+16, 1.13003076e+16, 9.69430404e+15,
                                      8.29611541e+15, 7.08395946e+15, 6.03664259e+15, 5.13408976e+15,
                                      4.35899286e+15, 3.69510346e+15, 3.12788041e+15, 2.64419546e+15,
                                      2.23233324e+15, 1.88269778e+15, 1.58692937e+15, 1.32265700e+15,
                                      1.09882908e+15, 9.12914148e+14, 7.59201706e+14, 6.32040130e+14,
                                      5.26696183e+14, 4.39366794e+14, 3.66890582e+14, 3.06694883e+14,
                                      2.56636786e+14, 2.14973709e+14, 1.80263308e+14, 1.51310501e+14,
                                      1.27143915e+14, 1.06939353e+14, 1.02141358e+14, 9.82146561e+13,
                                      9.72079603e+13, 1.00080870e+15, 9.65662653e+14, 9.45057768e+14,
                                      7.96820338e+14, 6.69305536e+14, 5.63620137e+14, 4.73400176e+14]),
                     },
              '18': {'name': 'Ar',
                     'barns': 663353000000.0,
                     'NumEdges': 7,
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 12.4, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 12.4, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 25.3, 'factor': 1.0},
                     'L3': {'filename': 'Ar.L3', 'excl before': 5, 'excl after': 50, 'onset': 245.2, 'factor': 1.0,
                            'XU': 0.22, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 247.29999999999998,
                            'factor': 0.5},
                     'L1': {'filename': 'Ar.L1', 'excl before': 5, 'excl after': 50, 'onset': 320.0, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3202.9, 'factor': 1.0},
                     'ene': np.array([12.462, 12.648, 13.05903, 13.9601, 14.92335,
                                      15.95306, 17.05382, 18.23053, 19.48844, 20.83314,
                                      22.27063, 23.8073, 24.794, 25.1735, 25.2747,
                                      25.45001, 25.806, 27.20606, 29.08327, 31.09002,
                                      33.23523, 35.52846, 37.97993, 40.60054, 43.40198,
                                      46.39671, 49.59809, 53.02035, 56.67876, 60.58959,
                                      64.77028, 69.23942, 74.01695, 79.12411, 84.58368,
                                      90.41995, 96.65893, 103.3284, 110.4581, 118.0797,
                                      126.2272, 134.9368, 144.2475, 154.2005, 164.8404,
                                      176.2144, 188.3732, 201.3709, 215.2655, 230.1188,
                                      240.296, 242.354, 243.974, 244.9548, 245.997,
                                      246.0635, 246.426, 247.0527, 248.5365, 250.104,
                                      252.246, 262.9708, 281.1158, 300.5128, 313.6,
                                      318.4, 319.68, 321.2482, 321.6, 326.4,
                                      343.4143, 367.1099, 392.4405, 419.5189, 448.4657,
                                      479.4098, 512.4891, 547.8508, 585.6525, 626.0625,
                                      669.2609, 715.4399, 764.8052, 817.5768, 873.9896,
                                      934.2948, 998.7612, 1067.676, 1141.345, 1220.098,
                                      1304.285, 1394.281, 1490.486, 1593.329, 1703.269,
                                      1820.795, 1946.43, 2080.733, 2224.304, 2377.781,
                                      2541.848, 2717.235, 2904.724, 3105.15, 3138.842,
                                      3186.885, 3199.697, 3218.914, 3266.958, 3319.406,
                                      3548.445, 3793.288]),
                     'dat': np.array([2.53705988e+17, 2.79298147e+17, 3.43709723e+17, 5.23027306e+17,
                                      6.72706277e+17, 7.22723094e+17, 6.73303295e+17, 5.62012562e+17,
                                      4.32154579e+17, 3.13480727e+17, 2.18853422e+17, 1.49526400e+17,
                                      1.18037033e+17, 1.08027036e+17, 1.05526195e+17, 1.01565978e+17,
                                      9.37185118e+16, 6.92805873e+16, 4.80247671e+16, 3.41620161e+16,
                                      2.51589892e+16, 1.93181661e+16, 1.55237869e+16, 1.30481535e+16,
                                      1.14163051e+16, 1.03211093e+16, 9.56090679e+15, 9.01563062e+15,
                                      8.60501512e+15, 8.27532868e+15, 7.99406700e+15, 7.74398292e+15,
                                      7.51446278e+15, 7.30086312e+15, 7.09787710e+15, 6.90351467e+15,
                                      6.71512242e+15, 6.52818954e+15, 6.33886860e+15, 6.14384282e+15,
                                      5.94039245e+15, 5.72632844e+15, 5.50012506e+15, 5.26118531e+15,
                                      5.00990720e+15, 4.74768376e+15, 4.47683673e+15, 4.20008585e+15,
                                      3.92088058e+15, 3.64260399e+15, 3.41805900e+15, 3.37109361e+15,
                                      3.33460920e+15, 3.31271855e+15, 3.35563749e+16, 3.35358109e+16,
                                      3.34223776e+16, 3.32266884e+16, 4.75299058e+16, 4.68426721e+16,
                                      4.59259182e+16, 4.16983696e+16, 3.57308460e+16, 3.06780862e+16,
                                      2.78462322e+16, 2.69022809e+16, 2.66588304e+16, 2.93580137e+16,
                                      2.92896884e+16, 2.83808948e+16, 2.54760720e+16, 2.21009319e+16,
                                      1.91403875e+16, 1.65413704e+16, 1.42614261e+16, 1.22660603e+16,
                                      1.05214419e+16, 9.00302692e+15, 7.68627121e+15, 6.54775846e+15,
                                      5.56665937e+15, 4.72380305e+15, 4.00187598e+15, 3.38515669e+15,
                                      2.85964845e+15, 2.41274753e+15, 2.03357496e+15, 1.69499959e+15,
                                      1.41353891e+15, 1.17977331e+15, 9.84283181e+14, 8.19373626e+14,
                                      6.82656572e+14, 5.69342613e+14, 4.75272524e+14, 3.97129541e+14,
                                      3.32154114e+14, 2.78077578e+14, 2.33035909e+14, 1.95476862e+14,
                                      1.64126799e+14, 1.37944256e+14, 1.16046974e+14, 9.67235009e+13,
                                      9.37782136e+13, 8.97848286e+13, 8.87632649e+13, 8.78014031e+14,
                                      8.45841410e+14, 8.12673760e+14, 6.84978308e+14, 5.76108813e+14]),
                     },
              '19': {'name': 'K',
                     'barns': 649243000000.0,
                     'NumEdges': 7,
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 17.8, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 17.8, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 33.9, 'factor': 1.0},
                     'L3': {'filename': 'K.L3', 'excl before': 5, 'excl after': 50, 'onset': 293.6, 'factor': 1.0,
                            'XU': 0.16, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 296.3, 'factor': 0.5},
                     'L1': {'filename': 'K.L1', 'excl before': 5, 'excl after': 50, 'onset': 377.09999999999997,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3607.4, 'factor': 1.0},
                     'ene': np.array([17.889, 18.156, 18.23053, 19.48844, 20.83314,
                                      22.27063, 23.8073, 25.45001, 27.20606, 29.08327,
                                      31.09002, 33.23523, 33.7305, 33.8661, 34.0695,
                                      34.578, 35.52846, 37.97993, 40.60054, 43.40198,
                                      46.39671, 49.59809, 53.02035, 56.67876, 60.58959,
                                      64.77028, 69.23942, 74.01695, 79.12411, 84.58368,
                                      90.41995, 96.65893, 103.3284, 110.4581, 118.0797,
                                      126.2272, 134.9368, 144.2475, 154.2005, 164.8404,
                                      176.2144, 188.3732, 201.3709, 215.2655, 230.1188,
                                      245.997, 262.9708, 281.1158, 287.728, 290.374,
                                      292.132, 293.3064, 294.8185, 295.068, 296.0037,
                                      297.7815, 299.472, 300.5128, 302.226, 321.2482,
                                      343.4143, 367.1099, 369.558, 375.2145, 376.7229,
                                      378.9855, 384.642, 392.4405, 419.5189, 448.4657,
                                      479.4098, 512.4891, 547.8508, 585.6525, 626.0625,
                                      669.2609, 715.4399, 764.8052, 817.5768, 873.9896,
                                      934.2948, 998.7612, 1067.676, 1141.345, 1220.098,
                                      1304.285, 1394.281, 1490.486, 1593.329, 1703.269,
                                      1820.795, 1946.43, 2080.733, 2224.304, 2377.781,
                                      2541.848, 2717.235, 2904.724, 3105.15, 3319.406,
                                      3535.252, 3548.445, 3589.363, 3603.793, 3625.437,
                                      3679.548, 3793.288]),
                     'dat': np.array([1.65888079e+18, 1.47105479e+18, 1.42294588e+18, 8.28174371e+17,
                                      4.92282012e+17, 3.07052984e+17, 2.00453776e+17, 1.36587742e+17,
                                      9.68670556e+16, 7.12933738e+16, 5.43026845e+16, 4.26831825e+16,
                                      4.06263807e+16, 4.00953000e+16, 4.07932362e+16, 3.90552127e+16,
                                      3.62160730e+16, 3.07663273e+16, 2.68948913e+16, 2.40784751e+16,
                                      2.19807710e+16, 2.03719469e+16, 1.90955351e+16, 1.80424630e+16,
                                      1.71393660e+16, 1.63356031e+16, 1.55987123e+16, 1.49033731e+16,
                                      1.42288096e+16, 1.35646340e+16, 1.29056524e+16, 1.22473200e+16,
                                      1.15889876e+16, 1.09306551e+16, 1.02749197e+16, 9.62372899e+15,
                                      8.97967993e+15, 8.34601876e+15, 7.72599170e+15, 7.12349420e+15,
                                      6.54307095e+15, 5.98679955e+15, 5.45792620e+15, 4.95846356e+15,
                                      4.49003474e+15, 4.05335390e+15, 3.64887551e+15, 3.27627495e+15,
                                      3.15382772e+15, 3.10662776e+15, 3.07585364e+15, 3.05553233e+15,
                                      2.54990188e+16, 2.54568180e+16, 2.52977535e+16, 3.60264941e+16,
                                      3.56239634e+16, 3.53798480e+16, 3.49825113e+16, 3.09903161e+16,
                                      2.70734331e+16, 2.35129845e+16, 2.31792736e+16, 2.24300472e+16,
                                      2.22352743e+16, 2.47919932e+16, 2.40401698e+16, 2.30520220e+16,
                                      2.00077215e+16, 1.73101169e+16, 1.49299920e+16, 1.28413773e+16,
                                      1.10163552e+16, 9.42895609e+15, 8.05256093e+15, 6.86249851e+15,
                                      5.83727889e+15, 4.95677553e+15, 4.20242009e+15, 3.55772179e+15,
                                      3.00787789e+15, 2.53990354e+15, 2.13815197e+15, 1.79801356e+15,
                                      1.50481543e+15, 1.25518149e+15, 1.04781328e+15, 8.75504186e+14,
                                      7.29814056e+14, 6.08509494e+14, 5.07844367e+14, 4.24234853e+14,
                                      3.54720405e+14, 2.96885839e+14, 2.48718501e+14, 2.08569314e+14,
                                      1.75068375e+14, 1.47086002e+14, 1.22434245e+14, 1.01035196e+14,
                                      8.43431581e+13, 8.34536952e+13, 8.07658292e+13, 7.98439041e+13,
                                      7.75845385e+14, 7.45850358e+14, 6.87872958e+14]), },
              '20': {'name': 'Ca',
                     'barns': 665545000000.0,
                     'NumEdges': 7,
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 25.4, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 25.4, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 43.7, 'factor': 1.0},
                     'L3': {'filename': 'Ca.L3', 'excl before': 5, 'excl after': 50, 'onset': 346.4, 'factor': 1.0,
                            'XU': 0.12, 'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 350.0, 'factor': 0.5},
                     'L1': {'filename': 'Ca.L1', 'excl before': 5, 'excl after': 50, 'onset': 437.8, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4038.1, 'factor': 1.0},
                     'ene': np.array([17.889, 18.156, 18.23053, 19.48844, 20.83314,
                                      22.27063, 23.8073, 25.45001, 27.20606, 29.08327,
                                      31.09002, 33.23523, 33.7305, 33.8661, 34.0695,
                                      34.578, 35.52846, 37.97993, 40.60054, 43.40198,
                                      46.39671, 49.59809, 53.02035, 56.67876, 60.58959,
                                      64.77028, 69.23942, 74.01695, 79.12411, 84.58368,
                                      90.41995, 96.65893, 103.3284, 110.4581, 118.0797,
                                      126.2272, 134.9368, 144.2475, 154.2005, 164.8404,
                                      176.2144, 188.3732, 201.3709, 215.2655, 230.1188,
                                      245.997, 262.9708, 281.1158, 287.728, 290.374,
                                      292.132, 293.3064, 294.8185, 295.068, 296.0037,
                                      297.7815, 299.472, 300.5128, 302.226, 321.2482,
                                      343.4143, 367.1099, 369.558, 375.2145, 376.7229,
                                      378.9855, 384.642, 392.4405, 419.5189, 448.4657,
                                      479.4098, 512.4891, 547.8508, 585.6525, 626.0625,
                                      669.2609, 715.4399, 764.8052, 817.5768, 873.9896,
                                      934.2948, 998.7612, 1067.676, 1141.345, 1220.098,
                                      1304.285, 1394.281, 1490.486, 1593.329, 1703.269,
                                      1820.795, 1946.43, 2080.733, 2224.304, 2377.781,
                                      2541.848, 2717.235, 2904.724, 3105.15, 3319.406,
                                      3535.252, 3548.445, 3589.363, 3603.793, 3625.437,
                                      3679.548, 3793.288]),
                     'dat': np.array([1.70053403e+18, 1.50799186e+18, 1.45867498e+18, 8.48969202e+17,
                                      5.04642841e+17, 3.14762852e+17, 2.05487019e+17, 1.40017357e+17,
                                      9.92993140e+16, 7.30834964e+16, 5.56661838e+16, 4.37549249e+16,
                                      4.16464784e+16, 4.11020626e+16, 4.18175234e+16, 4.00358595e+16,
                                      3.71254312e+16, 3.15388465e+16, 2.75702016e+16, 2.46830674e+16,
                                      2.25326915e+16, 2.08834710e+16, 1.95750095e+16, 1.84954956e+16,
                                      1.75697225e+16, 1.67457777e+16, 1.59903842e+16, 1.52775855e+16,
                                      1.45860842e+16, 1.39052317e+16, 1.32297035e+16, 1.25548409e+16,
                                      1.18799782e+16, 1.12051156e+16, 1.05329152e+16, 9.86537354e+15,
                                      9.20515290e+15, 8.55558098e+15, 7.91998550e+15, 7.30235974e+15,
                                      6.70736251e+15, 6.13712355e+15, 5.59497060e+15, 5.08296683e+15,
                                      4.60277611e+15, 4.15513054e+15, 3.74049601e+15, 3.35853973e+15,
                                      3.23301795e+15, 3.18463282e+15, 3.15308599e+15, 3.13225443e+15,
                                      2.61392799e+16, 2.60960194e+16, 2.59329609e+16, 3.69310920e+16,
                                      3.65184542e+16, 3.62682092e+16, 3.58608957e+16, 3.17684595e+16,
                                      2.77532265e+16, 2.41033777e+16, 2.37612876e+16, 2.29932487e+16,
                                      2.27935852e+16, 2.54145014e+16, 2.46438003e+16, 2.36308408e+16,
                                      2.05101003e+16, 1.77447608e+16, 1.53048728e+16, 1.31638146e+16,
                                      1.12929676e+16, 9.66571004e+15, 8.25475464e+15, 7.03481065e+15,
                                      5.98384854e+15, 5.08123641e+15, 4.30793968e+15, 3.64705349e+15,
                                      3.08340343e+15, 2.60367859e+15, 2.19183935e+15, 1.84316032e+15,
                                      1.54260020e+15, 1.28669815e+15, 1.07412308e+15, 8.97487432e+14,
                                      7.48139134e+14, 6.23788707e+14, 5.20595954e+14, 4.34887069e+14,
                                      3.63627166e+14, 3.04340418e+14, 2.54963634e+14, 2.13806331e+14,
                                      1.79464209e+14, 1.50779220e+14, 1.25508476e+14, 1.03572113e+14,
                                      8.64609510e+13, 8.55491543e+13, 8.27937980e+13, 8.18487241e+13,
                                      7.95326275e+14, 7.64578096e+14, 7.05144928e+14]), },
              '21': {'name': 'Sc',
                     'barns': 746511000000.0,
                     'NumEdges': 7,
                     'M3': {'filename': 'Sc.M3', 'excl before': 5, 'excl after': 50, 'onset': 32.300000000000004,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 32.300000000000004,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 53.8, 'factor': 1.0},
                     'L3': {'filename': 'Sc.L3', 'excl before': 5, 'excl after': 50, 'onset': 402.2, 'factor': 1.0,
                            'XU': 0.13, 'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 406.7, 'factor': 0.5},
                     'L1': {'filename': 'Sc.L1', 'excl before': 5, 'excl after': 50, 'onset': 500.4, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4492.8, 'factor': 1.0},
                     'ene': np.array([32.4615, 32.946, 33.23523, 35.52846, 37.97993,
                                      40.60054, 43.40198, 46.39671, 49.59809, 52.724,
                                      53.02035, 53.531, 53.7462, 54.069, 54.876,
                                      56.67876, 60.58959, 64.77028, 69.23942, 74.01695,
                                      79.12411, 84.58368, 90.41995, 96.65893, 103.3284,
                                      110.4581, 118.0797, 126.2272, 134.9368, 144.2475,
                                      154.2005, 164.8404, 176.2144, 188.3732, 201.3709,
                                      215.2655, 230.1188, 245.997, 262.9708, 281.1158,
                                      300.5128, 321.2482, 343.4143, 367.1099, 392.4405,
                                      394.156, 398.566, 400.189, 401.7978, 404.211,
                                      404.6665, 406.2933, 408.7335, 410.244, 414.834,
                                      419.5189, 448.4657, 479.4098, 490.392, 497.898,
                                      499.8996, 502.902, 510.408, 512.4891, 547.8508,
                                      585.6525, 626.0625, 669.2609, 715.4399, 764.8052,
                                      817.5768, 873.9896, 934.2948, 998.7612, 1067.676,
                                      1141.345, 1220.098, 1304.285, 1394.281, 1490.486,
                                      1593.329, 1703.269, 1820.795, 1946.43, 2080.733,
                                      2224.304, 2377.781, 2541.848, 2717.235, 2904.724,
                                      3105.15, 3319.406, 3548.445, 3793.288]),
                     'dat': np.array([1.39172046e+17, 1.19815016e+17, 1.09677396e+17, 5.58614181e+16,
                                      3.08122415e+16, 1.96496625e+16, 1.41254811e+16, 1.11946790e+16,
                                      9.59565239e+15, 8.79987167e+15, 8.74910892e+15, 8.67072526e+15,
                                      8.64011831e+15, 1.23637152e+16, 1.23002617e+16, 1.22218781e+16,
                                      1.22718943e+16, 1.24928616e+16, 1.28108753e+16, 1.31796517e+16,
                                      1.35618653e+16, 1.39231767e+16, 1.42307392e+16, 1.44561855e+16,
                                      1.45726412e+16, 1.45629366e+16, 1.44143809e+16, 1.41247346e+16,
                                      1.36917583e+16, 1.31154518e+16, 1.24182105e+16, 1.16321344e+16,
                                      1.07870840e+16, 9.91217306e+15, 9.03427612e+15, 8.17429545e+15,
                                      7.34850498e+15, 6.56914750e+15, 5.84413601e+15, 5.17787495e+15,
                                      4.57185732e+15, 4.02533661e+15, 3.53584935e+15, 3.09996158e+15,
                                      2.71379144e+15, 2.69012704e+15, 2.63077942e+15, 2.60935455e+15,
                                      2.58837759e+15, 1.90524537e+16, 1.90054235e+16, 1.88374586e+16,
                                      2.66750776e+16, 2.64578429e+16, 2.58136039e+16, 2.51783230e+16,
                                      2.17152585e+16, 1.86911424e+16, 1.77512851e+16, 1.71443716e+16,
                                      1.69868578e+16, 1.89860143e+16, 1.83813404e+16, 1.82186010e+16,
                                      1.57245077e+16, 1.35424561e+16, 1.16291484e+16, 9.95771023e+15,
                                      8.50873238e+15, 7.25750529e+15, 6.18058852e+15, 5.25372046e+15,
                                      4.45704393e+15, 3.77682310e+15, 3.18394407e+15, 2.68034775e+15,
                                      2.25416462e+15, 1.89449562e+15, 1.59163610e+15, 1.33707585e+15,
                                      1.12334975e+15, 9.39708047e+14, 7.86076083e+14, 6.58318190e+14,
                                      5.50447351e+14, 4.59761195e+14, 3.84371049e+14, 3.21656660e+14,
                                      2.69423285e+14, 2.25894229e+14, 1.87687796e+14, 1.54632289e+14,
                                      1.27526474e+14, 1.05272981e+14]), },
              '22': {'name': 'Ti',
                     'barns': 795067000000.0,
                     'NumEdges': 7,
                     'M3': {'filename': 'Ti.M3', 'excl before': 5, 'excl after': 50, 'onset': 34.6, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 34.6, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 60.3, 'factor': 1.0},
                     'L3': {'filename': 'Ti.L3', 'excl before': 5, 'excl after': 50, 'onset': 455.5, 'factor': 1.0,
                            'XU': 0.13, 'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 461.5, 'factor': 0.5},
                     'L1': {'filename': 'Ti.L1', 'excl before': 5, 'excl after': 50, 'onset': 563.6999999999999,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4966.400000000001,
                            'factor': 1.0},
                     'ene': np.array([34.773, 35.292, 35.52846, 37.97993, 40.60054,
                                      43.40198, 46.39671, 49.59809, 53.02035, 56.67876,
                                      59.094, 59.9985, 60.2397, 60.58959, 60.6015,
                                      61.506, 64.77028, 69.23942, 74.01695, 79.12411,
                                      84.58368, 90.41995, 96.65893, 103.3284, 110.4581,
                                      118.0797, 126.2272, 134.9368, 144.2475, 154.2005,
                                      164.8404, 176.2144, 188.3732, 201.3709, 215.2655,
                                      230.1188, 245.997, 262.9708, 281.1158, 300.5128,
                                      321.2482, 343.4143, 367.1099, 392.4405, 419.5189,
                                      446.39, 448.4657, 452.27, 453.2225, 455.0445,
                                      457.7775, 459.1925, 461.0385, 463.8075, 464.61,
                                      470.73, 479.4098, 512.4891, 547.8508, 552.426,
                                      560.8815, 563.1363, 566.5185, 574.974, 585.6525,
                                      626.0625, 669.2609, 715.4399, 764.8052, 817.5768,
                                      873.9896, 934.2948, 998.7612, 1067.676, 1141.345,
                                      1220.098, 1304.285, 1394.281, 1490.486, 1593.329,
                                      1703.269, 1820.795, 1946.43, 2080.733, 2224.304,
                                      2377.781, 2541.848, 2717.235, 2904.724, 3105.15,
                                      3319.406, 3548.445, 3793.288]),
                     'dat': np.array([8.85704638e+16, 7.79308772e+16, 7.35619840e+16, 4.13371235e+16,
                                      2.48052953e+16, 1.69086899e+16, 1.28021688e+16, 1.05553095e+16,
                                      9.31659511e+15, 8.67418097e+15, 8.47620929e+15, 8.43327567e+15,
                                      8.42452993e+15, 1.22472121e+16, 1.22464170e+16, 1.22432367e+16,
                                      1.23179730e+16, 1.25596734e+16, 1.28840607e+16, 1.32442261e+16,
                                      1.36067766e+16, 1.39383196e+16, 1.42094374e+16, 1.43938930e+16,
                                      1.44702194e+16, 1.44217203e+16, 1.42412401e+16, 1.39263936e+16,
                                      1.34803610e+16, 1.29007571e+16, 1.22122291e+16, 1.14418092e+16,
                                      1.06189149e+16, 9.77057836e+15, 8.91985667e+15, 8.08742152e+15,
                                      7.28734560e+15, 6.53107787e+15, 5.82569443e+15, 5.17556814e+15,
                                      4.58228915e+15, 4.04538040e+15, 3.56277473e+15, 3.13145089e+15,
                                      2.74791057e+15, 2.43036081e+15, 2.40809893e+15, 2.36794805e+15,
                                      2.35808922e+15, 2.33932563e+15, 1.69540087e+16, 1.68355437e+16,
                                      1.66836859e+16, 2.36198504e+16, 2.35268276e+16, 2.28398897e+16,
                                      2.19144317e+16, 1.88375224e+16, 1.61533762e+16, 1.58440952e+16,
                                      1.52915236e+16, 1.51484116e+16, 1.69754755e+16, 1.64244941e+16,
                                      1.57622033e+16, 1.35638430e+16, 1.16493217e+16, 9.98524645e+15,
                                      8.55174065e+15, 7.29275206e+15, 6.20859870e+15, 5.28314071e+15,
                                      4.49284411e+15, 3.78110013e+15, 3.18074504e+15, 2.67468489e+15,
                                      2.24916504e+15, 1.89170291e+15, 1.59148561e+15, 1.33944937e+15,
                                      1.12788205e+15, 9.50264078e+14, 7.95464534e+14, 6.66242294e+14,
                                      5.58709482e+14, 4.67276777e+14, 3.90783381e+14, 3.27122366e+14,
                                      2.74083447e+14, 2.27651534e+14, 1.87548355e+14, 1.54672334e+14,
                                      1.27687760e+14])},
              '23': {'name': 'V',
                     'barns': 845904000000.0,
                     'NumEdges': 8,
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2.2,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'V.M3', 'excl before': 5, 'excl after': 50, 'onset': 37.8, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 37.8, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 66.5, 'factor': 1.0},
                     'L3': {'filename': 'V.L3', 'excl before': 5, 'excl after': 50, 'onset': 512.9, 'factor': 1.0,
                            'XU': 0.14, 'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 520.5, 'factor': 0.5},
                     'L1': {'filename': 'V.L1', 'excl before': 5, 'excl after': 50, 'onset': 628.1999999999999,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5465.099999999999,
                            'factor': 1.0},
                     'ene': np.array([10.69, 11.42761, 12.21612, 13.05903, 13.9601,
                                      14.92335, 15.95306, 17.05382, 18.23053, 19.48844,
                                      20.83314, 22.27063, 23.8073, 25.45001, 27.20606,
                                      29.08327, 31.09002, 33.23523, 35.52846, 37.044,
                                      37.611, 37.7622, 37.97993, 37.989, 38.556,
                                      40.60054, 43.40198, 46.39671, 49.59809, 53.02035,
                                      56.67876, 60.58959, 64.77028, 65.17, 66.1675,
                                      66.4335, 66.8325, 67.83, 69.23942, 74.01695,
                                      79.12411, 84.58368, 90.41995, 96.65893, 103.3284,
                                      110.4581, 118.0797, 126.2272, 134.9368, 144.2475,
                                      154.2005, 164.8404, 176.2144, 188.3732, 201.3709,
                                      215.2655, 230.1188, 245.997, 262.9708, 281.1158,
                                      300.5128, 321.2482, 343.4143, 367.1099, 392.4405,
                                      419.5189, 448.4657, 479.4098, 502.642, 510.09,
                                      510.3355, 512.4891, 515.4645, 517.8975, 519.9795,
                                      523.1025, 523.158, 530.91, 547.8508, 585.6525,
                                      615.636, 625.059, 626.0625, 627.5718, 631.341,
                                      640.764, 669.2609, 715.4399, 764.8052, 817.5768,
                                      873.9896, 934.2948, 998.7612, 1067.676, 1141.345,
                                      1220.098, 1304.285, 1394.281, 1490.486, 1593.329,
                                      1703.269, 1820.795, 1946.43, 2080.733, 2224.304,
                                      2377.781, 2541.848, 2717.235, 2904.724, 3105.15,
                                      3319.406, 3548.445, 3793.288]),
                     'dat': np.array([9.10277294e+16, 9.06216955e+16, 9.01141531e+16, 8.94628070e+16,
                                      8.86676573e+16, 8.76948677e+16, 8.65359792e+16, 8.51909918e+16,
                                      8.36370662e+16, 8.18851990e+16, 7.99370821e+16, 7.78011745e+16,
                                      7.54901648e+16, 7.30209710e+16, 7.04130490e+16, 6.76875463e+16,
                                      6.48689941e+16, 6.19810779e+16, 5.90508664e+16, 5.72042580e+16,
                                      5.65326102e+16, 5.63549704e+16, 1.18824135e+17, 1.18697249e+17,
                                      1.11363262e+17, 9.09008438e+16, 7.19035318e+16, 5.98307899e+16,
                                      5.14715666e+16, 4.51306702e+16, 4.00459413e+16, 3.58401066e+16,
                                      3.23093033e+16, 3.20123910e+16, 3.13001398e+16, 3.11157327e+16,
                                      3.46456901e+16, 3.40011113e+16, 3.31467482e+16, 3.06640200e+16,
                                      2.85501059e+16, 2.67339500e+16, 2.51622604e+16, 2.37859746e+16,
                                      2.25585679e+16, 2.14352074e+16, 2.03786733e+16, 1.93559753e+16,
                                      1.83434282e+16, 1.73241139e+16, 1.62887274e+16, 1.52220425e+16,
                                      1.41299804e+16, 1.30269216e+16, 1.19314759e+16, 1.08580237e+16,
                                      9.82348315e+15, 8.83969680e+15, 7.91546209e+15, 7.05678494e+15,
                                      6.26654142e+15, 5.54583121e+15, 4.89363923e+15, 4.30734317e+15,
                                      3.78330564e+15, 3.31712795e+15, 2.90424220e+15, 2.53965758e+15,
                                      2.30779529e+15, 2.23995379e+15, 2.23775444e+15, 2.21872160e+15,
                                      1.52854853e+16, 1.51196881e+16, 1.49792680e+16, 2.11611345e+16,
                                      2.11560590e+16, 2.04429620e+16, 1.90006956e+16, 1.62608126e+16,
                                      1.44573453e+16, 1.39464192e+16, 1.38931273e+16, 1.38144582e+16,
                                      1.54834268e+16, 1.49758844e+16, 1.35725297e+16, 1.16599407e+16,
                                      9.99181805e+15, 8.55208944e+15, 7.31165581e+15, 6.22881410e+15,
                                      5.30339513e+15, 4.47288658e+15, 3.76410362e+15, 3.16706458e+15,
                                      2.66400547e+15, 2.24071511e+15, 1.88492788e+15, 1.58615459e+15,
                                      1.33517487e+15, 1.12446019e+15, 9.47497070e+14, 7.98051211e+14,
                                      6.68340291e+14, 5.60369105e+14, 4.70043476e+14, 3.93218474e+14,
                                      3.29251214e+14, 2.73421550e+14, 2.25331908e+14, 1.85887404e+14,
                                      1.53506199e+14]), },
              '24': {'name': 'Cr',
                     'barns': 863413999999.9999,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2.3, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2.3,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Cr.M3', 'excl before': 5, 'excl after': 50, 'onset': 42.5, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 42.5, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 74.1, 'factor': 1.0},
                     'L3': {'filename': 'Cr.L3', 'excl before': 5, 'excl after': 50, 'onset': 574.5, 'factor': 1.0,
                            'XU': 0.16, 'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 583.7, 'factor': 0.5},
                     'L1': {'filename': 'Cr.L1', 'excl before': 5, 'excl after': 50, 'onset': 694.6, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5989.200000000001,
                            'factor': 1.0},
                     'dat': np.array([1.33760097e+17, 1.31601562e+17, 1.29494832e+17, 1.27396736e+17,
                                      1.25281371e+17, 1.23096934e+17, 1.20826155e+17, 1.18443133e+17,
                                      1.15930598e+17, 1.13262649e+17, 1.10439285e+17, 1.07460506e+17,
                                      1.04317679e+17, 1.01028072e+17, 9.75916844e+16, 9.40344187e+16,
                                      9.03649092e+16, 8.66176925e+16, 8.28074465e+16, 7.89592103e+16,
                                      7.51006131e+16, 7.36267654e+16, 7.27512636e+16, 7.25198687e+16,
                                      1.65464659e+17, 1.52029937e+17, 1.50976572e+17, 1.06467580e+17,
                                      8.17445839e+16, 6.76061796e+16, 5.80447330e+16, 5.08145041e+16,
                                      4.49795523e+16, 4.01038535e+16, 3.70801776e+16, 3.61856807e+16,
                                      3.59620565e+16, 3.59551492e+16, 3.86878545e+16, 3.78883331e+16,
                                      3.55899251e+16, 3.26629516e+16, 3.01383291e+16, 2.79521648e+16,
                                      2.60535174e+16, 2.43897187e+16, 2.29115539e+16, 2.15723988e+16,
                                      2.03325363e+16, 1.91548396e+16, 1.80134063e+16, 1.68883778e+16,
                                      1.57668031e+16, 1.46322771e+16, 1.34917072e+16, 1.23580446e+16,
                                      1.12476942e+16, 1.01744706e+16, 9.15132499e+15, 8.18853203e+15,
                                      7.29317172e+15, 6.46887037e+15, 5.71683678e+15, 5.03655289e+15,
                                      4.42560114e+15, 3.88018252e+15, 3.39580726e+15, 2.96755392e+15,
                                      2.59024200e+15, 2.25869102e+15, 2.13513648e+15, 2.06632238e+15,
                                      2.05216240e+15, 1.41453116e+16, 1.39406824e+16, 1.38025362e+16,
                                      1.95744588e+16, 1.95459661e+16, 1.94941613e+16, 1.87887521e+16,
                                      1.65801390e+16, 1.40555165e+16, 1.34813462e+16, 1.29883368e+16,
                                      1.28605515e+16, 1.43853407e+16, 1.39001020e+16, 1.35892729e+16,
                                      1.16474549e+16, 9.97588536e+15, 8.53053032e+15, 7.28842294e+15,
                                      6.22055250e+15, 5.25050688e+15, 4.42957284e+15, 3.73176165e+15,
                                      3.14023672e+15, 2.64221952e+15, 2.22242764e+15, 1.86955033e+15,
                                      1.57305397e+15, 1.32404537e+15, 1.11492650e+15, 9.39308091e+14,
                                      7.91871516e+14, 6.65838974e+14, 5.58033102e+14, 4.68229412e+14,
                                      3.92292151e+14, 3.25722931e+14, 2.68530388e+14, 2.21612471e+14,
                                      1.83069670e+14]),
                     'ene': np.array([10.69, 11.42761, 12.21612, 13.05903, 13.9601,
                                      14.92335, 15.95306, 17.05382, 18.23053, 19.48844,
                                      20.83314, 22.27063, 23.8073, 25.45001, 27.20606,
                                      29.08327, 31.09002, 33.23523, 35.52846, 37.97993,
                                      40.60054, 41.65, 42.2875, 42.4575, 42.7125,
                                      43.35, 43.40198, 46.39671, 49.59809, 53.02035,
                                      56.67876, 60.58959, 64.77028, 69.23942, 72.618,
                                      73.7295, 74.01695, 74.0259, 74.4705, 75.582,
                                      79.12411, 84.58368, 90.41995, 96.65893, 103.3284,
                                      110.4581, 118.0797, 126.2272, 134.9368, 144.2475,
                                      154.2005, 164.8404, 176.2144, 188.3732, 201.3709,
                                      215.2655, 230.1188, 245.997, 262.9708, 281.1158,
                                      300.5128, 321.2482, 343.4143, 367.1099, 392.4405,
                                      419.5189, 448.4657, 479.4098, 512.4891, 547.8508,
                                      563.01, 572.026, 573.9255, 577.3725, 580.7815,
                                      583.1163, 585.6525, 585.99, 586.6185, 595.374,
                                      626.0625, 669.2609, 680.708, 691.127, 693.9054,
                                      698.073, 708.492, 715.4399, 764.8052, 817.5768,
                                      873.9896, 934.2948, 998.7612, 1067.676, 1141.345,
                                      1220.098, 1304.285, 1394.281, 1490.486, 1593.329,
                                      1703.269, 1820.795, 1946.43, 2080.733, 2224.304,
                                      2377.781, 2541.848, 2717.235, 2904.724, 3105.15,
                                      3319.406, 3548.445, 3793.288]), },
              '25': {'name': 'Mn',
                     'barns': 912268000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7.14378, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7.26159,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Mn.M3', 'excl before': 5, 'excl after': 50, 'onset': 48.599999999999994,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 48.599999999999994,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 83.9, 'factor': 1.0},
                     'L3': {'filename': 'Mn.L3', 'excl before': 5, 'excl after': 50, 'onset': 640.3, 'factor': 1.0,
                            'XU': 0.18, 'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 651.4, 'factor': 0.5},
                     'L1': {'filename': 'Mn.L1', 'excl before': 5, 'excl after': 50, 'onset': 769.0, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6539.0, 'factor': 1.0},
                     'dat': np.array([8.42680197e+15, 8.48272400e+15, 8.51821122e+15, 4.14543702e+16,
                                      4.15209658e+16, 4.21650270e+16, 5.85666933e+16, 6.13399881e+16,
                                      6.40421259e+16, 6.66694577e+16, 6.92110364e+16, 7.16522655e+16,
                                      7.39748999e+16, 7.61552204e+16, 7.81658590e+16, 7.99776233e+16,
                                      8.15576715e+16, 8.28722497e+16, 8.38894285e+16, 8.45754540e+16,
                                      8.49029582e+16, 8.48454853e+16, 8.43072472e+16, 8.32280342e+16,
                                      8.16288284e+16, 7.95415592e+16, 7.70091032e+16, 7.40807229e+16,
                                      7.08175403e+16, 6.94582610e+16, 6.86518161e+16, 6.84365208e+16,
                                      1.01252625e+17, 9.75579399e+16, 8.39961638e+16, 7.40460568e+16,
                                      6.68263678e+16, 6.10234311e+16, 5.60524827e+16, 5.16444037e+16,
                                      4.76687398e+16, 4.55486290e+16, 4.47412718e+16, 4.45314502e+16,
                                      4.75948461e+16, 4.74342869e+16, 4.68385759e+16, 4.41647184e+16,
                                      4.11843389e+16, 3.84429735e+16, 3.59169034e+16, 3.35814973e+16,
                                      3.14102995e+16, 2.93668192e+16, 2.69374495e+16, 2.46394464e+16,
                                      2.25229847e+16, 2.05625207e+16, 1.87379847e+16, 1.70320436e+16,
                                      1.54246273e+16, 1.39120870e+16, 1.24962471e+16, 1.11780198e+16,
                                      9.96014202e+15, 8.84115410e+15, 7.82105602e+15, 6.89692853e+15,
                                      6.06457521e+15, 5.31916103e+15, 4.65502992e+15, 4.06606970e+15,
                                      3.54589449e+15, 3.08811841e+15, 2.68644681e+15, 2.33485872e+15,
                                      2.02788054e+15, 2.01811927e+15, 1.95416928e+15, 1.94595887e+15,
                                      1.93765723e+15, 1.25254396e+16, 1.23083199e+16, 1.21879005e+16,
                                      1.72756191e+16, 1.71761819e+16, 1.65640501e+16, 1.62730366e+16,
                                      1.38217725e+16, 1.21742165e+16, 1.17445382e+16, 1.17317665e+16,
                                      1.16168207e+16, 1.30326606e+16, 1.25938597e+16, 1.14416653e+16,
                                      9.80323193e+15, 8.38921653e+15, 7.17051771e+15, 6.09987998e+15,
                                      5.15823695e+15, 4.35106223e+15, 3.66978048e+15, 3.08775350e+15,
                                      2.59786558e+15, 2.18552045e+15, 1.83822002e+15, 1.54647671e+15,
                                      1.30144153e+15, 1.09563387e+15, 9.22759082e+14, 7.77662857e+14,
                                      6.55774729e+14, 5.50426020e+14, 4.61872166e+14, 3.84849378e+14,
                                      3.17451019e+14, 2.62103719e+14, 2.16627159e+14]),
                     'ene': np.array([7.179501, 7.225283, 7.254329, 7.286658, 7.297899,
                                      7.406823, 10.69, 11.42761, 12.21612, 13.05903,
                                      13.9601, 14.92335, 15.95306, 17.05382, 18.23053,
                                      19.48844, 20.83314, 22.27063, 23.8073, 25.45001,
                                      27.20606, 29.08327, 31.09002, 33.23523, 35.52846,
                                      37.97993, 40.60054, 43.40198, 46.39671, 47.628,
                                      48.357, 48.5514, 48.843, 49.59809, 53.02035,
                                      56.67876, 60.58959, 64.77028, 69.23942, 74.01695,
                                      79.12411, 82.222, 83.4805, 83.8161, 84.3195,
                                      84.58368, 85.578, 90.41995, 96.65893, 103.3284,
                                      110.4581, 118.0797, 126.2272, 134.9368, 144.2475,
                                      154.2005, 164.8404, 176.2144, 188.3732, 201.3709,
                                      215.2655, 230.1188, 245.997, 262.9708, 281.1158,
                                      300.5128, 321.2482, 343.4143, 367.1099, 392.4405,
                                      419.5189, 448.4657, 479.4098, 512.4891, 547.8508,
                                      585.6525, 626.0625, 627.494, 637.0985, 638.372,
                                      639.6597, 643.5015, 648.143, 650.7486, 653.106,
                                      654.657, 664.428, 669.2609, 715.4399, 753.62,
                                      764.8052, 765.155, 768.231, 772.845, 784.38,
                                      817.5768, 873.9896, 934.2948, 998.7612, 1067.676,
                                      1141.345, 1220.098, 1304.285, 1394.281, 1490.486,
                                      1593.329, 1703.269, 1820.795, 1946.43, 2080.733,
                                      2224.304, 2377.781, 2541.848, 2717.235, 2904.724,
                                      3105.15, 3319.406, 3548.445, 3793.288]), },
              '26': {'name': 'Fe',
                     'barns': 927362000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.6, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.6,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Fe.M3', 'excl before': 5, 'excl after': 50, 'onset': 54.0, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 54.0, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 92.89999999999999,
                            'factor': 1.0},
                     'L3': {'filename': 'Fe.L3', 'excl before': 5, 'excl after': 50, 'onset': 708.0999999999999,
                            'factor': 1.0, 'XU': 0.19, 'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 721.0999999999999,
                            'factor': 0.5},
                     'L1': {'filename': 'Fe.L1', 'excl before': 5, 'excl after': 50, 'onset': 846.0999999999999,
                            'factor': 1.0},
                     'K1': {'filename': 'Fe.K1', 'excl before': 5, 'excl after': 50, 'onset': 7112.0, 'factor': 1.0},
                     'dat': np.array([9.30793239e+16, 9.39417706e+16, 9.49062271e+16, 9.59448725e+16,
                                      9.70391597e+16, 9.81427205e+16, 9.91442714e+16, 1.00015992e+17,
                                      1.00720787e+17, 1.01240110e+17, 1.01536865e+17, 1.01601781e+17,
                                      1.01425582e+17, 1.00998995e+17, 1.00322021e+17, 9.93946592e+16,
                                      9.82261830e+16, 9.66960357e+16, 9.47393019e+16, 9.24960132e+16,
                                      8.99902811e+16, 8.72462170e+16, 8.42934964e+16, 8.11627222e+16,
                                      7.79837253e+16, 7.78891344e+16, 7.72232885e+16, 7.70211235e+16,
                                      1.03131928e+17, 1.00377663e+17, 9.54811915e+16, 8.58310625e+16,
                                      7.87580726e+16, 7.22442819e+16, 6.49802553e+16, 5.85749660e+16,
                                      5.28624161e+16, 4.77470873e+16, 4.72528033e+16, 4.61779908e+16,
                                      4.58988548e+16, 4.86540473e+16, 4.76506416e+16, 4.63430612e+16,
                                      4.22608137e+16, 3.86023706e+16, 3.53148723e+16, 3.23584423e+16,
                                      2.96922765e+16, 2.72764985e+16, 2.50730864e+16, 2.30477278e+16,
                                      2.11726018e+16, 1.94245245e+16, 1.77849484e+16, 1.62408907e+16,
                                      1.47802956e+16, 1.33929620e+16, 1.20835269e+16, 1.08538448e+16,
                                      9.70762542e+15, 8.64829980e+15, 7.67577527e+15, 6.78949541e+15,
                                      5.98695634e+15, 5.26444860e+15, 4.61770634e+15, 4.04172180e+15,
                                      3.53093082e+15, 3.07986194e+15, 2.68285827e+15, 2.33435563e+15,
                                      2.02925353e+15, 1.88013372e+15, 1.82078255e+15, 1.80928326e+15,
                                      1.80538834e+15, 1.14464292e+16, 1.12952692e+16, 1.12145887e+16,
                                      1.11033052e+16, 1.57614446e+16, 1.56288318e+16, 1.50603589e+16,
                                      1.36581875e+16, 1.15642041e+16, 1.11682206e+16, 1.07564718e+16,
                                      1.06507526e+16, 1.19638972e+16, 1.15558579e+16, 1.12192255e+16,
                                      9.59912406e+15, 8.21327429e+15, 6.99407147e+15, 5.95255121e+15,
                                      5.05755414e+15, 4.26595794e+15, 3.59825730e+15, 3.03024807e+15,
                                      2.54903993e+15, 2.14396821e+15, 1.80297720e+15, 1.51632961e+15,
                                      1.27558643e+15, 1.07351425e+15, 9.03955383e+14, 7.61596042e+14,
                                      6.42096175e+14, 5.40837518e+14, 4.50799942e+14, 3.73680518e+14,
                                      3.09061934e+14, 2.55497505e+14, 2.11419989e+14, 1.75113766e+14,
                                      1.45187795e+14, 1.20492145e+14]),
                     'ene': np.array([10.69, 11.42761, 12.21612, 13.05903, 13.9601,
                                      14.92335, 15.95306, 17.05382, 18.23053, 19.48844,
                                      20.83314, 22.27063, 23.8073, 25.45001, 27.20606,
                                      29.08327, 31.09002, 33.23523, 35.52846, 37.97993,
                                      40.60054, 43.40198, 46.39671, 49.59809, 52.92,
                                      53.02035, 53.73, 53.946, 54.27, 55.08,
                                      56.67876, 60.58959, 64.77028, 69.23942, 74.01695,
                                      79.12411, 84.58368, 90.41995, 91.042, 92.4355,
                                      92.8071, 93.3645, 94.758, 96.65893, 103.3284,
                                      110.4581, 118.0797, 126.2272, 134.9368, 144.2475,
                                      154.2005, 164.8404, 176.2144, 188.3732, 201.3709,
                                      215.2655, 230.1188, 245.997, 262.9708, 281.1158,
                                      300.5128, 321.2482, 343.4143, 367.1099, 392.4405,
                                      419.5189, 448.4657, 479.4098, 512.4891, 547.8508,
                                      585.6525, 626.0625, 669.2609, 693.938, 704.5595,
                                      706.678, 707.3919, 711.6405, 715.4399, 717.4945,
                                      720.3789, 722.262, 724.7055, 735.522, 764.8052,
                                      817.5768, 829.178, 841.8695, 845.2539, 850.3305,
                                      863.022, 873.9896, 934.2948, 998.7612, 1067.676,
                                      1141.345, 1220.098, 1304.285, 1394.281, 1490.486,
                                      1593.329, 1703.269, 1820.795, 1946.43, 2080.733,
                                      2224.304, 2377.781, 2541.848, 2717.235, 2904.724,
                                      3105.15, 3319.406, 3548.445, 3793.288, 4055.024,
                                      4334.821, 4633.924, 4953.664]), },
              '27': {'name': 'Co',
                     'barns': 978609000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2.9, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2.9,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Co.M3', 'excl before': 5, 'excl after': 50, 'onset': 59.5, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 59.5, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 100.7, 'factor': 1.0},
                     'L3': {'filename': 'Co.L3', 'excl before': 5, 'excl after': 50, 'onset': 778.5999999999999,
                            'factor': 1.0, 'XU': 0.22, 'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 793.6, 'factor': 0.5},
                     'L1': {'filename': 'Co.L1', 'excl before': 5, 'excl after': 50, 'onset': 925.6, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7708.9, 'factor': 1.0},
                     'dat': np.array([1.01726406e+17, 1.02607154e+17, 1.03615121e+17, 1.04672019e+17,
                                      1.05728916e+17, 1.06766242e+17, 1.07735065e+17, 1.08615813e+17,
                                      1.09379128e+17, 1.09985866e+17, 1.10426240e+17, 1.10670892e+17,
                                      1.10719822e+17, 1.10553459e+17, 1.10171801e+17, 1.09565064e+17,
                                      1.08743032e+17, 1.07725279e+17, 1.06502017e+17, 1.05102607e+17,
                                      1.03546618e+17, 1.01501325e+17, 9.89960864e+16, 9.62892539e+16,
                                      9.34043146e+16, 8.79808635e+16, 8.50156783e+16, 8.34410964e+16,
                                      8.30271448e+16, 1.04280575e+17, 1.01569828e+17, 1.01227315e+17,
                                      8.91317077e+16, 7.88944790e+16, 7.06164254e+16, 6.35586973e+16,
                                      5.73650810e+16, 5.18535551e+16, 4.69223443e+16, 4.54955324e+16,
                                      4.44816935e+16, 4.42184477e+16, 4.68430770e+16, 4.58948049e+16,
                                      4.55190190e+16, 4.15664173e+16, 3.80218955e+16, 3.48296729e+16,
                                      3.19506052e+16, 2.93455481e+16, 2.69782929e+16, 2.48136098e+16,
                                      2.28192047e+16, 2.09696337e+16, 1.92433674e+16, 1.76218123e+16,
                                      1.60961608e+16, 1.46566270e+16, 1.32904888e+16, 1.19987249e+16,
                                      1.07862284e+16, 9.65495639e+15, 8.60843193e+15, 7.64694859e+15,
                                      6.76991920e+15, 5.97519083e+15, 5.25894691e+15, 4.61717512e+15,
                                      4.04498244e+15, 3.53718223e+15, 3.08829428e+15, 2.69264266e+15,
                                      2.34513861e+15, 2.04059549e+15, 1.78292774e+15, 1.77421812e+15,
                                      1.72685344e+15, 1.71285933e+15, 1.71237003e+15, 1.05454906e+16,
                                      1.03037742e+16, 1.01990630e+16, 1.45010282e+16, 1.43434721e+16,
                                      1.38081730e+16, 1.34588096e+16, 1.13410997e+16, 1.03233463e+16,
                                      9.93679579e+15, 9.83795628e+15, 1.09976079e+16, 1.08870251e+16,
                                      1.06257365e+16, 9.33270045e+15, 7.97302111e+15, 6.80123469e+15,
                                      5.79326742e+15, 4.93297225e+15, 4.16721070e+15, 3.51105337e+15,
                                      2.95647565e+15, 2.48615616e+15, 2.09079813e+15, 1.75826679e+15,
                                      1.47877606e+15, 1.24410562e+15, 1.04720949e+15, 8.81932217e+14,
                                      7.43224177e+14, 6.26759920e+14, 5.25708755e+14, 4.36038812e+14,
                                      3.61742817e+14, 2.99953445e+14, 2.48185028e+14, 2.05547034e+14,
                                      1.70395399e+14, 1.41389428e+14, 1.17433080e+14, 9.76309269e+13,
                                      8.12441192e+13, 6.76727696e+13, 5.64226805e+13, 4.70867506e+13,
                                      4.44053620e+13, 4.26223364e+13, 4.21643474e+13, 3.50968332e+14,
                                      3.35848823e+14, 3.30877489e+14, 2.75967738e+14, 2.33271027e+14,
                                      1.95623939e+14, 1.63505992e+14, 1.36437667e+14, 1.13861157e+14,
                                      9.50268483e+13, 7.93182167e+13, 6.62126849e+13, 5.52689005e+13,
                                      4.57666071e+13, 3.78917405e+13, 3.13556110e+13, 2.59497749e+13,
                                      2.14765531e+13, 1.77764325e+13, 1.47143649e+13, 1.21807462e+13,
                                      1.00356353e+13, 8.25681772e+12, 6.79350368e+12, 5.57748413e+12,
                                      4.56403665e+12, 3.73486125e+12, 3.05639163e+12, 2.50132460e+12,
                                      2.04695645e+12, 1.67518289e+12, 1.37093335e+12, 1.12197522e+12,
                                      9.18258183e+11, 7.51561926e+11, 6.15134045e+11, 5.03494330e+11,
                                      4.11426796e+11, 3.34938716e+11, 2.72679612e+11, 2.21997452e+11,
                                      1.80729510e+11, 1.47143649e+11, 1.19801314e+11, 9.75379590e+10,
                                      7.94150990e+10, 6.46596325e+10, 5.26472070e+10, 4.28660100e+10,
                                      3.49030686e+10, 2.84197840e+10, 2.31411670e+10, 1.88431163e+10,
                                      1.53436105e+10, 1.24939011e+10, 1.01736192e+10, 8.28461021e+09,
                                      6.74623686e+09, 5.49361734e+09, 4.47361318e+09, 3.64296986e+09,
                                      2.96665318e+09, 2.41589204e+09]),
                     'ene': np.array([1.069000e+01, 1.142761e+01, 1.221612e+01, 1.305903e+01,
                                      1.396010e+01, 1.492335e+01, 1.595306e+01, 1.705382e+01,
                                      1.823053e+01, 1.948844e+01, 2.083314e+01, 2.227063e+01,
                                      2.380730e+01, 2.545001e+01, 2.720606e+01, 2.908327e+01,
                                      3.109002e+01, 3.323523e+01, 3.552846e+01, 3.797993e+01,
                                      4.060054e+01, 4.340198e+01, 4.639671e+01, 4.959809e+01,
                                      5.302035e+01, 5.667876e+01, 5.831000e+01, 5.920250e+01,
                                      5.944050e+01, 5.979750e+01, 6.058959e+01, 6.069000e+01,
                                      6.477028e+01, 6.923942e+01, 7.401695e+01, 7.912411e+01,
                                      8.458368e+01, 9.041995e+01, 9.665893e+01, 9.868600e+01,
                                      1.001965e+02, 1.005993e+02, 1.012035e+02, 1.027140e+02,
                                      1.033284e+02, 1.104581e+02, 1.180797e+02, 1.262272e+02,
                                      1.349368e+02, 1.442475e+02, 1.542005e+02, 1.648404e+02,
                                      1.762144e+02, 1.883732e+02, 2.013709e+02, 2.152655e+02,
                                      2.301188e+02, 2.459970e+02, 2.629708e+02, 2.811158e+02,
                                      3.005128e+02, 3.212482e+02, 3.434143e+02, 3.671099e+02,
                                      3.924405e+02, 4.195189e+02, 4.484657e+02, 4.794098e+02,
                                      5.124891e+02, 5.478508e+02, 5.856525e+02, 6.260625e+02,
                                      6.692609e+02, 7.154399e+02, 7.630280e+02, 7.648052e+02,
                                      7.747070e+02, 7.777280e+02, 7.778214e+02, 7.824930e+02,
                                      7.896320e+02, 7.928064e+02, 7.941720e+02, 7.975680e+02,
                                      8.094720e+02, 8.175768e+02, 8.739896e+02, 9.070880e+02,
                                      9.209720e+02, 9.246744e+02, 9.302280e+02, 9.342948e+02,
                                      9.441120e+02, 9.987612e+02, 1.067676e+03, 1.141345e+03,
                                      1.220098e+03, 1.304285e+03, 1.394281e+03, 1.490486e+03,
                                      1.593329e+03, 1.703269e+03, 1.820795e+03, 1.946430e+03,
                                      2.080733e+03, 2.224304e+03, 2.377781e+03, 2.541848e+03,
                                      2.717235e+03, 2.904724e+03, 3.105150e+03, 3.319406e+03,
                                      3.548445e+03, 3.793288e+03, 4.055024e+03, 4.334821e+03,
                                      4.633924e+03, 4.953664e+03, 5.295467e+03, 5.660855e+03,
                                      6.051453e+03, 6.469004e+03, 6.915365e+03, 7.392525e+03,
                                      7.554722e+03, 7.670355e+03, 7.701191e+03, 7.747444e+03,
                                      7.863078e+03, 7.902609e+03, 8.447890e+03, 9.030794e+03,
                                      9.653919e+03, 1.032004e+04, 1.103212e+04, 1.179334e+04,
                                      1.260708e+04, 1.347697e+04, 1.440688e+04, 1.540095e+04,
                                      1.646362e+04, 1.759961e+04, 1.881398e+04, 2.011215e+04,
                                      2.149988e+04, 2.298338e+04, 2.456923e+04, 2.626450e+04,
                                      2.807676e+04, 3.001405e+04, 3.208502e+04, 3.429889e+04,
                                      3.666551e+04, 3.919543e+04, 4.189992e+04, 4.479101e+04,
                                      4.788159e+04, 5.118542e+04, 5.471721e+04, 5.849270e+04,
                                      6.252870e+04, 6.684318e+04, 7.145536e+04, 7.638578e+04,
                                      8.165640e+04, 8.729069e+04, 9.331374e+04, 9.975239e+04,
                                      1.066353e+05, 1.139931e+05, 1.218587e+05, 1.302669e+05,
                                      1.392553e+05, 1.488640e+05, 1.591356e+05, 1.701159e+05,
                                      1.818539e+05, 1.944018e+05, 2.078156e+05, 2.221548e+05,
                                      2.374835e+05, 2.538699e+05, 2.713869e+05, 2.901126e+05,
                                      3.101304e+05, 3.315294e+05, 3.544049e+05, 3.788588e+05,
                                      4.050001e+05, 4.329451e+05]), },
              '28': {'name': 'Ni',
                     'barns': 974571000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.6, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.6,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Ni.M3', 'excl before': 5, 'excl after': 50, 'onset': 68.1, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 68.1, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 111.8, 'factor': 1.0},
                     'L3': {'filename': 'Ni.L3', 'excl before': 5, 'excl after': 50, 'onset': 854.7, 'factor': 1.0,
                            'XU': 0.14, 'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 871.9, 'factor': 0.5},
                     'L1': {'filename': 'Ni.L1', 'excl before': 5, 'excl after': 50, 'onset': 1008.1, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8332.800000000001,
                            'factor': 1.0},
                     'dat': np.array([9.37527556e+16, 9.44593196e+16, 9.53510521e+16, 9.64065125e+16,
                                      9.76032856e+16, 9.89092108e+16, 1.00234627e+17, 1.01530807e+17,
                                      1.02758766e+17, 1.03889269e+17, 1.04883331e+17, 1.05731208e+17,
                                      1.06393916e+17, 1.06861710e+17, 1.07105353e+17, 1.07115099e+17,
                                      1.06881202e+17, 1.06423153e+17, 1.05711716e+17, 1.04785874e+17,
                                      1.03635880e+17, 1.02281226e+17, 1.00751150e+17, 9.90553964e+16,
                                      9.68869760e+16, 9.42254226e+16, 9.13670058e+16, 8.83448612e+16,
                                      8.69434281e+16, 8.60906784e+16, 8.56716129e+16, 1.02144787e+17,
                                      1.00107933e+17, 9.95524276e+16, 8.92336699e+16, 7.98524495e+16,
                                      7.19428312e+16, 6.50136314e+16, 5.88173090e+16, 5.32310680e+16,
                                      4.87694820e+16, 4.81808411e+16, 4.76760133e+16, 4.73914386e+16,
                                      4.97489258e+16, 4.87227026e+16, 4.64002999e+16, 4.22876103e+16,
                                      3.85647490e+16, 3.51917588e+16, 3.21335550e+16, 2.93550531e+16,
                                      2.68231176e+16, 2.45055878e+16, 2.23742010e+16, 2.04055676e+16,
                                      1.85782470e+16, 1.68785951e+16, 1.52949173e+16, 1.38184422e+16,
                                      1.24365005e+16, 1.11481177e+16, 9.95524276e+15, 8.85582922e+15,
                                      7.85075415e+15, 6.93738621e+15, 6.11250931e+15, 5.37154298e+15,
                                      4.70932199e+15, 4.12029127e+15, 3.59850596e+15, 3.13821608e+15,
                                      2.73337928e+15, 2.37834307e+15, 2.06774729e+15, 1.79662164e+15,
                                      1.70705856e+15, 1.65306733e+15, 1.63659708e+15, 9.69493485e+15,
                                      9.45207176e+15, 9.35568669e+15, 9.33463595e+15, 1.31986151e+16,
                                      1.31109037e+16, 1.26236182e+16, 1.11266771e+16, 9.65361304e+15,
                                      9.39145344e+15, 9.28912349e+15, 9.19410281e+15, 1.02992663e+16,
                                      9.93185306e+15, 9.05863744e+15, 7.71324218e+15, 6.57747714e+15,
                                      5.61206710e+15, 4.77422841e+15, 4.04690608e+15, 3.40992647e+15,
                                      2.87225565e+15, 2.41927505e+15, 2.03821779e+15, 1.71592716e+15,
                                      1.44255999e+15, 1.21324344e+15, 1.02096058e+15, 8.59688571e+14,
                                      7.24437607e+14, 6.07167479e+14, 5.06367600e+14, 4.21258315e+14,
                                      3.49451923e+14]),
                     'ene': np.array([10.69, 11.42761, 12.21612, 13.05903, 13.9601,
                                      14.92335, 15.95306, 17.05382, 18.23053, 19.48844,
                                      20.83314, 22.27063, 23.8073, 25.45001, 27.20606,
                                      29.08327, 31.09002, 33.23523, 35.52846, 37.97993,
                                      40.60054, 43.40198, 46.39671, 49.59809, 53.02035,
                                      56.67876, 60.58959, 64.77028, 66.738, 67.7595,
                                      68.0319, 68.4405, 69.23942, 69.462, 74.01695,
                                      79.12411, 84.58368, 90.41995, 96.65893, 103.3284,
                                      109.564, 110.4581, 111.241, 111.6882, 112.359,
                                      114.036, 118.0797, 126.2272, 134.9368, 144.2475,
                                      154.2005, 164.8404, 176.2144, 188.3732, 201.3709,
                                      215.2655, 230.1188, 245.997, 262.9708, 281.1158,
                                      300.5128, 321.2482, 343.4143, 367.1099, 392.4405,
                                      419.5189, 448.4657, 479.4098, 512.4891, 547.8508,
                                      585.6525, 626.0625, 669.2609, 715.4399, 764.8052,
                                      817.5768, 837.606, 850.4265, 854.462, 858.9735,
                                      867.5405, 871.0281, 871.794, 873.9896, 876.2595,
                                      889.338, 934.2948, 987.938, 998.7612, 1003.06,
                                      1007.092, 1013.141, 1028.262, 1067.676, 1141.345,
                                      1220.098, 1304.285, 1394.281, 1490.486, 1593.329,
                                      1703.269, 1820.795, 1946.43, 2080.733, 2224.304,
                                      2377.781, 2541.848, 2717.235, 2904.724, 3105.15,
                                      3319.406, 3548.445, 3793.288]), },
              '29': {'name': 'Cu',
                     'barns': 1055210000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1.6, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1.6,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Cu.M3', 'excl before': 5, 'excl after': 50, 'onset': 73.6, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 73.6, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 119.8, 'factor': 1.0},
                     'L3': {'filename': 'Cu.L3', 'excl before': 5, 'excl after': 50, 'onset': 931.1, 'factor': 1.0,
                            'XU': 0.11, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 951.0, 'factor': 0.5},
                     'L1': {'filename': 'Cu.L1', 'excl before': 5, 'excl after': 50, 'onset': 1096.1000000000001,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8978.9, 'factor': 1.0},
                     'dat': np.array([1.42062922e+17, 1.39963054e+17, 1.38000364e+17, 1.36174850e+17,
                                      1.34465410e+17, 1.32861491e+17, 1.31341989e+17, 1.29896351e+17,
                                      1.28492922e+17, 1.27142253e+17, 1.25802136e+17, 1.24462020e+17,
                                      1.23111351e+17, 1.21729026e+17, 1.20293940e+17, 1.18806094e+17,
                                      1.15587703e+17, 1.10786498e+17, 1.05995844e+17, 1.01198860e+17,
                                      9.64134825e+16, 9.16428781e+16, 8.68975987e+16, 8.21860861e+16,
                                      7.75210026e+16, 7.29171214e+16, 6.83871049e+16, 6.39457260e+16,
                                      5.96088129e+16, 5.70098307e+16, 5.60559208e+16, 5.58058361e+16,
                                      8.18178178e+16, 7.85762126e+16, 6.83005777e+16, 5.85979217e+16,
                                      5.18720132e+16, 4.66983186e+16, 4.24204972e+16, 3.87367591e+16,
                                      3.57610669e+16, 3.54972644e+16, 3.50688491e+16, 3.48894634e+16,
                                      3.68922520e+16, 3.62580708e+16, 3.49253406e+16, 3.24054991e+16,
                                      3.01251903e+16, 2.80464266e+16, 2.61407173e+16, 2.43816823e+16,
                                      2.27429411e+16, 2.12023345e+16, 1.97398135e+16, 1.83406050e+16,
                                      1.69920466e+16, 1.56899175e+16, 1.44310520e+16, 1.32165052e+16,
                                      1.20420565e+16, 1.09129818e+16, 9.84046638e+15, 8.83073593e+15,
                                      7.88991069e+15, 7.02136734e+15, 6.22637213e+15, 5.50386984e+15,
                                      4.85185558e+15, 4.26684716e+15, 3.74483477e+15, 3.28106997e+15,
                                      2.87080433e+15, 2.47794964e+15, 2.13141868e+15, 1.83469363e+15,
                                      1.66607107e+15, 1.61046150e+15, 1.59611065e+15, 9.83614002e+15,
                                      9.75509989e+15, 9.70444981e+15, 9.35063789e+15, 9.22654520e+15,
                                      1.30128497e+16, 1.23649508e+16, 1.11831156e+16, 9.07227350e+15,
                                      8.91546929e+15, 8.53918140e+15, 8.44336834e+15, 9.29355103e+15,
                                      8.98943951e+15, 8.59605722e+15, 7.36599893e+15, 6.28504180e+15,
                                      5.35635148e+15, 4.56853170e+15, 3.89731261e+15, 3.28951165e+15,
                                      2.77478022e+15, 2.34045578e+15, 1.97398135e+15, 1.66364409e+15,
                                      1.39825877e+15, 1.17571498e+15, 9.89301583e+14, 8.33130503e+14,
                                      6.97915894e+14, 5.81779481e+14, 4.85407152e+14, 4.04810212e+14]),
                     'ene': np.array([10.69, 11.42761, 12.21612, 13.05903, 13.9601,
                                      14.92335, 15.95306, 17.05382, 18.23053, 19.48844,
                                      20.83314, 22.27063, 23.8073, 25.45001, 27.20606,
                                      29.08327, 31.09002, 33.23523, 35.52846, 37.97993,
                                      40.60054, 43.40198, 46.39671, 49.59809, 53.02035,
                                      56.67876, 60.58959, 64.77028, 69.23942, 72.128,
                                      73.232, 73.5264, 74.01695, 75.072, 79.12411,
                                      84.58368, 90.41995, 96.65893, 103.3284, 110.4581,
                                      117.404, 118.0797, 119.201, 119.6802, 120.399,
                                      122.196, 126.2272, 134.9368, 144.2475, 154.2005,
                                      164.8404, 176.2144, 188.3732, 201.3709, 215.2655,
                                      230.1188, 245.997, 262.9708, 281.1158, 300.5128,
                                      321.2482, 343.4143, 367.1099, 392.4405, 419.5189,
                                      448.4657, 479.4098, 512.4891, 547.8508, 585.6525,
                                      626.0625, 669.2609, 715.4399, 764.8052, 817.5768,
                                      873.9896, 912.478, 926.4445, 930.1689, 931.98,
                                      934.2948, 935.7555, 946.245, 950.049, 955.755,
                                      970.02, 998.7612, 1067.676, 1074.178, 1090.619,
                                      1095.004, 1101.58, 1118.022, 1141.345, 1220.098,
                                      1304.285, 1394.281, 1490.486, 1593.329, 1703.269,
                                      1820.795, 1946.43, 2080.733, 2224.304, 2377.781,
                                      2541.848, 2717.235, 2904.724, 3105.15, 3319.406,
                                      3548.445, 3793.288]), },
              '30': {'name': 'Zn',
                     'barns': 1085660000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8.1, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8.1,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Zn.M3', 'excl before': 5, 'excl after': 50, 'onset': 86.6, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 86.6, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 135.9, 'factor': 1.0},
                     'L3': {'filename': 'Zn.L3', 'excl before': 5, 'excl after': 50, 'onset': 1019.7, 'factor': 1.0,
                            'XU': 0.12, 'twin': 'L2', 'shape': 'delayed'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1042.8, 'factor': 0.5},
                     'L1': {'filename': 'Zn.L1', 'excl before': 5, 'excl after': 50, 'onset': 1193.6, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9658.6, 'factor': 1.0},
                     'dat': np.array([5.67528765e+16, 5.69059546e+16, 5.99023762e+16, 6.09076973e+16,
                                      6.20400407e+16, 6.33080916e+16, 6.47183639e+16, 6.62697721e+16,
                                      6.79623160e+16, 6.97894818e+16, 7.17414985e+16, 7.38053381e+16,
                                      7.59625445e+16, 7.81935758e+16, 8.04723762e+16, 8.27674614e+16,
                                      8.50451761e+16, 8.72686078e+16, 8.93943301e+16, 9.13669743e+16,
                                      9.30182631e+16, 9.42841427e+16, 9.51428998e+16, 9.55815064e+16,
                                      9.55967056e+16, 9.51928401e+16, 9.43840234e+16, 9.31941401e+16,
                                      9.16514172e+16, 8.96603168e+16, 8.71470139e+16, 8.42917281e+16,
                                      8.11400571e+16, 7.77408556e+16, 7.75638930e+16, 7.67583333e+16,
                                      7.65444583e+16, 8.75259092e+16, 8.61862048e+16, 8.41093372e+16,
                                      7.84150505e+16, 7.33395900e+16, 6.87689614e+16, 6.45283734e+16,
                                      6.05407442e+16, 5.74943823e+16, 5.67713327e+16, 5.66562528e+16,
                                      5.64369494e+16, 5.84736476e+16, 5.76746018e+16, 5.55738497e+16,
                                      5.18261514e+16, 4.69243965e+16, 4.24145649e+16, 3.82825429e+16,
                                      3.45066174e+16, 3.10618183e+16, 2.79231752e+16, 2.50646324e+16,
                                      2.24612197e+16, 2.00901383e+16, 1.79329319e+16, 1.59711443e+16,
                                      1.41895762e+16, 1.25719428e+16, 1.11041305e+16, 9.77767109e+15,
                                      8.58507358e+15, 7.51819550e+15, 6.56835157e+15, 5.72674793e+15,
                                      4.98372223e+15, 4.33048061e+15, 3.75790352e+15, 3.25784853e+15,
                                      2.82217317e+15, 2.44349496e+15, 2.11486568e+15, 1.98480361e+15,
                                      1.96341611e+15, 1.94235431e+15, 1.92140107e+15, 1.90077353e+15,
                                      1.88036312e+15, 1.86016984e+15, 1.84019370e+15, 1.82043469e+15,
                                      1.80089281e+15, 1.78145949e+15, 1.76235188e+15, 1.74346139e+15,
                                      1.72467948e+15, 1.70611469e+15, 1.68787560e+15, 1.66974508e+15,
                                      1.65172312e+15, 1.63402687e+15, 1.61643917e+15, 1.59906861e+15,
                                      1.58191519e+15, 1.56248187e+15, 1.54283143e+15, 1.52350668e+15,
                                      1.50439906e+15, 1.50396480e+15, 8.61438640e+15, 8.50375765e+15,
                                      8.38889482e+15, 8.27555192e+15, 8.16372894e+15, 8.10694892e+15,
                                      1.15253666e+16, 1.14537130e+16, 1.12995493e+16, 1.11464712e+16,
                                      1.09966501e+16, 1.08480233e+16, 1.07015678e+16, 1.05570664e+16,
                                      1.04146278e+16, 1.02740348e+16, 1.01353961e+16, 9.99860290e+15,
                                      9.86376393e+15, 9.73066201e+15, 9.59940572e+15, 9.46988648e+15,
                                      9.34221287e+15, 9.21616774e+15, 9.09196824e+15, 8.96928866e+15,
                                      8.84845470e+15, 8.72914066e+15, 8.61145512e+15, 8.49539807e+15,
                                      8.38086094e+15, 8.26795230e+15, 8.15656358e+15, 8.04669479e+15,
                                      8.00153133e+15, 9.03019418e+15, 9.00706962e+15, 8.89177253e+15,
                                      8.77799536e+15, 8.66573812e+15, 8.55500080e+15, 8.44567484e+15,
                                      8.33776023e+15, 8.23136555e+15, 8.12627367e+15, 8.02259314e+15,
                                      7.92054110e+15, 7.82000898e+15, 7.72077966e+15, 7.62285312e+15,
                                      7.52633795e+15, 7.43101700e+15, 7.33699885e+15, 7.24417492e+15,
                                      7.15265378e+15, 7.06232687e+15, 6.97319418e+15, 6.88579855e+15,
                                      6.80035711e+15, 6.71610989e+15, 6.63294834e+15, 6.55087244e+15,
                                      6.47031647e+15, 6.39095472e+15, 6.31267864e+15, 6.23537964e+15,
                                      6.15905775e+15, 6.08382151e+15, 6.00956236e+15, 5.93617175e+15,
                                      5.86386679e+15, 5.79232180e+15, 5.72186246e+15, 5.65227166e+15,
                                      5.58354938e+15, 5.51569563e+15, 5.44871041e+15, 5.38259371e+15,
                                      5.31734555e+15, 5.25296591e+15, 5.18934623e+15, 5.12648652e+15,
                                      5.06449533e+15, 5.00326411e+15, 4.94290141e+15, 4.88319011e+15,
                                      4.82423878e+15, 4.76604740e+15, 4.70850742e+15, 4.65118457e+15,
                                      4.59429599e+15, 4.53816737e+15, 4.48269014e+15, 4.42797288e+15,
                                      4.37390701e+15, 4.32049254e+15, 4.26772946e+15, 4.21561778e+15,
                                      4.16394036e+15, 4.11258865e+15, 4.06199689e+15, 4.01194796e+15,
                                      3.96255043e+15, 3.91369573e+15, 3.86549243e+15, 3.81783196e+15,
                                      3.77082288e+15, 3.72446520e+15, 3.67854178e+15, 3.63326976e+15,
                                      3.58854056e+15, 3.54435420e+15, 3.50071067e+15, 3.45760997e+15,
                                      3.41505210e+15, 3.37303705e+15, 3.33145628e+15, 3.29041833e+15,
                                      3.24992321e+15, 3.20997092e+15, 3.17045290e+15, 3.13136914e+15,
                                      3.09282821e+15, 3.05483011e+15, 3.01715771e+15, 2.98002813e+15,
                                      2.94333283e+15, 2.90718035e+15, 2.87135357e+15, 2.83606962e+15,
                                      2.80111137e+15, 2.76669594e+15, 2.73260622e+15, 2.69895076e+15,
                                      2.66572956e+15, 2.63294263e+15, 2.60058996e+15, 2.56856299e+15,
                                      2.53697029e+15, 2.50570328e+15, 2.47487054e+15, 2.44447206e+15,
                                      2.41439927e+15, 2.38465219e+15, 2.35457941e+15, 2.32483232e+15,
                                      2.29541094e+15, 2.26642382e+15, 2.23754526e+15, 2.20888384e+15,
                                      2.18054811e+15, 2.15264665e+15, 2.12507088e+15, 2.09782082e+15,
                                      2.07089645e+15, 2.04440635e+15, 2.01824194e+15, 1.99240323e+15,
                                      1.96689022e+15, 1.94170291e+15, 1.91673273e+15, 1.89219681e+15,
                                      1.86798660e+15, 1.84410208e+15, 1.82054325e+15, 1.79720156e+15,
                                      1.77418557e+15, 1.75149528e+15, 1.72913068e+15, 1.70698322e+15,
                                      1.68516145e+15, 1.66355682e+15, 1.64238645e+15, 1.62132464e+15,
                                      1.60058854e+15, 1.58006956e+15, 1.55965916e+15, 1.53946588e+15,
                                      1.51959830e+15, 1.49994786e+15, 1.48051454e+15, 1.46140693e+15,
                                      1.44251644e+15, 1.42395166e+15, 1.40549544e+15, 1.38736491e+15,
                                      1.36945152e+15, 1.35175527e+15, 1.33438471e+15, 1.31712271e+15,
                                      1.30007785e+15, 1.28325012e+15, 1.26663952e+15, 1.25035462e+15,
                                      1.23417829e+15, 1.21821909e+15, 1.20247702e+15, 1.18695208e+15,
                                      1.17164427e+15, 1.15655360e+15, 1.14168006e+15, 1.12691508e+15,
                                      1.11236724e+15, 1.09803652e+15, 1.08390123e+15, 1.06993964e+15,
                                      1.05616262e+15, 1.04255930e+15, 1.02915140e+15, 1.01590634e+15,
                                      1.00284586e+15, 9.89948214e+14, 9.77224279e+14, 9.64663193e+14,
                                      9.52275812e+14, 9.40051281e+14, 9.27978742e+14, 9.16069051e+14,
                                      9.04322210e+14, 8.92727361e+14, 8.81284505e+14, 8.69548520e+14,
                                      8.57682257e+14, 8.45989698e+14, 8.34449133e+14, 8.23082272e+14,
                                      8.11867405e+14, 8.00804529e+14, 7.89904503e+14, 7.79156469e+14,
                                      7.68549571e+14, 7.58094665e+14, 7.47791751e+14, 7.37629974e+14,
                                      7.27609332e+14, 7.17729826e+14, 7.07980599e+14, 6.98372508e+14,
                                      6.88894696e+14, 6.79558020e+14, 6.70340767e+14, 6.61253793e+14,
                                      6.52297098e+14, 6.43459825e+14, 6.34752832e+14, 6.26165262e+14,
                                      6.17697114e+14, 6.09337532e+14, 6.01108229e+14, 5.92976635e+14,
                                      5.84975321e+14, 5.77071716e+14, 5.69287534e+14, 5.61601061e+14,
                                      5.54023155e+14, 5.46553814e+14, 5.39193039e+14, 5.31929974e+14,
                                      5.24764618e+14, 5.17696971e+14, 5.10727034e+14, 5.03854806e+14,
                                      4.97080288e+14, 4.90392622e+14, 4.83802666e+14, 4.77299562e+14,
                                      4.70883312e+14, 4.64564771e+14, 4.58322226e+14, 4.52177390e+14,
                                      4.46108551e+14, 4.40126564e+14, 4.34231430e+14, 4.28412293e+14,
                                      4.22669151e+14, 4.17012863e+14, 4.11432570e+14, 4.05928274e+14,
                                      4.00499974e+14]),
                     'ene': np.array([8.1405, 8.262, 10.69, 11.42761, 12.21612,
                                      13.05903, 13.9601, 14.92335, 15.95306, 17.05382,
                                      18.23053, 19.48844, 20.83314, 22.27063, 23.8073,
                                      25.45001, 27.20606, 29.08327, 31.09002, 33.23523,
                                      35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                      49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                      69.23942, 74.01695, 79.12411, 84.58368, 84.868,
                                      86.167, 86.5134, 87.033, 88.332, 90.41995,
                                      96.65893, 103.3284, 110.4581, 118.0797, 126.2272,
                                      133.182, 134.9368, 135.2205, 135.7641, 136.5795,
                                      138.618, 144.2475, 154.2005, 164.8404, 176.2144,
                                      188.3732, 201.3709, 215.2655, 230.1188, 245.997,
                                      262.9708, 281.1158, 300.5128, 321.2482, 343.4143,
                                      367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                      512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                      715.4399, 764.8052, 817.5768, 873.9896, 900.,
                                      904.5, 909.0225, 913.56761, 918.13545, 922.72613,
                                      927.33976, 931.97646, 936.63634, 941.31952, 946.02612,
                                      950.75625, 955.51003, 960.28758, 965.08902, 969.91446,
                                      974.76404, 979.63786, 984.53605, 989.45873, 994.40602,
                                      999.37805, 1004.3749, 1009.3968, 1014.4438, 1019.516,
                                      1019.629, 1019.7711, 1024.6136, 1029.7367, 1034.8853,
                                      1040.0598, 1042.7279, 1042.872, 1045.2601, 1050.4864,
                                      1055.7388, 1061.0175, 1066.3226, 1071.6542, 1077.0125,
                                      1082.3975, 1087.8095, 1093.2486, 1098.7148, 1104.2084,
                                      1109.7294, 1115.2781, 1120.8545, 1126.4587, 1132.091,
                                      1137.7515, 1143.4402, 1149.1574, 1154.9032, 1160.6777,
                                      1166.4811, 1172.3135, 1178.1751, 1184.066, 1189.9863,
                                      1192.4542, 1194.7459, 1195.9362, 1201.9159, 1207.9255,
                                      1213.9651, 1220.035, 1226.1351, 1232.2658, 1238.4271,
                                      1244.6193, 1250.8424, 1257.0966, 1263.3821, 1269.699,
                                      1276.0475, 1282.4277, 1288.8399, 1295.284, 1301.7605,
                                      1308.2693, 1314.8106, 1321.3847, 1327.9916, 1334.6316,
                                      1341.3047, 1348.0112, 1354.7513, 1361.525, 1368.3327,
                                      1375.1743, 1382.0502, 1388.9605, 1395.9053, 1402.8848,
                                      1409.8992, 1416.9487, 1424.0335, 1431.1536, 1438.3094,
                                      1445.5009, 1452.7284, 1459.9921, 1467.292, 1474.6285,
                                      1482.0016, 1489.4117, 1496.8587, 1504.343, 1511.8647,
                                      1519.424, 1527.0212, 1534.6563, 1542.3295, 1550.0412,
                                      1557.7914, 1565.5804, 1573.4083, 1581.2753, 1589.1817,
                                      1597.1276, 1605.1132, 1613.1388, 1621.2045, 1629.3105,
                                      1637.4571, 1645.6443, 1653.8726, 1662.1419, 1670.4526,
                                      1678.8049, 1687.1989, 1695.6349, 1704.1131, 1712.6337,
                                      1721.1968, 1729.8028, 1738.4518, 1747.1441, 1755.8798,
                                      1764.6592, 1773.4825, 1782.3499, 1791.2617, 1800.218,
                                      1809.2191, 1818.2652, 1827.3565, 1836.4933, 1845.6757,
                                      1854.9041, 1864.1786, 1873.4995, 1882.867, 1892.2814,
                                      1901.7428, 1911.2515, 1920.8077, 1930.4118, 1940.0638,
                                      1949.7642, 1959.513, 1969.3105, 1979.1571, 1989.0529,
                                      1998.9981, 2008.9931, 2019.0381, 2029.1333, 2039.279,
                                      2049.4754, 2059.7227, 2070.0213, 2080.3714, 2090.7733,
                                      2101.2272, 2111.7333, 2122.292, 2132.9034, 2143.568,
                                      2154.2858, 2165.0572, 2175.8825, 2186.7619, 2197.6957,
                                      2208.6842, 2219.7276, 2230.8263, 2241.9804, 2253.1903,
                                      2264.4562, 2275.7785, 2287.1574, 2298.5932, 2310.0862,
                                      2321.6366, 2333.2448, 2344.911, 2356.6356, 2368.4187,
                                      2380.2608, 2392.1621, 2404.123, 2416.1436, 2428.2243,
                                      2440.3654, 2452.5672, 2464.8301, 2477.1542, 2489.54,
                                      2501.9877, 2514.4976, 2527.0701, 2539.7055, 2552.404,
                                      2565.166, 2577.9919, 2590.8818, 2603.8362, 2616.8554,
                                      2629.9397, 2643.0894, 2656.3048, 2669.5863, 2682.9343,
                                      2696.3489, 2709.8307, 2723.3798, 2736.9967, 2750.6817,
                                      2764.4351, 2778.2573, 2792.1486, 2806.1093, 2820.1399,
                                      2834.2406, 2848.4118, 2862.6539, 2876.9671, 2891.352,
                                      2905.8087, 2920.3378, 2934.9394, 2949.6141, 2964.3622,
                                      2979.184, 2994.0799, 3009.0503, 3024.0956, 3039.2161,
                                      3054.4122, 3069.6842, 3085.0326, 3100.4578, 3115.9601,
                                      3131.5399, 3147.1976, 3162.9336, 3178.7482, 3194.642,
                                      3210.6152, 3226.6683, 3242.8016, 3259.0156, 3275.3107,
                                      3291.6873, 3308.1457, 3324.6864, 3341.3099, 3358.0164,
                                      3374.8065, 3391.6805, 3408.6389, 3425.6821, 3442.8105,
                                      3460.0246, 3477.3247, 3494.7113, 3512.1849, 3529.7458,
                                      3547.3945, 3565.1315, 3582.9572, 3600.8719, 3618.8763,
                                      3636.9707, 3655.1555, 3673.4313, 3691.7985, 3710.2575,
                                      3728.8088, 3747.4528, 3766.1901, 3785.021, 3803.9461,
                                      3822.9659, 3842.0807, 3861.2911, 3880.5975, 3900.0005,
                                      3919.5005, 3939.098, 3958.7935, 3978.5875, 3998.4804]), },
              '31': {'name': 'Ga',
                     'barns': 1157730000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 17.4, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 17.4,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 102.9, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 106.80000000000001,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 158.1, 'factor': 1.0},
                     'L3': {'filename': 'Ga.L3', 'excl before': 5, 'excl after': 50, 'onset': 1115.3999999999999,
                            'factor': 1.0, 'XU': 0.12, 'twin': 'L2', 'shape': 'delayed'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1142.3000000000002,
                            'factor': 0.5},
                     'L1': {'filename': 'Ga.L1', 'excl before': 5, 'excl after': 50, 'onset': 1297.7, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 10367.1, 'factor': 1.0},
                     'dat': np.array([3.89668763e+16, 3.85674595e+16, 3.78554555e+16, 3.61860089e+16,
                                      3.54786358e+16, 3.58247971e+16, 3.70253631e+16, 3.89541413e+16,
                                      4.15266174e+16, 4.46710120e+16, 4.83213347e+16, 5.24034907e+16,
                                      5.68318080e+16, 6.15032485e+16, 6.62997239e+16, 7.10857797e+16,
                                      7.57190152e+16, 8.00523986e+16, 8.39412136e+16, 8.72511637e+16,
                                      8.98664758e+16, 9.16956892e+16, 9.26762865e+16, 9.26890215e+16,
                                      9.16366450e+16, 8.96001979e+16, 8.66896647e+16, 8.30393420e+16,
                                      8.04043485e+16, 7.94087007e+16, 7.91412651e+16, 8.20332746e+16,
                                      8.19788613e+16, 8.11765544e+16, 8.09866867e+16, 8.01427015e+16,
                                      7.98660040e+16, 8.09646898e+16, 7.99308369e+16, 7.89479242e+16,
                                      7.40738809e+16, 6.90886955e+16, 6.41092988e+16, 5.92202050e+16,
                                      5.44897202e+16, 5.41586094e+16, 5.31120215e+16, 5.28376395e+16,
                                      5.46807456e+16, 5.36769937e+16, 5.22113075e+16, 4.79196024e+16,
                                      4.38721784e+16, 4.00713508e+16, 3.65205928e+16, 3.32152737e+16,
                                      3.01507624e+16, 2.73143239e+16, 2.46955386e+16, 2.22816716e+16,
                                      2.00634609e+16, 1.77665246e+16, 1.56177777e+16, 1.37005768e+16,
                                      1.19929251e+16, 1.04747937e+16, 9.12742755e+15, 7.93658647e+15,
                                      6.88814618e+15, 5.96832970e+15, 5.16428621e+15, 4.46316492e+15,
                                      3.85350430e+15, 3.32465324e+15, 2.86700257e+15, 2.47175355e+15,
                                      2.31569155e+15, 2.29010571e+15, 2.26486720e+15, 2.23986023e+15,
                                      2.21520058e+15, 2.19077248e+15, 2.16657592e+15, 2.14272668e+15,
                                      2.11910899e+15, 2.09572285e+15, 2.07256825e+15, 2.04976096e+15,
                                      2.02718523e+15, 2.00484104e+15, 1.98272840e+15, 1.96084730e+15,
                                      1.93931352e+15, 1.91789552e+15, 1.89682483e+15, 1.87586992e+15,
                                      1.85526232e+15, 1.83488628e+15, 1.81173168e+15, 1.78857708e+15,
                                      1.76576980e+15, 1.74319406e+15, 1.72096564e+15, 1.69896878e+15,
                                      1.67731922e+15, 1.65601699e+15, 1.63483053e+15, 1.61410717e+15,
                                      1.59361534e+15, 1.57335507e+15, 1.55332634e+15, 1.53364493e+15,
                                      1.51431084e+15, 1.49509252e+15, 1.47622152e+15, 1.45746630e+15,
                                      1.43905839e+15, 1.42088203e+15, 1.40305299e+15, 1.38533972e+15,
                                      1.38522394e+15, 7.61520062e+15, 7.51876171e+15, 7.42000734e+15,
                                      7.32252648e+15, 7.22631911e+15, 7.15176130e+15, 1.01483139e+16,
                                      1.01235384e+16, 9.99074681e+15, 9.85980754e+15, 9.73048910e+15,
                                      9.60290726e+15, 9.47706201e+15, 9.35283758e+15, 9.23023397e+15,
                                      9.10925119e+15, 8.98988922e+15, 8.87203231e+15, 8.75579622e+15,
                                      8.64106517e+15, 8.52783918e+15, 8.41623401e+15, 8.30590234e+15,
                                      8.19719149e+15, 8.08986992e+15, 7.98393763e+15, 7.87939461e+15,
                                      7.77624086e+15, 7.67436062e+15, 7.57398543e+15, 7.47476797e+15,
                                      7.37705556e+15, 7.28050088e+15, 7.26267184e+15, 8.20564292e+15,
                                      8.16176495e+15, 8.06243172e+15, 7.96448776e+15, 7.86770153e+15,
                                      7.77218881e+15, 7.67783381e+15, 7.58475232e+15, 7.49271279e+15,
                                      7.40206253e+15, 7.31245423e+15, 7.22296170e+15, 7.13451112e+15,
                                      7.04710251e+15, 6.96073585e+15, 6.87552692e+15, 6.79124418e+15,
                                      6.70800339e+15, 6.62568879e+15, 6.54453192e+15, 6.46418546e+15,
                                      6.38488095e+15, 6.30661840e+15, 6.22928204e+15, 6.15298763e+15,
                                      6.07761941e+15, 6.00306160e+15, 5.92954574e+15, 5.85684030e+15,
                                      5.78506104e+15, 5.71420796e+15, 5.64416530e+15, 5.57493304e+15,
                                      5.50662697e+15, 5.43913131e+15, 5.37244606e+15, 5.30657123e+15,
                                      5.24162258e+15, 5.17736856e+15, 5.11392496e+15, 5.05117599e+15,
                                      4.98935321e+15, 4.92810929e+15, 4.86779156e+15, 4.80816846e+15,
                                      4.74924001e+15, 4.69112196e+15, 4.63358278e+15, 4.57685401e+15,
                                      4.52081988e+15, 4.46548038e+15, 4.41083553e+15, 4.35688531e+15,
                                      4.30362973e+15, 4.25060570e+15, 4.19816053e+15, 4.14641000e+15,
                                      4.09535410e+15, 4.04487707e+15, 3.99509468e+15, 3.94589116e+15,
                                      3.89726650e+15, 3.84933648e+15, 3.80186955e+15, 3.75509726e+15,
                                      3.70878806e+15, 3.66317349e+15, 3.61813780e+15, 3.57356519e+15,
                                      3.52957145e+15, 3.48615658e+15, 3.44320479e+15, 3.40083188e+15,
                                      3.35892205e+15, 3.31759109e+15, 3.27683899e+15, 3.23654999e+15,
                                      3.19672408e+15, 3.15736126e+15, 3.11857730e+15, 3.08014066e+15,
                                      3.04205135e+15, 3.00442512e+15, 2.96726199e+15, 2.93056195e+15,
                                      2.89432500e+15, 2.85843537e+15, 2.82312460e+15, 2.78816116e+15,
                                      2.75354503e+15, 2.71939200e+15, 2.68570205e+15, 2.65235943e+15,
                                      2.61947990e+15, 2.58694768e+15, 2.55487856e+15, 2.52315676e+15,
                                      2.49189805e+15, 2.46098666e+15, 2.43042259e+15, 2.40032161e+15,
                                      2.37056795e+15, 2.34116161e+15, 2.31221836e+15, 2.28350665e+15,
                                      2.25525804e+15, 2.22724097e+15, 2.19968700e+15, 2.17248034e+15,
                                      2.14550524e+15, 2.11829858e+15, 2.09155502e+15, 2.06504300e+15,
                                      2.03887830e+15, 2.01294515e+15, 1.98712777e+15, 1.96165771e+15,
                                      1.93653497e+15, 1.91175955e+15, 1.88733145e+15, 1.86313489e+15,
                                      1.83928565e+15, 1.81566796e+15, 1.79239759e+15, 1.76947453e+15,
                                      1.74678302e+15, 1.72443884e+15, 1.70244196e+15, 1.68056087e+15,
                                      1.65914286e+15, 1.63784063e+15, 1.61688572e+15, 1.59627812e+15,
                                      1.57578630e+15, 1.55564180e+15, 1.53584462e+15, 1.51616321e+15,
                                      1.49682912e+15, 1.47761080e+15, 1.45873980e+15, 1.43998457e+15,
                                      1.42146089e+15, 1.40305299e+15, 1.38499240e+15, 1.36716336e+15,
                                      1.34945009e+15, 1.33208414e+15, 1.31494973e+15, 1.29793110e+15,
                                      1.28125979e+15, 1.26470425e+15, 1.24838026e+15, 1.23240358e+15,
                                      1.21642691e+15, 1.20079756e+15, 1.18539975e+15, 1.17011771e+15,
                                      1.15507880e+15, 1.14022512e+15, 1.12556826e+15, 1.11110821e+15,
                                      1.09683340e+15, 1.08275541e+15, 1.06885107e+15, 1.05514354e+15,
                                      1.04160968e+15, 1.02824948e+15, 1.01503978e+15, 1.00200374e+15,
                                      9.88620379e+14, 9.75098092e+14, 9.61761043e+14, 9.48620807e+14,
                                      9.35654231e+14, 9.22872892e+14, 9.10276790e+14, 8.97842770e+14,
                                      8.85593986e+14, 8.73518862e+14, 8.61605821e+14, 8.49854861e+14,
                                      8.38277561e+14, 8.26862343e+14, 8.15597630e+14, 8.04495000e+14,
                                      7.93542874e+14, 7.82752830e+14, 7.72113292e+14, 7.61612680e+14,
                                      7.51262574e+14, 7.41062973e+14, 7.31002299e+14, 7.21080553e+14,
                                      7.11297735e+14, 7.01642266e+14, 6.92137303e+14, 6.82748113e+14,
                                      6.73497850e+14, 6.64374938e+14, 6.55390953e+14, 6.46511164e+14,
                                      6.37770302e+14, 6.29145214e+14, 6.20635898e+14, 6.12253933e+14,
                                      6.03976164e+14, 5.95825744e+14, 5.87779521e+14, 5.79849070e+14,
                                      5.72022816e+14, 5.64312334e+14, 5.56706048e+14, 5.49203957e+14,
                                      5.41806063e+14, 5.34512364e+14, 5.27322860e+14, 5.20225976e+14,
                                      5.13233286e+14, 5.06333216e+14, 4.99525763e+14, 4.92822506e+14,
                                      4.86200291e+14, 4.79670694e+14, 4.73233715e+14, 4.66889354e+14,
                                      4.60626035e+14, 4.54455334e+14]),
                     'ene': np.array([17.487, 17.748, 18.23053, 19.48844, 20.83314,
                                      22.27063, 23.8073, 25.45001, 27.20606, 29.08327,
                                      31.09002, 33.23523, 35.52846, 37.97993, 40.60054,
                                      43.40198, 46.39671, 49.59809, 53.02035, 56.67876,
                                      60.58959, 64.77028, 69.23942, 74.01695, 79.12411,
                                      84.58368, 90.41995, 96.65893, 100.842, 102.3855,
                                      102.7971, 103.3284, 103.4145, 104.664, 104.958,
                                      106.266, 106.6932, 107.334, 108.936, 110.4581,
                                      118.0797, 126.2272, 134.9368, 144.2475, 154.2005,
                                      154.938, 157.3095, 157.9419, 158.8905, 161.262,
                                      164.8404, 176.2144, 188.3732, 201.3709, 215.2655,
                                      230.1188, 245.997, 262.9708, 281.1158, 300.5128,
                                      321.2482, 343.4143, 367.1099, 392.4405, 419.5189,
                                      448.4657, 479.4098, 512.4891, 547.8508, 585.6525,
                                      626.0625, 669.2609, 715.4399, 764.8052, 817.5768,
                                      873.9896, 900., 904.5, 909.0225, 913.56761,
                                      918.13545, 922.72613, 927.33976, 931.97646, 936.63634,
                                      941.31952, 946.02612, 950.75625, 955.51003, 960.28758,
                                      965.08902, 969.91446, 974.76404, 979.63786, 984.53605,
                                      989.45873, 994.40602, 999.37805, 1004.3749, 1009.3968,
                                      1014.4438, 1019.516, 1024.6136, 1029.7367, 1034.8853,
                                      1040.0598, 1045.2601, 1050.4864, 1055.7388, 1061.0175,
                                      1066.3226, 1071.6542, 1077.0125, 1082.3975, 1087.8095,
                                      1093.2486, 1098.7148, 1104.2084, 1109.7294, 1115.2781,
                                      1115.315, 1115.485, 1120.8545, 1126.4587, 1132.091,
                                      1137.7515, 1142.213, 1142.3871, 1143.4402, 1149.1574,
                                      1154.9032, 1160.6777, 1166.4811, 1172.3135, 1178.1751,
                                      1184.066, 1189.9863, 1195.9362, 1201.9159, 1207.9255,
                                      1213.9651, 1220.035, 1226.1351, 1232.2658, 1238.4271,
                                      1244.6193, 1250.8424, 1257.0966, 1263.3821, 1269.699,
                                      1276.0475, 1282.4277, 1288.8399, 1295.284, 1296.4841,
                                      1298.916, 1301.7605, 1308.2693, 1314.8106, 1321.3847,
                                      1327.9916, 1334.6316, 1341.3047, 1348.0112, 1354.7513,
                                      1361.525, 1368.3327, 1375.1743, 1382.0502, 1388.9605,
                                      1395.9053, 1402.8848, 1409.8992, 1416.9487, 1424.0335,
                                      1431.1536, 1438.3094, 1445.5009, 1452.7284, 1459.9921,
                                      1467.292, 1474.6285, 1482.0016, 1489.4117, 1496.8587,
                                      1504.343, 1511.8647, 1519.424, 1527.0212, 1534.6563,
                                      1542.3295, 1550.0412, 1557.7914, 1565.5804, 1573.4083,
                                      1581.2753, 1589.1817, 1597.1276, 1605.1132, 1613.1388,
                                      1621.2045, 1629.3105, 1637.4571, 1645.6443, 1653.8726,
                                      1662.1419, 1670.4526, 1678.8049, 1687.1989, 1695.6349,
                                      1704.1131, 1712.6337, 1721.1968, 1729.8028, 1738.4518,
                                      1747.1441, 1755.8798, 1764.6592, 1773.4825, 1782.3499,
                                      1791.2617, 1800.218, 1809.2191, 1818.2652, 1827.3565,
                                      1836.4933, 1845.6757, 1854.9041, 1864.1786, 1873.4995,
                                      1882.867, 1892.2814, 1901.7428, 1911.2515, 1920.8077,
                                      1930.4118, 1940.0638, 1949.7642, 1959.513, 1969.3105,
                                      1979.1571, 1989.0529, 1998.9981, 2008.9931, 2019.0381,
                                      2029.1333, 2039.279, 2049.4754, 2059.7227, 2070.0213,
                                      2080.3714, 2090.7733, 2101.2272, 2111.7333, 2122.292,
                                      2132.9034, 2143.568, 2154.2858, 2165.0572, 2175.8825,
                                      2186.7619, 2197.6957, 2208.6842, 2219.7276, 2230.8263,
                                      2241.9804, 2253.1903, 2264.4562, 2275.7785, 2287.1574,
                                      2298.5932, 2310.0862, 2321.6366, 2333.2448, 2344.911,
                                      2356.6356, 2368.4187, 2380.2608, 2392.1621, 2404.123,
                                      2416.1436, 2428.2243, 2440.3654, 2452.5672, 2464.8301,
                                      2477.1542, 2489.54, 2501.9877, 2514.4976, 2527.0701,
                                      2539.7055, 2552.404, 2565.166, 2577.9919, 2590.8818,
                                      2603.8362, 2616.8554, 2629.9397, 2643.0894, 2656.3048,
                                      2669.5863, 2682.9343, 2696.3489, 2709.8307, 2723.3798,
                                      2736.9967, 2750.6817, 2764.4351, 2778.2573, 2792.1486,
                                      2806.1093, 2820.1399, 2834.2406, 2848.4118, 2862.6539,
                                      2876.9671, 2891.352, 2905.8087, 2920.3378, 2934.9394,
                                      2949.6141, 2964.3622, 2979.184, 2994.0799, 3009.0503,
                                      3024.0956, 3039.2161, 3054.4122, 3069.6842, 3085.0326,
                                      3100.4578, 3115.9601, 3131.5399, 3147.1976, 3162.9336,
                                      3178.7482, 3194.642, 3210.6152, 3226.6683, 3242.8016,
                                      3259.0156, 3275.3107, 3291.6873, 3308.1457, 3324.6864,
                                      3341.3099, 3358.0164, 3374.8065, 3391.6805, 3408.6389,
                                      3425.6821, 3442.8105, 3460.0246, 3477.3247, 3494.7113,
                                      3512.1849, 3529.7458, 3547.3945, 3565.1315, 3582.9572,
                                      3600.8719, 3618.8763, 3636.9707, 3655.1555, 3673.4313,
                                      3691.7985, 3710.2575, 3728.8088, 3747.4528, 3766.1901,
                                      3785.021, 3803.9461, 3822.9659, 3842.0807, 3861.2911,
                                      3880.5975, 3900.0005, 3919.5005, 3939.098, 3958.7935,
                                      3978.5875, 3998.4804]), },
              '32': {'name': 'Ge',
                     'barns': 1205390000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 28.7, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 28.7,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 120.80000000000001,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 127.90000000000002,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 180.0, 'factor': 1.0},
                     'L3': {'filename': 'Ge.L3', 'excl before': 5, 'excl after': 50, 'onset': 1216.6999999999998,
                            'factor': 1.0, 'XU': 0.12, 'twin': 'L2', 'shape': 'delayed'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1247.8, 'factor': 0.5},
                     'L1': {'filename': 'Ge.L1', 'excl before': 5, 'excl after': 50, 'onset': 1414.3, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 11103.1, 'factor': 1.0},
                     'dat': np.array([2.08411931e+16, 2.10449040e+16, 2.12076317e+16, 2.27637902e+16,
                                      2.47394244e+16, 2.72442248e+16, 3.02673429e+16, 3.37786440e+16,
                                      3.77335286e+16, 4.20669056e+16, 4.66859601e+16, 5.14749746e+16,
                                      5.62941238e+16, 6.09879124e+16, 6.53899967e+16, 6.93388544e+16,
                                      7.26814008e+16, 7.52910702e+16, 7.70702258e+16, 7.79573929e+16,
                                      7.79320797e+16, 7.70123671e+16, 7.52524977e+16, 7.27211787e+16,
                                      7.26078720e+16, 7.19135674e+16, 7.17231158e+16, 7.37083931e+16,
                                      7.30406070e+16, 7.22293796e+16, 7.18834326e+16, 7.14760108e+16,
                                      7.12722999e+16, 7.19449075e+16, 7.11963604e+16, 6.94063562e+16,
                                      6.55587513e+16, 6.14025666e+16, 5.70691896e+16, 5.26743376e+16,
                                      5.26044250e+16, 5.16063621e+16, 5.13423817e+16, 5.30865810e+16,
                                      5.21138313e+16, 5.04395446e+16, 4.61724640e+16, 4.20596733e+16,
                                      3.81409504e+16, 3.44464300e+16, 3.09953985e+16, 2.77962934e+16,
                                      2.48503202e+16, 2.21550682e+16, 1.97020996e+16, 1.74781550e+16,
                                      1.54711806e+16, 1.36667118e+16, 1.20496811e+16, 1.06044185e+16,
                                      9.31525392e+15, 8.14325322e+15, 7.04273215e+15, 6.08046932e+15,
                                      5.24224111e+15, 4.51466771e+15, 3.88473089e+15, 3.34073838e+15,
                                      2.87208275e+15, 2.68741700e+15, 2.65728226e+15, 2.62738858e+15,
                                      2.59785653e+15, 2.56868609e+15, 2.53987727e+15, 2.51130953e+15,
                                      2.48310340e+15, 2.45525889e+15, 2.42765546e+15, 2.40041365e+15,
                                      2.37353345e+15, 2.34689433e+15, 2.32049629e+15, 2.29445986e+15,
                                      2.26878506e+15, 2.24335133e+15, 2.21815868e+15, 2.19332764e+15,
                                      2.16873769e+15, 2.14438881e+15, 2.12040155e+15, 2.09340081e+15,
                                      2.06615900e+15, 2.03939934e+15, 2.01288076e+15, 1.98684434e+15,
                                      1.96116953e+15, 1.93573580e+15, 1.91078423e+15, 1.88607373e+15,
                                      1.86172486e+15, 1.83773759e+15, 1.81399141e+15, 1.79060684e+15,
                                      1.76758390e+15, 1.74492256e+15, 1.72250231e+15, 1.70032313e+15,
                                      1.67850558e+15, 1.65704963e+15, 1.63571423e+15, 1.61486098e+15,
                                      1.59412828e+15, 1.57375718e+15, 1.55374771e+15, 1.53385878e+15,
                                      1.51433146e+15, 1.49504522e+15, 1.47600006e+15, 1.45719597e+15,
                                      1.43863296e+15, 1.42031104e+15, 1.40235073e+15, 1.38451095e+15,
                                      1.36691226e+15, 1.34967518e+15, 1.33255864e+15, 1.31568318e+15,
                                      1.29904880e+15, 1.28265550e+15, 1.27554370e+15, 6.83781585e+15,
                                      6.79032349e+15, 6.70208894e+15, 6.61493924e+15, 6.52887440e+15,
                                      6.44401494e+15, 6.40242898e+15, 9.07598400e+15, 9.02029499e+15,
                                      8.90325162e+15, 8.78777526e+15, 8.67386590e+15, 8.56128248e+15,
                                      8.45026606e+15, 8.34069610e+15, 8.23257262e+15, 8.12577507e+15,
                                      8.02054452e+15, 7.91651936e+15, 7.81394068e+15, 7.71268792e+15,
                                      7.61264054e+15, 7.51403964e+15, 7.41664413e+15, 7.32057455e+15,
                                      7.22583089e+15, 7.13217209e+15, 7.03983922e+15, 6.94859119e+15,
                                      6.85866910e+15, 6.76983186e+15, 6.68220000e+15, 6.59565300e+15,
                                      6.55780376e+15, 7.44617619e+15, 7.42857749e+15, 7.33781162e+15,
                                      7.24801007e+15, 7.15941390e+15, 7.07202313e+15, 6.98559667e+15,
                                      6.90037559e+15, 6.81611883e+15, 6.73294692e+15, 6.65085986e+15,
                                      6.56961658e+15, 6.48933760e+15, 6.41014348e+15, 6.33191367e+15,
                                      6.25452763e+15, 6.17822644e+15, 6.10288957e+15, 6.02839647e+15,
                                      5.95486768e+15, 5.88230320e+15, 5.81058250e+15, 5.73982610e+15,
                                      5.66991348e+15, 5.60048302e+15, 5.53189633e+15, 5.46415341e+15,
                                      5.39737480e+15, 5.33131943e+15, 5.26586675e+15, 5.20125785e+15,
                                      5.13737218e+15, 5.07433028e+15, 5.01201162e+15, 4.95053673e+15,
                                      4.88978507e+15, 4.82975665e+15, 4.77057200e+15, 4.71199005e+15,
                                      4.65425187e+15, 4.59711638e+15, 4.54070413e+15, 4.48501511e+15,
                                      4.43004933e+15, 4.37568624e+15, 4.32204638e+15, 4.26900922e+15,
                                      4.21669530e+15, 4.16498407e+15, 4.11399607e+15, 4.06349023e+15,
                                      4.01370762e+15, 3.96452771e+15, 3.91595049e+15, 3.86761435e+15,
                                      3.81988091e+15, 3.77262962e+15, 3.72598103e+15, 3.67993513e+15,
                                      3.63437139e+15, 3.58953088e+15, 3.54505199e+15, 3.50129633e+15,
                                      3.45802283e+15, 3.41523149e+15, 3.37292230e+15, 3.33121580e+15,
                                      3.29011200e+15, 3.24936982e+15, 3.20923034e+15, 3.16945247e+15,
                                      3.13027729e+15, 3.09158427e+15, 3.05337341e+15, 3.01552416e+15,
                                      2.97827761e+15, 2.94139268e+15, 2.90498990e+15, 2.86906928e+15,
                                      2.83363081e+15, 2.79855396e+15, 2.76395927e+15, 2.72972619e+15,
                                      2.69597527e+15, 2.66270651e+15, 2.62967882e+15, 2.59725383e+15,
                                      2.56506992e+15, 2.53336816e+15, 2.50202802e+15, 2.47104950e+15,
                                      2.44055313e+15, 2.41029784e+15, 2.38052471e+15, 2.35111320e+15,
                                      2.32206330e+15, 2.29325448e+15, 2.26468673e+15, 2.23648061e+15,
                                      2.20875664e+15, 2.18127374e+15, 2.15415247e+15, 2.12727227e+15,
                                      2.10087423e+15, 2.07471727e+15, 2.04892192e+15, 2.02348819e+15,
                                      1.99829554e+15, 1.97346451e+15, 1.94887455e+15, 1.92428460e+15,
                                      1.89981518e+15, 1.87570738e+15, 1.85184066e+15, 1.82833555e+15,
                                      1.80507152e+15, 1.78192804e+15, 1.75902563e+15, 1.73648483e+15,
                                      1.71418512e+15, 1.69224702e+15, 1.67055000e+15, 1.64921460e+15,
                                      1.62799973e+15, 1.60714649e+15, 1.58665486e+15, 1.56628377e+15,
                                      1.54627429e+15, 1.52638536e+15, 1.50685804e+15, 1.48757180e+15,
                                      1.46852664e+15, 1.44984309e+15, 1.43128009e+15, 1.41295816e+15,
                                      1.39487731e+15, 1.37703754e+15, 1.35943884e+15, 1.34208123e+15,
                                      1.32496469e+15, 1.30796869e+15, 1.29121377e+15, 1.27457939e+15,
                                      1.25818608e+15, 1.24191332e+15, 1.22600217e+15, 1.21021156e+15,
                                      1.19467408e+15, 1.17931741e+15, 1.16416566e+15, 1.14921883e+15,
                                      1.13446485e+15, 1.11932515e+15, 1.10401670e+15, 1.08891316e+15,
                                      1.07402660e+15, 1.05934495e+15, 1.04486821e+15, 1.03059640e+15,
                                      1.01652949e+15, 1.00265546e+15, 9.88974279e+14, 9.75498019e+14,
                                      9.62190514e+14, 9.49075870e+14, 9.36154090e+14, 9.23401063e+14,
                                      9.10828846e+14, 8.98437436e+14, 8.86214782e+14, 8.74160882e+14,
                                      8.62287790e+14, 8.50571400e+14, 8.39011710e+14, 8.27620774e+14,
                                      8.16386539e+14, 8.05296951e+14, 7.94339956e+14, 7.83551716e+14,
                                      7.72908122e+14, 7.62409175e+14, 7.52054875e+14, 7.41857276e+14,
                                      7.31792269e+14, 7.21859855e+14, 7.12084142e+14, 7.02428969e+14,
                                      6.92918442e+14, 6.83528453e+14, 6.74283112e+14, 6.65158310e+14,
                                      6.56154046e+14, 6.47282376e+14, 6.38531245e+14, 6.29912706e+14,
                                      6.21402653e+14, 6.13013138e+14, 6.04732109e+14, 5.96583673e+14,
                                      5.88531668e+14, 5.80600201e+14, 5.72777220e+14, 5.65062724e+14,
                                      5.57444659e+14, 5.49947134e+14, 5.42546039e+14, 5.35241376e+14,
                                      5.28045197e+14, 5.20945450e+14, 5.13954188e+14]),
                     'ene': np.array([28.8435, 29.08327, 29.274, 31.09002, 33.23523,
                                      35.52846, 37.97993, 40.60054, 43.40198, 46.39671,
                                      49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                      69.23942, 74.01695, 79.12411, 84.58368, 90.41995,
                                      96.65893, 103.3284, 110.4581, 118.0797, 118.384,
                                      120.196, 120.6792, 121.404, 123.216, 125.342,
                                      126.2272, 127.2605, 127.7721, 128.5395, 130.458,
                                      134.9368, 144.2475, 154.2005, 164.8404, 176.2144,
                                      176.4, 179.1, 179.82, 180.9, 183.6,
                                      188.3732, 201.3709, 215.2655, 230.1188, 245.997,
                                      262.9708, 281.1158, 300.5128, 321.2482, 343.4143,
                                      367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                      512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                      715.4399, 764.8052, 817.5768, 873.9896, 900.,
                                      904.5, 909.0225, 913.56761, 918.13545, 922.72613,
                                      927.33976, 931.97646, 936.63634, 941.31952, 946.02612,
                                      950.75625, 955.51003, 960.28758, 965.08902, 969.91446,
                                      974.76404, 979.63786, 984.53605, 989.45873, 994.40602,
                                      999.37805, 1004.3749, 1009.3968, 1014.4438, 1019.516,
                                      1024.6136, 1029.7367, 1034.8853, 1040.0598, 1045.2601,
                                      1050.4864, 1055.7388, 1061.0175, 1066.3226, 1071.6542,
                                      1077.0125, 1082.3975, 1087.8095, 1093.2486, 1098.7148,
                                      1104.2084, 1109.7294, 1115.2781, 1120.8545, 1126.4587,
                                      1132.091, 1137.7515, 1143.4402, 1149.1574, 1154.9032,
                                      1160.6777, 1166.4811, 1172.3135, 1178.1751, 1184.066,
                                      1189.9863, 1195.9362, 1201.9159, 1207.9255, 1213.9651,
                                      1216.5985, 1216.8014, 1220.035, 1226.1351, 1232.2658,
                                      1238.4271, 1244.6193, 1247.6951, 1247.9049, 1250.8424,
                                      1257.0966, 1263.3821, 1269.699, 1276.0475, 1282.4277,
                                      1288.8399, 1295.284, 1301.7605, 1308.2693, 1314.8106,
                                      1321.3847, 1327.9916, 1334.6316, 1341.3047, 1348.0112,
                                      1354.7513, 1361.525, 1368.3327, 1375.1743, 1382.0502,
                                      1388.9605, 1395.9053, 1402.8848, 1409.8992, 1413.0073,
                                      1415.5926, 1416.9487, 1424.0335, 1431.1536, 1438.3094,
                                      1445.5009, 1452.7284, 1459.9921, 1467.292, 1474.6285,
                                      1482.0016, 1489.4117, 1496.8587, 1504.343, 1511.8647,
                                      1519.424, 1527.0212, 1534.6563, 1542.3295, 1550.0412,
                                      1557.7914, 1565.5804, 1573.4083, 1581.2753, 1589.1817,
                                      1597.1276, 1605.1132, 1613.1388, 1621.2045, 1629.3105,
                                      1637.4571, 1645.6443, 1653.8726, 1662.1419, 1670.4526,
                                      1678.8049, 1687.1989, 1695.6349, 1704.1131, 1712.6337,
                                      1721.1968, 1729.8028, 1738.4518, 1747.1441, 1755.8798,
                                      1764.6592, 1773.4825, 1782.3499, 1791.2617, 1800.218,
                                      1809.2191, 1818.2652, 1827.3565, 1836.4933, 1845.6757,
                                      1854.9041, 1864.1786, 1873.4995, 1882.867, 1892.2814,
                                      1901.7428, 1911.2515, 1920.8077, 1930.4118, 1940.0638,
                                      1949.7642, 1959.513, 1969.3105, 1979.1571, 1989.0529,
                                      1998.9981, 2008.9931, 2019.0381, 2029.1333, 2039.279,
                                      2049.4754, 2059.7227, 2070.0213, 2080.3714, 2090.7733,
                                      2101.2272, 2111.7333, 2122.292, 2132.9034, 2143.568,
                                      2154.2858, 2165.0572, 2175.8825, 2186.7619, 2197.6957,
                                      2208.6842, 2219.7276, 2230.8263, 2241.9804, 2253.1903,
                                      2264.4562, 2275.7785, 2287.1574, 2298.5932, 2310.0862,
                                      2321.6366, 2333.2448, 2344.911, 2356.6356, 2368.4187,
                                      2380.2608, 2392.1621, 2404.123, 2416.1436, 2428.2243,
                                      2440.3654, 2452.5672, 2464.8301, 2477.1542, 2489.54,
                                      2501.9877, 2514.4976, 2527.0701, 2539.7055, 2552.404,
                                      2565.166, 2577.9919, 2590.8818, 2603.8362, 2616.8554,
                                      2629.9397, 2643.0894, 2656.3048, 2669.5863, 2682.9343,
                                      2696.3489, 2709.8307, 2723.3798, 2736.9967, 2750.6817,
                                      2764.4351, 2778.2573, 2792.1486, 2806.1093, 2820.1399,
                                      2834.2406, 2848.4118, 2862.6539, 2876.9671, 2891.352,
                                      2905.8087, 2920.3378, 2934.9394, 2949.6141, 2964.3622,
                                      2979.184, 2994.0799, 3009.0503, 3024.0956, 3039.2161,
                                      3054.4122, 3069.6842, 3085.0326, 3100.4578, 3115.9601,
                                      3131.5399, 3147.1976, 3162.9336, 3178.7482, 3194.642,
                                      3210.6152, 3226.6683, 3242.8016, 3259.0156, 3275.3107,
                                      3291.6873, 3308.1457, 3324.6864, 3341.3099, 3358.0164,
                                      3374.8065, 3391.6805, 3408.6389, 3425.6821, 3442.8105,
                                      3460.0246, 3477.3247, 3494.7113, 3512.1849, 3529.7458,
                                      3547.3945, 3565.1315, 3582.9572, 3600.8719, 3618.8763,
                                      3636.9707, 3655.1555, 3673.4313, 3691.7985, 3710.2575,
                                      3728.8088, 3747.4528, 3766.1901, 3785.021, 3803.9461,
                                      3822.9659, 3842.0807, 3861.2911, 3880.5975, 3900.0005,
                                      3919.5005, 3939.098, 3958.7935, 3978.5875, 3998.4804]), },
              '33': {'name': 'As',
                     'barns': 1244100000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 41.2, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 41.2,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 140.5, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 146.4, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 203.5, 'factor': 1.0},
                     'L3': {'filename': 'As.L3', 'excl before': 5, 'excl after': 50, 'onset': 1323.1, 'factor': 1.0,
                            'XU': 0.1, 'twin': 'L2', 'shape': 'delayed'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1358.6000000000001,
                            'factor': 0.5},
                     'L1': {'filename': 'As.L1', 'excl before': 5, 'excl after': 50, 'onset': 1526.5, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 11866.699999999999,
                            'factor': 1.0},
                     'dat': np.array([1.14416145e+16, 1.20800866e+16, 1.35967689e+16, 1.73427540e+16,
                                      2.17580649e+16, 2.67245121e+16, 3.21425676e+16, 3.78679158e+16,
                                      4.37164299e+16, 4.94815893e+16, 5.49469206e+16, 5.98984386e+16,
                                      6.41507724e+16, 6.75459213e+16, 6.99781368e+16, 7.13877021e+16,
                                      7.17671526e+16, 7.11525672e+16, 6.96235683e+16, 6.72883926e+16,
                                      6.64411605e+16, 6.57656142e+16, 6.55827315e+16, 6.75894648e+16,
                                      6.69611943e+16, 6.69126744e+16, 6.66775395e+16, 6.62421045e+16,
                                      6.60617100e+16, 6.67584060e+16, 6.61040094e+16, 6.46272627e+16,
                                      6.13092480e+16, 5.76441294e+16, 5.37015765e+16, 5.02106319e+16,
                                      4.96122198e+16, 4.92713364e+16, 4.90237605e+16, 5.07008073e+16,
                                      4.97764410e+16, 4.75109349e+16, 4.34091372e+16, 3.94180644e+16,
                                      3.55924569e+16, 3.19758582e+16, 2.85943944e+16, 2.54679711e+16,
                                      2.25990765e+16, 1.99889547e+16, 1.76288970e+16, 1.55077065e+16,
                                      1.36104540e+16, 1.19197221e+16, 1.04198351e+16, 9.09325131e+15,
                                      7.92255321e+15, 6.89044785e+15, 5.98287690e+15, 5.18752377e+15,
                                      4.49256951e+15, 3.86342814e+15, 3.31577532e+15, 3.10004838e+15,
                                      3.06471594e+15, 3.02988114e+15, 2.99541957e+15, 2.96133123e+15,
                                      2.92761612e+15, 2.89427424e+15, 2.86143000e+15, 2.82883458e+15,
                                      2.79661239e+15, 2.76488784e+15, 2.73341211e+15, 2.70230961e+15,
                                      2.67158034e+15, 2.64122430e+15, 2.61124149e+15, 2.58163191e+15,
                                      2.55227115e+15, 2.52328362e+15, 2.49466932e+15, 2.46630384e+15,
                                      2.43831159e+15, 2.40683586e+15, 2.37523572e+15, 2.34400881e+15,
                                      2.31327954e+15, 2.28304791e+15, 2.25306510e+15, 2.22357993e+15,
                                      2.19446799e+15, 2.16585369e+15, 2.13761262e+15, 2.10962037e+15,
                                      2.08212576e+15, 2.05500438e+15, 2.02825623e+15, 2.00188131e+15,
                                      1.97587962e+15, 1.95025116e+15, 1.92487152e+15, 1.89986511e+15,
                                      1.87535634e+15, 1.85097198e+15, 1.82708526e+15, 1.80344736e+15,
                                      1.78005828e+15, 1.75716684e+15, 1.73439981e+15, 1.71213042e+15,
                                      1.68998544e+15, 1.66821369e+15, 1.64681517e+15, 1.62566547e+15,
                                      1.60476459e+15, 1.58411253e+15, 1.56383370e+15, 1.54380369e+15,
                                      1.52402250e+15, 1.50449013e+15, 1.48520658e+15, 1.46617185e+15,
                                      1.44751035e+15, 1.42897326e+15, 1.41080940e+15, 1.39276995e+15,
                                      1.37510373e+15, 1.35756192e+15, 1.34026893e+15, 1.32322476e+15,
                                      1.30642941e+15, 1.28988288e+15, 1.27346076e+15, 1.25728746e+15,
                                      1.24141274e+15, 1.22568732e+15, 1.21018583e+15, 1.19489584e+15,
                                      1.17979247e+15, 1.17617214e+15, 6.17944470e+15, 6.12171846e+15,
                                      6.04246929e+15, 5.96433981e+15, 5.88720561e+15, 5.81119110e+15,
                                      5.76963816e+15, 8.17336377e+15, 8.12969586e+15, 8.02481823e+15,
                                      7.92130911e+15, 7.81916850e+15, 7.71839640e+15, 7.61886840e+15,
                                      7.52070891e+15, 7.42379352e+15, 7.32812223e+15, 7.23369504e+15,
                                      7.14038754e+15, 7.04844855e+15, 6.95762925e+15, 6.86792964e+15,
                                      6.77947413e+15, 6.69213831e+15, 6.60604659e+15, 6.52095015e+15,
                                      6.43697340e+15, 6.35411634e+15, 6.27225456e+15, 6.19151247e+15,
                                      6.11189007e+15, 6.05254650e+15, 6.90052506e+15, 6.89106990e+15,
                                      6.81555303e+15, 6.73145187e+15, 6.64859481e+15, 6.56660862e+15,
                                      6.48574212e+15, 6.40587090e+15, 6.32699496e+15, 6.24911430e+15,
                                      6.17222892e+15, 6.09646323e+15, 6.02194164e+15, 5.94841533e+15,
                                      5.87575989e+15, 5.80397532e+15, 5.73318603e+15, 5.66326761e+15,
                                      5.59422006e+15, 5.52616779e+15, 5.45886198e+15, 5.39255145e+15,
                                      5.32698738e+15, 5.26216977e+15, 5.19834744e+15, 5.13514716e+15,
                                      5.07219570e+15, 5.01011511e+15, 4.94878098e+15, 4.88831772e+15,
                                      4.82847651e+15, 4.76913294e+15, 4.71053583e+15, 4.65268518e+15,
                                      4.59545658e+15, 4.53897444e+15, 4.48323876e+15, 4.42824954e+15,
                                      4.37375796e+15, 4.32013725e+15, 4.26701418e+15, 4.21463757e+15,
                                      4.16288301e+15, 4.11175050e+15, 4.06136445e+15, 4.01147604e+15,
                                      3.96220968e+15, 3.91368978e+15, 3.86566752e+15, 3.81814290e+15,
                                      3.77136474e+15, 3.72508422e+15, 3.67942575e+15, 3.63426492e+15,
                                      3.58947732e+15, 3.54493854e+15, 3.50102181e+15, 3.45760272e+15,
                                      3.41468127e+15, 3.37238187e+15, 3.33058011e+15, 3.28927599e+15,
                                      3.24846951e+15, 3.20816067e+15, 3.16834947e+15, 3.12903591e+15,
                                      3.09021999e+15, 3.05190171e+15, 3.01395666e+15, 2.97650925e+15,
                                      2.93955948e+15, 2.90310735e+15, 2.86702845e+15, 2.83144719e+15,
                                      2.79623916e+15, 2.76152877e+15, 2.72731602e+15, 2.69335209e+15,
                                      2.65988580e+15, 2.62691715e+15, 2.59419732e+15, 2.56197513e+15,
                                      2.53012617e+15, 2.49877485e+15, 2.46767235e+15, 2.43706749e+15,
                                      2.40671145e+15, 2.37685305e+15, 2.34736788e+15, 2.31813153e+15,
                                      2.28939282e+15, 2.26090293e+15, 2.23278627e+15, 2.20504284e+15,
                                      2.17767264e+15, 2.15067567e+15, 2.12392752e+15, 2.09755260e+15,
                                      2.07155091e+15, 2.04579804e+15, 2.02041840e+15, 1.99528758e+15,
                                      1.97052999e+15, 1.94614563e+15, 1.92188568e+15, 1.89812337e+15,
                                      1.87448547e+15, 1.85122080e+15, 1.82832936e+15, 1.80568674e+15,
                                      1.78329294e+15, 1.76102355e+15, 1.73887857e+15, 1.71685800e+15,
                                      1.69508625e+15, 1.67356332e+15, 1.65241362e+15, 1.63138833e+15,
                                      1.61048745e+15, 1.58995980e+15, 1.56955656e+15, 1.54952655e+15,
                                      1.52962095e+15, 1.51008858e+15, 1.49068062e+15, 1.47164589e+15,
                                      1.45285998e+15, 1.43419848e+15, 1.41591021e+15, 1.39774635e+15,
                                      1.37995572e+15, 1.36228950e+15, 1.34487210e+15, 1.32770352e+15,
                                      1.31078376e+15, 1.29411282e+15, 1.27756629e+15, 1.26064653e+15,
                                      1.24362724e+15, 1.22683189e+15, 1.21024804e+15, 1.19367663e+15,
                                      1.17732915e+15, 1.16121806e+15, 1.14533090e+15, 1.12966768e+15,
                                      1.11422840e+15, 1.09900062e+15, 1.08398433e+15, 1.06917954e+15,
                                      1.05458625e+15, 1.04019201e+15, 1.02599683e+15, 1.01201314e+15,
                                      9.98216076e+14, 9.84605622e+14, 9.71194224e+14, 9.57969441e+14,
                                      9.44931273e+14, 9.32067279e+14, 9.19389900e+14, 9.06886695e+14,
                                      8.94557664e+14, 8.82402807e+14, 8.70422124e+14, 8.58603174e+14,
                                      8.46945957e+14, 8.35450473e+14, 8.24116722e+14, 8.12944704e+14,
                                      8.01921978e+14, 7.91060985e+14, 7.80349284e+14, 7.69786875e+14,
                                      7.59361317e+14, 7.49097492e+14, 7.38958077e+14, 7.28967954e+14,
                                      7.19114682e+14, 7.09410702e+14, 6.99818691e+14, 6.90375972e+14,
                                      6.81057663e+14, 6.71876205e+14, 6.62819157e+14, 6.53874078e+14,
                                      6.45053409e+14, 6.36344709e+14, 6.27747978e+14, 6.19275657e+14,
                                      6.10927746e+14, 6.02691804e+14, 5.94567831e+14, 5.86555827e+14,
                                      5.78655792e+14]),
                     'ene': np.array([41.406, 42.024, 43.40198, 46.39671, 49.59809,
                                      53.02035, 56.67876, 60.58959, 64.77028, 69.23942,
                                      74.01695, 79.12411, 84.58368, 90.41995, 96.65893,
                                      103.3284, 110.4581, 118.0797, 126.2272, 134.9368,
                                      137.69, 139.7975, 140.3595, 141.2025, 143.31,
                                      143.472, 144.2475, 145.668, 146.2536, 147.132,
                                      149.328, 154.2005, 164.8404, 176.2144, 188.3732,
                                      199.43, 201.3709, 202.4825, 203.2965, 204.5175,
                                      207.57, 215.2655, 230.1188, 245.997, 262.9708,
                                      281.1158, 300.5128, 321.2482, 343.4143, 367.1099,
                                      392.4405, 419.5189, 448.4657, 479.4098, 512.4891,
                                      547.8508, 585.6525, 626.0625, 669.2609, 715.4399,
                                      764.8052, 817.5768, 873.9896, 900., 904.5,
                                      909.0225, 913.56761, 918.13545, 922.72613, 927.33976,
                                      931.97646, 936.63634, 941.31952, 946.02612, 950.75625,
                                      955.51003, 960.28758, 965.08902, 969.91446, 974.76404,
                                      979.63786, 984.53605, 989.45873, 994.40602, 999.37805,
                                      1004.3749, 1009.3968, 1014.4438, 1019.516, 1024.6136,
                                      1029.7367, 1034.8853, 1040.0598, 1045.2601, 1050.4864,
                                      1055.7388, 1061.0175, 1066.3226, 1071.6542, 1077.0125,
                                      1082.3975, 1087.8095, 1093.2486, 1098.7148, 1104.2084,
                                      1109.7294, 1115.2781, 1120.8545, 1126.4587, 1132.091,
                                      1137.7515, 1143.4402, 1149.1574, 1154.9032, 1160.6777,
                                      1166.4811, 1172.3135, 1178.1751, 1184.066, 1189.9863,
                                      1195.9362, 1201.9159, 1207.9255, 1213.9651, 1220.035,
                                      1226.1351, 1232.2658, 1238.4271, 1244.6193, 1250.8424,
                                      1257.0966, 1263.3821, 1269.699, 1276.0475, 1282.4277,
                                      1288.8399, 1295.284, 1301.7605, 1308.2693, 1314.8106,
                                      1321.3847, 1322.9793, 1323.2206, 1327.9916, 1334.6316,
                                      1341.3047, 1348.0112, 1354.7513, 1358.4739, 1358.7261,
                                      1361.525, 1368.3327, 1375.1743, 1382.0502, 1388.9605,
                                      1395.9053, 1402.8848, 1409.8992, 1416.9487, 1424.0335,
                                      1431.1536, 1438.3094, 1445.5009, 1452.7284, 1459.9921,
                                      1467.292, 1474.6285, 1482.0016, 1489.4117, 1496.8587,
                                      1504.343, 1511.8647, 1519.424, 1525.1383, 1527.0212,
                                      1527.8616, 1534.6563, 1542.3295, 1550.0412, 1557.7914,
                                      1565.5804, 1573.4083, 1581.2753, 1589.1817, 1597.1276,
                                      1605.1132, 1613.1388, 1621.2045, 1629.3105, 1637.4571,
                                      1645.6443, 1653.8726, 1662.1419, 1670.4526, 1678.8049,
                                      1687.1989, 1695.6349, 1704.1131, 1712.6337, 1721.1968,
                                      1729.8028, 1738.4518, 1747.1441, 1755.8798, 1764.6592,
                                      1773.4825, 1782.3499, 1791.2617, 1800.218, 1809.2191,
                                      1818.2652, 1827.3565, 1836.4933, 1845.6757, 1854.9041,
                                      1864.1786, 1873.4995, 1882.867, 1892.2814, 1901.7428,
                                      1911.2515, 1920.8077, 1930.4118, 1940.0638, 1949.7642,
                                      1959.513, 1969.3105, 1979.1571, 1989.0529, 1998.9981,
                                      2008.9931, 2019.0381, 2029.1333, 2039.279, 2049.4754,
                                      2059.7227, 2070.0213, 2080.3714, 2090.7733, 2101.2272,
                                      2111.7333, 2122.292, 2132.9034, 2143.568, 2154.2858,
                                      2165.0572, 2175.8825, 2186.7619, 2197.6957, 2208.6842,
                                      2219.7276, 2230.8263, 2241.9804, 2253.1903, 2264.4562,
                                      2275.7785, 2287.1574, 2298.5932, 2310.0862, 2321.6366,
                                      2333.2448, 2344.911, 2356.6356, 2368.4187, 2380.2608,
                                      2392.1621, 2404.123, 2416.1436, 2428.2243, 2440.3654,
                                      2452.5672, 2464.8301, 2477.1542, 2489.54, 2501.9877,
                                      2514.4976, 2527.0701, 2539.7055, 2552.404, 2565.166,
                                      2577.9919, 2590.8818, 2603.8362, 2616.8554, 2629.9397,
                                      2643.0894, 2656.3048, 2669.5863, 2682.9343, 2696.3489,
                                      2709.8307, 2723.3798, 2736.9967, 2750.6817, 2764.4351,
                                      2778.2573, 2792.1486, 2806.1093, 2820.1399, 2834.2406,
                                      2848.4118, 2862.6539, 2876.9671, 2891.352, 2905.8087,
                                      2920.3378, 2934.9394, 2949.6141, 2964.3622, 2979.184,
                                      2994.0799, 3009.0503, 3024.0956, 3039.2161, 3054.4122,
                                      3069.6842, 3085.0326, 3100.4578, 3115.9601, 3131.5399,
                                      3147.1976, 3162.9336, 3178.7482, 3194.642, 3210.6152,
                                      3226.6683, 3242.8016, 3259.0156, 3275.3107, 3291.6873,
                                      3308.1457, 3324.6864, 3341.3099, 3358.0164, 3374.8065,
                                      3391.6805, 3408.6389, 3425.6821, 3442.8105, 3460.0246,
                                      3477.3247, 3494.7113, 3512.1849, 3529.7458, 3547.3945,
                                      3565.1315, 3582.9572, 3600.8719, 3618.8763, 3636.9707,
                                      3655.1555, 3673.4313, 3691.7985, 3710.2575, 3728.8088,
                                      3747.4528, 3766.1901, 3785.021, 3803.9461, 3822.9659,
                                      3842.0807, 3861.2911, 3880.5975, 3900.0005, 3919.5005,
                                      3939.098, 3958.7935, 3978.5875, 3998.4804]), },
              '34': {'name': 'Se',
                     'barns': 1311160000000.0002,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 56.7, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'hydrogenic'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 56.7,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 161.89999999999998,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 168.2, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 231.5, 'factor': 1.0},
                     'L3': {'filename': 'Se.L3', 'excl before': 5, 'excl after': 50, 'onset': 1435.8, 'factor': 1.0,
                            'XU': 0.1, 'twin': 'L2', 'shape': 'delayed'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1476.2, 'factor': 0.5},
                     'L1': {'filename': 'Se.L1', 'excl before': 5, 'excl after': 50, 'onset': 1653.8999999999999,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 12657.8, 'factor': 1.0},
                     'dat': np.array([6.65295696e+15, 7.27654465e+15, 9.64213952e+15, 1.42981998e+16,
                                      2.00974605e+16, 2.67699537e+16, 3.39800226e+16, 4.13107181e+16,
                                      4.83214906e+16, 5.46032582e+16, 5.98295420e+16, 6.37748224e+16,
                                      6.63276509e+16, 6.74827829e+16, 6.73215102e+16, 6.59919940e+16,
                                      6.36764854e+16, 6.24361280e+16, 6.17228570e+16, 6.15288053e+16,
                                      6.38639813e+16, 6.32778928e+16, 6.31952897e+16, 6.25698664e+16,
                                      6.23784370e+16, 6.31913562e+16, 6.24977526e+16, 6.11983930e+16,
                                      5.77329971e+16, 5.39883242e+16, 5.00758227e+16, 4.69473950e+16,
                                      4.60977633e+16, 4.60387611e+16, 4.57988188e+16, 4.73840112e+16,
                                      4.64884890e+16, 4.40182635e+16, 4.00520045e+16, 3.62063722e+16,
                                      3.25364354e+16, 2.90867734e+16, 2.58796761e+16, 2.29295661e+16,
                                      2.02403769e+16, 1.78068640e+16, 1.56198491e+16, 1.36662207e+16,
                                      1.19280159e+16, 1.03895007e+16, 9.03245012e+15, 7.83942564e+15,
                                      6.79325108e+15, 5.87675024e+15, 5.07615594e+15, 4.37940552e+15,
                                      3.77496076e+15, 3.53567406e+15, 3.49647037e+15, 3.45766004e+15,
                                      3.41937416e+15, 3.38135052e+15, 3.34385135e+15, 3.30674552e+15,
                                      3.27016416e+15, 3.23384502e+15, 3.19791924e+15, 3.16238680e+15,
                                      3.12737883e+15, 3.09263309e+15, 3.05828070e+15, 3.02432166e+15,
                                      2.99075596e+15, 2.95745250e+15, 2.92467350e+15, 2.89215673e+15,
                                      2.86003331e+15, 2.82830324e+15, 2.79696651e+15, 2.76195854e+15,
                                      2.72695057e+15, 2.69233594e+15, 2.65811467e+15, 2.62441786e+15,
                                      2.59124551e+15, 2.55846651e+15, 2.52608086e+15, 2.49408855e+15,
                                      2.46248960e+15, 2.43141510e+15, 2.40073396e+15, 2.36992170e+15,
                                      2.33871609e+15, 2.30790383e+15, 2.27748492e+15, 2.24745936e+15,
                                      2.21795826e+15, 2.18871939e+15, 2.16000498e+15, 2.13168393e+15,
                                      2.10362510e+15, 2.07609074e+15, 2.04894973e+15, 2.02207095e+15,
                                      1.99558552e+15, 1.96949344e+15, 1.94379470e+15, 1.91848931e+15,
                                      1.89344616e+15, 1.86879635e+15, 1.84440877e+15, 1.82041454e+15,
                                      1.79681366e+15, 1.77347502e+15, 1.75039860e+15, 1.72771553e+15,
                                      1.70529470e+15, 1.68313609e+15, 1.66137084e+15, 1.63986781e+15,
                                      1.61875814e+15, 1.59777958e+15, 1.57719436e+15, 1.55687138e+15,
                                      1.53681064e+15, 1.51701212e+15, 1.49747584e+15, 1.47820178e+15,
                                      1.45918996e+15, 1.44044038e+15, 1.42195302e+15, 1.40372790e+15,
                                      1.38576500e+15, 1.36806434e+15, 1.35049480e+15, 1.33331860e+15,
                                      1.31627352e+15, 1.29942512e+15, 1.28285206e+15, 1.26650189e+15,
                                      1.25036151e+15, 1.23444403e+15, 1.21874944e+15, 1.20325153e+15,
                                      1.18797652e+15, 1.17289818e+15, 1.15801651e+15, 1.14333152e+15,
                                      1.12885631e+15, 1.11456467e+15, 1.10046970e+15, 1.09168493e+15,
                                      5.61661609e+15, 5.59249075e+15, 5.52037695e+15, 5.44904984e+15,
                                      5.37864055e+15, 5.30928019e+15, 5.24070652e+15, 5.22759492e+15,
                                      7.39979369e+15, 7.32663096e+15, 7.23235856e+15, 7.13926620e+15,
                                      7.04735388e+15, 6.95662161e+15, 6.86720050e+15, 6.77882832e+15,
                                      6.69163618e+15, 6.60549296e+15, 6.52052980e+15, 6.43661556e+15,
                                      6.35388136e+15, 6.27219609e+15, 6.19155975e+15, 6.11197234e+15,
                                      6.03330274e+15, 5.95581318e+15, 5.87924144e+15, 5.80371862e+15,
                                      5.72911362e+15, 5.65542643e+15, 5.58278816e+15, 5.52339262e+15,
                                      5.51106771e+15, 6.30654848e+15, 6.24217053e+15, 6.16468097e+15,
                                      6.08824034e+15, 6.01271753e+15, 5.93824364e+15, 5.86455645e+15,
                                      5.79191818e+15, 5.72019773e+15, 5.64926398e+15, 5.57964138e+15,
                                      5.51119883e+15, 5.44367409e+15, 5.37706716e+15, 5.31137804e+15,
                                      5.24647562e+15, 5.18249102e+15, 5.11929310e+15, 5.05701300e+15,
                                      4.99538848e+15, 4.93468178e+15, 4.87463065e+15, 4.81549733e+15,
                                      4.75701960e+15, 4.69932856e+15, 4.64189975e+15, 4.58499540e+15,
                                      4.52874664e+15, 4.47328457e+15, 4.41847808e+15, 4.36432718e+15,
                                      4.31056962e+15, 4.25746764e+15, 4.20502124e+15, 4.15323042e+15,
                                      4.10209518e+15, 4.05161552e+15, 4.00179144e+15, 3.95249182e+15,
                                      3.90384778e+15, 3.85585933e+15, 3.80839534e+15, 3.76158692e+15,
                                      3.71530298e+15, 3.66967461e+15, 3.62443959e+15, 3.57986015e+15,
                                      3.53593629e+15, 3.49240578e+15, 3.44939973e+15, 3.40704926e+15,
                                      3.36509214e+15, 3.32379060e+15, 3.28275129e+15, 3.24197422e+15,
                                      3.20159049e+15, 3.16186234e+15, 3.12252754e+15, 3.08371720e+15,
                                      3.04543133e+15, 3.00753881e+15, 2.97003963e+15, 2.93319604e+15,
                                      2.89661467e+15, 2.86055777e+15, 2.82502534e+15, 2.78988625e+15,
                                      2.75514051e+15, 2.72078812e+15, 2.68696019e+15, 2.65339449e+15,
                                      2.62035326e+15, 2.58770538e+15, 2.55558196e+15, 2.52372077e+15,
                                      2.49225293e+15, 2.46117844e+15, 2.43049729e+15, 2.40020950e+15,
                                      2.37031505e+15, 2.34081395e+15, 2.31157508e+15, 2.28272956e+15,
                                      2.25427739e+15, 2.22621856e+15, 2.19855309e+15, 2.17114984e+15,
                                      2.14400883e+15, 2.11726117e+15, 2.09090685e+15, 2.06494588e+15,
                                      2.03911603e+15, 2.01381064e+15, 1.98863637e+15, 1.96385545e+15,
                                      1.93946787e+15, 1.91521141e+15, 1.89134830e+15, 1.86787854e+15,
                                      1.84453989e+15, 1.82159459e+15, 1.79891152e+15, 1.77662180e+15,
                                      1.75446320e+15, 1.73269794e+15, 1.71106380e+15, 1.68982301e+15,
                                      1.66884445e+15, 1.64799700e+15, 1.62754291e+15, 1.60735104e+15,
                                      1.58729030e+15, 1.56736066e+15, 1.54756215e+15, 1.52815698e+15,
                                      1.50888293e+15, 1.48987111e+15, 1.47112152e+15, 1.45250305e+15,
                                      1.43414681e+15, 1.41526610e+15, 1.39625428e+15, 1.37750470e+15,
                                      1.35888622e+15, 1.34052998e+15, 1.32243598e+15, 1.30457798e+15,
                                      1.28698221e+15, 1.26964867e+15, 1.25253804e+15, 1.23566341e+15,
                                      1.21899856e+15, 1.20256973e+15, 1.18635068e+15, 1.17038075e+15,
                                      1.15462061e+15, 1.13908336e+15, 1.12375590e+15, 1.10865134e+15,
                                      1.09374345e+15, 1.07880934e+15, 1.06408501e+15, 1.04955736e+15,
                                      1.03523949e+15, 1.02111830e+15, 1.00719378e+15, 9.93479044e+14,
                                      9.79934761e+14, 9.66587152e+14, 9.53436217e+14, 9.40455733e+14,
                                      9.27658812e+14, 9.15045452e+14, 9.02602544e+14, 8.90343198e+14,
                                      8.78241191e+14, 8.66309635e+14, 8.54548530e+14, 8.42957876e+14,
                                      8.31524560e+14, 8.20235473e+14, 8.09116836e+14, 7.98155538e+14,
                                      7.87338468e+14, 7.76678738e+14, 7.66163234e+14, 7.55791959e+14,
                                      7.45564911e+14, 7.35482090e+14, 7.25543498e+14, 7.15736021e+14,
                                      7.06072772e+14, 6.96540638e+14, 6.87126510e+14, 6.77856608e+14,
                                      6.68717823e+14, 6.59697042e+14, 6.50807378e+14]),
                     'ene': np.array([56.9835, 57.834, 60.58959, 64.77028, 69.23942,
                                      74.01695, 79.12411, 84.58368, 90.41995, 96.65893,
                                      103.3284, 110.4581, 118.0797, 126.2272, 134.9368,
                                      144.2475, 154.2005, 158.662, 161.0905, 161.7381,
                                      162.7095, 164.8404, 165.138, 167.359, 168.0318,
                                      169.041, 171.564, 176.2144, 188.3732, 201.3709,
                                      215.2655, 226.87, 230.1188, 230.3425, 231.2685,
                                      232.6575, 236.13, 245.997, 262.9708, 281.1158,
                                      300.5128, 321.2482, 343.4143, 367.1099, 392.4405,
                                      419.5189, 448.4657, 479.4098, 512.4891, 547.8508,
                                      585.6525, 626.0625, 669.2609, 715.4399, 764.8052,
                                      817.5768, 873.9896, 900., 904.5, 909.0225,
                                      913.56761, 918.13545, 922.72613, 927.33976, 931.97646,
                                      936.63634, 941.31952, 946.02612, 950.75625, 955.51003,
                                      960.28758, 965.08902, 969.91446, 974.76404, 979.63786,
                                      984.53605, 989.45873, 994.40602, 999.37805, 1004.3749,
                                      1009.3968, 1014.4438, 1019.516, 1024.6136, 1029.7367,
                                      1034.8853, 1040.0598, 1045.2601, 1050.4864, 1055.7388,
                                      1061.0175, 1066.3226, 1071.6542, 1077.0125, 1082.3975,
                                      1087.8095, 1093.2486, 1098.7148, 1104.2084, 1109.7294,
                                      1115.2781, 1120.8545, 1126.4587, 1132.091, 1137.7515,
                                      1143.4402, 1149.1574, 1154.9032, 1160.6777, 1166.4811,
                                      1172.3135, 1178.1751, 1184.066, 1189.9863, 1195.9362,
                                      1201.9159, 1207.9255, 1213.9651, 1220.035, 1226.1351,
                                      1232.2658, 1238.4271, 1244.6193, 1250.8424, 1257.0966,
                                      1263.3821, 1269.699, 1276.0475, 1282.4277, 1288.8399,
                                      1295.284, 1301.7605, 1308.2693, 1314.8106, 1321.3847,
                                      1327.9916, 1334.6316, 1341.3047, 1348.0112, 1354.7513,
                                      1361.525, 1368.3327, 1375.1743, 1382.0502, 1388.9605,
                                      1395.9053, 1402.8848, 1409.8992, 1416.9487, 1424.0335,
                                      1431.1536, 1435.6568, 1435.9431, 1438.3094, 1445.5009,
                                      1452.7284, 1459.9921, 1467.292, 1474.6285, 1476.0494,
                                      1476.3506, 1482.0016, 1489.4117, 1496.8587, 1504.343,
                                      1511.8647, 1519.424, 1527.0212, 1534.6563, 1542.3295,
                                      1550.0412, 1557.7914, 1565.5804, 1573.4083, 1581.2753,
                                      1589.1817, 1597.1276, 1605.1132, 1613.1388, 1621.2045,
                                      1629.3105, 1637.4571, 1645.6443, 1652.4595, 1653.8726,
                                      1655.3406, 1662.1419, 1670.4526, 1678.8049, 1687.1989,
                                      1695.6349, 1704.1131, 1712.6337, 1721.1968, 1729.8028,
                                      1738.4518, 1747.1441, 1755.8798, 1764.6592, 1773.4825,
                                      1782.3499, 1791.2617, 1800.218, 1809.2191, 1818.2652,
                                      1827.3565, 1836.4933, 1845.6757, 1854.9041, 1864.1786,
                                      1873.4995, 1882.867, 1892.2814, 1901.7428, 1911.2515,
                                      1920.8077, 1930.4118, 1940.0638, 1949.7642, 1959.513,
                                      1969.3105, 1979.1571, 1989.0529, 1998.9981, 2008.9931,
                                      2019.0381, 2029.1333, 2039.279, 2049.4754, 2059.7227,
                                      2070.0213, 2080.3714, 2090.7733, 2101.2272, 2111.7333,
                                      2122.292, 2132.9034, 2143.568, 2154.2858, 2165.0572,
                                      2175.8825, 2186.7619, 2197.6957, 2208.6842, 2219.7276,
                                      2230.8263, 2241.9804, 2253.1903, 2264.4562, 2275.7785,
                                      2287.1574, 2298.5932, 2310.0862, 2321.6366, 2333.2448,
                                      2344.911, 2356.6356, 2368.4187, 2380.2608, 2392.1621,
                                      2404.123, 2416.1436, 2428.2243, 2440.3654, 2452.5672,
                                      2464.8301, 2477.1542, 2489.54, 2501.9877, 2514.4976,
                                      2527.0701, 2539.7055, 2552.404, 2565.166, 2577.9919,
                                      2590.8818, 2603.8362, 2616.8554, 2629.9397, 2643.0894,
                                      2656.3048, 2669.5863, 2682.9343, 2696.3489, 2709.8307,
                                      2723.3798, 2736.9967, 2750.6817, 2764.4351, 2778.2573,
                                      2792.1486, 2806.1093, 2820.1399, 2834.2406, 2848.4118,
                                      2862.6539, 2876.9671, 2891.352, 2905.8087, 2920.3378,
                                      2934.9394, 2949.6141, 2964.3622, 2979.184, 2994.0799,
                                      3009.0503, 3024.0956, 3039.2161, 3054.4122, 3069.6842,
                                      3085.0326, 3100.4578, 3115.9601, 3131.5399, 3147.1976,
                                      3162.9336, 3178.7482, 3194.642, 3210.6152, 3226.6683,
                                      3242.8016, 3259.0156, 3275.3107, 3291.6873, 3308.1457,
                                      3324.6864, 3341.3099, 3358.0164, 3374.8065, 3391.6805,
                                      3408.6389, 3425.6821, 3442.8105, 3460.0246, 3477.3247,
                                      3494.7113, 3512.1849, 3529.7458, 3547.3945, 3565.1315,
                                      3582.9572, 3600.8719, 3618.8763, 3636.9707, 3655.1555,
                                      3673.4313, 3691.7985, 3710.2575, 3728.8088, 3747.4528,
                                      3766.1901, 3785.021, 3803.9461, 3822.9659, 3842.0807,
                                      3861.2911, 3880.5975, 3900.0005, 3919.5005, 3939.098,
                                      3958.7935, 3978.5875, 3998.4804]), },
              '35': {'name': 'Br',
                     'barns': 1326840000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 69.0, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'delayed'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 70.1,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 181.5, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 189.29999999999998,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 256.5, 'factor': 1.0},
                     'L3': {'filename': 'Br.L3', 'excl before': 5, 'excl after': 50, 'onset': 1549.9, 'factor': 1.0,
                            'XU': 0.1, 'twin': 'L2', 'shape': 'delayed'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1596.0, 'factor': 0.5},
                     'L1': {'filename': 'Br.L1', 'excl before': 5, 'excl after': 50, 'onset': 1782.0, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 13473.699999999999,
                            'factor': 1.0},
                     'dat': np.array([2.83744734e+15, 2.86968955e+15, 2.99640277e+15, 3.08702594e+15,
                                      5.05446430e+15, 5.09227924e+15, 5.68696892e+15, 7.35878732e+15,
                                      1.19503171e+16, 1.80344093e+16, 2.52736483e+16, 3.31869221e+16,
                                      4.11705184e+16, 4.86008224e+16, 5.49431176e+16, 5.98179277e+16,
                                      6.30275537e+16, 6.45494392e+16, 6.44976924e+16, 6.30832810e+16,
                                      6.05636118e+16, 6.01376962e+16, 5.94132415e+16, 5.92155424e+16,
                                      6.20430384e+16, 6.13464474e+16, 6.12469344e+16, 6.04932893e+16,
                                      6.02955901e+16, 6.12840859e+16, 6.05437092e+16, 5.83398280e+16,
                                      5.45636413e+16, 5.05539308e+16, 4.64486879e+16, 4.51191942e+16,
                                      4.41864257e+16, 4.39409603e+16, 4.54509042e+16, 4.45380383e+16,
                                      4.42249040e+16, 4.01966178e+16, 3.63036692e+16, 3.25858636e+16,
                                      2.90909670e+16, 2.58455164e+16, 2.28654337e+16, 2.01520459e+16,
                                      1.77026993e+16, 1.55054522e+16, 1.35443827e+16, 1.18046301e+16,
                                      1.02665572e+16, 8.91238428e+15, 7.72380101e+15, 6.68369113e+15,
                                      5.77507110e+15, 4.98254957e+15, 4.29365424e+15, 4.02072325e+15,
                                      3.97600874e+15, 3.93182497e+15, 3.88803925e+15, 3.84478427e+15,
                                      3.80192734e+15, 3.75960114e+15, 3.71780568e+15, 3.67640827e+15,
                                      3.63540892e+15, 3.59494030e+15, 3.55486973e+15, 3.51519721e+15,
                                      3.47605543e+15, 3.43731170e+15, 3.39896603e+15, 3.36115109e+15,
                                      3.32360152e+15, 3.28658268e+15, 3.24996190e+15, 3.21373916e+15,
                                      3.17791448e+15, 3.13824197e+15, 3.09856945e+15, 3.05942767e+15,
                                      3.02081663e+15, 2.98273632e+15, 2.94478870e+15, 2.90723912e+15,
                                      2.87022029e+15, 2.83373219e+15, 2.79777482e+15, 2.76221551e+15,
                                      2.72705425e+15, 2.69255641e+15, 2.65832394e+15, 2.62462220e+15,
                                      2.59131852e+15, 2.55854557e+15, 2.52617068e+15, 2.49419383e+15,
                                      2.46261504e+15, 2.43143430e+15, 2.40078430e+15, 2.37039966e+15,
                                      2.34054576e+15, 2.31095723e+15, 2.28176675e+15, 2.25310700e+15,
                                      2.22471263e+15, 2.19671630e+15, 2.16898535e+15, 2.14178513e+15,
                                      2.11485028e+15, 2.08818079e+15, 2.06204204e+15, 2.03616866e+15,
                                      2.01056065e+15, 1.98535069e+15, 1.96040610e+15, 1.93585956e+15,
                                      1.91171107e+15, 1.88769527e+15, 1.86407752e+15, 1.84085782e+15,
                                      1.81777080e+15, 1.79508184e+15, 1.77265824e+15, 1.75050001e+15,
                                      1.72873984e+15, 1.70724503e+15, 1.68588290e+15, 1.66491883e+15,
                                      1.64422013e+15, 1.62325606e+15, 1.60255735e+15, 1.58212402e+15,
                                      1.56169068e+15, 1.54139003e+15, 1.52148743e+15, 1.50185020e+15,
                                      1.48247833e+15, 1.46323915e+15, 1.44439802e+15, 1.42582226e+15,
                                      1.40737919e+15, 1.38933416e+15, 1.37142182e+15, 1.35390754e+15,
                                      1.33652593e+15, 1.31933009e+15, 1.30242614e+15, 1.28574777e+15,
                                      1.26929495e+15, 1.25306770e+15, 1.23705274e+15, 1.22126334e+15,
                                      1.20568624e+15, 1.19032143e+15, 1.17516892e+15, 1.16021543e+15,
                                      1.14546097e+15, 1.13090554e+15, 1.11654913e+15, 1.10239175e+15,
                                      1.08842012e+15, 1.07463425e+15, 1.06103414e+15, 1.04761979e+15,
                                      1.03490866e+15, 5.16353054e+15, 5.16326518e+15, 5.09679049e+15,
                                      5.03097923e+15, 4.96596407e+15, 4.90187770e+15, 4.83858743e+15,
                                      4.78630993e+15, 6.76343422e+15, 6.75308486e+15, 6.66604416e+15,
                                      6.58033030e+15, 6.49554522e+15, 6.41195430e+15, 6.32942485e+15,
                                      6.24808956e+15, 6.16768306e+15, 6.08833802e+15, 6.01005446e+15,
                                      5.93269969e+15, 5.85640639e+15, 5.78104188e+15, 5.70673884e+15,
                                      5.63336459e+15, 5.56105181e+15, 5.48953513e+15, 5.41894724e+15,
                                      5.34928814e+15, 5.28055783e+15, 5.21275631e+15, 5.14575089e+15,
                                      5.09347339e+15, 5.83491158e+15, 5.82535834e+15, 5.76220075e+15,
                                      5.69041871e+15, 5.61956545e+15, 5.54950830e+15, 5.48051262e+15,
                                      5.41218036e+15, 5.34490957e+15, 5.27830220e+15, 5.21275631e+15,
                                      5.14813920e+15, 5.08498162e+15, 5.02262014e+15, 4.96105476e+15,
                                      4.90041817e+15, 4.84044500e+15, 4.78140062e+15, 4.72301966e+15,
                                      4.66543481e+15, 4.60864606e+15, 4.55252072e+15, 4.49719150e+15,
                                      4.44252569e+15, 4.38865598e+15, 4.33544970e+15, 4.28264147e+15,
                                      4.23009860e+15, 4.17821916e+15, 4.12713582e+15, 4.07658322e+15,
                                      4.02669403e+15, 3.97720290e+15, 3.92824250e+15, 3.87981284e+15,
                                      3.83204660e+15, 3.78494378e+15, 3.73823902e+15, 3.69233035e+15,
                                      3.64681974e+15, 3.60197255e+15, 3.55765609e+15, 3.51387037e+15,
                                      3.47061539e+15, 3.42802382e+15, 3.38583031e+15, 3.34416754e+15,
                                      3.30303550e+15, 3.26243419e+15, 3.22236362e+15, 3.18269111e+15,
                                      3.14354933e+15, 3.10480560e+15, 3.06672529e+15, 3.02877767e+15,
                                      2.99122810e+15, 2.95407658e+15, 2.91732311e+15, 2.88110038e+15,
                                      2.84527570e+15, 2.80984907e+15, 2.77495318e+15, 2.74045534e+15,
                                      2.70635555e+15, 2.67265381e+15, 2.63948281e+15, 2.60657718e+15,
                                      2.57420228e+15, 2.54222544e+15, 2.51051396e+15, 2.47933322e+15,
                                      2.44841785e+15, 2.41790053e+15, 2.38778126e+15, 2.35806005e+15,
                                      2.32873688e+15, 2.29981177e+15, 2.27115203e+15, 2.24289034e+15,
                                      2.21489401e+15, 2.18729574e+15, 2.16009552e+15, 2.13316067e+15,
                                      2.10662387e+15, 2.08048512e+15, 2.05461174e+15, 2.02900373e+15,
                                      2.00366108e+15, 1.97884918e+15, 1.95416995e+15, 1.92988878e+15,
                                      1.90587298e+15, 1.88212254e+15, 1.85877016e+15, 1.83555046e+15,
                                      1.81272881e+15, 1.79030521e+15, 1.76801430e+15, 1.74598876e+15,
                                      1.72436126e+15, 1.70286646e+15, 1.68176970e+15, 1.66093831e+15,
                                      1.64023961e+15, 1.61993896e+15, 1.59990367e+15, 1.57947034e+15,
                                      1.55903700e+15, 1.53886903e+15, 1.51896643e+15, 1.49932920e+15,
                                      1.47982465e+15, 1.46071816e+15, 1.44134629e+15, 1.42210711e+15,
                                      1.40326598e+15, 1.38469022e+15, 1.36624715e+15, 1.34806944e+15,
                                      1.33002442e+15, 1.31211208e+15, 1.29447837e+15, 1.27709677e+15,
                                      1.25995400e+15, 1.24305005e+15, 1.22637168e+15, 1.20993213e+15,
                                      1.19371814e+15, 1.17772972e+15, 1.16196686e+15, 1.14641630e+15,
                                      1.13109129e+15, 1.11589898e+15, 1.10091895e+15, 1.08613796e+15,
                                      1.07156925e+15, 1.05721284e+15, 1.04304219e+15, 1.02907057e+15,
                                      1.01529797e+15, 1.00167132e+15, 9.88004869e+14, 9.74510906e+14,
                                      9.61215970e+14, 9.48106790e+14, 9.35183369e+14, 9.22445705e+14,
                                      9.09867262e+14, 8.97474576e+14, 8.85254380e+14, 8.73206672e+14,
                                      8.61331454e+14, 8.49615457e+14, 8.38058681e+14, 8.26674394e+14,
                                      8.15436059e+14, 8.04370213e+14, 7.93437052e+14, 7.82676379e+14,
                                      7.72048391e+14, 7.61579623e+14, 7.51256808e+14, 7.41066677e+14,
                                      7.31035766e+14]),
                     'ene': np.array([69.23942, 69.345, 69.7495, 70.0299, 70.38,
                                      70.4505, 71.502, 74.01695, 79.12411, 84.58368,
                                      90.41995, 96.65893, 103.3284, 110.4581, 118.0797,
                                      126.2272, 134.9368, 144.2475, 154.2005, 164.8404,
                                      176.2144, 177.87, 180.5925, 181.3185, 182.4075,
                                      185.13, 185.514, 188.3732, 189.1107, 190.2465,
                                      193.086, 201.3709, 215.2655, 230.1188, 245.997,
                                      251.37, 255.2175, 256.2435, 257.7825, 261.63,
                                      262.9708, 281.1158, 300.5128, 321.2482, 343.4143,
                                      367.1099, 392.4405, 419.5189, 448.4657, 479.4098,
                                      512.4891, 547.8508, 585.6525, 626.0625, 669.2609,
                                      715.4399, 764.8052, 817.5768, 873.9896, 900.,
                                      904.5, 909.0225, 913.56761, 918.13545, 922.72613,
                                      927.33976, 931.97646, 936.63634, 941.31952, 946.02612,
                                      950.75625, 955.51003, 960.28758, 965.08902, 969.91446,
                                      974.76404, 979.63786, 984.53605, 989.45873, 994.40602,
                                      999.37805, 1004.3749, 1009.3968, 1014.4438, 1019.516,
                                      1024.6136, 1029.7367, 1034.8853, 1040.0598, 1045.2601,
                                      1050.4864, 1055.7388, 1061.0175, 1066.3226, 1071.6542,
                                      1077.0125, 1082.3975, 1087.8095, 1093.2486, 1098.7148,
                                      1104.2084, 1109.7294, 1115.2781, 1120.8545, 1126.4587,
                                      1132.091, 1137.7515, 1143.4402, 1149.1574, 1154.9032,
                                      1160.6777, 1166.4811, 1172.3135, 1178.1751, 1184.066,
                                      1189.9863, 1195.9362, 1201.9159, 1207.9255, 1213.9651,
                                      1220.035, 1226.1351, 1232.2658, 1238.4271, 1244.6193,
                                      1250.8424, 1257.0966, 1263.3821, 1269.699, 1276.0475,
                                      1282.4277, 1288.8399, 1295.284, 1301.7605, 1308.2693,
                                      1314.8106, 1321.3847, 1327.9916, 1334.6316, 1341.3047,
                                      1348.0112, 1354.7513, 1361.525, 1368.3327, 1375.1743,
                                      1382.0502, 1388.9605, 1395.9053, 1402.8848, 1409.8992,
                                      1416.9487, 1424.0335, 1431.1536, 1438.3094, 1445.5009,
                                      1452.7284, 1459.9921, 1467.292, 1474.6285, 1482.0016,
                                      1489.4117, 1496.8587, 1504.343, 1511.8647, 1519.424,
                                      1527.0212, 1534.6563, 1542.3295, 1549.7311, 1550.0412,
                                      1550.069, 1557.7914, 1565.5804, 1573.4083, 1581.2753,
                                      1589.1817, 1595.8196, 1596.1803, 1597.1276, 1605.1132,
                                      1613.1388, 1621.2045, 1629.3105, 1637.4571, 1645.6443,
                                      1653.8726, 1662.1419, 1670.4526, 1678.8049, 1687.1989,
                                      1695.6349, 1704.1131, 1712.6337, 1721.1968, 1729.8028,
                                      1738.4518, 1747.1441, 1755.8798, 1764.6592, 1773.4825,
                                      1780.4852, 1782.3499, 1783.5146, 1791.2617, 1800.218,
                                      1809.2191, 1818.2652, 1827.3565, 1836.4933, 1845.6757,
                                      1854.9041, 1864.1786, 1873.4995, 1882.867, 1892.2814,
                                      1901.7428, 1911.2515, 1920.8077, 1930.4118, 1940.0638,
                                      1949.7642, 1959.513, 1969.3105, 1979.1571, 1989.0529,
                                      1998.9981, 2008.9931, 2019.0381, 2029.1333, 2039.279,
                                      2049.4754, 2059.7227, 2070.0213, 2080.3714, 2090.7733,
                                      2101.2272, 2111.7333, 2122.292, 2132.9034, 2143.568,
                                      2154.2858, 2165.0572, 2175.8825, 2186.7619, 2197.6957,
                                      2208.6842, 2219.7276, 2230.8263, 2241.9804, 2253.1903,
                                      2264.4562, 2275.7785, 2287.1574, 2298.5932, 2310.0862,
                                      2321.6366, 2333.2448, 2344.911, 2356.6356, 2368.4187,
                                      2380.2608, 2392.1621, 2404.123, 2416.1436, 2428.2243,
                                      2440.3654, 2452.5672, 2464.8301, 2477.1542, 2489.54,
                                      2501.9877, 2514.4976, 2527.0701, 2539.7055, 2552.404,
                                      2565.166, 2577.9919, 2590.8818, 2603.8362, 2616.8554,
                                      2629.9397, 2643.0894, 2656.3048, 2669.5863, 2682.9343,
                                      2696.3489, 2709.8307, 2723.3798, 2736.9967, 2750.6817,
                                      2764.4351, 2778.2573, 2792.1486, 2806.1093, 2820.1399,
                                      2834.2406, 2848.4118, 2862.6539, 2876.9671, 2891.352,
                                      2905.8087, 2920.3378, 2934.9394, 2949.6141, 2964.3622,
                                      2979.184, 2994.0799, 3009.0503, 3024.0956, 3039.2161,
                                      3054.4122, 3069.6842, 3085.0326, 3100.4578, 3115.9601,
                                      3131.5399, 3147.1976, 3162.9336, 3178.7482, 3194.642,
                                      3210.6152, 3226.6683, 3242.8016, 3259.0156, 3275.3107,
                                      3291.6873, 3308.1457, 3324.6864, 3341.3099, 3358.0164,
                                      3374.8065, 3391.6805, 3408.6389, 3425.6821, 3442.8105,
                                      3460.0246, 3477.3247, 3494.7113, 3512.1849, 3529.7458,
                                      3547.3945, 3565.1315, 3582.9572, 3600.8719, 3618.8763,
                                      3636.9707, 3655.1555, 3673.4313, 3691.7985, 3710.2575,
                                      3728.8088, 3747.4528, 3766.1901, 3785.021, 3803.9461,
                                      3822.9659, 3842.0807, 3861.2911, 3880.5975, 3900.0005,
                                      3919.5005, 3939.098, 3958.7935, 3978.5875, 3998.4804]), },
              '36': {'name': 'Kr',
                     'barns': 1391530000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'Kr.M5', 'excl before': 5, 'excl after': 50, 'onset': 88.9, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'hydrogenic'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 88.9,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 213.79999999999998,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 222.70000000000002,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 288.33, 'factor': 1.0},
                     'L3': {'filename': 'Kr.L3', 'excl before': 5, 'excl after': 50, 'onset': 1674.9, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1727.2, 'factor': 0.5},
                     'L1': {'filename': 'Kr.L1', 'excl before': 5, 'excl after': 50, 'onset': 1921.0, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 14325.6, 'factor': 1.0},
                     'dat': np.array([3.21777397e+15, 3.58959079e+15, 3.68421483e+15, 6.60517545e+15,
                                      1.16720145e+16, 1.84642116e+16, 2.65142126e+16, 3.50484661e+16,
                                      4.31750013e+16, 5.00964715e+16, 5.52562648e+16, 5.83997310e+16,
                                      5.95435687e+16, 5.89076395e+16, 5.68273021e+16, 5.50572760e+16,
                                      5.42961091e+16, 5.40887711e+16, 5.72266712e+16, 5.71348303e+16,
                                      5.64348907e+16, 5.56305863e+16, 5.54135077e+16, 5.65086418e+16,
                                      5.57085120e+16, 5.49904825e+16, 5.11025477e+16, 4.69947512e+16,
                                      4.28271188e+16, 4.25084584e+16, 4.15677842e+16, 4.13200918e+16,
                                      4.27283202e+16, 4.18085188e+16, 4.04809992e+16, 3.64984404e+16,
                                      3.27301771e+16, 2.92054316e+16, 2.59283785e+16, 2.29171076e+16,
                                      2.01757935e+16, 1.77016531e+16, 1.54835543e+16, 1.35061902e+16,
                                      1.17530015e+16, 1.02053419e+16, 8.84442553e+15, 7.65160601e+15,
                                      6.60948919e+15, 5.70137672e+15, 4.91168344e+15, 4.59831088e+15,
                                      4.54696343e+15, 4.49617258e+15, 4.44579920e+15, 4.39598242e+15,
                                      4.34686141e+15, 4.29815786e+15, 4.24987177e+15, 4.20228145e+15,
                                      4.15510858e+15, 4.10849232e+15, 4.06243268e+15, 4.01679050e+15,
                                      3.97170493e+15, 3.92703681e+15, 3.88292531e+15, 3.83923127e+15,
                                      3.79609384e+15, 3.75351302e+15, 3.71121051e+15, 3.66960376e+15,
                                      3.62827532e+15, 3.58249398e+15, 3.53671265e+15, 3.49148792e+15,
                                      3.44681981e+15, 3.40284746e+15, 3.35943173e+15, 3.31657260e+15,
                                      3.27427009e+15, 3.23252419e+15, 3.19133490e+15, 3.15070223e+15,
                                      3.11062616e+15, 3.07110671e+15, 3.03214387e+15, 2.99359849e+15,
                                      2.95560972e+15, 2.91803841e+15, 2.88116286e+15, 2.84456563e+15,
                                      2.80852500e+15, 2.77304098e+15, 2.73797443e+15, 2.70332533e+15,
                                      2.66923285e+15, 2.63541867e+15, 2.60216110e+15, 2.56946014e+15,
                                      2.53703750e+15, 2.50503231e+15, 2.47316627e+15, 2.44171769e+15,
                                      2.41082572e+15, 2.38021206e+15, 2.35001586e+15, 2.32023712e+15,
                                      2.29087584e+15, 2.26193202e+15, 2.23326650e+15, 2.20501844e+15,
                                      2.17718784e+15, 2.14963554e+15, 2.12250071e+15, 2.09578333e+15,
                                      2.06934426e+15, 2.04332265e+15, 2.01757935e+15, 1.99225350e+15,
                                      1.96706681e+15, 1.94243673e+15, 1.91794580e+15, 1.89387233e+15,
                                      1.87021632e+15, 1.84669946e+15, 1.82360006e+15, 1.80077897e+15,
                                      1.77823619e+15, 1.75597171e+15, 1.73398553e+15, 1.71227766e+15,
                                      1.69084810e+15, 1.66983600e+15, 1.64896305e+15, 1.62836841e+15,
                                      1.60805207e+15, 1.58801404e+15, 1.56825431e+15, 1.54877289e+15,
                                      1.52956978e+15, 1.51050582e+15, 1.49172016e+15, 1.47321281e+15,
                                      1.45498377e+15, 1.43689388e+15, 1.41908229e+15, 1.40154902e+15,
                                      1.38418272e+15, 1.36706690e+15, 1.35015981e+15, 1.33347537e+15,
                                      1.31699965e+15, 1.30074658e+15, 1.28470224e+15, 1.26885272e+15,
                                      1.25321192e+15, 1.23777985e+15, 1.22254260e+15, 1.20750016e+15,
                                      1.19265253e+15, 1.17799972e+15, 1.16352781e+15, 1.14923680e+15,
                                      1.13514060e+15, 1.12122530e+15, 1.10747698e+15, 1.09390956e+15,
                                      1.08052304e+15, 1.06730351e+15, 1.05425096e+15, 1.04136539e+15,
                                      1.02864681e+15, 1.01608129e+15, 1.00368276e+15, 9.91381633e+14,
                                      9.84966680e+14, 4.75165749e+15, 4.72424435e+15, 4.66301703e+15,
                                      4.60248548e+15, 4.54292799e+15, 4.48406627e+15, 4.42590032e+15,
                                      4.38721578e+15, 6.18827306e+15, 6.16614774e+15, 6.08641307e+15,
                                      6.00779162e+15, 5.93028340e+15, 5.85374925e+15, 5.77818917e+15,
                                      5.70360316e+15, 5.62999123e+15, 5.55735336e+15, 5.48555041e+15,
                                      5.41486069e+15, 5.34500588e+15, 5.27598600e+15, 5.20794018e+15,
                                      5.14086843e+15, 5.07449245e+15, 5.00909054e+15, 4.94452355e+15,
                                      4.88079148e+15, 4.81789432e+15, 4.75583208e+15, 4.70309309e+15,
                                      4.69460476e+15, 5.38549941e+15, 5.32997736e+15, 5.26332307e+15,
                                      5.19736455e+15, 5.13224095e+15, 5.06809141e+15, 5.00463764e+15,
                                      4.94201880e+15, 4.88009571e+15, 4.81914670e+15, 4.75917175e+15,
                                      4.70044919e+15, 4.64256154e+15, 4.58550881e+15, 4.52915184e+15,
                                      4.47362980e+15, 4.41880352e+15, 4.36481215e+15, 4.31137740e+15,
                                      4.25877756e+15, 4.20673434e+15, 4.15552604e+15, 4.10487435e+15,
                                      4.05491842e+15, 4.00565826e+15, 3.95695471e+15, 3.90839031e+15,
                                      3.86038253e+15, 3.81307051e+15, 3.76631510e+15, 3.72011630e+15,
                                      3.67461327e+15, 3.62938855e+15, 3.58458128e+15, 3.54046978e+15,
                                      3.49677574e+15, 3.45377746e+15, 3.41119664e+15, 3.36917244e+15,
                                      3.32770484e+15, 3.28679386e+15, 3.24630034e+15, 3.20636343e+15,
                                      3.16684397e+15, 3.12788113e+15, 3.08933575e+15, 3.05134698e+15,
                                      3.01377567e+15, 2.97662182e+15, 2.94002458e+15, 2.90384480e+15,
                                      2.86808248e+15, 2.83273762e+15, 2.79781022e+15, 2.76302197e+15,
                                      2.72865118e+15, 2.69483700e+15, 2.66130112e+15, 2.62818271e+15,
                                      2.59562091e+15, 2.56333741e+15, 2.53147138e+15, 2.50002280e+15,
                                      2.46885253e+15, 2.43823887e+15, 2.40790351e+15, 2.37784646e+15,
                                      2.34834603e+15, 2.31912390e+15, 2.29031923e+15, 2.26179286e+15,
                                      2.23368396e+15, 2.20585336e+15, 2.17844022e+15, 2.15130538e+15,
                                      2.12458800e+15, 2.09814893e+15, 2.07212732e+15, 2.04638402e+15,
                                      2.02091902e+15, 1.99573233e+15, 1.97096309e+15, 1.94647216e+15,
                                      1.92239870e+15, 1.89846438e+15, 1.87494752e+15, 1.85156982e+15,
                                      1.82860957e+15, 1.80592763e+15, 1.78352400e+15, 1.76084206e+15,
                                      1.73802097e+15, 1.71547818e+15, 1.69321370e+15, 1.67122753e+15,
                                      1.64965882e+15, 1.62822925e+15, 1.60707800e+15, 1.58634420e+15,
                                      1.56574956e+15, 1.54543322e+15, 1.52553434e+15, 1.50577461e+15,
                                      1.48629319e+15, 1.46695093e+15, 1.44802612e+15, 1.42924046e+15,
                                      1.41087227e+15, 1.39250407e+15, 1.37456725e+15, 1.35679741e+15,
                                      1.33926413e+15, 1.32173086e+15, 1.30415583e+15, 1.28683128e+15,
                                      1.26975721e+15, 1.25290578e+15, 1.23627700e+15, 1.21980128e+15,
                                      1.20338123e+15, 1.18718382e+15, 1.17122297e+15, 1.15548477e+15,
                                      1.13995529e+15, 1.12464846e+15, 1.10955036e+15, 1.09466099e+15,
                                      1.07998035e+15, 1.06550844e+15, 1.05123134e+15, 1.03716297e+15,
                                      1.02327550e+15, 1.00958285e+15, 9.96085005e+14, 9.82781978e+14,
                                      9.69645935e+14, 9.56704706e+14, 9.43944376e+14, 9.31351029e+14,
                                      9.18924666e+14, 9.06442642e+14, 8.94127601e+14, 8.81979545e+14,
                                      8.69998471e+14, 8.58198297e+14, 8.46551191e+14, 8.35071068e+14,
                                      8.23744014e+14]),
                     'ene': np.array([89.3445, 90.41995, 90.678, 96.65893, 103.3284,
                                      110.4581, 118.0797, 126.2272, 134.9368, 144.2475,
                                      154.2005, 164.8404, 176.2144, 188.3732, 201.3709,
                                      209.524, 212.731, 213.5862, 214.869, 215.2655,
                                      218.246, 221.5865, 222.4773, 223.8135, 227.154,
                                      230.1188, 245.997, 262.9708, 281.1158, 282.5634,
                                      286.8883, 288.0417, 289.7716, 294.0966, 300.5128,
                                      321.2482, 343.4143, 367.1099, 392.4405, 419.5189,
                                      448.4657, 479.4098, 512.4891, 547.8508, 585.6525,
                                      626.0625, 669.2609, 715.4399, 764.8052, 817.5768,
                                      873.9896, 900., 904.5, 909.0225, 913.56761,
                                      918.13545, 922.72613, 927.33976, 931.97646, 936.63634,
                                      941.31952, 946.02612, 950.75625, 955.51003, 960.28758,
                                      965.08902, 969.91446, 974.76404, 979.63786, 984.53605,
                                      989.45873, 994.40602, 999.37805, 1004.3749, 1009.3968,
                                      1014.4438, 1019.516, 1024.6136, 1029.7367, 1034.8853,
                                      1040.0598, 1045.2601, 1050.4864, 1055.7388, 1061.0175,
                                      1066.3226, 1071.6542, 1077.0125, 1082.3975, 1087.8095,
                                      1093.2486, 1098.7148, 1104.2084, 1109.7294, 1115.2781,
                                      1120.8545, 1126.4587, 1132.091, 1137.7515, 1143.4402,
                                      1149.1574, 1154.9032, 1160.6777, 1166.4811, 1172.3135,
                                      1178.1751, 1184.066, 1189.9863, 1195.9362, 1201.9159,
                                      1207.9255, 1213.9651, 1220.035, 1226.1351, 1232.2658,
                                      1238.4271, 1244.6193, 1250.8424, 1257.0966, 1263.3821,
                                      1269.699, 1276.0475, 1282.4277, 1288.8399, 1295.284,
                                      1301.7605, 1308.2693, 1314.8106, 1321.3847, 1327.9916,
                                      1334.6316, 1341.3047, 1348.0112, 1354.7513, 1361.525,
                                      1368.3327, 1375.1743, 1382.0502, 1388.9605, 1395.9053,
                                      1402.8848, 1409.8992, 1416.9487, 1424.0335, 1431.1536,
                                      1438.3094, 1445.5009, 1452.7284, 1459.9921, 1467.292,
                                      1474.6285, 1482.0016, 1489.4117, 1496.8587, 1504.343,
                                      1511.8647, 1519.424, 1527.0212, 1534.6563, 1542.3295,
                                      1550.0412, 1557.7914, 1565.5804, 1573.4083, 1581.2753,
                                      1589.1817, 1597.1276, 1605.1132, 1613.1388, 1621.2045,
                                      1629.3105, 1637.4571, 1645.6443, 1653.8726, 1662.1419,
                                      1670.4526, 1674.7007, 1675.0994, 1678.8049, 1687.1989,
                                      1695.6349, 1704.1131, 1712.6337, 1721.1968, 1726.9841,
                                      1727.4159, 1729.8028, 1738.4518, 1747.1441, 1755.8798,
                                      1764.6592, 1773.4825, 1782.3499, 1791.2617, 1800.218,
                                      1809.2191, 1818.2652, 1827.3565, 1836.4933, 1845.6757,
                                      1854.9041, 1864.1786, 1873.4995, 1882.867, 1892.2814,
                                      1901.7428, 1911.2515, 1919.4747, 1920.8077, 1922.5253,
                                      1930.4118, 1940.0638, 1949.7642, 1959.513, 1969.3105,
                                      1979.1571, 1989.0529, 1998.9981, 2008.9931, 2019.0381,
                                      2029.1333, 2039.279, 2049.4754, 2059.7227, 2070.0213,
                                      2080.3714, 2090.7733, 2101.2272, 2111.7333, 2122.292,
                                      2132.9034, 2143.568, 2154.2858, 2165.0572, 2175.8825,
                                      2186.7619, 2197.6957, 2208.6842, 2219.7276, 2230.8263,
                                      2241.9804, 2253.1903, 2264.4562, 2275.7785, 2287.1574,
                                      2298.5932, 2310.0862, 2321.6366, 2333.2448, 2344.911,
                                      2356.6356, 2368.4187, 2380.2608, 2392.1621, 2404.123,
                                      2416.1436, 2428.2243, 2440.3654, 2452.5672, 2464.8301,
                                      2477.1542, 2489.54, 2501.9877, 2514.4976, 2527.0701,
                                      2539.7055, 2552.404, 2565.166, 2577.9919, 2590.8818,
                                      2603.8362, 2616.8554, 2629.9397, 2643.0894, 2656.3048,
                                      2669.5863, 2682.9343, 2696.3489, 2709.8307, 2723.3798,
                                      2736.9967, 2750.6817, 2764.4351, 2778.2573, 2792.1486,
                                      2806.1093, 2820.1399, 2834.2406, 2848.4118, 2862.6539,
                                      2876.9671, 2891.352, 2905.8087, 2920.3378, 2934.9394,
                                      2949.6141, 2964.3622, 2979.184, 2994.0799, 3009.0503,
                                      3024.0956, 3039.2161, 3054.4122, 3069.6842, 3085.0326,
                                      3100.4578, 3115.9601, 3131.5399, 3147.1976, 3162.9336,
                                      3178.7482, 3194.642, 3210.6152, 3226.6683, 3242.8016,
                                      3259.0156, 3275.3107, 3291.6873, 3308.1457, 3324.6864,
                                      3341.3099, 3358.0164, 3374.8065, 3391.6805, 3408.6389,
                                      3425.6821, 3442.8105, 3460.0246, 3477.3247, 3494.7113,
                                      3512.1849, 3529.7458, 3547.3945, 3565.1315, 3582.9572,
                                      3600.8719, 3618.8763, 3636.9707, 3655.1555, 3673.4313,
                                      3691.7985, 3710.2575, 3728.8088, 3747.4528, 3766.1901,
                                      3785.021, 3803.9461, 3822.9659, 3842.0807, 3861.2911,
                                      3880.5975, 3900.0005, 3919.5005, 3939.098, 3958.7935,
                                      3978.5875, 3998.4804]), },
              '37': {'name': 'Rb',
                     'barns': 1419230000000.0,
                     'NumEdges': 9,
                     'M5': {'filename': 'Rb.M5', 'excl before': 5, 'excl after': 50, 'onset': 110.3, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'delayed'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 111.8,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Rb.M3', 'excl before': 5, 'excl after': 50, 'onset': 238.5, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 247.4, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 322.1, 'factor': 1.0},
                     'L3': {'filename': 'Rb.L3', 'excl before': 5, 'excl after': 50, 'onset': 1804.4, 'factor': 1.0,
                            'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1863.8999999999999,
                            'factor': 0.5},
                     'L1': {'filename': 'Rb.L1', 'excl before': 5, 'excl after': 50, 'onset': 2065.1000000000004,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 15199.7, 'factor': 1.0},
                     'dat': np.array([1.63935257e+15, 1.70009562e+15, 1.76225789e+15, 1.83605785e+15,
                                      3.09037332e+15, 3.13195676e+15, 3.59547728e+15, 5.13321299e+15,
                                      9.94255769e+15, 1.69626370e+16, 2.55489785e+16, 3.46575966e+16,
                                      4.30821459e+16, 4.98092961e+16, 5.42387129e+16, 5.62298926e+16,
                                      5.60013966e+16, 5.39875092e+16, 5.33162134e+16, 5.25995023e+16,
                                      5.24008101e+16, 5.58339274e+16, 5.52662354e+16, 5.50945086e+16,
                                      5.45097858e+16, 5.44743051e+16, 5.42571629e+16, 5.54833776e+16,
                                      5.46729973e+16, 5.22730794e+16, 4.80806739e+16, 4.37009302e+16,
                                      4.04821165e+16, 3.95014286e+16, 3.93495710e+16, 3.92431287e+16,
                                      4.06581010e+16, 3.96930246e+16, 3.68786916e+16, 3.28608514e+16,
                                      2.91453073e+16, 2.57505091e+16, 2.26750377e+16, 1.99018623e+16,
                                      1.74125329e+16, 1.51928572e+16, 1.32246690e+16, 1.14862542e+16,
                                      9.95674999e+15, 8.61557764e+15, 7.44315174e+15, 6.42102229e+15,
                                      5.53187469e+15, 4.76023934e+15, 4.09192394e+15, 3.44191660e+15,
                                      2.89806766e+15, 2.44377214e+15, 2.06313465e+15, 1.74224675e+15,
                                      1.47330266e+15, 1.24753155e+15, 1.05786566e+15, 9.64835131e+14,
                                      9.29609842e+14, 9.20540963e+14, 4.41252799e+15, 4.35519110e+15,
                                      4.31062728e+15, 4.20688157e+15, 4.10483893e+15, 4.05218550e+15,
                                      5.64825155e+15, 5.38924208e+15, 5.02861574e+15, 4.51967986e+15,
                                      4.34255995e+15, 4.29728652e+15, 4.87505505e+15, 4.84383199e+15,
                                      4.69779322e+15, 4.11278662e+15, 3.50549810e+15, 2.97328685e+15,
                                      2.51785594e+15, 2.12969654e+15, 1.79461634e+15, 1.50722226e+15,
                                      1.26703177e+15, 1.06066154e+15]),
                     'ene': np.array([110.4581, 110.8515, 111.241, 111.6882, 112.359, 112.506,
                                      114.036, 118.0797, 126.2272, 134.9368, 144.2475, 154.2005,
                                      164.8404, 176.2144, 188.3732, 201.3709, 215.2655, 230.1188,
                                      233.73, 237.3075, 238.2615, 239.6925, 242.452, 243.27,
                                      245.997, 246.163, 247.1526, 248.637, 252.348, 262.9708,
                                      281.1158, 300.5128, 315.658, 320.4895, 321.2482, 321.7779,
                                      323.7105, 328.542, 343.4143, 367.1099, 392.4405, 419.5189,
                                      448.4657, 479.4098, 512.4891, 547.8508, 585.6525, 626.0625,
                                      669.2609, 715.4399, 764.8052, 817.5768, 873.9896, 934.2948,
                                      998.7612, 1067.676, 1141.345, 1220.098, 1304.285, 1394.281,
                                      1490.486, 1593.329, 1703.269, 1768.312, 1795.378, 1802.596,
                                      1813.422, 1820.795, 1826.622, 1840.488, 1854.58, 1862.036,
                                      1873.219, 1901.178, 1946.43, 2023.798, 2054.774, 2063.035,
                                      2075.425, 2080.733, 2106.402, 2224.304, 2377.781, 2541.848,
                                      2717.235, 2904.724, 3105.15, 3319.406, 3548.445, 3793.288]), },
              '38': {'name': 'Sr',
                     'barns': 1454970000000.0002,
                     'NumEdges': 12,
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 19.900000000000002,
                            'factor': 1.0, 'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 19.900000000000002,
                            'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 37.699999999999996,
                            'factor': 1.0},
                     'M5': {'filename': 'Sr.M5', 'excl before': 5, 'excl after': 50, 'onset': 133.1, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'delayed'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 135.0,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Sr.M3', 'excl before': 5, 'excl after': 50, 'onset': 269.1, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 279.8, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 357.5, 'factor': 1.0},
                     'L3': {'filename': 'Sr.L3', 'excl before': 5, 'excl after': 50, 'onset': 1939.6, 'factor': 1.0,
                            'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2006.8000000000002,
                            'factor': 0.5},
                     'L1': {'filename': 'Sr.L1', 'excl before': 5, 'excl after': 50, 'onset': 2216.2999999999997,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 16104.600000000002,
                            'factor': 1.0},
                     'dat': np.array([6.54052664e+17, 6.18653244e+17, 5.61080081e+17, 4.36258205e+17,
                                      3.29361559e+17, 2.41103079e+17, 1.73068682e+17, 1.23000254e+17,
                                      8.72341813e+16, 6.21403137e+16, 4.46908585e+16, 3.70624508e+16,
                                      3.45133434e+16, 3.38731566e+16, 3.37349344e+16, 3.33770118e+16,
                                      3.16019484e+16, 2.51287869e+16, 1.94325793e+16, 1.54605112e+16,
                                      1.26602760e+16, 1.06583827e+16, 9.20210326e+15, 8.11960558e+15,
                                      7.29449210e+15, 6.64775793e+15, 6.12600569e+15, 5.69300662e+15,
                                      5.32548119e+15, 5.00742475e+15, 4.72588806e+15, 4.47199579e+15,
                                      4.23934609e+15, 4.02371954e+15, 3.82147871e+15, 3.72632367e+15,
                                      3.68587550e+15, 3.68296556e+15, 3.67161680e+15, 6.51491917e+15,
                                      6.60978321e+15, 6.71745099e+15, 8.77448758e+15, 8.80169552e+15,
                                      9.44624723e+15, 1.22594317e+16, 1.85217681e+16, 2.64077055e+16,
                                      3.48130672e+16, 4.25316830e+16, 4.85625337e+16, 5.23338159e+16,
                                      5.37465918e+16, 5.30540261e+16, 5.07173443e+16, 5.05893069e+16,
                                      4.98705517e+16, 4.96726758e+16, 5.34643276e+16, 5.27586672e+16,
                                      5.27048333e+16, 5.19409740e+16, 5.17183636e+16, 5.31107699e+16,
                                      5.30947652e+16, 5.22552476e+16, 4.91430667e+16, 4.48523602e+16,
                                      4.04758104e+16, 3.91794322e+16, 3.82031473e+16, 3.79470726e+16,
                                      3.92187164e+16, 3.82628011e+16, 3.78335849e+16, 3.37014701e+16,
                                      2.98676242e+16, 2.63596915e+16, 2.31849470e+16, 2.03346607e+16,
                                      1.77884632e+16, 1.55201650e+16, 1.35076505e+16, 1.17315686e+16,
                                      1.01699493e+16, 8.80125903e+15, 7.60571018e+15, 6.56409716e+15,
                                      5.65896032e+15, 4.87385851e+15, 4.14288158e+15, 3.50094881e+15,
                                      2.95329811e+15, 2.49483706e+15, 2.11072498e+15, 1.78699415e+15,
                                      1.51418728e+15, 1.28488401e+15, 1.09175129e+15, 9.83632469e+14,
                                      9.48189399e+14, 9.39052188e+14, 4.05791133e+15, 4.04161567e+15,
                                      3.94486016e+15, 3.88142347e+15, 3.78466796e+15, 3.74334682e+15,
                                      5.16848993e+15, 4.96610360e+15, 4.75513295e+15, 4.25040386e+15,
                                      4.08657424e+15, 4.04438011e+15, 4.59755970e+15, 4.58170053e+15,
                                      4.41525196e+15, 3.89655516e+15, 3.31122073e+15, 2.80678263e+15,
                                      2.37814847e+15, 2.00436667e+15, 1.68325479e+15, 1.41474008e+15,
                                      1.19007816e+15]),
                     'ene': np.array([19.9995, 20.298, 20.83314, 22.27063, 23.8073,
                                      25.45001, 27.20606, 29.08327, 31.09002, 33.23523,
                                      35.52846, 36.946, 37.5115, 37.6623, 37.8885,
                                      37.97993, 38.454, 40.60054, 43.40198, 46.39671,
                                      49.59809, 53.02035, 56.67876, 60.58959, 64.77028,
                                      69.23942, 74.01695, 79.12411, 84.58368, 90.41995,
                                      96.65893, 103.3284, 110.4581, 118.0797, 126.2272,
                                      130.438, 132.3, 132.4345, 132.9669, 133.7655,
                                      134.325, 134.9368, 135.675, 135.762, 137.7,
                                      144.2475, 154.2005, 164.8404, 176.2144, 188.3732,
                                      201.3709, 215.2655, 230.1188, 245.997, 262.9708,
                                      263.718, 267.7545, 268.8309, 270.4455, 274.204,
                                      274.482, 278.401, 279.5202, 281.1158, 281.199,
                                      285.396, 300.5128, 321.2482, 343.4143, 350.35,
                                      355.7125, 357.1425, 359.2875, 364.65, 367.1099,
                                      392.4405, 419.5189, 448.4657, 479.4098, 512.4891,
                                      547.8508, 585.6525, 626.0625, 669.2609, 715.4399,
                                      764.8052, 817.5768, 873.9896, 934.2948, 998.7612,
                                      1067.676, 1141.345, 1220.098, 1304.285, 1394.281,
                                      1490.486, 1593.329, 1703.269, 1820.795, 1900.808,
                                      1929.902, 1937.66, 1946.43, 1949.298, 1966.664,
                                      1978.392, 1996.766, 2004.793, 2016.834, 2046.936,
                                      2080.733, 2171.974, 2205.219, 2214.084, 2224.304,
                                      2227.382, 2260.626, 2377.781, 2541.848, 2717.235,
                                      2904.724, 3105.15, 3319.406, 3548.445, 3793.288]), },
              '39': {'name': 'Y',
                     'barns': 1476320000000.0,
                     'NumEdges': 12,
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 25.6, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 25.6, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 45.400000000000006,
                            'factor': 1.0},
                     'M5': {'filename': 'Y.M5', 'excl before': 5, 'excl after': 50, 'onset': 157.4, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 159.6,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Y.M3', 'excl before': 5, 'excl after': 50, 'onset': 300.3, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 312.40000000000003,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 393.6, 'factor': 1.0},
                     'L3': {'filename': 'Y.L3', 'excl before': 5, 'excl after': 50, 'onset': 2080.0, 'factor': 1.0,
                            'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2155.5, 'factor': 0.5},
                     'L1': {'filename': 'Y.L1', 'excl before': 5, 'excl after': 50, 'onset': 2372.5, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 17038.399999999998,
                            'factor': 1.0},
                     'dat': np.array([2.69192189e+17, 2.53410328e+17, 2.14405954e+17, 1.63118597e+17,
                                      1.22355925e+17, 9.09117856e+16, 6.73674342e+16, 5.00723454e+16,
                                      3.75014806e+16, 2.84043968e+16, 2.57056838e+16, 2.42057427e+16,
                                      2.38278048e+16, 2.45644885e+16, 2.32992822e+16, 2.31427923e+16,
                                      1.85130528e+16, 1.51691880e+16, 1.27202684e+16, 1.09039519e+16,
                                      9.53510798e+15, 8.48382051e+15, 7.65929579e+15, 6.99746154e+15,
                                      6.45358525e+15, 5.99607368e+15, 5.60278203e+15, 5.25806131e+15,
                                      4.95098675e+15, 4.67299570e+15, 4.41759234e+15, 4.17990482e+15,
                                      3.95638997e+15, 3.74409515e+15, 3.74306173e+15, 3.70024845e+15,
                                      3.69611475e+15, 3.68386130e+15, 7.83601130e+15, 7.94806398e+15,
                                      8.06764590e+15, 1.10514363e+16, 1.11008930e+16, 1.18817186e+16,
                                      1.26623966e+16, 1.83654208e+16, 2.58798896e+16, 3.36837171e+16,
                                      4.06002763e+16, 4.57275357e+16, 4.86196466e+16, 4.92898958e+16,
                                      4.80645502e+16, 4.63741638e+16, 4.56950566e+16, 4.55075640e+16,
                                      4.97076944e+16, 4.95039622e+16, 4.87938523e+16, 4.87687549e+16,
                                      4.80010685e+16, 4.77870021e+16, 4.92515115e+16, 4.84321539e+16,
                                      4.79715421e+16, 4.39825254e+16, 3.97942056e+16, 3.66954099e+16,
                                      3.57579467e+16, 3.56309832e+16, 3.55114013e+16, 3.67072205e+16,
                                      3.57889494e+16, 3.31345261e+16, 2.93433363e+16, 2.58695554e+16,
                                      2.27146595e+16, 1.98830778e+16, 1.73615232e+16, 1.51263747e+16,
                                      1.31494346e+16, 1.14056054e+16, 9.87421869e+15, 8.53445829e+15,
                                      7.36624627e+15, 6.35024285e+15, 5.46917507e+15, 4.64214061e+15,
                                      3.94266019e+15, 3.34770323e+15, 2.82730043e+15, 2.38868576e+15,
                                      2.02093445e+15, 1.71208830e+15, 1.45106016e+15, 1.23153138e+15,
                                      1.04663706e+15, 9.35942590e+14, 9.02282494e+14, 8.93601733e+14,
                                      3.81067718e+15, 3.76048230e+15, 3.64931541e+15, 3.60414002e+15,
                                      3.49385891e+15, 3.45399827e+15, 4.76644675e+15, 4.57245830e+15,
                                      4.42969816e+15, 3.93734544e+15, 3.78498922e+15, 3.74586674e+15,
                                      4.27557035e+15, 4.24619158e+15, 4.09250667e+15, 3.62687534e+15,
                                      3.08506590e+15, 2.61722010e+15, 2.20768893e+15, 1.85351976e+15,
                                      1.55736997e+15, 1.30961395e+15]),
                     'ene': np.array([25.728, 26.112, 27.20606, 29.08327, 31.09002,
                                      33.23523, 35.52846, 37.97993, 40.60054, 43.40198,
                                      44.492, 45.173, 45.3546, 45.627, 46.308,
                                      46.39671, 49.59809, 53.02035, 56.67876, 60.58959,
                                      64.77028, 69.23942, 74.01695, 79.12411, 84.58368,
                                      90.41995, 96.65893, 103.3284, 110.4581, 118.0797,
                                      126.2272, 134.9368, 144.2475, 154.2005, 154.252,
                                      156.408, 156.613, 157.2426, 158.187, 158.802,
                                      159.4404, 160.398, 160.548, 162.792, 164.8404,
                                      176.2144, 188.3732, 201.3709, 215.2655, 230.1188,
                                      245.997, 262.9708, 281.1158, 294.294, 298.7985,
                                      299.9997, 300.5128, 301.8015, 306.152, 306.306,
                                      310.838, 312.0876, 313.962, 318.648, 321.2482,
                                      343.4143, 367.1099, 385.728, 391.632, 392.4405,
                                      393.2064, 395.568, 401.472, 419.5189, 448.4657,
                                      479.4098, 512.4891, 547.8508, 585.6525, 626.0625,
                                      669.2609, 715.4399, 764.8052, 817.5768, 873.9896,
                                      934.2948, 998.7612, 1067.676, 1141.345, 1220.098,
                                      1304.285, 1394.281, 1490.486, 1593.329, 1703.269,
                                      1820.795, 1946.43, 2038.4, 2069.6, 2077.92,
                                      2080.733, 2090.4, 2112.39, 2121.6, 2144.722,
                                      2153.344, 2166.277, 2198.61, 2224.304, 2325.05,
                                      2360.637, 2370.127, 2377.781, 2384.362, 2419.95,
                                      2541.848, 2717.235, 2904.724, 3105.15, 3319.406,
                                      3548.445, 3793.288]), },
              '40': {'name': 'Zr',
                     'barns': 1514740000000.0,
                     'NumEdges': 13,
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4.0234499999999995,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 28.7, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 28.7, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 51.3, 'factor': 1.0},
                     'M5': {'filename': 'Zr.M5', 'excl before': 5, 'excl after': 50, 'onset': 180.0, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 182.4,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Zr.M3', 'excl before': 5, 'excl after': 50, 'onset': 330.5, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 344.2, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 430.3, 'factor': 1.0},
                     'L3': {'filename': 'Zr.L3', 'excl before': 5, 'excl after': 50, 'onset': 2222.3, 'factor': 1.0,
                            'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2306.7000000000003,
                            'factor': 0.5},
                     'L1': {'filename': 'Zr.L1', 'excl before': 5, 'excl after': 50, 'onset': 2531.6, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 17997.6, 'factor': 1.0},
                     'dat': np.array([2.45418175e+17, 2.36753862e+17, 2.19925101e+17, 1.96885905e+17,
                                      1.70135597e+17, 1.42235601e+17, 1.15358054e+17, 9.10237561e+16,
                                      7.01248883e+16, 5.29750020e+16, 3.94089906e+16, 2.89875794e+16,
                                      2.11639473e+16, 1.53912731e+16, 1.11849916e+16, 9.54634590e+15,
                                      8.88243536e+15, 8.71520806e+15, 1.91387399e+17, 1.84677101e+17,
                                      1.79542132e+17, 1.38577504e+17, 1.03959636e+17, 7.79061077e+16,
                                      5.85765105e+16, 4.43621904e+16, 3.39498676e+16, 2.63170928e+16,
                                      2.07004368e+16, 1.97537243e+16, 1.87585402e+16, 1.85055786e+16,
                                      1.96749579e+16, 1.88327624e+16, 1.81314378e+16, 1.51580032e+16,
                                      1.29446651e+16, 1.12664846e+16, 9.97441143e+15, 8.96180774e+15,
                                      8.16247944e+15, 7.51417072e+15, 6.97340854e+15, 6.51262463e+15,
                                      6.11167295e+15, 5.75646642e+15, 5.43625039e+15, 5.14329967e+15,
                                      4.87140384e+15, 4.61586720e+15, 4.37335733e+15, 4.14129916e+15,
                                      3.91802648e+15, 3.91469406e+15, 3.87122102e+15, 3.86485911e+15,
                                      3.85183235e+15, 8.94666034e+15, 9.04966266e+15, 9.18053619e+15,
                                      1.28171240e+16, 1.29081599e+16, 1.37174854e+16, 1.45487748e+16,
                                      2.04580784e+16, 2.77788169e+16, 3.48435642e+16, 4.05889730e+16,
                                      4.43424988e+16, 4.59057104e+16, 4.54755243e+16, 4.34760675e+16,
                                      4.31473689e+16, 4.24975454e+16, 4.23172914e+16, 4.64040599e+16,
                                      4.56572931e+16, 4.48832609e+16, 4.47408754e+16, 4.46742268e+16,
                                      4.61768489e+16, 4.53740367e+16, 4.28338177e+16, 3.88333894e+16,
                                      3.47981220e+16, 3.44891151e+16, 3.35878448e+16, 3.33515453e+16,
                                      3.44785119e+16, 3.35954185e+16, 3.23336400e+16, 2.86088944e+16,
                                      2.51886115e+16, 2.20909682e+16, 1.93083908e+16, 1.68348204e+16,
                                      1.46470814e+16, 1.27209380e+16, 1.10238233e+16, 9.53377356e+15,
                                      8.23276337e+15, 7.10094965e+15, 6.11954960e+15, 5.19222577e+15,
                                      4.40804487e+15, 3.74595202e+15, 3.18716443e+15, 2.70153879e+15,
                                      2.28498529e+15, 1.93568625e+15, 1.64212963e+15, 1.39334874e+15,
                                      1.18343607e+15, 1.00643870e+15, 9.01573248e+14, 8.69248696e+14,
                                      8.60917626e+14, 3.56085079e+15, 3.51813512e+15, 3.39498676e+15,
                                      3.36787292e+15, 3.24639077e+15, 3.20837079e+15, 4.42167753e+15,
                                      4.23839399e+15, 4.11615448e+15, 3.67294155e+15, 3.53085894e+15,
                                      3.49450518e+15, 3.97134533e+15, 3.96195394e+15, 3.81926544e+15,
                                      3.37211419e+15, 2.86906903e+15, 2.42252368e+15, 2.03641646e+15,
                                      1.71059588e+15, 1.43780636e+15]),
                     'ene': np.array([10.69, 11.42761, 12.21612, 13.05903, 13.9601,
                                      14.92335, 15.95306, 17.05382, 18.23053, 19.48844,
                                      20.83314, 22.27063, 23.8073, 25.45001, 27.20606,
                                      28.126, 28.5565, 28.6713, 28.8435, 29.08327,
                                      29.274, 31.09002, 33.23523, 35.52846, 37.97993,
                                      40.60054, 43.40198, 46.39671, 49.59809, 50.274,
                                      51.0435, 51.2487, 51.5565, 52.326, 53.02035,
                                      56.67876, 60.58959, 64.77028, 69.23942, 74.01695,
                                      79.12411, 84.58368, 90.41995, 96.65893, 103.3284,
                                      110.4581, 118.0797, 126.2272, 134.9368, 144.2475,
                                      154.2005, 164.8404, 176.2144, 176.4, 178.752,
                                      179.1, 179.82, 180.9, 181.488, 182.2176,
                                      183.312, 183.6, 186.048, 188.3732, 201.3709,
                                      215.2655, 230.1188, 245.997, 262.9708, 281.1158,
                                      300.5128, 321.2482, 323.89, 328.8475, 330.1695,
                                      332.1525, 337.316, 342.479, 343.4143, 343.8558,
                                      345.921, 351.084, 367.1099, 392.4405, 419.5189,
                                      421.694, 428.1485, 429.8697, 432.4515, 438.906,
                                      448.4657, 479.4098, 512.4891, 547.8508, 585.6525,
                                      626.0625, 669.2609, 715.4399, 764.8052, 817.5768,
                                      873.9896, 934.2948, 998.7612, 1067.676, 1141.345,
                                      1220.098, 1304.285, 1394.281, 1490.486, 1593.329,
                                      1703.269, 1820.795, 1946.43, 2080.733, 2177.854,
                                      2211.189, 2220.078, 2224.304, 2233.412, 2260.566,
                                      2266.746, 2295.166, 2304.393, 2318.233, 2352.834,
                                      2377.781, 2480.968, 2518.942, 2529.068, 2541.848,
                                      2544.258, 2582.232, 2717.235, 2904.724, 3105.15,
                                      3319.406, 3548.445, 3793.288]), },
              '41': {'name': 'Nb',
                     'barns': 1542750000000.0,
                     'NumEdges': 13,
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.2,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 33.9, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 33.9, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 58.1, 'factor': 1.0},
                     'M5': {'filename': 'Nb.M5', 'excl before': 5, 'excl after': 50, 'onset': 204.6, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 207.4,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Nb.M3', 'excl before': 5, 'excl after': 50, 'onset': 363.0, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 378.40000000000003,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 468.4, 'factor': 1.0},
                     'L3': {'filename': 'Nb.L3', 'excl before': 5, 'excl after': 50, 'onset': 2370.5, 'factor': 1.0,
                            'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2464.7000000000003,
                            'factor': 0.5},
                     'L1': {'filename': 'Nb.L1', 'excl before': 5, 'excl after': 50, 'onset': 2697.7000000000003,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 18985.600000000002,
                            'factor': 1.0},
                     'dat': np.array([2.89327335e+17, 2.62483485e+17, 2.33927182e+17, 2.05031475e+17,
                                      1.76922570e+17, 1.50578571e+17, 1.26673660e+17, 1.05558040e+17,
                                      8.73088508e+16, 7.18196408e+16, 5.88605408e+16, 4.81445992e+16,
                                      3.93617235e+16, 3.22079918e+16, 2.64103372e+16, 2.17219200e+16,
                                      1.79375542e+16, 1.48796695e+16, 1.42855564e+16, 1.41292759e+16,
                                      1.92874605e+17, 1.78156770e+17, 1.54125353e+17, 1.08311849e+17,
                                      7.75540425e+16, 5.68765642e+16, 4.27094910e+16, 3.28189208e+16,
                                      2.57839808e+16, 2.06867348e+16, 2.03936122e+16, 1.94556202e+16,
                                      1.92195795e+16, 2.02671068e+16, 1.94772188e+16, 1.84034648e+16,
                                      1.57962172e+16, 1.38341478e+16, 1.23225614e+16, 1.11327926e+16,
                                      1.01750534e+16, 9.38609100e+15, 8.72116575e+15, 8.14849695e+15,
                                      7.64494335e+15, 7.19384325e+15, 6.78331747e+15, 6.40441808e+15,
                                      6.05004840e+15, 5.71480882e+15, 5.39484248e+15, 5.08768095e+15,
                                      4.79131868e+15, 4.52272590e+15, 4.50452145e+15, 4.46533560e+15,
                                      4.45854750e+15, 4.44173152e+15, 8.98759868e+15, 9.09003728e+15,
                                      9.20790338e+15, 1.24825445e+16, 1.25474943e+16, 1.33113098e+16,
                                      1.44120619e+16, 2.01483150e+16, 2.71092030e+16, 3.36535485e+16,
                                      3.87291960e+16, 4.17344730e+16, 4.25814428e+16, 4.15663132e+16,
                                      4.04401058e+16, 3.98554035e+16, 3.96934148e+16, 4.38110145e+16,
                                      4.35317768e+16, 4.31399182e+16, 4.30674090e+16, 4.23346028e+16,
                                      4.21340452e+16, 4.36521112e+16, 4.28807362e+16, 4.19828558e+16,
                                      3.81753488e+16, 3.42320798e+16, 3.28682888e+16, 3.19873785e+16,
                                      3.17575088e+16, 3.27988650e+16, 3.19380105e+16, 3.17405385e+16,
                                      2.80348530e+16, 2.46315465e+16, 2.15537602e+16, 1.88045798e+16,
                                      1.63608638e+16, 1.42062591e+16, 1.23154647e+16, 1.06585512e+16,
                                      9.20713200e+15, 7.94192272e+15, 6.84379328e+15, 5.80691100e+15,
                                      4.92924052e+15, 4.18779488e+15, 3.56112983e+15, 3.03165802e+15,
                                      2.57839808e+15, 2.18391690e+15, 1.85114573e+15, 1.57144515e+15,
                                      1.33467931e+15, 1.13427608e+15, 9.65159828e+14, 8.69385908e+14,
                                      8.38299495e+14, 8.30292623e+14, 3.31320990e+15, 3.29438835e+15,
                                      3.16279178e+15, 3.15307245e+15, 3.02379000e+15, 2.98815248e+15,
                                      4.11142875e+15, 3.94188052e+15, 3.82355160e+15, 3.44249235e+15,
                                      3.31012440e+15, 3.27618390e+15, 3.71401635e+15, 3.69380633e+15,
                                      3.58118558e+15, 3.14026762e+15, 2.66078092e+15, 2.23698750e+15,
                                      1.87937805e+15, 1.57900462e+15, 1.32724325e+15, 1.11636476e+15,
                                      9.39781590e+14, 7.88484098e+14, 6.58970235e+14, 5.50021230e+14,
                                      4.59060690e+14, 3.83481368e+14, 3.20598878e+14, 2.67991102e+14,
                                      2.24192430e+14, 1.87721820e+14, 1.56943958e+14, 1.30209643e+14,
                                      1.08102035e+14, 8.94671580e+13, 7.40180595e+13, 6.10450748e+13,
                                      5.03908432e+13, 4.16357370e+13, 3.44326372e+13, 2.84992208e+13,
                                      2.36102460e+13, 2.01976830e+13, 1.95774975e+13, 1.93568842e+13,
                                      1.91408992e+13, 1.34168339e+14, 1.28622153e+14, 1.15636826e+14,
                                      9.68893282e+13, 8.14556572e+13, 6.84857580e+13, 5.73671588e+13,
                                      4.78206218e+13, 3.98106638e+13, 3.31459838e+13, 2.76013402e+13,
                                      2.29869750e+13, 1.90745610e+13, 1.57669050e+13, 1.30328435e+13,
                                      1.07741032e+13, 8.90722140e+12, 7.36354575e+12, 6.08661158e+12,
                                      5.02874790e+12, 4.15508857e+12, 3.43339012e+12, 2.83727152e+12,
                                      2.34174022e+12, 1.92334642e+12, 1.57931318e+12, 1.29688193e+12,
                                      1.06502203e+12, 8.74662112e+11, 7.18366110e+11, 5.90024738e+11,
                                      4.84624058e+11, 3.98075782e+11, 3.27001290e+11, 2.68623630e+11,
                                      2.20674960e+11, 1.81288552e+11, 1.48946342e+11, 1.22374016e+11,
                                      1.00547188e+11, 8.26158052e+10, 6.78840855e+10, 5.57812118e+10,
                                      4.58381880e+10, 3.76677840e+10, 3.09552788e+10, 2.54399475e+10,
                                      2.09073480e+10, 1.71831495e+10]),
                     'ene': np.array([1.069000e+01, 1.142761e+01, 1.221612e+01, 1.305903e+01,
                                      1.396010e+01, 1.492335e+01, 1.595306e+01, 1.705382e+01,
                                      1.823053e+01, 1.948844e+01, 2.083314e+01, 2.227063e+01,
                                      2.380730e+01, 2.545001e+01, 2.720606e+01, 2.908327e+01,
                                      3.109002e+01, 3.323523e+01, 3.373050e+01, 3.386610e+01,
                                      3.406950e+01, 3.457800e+01, 3.552846e+01, 3.797993e+01,
                                      4.060054e+01, 4.340198e+01, 4.639671e+01, 4.959809e+01,
                                      5.302035e+01, 5.667876e+01, 5.693800e+01, 5.780950e+01,
                                      5.804190e+01, 5.839050e+01, 5.926200e+01, 6.058959e+01,
                                      6.477028e+01, 6.923942e+01, 7.401695e+01, 7.912411e+01,
                                      8.458368e+01, 9.041995e+01, 9.665893e+01, 1.033284e+02,
                                      1.104581e+02, 1.180797e+02, 1.262272e+02, 1.349368e+02,
                                      1.442475e+02, 1.542005e+02, 1.648404e+02, 1.762144e+02,
                                      1.883732e+02, 2.005080e+02, 2.013709e+02, 2.032520e+02,
                                      2.035770e+02, 2.043954e+02, 2.056230e+02, 2.063630e+02,
                                      2.071926e+02, 2.084370e+02, 2.086920e+02, 2.115480e+02,
                                      2.152655e+02, 2.301188e+02, 2.459970e+02, 2.629708e+02,
                                      2.811158e+02, 3.005128e+02, 3.212482e+02, 3.434143e+02,
                                      3.557400e+02, 3.611850e+02, 3.626370e+02, 3.648150e+02,
                                      3.671099e+02, 3.702600e+02, 3.708320e+02, 3.765080e+02,
                                      3.780216e+02, 3.802920e+02, 3.859680e+02, 3.924405e+02,
                                      4.195189e+02, 4.484657e+02, 4.590320e+02, 4.660580e+02,
                                      4.679316e+02, 4.707420e+02, 4.777680e+02, 4.794098e+02,
                                      5.124891e+02, 5.478508e+02, 5.856525e+02, 6.260625e+02,
                                      6.692609e+02, 7.154399e+02, 7.648052e+02, 8.175768e+02,
                                      8.739896e+02, 9.342948e+02, 9.987612e+02, 1.067676e+03,
                                      1.141345e+03, 1.220098e+03, 1.304285e+03, 1.394281e+03,
                                      1.490486e+03, 1.593329e+03, 1.703269e+03, 1.820795e+03,
                                      1.946430e+03, 2.080733e+03, 2.224304e+03, 2.323090e+03,
                                      2.358648e+03, 2.368130e+03, 2.377781e+03, 2.382353e+03,
                                      2.415406e+03, 2.417910e+03, 2.452376e+03, 2.462235e+03,
                                      2.477023e+03, 2.513994e+03, 2.541848e+03, 2.643746e+03,
                                      2.684212e+03, 2.695002e+03, 2.711189e+03, 2.717235e+03,
                                      2.751654e+03, 2.904724e+03, 3.105150e+03, 3.319406e+03,
                                      3.548445e+03, 3.793288e+03, 4.055024e+03, 4.334821e+03,
                                      4.633924e+03, 4.953664e+03, 5.295467e+03, 5.660855e+03,
                                      6.051453e+03, 6.469004e+03, 6.915365e+03, 7.392525e+03,
                                      7.902609e+03, 8.447890e+03, 9.030794e+03, 9.653919e+03,
                                      1.032004e+04, 1.103212e+04, 1.179334e+04, 1.260708e+04,
                                      1.347697e+04, 1.440688e+04, 1.540095e+04, 1.646362e+04,
                                      1.759961e+04, 1.860589e+04, 1.881398e+04, 1.889067e+04,
                                      1.896661e+04, 1.908053e+04, 1.936531e+04, 2.011215e+04,
                                      2.149988e+04, 2.298338e+04, 2.456923e+04, 2.626450e+04,
                                      2.807676e+04, 3.001405e+04, 3.208502e+04, 3.429889e+04,
                                      3.666551e+04, 3.919543e+04, 4.189992e+04, 4.479101e+04,
                                      4.788159e+04, 5.118542e+04, 5.471721e+04, 5.849270e+04,
                                      6.252870e+04, 6.684318e+04, 7.145536e+04, 7.638578e+04,
                                      8.165640e+04, 8.729069e+04, 9.331374e+04, 9.975239e+04,
                                      1.066353e+05, 1.139931e+05, 1.218587e+05, 1.302669e+05,
                                      1.392553e+05, 1.488640e+05, 1.591356e+05, 1.701159e+05,
                                      1.818539e+05, 1.944018e+05, 2.078156e+05, 2.221548e+05,
                                      2.374835e+05, 2.538699e+05, 2.713869e+05, 2.901126e+05,
                                      3.101304e+05, 3.315294e+05, 3.544049e+05, 3.788588e+05,
                                      4.050001e+05, 4.329451e+05]), },
              '42': {'name': 'Mo',
                     'barns': 1593120000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1.8, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1.8,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 34.8, 'factor': 1.0,
                            'twin': 'N2', 'shape': 'delayed'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 34.8, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 61.800000000000004,
                            'factor': 1.0},
                     'M5': {'filename': 'Mo.M5', 'excl before': 5, 'excl after': 50, 'onset': 227.0, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 230.3,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Mo.M3', 'excl before': 5, 'excl after': 50, 'onset': 392.29999999999995,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 409.7, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 504.6, 'factor': 1.0},
                     'L3': {'filename': 'Mo.L3', 'excl before': 5, 'excl after': 50, 'onset': 2520.2, 'factor': 1.0,
                            'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2625.1000000000004,
                            'factor': 0.5},
                     'L1': {'filename': 'Mo.L1', 'excl before': 5, 'excl after': 50, 'onset': 2865.5, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 19999.5, 'factor': 1.0},
                     'dat': np.array([2.76294802e+17, 2.66592701e+17, 2.56412664e+17, 2.45802485e+17,
                                      2.34841819e+17, 2.23610323e+17, 2.12219515e+17, 2.00733120e+17,
                                      1.89262656e+17, 1.77887779e+17, 1.66704077e+17, 1.55786425e+17,
                                      1.45196957e+17, 1.34994616e+17, 1.25225604e+17, 1.15928156e+17,
                                      1.07126168e+17, 9.88371648e+16, 9.54613435e+16, 9.31799957e+16,
                                      9.25841688e+16, 2.38936138e+17, 2.25060062e+17, 1.76039760e+17,
                                      1.40049586e+17, 1.13739209e+17, 9.39829282e+16, 7.87654459e+16,
                                      6.67708454e+16, 5.71245038e+16, 4.92337805e+16, 4.76804885e+16,
                                      4.72694635e+16, 4.81616107e+16, 4.67293958e+16, 4.42536874e+16,
                                      3.88785005e+16, 3.43317360e+16, 3.04429301e+16, 2.70957850e+16,
                                      2.41947134e+16, 2.16680251e+16, 1.94551814e+16, 1.75115750e+16,
                                      1.57964220e+16, 1.42783380e+16, 1.29300805e+16, 1.17287088e+16,
                                      1.06535121e+16, 9.68776272e+15, 8.81744126e+15, 8.03043998e+15,
                                      7.31656291e+15, 6.66704789e+15, 6.36849720e+15, 6.24168485e+15,
                                      6.23499374e+15, 6.20026373e+15, 1.11499283e+16, 1.12611280e+16,
                                      1.13713719e+16, 1.49283310e+16, 1.49476077e+16, 1.57161288e+16,
                                      1.88258990e+16, 2.49944597e+16, 3.12363038e+16, 3.63215429e+16,
                                      3.95269003e+16, 4.06468637e+16, 3.99028766e+16, 3.85280141e+16,
                                      3.79576771e+16, 3.77983651e+16, 4.21252790e+16, 4.19261390e+16,
                                      4.12618080e+16, 4.11040891e+16, 4.03760333e+16, 4.01768933e+16,
                                      4.16951366e+16, 4.09272528e+16, 4.07217403e+16, 3.70177363e+16,
                                      3.31671653e+16, 3.13924296e+16, 3.05337379e+16, 3.03091080e+16,
                                      3.12936562e+16, 3.06962362e+16, 3.04556750e+16, 2.70671088e+16,
                                      2.37406742e+16, 2.07424224e+16, 1.80723533e+16, 1.57008348e+16,
                                      1.36089090e+16, 1.17793700e+16, 1.01793996e+16, 8.78494162e+15,
                                      7.57480766e+15, 6.42218534e+15, 5.44878902e+15, 4.62753566e+15,
                                      3.93452846e+15, 3.34921618e+15, 2.85455242e+15, 2.43365011e+15,
                                      2.06563939e+15, 1.75306925e+15, 1.48988582e+15, 1.26699240e+15,
                                      1.07787313e+15, 9.18051331e+14, 8.38363469e+14, 8.08540262e+14,
                                      8.00845493e+14, 3.07265054e+15, 3.04174402e+15, 2.94026227e+15,
                                      2.81695478e+15, 2.78525170e+15, 3.82332869e+15, 3.67198229e+15,
                                      3.53003530e+15, 3.23960952e+15, 3.11693928e+15, 3.08539550e+15,
                                      3.49657978e+15, 3.42377419e+15, 3.37247573e+15, 2.90218670e+15,
                                      2.44974062e+15, 2.05847035e+15, 1.72789795e+15, 1.45166688e+15,
                                      1.22036178e+15, 1.02635163e+15, 8.63917114e+14, 7.24519114e+14,
                                      6.05831674e+14, 5.05831531e+14, 4.22479493e+14, 3.53194704e+14,
                                      2.95523760e+14, 2.47236293e+14, 2.06978150e+14, 1.73044694e+14,
                                      1.43583126e+14, 1.19208390e+14, 9.90155942e+13, 8.20010726e+13,
                                      6.78637258e+13, 5.60077267e+13, 4.62673910e+13, 3.82555906e+13,
                                      3.16568875e+13, 2.62211621e+13, 2.17365293e+13, 1.93850842e+13,
                                      1.85805586e+13, 1.83734530e+13, 1.26651447e+14, 1.21660202e+14,
                                      1.05211238e+14, 8.82907104e+13, 7.42441714e+13, 6.23563099e+13,
                                      5.20058093e+13, 4.33121534e+13, 3.60777955e+13, 3.00558019e+13,
                                      2.50406602e+13, 2.08650926e+13, 1.72933176e+13, 1.42995265e+13,
                                      1.18250925e+13, 9.77952643e+12, 8.08827024e+12, 6.68935157e+12,
                                      5.53115333e+12, 4.57161715e+12, 3.77872133e+12, 3.12363038e+12,
                                      2.57862403e+12, 2.12171722e+12, 1.74303259e+12, 1.43213522e+12,
                                      1.17672623e+12, 9.66912322e+11, 7.94552669e+11, 6.52940232e+11,
                                      5.36594678e+11, 4.40991547e+11, 3.62450731e+11, 2.97897509e+11,
                                      2.44862544e+11, 2.01274781e+11, 1.65445512e+11, 1.36004654e+11,
                                      1.11805162e+11, 9.19150584e+10, 7.55664610e+10, 6.21269006e+10,
                                      5.10802066e+10, 4.19978294e+10, 3.45324691e+10, 2.83941778e+10,
                                      2.33487667e+10, 1.91986891e+10]),
                     'ene': np.array([1.069000e+01, 1.142761e+01, 1.221612e+01, 1.305903e+01,
                                      1.396010e+01, 1.492335e+01, 1.595306e+01, 1.705382e+01,
                                      1.823053e+01, 1.948844e+01, 2.083314e+01, 2.227063e+01,
                                      2.380730e+01, 2.545001e+01, 2.720606e+01, 2.908327e+01,
                                      3.109002e+01, 3.323523e+01, 3.410400e+01, 3.462600e+01,
                                      3.476520e+01, 3.497400e+01, 3.552846e+01, 3.797993e+01,
                                      4.060054e+01, 4.340198e+01, 4.639671e+01, 4.959809e+01,
                                      5.302035e+01, 5.667876e+01, 6.058959e+01, 6.149100e+01,
                                      6.173820e+01, 6.210900e+01, 6.303600e+01, 6.477028e+01,
                                      6.923942e+01, 7.401695e+01, 7.912411e+01, 8.458368e+01,
                                      9.041995e+01, 9.665893e+01, 1.033284e+02, 1.104581e+02,
                                      1.180797e+02, 1.262272e+02, 1.349368e+02, 1.442475e+02,
                                      1.542005e+02, 1.648404e+02, 1.762144e+02, 1.883732e+02,
                                      2.013709e+02, 2.152655e+02, 2.224600e+02, 2.256940e+02,
                                      2.258650e+02, 2.267730e+02, 2.281350e+02, 2.291485e+02,
                                      2.301188e+02, 2.314515e+02, 2.315400e+02, 2.349060e+02,
                                      2.459970e+02, 2.629708e+02, 2.811158e+02, 3.005128e+02,
                                      3.212482e+02, 3.434143e+02, 3.671099e+02, 3.844540e+02,
                                      3.903385e+02, 3.919077e+02, 3.924405e+02, 3.942615e+02,
                                      4.001460e+02, 4.015060e+02, 4.076515e+02, 4.092903e+02,
                                      4.117485e+02, 4.178940e+02, 4.195189e+02, 4.484657e+02,
                                      4.794098e+02, 4.945080e+02, 5.020770e+02, 5.040954e+02,
                                      5.071230e+02, 5.124891e+02, 5.146920e+02, 5.478508e+02,
                                      5.856525e+02, 6.260625e+02, 6.692609e+02, 7.154399e+02,
                                      7.648052e+02, 8.175768e+02, 8.739896e+02, 9.342948e+02,
                                      9.987612e+02, 1.067676e+03, 1.141345e+03, 1.220098e+03,
                                      1.304285e+03, 1.394281e+03, 1.490486e+03, 1.593329e+03,
                                      1.703269e+03, 1.820795e+03, 1.946430e+03, 2.080733e+03,
                                      2.224304e+03, 2.377781e+03, 2.469796e+03, 2.507599e+03,
                                      2.517680e+03, 2.532801e+03, 2.541848e+03, 2.572598e+03,
                                      2.611974e+03, 2.622475e+03, 2.638225e+03, 2.677602e+03,
                                      2.717235e+03, 2.808190e+03, 2.851172e+03, 2.862634e+03,
                                      2.879827e+03, 2.904724e+03, 2.922810e+03, 3.105150e+03,
                                      3.319406e+03, 3.548445e+03, 3.793288e+03, 4.055024e+03,
                                      4.334821e+03, 4.633924e+03, 4.953664e+03, 5.295467e+03,
                                      5.660855e+03, 6.051453e+03, 6.469004e+03, 6.915365e+03,
                                      7.392525e+03, 7.902609e+03, 8.447890e+03, 9.030794e+03,
                                      9.653919e+03, 1.032004e+04, 1.103212e+04, 1.179334e+04,
                                      1.260708e+04, 1.347697e+04, 1.440688e+04, 1.540095e+04,
                                      1.646362e+04, 1.759961e+04, 1.881398e+04, 1.959951e+04,
                                      1.989950e+04, 1.997950e+04, 2.011215e+04, 2.039949e+04,
                                      2.149988e+04, 2.298338e+04, 2.456923e+04, 2.626450e+04,
                                      2.807676e+04, 3.001405e+04, 3.208502e+04, 3.429889e+04,
                                      3.666551e+04, 3.919543e+04, 4.189992e+04, 4.479101e+04,
                                      4.788159e+04, 5.118542e+04, 5.471721e+04, 5.849270e+04,
                                      6.252870e+04, 6.684318e+04, 7.145536e+04, 7.638578e+04,
                                      8.165640e+04, 8.729069e+04, 9.331374e+04, 9.975239e+04,
                                      1.066353e+05, 1.139931e+05, 1.218587e+05, 1.302669e+05,
                                      1.392553e+05, 1.488640e+05, 1.591356e+05, 1.701159e+05,
                                      1.818539e+05, 1.944018e+05, 2.078156e+05, 2.221548e+05,
                                      2.374835e+05, 2.538699e+05, 2.713869e+05, 2.901126e+05,
                                      3.101304e+05, 3.315294e+05, 3.544049e+05, 3.788588e+05,
                                      4.050001e+05, 4.329451e+05]), },
              '43': {'name': 'Tc',
                     'barns': 1627330000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6.72942, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7.0115799999999995,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 38.9, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 38.9, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 68.4, 'factor': 1.0},
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 252.9, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 256.40000000000003,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 425.0, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 444.90000000000003,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 547.6, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2676.8999999999996,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2793.2000000000003,
                            'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3042.5, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 21044.0, 'factor': 1.0},
                     'dat': np.array([2.92268468e+16, 2.79038275e+16, 2.78110697e+16, 2.65205970e+16,
                                      2.61902490e+16, 1.34479297e+17, 1.28581853e+17, 1.25662423e+17,
                                      1.49914522e+17, 1.79803692e+17, 2.14286814e+17, 2.51471305e+17,
                                      2.88541882e+17, 3.22081154e+17, 3.48508993e+17, 3.64766020e+17,
                                      3.68964531e+17, 3.60665148e+17, 3.41039548e+17, 3.12398540e+17,
                                      2.77801504e+17, 2.40405461e+17, 2.02993144e+17, 1.67728903e+17,
                                      1.36109881e+17, 1.08887905e+17, 8.61785148e+16, 8.50377565e+16,
                                      8.05267977e+16, 7.93730208e+16, 1.64832256e+17, 1.54433617e+17,
                                      1.39580976e+17, 1.04167021e+17, 7.86732688e+16, 6.03674337e+16,
                                      4.70265823e+16, 3.71812358e+16, 2.98370956e+16, 2.43025462e+16,
                                      2.19949923e+16, 2.10706688e+16, 2.08363333e+16, 2.22911663e+16,
                                      2.18957252e+16, 2.14905200e+16, 1.87273136e+16, 1.62814366e+16,
                                      1.43587463e+16, 1.28253132e+16, 1.15831722e+16, 1.05603953e+16,
                                      9.70295512e+15, 8.97147029e+15, 8.33567246e+15, 7.80727841e+15,
                                      7.36399372e+15, 6.95699848e+15, 6.57734239e+15, 6.21770246e+15,
                                      5.87384764e+15, 5.54301145e+15, 5.22291564e+15, 4.91274654e+15,
                                      4.61152775e+15, 4.57833022e+15, 4.51763081e+15, 4.51128423e+15,
                                      4.49354633e+15, 1.23236074e+16, 1.24487490e+16, 1.25857702e+16,
                                      1.80991643e+16, 1.81642575e+16, 1.90283697e+16, 1.93928916e+16,
                                      2.46849688e+16, 3.04213070e+16, 3.48964645e+16, 3.75717950e+16,
                                      3.83561681e+16, 3.74904285e+16, 3.56645643e+16, 3.53911728e+16,
                                      3.50803528e+16, 3.49192471e+16, 3.89599075e+16, 3.82927022e+16,
                                      3.80274474e+16, 3.73049129e+16, 3.71096333e+16, 3.85888763e+16,
                                      3.84391619e+16, 3.78403045e+16, 3.49501664e+16, 3.13374938e+16,
                                      2.88737162e+16, 2.80779518e+16, 2.78696536e+16, 2.90527225e+16,
                                      2.88135050e+16, 2.80356412e+16, 2.56337022e+16, 2.24978372e+16,
                                      1.96727924e+16, 1.71618222e+16, 1.49095975e+16, 1.29166064e+16,
                                      1.11765024e+16, 9.66357374e+15, 8.35015570e+15, 7.09060228e+15,
                                      6.00761416e+15, 5.09777396e+15, 4.33244066e+15, 3.68736705e+15,
                                      3.14351336e+15, 2.68444357e+15, 2.29567443e+15, 1.95198234e+15,
                                      1.65824927e+15, 1.41045573e+15, 1.20082308e+15, 1.02240262e+15,
                                      8.71451488e+14, 8.08343631e+14, 7.79686350e+14, 7.72298271e+14,
                                      2.88606976e+15, 2.80519145e+15, 2.76662373e+15, 2.74677031e+15,
                                      2.63025348e+15, 2.60047334e+15, 3.56401543e+15, 3.42536692e+15,
                                      3.25531093e+15, 3.04701269e+15, 2.93017040e+15, 2.89925113e+15,
                                      3.28346374e+15, 3.15767113e+15, 2.66312554e+15, 2.24213527e+15,
                                      1.88526180e+15, 1.58524725e+15, 1.33236016e+15, 1.12038416e+15,
                                      9.42386803e+14, 7.93030456e+14, 6.64569025e+14, 5.55765742e+14,
                                      4.64195882e+14, 3.87988019e+14, 3.24587242e+14, 2.71812930e+14,
                                      2.27614647e+14, 1.90251150e+14, 1.57855892e+14, 1.31102587e+14,
                                      1.08926961e+14, 9.05104673e+13, 7.50068944e+13, 6.20907762e+13,
                                      5.12804230e+13, 4.23919465e+13, 3.50754708e+13, 2.90478405e+13,
                                      2.40747200e+13, 1.99722211e+13, 1.86215372e+13, 1.78501828e+13,
                                      1.76516485e+13, 1.20111600e+14, 1.15208455e+14, 1.14681200e+14,
                                      9.56512027e+13, 8.03819654e+13, 6.75813876e+13, 5.64797423e+13,
                                      4.70493650e+13, 3.91991250e+13, 3.26621404e+13, 2.72187216e+13,
                                      2.26849802e+13, 1.89095746e+13, 1.56488935e+13, 1.29450847e+13,
                                      1.07094587e+13, 8.86064912e+12, 7.33128438e+12, 6.06554711e+12,
                                      5.01705839e+12, 4.14806417e+12, 3.42992344e+12, 2.83236786e+12,
                                      2.33196389e+12, 1.91878480e+12, 1.57719196e+12, 1.29647754e+12,
                                      1.06578724e+12, 8.76170745e+11, 7.20337624e+11, 5.92234207e+11,
                                      4.86945956e+11, 4.00388273e+11, 3.29225132e+11, 2.70722619e+11,
                                      2.22618744e+11, 1.83074625e+11, 1.50565454e+11, 1.23828422e+11,
                                      1.01843193e+11, 8.37651844e+10, 6.88978975e+10, 5.66701399e+10,
                                      4.66148678e+10, 3.83447768e+10, 3.15425374e+10, 2.59477768e+10,
                                      2.13456876e+10]),
                     'ene': np.array([6.763068e+00, 6.864010e+00, 6.871351e+00, 6.976524e+00,
                                      7.004571e+00, 7.046640e+00, 7.151814e+00, 1.069000e+01,
                                      1.142761e+01, 1.221612e+01, 1.305903e+01, 1.396010e+01,
                                      1.492335e+01, 1.595306e+01, 1.705382e+01, 1.823053e+01,
                                      1.948844e+01, 2.083314e+01, 2.227063e+01, 2.380730e+01,
                                      2.545001e+01, 2.720606e+01, 2.908327e+01, 3.109002e+01,
                                      3.323523e+01, 3.552846e+01, 3.797993e+01, 3.812200e+01,
                                      3.870550e+01, 3.886110e+01, 3.909450e+01, 3.967800e+01,
                                      4.060054e+01, 4.340198e+01, 4.639671e+01, 4.959809e+01,
                                      5.302035e+01, 5.667876e+01, 6.058959e+01, 6.477028e+01,
                                      6.703200e+01, 6.805800e+01, 6.833160e+01, 6.874200e+01,
                                      6.923942e+01, 6.976800e+01, 7.401695e+01, 7.912411e+01,
                                      8.458368e+01, 9.041995e+01, 9.665893e+01, 1.033284e+02,
                                      1.104581e+02, 1.180797e+02, 1.262272e+02, 1.349368e+02,
                                      1.442475e+02, 1.542005e+02, 1.648404e+02, 1.762144e+02,
                                      1.883732e+02, 2.013709e+02, 2.152655e+02, 2.301188e+02,
                                      2.459970e+02, 2.478420e+02, 2.512720e+02, 2.516355e+02,
                                      2.526471e+02, 2.541645e+02, 2.551180e+02, 2.561436e+02,
                                      2.576820e+02, 2.579580e+02, 2.615280e+02, 2.629708e+02,
                                      2.811158e+02, 3.005128e+02, 3.212482e+02, 3.434143e+02,
                                      3.671099e+02, 3.924405e+02, 4.165000e+02, 4.195189e+02,
                                      4.228750e+02, 4.245750e+02, 4.271250e+02, 4.335000e+02,
                                      4.360020e+02, 4.426755e+02, 4.444551e+02, 4.471245e+02,
                                      4.484657e+02, 4.537980e+02, 4.794098e+02, 5.124891e+02,
                                      5.366480e+02, 5.448620e+02, 5.470524e+02, 5.478508e+02,
                                      5.503380e+02, 5.585520e+02, 5.856525e+02, 6.260625e+02,
                                      6.692609e+02, 7.154399e+02, 7.648052e+02, 8.175768e+02,
                                      8.739896e+02, 9.342948e+02, 9.987612e+02, 1.067676e+03,
                                      1.141345e+03, 1.220098e+03, 1.304285e+03, 1.394281e+03,
                                      1.490486e+03, 1.593329e+03, 1.703269e+03, 1.820795e+03,
                                      1.946430e+03, 2.080733e+03, 2.224304e+03, 2.377781e+03,
                                      2.541848e+03, 2.623362e+03, 2.663515e+03, 2.674223e+03,
                                      2.690284e+03, 2.717235e+03, 2.730438e+03, 2.737336e+03,
                                      2.779234e+03, 2.790407e+03, 2.807166e+03, 2.849064e+03,
                                      2.904724e+03, 2.981650e+03, 3.027288e+03, 3.039458e+03,
                                      3.057713e+03, 3.105150e+03, 3.319406e+03, 3.548445e+03,
                                      3.793288e+03, 4.055024e+03, 4.334821e+03, 4.633924e+03,
                                      4.953664e+03, 5.295467e+03, 5.660855e+03, 6.051453e+03,
                                      6.469004e+03, 6.915365e+03, 7.392525e+03, 7.902609e+03,
                                      8.447890e+03, 9.030794e+03, 9.653919e+03, 1.032004e+04,
                                      1.103212e+04, 1.179334e+04, 1.260708e+04, 1.347697e+04,
                                      1.440688e+04, 1.540095e+04, 1.646362e+04, 1.759961e+04,
                                      1.881398e+04, 2.011215e+04, 2.062312e+04, 2.093878e+04,
                                      2.102296e+04, 2.114922e+04, 2.146488e+04, 2.149988e+04,
                                      2.298338e+04, 2.456923e+04, 2.626450e+04, 2.807676e+04,
                                      3.001405e+04, 3.208502e+04, 3.429889e+04, 3.666551e+04,
                                      3.919543e+04, 4.189992e+04, 4.479101e+04, 4.788159e+04,
                                      5.118542e+04, 5.471721e+04, 5.849270e+04, 6.252870e+04,
                                      6.684318e+04, 7.145536e+04, 7.638578e+04, 8.165640e+04,
                                      8.729069e+04, 9.331374e+04, 9.975239e+04, 1.066353e+05,
                                      1.139931e+05, 1.218587e+05, 1.302669e+05, 1.392553e+05,
                                      1.488640e+05, 1.591356e+05, 1.701159e+05, 1.818539e+05,
                                      1.944018e+05, 2.078156e+05, 2.221548e+05, 2.374835e+05,
                                      2.538699e+05, 2.713869e+05, 2.901126e+05, 3.101304e+05,
                                      3.315294e+05, 3.544049e+05, 3.788588e+05, 4.050001e+05,
                                      4.329451e+05]), },
              '44': {'name': 'Ru',
                     'barns': 1678310000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2.0, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2.0,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 43.1, 'factor': 1.0,
                            'twin': 'N2', 'shape': 'delayed'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 43.1, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 74.89999999999999,
                            'factor': 1.0},
                     'M5': {'filename': 'Ru.M5', 'excl before': 5, 'excl after': 50, 'onset': 279.4, 'factor': 1.0,
                            'twin': 'M4'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 283.6,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Ru.M3', 'excl before': 5, 'excl after': 50, 'onset': 460.6, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 482.8, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 585.0, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2837.9, 'factor': 1.0,
                            'twin': 'L2', 'shape': 'white_line'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2966.9, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3224.0, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 22117.2, 'factor': 1.0},
                     'dat': np.array([3.34587882e+17, 3.32859222e+17, 3.30207492e+17, 3.26481644e+17,
                                      3.21698461e+17, 3.15790810e+17, 3.08825823e+17, 3.00820284e+17,
                                      2.91858109e+17, 2.82006429e+17, 2.71416293e+17, 2.60221966e+17,
                                      2.48524145e+17, 2.36507445e+17, 2.24289348e+17, 2.12004119e+17,
                                      1.99802806e+17, 1.87786106e+17, 1.76054719e+17, 1.63850049e+17,
                                      1.48149459e+17, 1.39329940e+17, 1.36038774e+17, 1.35179479e+17,
                                      2.30734059e+17, 2.29190014e+17, 2.19522948e+17, 1.84496618e+17,
                                      1.51428876e+17, 1.27187367e+17, 1.08526238e+17, 9.35708174e+16,
                                      8.12352389e+16, 7.08565699e+16, 6.30406802e+16, 6.20068413e+16,
                                      6.11727212e+16, 6.06893679e+16, 6.14764953e+16, 5.97746890e+16,
                                      5.59615686e+16, 4.94665089e+16, 4.38189958e+16, 3.88881210e+16,
                                      3.45715077e+16, 3.07852403e+16, 2.74571516e+16, 2.45268223e+16,
                                      2.19439032e+16, 1.96614016e+16, 1.76423947e+16, 1.58513023e+16,
                                      1.42590896e+16, 1.28385680e+16, 1.15677517e+16, 1.04278435e+16,
                                      9.40289961e+15, 8.47966128e+15, 7.64621253e+15, 7.18098500e+15,
                                      7.01617496e+15, 7.01332183e+15, 6.96951794e+15, 1.29996858e+16,
                                      1.30262031e+16, 1.31166640e+16, 1.32158521e+16, 1.75450527e+16,
                                      1.83120404e+16, 2.06734226e+16, 2.60473712e+16, 3.10453784e+16,
                                      3.45631161e+16, 3.61927552e+16, 3.59997495e+16, 3.43550057e+16,
                                      3.41351471e+16, 3.35863397e+16, 3.34352918e+16, 3.74145648e+16,
                                      3.67700938e+16, 3.64512149e+16, 3.58419884e+16, 3.57446464e+16,
                                      3.55549974e+16, 3.70017006e+16, 3.62615659e+16, 3.41938879e+16,
                                      3.06190876e+16, 2.82023212e+16, 2.74084806e+16, 2.72020485e+16,
                                      2.82795235e+16, 2.80764480e+16, 2.73027471e+16, 2.48809458e+16,
                                      2.17727156e+16, 1.89816861e+16, 1.65122208e+16, 1.43250472e+16,
                                      1.23896201e+16, 1.07040933e+16, 9.24194968e+15, 7.91625261e+15,
                                      6.75788305e+15, 5.72119096e+15, 4.85115506e+15, 4.12008322e+15,
                                      3.50464694e+15, 2.98604915e+15, 2.54834590e+15, 2.17861421e+15,
                                      1.85537170e+15, 1.57569813e+15, 1.33997949e+15, 1.14059626e+15,
                                      9.70969467e+14, 8.27507529e+14, 7.82864483e+14, 7.55071669e+14,
                                      7.47905285e+14, 2.67841493e+15, 2.58241560e+15, 2.56042974e+15,
                                      2.55421999e+15, 2.46040246e+15, 2.43623480e+15, 3.34923544e+15,
                                      3.26750174e+15, 2.99175541e+15, 2.81704334e+15, 2.67321217e+15,
                                      2.63679284e+15, 2.98789529e+15, 2.85396616e+15, 2.77525342e+15,
                                      2.33520053e+15, 2.03495088e+15, 1.72916279e+15, 1.45346681e+15,
                                      1.22139010e+15, 1.02689076e+15, 8.63826157e+14, 7.26842495e+14,
                                      6.08739820e+14, 5.09283170e+14, 4.25569067e+14, 3.55935985e+14,
                                      2.97983940e+14, 2.49698962e+14, 2.08815330e+14, 1.73218375e+14,
                                      1.43826132e+14, 1.19532595e+14, 9.93844833e+13, 8.26030616e+13,
                                      6.84935094e+13, 5.67033817e+13, 4.68634501e+13, 3.87656044e+13,
                                      3.20960004e+13, 2.65978569e+13, 2.20613850e+13, 1.83137187e+13,
                                      1.79042111e+13, 1.71640764e+13, 1.69744273e+13, 1.13903543e+14,
                                      1.09263016e+14, 1.03701097e+14, 8.68777172e+13, 7.31189318e+13,
                                      6.12448885e+13, 5.10776865e+13, 4.25535500e+13, 3.54576554e+13,
                                      2.95466476e+13, 2.46241643e+13, 2.05240530e+13, 1.70851958e+13,
                                      1.41379156e+13, 1.17000025e+13, 9.68334521e+12, 8.01493724e+12,
                                      6.63402377e+12, 5.49109466e+12, 4.54284951e+12, 3.75723260e+12,
                                      3.10353085e+12, 2.55606613e+12, 2.10510423e+12, 1.73218375e+12,
                                      1.42444883e+12, 1.17141003e+12, 9.63383506e+11, 7.92330151e+11,
                                      6.51670990e+11, 5.36018648e+11, 4.40892037e+11, 3.62682791e+11,
                                      2.98353169e+11, 2.45436054e+11, 2.01917476e+11, 1.66117445e+11,
                                      1.36669818e+11, 1.12448448e+11, 9.25218737e+10, 7.61281416e+10,
                                      6.26412424e+10, 5.15459350e+10, 4.24176069e+10, 3.49054914e+10,
                                      2.87259540e+10, 2.36389964e+10]),
                     'ene': np.array([1.069000e+01, 1.142761e+01, 1.221612e+01, 1.305903e+01,
                                      1.396010e+01, 1.492335e+01, 1.595306e+01, 1.705382e+01,
                                      1.823053e+01, 1.948844e+01, 2.083314e+01, 2.227063e+01,
                                      2.380730e+01, 2.545001e+01, 2.720606e+01, 2.908327e+01,
                                      3.109002e+01, 3.323523e+01, 3.552846e+01, 3.797993e+01,
                                      4.060054e+01, 4.223800e+01, 4.288450e+01, 4.305690e+01,
                                      4.331550e+01, 4.340198e+01, 4.396200e+01, 4.639671e+01,
                                      4.959809e+01, 5.302035e+01, 5.667876e+01, 6.058959e+01,
                                      6.477028e+01, 6.923942e+01, 7.340200e+01, 7.401695e+01,
                                      7.452550e+01, 7.482510e+01, 7.527450e+01, 7.639800e+01,
                                      7.912411e+01, 8.458368e+01, 9.041995e+01, 9.665893e+01,
                                      1.033284e+02, 1.104581e+02, 1.180797e+02, 1.262272e+02,
                                      1.349368e+02, 1.442475e+02, 1.542005e+02, 1.648404e+02,
                                      1.762144e+02, 1.883732e+02, 2.013709e+02, 2.152655e+02,
                                      2.301188e+02, 2.459970e+02, 2.629708e+02, 2.738120e+02,
                                      2.779280e+02, 2.780030e+02, 2.791206e+02, 2.807970e+02,
                                      2.811158e+02, 2.821820e+02, 2.833164e+02, 2.850180e+02,
                                      2.892720e+02, 3.005128e+02, 3.212482e+02, 3.434143e+02,
                                      3.671099e+02, 3.924405e+02, 4.195189e+02, 4.484657e+02,
                                      4.513880e+02, 4.582970e+02, 4.601394e+02, 4.629030e+02,
                                      4.698120e+02, 4.731440e+02, 4.794098e+02, 4.803860e+02,
                                      4.823172e+02, 4.852140e+02, 4.924560e+02, 5.124891e+02,
                                      5.478508e+02, 5.733000e+02, 5.820750e+02, 5.844150e+02,
                                      5.856525e+02, 5.879250e+02, 5.967000e+02, 6.260625e+02,
                                      6.692609e+02, 7.154399e+02, 7.648052e+02, 8.175768e+02,
                                      8.739896e+02, 9.342948e+02, 9.987612e+02, 1.067676e+03,
                                      1.141345e+03, 1.220098e+03, 1.304285e+03, 1.394281e+03,
                                      1.490486e+03, 1.593329e+03, 1.703269e+03, 1.820795e+03,
                                      1.946430e+03, 2.080733e+03, 2.224304e+03, 2.377781e+03,
                                      2.541848e+03, 2.717235e+03, 2.781142e+03, 2.823710e+03,
                                      2.835062e+03, 2.852089e+03, 2.894658e+03, 2.904724e+03,
                                      2.907562e+03, 2.952066e+03, 2.963933e+03, 2.981735e+03,
                                      3.026238e+03, 3.105150e+03, 3.159520e+03, 3.207880e+03,
                                      3.220776e+03, 3.240120e+03, 3.288480e+03, 3.319406e+03,
                                      3.548445e+03, 3.793288e+03, 4.055024e+03, 4.334821e+03,
                                      4.633924e+03, 4.953664e+03, 5.295467e+03, 5.660855e+03,
                                      6.051453e+03, 6.469004e+03, 6.915365e+03, 7.392525e+03,
                                      7.902609e+03, 8.447890e+03, 9.030794e+03, 9.653919e+03,
                                      1.032004e+04, 1.103212e+04, 1.179334e+04, 1.260708e+04,
                                      1.347697e+04, 1.440688e+04, 1.540095e+04, 1.646362e+04,
                                      1.759961e+04, 1.881398e+04, 2.011215e+04, 2.149988e+04,
                                      2.167486e+04, 2.200661e+04, 2.209508e+04, 2.222779e+04,
                                      2.255954e+04, 2.298338e+04, 2.456923e+04, 2.626450e+04,
                                      2.807676e+04, 3.001405e+04, 3.208502e+04, 3.429889e+04,
                                      3.666551e+04, 3.919543e+04, 4.189992e+04, 4.479101e+04,
                                      4.788159e+04, 5.118542e+04, 5.471721e+04, 5.849270e+04,
                                      6.252870e+04, 6.684318e+04, 7.145536e+04, 7.638578e+04,
                                      8.165640e+04, 8.729069e+04, 9.331374e+04, 9.975239e+04,
                                      1.066353e+05, 1.139931e+05, 1.218587e+05, 1.302669e+05,
                                      1.392553e+05, 1.488640e+05, 1.591356e+05, 1.701159e+05,
                                      1.818539e+05, 1.944018e+05, 2.078156e+05, 2.221548e+05,
                                      2.374835e+05, 2.538699e+05, 2.713869e+05, 2.901126e+05,
                                      3.101304e+05, 3.315294e+05, 3.544049e+05, 3.788588e+05,
                                      4.050001e+05, 4.329451e+05]), },
              '45': {'name': 'Rh',
                     'barns': 1708790000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2.5, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2.5,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 47.9, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 47.9, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 81.0, 'factor': 1.0},
                     'M5': {'filename': 'Rh.M5', 'excl before': 5, 'excl after': 50, 'onset': 307.0, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'delayed'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 311.7,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Rh.M3', 'excl before': 5, 'excl after': 50, 'onset': 496.2, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 521.0, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 627.1, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3003.8, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3146.1, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3411.9, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 23219.899999999998,
                            'factor': 1.0},
                     'dat': np.array([3.14109778e+17, 3.12025054e+17, 3.08983408e+17, 3.04984839e+17,
                                      2.99978084e+17, 2.93980232e+17, 2.87025456e+17, 2.79165022e+17,
                                      2.70467281e+17, 2.61034760e+17, 2.50969987e+17, 2.40375489e+17,
                                      2.29387970e+17, 2.18127044e+17, 2.06712326e+17, 1.95263433e+17,
                                      1.83899980e+17, 1.72690317e+17, 1.61764314e+17, 1.51168107e+17,
                                      1.40966631e+17, 1.31211149e+17, 1.21934128e+17, 1.20360332e+17,
                                      1.17624560e+17, 1.16908577e+17, 1.96203268e+17, 1.86548604e+17,
                                      1.77440754e+17, 1.43895497e+17, 1.19827190e+17, 1.02101911e+17,
                                      8.82692562e+16, 7.70185829e+16, 6.76065676e+16, 5.95855073e+16,
                                      5.92266614e+16, 5.75742615e+16, 5.71470640e+16, 5.79980414e+16,
                                      5.64891798e+16, 5.41942748e+16, 4.82596472e+16, 4.30700520e+16,
                                      3.85024563e+16, 3.44714207e+16, 3.09034672e+16, 2.77404969e+16,
                                      2.49295373e+16, 2.24295775e+16, 2.01996066e+16, 1.82088662e+16,
                                      1.64262565e+16, 1.48287087e+16, 1.33928125e+16, 1.20973788e+16,
                                      1.09266868e+16, 9.86689522e+15, 8.90621348e+15, 8.03438882e+15,
                                      7.24270642e+15, 7.22971961e+15, 7.06020764e+15, 7.01594998e+15,
                                      1.36404162e+16, 1.37612276e+16, 1.38579451e+16, 1.86104319e+16,
                                      1.93554643e+16, 1.99193650e+16, 2.44784168e+16, 2.92561936e+16,
                                      3.26925703e+16, 3.43449702e+16, 3.42424428e+16, 3.27250373e+16,
                                      3.22619552e+16, 3.17253951e+16, 3.15767304e+16, 3.54625189e+16,
                                      3.48285578e+16, 3.44406624e+16, 3.42732010e+16, 3.37468937e+16,
                                      3.35606356e+16, 3.49686786e+16, 3.42424428e+16, 3.27113670e+16,
                                      2.92647375e+16, 2.67972448e+16, 2.60351244e+16, 2.58693718e+16,
                                      2.58369048e+16, 2.66673767e+16, 2.59240531e+16, 2.37316755e+16,
                                      2.07412930e+16, 1.80619103e+16, 1.56925021e+16, 1.36048733e+16,
                                      1.17638230e+16, 1.01623450e+16, 8.71431636e+15, 7.46040626e+15,
                                      6.38010922e+15, 5.41020002e+15, 4.58553796e+15, 3.89296538e+15,
                                      3.31009711e+15, 2.81933262e+15, 2.40529280e+15, 2.05550349e+15,
                                      1.75202239e+15, 1.48803142e+15, 1.26534191e+15, 1.07708451e+15,
                                      9.16953802e+14, 7.81532194e+14, 7.57062322e+14, 7.30165967e+14,
                                      7.23159928e+14, 2.50542790e+15, 2.41827961e+15, 2.38239502e+15,
                                      2.34223845e+15, 2.29763903e+15, 2.27576652e+15, 3.09256814e+15,
                                      2.98132591e+15, 2.73816510e+15, 2.68690140e+15, 2.58215257e+15,
                                      2.55498281e+15, 2.89554466e+15, 2.78874528e+15, 2.65392175e+15,
                                      2.23595172e+15, 1.88137779e+15, 1.58174146e+15, 1.32935318e+15,
                                      1.11724108e+15, 9.39424390e+14, 7.90247023e+14, 6.64548431e+14,
                                      5.56535815e+14, 4.65764890e+14, 3.89518680e+14, 3.26054220e+14,
                                      2.73201345e+14, 2.28567750e+14, 1.89692778e+14, 1.57461581e+14,
                                      1.30831798e+14, 1.08810621e+14, 9.05299854e+13, 7.52568204e+13,
                                      6.24340602e+13, 5.16840623e+13, 4.27419643e+13, 3.53804970e+13,
                                      2.93125837e+13, 2.43075378e+13, 2.01756835e+13, 1.72280208e+13,
                                      1.67582744e+13, 1.65171641e+13, 1.63344945e+13, 1.08121978e+14,
                                      1.03737223e+14, 9.37459282e+13, 7.88281915e+13, 6.61199203e+13,
                                      5.53220762e+13, 4.61014454e+13, 3.84101816e+13, 3.20073455e+13,
                                      2.66742119e+13, 2.22313579e+13, 1.85318276e+13, 1.53979067e+13,
                                      1.27463772e+13, 1.05524618e+13, 8.73687239e+12, 7.23416246e+12,
                                      5.98999247e+12, 4.95959210e+12, 4.10485534e+12, 3.39246079e+12,
                                      2.79558044e+12, 2.30379068e+12, 1.89863657e+12, 1.56279098e+12,
                                      1.28617206e+12, 1.05857832e+12, 8.71294933e+11, 7.17196251e+11,
                                      5.90369857e+11, 4.85996964e+11, 4.00096091e+11, 3.29386360e+11,
                                      2.71202061e+11, 2.23287589e+11, 1.83848716e+11, 1.51391959e+11,
                                      1.24664774e+11, 1.02660686e+11, 8.45440940e+10, 6.96263573e+10,
                                      5.73418660e+10, 4.72275380e+10, 3.88988956e+10, 3.20398125e+10,
                                      2.63905528e+10]),
                     'ene': np.array([1.069000e+01, 1.142761e+01, 1.221612e+01, 1.305903e+01,
                                      1.396010e+01, 1.492335e+01, 1.595306e+01, 1.705382e+01,
                                      1.823053e+01, 1.948844e+01, 2.083314e+01, 2.227063e+01,
                                      2.380730e+01, 2.545001e+01, 2.720606e+01, 2.908327e+01,
                                      3.109002e+01, 3.323523e+01, 3.552846e+01, 3.797993e+01,
                                      4.060054e+01, 4.340198e+01, 4.639671e+01, 4.694200e+01,
                                      4.766050e+01, 4.785210e+01, 4.813950e+01, 4.885800e+01,
                                      4.959809e+01, 5.302035e+01, 5.667876e+01, 6.058959e+01,
                                      6.477028e+01, 6.923942e+01, 7.401695e+01, 7.912411e+01,
                                      7.938000e+01, 8.059500e+01, 8.091900e+01, 8.140500e+01,
                                      8.262000e+01, 8.458368e+01, 9.041995e+01, 9.665893e+01,
                                      1.033284e+02, 1.104581e+02, 1.180797e+02, 1.262272e+02,
                                      1.349368e+02, 1.442475e+02, 1.542005e+02, 1.648404e+02,
                                      1.762144e+02, 1.883732e+02, 2.013709e+02, 2.152655e+02,
                                      2.301188e+02, 2.459970e+02, 2.629708e+02, 2.811158e+02,
                                      3.005128e+02, 3.008600e+02, 3.054660e+02, 3.066930e+02,
                                      3.085350e+02, 3.101415e+02, 3.113883e+02, 3.132585e+02,
                                      3.179340e+02, 3.212482e+02, 3.434143e+02, 3.671099e+02,
                                      3.924405e+02, 4.195189e+02, 4.484657e+02, 4.794098e+02,
                                      4.862760e+02, 4.937190e+02, 4.957038e+02, 4.986810e+02,
                                      5.061240e+02, 5.105800e+02, 5.124891e+02, 5.183950e+02,
                                      5.204790e+02, 5.236050e+02, 5.314200e+02, 5.478508e+02,
                                      5.856525e+02, 6.145580e+02, 6.239645e+02, 6.260625e+02,
                                      6.264729e+02, 6.302355e+02, 6.396420e+02, 6.692609e+02,
                                      7.154399e+02, 7.648052e+02, 8.175768e+02, 8.739896e+02,
                                      9.342948e+02, 9.987612e+02, 1.067676e+03, 1.141345e+03,
                                      1.220098e+03, 1.304285e+03, 1.394281e+03, 1.490486e+03,
                                      1.593329e+03, 1.703269e+03, 1.820795e+03, 1.946430e+03,
                                      2.080733e+03, 2.224304e+03, 2.377781e+03, 2.541848e+03,
                                      2.717235e+03, 2.904724e+03, 2.943724e+03, 2.988781e+03,
                                      3.000796e+03, 3.018819e+03, 3.063876e+03, 3.083178e+03,
                                      3.105150e+03, 3.130370e+03, 3.142954e+03, 3.161831e+03,
                                      3.209022e+03, 3.319406e+03, 3.343662e+03, 3.394841e+03,
                                      3.408488e+03, 3.428960e+03, 3.480138e+03, 3.548445e+03,
                                      3.793288e+03, 4.055024e+03, 4.334821e+03, 4.633924e+03,
                                      4.953664e+03, 5.295467e+03, 5.660855e+03, 6.051453e+03,
                                      6.469004e+03, 6.915365e+03, 7.392525e+03, 7.902609e+03,
                                      8.447890e+03, 9.030794e+03, 9.653919e+03, 1.032004e+04,
                                      1.103212e+04, 1.179334e+04, 1.260708e+04, 1.347697e+04,
                                      1.440688e+04, 1.540095e+04, 1.646362e+04, 1.759961e+04,
                                      1.881398e+04, 2.011215e+04, 2.149988e+04, 2.275550e+04,
                                      2.298338e+04, 2.310380e+04, 2.319668e+04, 2.333600e+04,
                                      2.368430e+04, 2.456923e+04, 2.626450e+04, 2.807676e+04,
                                      3.001405e+04, 3.208502e+04, 3.429889e+04, 3.666551e+04,
                                      3.919543e+04, 4.189992e+04, 4.479101e+04, 4.788159e+04,
                                      5.118542e+04, 5.471721e+04, 5.849270e+04, 6.252870e+04,
                                      6.684318e+04, 7.145536e+04, 7.638578e+04, 8.165640e+04,
                                      8.729069e+04, 9.331374e+04, 9.975239e+04, 1.066353e+05,
                                      1.139931e+05, 1.218587e+05, 1.302669e+05, 1.392553e+05,
                                      1.488640e+05, 1.591356e+05, 1.701159e+05, 1.818539e+05,
                                      1.944018e+05, 2.078156e+05, 2.221548e+05, 2.374835e+05,
                                      2.538699e+05, 2.713869e+05, 2.901126e+05, 3.101304e+05,
                                      3.315294e+05, 3.544049e+05, 3.788588e+05, 4.050001e+05,
                                      4.329451e+05]), },
              '46': {'name': 'Pd',
                     'barns': 1767150000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5.01841, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5.44663,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 51.1, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 51.1, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 86.4, 'factor': 1.0},
                     'M5': {'filename': 'Pd.M5', 'excl before': 5, 'excl after': 50, 'onset': 334.7, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'delayed'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 340.0,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Pd.M3', 'excl before': 5, 'excl after': 50, 'onset': 531.5, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 559.1, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 669.9000000000001,
                            'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3173.2999999999997,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3330.2999999999997,
                            'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3604.2999999999997,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 24350.3, 'factor': 1.0},
                     'dat': np.array([1.79082981e+17, 1.71001804e+17, 1.50075214e+17, 1.43133849e+17,
                                      1.41356096e+17, 2.49203493e+17, 2.36921800e+17, 3.85839531e+17,
                                      4.25459034e+17, 4.57444449e+17, 4.78137776e+17, 4.84923632e+17,
                                      4.76794742e+17, 4.54510980e+17, 4.20387314e+17, 3.77798998e+17,
                                      3.30545408e+17, 2.82196184e+17, 2.35702467e+17, 1.93220181e+17,
                                      1.56011071e+17, 1.24525759e+17, 9.85910656e+16, 7.76715440e+16,
                                      6.10674026e+16, 4.80417399e+16, 3.79036004e+16, 3.00503858e+16,
                                      2.39802255e+16, 1.92884422e+16, 1.56509407e+16, 1.51978434e+16,
                                      1.45155468e+16, 1.43418360e+16, 1.05438772e+17, 9.61789059e+16,
                                      8.65550070e+16, 5.77628320e+16, 4.02397726e+16, 2.96174340e+16,
                                      2.28156736e+16, 1.82528924e+16, 1.50695483e+16, 1.27749041e+16,
                                      1.27443324e+16, 1.23147382e+16, 1.22058818e+16, 1.32649348e+16,
                                      1.29136253e+16, 1.23592704e+16, 1.12169846e+16, 1.04007380e+16,
                                      9.79442888e+15, 9.30475161e+15, 8.89512624e+15, 8.54010580e+15,
                                      8.22184209e+15, 7.92761162e+15, 7.64822520e+15, 7.37714439e+15,
                                      7.10959788e+15, 6.84240480e+15, 6.57238428e+15, 6.29653216e+15,
                                      6.01431831e+15, 5.72697972e+15, 5.43522326e+15, 5.14063935e+15,
                                      4.84517187e+15, 4.75310336e+15, 4.68365436e+15, 4.66828016e+15,
                                      9.75661186e+15, 9.90699633e+15, 1.00162062e+16, 1.37524914e+16,
                                      1.40014829e+16, 1.45132495e+16, 1.81892750e+16, 2.34500805e+16,
                                      2.77919680e+16, 3.04462274e+16, 3.12273076e+16, 3.03914457e+16,
                                      2.99956041e+16, 2.95679538e+16, 2.94477876e+16, 3.32595302e+16,
                                      3.27205494e+16, 3.23158720e+16, 3.23105706e+16, 3.16991367e+16,
                                      3.15312574e+16, 3.29114016e+16, 3.22557890e+16, 3.10329212e+16,
                                      2.78237768e+16, 2.55211803e+16, 2.47966488e+16, 2.46040294e+16,
                                      2.53886440e+16, 2.46800169e+16, 2.25559026e+16, 1.97001882e+16,
                                      1.71417084e+16, 1.48841743e+16, 1.29014320e+16, 1.11604358e+16,
                                      9.56346237e+15, 8.18667580e+15, 7.00091816e+15, 5.98586720e+15,
                                      5.09204272e+15, 4.31626388e+15, 3.66471567e+15, 3.11654574e+15,
                                      2.65478944e+15, 2.26513287e+15, 1.93608954e+15, 1.65088920e+15,
                                      1.40237490e+15, 1.19224309e+15, 1.01452082e+15, 8.63517848e+14,
                                      7.26174950e+14, 7.23153123e+14, 6.93358974e+14, 6.85707214e+14,
                                      2.23880234e+15, 2.19939489e+15, 2.17783566e+15, 2.13913508e+15,
                                      2.13489391e+15, 2.12923904e+15, 2.85235682e+15, 2.77884338e+15,
                                      2.56908267e+15, 2.54133842e+15, 2.47648401e+15, 2.45192062e+15,
                                      2.77336521e+15, 2.67352124e+15, 2.46552768e+15, 2.05607902e+15,
                                      1.71404714e+15, 1.43588006e+15, 1.20537302e+15, 1.01414971e+15,
                                      8.54558397e+14, 7.20520070e+14, 6.06556566e+14, 5.08232340e+14,
                                      4.25494377e+14, 3.56151411e+14, 2.98383278e+14, 2.49609938e+14,
                                      2.07180666e+14, 1.72056793e+14, 1.42927092e+14, 1.18835536e+14,
                                      9.89003169e+13, 8.23385871e+13, 6.84540896e+13, 5.68174068e+13,
                                      4.70256286e+13, 3.89144102e+13, 3.22328160e+13, 2.67228423e+13,
                                      2.21741982e+13, 1.84154702e+13, 1.65931851e+13, 1.59096514e+13,
                                      1.57339967e+13, 1.02701457e+14, 1.01589919e+14, 9.86105043e+13,
                                      8.49734078e+13, 7.13363112e+13, 5.97049299e+13, 4.98601372e+13,
                                      4.15403950e+13, 3.46131670e+13, 2.88469566e+13, 2.40420758e+13,
                                      2.00394810e+13, 1.67059292e+13, 1.38576369e+13, 1.14762255e+13,
                                      9.50496970e+12, 7.87282996e+12, 6.52166708e+12, 5.40200084e+12,
                                      4.47477723e+12, 3.69970524e+12, 3.04992418e+12, 2.51447774e+12,
                                      2.07304366e+12, 1.70897542e+12, 1.40728757e+12, 1.15893231e+12,
                                      9.54455386e+11, 7.86099006e+11, 6.47483760e+11, 5.33325870e+11,
                                      4.39313490e+11, 3.61894648e+11, 2.98135876e+11, 2.45616178e+11,
                                      2.02356346e+11, 1.66728835e+11, 1.37376474e+11, 1.13196560e+11,
                                      9.32754784e+10, 7.68639564e+10, 6.33417246e+10, 5.21998438e+10,
                                      4.30194996e+10, 3.54560976e+10, 2.92215924e+10]),
                     'ene': np.array([5.043505e+00, 5.118781e+00, 5.337699e+00, 5.419399e+00,
                                      5.441185e+00, 5.473865e+00, 5.555565e+00, 1.069000e+01,
                                      1.142761e+01, 1.221612e+01, 1.305903e+01, 1.396010e+01,
                                      1.492335e+01, 1.595306e+01, 1.705382e+01, 1.823053e+01,
                                      1.948844e+01, 2.083314e+01, 2.227063e+01, 2.380730e+01,
                                      2.545001e+01, 2.720606e+01, 2.908327e+01, 3.109002e+01,
                                      3.323523e+01, 3.552846e+01, 3.797993e+01, 4.060054e+01,
                                      4.340198e+01, 4.639671e+01, 4.959809e+01, 5.007800e+01,
                                      5.084450e+01, 5.104890e+01, 5.135550e+01, 5.212200e+01,
                                      5.302035e+01, 5.667876e+01, 6.058959e+01, 6.477028e+01,
                                      6.923942e+01, 7.401695e+01, 7.912411e+01, 8.458368e+01,
                                      8.467200e+01, 8.596800e+01, 8.631360e+01, 8.683200e+01,
                                      8.812800e+01, 9.041995e+01, 9.665893e+01, 1.033284e+02,
                                      1.104581e+02, 1.180797e+02, 1.262272e+02, 1.349368e+02,
                                      1.442475e+02, 1.542005e+02, 1.648404e+02, 1.762144e+02,
                                      1.883732e+02, 2.013709e+02, 2.152655e+02, 2.301188e+02,
                                      2.459970e+02, 2.629708e+02, 2.811158e+02, 3.005128e+02,
                                      3.212482e+02, 3.280060e+02, 3.332000e+02, 3.343653e+02,
                                      3.363735e+02, 3.383000e+02, 3.396600e+02, 3.417000e+02,
                                      3.434143e+02, 3.468000e+02, 3.671099e+02, 3.924405e+02,
                                      4.195189e+02, 4.484657e+02, 4.794098e+02, 5.124891e+02,
                                      5.208700e+02, 5.288425e+02, 5.309685e+02, 5.341575e+02,
                                      5.421300e+02, 5.478508e+02, 5.479180e+02, 5.563045e+02,
                                      5.585409e+02, 5.618955e+02, 5.702820e+02, 5.856525e+02,
                                      6.260625e+02, 6.565020e+02, 6.665505e+02, 6.692609e+02,
                                      6.732495e+02, 6.832980e+02, 7.154399e+02, 7.648052e+02,
                                      8.175768e+02, 8.739896e+02, 9.342948e+02, 9.987612e+02,
                                      1.067676e+03, 1.141345e+03, 1.220098e+03, 1.304285e+03,
                                      1.394281e+03, 1.490486e+03, 1.593329e+03, 1.703269e+03,
                                      1.820795e+03, 1.946430e+03, 2.080733e+03, 2.224304e+03,
                                      2.377781e+03, 2.541848e+03, 2.717235e+03, 2.904724e+03,
                                      3.105150e+03, 3.109834e+03, 3.157434e+03, 3.170127e+03,
                                      3.189167e+03, 3.236766e+03, 3.263694e+03, 3.313649e+03,
                                      3.319406e+03, 3.326970e+03, 3.346952e+03, 3.396906e+03,
                                      3.532214e+03, 3.548445e+03, 3.586279e+03, 3.600696e+03,
                                      3.622322e+03, 3.676386e+03, 3.793288e+03, 4.055024e+03,
                                      4.334821e+03, 4.633924e+03, 4.953664e+03, 5.295467e+03,
                                      5.660855e+03, 6.051453e+03, 6.469004e+03, 6.915365e+03,
                                      7.392525e+03, 7.902609e+03, 8.447890e+03, 9.030794e+03,
                                      9.653919e+03, 1.032004e+04, 1.103212e+04, 1.179334e+04,
                                      1.260708e+04, 1.347697e+04, 1.440688e+04, 1.540095e+04,
                                      1.646362e+04, 1.759961e+04, 1.881398e+04, 2.011215e+04,
                                      2.149988e+04, 2.298338e+04, 2.386329e+04, 2.422855e+04,
                                      2.432595e+04, 2.447205e+04, 2.456923e+04, 2.483731e+04,
                                      2.626450e+04, 2.807676e+04, 3.001405e+04, 3.208502e+04,
                                      3.429889e+04, 3.666551e+04, 3.919543e+04, 4.189992e+04,
                                      4.479101e+04, 4.788159e+04, 5.118542e+04, 5.471721e+04,
                                      5.849270e+04, 6.252870e+04, 6.684318e+04, 7.145536e+04,
                                      7.638578e+04, 8.165640e+04, 8.729069e+04, 9.331374e+04,
                                      9.975239e+04, 1.066353e+05, 1.139931e+05, 1.218587e+05,
                                      1.302669e+05, 1.392553e+05, 1.488640e+05, 1.591356e+05,
                                      1.701159e+05, 1.818539e+05, 1.944018e+05, 2.078156e+05,
                                      2.221548e+05, 2.374835e+05, 2.538699e+05, 2.713869e+05,
                                      2.901126e+05, 3.101304e+05, 3.315294e+05, 3.544049e+05,
                                      3.788588e+05, 4.050001e+05, 4.329451e+05]), },
              '47': {'name': 'Ag',
                     'barns': 1791190000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.3, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.3,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 55.9, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 62.6, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 95.2, 'factor': 1.0},
                     'M5': {'filename': 'Ag.M5', 'excl before': 5, 'excl after': 50, 'onset': 366.70000000000005,
                            'factor': 1.0, 'twin': 'M4', 'shape': 'delayed'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 372.8,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Ag.M3', 'excl before': 5, 'excl after': 50, 'onset': 571.4, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 602.4000000000001,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 717.5, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3351.1000000000004,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3523.7, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3805.8, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 25514.0, 'factor': 1.0},
                     'dat': np.array([3.00472122e+17, 2.99916854e+17, 2.98251047e+17, 2.95456790e+17,
                                      2.91390789e+17, 2.85927660e+17, 2.79174873e+17, 2.71275726e+17,
                                      2.62355599e+17, 2.52629438e+17, 2.42204712e+17, 2.31296365e+17,
                                      2.20029780e+17, 2.08584076e+17, 1.97084636e+17, 1.85638932e+17,
                                      1.74375929e+17, 1.63379813e+17, 1.52722233e+17, 1.42465879e+17,
                                      1.32653740e+17, 1.23318058e+17, 1.14476744e+17, 1.06142337e+17,
                                      9.83148367e+16, 9.46626003e+16, 9.30075408e+16, 9.25740728e+16,
                                      1.31555741e+17, 1.28387126e+17, 1.26327257e+17, 1.08341918e+17,
                                      1.05232412e+17, 1.01560473e+17, 1.00575318e+17, 1.17253089e+17,
                                      1.12173274e+17, 1.07648728e+17, 9.02920967e+16, 7.76122627e+16,
                                      6.78843098e+16, 6.00102386e+16, 5.34043298e+16, 5.06423149e+16,
                                      4.93687788e+16, 4.90391998e+16, 4.99455420e+16, 4.91395065e+16,
                                      4.87830596e+16, 4.42817992e+16, 4.00133934e+16, 3.62250266e+16,
                                      3.28432598e+16, 2.98089840e+16, 2.70792104e+16, 2.46163242e+16,
                                      2.23898750e+16, 2.03694127e+16, 1.85352341e+16, 1.68667406e+16,
                                      1.53447665e+16, 1.39546239e+16, 1.26814461e+16, 1.15137693e+16,
                                      1.04417421e+16, 9.45748320e+15, 8.55418608e+15, 7.72593983e+15,
                                      7.20237499e+15, 7.03418225e+15, 7.01985273e+15, 6.99029809e+15,
                                      1.48484277e+16, 1.49277775e+16, 1.50656991e+16, 1.51540048e+16,
                                      2.07778040e+16, 2.08512428e+16, 2.15247302e+16, 2.31368012e+16,
                                      2.71526492e+16, 3.02120017e+16, 3.16091299e+16, 3.13834400e+16,
                                      2.98680932e+16, 2.91641556e+16, 2.86303810e+16, 2.84835034e+16,
                                      3.21321574e+16, 3.15088233e+16, 3.12992541e+16, 3.09499720e+16,
                                      3.02729022e+16, 3.00902008e+16, 3.13870224e+16, 3.06866671e+16,
                                      2.97874897e+16, 2.65508094e+16, 2.41989769e+16, 2.34950392e+16,
                                      2.33965238e+16, 2.33105467e+16, 2.40449346e+16, 2.33607000e+16,
                                      2.14011381e+16, 1.86659910e+16, 1.62229869e+16, 1.40699766e+16,
                                      1.21836744e+16, 1.04618034e+16, 8.96401036e+15, 7.67327884e+15,
                                      6.56041249e+15, 5.60749941e+15, 4.78695528e+15, 4.05525416e+15,
                                      3.44069687e+15, 2.92411768e+15, 2.48921674e+15, 2.12256015e+15,
                                      1.81304252e+15, 1.54597609e+15, 1.31362292e+15, 1.11693235e+15,
                                      9.50727828e+14, 7.99085683e+14, 6.84342051e+14, 6.64441930e+14,
                                      6.56292016e+14, 6.49073520e+14, 2.15820483e+15, 2.10178235e+15,
                                      2.06380912e+15, 2.00899870e+15, 1.99359447e+15, 2.68821795e+15,
                                      2.67675434e+15, 2.60474850e+15, 2.39517927e+15, 2.30544065e+15,
                                      2.29540998e+15, 2.28197606e+15, 2.58594100e+15, 2.49190353e+15,
                                      2.22680741e+15, 1.86552438e+15, 1.56326107e+15, 1.31263777e+15,
                                      1.10260283e+15, 9.27424446e+14, 7.80708073e+14, 6.57474201e+14,
                                      5.52779146e+14, 4.63255470e+14, 3.88025490e+14, 3.25065161e+14,
                                      2.71902642e+14, 2.25636204e+14, 1.87412210e+14, 1.55756509e+14,
                                      1.29483334e+14, 1.07729331e+14, 8.97207071e+13, 7.47481499e+13,
                                      6.21345899e+13, 5.16077663e+13, 4.27019696e+13, 3.53598818e+13,
                                      2.93074508e+13, 2.43136131e+13, 2.01885025e+13, 1.67771811e+13,
                                      1.59833257e+13, 1.53266755e+13, 1.51577663e+13, 9.76717995e+13,
                                      9.37687965e+13, 9.14259200e+13, 7.69441488e+13, 6.47300242e+13,
                                      5.39452692e+13, 4.48478152e+13, 3.73695970e+13, 3.11416293e+13,
                                      2.59561343e+13, 2.16357840e+13, 1.80354921e+13, 1.50323830e+13,
                                      1.24532485e+13, 1.03176126e+13, 8.54881251e+12, 7.08397733e+12,
                                      5.87044611e+12, 4.86469292e+12, 4.02552041e+12, 3.31979155e+12,
                                      2.73801303e+12, 2.25833235e+12, 1.86265848e+12, 1.53578422e+12,
                                      1.26551156e+12, 1.04286664e+12, 8.59430874e+11, 7.08290262e+11,
                                      5.83766733e+11, 4.81167370e+11, 3.96605290e+11, 3.26927999e+11,
                                      2.69502447e+11, 2.22179208e+11, 1.83167089e+11, 1.51008064e+11,
                                      1.24502035e+11, 1.02654890e+11, 8.46426834e+10, 6.97937184e+10,
                                      5.75527259e+10, 4.74593702e+10, 3.91375015e+10, 3.22772438e+10]),
                     'ene': np.array([1.069000e+01, 1.142761e+01, 1.221612e+01, 1.305903e+01,
                                      1.396010e+01, 1.492335e+01, 1.595306e+01, 1.705382e+01,
                                      1.823053e+01, 1.948844e+01, 2.083314e+01, 2.227063e+01,
                                      2.380730e+01, 2.545001e+01, 2.720606e+01, 2.908327e+01,
                                      3.109002e+01, 3.323523e+01, 3.552846e+01, 3.797993e+01,
                                      4.060054e+01, 4.340198e+01, 4.639671e+01, 4.959809e+01,
                                      5.302035e+01, 5.478200e+01, 5.562050e+01, 5.584410e+01,
                                      5.617950e+01, 5.667876e+01, 5.701800e+01, 6.058959e+01,
                                      6.134800e+01, 6.228700e+01, 6.253740e+01, 6.291300e+01,
                                      6.385200e+01, 6.477028e+01, 6.923942e+01, 7.401695e+01,
                                      7.912411e+01, 8.458368e+01, 9.041995e+01, 9.329600e+01,
                                      9.472400e+01, 9.510480e+01, 9.567600e+01, 9.665893e+01,
                                      9.710400e+01, 1.033284e+02, 1.104581e+02, 1.180797e+02,
                                      1.262272e+02, 1.349368e+02, 1.442475e+02, 1.542005e+02,
                                      1.648404e+02, 1.762144e+02, 1.883732e+02, 2.013709e+02,
                                      2.152655e+02, 2.301188e+02, 2.459970e+02, 2.629708e+02,
                                      2.811158e+02, 3.005128e+02, 3.212482e+02, 3.434143e+02,
                                      3.593660e+02, 3.648665e+02, 3.653440e+02, 3.663333e+02,
                                      3.671099e+02, 3.685335e+02, 3.709360e+02, 3.724272e+02,
                                      3.740340e+02, 3.746640e+02, 3.802560e+02, 3.924405e+02,
                                      4.195189e+02, 4.484657e+02, 4.794098e+02, 5.124891e+02,
                                      5.478508e+02, 5.599720e+02, 5.685430e+02, 5.708286e+02,
                                      5.742570e+02, 5.828280e+02, 5.856525e+02, 5.903520e+02,
                                      5.993880e+02, 6.017976e+02, 6.054120e+02, 6.144480e+02,
                                      6.260625e+02, 6.692609e+02, 7.031500e+02, 7.139125e+02,
                                      7.154399e+02, 7.167825e+02, 7.210875e+02, 7.318500e+02,
                                      7.648052e+02, 8.175768e+02, 8.739896e+02, 9.342948e+02,
                                      9.987612e+02, 1.067676e+03, 1.141345e+03, 1.220098e+03,
                                      1.304285e+03, 1.394281e+03, 1.490486e+03, 1.593329e+03,
                                      1.703269e+03, 1.820795e+03, 1.946430e+03, 2.080733e+03,
                                      2.224304e+03, 2.377781e+03, 2.541848e+03, 2.717235e+03,
                                      2.904724e+03, 3.105150e+03, 3.284078e+03, 3.319406e+03,
                                      3.334344e+03, 3.347749e+03, 3.367855e+03, 3.418122e+03,
                                      3.453226e+03, 3.506081e+03, 3.520176e+03, 3.541318e+03,
                                      3.548445e+03, 3.594174e+03, 3.729684e+03, 3.786771e+03,
                                      3.793288e+03, 3.801994e+03, 3.824829e+03, 3.881916e+03,
                                      4.055024e+03, 4.334821e+03, 4.633924e+03, 4.953664e+03,
                                      5.295467e+03, 5.660855e+03, 6.051453e+03, 6.469004e+03,
                                      6.915365e+03, 7.392525e+03, 7.902609e+03, 8.447890e+03,
                                      9.030794e+03, 9.653919e+03, 1.032004e+04, 1.103212e+04,
                                      1.179334e+04, 1.260708e+04, 1.347697e+04, 1.440688e+04,
                                      1.540095e+04, 1.646362e+04, 1.759961e+04, 1.881398e+04,
                                      2.011215e+04, 2.149988e+04, 2.298338e+04, 2.456923e+04,
                                      2.500372e+04, 2.538643e+04, 2.548849e+04, 2.564157e+04,
                                      2.602428e+04, 2.626450e+04, 2.807676e+04, 3.001405e+04,
                                      3.208502e+04, 3.429889e+04, 3.666551e+04, 3.919543e+04,
                                      4.189992e+04, 4.479101e+04, 4.788159e+04, 5.118542e+04,
                                      5.471721e+04, 5.849270e+04, 6.252870e+04, 6.684318e+04,
                                      7.145536e+04, 7.638578e+04, 8.165640e+04, 8.729069e+04,
                                      9.331374e+04, 9.975239e+04, 1.066353e+05, 1.139931e+05,
                                      1.218587e+05, 1.302669e+05, 1.392553e+05, 1.488640e+05,
                                      1.591356e+05, 1.701159e+05, 1.818539e+05, 1.944018e+05,
                                      2.078156e+05, 2.221548e+05, 2.374835e+05, 2.538699e+05,
                                      2.713869e+05, 2.901126e+05, 3.101304e+05, 3.315294e+05,
                                      3.544049e+05, 3.788588e+05, 4.050001e+05, 4.329451e+05]), },
              '48': {'name': 'Cd',
                     'barns': 1866610000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9.299999999999999,
                            'factor': 1.0, 'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9.299999999999999,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 66.9, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 66.9, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 107.6, 'factor': 1.0},
                     'M5': {'filename': 'Cd.M5', 'excl before': 5, 'excl after': 50, 'onset': 403.7, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'delayed'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 410.5,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Cd.M3', 'excl before': 5, 'excl after': 50, 'onset': 616.5, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 650.6999999999999,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 770.2, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3537.5, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3727.0, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4018.0, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 26711.2, 'factor': 1.0},
                     'dat': np.array([1.85007184e+17, 1.72431832e+17, 1.01496919e+17, 8.91250277e+16,
                                      8.85370455e+16, 9.63170760e+16, 1.11625145e+17, 1.34666578e+17,
                                      1.65908030e+17, 2.05495095e+17, 2.52701662e+17, 3.05508059e+17,
                                      3.60442391e+17, 4.12782135e+17, 4.57207453e+17, 4.88827827e+17,
                                      5.04040698e+17, 5.01446110e+17, 4.81846705e+17, 4.48079730e+17,
                                      4.04195729e+17, 3.54674566e+17, 3.03529452e+17, 2.54288280e+17,
                                      2.09396310e+17, 1.70148968e+17, 1.36927043e+17, 1.09500942e+17,
                                      8.72845502e+16, 6.95424222e+16, 6.67331741e+16, 6.33863424e+16,
                                      6.25314350e+16, 9.67893283e+16, 9.07377787e+16, 8.51958136e+16,
                                      6.42505828e+16, 4.96126272e+16, 3.93668049e+16, 3.19264974e+16,
                                      2.63863990e+16, 2.21827932e+16, 2.11094925e+16, 2.03591153e+16,
                                      2.01687210e+16, 2.14137499e+16, 2.07567032e+16, 2.04841781e+16,
                                      1.80025201e+16, 1.60433263e+16, 1.44649209e+16, 1.31719201e+16,
                                      1.20930195e+16, 1.11752074e+16, 1.03996310e+16, 9.84319451e+15,
                                      9.33790319e+15, 8.86919742e+15, 8.42643752e+15, 8.00159709e+15,
                                      7.58944960e+15, 7.18514187e+15, 6.78456737e+15, 6.38791274e+15,
                                      5.99611130e+15, 5.61028302e+15, 5.23192117e+15, 5.18674921e+15,
                                      5.10219177e+15, 5.09379203e+15, 5.07997912e+15, 1.84047746e+16,
                                      1.85182645e+16, 1.85871424e+16, 2.77658238e+16, 2.78255553e+16,
                                      2.82922078e+16, 2.83556725e+16, 3.06366699e+16, 3.20851593e+16,
                                      3.18872986e+16, 3.05302732e+16, 2.83594057e+16, 2.71797082e+16,
                                      2.65842596e+16, 2.64255978e+16, 2.98638934e+16, 2.94103072e+16,
                                      2.92180463e+16, 2.86057982e+16, 2.79394185e+16, 2.77639571e+16,
                                      2.89865867e+16, 2.83258068e+16, 2.79562180e+16, 2.49192435e+16,
                                      2.24758510e+16, 2.18990685e+16, 2.18113378e+16, 2.16377431e+16,
                                      2.23433217e+16, 2.17030745e+16, 2.00473914e+16, 1.75130950e+16,
                                      1.52651366e+16, 1.32917565e+16, 1.14342929e+16, 9.79858253e+15,
                                      8.38518544e+15, 7.16946235e+15, 6.12229414e+15, 5.22800129e+15,
                                      4.46549110e+15, 3.79313818e+15, 3.21784898e+15, 2.73439699e+15,
                                      2.32710269e+15, 1.98383311e+15, 1.69389258e+15, 1.44516679e+15,
                                      1.22873336e+15, 1.04500294e+15, 8.78874652e+14, 7.30833813e+14,
                                      6.48684307e+14, 6.22271776e+14, 6.15495981e+14, 2.09116318e+15,
                                      2.08164347e+15, 2.00959233e+15, 1.95228740e+15, 1.88322283e+15,
                                      1.86431407e+15, 2.53242979e+15, 2.45440549e+15, 2.44115256e+15,
                                      2.23377219e+15, 2.14697482e+15, 2.12457550e+15, 2.41147346e+15,
                                      2.38627422e+15, 2.32318281e+15, 2.01369887e+15, 1.69605784e+15,
                                      1.42605271e+15, 1.19873694e+15, 1.00712943e+15, 8.46600966e+14,
                                      7.11962386e+14, 5.99013815e+14, 5.03182058e+14, 4.21909858e+14,
                                      3.53554600e+14, 2.95689690e+14, 2.45309886e+14, 2.03703149e+14,
                                      1.69312727e+14, 1.40830125e+14, 1.17159643e+14, 9.75434388e+13,
                                      8.12927321e+13, 6.77560764e+13, 5.63249568e+13, 4.67791132e+13,
                                      3.87265577e+13, 3.20907591e+13, 2.66141254e+13, 2.20931960e+13,
                                      1.83558694e+13, 1.54056923e+13, 1.52645766e+13, 1.47740315e+13,
                                      1.46116364e+13, 9.28937133e+13, 8.91996921e+13, 8.21607058e+13,
                                      6.87360466e+13, 5.75979848e+13, 4.82966671e+13, 4.03523750e+13,
                                      3.36643114e+13, 2.80682146e+13, 2.33886233e+13, 1.94836752e+13,
                                      1.62268141e+13, 1.34905505e+13, 1.11809939e+13, 9.26753199e+12,
                                      7.68222012e+12, 6.36868666e+12, 5.28007971e+12, 4.37066732e+12,
                                      3.60591720e+12, 2.97500302e+12, 2.45477881e+12, 2.02545851e+12,
                                      1.67151192e+12, 1.37847282e+12, 1.13663483e+12, 9.37280879e+11,
                                      7.72925869e+11, 6.37428649e+11, 5.25712040e+11, 4.33594837e+11,
                                      3.57623810e+11, 2.94980378e+11, 2.43331280e+11, 2.00735239e+11,
                                      1.65590706e+11, 1.36611586e+11, 1.12705912e+11, 9.29889104e+10,
                                      7.67232708e+10, 6.33042115e+10, 5.22352142e+10, 4.31037581e+10,
                                      3.55682536e+10]),
                     'ene': np.array([9.346500e+00, 9.486000e+00, 1.069000e+01, 1.142761e+01,
                                      1.221612e+01, 1.305903e+01, 1.396010e+01, 1.492335e+01,
                                      1.595306e+01, 1.705382e+01, 1.823053e+01, 1.948844e+01,
                                      2.083314e+01, 2.227063e+01, 2.380730e+01, 2.545001e+01,
                                      2.720606e+01, 2.908327e+01, 3.109002e+01, 3.323523e+01,
                                      3.552846e+01, 3.797993e+01, 4.060054e+01, 4.340198e+01,
                                      4.639671e+01, 4.959809e+01, 5.302035e+01, 5.667876e+01,
                                      6.058959e+01, 6.477028e+01, 6.556200e+01, 6.656550e+01,
                                      6.683310e+01, 6.723450e+01, 6.823800e+01, 6.923942e+01,
                                      7.401695e+01, 7.912411e+01, 8.458368e+01, 9.041995e+01,
                                      9.665893e+01, 1.033284e+02, 1.054480e+02, 1.070620e+02,
                                      1.074924e+02, 1.081380e+02, 1.097520e+02, 1.104581e+02,
                                      1.180797e+02, 1.262272e+02, 1.349368e+02, 1.442475e+02,
                                      1.542005e+02, 1.648404e+02, 1.762144e+02, 1.883732e+02,
                                      2.013709e+02, 2.152655e+02, 2.301188e+02, 2.459970e+02,
                                      2.629708e+02, 2.811158e+02, 3.005128e+02, 3.212482e+02,
                                      3.434143e+02, 3.671099e+02, 3.924405e+02, 3.956260e+02,
                                      4.016815e+02, 4.022900e+02, 4.032963e+02, 4.057185e+02,
                                      4.084475e+02, 4.100895e+02, 4.117740e+02, 4.125525e+02,
                                      4.187100e+02, 4.195189e+02, 4.484657e+02, 4.794098e+02,
                                      5.124891e+02, 5.478508e+02, 5.856525e+02, 6.041700e+02,
                                      6.134175e+02, 6.158835e+02, 6.195825e+02, 6.260625e+02,
                                      6.288300e+02, 6.376860e+02, 6.474465e+02, 6.500493e+02,
                                      6.539535e+02, 6.637140e+02, 6.692609e+02, 7.154399e+02,
                                      7.547960e+02, 7.648052e+02, 7.663490e+02, 7.694298e+02,
                                      7.740510e+02, 7.856040e+02, 8.175768e+02, 8.739896e+02,
                                      9.342948e+02, 9.987612e+02, 1.067676e+03, 1.141345e+03,
                                      1.220098e+03, 1.304285e+03, 1.394281e+03, 1.490486e+03,
                                      1.593329e+03, 1.703269e+03, 1.820795e+03, 1.946430e+03,
                                      2.080733e+03, 2.224304e+03, 2.377781e+03, 2.541848e+03,
                                      2.717235e+03, 2.904724e+03, 3.105150e+03, 3.319406e+03,
                                      3.466750e+03, 3.519812e+03, 3.533962e+03, 3.548445e+03,
                                      3.555187e+03, 3.608250e+03, 3.652460e+03, 3.708365e+03,
                                      3.723273e+03, 3.745635e+03, 3.793288e+03, 3.801540e+03,
                                      3.937640e+03, 3.997910e+03, 4.013982e+03, 4.038090e+03,
                                      4.055024e+03, 4.098360e+03, 4.334821e+03, 4.633924e+03,
                                      4.953664e+03, 5.295467e+03, 5.660855e+03, 6.051453e+03,
                                      6.469004e+03, 6.915365e+03, 7.392525e+03, 7.902609e+03,
                                      8.447890e+03, 9.030794e+03, 9.653919e+03, 1.032004e+04,
                                      1.103212e+04, 1.179334e+04, 1.260708e+04, 1.347697e+04,
                                      1.440688e+04, 1.540095e+04, 1.646362e+04, 1.759961e+04,
                                      1.881398e+04, 2.011215e+04, 2.149988e+04, 2.298338e+04,
                                      2.456923e+04, 2.617698e+04, 2.626450e+04, 2.657764e+04,
                                      2.668449e+04, 2.684476e+04, 2.724542e+04, 2.807676e+04,
                                      3.001405e+04, 3.208502e+04, 3.429889e+04, 3.666551e+04,
                                      3.919543e+04, 4.189992e+04, 4.479101e+04, 4.788159e+04,
                                      5.118542e+04, 5.471721e+04, 5.849270e+04, 6.252870e+04,
                                      6.684318e+04, 7.145536e+04, 7.638578e+04, 8.165640e+04,
                                      8.729069e+04, 9.331374e+04, 9.975239e+04, 1.066353e+05,
                                      1.139931e+05, 1.218587e+05, 1.302669e+05, 1.392553e+05,
                                      1.488640e+05, 1.591356e+05, 1.701159e+05, 1.818539e+05,
                                      1.944018e+05, 2.078156e+05, 2.221548e+05, 2.374835e+05,
                                      2.538699e+05, 2.713869e+05, 2.901126e+05, 3.101304e+05,
                                      3.315294e+05, 3.544049e+05, 3.788588e+05, 4.050001e+05,
                                      4.329451e+05]), },
              '49': {'name': 'In',
                     'barns': 1906630000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 16.2, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 16.2,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 77.39999999999999,
                            'factor': 1.0, 'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 77.39999999999999,
                            'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 121.89999999999999,
                            'factor': 1.0},
                     'M5': {'filename': 'In.M5', 'excl before': 5, 'excl after': 50, 'onset': 443.09999999999997,
                            'factor': 1.0, 'twin': 'M4', 'shape': 'delayed'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 450.79999999999995,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'In.M3', 'excl before': 5, 'excl after': 50, 'onset': 664.3, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 702.2, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 825.6, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3730.1000000000004,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3938.0, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4237.5, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 27939.9, 'factor': 1.0},
                     'dat': np.array([8.28735796e+16, 8.31576674e+16, 8.37658824e+16, 8.53541052e+16,
                                      9.06926692e+16, 1.00223913e+17, 1.13484524e+17, 1.30049326e+17,
                                      1.49329168e+17, 1.70441282e+17, 1.92188304e+17, 2.13084969e+17,
                                      2.31541147e+17, 2.46031535e+17, 2.55374022e+17, 2.58786890e+17,
                                      2.56117608e+17, 2.47747502e+17, 2.34534556e+17, 2.17622748e+17,
                                      1.98289520e+17, 1.77768461e+17, 1.57131098e+17, 1.37216348e+17,
                                      1.18651492e+17, 1.12262374e+17, 1.08424328e+17, 1.07427161e+17,
                                      1.26539220e+17, 1.21482837e+17, 1.20739251e+17, 1.00479401e+17,
                                      8.39489189e+16, 7.06711476e+16, 5.98548356e+16, 5.09832862e+16,
                                      4.36808933e+16, 4.25464484e+16, 4.11202892e+16, 4.07542162e+16,
                                      4.17590103e+16, 4.04701284e+16, 3.92155658e+16, 3.42640477e+16,
                                      3.01495402e+16, 2.67061664e+16, 2.38061822e+16, 2.13447228e+16,
                                      1.92378967e+16, 1.74164931e+16, 1.58269356e+16, 1.44244186e+16,
                                      1.31740506e+16, 1.20481856e+16, 1.10254693e+16, 1.00893140e+16,
                                      9.26412451e+15, 8.50376046e+15, 7.79315946e+15, 7.12869891e+15,
                                      6.50713753e+15, 6.20207673e+15, 6.07109125e+15, 6.05374091e+15,
                                      6.03677191e+15, 2.77052405e+16, 2.75469902e+16, 2.75431770e+16,
                                      2.74554720e+16, 4.20106854e+16, 4.19306070e+16, 4.14425097e+16,
                                      4.01002422e+16, 3.78141928e+16, 3.48570097e+16, 3.15509132e+16,
                                      2.81952444e+16, 2.62924277e+16, 2.55717216e+16, 2.53848718e+16,
                                      2.85670373e+16, 2.84450130e+16, 2.78387046e+16, 2.70932123e+16,
                                      2.63763194e+16, 2.61894697e+16, 2.73220079e+16, 2.66851935e+16,
                                      2.66337145e+16, 2.36955976e+16, 2.11712195e+16, 2.07269747e+16,
                                      2.05267786e+16, 2.03609018e+16, 2.10263156e+16, 2.04104742e+16,
                                      1.89364585e+16, 1.65356300e+16, 1.44339518e+16, 1.24018655e+16,
                                      1.06445246e+16, 9.10968748e+15, 7.78839289e+15, 6.66043058e+15,
                                      5.69129055e+15, 4.86190650e+15, 4.15569075e+15, 3.54385318e+15,
                                      3.00523021e+15, 2.55240558e+15, 2.17146091e+15, 1.85006029e+15,
                                      1.57872777e+15, 1.34711036e+15, 1.14584650e+15, 9.62924415e+14,
                                      8.01261258e+14, 6.66958240e+14, 6.14926308e+14, 5.89987587e+14,
                                      5.83581310e+14, 2.01492658e+15, 1.94361862e+15, 1.92588696e+15,
                                      1.84424507e+15, 1.76132573e+15, 1.74132518e+15, 2.38862606e+15,
                                      2.28871865e+15, 2.22751583e+15, 2.08261195e+15, 1.99795758e+15,
                                      1.97641266e+15, 2.24753544e+15, 2.16421571e+15, 2.14820002e+15,
                                      1.81770478e+15, 1.53973719e+15, 1.29864383e+15, 1.09259432e+15,
                                      9.17889815e+14, 7.70983973e+14, 6.47758476e+14, 5.44590727e+14,
                                      4.57209874e+14, 3.83613956e+14, 3.20809564e+14, 2.66089283e+14,
                                      2.20921218e+14, 1.83579870e+14, 1.52694370e+14, 1.27109302e+14,
                                      1.05827498e+14, 8.81701977e+13, 7.35329992e+13, 6.12924346e+13,
                                      5.09718464e+13, 4.23214661e+13, 3.50610191e+13, 2.90722942e+13,
                                      2.41264960e+13, 2.00405879e+13, 1.66624209e+13, 1.47750479e+13,
                                      1.41239337e+13, 1.39569129e+13, 8.83074751e+13, 8.82826889e+13,
                                      8.48374085e+13, 7.38475932e+13, 6.18377308e+13, 5.18050437e+13,
                                      4.33815524e+13, 3.61973706e+13, 3.01895794e+13, 2.51675160e+13,
                                      2.09748366e+13, 1.74761706e+13, 1.45603613e+13, 1.20908941e+13,
                                      1.00256325e+13, 8.31386012e+12, 6.89494607e+12, 5.71855536e+12,
                                      4.73587826e+12, 3.90859150e+12, 3.22601796e+12, 2.66279946e+12,
                                      2.19796306e+12, 1.81448257e+12, 1.49788666e+12, 1.23587757e+12,
                                      1.01976106e+12, 8.41491150e+11, 6.94413712e+11, 5.73075779e+11,
                                      4.72958638e+11, 3.90344360e+11, 3.22182337e+11, 2.65936752e+11,
                                      2.19529378e+11, 1.81211835e+11, 1.49594190e+11, 1.23498145e+11,
                                      1.01958946e+11, 8.41796211e+10, 6.95023834e+10, 5.73876564e+10,
                                      4.73854754e+10, 3.91278609e+10]),
                     'ene': np.array([1.628100e+01, 1.652400e+01, 1.705382e+01, 1.823053e+01,
                                      1.948844e+01, 2.083314e+01, 2.227063e+01, 2.380730e+01,
                                      2.545001e+01, 2.720606e+01, 2.908327e+01, 3.109002e+01,
                                      3.323523e+01, 3.552846e+01, 3.797993e+01, 4.060054e+01,
                                      4.340198e+01, 4.639671e+01, 4.959809e+01, 5.302035e+01,
                                      5.667876e+01, 6.058959e+01, 6.477028e+01, 6.923942e+01,
                                      7.401695e+01, 7.585200e+01, 7.701300e+01, 7.732260e+01,
                                      7.778700e+01, 7.894800e+01, 7.912411e+01, 8.458368e+01,
                                      9.041995e+01, 9.665893e+01, 1.033284e+02, 1.104581e+02,
                                      1.180797e+02, 1.194620e+02, 1.212905e+02, 1.217781e+02,
                                      1.225095e+02, 1.243380e+02, 1.262272e+02, 1.349368e+02,
                                      1.442475e+02, 1.542005e+02, 1.648404e+02, 1.762144e+02,
                                      1.883732e+02, 2.013709e+02, 2.152655e+02, 2.301188e+02,
                                      2.459970e+02, 2.629708e+02, 2.811158e+02, 3.005128e+02,
                                      3.212482e+02, 3.434143e+02, 3.671099e+02, 3.924405e+02,
                                      4.195189e+02, 4.342380e+02, 4.408845e+02, 4.417840e+02,
                                      4.426569e+02, 4.453155e+02, 4.484657e+02, 4.485460e+02,
                                      4.503492e+02, 4.519620e+02, 4.530540e+02, 4.598160e+02,
                                      4.794098e+02, 5.124891e+02, 5.478508e+02, 5.856525e+02,
                                      6.260625e+02, 6.510140e+02, 6.609785e+02, 6.636357e+02,
                                      6.676215e+02, 6.692609e+02, 6.775860e+02, 6.881560e+02,
                                      6.986890e+02, 7.014978e+02, 7.057110e+02, 7.154399e+02,
                                      7.162440e+02, 7.648052e+02, 8.090880e+02, 8.175768e+02,
                                      8.214720e+02, 8.247744e+02, 8.297280e+02, 8.421120e+02,
                                      8.739896e+02, 9.342948e+02, 9.987612e+02, 1.067676e+03,
                                      1.141345e+03, 1.220098e+03, 1.304285e+03, 1.394281e+03,
                                      1.490486e+03, 1.593329e+03, 1.703269e+03, 1.820795e+03,
                                      1.946430e+03, 2.080733e+03, 2.224304e+03, 2.377781e+03,
                                      2.541848e+03, 2.717235e+03, 2.904724e+03, 3.105150e+03,
                                      3.319406e+03, 3.548445e+03, 3.655498e+03, 3.711449e+03,
                                      3.726370e+03, 3.748750e+03, 3.793288e+03, 3.804702e+03,
                                      3.859240e+03, 3.918310e+03, 3.934062e+03, 3.957690e+03,
                                      4.016760e+03, 4.055024e+03, 4.152750e+03, 4.216313e+03,
                                      4.233263e+03, 4.258688e+03, 4.322250e+03, 4.334821e+03,
                                      4.633924e+03, 4.953664e+03, 5.295467e+03, 5.660855e+03,
                                      6.051453e+03, 6.469004e+03, 6.915365e+03, 7.392525e+03,
                                      7.902609e+03, 8.447890e+03, 9.030794e+03, 9.653919e+03,
                                      1.032004e+04, 1.103212e+04, 1.179334e+04, 1.260708e+04,
                                      1.347697e+04, 1.440688e+04, 1.540095e+04, 1.646362e+04,
                                      1.759961e+04, 1.881398e+04, 2.011215e+04, 2.149988e+04,
                                      2.298338e+04, 2.456923e+04, 2.626450e+04, 2.738110e+04,
                                      2.780020e+04, 2.791196e+04, 2.807676e+04, 2.807960e+04,
                                      2.849870e+04, 3.001405e+04, 3.208502e+04, 3.429889e+04,
                                      3.666551e+04, 3.919543e+04, 4.189992e+04, 4.479101e+04,
                                      4.788159e+04, 5.118542e+04, 5.471721e+04, 5.849270e+04,
                                      6.252870e+04, 6.684318e+04, 7.145536e+04, 7.638578e+04,
                                      8.165640e+04, 8.729069e+04, 9.331374e+04, 9.975239e+04,
                                      1.066353e+05, 1.139931e+05, 1.218587e+05, 1.302669e+05,
                                      1.392553e+05, 1.488640e+05, 1.591356e+05, 1.701159e+05,
                                      1.818539e+05, 1.944018e+05, 2.078156e+05, 2.221548e+05,
                                      2.374835e+05, 2.538699e+05, 2.713869e+05, 2.901126e+05,
                                      3.101304e+05, 3.315294e+05, 3.544049e+05, 3.788588e+05,
                                      4.050001e+05, 4.329451e+05]), },
              '50': {'name': 'Sn',
                     'barns': 1970900000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 23.900000000000002,
                            'factor': 1.0, 'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 23.900000000000002,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 88.6, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 88.6, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 136.5, 'factor': 1.0},
                     'M5': {'filename': 'Sn.M5', 'excl before': 5, 'excl after': 50, 'onset': 484.8, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'delayed'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 493.3,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Sn.M3', 'excl before': 5, 'excl after': 50, 'onset': 714.4000000000001,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 756.4, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 883.8000000000001,
                            'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3928.7999999999997,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4156.1, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4464.7, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 29200.1, 'factor': 1.0},
                     'dat': np.array([2.07437225e+16, 2.47131151e+16, 4.11050904e+16, 8.77503807e+16,
                                      1.53743996e+17, 2.22731409e+17, 2.76221635e+17, 3.02217806e+17,
                                      2.99458546e+17, 2.74782878e+17, 2.38025593e+17, 1.97779815e+17,
                                      1.59784805e+17, 1.26922018e+17, 1.00029088e+17, 7.87886984e+16,
                                      6.23789850e+16, 4.98558864e+16, 4.03522066e+16, 3.31485671e+16,
                                      2.76714360e+16, 2.58956551e+16, 2.49476522e+16, 2.47072024e+16,
                                      3.75633831e+16, 3.59413324e+16, 2.99143202e+16, 2.54384063e+16,
                                      2.22593446e+16, 1.99356535e+16, 1.81955459e+16, 1.70183273e+16,
                                      1.68634146e+16, 1.67506791e+16, 1.66824860e+16, 1.80968038e+16,
                                      1.78632522e+16, 1.73521978e+16, 1.65364423e+16, 1.58485982e+16,
                                      1.52415610e+16, 1.46834021e+16, 1.41500766e+16, 1.36246346e+16,
                                      1.30944625e+16, 1.25518737e+16, 1.19925323e+16, 1.14152557e+16,
                                      1.08214235e+16, 1.02139922e+16, 9.59788882e+15, 8.97804077e+15,
                                      8.35878399e+15, 7.74662245e+15, 7.14845430e+15, 6.58280600e+15,
                                      6.49628349e+15, 6.43735358e+15, 6.41665913e+15, 6.39931521e+15,
                                      3.55589778e+16, 3.50130385e+16, 3.47193744e+16, 5.38114827e+16,
                                      5.35138768e+16, 5.18267864e+16, 4.98105557e+16, 4.31232920e+16,
                                      3.74293619e+16, 3.25336463e+16, 2.82646769e+16, 2.56808270e+16,
                                      2.48589617e+16, 2.46461045e+16, 2.78547297e+16, 2.76576397e+16,
                                      2.68436580e+16, 2.59311313e+16, 2.51467131e+16, 2.49437104e+16,
                                      2.59863165e+16, 2.56788561e+16, 2.52413163e+16, 2.25135907e+16,
                                      2.00125186e+16, 1.96423836e+16, 1.93938531e+16, 1.92334218e+16,
                                      1.98568175e+16, 1.92671242e+16, 1.79103567e+16, 1.56250981e+16,
                                      1.34255737e+16, 1.15291737e+16, 9.89707144e+15, 8.46895730e+15,
                                      7.23753898e+15, 6.18665510e+15, 5.28615089e+15, 4.51690862e+15,
                                      3.85882511e+15, 3.29770988e+15, 2.79788964e+15, 2.37552577e+15,
                                      2.02017250e+15, 1.72057599e+15, 1.46755185e+15, 1.25230986e+15,
                                      1.05318983e+15, 8.76124177e+14, 7.30041069e+14, 6.08475957e+14,
                                      5.84352141e+14, 5.60780177e+14, 5.54729514e+14, 1.91488702e+15,
                                      1.82485631e+15, 1.75613103e+15, 1.73112031e+15, 1.64950534e+15,
                                      1.63026935e+15, 2.24308129e+15, 2.14571883e+15, 2.00913546e+15,
                                      1.95607883e+15, 1.87548873e+15, 1.85497166e+15, 2.11181935e+15,
                                      2.03298335e+15, 1.94537684e+15, 1.64960388e+15, 1.39837326e+15,
                                      1.17944569e+15, 9.91973679e+14, 8.33178266e+14, 6.99689209e+14,
                                      5.87840634e+14, 4.94203175e+14, 4.14933577e+14, 3.47489379e+14,
                                      2.88184998e+14, 2.39208133e+14, 1.98745556e+14, 1.65263907e+14,
                                      1.37556995e+14, 1.14596010e+14, 9.54822214e+13, 7.96046510e+13,
                                      6.64350972e+13, 5.53744064e+13, 4.60697875e+13, 3.82374309e+13,
                                      3.16979847e+13, 2.62996896e+13, 2.18415138e+13, 1.81551424e+13,
                                      1.49453347e+13, 1.41270170e+13, 1.35065777e+13, 1.33473290e+13,
                                      8.41199829e+13, 8.08069000e+13, 7.91375477e+13, 6.61650839e+13,
                                      5.54295916e+13, 4.64679093e+13, 3.88799443e+13, 3.24469267e+13,
                                      2.70624279e+13, 2.25589214e+13, 1.88000209e+13, 1.56639248e+13,
                                      1.30497231e+13, 1.08249712e+13, 8.98001167e+12, 7.45019909e+12,
                                      6.18153076e+12, 5.12138365e+12, 4.22817177e+12, 3.49105517e+12,
                                      2.88263834e+12, 2.38045302e+12, 1.96587420e+12, 1.62358800e+12,
                                      1.34074414e+12, 1.10697569e+12, 9.14004875e+11, 7.54736446e+11,
                                      6.23237998e+11, 5.14680826e+11, 4.25044294e+11, 3.51056708e+11,
                                      2.89939099e+11, 2.39484059e+11, 1.97819233e+11, 1.63405348e+11,
                                      1.34984970e+11, 1.11513522e+11, 9.21257787e+10, 7.61122162e+10,
                                      6.28835354e+10, 5.19568658e+10, 4.29301438e+10]),
                     'ene': np.array([2.401950e+01, 2.437800e+01, 2.545001e+01, 2.720606e+01,
                                      2.908327e+01, 3.109002e+01, 3.323523e+01, 3.552846e+01,
                                      3.797993e+01, 4.060054e+01, 4.340198e+01, 4.639671e+01,
                                      4.959809e+01, 5.302035e+01, 5.667876e+01, 6.058959e+01,
                                      6.477028e+01, 6.923942e+01, 7.401695e+01, 7.912411e+01,
                                      8.458368e+01, 8.682800e+01, 8.815700e+01, 8.851140e+01,
                                      8.904300e+01, 9.041995e+01, 9.665893e+01, 1.033284e+02,
                                      1.104581e+02, 1.180797e+02, 1.262272e+02, 1.337700e+02,
                                      1.349368e+02, 1.358175e+02, 1.363635e+02, 1.371825e+02,
                                      1.392300e+02, 1.442475e+02, 1.542005e+02, 1.648404e+02,
                                      1.762144e+02, 1.883732e+02, 2.013709e+02, 2.152655e+02,
                                      2.301188e+02, 2.459970e+02, 2.629708e+02, 2.811158e+02,
                                      3.005128e+02, 3.212482e+02, 3.434143e+02, 3.671099e+02,
                                      3.924405e+02, 4.195189e+02, 4.484657e+02, 4.751040e+02,
                                      4.794098e+02, 4.823760e+02, 4.834340e+02, 4.843152e+02,
                                      4.872240e+02, 4.908335e+02, 4.928067e+02, 4.944960e+02,
                                      4.957665e+02, 5.031660e+02, 5.124891e+02, 5.478508e+02,
                                      5.856525e+02, 6.260625e+02, 6.692609e+02, 7.001120e+02,
                                      7.108280e+02, 7.136856e+02, 7.154399e+02, 7.179720e+02,
                                      7.286880e+02, 7.412720e+02, 7.526180e+02, 7.556436e+02,
                                      7.601820e+02, 7.648052e+02, 7.715280e+02, 8.175768e+02,
                                      8.661240e+02, 8.739896e+02, 8.793810e+02, 8.829162e+02,
                                      8.882190e+02, 9.014760e+02, 9.342948e+02, 9.987612e+02,
                                      1.067676e+03, 1.141345e+03, 1.220098e+03, 1.304285e+03,
                                      1.394281e+03, 1.490486e+03, 1.593329e+03, 1.703269e+03,
                                      1.820795e+03, 1.946430e+03, 2.080733e+03, 2.224304e+03,
                                      2.377781e+03, 2.541848e+03, 2.717235e+03, 2.904724e+03,
                                      3.105150e+03, 3.319406e+03, 3.548445e+03, 3.793288e+03,
                                      3.850224e+03, 3.909156e+03, 3.924871e+03, 3.948444e+03,
                                      4.007376e+03, 4.055024e+03, 4.072978e+03, 4.135319e+03,
                                      4.151944e+03, 4.176880e+03, 4.239222e+03, 4.334821e+03,
                                      4.375406e+03, 4.442377e+03, 4.460236e+03, 4.487024e+03,
                                      4.553994e+03, 4.633924e+03, 4.953664e+03, 5.295467e+03,
                                      5.660855e+03, 6.051453e+03, 6.469004e+03, 6.915365e+03,
                                      7.392525e+03, 7.902609e+03, 8.447890e+03, 9.030794e+03,
                                      9.653919e+03, 1.032004e+04, 1.103212e+04, 1.179334e+04,
                                      1.260708e+04, 1.347697e+04, 1.440688e+04, 1.540095e+04,
                                      1.646362e+04, 1.759961e+04, 1.881398e+04, 2.011215e+04,
                                      2.149988e+04, 2.298338e+04, 2.456923e+04, 2.626450e+04,
                                      2.807676e+04, 2.861610e+04, 2.905410e+04, 2.917090e+04,
                                      2.934610e+04, 2.978410e+04, 3.001405e+04, 3.208502e+04,
                                      3.429889e+04, 3.666551e+04, 3.919543e+04, 4.189992e+04,
                                      4.479101e+04, 4.788159e+04, 5.118542e+04, 5.471721e+04,
                                      5.849270e+04, 6.252870e+04, 6.684318e+04, 7.145536e+04,
                                      7.638578e+04, 8.165640e+04, 8.729069e+04, 9.331374e+04,
                                      9.975239e+04, 1.066353e+05, 1.139931e+05, 1.218587e+05,
                                      1.302669e+05, 1.392553e+05, 1.488640e+05, 1.591356e+05,
                                      1.701159e+05, 1.818539e+05, 1.944018e+05, 2.078156e+05,
                                      2.221548e+05, 2.374835e+05, 2.538699e+05, 2.713869e+05,
                                      2.901126e+05, 3.101304e+05, 3.315294e+05, 3.544049e+05,
                                      3.788588e+05, 4.050001e+05, 4.329451e+05]), },
              '51': {'name': 'Sb',
                     'barns': 2021710000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 31.4, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 31.4,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 98.4, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 98.4, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 152.0, 'factor': 1.0},
                     'M5': {'filename': 'Sb.M5', 'excl before': 5, 'excl after': 50, 'onset': 527.5, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'delayed'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 536.9000000000001,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Sb.M3', 'excl before': 5, 'excl after': 50, 'onset': 765.5999999999999,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 811.9, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 943.6999999999999,
                            'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4132.2, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4380.4, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4698.299999999999,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 30491.2, 'factor': 1.0},
                     'dat': np.array([5.70425476e+15, 8.07915750e+15, 1.92701310e+16, 8.80919698e+16,
                                      2.61386886e+17, 5.02859928e+17, 6.86289677e+17, 7.17626182e+17,
                                      6.13770939e+17, 4.53631290e+17, 3.03317151e+17, 1.90532016e+17,
                                      1.15932938e+17, 7.00158607e+16, 4.27753402e+16, 2.68200049e+16,
                                      1.74356314e+16, 1.18367077e+16, 8.52090114e+15, 8.42648728e+15,
                                      7.93783997e+15, 7.79389422e+15, 1.70070289e+16, 1.61516434e+16,
                                      1.46491085e+16, 1.19183848e+16, 1.00814591e+16, 8.86722006e+15,
                                      8.06480336e+15, 7.54643692e+15, 7.37075032e+15, 7.30120349e+15,
                                      7.28422113e+15, 8.74793917e+15, 8.71397444e+15, 8.69557688e+15,
                                      8.54192692e+15, 8.45944115e+15, 8.42426340e+15, 8.41698524e+15,
                                      8.43174373e+15, 8.45378036e+15, 8.45944115e+15, 8.43113721e+15,
                                      8.36826203e+15, 8.26697436e+15, 8.12383729e+15, 7.93763780e+15,
                                      7.71019543e+15, 7.44514925e+15, 7.14674485e+15, 6.82124954e+15,
                                      6.47735667e+15, 6.11041630e+15, 6.06128875e+15, 5.97475956e+15,
                                      5.96080976e+15, 5.95191424e+15, 3.77433040e+16, 3.69669674e+16,
                                      3.65666688e+16, 5.70647865e+16, 5.66099017e+16, 5.42404576e+16,
                                      4.49891126e+16, 3.76523270e+16, 3.19672785e+16, 2.73496929e+16,
                                      2.45213206e+16, 2.36843326e+16, 2.34700314e+16, 2.34680097e+16,
                                      2.63246859e+16, 2.55038716e+16, 2.45031252e+16, 2.37207234e+16,
                                      2.35185524e+16, 2.44990818e+16, 2.43979963e+16, 2.37571142e+16,
                                      2.12421070e+16, 1.88803453e+16, 1.84834837e+16, 1.82914212e+16,
                                      1.81385799e+16, 1.87175977e+16, 1.81592014e+16, 1.68396313e+16,
                                      1.44764545e+16, 1.24323035e+16, 1.06752353e+16, 9.16501794e+15,
                                      7.84221309e+15, 6.70055345e+15, 5.72649358e+15, 4.89253820e+15,
                                      4.18170496e+15, 3.57337242e+15, 3.05460164e+15, 2.59769518e+15,
                                      2.20588778e+15, 1.87628840e+15, 1.59838414e+15, 1.36372426e+15,
                                      1.15172775e+15, 9.59847257e+14, 7.99727825e+14, 6.67386688e+14,
                                      5.59103900e+14, 5.57061973e+14, 5.36683137e+14, 5.30921263e+14,
                                      1.81480820e+15, 1.72829923e+15, 1.62711264e+15, 1.57580164e+15,
                                      1.55055048e+15, 1.53239553e+15, 2.11005873e+15, 2.01760593e+15,
                                      1.84572014e+15, 1.81290779e+15, 1.76925907e+15, 1.74983044e+15,
                                      1.99304215e+15, 1.91852192e+15, 1.76481131e+15, 1.49847123e+15,
                                      1.26904758e+15, 1.06948459e+15, 8.99014003e+14, 7.55088468e+14,
                                      6.34230644e+14, 5.33044059e+14, 4.48172673e+14, 3.75653935e+14,
                                      3.12030721e+14, 2.58960834e+14, 2.15089727e+14, 1.78800032e+14,
                                      1.48775617e+14, 1.23906562e+14, 1.03287142e+14, 8.61066506e+13,
                                      7.18273129e+13, 5.99740272e+13, 4.99726278e+13, 4.15825313e+13,
                                      3.44944160e+13, 2.86152833e+13, 2.37591359e+13, 1.97448285e+13,
                                      1.62555593e+13, 1.35246334e+13, 1.33493511e+13, 1.29328789e+13,
                                      1.27810484e+13, 8.01405844e+13, 7.70089556e+13, 7.08225230e+13,
                                      5.93048411e+13, 4.96956535e+13, 4.16553128e+13, 3.47976725e+13,
                                      2.90337773e+13, 2.42140207e+13, 2.01847526e+13, 1.68226489e+13,
                                      1.40193458e+13, 1.16648624e+13, 9.68075616e+12, 8.03488205e+12,
                                      6.66941912e+12, 5.52735514e+12, 4.56461684e+12, 3.76988264e+12,
                                      3.11363557e+12, 2.57201946e+12, 2.12461504e+12, 1.75510710e+12,
                                      1.44999063e+12, 1.19782274e+12, 9.89525960e+11, 8.17498656e+11,
                                      6.75392660e+11, 5.58032394e+11, 4.61091400e+11, 3.81011467e+11,
                                      3.14840898e+11, 2.60173860e+11, 2.15008858e+11, 1.77702244e+11,
                                      1.46869145e+11, 1.21389534e+11, 1.00335446e+11, 8.29345876e+10,
                                      6.85541644e+10, 5.66685313e+10, 4.68470641e+10]),
                     'ene': np.array([3.155700e+01, 3.202800e+01, 3.323523e+01, 3.552846e+01,
                                      3.797993e+01, 4.060054e+01, 4.340198e+01, 4.639671e+01,
                                      4.959809e+01, 5.302035e+01, 5.667876e+01, 6.058959e+01,
                                      6.477028e+01, 6.923942e+01, 7.401695e+01, 7.912411e+01,
                                      8.458368e+01, 9.041995e+01, 9.643200e+01, 9.665893e+01,
                                      9.790800e+01, 9.830160e+01, 9.889200e+01, 1.003680e+02,
                                      1.033284e+02, 1.104581e+02, 1.180797e+02, 1.262272e+02,
                                      1.349368e+02, 1.442475e+02, 1.489600e+02, 1.512400e+02,
                                      1.518480e+02, 1.527600e+02, 1.542005e+02, 1.550400e+02,
                                      1.648404e+02, 1.762144e+02, 1.883732e+02, 2.013709e+02,
                                      2.152655e+02, 2.301188e+02, 2.459970e+02, 2.629708e+02,
                                      2.811158e+02, 3.005128e+02, 3.212482e+02, 3.434143e+02,
                                      3.671099e+02, 3.924405e+02, 4.195189e+02, 4.484657e+02,
                                      4.794098e+02, 5.124891e+02, 5.169500e+02, 5.248625e+02,
                                      5.261620e+02, 5.269725e+02, 5.301375e+02, 5.342155e+02,
                                      5.363631e+02, 5.380500e+02, 5.395845e+02, 5.478508e+02,
                                      5.856525e+02, 6.260625e+02, 6.692609e+02, 7.154399e+02,
                                      7.502880e+02, 7.617720e+02, 7.648052e+02, 7.648344e+02,
                                      7.694280e+02, 7.809120e+02, 7.956620e+02, 8.078405e+02,
                                      8.110881e+02, 8.159595e+02, 8.175768e+02, 8.281380e+02,
                                      8.739896e+02, 9.248260e+02, 9.342948e+02, 9.389815e+02,
                                      9.427563e+02, 9.484185e+02, 9.625740e+02, 9.987612e+02,
                                      1.067676e+03, 1.141345e+03, 1.220098e+03, 1.304285e+03,
                                      1.394281e+03, 1.490486e+03, 1.593329e+03, 1.703269e+03,
                                      1.820795e+03, 1.946430e+03, 2.080733e+03, 2.224304e+03,
                                      2.377781e+03, 2.541848e+03, 2.717235e+03, 2.904724e+03,
                                      3.105150e+03, 3.319406e+03, 3.548445e+03, 3.793288e+03,
                                      4.049556e+03, 4.055024e+03, 4.111539e+03, 4.128068e+03,
                                      4.152861e+03, 4.214844e+03, 4.292792e+03, 4.334821e+03,
                                      4.358498e+03, 4.376020e+03, 4.402302e+03, 4.468008e+03,
                                      4.604334e+03, 4.633924e+03, 4.674808e+03, 4.693602e+03,
                                      4.721791e+03, 4.792266e+03, 4.953664e+03, 5.295467e+03,
                                      5.660855e+03, 6.051453e+03, 6.469004e+03, 6.915365e+03,
                                      7.392525e+03, 7.902609e+03, 8.447890e+03, 9.030794e+03,
                                      9.653919e+03, 1.032004e+04, 1.103212e+04, 1.179334e+04,
                                      1.260708e+04, 1.347697e+04, 1.440688e+04, 1.540095e+04,
                                      1.646362e+04, 1.759961e+04, 1.881398e+04, 2.011215e+04,
                                      2.149988e+04, 2.298338e+04, 2.456923e+04, 2.626450e+04,
                                      2.807676e+04, 2.988138e+04, 3.001405e+04, 3.033874e+04,
                                      3.046071e+04, 3.064366e+04, 3.110102e+04, 3.208502e+04,
                                      3.429889e+04, 3.666551e+04, 3.919543e+04, 4.189992e+04,
                                      4.479101e+04, 4.788159e+04, 5.118542e+04, 5.471721e+04,
                                      5.849270e+04, 6.252870e+04, 6.684318e+04, 7.145536e+04,
                                      7.638578e+04, 8.165640e+04, 8.729069e+04, 9.331374e+04,
                                      9.975239e+04, 1.066353e+05, 1.139931e+05, 1.218587e+05,
                                      1.302669e+05, 1.392553e+05, 1.488640e+05, 1.591356e+05,
                                      1.701159e+05, 1.818539e+05, 1.944018e+05, 2.078156e+05,
                                      2.221548e+05, 2.374835e+05, 2.538699e+05, 2.713869e+05,
                                      2.901126e+05, 3.101304e+05, 3.315294e+05, 3.544049e+05,
                                      3.788588e+05, 4.050001e+05, 4.329451e+05]), },
              '52': {'name': 'Te',
                     'barns': 2118850000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 39.800000000000004,
                            'factor': 1.0, 'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 39.800000000000004,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 110.2, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 110.2, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 168.3, 'factor': 1.0},
                     'M5': {'filename': 'Te.M5', 'excl before': 5, 'excl after': 50, 'onset': 572.1, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'hydrogenic'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 582.5,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Te.M3', 'excl before': 5, 'excl after': 50, 'onset': 818.6999999999999,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 869.7, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1006.0, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4341.400000000001,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4612.0, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4939.2, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 31813.8, 'factor': 1.0},
                     'dat': np.array([4.70596585e+15, 6.74006185e+15, 3.35795348e+16, 1.35758957e+17,
                                      3.33846006e+17, 5.50032272e+17, 6.62988165e+17, 6.29891728e+17,
                                      5.02252204e+17, 3.54123400e+17, 2.30488503e+17, 1.43384698e+17,
                                      8.76674188e+16, 5.38336220e+16, 3.37511616e+16, 2.18644132e+16,
                                      1.67683670e+16, 1.53747994e+16, 1.50323932e+16, 2.19576426e+16,
                                      2.17076182e+16, 2.03899054e+16, 1.68124391e+16, 1.34301188e+16,
                                      1.12256673e+16, 9.76641530e+15, 8.78665906e+15, 8.12600164e+15,
                                      8.12155205e+15, 8.00522718e+15, 7.97641082e+15, 9.39900672e+15,
                                      9.30302281e+15, 9.15427954e+15, 8.87204872e+15, 8.68114034e+15,
                                      8.54616959e+15, 8.44637176e+15, 8.36627922e+15, 8.29233136e+15,
                                      8.21351014e+15, 8.11900943e+15, 8.00014194e+15, 7.84885606e+15,
                                      7.65964275e+15, 7.42932376e+15, 7.15768718e+15, 6.84642812e+15,
                                      6.49936049e+15, 6.12347650e+15, 5.72746344e+15, 5.58719556e+15,
                                      5.49460182e+15, 5.47743914e+15, 5.47023504e+15, 3.56051554e+16,
                                      3.47830416e+16, 3.43804601e+16, 5.37086098e+16, 5.31280449e+16,
                                      5.08757074e+16, 4.34830397e+16, 3.59378148e+16, 3.03080304e+16,
                                      2.58351380e+16, 2.30806330e+16, 2.22754700e+16, 2.20868924e+16,
                                      2.20678228e+16, 2.47905450e+16, 2.40023328e+16, 2.29598586e+16,
                                      2.22140234e+16, 2.20212080e+16, 2.29513832e+16, 2.29492644e+16,
                                      2.22436873e+16, 1.99411330e+16, 1.77989757e+16, 1.73222344e+16,
                                      1.72385398e+16, 1.70787785e+16, 1.76233230e+16, 1.70357659e+16,
                                      1.55555373e+16, 1.33568066e+16, 1.14703945e+16, 9.85371192e+15,
                                      8.45929674e+15, 7.23820348e+15, 6.18407561e+15, 5.28462378e+15,
                                      4.51802386e+15, 3.86478240e+15, 3.30667731e+15, 2.82718156e+15,
                                      2.40955622e+15, 2.04719049e+15, 1.74205490e+15, 1.48478414e+15,
                                      1.25450752e+15, 1.05056821e+15, 8.76780130e+14, 7.31405832e+14,
                                      6.11161094e+14, 5.37552245e+14, 5.16278991e+14, 5.11511578e+14,
                                      5.10812358e+14, 1.71838735e+15, 1.63708708e+15, 1.53125052e+15,
                                      1.46069281e+15, 1.44372082e+15, 1.98877380e+15, 1.98731179e+15,
                                      1.90052370e+15, 1.74658924e+15, 1.67425170e+15, 1.65586009e+15,
                                      1.89666739e+15, 1.88653929e+15, 1.81593920e+15, 1.60231675e+15,
                                      1.36081022e+15, 1.15006940e+15, 9.68399204e+14, 8.13744342e+14,
                                      6.83541010e+14, 5.74356670e+14, 4.83034234e+14, 4.05357194e+14,
                                      3.37172600e+14, 2.80027216e+14, 2.32522599e+14, 1.93213694e+14,
                                      1.60689346e+14, 1.33763000e+14, 1.11449391e+14, 9.29412364e+13,
                                      7.75138896e+13, 6.46842528e+13, 5.40285562e+13, 4.50170871e+13,
                                      3.74803376e+13, 3.10835295e+13, 2.58012364e+13, 2.14364054e+13,
                                      1.76498086e+13, 1.44971717e+13, 1.29639718e+13, 1.23988745e+13,
                                      1.22539452e+13, 7.63760671e+13, 7.56726089e+13, 7.34435787e+13,
                                      6.34320124e+13, 5.31449957e+13, 4.45170385e+13, 3.72620961e+13,
                                      3.10941238e+13, 2.59389617e+13, 2.16313396e+13, 1.80362869e+13,
                                      1.50359953e+13, 1.25344809e+13, 1.04177498e+13, 8.64999324e+12,
                                      7.18268962e+12, 5.95566358e+12, 4.92145290e+12, 4.06713258e+12,
                                      3.36134364e+12, 2.77823612e+12, 2.29640963e+12, 1.89840485e+12,
                                      1.56943220e+12, 1.29758374e+12, 1.07296445e+12, 8.87268438e+11,
                                      7.33757755e+11, 6.06859828e+11, 5.01934376e+11, 4.15167469e+11,
                                      3.43423208e+11, 2.84074220e+11, 2.35022842e+11, 1.94432033e+11,
                                      1.60865211e+11, 1.33099800e+11, 1.10131466e+11, 9.11317385e+10,
                                      7.54119904e+10, 6.24086079e+10, 5.16490876e+10]),
                     'ene': np.array([3.999900e+01, 4.060054e+01, 4.340198e+01, 4.639671e+01,
                                      4.959809e+01, 5.302035e+01, 5.667876e+01, 6.058959e+01,
                                      6.477028e+01, 6.923942e+01, 7.401695e+01, 7.912411e+01,
                                      8.458368e+01, 9.041995e+01, 9.665893e+01, 1.033284e+02,
                                      1.079960e+02, 1.096490e+02, 1.100898e+02, 1.104581e+02,
                                      1.107510e+02, 1.124040e+02, 1.180797e+02, 1.262272e+02,
                                      1.349368e+02, 1.442475e+02, 1.542005e+02, 1.648404e+02,
                                      1.649340e+02, 1.674585e+02, 1.681317e+02, 1.691415e+02,
                                      1.716660e+02, 1.762144e+02, 1.883732e+02, 2.013709e+02,
                                      2.152655e+02, 2.301188e+02, 2.459970e+02, 2.629708e+02,
                                      2.811158e+02, 3.005128e+02, 3.212482e+02, 3.434143e+02,
                                      3.671099e+02, 3.924405e+02, 4.195189e+02, 4.484657e+02,
                                      4.794098e+02, 5.124891e+02, 5.478508e+02, 5.606580e+02,
                                      5.692395e+02, 5.708500e+02, 5.715279e+02, 5.749605e+02,
                                      5.795875e+02, 5.819175e+02, 5.835420e+02, 5.856525e+02,
                                      5.941500e+02, 6.260625e+02, 6.692609e+02, 7.154399e+02,
                                      7.648052e+02, 8.023260e+02, 8.146065e+02, 8.175768e+02,
                                      8.178813e+02, 8.227935e+02, 8.350740e+02, 8.523060e+02,
                                      8.653515e+02, 8.688303e+02, 8.739896e+02, 8.740485e+02,
                                      8.870940e+02, 9.342948e+02, 9.858800e+02, 9.987612e+02,
                                      1.000970e+03, 1.004994e+03, 1.011030e+03, 1.026120e+03,
                                      1.067676e+03, 1.141345e+03, 1.220098e+03, 1.304285e+03,
                                      1.394281e+03, 1.490486e+03, 1.593329e+03, 1.703269e+03,
                                      1.820795e+03, 1.946430e+03, 2.080733e+03, 2.224304e+03,
                                      2.377781e+03, 2.541848e+03, 2.717235e+03, 2.904724e+03,
                                      3.105150e+03, 3.319406e+03, 3.548445e+03, 3.793288e+03,
                                      4.055024e+03, 4.254572e+03, 4.319693e+03, 4.334821e+03,
                                      4.337059e+03, 4.363107e+03, 4.428228e+03, 4.519760e+03,
                                      4.588940e+03, 4.607388e+03, 4.633924e+03, 4.635060e+03,
                                      4.704240e+03, 4.840416e+03, 4.914504e+03, 4.934261e+03,
                                      4.953664e+03, 4.963896e+03, 5.037984e+03, 5.295467e+03,
                                      5.660855e+03, 6.051453e+03, 6.469004e+03, 6.915365e+03,
                                      7.392525e+03, 7.902609e+03, 8.447890e+03, 9.030794e+03,
                                      9.653919e+03, 1.032004e+04, 1.103212e+04, 1.179334e+04,
                                      1.260708e+04, 1.347697e+04, 1.440688e+04, 1.540095e+04,
                                      1.646362e+04, 1.759961e+04, 1.881398e+04, 2.011215e+04,
                                      2.149988e+04, 2.298338e+04, 2.456923e+04, 2.626450e+04,
                                      2.807676e+04, 3.001405e+04, 3.117752e+04, 3.165473e+04,
                                      3.178199e+04, 3.197287e+04, 3.208502e+04, 3.245008e+04,
                                      3.429889e+04, 3.666551e+04, 3.919543e+04, 4.189992e+04,
                                      4.479101e+04, 4.788159e+04, 5.118542e+04, 5.471721e+04,
                                      5.849270e+04, 6.252870e+04, 6.684318e+04, 7.145536e+04,
                                      7.638578e+04, 8.165640e+04, 8.729069e+04, 9.331374e+04,
                                      9.975239e+04, 1.066353e+05, 1.139931e+05, 1.218587e+05,
                                      1.302669e+05, 1.392553e+05, 1.488640e+05, 1.591356e+05,
                                      1.701159e+05, 1.818539e+05, 1.944018e+05, 2.078156e+05,
                                      2.221548e+05, 2.374835e+05, 2.538699e+05, 2.713869e+05,
                                      2.901126e+05, 3.101304e+05, 3.315294e+05, 3.544049e+05,
                                      3.788588e+05, 4.050001e+05, 4.329451e+05]), },
              '53': {'name': 'I',
                     'barns': 2107300000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 49.6, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 49.6,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 122.7, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 122.7, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 186.4, 'factor': 1.0},
                     'M5': {'filename': 'I.M5', 'excl before': 5, 'excl after': 50, 'onset': 619.4, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'hydrogenic'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 631.3,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'I.M3', 'excl before': 5, 'excl after': 50, 'onset': 874.6, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 930.5, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1072.1000000000001,
                            'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4557.1, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4852.1, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5188.1, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 33169.4, 'factor': 1.0},
                     'dat': np.array([8.79671312e+15, 1.13003962e+16, 2.49630758e+16, 7.22572097e+16,
                                      1.48362349e+17, 2.23921698e+17, 2.65814822e+17, 2.62843529e+17,
                                      2.27103721e+17, 1.78465130e+17, 1.31765254e+17, 9.38486055e+16,
                                      6.58468031e+16, 4.62531277e+16, 3.29265625e+16, 3.01217462e+16,
                                      2.79996951e+16, 2.74707628e+16, 3.26694719e+16, 3.07897603e+16,
                                      2.97761490e+16, 2.33320256e+16, 1.89079600e+16, 1.58603827e+16,
                                      1.37324312e+16, 1.22261331e+16, 1.15996328e+16, 1.13665655e+16,
                                      1.13077718e+16, 1.26515970e+16, 1.25742591e+16, 1.24495069e+16,
                                      1.17861289e+16, 1.12013532e+16, 1.07434369e+16, 1.03681267e+16,
                                      1.00440240e+16, 9.74836980e+15, 9.46325211e+15, 9.17518420e+15,
                                      8.87405103e+15, 8.55205559e+15, 8.20477255e+15, 7.83051607e+15,
                                      7.42991834e+15, 7.00614031e+15, 6.56402877e+15, 6.10864124e+15,
                                      5.64819619e+15, 5.40164209e+15, 5.29754147e+15, 5.27141095e+15,
                                      5.27014657e+15, 3.20183162e+16, 3.15041350e+16, 3.12070057e+16,
                                      3.08550866e+16, 4.81370539e+16, 4.75470099e+16, 4.55282165e+16,
                                      4.06729973e+16, 3.36409372e+16, 2.83200047e+16, 2.41032974e+16,
                                      2.15724301e+16, 2.08220206e+16, 2.06138193e+16, 2.32161241e+16,
                                      2.24827837e+16, 2.14375629e+16, 2.07442612e+16, 2.05649300e+16,
                                      2.14797089e+16, 2.14375629e+16, 2.07748170e+16, 1.86422294e+16,
                                      1.67001418e+16, 1.61018793e+16, 1.59842920e+16, 1.64997375e+16,
                                      1.59457284e+16, 1.44484917e+16, 1.23938742e+16, 1.06334358e+16,
                                      9.12671630e+15, 7.82840877e+15, 6.69404918e+15, 5.71626198e+15,
                                      4.88261410e+15, 4.17266473e+15, 3.56829109e+15, 3.05263478e+15,
                                      2.61115543e+15, 2.22952340e+15, 1.89541098e+15, 1.61398107e+15,
                                      1.36262233e+15, 1.14179836e+15, 9.57620339e+14, 8.00331467e+14,
                                      6.68477706e+14, 5.59256347e+14, 5.16688887e+14, 4.96311296e+14,
                                      4.91064119e+14, 1.62750994e+15, 1.56694613e+15, 1.55141533e+15,
                                      1.44147749e+15, 1.37657265e+15, 1.36068361e+15, 1.87172493e+15,
                                      1.78576817e+15, 1.65410406e+15, 1.58551145e+15, 1.56812622e+15,
                                      1.78663216e+15, 1.71713340e+15, 1.45397378e+15, 1.23306552e+15,
                                      1.04069010e+15, 8.75625296e+14, 7.35805941e+14, 6.18323966e+14,
                                      5.19934129e+14, 4.36843290e+14, 3.63930710e+14, 3.02734718e+14,
                                      2.51358744e+14, 2.08801820e+14, 1.73563550e+14, 1.44400625e+14,
                                      1.20246753e+14, 1.00223188e+14, 8.36092348e+13, 6.97558446e+13,
                                      5.82289136e+13, 4.86090891e+13, 4.05065206e+13, 3.37062635e+13,
                                      2.79723002e+13, 2.32350898e+13, 1.91336518e+13, 1.57200365e+13,
                                      1.29261782e+13, 1.24425528e+13, 1.19024519e+13, 1.17637915e+13,
                                      7.29189019e+13, 7.01204075e+13, 6.76337935e+13, 5.66863700e+13,
                                      4.74985420e+13, 3.97921459e+13, 3.32679451e+13, 2.77636775e+13,
                                      2.31613343e+13, 1.93163547e+13, 1.61067261e+13, 1.34289800e+13,
                                      1.11916596e+13, 9.29614322e+12, 7.72241158e+12, 6.40577054e+12,
                                      5.29522344e+12, 4.37770502e+12, 3.61928775e+12, 2.99278746e+12,
                                      2.47481312e+12, 2.04656761e+12, 1.69260443e+12, 1.39996368e+12,
                                      1.15819315e+12, 9.58400040e+11, 7.93124501e+11, 6.56381804e+11,
                                      5.43261940e+11, 4.49655674e+11, 3.72212399e+11, 3.08108333e+11,
                                      2.55067592e+11, 2.11172533e+11, 1.74832144e+11, 1.44756759e+11,
                                      1.19861117e+11, 9.92517227e+10, 8.21910219e+10, 6.80636827e+10,
                                      5.63702750e+10]),
                     'ene': np.array([4.984800e+01, 5.059200e+01, 5.302035e+01, 5.667876e+01,
                                      6.058959e+01, 6.477028e+01, 6.923942e+01, 7.401695e+01,
                                      7.912411e+01, 8.458368e+01, 9.041995e+01, 9.665893e+01,
                                      1.033284e+02, 1.104581e+02, 1.180797e+02, 1.202460e+02,
                                      1.220865e+02, 1.225773e+02, 1.233135e+02, 1.251540e+02,
                                      1.262272e+02, 1.349368e+02, 1.442475e+02, 1.542005e+02,
                                      1.648404e+02, 1.762144e+02, 1.826720e+02, 1.854680e+02,
                                      1.862136e+02, 1.873320e+02, 1.883732e+02, 1.901280e+02,
                                      2.013709e+02, 2.152655e+02, 2.301188e+02, 2.459970e+02,
                                      2.629708e+02, 2.811158e+02, 3.005128e+02, 3.212482e+02,
                                      3.434143e+02, 3.671099e+02, 3.924405e+02, 4.195189e+02,
                                      4.484657e+02, 4.794098e+02, 5.124891e+02, 5.478508e+02,
                                      5.856525e+02, 6.070120e+02, 6.163030e+02, 6.186740e+02,
                                      6.187806e+02, 6.224970e+02, 6.260625e+02, 6.281435e+02,
                                      6.306687e+02, 6.317880e+02, 6.344565e+02, 6.439260e+02,
                                      6.692609e+02, 7.154399e+02, 7.648052e+02, 8.175768e+02,
                                      8.571080e+02, 8.702270e+02, 8.739896e+02, 8.789730e+02,
                                      8.920920e+02, 9.118900e+02, 9.258475e+02, 9.295695e+02,
                                      9.342948e+02, 9.351525e+02, 9.491100e+02, 9.987612e+02,
                                      1.050658e+03, 1.067676e+03, 1.071028e+03, 1.077461e+03,
                                      1.093542e+03, 1.141345e+03, 1.220098e+03, 1.304285e+03,
                                      1.394281e+03, 1.490486e+03, 1.593329e+03, 1.703269e+03,
                                      1.820795e+03, 1.946430e+03, 2.080733e+03, 2.224304e+03,
                                      2.377781e+03, 2.541848e+03, 2.717235e+03, 2.904724e+03,
                                      3.105150e+03, 3.319406e+03, 3.548445e+03, 3.793288e+03,
                                      4.055024e+03, 4.334821e+03, 4.465958e+03, 4.534314e+03,
                                      4.552543e+03, 4.579885e+03, 4.633924e+03, 4.648242e+03,
                                      4.755058e+03, 4.827839e+03, 4.847248e+03, 4.876360e+03,
                                      4.953664e+03, 5.084338e+03, 5.162159e+03, 5.182912e+03,
                                      5.214040e+03, 5.295467e+03, 5.660855e+03, 6.051453e+03,
                                      6.469004e+03, 6.915365e+03, 7.392525e+03, 7.902609e+03,
                                      8.447890e+03, 9.030794e+03, 9.653919e+03, 1.032004e+04,
                                      1.103212e+04, 1.179334e+04, 1.260708e+04, 1.347697e+04,
                                      1.440688e+04, 1.540095e+04, 1.646362e+04, 1.759961e+04,
                                      1.881398e+04, 2.011215e+04, 2.149988e+04, 2.298338e+04,
                                      2.456923e+04, 2.626450e+04, 2.807676e+04, 3.001405e+04,
                                      3.208502e+04, 3.250601e+04, 3.300355e+04, 3.313623e+04,
                                      3.333525e+04, 3.383279e+04, 3.429889e+04, 3.666551e+04,
                                      3.919543e+04, 4.189992e+04, 4.479101e+04, 4.788159e+04,
                                      5.118542e+04, 5.471721e+04, 5.849270e+04, 6.252870e+04,
                                      6.684318e+04, 7.145536e+04, 7.638578e+04, 8.165640e+04,
                                      8.729069e+04, 9.331374e+04, 9.975239e+04, 1.066353e+05,
                                      1.139931e+05, 1.218587e+05, 1.302669e+05, 1.392553e+05,
                                      1.488640e+05, 1.591356e+05, 1.701159e+05, 1.818539e+05,
                                      1.944018e+05, 2.078156e+05, 2.221548e+05, 2.374835e+05,
                                      2.538699e+05, 2.713869e+05, 2.901126e+05, 3.101304e+05,
                                      3.315294e+05, 3.544049e+05, 3.788588e+05, 4.050001e+05,
                                      4.329451e+05]), },
              '54': {'name': 'Xe',
                     'barns': 2180120000000.0,
                     'NumEdges': 14,
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 64.0, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 64.0,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 146.7, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 146.7, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 208.1, 'factor': 1.0},
                     'M5': {'filename': 'Xe.M5', 'excl before': 5, 'excl after': 50, 'onset': 672.3, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'hydrogenic'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 685.4,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 937.0, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 999.0, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1144.6000000000001,
                            'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4782.2, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5103.7, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5452.8, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 34561.4, 'factor': 1.0},
                     'dat': np.array([2.97390169e+16, 3.09446233e+16, 3.23573410e+16, 4.52680117e+16,
                                      6.30686915e+16, 7.53863695e+16, 7.96419637e+16, 7.66748204e+16,
                                      6.90073384e+16, 5.92883634e+16, 4.94603824e+16, 4.06112754e+16,
                                      3.31683457e+16, 2.71621151e+16, 2.26427263e+16, 2.24334348e+16,
                                      2.17111610e+16, 2.14737460e+16, 2.61069370e+16, 2.52327089e+16,
                                      2.36019791e+16, 2.05700862e+16, 1.82240591e+16, 1.64054030e+16,
                                      1.49830927e+16, 1.47491658e+16, 1.44818831e+16, 1.44134274e+16,
                                      1.56890156e+16, 1.54468042e+16, 1.52279202e+16, 1.43107437e+16,
                                      1.35450856e+16, 1.28805850e+16, 1.22819240e+16, 1.17233773e+16,
                                      1.11859777e+16, 1.06568626e+16, 1.01268754e+16, 9.59056589e+15,
                                      9.04575390e+15, 8.49265746e+15, 7.93411072e+15, 7.37425590e+15,
                                      6.81767126e+15, 6.27024313e+15, 5.73676777e+15, 5.34085798e+15,
                                      5.22204144e+15, 5.19478994e+15, 2.85007088e+16, 2.77878095e+16,
                                      2.74847728e+16, 4.26802092e+16, 4.21417196e+16, 4.04150646e+16,
                                      3.78643242e+16, 3.14286099e+16, 2.64688369e+16, 2.25228197e+16,
                                      2.00394450e+16, 1.93357023e+16, 1.92393410e+16, 1.91540983e+16,
                                      2.15934346e+16, 2.09064788e+16, 1.98375659e+16, 1.91909423e+16,
                                      1.89921154e+16, 2.00141556e+16, 1.93670960e+16, 1.74560028e+16,
                                      1.56502094e+16, 1.51359191e+16, 1.50609230e+16, 1.49974815e+16,
                                      1.54860464e+16, 1.49693580e+16, 1.35082415e+16, 1.15592143e+16,
                                      9.90079697e+15, 8.48851523e+15, 7.27767658e+15, 6.22206248e+15,
                                      5.30728413e+15, 4.52810924e+15, 3.86513475e+15, 3.30135572e+15,
                                      2.82107528e+15, 2.41208477e+15, 2.06306936e+15, 1.75517101e+15,
                                      1.48023608e+15, 1.23944182e+15, 1.03998264e+15, 8.73530482e+14,
                                      7.31146844e+14, 6.11392853e+14, 5.12044784e+14, 4.96980155e+14,
                                      4.77446280e+14, 4.72410203e+14, 1.54289273e+15, 1.47131939e+15,
                                      1.40042188e+15, 1.35782234e+15, 1.29797804e+15, 1.28310963e+15,
                                      1.76378248e+15, 1.68791431e+15, 1.60541857e+15, 1.56360387e+15,
                                      1.49881070e+15, 1.48241620e+15, 1.68974561e+15, 1.62689275e+15,
                                      1.55592984e+15, 1.31868918e+15, 1.11641765e+15, 9.41223208e+14,
                                      7.91645174e+14, 6.65394425e+14, 5.59505997e+14, 4.70033872e+14,
                                      3.92465202e+14, 3.26843590e+14, 2.71817362e+14, 2.25664221e+14,
                                      1.87514301e+14, 1.55906922e+14, 1.29738941e+14, 1.08059828e+14,
                                      9.00869186e+13, 7.51705376e+13, 6.27307729e+13, 5.23752029e+13,
                                      4.37005054e+13, 3.64189046e+13, 3.02884072e+13, 2.51542246e+13,
                                      2.07159363e+13, 1.70234670e+13, 1.40009487e+13, 1.19546880e+13,
                                      1.15247684e+13, 1.14373455e+13, 1.13045762e+13, 6.96722750e+13,
                                      6.69950876e+13, 6.03849638e+13, 5.06093057e+13, 4.24120545e+13,
                                      3.55403162e+13, 2.96757934e+13, 2.47661632e+13, 2.06605612e+13,
                                      1.72316685e+13, 1.43698250e+13, 1.19825936e+13, 9.97470304e+12,
                                      8.28925226e+12, 6.87849661e+12, 5.68815109e+12, 4.70404492e+12,
                                      3.89064215e+12, 3.21807513e+12, 2.66192652e+12, 2.20213921e+12,
                                      1.82194809e+12, 1.50746578e+12, 1.24737746e+12, 1.03276645e+12,
                                      8.55173871e+11, 7.08168380e+11, 5.86474081e+11, 4.85730736e+11,
                                      4.02297544e+11, 3.33231342e+11, 2.76024993e+11, 2.28650986e+11,
                                      1.89430627e+11, 1.56938118e+11, 1.30026717e+11, 1.07734990e+11,
                                      8.92693736e+10, 7.39714716e+10, 6.12984340e+10]),
                     'ene': np.array([6.432000e+01, 6.477028e+01, 6.528000e+01, 6.923942e+01,
                                      7.401695e+01, 7.912411e+01, 8.458368e+01, 9.041995e+01,
                                      9.665893e+01, 1.033284e+02, 1.104581e+02, 1.180797e+02,
                                      1.262272e+02, 1.349368e+02, 1.437660e+02, 1.442475e+02,
                                      1.459665e+02, 1.465533e+02, 1.474335e+02, 1.496340e+02,
                                      1.542005e+02, 1.648404e+02, 1.762144e+02, 1.883732e+02,
                                      2.013709e+02, 2.039380e+02, 2.070595e+02, 2.078919e+02,
                                      2.091405e+02, 2.122620e+02, 2.152655e+02, 2.301188e+02,
                                      2.459970e+02, 2.629708e+02, 2.811158e+02, 3.005128e+02,
                                      3.212482e+02, 3.434143e+02, 3.671099e+02, 3.924405e+02,
                                      4.195189e+02, 4.484657e+02, 4.794098e+02, 5.124891e+02,
                                      5.478508e+02, 5.856525e+02, 6.260625e+02, 6.588540e+02,
                                      6.692609e+02, 6.716920e+02, 6.756615e+02, 6.819730e+02,
                                      6.847146e+02, 6.857460e+02, 6.888270e+02, 6.991080e+02,
                                      7.154399e+02, 7.648052e+02, 8.175768e+02, 8.739896e+02,
                                      9.182600e+02, 9.323150e+02, 9.342948e+02, 9.360630e+02,
                                      9.416850e+02, 9.557400e+02, 9.790200e+02, 9.940050e+02,
                                      9.987612e+02, 1.003995e+03, 1.018980e+03, 1.067676e+03,
                                      1.121708e+03, 1.138877e+03, 1.141345e+03, 1.143455e+03,
                                      1.150323e+03, 1.167492e+03, 1.220098e+03, 1.304285e+03,
                                      1.394281e+03, 1.490486e+03, 1.593329e+03, 1.703269e+03,
                                      1.820795e+03, 1.946430e+03, 2.080733e+03, 2.224304e+03,
                                      2.377781e+03, 2.541848e+03, 2.717235e+03, 2.904724e+03,
                                      3.105150e+03, 3.319406e+03, 3.548445e+03, 3.793288e+03,
                                      4.055024e+03, 4.334821e+03, 4.633924e+03, 4.686556e+03,
                                      4.758289e+03, 4.777418e+03, 4.806111e+03, 4.877844e+03,
                                      4.953664e+03, 5.001626e+03, 5.078182e+03, 5.098596e+03,
                                      5.129219e+03, 5.205774e+03, 5.295467e+03, 5.343744e+03,
                                      5.425536e+03, 5.447347e+03, 5.480064e+03, 5.561856e+03,
                                      5.660855e+03, 6.051453e+03, 6.469004e+03, 6.915365e+03,
                                      7.392525e+03, 7.902609e+03, 8.447890e+03, 9.030794e+03,
                                      9.653919e+03, 1.032004e+04, 1.103212e+04, 1.179334e+04,
                                      1.260708e+04, 1.347697e+04, 1.440688e+04, 1.540095e+04,
                                      1.646362e+04, 1.759961e+04, 1.881398e+04, 2.011215e+04,
                                      2.149988e+04, 2.298338e+04, 2.456923e+04, 2.626450e+04,
                                      2.807676e+04, 3.001405e+04, 3.208502e+04, 3.387017e+04,
                                      3.429889e+04, 3.438859e+04, 3.452684e+04, 3.473421e+04,
                                      3.525263e+04, 3.666551e+04, 3.919543e+04, 4.189992e+04,
                                      4.479101e+04, 4.788159e+04, 5.118542e+04, 5.471721e+04,
                                      5.849270e+04, 6.252870e+04, 6.684318e+04, 7.145536e+04,
                                      7.638578e+04, 8.165640e+04, 8.729069e+04, 9.331374e+04,
                                      9.975239e+04, 1.066353e+05, 1.139931e+05, 1.218587e+05,
                                      1.302669e+05, 1.392553e+05, 1.488640e+05, 1.591356e+05,
                                      1.701159e+05, 1.818539e+05, 1.944018e+05, 2.078156e+05,
                                      2.221548e+05, 2.374835e+05, 2.538699e+05, 2.713869e+05,
                                      2.901126e+05, 3.101304e+05, 3.315294e+05, 3.544049e+05,
                                      3.788588e+05, 4.050001e+05, 4.329451e+05]), },
              '55': {'name': 'Cs',
                     'barns': 2326750000000.0,
                     'NumEdges': 18,
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 37.8, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 19.8, 'factor': 1.0},
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 19.8, 'factor': 1.0},
                     'N5': {'filename': 'Cs.N5', 'excl before': 5, 'excl after': 50, 'onset': 110.0, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 110.0,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 207.2, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 223.3, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 85.9, 'factor': 1.0},
                     'M5': {'filename': 'Cs.M5', 'excl before': 5, 'excl after': 50, 'onset': 883.3, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 901.3,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Cs.M3', 'excl before': 5, 'excl after': 50, 'onset': 1185.4, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1272.8, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1434.6000000000001,
                            'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5723.4, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6164.2, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6548.8, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 40443.0, 'factor': 1.0},
                     'dat': np.array([4.01178235e+17, 3.81889478e+17, 3.44428802e+17, 2.75650072e+17,
                                      2.16792604e+17, 1.67637684e+17, 1.28208578e+17, 9.74768645e+16,
                                      7.39929768e+16, 5.62771022e+16, 4.30146272e+16, 3.64834400e+16,
                                      3.43916918e+16, 3.38611928e+16, 3.35261408e+16, 3.34958930e+16,
                                      3.16880082e+16, 2.62410865e+16, 2.08344175e+16, 1.68026251e+16,
                                      1.37778501e+16, 1.14908876e+16, 9.74466168e+15, 8.39491400e+15,
                                      7.33670810e+15, 6.49395925e+15, 5.81082545e+15, 5.24728660e+15,
                                      4.80729818e+15, 4.77635240e+15, 4.70957468e+15, 4.68444578e+15,
                                      5.45669410e+15, 5.47600612e+15, 5.57838312e+15, 6.14099128e+15,
                                      7.09705285e+15, 7.83812272e+15, 8.11919412e+15, 8.19434815e+15,
                                      2.59106880e+17, 2.55663290e+17, 2.01917692e+17, 9.21997955e+16,
                                      3.96454932e+16, 2.48078085e+16, 1.96975675e+16, 1.74485309e+16,
                                      1.61269369e+16, 1.51264344e+16, 1.42627448e+16, 1.34972441e+16,
                                      1.34088276e+16, 1.32520046e+16, 1.32115192e+16, 1.63298295e+16,
                                      1.61776601e+16, 1.59968716e+16, 1.58428408e+16, 1.57074239e+16,
                                      1.56725226e+16, 1.66232327e+16, 1.65003803e+16, 1.64184787e+16,
                                      1.59487079e+16, 1.55741011e+16, 1.52685988e+16, 1.52285788e+16,
                                      1.51659892e+16, 1.51497019e+16, 1.63547258e+16, 1.62849232e+16,
                                      1.62044177e+16, 1.58826282e+16, 1.55129076e+16, 1.50631468e+16,
                                      1.45151972e+16, 1.38683607e+16, 1.31300829e+16, 1.23031560e+16,
                                      1.14134068e+16, 1.04945732e+16, 9.57597230e+15, 8.68180228e+15,
                                      7.82951375e+15, 7.03120582e+15, 6.29269538e+15, 5.61747252e+15,
                                      5.08906760e+15, 5.00460658e+15, 4.95597750e+15, 4.91293262e+15,
                                      2.05607917e+16, 2.00240105e+16, 1.98162317e+16, 1.97836572e+16,
                                      2.96963102e+16, 2.85329352e+16, 2.73206985e+16, 2.28549672e+16,
                                      1.92696782e+16, 1.63223839e+16, 1.56294778e+16, 1.50589587e+16,
                                      1.49121408e+16, 1.71732764e+16, 1.65397024e+16, 1.61648630e+16,
                                      1.52941931e+16, 1.47548524e+16, 1.46168762e+16, 1.54082038e+16,
                                      1.48709573e+16, 1.47078521e+16, 1.26428615e+16, 1.24169340e+16,
                                      1.20171984e+16, 1.19145887e+16, 1.23254928e+16, 1.19478612e+16,
                                      1.14976351e+16, 9.90218265e+15, 8.49170680e+15, 7.26597490e+15,
                                      6.21056110e+15, 5.30475732e+15, 4.52483072e+15, 3.86380105e+15,
                                      3.29560870e+15, 2.81094668e+15, 2.40050798e+15, 2.03427752e+15,
                                      1.71246473e+15, 1.44314342e+15, 1.21058476e+15, 1.01630113e+15,
                                      8.54382600e+14, 7.19454368e+14, 6.06956005e+14, 5.11698860e+14,
                                      4.40709718e+14, 4.30169540e+14, 4.23491768e+14, 4.19070943e+14,
                                      1.27961943e+15, 1.22145068e+15, 1.09894729e+15, 1.09347943e+15,
                                      1.05250536e+15, 1.04068547e+15, 1.41559470e+15, 1.35882200e+15,
                                      1.28464521e+15, 1.25723610e+15, 1.23294482e+15, 1.21972888e+15,
                                      1.38876727e+15, 1.33818373e+15, 1.22759330e+15, 1.03891714e+15,
                                      8.76067910e+14, 7.37603018e+14, 6.19753130e+14, 5.17515735e+14,
                                      4.32542825e+14, 3.61832892e+14, 3.02384430e+14, 2.52126630e+14,
                                      2.09728592e+14, 1.74259614e+14, 1.44914644e+14, 1.20614066e+14,
                                      1.00457431e+14, 8.37420592e+13, 6.98723025e+13, 5.83525632e+13,
                                      4.87779870e+13, 4.08111950e+13, 3.40961945e+13, 2.82420915e+13,
                                      2.32640099e+13, 1.91554347e+13, 1.57818799e+13, 1.30130474e+13,
                                      1.07388820e+13, 1.04010378e+13, 9.95732662e+12, 9.84331588e+12,
                                      5.85270695e+13, 5.63399245e+13, 5.41271852e+13, 4.54646950e+13,
                                      3.81098382e+13, 3.19206832e+13, 2.66854958e+13, 2.22821214e+13,
                                      1.86023662e+13, 1.55284968e+13, 1.29611609e+13, 1.08172934e+13,
                                      9.01196810e+12, 7.46467935e+12, 6.18380348e+12, 5.12303815e+12,
                                      4.24469002e+12, 3.51734798e+12, 2.91471972e+12, 2.41563185e+12,
                                      2.00209857e+12, 1.65950790e+12, 1.37564440e+12, 1.14040998e+12,
                                      9.46359028e+11, 7.85976150e+11, 6.52816248e+11, 5.42249088e+11,
                                      4.50435532e+11, 3.74187935e+11, 3.10877068e+11, 2.58292518e+11,
                                      2.14598479e+11, 1.78312813e+11, 1.48169767e+11, 1.23129283e+11,
                                      1.02325812e+11, 8.50403858e+10]),
                     'ene': np.array([1.989900e+01, 2.019600e+01, 2.083314e+01, 2.227063e+01,
                                      2.380730e+01, 2.545001e+01, 2.720606e+01, 2.908327e+01,
                                      3.109002e+01, 3.323523e+01, 3.552846e+01, 3.704400e+01,
                                      3.761100e+01, 3.776220e+01, 3.797993e+01, 3.798900e+01,
                                      3.855600e+01, 4.060054e+01, 4.340198e+01, 4.639671e+01,
                                      4.959809e+01, 5.302035e+01, 5.667876e+01, 6.058959e+01,
                                      6.477028e+01, 6.923942e+01, 7.401695e+01, 7.912411e+01,
                                      8.418200e+01, 8.458368e+01, 8.547050e+01, 8.581410e+01,
                                      8.632950e+01, 8.761800e+01, 9.041995e+01, 9.665893e+01,
                                      1.033284e+02, 1.078000e+02, 1.094500e+02, 1.098900e+02,
                                      1.104581e+02, 1.105500e+02, 1.122000e+02, 1.180797e+02,
                                      1.262272e+02, 1.349368e+02, 1.442475e+02, 1.542005e+02,
                                      1.648404e+02, 1.762144e+02, 1.883732e+02, 2.013709e+02,
                                      2.030560e+02, 2.061640e+02, 2.069928e+02, 2.082360e+02,
                                      2.113440e+02, 2.152655e+02, 2.188340e+02, 2.221835e+02,
                                      2.230767e+02, 2.244165e+02, 2.277660e+02, 2.301188e+02,
                                      2.459970e+02, 2.629708e+02, 2.811158e+02, 2.838080e+02,
                                      2.881520e+02, 2.893104e+02, 2.910480e+02, 2.953920e+02,
                                      3.005128e+02, 3.212482e+02, 3.434143e+02, 3.671099e+02,
                                      3.924405e+02, 4.195189e+02, 4.484657e+02, 4.794098e+02,
                                      5.124891e+02, 5.478508e+02, 5.856525e+02, 6.260625e+02,
                                      6.692609e+02, 7.154399e+02, 7.648052e+02, 8.175768e+02,
                                      8.656340e+02, 8.739896e+02, 8.788835e+02, 8.832740e+02,
                                      8.877165e+02, 8.967935e+02, 9.003987e+02, 9.009660e+02,
                                      9.058065e+02, 9.193260e+02, 9.342948e+02, 9.987612e+02,
                                      1.067676e+03, 1.141345e+03, 1.161692e+03, 1.179473e+03,
                                      1.184215e+03, 1.191327e+03, 1.209108e+03, 1.220098e+03,
                                      1.247344e+03, 1.266436e+03, 1.271527e+03, 1.279164e+03,
                                      1.298256e+03, 1.304285e+03, 1.394281e+03, 1.405908e+03,
                                      1.427427e+03, 1.433165e+03, 1.441773e+03, 1.463292e+03,
                                      1.490486e+03, 1.593329e+03, 1.703269e+03, 1.820795e+03,
                                      1.946430e+03, 2.080733e+03, 2.224304e+03, 2.377781e+03,
                                      2.541848e+03, 2.717235e+03, 2.904724e+03, 3.105150e+03,
                                      3.319406e+03, 3.548445e+03, 3.793288e+03, 4.055024e+03,
                                      4.334821e+03, 4.633924e+03, 4.953664e+03, 5.295467e+03,
                                      5.608932e+03, 5.660855e+03, 5.694783e+03, 5.717677e+03,
                                      5.752017e+03, 5.837868e+03, 6.040916e+03, 6.051453e+03,
                                      6.133379e+03, 6.158036e+03, 6.195021e+03, 6.287484e+03,
                                      6.417824e+03, 6.469004e+03, 6.516056e+03, 6.542251e+03,
                                      6.581544e+03, 6.679776e+03, 6.915365e+03, 7.392525e+03,
                                      7.902609e+03, 8.447890e+03, 9.030794e+03, 9.653919e+03,
                                      1.032004e+04, 1.103212e+04, 1.179334e+04, 1.260708e+04,
                                      1.347697e+04, 1.440688e+04, 1.540095e+04, 1.646362e+04,
                                      1.759961e+04, 1.881398e+04, 2.011215e+04, 2.149988e+04,
                                      2.298338e+04, 2.456923e+04, 2.626450e+04, 2.807676e+04,
                                      3.001405e+04, 3.208502e+04, 3.429889e+04, 3.666551e+04,
                                      3.919543e+04, 3.963414e+04, 4.024079e+04, 4.040256e+04,
                                      4.064522e+04, 4.125186e+04, 4.189992e+04, 4.479101e+04,
                                      4.788159e+04, 5.118542e+04, 5.471721e+04, 5.849270e+04,
                                      6.252870e+04, 6.684318e+04, 7.145536e+04, 7.638578e+04,
                                      8.165640e+04, 8.729069e+04, 9.331374e+04, 9.975239e+04,
                                      1.066353e+05, 1.139931e+05, 1.218587e+05, 1.302669e+05,
                                      1.392553e+05, 1.488640e+05, 1.591356e+05, 1.701159e+05,
                                      1.818539e+05, 1.944018e+05, 2.078156e+05, 2.221548e+05,
                                      2.374835e+05, 2.538699e+05, 2.713869e+05, 2.901126e+05,
                                      3.101304e+05, 3.315294e+05, 3.544049e+05, 3.788588e+05,
                                      4.050001e+05, 4.329451e+05]), },
              '56': {'name': 'Ba',
                     'barns': 2280420000000.0,
                     'NumEdges': 17,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 14.6, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 16.6, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 39.1, 'factor': 1.0},
                     'N5': {'filename': 'Ba.N5', 'excl before': 5, 'excl after': 50, 'onset': 89.89999999999999,
                            'factor': 1.0, 'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 92.5,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 179.7, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 191.8, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 253.0, 'factor': 1.0},
                     'M5': {'filename': 'Ba.M5', 'excl before': 5, 'excl after': 50, 'onset': 780.6999999999999,
                            'factor': 1.0, 'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 796.1,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Ba.M3', 'excl before': 5, 'excl after': 50, 'onset': 1062.2, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1136.7, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1292.8, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5247.0, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5623.599999999999,
                            'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5988.8, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 37440.600000000006,
                            'factor': 1.0},
                     'dat': np.array([4.17841357e+17, 3.97750856e+17, 3.94968744e+17, 3.16362667e+17,
                                      2.96340579e+17, 2.81335415e+17, 2.77458701e+17, 4.59823889e+17,
                                      4.37270535e+17, 4.26689386e+17, 3.37981048e+17, 2.65007608e+17,
                                      2.05566180e+17, 1.58393412e+17, 1.21658127e+17, 9.34288074e+16,
                                      7.19221664e+16, 5.56194438e+16, 4.32869324e+16, 3.39531734e+16,
                                      2.68701889e+16, 2.14728908e+16, 2.08587737e+16, 1.98556169e+16,
                                      1.96004379e+16, 1.95489004e+16, 1.86827969e+16, 1.77067772e+16,
                                      1.46364197e+16, 1.22962527e+16, 1.04965452e+16, 9.09978797e+15,
                                      8.00199378e+15, 7.12654054e+15, 6.41824209e+15, 5.83308632e+15,
                                      5.34051560e+15, 4.91612944e+15, 4.54350881e+15, 4.33599059e+15,
                                      4.26187694e+15, 4.24272141e+15, 4.55194636e+17, 4.33986730e+17,
                                      3.49748015e+17, 3.26350906e+17, 3.02725755e+17, 5.49216353e+17,
                                      4.16769559e+17, 2.66033797e+17, 8.14201157e+16, 3.30752117e+16,
                                      1.78467950e+16, 1.18953548e+16, 9.17777833e+15, 7.81591151e+15,
                                      7.12334795e+15, 6.81480713e+15, 6.75665642e+15, 6.76942677e+15,
                                      6.77444369e+15, 1.01227844e+16, 1.01398875e+16, 1.01857240e+16,
                                      1.01905129e+16, 1.02226668e+16, 1.02336128e+16, 1.13708582e+16,
                                      1.14135021e+16, 1.15111041e+16, 1.17899994e+16, 1.21124508e+16,
                                      1.24385509e+16, 1.24752657e+16, 1.25445904e+16, 1.25623777e+16,
                                      1.39475048e+16, 1.40004105e+16, 1.40628941e+16, 1.42307330e+16,
                                      1.42843228e+16, 1.41992632e+16, 1.39659762e+16, 1.35849180e+16,
                                      1.30547204e+16, 1.23936266e+16, 1.16365272e+16, 1.08187686e+16,
                                      9.97273274e+15, 9.12532867e+15, 8.29867642e+15, 7.50805481e+15,
                                      6.76418180e+15, 6.07321454e+15, 5.43674932e+15, 5.43355673e+15,
                                      5.29627545e+15, 5.25773635e+15, 2.29911944e+16, 2.24546116e+16,
                                      2.22327267e+16, 3.38163482e+16, 3.34127138e+16, 3.21744458e+16,
                                      3.16203037e+16, 2.66877553e+16, 2.26719356e+16, 1.93527843e+16,
                                      1.75122573e+16, 1.68828614e+16, 1.67204955e+16, 1.91591767e+16,
                                      1.84702618e+16, 1.72338181e+16, 1.66292787e+16, 1.64746662e+16,
                                      1.73608375e+16, 1.73234386e+16, 1.67287050e+16, 1.48918267e+16,
                                      1.37221993e+16, 1.32843587e+16, 1.31717059e+16, 1.36243693e+16,
                                      1.35149091e+16, 1.32097889e+16, 1.16695933e+16, 1.00185692e+16,
                                      8.58030829e+15, 7.34181219e+15, 6.26568199e+15, 5.34735686e+15,
                                      4.56722518e+15, 3.89769386e+15, 3.32348411e+15, 2.83570227e+15,
                                      2.42134996e+15, 2.06964078e+15, 1.75633388e+15, 1.47214794e+15,
                                      1.23382124e+15, 1.03549311e+15, 8.70641552e+14, 7.33405876e+14,
                                      6.18609533e+14, 5.19844543e+14, 4.71157576e+14, 4.52731783e+14,
                                      4.47988509e+14, 1.40275475e+15, 1.38410092e+15, 1.33821887e+15,
                                      1.21968264e+15, 1.16755224e+15, 1.15430300e+15, 1.58256587e+15,
                                      1.57499488e+15, 1.51481459e+15, 1.41687055e+15, 1.35764805e+15,
                                      1.34275690e+15, 1.52922685e+15, 1.50811016e+15, 1.47239878e+15,
                                      1.27530208e+15, 1.08034898e+15, 9.11734720e+14, 7.67384134e+14,
                                      6.45427273e+14, 5.42147051e+14, 4.52777391e+14, 3.78481307e+14,
                                      3.15701345e+14, 2.62886818e+14, 2.18379860e+14, 1.81414252e+14,
                                      1.50833820e+14, 1.25493793e+14, 1.04495686e+14, 8.70892398e+13,
                                      7.26496204e+13, 6.06568916e+13, 5.06914562e+13, 4.23747644e+13,
                                      3.53487904e+13, 2.94561851e+13, 2.42796317e+13, 1.99639369e+13,
                                      1.64288298e+13, 1.35311001e+13, 1.11537623e+13, 1.11307300e+13,
                                      1.06529820e+13, 1.05302954e+13, 6.37240565e+13, 6.13182134e+13,
                                      5.73137959e+13, 4.80803753e+13, 4.02950214e+13, 3.37524964e+13,
                                      2.82019541e+13, 2.35407757e+13, 1.96460463e+13, 1.63930272e+13,
                                      1.36768190e+13, 1.14098534e+13, 9.51003553e+12, 7.89823467e+12,
                                      6.53728001e+12, 5.41143666e+12, 4.47988509e+12, 3.70887509e+12,
                                      3.07081357e+12, 2.54289634e+12, 2.10576263e+12, 1.74392839e+12,
                                      1.44437242e+12, 1.19635394e+12, 9.91777462e+11, 8.22501886e+11,
                                      6.82164839e+11, 5.65795006e+11, 4.69310436e+11, 3.89290498e+11,
                                      3.22953080e+11, 2.67926546e+11, 2.22281659e+11, 1.84426687e+11,
                                      1.53025304e+11, 1.26978346e+11, 1.05369087e+11, 8.74404245e+10,
                                      7.25675252e+10]),
                     'ene': np.array([1.467300e+01, 1.489200e+01, 1.492335e+01, 1.595306e+01,
                                      1.626800e+01, 1.651700e+01, 1.658340e+01, 1.668300e+01,
                                      1.693200e+01, 1.705382e+01, 1.823053e+01, 1.948844e+01,
                                      2.083314e+01, 2.227063e+01, 2.380730e+01, 2.545001e+01,
                                      2.720606e+01, 2.908327e+01, 3.109002e+01, 3.323523e+01,
                                      3.552846e+01, 3.797993e+01, 3.831800e+01, 3.890450e+01,
                                      3.906090e+01, 3.929550e+01, 3.988200e+01, 4.060054e+01,
                                      4.340198e+01, 4.639671e+01, 4.959809e+01, 5.302035e+01,
                                      5.667876e+01, 6.058959e+01, 6.477028e+01, 6.923942e+01,
                                      7.401695e+01, 7.912411e+01, 8.458368e+01, 8.810200e+01,
                                      8.945050e+01, 8.981010e+01, 9.041995e+01, 9.065000e+01,
                                      9.169800e+01, 9.203750e+01, 9.240750e+01, 9.296250e+01,
                                      9.435000e+01, 9.665893e+01, 1.033284e+02, 1.104581e+02,
                                      1.180797e+02, 1.262272e+02, 1.349368e+02, 1.442475e+02,
                                      1.542005e+02, 1.648404e+02, 1.762144e+02, 1.788015e+02,
                                      1.795203e+02, 1.805985e+02, 1.832940e+02, 1.879640e+02,
                                      1.883732e+02, 1.908410e+02, 1.916082e+02, 1.927590e+02,
                                      1.956360e+02, 2.013709e+02, 2.152655e+02, 2.301188e+02,
                                      2.459970e+02, 2.479400e+02, 2.517350e+02, 2.527470e+02,
                                      2.542650e+02, 2.580600e+02, 2.629708e+02, 2.811158e+02,
                                      3.005128e+02, 3.212482e+02, 3.434143e+02, 3.671099e+02,
                                      3.924405e+02, 4.195189e+02, 4.484657e+02, 4.794098e+02,
                                      5.124891e+02, 5.478508e+02, 5.856525e+02, 6.260625e+02,
                                      6.692609e+02, 7.154399e+02, 7.648052e+02, 7.650860e+02,
                                      7.767965e+02, 7.801780e+02, 7.846035e+02, 7.921195e+02,
                                      7.953039e+02, 7.963140e+02, 8.000805e+02, 8.120220e+02,
                                      8.175768e+02, 8.739896e+02, 9.342948e+02, 9.987612e+02,
                                      1.040956e+03, 1.056889e+03, 1.061138e+03, 1.067676e+03,
                                      1.083444e+03, 1.113966e+03, 1.131017e+03, 1.135563e+03,
                                      1.141345e+03, 1.142384e+03, 1.159434e+03, 1.220098e+03,
                                      1.266944e+03, 1.286336e+03, 1.291507e+03, 1.299264e+03,
                                      1.304285e+03, 1.318656e+03, 1.394281e+03, 1.490486e+03,
                                      1.593329e+03, 1.703269e+03, 1.820795e+03, 1.946430e+03,
                                      2.080733e+03, 2.224304e+03, 2.377781e+03, 2.541848e+03,
                                      2.717235e+03, 2.904724e+03, 3.105150e+03, 3.319406e+03,
                                      3.548445e+03, 3.793288e+03, 4.055024e+03, 4.334821e+03,
                                      4.633924e+03, 4.953664e+03, 5.142060e+03, 5.220765e+03,
                                      5.241753e+03, 5.273235e+03, 5.295467e+03, 5.351940e+03,
                                      5.511128e+03, 5.595482e+03, 5.617976e+03, 5.651718e+03,
                                      5.660855e+03, 5.736072e+03, 5.869024e+03, 5.958856e+03,
                                      5.982811e+03, 6.018744e+03, 6.051453e+03, 6.108576e+03,
                                      6.469004e+03, 6.915365e+03, 7.392525e+03, 7.902609e+03,
                                      8.447890e+03, 9.030794e+03, 9.653919e+03, 1.032004e+04,
                                      1.103212e+04, 1.179334e+04, 1.260708e+04, 1.347697e+04,
                                      1.440688e+04, 1.540095e+04, 1.646362e+04, 1.759961e+04,
                                      1.881398e+04, 2.011215e+04, 2.149988e+04, 2.298338e+04,
                                      2.456923e+04, 2.626450e+04, 2.807676e+04, 3.001405e+04,
                                      3.208502e+04, 3.429889e+04, 3.666551e+04, 3.669179e+04,
                                      3.725340e+04, 3.740316e+04, 3.762780e+04, 3.818941e+04,
                                      3.919543e+04, 4.189992e+04, 4.479101e+04, 4.788159e+04,
                                      5.118542e+04, 5.471721e+04, 5.849270e+04, 6.252870e+04,
                                      6.684318e+04, 7.145536e+04, 7.638578e+04, 8.165640e+04,
                                      8.729069e+04, 9.331374e+04, 9.975239e+04, 1.066353e+05,
                                      1.139931e+05, 1.218587e+05, 1.302669e+05, 1.392553e+05,
                                      1.488640e+05, 1.591356e+05, 1.701159e+05, 1.818539e+05,
                                      1.944018e+05, 2.078156e+05, 2.221548e+05, 2.374835e+05,
                                      2.538699e+05, 2.713869e+05, 2.901126e+05, 3.101304e+05,
                                      3.315294e+05, 3.544049e+05, 3.788588e+05, 4.050001e+05,
                                      4.329451e+05]), },
              '57': {'name': 'La',
                     'barns': 2306580000000.0,
                     'NumEdges': 17,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 14.4, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 14.4, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 32.300000000000004,
                            'factor': 1.0},
                     'N5': {'filename': 'La.N5', 'excl before': 5, 'excl after': 50, 'onset': 98.9, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 98.9,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 191.39999999999998,
                            'factor': 1.0, 'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 205.8, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 270.4, 'factor': 1.0},
                     'M5': {'filename': 'La.M5', 'excl before': 5, 'excl after': 50, 'onset': 831.7, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 848.5,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'La.M3', 'excl before': 5, 'excl after': 50, 'onset': 1123.3999999999999,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1204.3999999999999,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1361.3, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5482.700000000001,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5890.6, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6266.3, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 38924.6, 'factor': 1.0},
                     'dat': np.array([4.10317516e+17, 3.96501102e+17, 3.82177240e+17, 3.27488228e+17,
                                      2.76605074e+17, 2.28914226e+17, 1.86570030e+17, 1.50407469e+17,
                                      1.20391943e+17, 9.59906333e+16, 7.64446744e+16, 6.09490699e+16,
                                      4.87426486e+16, 3.91611152e+16, 3.69537182e+16, 3.51984108e+16,
                                      3.47509343e+16, 3.47624672e+16, 3.32239783e+16, 3.23543977e+16,
                                      2.65787213e+16, 2.20691268e+16, 1.85319864e+16, 1.57433311e+16,
                                      1.35303983e+16, 1.17600981e+16, 1.03304798e+16, 9.16311971e+15,
                                      8.20127585e+15, 7.40296851e+15, 6.72990847e+15, 6.15395544e+15,
                                      5.65365824e+15, 5.21379343e+15, 4.82167483e+15, 4.46899875e+15,
                                      4.45538993e+15, 4.38019542e+15, 4.36058949e+15, 1.69648959e+17,
                                      1.37407584e+17, 9.79212407e+16, 3.94771167e+16, 1.98783371e+16,
                                      1.26845754e+16, 9.53032724e+15, 7.97661496e+15, 7.17761564e+15,
                                      6.79633797e+15, 6.68239292e+15, 6.74974505e+15, 6.75943269e+15,
                                      6.78688099e+15, 6.79795258e+15, 1.02631277e+16, 1.02988797e+16,
                                      1.03934495e+16, 1.03989853e+16, 1.04545738e+16, 1.04702586e+16,
                                      1.15993295e+16, 1.16595312e+16, 1.17709391e+16, 1.21010107e+16,
                                      1.24511495e+16, 1.27805291e+16, 1.28153585e+16, 1.28813267e+16,
                                      1.28983954e+16, 1.42475140e+16, 1.42943376e+16, 1.43483115e+16,
                                      1.44707909e+16, 1.44634099e+16, 1.43063318e+16, 1.39954048e+16,
                                      1.35380100e+16, 1.29426817e+16, 1.22255660e+16, 1.14244907e+16,
                                      1.05754386e+16, 9.71047114e+15, 8.85519128e+15, 8.02943564e+15,
                                      7.24612107e+15, 6.51447389e+15, 5.83910727e+15, 5.24770016e+15,
                                      5.22025186e+15, 5.11414918e+15, 5.07240008e+15, 2.10713003e+16,
                                      2.05714644e+16, 2.03742518e+16, 2.03348093e+16, 3.04722284e+16,
                                      2.93789095e+16, 2.86777091e+16, 2.43344190e+16, 2.07414593e+16,
                                      1.76515648e+16, 1.63942480e+16, 1.58058394e+16, 1.56540665e+16,
                                      1.79947839e+16, 1.75138619e+16, 1.73420217e+16, 1.61116920e+16,
                                      1.55479638e+16, 1.54033412e+16, 1.62205625e+16, 1.59172473e+16,
                                      1.56616782e+16, 1.36669478e+16, 1.30116484e+16, 1.25936961e+16,
                                      1.24862095e+16, 1.29129268e+16, 1.25191936e+16, 1.24119376e+16,
                                      1.07099123e+16, 9.19149064e+15, 7.86958964e+15, 6.73198439e+15,
                                      5.74707473e+15, 4.90517303e+15, 4.19082520e+15, 3.57658295e+15,
                                      3.05114402e+15, 2.60528211e+15, 2.22621875e+15, 1.88839705e+15,
                                      1.59121728e+15, 1.33465639e+15, 1.11966006e+15, 9.40646390e+14,
                                      7.91664388e+14, 6.67501186e+14, 5.63059244e+14, 4.73379413e+14,
                                      4.55641813e+14, 4.37858081e+14, 4.33291053e+14, 1.31592696e+15,
                                      1.26259883e+15, 1.22043454e+15, 1.15580417e+15, 1.10893447e+15,
                                      1.09689412e+15, 1.49309537e+15, 1.43370093e+15, 1.40597584e+15,
                                      1.35071018e+15, 1.29622876e+15, 1.28229702e+15, 1.45964996e+15,
                                      1.40606810e+15, 1.36411141e+15, 1.15287482e+15, 9.72823181e+14,
                                      8.19412545e+14, 6.89713552e+14, 5.79574357e+14, 4.84035813e+14,
                                      4.04597198e+14, 3.38375286e+14, 2.82186997e+14, 2.34879041e+14,
                                      1.95060551e+14, 1.62124895e+14, 1.34863426e+14, 1.12263555e+14,
                                      9.35295124e+13, 7.79900830e+13, 6.50939942e+13, 5.43776235e+13,
                                      4.54673050e+13, 3.79939858e+13, 3.17039421e+13, 2.61935225e+13,
                                      2.15510689e+13, 1.77389841e+13, 1.46133376e+13, 1.20484206e+13,
                                      1.07491241e+13, 1.02894227e+13, 1.01713258e+13, 6.10482529e+13,
                                      6.07414777e+13, 5.87416729e+13, 5.10307759e+13, 4.27939787e+13,
                                      3.58627058e+13, 3.00293650e+13, 2.50748312e+13, 2.09326748e+13,
                                      1.74709596e+13, 1.45792002e+13, 1.21651336e+13, 1.01501053e+13,
                                      8.43977622e+12, 6.98847608e+12, 5.78720922e+12, 4.79284258e+12,
                                      3.96962418e+12, 3.28826045e+12, 2.72384032e+12, 2.25666561e+12,
                                      1.86969068e+12, 1.54919139e+12, 1.28372710e+12, 1.06400229e+12,
                                      8.83004956e+11, 7.32846598e+11, 6.08268212e+11, 5.04887296e+11,
                                      4.19105586e+11, 3.47924527e+11, 2.88853013e+11, 2.39815123e+11,
                                      1.99110905e+11, 1.65326428e+11, 1.37283028e+11, 1.14000410e+11,
                                      9.46712695e+10, 7.86220859e+10]),
                     'ene': np.array([1.447200e+01, 1.468800e+01, 1.492335e+01, 1.595306e+01,
                                      1.705382e+01, 1.823053e+01, 1.948844e+01, 2.083314e+01,
                                      2.227063e+01, 2.380730e+01, 2.545001e+01, 2.720606e+01,
                                      2.908327e+01, 3.109002e+01, 3.165400e+01, 3.213850e+01,
                                      3.226770e+01, 3.246150e+01, 3.294600e+01, 3.323523e+01,
                                      3.552846e+01, 3.797993e+01, 4.060054e+01, 4.340198e+01,
                                      4.639671e+01, 4.959809e+01, 5.302035e+01, 5.667876e+01,
                                      6.058959e+01, 6.477028e+01, 6.923942e+01, 7.401695e+01,
                                      7.912411e+01, 8.458368e+01, 9.041995e+01, 9.665893e+01,
                                      9.692200e+01, 9.840550e+01, 9.880110e+01, 9.939450e+01,
                                      1.008780e+02, 1.033284e+02, 1.104581e+02, 1.180797e+02,
                                      1.262272e+02, 1.349368e+02, 1.442475e+02, 1.542005e+02,
                                      1.648404e+02, 1.762144e+02, 1.875720e+02, 1.883732e+02,
                                      1.904430e+02, 1.912086e+02, 1.923570e+02, 1.952280e+02,
                                      2.013709e+02, 2.016840e+02, 2.047710e+02, 2.055942e+02,
                                      2.068290e+02, 2.099160e+02, 2.152655e+02, 2.301188e+02,
                                      2.459970e+02, 2.629708e+02, 2.649920e+02, 2.690480e+02,
                                      2.701296e+02, 2.717520e+02, 2.758080e+02, 2.811158e+02,
                                      3.005128e+02, 3.212482e+02, 3.434143e+02, 3.671099e+02,
                                      3.924405e+02, 4.195189e+02, 4.484657e+02, 4.794098e+02,
                                      5.124891e+02, 5.478508e+02, 5.856525e+02, 6.260625e+02,
                                      6.692609e+02, 7.154399e+02, 7.648052e+02, 8.150660e+02,
                                      8.175768e+02, 8.275415e+02, 8.315300e+02, 8.358585e+02,
                                      8.442575e+02, 8.476515e+02, 8.483340e+02, 8.527425e+02,
                                      8.654700e+02, 8.739896e+02, 9.342948e+02, 9.987612e+02,
                                      1.067676e+03, 1.100932e+03, 1.117783e+03, 1.122277e+03,
                                      1.129017e+03, 1.141345e+03, 1.145868e+03, 1.180312e+03,
                                      1.198378e+03, 1.203196e+03, 1.210422e+03, 1.220098e+03,
                                      1.228488e+03, 1.304285e+03, 1.334074e+03, 1.354493e+03,
                                      1.359939e+03, 1.368106e+03, 1.388526e+03, 1.394281e+03,
                                      1.490486e+03, 1.593329e+03, 1.703269e+03, 1.820795e+03,
                                      1.946430e+03, 2.080733e+03, 2.224304e+03, 2.377781e+03,
                                      2.541848e+03, 2.717235e+03, 2.904724e+03, 3.105150e+03,
                                      3.319406e+03, 3.548445e+03, 3.793288e+03, 4.055024e+03,
                                      4.334821e+03, 4.633924e+03, 4.953664e+03, 5.295467e+03,
                                      5.373046e+03, 5.455286e+03, 5.477217e+03, 5.510113e+03,
                                      5.592354e+03, 5.660855e+03, 5.772788e+03, 5.861147e+03,
                                      5.884710e+03, 5.920053e+03, 6.008412e+03, 6.051453e+03,
                                      6.140974e+03, 6.234969e+03, 6.260034e+03, 6.297632e+03,
                                      6.391626e+03, 6.469004e+03, 6.915365e+03, 7.392525e+03,
                                      7.902609e+03, 8.447890e+03, 9.030794e+03, 9.653919e+03,
                                      1.032004e+04, 1.103212e+04, 1.179334e+04, 1.260708e+04,
                                      1.347697e+04, 1.440688e+04, 1.540095e+04, 1.646362e+04,
                                      1.759961e+04, 1.881398e+04, 2.011215e+04, 2.149988e+04,
                                      2.298338e+04, 2.456923e+04, 2.626450e+04, 2.807676e+04,
                                      3.001405e+04, 3.208502e+04, 3.429889e+04, 3.666551e+04,
                                      3.814611e+04, 3.872998e+04, 3.888567e+04, 3.911922e+04,
                                      3.919543e+04, 3.970309e+04, 4.189992e+04, 4.479101e+04,
                                      4.788159e+04, 5.118542e+04, 5.471721e+04, 5.849270e+04,
                                      6.252870e+04, 6.684318e+04, 7.145536e+04, 7.638578e+04,
                                      8.165640e+04, 8.729069e+04, 9.331374e+04, 9.975239e+04,
                                      1.066353e+05, 1.139931e+05, 1.218587e+05, 1.302669e+05,
                                      1.392553e+05, 1.488640e+05, 1.591356e+05, 1.701159e+05,
                                      1.818539e+05, 1.944018e+05, 2.078156e+05, 2.221548e+05,
                                      2.374835e+05, 2.538699e+05, 2.713869e+05, 2.901126e+05,
                                      3.101304e+05, 3.315294e+05, 3.544049e+05, 3.788588e+05,
                                      4.050001e+05, 4.329451e+05]), },
              '58': {'name': 'Ce',
                     'barns': 2326750000000.0,
                     'NumEdges': 18,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 19.8, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 19.8, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 37.8, 'factor': 1.0},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 85.9, 'factor': 0.75},
                     'N5': {'filename': 'Ce.N5', 'excl before': 5, 'excl after': 50, 'onset': 110.0, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 110.0,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 207.2, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 223.3, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 289.6, 'factor': 1.0},
                     'M5': {'filename': 'Ce.M5', 'excl before': 5, 'excl after': 50, 'onset': 883.3, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 901.3,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Ce.M3', 'excl before': 5, 'excl after': 50, 'onset': 1185.4, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1272.8, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1434.6000000000001,
                            'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5723.4, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6164.2, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6548.8, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 40443.0, 'factor': 1.0},
                     'dat': np.array([4.01178235e+17, 3.81889478e+17, 3.44428802e+17, 2.75650072e+17,
                                      2.16792604e+17, 1.67637684e+17, 1.28208578e+17, 9.74768645e+16,
                                      7.39929768e+16, 5.62771022e+16, 4.30146272e+16, 3.64834400e+16,
                                      3.43916918e+16, 3.38611928e+16, 3.35261408e+16, 3.34958930e+16,
                                      3.16880082e+16, 2.62410865e+16, 2.08344175e+16, 1.68026251e+16,
                                      1.37778501e+16, 1.14908876e+16, 9.74466168e+15, 8.39491400e+15,
                                      7.33670810e+15, 6.49395925e+15, 5.81082545e+15, 5.24728660e+15,
                                      4.80729818e+15, 4.77635240e+15, 4.70957468e+15, 4.68444578e+15,
                                      5.45669410e+15, 5.47600612e+15, 5.57838312e+15, 6.14099128e+15,
                                      7.09705285e+15, 7.83812272e+15, 8.11919412e+15, 8.19434815e+15,
                                      2.59106880e+17, 2.55663290e+17, 2.01917692e+17, 9.21997955e+16,
                                      3.96454932e+16, 2.48078085e+16, 1.96975675e+16, 1.74485309e+16,
                                      1.61269369e+16, 1.51264344e+16, 1.42627448e+16, 1.34972441e+16,
                                      1.34088276e+16, 1.32520046e+16, 1.32115192e+16, 1.63298295e+16,
                                      1.61776601e+16, 1.59968716e+16, 1.58428408e+16, 1.57074239e+16,
                                      1.56725226e+16, 1.66232327e+16, 1.65003803e+16, 1.64184787e+16,
                                      1.59487079e+16, 1.55741011e+16, 1.52685988e+16, 1.52285788e+16,
                                      1.51659892e+16, 1.51497019e+16, 1.63547258e+16, 1.62849232e+16,
                                      1.62044177e+16, 1.58826282e+16, 1.55129076e+16, 1.50631468e+16,
                                      1.45151972e+16, 1.38683607e+16, 1.31300829e+16, 1.23031560e+16,
                                      1.14134068e+16, 1.04945732e+16, 9.57597230e+15, 8.68180228e+15,
                                      7.82951375e+15, 7.03120582e+15, 6.29269538e+15, 5.61747252e+15,
                                      5.08906760e+15, 5.00460658e+15, 4.95597750e+15, 4.91293262e+15,
                                      2.05607917e+16, 2.00240105e+16, 1.98162317e+16, 1.97836572e+16,
                                      2.96963102e+16, 2.85329352e+16, 2.73206985e+16, 2.28549672e+16,
                                      1.92696782e+16, 1.63223839e+16, 1.56294778e+16, 1.50589587e+16,
                                      1.49121408e+16, 1.71732764e+16, 1.65397024e+16, 1.61648630e+16,
                                      1.52941931e+16, 1.47548524e+16, 1.46168762e+16, 1.54082038e+16,
                                      1.48709573e+16, 1.47078521e+16, 1.26428615e+16, 1.24169340e+16,
                                      1.20171984e+16, 1.19145887e+16, 1.23254928e+16, 1.19478612e+16,
                                      1.14976351e+16, 9.90218265e+15, 8.49170680e+15, 7.26597490e+15,
                                      6.21056110e+15, 5.30475732e+15, 4.52483072e+15, 3.86380105e+15,
                                      3.29560870e+15, 2.81094668e+15, 2.40050798e+15, 2.03427752e+15,
                                      1.71246473e+15, 1.44314342e+15, 1.21058476e+15, 1.01630113e+15,
                                      8.54382600e+14, 7.19454368e+14, 6.06956005e+14, 5.11698860e+14,
                                      4.40709718e+14, 4.30169540e+14, 4.23491768e+14, 4.19070943e+14,
                                      1.27961943e+15, 1.22145068e+15, 1.09894729e+15, 1.09347943e+15,
                                      1.05250536e+15, 1.04068547e+15, 1.41559470e+15, 1.35882200e+15,
                                      1.28464521e+15, 1.25723610e+15, 1.23294482e+15, 1.21972888e+15,
                                      1.38876727e+15, 1.33818373e+15, 1.22759330e+15, 1.03891714e+15,
                                      8.76067910e+14, 7.37603018e+14, 6.19753130e+14, 5.17515735e+14,
                                      4.32542825e+14, 3.61832892e+14, 3.02384430e+14, 2.52126630e+14,
                                      2.09728592e+14, 1.74259614e+14, 1.44914644e+14, 1.20614066e+14,
                                      1.00457431e+14, 8.37420592e+13, 6.98723025e+13, 5.83525632e+13,
                                      4.87779870e+13, 4.08111950e+13, 3.40961945e+13, 2.82420915e+13,
                                      2.32640099e+13, 1.91554347e+13, 1.57818799e+13, 1.30130474e+13,
                                      1.07388820e+13, 1.04010378e+13, 9.95732662e+12, 9.84331588e+12,
                                      5.85270695e+13, 5.63399245e+13, 5.41271852e+13, 4.54646950e+13,
                                      3.81098382e+13, 3.19206832e+13, 2.66854958e+13, 2.22821214e+13,
                                      1.86023662e+13, 1.55284968e+13, 1.29611609e+13, 1.08172934e+13,
                                      9.01196810e+12, 7.46467935e+12, 6.18380348e+12, 5.12303815e+12,
                                      4.24469002e+12, 3.51734798e+12, 2.91471972e+12, 2.41563185e+12,
                                      2.00209857e+12, 1.65950790e+12, 1.37564440e+12, 1.14040998e+12,
                                      9.46359028e+11, 7.85976150e+11, 6.52816248e+11, 5.42249088e+11,
                                      4.50435532e+11, 3.74187935e+11, 3.10877068e+11, 2.58292518e+11,
                                      2.14598479e+11, 1.78312813e+11, 1.48169767e+11, 1.23129283e+11,
                                      1.02325812e+11, 8.50403858e+10]),
                     'ene': np.array([1.989900e+01, 2.019600e+01, 2.083314e+01, 2.227063e+01,
                                      2.380730e+01, 2.545001e+01, 2.720606e+01, 2.908327e+01,
                                      3.109002e+01, 3.323523e+01, 3.552846e+01, 3.704400e+01,
                                      3.761100e+01, 3.776220e+01, 3.797993e+01, 3.798900e+01,
                                      3.855600e+01, 4.060054e+01, 4.340198e+01, 4.639671e+01,
                                      4.959809e+01, 5.302035e+01, 5.667876e+01, 6.058959e+01,
                                      6.477028e+01, 6.923942e+01, 7.401695e+01, 7.912411e+01,
                                      8.418200e+01, 8.458368e+01, 8.547050e+01, 8.581410e+01,
                                      8.632950e+01, 8.761800e+01, 9.041995e+01, 9.665893e+01,
                                      1.033284e+02, 1.078000e+02, 1.094500e+02, 1.098900e+02,
                                      1.104581e+02, 1.105500e+02, 1.122000e+02, 1.180797e+02,
                                      1.262272e+02, 1.349368e+02, 1.442475e+02, 1.542005e+02,
                                      1.648404e+02, 1.762144e+02, 1.883732e+02, 2.013709e+02,
                                      2.030560e+02, 2.061640e+02, 2.069928e+02, 2.082360e+02,
                                      2.113440e+02, 2.152655e+02, 2.188340e+02, 2.221835e+02,
                                      2.230767e+02, 2.244165e+02, 2.277660e+02, 2.301188e+02,
                                      2.459970e+02, 2.629708e+02, 2.811158e+02, 2.838080e+02,
                                      2.881520e+02, 2.893104e+02, 2.910480e+02, 2.953920e+02,
                                      3.005128e+02, 3.212482e+02, 3.434143e+02, 3.671099e+02,
                                      3.924405e+02, 4.195189e+02, 4.484657e+02, 4.794098e+02,
                                      5.124891e+02, 5.478508e+02, 5.856525e+02, 6.260625e+02,
                                      6.692609e+02, 7.154399e+02, 7.648052e+02, 8.175768e+02,
                                      8.656340e+02, 8.739896e+02, 8.788835e+02, 8.832740e+02,
                                      8.877165e+02, 8.967935e+02, 9.003987e+02, 9.009660e+02,
                                      9.058065e+02, 9.193260e+02, 9.342948e+02, 9.987612e+02,
                                      1.067676e+03, 1.141345e+03, 1.161692e+03, 1.179473e+03,
                                      1.184215e+03, 1.191327e+03, 1.209108e+03, 1.220098e+03,
                                      1.247344e+03, 1.266436e+03, 1.271527e+03, 1.279164e+03,
                                      1.298256e+03, 1.304285e+03, 1.394281e+03, 1.405908e+03,
                                      1.427427e+03, 1.433165e+03, 1.441773e+03, 1.463292e+03,
                                      1.490486e+03, 1.593329e+03, 1.703269e+03, 1.820795e+03,
                                      1.946430e+03, 2.080733e+03, 2.224304e+03, 2.377781e+03,
                                      2.541848e+03, 2.717235e+03, 2.904724e+03, 3.105150e+03,
                                      3.319406e+03, 3.548445e+03, 3.793288e+03, 4.055024e+03,
                                      4.334821e+03, 4.633924e+03, 4.953664e+03, 5.295467e+03,
                                      5.608932e+03, 5.660855e+03, 5.694783e+03, 5.717677e+03,
                                      5.752017e+03, 5.837868e+03, 6.040916e+03, 6.051453e+03,
                                      6.133379e+03, 6.158036e+03, 6.195021e+03, 6.287484e+03,
                                      6.417824e+03, 6.469004e+03, 6.516056e+03, 6.542251e+03,
                                      6.581544e+03, 6.679776e+03, 6.915365e+03, 7.392525e+03,
                                      7.902609e+03, 8.447890e+03, 9.030794e+03, 9.653919e+03,
                                      1.032004e+04, 1.103212e+04, 1.179334e+04, 1.260708e+04,
                                      1.347697e+04, 1.440688e+04, 1.540095e+04, 1.646362e+04,
                                      1.759961e+04, 1.881398e+04, 2.011215e+04, 2.149988e+04,
                                      2.298338e+04, 2.456923e+04, 2.626450e+04, 2.807676e+04,
                                      3.001405e+04, 3.208502e+04, 3.429889e+04, 3.666551e+04,
                                      3.919543e+04, 3.963414e+04, 4.024079e+04, 4.040256e+04,
                                      4.064522e+04, 4.125186e+04, 4.189992e+04, 4.479101e+04,
                                      4.788159e+04, 5.118542e+04, 5.471721e+04, 5.849270e+04,
                                      6.252870e+04, 6.684318e+04, 7.145536e+04, 7.638578e+04,
                                      8.165640e+04, 8.729069e+04, 9.331374e+04, 9.975239e+04,
                                      1.066353e+05, 1.139931e+05, 1.218587e+05, 1.302669e+05,
                                      1.392553e+05, 1.488640e+05, 1.591356e+05, 1.701159e+05,
                                      1.818539e+05, 1.944018e+05, 2.078156e+05, 2.221548e+05,
                                      2.374835e+05, 2.538699e+05, 2.713869e+05, 2.901126e+05,
                                      3.101304e+05, 3.315294e+05, 3.544049e+05, 3.788588e+05,
                                      4.050001e+05, 4.329451e+05]), },
              '59': {'name': 'Pr',
                     'barns': 2339830000000.0,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 22.3, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 22.3, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 37.400000000000006,
                            'factor': 1.0},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.5, 'factor': 0.75},
                     'N5': {'filename': 'Pr.N5', 'excl before': 5, 'excl after': 50, 'onset': 113.19999999999999,
                            'factor': 1.0, 'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 113.19999999999999,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 217.6, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 236.3, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 304.5, 'factor': 1.0},
                     'M5': {'filename': 'Pr.M5', 'excl before': 5, 'excl after': 50, 'onset': 931.0, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 951.0999999999999,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Pr.M3', 'excl before': 5, 'excl after': 50, 'onset': 1242.2, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1337.3999999999999,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1511.0, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5964.299999999999,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6440.400000000001,
                            'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6834.8, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 41990.6, 'factor': 1.0},
                     'NumEdges': 18,
                     'dat': np.array([1.55102651e+16, 1.60428104e+16, 1.66315116e+16, 1.72766028e+16,
                                      1.79783178e+16, 1.87322110e+16, 1.95305610e+16, 2.03682202e+16,
                                      2.12395728e+16, 2.21375996e+16, 2.30538770e+16, 2.37165169e+16,
                                      2.39271016e+16, 2.39785778e+16, 2.39832575e+16, 4.15109240e+17,
                                      3.94284753e+17, 3.37052512e+17, 2.68565687e+17, 2.12334893e+17,
                                      1.67702636e+17, 1.33414767e+17, 1.07678977e+17, 8.86538189e+16,
                                      8.16085907e+16, 7.85270346e+16, 7.77502111e+16, 7.70131646e+16,
                                      7.51342811e+16, 7.43621372e+16, 6.50659926e+16, 5.77540239e+16,
                                      5.24098522e+16, 4.84204420e+16, 4.54114206e+16, 4.31020084e+16,
                                      4.12863004e+16, 3.98122074e+16, 3.73062495e+16, 3.46131052e+16,
                                      3.20556710e+16, 2.96128885e+16, 2.72777381e+16, 2.50455403e+16,
                                      2.29219106e+16, 2.09061471e+16, 2.07795623e+16, 2.03378024e+16,
                                      2.02219808e+16, 2.16598063e+17, 1.75028643e+17, 1.27941904e+17,
                                      5.52527456e+16, 3.17538329e+16, 2.28566294e+16, 1.84645345e+16,
                                      1.58298859e+16, 1.40459995e+16, 1.27640066e+16, 1.18301805e+16,
                                      1.12454570e+16, 1.11661367e+16, 1.11195741e+16, 1.10882204e+16,
                                      1.41665007e+16, 1.40525510e+16, 1.38150583e+16, 1.37792589e+16,
                                      1.36992367e+16, 1.36795821e+16, 1.46094306e+16, 1.45441493e+16,
                                      1.44650630e+16, 1.42809184e+16, 1.41744562e+16, 1.41070691e+16,
                                      1.40993476e+16, 1.40899883e+16, 1.40853086e+16, 1.52594353e+16,
                                      1.52308894e+16, 1.51590566e+16, 1.49711683e+16, 1.46906227e+16,
                                      1.42979992e+16, 1.37874483e+16, 1.31634156e+16, 1.24366644e+16,
                                      1.16228715e+16, 1.07573684e+16, 9.87267870e+15, 8.99664635e+15,
                                      8.15032984e+15, 7.34823612e+15, 6.59972450e+15, 5.90994261e+15,
                                      5.28006038e+15, 4.90545360e+15, 4.77863481e+15, 4.74564321e+15,
                                      2.01000756e+16, 1.99671733e+16, 1.98864492e+16, 1.92663942e+16,
                                      1.90520658e+16, 2.86020819e+16, 2.73877102e+16, 2.51555123e+16,
                                      2.08853226e+16, 1.75749311e+16, 1.49573633e+16, 1.48745333e+16,
                                      1.44077372e+16, 1.42664115e+16, 1.64585982e+16, 1.58450948e+16,
                                      1.47182326e+16, 1.45478930e+16, 1.40340664e+16, 1.39025679e+16,
                                      1.46545893e+16, 1.41461442e+16, 1.34374097e+16, 1.17604535e+16,
                                      1.15964315e+16, 1.13835069e+16, 1.12864040e+16, 1.16799634e+16,
                                      1.13226714e+16, 1.05531013e+16, 9.07058498e+15, 7.77127738e+15,
                                      6.64792500e+15, 5.68040529e+15, 4.84672386e+15, 4.13564952e+15,
                                      3.53080347e+15, 3.01299909e+15, 2.57217512e+15, 2.17955164e+15,
                                      1.83388856e+15, 1.54517694e+15, 1.30216219e+15, 1.09286440e+15,
                                      9.18242885e+14, 7.72682061e+14, 6.51338477e+14, 5.50047236e+14,
                                      4.63403332e+14, 4.26574407e+14, 4.09938216e+14, 4.05679725e+14,
                                      1.22614111e+15, 1.18989715e+15, 1.17021918e+15, 1.04473410e+15,
                                      1.00072189e+15, 9.89537505e+14, 1.34949695e+15, 1.34741450e+15,
                                      1.29306025e+15, 1.22562635e+15, 1.17602196e+15, 1.16341027e+15,
                                      1.32532651e+15, 1.30302793e+15, 1.27684523e+15, 1.10290227e+15,
                                      9.32515848e+14, 7.86065888e+14, 6.60674399e+14, 5.51731914e+14,
                                      4.61157095e+14, 3.85791170e+14, 3.23036930e+14, 2.69712204e+14,
                                      2.24869362e+14, 1.86961776e+14, 1.55455965e+14, 1.29373880e+14,
                                      1.07758531e+14, 8.98167144e+13, 7.49283761e+13, 6.25670542e+13,
                                      5.22928607e+13, 4.37478015e+13, 3.66136598e+13, 3.03592942e+13,
                                      2.50782979e+13, 2.06630387e+13, 1.70260070e+13, 1.40399159e+13,
                                      1.15868382e+13, 1.00769459e+13, 9.64828900e+12, 9.56990470e+12,
                                      9.53831700e+12, 5.61886776e+13, 5.40804908e+13, 4.81537014e+13,
                                      4.03995048e+13, 3.38573401e+13, 2.83610794e+13, 2.36931186e+13,
                                      1.97881763e+13, 1.65252834e+13, 1.37986795e+13, 1.15208550e+13,
                                      9.60664003e+12, 7.97109886e+12, 6.60463814e+12, 5.47286237e+12,
                                      4.53529249e+12, 3.75893690e+12, 3.11548364e+12, 2.58247037e+12,
                                      2.14092105e+12, 1.77492484e+12, 1.47161268e+12, 1.22022134e+12,
                                      1.01185948e+12, 8.40888105e+11, 6.98883823e+11, 5.80886196e+11,
                                      4.82823920e+11, 4.01374438e+11, 3.33659758e+11, 2.77386846e+11,
                                      2.30623004e+11, 1.91751408e+11, 1.59440696e+11, 1.32579447e+11,
                                      1.10250450e+11, 9.16838987e+10]),
                     'ene': np.array([1.069000e+01, 1.142761e+01, 1.221612e+01, 1.305903e+01,
                                      1.396010e+01, 1.492335e+01, 1.595306e+01, 1.705382e+01,
                                      1.823053e+01, 1.948844e+01, 2.083314e+01, 2.185400e+01,
                                      2.218850e+01, 2.227063e+01, 2.227770e+01, 2.241150e+01,
                                      2.274600e+01, 2.380730e+01, 2.545001e+01, 2.720606e+01,
                                      2.908327e+01, 3.109002e+01, 3.323523e+01, 3.552846e+01,
                                      3.665200e+01, 3.721300e+01, 3.736260e+01, 3.758700e+01,
                                      3.797993e+01, 3.814800e+01, 4.060054e+01, 4.340198e+01,
                                      4.639671e+01, 4.959809e+01, 5.302035e+01, 5.667876e+01,
                                      6.058959e+01, 6.477028e+01, 6.923942e+01, 7.401695e+01,
                                      7.912411e+01, 8.458368e+01, 9.041995e+01, 9.665893e+01,
                                      1.033284e+02, 1.104581e+02, 1.109360e+02, 1.126340e+02,
                                      1.130868e+02, 1.137660e+02, 1.154640e+02, 1.180797e+02,
                                      1.262272e+02, 1.349368e+02, 1.442475e+02, 1.542005e+02,
                                      1.648404e+02, 1.762144e+02, 1.883732e+02, 2.013709e+02,
                                      2.132480e+02, 2.152655e+02, 2.165120e+02, 2.173824e+02,
                                      2.186880e+02, 2.219520e+02, 2.301188e+02, 2.315740e+02,
                                      2.351185e+02, 2.360637e+02, 2.374815e+02, 2.410260e+02,
                                      2.459970e+02, 2.629708e+02, 2.811158e+02, 2.984100e+02,
                                      3.005128e+02, 3.029775e+02, 3.041955e+02, 3.060225e+02,
                                      3.105900e+02, 3.212482e+02, 3.434143e+02, 3.671099e+02,
                                      3.924405e+02, 4.195189e+02, 4.484657e+02, 4.794098e+02,
                                      5.124891e+02, 5.478508e+02, 5.856525e+02, 6.260625e+02,
                                      6.692609e+02, 7.154399e+02, 7.648052e+02, 8.175768e+02,
                                      8.739896e+02, 9.123800e+02, 9.263450e+02, 9.300690e+02,
                                      9.320780e+02, 9.342948e+02, 9.356550e+02, 9.463445e+02,
                                      9.501489e+02, 9.558555e+02, 9.701220e+02, 9.987612e+02,
                                      1.067676e+03, 1.141345e+03, 1.217356e+03, 1.220098e+03,
                                      1.235989e+03, 1.240958e+03, 1.248411e+03, 1.267044e+03,
                                      1.304285e+03, 1.310652e+03, 1.330713e+03, 1.336063e+03,
                                      1.344087e+03, 1.364148e+03, 1.394281e+03, 1.480780e+03,
                                      1.490486e+03, 1.503445e+03, 1.509489e+03, 1.518555e+03,
                                      1.541220e+03, 1.593329e+03, 1.703269e+03, 1.820795e+03,
                                      1.946430e+03, 2.080733e+03, 2.224304e+03, 2.377781e+03,
                                      2.541848e+03, 2.717235e+03, 2.904724e+03, 3.105150e+03,
                                      3.319406e+03, 3.548445e+03, 3.793288e+03, 4.055024e+03,
                                      4.334821e+03, 4.633924e+03, 4.953664e+03, 5.295467e+03,
                                      5.660855e+03, 5.845014e+03, 5.934479e+03, 5.958336e+03,
                                      5.994122e+03, 6.051453e+03, 6.083586e+03, 6.311592e+03,
                                      6.408198e+03, 6.433960e+03, 6.469004e+03, 6.472602e+03,
                                      6.569208e+03, 6.698104e+03, 6.800626e+03, 6.827965e+03,
                                      6.868974e+03, 6.915365e+03, 6.971496e+03, 7.392525e+03,
                                      7.902609e+03, 8.447890e+03, 9.030794e+03, 9.653919e+03,
                                      1.032004e+04, 1.103212e+04, 1.179334e+04, 1.260708e+04,
                                      1.347697e+04, 1.440688e+04, 1.540095e+04, 1.646362e+04,
                                      1.759961e+04, 1.881398e+04, 2.011215e+04, 2.149988e+04,
                                      2.298338e+04, 2.456923e+04, 2.626450e+04, 2.807676e+04,
                                      3.001405e+04, 3.208502e+04, 3.429889e+04, 3.666551e+04,
                                      3.919543e+04, 4.115079e+04, 4.178065e+04, 4.189992e+04,
                                      4.194861e+04, 4.220055e+04, 4.283041e+04, 4.479101e+04,
                                      4.788159e+04, 5.118542e+04, 5.471721e+04, 5.849270e+04,
                                      6.252870e+04, 6.684318e+04, 7.145536e+04, 7.638578e+04,
                                      8.165640e+04, 8.729069e+04, 9.331374e+04, 9.975239e+04,
                                      1.066353e+05, 1.139931e+05, 1.218587e+05, 1.302669e+05,
                                      1.392553e+05, 1.488640e+05, 1.591356e+05, 1.701159e+05,
                                      1.818539e+05, 1.944018e+05, 2.078156e+05, 2.221548e+05,
                                      2.374835e+05, 2.538699e+05, 2.713869e+05, 2.901126e+05,
                                      3.101304e+05, 3.315294e+05, 3.544049e+05, 3.788588e+05,
                                      4.050001e+05, 4.329451e+05]), },
              '60': {'name': 'Nd',
                     'barns': 2395160000000.0,
                     'NumEdges': 18,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 21.1, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 21.1, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 37.5, 'factor': 1.0},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.0, 'factor': 0.75},
                     'N5': {'filename': 'Nd.N5', 'excl before': 5, 'excl after': 50, 'onset': 117.5, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 117.5,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 224.6, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 243.29999999999998,
                            'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 315.2, 'factor': 1.0},
                     'M5': {'filename': 'Nd.M5', 'excl before': 5, 'excl after': 50, 'onset': 977.7, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 999.5,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Nd.M3', 'excl before': 5, 'excl after': 50, 'onset': 1297.4, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1402.8, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1575.3, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6207.900000000001,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6721.5, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7126.0, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 43568.9, 'factor': 1.0},
                     'dat': np.array([1.77107711e+16, 1.84250078e+16, 1.92039138e+16, 2.00470102e+16,
                                      2.09528597e+16, 2.19205043e+16, 2.29470699e+16, 2.40282451e+16,
                                      2.51611558e+16, 2.63371794e+16, 2.74126062e+16, 2.75491303e+16,
                                      2.76928399e+16, 2.77670899e+16, 4.80876273e+17, 4.57379754e+17,
                                      4.07847845e+17, 3.27107001e+17, 2.60329940e+17, 2.06537042e+17,
                                      1.64791798e+17, 1.33247541e+17, 1.09861199e+17, 9.27549662e+16,
                                      8.59670827e+16, 8.32605519e+16, 8.25803265e+16, 8.19791413e+16,
                                      8.07504242e+16, 7.96630216e+16, 7.18835419e+16, 6.55339728e+16,
                                      6.09735881e+16, 5.76826383e+16, 5.52755025e+16, 5.32923100e+16,
                                      4.98432796e+16, 4.66577168e+16, 4.36565813e+16, 4.07919700e+16,
                                      3.80303505e+16, 3.53597471e+16, 3.27753694e+16, 3.02820079e+16,
                                      2.90461053e+16, 2.88664683e+16, 2.86892265e+16, 2.85095895e+16,
                                      2.83323476e+16, 2.81551058e+16, 2.79802591e+16, 2.78030173e+16,
                                      2.76281706e+16, 2.74533239e+16, 2.72784772e+16, 2.71060257e+16,
                                      2.69311790e+16, 2.67587275e+16, 2.65862760e+16, 2.64162196e+16,
                                      2.62437681e+16, 2.60737118e+16, 2.59036554e+16, 2.57359942e+16,
                                      2.55659378e+16, 2.53982766e+16, 2.52306154e+16, 2.50653494e+16,
                                      2.48976882e+16, 2.47324222e+16, 2.45671561e+16, 2.44042852e+16,
                                      2.42390192e+16, 2.40761483e+16, 2.39137565e+16, 2.37518437e+16,
                                      2.35904099e+16, 2.35393930e+16, 1.95179193e+17, 1.95179193e+17,
                                      1.86856012e+17, 1.74774825e+17, 1.63565476e+17, 1.53160901e+17,
                                      1.43506011e+17, 1.34543323e+17, 1.26224932e+17, 1.18500541e+17,
                                      1.11329432e+17, 1.04670887e+17, 9.84889792e+16, 9.27453855e+16,
                                      8.74113642e+16, 8.24533830e+16, 7.78498855e+16, 7.35697346e+16,
                                      6.95913738e+16, 6.58932468e+16, 6.24561922e+16, 5.92610487e+16,
                                      5.63437438e+16, 5.36803259e+16, 5.12444482e+16, 4.90169494e+16,
                                      4.69714828e+16, 4.50912822e+16, 4.33619766e+16, 4.17668001e+16,
                                      4.02913815e+16, 3.89261403e+16, 3.76614958e+16, 3.64854723e+16,
                                      3.53932793e+16, 3.43729412e+16, 3.34220626e+16, 3.25334583e+16,
                                      3.16999426e+16, 3.09191204e+16, 3.01838063e+16, 2.94916051e+16,
                                      2.88425167e+16, 2.82269606e+16, 2.76473319e+16, 2.70964451e+16,
                                      2.65743002e+16, 2.60808972e+16, 2.56114459e+16, 2.51635510e+16,
                                      2.47372125e+16, 2.43300353e+16, 2.39405823e+16, 2.35688534e+16,
                                      2.32129327e+16, 2.28716224e+16, 2.25442040e+16, 2.22294800e+16,
                                      2.19269713e+16, 2.16357198e+16, 2.13550070e+16, 2.10843540e+16,
                                      2.08230420e+16, 2.05708317e+16, 2.03267649e+16, 2.00906021e+16,
                                      1.98618643e+16, 1.96403120e+16, 1.94252266e+16, 1.92166082e+16,
                                      1.90142172e+16, 1.88173350e+16, 1.86259617e+16, 1.84398578e+16,
                                      1.82587837e+16, 1.80822604e+16, 1.79102879e+16, 1.77428662e+16,
                                      1.75795163e+16, 1.74202382e+16, 1.72645528e+16, 1.71126997e+16,
                                      1.69644392e+16, 1.68197716e+16, 1.66782176e+16, 1.65397774e+16,
                                      1.64044508e+16, 1.62722380e+16, 1.61428994e+16, 1.60161954e+16,
                                      1.58923656e+16, 1.57711705e+16, 1.56523706e+16, 1.55362053e+16,
                                      1.54224352e+16, 1.53110603e+16, 1.52018410e+16, 1.50950169e+16,
                                      1.49901089e+16, 1.48875960e+16, 1.47872388e+16, 1.46887977e+16,
                                      1.45922728e+16, 1.44976640e+16, 1.44052108e+16, 1.43144342e+16,
                                      1.42255738e+16, 1.41386295e+16, 1.40533618e+16, 1.39697707e+16,
                                      1.38880957e+16, 1.38078579e+16, 1.37295362e+16, 1.36526515e+16,
                                      1.35774435e+16, 1.35036726e+16, 1.34315782e+16, 1.33611605e+16,
                                      1.32921799e+16, 1.32243969e+16, 1.31585300e+16, 1.30938607e+16,
                                      1.30306285e+16, 1.29688333e+16, 1.29082358e+16, 1.28493149e+16,
                                      1.27915915e+16, 1.27350657e+16, 1.26799770e+16, 1.26263255e+16,
                                      1.25736319e+16, 1.25226150e+16, 1.25161481e+16, 1.56248263e+16,
                                      1.55898569e+16, 1.55378820e+16, 1.54868650e+16, 1.54372852e+16,
                                      1.53886635e+16, 1.53412393e+16, 1.52950127e+16, 1.52499837e+16,
                                      1.52059128e+16, 1.51630394e+16, 1.51211241e+16, 1.50804064e+16,
                                      1.50406467e+16, 1.50020847e+16, 1.49644806e+16, 1.49278347e+16,
                                      1.49223258e+16, 1.58550011e+16, 1.58332052e+16, 1.57979963e+16,
                                      1.57637455e+16, 1.57306923e+16, 1.56983577e+16, 1.56667416e+16,
                                      1.56358440e+16, 1.56059045e+16, 1.55766835e+16, 1.55481811e+16,
                                      1.55203973e+16, 1.54933320e+16, 1.54667457e+16, 1.54411175e+16,
                                      1.54159683e+16, 1.53915377e+16, 1.53678256e+16, 1.53445925e+16,
                                      1.53218385e+16, 1.52998030e+16, 1.52782466e+16, 1.52571692e+16,
                                      1.52365708e+16, 1.52164515e+16, 1.51970507e+16, 1.51778894e+16,
                                      1.51589676e+16, 1.51407644e+16, 1.51228007e+16, 1.51050765e+16,
                                      1.50878314e+16, 1.50708258e+16, 1.50542991e+16, 1.50380121e+16,
                                      1.50217250e+16, 1.50059169e+16, 1.49903484e+16, 1.49747798e+16,
                                      1.49596903e+16, 1.49446008e+16, 1.49295113e+16, 1.49149008e+16,
                                      1.49000508e+16, 1.48854404e+16, 1.48708299e+16, 1.48564589e+16,
                                      1.48418485e+16, 1.48274775e+16, 1.48128670e+16, 1.47984961e+16,
                                      1.47838856e+16, 1.47692751e+16, 1.59155987e+16, 1.59043414e+16,
                                      1.58863777e+16, 1.58681745e+16, 1.58497318e+16, 1.58312891e+16,
                                      1.58126068e+16, 1.57939246e+16, 1.57750028e+16, 1.57558415e+16,
                                      1.57364407e+16, 1.57165609e+16, 1.56966811e+16, 1.56765617e+16,
                                      1.56562029e+16, 1.56353650e+16, 1.56142876e+16, 1.55927311e+16,
                                      1.55711747e+16, 1.55488997e+16, 1.55263852e+16, 1.55036312e+16,
                                      1.54801586e+16, 1.54564465e+16, 1.54322554e+16, 1.54073457e+16,
                                      1.53821966e+16, 1.53565683e+16, 1.53304611e+16, 1.53036353e+16,
                                      1.52765700e+16, 1.52487861e+16, 1.52205233e+16, 1.51917813e+16,
                                      1.51623209e+16, 1.51323814e+16, 1.51019628e+16, 1.50710653e+16,
                                      1.50394492e+16, 1.50073540e+16, 1.49745403e+16, 1.49412476e+16,
                                      1.49074758e+16, 1.48729855e+16, 1.48380162e+16, 1.48023283e+16,
                                      1.47661614e+16, 1.47290364e+16, 1.46914324e+16, 1.46531098e+16,
                                      1.46143083e+16, 1.45750276e+16, 1.45350285e+16, 1.44945503e+16,
                                      1.44533535e+16, 1.44114382e+16, 1.43690439e+16, 1.43261705e+16,
                                      1.42825786e+16, 1.42385077e+16, 1.41939577e+16, 1.41486892e+16,
                                      1.41027021e+16, 1.40564755e+16, 1.40092908e+16, 1.39618667e+16,
                                      1.39137240e+16, 1.38651022e+16, 1.38160014e+16, 1.37664216e+16,
                                      1.37161233e+16, 1.36653459e+16, 1.36140894e+16, 1.35623540e+16,
                                      1.35099000e+16, 1.34572065e+16, 1.34040339e+16, 1.33501428e+16,
                                      1.32960122e+16, 1.32411630e+16, 1.31860743e+16, 1.31305066e+16,
                                      1.30742204e+16, 1.30174551e+16, 1.29602108e+16, 1.29024874e+16,
                                      1.28440455e+16, 1.27851246e+16, 1.27259641e+16, 1.26660851e+16,
                                      1.26057271e+16, 1.25451295e+16, 1.24838134e+16, 1.24222578e+16,
                                      1.23604627e+16, 1.22979490e+16, 1.22351958e+16, 1.21722031e+16,
                                      1.21087314e+16, 1.20450201e+16, 1.19808298e+16, 1.19166395e+16,
                                      1.18519702e+16, 1.17870614e+16, 1.17216735e+16, 1.16562857e+16,
                                      1.15906583e+16, 1.15247914e+16, 1.14586850e+16, 1.13925785e+16,
                                      1.13259931e+16, 1.12594076e+16, 1.11925827e+16, 1.11257577e+16,
                                      1.10589328e+16, 1.09916288e+16, 1.09245643e+16, 1.08572603e+16,
                                      1.07899563e+16, 1.07224128e+16, 1.06548693e+16, 1.05875653e+16,
                                      1.05200218e+16, 1.04524782e+16, 1.03849347e+16, 1.03173912e+16,
                                      1.02498477e+16, 1.01823042e+16, 1.01150002e+16, 1.00476962e+16,
                                      9.98039220e+15, 9.91308821e+15, 9.84578421e+15, 9.77871973e+15,
                                      9.71189477e+15, 9.64506980e+15, 9.57824484e+15, 9.51165939e+15,
                                      9.44531346e+15, 9.37896753e+15, 9.31262160e+15, 9.24675470e+15,
                                      9.18088780e+15, 9.11526041e+15, 9.04963303e+15, 8.98448468e+15,
                                      8.91933632e+15, 8.85442749e+15, 8.78975817e+15, 8.72532836e+15,
                                      8.66113808e+15, 8.59718730e+15, 8.53323653e+15, 8.46976479e+15,
                                      8.40653257e+15, 8.34353986e+15, 8.28054715e+15, 8.21803348e+15,
                                      8.15599883e+15, 8.09396419e+15, 8.03216906e+15, 7.97085296e+15,
                                      7.90953687e+15, 7.84869980e+15, 7.78810226e+15, 7.72774422e+15,
                                      7.66762571e+15, 7.60798622e+15, 7.54858626e+15, 7.48942580e+15,
                                      7.43074438e+15, 7.37206296e+15, 7.31410009e+15, 7.25613722e+15,
                                      7.19865338e+15, 7.14140906e+15, 7.08440425e+15, 7.02787847e+15,
                                      6.97159221e+15, 6.91578498e+15, 6.86021727e+15, 6.80488908e+15,
                                      6.75003991e+15, 6.69543026e+15, 6.64129965e+15, 6.58740855e+15,
                                      6.53375696e+15, 6.48058441e+15, 6.42765138e+15, 6.37519737e+15,
                                      6.32298288e+15, 6.27100791e+15, 6.21951197e+15, 6.16825555e+15,
                                      6.11747816e+15, 6.06694028e+15, 6.01688144e+15, 5.96706211e+15,
                                      5.91748230e+15, 5.86838152e+15, 5.81952025e+15, 5.77113802e+15,
                                      5.72299530e+15, 5.67509210e+15, 5.62766794e+15, 5.58072280e+15,
                                      5.53401718e+15, 5.48755108e+15, 5.44132449e+15, 5.39557693e+15,
                                      5.35030841e+15, 5.30503988e+15, 5.26025039e+15, 5.21593993e+15,
                                      5.17186899e+15, 5.12803756e+15, 5.08468516e+15, 5.04157228e+15,
                                      4.99869892e+15, 4.95630459e+15, 4.91414977e+15, 4.87223447e+15,
                                      4.83079820e+15, 4.78960145e+15, 4.74864422e+15, 4.70816601e+15,
                                      4.66792732e+15, 4.62816767e+15, 4.62313783e+15, 1.84762642e+16,
                                      1.82997409e+16, 1.80904040e+16, 1.78834621e+16, 1.76791550e+16,
                                      1.75699357e+16, 2.64880744e+16, 2.65144212e+16, 2.61862843e+16,
                                      2.58629377e+16, 2.55419862e+16, 2.52258251e+16, 2.49144543e+16,
                                      2.46054787e+16, 2.43012934e+16, 2.39995032e+16, 2.37037009e+16,
                                      2.34105334e+16, 2.31211980e+16, 2.28352159e+16, 2.25528266e+16,
                                      2.22740299e+16, 2.19988261e+16, 2.17267359e+16, 2.14582384e+16,
                                      2.11930942e+16, 2.09313032e+16, 2.06726260e+16, 2.04173019e+16,
                                      2.01650916e+16, 1.99159949e+16, 1.96700120e+16, 1.94271428e+16,
                                      1.91873872e+16, 1.89505059e+16, 1.87164988e+16, 1.84856054e+16,
                                      1.82573466e+16, 1.80322016e+16, 1.78096912e+16, 1.75898155e+16,
                                      1.73728140e+16, 1.71586867e+16, 1.69469546e+16, 1.67380966e+16,
                                      1.65316338e+16, 1.63278057e+16, 1.61266123e+16, 1.59278140e+16,
                                      1.57314109e+16, 1.55376424e+16, 1.53462692e+16, 1.51570515e+16,
                                      1.49704685e+16, 1.47858017e+16, 1.46035300e+16, 1.44236535e+16,
                                      1.42459326e+16, 1.40703674e+16, 1.39429449e+16, 1.62834953e+16,
                                      1.62820582e+16, 1.60705655e+16, 1.58607495e+16, 1.56535682e+16,
                                      1.54490215e+16, 1.52473490e+16, 1.50483112e+16, 1.48521476e+16,
                                      1.46583792e+16, 1.44672454e+16, 1.42847342e+16, 1.41108456e+16,
                                      1.39395917e+16, 1.37714515e+16, 1.36059459e+16, 1.34428355e+16,
                                      1.33791242e+16, 1.42514415e+16, 1.41929996e+16, 1.40207876e+16,
                                      1.38509708e+16, 1.36840281e+16, 1.35194806e+16, 1.33575678e+16,
                                      1.31978106e+16, 1.30406881e+16, 1.28859608e+16, 1.27333891e+16,
                                      1.25868053e+16, 1.24433352e+16, 1.23020208e+16, 1.21628620e+16,
                                      1.20260984e+16, 1.18912509e+16, 1.17585590e+16, 1.16277833e+16,
                                      1.14989236e+16, 1.13719802e+16, 1.12469528e+16, 1.11236021e+16,
                                      1.10021675e+16, 1.09391748e+16, 1.14019197e+16, 1.13968898e+16,
                                      1.12792875e+16, 1.11583319e+16, 1.10390529e+16, 1.09212111e+16,
                                      1.08050458e+16, 1.06903176e+16, 1.05770266e+16, 1.04651726e+16,
                                      1.03547557e+16, 1.02436203e+16, 1.01327244e+16, 1.00232656e+16,
                                      9.91524385e+15, 9.80602456e+15, 9.69464962e+15, 9.58471177e+15,
                                      9.47597151e+15, 9.36842882e+15, 9.26232324e+15, 9.15741523e+15,
                                      9.05370480e+15, 8.95119195e+15, 8.84963717e+15, 8.74951948e+15,
                                      8.65035986e+15, 8.55263733e+15, 8.45563335e+15, 8.36006646e+15,
                                      8.26521813e+15, 8.17036979e+15, 8.07624000e+15, 7.98330780e+15,
                                      7.89133365e+15, 7.80031757e+15, 7.71025956e+15, 7.62139912e+15,
                                      7.53349675e+15, 7.44631292e+15, 7.36032668e+15, 7.27529850e+15,
                                      7.19122838e+15, 7.10787682e+15, 7.02572283e+15, 6.94452690e+15,
                                      6.86404953e+15, 6.78453022e+15, 6.70596897e+15, 6.62812627e+15,
                                      6.55124163e+15, 6.47531506e+15, 6.40010704e+15, 6.32585708e+15,
                                      6.25232566e+15, 6.17951280e+15, 6.10741848e+15, 6.03604272e+15,
                                      5.96562501e+15, 5.89592586e+15, 5.82718476e+15, 5.75916222e+15,
                                      5.69185822e+15, 5.62551229e+15, 5.55964539e+15, 5.49473656e+15,
                                      5.43054627e+15, 5.36707453e+15, 5.30456085e+15, 5.24204718e+15,
                                      5.18001253e+15, 5.11869644e+15, 5.05809889e+15, 4.99821989e+15,
                                      4.93905944e+15, 4.88061753e+15, 4.82289418e+15, 4.76588937e+15,
                                      4.70960311e+15, 4.65379588e+15, 4.59894672e+15, 4.54457658e+15,
                                      4.49092500e+15, 4.43799196e+15, 4.38553796e+15, 4.33404202e+15,
                                      4.28278560e+15, 4.23248724e+15, 4.18266791e+15, 4.13332761e+15,
                                      4.08494538e+15, 4.03680266e+15, 3.98937850e+15, 3.94267288e+15,
                                      3.89644629e+15, 3.85069873e+15, 3.80566972e+15, 3.76111975e+15,
                                      3.71704880e+15, 3.67369641e+15, 3.63058353e+15, 3.58818920e+15,
                                      3.54579486e+15, 3.50387956e+15, 3.46244330e+15, 3.42148606e+15,
                                      3.38124737e+15, 3.34124820e+15, 3.30196758e+15, 3.26292647e+15,
                                      3.22460391e+15, 3.18652086e+15, 3.14915637e+15, 3.11227090e+15,
                                      3.07562496e+15, 3.03945804e+15, 3.00377016e+15, 2.96856130e+15,
                                      2.93359197e+15, 2.89886215e+15, 2.86461136e+15, 2.83083960e+15,
                                      2.79754688e+15, 2.76473319e+15, 2.73215901e+15, 2.70006387e+15,
                                      2.66820824e+15, 2.63707116e+15, 2.60593408e+15, 2.57551555e+15,
                                      2.54509702e+15, 2.51252284e+15, 2.48018818e+15, 2.44833255e+15,
                                      2.41695596e+15, 2.38605839e+15, 2.35547220e+15, 2.32531713e+15,
                                      2.29554530e+15, 2.26618063e+15, 2.23715129e+15, 2.20840937e+15,
                                      2.18005068e+15, 2.15207521e+15, 2.12445902e+15, 2.09720210e+15,
                                      2.07032840e+15, 2.04379003e+15, 2.01761093e+15, 1.99176715e+15,
                                      1.96628265e+15, 1.94110952e+15, 1.91629566e+15, 1.89179317e+15,
                                      1.86762601e+15, 1.84377022e+15, 1.82022579e+15, 1.79701669e+15,
                                      1.77409501e+15, 1.75148470e+15, 1.72916181e+15, 1.70715029e+15,
                                      1.68540224e+15, 1.66396556e+15, 1.64281629e+15, 1.62193050e+15,
                                      1.60133212e+15, 1.58099721e+15, 1.56092577e+15, 1.54111780e+15,
                                      1.52159724e+15, 1.50231621e+15, 1.48327468e+15, 1.46452058e+15,
                                      1.44598204e+15, 1.42770697e+15, 1.40967142e+15, 1.39185143e+15,
                                      1.37429490e+15, 1.35695395e+15, 1.33985250e+15, 1.32296663e+15,
                                      1.30629631e+15, 1.28986551e+15, 1.27329101e+15, 1.25688416e+15,
                                      1.24071683e+15, 1.22476507e+15, 1.17214340e+15, 9.84458663e+14,
                                      8.27934957e+14, 6.97374786e+14, 5.88490812e+14, 4.97259168e+14,
                                      4.18745823e+14, 4.13069294e+14, 3.96997770e+14, 3.92878095e+14,
                                      1.17336493e+15, 1.12083907e+15, 1.04919984e+15, 9.94973416e+14,
                                      9.53513196e+14, 9.42950540e+14, 1.29197326e+15, 1.23762708e+15,
                                      1.20713669e+15, 1.17358050e+15, 1.12433601e+15, 1.11209674e+15,
                                      1.26656061e+15, 1.21983104e+15, 1.16907760e+15, 9.89536402e+14,
                                      8.35838985e+14, 7.03242928e+14, 5.87556700e+14, 4.91079655e+14,
                                      4.10793892e+14, 3.43968928e+14, 2.87946135e+14, 2.40426161e+14,
                                      2.00300045e+14, 1.66540265e+14, 1.38591143e+14, 1.15432341e+14,
                                      9.62231578e+13, 8.02689971e+13, 6.70213671e+13, 5.60132118e+13,
                                      4.68565151e+13, 3.92351160e+13, 3.25765712e+13, 2.69551306e+13,
                                      2.22510364e+13, 1.83447700e+13, 1.51280701e+13, 1.24852505e+13,
                                      1.03126009e+13, 9.77153425e+12, 9.35669254e+12, 9.25010792e+12,
                                      5.39413984e+13, 5.19390446e+13, 5.09091258e+13, 4.28110898e+13,
                                      3.58962629e+13, 3.00688386e+13, 2.51515752e+13, 2.10151338e+13,
                                      1.75570018e+13, 1.46670018e+13, 1.22519619e+13, 1.02203872e+13,
                                      8.50066236e+12, 7.04488411e+12, 5.83916056e+12, 4.84013933e+12,
                                      4.01237203e+12, 3.32663772e+12, 2.75802674e+12, 2.28704248e+12,
                                      1.89655954e+12, 1.57285367e+12, 1.30449994e+12, 1.08201353e+12,
                                      8.98520322e+11, 7.47289920e+11, 6.21544020e+11, 5.16995286e+11,
                                      4.30050978e+11, 3.57765049e+11, 2.97622582e+11, 2.47635592e+11,
                                      2.06029268e+11, 1.71431182e+11, 1.42648544e+11, 1.18706525e+11,
                                      9.87859790e+10]),
                     'ene': np.array([1.0690000e+01, 1.1427610e+01, 1.2216120e+01, 1.3059030e+01,
                                      1.3960100e+01, 1.4923350e+01, 1.5953060e+01, 1.7053820e+01,
                                      1.8230530e+01, 1.9488440e+01, 2.0678000e+01, 2.0833140e+01,
                                      2.0994500e+01, 2.1078900e+01, 2.1205500e+01, 2.1522000e+01,
                                      2.2270630e+01, 2.3807300e+01, 2.5450010e+01, 2.7206060e+01,
                                      2.9083270e+01, 3.1090020e+01, 3.3235230e+01, 3.5528460e+01,
                                      3.6750000e+01, 3.7312500e+01, 3.7462500e+01, 3.7687500e+01,
                                      3.7979930e+01, 3.8250000e+01, 4.0600540e+01, 4.3401980e+01,
                                      4.6396710e+01, 4.9598090e+01, 5.3020350e+01, 5.6678760e+01,
                                      6.0589590e+01, 6.4770280e+01, 6.9239420e+01, 7.4016950e+01,
                                      7.9124110e+01, 8.4583680e+01, 9.0419950e+01, 9.6658930e+01,
                                      1.0000000e+02, 1.0050000e+02, 1.0100250e+02, 1.0150751e+02,
                                      1.0201505e+02, 1.0252513e+02, 1.0303775e+02, 1.0355294e+02,
                                      1.0407070e+02, 1.0459106e+02, 1.0511401e+02, 1.0563958e+02,
                                      1.0616778e+02, 1.0669862e+02, 1.0723211e+02, 1.0776827e+02,
                                      1.0830712e+02, 1.0884865e+02, 1.0939289e+02, 1.0993986e+02,
                                      1.1048956e+02, 1.1104201e+02, 1.1159722e+02, 1.1215520e+02,
                                      1.1271598e+02, 1.1327956e+02, 1.1384596e+02, 1.1441519e+02,
                                      1.1498726e+02, 1.1556220e+02, 1.1614001e+02, 1.1672071e+02,
                                      1.1730431e+02, 1.1748954e+02, 1.1751046e+02, 1.1751048e+02,
                                      1.1789083e+02, 1.1848029e+02, 1.1907269e+02, 1.1966805e+02,
                                      1.2026639e+02, 1.2086772e+02, 1.2147206e+02, 1.2207942e+02,
                                      1.2268982e+02, 1.2330327e+02, 1.2391979e+02, 1.2453939e+02,
                                      1.2516208e+02, 1.2578789e+02, 1.2641683e+02, 1.2704892e+02,
                                      1.2768416e+02, 1.2832258e+02, 1.2896419e+02, 1.2960902e+02,
                                      1.3025706e+02, 1.3090835e+02, 1.3156289e+02, 1.3222070e+02,
                                      1.3288181e+02, 1.3354621e+02, 1.3421395e+02, 1.3488502e+02,
                                      1.3555944e+02, 1.3623724e+02, 1.3691842e+02, 1.3760302e+02,
                                      1.3829103e+02, 1.3898249e+02, 1.3967740e+02, 1.4037579e+02,
                                      1.4107766e+02, 1.4178305e+02, 1.4249197e+02, 1.4320443e+02,
                                      1.4392045e+02, 1.4464005e+02, 1.4536325e+02, 1.4609007e+02,
                                      1.4682052e+02, 1.4755462e+02, 1.4829239e+02, 1.4903386e+02,
                                      1.4977903e+02, 1.5052792e+02, 1.5128056e+02, 1.5203696e+02,
                                      1.5279715e+02, 1.5356113e+02, 1.5432894e+02, 1.5510058e+02,
                                      1.5587609e+02, 1.5665547e+02, 1.5743875e+02, 1.5822594e+02,
                                      1.5901707e+02, 1.5981215e+02, 1.6061121e+02, 1.6141427e+02,
                                      1.6222134e+02, 1.6303245e+02, 1.6384761e+02, 1.6466685e+02,
                                      1.6549018e+02, 1.6631763e+02, 1.6714922e+02, 1.6798497e+02,
                                      1.6882489e+02, 1.6966902e+02, 1.7051736e+02, 1.7136995e+02,
                                      1.7222680e+02, 1.7308793e+02, 1.7395337e+02, 1.7482314e+02,
                                      1.7569726e+02, 1.7657574e+02, 1.7745862e+02, 1.7834591e+02,
                                      1.7923764e+02, 1.8013383e+02, 1.8103450e+02, 1.8193967e+02,
                                      1.8284937e+02, 1.8376362e+02, 1.8468244e+02, 1.8560585e+02,
                                      1.8653388e+02, 1.8746655e+02, 1.8840388e+02, 1.8934590e+02,
                                      1.9029263e+02, 1.9124409e+02, 1.9220031e+02, 1.9316131e+02,
                                      1.9412712e+02, 1.9509776e+02, 1.9607325e+02, 1.9705361e+02,
                                      1.9803888e+02, 1.9902907e+02, 2.0002422e+02, 2.0102434e+02,
                                      2.0202946e+02, 2.0303961e+02, 2.0405481e+02, 2.0507508e+02,
                                      2.0610046e+02, 2.0713096e+02, 2.0816661e+02, 2.0920745e+02,
                                      2.1025348e+02, 2.1130475e+02, 2.1236128e+02, 2.1342308e+02,
                                      2.1449020e+02, 2.1556265e+02, 2.1664046e+02, 2.1772366e+02,
                                      2.1881228e+02, 2.1990634e+02, 2.2100588e+02, 2.2211090e+02,
                                      2.2322146e+02, 2.2433757e+02, 2.2447692e+02, 2.2472308e+02,
                                      2.2545925e+02, 2.2658655e+02, 2.2771948e+02, 2.2885808e+02,
                                      2.3000237e+02, 2.3115238e+02, 2.3230814e+02, 2.3346969e+02,
                                      2.3463703e+02, 2.3581022e+02, 2.3698927e+02, 2.3817422e+02,
                                      2.3936509e+02, 2.4056191e+02, 2.4176472e+02, 2.4297355e+02,
                                      2.4315743e+02, 2.4344258e+02, 2.4418841e+02, 2.4540936e+02,
                                      2.4663640e+02, 2.4786959e+02, 2.4910893e+02, 2.5035448e+02,
                                      2.5160625e+02, 2.5286428e+02, 2.5412860e+02, 2.5539925e+02,
                                      2.5667624e+02, 2.5795962e+02, 2.5924942e+02, 2.6054567e+02,
                                      2.6184840e+02, 2.6315764e+02, 2.6447343e+02, 2.6579579e+02,
                                      2.6712477e+02, 2.6846040e+02, 2.6980270e+02, 2.7115171e+02,
                                      2.7250747e+02, 2.7387001e+02, 2.7523936e+02, 2.7661556e+02,
                                      2.7799863e+02, 2.7938863e+02, 2.8078557e+02, 2.8218950e+02,
                                      2.8360044e+02, 2.8501845e+02, 2.8644354e+02, 2.8787576e+02,
                                      2.8931514e+02, 2.9076171e+02, 2.9221552e+02, 2.9367660e+02,
                                      2.9514498e+02, 2.9662071e+02, 2.9810381e+02, 2.9959433e+02,
                                      3.0109230e+02, 3.0259776e+02, 3.0411075e+02, 3.0563130e+02,
                                      3.0715946e+02, 3.0869526e+02, 3.1023873e+02, 3.1178993e+02,
                                      3.1334888e+02, 3.1491562e+02, 3.1551520e+02, 3.1649020e+02,
                                      3.1807265e+02, 3.1966301e+02, 3.2126133e+02, 3.2286764e+02,
                                      3.2448197e+02, 3.2610438e+02, 3.2773491e+02, 3.2937358e+02,
                                      3.3102045e+02, 3.3267555e+02, 3.3433893e+02, 3.3601062e+02,
                                      3.3769068e+02, 3.3937913e+02, 3.4107602e+02, 3.4278140e+02,
                                      3.4449531e+02, 3.4621779e+02, 3.4794888e+02, 3.4968862e+02,
                                      3.5143706e+02, 3.5319425e+02, 3.5496022e+02, 3.5673502e+02,
                                      3.5851870e+02, 3.6031129e+02, 3.6211285e+02, 3.6392341e+02,
                                      3.6574303e+02, 3.6757174e+02, 3.6940960e+02, 3.7125665e+02,
                                      3.7311293e+02, 3.7497850e+02, 3.7685339e+02, 3.7873766e+02,
                                      3.8063135e+02, 3.8253450e+02, 3.8444718e+02, 3.8636941e+02,
                                      3.8830126e+02, 3.9024276e+02, 3.9219398e+02, 3.9415495e+02,
                                      3.9612572e+02, 3.9810635e+02, 4.0009688e+02, 4.0209737e+02,
                                      4.0410785e+02, 4.0612839e+02, 4.0815904e+02, 4.1019983e+02,
                                      4.1225083e+02, 4.1431208e+02, 4.1638364e+02, 4.1846556e+02,
                                      4.2055789e+02, 4.2266068e+02, 4.2477398e+02, 4.2689785e+02,
                                      4.2903234e+02, 4.3117750e+02, 4.3333339e+02, 4.3550006e+02,
                                      4.3767756e+02, 4.3986595e+02, 4.4206528e+02, 4.4427560e+02,
                                      4.4649698e+02, 4.4872947e+02, 4.5097311e+02, 4.5322798e+02,
                                      4.5549412e+02, 4.5777159e+02, 4.6006045e+02, 4.6236075e+02,
                                      4.6467255e+02, 4.6699592e+02, 4.6933090e+02, 4.7167755e+02,
                                      4.7403594e+02, 4.7640612e+02, 4.7878815e+02, 4.8118209e+02,
                                      4.8358800e+02, 4.8600594e+02, 4.8843597e+02, 4.9087815e+02,
                                      4.9333254e+02, 4.9579920e+02, 4.9827820e+02, 5.0076959e+02,
                                      5.0327344e+02, 5.0578980e+02, 5.0831875e+02, 5.1086035e+02,
                                      5.1341465e+02, 5.1598172e+02, 5.1856163e+02, 5.2115444e+02,
                                      5.2376021e+02, 5.2637901e+02, 5.2901091e+02, 5.3165596e+02,
                                      5.3431424e+02, 5.3698581e+02, 5.3967074e+02, 5.4236910e+02,
                                      5.4508094e+02, 5.4780635e+02, 5.5054538e+02, 5.5329810e+02,
                                      5.5606460e+02, 5.5884492e+02, 5.6163914e+02, 5.6444734e+02,
                                      5.6726958e+02, 5.7010592e+02, 5.7295645e+02, 5.7582123e+02,
                                      5.7870034e+02, 5.8159384e+02, 5.8450181e+02, 5.8742432e+02,
                                      5.9036144e+02, 5.9331325e+02, 5.9627982e+02, 5.9926122e+02,
                                      6.0225752e+02, 6.0526881e+02, 6.0829515e+02, 6.1133663e+02,
                                      6.1439331e+02, 6.1746528e+02, 6.2055260e+02, 6.2365537e+02,
                                      6.2677364e+02, 6.2990751e+02, 6.3305705e+02, 6.3622234e+02,
                                      6.3940345e+02, 6.4260046e+02, 6.4581347e+02, 6.4904253e+02,
                                      6.5228775e+02, 6.5554919e+02, 6.5882693e+02, 6.6212107e+02,
                                      6.6543167e+02, 6.6875883e+02, 6.7210262e+02, 6.7546314e+02,
                                      6.7884045e+02, 6.8223466e+02, 6.8564583e+02, 6.8907406e+02,
                                      6.9251943e+02, 6.9598202e+02, 6.9946194e+02, 7.0295924e+02,
                                      7.0647404e+02, 7.1000641e+02, 7.1355644e+02, 7.1712423e+02,
                                      7.2070985e+02, 7.2431340e+02, 7.2793496e+02, 7.3157464e+02,
                                      7.3523251e+02, 7.3890867e+02, 7.4260322e+02, 7.4631623e+02,
                                      7.5004781e+02, 7.5379805e+02, 7.5756704e+02, 7.6135488e+02,
                                      7.6516165e+02, 7.6898746e+02, 7.7283240e+02, 7.7669656e+02,
                                      7.8058004e+02, 7.8448294e+02, 7.8840536e+02, 7.9234738e+02,
                                      7.9630912e+02, 8.0029067e+02, 8.0429212e+02, 8.0831358e+02,
                                      8.1235515e+02, 8.1641693e+02, 8.2049901e+02, 8.2460150e+02,
                                      8.2872451e+02, 8.3286813e+02, 8.3703248e+02, 8.4121764e+02,
                                      8.4542373e+02, 8.4965084e+02, 8.5389910e+02, 8.5816859e+02,
                                      8.6245944e+02, 8.6677173e+02, 8.7110559e+02, 8.7546112e+02,
                                      8.7983843e+02, 8.8423762e+02, 8.8865881e+02, 8.9310210e+02,
                                      8.9756761e+02, 9.0205545e+02, 9.0656573e+02, 9.1109856e+02,
                                      9.1565405e+02, 9.2023232e+02, 9.2483348e+02, 9.2945765e+02,
                                      9.3410494e+02, 9.3877546e+02, 9.4346934e+02, 9.4818668e+02,
                                      9.5292762e+02, 9.5769226e+02, 9.6248072e+02, 9.6729312e+02,
                                      9.7212959e+02, 9.7699023e+02, 9.7760223e+02, 9.7779777e+02,
                                      9.8187519e+02, 9.8678456e+02, 9.9171848e+02, 9.9667708e+02,
                                      9.9936105e+02, 9.9963891e+02, 1.0016605e+03, 1.0066688e+03,
                                      1.0117021e+03, 1.0167606e+03, 1.0218444e+03, 1.0269536e+03,
                                      1.0320884e+03, 1.0372489e+03, 1.0424351e+03, 1.0476473e+03,
                                      1.0528855e+03, 1.0581499e+03, 1.0634407e+03, 1.0687579e+03,
                                      1.0741017e+03, 1.0794722e+03, 1.0848695e+03, 1.0902939e+03,
                                      1.0957454e+03, 1.1012241e+03, 1.1067302e+03, 1.1122639e+03,
                                      1.1178252e+03, 1.1234143e+03, 1.1290314e+03, 1.1346765e+03,
                                      1.1403499e+03, 1.1460517e+03, 1.1517819e+03, 1.1575408e+03,
                                      1.1633285e+03, 1.1691452e+03, 1.1749909e+03, 1.1808659e+03,
                                      1.1867702e+03, 1.1927040e+03, 1.1986676e+03, 1.2046609e+03,
                                      1.2106842e+03, 1.2167376e+03, 1.2228213e+03, 1.2289354e+03,
                                      1.2350801e+03, 1.2412555e+03, 1.2474618e+03, 1.2536991e+03,
                                      1.2599676e+03, 1.2662674e+03, 1.2725988e+03, 1.2789618e+03,
                                      1.2853566e+03, 1.2917833e+03, 1.2965165e+03, 1.2982423e+03,
                                      1.2982835e+03, 1.3047335e+03, 1.3112571e+03, 1.3178134e+03,
                                      1.3244025e+03, 1.3310245e+03, 1.3376796e+03, 1.3443680e+03,
                                      1.3510899e+03, 1.3578453e+03, 1.3646345e+03, 1.3714577e+03,
                                      1.3783150e+03, 1.3852066e+03, 1.3921326e+03, 1.3990933e+03,
                                      1.4018615e+03, 1.4037384e+03, 1.4060887e+03, 1.4131192e+03,
                                      1.4201848e+03, 1.4272857e+03, 1.4344221e+03, 1.4415942e+03,
                                      1.4488022e+03, 1.4560462e+03, 1.4633265e+03, 1.4706431e+03,
                                      1.4779963e+03, 1.4853863e+03, 1.4928132e+03, 1.5002773e+03,
                                      1.5077787e+03, 1.5153176e+03, 1.5228942e+03, 1.5305086e+03,
                                      1.5381612e+03, 1.5458520e+03, 1.5535812e+03, 1.5613491e+03,
                                      1.5691559e+03, 1.5732678e+03, 1.5770017e+03, 1.5773321e+03,
                                      1.5848867e+03, 1.5928111e+03, 1.6007752e+03, 1.6087790e+03,
                                      1.6168229e+03, 1.6249070e+03, 1.6330316e+03, 1.6411967e+03,
                                      1.6494027e+03, 1.6576497e+03, 1.6659380e+03, 1.6742677e+03,
                                      1.6826390e+03, 1.6910522e+03, 1.6995075e+03, 1.7080050e+03,
                                      1.7165450e+03, 1.7251278e+03, 1.7337534e+03, 1.7424222e+03,
                                      1.7511343e+03, 1.7598899e+03, 1.7686894e+03, 1.7775328e+03,
                                      1.7864205e+03, 1.7953526e+03, 1.8043294e+03, 1.8133510e+03,
                                      1.8224178e+03, 1.8315299e+03, 1.8406875e+03, 1.8498909e+03,
                                      1.8591404e+03, 1.8684361e+03, 1.8777783e+03, 1.8871672e+03,
                                      1.8966030e+03, 1.9060860e+03, 1.9156165e+03, 1.9251945e+03,
                                      1.9348205e+03, 1.9444946e+03, 1.9542171e+03, 1.9639882e+03,
                                      1.9738081e+03, 1.9836772e+03, 1.9935955e+03, 2.0035635e+03,
                                      2.0135813e+03, 2.0236492e+03, 2.0337675e+03, 2.0439363e+03,
                                      2.0541560e+03, 2.0644268e+03, 2.0747489e+03, 2.0851227e+03,
                                      2.0955483e+03, 2.1060260e+03, 2.1165562e+03, 2.1271389e+03,
                                      2.1377746e+03, 2.1484635e+03, 2.1592058e+03, 2.1700018e+03,
                                      2.1808519e+03, 2.1917561e+03, 2.2027149e+03, 2.2137285e+03,
                                      2.2247971e+03, 2.2359211e+03, 2.2471007e+03, 2.2583362e+03,
                                      2.2696279e+03, 2.2809760e+03, 2.2923809e+03, 2.3038428e+03,
                                      2.3153620e+03, 2.3269388e+03, 2.3385735e+03, 2.3502664e+03,
                                      2.3620177e+03, 2.3738278e+03, 2.3856970e+03, 2.3976254e+03,
                                      2.4096136e+03, 2.4216616e+03, 2.4337699e+03, 2.4459388e+03,
                                      2.4581685e+03, 2.4704593e+03, 2.4828116e+03, 2.4952257e+03,
                                      2.5077018e+03, 2.5202403e+03, 2.5328415e+03, 2.5455057e+03,
                                      2.5582333e+03, 2.5710244e+03, 2.5838796e+03, 2.5967990e+03,
                                      2.6097829e+03, 2.6228319e+03, 2.6359460e+03, 2.6491257e+03,
                                      2.6623714e+03, 2.6756832e+03, 2.6890617e+03, 2.7025070e+03,
                                      2.7160195e+03, 2.7295996e+03, 2.7432476e+03, 2.7569638e+03,
                                      2.7707486e+03, 2.7846024e+03, 2.7985254e+03, 2.8125180e+03,
                                      2.8265806e+03, 2.8407135e+03, 2.8549171e+03, 2.8691917e+03,
                                      2.8835376e+03, 2.8979553e+03, 2.9124451e+03, 2.9270073e+03,
                                      2.9416424e+03, 2.9563506e+03, 2.9711323e+03, 2.9859880e+03,
                                      3.0009179e+03, 3.0159225e+03, 3.0310021e+03, 3.0461571e+03,
                                      3.0613879e+03, 3.0766949e+03, 3.0920783e+03, 3.1075387e+03,
                                      3.1230764e+03, 3.1386918e+03, 3.1543853e+03, 3.1701572e+03,
                                      3.1860080e+03, 3.2019380e+03, 3.2179477e+03, 3.2340374e+03,
                                      3.2502076e+03, 3.2664587e+03, 3.2827910e+03, 3.2992049e+03,
                                      3.3157009e+03, 3.3322794e+03, 3.3489408e+03, 3.3656856e+03,
                                      3.3825140e+03, 3.3994265e+03, 3.4164237e+03, 3.4335058e+03,
                                      3.4506733e+03, 3.4679267e+03, 3.4852663e+03, 3.5026927e+03,
                                      3.5202061e+03, 3.5378072e+03, 3.5554962e+03, 3.5732737e+03,
                                      3.5911400e+03, 3.6090957e+03, 3.6271412e+03, 3.6452769e+03,
                                      3.6635033e+03, 3.6818208e+03, 3.7002299e+03, 3.7187311e+03,
                                      3.7373247e+03, 3.7560114e+03, 3.7747914e+03, 3.7936654e+03,
                                      3.8126337e+03, 3.8316969e+03, 3.8508554e+03, 3.8701096e+03,
                                      3.8894602e+03, 3.9089075e+03, 3.9284520e+03, 3.9480943e+03,
                                      3.9678347e+03, 3.9876739e+03, 4.0550240e+03, 4.3348210e+03,
                                      4.6339240e+03, 4.9536640e+03, 5.2954670e+03, 5.6608550e+03,
                                      6.0514530e+03, 6.0837420e+03, 6.1768610e+03, 6.2016920e+03,
                                      6.2389400e+03, 6.3320580e+03, 6.4690040e+03, 6.5870700e+03,
                                      6.6878920e+03, 6.7147780e+03, 6.7551070e+03, 6.8559300e+03,
                                      6.9153650e+03, 6.9834800e+03, 7.0903700e+03, 7.1188740e+03,
                                      7.1616300e+03, 7.2685200e+03, 7.3925250e+03, 7.9026090e+03,
                                      8.4478900e+03, 9.0307940e+03, 9.6539190e+03, 1.0320040e+04,
                                      1.1032120e+04, 1.1793340e+04, 1.2607080e+04, 1.3476970e+04,
                                      1.4406880e+04, 1.5400950e+04, 1.6463620e+04, 1.7599610e+04,
                                      1.8813980e+04, 2.0112150e+04, 2.1499880e+04, 2.2983380e+04,
                                      2.4569230e+04, 2.6264500e+04, 2.8076760e+04, 3.0014050e+04,
                                      3.2085020e+04, 3.4298890e+04, 3.6665510e+04, 3.9195430e+04,
                                      4.1899920e+04, 4.2697520e+04, 4.3351060e+04, 4.3525330e+04,
                                      4.3786750e+04, 4.4440280e+04, 4.4791010e+04, 4.7881590e+04,
                                      5.1185420e+04, 5.4717210e+04, 5.8492700e+04, 6.2528700e+04,
                                      6.6843180e+04, 7.1455360e+04, 7.6385780e+04, 8.1656400e+04,
                                      8.7290690e+04, 9.3313740e+04, 9.9752390e+04, 1.0663530e+05,
                                      1.1399310e+05, 1.2185870e+05, 1.3026690e+05, 1.3925530e+05,
                                      1.4886400e+05, 1.5913560e+05, 1.7011590e+05, 1.8185390e+05,
                                      1.9440180e+05, 2.0781560e+05, 2.2215480e+05, 2.3748350e+05,
                                      2.5386990e+05, 2.7138690e+05, 2.9011260e+05, 3.1013040e+05,
                                      3.3152940e+05, 3.5440490e+05, 3.7885880e+05, 4.0500010e+05,
                                      4.3294510e+05]), },
              '61': {'name': 'Pm',
                     'barns': 2407780000000.0,
                     'NumEdges': 18,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 21.1, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 21.1, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 37.5, 'factor': 1.0},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4.0, 'factor': 0.75},
                     'N5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 120.39999999999999,
                            'factor': 1.0, 'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 120.39999999999999,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 236.0, 'factor': 1.0,
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 254.4, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 330.40000000000003,
                            'factor': 1.0},
                     'M5': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1026.8999999999999,
                            'factor': 1.0, 'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1051.5,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1356.9, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1471.4, 'factor': 0.5},
                            'twin': 'N2'},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1646.5, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6459.3, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7012.8, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7427.900000000001,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 45184.0, 'factor': 1.0},
                     'dat': np.array([1.58451186e+16, 1.66572628e+16, 1.75226190e+16, 1.84474472e+16,
                                      1.94370448e+16, 2.04959865e+16, 2.16281246e+16, 2.28291253e+16,
                                      2.40922467e+16, 2.54117101e+16, 2.66300468e+16, 2.67841447e+16,
                                      2.69478738e+16, 2.70321461e+16, 5.17070755e+17, 4.91355665e+17,
                                      4.37252848e+17, 3.49224411e+17, 2.76798389e+17, 2.18782930e+17,
                                      1.73964513e+17, 1.40258001e+17, 1.15397672e+17, 9.73176520e+16,
                                      9.01833999e+16, 8.73470351e+16, 8.66343322e+16, 8.59938627e+16,
                                      8.47057004e+16, 8.35716360e+16, 7.54790874e+16, 6.89395570e+16,
                                      6.43093960e+16, 6.10203685e+16, 5.86655597e+16, 5.69391814e+16,
                                      5.56317569e+16, 5.45867804e+16, 5.36959018e+16, 5.28796644e+16,
                                      5.02961164e+16, 4.72117502e+16, 4.41514619e+16, 4.11200668e+16,
                                      3.95935343e+16, 3.93696108e+16, 3.91456872e+16, 3.89241715e+16,
                                      3.87026557e+16, 3.84811400e+16, 3.82596242e+16, 3.80381084e+16,
                                      3.78190005e+16, 3.75974847e+16, 3.73783767e+16, 3.71592687e+16,
                                      3.69401608e+16, 3.67210528e+16, 3.65019448e+16, 3.62852446e+16,
                                      3.60661366e+16, 3.58494364e+16, 3.56327362e+16, 3.54160360e+16,
                                      3.52017436e+16, 3.49850434e+16, 3.47707510e+16, 3.45564586e+16,
                                      3.43421661e+16, 3.41302815e+16, 3.39159891e+16, 3.37041044e+16,
                                      3.34922198e+16, 3.32803352e+16, 3.30708583e+16, 3.28589737e+16,
                                      3.26494968e+16, 3.24400199e+16, 3.22329509e+16, 3.20234740e+16,
                                      3.18164049e+16, 3.16093358e+16, 3.15684036e+16, 1.76699751e+17,
                                      1.68766116e+17, 1.58882179e+17, 1.49679644e+17, 1.41112762e+17,
                                      1.33135787e+17, 1.25707786e+17, 1.18787826e+17, 1.12342199e+17,
                                      1.06337196e+17, 1.00743923e+17, 9.55286715e+16, 9.06673637e+16,
                                      8.61359217e+16, 8.19102678e+16, 7.79687320e+16, 7.42920519e+16,
                                      7.08609654e+16, 6.76586180e+16, 6.46705630e+16, 6.18847616e+16,
                                      5.93301070e+16, 5.69897448e+16, 5.48371895e+16, 5.28579943e+16,
                                      5.10353049e+16, 4.93474511e+16, 4.77872097e+16, 4.63425417e+16,
                                      4.49990004e+16, 4.37469548e+16, 4.25815893e+16, 4.14908650e+16,
                                      4.04723740e+16, 3.95164854e+16, 3.86183834e+16, 3.77756604e+16,
                                      3.69786852e+16, 3.62298657e+16, 3.55195706e+16, 3.48477999e+16,
                                      3.42097382e+16, 3.36053855e+16, 3.30299260e+16, 3.24809522e+16,
                                      3.19584639e+16, 3.14600535e+16, 3.09809053e+16, 3.05234271e+16,
                                      3.00852111e+16, 2.96638496e+16, 2.92569348e+16, 2.88668744e+16,
                                      2.84912607e+16, 2.81300937e+16, 2.77785579e+16, 2.74414687e+16,
                                      2.71140106e+16, 2.67961836e+16, 2.64879878e+16, 2.61918308e+16,
                                      2.59004895e+16, 2.56211870e+16, 2.53467001e+16, 2.50794365e+16,
                                      2.48218040e+16, 2.45689871e+16, 2.43209858e+16, 2.40826156e+16,
                                      2.38473755e+16, 2.36181548e+16, 2.33942313e+16, 2.31753641e+16,
                                      2.29613124e+16, 2.27515948e+16, 2.25464519e+16, 2.23456431e+16,
                                      2.21486867e+16, 2.19558235e+16, 2.17665720e+16, 2.15809321e+16,
                                      2.13991448e+16, 2.12204875e+16, 2.10452011e+16, 2.08730448e+16,
                                      2.07040187e+16, 2.05381226e+16, 2.03751159e+16, 2.02147578e+16,
                                      2.00572890e+16, 1.99027095e+16, 1.97505378e+16, 1.96010146e+16,
                                      1.94538993e+16, 1.93094325e+16, 1.91671327e+16, 1.90272407e+16,
                                      1.88897564e+16, 1.87544392e+16, 1.86215297e+16, 1.84905465e+16,
                                      1.83617303e+16, 1.82350811e+16, 1.81103580e+16, 1.79878020e+16,
                                      1.78671723e+16, 1.77484687e+16, 1.76316914e+16, 1.75168403e+16,
                                      1.74039154e+16, 1.72926760e+16, 1.71833627e+16, 1.70759758e+16,
                                      1.69700334e+16, 1.68660173e+16, 1.67636867e+16, 1.66630415e+16,
                                      1.65640817e+16, 1.64668074e+16, 1.63712186e+16, 1.62770744e+16,
                                      1.61846156e+16, 1.60938423e+16, 1.60045137e+16, 1.59166297e+16,
                                      1.58304312e+16, 1.57456773e+16, 1.56623681e+16, 1.55805036e+16,
                                      1.55003245e+16, 1.54213493e+16, 1.53438188e+16, 1.52677330e+16,
                                      1.51928510e+16, 1.51196545e+16, 1.50476619e+16, 1.50445318e+16,
                                      1.80749637e+16, 1.80219925e+16, 1.79492776e+16, 1.78780073e+16,
                                      1.78079409e+16, 1.77390784e+16, 1.76714198e+16, 1.76052058e+16,
                                      1.75399550e+16, 1.74761488e+16, 1.74133057e+16, 1.73519073e+16,
                                      1.72914721e+16, 1.72322407e+16, 1.71739724e+16, 1.71169080e+16,
                                      1.71123332e+16, 1.80036934e+16, 1.79670951e+16, 1.79117162e+16,
                                      1.78575411e+16, 1.78045700e+16, 1.77523212e+16, 1.77010354e+16,
                                      1.76507128e+16, 1.76013534e+16, 1.75527162e+16, 1.75048014e+16,
                                      1.74578497e+16, 1.74116203e+16, 1.73663540e+16, 1.73215693e+16,
                                      1.72777477e+16, 1.72344077e+16, 1.71920308e+16, 1.71501354e+16,
                                      1.71089623e+16, 1.70685116e+16, 1.70285425e+16, 1.69892957e+16,
                                      1.69505304e+16, 1.69122467e+16, 1.68744446e+16, 1.68373648e+16,
                                      1.68007665e+16, 1.67644090e+16, 1.67287739e+16, 1.66933795e+16,
                                      1.66584667e+16, 1.66240355e+16, 1.65898450e+16, 1.65558953e+16,
                                      1.65224271e+16, 1.64891998e+16, 1.64564540e+16, 1.64237082e+16,
                                      1.63914439e+16, 1.63591797e+16, 1.63273970e+16, 1.62956143e+16,
                                      1.62640723e+16, 1.62325304e+16, 1.62012293e+16, 1.61701689e+16,
                                      1.61391086e+16, 1.61080482e+16, 1.60772286e+16, 1.60461683e+16,
                                      1.60153487e+16, 1.59845291e+16, 1.59715271e+16, 1.70624922e+16,
                                      1.70567135e+16, 1.70227638e+16, 1.69885733e+16, 1.69543829e+16,
                                      1.69201924e+16, 1.68857611e+16, 1.68513299e+16, 1.68168986e+16,
                                      1.67822266e+16, 1.67473138e+16, 1.67121602e+16, 1.66770066e+16,
                                      1.66416122e+16, 1.66059771e+16, 1.65701012e+16, 1.65342253e+16,
                                      1.64978678e+16, 1.64612695e+16, 1.64244305e+16, 1.63873507e+16,
                                      1.63497893e+16, 1.63119872e+16, 1.62737035e+16, 1.62351790e+16,
                                      1.61964137e+16, 1.61569261e+16, 1.61171978e+16, 1.60772286e+16,
                                      1.60367779e+16, 1.59958457e+16, 1.59544318e+16, 1.59125365e+16,
                                      1.58704003e+16, 1.58275418e+16, 1.57844426e+16, 1.57408618e+16,
                                      1.56967994e+16, 1.56522554e+16, 1.56072300e+16, 1.55614821e+16,
                                      1.55154935e+16, 1.54690234e+16, 1.54218309e+16, 1.53743976e+16,
                                      1.53264828e+16, 1.52780864e+16, 1.52289677e+16, 1.51796082e+16,
                                      1.51297672e+16, 1.50794446e+16, 1.50286404e+16, 1.49773547e+16,
                                      1.49253467e+16, 1.48730978e+16, 1.48203675e+16, 1.47671555e+16,
                                      1.47137028e+16, 1.46595278e+16, 1.46048711e+16, 1.45499738e+16,
                                      1.44943540e+16, 1.44384935e+16, 1.43821515e+16, 1.43253279e+16,
                                      1.42680227e+16, 1.42102360e+16, 1.41522085e+16, 1.40936995e+16,
                                      1.40349496e+16, 1.39754775e+16, 1.39157645e+16, 1.38558108e+16,
                                      1.37951347e+16, 1.37344587e+16, 1.36730603e+16, 1.36114211e+16,
                                      1.35495412e+16, 1.34871797e+16, 1.34240958e+16, 1.33607712e+16,
                                      1.32969650e+16, 1.32326773e+16, 1.31681488e+16, 1.31028980e+16,
                                      1.30376471e+16, 1.29716740e+16, 1.29057008e+16, 1.28390053e+16,
                                      1.27723098e+16, 1.27051327e+16, 1.26377149e+16, 1.25698155e+16,
                                      1.25019161e+16, 1.24335351e+16, 1.23651542e+16, 1.22962917e+16,
                                      1.22274292e+16, 1.21580851e+16, 1.20887410e+16, 1.20191562e+16,
                                      1.19493306e+16, 1.18795050e+16, 1.18094386e+16, 1.17393722e+16,
                                      1.16690650e+16, 1.15987578e+16, 1.15282099e+16, 1.14576619e+16,
                                      1.13871140e+16, 1.13163252e+16, 1.12455365e+16, 1.11747478e+16,
                                      1.11041998e+16, 1.10334111e+16, 1.09626223e+16, 1.08918336e+16,
                                      1.08210449e+16, 1.07502561e+16, 1.06797082e+16, 1.06089195e+16,
                                      1.05383715e+16, 1.04680643e+16, 1.03975164e+16, 1.03274500e+16,
                                      1.02571428e+16, 1.01870764e+16, 1.01172508e+16, 1.00474252e+16,
                                      9.97759954e+15, 9.90825548e+15, 9.83867064e+15, 9.76956735e+15,
                                      9.70046406e+15, 9.63160156e+15, 9.56297983e+15, 9.49459887e+15,
                                      9.42621792e+15, 9.35831853e+15, 9.29041913e+15, 9.22276051e+15,
                                      9.15534267e+15, 9.08816561e+15, 9.02147010e+15, 8.95477460e+15,
                                      8.88831987e+15, 8.82210592e+15, 8.75637353e+15, 8.69064113e+15,
                                      8.62539029e+15, 8.56013946e+15, 8.49537017e+15, 8.43108245e+15,
                                      8.36679472e+15, 8.30274777e+15, 8.23918238e+15, 8.17585777e+15,
                                      8.11277393e+15, 8.04993087e+15, 7.98756937e+15, 7.92544865e+15,
                                      7.86380948e+15, 7.80217031e+15, 7.74101270e+15, 7.68033664e+15,
                                      7.61990137e+15, 7.55970687e+15, 7.49999392e+15, 7.44052176e+15,
                                      7.38129037e+15, 7.32254054e+15, 7.26403148e+15, 7.20600398e+15,
                                      7.14821726e+15, 7.09091210e+15, 7.03384771e+15, 6.97702411e+15,
                                      6.92068205e+15, 6.86482156e+15, 6.80896106e+15, 6.75382290e+15,
                                      6.69892552e+15, 6.64426891e+15, 6.59009386e+15, 6.53615959e+15,
                                      6.48270687e+15, 6.42949493e+15, 6.37652377e+15, 6.32427495e+15,
                                      6.27202612e+15, 6.22025885e+15, 6.16897314e+15, 6.11792820e+15,
                                      6.06712404e+15, 6.01680144e+15, 5.96696040e+15, 5.91736013e+15,
                                      5.86800064e+15, 5.81912270e+15, 5.77048555e+15, 5.72232995e+15,
                                      5.67441513e+15, 5.62698186e+15, 5.57978937e+15, 5.53307844e+15,
                                      5.48660829e+15, 5.44037891e+15, 5.39463109e+15, 5.34912405e+15,
                                      5.30409856e+15, 5.25931385e+15, 5.21476992e+15, 5.17070755e+15,
                                      5.12712673e+15, 5.08354591e+15, 5.04044665e+15, 4.99782895e+15,
                                      4.95545202e+15, 4.91331587e+15, 4.87142050e+15, 4.83000668e+15,
                                      4.78907442e+15, 4.74814216e+15, 4.70480212e+15, 4.65568341e+15,
                                      4.60704625e+15, 4.55889065e+15, 4.51097583e+15, 4.46474645e+15,
                                      1.80518490e+16, 1.80494412e+16, 1.78235914e+16, 1.75984640e+16,
                                      1.73762259e+16, 1.71566364e+16, 1.70035016e+16, 2.57078671e+16,
                                      2.56308181e+16, 2.53033600e+16, 2.49807175e+16, 2.46604828e+16,
                                      2.43450636e+16, 2.40351823e+16, 2.37284311e+16, 2.34255324e+16,
                                      2.31264861e+16, 2.28312923e+16, 2.25399509e+16, 2.22524620e+16,
                                      2.19685847e+16, 2.16883191e+16, 2.14119060e+16, 2.11388637e+16,
                                      2.08691924e+16, 2.06031327e+16, 2.03406847e+16, 2.00813668e+16,
                                      1.98256605e+16, 1.95728436e+16, 1.93236384e+16, 1.90775633e+16,
                                      1.88346183e+16, 1.85948034e+16, 1.83581186e+16, 1.81243232e+16,
                                      1.78936578e+16, 1.76658819e+16, 1.74412360e+16, 1.72192387e+16,
                                      1.70001307e+16, 1.67839120e+16, 1.65705827e+16, 1.63599020e+16,
                                      1.61518698e+16, 1.59467269e+16, 1.57439919e+16, 1.55439053e+16,
                                      1.53464674e+16, 1.51514372e+16, 1.49590556e+16, 1.47690817e+16,
                                      1.45815157e+16, 1.43965982e+16, 1.42136069e+16, 1.40330234e+16,
                                      1.38553292e+16, 1.36807652e+16, 1.35083681e+16, 1.33860529e+16,
                                      1.56154164e+16, 1.56146941e+16, 1.54107551e+16, 1.52089831e+16,
                                      1.50103413e+16, 1.48141072e+16, 1.46207625e+16, 1.44298255e+16,
                                      1.42415371e+16, 1.40558973e+16, 1.38724245e+16, 1.36966565e+16,
                                      1.35283527e+16, 1.33626974e+16, 1.31999315e+16, 1.30395734e+16,
                                      1.28816230e+16, 1.27328222e+16, 1.27263212e+16, 1.35683219e+16,
                                      1.34423950e+16, 1.32774620e+16, 1.31149369e+16, 1.29550603e+16,
                                      1.27973507e+16, 1.26422897e+16, 1.24891549e+16, 1.23384278e+16,
                                      1.21901086e+16, 1.20446787e+16, 1.19050274e+16, 1.17673024e+16,
                                      1.16319852e+16, 1.14985942e+16, 1.13673702e+16, 1.12378316e+16,
                                      1.11104600e+16, 1.09850147e+16, 1.08612548e+16, 1.07394211e+16,
                                      1.06192729e+16, 1.05008101e+16, 1.04567478e+16, 1.08915928e+16,
                                      1.08817209e+16, 1.07622950e+16, 1.06443138e+16, 1.05280180e+16,
                                      1.04134077e+16, 1.03002421e+16, 1.01882803e+16, 1.00780040e+16,
                                      9.96917231e+15, 9.86154455e+15, 9.75560223e+15, 9.65110457e+15,
                                      9.54805159e+15, 9.44620250e+15, 9.34387185e+15, 9.24130042e+15,
                                      9.13993288e+15, 9.03976923e+15, 8.94080947e+15, 8.84305361e+15,
                                      8.74650163e+15, 8.65067198e+15, 8.55628701e+15, 8.46286514e+15,
                                      8.37040639e+15, 8.27891075e+15, 8.18861900e+15, 8.09929036e+15,
                                      8.01092484e+15, 7.92352242e+15, 7.83660157e+15, 7.74968071e+15,
                                      7.66372296e+15, 7.57848755e+15, 7.49445603e+15, 7.41114684e+15,
                                      7.32880076e+15, 7.24717702e+15, 7.16675717e+15, 7.08705965e+15,
                                      7.00808447e+15, 6.93007240e+15, 6.85302344e+15, 6.77669681e+15,
                                      6.70109252e+15, 6.62428434e+15, 6.54819849e+15, 6.47283497e+15,
                                      6.39867535e+15, 6.32475650e+15, 6.25059688e+15, 6.17740037e+15,
                                      6.10516697e+15, 6.03341512e+15, 5.96238561e+15, 5.89207844e+15,
                                      5.82273437e+15, 5.75435342e+15, 5.68645403e+15, 5.61951774e+15,
                                      5.55354457e+15, 5.48805295e+15, 5.42352445e+15, 5.35947750e+15,
                                      5.29567133e+15, 5.23258750e+15, 5.17022599e+15, 5.10834605e+15,
                                      5.04742921e+15, 4.98723471e+15, 4.92776255e+15, 4.86901272e+15,
                                      4.81098522e+15, 4.75368005e+15, 4.69709722e+15, 4.64099595e+15,
                                      4.58585779e+15, 4.53120118e+15, 4.47726691e+15, 4.42405497e+15,
                                      4.37156537e+15, 4.31955732e+15, 4.26827161e+15, 4.21770823e+15,
                                      4.16762640e+15, 4.11826691e+15, 4.06938898e+15, 4.02123338e+15,
                                      3.97355933e+15, 3.92660762e+15, 3.88013747e+15, 3.83438965e+15,
                                      3.78912339e+15, 3.74457946e+15, 3.70027630e+15, 3.65669549e+15,
                                      3.61383700e+15, 3.57121930e+15, 3.52932392e+15, 3.48791011e+15,
                                      3.44697785e+15, 3.40604559e+15, 3.36559488e+15, 3.32562574e+15,
                                      3.28637892e+15, 3.24737289e+15, 3.20884841e+15, 3.17104626e+15,
                                      3.13348489e+15, 3.09664586e+15, 3.06004760e+15, 3.02393090e+15,
                                      2.98829576e+15, 2.95314217e+15, 2.91847014e+15, 2.88403888e+15,
                                      2.85032996e+15, 2.81662104e+15, 2.78339368e+15, 2.75040709e+15,
                                      2.71790206e+15, 2.68250770e+15, 2.64783567e+15, 2.61340441e+15,
                                      2.57969549e+15, 2.54622735e+15, 2.51324076e+15, 2.48073573e+15,
                                      2.44871226e+15, 2.41717034e+15, 2.38594144e+15, 2.35517001e+15,
                                      2.32483198e+15, 2.29490327e+15, 2.26538389e+15, 2.23624975e+15,
                                      2.20750086e+15, 2.17916129e+15, 2.15118289e+15, 2.12354157e+15,
                                      2.09618919e+15, 2.06919798e+15, 2.04256793e+15, 2.01629905e+15,
                                      1.99039134e+15, 1.96484479e+15, 1.93961126e+15, 1.91473889e+15,
                                      1.89017953e+15, 1.86595727e+15, 1.84207209e+15, 1.81849992e+15,
                                      1.79524077e+15, 1.77229462e+15, 1.74966149e+15, 1.72731729e+15,
                                      1.70528611e+15, 1.68354385e+15, 1.66209053e+15, 1.64092615e+15,
                                      1.62005070e+15, 1.59944010e+15, 1.57911844e+15, 1.55906163e+15,
                                      1.53926968e+15, 1.51974258e+15, 1.50048034e+15, 1.48145888e+15,
                                      1.46270227e+15, 1.44418644e+15, 1.42591139e+15, 1.40790120e+15,
                                      1.39010771e+15, 1.37255499e+15, 1.35524305e+15, 1.33817189e+15,
                                      1.32129335e+15, 1.30465559e+15, 1.25038423e+15, 1.05655794e+15,
                                      8.90758211e+14, 7.49301136e+14, 6.31392149e+14, 5.33058414e+14,
                                      4.49821460e+14, 4.00630514e+14, 3.85196644e+14, 3.81175652e+14,
                                      1.13784459e+15, 1.12578162e+15, 1.07598873e+15, 9.49050565e+14,
                                      9.32701739e+14, 9.09731517e+14, 8.99691075e+14, 1.23285559e+15,
                                      1.18091978e+15, 1.12269966e+15, 1.07466445e+15, 1.06366089e+15,
                                      1.21145043e+15, 1.16671388e+15, 1.04964761e+15, 8.88037420e+14,
                                      7.48025013e+14, 6.25444933e+14, 5.22680882e+14, 4.37156537e+14,
                                      3.65982560e+14, 3.06654861e+14, 2.56428570e+14, 2.14058865e+14,
                                      1.78264808e+14, 1.48352957e+14, 1.23567270e+14, 1.03014460e+14,
                                      8.59553382e+13, 7.17855529e+13, 5.99994698e+13, 5.01901741e+13,
                                      4.20253921e+13, 3.49513345e+13, 2.89391078e+13, 2.39552440e+13,
                                      1.97577611e+13, 1.62968182e+13, 1.34491367e+13, 1.11078115e+13,
                                      9.48641242e+12, 9.18134670e+12, 9.08455394e+12, 8.98126018e+12,
                                      5.18563579e+13, 4.99229105e+13, 4.52494095e+13, 3.79779139e+13,
                                      3.18332594e+13, 2.66685713e+13, 2.22945981e+13, 1.86333279e+13,
                                      1.55723172e+13, 1.30130878e+13, 1.08595694e+13, 9.03615756e+12,
                                      7.50601337e+12, 6.22290741e+12, 5.15963176e+12, 4.27838428e+12,
                                      3.54810461e+12, 2.94254794e+12, 2.44052581e+12, 2.02446142e+12,
                                      1.67940247e+12, 1.39326190e+12, 1.15595110e+12, 9.59139163e+11,
                                      7.98010525e+11, 6.64210191e+11, 5.52874444e+11, 4.60223069e+11,
                                      3.83125954e+11, 3.18958617e+11, 2.65554056e+11, 2.21111253e+11,
                                      1.84113305e+11, 1.53312984e+11, 1.27670127e+11, 1.06322749e+11]),
                     'ene': np.array([1.0690000e+01, 1.1427610e+01, 1.2216120e+01, 1.3059030e+01,
                                      1.3960100e+01, 1.4923350e+01, 1.5953060e+01, 1.7053820e+01,
                                      1.8230530e+01, 1.9488440e+01, 2.0678000e+01, 2.0833140e+01,
                                      2.0994500e+01, 2.1078900e+01, 2.1205500e+01, 2.1522000e+01,
                                      2.2270630e+01, 2.3807300e+01, 2.5450010e+01, 2.7206060e+01,
                                      2.9083270e+01, 3.1090020e+01, 3.3235230e+01, 3.5528460e+01,
                                      3.6750000e+01, 3.7312500e+01, 3.7462500e+01, 3.7687500e+01,
                                      3.7979930e+01, 3.8250000e+01, 4.0600540e+01, 4.3401980e+01,
                                      4.6396710e+01, 4.9598090e+01, 5.3020350e+01, 5.6678760e+01,
                                      6.0589590e+01, 6.4770280e+01, 6.9239420e+01, 7.4016950e+01,
                                      7.9124110e+01, 8.4583680e+01, 9.0419950e+01, 9.6658930e+01,
                                      1.0000000e+02, 1.0050000e+02, 1.0100250e+02, 1.0150751e+02,
                                      1.0201505e+02, 1.0252513e+02, 1.0303775e+02, 1.0355294e+02,
                                      1.0407070e+02, 1.0459106e+02, 1.0511401e+02, 1.0563958e+02,
                                      1.0616778e+02, 1.0669862e+02, 1.0723211e+02, 1.0776827e+02,
                                      1.0830712e+02, 1.0884865e+02, 1.0939289e+02, 1.0993986e+02,
                                      1.1048956e+02, 1.1104201e+02, 1.1159722e+02, 1.1215520e+02,
                                      1.1271598e+02, 1.1327956e+02, 1.1384596e+02, 1.1441519e+02,
                                      1.1498726e+02, 1.1556220e+02, 1.1614001e+02, 1.1672071e+02,
                                      1.1730431e+02, 1.1789083e+02, 1.1848029e+02, 1.1907269e+02,
                                      1.1966805e+02, 1.2026639e+02, 1.2038579e+02, 1.2041420e+02,
                                      1.2086772e+02, 1.2147206e+02, 1.2207942e+02, 1.2268982e+02,
                                      1.2330327e+02, 1.2391979e+02, 1.2453939e+02, 1.2516208e+02,
                                      1.2578789e+02, 1.2641683e+02, 1.2704892e+02, 1.2768416e+02,
                                      1.2832258e+02, 1.2896419e+02, 1.2960902e+02, 1.3025706e+02,
                                      1.3090835e+02, 1.3156289e+02, 1.3222070e+02, 1.3288181e+02,
                                      1.3354621e+02, 1.3421395e+02, 1.3488502e+02, 1.3555944e+02,
                                      1.3623724e+02, 1.3691842e+02, 1.3760302e+02, 1.3829103e+02,
                                      1.3898249e+02, 1.3967740e+02, 1.4037579e+02, 1.4107766e+02,
                                      1.4178305e+02, 1.4249197e+02, 1.4320443e+02, 1.4392045e+02,
                                      1.4464005e+02, 1.4536325e+02, 1.4609007e+02, 1.4682052e+02,
                                      1.4755462e+02, 1.4829239e+02, 1.4903386e+02, 1.4977903e+02,
                                      1.5052792e+02, 1.5128056e+02, 1.5203696e+02, 1.5279715e+02,
                                      1.5356113e+02, 1.5432894e+02, 1.5510058e+02, 1.5587609e+02,
                                      1.5665547e+02, 1.5743875e+02, 1.5822594e+02, 1.5901707e+02,
                                      1.5981215e+02, 1.6061121e+02, 1.6141427e+02, 1.6222134e+02,
                                      1.6303245e+02, 1.6384761e+02, 1.6466685e+02, 1.6549018e+02,
                                      1.6631763e+02, 1.6714922e+02, 1.6798497e+02, 1.6882489e+02,
                                      1.6966902e+02, 1.7051736e+02, 1.7136995e+02, 1.7222680e+02,
                                      1.7308793e+02, 1.7395337e+02, 1.7482314e+02, 1.7569726e+02,
                                      1.7657574e+02, 1.7745862e+02, 1.7834591e+02, 1.7923764e+02,
                                      1.8013383e+02, 1.8103450e+02, 1.8193967e+02, 1.8284937e+02,
                                      1.8376362e+02, 1.8468244e+02, 1.8560585e+02, 1.8653388e+02,
                                      1.8746655e+02, 1.8840388e+02, 1.8934590e+02, 1.9029263e+02,
                                      1.9124409e+02, 1.9220031e+02, 1.9316131e+02, 1.9412712e+02,
                                      1.9509776e+02, 1.9607325e+02, 1.9705361e+02, 1.9803888e+02,
                                      1.9902907e+02, 2.0002422e+02, 2.0102434e+02, 2.0202946e+02,
                                      2.0303961e+02, 2.0405481e+02, 2.0507508e+02, 2.0610046e+02,
                                      2.0713096e+02, 2.0816661e+02, 2.0920745e+02, 2.1025348e+02,
                                      2.1130475e+02, 2.1236128e+02, 2.1342308e+02, 2.1449020e+02,
                                      2.1556265e+02, 2.1664046e+02, 2.1772366e+02, 2.1881228e+02,
                                      2.1990634e+02, 2.2100588e+02, 2.2211090e+02, 2.2322146e+02,
                                      2.2433757e+02, 2.2545925e+02, 2.2658655e+02, 2.2771948e+02,
                                      2.2885808e+02, 2.3000237e+02, 2.3115238e+02, 2.3230814e+02,
                                      2.3346969e+02, 2.3463703e+02, 2.3581022e+02, 2.3585864e+02,
                                      2.3614137e+02, 2.3698927e+02, 2.3817422e+02, 2.3936509e+02,
                                      2.4056191e+02, 2.4176472e+02, 2.4297355e+02, 2.4418841e+02,
                                      2.4540936e+02, 2.4663640e+02, 2.4786959e+02, 2.4910893e+02,
                                      2.5035448e+02, 2.5160625e+02, 2.5286428e+02, 2.5412860e+02,
                                      2.5423287e+02, 2.5456716e+02, 2.5539925e+02, 2.5667624e+02,
                                      2.5795962e+02, 2.5924942e+02, 2.6054567e+02, 2.6184840e+02,
                                      2.6315764e+02, 2.6447343e+02, 2.6579579e+02, 2.6712477e+02,
                                      2.6846040e+02, 2.6980270e+02, 2.7115171e+02, 2.7250747e+02,
                                      2.7387001e+02, 2.7523936e+02, 2.7661556e+02, 2.7799863e+02,
                                      2.7938863e+02, 2.8078557e+02, 2.8218950e+02, 2.8360044e+02,
                                      2.8501845e+02, 2.8644354e+02, 2.8787576e+02, 2.8931514e+02,
                                      2.9076171e+02, 2.9221552e+02, 2.9367660e+02, 2.9514498e+02,
                                      2.9662071e+02, 2.9810381e+02, 2.9959433e+02, 3.0109230e+02,
                                      3.0259776e+02, 3.0411075e+02, 3.0563130e+02, 3.0715946e+02,
                                      3.0869526e+02, 3.1023873e+02, 3.1178993e+02, 3.1334888e+02,
                                      3.1491562e+02, 3.1649020e+02, 3.1807265e+02, 3.1966301e+02,
                                      3.2126133e+02, 3.2286764e+02, 3.2448197e+02, 3.2610438e+02,
                                      3.2773491e+02, 3.2937358e+02, 3.3005637e+02, 3.3074361e+02,
                                      3.3102045e+02, 3.3267555e+02, 3.3433893e+02, 3.3601062e+02,
                                      3.3769068e+02, 3.3937913e+02, 3.4107602e+02, 3.4278140e+02,
                                      3.4449531e+02, 3.4621779e+02, 3.4794888e+02, 3.4968862e+02,
                                      3.5143706e+02, 3.5319425e+02, 3.5496022e+02, 3.5673502e+02,
                                      3.5851870e+02, 3.6031129e+02, 3.6211285e+02, 3.6392341e+02,
                                      3.6574303e+02, 3.6757174e+02, 3.6940960e+02, 3.7125665e+02,
                                      3.7311293e+02, 3.7497850e+02, 3.7685339e+02, 3.7873766e+02,
                                      3.8063135e+02, 3.8253450e+02, 3.8444718e+02, 3.8636941e+02,
                                      3.8830126e+02, 3.9024276e+02, 3.9219398e+02, 3.9415495e+02,
                                      3.9612572e+02, 3.9810635e+02, 4.0009688e+02, 4.0209737e+02,
                                      4.0410785e+02, 4.0612839e+02, 4.0815904e+02, 4.1019983e+02,
                                      4.1225083e+02, 4.1431208e+02, 4.1638364e+02, 4.1846556e+02,
                                      4.2055789e+02, 4.2266068e+02, 4.2477398e+02, 4.2689785e+02,
                                      4.2903234e+02, 4.3117750e+02, 4.3333339e+02, 4.3550006e+02,
                                      4.3767756e+02, 4.3986595e+02, 4.4206528e+02, 4.4427560e+02,
                                      4.4649698e+02, 4.4872947e+02, 4.5097311e+02, 4.5322798e+02,
                                      4.5549412e+02, 4.5777159e+02, 4.6006045e+02, 4.6236075e+02,
                                      4.6467255e+02, 4.6699592e+02, 4.6933090e+02, 4.7167755e+02,
                                      4.7403594e+02, 4.7640612e+02, 4.7878815e+02, 4.8118209e+02,
                                      4.8358800e+02, 4.8600594e+02, 4.8843597e+02, 4.9087815e+02,
                                      4.9333254e+02, 4.9579920e+02, 4.9827820e+02, 5.0076959e+02,
                                      5.0327344e+02, 5.0578980e+02, 5.0831875e+02, 5.1086035e+02,
                                      5.1341465e+02, 5.1598172e+02, 5.1856163e+02, 5.2115444e+02,
                                      5.2376021e+02, 5.2637901e+02, 5.2901091e+02, 5.3165596e+02,
                                      5.3431424e+02, 5.3698581e+02, 5.3967074e+02, 5.4236910e+02,
                                      5.4508094e+02, 5.4780635e+02, 5.5054538e+02, 5.5329810e+02,
                                      5.5606460e+02, 5.5884492e+02, 5.6163914e+02, 5.6444734e+02,
                                      5.6726958e+02, 5.7010592e+02, 5.7295645e+02, 5.7582123e+02,
                                      5.7870034e+02, 5.8159384e+02, 5.8450181e+02, 5.8742432e+02,
                                      5.9036144e+02, 5.9331325e+02, 5.9627982e+02, 5.9926122e+02,
                                      6.0225752e+02, 6.0526881e+02, 6.0829515e+02, 6.1133663e+02,
                                      6.1439331e+02, 6.1746528e+02, 6.2055260e+02, 6.2365537e+02,
                                      6.2677364e+02, 6.2990751e+02, 6.3305705e+02, 6.3622234e+02,
                                      6.3940345e+02, 6.4260046e+02, 6.4581347e+02, 6.4904253e+02,
                                      6.5228775e+02, 6.5554919e+02, 6.5882693e+02, 6.6212107e+02,
                                      6.6543167e+02, 6.6875883e+02, 6.7210262e+02, 6.7546314e+02,
                                      6.7884045e+02, 6.8223466e+02, 6.8564583e+02, 6.8907406e+02,
                                      6.9251943e+02, 6.9598202e+02, 6.9946194e+02, 7.0295924e+02,
                                      7.0647404e+02, 7.1000641e+02, 7.1355644e+02, 7.1712423e+02,
                                      7.2070985e+02, 7.2431340e+02, 7.2793496e+02, 7.3157464e+02,
                                      7.3523251e+02, 7.3890867e+02, 7.4260322e+02, 7.4631623e+02,
                                      7.5004781e+02, 7.5379805e+02, 7.5756704e+02, 7.6135488e+02,
                                      7.6516165e+02, 7.6898746e+02, 7.7283240e+02, 7.7669656e+02,
                                      7.8058004e+02, 7.8448294e+02, 7.8840536e+02, 7.9234738e+02,
                                      7.9630912e+02, 8.0029067e+02, 8.0429212e+02, 8.0831358e+02,
                                      8.1235515e+02, 8.1641693e+02, 8.2049901e+02, 8.2460150e+02,
                                      8.2872451e+02, 8.3286813e+02, 8.3703248e+02, 8.4121764e+02,
                                      8.4542373e+02, 8.4965084e+02, 8.5389910e+02, 8.5816859e+02,
                                      8.6245944e+02, 8.6677173e+02, 8.7110559e+02, 8.7546112e+02,
                                      8.7983843e+02, 8.8423762e+02, 8.8865881e+02, 8.9310210e+02,
                                      8.9756761e+02, 9.0205545e+02, 9.0656573e+02, 9.1109856e+02,
                                      9.1565405e+02, 9.2023232e+02, 9.2483348e+02, 9.2945765e+02,
                                      9.3410494e+02, 9.3877546e+02, 9.4346934e+02, 9.4818668e+02,
                                      9.5292762e+02, 9.5769226e+02, 9.6248072e+02, 9.6729312e+02,
                                      9.7212959e+02, 9.7699023e+02, 9.8187519e+02, 9.8678456e+02,
                                      9.9171848e+02, 9.9667708e+02, 1.0016605e+03, 1.0066688e+03,
                                      1.0117021e+03, 1.0167606e+03, 1.0218444e+03, 1.0267933e+03,
                                      1.0269536e+03, 1.0270069e+03, 1.0320884e+03, 1.0372489e+03,
                                      1.0424351e+03, 1.0476473e+03, 1.0513391e+03, 1.0516608e+03,
                                      1.0528855e+03, 1.0581499e+03, 1.0634407e+03, 1.0687579e+03,
                                      1.0741017e+03, 1.0794722e+03, 1.0848695e+03, 1.0902939e+03,
                                      1.0957454e+03, 1.1012241e+03, 1.1067302e+03, 1.1122639e+03,
                                      1.1178252e+03, 1.1234143e+03, 1.1290314e+03, 1.1346765e+03,
                                      1.1403499e+03, 1.1460517e+03, 1.1517819e+03, 1.1575408e+03,
                                      1.1633285e+03, 1.1691452e+03, 1.1749909e+03, 1.1808659e+03,
                                      1.1867702e+03, 1.1927040e+03, 1.1986676e+03, 1.2046609e+03,
                                      1.2106842e+03, 1.2167376e+03, 1.2228213e+03, 1.2289354e+03,
                                      1.2350801e+03, 1.2412555e+03, 1.2474618e+03, 1.2536991e+03,
                                      1.2599676e+03, 1.2662674e+03, 1.2725988e+03, 1.2789618e+03,
                                      1.2853566e+03, 1.2917833e+03, 1.2982423e+03, 1.3047335e+03,
                                      1.3112571e+03, 1.3178134e+03, 1.3244025e+03, 1.3310245e+03,
                                      1.3376796e+03, 1.3443680e+03, 1.3510899e+03, 1.3559325e+03,
                                      1.3578453e+03, 1.3578674e+03, 1.3646345e+03, 1.3714577e+03,
                                      1.3783150e+03, 1.3852066e+03, 1.3921326e+03, 1.3990933e+03,
                                      1.4060887e+03, 1.4131192e+03, 1.4201848e+03, 1.4272857e+03,
                                      1.4344221e+03, 1.4415942e+03, 1.4488022e+03, 1.4560462e+03,
                                      1.4633265e+03, 1.4703391e+03, 1.4706431e+03, 1.4724609e+03,
                                      1.4779963e+03, 1.4853863e+03, 1.4928132e+03, 1.5002773e+03,
                                      1.5077787e+03, 1.5153176e+03, 1.5228942e+03, 1.5305086e+03,
                                      1.5381612e+03, 1.5458520e+03, 1.5535812e+03, 1.5613491e+03,
                                      1.5691559e+03, 1.5770017e+03, 1.5848867e+03, 1.5928111e+03,
                                      1.6007752e+03, 1.6087790e+03, 1.6168229e+03, 1.6249070e+03,
                                      1.6330316e+03, 1.6411967e+03, 1.6442772e+03, 1.6487228e+03,
                                      1.6494027e+03, 1.6576497e+03, 1.6659380e+03, 1.6742677e+03,
                                      1.6826390e+03, 1.6910522e+03, 1.6995075e+03, 1.7080050e+03,
                                      1.7165450e+03, 1.7251278e+03, 1.7337534e+03, 1.7424222e+03,
                                      1.7511343e+03, 1.7598899e+03, 1.7686894e+03, 1.7775328e+03,
                                      1.7864205e+03, 1.7953526e+03, 1.8043294e+03, 1.8133510e+03,
                                      1.8224178e+03, 1.8315299e+03, 1.8406875e+03, 1.8498909e+03,
                                      1.8591404e+03, 1.8684361e+03, 1.8777783e+03, 1.8871672e+03,
                                      1.8966030e+03, 1.9060860e+03, 1.9156165e+03, 1.9251945e+03,
                                      1.9348205e+03, 1.9444946e+03, 1.9542171e+03, 1.9639882e+03,
                                      1.9738081e+03, 1.9836772e+03, 1.9935955e+03, 2.0035635e+03,
                                      2.0135813e+03, 2.0236492e+03, 2.0337675e+03, 2.0439363e+03,
                                      2.0541560e+03, 2.0644268e+03, 2.0747489e+03, 2.0851227e+03,
                                      2.0955483e+03, 2.1060260e+03, 2.1165562e+03, 2.1271389e+03,
                                      2.1377746e+03, 2.1484635e+03, 2.1592058e+03, 2.1700018e+03,
                                      2.1808519e+03, 2.1917561e+03, 2.2027149e+03, 2.2137285e+03,
                                      2.2247971e+03, 2.2359211e+03, 2.2471007e+03, 2.2583362e+03,
                                      2.2696279e+03, 2.2809760e+03, 2.2923809e+03, 2.3038428e+03,
                                      2.3153620e+03, 2.3269388e+03, 2.3385735e+03, 2.3502664e+03,
                                      2.3620177e+03, 2.3738278e+03, 2.3856970e+03, 2.3976254e+03,
                                      2.4096136e+03, 2.4216616e+03, 2.4337699e+03, 2.4459388e+03,
                                      2.4581685e+03, 2.4704593e+03, 2.4828116e+03, 2.4952257e+03,
                                      2.5077018e+03, 2.5202403e+03, 2.5328415e+03, 2.5455057e+03,
                                      2.5582333e+03, 2.5710244e+03, 2.5838796e+03, 2.5967990e+03,
                                      2.6097829e+03, 2.6228319e+03, 2.6359460e+03, 2.6491257e+03,
                                      2.6623714e+03, 2.6756832e+03, 2.6890617e+03, 2.7025070e+03,
                                      2.7160195e+03, 2.7295996e+03, 2.7432476e+03, 2.7569638e+03,
                                      2.7707486e+03, 2.7846024e+03, 2.7985254e+03, 2.8125180e+03,
                                      2.8265806e+03, 2.8407135e+03, 2.8549171e+03, 2.8691917e+03,
                                      2.8835376e+03, 2.8979553e+03, 2.9124451e+03, 2.9270073e+03,
                                      2.9416424e+03, 2.9563506e+03, 2.9711323e+03, 2.9859880e+03,
                                      3.0009179e+03, 3.0159225e+03, 3.0310021e+03, 3.0461571e+03,
                                      3.0613879e+03, 3.0766949e+03, 3.0920783e+03, 3.1075387e+03,
                                      3.1230764e+03, 3.1386918e+03, 3.1543853e+03, 3.1701572e+03,
                                      3.1860080e+03, 3.2019380e+03, 3.2179477e+03, 3.2340374e+03,
                                      3.2502076e+03, 3.2664587e+03, 3.2827910e+03, 3.2992049e+03,
                                      3.3157009e+03, 3.3322794e+03, 3.3489408e+03, 3.3656856e+03,
                                      3.3825140e+03, 3.3994265e+03, 3.4164237e+03, 3.4335058e+03,
                                      3.4506733e+03, 3.4679267e+03, 3.4852663e+03, 3.5026927e+03,
                                      3.5202061e+03, 3.5378072e+03, 3.5554962e+03, 3.5732737e+03,
                                      3.5911400e+03, 3.6090957e+03, 3.6271412e+03, 3.6452769e+03,
                                      3.6635033e+03, 3.6818208e+03, 3.7002299e+03, 3.7187311e+03,
                                      3.7373247e+03, 3.7560114e+03, 3.7747914e+03, 3.7936654e+03,
                                      3.8126337e+03, 3.8316969e+03, 3.8508554e+03, 3.8701096e+03,
                                      3.8894602e+03, 3.9089075e+03, 3.9284520e+03, 3.9480943e+03,
                                      3.9678347e+03, 3.9876739e+03, 4.0550240e+03, 4.3348210e+03,
                                      4.6339240e+03, 4.9536640e+03, 5.2954670e+03, 5.6608550e+03,
                                      6.0514530e+03, 6.3301140e+03, 6.4270040e+03, 6.4528410e+03,
                                      6.4690040e+03, 6.4915970e+03, 6.5884860e+03, 6.8725440e+03,
                                      6.9153650e+03, 6.9777360e+03, 7.0057870e+03, 7.0478640e+03,
                                      7.1530560e+03, 7.2793420e+03, 7.3925250e+03, 7.4204720e+03,
                                      7.4650390e+03, 7.5764580e+03, 7.9026090e+03, 8.4478900e+03,
                                      9.0307940e+03, 9.6539190e+03, 1.0320040e+04, 1.1032120e+04,
                                      1.1793340e+04, 1.2607080e+04, 1.3476970e+04, 1.4406880e+04,
                                      1.5400950e+04, 1.6463620e+04, 1.7599610e+04, 1.8813980e+04,
                                      2.0112150e+04, 2.1499880e+04, 2.2983380e+04, 2.4569230e+04,
                                      2.6264500e+04, 2.8076760e+04, 3.0014050e+04, 3.2085020e+04,
                                      3.4298890e+04, 3.6665510e+04, 3.9195430e+04, 4.1899920e+04,
                                      4.4280320e+04, 4.4791010e+04, 4.4958080e+04, 4.5138810e+04,
                                      4.5409920e+04, 4.6087680e+04, 4.7881590e+04, 5.1185420e+04,
                                      5.4717210e+04, 5.8492700e+04, 6.2528700e+04, 6.6843180e+04,
                                      7.1455360e+04, 7.6385780e+04, 8.1656400e+04, 8.7290690e+04,
                                      9.3313740e+04, 9.9752390e+04, 1.0663530e+05, 1.1399310e+05,
                                      1.2185870e+05, 1.3026690e+05, 1.3925530e+05, 1.4886400e+05,
                                      1.5913560e+05, 1.7011590e+05, 1.8185390e+05, 1.9440180e+05,
                                      2.0781560e+05, 2.2215480e+05, 2.3748350e+05, 2.5386990e+05,
                                      2.7138690e+05, 2.9011260e+05, 3.1013040e+05, 3.3152940e+05,
                                      3.5440490e+05, 3.7885880e+05, 4.0500010e+05, 4.3294510e+05]), },
              '62': {'name': 'Sm',
                     'barns': 2496790000000.0,
                     'NumEdges': 18,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 21.3, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 21.3, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 37.400000000000006,
                            'factor': 1.0},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5.5, 'factor': 0.75},

                     'N5': {'filename': 'Sm.N5', 'excl before': 5, 'excl after': 50, 'onset': 129.0, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 129.0,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 247.4, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 265.6, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 345.7, 'factor': 1.0},
                     'M5': {'filename': 'Sm.M5', 'excl before': 5, 'excl after': 50, 'onset': 1080.2, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1106.0,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Sm.M3', 'excl before': 5, 'excl after': 50, 'onset': 1419.8, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1540.7, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1722.8000000000002,
                            'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6716.2, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7311.8, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7736.799999999999,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 46834.200000000004,
                            'factor': 1.0},
                     'dat': np.array([4.22581708e+15, 4.36788443e+15, 1.24619782e+16, 1.34369747e+16,
                                      1.44546663e+16, 1.55220441e+16, 1.66451002e+16, 1.78303264e+16,
                                      1.90829660e+16, 2.04075131e+16, 2.18074632e+16, 2.32850635e+16,
                                      2.48403140e+16, 2.48872537e+16, 2.52525341e+16, 2.53499089e+16,
                                      5.49143993e+17, 5.21179945e+17, 4.77860638e+17, 3.79462144e+17,
                                      2.99464993e+17, 2.35459781e+17, 1.86123211e+17, 1.49125776e+17,
                                      1.21940727e+17, 1.02263525e+17, 9.50952407e+16, 9.19867372e+16,
                                      9.12052419e+16, 9.04786760e+16, 8.85960964e+16, 8.78270850e+16,
                                      7.86738529e+16, 7.16978216e+16, 6.68141004e+16, 6.33885045e+16,
                                      6.09466439e+16, 5.90465867e+16, 5.75959517e+16, 5.64299508e+16,
                                      5.54362284e+16, 5.45348872e+16, 5.36759914e+16, 5.28270828e+16,
                                      5.19656903e+16, 5.10893170e+16, 5.06324044e+16, 5.05649911e+16,
                                      5.04975778e+16, 5.04301644e+16, 5.03602543e+16, 5.02928410e+16,
                                      5.02254276e+16, 5.00556459e+16, 4.97984766e+16, 4.95388104e+16,
                                      4.92791442e+16, 4.90219749e+16, 4.87623087e+16, 4.85026425e+16,
                                      4.82454732e+16, 4.79858070e+16, 4.77261408e+16, 4.74689715e+16,
                                      4.72093053e+16, 4.69496392e+16, 4.66924698e+16, 4.64328036e+16,
                                      4.61756343e+16, 4.59159681e+16, 4.56587987e+16, 4.54016294e+16,
                                      4.51419632e+16, 4.48847938e+16, 4.46276245e+16, 4.43704551e+16,
                                      4.41132857e+16, 4.38586131e+16, 4.36014438e+16, 4.33442744e+16,
                                      4.30896018e+16, 4.28324324e+16, 4.25777599e+16, 4.23230873e+16,
                                      4.20684147e+16, 4.18137421e+16, 4.15590696e+16, 4.13068938e+16,
                                      4.10547180e+16, 4.08000454e+16, 4.05478696e+16, 4.02956938e+16,
                                      4.00460148e+16, 3.97938390e+16, 3.95441600e+16, 3.92944810e+16,
                                      3.90448020e+16, 3.87951230e+16, 3.87876326e+16, 1.57779650e+17,
                                      1.50149460e+17, 1.42317030e+17, 1.35003932e+17, 1.28167721e+17,
                                      1.21783429e+17, 1.15813604e+17, 1.10235775e+17, 1.05019981e+17,
                                      1.00141253e+17, 9.55796180e+16, 9.13101071e+16, 8.73177399e+16,
                                      8.35800452e+16, 8.00795457e+16, 7.68012604e+16, 7.37302087e+16,
                                      7.08514098e+16, 6.81548766e+16, 6.56231316e+16, 6.32611682e+16,
                                      6.10864641e+16, 5.90815418e+16, 5.72314204e+16, 5.55186224e+16,
                                      5.39306640e+16, 5.24550611e+16, 5.10818266e+16, 4.98009733e+16,
                                      4.86050109e+16, 4.74839522e+16, 4.64328036e+16, 4.54465716e+16,
                                      4.45152689e+16, 4.36388956e+16, 4.28099613e+16, 4.20259693e+16,
                                      4.12794291e+16, 4.05728375e+16, 3.99012010e+16, 3.92595260e+16,
                                      3.86478124e+16, 3.80635636e+16, 3.75042826e+16, 3.69674727e+16,
                                      3.64531340e+16, 3.59587696e+16, 3.54818827e+16, 3.50224733e+16,
                                      3.45805415e+16, 3.41535904e+16, 3.37391233e+16, 3.33396369e+16,
                                      3.29501376e+16, 3.25731223e+16, 3.22085910e+16, 3.18540468e+16,
                                      3.15094898e+16, 3.11724232e+16, 3.08453437e+16, 3.05257545e+16,
                                      3.02136558e+16, 2.99090474e+16, 2.96119294e+16, 2.93223018e+16,
                                      2.90376677e+16, 2.87580272e+16, 2.84858771e+16, 2.82187206e+16,
                                      2.79590544e+16, 2.77018850e+16, 2.74497093e+16, 2.72025270e+16,
                                      2.69603384e+16, 2.67231434e+16, 2.64884451e+16, 2.62587404e+16,
                                      2.60340293e+16, 2.58118150e+16, 2.55920975e+16, 2.53773736e+16,
                                      2.51651464e+16, 2.49574135e+16, 2.47521773e+16, 2.45504367e+16,
                                      2.43516922e+16, 2.41559439e+16, 2.39629420e+16, 2.37729363e+16,
                                      2.35856771e+16, 2.34011643e+16, 2.32193980e+16, 2.30401284e+16,
                                      2.28633557e+16, 2.26893294e+16, 2.25175503e+16, 2.23482679e+16,
                                      2.21814824e+16, 2.20169439e+16, 2.18546525e+16, 2.16946083e+16,
                                      2.15368112e+16, 2.13812612e+16, 2.12279583e+16, 2.10766528e+16,
                                      2.09275944e+16, 2.07802838e+16, 2.06354700e+16, 2.04924039e+16,
                                      2.03513353e+16, 2.02122641e+16, 2.00751903e+16, 1.99398643e+16,
                                      1.98067854e+16, 1.96752046e+16, 1.95458708e+16, 1.94180352e+16,
                                      1.92921970e+16, 1.91681065e+16, 1.90457638e+16, 1.89251688e+16,
                                      1.88063216e+16, 1.86892222e+16, 1.85738705e+16, 1.84602665e+16,
                                      1.83481607e+16, 1.82378026e+16, 1.81291922e+16, 1.80220799e+16,
                                      1.79164657e+16, 1.78123495e+16, 1.77621641e+16, 2.07121214e+16,
                                      2.06859052e+16, 2.05817890e+16, 2.04791709e+16, 2.03780509e+16,
                                      2.02786787e+16, 2.01805549e+16, 2.00839291e+16, 1.99885517e+16,
                                      1.98949221e+16, 1.98025408e+16, 1.97116577e+16, 1.96220229e+16,
                                      1.95336366e+16, 1.94467483e+16, 1.93863260e+16, 2.02337365e+16,
                                      2.01493450e+16, 2.00662019e+16, 1.99840575e+16, 1.99034112e+16,
                                      1.98240132e+16, 1.97456140e+16, 1.96684632e+16, 1.95923111e+16,
                                      1.95174074e+16, 1.94432528e+16, 1.93703465e+16, 1.92984389e+16,
                                      1.92275301e+16, 1.91573703e+16, 1.90884589e+16, 1.90202965e+16,
                                      1.89531329e+16, 1.88867183e+16, 1.88213024e+16, 1.87568852e+16,
                                      1.86929674e+16, 1.86300483e+16, 1.85678782e+16, 1.85064572e+16,
                                      1.84460348e+16, 1.83861119e+16, 1.83266883e+16, 1.82682634e+16,
                                      1.82103379e+16, 1.81531614e+16, 1.80964842e+16, 1.80405561e+16,
                                      1.79848777e+16, 1.79301980e+16, 1.78757680e+16, 1.78218373e+16,
                                      1.77686557e+16, 1.77157238e+16, 1.76632912e+16, 1.76111083e+16,
                                      1.75596744e+16, 1.75084902e+16, 1.74575557e+16, 1.74071205e+16,
                                      1.73569350e+16, 1.73069992e+16, 1.72575628e+16, 1.72083760e+16,
                                      1.71591893e+16, 1.71105019e+16, 1.70618145e+16, 1.70133767e+16,
                                      1.69901566e+16, 1.80265741e+16, 1.80223296e+16, 1.79713951e+16,
                                      1.79204605e+16, 1.78695260e+16, 1.78188412e+16, 1.77684060e+16,
                                      1.77179709e+16, 1.76675357e+16, 1.76171006e+16, 1.75666654e+16,
                                      1.75164799e+16, 1.74660448e+16, 1.74156096e+16, 1.73651744e+16,
                                      1.73147393e+16, 1.72643041e+16, 1.72138690e+16, 1.71631841e+16,
                                      1.71122496e+16, 1.70615648e+16, 1.70103806e+16, 1.69591964e+16,
                                      1.69077625e+16, 1.68563286e+16, 1.68043954e+16, 1.67524622e+16,
                                      1.67000296e+16, 1.66475970e+16, 1.65949147e+16, 1.65417331e+16,
                                      1.64883018e+16, 1.64346208e+16, 1.63806902e+16, 1.63265098e+16,
                                      1.62718301e+16, 1.62171504e+16, 1.61619713e+16, 1.61065426e+16,
                                      1.60506145e+16, 1.59944367e+16, 1.59380093e+16, 1.58813322e+16,
                                      1.58244053e+16, 1.57669792e+16, 1.57090536e+16, 1.56511281e+16,
                                      1.55927032e+16, 1.55340287e+16, 1.54748547e+16, 1.54154311e+16,
                                      1.53555082e+16, 1.52955852e+16, 1.52351629e+16, 1.51742412e+16,
                                      1.51130699e+16, 1.50516488e+16, 1.49897284e+16, 1.49275584e+16,
                                      1.48651386e+16, 1.48024692e+16, 1.47393004e+16, 1.46758819e+16,
                                      1.46119641e+16, 1.45477966e+16, 1.44833794e+16, 1.44187126e+16,
                                      1.43537960e+16, 1.42883801e+16, 1.42227146e+16, 1.41567993e+16,
                                      1.40906344e+16, 1.40242198e+16, 1.39575555e+16, 1.38903918e+16,
                                      1.38232282e+16, 1.37555651e+16, 1.36879021e+16, 1.36197398e+16,
                                      1.35515774e+16, 1.34831654e+16, 1.34142540e+16, 1.33453426e+16,
                                      1.32759318e+16, 1.32065210e+16, 1.31363612e+16, 1.30662014e+16,
                                      1.29957920e+16, 1.29248831e+16, 1.28539743e+16, 1.27825661e+16,
                                      1.27111579e+16, 1.26392503e+16, 1.25673428e+16, 1.24951856e+16,
                                      1.24230283e+16, 1.23506214e+16, 1.22779648e+16, 1.22050586e+16,
                                      1.21321523e+16, 1.20592460e+16, 1.19860901e+16, 1.19129341e+16,
                                      1.18397782e+16, 1.17663726e+16, 1.16929669e+16, 1.16195613e+16,
                                      1.15461557e+16, 1.14725004e+16, 1.13990947e+16, 1.13256891e+16,
                                      1.12522835e+16, 1.11786282e+16, 1.11052226e+16, 1.10320666e+16,
                                      1.09586610e+16, 1.08855050e+16, 1.08123491e+16, 1.07391931e+16,
                                      1.06662869e+16, 1.05933806e+16, 1.05207240e+16, 1.04480674e+16,
                                      1.03756605e+16, 1.03032536e+16, 1.02310964e+16, 1.01591888e+16,
                                      1.00872813e+16, 1.00156234e+16, 9.94421521e+15, 9.87305670e+15,
                                      9.80189818e+15, 9.73098935e+15, 9.66057987e+15, 9.59017039e+15,
                                      9.52001059e+15, 9.44985079e+15, 9.38019035e+15, 9.31077959e+15,
                                      9.24161851e+15, 9.17270710e+15, 9.10404538e+15, 9.03563333e+15,
                                      8.96772064e+15, 8.89980796e+15, 8.83214495e+15, 8.76498130e+15,
                                      8.69781764e+15, 8.63115335e+15, 8.56498842e+15, 8.49882348e+15,
                                      8.43315790e+15, 8.36774201e+15, 8.30257579e+15, 8.23790893e+15,
                                      8.17349174e+15, 8.10932424e+15, 8.04565610e+15, 7.98223763e+15,
                                      7.91931852e+15, 7.85639941e+15, 7.79422934e+15, 7.73205927e+15,
                                      7.67038856e+15, 7.60921720e+15, 7.54829553e+15, 7.48762353e+15,
                                      7.42745089e+15, 7.36752793e+15, 7.30810433e+15, 7.24893041e+15,
                                      7.19025584e+15, 7.13183096e+15, 7.07365575e+15, 7.01597990e+15,
                                      6.95880341e+15, 6.90187660e+15, 6.84519946e+15, 6.78902169e+15,
                                      6.73334327e+15, 6.67791453e+15, 6.62273548e+15, 6.56805577e+15,
                                      6.51387543e+15, 6.45994477e+15, 6.40626378e+15, 6.35308216e+15,
                                      6.30039989e+15, 6.24796730e+15, 6.19578438e+15, 6.14410083e+15,
                                      6.09291664e+15, 6.04173244e+15, 5.99129728e+15, 5.94111180e+15,
                                      5.89117600e+15, 5.84173956e+15, 5.79255280e+15, 5.74386540e+15,
                                      5.69542767e+15, 5.64748930e+15, 5.59980061e+15, 5.55236160e+15,
                                      5.50542195e+15, 5.45873198e+15, 5.41254136e+15, 5.36685010e+15,
                                      5.32115885e+15, 5.27596695e+15, 5.23127441e+15, 5.18683155e+15,
                                      5.14263836e+15, 5.09894454e+15, 5.05550039e+15, 5.00881042e+15,
                                      4.95587847e+15, 4.90344588e+15, 4.85176233e+15, 4.80032845e+15,
                                      4.74964362e+15, 4.69970782e+15, 4.65002170e+15, 4.60108461e+15,
                                      4.55239721e+15, 4.50445884e+15, 4.45726951e+15, 4.41008018e+15,
                                      4.36314052e+15, 4.31670023e+15, 4.27075930e+15, 4.26551604e+15,
                                      1.71272304e+16, 1.69442157e+16, 1.67299911e+16, 1.65182633e+16,
                                      1.63092820e+16, 1.61372531e+16, 2.43791569e+16, 2.43484464e+16,
                                      2.40370967e+16, 2.37297418e+16, 2.34263819e+16, 2.31270167e+16,
                                      2.28313968e+16, 2.25397717e+16, 2.22516422e+16, 2.19675075e+16,
                                      2.16868683e+16, 2.14099742e+16, 2.11365757e+16, 2.08666727e+16,
                                      2.06005149e+16, 2.03376029e+16, 2.00779368e+16, 1.98217661e+16,
                                      1.95690910e+16, 1.93194120e+16, 1.90729788e+16, 1.88297915e+16,
                                      1.85898499e+16, 1.83529046e+16, 1.81189554e+16, 1.78880023e+16,
                                      1.76600453e+16, 1.74350846e+16, 1.72131199e+16, 1.69939018e+16,
                                      1.67774301e+16, 1.65639545e+16, 1.63529758e+16, 1.61449932e+16,
                                      1.59395074e+16, 1.57367680e+16, 1.55365255e+16, 1.53390294e+16,
                                      1.51437804e+16, 1.49512779e+16, 1.47612722e+16, 1.45737632e+16,
                                      1.43885014e+16, 1.42057364e+16, 1.40252185e+16, 1.38469477e+16,
                                      1.36711736e+16, 1.34973971e+16, 1.33258676e+16, 1.31568349e+16,
                                      1.29905487e+16, 1.28597169e+16, 1.50102021e+16, 1.49914762e+16,
                                      1.48149531e+16, 1.46219513e+16, 1.44319456e+16, 1.42444366e+16,
                                      1.40594245e+16, 1.38769091e+16, 1.36968906e+16, 1.35191191e+16,
                                      1.33435948e+16, 1.31743124e+16, 1.30122708e+16, 1.28527259e+16,
                                      1.26959275e+16, 1.25413762e+16, 1.23893217e+16, 1.22395143e+16,
                                      1.22137973e+16, 1.30175140e+16, 1.29346206e+16, 1.27748260e+16,
                                      1.26172786e+16, 1.24624776e+16, 1.23096741e+16, 1.21591176e+16,
                                      1.20108083e+16, 1.18647461e+16, 1.17206813e+16, 1.15791133e+16,
                                      1.14435376e+16, 1.13104587e+16, 1.11793772e+16, 1.10502932e+16,
                                      1.09232066e+16, 1.07978677e+16, 1.06745263e+16, 1.05529326e+16,
                                      1.04333364e+16, 1.03152382e+16, 1.01991375e+16, 1.00842851e+16,
                                      1.00338500e+16, 1.04488165e+16, 1.04473184e+16, 1.03332151e+16,
                                      1.02191118e+16, 1.01065066e+16, 9.99539941e+15, 9.88579033e+15,
                                      9.77742964e+15, 9.67056703e+15, 9.56520249e+15, 9.46108635e+15,
                                      9.35846828e+15, 9.25759796e+15, 9.15772636e+15, 9.05935284e+15,
                                      8.96072963e+15, 8.86185675e+15, 8.76398258e+15, 8.66760648e+15,
                                      8.57197943e+15, 8.47760077e+15, 8.38447050e+15, 8.29233895e+15,
                                      8.20120611e+15, 8.11107199e+15, 8.02218627e+15, 7.93404958e+15,
                                      7.84716129e+15, 7.76102204e+15, 7.67588150e+15, 7.59198935e+15,
                                      7.50859657e+15, 7.42495410e+15, 7.34206067e+15, 7.26016596e+15,
                                      7.17902029e+15, 7.09887333e+15, 7.01972508e+15, 6.94132588e+15,
                                      6.86367571e+15, 6.78702426e+15, 6.71112184e+15, 6.63621814e+15,
                                      6.56206348e+15, 6.48865785e+15, 6.41600126e+15, 6.34409371e+15,
                                      6.27143712e+15, 6.19927989e+15, 6.12812138e+15, 6.05746222e+15,
                                      5.98755210e+15, 5.91764198e+15, 5.84823122e+15, 5.77956949e+15,
                                      5.71140712e+15, 5.64424347e+15, 5.57782886e+15, 5.51216328e+15,
                                      5.44749642e+15, 5.38332892e+15, 5.31991045e+15, 5.25724102e+15,
                                      5.19532063e+15, 5.13414928e+15, 5.07372696e+15, 5.01405368e+15,
                                      4.95512943e+15, 4.89695423e+15, 4.83927838e+15, 4.78160253e+15,
                                      4.72467572e+15, 4.66824826e+15, 4.61256985e+15, 4.55764047e+15,
                                      4.50346012e+15, 4.44977914e+15, 4.39684719e+15, 4.34466428e+15,
                                      4.29298073e+15, 4.24204621e+15, 4.19161105e+15, 4.14167525e+15,
                                      4.09273817e+15, 4.04405076e+15, 3.99611240e+15, 3.94892306e+15,
                                      3.90198341e+15, 3.85604248e+15, 3.81035122e+15, 3.76540900e+15,
                                      3.72096614e+15, 3.67702263e+15, 3.63357849e+15, 3.59088338e+15,
                                      3.54868763e+15, 3.50674156e+15, 3.46554452e+15, 3.42484684e+15,
                                      3.38489820e+15, 3.34519924e+15, 3.30599964e+15, 3.26680004e+15,
                                      3.22809979e+15, 3.18989890e+15, 3.15219738e+15, 3.11499520e+15,
                                      3.07829239e+15, 3.04183926e+15, 3.00613516e+15, 2.97068074e+15,
                                      2.93572568e+15, 2.90102030e+15, 2.86381813e+15, 2.82686564e+15,
                                      2.79041250e+15, 2.75470841e+15, 2.71925399e+15, 2.68404925e+15,
                                      2.64934387e+15, 2.61488817e+15, 2.58118150e+15, 2.54772452e+15,
                                      2.51476689e+15, 2.48220875e+15, 2.45014996e+15, 2.41851563e+15,
                                      2.38730576e+15, 2.35652034e+15, 2.32615937e+15, 2.29622286e+15,
                                      2.26666087e+15, 2.23752333e+15, 2.20876031e+15, 2.18039677e+15,
                                      2.15240776e+15, 2.12479326e+15, 2.09757825e+15, 2.07071279e+15,
                                      2.04419688e+15, 2.01800555e+15, 1.99206390e+15, 1.96647180e+15,
                                      1.94122926e+15, 1.91631129e+15, 1.89174288e+15, 1.86749905e+15,
                                      1.84357980e+15, 1.81998513e+15, 1.79669008e+15, 1.77371962e+15,
                                      1.75107373e+15, 1.72870249e+15, 1.70665584e+15, 1.68488383e+15,
                                      1.66341143e+15, 1.64221369e+15, 1.62131555e+15, 1.60069207e+15,
                                      1.58034323e+15, 1.56026904e+15, 1.54044453e+15, 1.52089466e+15,
                                      1.50161944e+15, 1.48259390e+15, 1.46379307e+15, 1.44526689e+15,
                                      1.42699039e+15, 1.40893860e+15, 1.39113648e+15, 1.33306115e+15,
                                      1.12577764e+15, 9.52050995e+14, 8.01894044e+14, 6.75107048e+14,
                                      5.69442895e+14, 4.81206337e+14, 4.05703407e+14, 3.88101038e+14,
                                      3.73270105e+14, 3.69400080e+14, 1.08555436e+15, 1.03586824e+15,
                                      1.00548230e+15, 9.03413526e+14, 8.65886772e+14, 8.56349034e+14,
                                      1.17421537e+15, 1.15391647e+15, 1.12477893e+15, 1.07254608e+15,
                                      1.02735418e+15, 1.01621850e+15, 1.15781146e+15, 1.11531609e+15,
                                      1.11139613e+15, 9.41289830e+14, 7.94203931e+14, 6.64670466e+14,
                                      5.55935261e+14, 4.64927266e+14, 3.89149689e+14, 3.26005870e+14,
                                      2.73298633e+14, 2.28331446e+14, 1.90579981e+14, 1.58648533e+14,
                                      1.32147604e+14, 1.10170859e+14, 9.19318078e+13, 7.67787893e+13,
                                      6.41824837e+13, 5.36934690e+13, 4.49572007e+13, 3.73919270e+13,
                                      3.10126286e+13, 2.56894723e+13, 2.12454358e+13, 1.75324594e+13,
                                      1.44681490e+13, 1.19486382e+13, 9.87555349e+12, 9.21265574e+12,
                                      8.82315650e+12, 8.72303522e+12, 4.98434188e+13, 4.80032845e+13,
                                      4.77211473e+13, 4.01683575e+13, 3.36891875e+13, 2.82212174e+13,
                                      2.36206321e+13, 1.97478611e+13, 1.65097742e+13, 1.38025048e+13,
                                      1.15234349e+13, 9.59216782e+12, 7.98548346e+12, 6.62398387e+12,
                                      5.49368704e+12, 4.55664175e+12, 3.77989038e+12, 3.13571856e+12,
                                      2.60165518e+12, 2.15867470e+12, 1.79124708e+12, 1.48648889e+12,
                                      1.23368891e+12, 1.02393358e+12, 8.50931000e+11, 7.08763777e+11,
                                      5.90390963e+11, 4.91817694e+11, 4.09723239e+11, 3.41361129e+11,
                                      2.84409349e+11, 2.36977829e+11, 1.97466128e+11, 1.64553442e+11,
                                      1.37131197e+11, 1.14285569e+11]),
                     'ene': np.array([5.5275000e+00, 5.6100000e+00, 1.0690000e+01, 1.1427610e+01,
                                      1.2216120e+01, 1.3059030e+01, 1.3960100e+01, 1.4923350e+01,
                                      1.5953060e+01, 1.7053820e+01, 1.8230530e+01, 1.9488440e+01,
                                      2.0833140e+01, 2.0874000e+01, 2.1193500e+01, 2.1278700e+01,
                                      2.1406500e+01, 2.1726000e+01, 2.2270630e+01, 2.3807300e+01,
                                      2.5450010e+01, 2.7206060e+01, 2.9083270e+01, 3.1090020e+01,
                                      3.3235230e+01, 3.5528460e+01, 3.6652000e+01, 3.7213000e+01,
                                      3.7362600e+01, 3.7587000e+01, 3.7979930e+01, 3.8148000e+01,
                                      4.0600540e+01, 4.3401980e+01, 4.6396710e+01, 4.9598090e+01,
                                      5.3020350e+01, 5.6678760e+01, 6.0589590e+01, 6.4770280e+01,
                                      6.9239420e+01, 7.4016950e+01, 7.9124110e+01, 8.4583680e+01,
                                      9.0419950e+01, 9.6658930e+01, 1.0000000e+02, 1.0050000e+02,
                                      1.0100250e+02, 1.0150751e+02, 1.0201505e+02, 1.0252513e+02,
                                      1.0303775e+02, 1.0355294e+02, 1.0407070e+02, 1.0459106e+02,
                                      1.0511401e+02, 1.0563958e+02, 1.0616778e+02, 1.0669862e+02,
                                      1.0723211e+02, 1.0776827e+02, 1.0830712e+02, 1.0884865e+02,
                                      1.0939289e+02, 1.0993986e+02, 1.1048956e+02, 1.1104201e+02,
                                      1.1159722e+02, 1.1215520e+02, 1.1271598e+02, 1.1327956e+02,
                                      1.1384596e+02, 1.1441519e+02, 1.1498726e+02, 1.1556220e+02,
                                      1.1614001e+02, 1.1672071e+02, 1.1730431e+02, 1.1789083e+02,
                                      1.1848029e+02, 1.1907269e+02, 1.1966805e+02, 1.2026639e+02,
                                      1.2086772e+02, 1.2147206e+02, 1.2207942e+02, 1.2268982e+02,
                                      1.2330327e+02, 1.2391979e+02, 1.2453939e+02, 1.2516208e+02,
                                      1.2578789e+02, 1.2641683e+02, 1.2704892e+02, 1.2768416e+02,
                                      1.2832258e+02, 1.2896419e+02, 1.2897987e+02, 1.2902012e+02,
                                      1.2960902e+02, 1.3025706e+02, 1.3090835e+02, 1.3156289e+02,
                                      1.3222070e+02, 1.3288181e+02, 1.3354621e+02, 1.3421395e+02,
                                      1.3488502e+02, 1.3555944e+02, 1.3623724e+02, 1.3691842e+02,
                                      1.3760302e+02, 1.3829103e+02, 1.3898249e+02, 1.3967740e+02,
                                      1.4037579e+02, 1.4107766e+02, 1.4178305e+02, 1.4249197e+02,
                                      1.4320443e+02, 1.4392045e+02, 1.4464005e+02, 1.4536325e+02,
                                      1.4609007e+02, 1.4682052e+02, 1.4755462e+02, 1.4829239e+02,
                                      1.4903386e+02, 1.4977903e+02, 1.5052792e+02, 1.5128056e+02,
                                      1.5203696e+02, 1.5279715e+02, 1.5356113e+02, 1.5432894e+02,
                                      1.5510058e+02, 1.5587609e+02, 1.5665547e+02, 1.5743875e+02,
                                      1.5822594e+02, 1.5901707e+02, 1.5981215e+02, 1.6061121e+02,
                                      1.6141427e+02, 1.6222134e+02, 1.6303245e+02, 1.6384761e+02,
                                      1.6466685e+02, 1.6549018e+02, 1.6631763e+02, 1.6714922e+02,
                                      1.6798497e+02, 1.6882489e+02, 1.6966902e+02, 1.7051736e+02,
                                      1.7136995e+02, 1.7222680e+02, 1.7308793e+02, 1.7395337e+02,
                                      1.7482314e+02, 1.7569726e+02, 1.7657574e+02, 1.7745862e+02,
                                      1.7834591e+02, 1.7923764e+02, 1.8013383e+02, 1.8103450e+02,
                                      1.8193967e+02, 1.8284937e+02, 1.8376362e+02, 1.8468244e+02,
                                      1.8560585e+02, 1.8653388e+02, 1.8746655e+02, 1.8840388e+02,
                                      1.8934590e+02, 1.9029263e+02, 1.9124409e+02, 1.9220031e+02,
                                      1.9316131e+02, 1.9412712e+02, 1.9509776e+02, 1.9607325e+02,
                                      1.9705361e+02, 1.9803888e+02, 1.9902907e+02, 2.0002422e+02,
                                      2.0102434e+02, 2.0202946e+02, 2.0303961e+02, 2.0405481e+02,
                                      2.0507508e+02, 2.0610046e+02, 2.0713096e+02, 2.0816661e+02,
                                      2.0920745e+02, 2.1025348e+02, 2.1130475e+02, 2.1236128e+02,
                                      2.1342308e+02, 2.1449020e+02, 2.1556265e+02, 2.1664046e+02,
                                      2.1772366e+02, 2.1881228e+02, 2.1990634e+02, 2.2100588e+02,
                                      2.2211090e+02, 2.2322146e+02, 2.2433757e+02, 2.2545925e+02,
                                      2.2658655e+02, 2.2771948e+02, 2.2885808e+02, 2.3000237e+02,
                                      2.3115238e+02, 2.3230814e+02, 2.3346969e+02, 2.3463703e+02,
                                      2.3581022e+02, 2.3698927e+02, 2.3817422e+02, 2.3936509e+02,
                                      2.4056191e+02, 2.4176472e+02, 2.4297355e+02, 2.4418841e+02,
                                      2.4540936e+02, 2.4663640e+02, 2.4723820e+02, 2.4756180e+02,
                                      2.4786959e+02, 2.4910893e+02, 2.5035448e+02, 2.5160625e+02,
                                      2.5286428e+02, 2.5412860e+02, 2.5539925e+02, 2.5667624e+02,
                                      2.5795962e+02, 2.5924942e+02, 2.6054567e+02, 2.6184840e+02,
                                      2.6315764e+02, 2.6447343e+02, 2.6540451e+02, 2.6579579e+02,
                                      2.6712477e+02, 2.6846040e+02, 2.6980270e+02, 2.7115171e+02,
                                      2.7250747e+02, 2.7387001e+02, 2.7523936e+02, 2.7661556e+02,
                                      2.7799863e+02, 2.7938863e+02, 2.8078557e+02, 2.8218950e+02,
                                      2.8360044e+02, 2.8501845e+02, 2.8644354e+02, 2.8787576e+02,
                                      2.8931514e+02, 2.9076171e+02, 2.9221552e+02, 2.9367660e+02,
                                      2.9514498e+02, 2.9662071e+02, 2.9810381e+02, 2.9959433e+02,
                                      3.0109230e+02, 3.0259776e+02, 3.0411075e+02, 3.0563130e+02,
                                      3.0715946e+02, 3.0869526e+02, 3.1023873e+02, 3.1178993e+02,
                                      3.1334888e+02, 3.1491562e+02, 3.1649020e+02, 3.1807265e+02,
                                      3.1966301e+02, 3.2126133e+02, 3.2286764e+02, 3.2448197e+02,
                                      3.2610438e+02, 3.2773491e+02, 3.2937358e+02, 3.3102045e+02,
                                      3.3267555e+02, 3.3433893e+02, 3.3601062e+02, 3.3769068e+02,
                                      3.3937913e+02, 3.4107602e+02, 3.4278140e+02, 3.4449531e+02,
                                      3.4532318e+02, 3.4607681e+02, 3.4621779e+02, 3.4794888e+02,
                                      3.4968862e+02, 3.5143706e+02, 3.5319425e+02, 3.5496022e+02,
                                      3.5673502e+02, 3.5851870e+02, 3.6031129e+02, 3.6211285e+02,
                                      3.6392341e+02, 3.6574303e+02, 3.6757174e+02, 3.6940960e+02,
                                      3.7125665e+02, 3.7311293e+02, 3.7497850e+02, 3.7685339e+02,
                                      3.7873766e+02, 3.8063135e+02, 3.8253450e+02, 3.8444718e+02,
                                      3.8636941e+02, 3.8830126e+02, 3.9024276e+02, 3.9219398e+02,
                                      3.9415495e+02, 3.9612572e+02, 3.9810635e+02, 4.0009688e+02,
                                      4.0209737e+02, 4.0410785e+02, 4.0612839e+02, 4.0815904e+02,
                                      4.1019983e+02, 4.1225083e+02, 4.1431208e+02, 4.1638364e+02,
                                      4.1846556e+02, 4.2055789e+02, 4.2266068e+02, 4.2477398e+02,
                                      4.2689785e+02, 4.2903234e+02, 4.3117750e+02, 4.3333339e+02,
                                      4.3550006e+02, 4.3767756e+02, 4.3986595e+02, 4.4206528e+02,
                                      4.4427560e+02, 4.4649698e+02, 4.4872947e+02, 4.5097311e+02,
                                      4.5322798e+02, 4.5549412e+02, 4.5777159e+02, 4.6006045e+02,
                                      4.6236075e+02, 4.6467255e+02, 4.6699592e+02, 4.6933090e+02,
                                      4.7167755e+02, 4.7403594e+02, 4.7640612e+02, 4.7878815e+02,
                                      4.8118209e+02, 4.8358800e+02, 4.8600594e+02, 4.8843597e+02,
                                      4.9087815e+02, 4.9333254e+02, 4.9579920e+02, 4.9827820e+02,
                                      5.0076959e+02, 5.0327344e+02, 5.0578980e+02, 5.0831875e+02,
                                      5.1086035e+02, 5.1341465e+02, 5.1598172e+02, 5.1856163e+02,
                                      5.2115444e+02, 5.2376021e+02, 5.2637901e+02, 5.2901091e+02,
                                      5.3165596e+02, 5.3431424e+02, 5.3698581e+02, 5.3967074e+02,
                                      5.4236910e+02, 5.4508094e+02, 5.4780635e+02, 5.5054538e+02,
                                      5.5329810e+02, 5.5606460e+02, 5.5884492e+02, 5.6163914e+02,
                                      5.6444734e+02, 5.6726958e+02, 5.7010592e+02, 5.7295645e+02,
                                      5.7582123e+02, 5.7870034e+02, 5.8159384e+02, 5.8450181e+02,
                                      5.8742432e+02, 5.9036144e+02, 5.9331325e+02, 5.9627982e+02,
                                      5.9926122e+02, 6.0225752e+02, 6.0526881e+02, 6.0829515e+02,
                                      6.1133663e+02, 6.1439331e+02, 6.1746528e+02, 6.2055260e+02,
                                      6.2365537e+02, 6.2677364e+02, 6.2990751e+02, 6.3305705e+02,
                                      6.3622234e+02, 6.3940345e+02, 6.4260046e+02, 6.4581347e+02,
                                      6.4904253e+02, 6.5228775e+02, 6.5554919e+02, 6.5882693e+02,
                                      6.6212107e+02, 6.6543167e+02, 6.6875883e+02, 6.7210262e+02,
                                      6.7546314e+02, 6.7884045e+02, 6.8223466e+02, 6.8564583e+02,
                                      6.8907406e+02, 6.9251943e+02, 6.9598202e+02, 6.9946194e+02,
                                      7.0295924e+02, 7.0647404e+02, 7.1000641e+02, 7.1355644e+02,
                                      7.1712423e+02, 7.2070985e+02, 7.2431340e+02, 7.2793496e+02,
                                      7.3157464e+02, 7.3523251e+02, 7.3890867e+02, 7.4260322e+02,
                                      7.4631623e+02, 7.5004781e+02, 7.5379805e+02, 7.5756704e+02,
                                      7.6135488e+02, 7.6516165e+02, 7.6898746e+02, 7.7283240e+02,
                                      7.7669656e+02, 7.8058004e+02, 7.8448294e+02, 7.8840536e+02,
                                      7.9234738e+02, 7.9630912e+02, 8.0029067e+02, 8.0429212e+02,
                                      8.0831358e+02, 8.1235515e+02, 8.1641693e+02, 8.2049901e+02,
                                      8.2460150e+02, 8.2872451e+02, 8.3286813e+02, 8.3703248e+02,
                                      8.4121764e+02, 8.4542373e+02, 8.4965084e+02, 8.5389910e+02,
                                      8.5816859e+02, 8.6245944e+02, 8.6677173e+02, 8.7110559e+02,
                                      8.7546112e+02, 8.7983843e+02, 8.8423762e+02, 8.8865881e+02,
                                      8.9310210e+02, 8.9756761e+02, 9.0205545e+02, 9.0656573e+02,
                                      9.1109856e+02, 9.1565405e+02, 9.2023232e+02, 9.2483348e+02,
                                      9.2945765e+02, 9.3410494e+02, 9.3877546e+02, 9.4346934e+02,
                                      9.4818668e+02, 9.5292762e+02, 9.5769226e+02, 9.6248072e+02,
                                      9.6729312e+02, 9.7212959e+02, 9.7699023e+02, 9.8187519e+02,
                                      9.8678456e+02, 9.9171848e+02, 9.9667708e+02, 1.0016605e+03,
                                      1.0066688e+03, 1.0117021e+03, 1.0167606e+03, 1.0218444e+03,
                                      1.0269536e+03, 1.0320884e+03, 1.0372489e+03, 1.0424351e+03,
                                      1.0476473e+03, 1.0528855e+03, 1.0581499e+03, 1.0634407e+03,
                                      1.0687579e+03, 1.0741017e+03, 1.0794722e+03, 1.0800822e+03,
                                      1.0803177e+03, 1.0848695e+03, 1.0902939e+03, 1.0957454e+03,
                                      1.1012241e+03, 1.1058130e+03, 1.1061869e+03, 1.1067302e+03,
                                      1.1122639e+03, 1.1178252e+03, 1.1234143e+03, 1.1290314e+03,
                                      1.1346765e+03, 1.1403499e+03, 1.1460517e+03, 1.1517819e+03,
                                      1.1575408e+03, 1.1633285e+03, 1.1691452e+03, 1.1749909e+03,
                                      1.1808659e+03, 1.1867702e+03, 1.1927040e+03, 1.1986676e+03,
                                      1.2046609e+03, 1.2106842e+03, 1.2167376e+03, 1.2228213e+03,
                                      1.2289354e+03, 1.2350801e+03, 1.2412555e+03, 1.2474618e+03,
                                      1.2536991e+03, 1.2599676e+03, 1.2662674e+03, 1.2725988e+03,
                                      1.2789618e+03, 1.2853566e+03, 1.2917833e+03, 1.2982423e+03,
                                      1.3047335e+03, 1.3112571e+03, 1.3178134e+03, 1.3244025e+03,
                                      1.3310245e+03, 1.3376796e+03, 1.3443680e+03, 1.3510899e+03,
                                      1.3578453e+03, 1.3646345e+03, 1.3714577e+03, 1.3783150e+03,
                                      1.3852066e+03, 1.3921326e+03, 1.3990933e+03, 1.4060887e+03,
                                      1.4131192e+03, 1.4187409e+03, 1.4201848e+03, 1.4208592e+03,
                                      1.4272857e+03, 1.4344221e+03, 1.4415942e+03, 1.4488022e+03,
                                      1.4560462e+03, 1.4633265e+03, 1.4706431e+03, 1.4779963e+03,
                                      1.4853863e+03, 1.4928132e+03, 1.5002773e+03, 1.5077787e+03,
                                      1.5153176e+03, 1.5228942e+03, 1.5305086e+03, 1.5381612e+03,
                                      1.5395028e+03, 1.5418971e+03, 1.5458520e+03, 1.5535812e+03,
                                      1.5613491e+03, 1.5691559e+03, 1.5770017e+03, 1.5848867e+03,
                                      1.5928111e+03, 1.6007752e+03, 1.6087790e+03, 1.6168229e+03,
                                      1.6249070e+03, 1.6330316e+03, 1.6411967e+03, 1.6494027e+03,
                                      1.6576497e+03, 1.6659380e+03, 1.6742677e+03, 1.6826390e+03,
                                      1.6910522e+03, 1.6995075e+03, 1.7080050e+03, 1.7165450e+03,
                                      1.7203536e+03, 1.7251278e+03, 1.7252464e+03, 1.7337534e+03,
                                      1.7424222e+03, 1.7511343e+03, 1.7598899e+03, 1.7686894e+03,
                                      1.7775328e+03, 1.7864205e+03, 1.7953526e+03, 1.8043294e+03,
                                      1.8133510e+03, 1.8224178e+03, 1.8315299e+03, 1.8406875e+03,
                                      1.8498909e+03, 1.8591404e+03, 1.8684361e+03, 1.8777783e+03,
                                      1.8871672e+03, 1.8966030e+03, 1.9060860e+03, 1.9156165e+03,
                                      1.9251945e+03, 1.9348205e+03, 1.9444946e+03, 1.9542171e+03,
                                      1.9639882e+03, 1.9738081e+03, 1.9836772e+03, 1.9935955e+03,
                                      2.0035635e+03, 2.0135813e+03, 2.0236492e+03, 2.0337675e+03,
                                      2.0439363e+03, 2.0541560e+03, 2.0644268e+03, 2.0747489e+03,
                                      2.0851227e+03, 2.0955483e+03, 2.1060260e+03, 2.1165562e+03,
                                      2.1271389e+03, 2.1377746e+03, 2.1484635e+03, 2.1592058e+03,
                                      2.1700018e+03, 2.1808519e+03, 2.1917561e+03, 2.2027149e+03,
                                      2.2137285e+03, 2.2247971e+03, 2.2359211e+03, 2.2471007e+03,
                                      2.2583362e+03, 2.2696279e+03, 2.2809760e+03, 2.2923809e+03,
                                      2.3038428e+03, 2.3153620e+03, 2.3269388e+03, 2.3385735e+03,
                                      2.3502664e+03, 2.3620177e+03, 2.3738278e+03, 2.3856970e+03,
                                      2.3976254e+03, 2.4096136e+03, 2.4216616e+03, 2.4337699e+03,
                                      2.4459388e+03, 2.4581685e+03, 2.4704593e+03, 2.4828116e+03,
                                      2.4952257e+03, 2.5077018e+03, 2.5202403e+03, 2.5328415e+03,
                                      2.5455057e+03, 2.5582333e+03, 2.5710244e+03, 2.5838796e+03,
                                      2.5967990e+03, 2.6097829e+03, 2.6228319e+03, 2.6359460e+03,
                                      2.6491257e+03, 2.6623714e+03, 2.6756832e+03, 2.6890617e+03,
                                      2.7025070e+03, 2.7160195e+03, 2.7295996e+03, 2.7432476e+03,
                                      2.7569638e+03, 2.7707486e+03, 2.7846024e+03, 2.7985254e+03,
                                      2.8125180e+03, 2.8265806e+03, 2.8407135e+03, 2.8549171e+03,
                                      2.8691917e+03, 2.8835376e+03, 2.8979553e+03, 2.9124451e+03,
                                      2.9270073e+03, 2.9416424e+03, 2.9563506e+03, 2.9711323e+03,
                                      2.9859880e+03, 3.0009179e+03, 3.0159225e+03, 3.0310021e+03,
                                      3.0461571e+03, 3.0613879e+03, 3.0766949e+03, 3.0920783e+03,
                                      3.1075387e+03, 3.1230764e+03, 3.1386918e+03, 3.1543853e+03,
                                      3.1701572e+03, 3.1860080e+03, 3.2019380e+03, 3.2179477e+03,
                                      3.2340374e+03, 3.2502076e+03, 3.2664587e+03, 3.2827910e+03,
                                      3.2992049e+03, 3.3157009e+03, 3.3322794e+03, 3.3489408e+03,
                                      3.3656856e+03, 3.3825140e+03, 3.3994265e+03, 3.4164237e+03,
                                      3.4335058e+03, 3.4506733e+03, 3.4679267e+03, 3.4852663e+03,
                                      3.5026927e+03, 3.5202061e+03, 3.5378072e+03, 3.5554962e+03,
                                      3.5732737e+03, 3.5911400e+03, 3.6090957e+03, 3.6271412e+03,
                                      3.6452769e+03, 3.6635033e+03, 3.6818208e+03, 3.7002299e+03,
                                      3.7187311e+03, 3.7373247e+03, 3.7560114e+03, 3.7747914e+03,
                                      3.7936654e+03, 3.8126337e+03, 3.8316969e+03, 3.8508554e+03,
                                      3.8701096e+03, 3.8894602e+03, 3.9089075e+03, 3.9284520e+03,
                                      3.9480943e+03, 3.9678347e+03, 3.9876739e+03, 4.0550240e+03,
                                      4.3348210e+03, 4.6339240e+03, 4.9536640e+03, 5.2954670e+03,
                                      5.6608550e+03, 6.0514530e+03, 6.4690040e+03, 6.5818760e+03,
                                      6.6826190e+03, 6.7094840e+03, 6.7497810e+03, 6.8505240e+03,
                                      6.9153650e+03, 7.1655640e+03, 7.2752410e+03, 7.3044880e+03,
                                      7.3483590e+03, 7.3925250e+03, 7.4580360e+03, 7.5820640e+03,
                                      7.6981160e+03, 7.7290630e+03, 7.7754840e+03, 7.8915360e+03,
                                      7.9026090e+03, 8.4478900e+03, 9.0307940e+03, 9.6539190e+03,
                                      1.0320040e+04, 1.1032120e+04, 1.1793340e+04, 1.2607080e+04,
                                      1.3476970e+04, 1.4406880e+04, 1.5400950e+04, 1.6463620e+04,
                                      1.7599610e+04, 1.8813980e+04, 2.0112150e+04, 2.1499880e+04,
                                      2.2983380e+04, 2.4569230e+04, 2.6264500e+04, 2.8076760e+04,
                                      3.0014050e+04, 3.2085020e+04, 3.4298890e+04, 3.6665510e+04,
                                      3.9195430e+04, 4.1899920e+04, 4.4791010e+04, 4.5897520e+04,
                                      4.6600030e+04, 4.6787370e+04, 4.7068370e+04, 4.7770890e+04,
                                      4.7881590e+04, 5.1185420e+04, 5.4717210e+04, 5.8492700e+04,
                                      6.2528700e+04, 6.6843180e+04, 7.1455360e+04, 7.6385780e+04,
                                      8.1656400e+04, 8.7290690e+04, 9.3313740e+04, 9.9752390e+04,
                                      1.0663530e+05, 1.1399310e+05, 1.2185870e+05, 1.3026690e+05,
                                      1.3925530e+05, 1.4886400e+05, 1.5913560e+05, 1.7011590e+05,
                                      1.8185390e+05, 1.9440180e+05, 2.0781560e+05, 2.2215480e+05,
                                      2.3748350e+05, 2.5386990e+05, 2.7138690e+05, 2.9011260e+05,
                                      3.1013040e+05, 3.3152940e+05, 3.5440490e+05, 3.7885880e+05,
                                      4.0500010e+05, 4.3294510e+05]), },
              '63': {'name': 'Eu',
                     'barns': 2523360000000.0,
                     'NumEdges': 18,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 22.0, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 22.0, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 31.8, 'factor': 1.0},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2.91151, 'factor': 0.75},
                     'N5': {'filename': 'Eu.N5', 'excl before': 5, 'excl after': 50, 'onset': 133.20000000000002,
                            'factor': 1.0, 'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 133.20000000000002,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 256.6, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 283.9, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 360.20000000000005,
                            'factor': 1.0},
                     'M5': {'filename': 'Eu.M5', 'excl before': 5, 'excl after': 50, 'onset': 1130.9, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1160.6000000000001,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Eu.M3', 'excl before': 5, 'excl after': 50, 'onset': 1480.6, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1613.8999999999999,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1800.0, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 6976.9, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7617.099999999999,
                            'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8052.0, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 48519.0, 'factor': 1.0},
                     'dat': np.array([1.63836718e+16, 1.71792872e+16, 1.80453044e+16, 1.89837420e+16,
                                      1.99968710e+16, 2.10854485e+16, 2.22502315e+16, 2.34902106e+16,
                                      2.48046288e+16, 2.61899534e+16, 2.76434088e+16, 2.84155570e+16,
                                      2.87612573e+16, 2.88546216e+16, 5.71440106e+17, 5.56653216e+17,
                                      5.41613990e+17, 4.38509501e+17, 3.45851722e+17, 2.71008864e+17,
                                      2.12908500e+17, 1.69153438e+17, 1.67823627e+17, 1.59668127e+17,
                                      1.57609066e+17, 1.55121033e+17, 1.48060671e+17, 1.37497886e+17,
                                      1.14270358e+17, 9.77145926e+16, 8.60591928e+16, 7.79465904e+16,
                                      7.23724882e+16, 6.86051117e+16, 6.61095086e+16, 6.32152147e+16,
                                      5.97582115e+16, 5.66317685e+16, 5.37147643e+16, 5.09239282e+16,
                                      4.82087928e+16, 4.55416013e+16, 4.29046901e+16, 4.02980592e+16,
                                      3.89808653e+16, 3.87890899e+16, 3.85973146e+16, 3.84055392e+16,
                                      3.82137638e+16, 3.80219885e+16, 3.78302131e+16, 3.76409611e+16,
                                      3.74491858e+16, 3.72574104e+16, 3.70681584e+16, 3.68789064e+16,
                                      3.66871310e+16, 3.64978790e+16, 3.63086270e+16, 3.61193750e+16,
                                      3.59301230e+16, 3.57408710e+16, 3.55541424e+16, 3.53648904e+16,
                                      3.51756384e+16, 3.49889098e+16, 3.48021811e+16, 3.46154525e+16,
                                      3.44287238e+16, 3.42419952e+16, 3.40552666e+16, 3.38685379e+16,
                                      3.36843326e+16, 3.34976040e+16, 3.33133987e+16, 3.31291934e+16,
                                      3.29449882e+16, 3.27607829e+16, 3.25765776e+16, 3.23923723e+16,
                                      3.22106904e+16, 3.20264851e+16, 3.18448032e+16, 3.16631213e+16,
                                      3.14814394e+16, 3.12997574e+16, 3.11205989e+16, 3.09389170e+16,
                                      3.07597584e+16, 3.05805998e+16, 3.04014413e+16, 3.02222827e+16,
                                      3.00431242e+16, 2.98639656e+16, 2.96873304e+16, 2.95106952e+16,
                                      2.93340600e+16, 2.91574248e+16, 2.89807896e+16, 2.88066778e+16,
                                      2.86300426e+16, 2.84559307e+16, 2.83802299e+16, 1.31580607e+17,
                                      1.28176595e+17, 1.21411466e+17, 1.15080356e+17, 1.09155507e+17,
                                      1.03611685e+17, 9.84211334e+16, 9.35661888e+16, 8.90165707e+16,
                                      8.47596624e+16, 8.07702302e+16, 7.70356574e+16, 7.35357571e+16,
                                      7.02579125e+16, 6.71844600e+16, 6.43027829e+16, 6.16002643e+16,
                                      5.90668109e+16, 5.66898058e+16, 5.44591555e+16, 5.23672901e+16,
                                      5.04343963e+16, 4.86529042e+16, 4.70101968e+16, 4.54936574e+16,
                                      4.40906693e+16, 4.27860922e+16, 4.15774027e+16, 4.04519842e+16,
                                      3.94022664e+16, 3.84206794e+16, 3.75046997e+16, 3.66442339e+16,
                                      3.58367587e+16, 3.50772274e+16, 3.43605931e+16, 3.36868560e+16,
                                      3.30484459e+16, 3.24453629e+16, 3.18725602e+16, 3.13300378e+16,
                                      3.08127490e+16, 3.03206938e+16, 2.98513488e+16, 2.94021907e+16,
                                      2.89732195e+16, 2.85644352e+16, 2.81707910e+16, 2.77922870e+16,
                                      2.74314466e+16, 2.70806995e+16, 2.67450926e+16, 2.64221026e+16,
                                      2.61092059e+16, 2.58064027e+16, 2.55136930e+16, 2.52318336e+16,
                                      2.49577968e+16, 2.46920869e+16, 2.44341996e+16, 2.41838822e+16,
                                      2.39403780e+16, 2.37034345e+16, 2.34730517e+16, 2.32484727e+16,
                                      2.30294450e+16, 2.28162211e+16, 2.26077916e+16, 2.24044088e+16,
                                      2.22058203e+16, 2.20115216e+16, 2.18217649e+16, 2.16357933e+16,
                                      2.14541114e+16, 2.12759622e+16, 2.11015980e+16, 2.09307665e+16,
                                      2.07632154e+16, 2.05991970e+16, 2.04382067e+16, 2.02799920e+16,
                                      2.01250577e+16, 1.99728991e+16, 1.98235162e+16, 1.96766566e+16,
                                      1.95325728e+16, 1.93910123e+16, 1.92519751e+16, 1.91152090e+16,
                                      1.89807139e+16, 1.88487422e+16, 1.87187892e+16, 1.85911071e+16,
                                      1.84654438e+16, 1.83420515e+16, 1.82206779e+16, 1.81010706e+16,
                                      1.79837344e+16, 1.78681645e+16, 1.77543610e+16, 1.76425761e+16,
                                      1.75325576e+16, 1.74243055e+16, 1.73178197e+16, 1.72128479e+16,
                                      1.71098948e+16, 1.70084557e+16, 1.69087830e+16, 1.68106243e+16,
                                      1.67139796e+16, 1.66188490e+16, 1.65254846e+16, 1.64336343e+16,
                                      1.63432980e+16, 1.62542234e+16, 1.61669152e+16, 1.60808686e+16,
                                      1.59963360e+16, 1.59130652e+16, 1.58313083e+16, 1.57508131e+16,
                                      1.56718320e+16, 1.55941125e+16, 1.55176547e+16, 1.54427109e+16,
                                      1.53690288e+16, 1.52963560e+16, 1.52251972e+16, 1.51553002e+16,
                                      1.50864124e+16, 1.50187864e+16, 1.49524220e+16, 1.49004408e+16,
                                      1.78232487e+16, 1.78176973e+16, 1.77558750e+16, 1.76895106e+16,
                                      1.76244079e+16, 1.75603146e+16, 1.74974829e+16, 1.74356606e+16,
                                      1.73748476e+16, 1.73152963e+16, 1.72565020e+16, 1.71989694e+16,
                                      1.71421938e+16, 1.70866799e+16, 1.70321753e+16, 1.69784278e+16,
                                      1.69256895e+16, 1.68739607e+16, 1.68229888e+16, 1.67730263e+16,
                                      1.67238207e+16, 1.66756246e+16, 1.66733535e+16, 1.74757820e+16,
                                      1.74462587e+16, 1.73995765e+16, 1.73533991e+16, 1.73079786e+16,
                                      1.72633151e+16, 1.72191563e+16, 1.71760068e+16, 1.71331097e+16,
                                      1.70909696e+16, 1.70495865e+16, 1.70087081e+16, 1.69683343e+16,
                                      1.69284652e+16, 1.68893532e+16, 1.68504934e+16, 1.68123907e+16,
                                      1.67745403e+16, 1.67374469e+16, 1.67006058e+16, 1.66640171e+16,
                                      1.66281854e+16, 1.65923537e+16, 1.65572790e+16, 1.65222043e+16,
                                      1.64876342e+16, 1.64533165e+16, 1.64192512e+16, 1.63854382e+16,
                                      1.63521298e+16, 1.63188215e+16, 1.62857654e+16, 1.62529618e+16,
                                      1.62201581e+16, 1.61876067e+16, 1.61553077e+16, 1.61230087e+16,
                                      1.60909620e+16, 1.60589154e+16, 1.60268687e+16, 1.59948220e+16,
                                      1.59630277e+16, 1.59309810e+16, 1.58991867e+16, 1.58673924e+16,
                                      1.58353457e+16, 1.58032990e+16, 1.57712523e+16, 1.57485421e+16,
                                      1.67561197e+16, 1.67503160e+16, 1.67210450e+16, 1.66857180e+16,
                                      1.66503910e+16, 1.66150639e+16, 1.65794845e+16, 1.65436528e+16,
                                      1.65078211e+16, 1.64717371e+16, 1.64354007e+16, 1.63988120e+16,
                                      1.63622232e+16, 1.63251299e+16, 1.62880365e+16, 1.62504384e+16,
                                      1.62128403e+16, 1.61747376e+16, 1.61363825e+16, 1.60977751e+16,
                                      1.60589154e+16, 1.60195510e+16, 1.59799342e+16, 1.59400651e+16,
                                      1.58996914e+16, 1.58588129e+16, 1.58176822e+16, 1.57760467e+16,
                                      1.57341589e+16, 1.56915142e+16, 1.56486170e+16, 1.56052152e+16,
                                      1.55615611e+16, 1.55171500e+16, 1.54724865e+16, 1.54273184e+16,
                                      1.53818979e+16, 1.53357204e+16, 1.52892906e+16, 1.52423561e+16,
                                      1.51951692e+16, 1.51472254e+16, 1.50990292e+16, 1.50503284e+16,
                                      1.50011229e+16, 1.49514127e+16, 1.49014501e+16, 1.48507306e+16,
                                      1.47997587e+16, 1.47482822e+16, 1.46963010e+16, 1.46440674e+16,
                                      1.45913292e+16, 1.45380863e+16, 1.44843387e+16, 1.44300865e+16,
                                      1.43755819e+16, 1.43205727e+16, 1.42653111e+16, 1.42092925e+16,
                                      1.41530216e+16, 1.40964983e+16, 1.40394704e+16, 1.39819378e+16,
                                      1.39239005e+16, 1.38658632e+16, 1.38070689e+16, 1.37480223e+16,
                                      1.36887233e+16, 1.36289197e+16, 1.35688637e+16, 1.35083031e+16,
                                      1.34474901e+16, 1.33861725e+16, 1.33248548e+16, 1.32630325e+16,
                                      1.32009578e+16, 1.31383785e+16, 1.30755468e+16, 1.30127152e+16,
                                      1.29493788e+16, 1.28855378e+16, 1.28214445e+16, 1.27570988e+16,
                                      1.26922485e+16, 1.26268934e+16, 1.25615384e+16, 1.24956787e+16,
                                      1.24295667e+16, 1.23632023e+16, 1.22963333e+16, 1.22294642e+16,
                                      1.21623429e+16, 1.20947168e+16, 1.20270908e+16, 1.19592124e+16,
                                      1.18913340e+16, 1.18229509e+16, 1.17545679e+16, 1.16861848e+16,
                                      1.16172971e+16, 1.15486617e+16, 1.14795216e+16, 1.14106339e+16,
                                      1.13412415e+16, 1.12721015e+16, 1.12027091e+16, 1.11333167e+16,
                                      1.10639243e+16, 1.09942795e+16, 1.09248871e+16, 1.08554947e+16,
                                      1.07858500e+16, 1.07164576e+16, 1.06470652e+16, 1.05776728e+16,
                                      1.05082804e+16, 1.04388880e+16, 1.03697479e+16, 1.03006079e+16,
                                      1.02314678e+16, 1.01625801e+16, 1.00936923e+16, 1.00248046e+16,
                                      9.95616922e+15, 9.88778616e+15, 9.81940310e+15, 9.75127238e+15,
                                      9.68314166e+15, 9.61526328e+15, 9.54763723e+15, 9.48001118e+15,
                                      9.41263747e+15, 9.34551610e+15, 9.27864706e+15, 9.21203035e+15,
                                      9.14541365e+15, 9.07904928e+15, 9.01318958e+15, 8.94732989e+15,
                                      8.88172253e+15, 8.81636750e+15, 8.75126482e+15, 8.68641446e+15,
                                      8.62181645e+15, 8.55772310e+15, 8.49362976e+15, 8.42978875e+15,
                                      8.36645242e+15, 8.30311608e+15, 8.24028442e+15, 8.17770509e+15,
                                      8.11537810e+15, 8.05355578e+15, 7.99173346e+15, 7.93041581e+15,
                                      7.86935050e+15, 7.80853752e+15, 7.74822922e+15, 7.68817325e+15,
                                      7.62836962e+15, 7.56881832e+15, 7.50977170e+15, 7.45097741e+15,
                                      7.39243546e+15, 7.33439818e+15, 7.27661323e+15, 7.21908062e+15,
                                      7.16180035e+15, 7.10502475e+15, 7.04875382e+15, 6.99248290e+15,
                                      6.93671664e+15, 6.88145506e+15, 6.82644581e+15, 6.77168890e+15,
                                      6.71718432e+15, 6.66318442e+15, 6.60943685e+15, 6.55619395e+15,
                                      6.50320339e+15, 6.45071750e+15, 6.39823162e+15, 6.34650274e+15,
                                      6.29477386e+15, 6.24354965e+15, 6.19283011e+15, 6.14211058e+15,
                                      6.09214805e+15, 6.04218552e+15, 5.99272766e+15, 5.94352214e+15,
                                      5.89482130e+15, 5.84637278e+15, 5.79817661e+15, 5.75048510e+15,
                                      5.70304594e+15, 5.65611144e+15, 5.60942928e+15, 5.56299946e+15,
                                      5.51707430e+15, 5.47140149e+15, 5.42598101e+15, 5.38081286e+15,
                                      5.33614939e+15, 5.29199059e+15, 5.24455142e+15, 5.19105619e+15,
                                      5.13831797e+15, 5.08583208e+15, 5.03410320e+15, 4.98262666e+15,
                                      4.93064544e+15, 4.87916890e+15, 4.82819702e+15, 4.77772982e+15,
                                      4.72801963e+15, 4.67856178e+15, 4.62986093e+15, 4.58166475e+15,
                                      4.53397325e+15, 4.48678642e+15, 4.44010426e+15, 4.39392677e+15,
                                      4.34825395e+15, 4.30308581e+15, 4.25817000e+15, 4.21401120e+15,
                                      4.17035707e+15, 4.12695528e+15, 4.08431050e+15, 4.07118902e+15,
                                      1.63145317e+16, 1.61818030e+16, 1.59776632e+16, 1.57762991e+16,
                                      1.55774583e+16, 1.53811409e+16, 1.52855055e+16, 2.31114542e+16,
                                      2.29830152e+16, 2.26898008e+16, 2.24003714e+16, 2.21147270e+16,
                                      2.18326154e+16, 2.15542888e+16, 2.12794949e+16, 2.10082337e+16,
                                      2.07405052e+16, 2.04763094e+16, 2.02153940e+16, 1.99577589e+16,
                                      1.97036566e+16, 1.94525822e+16, 1.92050406e+16, 1.89605270e+16,
                                      1.87190415e+16, 1.84808363e+16, 1.82456592e+16, 1.80135100e+16,
                                      1.77841366e+16, 1.75580436e+16, 1.73347262e+16, 1.71141845e+16,
                                      1.68966709e+16, 1.66819330e+16, 1.64697184e+16, 1.62600272e+16,
                                      1.60533640e+16, 1.58489718e+16, 1.56473554e+16, 1.54482623e+16,
                                      1.52519448e+16, 1.50578985e+16, 1.48666278e+16, 1.46776281e+16,
                                      1.44911518e+16, 1.43069465e+16, 1.41252646e+16, 1.39458537e+16,
                                      1.37687138e+16, 1.35938450e+16, 1.34212472e+16, 1.32509204e+16,
                                      1.30826123e+16, 1.29165752e+16, 1.27525568e+16, 1.25908094e+16,
                                      1.24315854e+16, 1.24005480e+16, 1.44669276e+16, 1.43738156e+16,
                                      1.41855729e+16, 1.40001060e+16, 1.38169100e+16, 1.36362374e+16,
                                      1.34580882e+16, 1.32824624e+16, 1.31088552e+16, 1.29377714e+16,
                                      1.27689586e+16, 1.26112486e+16, 1.24558096e+16, 1.23028940e+16,
                                      1.21525018e+16, 1.20043805e+16, 1.18585303e+16, 1.17149511e+16,
                                      1.16483344e+16, 1.24103892e+16, 1.23801088e+16, 1.22276979e+16,
                                      1.20773056e+16, 1.19291844e+16, 1.17830819e+16, 1.16395027e+16,
                                      1.14976898e+16, 1.13581480e+16, 1.12206249e+16, 1.10848681e+16,
                                      1.09541581e+16, 1.08264761e+16, 1.07010651e+16, 1.05774204e+16,
                                      1.04555422e+16, 1.03356826e+16, 1.02173370e+16, 1.01010101e+16,
                                      9.98619720e+15, 9.87315067e+15, 9.76161816e+15, 9.65185200e+15,
                                      9.62813242e+15, 1.00205149e+16, 1.00003280e+16, 9.88930018e+15,
                                      9.77978635e+15, 9.67178654e+15, 9.56530075e+15, 9.46007664e+15,
                                      9.35636654e+15, 9.25391813e+15, 9.15273139e+15, 9.05280634e+15,
                                      8.95439530e+15, 8.85749827e+15, 8.76186293e+15, 8.66723693e+15,
                                      8.57109691e+15, 8.47596624e+15, 8.38209725e+15, 8.28948994e+15,
                                      8.19763963e+15, 8.10705101e+15, 8.01747173e+15, 7.92915413e+15,
                                      7.84159354e+15, 7.75504229e+15, 7.66950038e+15, 7.58496782e+15,
                                      7.50144461e+15, 7.41867840e+15, 7.33717387e+15, 7.25617402e+15,
                                      7.17643584e+15, 7.09644533e+15, 7.01695949e+15, 6.93848299e+15,
                                      6.86076350e+15, 6.78380102e+15, 6.70784789e+15, 6.63265176e+15,
                                      6.55846498e+15, 6.48478286e+15, 6.41211010e+15, 6.34019434e+15,
                                      6.26903558e+15, 6.19888618e+15, 6.12924144e+15, 6.06035371e+15,
                                      5.99121365e+15, 5.92232592e+15, 5.85394286e+15, 5.78656915e+15,
                                      5.71995245e+15, 5.65358808e+15, 5.58747605e+15, 5.52186869e+15,
                                      5.45701834e+15, 5.39267266e+15, 5.32933632e+15, 5.26675699e+15,
                                      5.20493467e+15, 5.14361702e+15, 5.08330872e+15, 5.02350509e+15,
                                      4.96445846e+15, 4.90616885e+15, 4.84838390e+15, 4.79160830e+15,
                                      4.73483270e+15, 4.67830944e+15, 4.62279552e+15, 4.56778627e+15,
                                      4.51328170e+15, 4.45953413e+15, 4.40654357e+15, 4.35431002e+15,
                                      4.30258114e+15, 4.25135693e+15, 4.20088973e+15, 4.15117954e+15,
                                      4.10197402e+15, 4.05327317e+15, 4.00532933e+15, 3.95789016e+15,
                                      3.91095566e+15, 3.86477818e+15, 3.81910536e+15, 3.77393722e+15,
                                      3.72952608e+15, 3.68561962e+15, 3.64221782e+15, 3.59932070e+15,
                                      3.55692826e+15, 3.51504048e+15, 3.47390971e+15, 3.43303128e+15,
                                      3.39290986e+15, 3.35304077e+15, 3.31392869e+15, 3.27506894e+15,
                                      3.23671387e+15, 3.19911581e+15, 3.16151774e+15, 3.12417202e+15,
                                      3.08733096e+15, 3.04746187e+15, 3.00809746e+15, 2.96923771e+15,
                                      2.93113498e+15, 2.89328458e+15, 2.85619118e+15, 2.81935013e+15,
                                      2.78326608e+15, 2.74743437e+15, 2.71210733e+15, 2.67753730e+15,
                                      2.64321960e+15, 2.60940658e+15, 2.57584589e+15, 2.54278987e+15,
                                      2.50998619e+15, 2.47756102e+15, 2.44559004e+15, 2.41402281e+15,
                                      2.38290978e+15, 2.35220049e+15, 2.32192017e+15, 2.29204359e+15,
                                      2.26257074e+15, 2.23347640e+15, 2.20481103e+15, 2.17649893e+15,
                                      2.14859057e+15, 2.12106072e+15, 2.09388413e+15, 2.06708604e+15,
                                      2.04064123e+15, 2.01454969e+15, 1.98881142e+15, 1.96342642e+15,
                                      1.93836945e+15, 1.91359006e+15, 1.88906300e+15, 1.86486397e+15,
                                      1.84096776e+15, 1.81742481e+15, 1.79418466e+15, 1.77124732e+15,
                                      1.74863801e+15, 1.72630628e+15, 1.70430258e+15, 1.68257645e+15,
                                      1.66112789e+15, 1.63998213e+15, 1.61911394e+15, 1.59852333e+15,
                                      1.57821028e+15, 1.55817480e+15, 1.53839166e+15, 1.51886085e+15,
                                      1.49960761e+15, 1.48060671e+15, 1.41863299e+15, 1.19746049e+15,
                                      1.01219540e+15, 8.55898478e+14, 7.20671616e+14, 6.07372752e+14,
                                      5.12822453e+14, 4.33513248e+14, 3.76056341e+14, 3.65306827e+14,
                                      3.61723656e+14, 3.58039550e+14, 1.04492338e+15, 9.96550565e+14,
                                      8.85396557e+14, 8.61424637e+14, 8.25895728e+14, 8.16862099e+14,
                                      1.12034661e+15, 1.07366445e+15, 1.02713369e+15, 1.02284398e+15,
                                      9.84135634e+14, 9.73562755e+14, 1.10906719e+15, 1.06874389e+15,
                                      9.96853368e+14, 8.42272334e+14, 7.05380054e+14, 5.90567174e+14,
                                      4.93972954e+14, 4.13402069e+14, 3.46255459e+14, 2.90262101e+14,
                                      2.43024802e+14, 2.03117863e+14, 1.69408297e+14, 1.41121431e+14,
                                      1.17659230e+14, 9.81864610e+13, 8.20092000e+13, 6.85571678e+13,
                                      5.73635429e+13, 4.80321576e+13, 3.99473122e+13, 3.31695672e+13,
                                      2.74995773e+13, 2.27894735e+13, 1.88270413e+13, 1.55446546e+13,
                                      1.28370893e+13, 1.06094671e+13, 8.95086259e+12, 8.77523674e+12,
                                      8.57311560e+12, 8.47596624e+12, 4.79640269e+13, 4.61850581e+13,
                                      4.23722611e+13, 3.55768526e+13, 2.98235918e+13, 2.49878247e+13,
                                      2.09042712e+13, 1.74830998e+13, 1.46218619e+13, 1.22120531e+13,
                                      1.01691408e+13, 8.46890083e+12, 7.04194075e+12, 5.84208307e+12,
                                      4.84712222e+12, 4.02198350e+12, 3.33764827e+12, 2.76989227e+12,
                                      2.29895760e+12, 1.90824053e+12, 1.58406447e+12, 1.31504906e+12,
                                      1.09180740e+12, 9.06542314e+11, 7.55115480e+11, 6.29452152e+11,
                                      5.24732712e+11, 4.37449690e+11, 3.64726454e+11, 3.04090114e+11,
                                      2.53572446e+11, 2.11447475e+11, 1.76329873e+11, 1.47053851e+11,
                                      1.22645389e+11]),
                     'ene': np.array([1.0690000e+01, 1.1427610e+01, 1.2216120e+01, 1.3059030e+01,
                                      1.3960100e+01, 1.4923350e+01, 1.5953060e+01, 1.7053820e+01,
                                      1.8230530e+01, 1.9488440e+01, 2.0833140e+01, 2.1560000e+01,
                                      2.1890000e+01, 2.1978000e+01, 2.2110000e+01, 2.2270630e+01,
                                      2.2440000e+01, 2.3807300e+01, 2.5450010e+01, 2.7206060e+01,
                                      2.9083270e+01, 3.1090020e+01, 3.1164000e+01, 3.1641000e+01,
                                      3.1768200e+01, 3.1959000e+01, 3.2436000e+01, 3.3235230e+01,
                                      3.5528460e+01, 3.7979930e+01, 4.0600540e+01, 4.3401980e+01,
                                      4.6396710e+01, 4.9598090e+01, 5.3020350e+01, 5.6678760e+01,
                                      6.0589590e+01, 6.4770280e+01, 6.9239420e+01, 7.4016950e+01,
                                      7.9124110e+01, 8.4583680e+01, 9.0419950e+01, 9.6658930e+01,
                                      1.0000000e+02, 1.0050000e+02, 1.0100250e+02, 1.0150751e+02,
                                      1.0201505e+02, 1.0252513e+02, 1.0303775e+02, 1.0355294e+02,
                                      1.0407070e+02, 1.0459106e+02, 1.0511401e+02, 1.0563958e+02,
                                      1.0616778e+02, 1.0669862e+02, 1.0723211e+02, 1.0776827e+02,
                                      1.0830712e+02, 1.0884865e+02, 1.0939289e+02, 1.0993986e+02,
                                      1.1048956e+02, 1.1104201e+02, 1.1159722e+02, 1.1215520e+02,
                                      1.1271598e+02, 1.1327956e+02, 1.1384596e+02, 1.1441519e+02,
                                      1.1498726e+02, 1.1556220e+02, 1.1614001e+02, 1.1672071e+02,
                                      1.1730431e+02, 1.1789083e+02, 1.1848029e+02, 1.1907269e+02,
                                      1.1966805e+02, 1.2026639e+02, 1.2086772e+02, 1.2147206e+02,
                                      1.2207942e+02, 1.2268982e+02, 1.2330327e+02, 1.2391979e+02,
                                      1.2453939e+02, 1.2516208e+02, 1.2578789e+02, 1.2641683e+02,
                                      1.2704892e+02, 1.2768416e+02, 1.2832258e+02, 1.2896419e+02,
                                      1.2960902e+02, 1.3025706e+02, 1.3090835e+02, 1.3156289e+02,
                                      1.3222070e+02, 1.3288181e+02, 1.3317243e+02, 1.3322758e+02,
                                      1.3354621e+02, 1.3421395e+02, 1.3488502e+02, 1.3555944e+02,
                                      1.3623724e+02, 1.3691842e+02, 1.3760302e+02, 1.3829103e+02,
                                      1.3898249e+02, 1.3967740e+02, 1.4037579e+02, 1.4107766e+02,
                                      1.4178305e+02, 1.4249197e+02, 1.4320443e+02, 1.4392045e+02,
                                      1.4464005e+02, 1.4536325e+02, 1.4609007e+02, 1.4682052e+02,
                                      1.4755462e+02, 1.4829239e+02, 1.4903386e+02, 1.4977903e+02,
                                      1.5052792e+02, 1.5128056e+02, 1.5203696e+02, 1.5279715e+02,
                                      1.5356113e+02, 1.5432894e+02, 1.5510058e+02, 1.5587609e+02,
                                      1.5665547e+02, 1.5743875e+02, 1.5822594e+02, 1.5901707e+02,
                                      1.5981215e+02, 1.6061121e+02, 1.6141427e+02, 1.6222134e+02,
                                      1.6303245e+02, 1.6384761e+02, 1.6466685e+02, 1.6549018e+02,
                                      1.6631763e+02, 1.6714922e+02, 1.6798497e+02, 1.6882489e+02,
                                      1.6966902e+02, 1.7051736e+02, 1.7136995e+02, 1.7222680e+02,
                                      1.7308793e+02, 1.7395337e+02, 1.7482314e+02, 1.7569726e+02,
                                      1.7657574e+02, 1.7745862e+02, 1.7834591e+02, 1.7923764e+02,
                                      1.8013383e+02, 1.8103450e+02, 1.8193967e+02, 1.8284937e+02,
                                      1.8376362e+02, 1.8468244e+02, 1.8560585e+02, 1.8653388e+02,
                                      1.8746655e+02, 1.8840388e+02, 1.8934590e+02, 1.9029263e+02,
                                      1.9124409e+02, 1.9220031e+02, 1.9316131e+02, 1.9412712e+02,
                                      1.9509776e+02, 1.9607325e+02, 1.9705361e+02, 1.9803888e+02,
                                      1.9902907e+02, 2.0002422e+02, 2.0102434e+02, 2.0202946e+02,
                                      2.0303961e+02, 2.0405481e+02, 2.0507508e+02, 2.0610046e+02,
                                      2.0713096e+02, 2.0816661e+02, 2.0920745e+02, 2.1025348e+02,
                                      2.1130475e+02, 2.1236128e+02, 2.1342308e+02, 2.1449020e+02,
                                      2.1556265e+02, 2.1664046e+02, 2.1772366e+02, 2.1881228e+02,
                                      2.1990634e+02, 2.2100588e+02, 2.2211090e+02, 2.2322146e+02,
                                      2.2433757e+02, 2.2545925e+02, 2.2658655e+02, 2.2771948e+02,
                                      2.2885808e+02, 2.3000237e+02, 2.3115238e+02, 2.3230814e+02,
                                      2.3346969e+02, 2.3463703e+02, 2.3581022e+02, 2.3698927e+02,
                                      2.3817422e+02, 2.3936509e+02, 2.4056191e+02, 2.4176472e+02,
                                      2.4297355e+02, 2.4418841e+02, 2.4540936e+02, 2.4663640e+02,
                                      2.4786959e+02, 2.4910893e+02, 2.5035448e+02, 2.5160625e+02,
                                      2.5286428e+02, 2.5412860e+02, 2.5539925e+02, 2.5641678e+02,
                                      2.5667624e+02, 2.5678320e+02, 2.5795962e+02, 2.5924942e+02,
                                      2.6054567e+02, 2.6184840e+02, 2.6315764e+02, 2.6447343e+02,
                                      2.6579579e+02, 2.6712477e+02, 2.6846040e+02, 2.6980270e+02,
                                      2.7115171e+02, 2.7250747e+02, 2.7387001e+02, 2.7523936e+02,
                                      2.7661556e+02, 2.7799863e+02, 2.7938863e+02, 2.8078557e+02,
                                      2.8218950e+02, 2.8360044e+02, 2.8366578e+02, 2.8413421e+02,
                                      2.8501845e+02, 2.8644354e+02, 2.8787576e+02, 2.8931514e+02,
                                      2.9076171e+02, 2.9221552e+02, 2.9367660e+02, 2.9514498e+02,
                                      2.9662071e+02, 2.9810381e+02, 2.9959433e+02, 3.0109230e+02,
                                      3.0259776e+02, 3.0411075e+02, 3.0563130e+02, 3.0715946e+02,
                                      3.0869526e+02, 3.1023873e+02, 3.1178993e+02, 3.1334888e+02,
                                      3.1491562e+02, 3.1649020e+02, 3.1807265e+02, 3.1966301e+02,
                                      3.2126133e+02, 3.2286764e+02, 3.2448197e+02, 3.2610438e+02,
                                      3.2773491e+02, 3.2937358e+02, 3.3102045e+02, 3.3267555e+02,
                                      3.3433893e+02, 3.3601062e+02, 3.3769068e+02, 3.3937913e+02,
                                      3.4107602e+02, 3.4278140e+02, 3.4449531e+02, 3.4621779e+02,
                                      3.4794888e+02, 3.4968862e+02, 3.5143706e+02, 3.5319425e+02,
                                      3.5496022e+02, 3.5673502e+02, 3.5851870e+02, 3.5978936e+02,
                                      3.6031129e+02, 3.6061062e+02, 3.6211285e+02, 3.6392341e+02,
                                      3.6574303e+02, 3.6757174e+02, 3.6940960e+02, 3.7125665e+02,
                                      3.7311293e+02, 3.7497850e+02, 3.7685339e+02, 3.7873766e+02,
                                      3.8063135e+02, 3.8253450e+02, 3.8444718e+02, 3.8636941e+02,
                                      3.8830126e+02, 3.9024276e+02, 3.9219398e+02, 3.9415495e+02,
                                      3.9612572e+02, 3.9810635e+02, 4.0009688e+02, 4.0209737e+02,
                                      4.0410785e+02, 4.0612839e+02, 4.0815904e+02, 4.1019983e+02,
                                      4.1225083e+02, 4.1431208e+02, 4.1638364e+02, 4.1846556e+02,
                                      4.2055789e+02, 4.2266068e+02, 4.2477398e+02, 4.2689785e+02,
                                      4.2903234e+02, 4.3117750e+02, 4.3333339e+02, 4.3550006e+02,
                                      4.3767756e+02, 4.3986595e+02, 4.4206528e+02, 4.4427560e+02,
                                      4.4649698e+02, 4.4872947e+02, 4.5097311e+02, 4.5322798e+02,
                                      4.5549412e+02, 4.5777159e+02, 4.6006045e+02, 4.6236075e+02,
                                      4.6467255e+02, 4.6699592e+02, 4.6933090e+02, 4.7167755e+02,
                                      4.7403594e+02, 4.7640612e+02, 4.7878815e+02, 4.8118209e+02,
                                      4.8358800e+02, 4.8600594e+02, 4.8843597e+02, 4.9087815e+02,
                                      4.9333254e+02, 4.9579920e+02, 4.9827820e+02, 5.0076959e+02,
                                      5.0327344e+02, 5.0578980e+02, 5.0831875e+02, 5.1086035e+02,
                                      5.1341465e+02, 5.1598172e+02, 5.1856163e+02, 5.2115444e+02,
                                      5.2376021e+02, 5.2637901e+02, 5.2901091e+02, 5.3165596e+02,
                                      5.3431424e+02, 5.3698581e+02, 5.3967074e+02, 5.4236910e+02,
                                      5.4508094e+02, 5.4780635e+02, 5.5054538e+02, 5.5329810e+02,
                                      5.5606460e+02, 5.5884492e+02, 5.6163914e+02, 5.6444734e+02,
                                      5.6726958e+02, 5.7010592e+02, 5.7295645e+02, 5.7582123e+02,
                                      5.7870034e+02, 5.8159384e+02, 5.8450181e+02, 5.8742432e+02,
                                      5.9036144e+02, 5.9331325e+02, 5.9627982e+02, 5.9926122e+02,
                                      6.0225752e+02, 6.0526881e+02, 6.0829515e+02, 6.1133663e+02,
                                      6.1439331e+02, 6.1746528e+02, 6.2055260e+02, 6.2365537e+02,
                                      6.2677364e+02, 6.2990751e+02, 6.3305705e+02, 6.3622234e+02,
                                      6.3940345e+02, 6.4260046e+02, 6.4581347e+02, 6.4904253e+02,
                                      6.5228775e+02, 6.5554919e+02, 6.5882693e+02, 6.6212107e+02,
                                      6.6543167e+02, 6.6875883e+02, 6.7210262e+02, 6.7546314e+02,
                                      6.7884045e+02, 6.8223466e+02, 6.8564583e+02, 6.8907406e+02,
                                      6.9251943e+02, 6.9598202e+02, 6.9946194e+02, 7.0295924e+02,
                                      7.0647404e+02, 7.1000641e+02, 7.1355644e+02, 7.1712423e+02,
                                      7.2070985e+02, 7.2431340e+02, 7.2793496e+02, 7.3157464e+02,
                                      7.3523251e+02, 7.3890867e+02, 7.4260322e+02, 7.4631623e+02,
                                      7.5004781e+02, 7.5379805e+02, 7.5756704e+02, 7.6135488e+02,
                                      7.6516165e+02, 7.6898746e+02, 7.7283240e+02, 7.7669656e+02,
                                      7.8058004e+02, 7.8448294e+02, 7.8840536e+02, 7.9234738e+02,
                                      7.9630912e+02, 8.0029067e+02, 8.0429212e+02, 8.0831358e+02,
                                      8.1235515e+02, 8.1641693e+02, 8.2049901e+02, 8.2460150e+02,
                                      8.2872451e+02, 8.3286813e+02, 8.3703248e+02, 8.4121764e+02,
                                      8.4542373e+02, 8.4965084e+02, 8.5389910e+02, 8.5816859e+02,
                                      8.6245944e+02, 8.6677173e+02, 8.7110559e+02, 8.7546112e+02,
                                      8.7983843e+02, 8.8423762e+02, 8.8865881e+02, 8.9310210e+02,
                                      8.9756761e+02, 9.0205545e+02, 9.0656573e+02, 9.1109856e+02,
                                      9.1565405e+02, 9.2023232e+02, 9.2483348e+02, 9.2945765e+02,
                                      9.3410494e+02, 9.3877546e+02, 9.4346934e+02, 9.4818668e+02,
                                      9.5292762e+02, 9.5769226e+02, 9.6248072e+02, 9.6729312e+02,
                                      9.7212959e+02, 9.7699023e+02, 9.8187519e+02, 9.8678456e+02,
                                      9.9171848e+02, 9.9667708e+02, 1.0016605e+03, 1.0066688e+03,
                                      1.0117021e+03, 1.0167606e+03, 1.0218444e+03, 1.0269536e+03,
                                      1.0320884e+03, 1.0372489e+03, 1.0424351e+03, 1.0476473e+03,
                                      1.0528855e+03, 1.0581499e+03, 1.0634407e+03, 1.0687579e+03,
                                      1.0741017e+03, 1.0794722e+03, 1.0848695e+03, 1.0902939e+03,
                                      1.0957454e+03, 1.1012241e+03, 1.1067302e+03, 1.1122639e+03,
                                      1.1178252e+03, 1.1234143e+03, 1.1290314e+03, 1.1307711e+03,
                                      1.1310289e+03, 1.1346765e+03, 1.1403499e+03, 1.1460517e+03,
                                      1.1517819e+03, 1.1575408e+03, 1.1603841e+03, 1.1608158e+03,
                                      1.1633285e+03, 1.1691452e+03, 1.1749909e+03, 1.1808659e+03,
                                      1.1867702e+03, 1.1927040e+03, 1.1986676e+03, 1.2046609e+03,
                                      1.2106842e+03, 1.2167376e+03, 1.2228213e+03, 1.2289354e+03,
                                      1.2350801e+03, 1.2412555e+03, 1.2474618e+03, 1.2536991e+03,
                                      1.2599676e+03, 1.2662674e+03, 1.2725988e+03, 1.2789618e+03,
                                      1.2853566e+03, 1.2917833e+03, 1.2982423e+03, 1.3047335e+03,
                                      1.3112571e+03, 1.3178134e+03, 1.3244025e+03, 1.3310245e+03,
                                      1.3376796e+03, 1.3443680e+03, 1.3510899e+03, 1.3578453e+03,
                                      1.3646345e+03, 1.3714577e+03, 1.3783150e+03, 1.3852066e+03,
                                      1.3921326e+03, 1.3990933e+03, 1.4060887e+03, 1.4131192e+03,
                                      1.4201848e+03, 1.4272857e+03, 1.4344221e+03, 1.4415942e+03,
                                      1.4488022e+03, 1.4560462e+03, 1.4633265e+03, 1.4706431e+03,
                                      1.4779963e+03, 1.4794437e+03, 1.4817563e+03, 1.4853863e+03,
                                      1.4928132e+03, 1.5002773e+03, 1.5077787e+03, 1.5153176e+03,
                                      1.5228942e+03, 1.5305086e+03, 1.5381612e+03, 1.5458520e+03,
                                      1.5535812e+03, 1.5613491e+03, 1.5691559e+03, 1.5770017e+03,
                                      1.5848867e+03, 1.5928111e+03, 1.6007752e+03, 1.6087790e+03,
                                      1.6125491e+03, 1.6152508e+03, 1.6168229e+03, 1.6249070e+03,
                                      1.6330316e+03, 1.6411967e+03, 1.6494027e+03, 1.6576497e+03,
                                      1.6659380e+03, 1.6742677e+03, 1.6826390e+03, 1.6910522e+03,
                                      1.6995075e+03, 1.7080050e+03, 1.7165450e+03, 1.7251278e+03,
                                      1.7337534e+03, 1.7424222e+03, 1.7511343e+03, 1.7598899e+03,
                                      1.7686894e+03, 1.7775328e+03, 1.7864205e+03, 1.7953526e+03,
                                      1.7973000e+03, 1.8027000e+03, 1.8043294e+03, 1.8133510e+03,
                                      1.8224178e+03, 1.8315299e+03, 1.8406875e+03, 1.8498909e+03,
                                      1.8591404e+03, 1.8684361e+03, 1.8777783e+03, 1.8871672e+03,
                                      1.8966030e+03, 1.9060860e+03, 1.9156165e+03, 1.9251945e+03,
                                      1.9348205e+03, 1.9444946e+03, 1.9542171e+03, 1.9639882e+03,
                                      1.9738081e+03, 1.9836772e+03, 1.9935955e+03, 2.0035635e+03,
                                      2.0135813e+03, 2.0236492e+03, 2.0337675e+03, 2.0439363e+03,
                                      2.0541560e+03, 2.0644268e+03, 2.0747489e+03, 2.0851227e+03,
                                      2.0955483e+03, 2.1060260e+03, 2.1165562e+03, 2.1271389e+03,
                                      2.1377746e+03, 2.1484635e+03, 2.1592058e+03, 2.1700018e+03,
                                      2.1808519e+03, 2.1917561e+03, 2.2027149e+03, 2.2137285e+03,
                                      2.2247971e+03, 2.2359211e+03, 2.2471007e+03, 2.2583362e+03,
                                      2.2696279e+03, 2.2809760e+03, 2.2923809e+03, 2.3038428e+03,
                                      2.3153620e+03, 2.3269388e+03, 2.3385735e+03, 2.3502664e+03,
                                      2.3620177e+03, 2.3738278e+03, 2.3856970e+03, 2.3976254e+03,
                                      2.4096136e+03, 2.4216616e+03, 2.4337699e+03, 2.4459388e+03,
                                      2.4581685e+03, 2.4704593e+03, 2.4828116e+03, 2.4952257e+03,
                                      2.5077018e+03, 2.5202403e+03, 2.5328415e+03, 2.5455057e+03,
                                      2.5582333e+03, 2.5710244e+03, 2.5838796e+03, 2.5967990e+03,
                                      2.6097829e+03, 2.6228319e+03, 2.6359460e+03, 2.6491257e+03,
                                      2.6623714e+03, 2.6756832e+03, 2.6890617e+03, 2.7025070e+03,
                                      2.7160195e+03, 2.7295996e+03, 2.7432476e+03, 2.7569638e+03,
                                      2.7707486e+03, 2.7846024e+03, 2.7985254e+03, 2.8125180e+03,
                                      2.8265806e+03, 2.8407135e+03, 2.8549171e+03, 2.8691917e+03,
                                      2.8835376e+03, 2.8979553e+03, 2.9124451e+03, 2.9270073e+03,
                                      2.9416424e+03, 2.9563506e+03, 2.9711323e+03, 2.9859880e+03,
                                      3.0009179e+03, 3.0159225e+03, 3.0310021e+03, 3.0461571e+03,
                                      3.0613879e+03, 3.0766949e+03, 3.0920783e+03, 3.1075387e+03,
                                      3.1230764e+03, 3.1386918e+03, 3.1543853e+03, 3.1701572e+03,
                                      3.1860080e+03, 3.2019380e+03, 3.2179477e+03, 3.2340374e+03,
                                      3.2502076e+03, 3.2664587e+03, 3.2827910e+03, 3.2992049e+03,
                                      3.3157009e+03, 3.3322794e+03, 3.3489408e+03, 3.3656856e+03,
                                      3.3825140e+03, 3.3994265e+03, 3.4164237e+03, 3.4335058e+03,
                                      3.4506733e+03, 3.4679267e+03, 3.4852663e+03, 3.5026927e+03,
                                      3.5202061e+03, 3.5378072e+03, 3.5554962e+03, 3.5732737e+03,
                                      3.5911400e+03, 3.6090957e+03, 3.6271412e+03, 3.6452769e+03,
                                      3.6635033e+03, 3.6818208e+03, 3.7002299e+03, 3.7187311e+03,
                                      3.7373247e+03, 3.7560114e+03, 3.7747914e+03, 3.7936654e+03,
                                      3.8126337e+03, 3.8316969e+03, 3.8508554e+03, 3.8701096e+03,
                                      3.8894602e+03, 3.9089075e+03, 3.9284520e+03, 3.9480943e+03,
                                      3.9678347e+03, 3.9876739e+03, 4.0550240e+03, 4.3348210e+03,
                                      4.6339240e+03, 4.9536640e+03, 5.2954670e+03, 5.6608550e+03,
                                      6.0514530e+03, 6.4690040e+03, 6.8373620e+03, 6.9153650e+03,
                                      6.9420160e+03, 6.9699230e+03, 7.0117850e+03, 7.1164380e+03,
                                      7.3925250e+03, 7.4647580e+03, 7.5790140e+03, 7.6094830e+03,
                                      7.6551850e+03, 7.7694420e+03, 7.8909600e+03, 7.9026090e+03,
                                      8.0117400e+03, 8.0439480e+03, 8.0922600e+03, 8.2130400e+03,
                                      8.4478900e+03, 9.0307940e+03, 9.6539190e+03, 1.0320040e+04,
                                      1.1032120e+04, 1.1793340e+04, 1.2607080e+04, 1.3476970e+04,
                                      1.4406880e+04, 1.5400950e+04, 1.6463620e+04, 1.7599610e+04,
                                      1.8813980e+04, 2.0112150e+04, 2.1499880e+04, 2.2983380e+04,
                                      2.4569230e+04, 2.6264500e+04, 2.8076760e+04, 3.0014050e+04,
                                      3.2085020e+04, 3.4298890e+04, 3.6665510e+04, 3.9195430e+04,
                                      4.1899920e+04, 4.4791010e+04, 4.7548620e+04, 4.7881590e+04,
                                      4.8276410e+04, 4.8470480e+04, 4.8761600e+04, 4.9489380e+04,
                                      5.1185420e+04, 5.4717210e+04, 5.8492700e+04, 6.2528700e+04,
                                      6.6843180e+04, 7.1455360e+04, 7.6385780e+04, 8.1656400e+04,
                                      8.7290690e+04, 9.3313740e+04, 9.9752390e+04, 1.0663530e+05,
                                      1.1399310e+05, 1.2185870e+05, 1.3026690e+05, 1.3925530e+05,
                                      1.4886400e+05, 1.5913560e+05, 1.7011590e+05, 1.8185390e+05,
                                      1.9440180e+05, 2.0781560e+05, 2.2215480e+05, 2.3748350e+05,
                                      2.5386990e+05, 2.7138690e+05, 2.9011260e+05, 3.1013040e+05,
                                      3.3152940e+05, 3.5440490e+05, 3.7885880e+05, 4.0500010e+05,
                                      4.3294510e+05]), },
              '64': {'name': 'Gd',
                     'barns': 2611200000000.0,
                     'NumEdges': 19,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 20.299999999999997,
                            'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 20.299999999999997,
                            'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 36.1, 'factor': 1.0},
                     'N7': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8.524189999999999,
                            'factor': 1.0, 'twin': 'N6'},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9.2794, 'factor': 0.75},
                     'N5': {'filename': 'Gd.N5', 'excl before': 5, 'excl after': 50, 'onset': 140.5, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 140.5,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 270.9, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 288.5, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 375.8, 'factor': 1.0},
                     'M5': {'filename': 'Gd.M5', 'excl before': 5, 'excl after': 50, 'onset': 1185.2, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1217.2,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Gd.M3', 'excl before': 5, 'excl after': 50, 'onset': 1544.0, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1688.3, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1880.8, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7242.8, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7930.3, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8375.6, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 50239.1, 'factor': 1.0},
                     'dat': np.array([1.60416461e+15, 1.55303731e+15, 1.40790682e+15, 1.36194970e+15,
                                      1.35004262e+15, 1.00319693e+16, 9.71183616e+15, 7.60955904e+15,
                                      7.02569472e+15, 6.76300800e+15, 6.74394624e+15, 6.92620800e+15,
                                      7.28968704e+15, 7.82628864e+15, 8.53705728e+15, 9.42825984e+15,
                                      1.05092966e+16, 1.08829594e+16, 1.11709747e+16, 1.12487885e+16,
                                      3.74942208e+17, 3.61442304e+17, 3.56011008e+17, 3.02429184e+17,
                                      2.54686003e+17, 2.10768230e+17, 1.73054669e+17, 1.42286899e+17,
                                      1.18180301e+17, 9.99254016e+16, 8.72636928e+16, 8.65377792e+16,
                                      8.47360512e+16, 8.41015296e+16, 8.38064640e+16, 8.16600576e+16,
                                      7.76988672e+16, 7.12126464e+16, 6.69015552e+16, 6.40605696e+16,
                                      6.22562304e+16, 6.11203584e+16, 6.03735552e+16, 5.98199808e+16,
                                      5.93107968e+16, 5.87546112e+16, 5.80861440e+16, 5.72766720e+16,
                                      5.63131392e+16, 5.52033792e+16, 5.39526144e+16, 5.32684800e+16,
                                      5.31640320e+16, 5.30595840e+16, 5.29577472e+16, 5.28506880e+16,
                                      5.27462400e+16, 5.26417920e+16, 5.25347328e+16, 5.24276736e+16,
                                      5.23206144e+16, 5.22109440e+16, 5.21038848e+16, 5.19942144e+16,
                                      5.18845440e+16, 5.17748736e+16, 5.16625920e+16, 5.15529216e+16,
                                      5.14406400e+16, 5.13283584e+16, 5.12160768e+16, 5.11037952e+16,
                                      5.09889024e+16, 5.08766208e+16, 5.07617280e+16, 5.06468352e+16,
                                      5.05319424e+16, 5.04170496e+16, 5.03021568e+16, 5.01846528e+16,
                                      5.00697600e+16, 4.99522560e+16, 4.98347520e+16, 4.97172480e+16,
                                      4.95997440e+16, 4.94822400e+16, 4.93647360e+16, 4.92472320e+16,
                                      4.91271168e+16, 4.90096128e+16, 4.88894976e+16, 4.87693824e+16,
                                      4.86492672e+16, 4.85317632e+16, 4.84116480e+16, 4.82889216e+16,
                                      4.81688064e+16, 4.80486912e+16, 4.79285760e+16, 4.78084608e+16,
                                      4.76857344e+16, 4.75656192e+16, 4.74428928e+16, 4.73227776e+16,
                                      4.72000512e+16, 4.70773248e+16, 4.69572096e+16, 4.68344832e+16,
                                      4.67117568e+16, 4.65916416e+16, 4.64689152e+16, 4.63461888e+16,
                                      4.62234624e+16, 4.61007360e+16, 4.59806208e+16, 4.58578944e+16,
                                      4.57351680e+16, 4.56124416e+16, 4.54897152e+16, 4.53669888e+16,
                                      4.53513216e+16, 9.34026240e+16, 9.13998336e+16, 8.89139712e+16,
                                      8.65508352e+16, 8.42999808e+16, 8.21587968e+16, 8.01220608e+16,
                                      7.81845504e+16, 7.63384320e+16, 7.45810944e+16, 7.29073152e+16,
                                      7.13118720e+16, 6.97947648e+16, 6.83455488e+16, 6.69668352e+16,
                                      6.56534016e+16, 6.44000256e+16, 6.32040960e+16, 6.20656128e+16,
                                      6.09767424e+16, 5.99427072e+16, 5.89739520e+16, 5.80678656e+16,
                                      5.72166144e+16, 5.64201984e+16, 5.56707840e+16, 5.49657600e+16,
                                      5.42842368e+16, 5.36288256e+16, 5.30073600e+16, 5.24198400e+16,
                                      5.18610432e+16, 5.13283584e+16, 5.08217856e+16, 5.03387136e+16,
                                      4.98765312e+16, 4.94326272e+16, 4.90096128e+16, 4.86022656e+16,
                                      4.82131968e+16, 4.78371840e+16, 4.74768384e+16, 4.71295488e+16,
                                      4.67953152e+16, 4.63696896e+16, 4.59022848e+16, 4.54453248e+16,
                                      4.49988096e+16, 4.45627392e+16, 4.41345024e+16, 4.37167104e+16,
                                      4.33067520e+16, 4.29046272e+16, 4.25103360e+16, 4.21212672e+16,
                                      4.17400320e+16, 4.13666304e+16, 4.09984512e+16, 4.06354944e+16,
                                      4.02803712e+16, 3.99278592e+16, 3.95831808e+16, 3.92411136e+16,
                                      3.89068800e+16, 3.85752576e+16, 3.82488576e+16, 3.79276800e+16,
                                      3.76117248e+16, 3.72983808e+16, 3.69876480e+16, 3.66821376e+16,
                                      3.63818496e+16, 3.60841728e+16, 3.57891072e+16, 3.54992640e+16,
                                      3.52120320e+16, 3.49300224e+16, 3.46506240e+16, 3.43738368e+16,
                                      3.40996608e+16, 3.38280960e+16, 3.35617536e+16, 3.32954112e+16,
                                      3.30342912e+16, 3.27757824e+16, 3.25198848e+16, 3.22665984e+16,
                                      3.20185344e+16, 3.17704704e+16, 3.15250176e+16, 3.12847872e+16,
                                      3.10445568e+16, 3.08069376e+16, 3.05745408e+16, 3.03421440e+16,
                                      3.01123584e+16, 2.98851840e+16, 2.96632320e+16, 2.94412800e+16,
                                      2.92219392e+16, 2.90025984e+16, 2.87884800e+16, 2.85769728e+16,
                                      2.83680768e+16, 2.81591808e+16, 2.79528960e+16, 2.77518336e+16,
                                      2.75507712e+16, 2.73497088e+16, 2.71538688e+16, 2.69606400e+16,
                                      2.67674112e+16, 2.65767936e+16, 2.63887872e+16, 2.62033920e+16,
                                      2.60195635e+16, 2.58378240e+16, 2.56579123e+16, 2.54803507e+16,
                                      2.53046170e+16, 2.51307110e+16, 2.49588941e+16, 2.47891661e+16,
                                      2.46212659e+16, 2.44551936e+16, 2.42912102e+16, 2.41287936e+16,
                                      2.39684659e+16, 2.38099661e+16, 2.36532941e+16, 2.34984499e+16,
                                      2.33454336e+16, 2.32462080e+16, 2.61590016e+16, 2.61537792e+16,
                                      2.59991962e+16, 2.58467021e+16, 2.56957747e+16, 2.55466752e+16,
                                      2.53991424e+16, 2.52531763e+16, 2.51090381e+16, 2.49664666e+16,
                                      2.48257229e+16, 2.46862848e+16, 2.45486746e+16, 2.44123699e+16,
                                      2.43784243e+16, 2.51670067e+16, 2.51153050e+16, 2.49818726e+16,
                                      2.48500070e+16, 2.47194470e+16, 2.45904538e+16, 2.44627661e+16,
                                      2.43366451e+16, 2.42118298e+16, 2.40883200e+16, 2.39661158e+16,
                                      2.38452173e+16, 2.37256243e+16, 2.36070758e+16, 2.34898330e+16,
                                      2.33738957e+16, 2.32590029e+16, 2.31451546e+16, 2.30326118e+16,
                                      2.29211136e+16, 2.28109210e+16, 2.27015117e+16, 2.25931469e+16,
                                      2.24858266e+16, 2.23795507e+16, 2.22743194e+16, 2.21698714e+16,
                                      2.20664678e+16, 2.19641088e+16, 2.18622720e+16, 2.17617408e+16,
                                      2.16617318e+16, 2.15625062e+16, 2.14643251e+16, 2.13666662e+16,
                                      2.12700518e+16, 2.11739597e+16, 2.10786509e+16, 2.09841254e+16,
                                      2.08901222e+16, 2.07969024e+16, 2.07044659e+16, 2.06122906e+16,
                                      2.05208986e+16, 2.04300288e+16, 2.03399424e+16, 2.02501171e+16,
                                      2.01610752e+16, 2.00722944e+16, 1.99840358e+16, 1.98962995e+16,
                                      1.98090854e+16, 1.97221325e+16, 1.96357018e+16, 1.96187290e+16,
                                      2.05671168e+16, 2.05386547e+16, 2.04501350e+16, 2.03618765e+16,
                                      2.02738790e+16, 2.01861427e+16, 2.00989286e+16, 2.00119757e+16,
                                      1.99252838e+16, 1.98388531e+16, 1.97526835e+16, 1.96670362e+16,
                                      1.95813888e+16, 1.94960026e+16, 1.94106163e+16, 1.93257523e+16,
                                      1.92408883e+16, 1.91562854e+16, 1.90719437e+16, 1.89876019e+16,
                                      1.89035213e+16, 1.88194406e+16, 1.87356211e+16, 1.86518016e+16,
                                      1.85679821e+16, 1.84844237e+16, 1.84006042e+16, 1.83170458e+16,
                                      1.82334874e+16, 1.81501901e+16, 1.80666317e+16, 1.79830733e+16,
                                      1.78997760e+16, 1.78162176e+16, 1.77329203e+16, 1.76493619e+16,
                                      1.75660646e+16, 1.74825062e+16, 1.73989478e+16, 1.73156506e+16,
                                      1.72320922e+16, 1.71485338e+16, 1.70649754e+16, 1.69814170e+16,
                                      1.68978586e+16, 1.68143002e+16, 1.67307418e+16, 1.66469222e+16,
                                      1.65633638e+16, 1.64795443e+16, 1.63957248e+16, 1.63119053e+16,
                                      1.62280858e+16, 1.61442662e+16, 1.60601856e+16, 1.59763661e+16,
                                      1.58922854e+16, 1.58082048e+16, 1.57243853e+16, 1.56403046e+16,
                                      1.55562240e+16, 1.54718822e+16, 1.53878016e+16, 1.53037210e+16,
                                      1.52196403e+16, 1.51352986e+16, 1.50512179e+16, 1.49668762e+16,
                                      1.48827955e+16, 1.47984538e+16, 1.47143731e+16, 1.46302925e+16,
                                      1.45459507e+16, 1.44618701e+16, 1.43777894e+16, 1.42937088e+16,
                                      1.42096282e+16, 1.41255475e+16, 1.40417280e+16, 1.39576474e+16,
                                      1.38738278e+16, 1.37900083e+16, 1.37061888e+16, 1.36223693e+16,
                                      1.35385498e+16, 1.34544691e+16, 1.33706496e+16, 1.32868301e+16,
                                      1.32027494e+16, 1.31189299e+16, 1.30351104e+16, 1.29512909e+16,
                                      1.28674714e+16, 1.27836518e+16, 1.27000934e+16, 1.26165350e+16,
                                      1.25332378e+16, 1.24496794e+16, 1.23663821e+16, 1.22833459e+16,
                                      1.22003098e+16, 1.21175347e+16, 1.20347597e+16, 1.19522458e+16,
                                      1.18697318e+16, 1.17874790e+16, 1.17054874e+16, 1.16234957e+16,
                                      1.15420262e+16, 1.14605568e+16, 1.13793485e+16, 1.12981402e+16,
                                      1.12174541e+16, 1.11370291e+16, 1.10566042e+16, 1.09764403e+16,
                                      1.08967987e+16, 1.08171571e+16, 1.07380378e+16, 1.06589184e+16,
                                      1.05803213e+16, 1.05017242e+16, 1.04236493e+16, 1.03458355e+16,
                                      1.02682829e+16, 1.01909914e+16, 1.01142221e+16, 1.00377139e+16,
                                      9.96146688e+15, 9.88548096e+15, 9.81001728e+15, 9.73481472e+15,
                                      9.65987328e+15, 9.58545408e+15, 9.51129600e+15, 9.43766016e+15,
                                      9.36428544e+15, 9.29117184e+15, 9.21858048e+15, 9.14625024e+15,
                                      9.07444224e+15, 9.00289536e+15, 8.93187072e+15, 8.86110720e+15,
                                      8.79060480e+15, 8.72088576e+15, 8.65116672e+15, 8.58223104e+15,
                                      8.51329536e+15, 8.44514304e+15, 8.37725184e+15, 8.30962176e+15,
                                      8.24251392e+15, 8.17592832e+15, 8.10960384e+15, 8.04380160e+15,
                                      7.97826048e+15, 7.91324160e+15, 7.84874496e+15, 7.78450944e+15,
                                      7.72079616e+15, 7.65734400e+15, 7.59441408e+15, 7.53200640e+15,
                                      7.46985984e+15, 7.40823552e+15, 7.34687232e+15, 7.28603136e+15,
                                      7.22571264e+15, 7.16565504e+15, 7.10611968e+15, 7.04710656e+15,
                                      6.98835456e+15, 6.93012480e+15, 6.87215616e+15, 6.81470976e+15,
                                      6.75752448e+15, 6.70112256e+15, 6.64472064e+15, 6.58910208e+15,
                                      6.53348352e+15, 6.47864832e+15, 6.42407424e+15, 6.37002240e+15,
                                      6.31623168e+15, 6.26296320e+15, 6.20995584e+15, 6.15747072e+15,
                                      6.10524672e+15, 6.05354496e+15, 6.00210432e+15, 5.95118592e+15,
                                      5.90078976e+15, 5.85065472e+15, 5.80104192e+15, 5.75169024e+15,
                                      5.70259968e+15, 5.65037568e+15, 5.59110144e+15, 5.53234944e+15,
                                      5.47438080e+15, 5.41693440e+15, 5.36001024e+15, 5.30386944e+15,
                                      5.24851200e+15, 5.19367680e+15, 5.13936384e+15, 5.08557312e+15,
                                      5.03256576e+15, 4.97981952e+15, 4.92811776e+15, 4.87667712e+15,
                                      4.82575872e+15, 4.77536256e+15, 4.72444416e+15, 4.67404800e+15,
                                      4.62443520e+15, 4.57508352e+15, 4.52651520e+15, 4.47846912e+15,
                                      4.43094528e+15, 4.38394368e+15, 4.33746432e+15, 4.29150720e+15,
                                      4.24607232e+15, 4.20115968e+15, 4.15624704e+15, 4.11185664e+15,
                                      4.06798848e+15, 4.02438144e+15, 3.98155776e+15, 3.95126784e+15,
                                      1.52682086e+16, 1.52225126e+16, 1.50345062e+16, 1.48488499e+16,
                                      1.46655437e+16, 1.44845875e+16, 1.43057203e+16, 1.42991923e+16,
                                      2.15275162e+16, 2.12901581e+16, 2.10251213e+16, 2.07632179e+16,
                                      2.05047091e+16, 2.02495949e+16, 1.99976141e+16, 1.97487667e+16,
                                      1.95030528e+16, 1.92602112e+16, 1.90207642e+16, 1.87841894e+16,
                                      1.85504870e+16, 1.83199181e+16, 1.80922214e+16, 1.78673971e+16,
                                      1.76451840e+16, 1.74261043e+16, 1.72096358e+16, 1.69957786e+16,
                                      1.67847936e+16, 1.65761587e+16, 1.63703962e+16, 1.61672448e+16,
                                      1.59664435e+16, 1.57685146e+16, 1.55726746e+16, 1.53794458e+16,
                                      1.51888282e+16, 1.50002995e+16, 1.48143821e+16, 1.46305536e+16,
                                      1.44493363e+16, 1.42702080e+16, 1.40934298e+16, 1.39187405e+16,
                                      1.37464013e+16, 1.35758899e+16, 1.34079898e+16, 1.32419174e+16,
                                      1.30779341e+16, 1.29160397e+16, 1.27562342e+16, 1.25982566e+16,
                                      1.24421069e+16, 1.22880461e+16, 1.21360742e+16, 1.19856691e+16,
                                      1.18974106e+16, 1.39015066e+16, 1.38881894e+16, 1.37072333e+16,
                                      1.35283661e+16, 1.33521101e+16, 1.31779430e+16, 1.30058650e+16,
                                      1.28353536e+16, 1.26671923e+16, 1.25011200e+16, 1.23373978e+16,
                                      1.21812480e+16, 1.20308429e+16, 1.18827878e+16, 1.17373440e+16,
                                      1.15939891e+16, 1.14527232e+16, 1.13138074e+16, 1.11769805e+16,
                                      1.11098726e+16, 1.18399642e+16, 1.18180301e+16, 1.16720640e+16,
                                      1.15284480e+16, 1.13869210e+16, 1.12472218e+16, 1.11098726e+16,
                                      1.09743514e+16, 1.08409190e+16, 1.07093146e+16, 1.05795379e+16,
                                      1.04544614e+16, 1.03325184e+16, 1.02126643e+16, 1.00943770e+16,
                                      9.97791744e+15, 9.86354688e+15, 9.75048192e+15, 9.63924480e+15,
                                      9.52957440e+15, 9.42147072e+15, 9.31493376e+15, 9.20996352e+15,
                                      9.20918016e+15, 9.57970944e+15, 9.54080256e+15, 9.43504896e+15,
                                      9.33060096e+15, 9.22745856e+15, 9.12588288e+15, 9.02535168e+15,
                                      8.92612608e+15, 8.82846720e+15, 8.73185280e+15, 8.63628288e+15,
                                      8.54254080e+15, 8.44984320e+15, 8.35845120e+15, 8.26627584e+15,
                                      8.17436160e+15, 8.08349184e+15, 7.99366656e+15, 7.90488576e+15,
                                      7.81714944e+15, 7.73045760e+15, 7.64481024e+15, 7.56020736e+15,
                                      7.47638784e+15, 7.39361280e+15, 7.31188224e+15, 7.23093504e+15,
                                      7.15077120e+15, 7.07165184e+15, 6.99357696e+15, 6.91628544e+15,
                                      6.83977728e+15, 6.76326912e+15, 6.68728320e+15, 6.61208064e+15,
                                      6.53792256e+15, 6.46428672e+15, 6.39169536e+15, 6.31988736e+15,
                                      6.24860160e+15, 6.17836032e+15, 6.10890240e+15, 6.04022784e+15,
                                      5.97207552e+15, 5.90496768e+15, 5.83838208e+15, 5.77257984e+15,
                                      5.70729984e+15, 5.64149760e+15, 5.57647872e+15, 5.51224320e+15,
                                      5.44879104e+15, 5.38612224e+15, 5.32319232e+15, 5.26078464e+15,
                                      5.19889920e+15, 5.13805824e+15, 5.07773952e+15, 5.01820416e+15,
                                      4.95945216e+15, 4.90122240e+15, 4.84377600e+15, 4.78685184e+15,
                                      4.73071104e+15, 4.67535360e+15, 4.62051840e+15, 4.56646656e+15,
                                      4.51293696e+15, 4.46019072e+15, 4.40744448e+15, 4.35522048e+15,
                                      4.30351872e+15, 4.25233920e+15, 4.20194304e+15, 4.15233024e+15,
                                      4.10323968e+15, 4.05467136e+15, 4.00662528e+15, 3.95936256e+15,
                                      3.91262208e+15, 3.86640384e+15, 3.82070784e+15, 3.77579520e+15,
                                      3.73140480e+15, 3.68727552e+15, 3.64392960e+15, 3.60110592e+15,
                                      3.55880448e+15, 3.51728640e+15, 3.47602944e+15, 3.43529472e+15,
                                      3.39508224e+15, 3.35539200e+15, 3.31622400e+15, 3.27731712e+15,
                                      3.23579904e+15, 3.19454208e+15, 3.15406848e+15, 3.11411712e+15,
                                      3.07468800e+15, 3.03578112e+15, 2.99661312e+15, 2.95796736e+15,
                                      2.92010496e+15, 2.88250368e+15, 2.84542464e+15, 2.80886784e+15,
                                      2.77283328e+15, 2.73732096e+15, 2.70233088e+15, 2.66760192e+15,
                                      2.63365632e+15, 2.59991962e+15, 2.56673126e+15, 2.53396070e+15,
                                      2.50166016e+15, 2.46977741e+15, 2.43833856e+15, 2.40716083e+15,
                                      2.37616589e+15, 2.34558874e+15, 2.31540326e+15, 2.28563558e+15,
                                      2.25625958e+15, 2.22730138e+15, 2.19870874e+15, 2.17053389e+15,
                                      2.14272461e+15, 2.11528090e+15, 2.08820275e+15, 2.06149018e+15,
                                      2.03514317e+15, 2.00916173e+15, 1.98349363e+15, 1.95819110e+15,
                                      1.93322803e+15, 1.90860442e+15, 1.88432026e+15, 1.86034944e+15,
                                      1.83669197e+15, 1.81324339e+15, 1.79005594e+15, 1.76720794e+15,
                                      1.74464717e+15, 1.72239974e+15, 1.70043955e+15, 1.67876659e+15,
                                      1.65738086e+15, 1.63630848e+15, 1.61549722e+15, 1.59494707e+15,
                                      1.57468416e+15, 1.50859469e+15, 1.27280333e+15, 1.07531827e+15,
                                      9.09715968e+14, 7.68763392e+14, 6.47368704e+14, 5.46106368e+14,
                                      4.61529600e+14, 3.89721600e+14, 3.64601856e+14, 3.50736384e+14,
                                      3.47159040e+14, 1.00361472e+15, 9.55855872e+14, 8.22763008e+14,
                                      7.89209088e+14, 7.85971200e+14, 7.80670464e+14, 1.06301952e+15,
                                      1.02142310e+15, 9.82176768e+14, 9.43165440e+14, 9.33242880e+14,
                                      1.06307174e+15, 1.05364531e+15, 1.02486989e+15, 8.91672576e+14,
                                      7.47899904e+14, 6.26479104e+14, 5.24172288e+14, 4.38551040e+14,
                                      3.67239168e+14, 3.07782144e+14, 2.58182400e+14, 2.15912294e+14,
                                      1.80444365e+14, 1.50452122e+14, 1.25455104e+14, 1.04701286e+14,
                                      8.74595328e+13, 7.31240448e+13, 6.11908608e+13, 5.12474112e+13,
                                      4.26200064e+13, 3.53869824e+13, 2.93812224e+13, 2.43677184e+13,
                                      2.01850982e+13, 1.66685952e+13, 1.37688576e+13, 1.13796096e+13,
                                      9.41207040e+12, 8.69712384e+12, 8.33077248e+12, 8.23650816e+12,
                                      4.61634048e+13, 4.45757952e+13, 4.44452352e+13, 3.75072768e+13,
                                      3.14701824e+13, 2.63809536e+13, 2.20970189e+13, 1.84891238e+13,
                                      1.54697933e+13, 1.29257011e+13, 1.07670221e+13, 8.96999424e+12,
                                      7.47377664e+12, 6.20499456e+12, 5.15006976e+12, 4.27479552e+12,
                                      3.54835968e+12, 2.94595584e+12, 2.44585882e+12, 2.03086080e+12,
                                      1.68644352e+12, 1.40051712e+12, 1.16315904e+12, 9.66117888e+11,
                                      8.03518464e+11, 6.70295040e+11, 5.59188480e+11, 4.66516992e+11,
                                      3.89251584e+11, 3.24781056e+11, 2.71016448e+11, 2.26171699e+11,
                                      1.88753203e+11, 1.57531085e+11, 1.31481754e+11]),
                     'ene': np.array([8.5668150e+00, 8.6946780e+00, 9.0938140e+00, 9.2330050e+00,
                                      9.2701230e+00, 9.3257990e+00, 9.4649900e+00, 1.0690000e+01,
                                      1.1427610e+01, 1.2216120e+01, 1.3059030e+01, 1.3960100e+01,
                                      1.4923350e+01, 1.5953060e+01, 1.7053820e+01, 1.8230530e+01,
                                      1.9488440e+01, 1.9894000e+01, 2.0198500e+01, 2.0279700e+01,
                                      2.0401500e+01, 2.0706000e+01, 2.0833140e+01, 2.2270630e+01,
                                      2.3807300e+01, 2.5450010e+01, 2.7206060e+01, 2.9083270e+01,
                                      3.1090020e+01, 3.3235230e+01, 3.5378000e+01, 3.5528460e+01,
                                      3.5919500e+01, 3.6063900e+01, 3.6280500e+01, 3.6822000e+01,
                                      3.7979930e+01, 4.0600540e+01, 4.3401980e+01, 4.6396710e+01,
                                      4.9598090e+01, 5.3020350e+01, 5.6678760e+01, 6.0589590e+01,
                                      6.4770280e+01, 6.9239420e+01, 7.4016950e+01, 7.9124110e+01,
                                      8.4583680e+01, 9.0419950e+01, 9.6658930e+01, 1.0000000e+02,
                                      1.0050000e+02, 1.0100250e+02, 1.0150751e+02, 1.0201505e+02,
                                      1.0252513e+02, 1.0303775e+02, 1.0355294e+02, 1.0407070e+02,
                                      1.0459106e+02, 1.0511401e+02, 1.0563958e+02, 1.0616778e+02,
                                      1.0669862e+02, 1.0723211e+02, 1.0776827e+02, 1.0830712e+02,
                                      1.0884865e+02, 1.0939289e+02, 1.0993986e+02, 1.1048956e+02,
                                      1.1104201e+02, 1.1159722e+02, 1.1215520e+02, 1.1271598e+02,
                                      1.1327956e+02, 1.1384596e+02, 1.1441519e+02, 1.1498726e+02,
                                      1.1556220e+02, 1.1614001e+02, 1.1672071e+02, 1.1730431e+02,
                                      1.1789083e+02, 1.1848029e+02, 1.1907269e+02, 1.1966805e+02,
                                      1.2026639e+02, 1.2086772e+02, 1.2147206e+02, 1.2207942e+02,
                                      1.2268982e+02, 1.2330327e+02, 1.2391979e+02, 1.2453939e+02,
                                      1.2516208e+02, 1.2578789e+02, 1.2641683e+02, 1.2704892e+02,
                                      1.2768416e+02, 1.2832258e+02, 1.2896419e+02, 1.2960902e+02,
                                      1.3025706e+02, 1.3090835e+02, 1.3156289e+02, 1.3222070e+02,
                                      1.3288181e+02, 1.3354621e+02, 1.3421395e+02, 1.3488502e+02,
                                      1.3555944e+02, 1.3623724e+02, 1.3691842e+02, 1.3760302e+02,
                                      1.3829103e+02, 1.3898249e+02, 1.3967740e+02, 1.4037579e+02,
                                      1.4046403e+02, 1.4053596e+02, 1.4107766e+02, 1.4178305e+02,
                                      1.4249197e+02, 1.4320443e+02, 1.4392045e+02, 1.4464005e+02,
                                      1.4536325e+02, 1.4609007e+02, 1.4682052e+02, 1.4755462e+02,
                                      1.4829239e+02, 1.4903386e+02, 1.4977903e+02, 1.5052792e+02,
                                      1.5128056e+02, 1.5203696e+02, 1.5279715e+02, 1.5356113e+02,
                                      1.5432894e+02, 1.5510058e+02, 1.5587609e+02, 1.5665547e+02,
                                      1.5743875e+02, 1.5822594e+02, 1.5901707e+02, 1.5981215e+02,
                                      1.6061121e+02, 1.6141427e+02, 1.6222134e+02, 1.6303245e+02,
                                      1.6384761e+02, 1.6466685e+02, 1.6549018e+02, 1.6631763e+02,
                                      1.6714922e+02, 1.6798497e+02, 1.6882489e+02, 1.6966902e+02,
                                      1.7051736e+02, 1.7136995e+02, 1.7222680e+02, 1.7308793e+02,
                                      1.7395337e+02, 1.7482314e+02, 1.7569726e+02, 1.7657574e+02,
                                      1.7745862e+02, 1.7834591e+02, 1.7923764e+02, 1.8013383e+02,
                                      1.8103450e+02, 1.8193967e+02, 1.8284937e+02, 1.8376362e+02,
                                      1.8468244e+02, 1.8560585e+02, 1.8653388e+02, 1.8746655e+02,
                                      1.8840388e+02, 1.8934590e+02, 1.9029263e+02, 1.9124409e+02,
                                      1.9220031e+02, 1.9316131e+02, 1.9412712e+02, 1.9509776e+02,
                                      1.9607325e+02, 1.9705361e+02, 1.9803888e+02, 1.9902907e+02,
                                      2.0002422e+02, 2.0102434e+02, 2.0202946e+02, 2.0303961e+02,
                                      2.0405481e+02, 2.0507508e+02, 2.0610046e+02, 2.0713096e+02,
                                      2.0816661e+02, 2.0920745e+02, 2.1025348e+02, 2.1130475e+02,
                                      2.1236128e+02, 2.1342308e+02, 2.1449020e+02, 2.1556265e+02,
                                      2.1664046e+02, 2.1772366e+02, 2.1881228e+02, 2.1990634e+02,
                                      2.2100588e+02, 2.2211090e+02, 2.2322146e+02, 2.2433757e+02,
                                      2.2545925e+02, 2.2658655e+02, 2.2771948e+02, 2.2885808e+02,
                                      2.3000237e+02, 2.3115238e+02, 2.3230814e+02, 2.3346969e+02,
                                      2.3463703e+02, 2.3581022e+02, 2.3698927e+02, 2.3817422e+02,
                                      2.3936509e+02, 2.4056191e+02, 2.4176472e+02, 2.4297355e+02,
                                      2.4418841e+02, 2.4540936e+02, 2.4663640e+02, 2.4786959e+02,
                                      2.4910893e+02, 2.5035448e+02, 2.5160625e+02, 2.5286428e+02,
                                      2.5412860e+02, 2.5539925e+02, 2.5667624e+02, 2.5795962e+02,
                                      2.5924942e+02, 2.6054567e+02, 2.6184840e+02, 2.6315764e+02,
                                      2.6447343e+02, 2.6579579e+02, 2.6712477e+02, 2.6846040e+02,
                                      2.6980270e+02, 2.7068519e+02, 2.7111483e+02, 2.7115171e+02,
                                      2.7250747e+02, 2.7387001e+02, 2.7523936e+02, 2.7661556e+02,
                                      2.7799863e+02, 2.7938863e+02, 2.8078557e+02, 2.8218950e+02,
                                      2.8360044e+02, 2.8501845e+02, 2.8644354e+02, 2.8787576e+02,
                                      2.8823661e+02, 2.8876341e+02, 2.8931514e+02, 2.9076171e+02,
                                      2.9221552e+02, 2.9367660e+02, 2.9514498e+02, 2.9662071e+02,
                                      2.9810381e+02, 2.9959433e+02, 3.0109230e+02, 3.0259776e+02,
                                      3.0411075e+02, 3.0563130e+02, 3.0715946e+02, 3.0869526e+02,
                                      3.1023873e+02, 3.1178993e+02, 3.1334888e+02, 3.1491562e+02,
                                      3.1649020e+02, 3.1807265e+02, 3.1966301e+02, 3.2126133e+02,
                                      3.2286764e+02, 3.2448197e+02, 3.2610438e+02, 3.2773491e+02,
                                      3.2937358e+02, 3.3102045e+02, 3.3267555e+02, 3.3433893e+02,
                                      3.3601062e+02, 3.3769068e+02, 3.3937913e+02, 3.4107602e+02,
                                      3.4278140e+02, 3.4449531e+02, 3.4621779e+02, 3.4794888e+02,
                                      3.4968862e+02, 3.5143706e+02, 3.5319425e+02, 3.5496022e+02,
                                      3.5673502e+02, 3.5851870e+02, 3.6031129e+02, 3.6211285e+02,
                                      3.6392341e+02, 3.6574303e+02, 3.6757174e+02, 3.6940960e+02,
                                      3.7125665e+02, 3.7311293e+02, 3.7497850e+02, 3.7534905e+02,
                                      3.7625097e+02, 3.7685339e+02, 3.7873766e+02, 3.8063135e+02,
                                      3.8253450e+02, 3.8444718e+02, 3.8636941e+02, 3.8830126e+02,
                                      3.9024276e+02, 3.9219398e+02, 3.9415495e+02, 3.9612572e+02,
                                      3.9810635e+02, 4.0009688e+02, 4.0209737e+02, 4.0410785e+02,
                                      4.0612839e+02, 4.0815904e+02, 4.1019983e+02, 4.1225083e+02,
                                      4.1431208e+02, 4.1638364e+02, 4.1846556e+02, 4.2055789e+02,
                                      4.2266068e+02, 4.2477398e+02, 4.2689785e+02, 4.2903234e+02,
                                      4.3117750e+02, 4.3333339e+02, 4.3550006e+02, 4.3767756e+02,
                                      4.3986595e+02, 4.4206528e+02, 4.4427560e+02, 4.4649698e+02,
                                      4.4872947e+02, 4.5097311e+02, 4.5322798e+02, 4.5549412e+02,
                                      4.5777159e+02, 4.6006045e+02, 4.6236075e+02, 4.6467255e+02,
                                      4.6699592e+02, 4.6933090e+02, 4.7167755e+02, 4.7403594e+02,
                                      4.7640612e+02, 4.7878815e+02, 4.8118209e+02, 4.8358800e+02,
                                      4.8600594e+02, 4.8843597e+02, 4.9087815e+02, 4.9333254e+02,
                                      4.9579920e+02, 4.9827820e+02, 5.0076959e+02, 5.0327344e+02,
                                      5.0578980e+02, 5.0831875e+02, 5.1086035e+02, 5.1341465e+02,
                                      5.1598172e+02, 5.1856163e+02, 5.2115444e+02, 5.2376021e+02,
                                      5.2637901e+02, 5.2901091e+02, 5.3165596e+02, 5.3431424e+02,
                                      5.3698581e+02, 5.3967074e+02, 5.4236910e+02, 5.4508094e+02,
                                      5.4780635e+02, 5.5054538e+02, 5.5329810e+02, 5.5606460e+02,
                                      5.5884492e+02, 5.6163914e+02, 5.6444734e+02, 5.6726958e+02,
                                      5.7010592e+02, 5.7295645e+02, 5.7582123e+02, 5.7870034e+02,
                                      5.8159384e+02, 5.8450181e+02, 5.8742432e+02, 5.9036144e+02,
                                      5.9331325e+02, 5.9627982e+02, 5.9926122e+02, 6.0225752e+02,
                                      6.0526881e+02, 6.0829515e+02, 6.1133663e+02, 6.1439331e+02,
                                      6.1746528e+02, 6.2055260e+02, 6.2365537e+02, 6.2677364e+02,
                                      6.2990751e+02, 6.3305705e+02, 6.3622234e+02, 6.3940345e+02,
                                      6.4260046e+02, 6.4581347e+02, 6.4904253e+02, 6.5228775e+02,
                                      6.5554919e+02, 6.5882693e+02, 6.6212107e+02, 6.6543167e+02,
                                      6.6875883e+02, 6.7210262e+02, 6.7546314e+02, 6.7884045e+02,
                                      6.8223466e+02, 6.8564583e+02, 6.8907406e+02, 6.9251943e+02,
                                      6.9598202e+02, 6.9946194e+02, 7.0295924e+02, 7.0647404e+02,
                                      7.1000641e+02, 7.1355644e+02, 7.1712423e+02, 7.2070985e+02,
                                      7.2431340e+02, 7.2793496e+02, 7.3157464e+02, 7.3523251e+02,
                                      7.3890867e+02, 7.4260322e+02, 7.4631623e+02, 7.5004781e+02,
                                      7.5379805e+02, 7.5756704e+02, 7.6135488e+02, 7.6516165e+02,
                                      7.6898746e+02, 7.7283240e+02, 7.7669656e+02, 7.8058004e+02,
                                      7.8448294e+02, 7.8840536e+02, 7.9234738e+02, 7.9630912e+02,
                                      8.0029067e+02, 8.0429212e+02, 8.0831358e+02, 8.1235515e+02,
                                      8.1641693e+02, 8.2049901e+02, 8.2460150e+02, 8.2872451e+02,
                                      8.3286813e+02, 8.3703248e+02, 8.4121764e+02, 8.4542373e+02,
                                      8.4965084e+02, 8.5389910e+02, 8.5816859e+02, 8.6245944e+02,
                                      8.6677173e+02, 8.7110559e+02, 8.7546112e+02, 8.7983843e+02,
                                      8.8423762e+02, 8.8865881e+02, 8.9310210e+02, 8.9756761e+02,
                                      9.0205545e+02, 9.0656573e+02, 9.1109856e+02, 9.1565405e+02,
                                      9.2023232e+02, 9.2483348e+02, 9.2945765e+02, 9.3410494e+02,
                                      9.3877546e+02, 9.4346934e+02, 9.4818668e+02, 9.5292762e+02,
                                      9.5769226e+02, 9.6248072e+02, 9.6729312e+02, 9.7212959e+02,
                                      9.7699023e+02, 9.8187519e+02, 9.8678456e+02, 9.9171848e+02,
                                      9.9667708e+02, 1.0016605e+03, 1.0066688e+03, 1.0117021e+03,
                                      1.0167606e+03, 1.0218444e+03, 1.0269536e+03, 1.0320884e+03,
                                      1.0372489e+03, 1.0424351e+03, 1.0476473e+03, 1.0528855e+03,
                                      1.0581499e+03, 1.0634407e+03, 1.0687579e+03, 1.0741017e+03,
                                      1.0794722e+03, 1.0848695e+03, 1.0902939e+03, 1.0957454e+03,
                                      1.1012241e+03, 1.1067302e+03, 1.1122639e+03, 1.1178252e+03,
                                      1.1234143e+03, 1.1290314e+03, 1.1346765e+03, 1.1403499e+03,
                                      1.1460517e+03, 1.1517819e+03, 1.1575408e+03, 1.1633285e+03,
                                      1.1691452e+03, 1.1749909e+03, 1.1808659e+03, 1.1850578e+03,
                                      1.1853422e+03, 1.1867702e+03, 1.1927040e+03, 1.1986676e+03,
                                      1.2046609e+03, 1.2106842e+03, 1.2167376e+03, 1.2169590e+03,
                                      1.2174410e+03, 1.2228213e+03, 1.2289354e+03, 1.2350801e+03,
                                      1.2412555e+03, 1.2474618e+03, 1.2536991e+03, 1.2599676e+03,
                                      1.2662674e+03, 1.2725988e+03, 1.2789618e+03, 1.2853566e+03,
                                      1.2917833e+03, 1.2982423e+03, 1.3047335e+03, 1.3112571e+03,
                                      1.3178134e+03, 1.3244025e+03, 1.3310245e+03, 1.3376796e+03,
                                      1.3443680e+03, 1.3510899e+03, 1.3578453e+03, 1.3646345e+03,
                                      1.3714577e+03, 1.3783150e+03, 1.3852066e+03, 1.3921326e+03,
                                      1.3990933e+03, 1.4060887e+03, 1.4131192e+03, 1.4201848e+03,
                                      1.4272857e+03, 1.4344221e+03, 1.4415942e+03, 1.4488022e+03,
                                      1.4560462e+03, 1.4633265e+03, 1.4706431e+03, 1.4779963e+03,
                                      1.4853863e+03, 1.4928132e+03, 1.5002773e+03, 1.5077787e+03,
                                      1.5153176e+03, 1.5228942e+03, 1.5305086e+03, 1.5381612e+03,
                                      1.5427108e+03, 1.5452893e+03, 1.5458520e+03, 1.5535812e+03,
                                      1.5613491e+03, 1.5691559e+03, 1.5770017e+03, 1.5848867e+03,
                                      1.5928111e+03, 1.6007752e+03, 1.6087790e+03, 1.6168229e+03,
                                      1.6249070e+03, 1.6330316e+03, 1.6411967e+03, 1.6494027e+03,
                                      1.6576497e+03, 1.6659380e+03, 1.6742677e+03, 1.6826390e+03,
                                      1.6868076e+03, 1.6897925e+03, 1.6910522e+03, 1.6995075e+03,
                                      1.7080050e+03, 1.7165450e+03, 1.7251278e+03, 1.7337534e+03,
                                      1.7424222e+03, 1.7511343e+03, 1.7598899e+03, 1.7686894e+03,
                                      1.7775328e+03, 1.7864205e+03, 1.7953526e+03, 1.8043294e+03,
                                      1.8133510e+03, 1.8224178e+03, 1.8315299e+03, 1.8406875e+03,
                                      1.8498909e+03, 1.8591404e+03, 1.8684361e+03, 1.8777783e+03,
                                      1.8778472e+03, 1.8837529e+03, 1.8871672e+03, 1.8966030e+03,
                                      1.9060860e+03, 1.9156165e+03, 1.9251945e+03, 1.9348205e+03,
                                      1.9444946e+03, 1.9542171e+03, 1.9639882e+03, 1.9738081e+03,
                                      1.9836772e+03, 1.9935955e+03, 2.0035635e+03, 2.0135813e+03,
                                      2.0236492e+03, 2.0337675e+03, 2.0439363e+03, 2.0541560e+03,
                                      2.0644268e+03, 2.0747489e+03, 2.0851227e+03, 2.0955483e+03,
                                      2.1060260e+03, 2.1165562e+03, 2.1271389e+03, 2.1377746e+03,
                                      2.1484635e+03, 2.1592058e+03, 2.1700018e+03, 2.1808519e+03,
                                      2.1917561e+03, 2.2027149e+03, 2.2137285e+03, 2.2247971e+03,
                                      2.2359211e+03, 2.2471007e+03, 2.2583362e+03, 2.2696279e+03,
                                      2.2809760e+03, 2.2923809e+03, 2.3038428e+03, 2.3153620e+03,
                                      2.3269388e+03, 2.3385735e+03, 2.3502664e+03, 2.3620177e+03,
                                      2.3738278e+03, 2.3856970e+03, 2.3976254e+03, 2.4096136e+03,
                                      2.4216616e+03, 2.4337699e+03, 2.4459388e+03, 2.4581685e+03,
                                      2.4704593e+03, 2.4828116e+03, 2.4952257e+03, 2.5077018e+03,
                                      2.5202403e+03, 2.5328415e+03, 2.5455057e+03, 2.5582333e+03,
                                      2.5710244e+03, 2.5838796e+03, 2.5967990e+03, 2.6097829e+03,
                                      2.6228319e+03, 2.6359460e+03, 2.6491257e+03, 2.6623714e+03,
                                      2.6756832e+03, 2.6890617e+03, 2.7025070e+03, 2.7160195e+03,
                                      2.7295996e+03, 2.7432476e+03, 2.7569638e+03, 2.7707486e+03,
                                      2.7846024e+03, 2.7985254e+03, 2.8125180e+03, 2.8265806e+03,
                                      2.8407135e+03, 2.8549171e+03, 2.8691917e+03, 2.8835376e+03,
                                      2.8979553e+03, 2.9124451e+03, 2.9270073e+03, 2.9416424e+03,
                                      2.9563506e+03, 2.9711323e+03, 2.9859880e+03, 3.0009179e+03,
                                      3.0159225e+03, 3.0310021e+03, 3.0461571e+03, 3.0613879e+03,
                                      3.0766949e+03, 3.0920783e+03, 3.1075387e+03, 3.1230764e+03,
                                      3.1386918e+03, 3.1543853e+03, 3.1701572e+03, 3.1860080e+03,
                                      3.2019380e+03, 3.2179477e+03, 3.2340374e+03, 3.2502076e+03,
                                      3.2664587e+03, 3.2827910e+03, 3.2992049e+03, 3.3157009e+03,
                                      3.3322794e+03, 3.3489408e+03, 3.3656856e+03, 3.3825140e+03,
                                      3.3994265e+03, 3.4164237e+03, 3.4335058e+03, 3.4506733e+03,
                                      3.4679267e+03, 3.4852663e+03, 3.5026927e+03, 3.5202061e+03,
                                      3.5378072e+03, 3.5554962e+03, 3.5732737e+03, 3.5911400e+03,
                                      3.6090957e+03, 3.6271412e+03, 3.6452769e+03, 3.6635033e+03,
                                      3.6818208e+03, 3.7002299e+03, 3.7187311e+03, 3.7373247e+03,
                                      3.7560114e+03, 3.7747914e+03, 3.7936654e+03, 3.8126337e+03,
                                      3.8316969e+03, 3.8508554e+03, 3.8701096e+03, 3.8894602e+03,
                                      3.9089075e+03, 3.9284520e+03, 3.9480943e+03, 3.9678347e+03,
                                      3.9876739e+03, 4.0550240e+03, 4.3348210e+03, 4.6339240e+03,
                                      4.9536640e+03, 5.2954670e+03, 5.6608550e+03, 6.0514530e+03,
                                      6.4690040e+03, 6.9153650e+03, 7.0979440e+03, 7.2065860e+03,
                                      7.2355570e+03, 7.2790140e+03, 7.3925250e+03, 7.7716940e+03,
                                      7.8906490e+03, 7.9026090e+03, 7.9223700e+03, 7.9699520e+03,
                                      8.0889060e+03, 8.2080880e+03, 8.3337220e+03, 8.3672240e+03,
                                      8.4174780e+03, 8.4478900e+03, 8.5431120e+03, 9.0307940e+03,
                                      9.6539190e+03, 1.0320040e+04, 1.1032120e+04, 1.1793340e+04,
                                      1.2607080e+04, 1.3476970e+04, 1.4406880e+04, 1.5400950e+04,
                                      1.6463620e+04, 1.7599610e+04, 1.8813980e+04, 2.0112150e+04,
                                      2.1499880e+04, 2.2983380e+04, 2.4569230e+04, 2.6264500e+04,
                                      2.8076760e+04, 3.0014050e+04, 3.2085020e+04, 3.4298890e+04,
                                      3.6665510e+04, 3.9195430e+04, 4.1899920e+04, 4.4791010e+04,
                                      4.7881590e+04, 4.9234320e+04, 4.9987910e+04, 5.0188860e+04,
                                      5.0490300e+04, 5.1185420e+04, 5.1243880e+04, 5.4717210e+04,
                                      5.8492700e+04, 6.2528700e+04, 6.6843180e+04, 7.1455360e+04,
                                      7.6385780e+04, 8.1656400e+04, 8.7290690e+04, 9.3313740e+04,
                                      9.9752390e+04, 1.0663530e+05, 1.1399310e+05, 1.2185870e+05,
                                      1.3026690e+05, 1.3925530e+05, 1.4886400e+05, 1.5913560e+05,
                                      1.7011590e+05, 1.8185390e+05, 1.9440180e+05, 2.0781560e+05,
                                      2.2215480e+05, 2.3748350e+05, 2.5386990e+05, 2.7138690e+05,
                                      2.9011260e+05, 3.1013040e+05, 3.3152940e+05, 3.5440490e+05,
                                      3.7885880e+05, 4.0500010e+05, 4.3294510e+05]), },
              '65': {'name': 'Tb',
                     'barns': 2639020000000.0,
                     'NumEdges': 19,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 25.4, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 25.4, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 39.0, 'factor': 1.0},
                     'N7': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8.6, 'factor': 1.0,
                            'twin': 'N6'},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9.4, 'factor': 0.75},
                     'N5': {'filename': 'Tb.N5', 'excl before': 5, 'excl after': 50, 'onset': 147.0, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 147.0,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 285.0, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 310.2, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 397.9, 'factor': 1.0},
                     'M5': {'filename': 'Tb.M5', 'excl before': 5, 'excl after': 50, 'onset': 1241.2, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1275.0,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Tb.M3', 'excl before': 5, 'excl after': 50, 'onset': 1611.3, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1767.7, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1967.5, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7514.0, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8251.6, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8708.0, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 51995.7, 'factor': 1.0},
                     'dat': np.array([3.57191357e+15, 3.44471281e+15, 3.05519345e+15, 2.94356291e+15,
                                      2.91479759e+15, 1.25627908e+16, 1.21138935e+16, 9.47698472e+15,
                                      8.56256429e+15, 8.07249828e+15, 7.89040590e+15, 7.95189506e+15,
                                      8.22107510e+15, 8.68079239e+15, 9.32524107e+15, 1.01554768e+16,
                                      1.11778331e+16, 1.24010189e+16, 1.38340067e+16, 1.54860333e+16,
                                      1.67139693e+16, 1.71557412e+16, 1.72744971e+16, 3.26816237e+17,
                                      3.24018876e+17, 3.10744605e+17, 2.71317646e+17, 2.25831497e+17,
                                      1.85699920e+17, 1.52279371e+17, 1.25941951e+17, 1.06085965e+17,
                                      1.04507831e+17, 1.00897652e+17, 9.99871898e+16, 9.92482642e+16,
                                      9.61526937e+16, 9.22548612e+16, 8.21421365e+16, 7.52780455e+16,
                                      7.06967068e+16, 6.76591948e+16, 6.56984029e+16, 6.44105611e+16,
                                      6.35132943e+16, 6.27981199e+16, 6.21330869e+16, 6.14231905e+16,
                                      6.06130114e+16, 5.96814373e+16, 5.86126342e+16, 5.80188547e+16,
                                      5.79291280e+16, 5.78394013e+16, 5.77470356e+16, 5.76546699e+16,
                                      5.75623042e+16, 5.74699385e+16, 5.73749338e+16, 5.72799291e+16,
                                      5.71849244e+16, 5.70899197e+16, 5.69949149e+16, 5.68972712e+16,
                                      5.67996275e+16, 5.67019837e+16, 5.66017010e+16, 5.65040572e+16,
                                      5.64037745e+16, 5.63034917e+16, 5.62005699e+16, 5.61002872e+16,
                                      5.59973654e+16, 5.58944436e+16, 5.57915218e+16, 5.56886000e+16,
                                      5.55830392e+16, 5.54801175e+16, 5.53745567e+16, 5.52689959e+16,
                                      5.51634351e+16, 5.50552352e+16, 5.49496744e+16, 5.48414746e+16,
                                      5.47332748e+16, 5.46250750e+16, 5.45168752e+16, 5.44060363e+16,
                                      5.42978365e+16, 5.41869977e+16, 5.40761588e+16, 5.39653200e+16,
                                      5.38544811e+16, 5.37436423e+16, 5.36328035e+16, 5.35193256e+16,
                                      5.34084868e+16, 5.32950089e+16, 5.31815310e+16, 5.30680532e+16,
                                      5.29545753e+16, 5.28410975e+16, 5.27249806e+16, 5.26115027e+16,
                                      5.24953858e+16, 5.23819080e+16, 5.22657911e+16, 5.21496742e+16,
                                      5.20335573e+16, 5.19174405e+16, 5.18013236e+16, 5.16852067e+16,
                                      5.15690898e+16, 5.14529729e+16, 5.13368561e+16, 5.12181002e+16,
                                      5.11019833e+16, 5.09832274e+16, 5.08671105e+16, 5.07483546e+16,
                                      5.06295987e+16, 5.05134818e+16, 5.03947259e+16, 5.02759700e+16,
                                      5.01572141e+16, 5.00410972e+16, 4.99223413e+16, 4.98035854e+16,
                                      4.96848295e+16, 4.96637174e+16, 1.27224515e+17, 1.23767399e+17,
                                      1.19030358e+17, 1.14580970e+17, 1.10398124e+17, 1.06471262e+17,
                                      1.02779273e+17, 9.93116006e+16, 9.60524109e+16, 9.29885087e+16,
                                      9.01066989e+16, 8.73990644e+16, 8.48497710e+16, 8.24535409e+16,
                                      8.01998178e+16, 7.80780457e+16, 7.60803076e+16, 7.42013253e+16,
                                      7.24305429e+16, 7.07653213e+16, 6.91502411e+16, 6.76486387e+16,
                                      6.62578751e+16, 6.49673944e+16, 6.37692793e+16, 6.26529738e+16,
                                      6.16131999e+16, 6.06394016e+16, 5.97263006e+16, 5.88712582e+16,
                                      5.80663571e+16, 5.73115973e+16, 5.65964229e+16, 5.59208338e+16,
                                      5.52821910e+16, 5.46778554e+16, 5.41025490e+16, 5.35457158e+16,
                                      5.28754047e+16, 5.22288448e+16, 5.16060361e+16, 5.10017005e+16,
                                      5.04184771e+16, 4.98537268e+16, 4.93048107e+16, 4.87717286e+16,
                                      4.82544807e+16, 4.77504279e+16, 4.72595702e+16, 4.67819075e+16,
                                      4.63148010e+16, 4.58582505e+16, 4.54122562e+16, 4.49741788e+16,
                                      4.45466576e+16, 4.41270534e+16, 4.37180053e+16, 4.33142353e+16,
                                      4.29183823e+16, 4.25278073e+16, 4.21477884e+16, 4.17704086e+16,
                                      4.14009458e+16, 4.10367610e+16, 4.06778543e+16, 4.03268646e+16,
                                      3.99785140e+16, 3.96354414e+16, 3.92976468e+16, 3.89651303e+16,
                                      3.86352528e+16, 3.83106533e+16, 3.79913319e+16, 3.76746495e+16,
                                      3.73606061e+16, 3.70518408e+16, 3.67483535e+16, 3.64475052e+16,
                                      3.61492960e+16, 3.58563647e+16, 3.55660725e+16, 3.52784194e+16,
                                      3.49934052e+16, 3.47136691e+16, 3.44339330e+16, 3.41594749e+16,
                                      3.38876558e+16, 3.36211148e+16, 3.33545738e+16, 3.30906718e+16,
                                      3.28320478e+16, 3.25734239e+16, 3.23200779e+16, 3.20667320e+16,
                                      3.18186641e+16, 3.15705963e+16, 3.13278064e+16, 3.10876556e+16,
                                      3.08475048e+16, 3.06099930e+16, 3.03777592e+16, 3.01455255e+16,
                                      2.99159307e+16, 2.96916140e+16, 2.94672973e+16, 2.92456196e+16,
                                      2.90239420e+16, 2.88075423e+16, 2.85937817e+16, 2.83800211e+16,
                                      2.81715385e+16, 2.79630559e+16, 2.77572124e+16, 2.75540078e+16,
                                      2.73508033e+16, 2.71528768e+16, 2.69549503e+16, 2.67596628e+16,
                                      2.65670143e+16, 2.63770049e+16, 2.61885789e+16, 2.60020002e+16,
                                      2.58175327e+16, 2.56351764e+16, 2.54546674e+16, 2.52765336e+16,
                                      2.50999831e+16, 2.49255439e+16, 2.47532159e+16, 2.45827352e+16,
                                      2.44141018e+16, 2.42475797e+16, 2.40826409e+16, 2.39506899e+16,
                                      2.66725751e+16, 2.66461849e+16, 2.65089559e+16, 2.63469201e+16,
                                      2.61862038e+16, 2.60273348e+16, 2.58700492e+16, 2.57148748e+16,
                                      2.55612838e+16, 2.54092763e+16, 2.52591160e+16, 2.51108031e+16,
                                      2.49640736e+16, 2.48189275e+16, 2.46756287e+16, 2.45336494e+16,
                                      2.43935175e+16, 2.42549689e+16, 2.41488803e+16, 2.48685411e+16,
                                      2.48442621e+16, 2.47328954e+16, 2.45990971e+16, 2.44666183e+16,
                                      2.43354590e+16, 2.42056192e+16, 2.40773629e+16, 2.39504260e+16,
                                      2.38248087e+16, 2.37005108e+16, 2.35775325e+16, 2.34556098e+16,
                                      2.33352704e+16, 2.32157228e+16, 2.30977586e+16, 2.29808501e+16,
                                      2.28649971e+16, 2.27504636e+16, 2.26369858e+16, 2.25245635e+16,
                                      2.24131969e+16, 2.23028858e+16, 2.21936304e+16, 2.20854306e+16,
                                      2.19782864e+16, 2.18719339e+16, 2.17666370e+16, 2.16621318e+16,
                                      2.15586822e+16, 2.14560243e+16, 2.13541581e+16, 2.12530837e+16,
                                      2.11530648e+16, 2.10535738e+16, 2.09548744e+16, 2.08569668e+16,
                                      2.07598508e+16, 2.06635266e+16, 2.05677302e+16, 2.04727255e+16,
                                      2.03782485e+16, 2.02842994e+16, 2.01911420e+16, 2.00985124e+16,
                                      2.00064106e+16, 1.99148366e+16, 1.98237904e+16, 1.97332720e+16,
                                      1.96432815e+16, 1.95538187e+16, 1.94965520e+16, 2.03843183e+16,
                                      2.03708593e+16, 2.02930082e+16, 2.02022259e+16, 2.01119714e+16,
                                      2.00217169e+16, 1.99322542e+16, 1.98427914e+16, 1.97538564e+16,
                                      1.96654492e+16, 1.95770421e+16, 1.94888988e+16, 1.94012833e+16,
                                      1.93139318e+16, 1.92265802e+16, 1.91397565e+16, 1.90529327e+16,
                                      1.89663728e+16, 1.88800769e+16, 1.87940448e+16, 1.87082767e+16,
                                      1.86225085e+16, 1.85367404e+16, 1.84512361e+16, 1.83657319e+16,
                                      1.82804915e+16, 1.81952512e+16, 1.81100108e+16, 1.80250344e+16,
                                      1.79397941e+16, 1.78548176e+16, 1.77701051e+16, 1.76851286e+16,
                                      1.76001522e+16, 1.75154396e+16, 1.74307271e+16, 1.73457507e+16,
                                      1.72610381e+16, 1.71763256e+16, 1.70913491e+16, 1.70063727e+16,
                                      1.69213962e+16, 1.68366837e+16, 1.67517073e+16, 1.66667308e+16,
                                      1.65817544e+16, 1.64967779e+16, 1.64118015e+16, 1.63268250e+16,
                                      1.62418486e+16, 1.61568721e+16, 1.60718957e+16, 1.59866554e+16,
                                      1.59016789e+16, 1.58167025e+16, 1.57314621e+16, 1.56464857e+16,
                                      1.55612453e+16, 1.54760050e+16, 1.53910285e+16, 1.53057882e+16,
                                      1.52205478e+16, 1.51355714e+16, 1.50503311e+16, 1.49650907e+16,
                                      1.48801143e+16, 1.47948739e+16, 1.47098975e+16, 1.46246571e+16,
                                      1.45396807e+16, 1.44544403e+16, 1.43694639e+16, 1.42844875e+16,
                                      1.41995110e+16, 1.41145346e+16, 1.40298220e+16, 1.39448456e+16,
                                      1.38601330e+16, 1.37754205e+16, 1.36907080e+16, 1.36059954e+16,
                                      1.35215468e+16, 1.34368342e+16, 1.33521217e+16, 1.32674091e+16,
                                      1.31826966e+16, 1.30979841e+16, 1.30132715e+16, 1.29288229e+16,
                                      1.28441103e+16, 1.27596617e+16, 1.26752131e+16, 1.25910283e+16,
                                      1.25065797e+16, 1.24223949e+16, 1.23384741e+16, 1.22545533e+16,
                                      1.21706324e+16, 1.20869755e+16, 1.20035825e+16, 1.19201894e+16,
                                      1.18370603e+16, 1.17541951e+16, 1.16713299e+16, 1.15887285e+16,
                                      1.15063911e+16, 1.14240537e+16, 1.13422441e+16, 1.12604344e+16,
                                      1.11788887e+16, 1.10976069e+16, 1.10165890e+16, 1.09358350e+16,
                                      1.08556088e+16, 1.07753826e+16, 1.06954203e+16, 1.06157219e+16,
                                      1.05365513e+16, 1.04576446e+16, 1.03790018e+16, 1.03006229e+16,
                                      1.02225079e+16, 1.01446568e+16, 1.00673335e+16, 9.99027411e+15,
                                      9.91347863e+15, 9.83721095e+15, 9.76120718e+15, 9.68546730e+15,
                                      9.61025523e+15, 9.53530706e+15, 9.46088670e+15, 9.38673024e+15,
                                      9.31283768e+15, 9.23947292e+15, 9.16637207e+15, 9.09379902e+15,
                                      9.02148987e+15, 8.94970853e+15, 8.87845499e+15, 8.80746535e+15,
                                      8.73673961e+15, 8.66654168e+15, 8.59687155e+15, 8.52746533e+15,
                                      8.45858690e+15, 8.38997238e+15, 8.32188567e+15, 8.25432676e+15,
                                      8.18703175e+15, 8.12026454e+15, 8.05376124e+15, 7.98804964e+15,
                                      7.92233804e+15, 7.85741815e+15, 7.79276216e+15, 7.72837007e+15,
                                      7.66450579e+15, 7.60116931e+15, 7.53836063e+15, 7.47581586e+15,
                                      7.41379889e+15, 7.35230972e+15, 7.29108446e+15, 7.23012309e+15,
                                      7.16995344e+15, 7.11004768e+15, 7.05066973e+15, 6.99155569e+15,
                                      6.93296944e+15, 6.87491100e+15, 6.81711646e+15, 6.75984973e+15,
                                      6.70284690e+15, 6.64663577e+15, 6.59042465e+15, 6.53500523e+15,
                                      6.47984971e+15, 6.42495809e+15, 6.37059428e+15, 6.31675827e+15,
                                      6.26345007e+15, 6.21014186e+15, 6.15762537e+15, 6.10537277e+15,
                                      6.05364798e+15, 5.99796466e+15, 5.93410037e+15, 5.87129170e+15,
                                      5.80901082e+15, 5.74725776e+15, 5.68629639e+15, 5.62612674e+15,
                                      5.56648489e+15, 5.50763474e+15, 5.44957630e+15, 5.39204566e+15,
                                      5.33504283e+15, 5.27883171e+15, 5.22314838e+15, 5.16799287e+15,
                                      5.11362905e+15, 5.05979305e+15, 5.00648484e+15, 4.95396834e+15,
                                      4.90197965e+15, 4.85051876e+15, 4.79958567e+15, 4.74918039e+15,
                                      4.69956682e+15, 4.65048104e+15, 4.60165917e+15, 4.55362901e+15,
                                      4.50480714e+15, 4.45677698e+15, 4.40901071e+15, 4.36203616e+15,
                                      4.31558941e+15, 4.26940656e+15, 4.22401541e+15, 4.17915207e+15,
                                      4.13455263e+15, 4.09074490e+15, 4.04720107e+15, 4.00418505e+15,
                                      3.96169682e+15, 3.91973641e+15, 3.87830379e+15, 3.83713508e+15,
                                      3.79807758e+15, 1.48890869e+16, 1.48859201e+16, 1.47006609e+16,
                                      1.45146100e+16, 1.43309342e+16, 1.41496335e+16, 1.39704441e+16,
                                      1.39110661e+16, 2.09733475e+16, 2.08176454e+16, 2.05516322e+16,
                                      2.02890497e+16, 2.00301618e+16, 1.97741769e+16, 1.95218865e+16,
                                      1.92727631e+16, 1.90268064e+16, 1.87840166e+16, 1.85443935e+16,
                                      1.83079373e+16, 1.80743841e+16, 1.78439976e+16, 1.76165141e+16,
                                      1.73919335e+16, 1.71702558e+16, 1.69514811e+16, 1.67356092e+16,
                                      1.65223764e+16, 1.63120465e+16, 1.61043556e+16, 1.58993038e+16,
                                      1.56968910e+16, 1.54971171e+16, 1.52999824e+16, 1.51052227e+16,
                                      1.49131020e+16, 1.47236204e+16, 1.45362500e+16, 1.43515186e+16,
                                      1.41691623e+16, 1.39891811e+16, 1.38113112e+16, 1.36358163e+16,
                                      1.34626966e+16, 1.32916881e+16, 1.31230548e+16, 1.29565326e+16,
                                      1.27921216e+16, 1.26298219e+16, 1.24693695e+16, 1.23112922e+16,
                                      1.21550622e+16, 1.20009434e+16, 1.18489359e+16, 1.16985118e+16,
                                      1.15501988e+16, 1.15304062e+16, 1.34524044e+16, 1.33626778e+16,
                                      1.31877107e+16, 1.30148549e+16, 1.28443742e+16, 1.26762687e+16,
                                      1.25105382e+16, 1.23466551e+16, 1.21848831e+16, 1.20252224e+16,
                                      1.18682007e+16, 1.17209434e+16, 1.15757973e+16, 1.14330263e+16,
                                      1.12926305e+16, 1.11543458e+16, 1.10181724e+16, 1.08841102e+16,
                                      1.07521592e+16, 1.06605852e+16, 1.13749679e+16, 1.13641479e+16,
                                      1.12332525e+16, 1.10936484e+16, 1.09561554e+16, 1.08207737e+16,
                                      1.06872393e+16, 1.05555522e+16, 1.04259763e+16, 1.02982477e+16,
                                      1.01723665e+16, 1.00501799e+16, 9.93221567e+15, 9.81609879e+15,
                                      9.70182923e+15, 9.58940697e+15, 9.47830423e+15, 9.36931271e+15,
                                      9.26164069e+15, 9.15555209e+15, 9.05131080e+15, 8.94812511e+15,
                                      8.84678675e+15, 8.84388382e+15, 9.19698470e+15, 9.16478866e+15,
                                      9.06213078e+15, 8.96105631e+15, 8.86130136e+15, 8.76260201e+15,
                                      8.66548607e+15, 8.56968965e+15, 8.47494883e+15, 8.38126362e+15,
                                      8.28889792e+15, 8.19837953e+15, 8.10865285e+15, 8.02024568e+15,
                                      7.93051900e+15, 7.84184793e+15, 7.75449637e+15, 7.66793651e+15,
                                      7.58243226e+15, 7.49798362e+15, 7.41459059e+15, 7.33225317e+15,
                                      7.25070745e+15, 7.17021734e+15, 7.09051894e+15, 7.01187614e+15,
                                      6.93402505e+15, 6.85696567e+15, 6.78096189e+15, 6.70574982e+15,
                                      6.63132946e+15, 6.55770080e+15, 6.48433604e+15, 6.41149909e+15,
                                      6.33918994e+15, 6.26767250e+15, 6.19721067e+15, 6.12727664e+15,
                                      6.05813431e+15, 5.98978369e+15, 5.92222478e+15, 5.85545758e+15,
                                      5.78948208e+15, 5.72403438e+15, 5.65964229e+15, 5.59577801e+15,
                                      5.53244153e+15, 5.46989675e+15, 5.40682418e+15, 5.34454330e+15,
                                      5.28305414e+15, 5.22209278e+15, 5.16192312e+15, 5.10175346e+15,
                                      5.04211161e+15, 4.98299756e+15, 4.92441132e+15, 4.86688068e+15,
                                      4.80987785e+15, 4.75340282e+15, 4.69771950e+15, 4.64282789e+15,
                                      4.58820017e+15, 4.53462807e+15, 4.48158376e+15, 4.42906727e+15,
                                      4.37734247e+15, 4.32614549e+15, 4.27547630e+15, 4.22507102e+15,
                                      4.17492964e+15, 4.12557997e+15, 4.07675810e+15, 4.02846403e+15,
                                      3.98096167e+15, 3.93398711e+15, 3.88754036e+15, 3.84162141e+15,
                                      3.79623027e+15, 3.75163083e+15, 3.70755920e+15, 3.66401537e+15,
                                      3.62073544e+15, 3.57824722e+15, 3.53628680e+15, 3.49485419e+15,
                                      3.45025475e+15, 3.40618311e+15, 3.36290319e+15, 3.32015106e+15,
                                      3.27792674e+15, 3.23623023e+15, 3.19506151e+15, 3.15468451e+15,
                                      3.11457140e+15, 3.07525001e+15, 3.03645641e+15, 2.99792672e+15,
                                      2.96018873e+15, 2.92271465e+15, 2.88550447e+15, 2.84829429e+15,
                                      2.81161191e+15, 2.77572124e+15, 2.74009447e+15, 2.70473160e+15,
                                      2.67016044e+15, 2.63601152e+15, 2.60228484e+15, 2.56903319e+15,
                                      2.53620378e+15, 2.50382301e+15, 2.47189086e+15, 2.44038096e+15,
                                      2.40929331e+15, 2.37862790e+15, 2.34838473e+15, 2.31853741e+15,
                                      2.28903317e+15, 2.25958170e+15, 2.23052609e+15, 2.20186634e+15,
                                      2.17357604e+15, 2.14568160e+15, 2.11815662e+15, 2.09100111e+15,
                                      2.06421505e+15, 2.03779846e+15, 2.01172495e+15, 1.98599450e+15,
                                      1.96063352e+15, 1.93558922e+15, 1.91088799e+15, 1.88650345e+15,
                                      1.86246197e+15, 1.83876358e+15, 1.81535547e+15, 1.79226404e+15,
                                      1.76948930e+15, 1.74700485e+15, 1.72473152e+15, 1.70269570e+15,
                                      1.68095018e+15, 1.61003971e+15, 1.35722160e+15, 1.14562497e+15,
                                      9.68361999e+14, 8.19600441e+14, 6.91476020e+14, 5.82695616e+14,
                                      4.91834157e+14, 4.15909552e+14, 3.54288435e+14, 3.50778538e+14,
                                      3.40829433e+14, 3.37372317e+14, 9.68230048e+14, 9.23841731e+14,
                                      8.38865287e+14, 7.86876593e+14, 7.55234744e+14, 7.47159342e+14,
                                      1.02518010e+15, 9.83061340e+14, 9.72821943e+14, 9.45481695e+14,
                                      9.06054737e+14, 8.96633435e+14, 1.02114240e+15, 9.84248899e+14,
                                      9.44109405e+14, 7.96640967e+14, 6.67751231e+14, 5.57413804e+14,
                                      4.65839810e+14, 3.89941595e+14, 3.26684286e+14, 2.73956666e+14,
                                      2.29565711e+14, 1.92062598e+14, 1.60418109e+14, 1.33769285e+14,
                                      1.11643741e+14, 9.32629668e+13, 7.79751239e+13, 6.52524085e+13,
                                      5.46541042e+13, 4.54544805e+13, 3.77379860e+13, 3.13594747e+13,
                                      2.60291821e+13, 2.15908782e+13, 1.78645820e+13, 1.47634696e+13,
                                      1.22009812e+13, 1.00910847e+13, 8.45937861e+12, 8.35249830e+12,
                                      8.10363871e+12, 8.01232862e+12, 4.44542919e+13, 4.28128215e+13,
                                      3.95430757e+13, 3.32094277e+13, 2.78443000e+13, 2.33350065e+13,
                                      1.95353456e+13, 1.63513679e+13, 1.36674846e+13, 1.13892186e+13,
                                      9.49176323e+12, 7.91151806e+12, 6.58461880e+12, 5.46672993e+12,
                                      4.53911440e+12, 3.76904836e+12, 3.13014162e+12, 2.59959304e+12,
                                      2.15921977e+12, 1.79360994e+12, 1.49001708e+12, 1.23788511e+12,
                                      1.02853165e+12, 8.54620237e+11, 7.12746522e+11, 5.95046230e+11,
                                      4.96795515e+11, 4.14827554e+11, 3.46397765e+11, 2.89262982e+11,
                                      2.41565335e+11, 2.01750440e+11, 1.68504066e+11, 1.40746854e+11]),
                     'ene': np.array([8.6430000e+00, 8.7720000e+00, 9.2120000e+00, 9.3530000e+00,
                                      9.3906000e+00, 9.4470000e+00, 9.5880000e+00, 1.0690000e+01,
                                      1.1427610e+01, 1.2216120e+01, 1.3059030e+01, 1.3960100e+01,
                                      1.4923350e+01, 1.5953060e+01, 1.7053820e+01, 1.8230530e+01,
                                      1.9488440e+01, 2.0833140e+01, 2.2270630e+01, 2.3807300e+01,
                                      2.4892000e+01, 2.5273000e+01, 2.5374600e+01, 2.5450010e+01,
                                      2.5527000e+01, 2.5908000e+01, 2.7206060e+01, 2.9083270e+01,
                                      3.1090020e+01, 3.3235230e+01, 3.5528460e+01, 3.7979930e+01,
                                      3.8220000e+01, 3.8805000e+01, 3.8961000e+01, 3.9195000e+01,
                                      3.9780000e+01, 4.0600540e+01, 4.3401980e+01, 4.6396710e+01,
                                      4.9598090e+01, 5.3020350e+01, 5.6678760e+01, 6.0589590e+01,
                                      6.4770280e+01, 6.9239420e+01, 7.4016950e+01, 7.9124110e+01,
                                      8.4583680e+01, 9.0419950e+01, 9.6658930e+01, 1.0000000e+02,
                                      1.0050000e+02, 1.0100250e+02, 1.0150751e+02, 1.0201505e+02,
                                      1.0252513e+02, 1.0303775e+02, 1.0355294e+02, 1.0407070e+02,
                                      1.0459106e+02, 1.0511401e+02, 1.0563958e+02, 1.0616778e+02,
                                      1.0669862e+02, 1.0723211e+02, 1.0776827e+02, 1.0830712e+02,
                                      1.0884865e+02, 1.0939289e+02, 1.0993986e+02, 1.1048956e+02,
                                      1.1104201e+02, 1.1159722e+02, 1.1215520e+02, 1.1271598e+02,
                                      1.1327956e+02, 1.1384596e+02, 1.1441519e+02, 1.1498726e+02,
                                      1.1556220e+02, 1.1614001e+02, 1.1672071e+02, 1.1730431e+02,
                                      1.1789083e+02, 1.1848029e+02, 1.1907269e+02, 1.1966805e+02,
                                      1.2026639e+02, 1.2086772e+02, 1.2147206e+02, 1.2207942e+02,
                                      1.2268982e+02, 1.2330327e+02, 1.2391979e+02, 1.2453939e+02,
                                      1.2516208e+02, 1.2578789e+02, 1.2641683e+02, 1.2704892e+02,
                                      1.2768416e+02, 1.2832258e+02, 1.2896419e+02, 1.2960902e+02,
                                      1.3025706e+02, 1.3090835e+02, 1.3156289e+02, 1.3222070e+02,
                                      1.3288181e+02, 1.3354621e+02, 1.3421395e+02, 1.3488502e+02,
                                      1.3555944e+02, 1.3623724e+02, 1.3691842e+02, 1.3760302e+02,
                                      1.3829103e+02, 1.3898249e+02, 1.3967740e+02, 1.4037579e+02,
                                      1.4107766e+02, 1.4178305e+02, 1.4249197e+02, 1.4320443e+02,
                                      1.4392045e+02, 1.4464005e+02, 1.4536325e+02, 1.4609007e+02,
                                      1.4682052e+02, 1.4695355e+02, 1.4704645e+02, 1.4755462e+02,
                                      1.4829239e+02, 1.4903386e+02, 1.4977903e+02, 1.5052792e+02,
                                      1.5128056e+02, 1.5203696e+02, 1.5279715e+02, 1.5356113e+02,
                                      1.5432894e+02, 1.5510058e+02, 1.5587609e+02, 1.5665547e+02,
                                      1.5743875e+02, 1.5822594e+02, 1.5901707e+02, 1.5981215e+02,
                                      1.6061121e+02, 1.6141427e+02, 1.6222134e+02, 1.6303245e+02,
                                      1.6384761e+02, 1.6466685e+02, 1.6549018e+02, 1.6631763e+02,
                                      1.6714922e+02, 1.6798497e+02, 1.6882489e+02, 1.6966902e+02,
                                      1.7051736e+02, 1.7136995e+02, 1.7222680e+02, 1.7308793e+02,
                                      1.7395337e+02, 1.7482314e+02, 1.7569726e+02, 1.7657574e+02,
                                      1.7745862e+02, 1.7834591e+02, 1.7923764e+02, 1.8013383e+02,
                                      1.8103450e+02, 1.8193967e+02, 1.8284937e+02, 1.8376362e+02,
                                      1.8468244e+02, 1.8560585e+02, 1.8653388e+02, 1.8746655e+02,
                                      1.8840388e+02, 1.8934590e+02, 1.9029263e+02, 1.9124409e+02,
                                      1.9220031e+02, 1.9316131e+02, 1.9412712e+02, 1.9509776e+02,
                                      1.9607325e+02, 1.9705361e+02, 1.9803888e+02, 1.9902907e+02,
                                      2.0002422e+02, 2.0102434e+02, 2.0202946e+02, 2.0303961e+02,
                                      2.0405481e+02, 2.0507508e+02, 2.0610046e+02, 2.0713096e+02,
                                      2.0816661e+02, 2.0920745e+02, 2.1025348e+02, 2.1130475e+02,
                                      2.1236128e+02, 2.1342308e+02, 2.1449020e+02, 2.1556265e+02,
                                      2.1664046e+02, 2.1772366e+02, 2.1881228e+02, 2.1990634e+02,
                                      2.2100588e+02, 2.2211090e+02, 2.2322146e+02, 2.2433757e+02,
                                      2.2545925e+02, 2.2658655e+02, 2.2771948e+02, 2.2885808e+02,
                                      2.3000237e+02, 2.3115238e+02, 2.3230814e+02, 2.3346969e+02,
                                      2.3463703e+02, 2.3581022e+02, 2.3698927e+02, 2.3817422e+02,
                                      2.3936509e+02, 2.4056191e+02, 2.4176472e+02, 2.4297355e+02,
                                      2.4418841e+02, 2.4540936e+02, 2.4663640e+02, 2.4786959e+02,
                                      2.4910893e+02, 2.5035448e+02, 2.5160625e+02, 2.5286428e+02,
                                      2.5412860e+02, 2.5539925e+02, 2.5667624e+02, 2.5795962e+02,
                                      2.5924942e+02, 2.6054567e+02, 2.6184840e+02, 2.6315764e+02,
                                      2.6447343e+02, 2.6579579e+02, 2.6712477e+02, 2.6846040e+02,
                                      2.6980270e+02, 2.7115171e+02, 2.7250747e+02, 2.7387001e+02,
                                      2.7523936e+02, 2.7661556e+02, 2.7799863e+02, 2.7938863e+02,
                                      2.8078557e+02, 2.8218950e+02, 2.8360044e+02, 2.8474920e+02,
                                      2.8501845e+02, 2.8525080e+02, 2.8644354e+02, 2.8787576e+02,
                                      2.8931514e+02, 2.9076171e+02, 2.9221552e+02, 2.9367660e+02,
                                      2.9514498e+02, 2.9662071e+02, 2.9810381e+02, 2.9959433e+02,
                                      3.0109230e+02, 3.0259776e+02, 3.0411075e+02, 3.0563130e+02,
                                      3.0715946e+02, 3.0869526e+02, 3.0988670e+02, 3.1023873e+02,
                                      3.1051331e+02, 3.1178993e+02, 3.1334888e+02, 3.1491562e+02,
                                      3.1649020e+02, 3.1807265e+02, 3.1966301e+02, 3.2126133e+02,
                                      3.2286764e+02, 3.2448197e+02, 3.2610438e+02, 3.2773491e+02,
                                      3.2937358e+02, 3.3102045e+02, 3.3267555e+02, 3.3433893e+02,
                                      3.3601062e+02, 3.3769068e+02, 3.3937913e+02, 3.4107602e+02,
                                      3.4278140e+02, 3.4449531e+02, 3.4621779e+02, 3.4794888e+02,
                                      3.4968862e+02, 3.5143706e+02, 3.5319425e+02, 3.5496022e+02,
                                      3.5673502e+02, 3.5851870e+02, 3.6031129e+02, 3.6211285e+02,
                                      3.6392341e+02, 3.6574303e+02, 3.6757174e+02, 3.6940960e+02,
                                      3.7125665e+02, 3.7311293e+02, 3.7497850e+02, 3.7685339e+02,
                                      3.7873766e+02, 3.8063135e+02, 3.8253450e+02, 3.8444718e+02,
                                      3.8636941e+02, 3.8830126e+02, 3.9024276e+02, 3.9219398e+02,
                                      3.9415495e+02, 3.9612572e+02, 3.9739863e+02, 3.9810635e+02,
                                      3.9840134e+02, 4.0009688e+02, 4.0209737e+02, 4.0410785e+02,
                                      4.0612839e+02, 4.0815904e+02, 4.1019983e+02, 4.1225083e+02,
                                      4.1431208e+02, 4.1638364e+02, 4.1846556e+02, 4.2055789e+02,
                                      4.2266068e+02, 4.2477398e+02, 4.2689785e+02, 4.2903234e+02,
                                      4.3117750e+02, 4.3333339e+02, 4.3550006e+02, 4.3767756e+02,
                                      4.3986595e+02, 4.4206528e+02, 4.4427560e+02, 4.4649698e+02,
                                      4.4872947e+02, 4.5097311e+02, 4.5322798e+02, 4.5549412e+02,
                                      4.5777159e+02, 4.6006045e+02, 4.6236075e+02, 4.6467255e+02,
                                      4.6699592e+02, 4.6933090e+02, 4.7167755e+02, 4.7403594e+02,
                                      4.7640612e+02, 4.7878815e+02, 4.8118209e+02, 4.8358800e+02,
                                      4.8600594e+02, 4.8843597e+02, 4.9087815e+02, 4.9333254e+02,
                                      4.9579920e+02, 4.9827820e+02, 5.0076959e+02, 5.0327344e+02,
                                      5.0578980e+02, 5.0831875e+02, 5.1086035e+02, 5.1341465e+02,
                                      5.1598172e+02, 5.1856163e+02, 5.2115444e+02, 5.2376021e+02,
                                      5.2637901e+02, 5.2901091e+02, 5.3165596e+02, 5.3431424e+02,
                                      5.3698581e+02, 5.3967074e+02, 5.4236910e+02, 5.4508094e+02,
                                      5.4780635e+02, 5.5054538e+02, 5.5329810e+02, 5.5606460e+02,
                                      5.5884492e+02, 5.6163914e+02, 5.6444734e+02, 5.6726958e+02,
                                      5.7010592e+02, 5.7295645e+02, 5.7582123e+02, 5.7870034e+02,
                                      5.8159384e+02, 5.8450181e+02, 5.8742432e+02, 5.9036144e+02,
                                      5.9331325e+02, 5.9627982e+02, 5.9926122e+02, 6.0225752e+02,
                                      6.0526881e+02, 6.0829515e+02, 6.1133663e+02, 6.1439331e+02,
                                      6.1746528e+02, 6.2055260e+02, 6.2365537e+02, 6.2677364e+02,
                                      6.2990751e+02, 6.3305705e+02, 6.3622234e+02, 6.3940345e+02,
                                      6.4260046e+02, 6.4581347e+02, 6.4904253e+02, 6.5228775e+02,
                                      6.5554919e+02, 6.5882693e+02, 6.6212107e+02, 6.6543167e+02,
                                      6.6875883e+02, 6.7210262e+02, 6.7546314e+02, 6.7884045e+02,
                                      6.8223466e+02, 6.8564583e+02, 6.8907406e+02, 6.9251943e+02,
                                      6.9598202e+02, 6.9946194e+02, 7.0295924e+02, 7.0647404e+02,
                                      7.1000641e+02, 7.1355644e+02, 7.1712423e+02, 7.2070985e+02,
                                      7.2431340e+02, 7.2793496e+02, 7.3157464e+02, 7.3523251e+02,
                                      7.3890867e+02, 7.4260322e+02, 7.4631623e+02, 7.5004781e+02,
                                      7.5379805e+02, 7.5756704e+02, 7.6135488e+02, 7.6516165e+02,
                                      7.6898746e+02, 7.7283240e+02, 7.7669656e+02, 7.8058004e+02,
                                      7.8448294e+02, 7.8840536e+02, 7.9234738e+02, 7.9630912e+02,
                                      8.0029067e+02, 8.0429212e+02, 8.0831358e+02, 8.1235515e+02,
                                      8.1641693e+02, 8.2049901e+02, 8.2460150e+02, 8.2872451e+02,
                                      8.3286813e+02, 8.3703248e+02, 8.4121764e+02, 8.4542373e+02,
                                      8.4965084e+02, 8.5389910e+02, 8.5816859e+02, 8.6245944e+02,
                                      8.6677173e+02, 8.7110559e+02, 8.7546112e+02, 8.7983843e+02,
                                      8.8423762e+02, 8.8865881e+02, 8.9310210e+02, 8.9756761e+02,
                                      9.0205545e+02, 9.0656573e+02, 9.1109856e+02, 9.1565405e+02,
                                      9.2023232e+02, 9.2483348e+02, 9.2945765e+02, 9.3410494e+02,
                                      9.3877546e+02, 9.4346934e+02, 9.4818668e+02, 9.5292762e+02,
                                      9.5769226e+02, 9.6248072e+02, 9.6729312e+02, 9.7212959e+02,
                                      9.7699023e+02, 9.8187519e+02, 9.8678456e+02, 9.9171848e+02,
                                      9.9667708e+02, 1.0016605e+03, 1.0066688e+03, 1.0117021e+03,
                                      1.0167606e+03, 1.0218444e+03, 1.0269536e+03, 1.0320884e+03,
                                      1.0372489e+03, 1.0424351e+03, 1.0476473e+03, 1.0528855e+03,
                                      1.0581499e+03, 1.0634407e+03, 1.0687579e+03, 1.0741017e+03,
                                      1.0794722e+03, 1.0848695e+03, 1.0902939e+03, 1.0957454e+03,
                                      1.1012241e+03, 1.1067302e+03, 1.1122639e+03, 1.1178252e+03,
                                      1.1234143e+03, 1.1290314e+03, 1.1346765e+03, 1.1403499e+03,
                                      1.1460517e+03, 1.1517819e+03, 1.1575408e+03, 1.1633285e+03,
                                      1.1691452e+03, 1.1749909e+03, 1.1808659e+03, 1.1867702e+03,
                                      1.1927040e+03, 1.1986676e+03, 1.2046609e+03, 1.2106842e+03,
                                      1.2167376e+03, 1.2228213e+03, 1.2289354e+03, 1.2350801e+03,
                                      1.2410448e+03, 1.2412555e+03, 1.2413551e+03, 1.2474618e+03,
                                      1.2536991e+03, 1.2599676e+03, 1.2662674e+03, 1.2725988e+03,
                                      1.2747297e+03, 1.2752703e+03, 1.2789618e+03, 1.2853566e+03,
                                      1.2917833e+03, 1.2982423e+03, 1.3047335e+03, 1.3112571e+03,
                                      1.3178134e+03, 1.3244025e+03, 1.3310245e+03, 1.3376796e+03,
                                      1.3443680e+03, 1.3510899e+03, 1.3578453e+03, 1.3646345e+03,
                                      1.3714577e+03, 1.3783150e+03, 1.3852066e+03, 1.3921326e+03,
                                      1.3990933e+03, 1.4060887e+03, 1.4131192e+03, 1.4201848e+03,
                                      1.4272857e+03, 1.4344221e+03, 1.4415942e+03, 1.4488022e+03,
                                      1.4560462e+03, 1.4633265e+03, 1.4706431e+03, 1.4779963e+03,
                                      1.4853863e+03, 1.4928132e+03, 1.5002773e+03, 1.5077787e+03,
                                      1.5153176e+03, 1.5228942e+03, 1.5305086e+03, 1.5381612e+03,
                                      1.5458520e+03, 1.5535812e+03, 1.5613491e+03, 1.5691559e+03,
                                      1.5770017e+03, 1.5848867e+03, 1.5928111e+03, 1.6007752e+03,
                                      1.6087790e+03, 1.6098611e+03, 1.6127389e+03, 1.6168229e+03,
                                      1.6249070e+03, 1.6330316e+03, 1.6411967e+03, 1.6494027e+03,
                                      1.6576497e+03, 1.6659380e+03, 1.6742677e+03, 1.6826390e+03,
                                      1.6910522e+03, 1.6995075e+03, 1.7080050e+03, 1.7165450e+03,
                                      1.7251278e+03, 1.7337534e+03, 1.7424222e+03, 1.7511343e+03,
                                      1.7598899e+03, 1.7660507e+03, 1.7686894e+03, 1.7693492e+03,
                                      1.7775328e+03, 1.7864205e+03, 1.7953526e+03, 1.8043294e+03,
                                      1.8133510e+03, 1.8224178e+03, 1.8315299e+03, 1.8406875e+03,
                                      1.8498909e+03, 1.8591404e+03, 1.8684361e+03, 1.8777783e+03,
                                      1.8871672e+03, 1.8966030e+03, 1.9060860e+03, 1.9156165e+03,
                                      1.9251945e+03, 1.9348205e+03, 1.9444946e+03, 1.9542171e+03,
                                      1.9639882e+03, 1.9642536e+03, 1.9707463e+03, 1.9738081e+03,
                                      1.9836772e+03, 1.9935955e+03, 2.0035635e+03, 2.0135813e+03,
                                      2.0236492e+03, 2.0337675e+03, 2.0439363e+03, 2.0541560e+03,
                                      2.0644268e+03, 2.0747489e+03, 2.0851227e+03, 2.0955483e+03,
                                      2.1060260e+03, 2.1165562e+03, 2.1271389e+03, 2.1377746e+03,
                                      2.1484635e+03, 2.1592058e+03, 2.1700018e+03, 2.1808519e+03,
                                      2.1917561e+03, 2.2027149e+03, 2.2137285e+03, 2.2247971e+03,
                                      2.2359211e+03, 2.2471007e+03, 2.2583362e+03, 2.2696279e+03,
                                      2.2809760e+03, 2.2923809e+03, 2.3038428e+03, 2.3153620e+03,
                                      2.3269388e+03, 2.3385735e+03, 2.3502664e+03, 2.3620177e+03,
                                      2.3738278e+03, 2.3856970e+03, 2.3976254e+03, 2.4096136e+03,
                                      2.4216616e+03, 2.4337699e+03, 2.4459388e+03, 2.4581685e+03,
                                      2.4704593e+03, 2.4828116e+03, 2.4952257e+03, 2.5077018e+03,
                                      2.5202403e+03, 2.5328415e+03, 2.5455057e+03, 2.5582333e+03,
                                      2.5710244e+03, 2.5838796e+03, 2.5967990e+03, 2.6097829e+03,
                                      2.6228319e+03, 2.6359460e+03, 2.6491257e+03, 2.6623714e+03,
                                      2.6756832e+03, 2.6890617e+03, 2.7025070e+03, 2.7160195e+03,
                                      2.7295996e+03, 2.7432476e+03, 2.7569638e+03, 2.7707486e+03,
                                      2.7846024e+03, 2.7985254e+03, 2.8125180e+03, 2.8265806e+03,
                                      2.8407135e+03, 2.8549171e+03, 2.8691917e+03, 2.8835376e+03,
                                      2.8979553e+03, 2.9124451e+03, 2.9270073e+03, 2.9416424e+03,
                                      2.9563506e+03, 2.9711323e+03, 2.9859880e+03, 3.0009179e+03,
                                      3.0159225e+03, 3.0310021e+03, 3.0461571e+03, 3.0613879e+03,
                                      3.0766949e+03, 3.0920783e+03, 3.1075387e+03, 3.1230764e+03,
                                      3.1386918e+03, 3.1543853e+03, 3.1701572e+03, 3.1860080e+03,
                                      3.2019380e+03, 3.2179477e+03, 3.2340374e+03, 3.2502076e+03,
                                      3.2664587e+03, 3.2827910e+03, 3.2992049e+03, 3.3157009e+03,
                                      3.3322794e+03, 3.3489408e+03, 3.3656856e+03, 3.3825140e+03,
                                      3.3994265e+03, 3.4164237e+03, 3.4335058e+03, 3.4506733e+03,
                                      3.4679267e+03, 3.4852663e+03, 3.5026927e+03, 3.5202061e+03,
                                      3.5378072e+03, 3.5554962e+03, 3.5732737e+03, 3.5911400e+03,
                                      3.6090957e+03, 3.6271412e+03, 3.6452769e+03, 3.6635033e+03,
                                      3.6818208e+03, 3.7002299e+03, 3.7187311e+03, 3.7373247e+03,
                                      3.7560114e+03, 3.7747914e+03, 3.7936654e+03, 3.8126337e+03,
                                      3.8316969e+03, 3.8508554e+03, 3.8701096e+03, 3.8894602e+03,
                                      3.9089075e+03, 3.9284520e+03, 3.9480943e+03, 3.9678347e+03,
                                      3.9876739e+03, 4.0550240e+03, 4.3348210e+03, 4.6339240e+03,
                                      4.9536640e+03, 5.2954670e+03, 5.6608550e+03, 6.0514530e+03,
                                      6.4690040e+03, 6.9153650e+03, 7.3637200e+03, 7.3925250e+03,
                                      7.4764300e+03, 7.5064860e+03, 7.5515700e+03, 7.6642800e+03,
                                      7.9026090e+03, 8.0865680e+03, 8.2103420e+03, 8.2433490e+03,
                                      8.2928580e+03, 8.4166320e+03, 8.4478900e+03, 8.5338400e+03,
                                      8.6644600e+03, 8.6992920e+03, 8.7515400e+03, 8.8821600e+03,
                                      9.0307940e+03, 9.6539190e+03, 1.0320040e+04, 1.1032120e+04,
                                      1.1793340e+04, 1.2607080e+04, 1.3476970e+04, 1.4406880e+04,
                                      1.5400950e+04, 1.6463620e+04, 1.7599610e+04, 1.8813980e+04,
                                      2.0112150e+04, 2.1499880e+04, 2.2983380e+04, 2.4569230e+04,
                                      2.6264500e+04, 2.8076760e+04, 3.0014050e+04, 3.2085020e+04,
                                      3.4298890e+04, 3.6665510e+04, 3.9195430e+04, 4.1899920e+04,
                                      4.4791010e+04, 4.7881590e+04, 5.0955790e+04, 5.1185420e+04,
                                      5.1735720e+04, 5.1943710e+04, 5.2255680e+04, 5.3035610e+04,
                                      5.4717210e+04, 5.8492700e+04, 6.2528700e+04, 6.6843180e+04,
                                      7.1455360e+04, 7.6385780e+04, 8.1656400e+04, 8.7290690e+04,
                                      9.3313740e+04, 9.9752390e+04, 1.0663530e+05, 1.1399310e+05,
                                      1.2185870e+05, 1.3026690e+05, 1.3925530e+05, 1.4886400e+05,
                                      1.5913560e+05, 1.7011590e+05, 1.8185390e+05, 1.9440180e+05,
                                      2.0781560e+05, 2.2215480e+05, 2.3748350e+05, 2.5386990e+05,
                                      2.7138690e+05, 2.9011260e+05, 3.1013040e+05, 3.3152940e+05,
                                      3.5440490e+05, 3.7885880e+05, 4.0500010e+05, 4.3294510e+05]), },
              '66': {'name': 'Dy',
                     'barns': 2698380000000.0,
                     'NumEdges': 19,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 26.3, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 26.3, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 62.9, 'factor': 1.0},
                     'N7': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4.2, 'factor': 1.0,
                            'twin': 'N6'},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4.2, 'factor': 0.75},
                     'N5': {'filename': 'Dy.N5', 'excl before': 5, 'excl after': 50, 'onset': 154.20000000000002,
                            'factor': 1.0, 'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 154.20000000000002,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 292.9, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 331.8, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 416.3, 'factor': 1.0},
                     'M5': {'filename': 'Dy.M5', 'excl before': 5, 'excl after': 50, 'onset': 1294.8999999999999,
                            'factor': 1.0, 'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1332.5,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Dy.M3', 'excl before': 5, 'excl after': 50, 'onset': 1675.6, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1841.8000000000002,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2046.8000000000002,
                            'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 7790.099999999999,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8580.6, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9045.8, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 53788.5, 'factor': 1.0},
                     'dat': np.array([1.40224015e+16, 1.39924495e+16, 1.73176632e+16, 1.80524320e+16,
                                      1.88721999e+16, 1.97820936e+16, 2.07869703e+16, 2.18919569e+16,
                                      2.31016407e+16, 2.44203390e+16, 2.58461630e+16, 2.73777635e+16,
                                      2.90156801e+16, 3.07561352e+16, 3.25937320e+16, 3.45284705e+16,
                                      3.49062437e+16, 3.53622699e+16, 3.54836970e+16, 5.76994595e+17,
                                      5.43642619e+17, 5.13960439e+17, 3.95906314e+17, 3.05537567e+17,
                                      2.36650624e+17, 1.85956159e+17, 1.49614377e+17, 1.24093099e+17,
                                      1.06483472e+17, 9.45350449e+16, 8.65883158e+16, 8.14317116e+16,
                                      7.82071475e+16, 7.63047896e+16, 7.59728889e+16, 7.57246379e+16,
                                      7.56652736e+16, 7.58703505e+16, 7.56976541e+16, 7.56032108e+16,
                                      7.52470247e+16, 7.52713101e+16, 7.53576583e+16, 7.24515030e+16,
                                      6.94751899e+16, 6.64071318e+16, 6.48069925e+16, 6.45722334e+16,
                                      6.43347760e+16, 6.40946201e+16, 6.38571627e+16, 6.36170069e+16,
                                      6.33795494e+16, 6.31393936e+16, 6.28965394e+16, 6.26563836e+16,
                                      6.24162278e+16, 6.21733736e+16, 6.19305194e+16, 6.16876652e+16,
                                      6.14448110e+16, 6.11992584e+16, 6.09564042e+16, 6.07108516e+16,
                                      6.04652990e+16, 6.02197465e+16, 5.99741939e+16, 5.97286413e+16,
                                      5.94803903e+16, 5.92348378e+16, 5.89865868e+16, 5.87383358e+16,
                                      5.84900849e+16, 5.82418339e+16, 5.79935830e+16, 5.77453320e+16,
                                      5.74943827e+16, 5.72461317e+16, 5.69951824e+16, 5.67442330e+16,
                                      5.64932837e+16, 5.62423343e+16, 5.59913850e+16, 5.57404357e+16,
                                      5.54894863e+16, 5.52385370e+16, 5.49848893e+16, 5.47339399e+16,
                                      5.44802922e+16, 5.42293429e+16, 5.39756951e+16, 5.37220474e+16,
                                      5.34710981e+16, 5.32174504e+16, 5.29638026e+16, 5.27101549e+16,
                                      5.24565072e+16, 5.22028595e+16, 5.19492118e+16, 5.16955640e+16,
                                      5.14419163e+16, 5.11882686e+16, 5.09346209e+16, 5.06809732e+16,
                                      5.04273254e+16, 5.01736777e+16, 4.99200300e+16, 4.96663823e+16,
                                      4.94127346e+16, 4.91590868e+16, 4.89054391e+16, 4.86517914e+16,
                                      4.83981437e+16, 4.81444960e+16, 4.78908482e+16, 4.76372005e+16,
                                      4.73862512e+16, 4.71326035e+16, 4.68816541e+16, 4.66280064e+16,
                                      4.63770571e+16, 4.61234093e+16, 4.58724600e+16, 4.56215107e+16,
                                      4.53705613e+16, 4.51196120e+16, 4.48686626e+16, 4.46177133e+16,
                                      4.43667640e+16, 4.41185130e+16, 4.38675637e+16, 4.36193127e+16,
                                      4.33683634e+16, 4.31821751e+16, 1.11880232e+17, 1.11456586e+17,
                                      1.07058226e+17, 1.02910816e+17, 9.90035622e+16, 9.53148767e+16,
                                      9.18393633e+16, 8.85581332e+16, 8.54630914e+16, 8.25407458e+16,
                                      7.97803031e+16, 7.71763664e+16, 7.47127454e+16, 7.23867419e+16,
                                      7.01875622e+16, 6.81071112e+16, 6.61372938e+16, 6.42754116e+16,
                                      6.25106711e+16, 6.08403739e+16, 5.92564248e+16, 5.77669190e+16,
                                      5.63826501e+16, 5.50901261e+16, 5.38866486e+16, 5.27587258e+16,
                                      5.17009608e+16, 5.07079570e+16, 4.97716191e+16, 4.88892488e+16,
                                      4.80554494e+16, 4.72675225e+16, 4.65200712e+16, 4.58076989e+16,
                                      4.51331039e+16, 4.44881911e+16, 4.38702620e+16, 4.32820152e+16,
                                      4.27180538e+16, 4.21756794e+16, 4.16548921e+16, 4.11556918e+16,
                                      4.06726817e+16, 4.02085604e+16, 3.97579309e+16, 3.93234917e+16,
                                      3.89025445e+16, 3.84950891e+16, 3.80984272e+16, 3.77125589e+16,
                                      3.73401824e+16, 3.69759011e+16, 3.66197150e+16, 3.62743223e+16,
                                      3.59370248e+16, 3.56078225e+16, 3.52840169e+16, 3.49710048e+16,
                                      3.46606911e+16, 3.43584725e+16, 3.40616507e+16, 3.37729241e+16,
                                      3.34868958e+16, 3.32089627e+16, 3.29337279e+16, 3.26638899e+16,
                                      3.23994487e+16, 3.21377058e+16, 3.18813597e+16, 3.16277120e+16,
                                      3.13794610e+16, 3.11339084e+16, 3.08937526e+16, 3.06562952e+16,
                                      3.04215361e+16, 3.01921738e+16, 2.99628115e+16, 2.97388460e+16,
                                      2.95175788e+16, 2.92990100e+16, 2.90831396e+16, 2.88699676e+16,
                                      2.86594940e+16, 2.84517187e+16, 2.82466418e+16, 2.80442633e+16,
                                      2.78445832e+16, 2.76476015e+16, 2.74533181e+16, 2.72590348e+16,
                                      2.70701482e+16, 2.68812616e+16, 2.66953432e+16, 2.65115835e+16,
                                      2.63297127e+16, 2.61502704e+16, 2.59727170e+16, 2.57973223e+16,
                                      2.56238165e+16, 2.54524694e+16, 2.52827412e+16, 2.51154417e+16,
                                      2.49497612e+16, 2.47859695e+16, 2.46240667e+16, 2.44640528e+16,
                                      2.43056578e+16, 2.41494216e+16, 2.39945346e+16, 2.38418063e+16,
                                      2.36906970e+16, 2.35412068e+16, 2.33936054e+16, 2.32473532e+16,
                                      2.31029899e+16, 2.29602456e+16, 2.28193901e+16, 2.26798839e+16,
                                      2.25419967e+16, 2.24057285e+16, 2.22710793e+16, 2.21380492e+16,
                                      2.20063683e+16, 2.18763063e+16, 2.17478634e+16, 2.16207698e+16,
                                      2.14952951e+16, 2.13711696e+16, 2.12483933e+16, 2.11272360e+16,
                                      2.10932365e+16, 2.37767754e+16, 2.37344108e+16, 2.36124440e+16,
                                      2.34918264e+16, 2.33725580e+16, 2.32546388e+16, 2.31380688e+16,
                                      2.30231178e+16, 2.29092462e+16, 2.27964539e+16, 2.26852807e+16,
                                      2.25751868e+16, 2.24664420e+16, 2.23590465e+16, 2.22527303e+16,
                                      2.21477634e+16, 2.20438757e+16, 2.19410675e+16, 2.18393385e+16,
                                      2.17389588e+16, 2.16396584e+16, 2.15414374e+16, 2.14440259e+16,
                                      2.13479635e+16, 2.12527107e+16, 2.11582674e+16, 2.11339820e+16,
                                      2.17950851e+16, 2.17656728e+16, 2.16733882e+16, 2.15819131e+16,
                                      2.14912475e+16, 2.14016613e+16, 2.13126148e+16, 2.12246476e+16,
                                      2.11374899e+16, 2.10511417e+16, 2.09656031e+16, 2.08806041e+16,
                                      2.07966845e+16, 2.07133046e+16, 2.06304643e+16, 2.05487034e+16,
                                      2.04672123e+16, 2.03868006e+16, 2.03066587e+16, 2.02273263e+16,
                                      2.01485336e+16, 2.00702806e+16, 1.99925673e+16, 1.99153936e+16,
                                      1.98387596e+16, 1.97626653e+16, 1.96871106e+16, 1.96118258e+16,
                                      1.95370807e+16, 1.94628753e+16, 1.93889397e+16, 1.93155437e+16,
                                      1.92424176e+16, 1.91695614e+16, 1.90972448e+16, 1.90249282e+16,
                                      1.89531513e+16, 1.88816442e+16, 1.88104070e+16, 1.87394396e+16,
                                      1.86687420e+16, 1.85980445e+16, 1.85278866e+16, 1.84577287e+16,
                                      1.83878407e+16, 1.83179526e+16, 1.82701913e+16, 1.91253079e+16,
                                      1.91083081e+16, 1.90532612e+16, 1.89814843e+16, 1.89097074e+16,
                                      1.88382003e+16, 1.87666932e+16, 1.86951862e+16, 1.86239489e+16,
                                      1.85524419e+16, 1.84812046e+16, 1.84099674e+16, 1.83387302e+16,
                                      1.82674929e+16, 1.81962557e+16, 1.81250185e+16, 1.80537812e+16,
                                      1.79825440e+16, 1.79110369e+16, 1.78397997e+16, 1.77682926e+16,
                                      1.76967856e+16, 1.76252785e+16, 1.75535016e+16, 1.74814548e+16,
                                      1.74094081e+16, 1.73373613e+16, 1.72650448e+16, 1.71927282e+16,
                                      1.71201417e+16, 1.70472855e+16, 1.69744292e+16, 1.69013031e+16,
                                      1.68281770e+16, 1.67547811e+16, 1.66811153e+16, 1.66074495e+16,
                                      1.65332441e+16, 1.64590386e+16, 1.63848332e+16, 1.63100881e+16,
                                      1.62353429e+16, 1.61605978e+16, 1.60855829e+16, 1.60102981e+16,
                                      1.59350133e+16, 1.58594586e+16, 1.57836341e+16, 1.57078097e+16,
                                      1.56317153e+16, 1.55553512e+16, 1.54789870e+16, 1.54026229e+16,
                                      1.53257190e+16, 1.52490851e+16, 1.51719114e+16, 1.50950076e+16,
                                      1.50175641e+16, 1.49403904e+16, 1.48626770e+16, 1.47852335e+16,
                                      1.47072504e+16, 1.46295370e+16, 1.45515538e+16, 1.44735706e+16,
                                      1.43953176e+16, 1.43170646e+16, 1.42385417e+16, 1.41602887e+16,
                                      1.40817659e+16, 1.40029732e+16, 1.39244503e+16, 1.38456576e+16,
                                      1.37668649e+16, 1.36880722e+16, 1.36092795e+16, 1.35304868e+16,
                                      1.34514243e+16, 1.33726316e+16, 1.32935691e+16, 1.32147764e+16,
                                      1.31357138e+16, 1.30566513e+16, 1.29773189e+16, 1.28979866e+16,
                                      1.28186542e+16, 1.27393218e+16, 1.26599894e+16, 1.25803872e+16,
                                      1.25010549e+16, 1.24214527e+16, 1.23421203e+16, 1.22627879e+16,
                                      1.21834555e+16, 1.21041232e+16, 1.20247908e+16, 1.19454584e+16,
                                      1.18663959e+16, 1.17873334e+16, 1.17085407e+16, 1.16297480e+16,
                                      1.15509553e+16, 1.14724324e+16, 1.13939096e+16, 1.13156565e+16,
                                      1.12376733e+16, 1.11596902e+16, 1.10817070e+16, 1.10037238e+16,
                                      1.09257406e+16, 1.08482971e+16, 1.07708536e+16, 1.06936799e+16,
                                      1.06167761e+16, 1.05401421e+16, 1.04637780e+16, 1.03876836e+16,
                                      1.03118592e+16, 1.02360347e+16, 1.01607499e+16, 1.00857349e+16,
                                      1.00109898e+16, 9.93651451e+15, 9.86230906e+15, 9.78837345e+15,
                                      9.71470768e+15, 9.64158158e+15, 9.56872532e+15, 9.49613890e+15,
                                      9.42382231e+15, 9.35177557e+15, 9.28026850e+15, 9.20903126e+15,
                                      9.13833371e+15, 9.06763615e+15, 8.99747827e+15, 8.92786007e+15,
                                      8.85824186e+15, 8.78943317e+15, 8.72062448e+15, 8.65235547e+15,
                                      8.58462613e+15, 8.51689679e+15, 8.44997697e+15, 8.38305715e+15,
                                      8.31667700e+15, 8.25083653e+15, 8.18526589e+15, 8.12023493e+15,
                                      8.05547381e+15, 7.99098253e+15, 7.92703093e+15, 7.86361900e+15,
                                      7.80047690e+15, 7.73760465e+15, 7.67527207e+15, 7.61347917e+15,
                                      7.55195611e+15, 7.49097272e+15, 7.43025917e+15, 7.37008529e+15,
                                      7.31018126e+15, 7.25081690e+15, 7.19172238e+15, 7.13316753e+15,
                                      7.07488252e+15, 7.01713719e+15, 6.95966170e+15, 6.90272588e+15,
                                      6.84632974e+15, 6.79020343e+15, 6.73434697e+15, 6.67903018e+15,
                                      6.62398322e+15, 6.56974579e+15, 6.51550835e+15, 6.46181059e+15,
                                      6.40325574e+15, 6.33471689e+15, 6.26698755e+15, 6.19979789e+15,
                                      6.13368758e+15, 6.06811694e+15, 6.00335582e+15, 5.93940422e+15,
                                      5.87599229e+15, 5.81338987e+15, 5.75159697e+15, 5.69034374e+15,
                                      5.62990003e+15, 5.56999600e+15, 5.51090147e+15, 5.45234663e+15,
                                      5.39460130e+15, 5.33739564e+15, 5.28072966e+15, 5.22487319e+15,
                                      5.16955640e+15, 5.11504913e+15, 5.06081169e+15, 5.00738377e+15,
                                      4.95476536e+15, 4.90241678e+15, 4.85087773e+15, 4.79960851e+15,
                                      4.74914880e+15, 4.69922877e+15, 4.64984842e+15, 4.60127758e+15,
                                      4.55216706e+15, 4.50332638e+15, 4.45502538e+15, 4.40726405e+15,
                                      4.36031224e+15, 4.31363027e+15, 4.26748797e+15, 4.22188535e+15,
                                      4.17682240e+15, 4.13202929e+15, 4.08804570e+15, 4.04460178e+15,
                                      4.00142770e+15, 3.95879330e+15, 3.91669857e+15, 3.87514352e+15,
                                      3.83385830e+15, 3.79338260e+15, 3.75317674e+15, 3.71324072e+15,
                                      3.69516157e+15, 1.42919697e+16, 1.42031930e+16, 1.40242904e+16,
                                      1.38472766e+16, 1.36726915e+16, 1.35005348e+16, 1.33302670e+16,
                                      1.33003150e+16, 2.00271065e+16, 1.98395691e+16, 1.95867309e+16,
                                      1.93368609e+16, 1.90904988e+16, 1.88471049e+16, 1.86069491e+16,
                                      1.83700314e+16, 1.81360818e+16, 1.79051005e+16, 1.76770874e+16,
                                      1.74520425e+16, 1.72296960e+16, 1.70105875e+16, 1.67941774e+16,
                                      1.65804657e+16, 1.63694524e+16, 1.61614073e+16, 1.59557908e+16,
                                      1.57528726e+16, 1.55526528e+16, 1.53551314e+16, 1.51600385e+16,
                                      1.49673742e+16, 1.47774082e+16, 1.45896010e+16, 1.44044921e+16,
                                      1.42215420e+16, 1.40410203e+16, 1.38629272e+16, 1.36869929e+16,
                                      1.35132172e+16, 1.33418701e+16, 1.31726816e+16, 1.30056519e+16,
                                      1.28407809e+16, 1.26780686e+16, 1.25175150e+16, 1.23588502e+16,
                                      1.22023442e+16, 1.20479969e+16, 1.18952686e+16, 1.17446990e+16,
                                      1.15960182e+16, 1.14494962e+16, 1.13045932e+16, 1.11658964e+16,
                                      1.11613092e+16, 1.30302072e+16, 1.29187641e+16, 1.27487661e+16,
                                      1.25809269e+16, 1.24155162e+16, 1.22522642e+16, 1.20911709e+16,
                                      1.19322364e+16, 1.17751906e+16, 1.16200338e+16, 1.14686547e+16,
                                      1.13259104e+16, 1.11853248e+16, 1.10471677e+16, 1.09111694e+16,
                                      1.07773297e+16, 1.06453789e+16, 1.05155869e+16, 1.03876836e+16,
                                      1.02713835e+16, 1.02616693e+16, 1.09386928e+16, 1.08461384e+16,
                                      1.07117591e+16, 1.05795385e+16, 1.04492067e+16, 1.03204940e+16,
                                      1.01939400e+16, 1.00692748e+16, 9.94622868e+15, 9.82453174e+15,
                                      9.70580302e+15, 9.59166155e+15, 9.47940894e+15, 9.36877536e+15,
                                      9.25976081e+15, 9.15236528e+15, 9.04685863e+15, 8.94270116e+15,
                                      8.83989288e+15, 8.73870363e+15, 8.63913341e+15, 8.54738849e+15,
                                      8.54091238e+15, 8.88252728e+15, 8.84555948e+15, 8.74598926e+15,
                                      8.64803806e+15, 8.55143606e+15, 8.45591341e+15, 8.36173994e+15,
                                      8.26864583e+15, 8.17690091e+15, 8.08623535e+15, 7.99664913e+15,
                                      7.90868194e+15, 7.82179411e+15, 7.73571578e+15, 7.64882795e+15,
                                      7.56301946e+15, 7.47829033e+15, 7.39437071e+15, 7.31153045e+15,
                                      7.22976953e+15, 7.14908797e+15, 7.06894609e+15, 6.99015339e+15,
                                      6.91190037e+15, 6.83472670e+15, 6.75863239e+15, 6.68307775e+15,
                                      6.60860246e+15, 6.53466685e+15, 6.46181059e+15, 6.38976384e+15,
                                      6.31852661e+15, 6.24782905e+15, 6.17713150e+15, 6.10724345e+15,
                                      6.03816493e+15, 5.96989591e+15, 5.90243641e+15, 5.83578643e+15,
                                      5.76967612e+15, 5.70437532e+15, 5.63988404e+15, 5.57593243e+15,
                                      5.51279034e+15, 5.45045776e+15, 5.38866486e+15, 5.32768147e+15,
                                      5.26723776e+15, 5.20706389e+15, 5.14689001e+15, 5.08752565e+15,
                                      5.02870097e+15, 4.97068580e+15, 4.91348014e+15, 4.85600465e+15,
                                      4.79906883e+15, 4.74294253e+15, 4.68735590e+15, 4.63257878e+15,
                                      4.57834135e+15, 4.52464358e+15, 4.47175534e+15, 4.41967660e+15,
                                      4.36786771e+15, 4.31686832e+15, 4.26640862e+15, 4.21675843e+15,
                                      4.16764791e+15, 4.11907707e+15, 4.07104591e+15, 4.02355442e+15,
                                      3.97606293e+15, 3.92911112e+15, 3.88269898e+15, 3.83709636e+15,
                                      3.79176358e+15, 3.74724031e+15, 3.70298687e+15, 3.65549539e+15,
                                      3.60881341e+15, 3.56267111e+15, 3.51733833e+15, 3.47227538e+15,
                                      3.42802195e+15, 3.38457803e+15, 3.34140395e+15, 3.29903939e+15,
                                      3.25694466e+15, 3.21565945e+15, 3.17491391e+15, 3.13470805e+15,
                                      3.09504186e+15, 3.05591535e+15, 3.01732852e+15, 2.97928136e+15,
                                      2.94150404e+15, 2.90453623e+15, 2.86783826e+15, 2.83194981e+15,
                                      2.79633119e+15, 2.76044274e+15, 2.72509396e+15, 2.69014994e+15,
                                      2.65569163e+15, 2.62169204e+15, 2.58815118e+15, 2.55506904e+15,
                                      2.52244562e+15, 2.49025395e+15, 2.45849402e+15, 2.42716583e+15,
                                      2.39626938e+15, 2.36577768e+15, 2.33569074e+15, 2.30600856e+15,
                                      2.27673114e+15, 2.24785848e+15, 2.21936358e+15, 2.19124646e+15,
                                      2.16312934e+15, 2.13536301e+15, 2.10797446e+15, 2.08093669e+15,
                                      2.05427669e+15, 2.02796749e+15, 2.00203606e+15, 1.97642843e+15,
                                      1.95117159e+15, 1.92623856e+15, 1.90165632e+15, 1.87739788e+15,
                                      1.85346325e+15, 1.82985243e+15, 1.80656541e+15, 1.78357521e+15,
                                      1.70861422e+15, 1.43974763e+15, 1.21464877e+15, 1.02611296e+15,
                                      8.67987895e+14, 7.34553004e+14, 6.19062340e+14, 5.22163514e+14,
                                      4.41131162e+14, 3.72862148e+14, 3.43422823e+14, 3.30389647e+14,
                                      3.27043656e+14, 9.32263306e+14, 9.05279506e+14, 8.89871756e+14,
                                      7.52875004e+14, 7.43592577e+14, 7.22896002e+14, 7.15232603e+14,
                                      9.81130968e+14, 9.39333062e+14, 9.04766814e+14, 8.68608522e+14,
                                      8.60945123e+14, 8.59434030e+14, 9.78810361e+14, 9.43596502e+14,
                                      8.43189782e+14, 7.08513637e+14, 5.90297609e+14, 4.93668621e+14,
                                      4.13229913e+14, 3.46148186e+14, 2.90210769e+14, 2.43491018e+14,
                                      2.03792451e+14, 1.70467458e+14, 1.42315260e+14, 1.18788084e+14,
                                      9.92383213e+13, 8.29778834e+13, 6.94455077e+13, 5.81716760e+13,
                                      4.83846518e+13, 4.01707831e+13, 3.33789606e+13, 2.77447432e+13,
                                      2.30312130e+13, 1.91112764e+13, 1.57933483e+13, 1.30577307e+13,
                                      1.07991866e+13, 8.93811391e+12, 8.22547175e+12, 7.88034895e+12,
                                      7.79157225e+12, 4.28313857e+13, 4.15280682e+13, 4.12447383e+13,
                                      3.49602113e+13, 2.93367874e+13, 2.45957337e+13, 2.06107661e+13,
                                      1.72574893e+13, 1.44301267e+13, 1.20293780e+13, 1.00293388e+13,
                                      8.36281930e+12, 6.97396311e+12, 5.79531073e+12, 4.81337024e+12,
                                      3.99818965e+12, 3.32143594e+12, 2.75963323e+12, 2.29289444e+12,
                                      1.90529913e+12, 1.58335542e+12, 1.31591897e+12, 1.09373437e+12,
                                      9.09111206e+11, 7.56787655e+11, 6.32257418e+11, 5.28261853e+11,
                                      4.41401000e+11, 3.68868546e+11, 3.08262931e+11, 2.57617037e+11,
                                      2.15314534e+11, 1.79968454e+11, 1.50431987e+11]),
                     'ene': np.array([4.2210000e+00, 4.2840000e+00, 1.0690000e+01, 1.1427610e+01,
                                      1.2216120e+01, 1.3059030e+01, 1.3960100e+01, 1.4923350e+01,
                                      1.5953060e+01, 1.7053820e+01, 1.8230530e+01, 1.9488440e+01,
                                      2.0833140e+01, 2.2270630e+01, 2.3807300e+01, 2.5450010e+01,
                                      2.5774000e+01, 2.6168500e+01, 2.6273700e+01, 2.6431500e+01,
                                      2.6826000e+01, 2.7206060e+01, 2.9083270e+01, 3.1090020e+01,
                                      3.3235230e+01, 3.5528460e+01, 3.7979930e+01, 4.0600540e+01,
                                      4.3401980e+01, 4.6396710e+01, 4.9598090e+01, 5.3020350e+01,
                                      5.6678760e+01, 6.0589590e+01, 6.1642000e+01, 6.2585500e+01,
                                      6.2837100e+01, 6.3214500e+01, 6.4158000e+01, 6.4770280e+01,
                                      6.9239420e+01, 7.4016950e+01, 7.9124110e+01, 8.4583680e+01,
                                      9.0419950e+01, 9.6658930e+01, 1.0000000e+02, 1.0050000e+02,
                                      1.0100250e+02, 1.0150751e+02, 1.0201505e+02, 1.0252513e+02,
                                      1.0303775e+02, 1.0355294e+02, 1.0407070e+02, 1.0459106e+02,
                                      1.0511401e+02, 1.0563958e+02, 1.0616778e+02, 1.0669862e+02,
                                      1.0723211e+02, 1.0776827e+02, 1.0830712e+02, 1.0884865e+02,
                                      1.0939289e+02, 1.0993986e+02, 1.1048956e+02, 1.1104201e+02,
                                      1.1159722e+02, 1.1215520e+02, 1.1271598e+02, 1.1327956e+02,
                                      1.1384596e+02, 1.1441519e+02, 1.1498726e+02, 1.1556220e+02,
                                      1.1614001e+02, 1.1672071e+02, 1.1730431e+02, 1.1789083e+02,
                                      1.1848029e+02, 1.1907269e+02, 1.1966805e+02, 1.2026639e+02,
                                      1.2086772e+02, 1.2147206e+02, 1.2207942e+02, 1.2268982e+02,
                                      1.2330327e+02, 1.2391979e+02, 1.2453939e+02, 1.2516208e+02,
                                      1.2578789e+02, 1.2641683e+02, 1.2704892e+02, 1.2768416e+02,
                                      1.2832258e+02, 1.2896419e+02, 1.2960902e+02, 1.3025706e+02,
                                      1.3090835e+02, 1.3156289e+02, 1.3222070e+02, 1.3288181e+02,
                                      1.3354621e+02, 1.3421395e+02, 1.3488502e+02, 1.3555944e+02,
                                      1.3623724e+02, 1.3691842e+02, 1.3760302e+02, 1.3829103e+02,
                                      1.3898249e+02, 1.3967740e+02, 1.4037579e+02, 1.4107766e+02,
                                      1.4178305e+02, 1.4249197e+02, 1.4320443e+02, 1.4392045e+02,
                                      1.4464005e+02, 1.4536325e+02, 1.4609007e+02, 1.4682052e+02,
                                      1.4755462e+02, 1.4829239e+02, 1.4903386e+02, 1.4977903e+02,
                                      1.5052792e+02, 1.5128056e+02, 1.5203696e+02, 1.5279715e+02,
                                      1.5356113e+02, 1.5414295e+02, 1.5425706e+02, 1.5432894e+02,
                                      1.5510058e+02, 1.5587609e+02, 1.5665547e+02, 1.5743875e+02,
                                      1.5822594e+02, 1.5901707e+02, 1.5981215e+02, 1.6061121e+02,
                                      1.6141427e+02, 1.6222134e+02, 1.6303245e+02, 1.6384761e+02,
                                      1.6466685e+02, 1.6549018e+02, 1.6631763e+02, 1.6714922e+02,
                                      1.6798497e+02, 1.6882489e+02, 1.6966902e+02, 1.7051736e+02,
                                      1.7136995e+02, 1.7222680e+02, 1.7308793e+02, 1.7395337e+02,
                                      1.7482314e+02, 1.7569726e+02, 1.7657574e+02, 1.7745862e+02,
                                      1.7834591e+02, 1.7923764e+02, 1.8013383e+02, 1.8103450e+02,
                                      1.8193967e+02, 1.8284937e+02, 1.8376362e+02, 1.8468244e+02,
                                      1.8560585e+02, 1.8653388e+02, 1.8746655e+02, 1.8840388e+02,
                                      1.8934590e+02, 1.9029263e+02, 1.9124409e+02, 1.9220031e+02,
                                      1.9316131e+02, 1.9412712e+02, 1.9509776e+02, 1.9607325e+02,
                                      1.9705361e+02, 1.9803888e+02, 1.9902907e+02, 2.0002422e+02,
                                      2.0102434e+02, 2.0202946e+02, 2.0303961e+02, 2.0405481e+02,
                                      2.0507508e+02, 2.0610046e+02, 2.0713096e+02, 2.0816661e+02,
                                      2.0920745e+02, 2.1025348e+02, 2.1130475e+02, 2.1236128e+02,
                                      2.1342308e+02, 2.1449020e+02, 2.1556265e+02, 2.1664046e+02,
                                      2.1772366e+02, 2.1881228e+02, 2.1990634e+02, 2.2100588e+02,
                                      2.2211090e+02, 2.2322146e+02, 2.2433757e+02, 2.2545925e+02,
                                      2.2658655e+02, 2.2771948e+02, 2.2885808e+02, 2.3000237e+02,
                                      2.3115238e+02, 2.3230814e+02, 2.3346969e+02, 2.3463703e+02,
                                      2.3581022e+02, 2.3698927e+02, 2.3817422e+02, 2.3936509e+02,
                                      2.4056191e+02, 2.4176472e+02, 2.4297355e+02, 2.4418841e+02,
                                      2.4540936e+02, 2.4663640e+02, 2.4786959e+02, 2.4910893e+02,
                                      2.5035448e+02, 2.5160625e+02, 2.5286428e+02, 2.5412860e+02,
                                      2.5539925e+02, 2.5667624e+02, 2.5795962e+02, 2.5924942e+02,
                                      2.6054567e+02, 2.6184840e+02, 2.6315764e+02, 2.6447343e+02,
                                      2.6579579e+02, 2.6712477e+02, 2.6846040e+02, 2.6980270e+02,
                                      2.7115171e+02, 2.7250747e+02, 2.7387001e+02, 2.7523936e+02,
                                      2.7661556e+02, 2.7799863e+02, 2.7938863e+02, 2.8078557e+02,
                                      2.8218950e+02, 2.8360044e+02, 2.8501845e+02, 2.8644354e+02,
                                      2.8787576e+02, 2.8931514e+02, 2.9076171e+02, 2.9221552e+02,
                                      2.9262731e+02, 2.9317269e+02, 2.9367660e+02, 2.9514498e+02,
                                      2.9662071e+02, 2.9810381e+02, 2.9959433e+02, 3.0109230e+02,
                                      3.0259776e+02, 3.0411075e+02, 3.0563130e+02, 3.0715946e+02,
                                      3.0869526e+02, 3.1023873e+02, 3.1178993e+02, 3.1334888e+02,
                                      3.1491562e+02, 3.1649020e+02, 3.1807265e+02, 3.1966301e+02,
                                      3.2126133e+02, 3.2286764e+02, 3.2448197e+02, 3.2610438e+02,
                                      3.2773491e+02, 3.2937358e+02, 3.3102045e+02, 3.3144831e+02,
                                      3.3215172e+02, 3.3267555e+02, 3.3433893e+02, 3.3601062e+02,
                                      3.3769068e+02, 3.3937913e+02, 3.4107602e+02, 3.4278140e+02,
                                      3.4449531e+02, 3.4621779e+02, 3.4794888e+02, 3.4968862e+02,
                                      3.5143706e+02, 3.5319425e+02, 3.5496022e+02, 3.5673502e+02,
                                      3.5851870e+02, 3.6031129e+02, 3.6211285e+02, 3.6392341e+02,
                                      3.6574303e+02, 3.6757174e+02, 3.6940960e+02, 3.7125665e+02,
                                      3.7311293e+02, 3.7497850e+02, 3.7685339e+02, 3.7873766e+02,
                                      3.8063135e+02, 3.8253450e+02, 3.8444718e+02, 3.8636941e+02,
                                      3.8830126e+02, 3.9024276e+02, 3.9219398e+02, 3.9415495e+02,
                                      3.9612572e+02, 3.9810635e+02, 4.0009688e+02, 4.0209737e+02,
                                      4.0410785e+02, 4.0612839e+02, 4.0815904e+02, 4.1019983e+02,
                                      4.1225083e+02, 4.1431208e+02, 4.1572967e+02, 4.1638364e+02,
                                      4.1687033e+02, 4.1846556e+02, 4.2055789e+02, 4.2266068e+02,
                                      4.2477398e+02, 4.2689785e+02, 4.2903234e+02, 4.3117750e+02,
                                      4.3333339e+02, 4.3550006e+02, 4.3767756e+02, 4.3986595e+02,
                                      4.4206528e+02, 4.4427560e+02, 4.4649698e+02, 4.4872947e+02,
                                      4.5097311e+02, 4.5322798e+02, 4.5549412e+02, 4.5777159e+02,
                                      4.6006045e+02, 4.6236075e+02, 4.6467255e+02, 4.6699592e+02,
                                      4.6933090e+02, 4.7167755e+02, 4.7403594e+02, 4.7640612e+02,
                                      4.7878815e+02, 4.8118209e+02, 4.8358800e+02, 4.8600594e+02,
                                      4.8843597e+02, 4.9087815e+02, 4.9333254e+02, 4.9579920e+02,
                                      4.9827820e+02, 5.0076959e+02, 5.0327344e+02, 5.0578980e+02,
                                      5.0831875e+02, 5.1086035e+02, 5.1341465e+02, 5.1598172e+02,
                                      5.1856163e+02, 5.2115444e+02, 5.2376021e+02, 5.2637901e+02,
                                      5.2901091e+02, 5.3165596e+02, 5.3431424e+02, 5.3698581e+02,
                                      5.3967074e+02, 5.4236910e+02, 5.4508094e+02, 5.4780635e+02,
                                      5.5054538e+02, 5.5329810e+02, 5.5606460e+02, 5.5884492e+02,
                                      5.6163914e+02, 5.6444734e+02, 5.6726958e+02, 5.7010592e+02,
                                      5.7295645e+02, 5.7582123e+02, 5.7870034e+02, 5.8159384e+02,
                                      5.8450181e+02, 5.8742432e+02, 5.9036144e+02, 5.9331325e+02,
                                      5.9627982e+02, 5.9926122e+02, 6.0225752e+02, 6.0526881e+02,
                                      6.0829515e+02, 6.1133663e+02, 6.1439331e+02, 6.1746528e+02,
                                      6.2055260e+02, 6.2365537e+02, 6.2677364e+02, 6.2990751e+02,
                                      6.3305705e+02, 6.3622234e+02, 6.3940345e+02, 6.4260046e+02,
                                      6.4581347e+02, 6.4904253e+02, 6.5228775e+02, 6.5554919e+02,
                                      6.5882693e+02, 6.6212107e+02, 6.6543167e+02, 6.6875883e+02,
                                      6.7210262e+02, 6.7546314e+02, 6.7884045e+02, 6.8223466e+02,
                                      6.8564583e+02, 6.8907406e+02, 6.9251943e+02, 6.9598202e+02,
                                      6.9946194e+02, 7.0295924e+02, 7.0647404e+02, 7.1000641e+02,
                                      7.1355644e+02, 7.1712423e+02, 7.2070985e+02, 7.2431340e+02,
                                      7.2793496e+02, 7.3157464e+02, 7.3523251e+02, 7.3890867e+02,
                                      7.4260322e+02, 7.4631623e+02, 7.5004781e+02, 7.5379805e+02,
                                      7.5756704e+02, 7.6135488e+02, 7.6516165e+02, 7.6898746e+02,
                                      7.7283240e+02, 7.7669656e+02, 7.8058004e+02, 7.8448294e+02,
                                      7.8840536e+02, 7.9234738e+02, 7.9630912e+02, 8.0029067e+02,
                                      8.0429212e+02, 8.0831358e+02, 8.1235515e+02, 8.1641693e+02,
                                      8.2049901e+02, 8.2460150e+02, 8.2872451e+02, 8.3286813e+02,
                                      8.3703248e+02, 8.4121764e+02, 8.4542373e+02, 8.4965084e+02,
                                      8.5389910e+02, 8.5816859e+02, 8.6245944e+02, 8.6677173e+02,
                                      8.7110559e+02, 8.7546112e+02, 8.7983843e+02, 8.8423762e+02,
                                      8.8865881e+02, 8.9310210e+02, 8.9756761e+02, 9.0205545e+02,
                                      9.0656573e+02, 9.1109856e+02, 9.1565405e+02, 9.2023232e+02,
                                      9.2483348e+02, 9.2945765e+02, 9.3410494e+02, 9.3877546e+02,
                                      9.4346934e+02, 9.4818668e+02, 9.5292762e+02, 9.5769226e+02,
                                      9.6248072e+02, 9.6729312e+02, 9.7212959e+02, 9.7699023e+02,
                                      9.8187519e+02, 9.8678456e+02, 9.9171848e+02, 9.9667708e+02,
                                      1.0016605e+03, 1.0066688e+03, 1.0117021e+03, 1.0167606e+03,
                                      1.0218444e+03, 1.0269536e+03, 1.0320884e+03, 1.0372489e+03,
                                      1.0424351e+03, 1.0476473e+03, 1.0528855e+03, 1.0581499e+03,
                                      1.0634407e+03, 1.0687579e+03, 1.0741017e+03, 1.0794722e+03,
                                      1.0848695e+03, 1.0902939e+03, 1.0957454e+03, 1.1012241e+03,
                                      1.1067302e+03, 1.1122639e+03, 1.1178252e+03, 1.1234143e+03,
                                      1.1290314e+03, 1.1346765e+03, 1.1403499e+03, 1.1460517e+03,
                                      1.1517819e+03, 1.1575408e+03, 1.1633285e+03, 1.1691452e+03,
                                      1.1749909e+03, 1.1808659e+03, 1.1867702e+03, 1.1927040e+03,
                                      1.1986676e+03, 1.2046609e+03, 1.2106842e+03, 1.2167376e+03,
                                      1.2228213e+03, 1.2289354e+03, 1.2350801e+03, 1.2412555e+03,
                                      1.2474618e+03, 1.2536991e+03, 1.2599676e+03, 1.2662674e+03,
                                      1.2725988e+03, 1.2789618e+03, 1.2853566e+03, 1.2917833e+03,
                                      1.2947290e+03, 1.2950709e+03, 1.2982423e+03, 1.3047335e+03,
                                      1.3112571e+03, 1.3178134e+03, 1.3244025e+03, 1.3310245e+03,
                                      1.3321988e+03, 1.3328011e+03, 1.3376796e+03, 1.3443680e+03,
                                      1.3510899e+03, 1.3578453e+03, 1.3646345e+03, 1.3714577e+03,
                                      1.3783150e+03, 1.3852066e+03, 1.3921326e+03, 1.3990933e+03,
                                      1.4060887e+03, 1.4131192e+03, 1.4201848e+03, 1.4272857e+03,
                                      1.4344221e+03, 1.4415942e+03, 1.4488022e+03, 1.4560462e+03,
                                      1.4633265e+03, 1.4706431e+03, 1.4779963e+03, 1.4853863e+03,
                                      1.4928132e+03, 1.5002773e+03, 1.5077787e+03, 1.5153176e+03,
                                      1.5228942e+03, 1.5305086e+03, 1.5381612e+03, 1.5458520e+03,
                                      1.5535812e+03, 1.5613491e+03, 1.5691559e+03, 1.5770017e+03,
                                      1.5848867e+03, 1.5928111e+03, 1.6007752e+03, 1.6087790e+03,
                                      1.6168229e+03, 1.6249070e+03, 1.6330316e+03, 1.6411967e+03,
                                      1.6494027e+03, 1.6576497e+03, 1.6659380e+03, 1.6740015e+03,
                                      1.6742677e+03, 1.6771986e+03, 1.6826390e+03, 1.6910522e+03,
                                      1.6995075e+03, 1.7080050e+03, 1.7165450e+03, 1.7251278e+03,
                                      1.7337534e+03, 1.7424222e+03, 1.7511343e+03, 1.7598899e+03,
                                      1.7686894e+03, 1.7775328e+03, 1.7864205e+03, 1.7953526e+03,
                                      1.8043294e+03, 1.8133510e+03, 1.8224178e+03, 1.8315299e+03,
                                      1.8399858e+03, 1.8406875e+03, 1.8436141e+03, 1.8498909e+03,
                                      1.8591404e+03, 1.8684361e+03, 1.8777783e+03, 1.8871672e+03,
                                      1.8966030e+03, 1.9060860e+03, 1.9156165e+03, 1.9251945e+03,
                                      1.9348205e+03, 1.9444946e+03, 1.9542171e+03, 1.9639882e+03,
                                      1.9738081e+03, 1.9836772e+03, 1.9935955e+03, 2.0035635e+03,
                                      2.0135813e+03, 2.0236492e+03, 2.0337675e+03, 2.0432385e+03,
                                      2.0439363e+03, 2.0503613e+03, 2.0541560e+03, 2.0644268e+03,
                                      2.0747489e+03, 2.0851227e+03, 2.0955483e+03, 2.1060260e+03,
                                      2.1165562e+03, 2.1271389e+03, 2.1377746e+03, 2.1484635e+03,
                                      2.1592058e+03, 2.1700018e+03, 2.1808519e+03, 2.1917561e+03,
                                      2.2027149e+03, 2.2137285e+03, 2.2247971e+03, 2.2359211e+03,
                                      2.2471007e+03, 2.2583362e+03, 2.2696279e+03, 2.2809760e+03,
                                      2.2923809e+03, 2.3038428e+03, 2.3153620e+03, 2.3269388e+03,
                                      2.3385735e+03, 2.3502664e+03, 2.3620177e+03, 2.3738278e+03,
                                      2.3856970e+03, 2.3976254e+03, 2.4096136e+03, 2.4216616e+03,
                                      2.4337699e+03, 2.4459388e+03, 2.4581685e+03, 2.4704593e+03,
                                      2.4828116e+03, 2.4952257e+03, 2.5077018e+03, 2.5202403e+03,
                                      2.5328415e+03, 2.5455057e+03, 2.5582333e+03, 2.5710244e+03,
                                      2.5838796e+03, 2.5967990e+03, 2.6097829e+03, 2.6228319e+03,
                                      2.6359460e+03, 2.6491257e+03, 2.6623714e+03, 2.6756832e+03,
                                      2.6890617e+03, 2.7025070e+03, 2.7160195e+03, 2.7295996e+03,
                                      2.7432476e+03, 2.7569638e+03, 2.7707486e+03, 2.7846024e+03,
                                      2.7985254e+03, 2.8125180e+03, 2.8265806e+03, 2.8407135e+03,
                                      2.8549171e+03, 2.8691917e+03, 2.8835376e+03, 2.8979553e+03,
                                      2.9124451e+03, 2.9270073e+03, 2.9416424e+03, 2.9563506e+03,
                                      2.9711323e+03, 2.9859880e+03, 3.0009179e+03, 3.0159225e+03,
                                      3.0310021e+03, 3.0461571e+03, 3.0613879e+03, 3.0766949e+03,
                                      3.0920783e+03, 3.1075387e+03, 3.1230764e+03, 3.1386918e+03,
                                      3.1543853e+03, 3.1701572e+03, 3.1860080e+03, 3.2019380e+03,
                                      3.2179477e+03, 3.2340374e+03, 3.2502076e+03, 3.2664587e+03,
                                      3.2827910e+03, 3.2992049e+03, 3.3157009e+03, 3.3322794e+03,
                                      3.3489408e+03, 3.3656856e+03, 3.3825140e+03, 3.3994265e+03,
                                      3.4164237e+03, 3.4335058e+03, 3.4506733e+03, 3.4679267e+03,
                                      3.4852663e+03, 3.5026927e+03, 3.5202061e+03, 3.5378072e+03,
                                      3.5554962e+03, 3.5732737e+03, 3.5911400e+03, 3.6090957e+03,
                                      3.6271412e+03, 3.6452769e+03, 3.6635033e+03, 3.6818208e+03,
                                      3.7002299e+03, 3.7187311e+03, 3.7373247e+03, 3.7560114e+03,
                                      3.7747914e+03, 3.7936654e+03, 3.8126337e+03, 3.8316969e+03,
                                      3.8508554e+03, 3.8701096e+03, 3.8894602e+03, 3.9089075e+03,
                                      3.9284520e+03, 3.9480943e+03, 3.9678347e+03, 3.9876739e+03,
                                      4.0550240e+03, 4.3348210e+03, 4.6339240e+03, 4.9536640e+03,
                                      5.2954670e+03, 5.6608550e+03, 6.0514530e+03, 6.4690040e+03,
                                      6.9153650e+03, 7.3925250e+03, 7.6342980e+03, 7.7511500e+03,
                                      7.7823100e+03, 7.8290510e+03, 7.9026090e+03, 7.9459020e+03,
                                      8.4089880e+03, 8.4478900e+03, 8.5376970e+03, 8.5720190e+03,
                                      8.6235030e+03, 8.7522120e+03, 8.8648840e+03, 9.0005710e+03,
                                      9.0307940e+03, 9.0367540e+03, 9.0910290e+03, 9.2267160e+03,
                                      9.6539190e+03, 1.0320040e+04, 1.1032120e+04, 1.1793340e+04,
                                      1.2607080e+04, 1.3476970e+04, 1.4406880e+04, 1.5400950e+04,
                                      1.6463620e+04, 1.7599610e+04, 1.8813980e+04, 2.0112150e+04,
                                      2.1499880e+04, 2.2983380e+04, 2.4569230e+04, 2.6264500e+04,
                                      2.8076760e+04, 3.0014050e+04, 3.2085020e+04, 3.4298890e+04,
                                      3.6665510e+04, 3.9195430e+04, 4.1899920e+04, 4.4791010e+04,
                                      4.7881590e+04, 5.1185420e+04, 5.2712730e+04, 5.3519560e+04,
                                      5.3734710e+04, 5.4057440e+04, 5.4717210e+04, 5.4864270e+04,
                                      5.8492700e+04, 6.2528700e+04, 6.6843180e+04, 7.1455360e+04,
                                      7.6385780e+04, 8.1656400e+04, 8.7290690e+04, 9.3313740e+04,
                                      9.9752390e+04, 1.0663530e+05, 1.1399310e+05, 1.2185870e+05,
                                      1.3026690e+05, 1.3925530e+05, 1.4886400e+05, 1.5913560e+05,
                                      1.7011590e+05, 1.8185390e+05, 1.9440180e+05, 2.0781560e+05,
                                      2.2215480e+05, 2.3748350e+05, 2.5386990e+05, 2.7138690e+05,
                                      2.9011260e+05, 3.1013040e+05, 3.3152940e+05, 3.5440490e+05,
                                      3.7885880e+05, 4.0500010e+05, 4.3294510e+05]), },
              '67': {'name': 'Ho',
                     'barns': 2738740000000.0,
                     'NumEdges': 19,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 20.299999999999997,
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 20.299999999999997,
                            'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 51.2, 'factor': 1.0},
                     'N7': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.7, 'factor': 1.0,
                            'twin': 'N6'},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 3.7, 'factor': 0.75},
                            'factor': 1.0},
                     'N5': {'filename': 'Ho.N5', 'excl before': 5, 'excl after': 50, 'onset': 161.0, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 161.0,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 306.59999999999997,
                            'factor': 1.0, 'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 343.5, 'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 435.7, 'factor': 1.0},
                     'M5': {'filename': 'Ho.M5', 'excl before': 5, 'excl after': 50, 'onset': 1351.3999999999999,
                            'factor': 1.0, 'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1391.5,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Ho.M3', 'excl before': 5, 'excl after': 50, 'onset': 1741.2, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1922.8, 'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2128.2999999999997,
                            'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8071.099999999999,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8917.8, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9394.199999999999,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 55617.7, 'factor': 1.0},
                     'dat': np.array([1.92785386e+16, 1.99465173e+16, 2.07037789e+16, 2.15541577e+16,
                                      2.25020356e+16, 2.35517946e+16, 2.47075429e+16, 2.59717453e+16,
                                      2.73465928e+16, 2.88334547e+16, 2.93127342e+16, 2.96742479e+16,
                                      2.97728425e+16, 8.80148874e+17, 8.29591733e+17, 8.09598931e+17,
                                      6.22077404e+17, 4.78293554e+17, 3.67621070e+17, 2.84472924e+17,
                                      2.23166229e+17, 1.78565848e+17, 1.46481509e+17, 1.23626724e+17,
                                      1.07517455e+17, 9.63077921e+16, 8.86475363e+16, 8.35562187e+16,
                                      8.03217667e+16, 7.99082170e+16, 7.94234600e+16, 7.93056942e+16,
                                      7.95330096e+16, 7.91632797e+16, 7.88401084e+16, 7.79500179e+16,
                                      7.77446124e+16, 7.80130089e+16, 7.85963605e+16, 7.63889361e+16,
                                      7.39733674e+16, 7.14674203e+16, 6.88519236e+16, 6.61159223e+16,
                                      6.46753451e+16, 6.44589846e+16, 6.42453629e+16, 6.40290025e+16,
                                      6.38153807e+16, 6.35962815e+16, 6.33799211e+16, 6.31608219e+16,
                                      6.29444614e+16, 6.27253622e+16, 6.25035243e+16, 6.22844251e+16,
                                      6.20625871e+16, 6.18407492e+16, 6.16189113e+16, 6.13970733e+16,
                                      6.11724966e+16, 6.09479200e+16, 6.07233433e+16, 6.04987666e+16,
                                      6.02741899e+16, 6.00468745e+16, 5.98195591e+16, 5.95922437e+16,
                                      5.93649282e+16, 5.91376128e+16, 5.89102974e+16, 5.86802432e+16,
                                      5.84501891e+16, 5.82201349e+16, 5.79900808e+16, 5.77600266e+16,
                                      5.75272337e+16, 5.72944408e+16, 5.70643866e+16, 5.68315937e+16,
                                      5.65988008e+16, 5.63632692e+16, 5.61304763e+16, 5.58976834e+16,
                                      5.56621518e+16, 5.54266201e+16, 5.51910885e+16, 5.49555568e+16,
                                      5.47200252e+16, 5.44844936e+16, 5.42489619e+16, 5.40134303e+16,
                                      5.37751599e+16, 5.35396283e+16, 5.33013579e+16, 5.30630875e+16,
                                      5.28248171e+16, 5.25865467e+16, 5.23482764e+16, 5.21100060e+16,
                                      5.18717356e+16, 5.16334652e+16, 5.13951948e+16, 5.11569245e+16,
                                      5.09159153e+16, 5.06776450e+16, 5.04393746e+16, 5.01983655e+16,
                                      4.99600951e+16, 4.97190860e+16, 4.94808156e+16, 4.92398065e+16,
                                      4.90015361e+16, 4.87605270e+16, 4.85222566e+16, 4.82812475e+16,
                                      4.80429771e+16, 4.78019680e+16, 4.75636976e+16, 4.73226885e+16,
                                      4.70844181e+16, 4.68461477e+16, 4.66051386e+16, 4.63668682e+16,
                                      4.61258591e+16, 4.58875887e+16, 4.56493183e+16, 4.54110479e+16,
                                      4.51727776e+16, 4.49345072e+16, 4.46962368e+16, 4.44579664e+16,
                                      4.42196960e+16, 4.39814257e+16, 4.37431553e+16, 4.35076236e+16,
                                      4.32693533e+16, 4.30338216e+16, 4.27955512e+16, 4.25600196e+16,
                                      4.24669024e+16, 1.04381598e+17, 1.02672624e+17, 9.88411266e+16,
                                      9.52259898e+16, 9.18135198e+16, 8.85900228e+16, 8.55445439e+16,
                                      8.26661282e+16, 7.99465593e+16, 7.73748825e+16, 7.49428814e+16,
                                      7.26423398e+16, 7.04650415e+16, 6.84027702e+16, 6.64527874e+16,
                                      6.46041379e+16, 6.28513443e+16, 6.11916678e+16, 5.96168923e+16,
                                      5.81215403e+16, 5.67028730e+16, 5.53773228e+16, 5.41394123e+16,
                                      5.29836640e+16, 5.19046005e+16, 5.08912667e+16, 4.99381852e+16,
                                      4.90426172e+16, 4.81963465e+16, 4.73993732e+16, 4.66407422e+16,
                                      4.59231923e+16, 4.52439848e+16, 4.45949034e+16, 4.39759482e+16,
                                      4.33843803e+16, 4.28201999e+16, 4.22779294e+16, 4.17575688e+16,
                                      4.12591181e+16, 4.07798386e+16, 4.03169915e+16, 3.98705769e+16,
                                      3.94378560e+16, 3.90215675e+16, 3.86162340e+16, 3.82245942e+16,
                                      3.78439093e+16, 3.74741794e+16, 3.71154045e+16, 3.67648458e+16,
                                      3.64225033e+16, 3.60911157e+16, 3.57652057e+16, 3.54475118e+16,
                                      3.51380342e+16, 3.48340341e+16, 3.45382501e+16, 3.42479437e+16,
                                      3.39603760e+16, 3.36810245e+16, 3.34071505e+16, 3.31387540e+16,
                                      3.28730962e+16, 3.26129159e+16, 3.23582131e+16, 3.21062490e+16,
                                      3.18570237e+16, 3.16132758e+16, 3.13750054e+16, 3.11367351e+16,
                                      3.09039422e+16, 3.06766267e+16, 3.04493113e+16, 3.02247346e+16,
                                      3.00056354e+16, 2.97892750e+16, 2.95756533e+16, 2.93620315e+16,
                                      2.91538873e+16, 2.89484818e+16, 2.87430763e+16, 2.85431483e+16,
                                      2.83459590e+16, 2.81487697e+16, 2.79543192e+16, 2.77626074e+16,
                                      2.75736343e+16, 2.73868523e+16, 2.72019873e+16, 2.70193133e+16,
                                      2.68385565e+16, 2.66599907e+16, 2.64833419e+16, 2.63088842e+16,
                                      2.61360697e+16, 2.59654462e+16, 2.57967398e+16, 2.56299505e+16,
                                      2.54648045e+16, 2.53015756e+16, 2.51402638e+16, 2.49805953e+16,
                                      2.48228439e+16, 2.46664618e+16, 2.45122707e+16, 2.43594491e+16,
                                      2.42085445e+16, 2.40592832e+16, 2.39113912e+16, 2.37654164e+16,
                                      2.36210848e+16, 2.34781225e+16, 2.33368035e+16, 2.31971278e+16,
                                      2.30590953e+16, 2.29224322e+16, 2.27874123e+16, 2.26537618e+16,
                                      2.25214806e+16, 2.23908427e+16, 2.22618481e+16, 2.21339489e+16,
                                      2.20076930e+16, 2.18828065e+16, 2.17592893e+16, 2.16371415e+16,
                                      2.15163631e+16, 2.13969540e+16, 2.12789143e+16, 2.12276999e+16,
                                      2.38338848e+16, 2.38136182e+16, 2.36944830e+16, 2.35767172e+16,
                                      2.34603207e+16, 2.33450198e+16, 2.32310882e+16, 2.31185260e+16,
                                      2.30067854e+16, 2.28966880e+16, 2.27874123e+16, 2.26795059e+16,
                                      2.25729690e+16, 2.24672536e+16, 2.23629076e+16, 2.22593832e+16,
                                      2.21572282e+16, 2.20561687e+16, 2.19559308e+16, 2.18570623e+16,
                                      2.17590154e+16, 2.16620640e+16, 2.15659343e+16, 2.14706261e+16,
                                      2.14522765e+16, 2.20851994e+16, 2.20517867e+16, 2.19583957e+16,
                                      2.18658263e+16, 2.17743524e+16, 2.16834262e+16, 2.15935955e+16,
                                      2.15043126e+16, 2.14161252e+16, 2.13284855e+16, 2.12416674e+16,
                                      2.11553971e+16, 2.10699484e+16, 2.09853214e+16, 2.09012421e+16,
                                      2.08179844e+16, 2.07350005e+16, 2.06528383e+16, 2.05714978e+16,
                                      2.04904311e+16, 2.04101860e+16, 2.03302148e+16, 2.02510652e+16,
                                      2.01721895e+16, 2.00938615e+16, 2.00160813e+16, 1.99388488e+16,
                                      1.98618902e+16, 1.97854794e+16, 1.97093424e+16, 1.96337532e+16,
                                      1.95584378e+16, 1.94833964e+16, 1.94089026e+16, 1.93346828e+16,
                                      1.92604629e+16, 1.91867908e+16, 1.91133926e+16, 1.90402682e+16,
                                      1.89674177e+16, 1.88945673e+16, 1.88219906e+16, 1.87496879e+16,
                                      1.86776591e+16, 1.86056302e+16, 1.85338752e+16, 1.84623941e+16,
                                      1.83906391e+16, 1.83339472e+16, 1.83194319e+16, 1.91262647e+16,
                                      1.90810755e+16, 1.90076772e+16, 1.89342790e+16, 1.88608808e+16,
                                      1.87874825e+16, 1.87140843e+16, 1.86409599e+16, 1.85678356e+16,
                                      1.84944373e+16, 1.84213130e+16, 1.83481886e+16, 1.82747904e+16,
                                      1.82016660e+16, 1.81282678e+16, 1.80551434e+16, 1.79817452e+16,
                                      1.79083470e+16, 1.78349488e+16, 1.77612766e+16, 1.76876045e+16,
                                      1.76139324e+16, 1.75399865e+16, 1.74660405e+16, 1.73918206e+16,
                                      1.73176008e+16, 1.72431070e+16, 1.71686133e+16, 1.70938457e+16,
                                      1.70190781e+16, 1.69440366e+16, 1.68687213e+16, 1.67934059e+16,
                                      1.67178167e+16, 1.66422275e+16, 1.65663644e+16, 1.64905013e+16,
                                      1.64143643e+16, 1.63379535e+16, 1.62615426e+16, 1.61848579e+16,
                                      1.61078993e+16, 1.60309407e+16, 1.59539821e+16, 1.58767497e+16,
                                      1.57992433e+16, 1.57217370e+16, 1.56439568e+16, 1.55661765e+16,
                                      1.54881224e+16, 1.54100684e+16, 1.53317404e+16, 1.52534124e+16,
                                      1.51748106e+16, 1.50962088e+16, 1.50173330e+16, 1.49384573e+16,
                                      1.48595816e+16, 1.47804320e+16, 1.47012824e+16, 1.46221329e+16,
                                      1.45427094e+16, 1.44632859e+16, 1.43835886e+16, 1.43041651e+16,
                                      1.42244678e+16, 1.41447705e+16, 1.40650731e+16, 1.39851019e+16,
                                      1.39054046e+16, 1.38254334e+16, 1.37454622e+16, 1.36654910e+16,
                                      1.35855198e+16, 1.35055486e+16, 1.34255774e+16, 1.33456061e+16,
                                      1.32656349e+16, 1.31856637e+16, 1.31059664e+16, 1.30259952e+16,
                                      1.29457501e+16, 1.28657789e+16, 1.27855338e+16, 1.27052887e+16,
                                      1.26253175e+16, 1.25450724e+16, 1.24648274e+16, 1.23848562e+16,
                                      1.23046111e+16, 1.22246399e+16, 1.21446687e+16, 1.20646974e+16,
                                      1.19850001e+16, 1.19050289e+16, 1.18256054e+16, 1.17459081e+16,
                                      1.16664847e+16, 1.15873351e+16, 1.15081855e+16, 1.14293098e+16,
                                      1.13504341e+16, 1.12718322e+16, 1.11935043e+16, 1.11151763e+16,
                                      1.10373961e+16, 1.09593420e+16, 1.08812879e+16, 1.08035077e+16,
                                      1.07260013e+16, 1.06487689e+16, 1.05718103e+16, 1.04951256e+16,
                                      1.04184408e+16, 1.03423039e+16, 1.02664408e+16, 1.01908515e+16,
                                      1.01155362e+16, 1.00404947e+16, 9.96572711e+15, 9.89123338e+15,
                                      9.81728740e+15, 9.74334142e+15, 9.66994319e+15, 9.59681883e+15,
                                      9.52424222e+15, 9.45166561e+15, 9.37963675e+15, 9.30788176e+15,
                                      9.23667452e+15, 9.16574116e+15, 9.09508167e+15, 9.02469605e+15,
                                      8.95485818e+15, 8.88556806e+15, 8.81627793e+15, 8.74753556e+15,
                                      8.67934093e+15, 8.61142018e+15, 8.54377330e+15, 8.47667417e+15,
                                      8.41012279e+15, 8.34357141e+15, 8.27784165e+15, 8.21211189e+15,
                                      8.14720375e+15, 8.08229561e+15, 8.01793522e+15, 7.95412258e+15,
                                      7.89058381e+15, 7.82759279e+15, 7.76487565e+15, 7.70270625e+15,
                                      7.64081073e+15, 7.57946295e+15, 7.51838905e+15, 7.45786289e+15,
                                      7.39788449e+15, 7.33817996e+15, 7.27874930e+15, 7.21986639e+15,
                                      7.16125735e+15, 7.10319606e+15, 7.04568252e+15, 6.98844286e+15,
                                      6.93147707e+15, 6.87505902e+15, 6.81316350e+15, 6.73949139e+15,
                                      6.66691478e+15, 6.59515979e+15, 6.52422643e+15, 6.45411468e+15,
                                      6.38455069e+15, 6.31608219e+15, 6.24816144e+15, 6.18133618e+15,
                                      6.11505867e+15, 6.04932891e+15, 5.98469465e+15, 5.92060813e+15,
                                      5.85734324e+15, 5.79462609e+15, 5.73273057e+15, 5.67165667e+15,
                                      5.61113051e+15, 5.55142598e+15, 5.49226920e+15, 5.43366016e+15,
                                      5.37587275e+15, 5.31890695e+15, 5.26221504e+15, 5.20634474e+15,
                                      5.15129607e+15, 5.09652127e+15, 5.04256809e+15, 4.98916266e+15,
                                      4.93630498e+15, 4.88426892e+15, 4.83250673e+15, 4.78156617e+15,
                                      4.73117335e+15, 4.68132828e+15, 4.63203096e+15, 4.58328139e+15,
                                      4.53507957e+15, 4.48742549e+15, 4.44004529e+15, 4.39321283e+15,
                                      4.34610651e+15, 4.29954793e+15, 4.25353709e+15, 4.20780014e+15,
                                      4.16288480e+15, 4.11851721e+15, 4.07442350e+15, 4.03087753e+15,
                                      3.98787931e+15, 3.94542884e+15, 3.90352612e+15, 3.86189727e+15,
                                      3.82081617e+15, 3.78028282e+15, 3.74002334e+15, 3.70031161e+15,
                                      3.66114763e+15, 3.62225752e+15, 3.58391516e+15, 3.58336742e+15,
                                      1.37032856e+16, 1.35433432e+16, 1.33727197e+16, 1.32045610e+16,
                                      1.30380456e+16, 1.28737212e+16, 1.27337716e+16, 1.91632377e+16,
                                      1.91525566e+16, 1.89085348e+16, 1.86675257e+16, 1.84298031e+16,
                                      1.81950931e+16, 1.79633957e+16, 1.77347109e+16, 1.75087648e+16,
                                      1.72861053e+16, 1.70659106e+16, 1.68487285e+16, 1.66345590e+16,
                                      1.64228544e+16, 1.62141624e+16, 1.60079353e+16, 1.58044469e+16,
                                      1.56034234e+16, 1.54051386e+16, 1.52095926e+16, 1.50162375e+16,
                                      1.48256212e+16, 1.46371959e+16, 1.44515094e+16, 1.42680138e+16,
                                      1.40869831e+16, 1.39081433e+16, 1.37317685e+16, 1.35575846e+16,
                                      1.33855918e+16, 1.32157899e+16, 1.30484529e+16, 1.28830330e+16,
                                      1.27198041e+16, 1.25584923e+16, 1.23993715e+16, 1.22424417e+16,
                                      1.20874290e+16, 1.19343334e+16, 1.17831550e+16, 1.16336198e+16,
                                      1.14860017e+16, 1.13403007e+16, 1.11965169e+16, 1.10543763e+16,
                                      1.09141528e+16, 1.08235005e+16, 1.26595518e+16, 1.26485968e+16,
                                      1.24902976e+16, 1.23232345e+16, 1.21583624e+16, 1.19956812e+16,
                                      1.18351910e+16, 1.16768919e+16, 1.15207837e+16, 1.13665926e+16,
                                      1.12145926e+16, 1.10688916e+16, 1.09300375e+16, 1.07933743e+16,
                                      1.06589022e+16, 1.05266211e+16, 1.03965309e+16, 1.02686318e+16,
                                      1.01426497e+16, 1.00185848e+16, 9.89671086e+15, 9.83125498e+15,
                                      1.04748589e+16, 1.04693814e+16, 1.03384696e+16, 1.02094750e+16,
                                      1.00823974e+16, 9.95751089e+15, 9.83426759e+15, 9.71294141e+15,
                                      9.59325847e+15, 9.47521878e+15, 9.35909620e+15, 9.24708174e+15,
                                      9.13835376e+15, 9.03126902e+15, 8.92610141e+15, 8.82230316e+15,
                                      8.72014816e+15, 8.61963640e+15, 8.52049401e+15, 8.42272100e+15,
                                      8.32631735e+15, 8.25593173e+15, 8.23155694e+15, 8.57417332e+15,
                                      8.52350663e+15, 8.42765073e+15, 8.33289032e+15, 8.23977316e+15,
                                      8.14747763e+15, 8.05655146e+15, 7.96699466e+15, 7.87825948e+15,
                                      7.79089368e+15, 7.70462337e+15, 7.61972243e+15, 7.53591698e+15,
                                      7.45211154e+15, 7.36830610e+15, 7.28559615e+15, 7.20398170e+15,
                                      7.12291499e+15, 7.04321766e+15, 6.96434195e+15, 6.88628786e+15,
                                      6.80905539e+15, 6.73291842e+15, 6.65760307e+15, 6.58310934e+15,
                                      6.50971111e+15, 6.43686062e+15, 6.36483176e+15, 6.29362452e+15,
                                      6.22323890e+15, 6.15367491e+15, 6.08493253e+15, 6.01701178e+15,
                                      5.94909103e+15, 5.88171802e+15, 5.81516664e+15, 5.74916301e+15,
                                      5.68398100e+15, 5.61962061e+15, 5.55608184e+15, 5.49309082e+15,
                                      5.43064755e+15, 5.36902590e+15, 5.30822587e+15, 5.24797359e+15,
                                      5.18854293e+15, 5.12966002e+15, 5.07132486e+15, 5.01381132e+15,
                                      4.95602390e+15, 4.89878424e+15, 4.84236619e+15, 4.78649590e+15,
                                      4.73117335e+15, 4.67639855e+15, 4.62162375e+15, 4.56767057e+15,
                                      4.51426514e+15, 4.46168133e+15, 4.40964527e+15, 4.35815696e+15,
                                      4.30721640e+15, 4.25709746e+15, 4.20752626e+15, 4.15850282e+15,
                                      4.11002712e+15, 4.06237304e+15, 4.01499284e+15, 3.96843426e+15,
                                      3.92214955e+15, 3.87230449e+15, 3.82300717e+15, 3.77398372e+15,
                                      3.72550802e+15, 3.67785395e+15, 3.63102149e+15, 3.58446291e+15,
                                      3.53872595e+15, 3.49353674e+15, 3.44916916e+15, 3.40534932e+15,
                                      3.36207722e+15, 3.31935288e+15, 3.27717628e+15, 3.23554744e+15,
                                      3.19446634e+15, 3.15393298e+15, 3.11422125e+15, 3.07478340e+15,
                                      3.03589329e+15, 2.99755093e+15, 2.95975632e+15, 2.92250945e+15,
                                      2.88581034e+15, 2.84938510e+15, 2.81350760e+15, 2.77845173e+15,
                                      2.74339586e+15, 2.70907945e+15, 2.67503691e+15, 2.64077527e+15,
                                      2.60700661e+15, 2.57367614e+15, 2.54078387e+15, 2.50835719e+15,
                                      2.47636871e+15, 2.44479104e+15, 2.41367895e+15, 2.38295029e+15,
                                      2.35263243e+15, 2.32275278e+15, 2.29325655e+15, 2.26414375e+15,
                                      2.23544175e+15, 2.20712318e+15, 2.17918803e+15, 2.15160892e+15,
                                      2.12441323e+15, 2.09757358e+15, 2.07098041e+15, 2.04446941e+15,
                                      2.01828706e+15, 1.99246074e+15, 1.96696307e+15, 1.94184882e+15,
                                      1.91703584e+15, 1.89257889e+15, 1.81277201e+15, 1.52780611e+15,
                                      1.28824852e+15, 1.08771798e+15, 9.19614117e+14, 7.78514232e+14,
                                      6.58173997e+14, 5.54786562e+14, 4.68297153e+14, 3.95994417e+14,
                                      3.34345379e+14, 3.33578532e+14, 3.20952941e+14, 3.17693840e+14,
                                      9.00388162e+14, 8.58868864e+14, 7.91030274e+14, 7.21301954e+14,
                                      6.93394193e+14, 6.86109145e+14, 9.41414488e+14, 9.20682226e+14,
                                      9.01456271e+14, 8.70207248e+14, 8.32193536e+14, 8.22717496e+14,
                                      9.36484756e+14, 9.00497712e+14, 8.82915001e+14, 7.40801783e+14,
                                      6.22214341e+14, 5.22852853e+14, 4.38390112e+14, 3.67401971e+14,
                                      3.07916538e+14, 2.58161849e+14, 2.16319379e+14, 1.80929381e+14,
                                      1.51298953e+14, 1.26299734e+14, 1.05523652e+14, 8.82422028e+13,
                                      7.38556016e+13, 6.18681366e+13, 5.14609246e+13, 4.27243440e+13,
                                      3.54995479e+13, 2.95236172e+13, 2.45297987e+13, 2.03693788e+13,
                                      1.68780330e+13, 1.39588100e+13, 1.15459801e+13, 9.55628548e+12,
                                      8.00232441e+12, 7.91550635e+12, 7.66737650e+12, 7.58110619e+12,
                                      4.12700731e+13, 3.97500724e+13, 3.67812782e+13, 3.08984647e+13,
                                      2.59120408e+13, 2.17203992e+13, 1.81953669e+13, 1.52197259e+13,
                                      1.26924167e+13, 1.05860517e+13, 8.83051938e+12, 7.36693673e+12,
                                      6.13696859e+12, 5.09898613e+12, 4.23710465e+12, 3.52119802e+12,
                                      2.92634369e+12, 2.43241193e+12, 2.02195697e+12, 1.68090168e+12,
                                      1.39749686e+12, 1.16196522e+12, 9.66200085e+11, 8.03464154e+11,
                                      6.70991300e+11, 5.61030889e+11, 4.69146162e+11, 3.92324505e+11,
                                      3.28101052e+11, 2.74421748e+11, 2.29536538e+11, 1.92002106e+11,
                                      1.60613407e+11]),
                     'ene': np.array([1.0690000e+01, 1.1427610e+01, 1.2216120e+01, 1.3059030e+01,
                                      1.3960100e+01, 1.4923350e+01, 1.5953060e+01, 1.7053820e+01,
                                      1.8230530e+01, 1.9488440e+01, 1.9894000e+01, 2.0198500e+01,
                                      2.0279700e+01, 2.0401500e+01, 2.0706000e+01, 2.0833140e+01,
                                      2.2270630e+01, 2.3807300e+01, 2.5450010e+01, 2.7206060e+01,
                                      2.9083270e+01, 3.1090020e+01, 3.3235230e+01, 3.5528460e+01,
                                      3.7979930e+01, 4.0600540e+01, 4.3401980e+01, 4.6396710e+01,
                                      4.9598090e+01, 5.0176000e+01, 5.0944000e+01, 5.1148800e+01,
                                      5.1456000e+01, 5.2224000e+01, 5.3020350e+01, 5.6678760e+01,
                                      6.0589590e+01, 6.4770280e+01, 6.9239420e+01, 7.4016950e+01,
                                      7.9124110e+01, 8.4583680e+01, 9.0419950e+01, 9.6658930e+01,
                                      1.0000000e+02, 1.0050000e+02, 1.0100250e+02, 1.0150751e+02,
                                      1.0201505e+02, 1.0252513e+02, 1.0303775e+02, 1.0355294e+02,
                                      1.0407070e+02, 1.0459106e+02, 1.0511401e+02, 1.0563958e+02,
                                      1.0616778e+02, 1.0669862e+02, 1.0723211e+02, 1.0776827e+02,
                                      1.0830712e+02, 1.0884865e+02, 1.0939289e+02, 1.0993986e+02,
                                      1.1048956e+02, 1.1104201e+02, 1.1159722e+02, 1.1215520e+02,
                                      1.1271598e+02, 1.1327956e+02, 1.1384596e+02, 1.1441519e+02,
                                      1.1498726e+02, 1.1556220e+02, 1.1614001e+02, 1.1672071e+02,
                                      1.1730431e+02, 1.1789083e+02, 1.1848029e+02, 1.1907269e+02,
                                      1.1966805e+02, 1.2026639e+02, 1.2086772e+02, 1.2147206e+02,
                                      1.2207942e+02, 1.2268982e+02, 1.2330327e+02, 1.2391979e+02,
                                      1.2453939e+02, 1.2516208e+02, 1.2578789e+02, 1.2641683e+02,
                                      1.2704892e+02, 1.2768416e+02, 1.2832258e+02, 1.2896419e+02,
                                      1.2960902e+02, 1.3025706e+02, 1.3090835e+02, 1.3156289e+02,
                                      1.3222070e+02, 1.3288181e+02, 1.3354621e+02, 1.3421395e+02,
                                      1.3488502e+02, 1.3555944e+02, 1.3623724e+02, 1.3691842e+02,
                                      1.3760302e+02, 1.3829103e+02, 1.3898249e+02, 1.3967740e+02,
                                      1.4037579e+02, 1.4107766e+02, 1.4178305e+02, 1.4249197e+02,
                                      1.4320443e+02, 1.4392045e+02, 1.4464005e+02, 1.4536325e+02,
                                      1.4609007e+02, 1.4682052e+02, 1.4755462e+02, 1.4829239e+02,
                                      1.4903386e+02, 1.4977903e+02, 1.5052792e+02, 1.5128056e+02,
                                      1.5203696e+02, 1.5279715e+02, 1.5356113e+02, 1.5432894e+02,
                                      1.5510058e+02, 1.5587609e+02, 1.5665547e+02, 1.5743875e+02,
                                      1.5822594e+02, 1.5901707e+02, 1.5981215e+02, 1.6061121e+02,
                                      1.6093012e+02, 1.6106987e+02, 1.6141427e+02, 1.6222134e+02,
                                      1.6303245e+02, 1.6384761e+02, 1.6466685e+02, 1.6549018e+02,
                                      1.6631763e+02, 1.6714922e+02, 1.6798497e+02, 1.6882489e+02,
                                      1.6966902e+02, 1.7051736e+02, 1.7136995e+02, 1.7222680e+02,
                                      1.7308793e+02, 1.7395337e+02, 1.7482314e+02, 1.7569726e+02,
                                      1.7657574e+02, 1.7745862e+02, 1.7834591e+02, 1.7923764e+02,
                                      1.8013383e+02, 1.8103450e+02, 1.8193967e+02, 1.8284937e+02,
                                      1.8376362e+02, 1.8468244e+02, 1.8560585e+02, 1.8653388e+02,
                                      1.8746655e+02, 1.8840388e+02, 1.8934590e+02, 1.9029263e+02,
                                      1.9124409e+02, 1.9220031e+02, 1.9316131e+02, 1.9412712e+02,
                                      1.9509776e+02, 1.9607325e+02, 1.9705361e+02, 1.9803888e+02,
                                      1.9902907e+02, 2.0002422e+02, 2.0102434e+02, 2.0202946e+02,
                                      2.0303961e+02, 2.0405481e+02, 2.0507508e+02, 2.0610046e+02,
                                      2.0713096e+02, 2.0816661e+02, 2.0920745e+02, 2.1025348e+02,
                                      2.1130475e+02, 2.1236128e+02, 2.1342308e+02, 2.1449020e+02,
                                      2.1556265e+02, 2.1664046e+02, 2.1772366e+02, 2.1881228e+02,
                                      2.1990634e+02, 2.2100588e+02, 2.2211090e+02, 2.2322146e+02,
                                      2.2433757e+02, 2.2545925e+02, 2.2658655e+02, 2.2771948e+02,
                                      2.2885808e+02, 2.3000237e+02, 2.3115238e+02, 2.3230814e+02,
                                      2.3346969e+02, 2.3463703e+02, 2.3581022e+02, 2.3698927e+02,
                                      2.3817422e+02, 2.3936509e+02, 2.4056191e+02, 2.4176472e+02,
                                      2.4297355e+02, 2.4418841e+02, 2.4540936e+02, 2.4663640e+02,
                                      2.4786959e+02, 2.4910893e+02, 2.5035448e+02, 2.5160625e+02,
                                      2.5286428e+02, 2.5412860e+02, 2.5539925e+02, 2.5667624e+02,
                                      2.5795962e+02, 2.5924942e+02, 2.6054567e+02, 2.6184840e+02,
                                      2.6315764e+02, 2.6447343e+02, 2.6579579e+02, 2.6712477e+02,
                                      2.6846040e+02, 2.6980270e+02, 2.7115171e+02, 2.7250747e+02,
                                      2.7387001e+02, 2.7523936e+02, 2.7661556e+02, 2.7799863e+02,
                                      2.7938863e+02, 2.8078557e+02, 2.8218950e+02, 2.8360044e+02,
                                      2.8501845e+02, 2.8644354e+02, 2.8787576e+02, 2.8931514e+02,
                                      2.9076171e+02, 2.9221552e+02, 2.9367660e+02, 2.9514498e+02,
                                      2.9662071e+02, 2.9810381e+02, 2.9959433e+02, 3.0109230e+02,
                                      3.0259776e+02, 3.0411075e+02, 3.0563130e+02, 3.0629770e+02,
                                      3.0690231e+02, 3.0715946e+02, 3.0869526e+02, 3.1023873e+02,
                                      3.1178993e+02, 3.1334888e+02, 3.1491562e+02, 3.1649020e+02,
                                      3.1807265e+02, 3.1966301e+02, 3.2126133e+02, 3.2286764e+02,
                                      3.2448197e+02, 3.2610438e+02, 3.2773491e+02, 3.2937358e+02,
                                      3.3102045e+02, 3.3267555e+02, 3.3433893e+02, 3.3601062e+02,
                                      3.3769068e+02, 3.3937913e+02, 3.4107602e+02, 3.4278140e+02,
                                      3.4311527e+02, 3.4388471e+02, 3.4449531e+02, 3.4621779e+02,
                                      3.4794888e+02, 3.4968862e+02, 3.5143706e+02, 3.5319425e+02,
                                      3.5496022e+02, 3.5673502e+02, 3.5851870e+02, 3.6031129e+02,
                                      3.6211285e+02, 3.6392341e+02, 3.6574303e+02, 3.6757174e+02,
                                      3.6940960e+02, 3.7125665e+02, 3.7311293e+02, 3.7497850e+02,
                                      3.7685339e+02, 3.7873766e+02, 3.8063135e+02, 3.8253450e+02,
                                      3.8444718e+02, 3.8636941e+02, 3.8830126e+02, 3.9024276e+02,
                                      3.9219398e+02, 3.9415495e+02, 3.9612572e+02, 3.9810635e+02,
                                      4.0009688e+02, 4.0209737e+02, 4.0410785e+02, 4.0612839e+02,
                                      4.0815904e+02, 4.1019983e+02, 4.1225083e+02, 4.1431208e+02,
                                      4.1638364e+02, 4.1846556e+02, 4.2055789e+02, 4.2266068e+02,
                                      4.2477398e+02, 4.2689785e+02, 4.2903234e+02, 4.3117750e+02,
                                      4.3333339e+02, 4.3505516e+02, 4.3550006e+02, 4.3634484e+02,
                                      4.3767756e+02, 4.3986595e+02, 4.4206528e+02, 4.4427560e+02,
                                      4.4649698e+02, 4.4872947e+02, 4.5097311e+02, 4.5322798e+02,
                                      4.5549412e+02, 4.5777159e+02, 4.6006045e+02, 4.6236075e+02,
                                      4.6467255e+02, 4.6699592e+02, 4.6933090e+02, 4.7167755e+02,
                                      4.7403594e+02, 4.7640612e+02, 4.7878815e+02, 4.8118209e+02,
                                      4.8358800e+02, 4.8600594e+02, 4.8843597e+02, 4.9087815e+02,
                                      4.9333254e+02, 4.9579920e+02, 4.9827820e+02, 5.0076959e+02,
                                      5.0327344e+02, 5.0578980e+02, 5.0831875e+02, 5.1086035e+02,
                                      5.1341465e+02, 5.1598172e+02, 5.1856163e+02, 5.2115444e+02,
                                      5.2376021e+02, 5.2637901e+02, 5.2901091e+02, 5.3165596e+02,
                                      5.3431424e+02, 5.3698581e+02, 5.3967074e+02, 5.4236910e+02,
                                      5.4508094e+02, 5.4780635e+02, 5.5054538e+02, 5.5329810e+02,
                                      5.5606460e+02, 5.5884492e+02, 5.6163914e+02, 5.6444734e+02,
                                      5.6726958e+02, 5.7010592e+02, 5.7295645e+02, 5.7582123e+02,
                                      5.7870034e+02, 5.8159384e+02, 5.8450181e+02, 5.8742432e+02,
                                      5.9036144e+02, 5.9331325e+02, 5.9627982e+02, 5.9926122e+02,
                                      6.0225752e+02, 6.0526881e+02, 6.0829515e+02, 6.1133663e+02,
                                      6.1439331e+02, 6.1746528e+02, 6.2055260e+02, 6.2365537e+02,
                                      6.2677364e+02, 6.2990751e+02, 6.3305705e+02, 6.3622234e+02,
                                      6.3940345e+02, 6.4260046e+02, 6.4581347e+02, 6.4904253e+02,
                                      6.5228775e+02, 6.5554919e+02, 6.5882693e+02, 6.6212107e+02,
                                      6.6543167e+02, 6.6875883e+02, 6.7210262e+02, 6.7546314e+02,
                                      6.7884045e+02, 6.8223466e+02, 6.8564583e+02, 6.8907406e+02,
                                      6.9251943e+02, 6.9598202e+02, 6.9946194e+02, 7.0295924e+02,
                                      7.0647404e+02, 7.1000641e+02, 7.1355644e+02, 7.1712423e+02,
                                      7.2070985e+02, 7.2431340e+02, 7.2793496e+02, 7.3157464e+02,
                                      7.3523251e+02, 7.3890867e+02, 7.4260322e+02, 7.4631623e+02,
                                      7.5004781e+02, 7.5379805e+02, 7.5756704e+02, 7.6135488e+02,
                                      7.6516165e+02, 7.6898746e+02, 7.7283240e+02, 7.7669656e+02,
                                      7.8058004e+02, 7.8448294e+02, 7.8840536e+02, 7.9234738e+02,
                                      7.9630912e+02, 8.0029067e+02, 8.0429212e+02, 8.0831358e+02,
                                      8.1235515e+02, 8.1641693e+02, 8.2049901e+02, 8.2460150e+02,
                                      8.2872451e+02, 8.3286813e+02, 8.3703248e+02, 8.4121764e+02,
                                      8.4542373e+02, 8.4965084e+02, 8.5389910e+02, 8.5816859e+02,
                                      8.6245944e+02, 8.6677173e+02, 8.7110559e+02, 8.7546112e+02,
                                      8.7983843e+02, 8.8423762e+02, 8.8865881e+02, 8.9310210e+02,
                                      8.9756761e+02, 9.0205545e+02, 9.0656573e+02, 9.1109856e+02,
                                      9.1565405e+02, 9.2023232e+02, 9.2483348e+02, 9.2945765e+02,
                                      9.3410494e+02, 9.3877546e+02, 9.4346934e+02, 9.4818668e+02,
                                      9.5292762e+02, 9.5769226e+02, 9.6248072e+02, 9.6729312e+02,
                                      9.7212959e+02, 9.7699023e+02, 9.8187519e+02, 9.8678456e+02,
                                      9.9171848e+02, 9.9667708e+02, 1.0016605e+03, 1.0066688e+03,
                                      1.0117021e+03, 1.0167606e+03, 1.0218444e+03, 1.0269536e+03,
                                      1.0320884e+03, 1.0372489e+03, 1.0424351e+03, 1.0476473e+03,
                                      1.0528855e+03, 1.0581499e+03, 1.0634407e+03, 1.0687579e+03,
                                      1.0741017e+03, 1.0794722e+03, 1.0848695e+03, 1.0902939e+03,
                                      1.0957454e+03, 1.1012241e+03, 1.1067302e+03, 1.1122639e+03,
                                      1.1178252e+03, 1.1234143e+03, 1.1290314e+03, 1.1346765e+03,
                                      1.1403499e+03, 1.1460517e+03, 1.1517819e+03, 1.1575408e+03,
                                      1.1633285e+03, 1.1691452e+03, 1.1749909e+03, 1.1808659e+03,
                                      1.1867702e+03, 1.1927040e+03, 1.1986676e+03, 1.2046609e+03,
                                      1.2106842e+03, 1.2167376e+03, 1.2228213e+03, 1.2289354e+03,
                                      1.2350801e+03, 1.2412555e+03, 1.2474618e+03, 1.2536991e+03,
                                      1.2599676e+03, 1.2662674e+03, 1.2725988e+03, 1.2789618e+03,
                                      1.2853566e+03, 1.2917833e+03, 1.2982423e+03, 1.3047335e+03,
                                      1.3112571e+03, 1.3178134e+03, 1.3244025e+03, 1.3310245e+03,
                                      1.3376796e+03, 1.3443680e+03, 1.3510899e+03, 1.3512135e+03,
                                      1.3515865e+03, 1.3578453e+03, 1.3646345e+03, 1.3714577e+03,
                                      1.3783150e+03, 1.3852066e+03, 1.3911646e+03, 1.3918353e+03,
                                      1.3921326e+03, 1.3990933e+03, 1.4060887e+03, 1.4131192e+03,
                                      1.4201848e+03, 1.4272857e+03, 1.4344221e+03, 1.4415942e+03,
                                      1.4488022e+03, 1.4560462e+03, 1.4633265e+03, 1.4706431e+03,
                                      1.4779963e+03, 1.4853863e+03, 1.4928132e+03, 1.5002773e+03,
                                      1.5077787e+03, 1.5153176e+03, 1.5228942e+03, 1.5305086e+03,
                                      1.5381612e+03, 1.5458520e+03, 1.5535812e+03, 1.5613491e+03,
                                      1.5691559e+03, 1.5770017e+03, 1.5848867e+03, 1.5928111e+03,
                                      1.6007752e+03, 1.6087790e+03, 1.6168229e+03, 1.6249070e+03,
                                      1.6330316e+03, 1.6411967e+03, 1.6494027e+03, 1.6576497e+03,
                                      1.6659380e+03, 1.6742677e+03, 1.6826390e+03, 1.6910522e+03,
                                      1.6995075e+03, 1.7080050e+03, 1.7165450e+03, 1.7251278e+03,
                                      1.7337534e+03, 1.7394239e+03, 1.7424222e+03, 1.7429760e+03,
                                      1.7511343e+03, 1.7598899e+03, 1.7686894e+03, 1.7775328e+03,
                                      1.7864205e+03, 1.7953526e+03, 1.8043294e+03, 1.8133510e+03,
                                      1.8224178e+03, 1.8315299e+03, 1.8406875e+03, 1.8498909e+03,
                                      1.8591404e+03, 1.8684361e+03, 1.8777783e+03, 1.8871672e+03,
                                      1.8966030e+03, 1.9060860e+03, 1.9156165e+03, 1.9208002e+03,
                                      1.9247997e+03, 1.9251945e+03, 1.9348205e+03, 1.9444946e+03,
                                      1.9542171e+03, 1.9639882e+03, 1.9738081e+03, 1.9836772e+03,
                                      1.9935955e+03, 2.0035635e+03, 2.0135813e+03, 2.0236492e+03,
                                      2.0337675e+03, 2.0439363e+03, 2.0541560e+03, 2.0644268e+03,
                                      2.0747489e+03, 2.0851227e+03, 2.0955483e+03, 2.1060260e+03,
                                      2.1165562e+03, 2.1244052e+03, 2.1271389e+03, 2.1321947e+03,
                                      2.1377746e+03, 2.1484635e+03, 2.1592058e+03, 2.1700018e+03,
                                      2.1808519e+03, 2.1917561e+03, 2.2027149e+03, 2.2137285e+03,
                                      2.2247971e+03, 2.2359211e+03, 2.2471007e+03, 2.2583362e+03,
                                      2.2696279e+03, 2.2809760e+03, 2.2923809e+03, 2.3038428e+03,
                                      2.3153620e+03, 2.3269388e+03, 2.3385735e+03, 2.3502664e+03,
                                      2.3620177e+03, 2.3738278e+03, 2.3856970e+03, 2.3976254e+03,
                                      2.4096136e+03, 2.4216616e+03, 2.4337699e+03, 2.4459388e+03,
                                      2.4581685e+03, 2.4704593e+03, 2.4828116e+03, 2.4952257e+03,
                                      2.5077018e+03, 2.5202403e+03, 2.5328415e+03, 2.5455057e+03,
                                      2.5582333e+03, 2.5710244e+03, 2.5838796e+03, 2.5967990e+03,
                                      2.6097829e+03, 2.6228319e+03, 2.6359460e+03, 2.6491257e+03,
                                      2.6623714e+03, 2.6756832e+03, 2.6890617e+03, 2.7025070e+03,
                                      2.7160195e+03, 2.7295996e+03, 2.7432476e+03, 2.7569638e+03,
                                      2.7707486e+03, 2.7846024e+03, 2.7985254e+03, 2.8125180e+03,
                                      2.8265806e+03, 2.8407135e+03, 2.8549171e+03, 2.8691917e+03,
                                      2.8835376e+03, 2.8979553e+03, 2.9124451e+03, 2.9270073e+03,
                                      2.9416424e+03, 2.9563506e+03, 2.9711323e+03, 2.9859880e+03,
                                      3.0009179e+03, 3.0159225e+03, 3.0310021e+03, 3.0461571e+03,
                                      3.0613879e+03, 3.0766949e+03, 3.0920783e+03, 3.1075387e+03,
                                      3.1230764e+03, 3.1386918e+03, 3.1543853e+03, 3.1701572e+03,
                                      3.1860080e+03, 3.2019380e+03, 3.2179477e+03, 3.2340374e+03,
                                      3.2502076e+03, 3.2664587e+03, 3.2827910e+03, 3.2992049e+03,
                                      3.3157009e+03, 3.3322794e+03, 3.3489408e+03, 3.3656856e+03,
                                      3.3825140e+03, 3.3994265e+03, 3.4164237e+03, 3.4335058e+03,
                                      3.4506733e+03, 3.4679267e+03, 3.4852663e+03, 3.5026927e+03,
                                      3.5202061e+03, 3.5378072e+03, 3.5554962e+03, 3.5732737e+03,
                                      3.5911400e+03, 3.6090957e+03, 3.6271412e+03, 3.6452769e+03,
                                      3.6635033e+03, 3.6818208e+03, 3.7002299e+03, 3.7187311e+03,
                                      3.7373247e+03, 3.7560114e+03, 3.7747914e+03, 3.7936654e+03,
                                      3.8126337e+03, 3.8316969e+03, 3.8508554e+03, 3.8701096e+03,
                                      3.8894602e+03, 3.9089075e+03, 3.9284520e+03, 3.9480943e+03,
                                      3.9678347e+03, 3.9876739e+03, 4.0550240e+03, 4.3348210e+03,
                                      4.6339240e+03, 4.9536640e+03, 5.2954670e+03, 5.6608550e+03,
                                      6.0514530e+03, 6.4690040e+03, 6.9153650e+03, 7.3925250e+03,
                                      7.9026090e+03, 7.9096780e+03, 8.0307450e+03, 8.0630290e+03,
                                      8.1114560e+03, 8.2325220e+03, 8.4478900e+03, 8.7394440e+03,
                                      8.8732110e+03, 8.9088820e+03, 8.9623890e+03, 9.0307940e+03,
                                      9.0961560e+03, 9.2063160e+03, 9.3472290e+03, 9.3848060e+03,
                                      9.4411710e+03, 9.5820840e+03, 9.6539190e+03, 1.0320040e+04,
                                      1.1032120e+04, 1.1793340e+04, 1.2607080e+04, 1.3476970e+04,
                                      1.4406880e+04, 1.5400950e+04, 1.6463620e+04, 1.7599610e+04,
                                      1.8813980e+04, 2.0112150e+04, 2.1499880e+04, 2.2983380e+04,
                                      2.4569230e+04, 2.6264500e+04, 2.8076760e+04, 3.0014050e+04,
                                      3.2085020e+04, 3.4298890e+04, 3.6665510e+04, 3.9195430e+04,
                                      4.1899920e+04, 4.4791010e+04, 4.7881590e+04, 5.1185420e+04,
                                      5.4505340e+04, 5.4717210e+04, 5.5339610e+04, 5.5562080e+04,
                                      5.5895790e+04, 5.6730050e+04, 5.8492700e+04, 6.2528700e+04,
                                      6.6843180e+04, 7.1455360e+04, 7.6385780e+04, 8.1656400e+04,
                                      8.7290690e+04, 9.3313740e+04, 9.9752390e+04, 1.0663530e+05,
                                      1.1399310e+05, 1.2185870e+05, 1.3026690e+05, 1.3925530e+05,
                                      1.4886400e+05, 1.5913560e+05, 1.7011590e+05, 1.8185390e+05,
                                      1.9440180e+05, 2.0781560e+05, 2.2215480e+05, 2.3748350e+05,
                                      2.5386990e+05, 2.7138690e+05, 2.9011260e+05, 3.1013040e+05,
                                      3.3152940e+05, 3.5440490e+05, 3.7885880e+05, 4.0500010e+05,
                                      4.3294510e+05]), },
              '68': {'name': 'Er',
                     'barns': 2777420000000.0,
                     'NumEdges': 19,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 29.4, 'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 29.4, 'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 59.8, 'factor': 1.0},
                     'N7': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4.3, 'factor': 1.0,
                            'twin': 'N6'},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 4.3, 'factor': 0.75},
                     'N5': {'filename': 'Er.N5', 'excl before': 5, 'excl after': 50, 'onset': 167.6, 'factor': 1.0,
                            'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 176.7,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 320.0, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 366.20000000000005,
                            'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 449.1, 'factor': 1.0},
                     'M5': {'filename': 'Er.M5', 'excl before': 5, 'excl after': 50, 'onset': 1409.3, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1453.3,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Er.M3', 'excl before': 5, 'excl after': 50, 'onset': 1811.8000000000002,
                            'factor': 1.0, 'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2005.7999999999997,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2206.5, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8357.900000000001,
                            'factor': 1.0, 'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9264.300000000001,
                            'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9751.300000000001,
                            'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 57485.5, 'factor': 1.0},
                     'dat': np.array([2.01037992e+16, 1.98952149e+16, 1.84606775e+16, 1.90386586e+16,
                                      1.97055172e+16, 2.04648638e+16, 2.13203091e+16, 2.22757416e+16,
                                      2.33358828e+16, 2.45046212e+16, 2.57855673e+16, 2.71792766e+16,
                                      2.86851938e+16, 3.03072070e+16, 3.20403171e+16, 3.38845240e+16,
                                      3.58342728e+16, 3.75923797e+16, 3.78867862e+16, 3.80700959e+16,
                                      3.81950798e+16, 5.80203038e+17, 5.44374320e+17, 4.67078721e+17,
                                      3.54676534e+17, 2.70395724e+17, 2.08748110e+17, 1.64953751e+17,
                                      1.34541002e+17, 1.13829781e+17, 9.99926748e+16, 9.09549502e+16,
                                      8.52334650e+16, 8.32753839e+16, 8.25449224e+16, 8.23671675e+16,
                                      8.24671546e+16, 8.21449739e+16, 8.19005610e+16, 8.02868799e+16,
                                      7.94730959e+16, 7.93425571e+16, 7.96508508e+16, 7.79482923e+16,
                                      7.52653046e+16, 7.25045491e+16, 7.10602907e+16, 7.08436519e+16,
                                      7.06297906e+16, 7.04131518e+16, 7.01965131e+16, 6.99798743e+16,
                                      6.97604581e+16, 6.95410420e+16, 6.93216258e+16, 6.91022096e+16,
                                      6.88827934e+16, 6.86605998e+16, 6.84384062e+16, 6.82162126e+16,
                                      6.79912416e+16, 6.77662706e+16, 6.75412996e+16, 6.73163285e+16,
                                      6.70913575e+16, 6.68636091e+16, 6.66358606e+16, 6.64081122e+16,
                                      6.61803638e+16, 6.59498379e+16, 6.57193120e+16, 6.54887862e+16,
                                      6.52582603e+16, 6.50249570e+16, 6.47916538e+16, 6.45583505e+16,
                                      6.43250472e+16, 6.40917439e+16, 6.38556632e+16, 6.36195825e+16,
                                      6.33835018e+16, 6.31474211e+16, 6.29085630e+16, 6.26724823e+16,
                                      6.24336242e+16, 6.21947661e+16, 6.19559079e+16, 6.17142724e+16,
                                      6.14754143e+16, 6.12337787e+16, 6.09921432e+16, 6.07505077e+16,
                                      6.05088721e+16, 6.02644592e+16, 6.00228236e+16, 5.97784107e+16,
                                      5.95339977e+16, 5.92895847e+16, 5.90423944e+16, 5.87979814e+16,
                                      5.85535684e+16, 5.83063781e+16, 5.80591877e+16, 5.78119973e+16,
                                      5.75648069e+16, 5.73176165e+16, 5.70704262e+16, 5.68204584e+16,
                                      5.65732680e+16, 5.63233002e+16, 5.60761098e+16, 5.58261420e+16,
                                      5.55761742e+16, 5.53262064e+16, 5.50762386e+16, 5.48262708e+16,
                                      5.45763030e+16, 5.43235578e+16, 5.40735900e+16, 5.38208448e+16,
                                      5.35708770e+16, 5.33181317e+16, 5.30681639e+16, 5.28154187e+16,
                                      5.25654509e+16, 5.23127057e+16, 5.20599605e+16, 5.18072153e+16,
                                      5.15572475e+16, 5.13045022e+16, 5.10517570e+16, 5.07990118e+16,
                                      5.05462666e+16, 5.02962988e+16, 5.00435536e+16, 4.97908083e+16,
                                      4.95380631e+16, 4.92853179e+16, 4.90353501e+16, 4.87826049e+16,
                                      4.85298597e+16, 4.82798919e+16, 4.80271466e+16, 4.77744014e+16,
                                      4.75244336e+16, 4.72716884e+16, 4.70217206e+16, 4.67717528e+16,
                                      4.65190076e+16, 4.62690398e+16, 4.61607204e+16, 8.00535767e+16,
                                      7.92425700e+16, 7.70456308e+16, 7.49653432e+16, 7.29933750e+16,
                                      7.11213939e+16, 6.93438451e+16, 6.76551738e+16, 6.60526024e+16,
                                      6.45305763e+16, 6.30807630e+16, 6.17031627e+16, 6.16670563e+16,
                                      8.20644287e+16, 8.02035573e+16, 7.78260858e+16, 7.55708208e+16,
                                      7.34294300e+16, 7.14019134e+16, 6.94743839e+16, 6.76468415e+16,
                                      6.59081766e+16, 6.42583891e+16, 6.27002565e+16, 6.12337787e+16,
                                      5.98478462e+16, 5.85396813e+16, 5.73037294e+16, 5.61344356e+16,
                                      5.50234676e+16, 5.39708254e+16, 5.29681768e+16, 5.20182992e+16,
                                      5.11128603e+16, 5.02574149e+16, 4.94519631e+16, 4.86881726e+16,
                                      4.79632660e+16, 4.72744658e+16, 4.66162173e+16, 4.59912978e+16,
                                      4.53941525e+16, 4.48220040e+16, 4.42720748e+16, 4.37471424e+16,
                                      4.32388746e+16, 4.27528261e+16, 4.22806647e+16, 4.18279452e+16,
                                      4.13863354e+16, 4.09613902e+16, 4.05503320e+16, 4.01503835e+16,
                                      3.97615447e+16, 3.93810382e+16, 3.90144187e+16, 3.86533541e+16,
                                      3.83033992e+16, 3.79617766e+16, 3.76284862e+16, 3.73007506e+16,
                                      3.69813473e+16, 3.66702763e+16, 3.63619826e+16, 3.60620213e+16,
                                      3.57676148e+16, 3.54759857e+16, 3.51926888e+16, 3.49121694e+16,
                                      3.46372048e+16, 3.43677951e+16, 3.41011628e+16, 3.38400853e+16,
                                      3.35817852e+16, 3.33262626e+16, 3.30762948e+16, 3.28291044e+16,
                                      3.25846914e+16, 3.23458333e+16, 3.21097526e+16, 3.18736719e+16,
                                      3.16431461e+16, 3.14153976e+16, 3.11904266e+16, 3.09682330e+16,
                                      3.07488168e+16, 3.05321781e+16, 3.03183167e+16, 3.01072328e+16,
                                      2.98961489e+16, 2.96906198e+16, 2.94850907e+16, 2.92823391e+16,
                                      2.90823648e+16, 2.88851680e+16, 2.86879712e+16, 2.84963292e+16,
                                      2.83046872e+16, 2.81158227e+16, 2.79269581e+16, 2.77419819e+16,
                                      2.75583945e+16, 2.73770289e+16, 2.71976076e+16, 2.70201305e+16,
                                      2.68443198e+16, 2.66704533e+16, 2.64985310e+16, 2.63282751e+16,
                                      2.61596858e+16, 2.59930406e+16, 2.58280618e+16, 2.56650273e+16,
                                      2.55033814e+16, 2.53436798e+16, 2.51853668e+16, 2.50289981e+16,
                                      2.48740180e+16, 2.47209822e+16, 2.45693351e+16, 2.44190766e+16,
                                      2.42707624e+16, 2.41238369e+16, 2.39785778e+16, 2.38347075e+16,
                                      2.36922258e+16, 2.35514106e+16, 2.34119841e+16, 2.32742241e+16,
                                      2.31378528e+16, 2.30025924e+16, 2.28692763e+16, 2.27370711e+16,
                                      2.52636901e+16, 2.51864778e+16, 2.50534394e+16, 2.49215119e+16,
                                      2.47912509e+16, 2.46621009e+16, 2.45343396e+16, 2.44079670e+16,
                                      2.42829831e+16, 2.41591101e+16, 2.40366259e+16, 2.39152527e+16,
                                      2.37949904e+16, 2.36761168e+16, 2.35586319e+16, 2.34419803e+16,
                                      2.33267174e+16, 2.32125654e+16, 2.30995244e+16, 2.29875944e+16,
                                      2.28767753e+16, 2.27670672e+16, 2.26581924e+16, 2.25504285e+16,
                                      2.24434978e+16, 2.23376781e+16, 2.22329694e+16, 2.21288161e+16,
                                      2.21279829e+16, 2.27087414e+16, 2.26565259e+16, 2.25543169e+16,
                                      2.24532188e+16, 2.23529539e+16, 2.22532445e+16, 2.21546461e+16,
                                      2.20568809e+16, 2.19596712e+16, 2.18635725e+16, 2.17680292e+16,
                                      2.16730415e+16, 2.15788869e+16, 2.14855656e+16, 2.13927998e+16,
                                      2.13005895e+16, 2.12092123e+16, 2.11183907e+16, 2.10281246e+16,
                                      2.09386916e+16, 2.08495365e+16, 2.07612145e+16, 2.06731703e+16,
                                      2.05856816e+16, 2.04987483e+16, 2.04123705e+16, 2.03262705e+16,
                                      2.02407260e+16, 2.01557369e+16, 2.00710256e+16, 1.99865921e+16,
                                      1.99027140e+16, 1.98191136e+16, 1.97360688e+16, 1.96530239e+16,
                                      1.95705345e+16, 1.94883229e+16, 1.94063890e+16, 1.93247329e+16,
                                      1.92433545e+16, 1.91619761e+16, 1.90919851e+16, 1.90811531e+16,
                                      1.98499430e+16, 1.98055043e+16, 1.97227372e+16, 1.96402478e+16,
                                      1.95577584e+16, 1.94758245e+16, 1.93936129e+16, 1.93116790e+16,
                                      1.92300229e+16, 1.91483667e+16, 1.90669883e+16, 1.89856099e+16,
                                      1.89042315e+16, 1.88231308e+16, 1.87417524e+16, 1.86609295e+16,
                                      1.85798288e+16, 1.84987282e+16, 1.84179052e+16, 1.83370823e+16,
                                      1.82559817e+16, 1.81751587e+16, 1.80943358e+16, 1.80132352e+16,
                                      1.79324122e+16, 1.78513116e+16, 1.77702109e+16, 1.76888325e+16,
                                      1.76077318e+16, 1.75263534e+16, 1.74449750e+16, 1.73635966e+16,
                                      1.72822182e+16, 1.72005621e+16, 1.71189059e+16, 1.70372498e+16,
                                      1.69553159e+16, 1.68736597e+16, 1.67917258e+16, 1.67095142e+16,
                                      1.66273026e+16, 1.65450909e+16, 1.64628793e+16, 1.63803899e+16,
                                      1.62979006e+16, 1.62151334e+16, 1.61323663e+16, 1.60495992e+16,
                                      1.59668321e+16, 1.58837872e+16, 1.58007424e+16, 1.57176975e+16,
                                      1.56343749e+16, 1.55513301e+16, 1.54680075e+16, 1.53846849e+16,
                                      1.53013623e+16, 1.52177619e+16, 1.51341616e+16, 1.50508390e+16,
                                      1.49672386e+16, 1.48836383e+16, 1.48000380e+16, 1.47164376e+16,
                                      1.46325595e+16, 1.45489592e+16, 1.44653588e+16, 1.43817585e+16,
                                      1.42978804e+16, 1.42142801e+16, 1.41306797e+16, 1.40470794e+16,
                                      1.39632013e+16, 1.38798787e+16, 1.37962784e+16, 1.37126780e+16,
                                      1.36290777e+16, 1.35457551e+16, 1.34624325e+16, 1.33791099e+16,
                                      1.32960650e+16, 1.32127424e+16, 1.31296976e+16, 1.30466527e+16,
                                      1.29636078e+16, 1.28805630e+16, 1.27977959e+16, 1.27147510e+16,
                                      1.26319839e+16, 1.25494945e+16, 1.24667274e+16, 1.23842380e+16,
                                      1.23020264e+16, 1.22198148e+16, 1.21376031e+16, 1.20553915e+16,
                                      1.19734576e+16, 1.18918015e+16, 1.18101453e+16, 1.17284892e+16,
                                      1.16473885e+16, 1.15662878e+16, 1.14851872e+16, 1.14043643e+16,
                                      1.13238191e+16, 1.12435516e+16, 1.11632842e+16, 1.10830168e+16,
                                      1.10030271e+16, 1.09233151e+16, 1.08438809e+16, 1.07647244e+16,
                                      1.06858457e+16, 1.06072447e+16, 1.05289215e+16, 1.04508760e+16,
                                      1.03731082e+16, 1.02956182e+16, 1.02184059e+16, 1.01417491e+16,
                                      1.00653701e+16, 9.98926877e+15, 9.91344521e+15, 9.83789938e+15,
                                      9.76290904e+15, 9.68819644e+15, 9.61376159e+15, 9.53988222e+15,
                                      9.46628059e+15, 9.39323444e+15, 9.32046604e+15, 9.24797537e+15,
                                      9.17604020e+15, 9.10438276e+15, 9.03300307e+15, 8.96217886e+15,
                                      8.89191013e+15, 8.82191915e+15, 8.75220590e+15, 8.68304815e+15,
                                      8.61444587e+15, 8.54612134e+15, 8.47807455e+15, 8.41058324e+15,
                                      8.34364742e+15, 8.27698934e+15, 8.21088675e+15, 8.14506189e+15,
                                      8.07979252e+15, 8.01480089e+15, 7.95036475e+15, 7.88620635e+15,
                                      7.82288117e+15, 7.75955600e+15, 7.69678630e+15, 7.63457210e+15,
                                      7.57291337e+15, 7.51153239e+15, 7.45042915e+15, 7.39015914e+15,
                                      7.32988912e+15, 7.26350878e+15, 7.18435231e+15, 7.10602907e+15,
                                      7.02853905e+15, 6.95188226e+15, 6.87633644e+15, 6.80134610e+15,
                                      6.72746672e+15, 6.65442058e+15, 6.58220766e+15, 6.51082796e+15,
                                      6.44028150e+15, 6.37056825e+15, 6.30168824e+15, 6.23364145e+15,
                                      6.16642788e+15, 6.09976980e+15, 6.03394495e+15, 5.96895332e+15,
                                      5.90451718e+15, 5.84119200e+15, 5.77842231e+15, 5.71620810e+15,
                                      5.65482712e+15, 5.59427936e+15, 5.53400935e+15, 5.47485030e+15,
                                      5.41624674e+15, 5.35819866e+15, 5.30098381e+15, 5.24432444e+15,
                                      5.18822056e+15, 5.13294990e+15, 5.07823473e+15, 5.02407504e+15,
                                      4.97074857e+15, 4.91769985e+15, 4.86548436e+15, 4.81382434e+15,
                                      4.76271982e+15, 4.71217077e+15, 4.66245495e+15, 4.61301688e+15,
                                      4.56413429e+15, 4.51580718e+15, 4.46831330e+15, 4.42109716e+15,
                                      4.37443650e+15, 4.32833133e+15, 4.28278164e+15, 4.23695421e+15,
                                      4.19140452e+15, 4.14641032e+15, 4.10197160e+15, 4.05808836e+15,
                                      4.01448287e+15, 3.97171060e+15, 3.92921607e+15, 3.88727703e+15,
                                      3.84589347e+15, 3.80478766e+15, 3.76423733e+15, 3.72424248e+15,
                                      3.68452537e+15, 3.64536375e+15, 3.60647987e+15, 3.56842922e+15,
                                      3.53037856e+15, 3.49316113e+15, 3.47705210e+15, 1.31749695e+16,
                                      1.30894250e+16, 1.29241685e+16, 1.27614117e+16, 1.26003213e+16,
                                      1.24417306e+16, 1.22848064e+16, 1.21964844e+16, 1.83329162e+16,
                                      1.82565371e+16, 1.80240671e+16, 1.77943745e+16, 1.75674592e+16,
                                      1.73435992e+16, 1.71225166e+16, 1.69042113e+16, 1.66889613e+16,
                                      1.64764887e+16, 1.62665157e+16, 1.60595979e+16, 1.58551798e+16,
                                      1.56532614e+16, 1.54541204e+16, 1.52574790e+16, 1.50633374e+16,
                                      1.48716954e+16, 1.46828308e+16, 1.44961882e+16, 1.43117675e+16,
                                      1.41298465e+16, 1.39504252e+16, 1.37732258e+16, 1.35982483e+16,
                                      1.34254928e+16, 1.32552370e+16, 1.30869253e+16, 1.29208356e+16,
                                      1.27569678e+16, 1.25950442e+16, 1.24353426e+16, 1.22775851e+16,
                                      1.21220496e+16, 1.19684583e+16, 1.18168111e+16, 1.16671082e+16,
                                      1.15193494e+16, 1.13732572e+16, 1.12293868e+16, 1.10871829e+16,
                                      1.09469232e+16, 1.08083299e+16, 1.06716809e+16, 1.05364205e+16,
                                      1.04542089e+16, 1.22353683e+16, 1.22284248e+16, 1.20706673e+16,
                                      1.19084660e+16, 1.17479311e+16, 1.15898959e+16, 1.14338049e+16,
                                      1.12802136e+16, 1.11285665e+16, 1.09788635e+16, 1.08311048e+16,
                                      1.06900118e+16, 1.05555847e+16, 1.04233795e+16, 1.02933963e+16,
                                      1.01656349e+16, 1.00400956e+16, 9.91594488e+15, 9.79401615e+15,
                                      9.67375386e+15, 9.55571351e+15, 9.43933961e+15, 9.43850639e+15,
                                      1.00573156e+16, 9.98649135e+15, 9.86095197e+15, 9.73763452e+15,
                                      9.61626127e+15, 9.49655446e+15, 9.37879186e+15, 9.26269570e+15,
                                      9.14826600e+15, 9.03550274e+15, 8.92496143e+15, 8.81969721e+15,
                                      8.71609944e+15, 8.61389039e+15, 8.51362553e+15, 8.41474937e+15,
                                      8.31753967e+15, 8.22144094e+15, 8.12700866e+15, 8.03757574e+15,
                                      8.03396509e+15, 8.34031452e+15, 8.31448451e+15, 8.22060772e+15,
                                      8.12784189e+15, 8.03646477e+15, 7.94619862e+15, 7.85732118e+15,
                                      7.76927697e+15, 7.68262146e+15, 7.59707693e+15, 7.51236562e+15,
                                      7.42959850e+15, 7.34766461e+15, 7.26684169e+15, 7.18574102e+15,
                                      7.10491810e+15, 7.02492841e+15, 6.94604968e+15, 6.86800418e+15,
                                      6.79079190e+15, 6.71469059e+15, 6.63914477e+15, 6.56470991e+15,
                                      6.49110828e+15, 6.41833988e+15, 6.34640470e+15, 6.27530275e+15,
                                      6.20503402e+15, 6.13559852e+15, 6.06671851e+15, 5.99867172e+15,
                                      5.93145815e+15, 5.86507781e+15, 5.79925296e+15, 5.73426133e+15,
                                      5.66899196e+15, 5.60483356e+15, 5.54123064e+15, 5.47818321e+15,
                                      5.41596900e+15, 5.35458802e+15, 5.29376252e+15, 5.23349251e+15,
                                      5.17405572e+15, 5.11517441e+15, 5.05712634e+15, 4.99963374e+15,
                                      4.94269663e+15, 4.88659275e+15, 4.83104435e+15, 4.77577369e+15,
                                      4.72050303e+15, 4.66606560e+15, 4.61246139e+15, 4.55913493e+15,
                                      4.50636395e+15, 4.45414845e+15, 4.40221070e+15, 4.35082843e+15,
                                      4.30027939e+15, 4.25028583e+15, 4.20084775e+15, 4.15168742e+15,
                                      4.09891644e+15, 4.04670094e+15, 3.99504093e+15, 3.94421414e+15,
                                      3.89422058e+15, 3.84478251e+15, 3.79589991e+15, 3.74785055e+15,
                                      3.70035667e+15, 3.65341827e+15, 3.60703535e+15, 3.56093018e+15,
                                      3.51593598e+15, 3.47121952e+15, 3.42705854e+15, 3.38373079e+15,
                                      3.34095852e+15, 3.29874173e+15, 3.25708043e+15, 3.21569688e+15,
                                      3.17514654e+15, 3.13487395e+15, 3.09515685e+15, 3.05599523e+15,
                                      3.01766683e+15, 2.97933843e+15, 2.94184326e+15, 2.90490358e+15,
                                      2.86824163e+15, 2.83213517e+15, 2.79658420e+15, 2.76156093e+15,
                                      2.72695428e+15, 2.69279201e+15, 2.65907413e+15, 2.62582842e+15,
                                      2.59302709e+15, 2.56050350e+15, 2.52778549e+15, 2.49548410e+15,
                                      2.46365486e+15, 2.43224224e+15, 2.40124624e+15, 2.37069462e+15,
                                      2.34053183e+15, 2.31078567e+15, 2.28142834e+15, 2.25245985e+15,
                                      2.22390797e+15, 2.19571716e+15, 2.16791518e+15, 2.14047427e+15,
                                      2.11342220e+15, 2.08670342e+15, 2.06037348e+15, 2.03437683e+15,
                                      2.00874124e+15, 1.92419658e+15, 1.62118005e+15, 1.36654619e+15,
                                      1.15310146e+15, 9.74263388e+14, 8.24254933e+14, 6.98187840e+14,
                                      5.89201879e+14, 4.97102632e+14, 4.19945904e+14, 3.55232018e+14,
                                      3.24236011e+14, 3.11987589e+14, 3.08821330e+14, 8.68832524e+14,
                                      8.53223424e+14, 8.29059870e+14, 7.01992905e+14, 6.92049741e+14,
                                      6.64442187e+14, 6.57331991e+14, 9.02244887e+14, 8.64527523e+14,
                                      8.36864420e+14, 8.12423124e+14, 8.00535767e+14, 7.91370281e+14,
                                      9.00384016e+14, 8.65694040e+14, 7.84898892e+14, 6.57193120e+14,
                                      5.52345515e+14, 4.63718043e+14, 3.88699929e+14, 3.25791366e+14,
                                      2.73156480e+14, 2.29123263e+14, 1.91783628e+14, 1.60498770e+14,
                                      1.34154941e+14, 1.12096671e+14, 9.37434798e+13, 7.84648924e+13,
                                      6.57359766e+13, 5.46790675e+13, 4.54024847e+13, 3.77256959e+13,
                                      3.13737363e+13, 2.61016377e+13, 2.16874841e+13, 1.80132352e+13,
                                      1.49072464e+13, 1.23356332e+13, 1.02095182e+13, 8.45641067e+12,
                                      7.78982987e+12, 7.46431625e+12, 7.38043817e+12, 3.98004286e+13,
                                      3.85644767e+13, 3.83283960e+13, 3.24763721e+13, 2.72573221e+13,
                                      2.28576111e+13, 1.91644757e+13, 1.60382118e+13, 1.33793876e+13,
                                      1.11630065e+13, 9.31491120e+12, 7.77372084e+12, 6.48860860e+12,
                                      5.39597158e+12, 4.48553330e+12, 3.72896409e+12, 3.10043395e+12,
                                      2.57791792e+12, 2.14369608e+12, 1.78279812e+12, 1.48275344e+12,
                                      1.23331335e+12, 1.02592340e+12, 8.53473392e+11, 7.11213939e+11,
                                      5.95117783e+11, 4.97991406e+11, 4.16779645e+11, 3.48816178e+11,
                                      2.91962390e+11, 2.44379631e+11, 2.04568093e+11, 1.71252940e+11]),
                     'ene': np.array([4.3215000e+00, 4.3860000e+00, 1.0690000e+01, 1.1427610e+01,
                                      1.2216120e+01, 1.3059030e+01, 1.3960100e+01, 1.4923350e+01,
                                      1.5953060e+01, 1.7053820e+01, 1.8230530e+01, 1.9488440e+01,
                                      2.0833140e+01, 2.2270630e+01, 2.3807300e+01, 2.5450010e+01,
                                      2.7206060e+01, 2.8812000e+01, 2.9083270e+01, 2.9253000e+01,
                                      2.9370600e+01, 2.9547000e+01, 2.9988000e+01, 3.1090020e+01,
                                      3.3235230e+01, 3.5528460e+01, 3.7979930e+01, 4.0600540e+01,
                                      4.3401980e+01, 4.6396710e+01, 4.9598090e+01, 5.3020350e+01,
                                      5.6678760e+01, 5.8604000e+01, 5.9501000e+01, 5.9740200e+01,
                                      6.0099000e+01, 6.0589590e+01, 6.0996000e+01, 6.4770280e+01,
                                      6.9239420e+01, 7.4016950e+01, 7.9124110e+01, 8.4583680e+01,
                                      9.0419950e+01, 9.6658930e+01, 1.0000000e+02, 1.0050000e+02,
                                      1.0100250e+02, 1.0150751e+02, 1.0201505e+02, 1.0252513e+02,
                                      1.0303775e+02, 1.0355294e+02, 1.0407070e+02, 1.0459106e+02,
                                      1.0511401e+02, 1.0563958e+02, 1.0616778e+02, 1.0669862e+02,
                                      1.0723211e+02, 1.0776827e+02, 1.0830712e+02, 1.0884865e+02,
                                      1.0939289e+02, 1.0993986e+02, 1.1048956e+02, 1.1104201e+02,
                                      1.1159722e+02, 1.1215520e+02, 1.1271598e+02, 1.1327956e+02,
                                      1.1384596e+02, 1.1441519e+02, 1.1498726e+02, 1.1556220e+02,
                                      1.1614001e+02, 1.1672071e+02, 1.1730431e+02, 1.1789083e+02,
                                      1.1848029e+02, 1.1907269e+02, 1.1966805e+02, 1.2026639e+02,
                                      1.2086772e+02, 1.2147206e+02, 1.2207942e+02, 1.2268982e+02,
                                      1.2330327e+02, 1.2391979e+02, 1.2453939e+02, 1.2516208e+02,
                                      1.2578789e+02, 1.2641683e+02, 1.2704892e+02, 1.2768416e+02,
                                      1.2832258e+02, 1.2896419e+02, 1.2960902e+02, 1.3025706e+02,
                                      1.3090835e+02, 1.3156289e+02, 1.3222070e+02, 1.3288181e+02,
                                      1.3354621e+02, 1.3421395e+02, 1.3488502e+02, 1.3555944e+02,
                                      1.3623724e+02, 1.3691842e+02, 1.3760302e+02, 1.3829103e+02,
                                      1.3898249e+02, 1.3967740e+02, 1.4037579e+02, 1.4107766e+02,
                                      1.4178305e+02, 1.4249197e+02, 1.4320443e+02, 1.4392045e+02,
                                      1.4464005e+02, 1.4536325e+02, 1.4609007e+02, 1.4682052e+02,
                                      1.4755462e+02, 1.4829239e+02, 1.4903386e+02, 1.4977903e+02,
                                      1.5052792e+02, 1.5128056e+02, 1.5203696e+02, 1.5279715e+02,
                                      1.5356113e+02, 1.5432894e+02, 1.5510058e+02, 1.5587609e+02,
                                      1.5665547e+02, 1.5743875e+02, 1.5822594e+02, 1.5901707e+02,
                                      1.5981215e+02, 1.6061121e+02, 1.6141427e+02, 1.6222134e+02,
                                      1.6303245e+02, 1.6384761e+02, 1.6466685e+02, 1.6549018e+02,
                                      1.6631763e+02, 1.6714922e+02, 1.6751369e+02, 1.6768632e+02,
                                      1.6798497e+02, 1.6882489e+02, 1.6966902e+02, 1.7051736e+02,
                                      1.7136995e+02, 1.7222680e+02, 1.7308793e+02, 1.7395337e+02,
                                      1.7482314e+02, 1.7569726e+02, 1.7657574e+02, 1.7660087e+02,
                                      1.7679912e+02, 1.7745862e+02, 1.7834591e+02, 1.7923764e+02,
                                      1.8013383e+02, 1.8103450e+02, 1.8193967e+02, 1.8284937e+02,
                                      1.8376362e+02, 1.8468244e+02, 1.8560585e+02, 1.8653388e+02,
                                      1.8746655e+02, 1.8840388e+02, 1.8934590e+02, 1.9029263e+02,
                                      1.9124409e+02, 1.9220031e+02, 1.9316131e+02, 1.9412712e+02,
                                      1.9509776e+02, 1.9607325e+02, 1.9705361e+02, 1.9803888e+02,
                                      1.9902907e+02, 2.0002422e+02, 2.0102434e+02, 2.0202946e+02,
                                      2.0303961e+02, 2.0405481e+02, 2.0507508e+02, 2.0610046e+02,
                                      2.0713096e+02, 2.0816661e+02, 2.0920745e+02, 2.1025348e+02,
                                      2.1130475e+02, 2.1236128e+02, 2.1342308e+02, 2.1449020e+02,
                                      2.1556265e+02, 2.1664046e+02, 2.1772366e+02, 2.1881228e+02,
                                      2.1990634e+02, 2.2100588e+02, 2.2211090e+02, 2.2322146e+02,
                                      2.2433757e+02, 2.2545925e+02, 2.2658655e+02, 2.2771948e+02,
                                      2.2885808e+02, 2.3000237e+02, 2.3115238e+02, 2.3230814e+02,
                                      2.3346969e+02, 2.3463703e+02, 2.3581022e+02, 2.3698927e+02,
                                      2.3817422e+02, 2.3936509e+02, 2.4056191e+02, 2.4176472e+02,
                                      2.4297355e+02, 2.4418841e+02, 2.4540936e+02, 2.4663640e+02,
                                      2.4786959e+02, 2.4910893e+02, 2.5035448e+02, 2.5160625e+02,
                                      2.5286428e+02, 2.5412860e+02, 2.5539925e+02, 2.5667624e+02,
                                      2.5795962e+02, 2.5924942e+02, 2.6054567e+02, 2.6184840e+02,
                                      2.6315764e+02, 2.6447343e+02, 2.6579579e+02, 2.6712477e+02,
                                      2.6846040e+02, 2.6980270e+02, 2.7115171e+02, 2.7250747e+02,
                                      2.7387001e+02, 2.7523936e+02, 2.7661556e+02, 2.7799863e+02,
                                      2.7938863e+02, 2.8078557e+02, 2.8218950e+02, 2.8360044e+02,
                                      2.8501845e+02, 2.8644354e+02, 2.8787576e+02, 2.8931514e+02,
                                      2.9076171e+02, 2.9221552e+02, 2.9367660e+02, 2.9514498e+02,
                                      2.9662071e+02, 2.9810381e+02, 2.9959433e+02, 3.0109230e+02,
                                      3.0259776e+02, 3.0411075e+02, 3.0563130e+02, 3.0715946e+02,
                                      3.0869526e+02, 3.1023873e+02, 3.1178993e+02, 3.1334888e+02,
                                      3.1491562e+02, 3.1649020e+02, 3.1807265e+02, 3.1966301e+02,
                                      3.2033919e+02, 3.2126133e+02, 3.2286764e+02, 3.2448197e+02,
                                      3.2610438e+02, 3.2773491e+02, 3.2937358e+02, 3.3102045e+02,
                                      3.3267555e+02, 3.3433893e+02, 3.3601062e+02, 3.3769068e+02,
                                      3.3937913e+02, 3.4107602e+02, 3.4278140e+02, 3.4449531e+02,
                                      3.4621779e+02, 3.4794888e+02, 3.4968862e+02, 3.5143706e+02,
                                      3.5319425e+02, 3.5496022e+02, 3.5673502e+02, 3.5851870e+02,
                                      3.6031129e+02, 3.6211285e+02, 3.6392341e+02, 3.6574303e+02,
                                      3.6576056e+02, 3.6663944e+02, 3.6757174e+02, 3.6940960e+02,
                                      3.7125665e+02, 3.7311293e+02, 3.7497850e+02, 3.7685339e+02,
                                      3.7873766e+02, 3.8063135e+02, 3.8253450e+02, 3.8444718e+02,
                                      3.8636941e+02, 3.8830126e+02, 3.9024276e+02, 3.9219398e+02,
                                      3.9415495e+02, 3.9612572e+02, 3.9810635e+02, 4.0009688e+02,
                                      4.0209737e+02, 4.0410785e+02, 4.0612839e+02, 4.0815904e+02,
                                      4.1019983e+02, 4.1225083e+02, 4.1431208e+02, 4.1638364e+02,
                                      4.1846556e+02, 4.2055789e+02, 4.2266068e+02, 4.2477398e+02,
                                      4.2689785e+02, 4.2903234e+02, 4.3117750e+02, 4.3333339e+02,
                                      4.3550006e+02, 4.3767756e+02, 4.3986595e+02, 4.4206528e+02,
                                      4.4427560e+02, 4.4649698e+02, 4.4843083e+02, 4.4872947e+02,
                                      4.4976915e+02, 4.5097311e+02, 4.5322798e+02, 4.5549412e+02,
                                      4.5777159e+02, 4.6006045e+02, 4.6236075e+02, 4.6467255e+02,
                                      4.6699592e+02, 4.6933090e+02, 4.7167755e+02, 4.7403594e+02,
                                      4.7640612e+02, 4.7878815e+02, 4.8118209e+02, 4.8358800e+02,
                                      4.8600594e+02, 4.8843597e+02, 4.9087815e+02, 4.9333254e+02,
                                      4.9579920e+02, 4.9827820e+02, 5.0076959e+02, 5.0327344e+02,
                                      5.0578980e+02, 5.0831875e+02, 5.1086035e+02, 5.1341465e+02,
                                      5.1598172e+02, 5.1856163e+02, 5.2115444e+02, 5.2376021e+02,
                                      5.2637901e+02, 5.2901091e+02, 5.3165596e+02, 5.3431424e+02,
                                      5.3698581e+02, 5.3967074e+02, 5.4236910e+02, 5.4508094e+02,
                                      5.4780635e+02, 5.5054538e+02, 5.5329810e+02, 5.5606460e+02,
                                      5.5884492e+02, 5.6163914e+02, 5.6444734e+02, 5.6726958e+02,
                                      5.7010592e+02, 5.7295645e+02, 5.7582123e+02, 5.7870034e+02,
                                      5.8159384e+02, 5.8450181e+02, 5.8742432e+02, 5.9036144e+02,
                                      5.9331325e+02, 5.9627982e+02, 5.9926122e+02, 6.0225752e+02,
                                      6.0526881e+02, 6.0829515e+02, 6.1133663e+02, 6.1439331e+02,
                                      6.1746528e+02, 6.2055260e+02, 6.2365537e+02, 6.2677364e+02,
                                      6.2990751e+02, 6.3305705e+02, 6.3622234e+02, 6.3940345e+02,
                                      6.4260046e+02, 6.4581347e+02, 6.4904253e+02, 6.5228775e+02,
                                      6.5554919e+02, 6.5882693e+02, 6.6212107e+02, 6.6543167e+02,
                                      6.6875883e+02, 6.7210262e+02, 6.7546314e+02, 6.7884045e+02,
                                      6.8223466e+02, 6.8564583e+02, 6.8907406e+02, 6.9251943e+02,
                                      6.9598202e+02, 6.9946194e+02, 7.0295924e+02, 7.0647404e+02,
                                      7.1000641e+02, 7.1355644e+02, 7.1712423e+02, 7.2070985e+02,
                                      7.2431340e+02, 7.2793496e+02, 7.3157464e+02, 7.3523251e+02,
                                      7.3890867e+02, 7.4260322e+02, 7.4631623e+02, 7.5004781e+02,
                                      7.5379805e+02, 7.5756704e+02, 7.6135488e+02, 7.6516165e+02,
                                      7.6898746e+02, 7.7283240e+02, 7.7669656e+02, 7.8058004e+02,
                                      7.8448294e+02, 7.8840536e+02, 7.9234738e+02, 7.9630912e+02,
                                      8.0029067e+02, 8.0429212e+02, 8.0831358e+02, 8.1235515e+02,
                                      8.1641693e+02, 8.2049901e+02, 8.2460150e+02, 8.2872451e+02,
                                      8.3286813e+02, 8.3703248e+02, 8.4121764e+02, 8.4542373e+02,
                                      8.4965084e+02, 8.5389910e+02, 8.5816859e+02, 8.6245944e+02,
                                      8.6677173e+02, 8.7110559e+02, 8.7546112e+02, 8.7983843e+02,
                                      8.8423762e+02, 8.8865881e+02, 8.9310210e+02, 8.9756761e+02,
                                      9.0205545e+02, 9.0656573e+02, 9.1109856e+02, 9.1565405e+02,
                                      9.2023232e+02, 9.2483348e+02, 9.2945765e+02, 9.3410494e+02,
                                      9.3877546e+02, 9.4346934e+02, 9.4818668e+02, 9.5292762e+02,
                                      9.5769226e+02, 9.6248072e+02, 9.6729312e+02, 9.7212959e+02,
                                      9.7699023e+02, 9.8187519e+02, 9.8678456e+02, 9.9171848e+02,
                                      9.9667708e+02, 1.0016605e+03, 1.0066688e+03, 1.0117021e+03,
                                      1.0167606e+03, 1.0218444e+03, 1.0269536e+03, 1.0320884e+03,
                                      1.0372489e+03, 1.0424351e+03, 1.0476473e+03, 1.0528855e+03,
                                      1.0581499e+03, 1.0634407e+03, 1.0687579e+03, 1.0741017e+03,
                                      1.0794722e+03, 1.0848695e+03, 1.0902939e+03, 1.0957454e+03,
                                      1.1012241e+03, 1.1067302e+03, 1.1122639e+03, 1.1178252e+03,
                                      1.1234143e+03, 1.1290314e+03, 1.1346765e+03, 1.1403499e+03,
                                      1.1460517e+03, 1.1517819e+03, 1.1575408e+03, 1.1633285e+03,
                                      1.1691452e+03, 1.1749909e+03, 1.1808659e+03, 1.1867702e+03,
                                      1.1927040e+03, 1.1986676e+03, 1.2046609e+03, 1.2106842e+03,
                                      1.2167376e+03, 1.2228213e+03, 1.2289354e+03, 1.2350801e+03,
                                      1.2412555e+03, 1.2474618e+03, 1.2536991e+03, 1.2599676e+03,
                                      1.2662674e+03, 1.2725988e+03, 1.2789618e+03, 1.2853566e+03,
                                      1.2917833e+03, 1.2982423e+03, 1.3047335e+03, 1.3112571e+03,
                                      1.3178134e+03, 1.3244025e+03, 1.3310245e+03, 1.3376796e+03,
                                      1.3443680e+03, 1.3510899e+03, 1.3578453e+03, 1.3646345e+03,
                                      1.3714577e+03, 1.3783150e+03, 1.3852066e+03, 1.3921326e+03,
                                      1.3990933e+03, 1.4060887e+03, 1.4090970e+03, 1.4095029e+03,
                                      1.4131192e+03, 1.4201848e+03, 1.4272857e+03, 1.4344221e+03,
                                      1.4415942e+03, 1.4488022e+03, 1.4529192e+03, 1.4536808e+03,
                                      1.4560462e+03, 1.4633265e+03, 1.4706431e+03, 1.4779963e+03,
                                      1.4853863e+03, 1.4928132e+03, 1.5002773e+03, 1.5077787e+03,
                                      1.5153176e+03, 1.5228942e+03, 1.5305086e+03, 1.5381612e+03,
                                      1.5458520e+03, 1.5535812e+03, 1.5613491e+03, 1.5691559e+03,
                                      1.5770017e+03, 1.5848867e+03, 1.5928111e+03, 1.6007752e+03,
                                      1.6087790e+03, 1.6168229e+03, 1.6249070e+03, 1.6330316e+03,
                                      1.6411967e+03, 1.6494027e+03, 1.6576497e+03, 1.6659380e+03,
                                      1.6742677e+03, 1.6826390e+03, 1.6910522e+03, 1.6995075e+03,
                                      1.7080050e+03, 1.7165450e+03, 1.7251278e+03, 1.7337534e+03,
                                      1.7424222e+03, 1.7511343e+03, 1.7598899e+03, 1.7686894e+03,
                                      1.7775328e+03, 1.7864205e+03, 1.7953526e+03, 1.8043294e+03,
                                      1.8098795e+03, 1.8133510e+03, 1.8137205e+03, 1.8224178e+03,
                                      1.8315299e+03, 1.8406875e+03, 1.8498909e+03, 1.8591404e+03,
                                      1.8684361e+03, 1.8777783e+03, 1.8871672e+03, 1.8966030e+03,
                                      1.9060860e+03, 1.9156165e+03, 1.9251945e+03, 1.9348205e+03,
                                      1.9444946e+03, 1.9542171e+03, 1.9639882e+03, 1.9738081e+03,
                                      1.9836772e+03, 1.9935955e+03, 2.0035635e+03, 2.0036337e+03,
                                      2.0079663e+03, 2.0135813e+03, 2.0236492e+03, 2.0337675e+03,
                                      2.0439363e+03, 2.0541560e+03, 2.0644268e+03, 2.0747489e+03,
                                      2.0851227e+03, 2.0955483e+03, 2.1060260e+03, 2.1165562e+03,
                                      2.1271389e+03, 2.1377746e+03, 2.1484635e+03, 2.1592058e+03,
                                      2.1700018e+03, 2.1808519e+03, 2.1917561e+03, 2.2022856e+03,
                                      2.2027149e+03, 2.2107145e+03, 2.2137285e+03, 2.2247971e+03,
                                      2.2359211e+03, 2.2471007e+03, 2.2583362e+03, 2.2696279e+03,
                                      2.2809760e+03, 2.2923809e+03, 2.3038428e+03, 2.3153620e+03,
                                      2.3269388e+03, 2.3385735e+03, 2.3502664e+03, 2.3620177e+03,
                                      2.3738278e+03, 2.3856970e+03, 2.3976254e+03, 2.4096136e+03,
                                      2.4216616e+03, 2.4337699e+03, 2.4459388e+03, 2.4581685e+03,
                                      2.4704593e+03, 2.4828116e+03, 2.4952257e+03, 2.5077018e+03,
                                      2.5202403e+03, 2.5328415e+03, 2.5455057e+03, 2.5582333e+03,
                                      2.5710244e+03, 2.5838796e+03, 2.5967990e+03, 2.6097829e+03,
                                      2.6228319e+03, 2.6359460e+03, 2.6491257e+03, 2.6623714e+03,
                                      2.6756832e+03, 2.6890617e+03, 2.7025070e+03, 2.7160195e+03,
                                      2.7295996e+03, 2.7432476e+03, 2.7569638e+03, 2.7707486e+03,
                                      2.7846024e+03, 2.7985254e+03, 2.8125180e+03, 2.8265806e+03,
                                      2.8407135e+03, 2.8549171e+03, 2.8691917e+03, 2.8835376e+03,
                                      2.8979553e+03, 2.9124451e+03, 2.9270073e+03, 2.9416424e+03,
                                      2.9563506e+03, 2.9711323e+03, 2.9859880e+03, 3.0009179e+03,
                                      3.0159225e+03, 3.0310021e+03, 3.0461571e+03, 3.0613879e+03,
                                      3.0766949e+03, 3.0920783e+03, 3.1075387e+03, 3.1230764e+03,
                                      3.1386918e+03, 3.1543853e+03, 3.1701572e+03, 3.1860080e+03,
                                      3.2019380e+03, 3.2179477e+03, 3.2340374e+03, 3.2502076e+03,
                                      3.2664587e+03, 3.2827910e+03, 3.2992049e+03, 3.3157009e+03,
                                      3.3322794e+03, 3.3489408e+03, 3.3656856e+03, 3.3825140e+03,
                                      3.3994265e+03, 3.4164237e+03, 3.4335058e+03, 3.4506733e+03,
                                      3.4679267e+03, 3.4852663e+03, 3.5026927e+03, 3.5202061e+03,
                                      3.5378072e+03, 3.5554962e+03, 3.5732737e+03, 3.5911400e+03,
                                      3.6090957e+03, 3.6271412e+03, 3.6452769e+03, 3.6635033e+03,
                                      3.6818208e+03, 3.7002299e+03, 3.7187311e+03, 3.7373247e+03,
                                      3.7560114e+03, 3.7747914e+03, 3.7936654e+03, 3.8126337e+03,
                                      3.8316969e+03, 3.8508554e+03, 3.8701096e+03, 3.8894602e+03,
                                      3.9089075e+03, 3.9284520e+03, 3.9480943e+03, 3.9678347e+03,
                                      3.9876739e+03, 4.0550240e+03, 4.3348210e+03, 4.6339240e+03,
                                      4.9536640e+03, 5.2954670e+03, 5.6608550e+03, 6.0514530e+03,
                                      6.4690040e+03, 6.9153650e+03, 7.3925250e+03, 7.9026090e+03,
                                      8.1907420e+03, 8.3161100e+03, 8.3495420e+03, 8.3996890e+03,
                                      8.4478900e+03, 8.5250580e+03, 9.0307940e+03, 9.0790140e+03,
                                      9.2179790e+03, 9.2550360e+03, 9.3106220e+03, 9.4495860e+03,
                                      9.5562740e+03, 9.6539190e+03, 9.7025430e+03, 9.7415490e+03,
                                      9.8000560e+03, 9.9463260e+03, 1.0320040e+04, 1.1032120e+04,
                                      1.1793340e+04, 1.2607080e+04, 1.3476970e+04, 1.4406880e+04,
                                      1.5400950e+04, 1.6463620e+04, 1.7599610e+04, 1.8813980e+04,
                                      2.0112150e+04, 2.1499880e+04, 2.2983380e+04, 2.4569230e+04,
                                      2.6264500e+04, 2.8076760e+04, 3.0014050e+04, 3.2085020e+04,
                                      3.4298890e+04, 3.6665510e+04, 3.9195430e+04, 4.1899920e+04,
                                      4.4791010e+04, 4.7881590e+04, 5.1185420e+04, 5.4717210e+04,
                                      5.6335790e+04, 5.7198070e+04, 5.7428010e+04, 5.7772930e+04,
                                      5.8492700e+04, 5.8635210e+04, 6.2528700e+04, 6.6843180e+04,
                                      7.1455360e+04, 7.6385780e+04, 8.1656400e+04, 8.7290690e+04,
                                      9.3313740e+04, 9.9752390e+04, 1.0663530e+05, 1.1399310e+05,
                                      1.2185870e+05, 1.3026690e+05, 1.3925530e+05, 1.4886400e+05,
                                      1.5913560e+05, 1.7011590e+05, 1.8185390e+05, 1.9440180e+05,
                                      2.0781560e+05, 2.2215480e+05, 2.3748350e+05, 2.5386990e+05,
                                      2.7138690e+05, 2.9011260e+05, 3.1013040e+05, 3.3152940e+05,
                                      3.5440490e+05, 3.7885880e+05, 4.0500010e+05, 4.3294510e+05]), },
              '69': {'name': 'Tm',
                     'barns': 2805220000000.0,
                     'NumEdges': 19,
                     'O3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 32.300000000000004,
                            'factor': 1.0},
                     'O2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 32.300000000000004,
                            'factor': 1.0},
                     'O1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 53.199999999999996,
                            'factor': 1.0},
                     'N7': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5.3, 'factor': 1.0,
                            'twin': 'N6'},
                     'N6': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 5.3, 'factor': 0.75},
                     'N5': {'filename': 'Tm.N5', 'excl before': 5, 'excl after': 50, 'onset': 179.60000000000002,
                            'factor': 1.0, 'twin': 'N4'},
                     'N4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 179.60000000000002,
                            'factor': 0.6666666666666666},
                     'N3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 336.6, 'factor': 1.0,
                            'twin': 'N2'},
                     'N2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 385.90000000000003,
                            'factor': 0.5},
                     'N1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 471.7, 'factor': 1.0},
                     'M5': {'filename': 'Tm.M5', 'excl before': 5, 'excl after': 50, 'onset': 1467.7, 'factor': 1.0,
                            'twin': 'M4', 'shape': 'white_line'},
                     'M4': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 1514.6,
                            'factor': 0.6666666666666666},
                     'M3': {'filename': 'Tm.M3', 'excl before': 5, 'excl after': 50, 'onset': 1884.5, 'factor': 1.0,
                            'twin': 'M2'},
                     'M2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2089.7999999999997,
                            'factor': 0.5},
                     'M1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 2306.8, 'factor': 1.0},
                     'L3': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 8648.0, 'factor': 1.0,
                            'twin': 'L2'},
                     'L2': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 9616.9, 'factor': 0.5},
                     'L1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 10115.7, 'factor': 1.0},
                     'K1': {'filename': 'None', 'excl before': 5, 'excl after': 50, 'onset': 59389.6, 'factor': 1.0},
                     'dat': np.array([1.87486879e+16, 1.85411016e+16, 1.69331495e+16, 1.74204162e+16,
                                      1.80002552e+16, 1.86743495e+16, 1.94455045e+16, 2.03168058e+16,
                                      2.12921808e+16, 2.23752763e+16, 2.35711416e+16, 2.48834235e+16,
                                      2.63160493e+16, 2.78704217e+16, 2.95417718e+16, 3.13258917e+16,
                                      3.32222205e+16, 3.52251475e+16, 3.73262573e+16, 3.79097431e+16,
                                      3.84090722e+16, 3.85409176e+16, 5.50524425e+17, 5.14870079e+17,
                                      4.95065226e+17, 3.69727996e+17, 2.78760322e+17, 2.12812405e+17,
                                      1.66414066e+17, 1.34527130e+17, 1.13039145e+17, 1.01868759e+17,
                                      9.91196435e+16, 9.88391215e+16, 9.84379750e+16, 9.79105937e+16,
                                      9.56383655e+16, 9.01429395e+16, 8.44174855e+16, 8.10091432e+16,
                                      7.91492823e+16, 7.83133267e+16, 7.81309874e+16, 7.83525998e+16,
                                      7.87986298e+16, 7.93484529e+16, 7.93989469e+16, 7.91913606e+16,
                                      7.89809691e+16, 7.87705776e+16, 7.85601861e+16, 7.83469894e+16,
                                      7.81337927e+16, 7.79177907e+16, 7.77017888e+16, 7.74857868e+16,
                                      7.72697849e+16, 7.70509777e+16, 7.68321706e+16, 7.66133634e+16,
                                      7.63917510e+16, 7.61701387e+16, 7.59457211e+16, 7.57241087e+16,
                                      7.54968859e+16, 7.52724683e+16, 7.50452454e+16, 7.48180226e+16,
                                      7.45879946e+16, 7.43607718e+16, 7.41279385e+16, 7.38979105e+16,
                                      7.36650772e+16, 7.34322439e+16, 7.31966055e+16, 7.29609670e+16,
                                      7.27253285e+16, 7.24896900e+16, 7.22512463e+16, 7.20128026e+16,
                                      7.17715537e+16, 7.15303048e+16, 7.12890559e+16, 7.10478069e+16,
                                      7.08037528e+16, 7.05596987e+16, 7.03156445e+16, 7.00687852e+16,
                                      6.98219258e+16, 6.95750664e+16, 6.93254019e+16, 6.90757373e+16,
                                      6.88260727e+16, 6.85764081e+16, 6.83239383e+16, 6.80714685e+16,
                                      6.78189987e+16, 6.75637237e+16, 6.73084487e+16, 6.70531737e+16,
                                      6.67978986e+16, 6.65398184e+16, 6.62845434e+16, 6.60264631e+16,
                                      6.57655777e+16, 6.55074974e+16, 6.52466120e+16, 6.49857265e+16,
                                      6.47248411e+16, 6.44639556e+16, 6.42002649e+16, 6.39365742e+16,
                                      6.36728836e+16, 6.34091929e+16, 6.31455022e+16, 6.28790063e+16,
                                      6.26125104e+16, 6.23460145e+16, 6.20795186e+16, 6.18130227e+16,
                                      6.15465268e+16, 6.12772257e+16, 6.10079246e+16, 6.07386234e+16,
                                      6.04693223e+16, 6.02000212e+16, 5.99307201e+16, 5.96614190e+16,
                                      5.93893126e+16, 5.91200115e+16, 5.88479052e+16, 5.85757988e+16,
                                      5.83036925e+16, 5.80315861e+16, 5.77594798e+16, 5.74873735e+16,
                                      5.72124619e+16, 5.69403556e+16, 5.66682492e+16, 5.63933377e+16,
                                      5.61212313e+16, 5.58463198e+16, 5.55714082e+16, 5.52993019e+16,
                                      5.50243903e+16, 5.47494787e+16, 5.44773724e+16, 5.42024608e+16,
                                      5.39275493e+16, 5.36526377e+16, 5.33777262e+16, 5.31056198e+16,
                                      5.28307083e+16, 5.25557967e+16, 5.22808851e+16, 5.20087788e+16,
                                      5.17338672e+16, 5.14589557e+16, 5.11868493e+16, 5.09119378e+16,
                                      5.06370262e+16, 5.03649199e+16, 5.00928135e+16, 4.98179020e+16,
                                      4.97477715e+16, 4.97421610e+16, 9.89569407e+16, 9.88868102e+16,
                                      9.74870054e+16, 9.44966409e+16, 9.16605635e+16, 8.89703575e+16,
                                      8.64148021e+16, 8.39910920e+16, 8.16908116e+16, 7.95027400e+16,
                                      7.74268772e+16, 7.54520023e+16, 7.35753102e+16, 7.17883850e+16,
                                      7.00884217e+16, 6.84698098e+16, 6.69297440e+16, 6.54598087e+16,
                                      6.40600039e+16, 6.27247192e+16, 6.14483441e+16, 6.02336838e+16,
                                      5.90891541e+16, 5.80147548e+16, 5.70048756e+16, 5.60539060e+16,
                                      5.51562356e+16, 5.43062540e+16, 5.34983506e+16, 5.27325256e+16,
                                      5.20031684e+16, 5.13102790e+16, 5.06454419e+16, 5.00086569e+16,
                                      4.93999242e+16, 4.88164384e+16, 4.82553944e+16, 4.77139870e+16,
                                      4.71922161e+16, 4.66872765e+16, 4.61991682e+16, 4.57278912e+16,
                                      4.52678351e+16, 4.48246104e+16, 4.43926065e+16, 4.39718235e+16,
                                      4.35622614e+16, 4.31639201e+16, 4.27739946e+16, 4.23952899e+16,
                                      4.20221956e+16, 4.16575170e+16, 4.13012541e+16, 4.09534068e+16,
                                      4.06111699e+16, 4.02745435e+16, 3.99463328e+16, 3.96237325e+16,
                                      3.93039374e+16, 3.89925580e+16, 3.86839838e+16, 3.83810200e+16,
                                      3.80836667e+16, 3.77891186e+16, 3.75001810e+16, 3.72140485e+16,
                                      3.69335265e+16, 3.66558097e+16, 3.63808982e+16, 3.61115971e+16,
                                      3.58451012e+16, 3.55814105e+16, 3.53205250e+16, 3.50624448e+16,
                                      3.48071698e+16, 3.45575052e+16, 3.43078406e+16, 3.40637865e+16,
                                      3.38197323e+16, 3.35784834e+16, 3.33428449e+16, 3.31072064e+16,
                                      3.28743732e+16, 3.26443451e+16, 3.24171223e+16, 3.21898995e+16,
                                      3.19682871e+16, 3.17466747e+16, 3.15278676e+16, 3.13118656e+16,
                                      3.10986689e+16, 3.08854722e+16, 3.06750807e+16, 3.04674944e+16,
                                      3.02627134e+16, 3.00579323e+16, 2.98559565e+16, 2.96567858e+16,
                                      2.94604204e+16, 2.92640550e+16, 2.90704949e+16, 2.88769347e+16,
                                      2.86861797e+16, 2.84982300e+16, 2.83130855e+16, 2.81279409e+16,
                                      2.79441990e+16, 2.77629818e+16, 2.75837283e+16, 2.74058773e+16,
                                      2.72299900e+16, 2.70555053e+16, 2.68829843e+16, 2.67121464e+16,
                                      2.65429916e+16, 2.63752395e+16, 2.62094510e+16, 2.60450651e+16,
                                      2.58823623e+16, 2.57210622e+16, 2.55617257e+16, 2.54037918e+16,
                                      2.52472605e+16, 2.50924124e+16, 2.49389668e+16, 2.47869239e+16,
                                      2.46365641e+16, 2.44878875e+16, 2.44693730e+16, 2.68944857e+16,
                                      2.68308072e+16, 2.66812890e+16, 2.65328928e+16, 2.63861798e+16,
                                      2.62408694e+16, 2.60969617e+16, 2.59544565e+16, 2.58133539e+16,
                                      2.56733734e+16, 2.55350761e+16, 2.53979008e+16, 2.52618477e+16,
                                      2.51274776e+16, 2.49939492e+16, 2.48621038e+16, 2.47311000e+16,
                                      2.46014989e+16, 2.44733003e+16, 2.43459433e+16, 2.42199890e+16,
                                      2.40951567e+16, 2.39711659e+16, 2.38485778e+16, 2.37268313e+16,
                                      2.36062068e+16, 2.34864239e+16, 2.33677631e+16, 2.33088535e+16,
                                      2.38452116e+16, 2.38438090e+16, 2.37287949e+16, 2.36132199e+16,
                                      2.34984864e+16, 2.33845944e+16, 2.32718246e+16, 2.31596158e+16,
                                      2.30485291e+16, 2.29382839e+16, 2.28288804e+16, 2.27200378e+16,
                                      2.26120369e+16, 2.25048774e+16, 2.23985596e+16, 2.22928028e+16,
                                      2.21878876e+16, 2.20838139e+16, 2.19800208e+16, 2.18770692e+16,
                                      2.17749592e+16, 2.16731297e+16, 2.15721418e+16, 2.14717149e+16,
                                      2.13718491e+16, 2.12725443e+16, 2.11738006e+16, 2.10753373e+16,
                                      2.09777157e+16, 2.08803745e+16, 2.07835945e+16, 2.06870949e+16,
                                      2.05914369e+16, 2.04957789e+16, 2.04006819e+16, 2.03061460e+16,
                                      2.02116101e+16, 2.01176352e+16, 2.00242214e+16, 1.99308076e+16,
                                      1.98379548e+16, 1.97723126e+16, 1.97453825e+16, 2.04806307e+16,
                                      2.04155496e+16, 2.03215747e+16, 2.02275999e+16, 2.01339055e+16,
                                      2.00404917e+16, 1.99476389e+16, 1.98545056e+16, 1.97619333e+16,
                                      1.96696416e+16, 1.95773499e+16, 1.94850581e+16, 1.93933274e+16,
                                      1.93015967e+16, 1.92098660e+16, 1.91186964e+16, 1.90272462e+16,
                                      1.89360766e+16, 1.88451874e+16, 1.87542983e+16, 1.86634092e+16,
                                      1.85728006e+16, 1.84819114e+16, 1.83913028e+16, 1.83006942e+16,
                                      1.82103662e+16, 1.81197575e+16, 1.80294295e+16, 1.79388209e+16,
                                      1.78484928e+16, 1.77581647e+16, 1.76678366e+16, 1.75775085e+16,
                                      1.74871804e+16, 1.73968524e+16, 1.73065243e+16, 1.72161962e+16,
                                      1.71261486e+16, 1.70358205e+16, 1.69454925e+16, 1.68554449e+16,
                                      1.67651168e+16, 1.66750692e+16, 1.65847412e+16, 1.64946936e+16,
                                      1.64046460e+16, 1.63143180e+16, 1.62242704e+16, 1.61342228e+16,
                                      1.60441753e+16, 1.59541277e+16, 1.58640801e+16, 1.57740326e+16,
                                      1.56839850e+16, 1.55939375e+16, 1.55038899e+16, 1.54138423e+16,
                                      1.53240753e+16, 1.52343083e+16, 1.51445412e+16, 1.50547742e+16,
                                      1.49650071e+16, 1.48755206e+16, 1.47857536e+16, 1.46965476e+16,
                                      1.46070611e+16, 1.45178551e+16, 1.44286491e+16, 1.43394431e+16,
                                      1.42505176e+16, 1.41615921e+16, 1.40726667e+16, 1.39840217e+16,
                                      1.38956573e+16, 1.38070123e+16, 1.37189284e+16, 1.36305640e+16,
                                      1.35427606e+16, 1.34546767e+16, 1.33671538e+16, 1.32796310e+16,
                                      1.31921081e+16, 1.31048658e+16, 1.30179039e+16, 1.29309421e+16,
                                      1.28442608e+16, 1.27575795e+16, 1.26711787e+16, 1.25847780e+16,
                                      1.24986577e+16, 1.24125375e+16, 1.23266977e+16, 1.22408580e+16,
                                      1.21552988e+16, 1.20697396e+16, 1.19847414e+16, 1.18997432e+16,
                                      1.18150256e+16, 1.17303080e+16, 1.16461514e+16, 1.15619948e+16,
                                      1.14783992e+16, 1.13948036e+16, 1.13114886e+16, 1.12287346e+16,
                                      1.11459806e+16, 1.10635072e+16, 1.09810337e+16, 1.08991213e+16,
                                      1.08174894e+16, 1.07361380e+16, 1.06550671e+16, 1.05742768e+16,
                                      1.04940475e+16, 1.04140987e+16, 1.03344305e+16, 1.02553233e+16,
                                      1.01764966e+16, 1.00979504e+16, 1.00199653e+16, 9.94226072e+15,
                                      9.86511717e+15, 9.78825415e+15, 9.71195216e+15, 9.63593070e+15,
                                      9.56018976e+15, 9.48500986e+15, 9.41039101e+15, 9.33605268e+15,
                                      9.26227540e+15, 9.18877863e+15, 9.11584291e+15, 9.04318771e+15,
                                      8.97109356e+15, 8.89956045e+15, 8.82830786e+15, 8.75761632e+15,
                                      8.68720530e+15, 8.61763584e+15, 8.54806638e+15, 8.47933849e+15,
                                      8.41089113e+15, 8.34300480e+15, 8.27539900e+15, 8.20835424e+15,
                                      8.14187053e+15, 8.07566734e+15, 8.01030571e+15, 7.94494408e+15,
                                      7.88042402e+15, 7.81618449e+15, 7.74465138e+15, 7.65881164e+15,
                                      7.57381348e+15, 7.48965688e+15, 7.40690289e+15, 7.32470994e+15,
                                      7.24391961e+15, 7.16369031e+15, 7.08458311e+15, 7.00659799e+15,
                                      6.92945444e+15, 6.85315246e+15, 6.77769204e+15, 6.70307319e+15,
                                      6.62957643e+15, 6.55692123e+15, 6.48510760e+15, 6.41413553e+15,
                                      6.34372451e+15, 6.27443557e+15, 6.20598821e+15, 6.13810188e+15,
                                      6.07133765e+15, 6.00513445e+15, 5.93977283e+15, 5.87525277e+15,
                                      5.81129375e+15, 5.74845682e+15, 5.68590042e+15, 5.62446610e+15,
                                      5.56359283e+15, 5.50328060e+15, 5.44380993e+15, 5.38518083e+15,
                                      5.32683226e+15, 5.26960577e+15, 5.21265980e+15, 5.15683593e+15,
                                      5.10129257e+15, 5.04659078e+15, 4.99245003e+15, 4.93887033e+15,
                                      4.88585167e+15, 4.83367458e+15, 4.78177801e+15, 4.73072301e+15,
                                      4.68022905e+15, 4.63029613e+15, 4.58092426e+15, 4.53239395e+15,
                                      4.48414417e+15, 4.43645543e+15, 4.38932773e+15, 4.34276108e+15,
                                      4.29675547e+15, 4.25131091e+15, 4.20614687e+15, 4.16182439e+15,
                                      4.11778244e+15, 4.07430153e+15, 4.03082062e+15, 3.98733971e+15,
                                      3.94470036e+15, 3.90234154e+15, 3.86026324e+15, 3.81902651e+15,
                                      3.77807030e+15, 3.73767513e+15, 3.69784100e+15, 3.65828740e+15,
                                      3.61929484e+15, 3.58058281e+15, 3.54243182e+15, 3.50484187e+15,
                                      3.46753244e+15, 3.43050354e+15, 3.39431620e+15, 3.37355757e+15,
                                      1.26661293e+16, 1.26066587e+16, 1.24476027e+16, 1.22905104e+16,
                                      1.21356622e+16, 1.19827778e+16, 1.18315764e+16, 1.17053415e+16,
                                      1.75699344e+16, 1.75615188e+16, 1.73382233e+16, 1.71174524e+16,
                                      1.68997674e+16, 1.66848875e+16, 1.64725324e+16, 1.62627019e+16,
                                      1.60556767e+16, 1.58514567e+16, 1.56497613e+16, 1.54505907e+16,
                                      1.52542253e+16, 1.50601041e+16, 1.48687881e+16, 1.46797163e+16,
                                      1.44931691e+16, 1.43091467e+16, 1.41273684e+16, 1.39478344e+16,
                                      1.37708250e+16, 1.35960598e+16, 1.34232582e+16, 1.32529814e+16,
                                      1.30849487e+16, 1.29188797e+16, 1.27550548e+16, 1.25934741e+16,
                                      1.24338571e+16, 1.22762038e+16, 1.21207946e+16, 1.19670685e+16,
                                      1.18155866e+16, 1.16660684e+16, 1.15182333e+16, 1.13723619e+16,
                                      1.12284541e+16, 1.10865100e+16, 1.09462490e+16, 1.08079516e+16,
                                      1.06713374e+16, 1.05364063e+16, 1.04031584e+16, 1.02718741e+16,
                                      1.01419924e+16, 1.00785944e+16, 1.17656537e+16, 1.17561160e+16,
                                      1.16009873e+16, 1.14483833e+16, 1.12971820e+16, 1.11479443e+16,
                                      1.10006702e+16, 1.08556404e+16, 1.07122936e+16, 1.05709105e+16,
                                      1.04312106e+16, 1.02982431e+16, 1.01697641e+16, 1.00432486e+16,
                                      9.91897740e+15, 9.79638928e+15, 9.67604535e+15, 9.55738454e+15,
                                      9.44068739e+15, 9.32567337e+15, 9.21234248e+15, 9.10069472e+15,
                                      9.07600879e+15, 9.66033611e+15, 9.62134356e+15, 9.50184118e+15,
                                      9.38430247e+15, 9.26844688e+15, 9.15399390e+15, 9.04150458e+15,
                                      8.93041787e+15, 8.82101429e+15, 8.71329384e+15, 8.60669548e+15,
                                      8.50514652e+15, 8.40556121e+15, 8.30737851e+15, 8.21059842e+15,
                                      8.11550146e+15, 8.02152659e+15, 7.92895433e+15, 7.83778468e+15,
                                      7.74801764e+15, 7.67171566e+15, 7.65937269e+15, 7.95840914e+15,
                                      7.92727120e+15, 7.83750416e+15, 7.74913973e+15, 7.66189739e+15,
                                      7.57577713e+15, 7.49049844e+15, 7.40662237e+15, 7.32358785e+15,
                                      7.24167543e+15, 7.16060457e+15, 7.08093632e+15, 7.00239016e+15,
                                      6.92384400e+15, 6.84557837e+15, 6.76815429e+15, 6.69185231e+15,
                                      6.61639189e+15, 6.54177304e+15, 6