# ******************************************************************************
#  djangoFCM — Django app which stores, manages FCM push tokens                *
#  and interacts with them.                                                    *
#  Copyright (C) 2021-2021 omelched                                            *
#                                                                              *
#  This file is part of djangoFCM.                                             *
#                                                                              *
#  djangoFCM is free software: you can redistribute it and/or modify           *
#  it under the terms of the GNU Affero General Public License as published    *
#  by the Free Software Foundation, either version 3 of the License, or        *
#  (at your option) any later version.                                         *
#                                                                              *
#  djangoFCM is distributed in the hope that it will be useful,                *
#  but WITHOUT ANY WARRANTY; without even the implied warranty of              *
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
#  GNU Affero General Public License for more details.                         *
#                                                                              *
#  You should have received a copy of the GNU Affero General Public License    *
#  along with djangoFCM.  If not, see <https://www.gnu.org/licenses/>.         *
# ******************************************************************************

# Generated by Django 3.2.8 on 2021-10-25 21:00

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('django_celery_beat', '0015_edit_solarschedule_events_choices'),
    ]

    operations = [
        migrations.CreateModel(
            name='Parameter',
            fields=[
                ('name', models.CharField(max_length=63, primary_key=True, serialize=False, verbose_name='name')),
                ('type', models.CharField(choices=[
                    ('N', 'number'),
                    ('S', 'string'),
                    ('F', 'foreign key'),
                    ('C', 'choice')
                ], max_length=1, verbose_name='type')),
                ('content_types', models.ManyToManyField(blank=True,
                                                         related_name='used_in_parameters',
                                                         to='contenttypes.ContentType',
                                                         verbose_name='content types')),
            ],
            options={
                'verbose_name': 'parameter',
                'verbose_name_plural': 'parameters',
            },
        ),
        migrations.CreateModel(
            name='PushToken',
            fields=[
                ('push_token', models.CharField(max_length=255,
                                                primary_key=True,
                                                serialize=False,
                                                verbose_name='push token')),
                ('creation_date', models.DateTimeField(auto_now_add=True, verbose_name='creation date')),
                ('update_date', models.DateTimeField(auto_now=True, verbose_name='update date')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                           related_name='push_tokens',
                                           to=settings.AUTH_USER_MODEL, verbose_name='user')),
            ],
            options={
                'verbose_name': 'push token',
                'verbose_name_plural': 'push tokens',
            },
        ),
        migrations.CreateModel(
            name='PushTokenParameters',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.CharField(max_length=255, verbose_name='value')),
                ('content_type', models.ForeignKey(blank=True,
                                                   null=True,
                                                   on_delete=django.db.models.deletion.CASCADE,
                                                   to='contenttypes.contenttype',
                                                   verbose_name='content type')),
                ('parameter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                related_name='push_tokens',
                                                to='djangoFCM.parameter', verbose_name='parameter')),
                ('push_token', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                 related_name='parameters',
                                                 to='djangoFCM.pushtoken',
                                                 verbose_name='push token')),
            ],
            options={
                'verbose_name': 'push token parameter',
                'verbose_name_plural': 'push token parameters',
            },
        ),
        migrations.CreateModel(
            name='ParameterChoices',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('choice', models.CharField(max_length=63, verbose_name='choice')),
                ('parameter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                related_name='choices',
                                                to='djangoFCM.parameter',
                                                verbose_name='parameter')),
            ],
            options={
                'verbose_name': 'parameter and choice',
                'verbose_name_plural': 'parameters and choices',
            },
        ),
        migrations.CreateModel(
            name='Notification',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=63, unique=True, verbose_name='name')),
                ('title', models.CharField(blank=True, max_length=63, verbose_name='title')),
                ('body', models.CharField(blank=True, max_length=255, verbose_name='body')),
                ('send_on', models.DateTimeField(blank=True, verbose_name='send on date')),
                ('sent', models.BooleanField(default=False, verbose_name='is sent')),
                ('creation_date', models.DateTimeField(auto_now_add=True, verbose_name='creation date')),
                ('recipients', models.ManyToManyField(blank=True,
                                                      related_name='notifications',
                                                      to='djangoFCM.PushToken',
                                                      verbose_name='recipients')),
                ('task', models.OneToOneField(null=True,
                                              on_delete=django.db.models.deletion.SET_NULL,
                                              related_name='notification',
                                              to='django_celery_beat.periodictask',
                                              verbose_name='task')),
            ],
            options={
                'verbose_name': 'notification',
                'verbose_name_plural': 'notifications',
            },
        ),
        migrations.AddConstraint(
            model_name='pushtokenparameters',
            constraint=models.UniqueConstraint(fields=('push_token', 'parameter', 'value'),
                                               name='unique parameter value at token'),
        ),
        migrations.AddConstraint(
            model_name='parameterchoices',
            constraint=models.UniqueConstraint(fields=('parameter', 'choice'), name='unique parameter and choice'),
        ),
    ]
