# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.documents_database import DocumentsDatabase
from typing import Optional, Set
from typing_extensions import Self

class TransactionInfo(BaseModel):
    """
    TransactionInfo
    """ # noqa: E501
    computer_name: Optional[StrictStr] = Field(default=None, description="Computer name", alias="ComputerName")
    date_time: Optional[StrictStr] = Field(default=None, description="Date and time", alias="DateTime")
    documents_database: Optional[DocumentsDatabase] = Field(default=None, alias="DocumentsDatabase")
    system_info: Optional[StrictStr] = Field(default=None, description="System information", alias="SystemInfo")
    tag: Optional[StrictStr] = Field(default=None, description="Transaction tag", alias="Tag")
    transaction_id: Optional[StrictStr] = Field(default=None, description="Transaction identifier", alias="TransactionID")
    user_name: Optional[StrictStr] = Field(default=None, description="User name", alias="UserName")
    version: Optional[StrictStr] = Field(default=None, description="SDK version", alias="Version")
    __properties: ClassVar[List[str]] = ["ComputerName", "DateTime", "DocumentsDatabase", "SystemInfo", "Tag", "TransactionID", "UserName", "Version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of TransactionInfo from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of documents_database
        if self.documents_database:
            _dict['DocumentsDatabase'] = self.documents_database.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of TransactionInfo from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "ComputerName": obj.get("ComputerName"),
            "DateTime": obj.get("DateTime"),
            "DocumentsDatabase": DocumentsDatabase.from_dict(obj["DocumentsDatabase"]) if obj.get("DocumentsDatabase") is not None else None,
            "SystemInfo": obj.get("SystemInfo"),
            "Tag": obj.get("Tag"),
            "TransactionID": obj.get("TransactionID"),
            "UserName": obj.get("UserName"),
            "Version": obj.get("Version")
        })
        return _obj


