# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.area_container import AreaContainer
from regula.documentreader.webclient.gen.models.authenticity_check_result_item import AuthenticityCheckResultItem
from regula.documentreader.webclient.gen.models.authenticity_result_type import AuthenticityResultType
from regula.documentreader.webclient.gen.models.check_diagnose import CheckDiagnose
from regula.documentreader.webclient.gen.models.check_result import CheckResult
from regula.documentreader.webclient.gen.models.critical import Critical
from regula.documentreader.webclient.gen.models.rectangle_coordinates import RectangleCoordinates
from regula.documentreader.webclient.gen.models.security_feature_type import SecurityFeatureType
from regula.documentreader.webclient.gen.models.visibility import Visibility
from typing import Optional, Set
from typing_extensions import Self

class SecurityFeatureResult(AuthenticityCheckResultItem):
    """
    SecurityFeatureResult
    """ # noqa: E501
    element_type: SecurityFeatureType = Field(alias="ElementType")
    element_rect: RectangleCoordinates = Field(alias="ElementRect")
    visibility: Visibility = Field(alias="Visibility")
    critical_flag: Critical = Field(alias="CriticalFlag")
    area_list: Optional[AreaContainer] = Field(default=None, alias="AreaList")
    result: Optional[StrictInt] = Field(default=None, alias="Result")
    reserved2: Optional[StrictInt] = Field(default=None, alias="Reserved2")
    __properties: ClassVar[List[str]] = ["Type", "ElementResult", "ElementDiagnose", "PercentValue", "ElementType", "ElementRect", "Visibility", "CriticalFlag", "AreaList", "Result", "Reserved2"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of SecurityFeatureResult from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of element_rect
        if self.element_rect:
            _dict['ElementRect'] = self.element_rect.to_dict()
        # override the default output from pydantic by calling `to_dict()` of area_list
        if self.area_list:
            _dict['AreaList'] = self.area_list.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of SecurityFeatureResult from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "Type": obj.get("Type"),
            "ElementResult": obj.get("ElementResult"),
            "ElementDiagnose": obj.get("ElementDiagnose"),
            "PercentValue": obj.get("PercentValue"),
            "ElementType": obj.get("ElementType"),
            "ElementRect": RectangleCoordinates.from_dict(obj["ElementRect"]) if obj.get("ElementRect") is not None else None,
            "Visibility": obj.get("Visibility"),
            "CriticalFlag": obj.get("CriticalFlag"),
            "AreaList": AreaContainer.from_dict(obj["AreaList"]) if obj.get("AreaList") is not None else None,
            "Result": obj.get("Result"),
            "Reserved2": obj.get("Reserved2")
        })
        return _obj


