# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.rfid_a_chip import RfidAChip
from regula.documentreader.webclient.gen.models.rfid_baud_rate import RfidBaudRate
from regula.documentreader.webclient.gen.models.rfid_type import RfidType
from typing import Optional, Set
from typing_extensions import Self

class RfidCardPropertiesExt(BaseModel):
    """
    Structure is used to store extended information about the characteristics of the RFID-chip located in the scope of the reader
    """ # noqa: E501
    rfid_type: RfidType = Field(alias="RFID_Type")
    baudrate1: StrictStr = Field(description="Numeric Baudrate1 value in hexadecimal format (e.g. 0x0000000F)", alias="Baudrate1")
    baudrate2: StrictStr = Field(description="Numeric Baudrate2 value in hexadecimal format", alias="Baudrate2")
    support_4: StrictBool = Field(description="Boolean Support_4 value", alias="Support_4")
    chip_type_a: RfidAChip = Field(alias="ChipType_A")
    support_mifare: StrictBool = Field(description="Sign of support for ISO/IEC 14443-3 data exchange protocol", alias="Support_Mifare")
    mifare_memory: Union[StrictFloat, StrictInt] = Field(description="Amount of operational memory MIFARE® of the chip, kilobytes", alias="MifareMemory")
    uid: StrictStr = Field(description="UID contents in text format. Each byte is represented by its hexadecimal value. The individual bytes are separated by spaces (e.g. F9 4F 41 60)", alias="UID")
    atq_a: Optional[Any] = Field(description="Reply of the «A» type chip to «REQA» command of ISO/IEC 14443-3 protocol (Answer To Request, Type A – ATQA) – for the internal use by the main control library", alias="ATQ_A")
    sak: Optional[Any] = Field(description="Response of type-A RFID-chip to SELECT command of ISO/IEC 14443-3 protocol (Select Acknowledge, SAK).", alias="SAK")
    atq_b: Optional[Any] = Field(description="ATQ_B contents in text format. Each byte is represented by its hexadecimal value. The individual bytes are separated by spaces (e.g. 50 F9 4F 41 60 00 00 00 00 77 81 81)", alias="ATQ_B")
    bit_rate_s: RfidBaudRate = Field(alias="BitRateS")
    bit_rate_r: RfidBaudRate = Field(alias="BitRateR")
    atr: StrictStr = Field(description="ATR-string of RFID-chip", alias="ATR")
    __properties: ClassVar[List[str]] = ["RFID_Type", "Baudrate1", "Baudrate2", "Support_4", "ChipType_A", "Support_Mifare", "MifareMemory", "UID", "ATQ_A", "SAK", "ATQ_B", "BitRateS", "BitRateR", "ATR"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of RfidCardPropertiesExt from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # set to None if atq_a (nullable) is None
        # and model_fields_set contains the field
        if self.atq_a is None and "atq_a" in self.model_fields_set:
            _dict['ATQ_A'] = None

        # set to None if sak (nullable) is None
        # and model_fields_set contains the field
        if self.sak is None and "sak" in self.model_fields_set:
            _dict['SAK'] = None

        # set to None if atq_b (nullable) is None
        # and model_fields_set contains the field
        if self.atq_b is None and "atq_b" in self.model_fields_set:
            _dict['ATQ_B'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of RfidCardPropertiesExt from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "RFID_Type": obj.get("RFID_Type"),
            "Baudrate1": obj.get("Baudrate1"),
            "Baudrate2": obj.get("Baudrate2"),
            "Support_4": obj.get("Support_4"),
            "ChipType_A": obj.get("ChipType_A"),
            "Support_Mifare": obj.get("Support_Mifare"),
            "MifareMemory": obj.get("MifareMemory"),
            "UID": obj.get("UID"),
            "ATQ_A": obj.get("ATQ_A"),
            "SAK": obj.get("SAK"),
            "ATQ_B": obj.get("ATQ_B"),
            "BitRateS": obj.get("BitRateS"),
            "BitRateR": obj.get("BitRateR"),
            "ATR": obj.get("ATR")
        })
        return _obj


