# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt
from typing import Any, ClassVar, Dict, List, Optional, Union
from regula.documentreader.webclient.gen.models.barcode_type import BarcodeType
from regula.documentreader.webclient.gen.models.bc_pdf417_info import BcPDF417INFO
from regula.documentreader.webclient.gen.models.bc_roidetect import BcROIDETECT
from regula.documentreader.webclient.gen.models.data_module import DataModule
from typing import Optional, Set
from typing_extensions import Self

class PArrayField(BaseModel):
    """
    PArrayField
    """ # noqa: E501
    bc_angle_detect: Union[StrictFloat, StrictInt] = Field(alias="bcAngle_DETECT")
    bc_code_result: StrictInt = Field(alias="bcCodeResult")
    bc_count_module: StrictInt = Field(alias="bcCountModule")
    bc_data_module: List[DataModule] = Field(alias="bcDataModule")
    bc_pdf417_info: Optional[BcPDF417INFO] = Field(default=None, alias="bcPDF417INFO")
    bc_roi_detect: BcROIDETECT = Field(alias="bcROI_DETECT")
    bc_text_decoder_types: Optional[StrictInt] = Field(default=None, alias="bcTextDecoderTypes")
    bc_text_field_type: Optional[StrictInt] = Field(default=None, alias="bcTextFieldType")
    bc_type_decode: BarcodeType = Field(alias="bcType_DECODE")
    bc_type_detect: StrictInt = Field(alias="bcType_DETECT")
    __properties: ClassVar[List[str]] = ["bcAngle_DETECT", "bcCodeResult", "bcCountModule", "bcDataModule", "bcPDF417INFO", "bcROI_DETECT", "bcTextDecoderTypes", "bcTextFieldType", "bcType_DECODE", "bcType_DETECT"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of PArrayField from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in bc_data_module (list)
        _items = []
        if self.bc_data_module:
            for _item_bc_data_module in self.bc_data_module:
                if _item_bc_data_module:
                    _items.append(_item_bc_data_module.to_dict())
            _dict['bcDataModule'] = _items
        # override the default output from pydantic by calling `to_dict()` of bc_pdf417_info
        if self.bc_pdf417_info:
            _dict['bcPDF417INFO'] = self.bc_pdf417_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of bc_roi_detect
        if self.bc_roi_detect:
            _dict['bcROI_DETECT'] = self.bc_roi_detect.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of PArrayField from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bcAngle_DETECT": obj.get("bcAngle_DETECT"),
            "bcCodeResult": obj.get("bcCodeResult"),
            "bcCountModule": obj.get("bcCountModule"),
            "bcDataModule": [DataModule.from_dict(_item) for _item in obj["bcDataModule"]] if obj.get("bcDataModule") is not None else None,
            "bcPDF417INFO": BcPDF417INFO.from_dict(obj["bcPDF417INFO"]) if obj.get("bcPDF417INFO") is not None else None,
            "bcROI_DETECT": BcROIDETECT.from_dict(obj["bcROI_DETECT"]) if obj.get("bcROI_DETECT") is not None else None,
            "bcTextDecoderTypes": obj.get("bcTextDecoderTypes"),
            "bcTextFieldType": obj.get("bcTextFieldType"),
            "bcType_DECODE": obj.get("bcType_DECODE"),
            "bcType_DETECT": obj.get("bcType_DETECT")
        })
        return _obj


