# coding: utf-8

"""
    Generated by: https://openapi-generator.tech
"""

from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from regula.documentreader.webclient.gen.models.images_available_source import ImagesAvailableSource
from regula.documentreader.webclient.gen.models.images_field import ImagesField
from typing import Optional, Set
from typing_extensions import Self

class Images(BaseModel):
    """
    Images
    """ # noqa: E501
    field_count: Optional[StrictInt] = Field(default=None, description="Fields count", alias="fieldCount")
    available_source_count: Optional[StrictInt] = Field(default=None, description="Available sources count", alias="availableSourceCount")
    available_source_list: List[ImagesAvailableSource] = Field(alias="availableSourceList")
    field_list: List[ImagesField] = Field(alias="fieldList")
    __properties: ClassVar[List[str]] = ["fieldCount", "availableSourceCount", "availableSourceList", "fieldList"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Images from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in available_source_list (list)
        _items = []
        if self.available_source_list:
            for _item_available_source_list in self.available_source_list:
                if _item_available_source_list:
                    _items.append(_item_available_source_list.to_dict())
            _dict['availableSourceList'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in field_list (list)
        _items = []
        if self.field_list:
            for _item_field_list in self.field_list:
                if _item_field_list:
                    _items.append(_item_field_list.to_dict())
            _dict['fieldList'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Images from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fieldCount": obj.get("fieldCount"),
            "availableSourceCount": obj.get("availableSourceCount"),
            "availableSourceList": [ImagesAvailableSource.from_dict(_item) for _item in obj["availableSourceList"]] if obj.get("availableSourceList") is not None else None,
            "fieldList": [ImagesField.from_dict(_item) for _item in obj["fieldList"]] if obj.get("fieldList") is not None else None
        })
        return _obj


