# coding: utf-8

"""
    Files

    Upload and manage files.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from hubspot.files.files.api_client import ApiClient
from hubspot.files.files.exceptions import ApiTypeError, ApiValueError  # noqa: F401


class FoldersApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def archive(self, folder_id, **kwargs):  # noqa: E501
        """Delete folder.  # noqa: E501

        Delete folder by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive(folder_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str folder_id: ID of folder to delete. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_with_http_info(folder_id, **kwargs)  # noqa: E501

    def archive_with_http_info(self, folder_id, **kwargs):  # noqa: E501
        """Delete folder.  # noqa: E501

        Delete folder by ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_with_http_info(folder_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str folder_id: ID of folder to delete. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["folder_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method archive" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'folder_id' is set
        if self.api_client.client_side_validation and (
            "folder_id" not in local_var_params
            or local_var_params["folder_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `folder_id` when calling `archive`"
            )  # noqa: E501

        if (
            self.api_client.client_side_validation
            and "folder_id" in local_var_params
            and not re.search(r"\d+", local_var_params["folder_id"])
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `folder_id` when calling `archive`, must conform to the pattern `/\d+/`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "folder_id" in local_var_params:
            path_params["folderId"] = local_var_params["folder_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/folders/{folderId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def archive_by_path(self, folder_path, **kwargs):  # noqa: E501
        """Delete folder.  # noqa: E501

        Delete folder by path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_by_path(folder_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str folder_path: Path of folder to delete (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.archive_by_path_with_http_info(folder_path, **kwargs)  # noqa: E501

    def archive_by_path_with_http_info(self, folder_path, **kwargs):  # noqa: E501
        """Delete folder.  # noqa: E501

        Delete folder by path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.archive_by_path_with_http_info(folder_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str folder_path: Path of folder to delete (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["folder_path"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method archive_by_path" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'folder_path' is set
        if self.api_client.client_side_validation and (
            "folder_path" not in local_var_params
            or local_var_params["folder_path"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `folder_path` when calling `archive_by_path`"
            )  # noqa: E501

        if (
            self.api_client.client_side_validation
            and "folder_path" in local_var_params
            and not re.search(r".+", local_var_params["folder_path"])
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `folder_path` when calling `archive_by_path`, must conform to the pattern `/.+/`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "folder_path" in local_var_params:
            path_params["folderPath"] = local_var_params["folder_path"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/folders/{folderPath}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def check_update_status(self, task_id, **kwargs):  # noqa: E501
        """Check folder update status.  # noqa: E501

        Check status of folder update. Folder updates happen asynchronously.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_update_status(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Task ID of folder update (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FolderActionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.check_update_status_with_http_info(task_id, **kwargs)  # noqa: E501

    def check_update_status_with_http_info(self, task_id, **kwargs):  # noqa: E501
        """Check folder update status.  # noqa: E501

        Check status of folder update. Folder updates happen asynchronously.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.check_update_status_with_http_info(task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Task ID of folder update (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FolderActionResponse, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["task_id"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method check_update_status" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'task_id' is set
        if self.api_client.client_side_validation and (
            "task_id" not in local_var_params
            or local_var_params["task_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `task_id` when calling `check_update_status`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "task_id" in local_var_params:
            path_params["taskId"] = local_var_params["task_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/folders/update/async/tasks/{taskId}/status",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FolderActionResponse",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create(self, folder_input, **kwargs):  # noqa: E501
        """Create folder.  # noqa: E501

        Creates a folder.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create(folder_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FolderInput folder_input: Folder creation options (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.create_with_http_info(folder_input, **kwargs)  # noqa: E501

    def create_with_http_info(self, folder_input, **kwargs):  # noqa: E501
        """Create folder.  # noqa: E501

        Creates a folder.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_with_http_info(folder_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FolderInput folder_input: Folder creation options (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Folder, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["folder_input"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'" " to method create" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'folder_input' is set
        if self.api_client.client_side_validation and (
            "folder_input" not in local_var_params
            or local_var_params["folder_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `folder_input` when calling `create`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "folder_input" in local_var_params:
            body_params = local_var_params["folder_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/folders",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Folder",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def do_search(self, **kwargs):  # noqa: E501
        """Search folders  # noqa: E501

        Search for folders. Does not contain hidden or archived folders.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_search(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] properties: Properties that should be included in the returned folders.
        :param str after: The maximum offset of items for a given search is 10000. Narrow your search down if you are reaching this limit.
        :param str before:
        :param int limit: Limit of results to return. Max limit is 100.
        :param list[str] sort: Sort results by given property. For example -name sorts by name field descending, name sorts by name field ascending.
        :param str id: Search folder by given ID.
        :param datetime created_at: Search for folders with the given creation timestamp.
        :param datetime updated_at: Search for folder at given update timestamp.
        :param str name: Search for folders containing the specified name.
        :param str path: Search for folders by path.
        :param int parent_folder_id: Search for folders with the given parent folder ID.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CollectionResponseFolder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.do_search_with_http_info(**kwargs)  # noqa: E501

    def do_search_with_http_info(self, **kwargs):  # noqa: E501
        """Search folders  # noqa: E501

        Search for folders. Does not contain hidden or archived folders.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.do_search_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param list[str] properties: Properties that should be included in the returned folders.
        :param str after: The maximum offset of items for a given search is 10000. Narrow your search down if you are reaching this limit.
        :param str before:
        :param int limit: Limit of results to return. Max limit is 100.
        :param list[str] sort: Sort results by given property. For example -name sorts by name field descending, name sorts by name field ascending.
        :param str id: Search folder by given ID.
        :param datetime created_at: Search for folders with the given creation timestamp.
        :param datetime updated_at: Search for folder at given update timestamp.
        :param str name: Search for folders containing the specified name.
        :param str path: Search for folders by path.
        :param int parent_folder_id: Search for folders with the given parent folder ID.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CollectionResponseFolder, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            "properties",
            "after",
            "before",
            "limit",
            "sort",
            "id",
            "created_at",
            "updated_at",
            "name",
            "path",
            "parent_folder_id",
        ]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method do_search" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if (
            "properties" in local_var_params
            and local_var_params["properties"] is not None
        ):  # noqa: E501
            query_params.append(
                ("properties", local_var_params["properties"])
            )  # noqa: E501
            collection_formats["properties"] = "multi"  # noqa: E501
        if (
            "after" in local_var_params and local_var_params["after"] is not None
        ):  # noqa: E501
            query_params.append(("after", local_var_params["after"]))  # noqa: E501
        if (
            "before" in local_var_params and local_var_params["before"] is not None
        ):  # noqa: E501
            query_params.append(("before", local_var_params["before"]))  # noqa: E501
        if (
            "limit" in local_var_params and local_var_params["limit"] is not None
        ):  # noqa: E501
            query_params.append(("limit", local_var_params["limit"]))  # noqa: E501
        if (
            "sort" in local_var_params and local_var_params["sort"] is not None
        ):  # noqa: E501
            query_params.append(("sort", local_var_params["sort"]))  # noqa: E501
            collection_formats["sort"] = "multi"  # noqa: E501
        if (
            "id" in local_var_params and local_var_params["id"] is not None
        ):  # noqa: E501
            query_params.append(("id", local_var_params["id"]))  # noqa: E501
        if (
            "created_at" in local_var_params
            and local_var_params["created_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("createdAt", local_var_params["created_at"])
            )  # noqa: E501
        if (
            "updated_at" in local_var_params
            and local_var_params["updated_at"] is not None
        ):  # noqa: E501
            query_params.append(
                ("updatedAt", local_var_params["updated_at"])
            )  # noqa: E501
        if (
            "name" in local_var_params and local_var_params["name"] is not None
        ):  # noqa: E501
            query_params.append(("name", local_var_params["name"]))  # noqa: E501
        if (
            "path" in local_var_params and local_var_params["path"] is not None
        ):  # noqa: E501
            query_params.append(("path", local_var_params["path"]))  # noqa: E501
        if (
            "parent_folder_id" in local_var_params
            and local_var_params["parent_folder_id"] is not None
        ):  # noqa: E501
            query_params.append(
                ("parentFolderId", local_var_params["parent_folder_id"])
            )  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/folders/search",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CollectionResponseFolder",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_by_id(self, folder_id, **kwargs):  # noqa: E501
        """Get folder  # noqa: E501

        Get folder by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id(folder_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str folder_id: ID of desired folder (required)
        :param list[str] properties: Properties to set on returned folder.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_by_id_with_http_info(folder_id, **kwargs)  # noqa: E501

    def get_by_id_with_http_info(self, folder_id, **kwargs):  # noqa: E501
        """Get folder  # noqa: E501

        Get folder by ID  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_id_with_http_info(folder_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str folder_id: ID of desired folder (required)
        :param list[str] properties: Properties to set on returned folder.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Folder, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["folder_id", "properties"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'folder_id' is set
        if self.api_client.client_side_validation and (
            "folder_id" not in local_var_params
            or local_var_params["folder_id"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `folder_id` when calling `get_by_id`"
            )  # noqa: E501

        if (
            self.api_client.client_side_validation
            and "folder_id" in local_var_params
            and not re.search(r"\d+", local_var_params["folder_id"])
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `folder_id` when calling `get_by_id`, must conform to the pattern `/\d+/`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "folder_id" in local_var_params:
            path_params["folderId"] = local_var_params["folder_id"]  # noqa: E501

        query_params = []
        if (
            "properties" in local_var_params
            and local_var_params["properties"] is not None
        ):  # noqa: E501
            query_params.append(
                ("properties", local_var_params["properties"])
            )  # noqa: E501
            collection_formats["properties"] = "multi"  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/folders/{folderId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Folder",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_by_path(self, folder_path, **kwargs):  # noqa: E501
        """Get folder.  # noqa: E501

        Get folder by path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_path(folder_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str folder_path: Path of desired folder. (required)
        :param list[str] properties: Properties to set on returned folder.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Folder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.get_by_path_with_http_info(folder_path, **kwargs)  # noqa: E501

    def get_by_path_with_http_info(self, folder_path, **kwargs):  # noqa: E501
        """Get folder.  # noqa: E501

        Get folder by path.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_by_path_with_http_info(folder_path, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str folder_path: Path of desired folder. (required)
        :param list[str] properties: Properties to set on returned folder.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(Folder, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["folder_path", "properties"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_by_path" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'folder_path' is set
        if self.api_client.client_side_validation and (
            "folder_path" not in local_var_params
            or local_var_params["folder_path"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `folder_path` when calling `get_by_path`"
            )  # noqa: E501

        if (
            self.api_client.client_side_validation
            and "folder_path" in local_var_params
            and not re.search(r".+", local_var_params["folder_path"])
        ):  # noqa: E501
            raise ApiValueError(
                "Invalid value for parameter `folder_path` when calling `get_by_path`, must conform to the pattern `/.+/`"
            )  # noqa: E501
        collection_formats = {}

        path_params = {}
        if "folder_path" in local_var_params:
            path_params["folderPath"] = local_var_params["folder_path"]  # noqa: E501

        query_params = []
        if (
            "properties" in local_var_params
            and local_var_params["properties"] is not None
        ):  # noqa: E501
            query_params.append(
                ("properties", local_var_params["properties"])
            )  # noqa: E501
            collection_formats["properties"] = "multi"  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/folders/{folderPath}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Folder",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_properties(self, folder_update_input, **kwargs):  # noqa: E501
        """Update folder properties  # noqa: E501

        Update properties of folder by given ID. This action happens asynchronously and will update all of the folder's children as well.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_properties(folder_update_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FolderUpdateInput folder_update_input: Properties to change in the folder (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: FolderUpdateTaskLocator
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        return self.update_properties_with_http_info(
            folder_update_input, **kwargs
        )  # noqa: E501

    def update_properties_with_http_info(
        self, folder_update_input, **kwargs
    ):  # noqa: E501
        """Update folder properties  # noqa: E501

        Update properties of folder by given ID. This action happens asynchronously and will update all of the folder's children as well.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_properties_with_http_info(folder_update_input, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param FolderUpdateInput folder_update_input: Properties to change in the folder (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(FolderUpdateTaskLocator, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = ["folder_update_input"]
        all_params.extend(
            [
                "async_req",
                "_return_http_data_only",
                "_preload_content",
                "_request_timeout",
            ]
        )

        for key, val in six.iteritems(local_var_params["kwargs"]):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_properties" % key
                )
            local_var_params[key] = val
        del local_var_params["kwargs"]
        # verify the required parameter 'folder_update_input' is set
        if self.api_client.client_side_validation and (
            "folder_update_input" not in local_var_params
            or local_var_params["folder_update_input"] is None  # noqa: E501
        ):  # noqa: E501
            raise ApiValueError(
                "Missing the required parameter `folder_update_input` when calling `update_properties`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "folder_update_input" in local_var_params:
            body_params = local_var_params["folder_update_input"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json", "*/*"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["hapikey", "oauth2"]  # noqa: E501

        return self.api_client.call_api(
            "/files/v3/folders/update/async",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="FolderUpdateTaskLocator",  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get("async_req"),
            _return_http_data_only=local_var_params.get(
                "_return_http_data_only"
            ),  # noqa: E501
            _preload_content=local_var_params.get("_preload_content", True),
            _request_timeout=local_var_params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
