# coding: utf-8

"""
    Video Conference Extension

    These APIs allow you to specify URLs that can be used to interact with a video conferencing application, to allow HubSpot to add video conference links to meeting requests with contacts.  # noqa: E501

    The version of the OpenAPI document: v3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from hubspot.crm.extensions.videoconferencing.configuration import Configuration


class ExternalSettings(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "create_meeting_url": "str",
        "update_meeting_url": "str",
        "delete_meeting_url": "str",
        "user_verify_url": "str",
    }

    attribute_map = {
        "create_meeting_url": "createMeetingUrl",
        "update_meeting_url": "updateMeetingUrl",
        "delete_meeting_url": "deleteMeetingUrl",
        "user_verify_url": "userVerifyUrl",
    }

    def __init__(
        self,
        create_meeting_url=None,
        update_meeting_url=None,
        delete_meeting_url=None,
        user_verify_url=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """ExternalSettings - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._create_meeting_url = None
        self._update_meeting_url = None
        self._delete_meeting_url = None
        self._user_verify_url = None
        self.discriminator = None

        self.create_meeting_url = create_meeting_url
        if update_meeting_url is not None:
            self.update_meeting_url = update_meeting_url
        if delete_meeting_url is not None:
            self.delete_meeting_url = delete_meeting_url
        if user_verify_url is not None:
            self.user_verify_url = user_verify_url

    @property
    def create_meeting_url(self):
        """Gets the create_meeting_url of this ExternalSettings.  # noqa: E501

        The URL that HubSpot will send requests to create a new video conference.  # noqa: E501

        :return: The create_meeting_url of this ExternalSettings.  # noqa: E501
        :rtype: str
        """
        return self._create_meeting_url

    @create_meeting_url.setter
    def create_meeting_url(self, create_meeting_url):
        """Sets the create_meeting_url of this ExternalSettings.

        The URL that HubSpot will send requests to create a new video conference.  # noqa: E501

        :param create_meeting_url: The create_meeting_url of this ExternalSettings.  # noqa: E501
        :type: str
        """
        if (
            self.local_vars_configuration.client_side_validation
            and create_meeting_url is None
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `create_meeting_url`, must not be `None`"
            )  # noqa: E501

        self._create_meeting_url = create_meeting_url

    @property
    def update_meeting_url(self):
        """Gets the update_meeting_url of this ExternalSettings.  # noqa: E501

        The URL that HubSpot will send updates to existing meetings. Typically called when the user changes the topic or times of a meeting.  # noqa: E501

        :return: The update_meeting_url of this ExternalSettings.  # noqa: E501
        :rtype: str
        """
        return self._update_meeting_url

    @update_meeting_url.setter
    def update_meeting_url(self, update_meeting_url):
        """Sets the update_meeting_url of this ExternalSettings.

        The URL that HubSpot will send updates to existing meetings. Typically called when the user changes the topic or times of a meeting.  # noqa: E501

        :param update_meeting_url: The update_meeting_url of this ExternalSettings.  # noqa: E501
        :type: str
        """

        self._update_meeting_url = update_meeting_url

    @property
    def delete_meeting_url(self):
        """Gets the delete_meeting_url of this ExternalSettings.  # noqa: E501

        The URL that HubSpot will send notifications of meetings that have been deleted in HubSpot.  # noqa: E501

        :return: The delete_meeting_url of this ExternalSettings.  # noqa: E501
        :rtype: str
        """
        return self._delete_meeting_url

    @delete_meeting_url.setter
    def delete_meeting_url(self, delete_meeting_url):
        """Sets the delete_meeting_url of this ExternalSettings.

        The URL that HubSpot will send notifications of meetings that have been deleted in HubSpot.  # noqa: E501

        :param delete_meeting_url: The delete_meeting_url of this ExternalSettings.  # noqa: E501
        :type: str
        """

        self._delete_meeting_url = delete_meeting_url

    @property
    def user_verify_url(self):
        """Gets the user_verify_url of this ExternalSettings.  # noqa: E501

        The URL that HubSpot will use to verify that a user exists in the video conference application.  # noqa: E501

        :return: The user_verify_url of this ExternalSettings.  # noqa: E501
        :rtype: str
        """
        return self._user_verify_url

    @user_verify_url.setter
    def user_verify_url(self, user_verify_url):
        """Sets the user_verify_url of this ExternalSettings.

        The URL that HubSpot will use to verify that a user exists in the video conference application.  # noqa: E501

        :param user_verify_url: The user_verify_url of this ExternalSettings.  # noqa: E501
        :type: str
        """

        self._user_verify_url = user_verify_url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ExternalSettings):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ExternalSettings):
            return True

        return self.to_dict() != other.to_dict()
