# 2022.9.7, data from bnc | ubuntu@cpu76:/ftp/cikuu/bin$ python3 mydump.py --port 3307 tsv "select substring_index(s,':',-1) word, 1000000 * i/5311102 from bnc where s like 'LEM:%' "   > lemma_mf.txt
lemma_mf = {
"a":389527.4465,
"aardvark":1.5063,
"aaron":0.3766,
"ab":10.9205,
"abacus":5.2720,
"abandon":874.7714,
"abandoning":2.2594,
"abandonment":87.9290,
"abandons":0.3766,
"abatement":23.9122,
"abbey":105.2512,
"abbot":67.0294,
"abbreviated":9.4142,
"abbreviation":41.2344,
"abc":1.1297,
"abdomen":51.0252,
"abdominal":97.1550,
"abducted":0.1883,
"abduction":40.8578,
"abel":0.1883,
"aberdeen":1.5063,
"aberration":33.3264,
"abide":117.8663,
"abiding":0.7531,
"ability":1898.6643,
"ablation":9.9791,
"able":5446.8922,
"abler":0.5649,
"ably":18.2636,
"abnormal":147.9919,
"abnormality":131.0462,
"abnormally":26.5482,
"aboard":171.7158,
"abode":31.0670,
"abolish":339.6659,
"abolition":204.6656,
"aboriginal":33.8913,
"abort":43.6821,
"aborted":4.3306,
"abortion":276.9670,
"abound":84.1633,
"about":34736.8588,
"above":4397.9573,
"abraham":0.1883,
"abrasion":17.3222,
"abrasive":46.1298,
"abreast":34.6444,
"abridged":2.2594,
"abroad":702.3025,
"abrupt":85.1047,
"abruptly":210.1259,
"abs":9.9791,
"abscess":18.0753,
"absence":1048.9349,
"absent":305.5863,
"absentee":39.7281,
"absenteeism":31.0670,
"absinthe":0.5649,
"absolute":617.0094,
"absolutely":962.3238,
"absorb":505.9214,
"absorbed":3.7657,
"absorbent":15.4394,
"absorber":9.9791,
"absorbing":26.1716,
"absorbs":0.5649,
"absorption":174.3518,
"abstain":50.6486,
"abstinence":26.1716,
"abstract":363.5780,
"abstracted":0.3766,
"abstraction":107.3224,
"abstractly":2.0711,
"absurd":166.8204,
"absurdity":53.0963,
"abundance":120.5023,
"abundant":108.0755,
"abundantly":33.1381,
"abuse":906.5915,
"abused":2.4477,
"abuser":24.6653,
"abusing":0.5649,
"abusive":41.7992,
"abyss":23.1590,
"ac":34.0796,
"acacia":3.0126,
"academia":16.7574,
"academic":987.9306,
"academically":32.5733,
"academy":55.7323,
"acapulco":0.7531,
"accelerate":239.1217,
"accelerated":29.3724,
"accelerating":0.1883,
"acceleration":117.3015,
"accelerator":67.0294,
"accent":330.8165,
"accented":3.9540,
"accept":3749.1278,
"acceptability":50.0838,
"acceptable":650.5241,
"acceptance":483.8920,
"accepted":33.7030,
"accepting":0.3766,
"acceptor":9.6025,
"accepts":0.1883,
"access":1933.6853,
"accessibility":54.6026,
"accessible":296.9252,
"accessing":2.6360,
"accession":91.1299,
"accessory":133.3057,
"accident":1425.5045,
"accidental":132.3642,
"accidentally":99.0378,
"acclaim":92.6361,
"acclaimed":12.2385,
"accommodate":374.4986,
"accommodated":0.1883,
"accommodating":6.0251,
"accommodation":752.7628,
"accompanied":1.1297,
"accompanies":0.1883,
"accompaniment":69.1005,
"accompany":905.6501,
"accompanying":42.5524,
"accomplish":180.3769,
"accomplished":44.4352,
"accomplishing":0.1883,
"accomplishment":39.3515,
"accord":3142.2857,
"accordance":351.5278,
"accordingly":397.8459,
"accordion":17.8871,
"account":4357.0995,
"accountability":215.7744,
"accountable":120.5023,
"accountancy":85.6696,
"accountant":345.5027,
"accounted":0.1883,
"accounting":410.0844,
"accounts":0.1883,
"accreditation":47.6361,
"accredited":7.3431,
"accrediting":0.7531,
"accretion":23.5356,
"accrual":15.2511,
"accruals":0.1883,
"accrue":112.5943,
"accrued":0.1883,
"accumulate":261.1511,
"accumulated":0.7531,
"accumulation":169.6446,
"accuracy":300.8792,
"accurate":521.7373,
"accurately":255.6908,
"accusation":205.2305,
"accuse":1065.8805,
"accused":0.5649,
"accusing":1.1297,
"accustom":83.4102,
"accustomed":88.3056,
"accustoms":0.1883,
"ace":95.8370,
"aces":1.3180,
"acetate":25.0419,
"acetic":19.7699,
"acetone":6.9665,
"ache":228.5778,
"ached":0.1883,
"achievable":38.0335,
"achieve":3023.6663,
"achieved":1.3180,
"achievement":812.4491,
"achieving":3.3891,
"achilles":1.3180,
"aching":7.9080,
"acid":963.6418,
"acidic":34.2678,
"acidity":50.8369,
"acids":1.3180,
"acknowledge":795.8800,
"acknowledged":0.3766,
"acknowledgement":107.1341,
"acknowledging":1.8828,
"acknowledgment":19.3933,
"acme":2.8243,
"acne":23.7239,
"acorn":15.8159,
"acoustic":156.0881,
"acoustical":1.3180,
"acquaint":63.6403,
"acquaintance":159.1007,
"acquainted":6.2134,
"acquire":1265.8390,
"acquired":2.2594,
"acquiring":0.9414,
"acquisition":580.8587,
"acquitted":0.1883,
"acre":420.2518,
"acreage":21.6528,
"acres":0.1883,
"acrobat":11.6737,
"acronym":22.0293,
"acronyms":0.1883,
"acropolis":1.5063,
"across":4377.9991,
"acrylic":59.8746,
"act":3990.8855,
"acting":93.0127,
"action":4525.6145,
"actionable":16.0042,
"activate":281.2976,
"activated":2.6360,
"activation":98.2847,
"activator":64.0168,
"active":1312.9102,
"actively":270.0005,
"activism":20.7113,
"activist":229.7075,
"activity":4059.0446,
"actor":653.7250,
"actors":0.3766,
"actress":211.8204,
"acts":3.7657,
"actual":1218.0146,
"actuality":29.9373,
"actually":4610.7192,
"actuarial":33.7030,
"actuate":7.7197,
"actuator":1.6946,
"acuity":10.5440,
"acupuncture":34.6444,
"acute":415.7329,
"acutely":72.8662,
"acyclovir":0.3766,
"ad":472.0301,
"ada":0.1883,
"adage":20.8996,
"adagio":1.8828,
"adam":0.1883,
"adamant":66.6528,
"adams":0.1883,
"adapt":522.6787,
"adaptability":28.2427,
"adaptable":42.9289,
"adaptation":208.9962,
"adapter":15.4394,
"adapting":0.5649,
"adaptive":57.4269,
"adaptor":50.2721,
"adapts":0.3766,
"add":5138.1050,
"added":4.7071,
"addendum":13.7448,
"adder":16.9456,
"addi":0.1883,
"addict":84.5399,
"addicted":39.1632,
"addicting":0.1883,
"addiction":119.1843,
"addictive":109.0169,
"adding":4.1423,
"addition":1894.7104,
"additional":1277.8892,
"additionally":101.8621,
"additive":73.4311,
"address":2121.0287,
"addressed":0.1883,
"addressee":8.2845,
"addressing":7.9080,
"adds":0.5649,
"adept":47.4478,
"adequacy":49.3306,
"adequate":635.8379,
"adequately":205.0422,
"adhere":142.9082,
"adherence":64.7700,
"adhering":0.3766,
"adhesion":64.7700,
"adhesive":73.8077,
"adj":0.3766,
"adjacent":280.7327,
"adjective":171.5275,
"adjoining":92.8244,
"adjourn":123.1383,
"adjournment":28.0544,
"adjudication":49.3306,
"adjunct":35.3976,
"adjust":509.1222,
"adjustable":69.6654,
"adjusted":6.7783,
"adjuster":11.6737,
"adjusting":4.7071,
"adjustment":376.9463,
"admin":19.5816,
"administer":344.5613,
"administered":0.5649,
"administering":1.3180,
"administrate":2.4477,
"administration":1001.6754,
"administrative":582.7416,
"administratively":15.8159,
"administrator":235.3561,
"administrators":0.1883,
"admirable":85.4813,
"admirably":43.3055,
"admiral":45.3766,
"admiralty":3.9540,
"admiration":169.8329,
"admire":399.3521,
"admired":14.6862,
"admiring":5.2720,
"admissibility":15.6276,
"admissible":42.3641,
"admission":481.6326,
"admit":2014.8361,
"admits":0.3766,
"admittedly":127.0923,
"admitting":0.7531,
"admixture":4.7071,
"ado":17.5105,
"adobe":3.7657,
"adolescence":79.8328,
"adolescent":153.4521,
"adonis":0.5649,
"adopt":1589.6889,
"adopted":2.4477,
"adopting":0.1883,
"adoption":271.6950,
"adoptive":23.7239,
"adopts":1.1297,
"adorable":12.2385,
"adoration":25.0419,
"adore":108.8286,
"adored":0.5649,
"adorn":79.2679,
"adrenal":4.3306,
"adrenaline":22.0293,
"adrian":3.9540,
"adriatic":7.5314,
"adsorption":17.8871,
"adult":1447.9104,
"adultery":50.8369,
"adulthood":54.0377,
"advance":1386.9061,
"advanced":603.0763,
"advancement":79.0796,
"advances":1.1297,
"advancing":0.9414,
"advantage":1824.8567,
"advantaged":7.7197,
"advantageous":66.6528,
"advent":125.7743,
"adventist":0.7531,
"adventure":335.7119,
"adventurer":105.0629,
"adventures":0.7531,
"adventurous":80.5859,
"adversarial":22.4059,
"adversary":62.5106,
"adverse":216.9041,
"adversely":76.2554,
"adversity":30.3139,
"advert":147.0505,
"advertise":299.3729,
"advertised":2.8243,
"advertisement":374.4986,
"advertiser":70.7951,
"advertising":717.5535,
"advice":1724.1243,
"advisable":94.8956,
"advise":964.3950,
"advised":3.2008,
"adviser":538.6829,
"advising":0.7531,
"advisors":0.1883,
"advisory":157.9710,
"advocacy":81.5273,
"advocate":453.7665,
"aegean":7.9080,
"aegis":24.4770,
"aerial":133.6822,
"aerobic":45.3766,
"aerobics":34.2678,
"aerodynamic":26.3599,
"aeronautical":8.2845,
"aeronautics":0.1883,
"aeroplane":134.4354,
"aerosol":50.0838,
"aerosols":0.1883,
"aerospace":44.4352,
"aesthetic":243.8289,
"aesthetically":19.7699,
"af":8.2845,
"afar":24.4770,
"affair":1407.4292,
"affect":2451.0921,
"affected":91.3181,
"affecting":1.3180,
"affection":278.6616,
"affectionate":57.8034,
"affectionately":37.2804,
"affective":38.5984,
"affectively":0.3766,
"affidavit":60.8160,
"affiliate":78.3265,
"affiliated":15.4394,
"affiliation":83.2219,
"affine":3.9540,
"affinity":154.0170,
"affirm":123.3266,
"affirmation":45.5649,
"affirmative":43.3055,
"affirming":1.5063,
"affix":27.8662,
"affixed":0.5649,
"afflicted":0.7531,
"affliction":25.2302,
"affluent":70.7951,
"afford":937.6585,
"affordability":5.0837,
"affordable":70.4185,
"affords":2.2594,
"afghan":32.7616,
"afghanistan":0.5649,
"afield":63.4520,
"afloat":41.7992,
"aforementioned":19.7699,
"aforesaid":11.8619,
"afraid":983.6000,
"african":546.2143,
"afrikaans":0.1883,
"afro":46.5064,
"aft":36.1507,
"after":20620.2027,
"afterlife":12.4268,
"aftermarket":1.6946,
"aftermath":121.4437,
"afternoon":1547.1365,
"aftershave":12.8034,
"afterward":6.4017,
"afterwards":805.6708,
"ag":0.5649,
"again":10354.7249,
"against":9846.7324,
"agar":3.0126,
"agate":4.5188,
"age":4869.9874,
"aged":387.6785,
"ageing":76.0671,
"agencies":0.5649,
"agency":1423.0568,
"agenda":433.2434,
"agent":1369.0191,
"aggravated":6.9665,
"aggravating":9.0377,
"aggregate":319.3311,
"aggregated":8.8494,
"aggregation":50.6486,
"aggression":241.5695,
"aggressive":352.6575,
"aggressively":52.1549,
"aggrieved":20.8996,
"agile":25.6067,
"agility":28.9959,
"aging":5.8368,
"agitated":49.3306,
"agitation":88.1173,
"agnostic":18.8285,
"ago":3485.3407,
"agony":177.9292,
"agrarian":50.6486,
"agree":4282.7270,
"agreeable":70.6068,
"agreed":18.6402,
"agreeing":3.2008,
"agreement":2663.1008,
"agrees":1.5063,
"agribusiness":6.0251,
"agricultural":658.0555,
"agriculture":398.9756,
"agronomy":0.7531,
"ahead":1593.0780,
"ai":43.4938,
"aid":1811.8650,
"aide":90.7533,
"aided":0.7531,
"aiding":0.3766,
"aids":8.8494,
"ailing":3.9540,
"aim":2712.4314,
"aimed":0.1883,
"aiming":0.9414,
"aimless":11.2971,
"aimlessness":3.3891,
"aims":0.9414,
"air":3182.3904,
"airbag":9.9791,
"airborne":62.8871,
"airbrush":5.8368,
"airbus":0.7531,
"aircraft":1089.0395,
"airfare":1.3180,
"airfield":129.9165,
"airflow":9.9791,
"airing":23.7239,
"airline":292.0298,
"airmail":8.2845,
"airman":44.2469,
"airplane":17.1339,
"airport":447.5531,
"airports":0.5649,
"airspace":19.9582,
"airtime":7.5314,
"airway":31.2553,
"airy":48.7658,
"aisle":109.2052,
"ajax":0.3766,
"aka":10.5440,
"akin":73.4311,
"al":3.9540,
"ala":1.3180,
"alabaster":8.2845,
"alanine":5.4603,
"alarm":534.5407,
"alarmed":66.8411,
"alarming":109.7701,
"alas":106.3809,
"alaska":0.7531,
"alaskan":12.0502,
"alb":1.3180,
"albania":0.5649,
"albanian":50.8369,
"albatross":11.6737,
"albeit":246.4649,
"albert":0.1883,
"albion":1.5063,
"album":471.4652,
"albumin":33.8913,
"albums":0.1883,
"albuquerque":0.1883,
"alchemist":15.0628,
"alchemy":13.3682,
"alcohol":559.9591,
"alcoholic":160.6070,
"alcoholism":41.9875,
"alder":20.5230,
"alderman":19.0168,
"ale":117.6780,
"alert":379.3940,
"alerting":0.1883,
"alexander":1.1297,
"alfalfa":3.7657,
"alfred":2.4477,
"algae":102.8035,
"algal":16.7574,
"algebra":34.8327,
"algebraic":22.7825,
"algerian":28.6193,
"algorithm":136.8831,
"algorithmic":2.4477,
"algorithms":0.3766,
"ali":0.3766,
"alias":25.4185,
"aliasing":0.3766,
"alien":273.3896,
"alienate":96.4018,
"alienated":19.2051,
"alienation":70.6068,
"aliens":0.5649,
"align":108.4521,
"aligned":14.3096,
"aligning":0.3766,
"alignment":98.8495,
"alike":269.4356,
"alimony":5.4603,
"alive":726.7795,
"alkali":46.1298,
"alkaline":60.2511,
"all":50583.4759,
"allegation":385.7956,
"allege":516.0888,
"alleged":126.1508,
"allegedly":183.7660,
"allegiance":139.3308,
"alleging":0.1883,
"allegro":1.8828,
"allele":28.8076,
"alleles":0.1883,
"allen":0.7531,
"allergen":6.0251,
"allergic":47.0712,
"allergy":61.1926,
"alleviate":99.0378,
"alleviating":0.3766,
"alleviation":10.3557,
"alley":116.7366,
"alliance":409.7078,
"allied":102.9918,
"alligator":14.8745,
"allocate":484.2686,
"allocated":0.3766,
"allocating":0.5649,
"allocation":414.2267,
"allocator":3.9540,
"allotment":62.3223,
"allotted":10.5440,
"allow":5869.9682,
"allowable":35.2093,
"allowance":573.7039,
"allowances":0.3766,
"allowed":3.2008,
"allowing":1.8828,
"allows":0.9414,
"alloy":83.5985,
"allure":12.9917,
"alluring":16.5691,
"alluvial":12.8034,
"ally":503.6620,
"almanac":3.9540,
"almighty":21.2762,
"almond":76.8202,
"almost":5502.4362,
"aloe":4.3306,
"aloft":36.9038,
"alone":2437.3473,
"along":4249.2123,
"alongside":580.4822,
"aloud":147.2387,
"alp":5.2720,
"alpaca":4.3306,
"alpha":281.4858,
"alphabet":57.0503,
"alphabetic":8.4728,
"alphabetical":41.7992,
"alphabetically":16.3808,
"alphanumeric":10.3557,
"alpine":37.8453,
"already":6039.8012,
"alright":1108.6211,
"alsace":0.1883,
"also":22306.4818,
"alt":9.2260,
"altar":160.4187,
"alter":814.1437,
"alterable":0.3766,
"alteration":267.3645,
"altered":17.6988,
"altering":0.7531,
"alternate":157.0296,
"alternately":41.6110,
"alternating":0.1883,
"alternative":1810.9236,
"alternatively":309.1637,
"alternatives":0.3766,
"alternator":14.4979,
"although":7685.9755,
"altitude":109.3935,
"alto":3.5774,
"altogether":568.4319,
"alum":9.2260,
"alumina":8.2845,
"aluminium":183.0129,
"aluminum":1.3180,
"alumnae":0.1883,
"alumni":0.1883,
"alumnus":17.1339,
"alveolar":14.3096,
"always":8103.4030,
"am":298.0549,
"amalgam":25.0419,
"amalgamation":53.8495,
"amateur":286.5695,
"amaze":42.7407,
"amazed":159.1007,
"amazement":87.1759,
"amazing":319.8959,
"amazingly":67.2177,
"amazon":0.9414,
"ambassador":189.7911,
"amber":68.1591,
"ambiance":1.8828,
"ambient":27.6779,
"ambiguity":192.6154,
"ambiguous":150.4396,
"ambition":415.5446,
"ambitious":279.9796,
"ambitiously":6.9665,
"ambulance":282.0507,
"ambulatory":19.7699,
"ambush":80.0211,
"amen":24.4770,
"amenable":58.5566,
"amend":321.0257,
"amended":0.3766,
"amending":1.5063,
"amendment":438.8920,
"amenity":135.1885,
"america":1.8828,
"american":2359.0208,
"americana":0.9414,
"americanism":4.7071,
"amethyst":11.4854,
"amid":192.0505,
"amidst":86.9876,
"amigo":0.3766,
"amigos":0.1883,
"amine":13.9331,
"amino":128.4103,
"amish":0.7531,
"amity":4.8954,
"ammo":6.4017,
"ammonia":65.5231,
"ammonium":18.2636,
"ammunition":106.3809,
"amnesia":18.6402,
"amnesty":60.8160,
"among":4014.0445,
"amongst":806.0474,
"amorphous":37.8453,
"amortization":1.3180,
"amount":3156.2188,
"amounting":6.7783,
"amounts":1.1297,
"amour":6.9665,
"amp":126.5274,
"amphetamine":22.4059,
"amphitheater":0.1883,
"amphitheatre":21.4645,
"ample":140.6488,
"amplification":52.3432,
"amplified":0.9414,
"amplifier":84.3516,
"amplify":80.0211,
"amplitude":76.6319,
"amps":0.3766,
"amsterdam":0.1883,
"amulet":9.7908,
"amuse":167.9501,
"amused":60.4394,
"amusement":183.5777,
"amusing":139.8956,
"an":60888.6819,
"ana":0.3766,
"anabolic":4.8954,
"anaconda":0.5649,
"anaerobic":26.1716,
"anaesthesia":28.4310,
"anal":92.8244,
"analgesic":18.6402,
"analog":0.7531,
"analogous":89.2470,
"analogue":103.9332,
"analogy":197.1342,
"analyse":734.1226,
"analysed":0.1883,
"analyser":37.4687,
"analysing":1.8828,
"analysis":2478.5817,
"analyst":341.1721,
"analytic":48.2009,
"analytical":135.3768,
"analytically":15.2511,
"analyze":58.9332,
"analyzer":0.7531,
"anarchist":34.2678,
"anarchy":45.1884,
"anatomical":41.2344,
"anatomy":71.9248,
"ancestor":224.4355,
"ancestral":50.6486,
"ancestry":39.7281,
"anchor":159.2890,
"anchorage":28.2427,
"anchored":3.0126,
"anchoring":9.0377,
"anchors":0.3766,
"ancient":839.1855,
"ancillary":60.0629,
"and":470059.1327,
"andante":0.3766,
"andean":22.2176,
"andersen":0.1883,
"anderson":1.8828,
"andes":0.3766,
"andorra":0.1883,
"androgen":2.6360,
"android":22.5942,
"anecdotal":30.1256,
"anecdote":77.5734,
"anesthesia":0.5649,
"aneurysm":7.5314,
"anew":31.4436,
"ang":0.3766,
"angel":214.4564,
"angelic":15.0628,
"anger":740.9009,
"angered":0.5649,
"angina":18.8285,
"angioplasty":10.5440,
"angle":651.8421,
"angled":53.6612,
"angler":118.8077,
"angles":0.3766,
"anglican":90.0002,
"angling":23.1590,
"angola":0.1883,
"angolan":0.3766,
"angrier":0.1883,
"angrily":189.4146,
"angry":725.2732,
"angst":18.0753,
"anguish":99.4144,
"angular":77.7616,
"angus":0.1883,
"animal":2707.7243,
"animate":84.3516,
"animated":15.0628,
"animation":59.3097,
"animator":5.8368,
"anion":19.2051,
"anisotropic":5.4603,
"anisotropy":2.2594,
"ankle":268.1176,
"anna":0.1883,
"annealing":9.2260,
"annex":47.6361,
"annexation":23.9122,
"annihilation":19.7699,
"anniversary":358.6826,
"annotate":20.5230,
"annotated":2.8243,
"annotation":16.7574,
"announce":2275.9872,
"announced":1.8828,
"announcement":492.5531,
"announcer":15.8159,
"announces":4.1423,
"annoy":141.0253,
"annoyance":83.0336,
"annoyed":90.0002,
"annoying":71.3600,
"annual":1295.0231,
"annually":195.8162,
"annuity":42.5524,
"anode":5.8368,
"anodized":0.5649,
"anomalous":47.4478,
"anomaly":107.1341,
"anonymity":48.7658,
"anonymous":157.5944,
"anonymously":16.7574,
"anorexia":12.4268,
"another":10693.8259,
"ans":0.1883,
"answer":4041.1576,
"answered":0.3766,
"answerer":0.9414,
"answering":38.9750,
"answers":0.1883,
"ant":168.3266,
"antagonist":42.7407,
"antarctic":11.4854,
"antares":0.3766,
"ante":34.4561,
"antecedent":50.4603,
"antelope":21.8410,
"antenna":15.2511,
"antennae":29.9373,
"anterior":37.0921,
"anthem":51.5900,
"anthology":35.3976,
"anthony":3.7657,
"anthrax":3.5774,
"anthropogenic":4.3306,
"anthropological":66.8411,
"anthropologist":127.4688,
"anthropology":96.0253,
"anti":1409.5003,
"antibacterial":10.1674,
"antibiotic":135.0002,
"antibody":271.3185,
"antichrist":5.8368,
"anticipate":496.6954,
"anticipated":12.8034,
"anticipation":147.2387,
"antics":0.5649,
"antidepressant":13.5565,
"antidote":36.1507,
"antigen":108.0755,
"antigens":0.5649,
"antilles":0.1883,
"antimicrobial":5.4603,
"antioxidant":7.1548,
"antiquarian":20.5230,
"antique":213.7033,
"antiques":0.1883,
"antiquity":86.7993,
"antisocial":9.0377,
"antitrust":14.4979,
"antiviral":4.5188,
"antiwar":0.9414,
"antler":23.3473,
"anus":26.9247,
"anvil":10.9205,
"anxiety":566.7374,
"anxious":543.9549,
"anxiously":111.0881,
"any":21754.0541,
"anybody":861.7797,
"anyhow":83.7868,
"anymore":49.7072,
"anyone":2593.6237,
"anything":4982.7701,
"anytime":20.1465,
"anyway":2105.0245,
"anyways":4.7071,
"anywhere":721.5075,
"aorta":3.2008,
"aortic":8.0962,
"apache":5.8368,
"apart":1762.7227,
"apartheid":86.0462,
"apartment":320.2725,
"apathy":45.5649,
"ape":92.4479,
"aperture":36.1507,
"apex":35.2093,
"aphrodite":0.7531,
"apical":31.4436,
"apiece":37.2804,
"apnea":0.1883,
"apo":0.7531,
"apocalypse":10.1674,
"apocalyptic":24.4770,
"apogee":7.3431,
"apologetic":43.4938,
"apologise":197.3225,
"apologising":0.5649,
"apologize":89.4353,
"apology":207.3016,
"apostle":52.1549,
"apostolic":16.7574,
"app":18.6402,
"appalachian":4.1423,
"appalled":30.5021,
"appalling":182.4480,
"apparatus":205.2305,
"apparel":9.7908,
"apparent":941.6125,
"apparently":1362.9940,
"appeal":2121.7819,
"appealing":75.1257,
"appear":5406.2227,
"appearance":1161.9058,
"appeared":4.7071,
"appearing":1.6946,
"appease":33.1381,
"appellant":105.8161,
"appellate":20.3348,
"append":30.6904,
"appended":0.7531,
"appending":0.1883,
"appendix":104.8747,
"appetite":189.6028,
"appetizer":1.3180,
"applaud":98.0964,
"applauded":0.1883,
"applauding":0.9414,
"applause":98.6613,
"apple":387.6785,
"apples":0.3766,
"applet":0.7531,
"appliance":117.6780,
"appliances":0.1883,
"applicability":37.8453,
"applicable":246.0883,
"applicant":416.2978,
"application":2798.8542,
"applicator":2.2594,
"applied":11.1088,
"applies":0.1883,
"applique":3.7657,
"apply":3544.0856,
"applying":0.7531,
"appoint":1477.2829,
"appointed":0.5649,
"appointee":32.7616,
"appointing":1.1297,
"appointment":1009.5833,
"apportionment":12.9917,
"appraisal":227.2598,
"appraiser":3.5774,
"appreciable":41.6110,
"appreciably":24.1005,
"appreciate":782.5118,
"appreciated":11.1088,
"appreciation":236.2975,
"appreciative":30.5021,
"apprehended":0.5649,
"apprehension":102.8035,
"apprehensive":52.1549,
"apprentice":185.0840,
"apprentices":0.1883,
"apprenticeship":100.7324,
"approach":4292.1413,
"approachable":17.3222,
"approaches":2.4477,
"approaching":7.3431,
"appropriacy":0.9414,
"appropriate":2097.4931,
"appropriated":0.3766,
"appropriately":158.9124,
"appropriateness":40.4812,
"appropriation":80.3976,
"approval":703.9970,
"approve":1117.4705,
"approved":7.1548,
"approx":39.5398,
"approximate":122.3851,
"approximated":3.0126,
"approximately":484.2686,
"approximating":0.1883,
"approximation":76.6319,
"apps":0.1883,
"apr":31.0670,
"apricot":14.1214,
"april":1.5063,
"apron":96.5901,
"apt":97.1550,
"aptitude":45.0001,
"aptly":45.0001,
"aqua":8.6611,
"aquaculture":1.6946,
"aquamarine":8.2845,
"aquarium":156.8413,
"aquarius":3.0126,
"aquatic":63.2637,
"aquatics":0.3766,
"aqueous":18.8285,
"aquifer":32.1967,
"ar":7.3431,
"arab":291.2767,
"arabia":0.9414,
"arabian":26.3599,
"arabic":33.8913,
"arable":80.0211,
"arafat":0.7531,
"aramaic":1.5063,
"arbitrage":76.4436,
"arbitrarily":42.5524,
"arbitrariness":8.8494,
"arbitrary":193.7451,
"arbitration":112.2178,
"arbitrator":70.9834,
"arbitrators":0.1883,
"arbor":0.1883,
"arboretum":0.9414,
"arc":143.2848,
"arcade":74.9374,
"arcane":20.8996,
"arch":313.1177,
"archaeological":137.0714,
"archaeology":98.0964,
"archaic":64.9583,
"archangel":3.9540,
"archbishop":115.4186,
"archdiocese":5.0837,
"arched":51.0252,
"archeology":0.3766,
"archer":54.0377,
"archery":17.1339,
"arches":0.1883,
"arching":3.5774,
"archipelago":20.8996,
"architect":414.9798,
"architectural":195.8162,
"architecture":442.8459,
"archival":26.3599,
"archive":198.0757,
"archived":0.1883,
"archiving":8.2845,
"archivist":24.8536,
"arctic":37.8453,
"ardent":40.8578,
"arduous":44.8118,
"are":24.8536,
"area":9824.7030,
"aren":0.1883,
"arena":163.4312,
"ares":0.1883,
"argent":1.3180,
"argentina":1.5063,
"argentine":27.8662,
"argentinian":25.9833,
"argo":0.3766,
"argon":7.5314,
"argosy":0.3766,
"arguable":38.2218,
"arguably":114.4772,
"argue":2628.6447,
"arguing":14.8745,
"argument":2178.2673,
"argus":0.3766,
"aria":22.5942,
"arid":61.0043,
"aries":0.9414,
"arise":1682.8899,
"arisen":1.8828,
"arising":4.8954,
"aristocracy":95.2721,
"aristocratic":92.2596,
"arithmetic":96.0253,
"ark":19.2051,
"arm":3572.1400,
"armada":7.1548,
"armageddon":0.1883,
"armchair":156.4647,
"armed":630.9425,
"armenian":42.7407,
"armor":0.1883,
"armored":0.5649,
"armory":0.5649,
"armour":166.6321,
"armoured":84.5399,
"armpit":33.5147,
"army":1435.4836,
"aroma":63.8286,
"aromas":0.1883,
"aromatherapy":30.5021,
"aromatic":54.6026,
"arose":0.3766,
"around":7853.5490,
"arousal":75.6905,
"arouse":253.8080,
"aroused":4.1423,
"arrange":1287.8683,
"arranged":18.4519,
"arrangement":1588.9358,
"arranger":10.1674,
"arranging":7.5314,
"array":226.8832,
"arrest":1126.8848,
"arresting":12.4268,
"arrival":661.0681,
"arrive":2478.9582,
"arrived":0.9414,
"arrives":0.1883,
"arriving":0.7531,
"arrogance":88.3056,
"arrogant":113.9123,
"arrow":249.2891,
"arrowhead":10.7322,
"arrows":0.1883,
"arse":97.5315,
"arsenal":34.0796,
"arsenic":25.7950,
"arson":51.5900,
"art":2770.9880,
"arte":0.3766,
"arterial":51.4018,
"artery":102.8035,
"arthritis":76.2554,
"arthur":4.7071,
"artichoke":14.6862,
"article":1601.3626,
"articles":2.8243,
"articulate":231.0255,
"articulated":4.8954,
"articulating":0.9414,
"articulation":64.0168,
"artifact":25.6067,
"artificial":338.3479,
"artificially":58.1800,
"artillery":112.4061,
"artisan":57.9917,
"artist":1294.6466,
"artistic":271.6950,
"artistically":15.8159,
"artistry":17.5105,
"artists":1.1297,
"arts":1.8828,
"artwork":66.6528,
"aryan":7.1548,
"as":118067.0226,
"asap":3.0126,
"asbestos":58.7449,
"ascend":92.0713,
"ascendant":16.5691,
"ascending":1.8828,
"ascension":6.4017,
"ascent":97.7198,
"ascertain":152.6990,
"ascii":25.0419,
"ascot":1.1297,
"ash":147.6153,
"ashamed":184.8957,
"ashamedly":1.1297,
"ashe":86.0462,
"ashes":0.7531,
"ashore":116.1717,
"ashtray":40.6695,
"asia":0.5649,
"asian":294.4775,
"asiatic":16.1925,
"aside":707.9510,
"ask":10245.5197,
"asked":1.3180,
"askew":10.7322,
"asking":26.3599,
"asl":4.3306,
"asleep":408.5781,
"asp":0.7531,
"asparagus":15.2511,
"aspect":2061.3424,
"aspen":3.0126,
"asphalt":16.5691,
"aspiration":224.6238,
"aspire":127.6571,
"aspirin":58.9332,
"aspiring":3.9540,
"ass":70.4185,
"assam":0.3766,
"assassin":73.8077,
"assassinated":0.1883,
"assassination":110.5232,
"assault":598.7458,
"assaults":0.1883,
"assay":142.5316,
"assemblage":70.6068,
"assemble":357.7412,
"assembler":17.5105,
"assembling":3.7657,
"assembly":498.9548,
"assent":75.1257,
"assert":376.9463,
"asserting":0.1883,
"assertion":206.9250,
"assertive":66.0880,
"asses":0.3766,
"assess":1162.6589,
"assessable":9.0377,
"assessed":0.1883,
"assessing":0.7531,
"assessment":1362.9940,
"assessor":70.7951,
"assessors":0.1883,
"asset":1070.2110,
"asshole":10.3557,
"assign":330.0633,
"assigned":0.3766,
"assigning":1.3180,
"assignment":299.3729,
"assimilate":83.7868,
"assimilated":0.3766,
"assimilation":55.5440,
"assist":766.6959,
"assistance":716.8004,
"assistant":604.3943,
"assisted":9.2260,
"assisting":0.3766,
"associate":1751.6139,
"associated":198.0757,
"association":1128.5793,
"associative":65.8997,
"assorted":46.1298,
"assortment":47.2595,
"assume":1992.0536,
"assumed":20.5230,
"assuming":0.9414,
"assumption":990.3783,
"assurance":370.9211,
"assure":597.8044,
"assured":21.2762,
"assuredly":9.7908,
"assures":0.1883,
"assuring":0.1883,
"assyrian":5.0837,
"aster":4.3306,
"asterisk":19.3933,
"asteroid":16.3808,
"asthma":104.1215,
"astonish":114.2889,
"astonished":18.2636,
"astonishes":0.1883,
"astonishing":149.1216,
"astonishment":92.0713,
"astor":1.1297,
"astounding":24.4770,
"astral":6.9665,
"astray":29.3724,
"astrological":9.6025,
"astrology":25.7950,
"astronaut":31.4436,
"astronomer":60.6277,
"astronomical":42.1758,
"astronomy":51.5900,
"astrophysical":1.3180,
"astute":43.8704,
"asylum":178.4940,
"asymmetric":24.6653,
"asymmetrical":19.7699,
"asymmetry":45.3766,
"asymptomatic":22.5942,
"asymptotic":7.3431,
"asymptotically":3.3891,
"asynchronous":9.2260,
"at":93483.0474,
"ate":4.3306,
"atelier":4.3306,
"atheism":16.9456,
"atheist":37.8453,
"athenian":46.1298,
"athens":0.5649,
"atherosclerosis":8.8494,
"athlete":146.8622,
"athletic":118.6195,
"athletics":0.1883,
"atlantic":51.9666,
"atlantis":0.1883,
"atlas":21.2762,
"atm":3.0126,
"atmosphere":861.4032,
"atmospheric":102.6152,
"atoll":10.3557,
"atom":286.9461,
"atomic":143.4730,
"atonement":20.5230,
"atop":25.2302,
"atp":8.0962,
"atrial":4.8954,
"atrium":15.6276,
"atrophy":25.9833,
"attach":856.6960,
"attached":63.8286,
"attaching":0.1883,
"attachment":171.5275,
"attack":3007.4738,
"attacked":0.3766,
"attacker":128.9751,
"attacking":11.2971,
"attain":220.6698,
"attainable":24.1005,
"attaining":0.3766,
"attainment":170.5861,
"attempt":4009.9023,
"attempted":1.3180,
"attempting":0.1883,
"attend":1639.9610,
"attendance":343.0550,
"attendant":153.2639,
"attended":1.3180,
"attendee":7.7197,
"attending":0.3766,
"attention":2468.4143,
"attentive":43.8704,
"attenuated":1.6946,
"attenuation":25.6067,
"attest":53.8495,
"attested":4.7071,
"attic":113.3475,
"attire":34.0796,
"attitude":1932.5556,
"attorney":63.0754,
"attract":1191.4665,
"attracted":0.7531,
"attracting":0.3766,
"attraction":423.2643,
"attractive":919.0183,
"attractively":33.1381,
"attractiveness":48.7658,
"attributable":104.4981,
"attribute":634.5199,
"attributing":0.1883,
"attribution":43.4938,
"attrition":16.9456,
"atypical":24.6653,
"au":9.0377,
"auburn":16.5691,
"auckland":0.1883,
"auction":299.3729,
"auctioned":0.1883,
"auctioneer":60.2511,
"audacity":19.5816,
"audible":59.4980,
"audience":1151.1735,
"audio":179.0589,
"audiovisual":11.6737,
"audit":383.5362,
"audited":1.8828,
"auditing":58.1800,
"audition":75.3139,
"auditor":281.4858,
"auditorium":32.5733,
"auditory":38.4101,
"audits":21.8410,
"aug":1.1297,
"auger":3.3891,
"augment":96.0253,
"augmentation":11.2971,
"augmented":0.3766,
"august":1.8828,
"augusta":0.7531,
"aunt":271.5067,
"auntie":21.2762,
"aunty":5.8368,
"aura":69.6654,
"aural":21.4645,
"aurora":2.6360,
"aussie":26.5482,
"austin":2.0711,
"australasian":2.2594,
"australia":2.2594,
"australian":326.6742,
"austria":0.1883,
"austrian":101.1090,
"auteur":2.4477,
"authentic":147.6153,
"authenticate":15.8159,
"authenticated":3.5774,
"authentication":6.7783,
"authenticity":64.7700,
"author":1223.6632,
"authored":0.7531,
"authoring":1.6946,
"authorisation":51.0252,
"authorise":216.1510,
"authorised":26.5482,
"authoritarian":93.3893,
"authoritative":111.0881,
"authority":4956.4102,
"authorization":28.2427,
"authorize":106.1927,
"authorized":8.4728,
"authorizing":0.5649,
"authors":1.1297,
"authorship":29.7490,
"autism":5.4603,
"autistic":12.4268,
"auto":71.7365,
"autobiographical":35.9624,
"autobiography":87.7407,
"autograph":48.9541,
"autographed":1.6946,
"autoimmune":18.4519,
"automate":70.2302,
"automated":13.3682,
"automatic":416.1095,
"automatically":496.6954,
"automating":0.1883,
"automation":58.9332,
"automaton":11.6737,
"automobile":39.7281,
"automotive":20.5230,
"autonomic":28.9959,
"autonomous":196.5694,
"autonomy":327.0508,
"autopsy":20.5230,
"autumn":595.9215,
"aux":1.6946,
"auxiliary":69.1005,
"av":10.1674,
"avail":70.2302,
"availability":355.6701,
"available":4830.2593,
"avalanche":38.4101,
"avatar":1.3180,
"ave":56.8620,
"avenge":35.5858,
"avenger":1.8828,
"avenue":121.2554,
"average":1902.4300,
"averaging":7.1548,
"averse":35.0210,
"aversion":39.5398,
"avert":99.2261,
"avian":7.3431,
"aviation":103.3684,
"aviator":10.3557,
"avid":27.8662,
"avocado":19.3933,
"avoid":2138.1627,
"avoidable":23.7239,
"avoidance":90.5650,
"avoiding":2.6360,
"avoids":0.1883,
"await":402.7413,
"awaited":0.7531,
"awaiting":0.5649,
"awake":308.4106,
"awaken":70.6068,
"awakened":2.0711,
"awakening":33.8913,
"award":1449.0401,
"awarded":0.7531,
"awarding":5.4603,
"awards":0.1883,
"aware":1912.4091,
"awareness":647.8881,
"away":8774.8268,
"awe":106.5692,
"awesome":67.2177,
"awful":558.8294,
"awfully":68.7240,
"awhile":16.0042,
"awkward":273.3896,
"awkwardly":65.3348,
"awning":20.8996,
"awol":2.4477,
"awry":16.9456,
"ax":4.1423,
"axe":181.1300,
"axed":0.3766,
"axel":0.3766,
"axial":25.2302,
"axing":3.3891,
"axiom":25.0419,
"axis":264.7285,
"axle":43.1172,
"ayatollah":2.6360,
"aye":348.7035,
"ayrshire":0.1883,
"azalea":12.0502,
"azerbaijan":0.5649,
"azerbaijani":9.6025,
"azimuth":5.0837,
"aztec":4.8954,
"azure":19.3933,
"b":1176.0271,
"ba":12.8034,
"baa":1.3180,
"babble":35.9624,
"babe":43.3055,
"babel":3.0126,
"babies":0.3766,
"baby":1967.7649,
"babylonian":13.3682,
"babysitter":18.4519,
"babysitting":7.1548,
"baccalaureate":1.1297,
"bachelor":77.1968,
"bacillus":7.9080,
"back":19143.1082,
"backbone":72.8662,
"backdoor":3.9540,
"backdrop":86.0462,
"backed":0.1883,
"backgammon":2.8243,
"background":1206.7176,
"backing":242.3226,
"backlash":48.2009,
"backlog":39.7281,
"backpack":17.5105,
"backpacker":9.7908,
"backpacking":7.7197,
"backseat":2.8243,
"backside":56.4855,
"backslash":3.7657,
"backstage":33.1381,
"backup":38.9750,
"backward":120.5023,
"backwards":309.5403,
"backyard":27.3013,
"bacon":143.6613,
"bacteria":230.0841,
"bacterial":102.8035,
"bacterium":24.6653,
"bad":4809.1714,
"bade":0.7531,
"badge":145.9208,
"badger":106.0044,
"badlands":0.1883,
"badly":778.7461,
"badminton":19.3933,
"badness":5.6485,
"baffled":16.5691,
"bag":1410.4418,
"bagel":4.7071,
"baggage":82.4688,
"bagged":0.3766,
"bagging":3.5774,
"baghdad":0.7531,
"bags":0.7531,
"bahamian":5.0837,
"bahrain":0.1883,
"baht":4.3306,
"bail":208.2430,
"bailey":11.2971,
"bait":152.3224,
"bake":151.5693,
"baked":83.2219,
"baker":57.9917,
"bakery":51.2135,
"baking":66.8411,
"balance":1906.0075,
"balanced":251.1720,
"balancing":28.2427,
"balcony":194.4982,
"bald":108.2638,
"baldness":8.2845,
"baldwin":0.7531,
"bale":54.9792,
"bali":0.9414,
"balinese":9.0377,
"balkan":17.3222,
"ball":1617.3668,
"ballad":56.1089,
"ballast":23.5356,
"ballerina":16.5691,
"ballet":195.0631,
"ballistic":30.3139,
"balloon":187.9083,
"ballooning":13.3682,
"ballot":209.7493,
"ballpark":1.6946,
"ballpoint":9.9791,
"ballroom":49.5189,
"bally":1.6946,
"balm":16.1925,
"baltic":70.7951,
"bamboo":52.9080,
"ban":998.4745,
"banana":159.6655,
"bananas":0.1883,
"band":1603.8103,
"bandage":81.1508,
"banded":4.3306,
"banding":29.3724,
"bandit":37.2804,
"bandwagon":30.6904,
"bandwidth":19.3933,
"bane":11.2971,
"bang":333.0759,
"banging":10.3557,
"bangladesh":0.1883,
"bangladeshi":14.3096,
"bangle":9.2260,
"banished":0.1883,
"banjo":7.1548,
"bank":2950.4235,
"banked":8.8494,
"banker":228.5778,
"banking":319.1428,
"bankroll":5.2720,
"bankrupt":138.5776,
"bankruptcy":184.3309,
"banner":147.2387,
"banning":21.8410,
"bannister":11.1088,
"banquet":77.9499,
"banshee":8.0962,
"bantam":7.1548,
"banter":35.9624,
"banyan":1.6946,
"baptism":82.6570,
"baptist":22.7825,
"bar":1775.1495,
"barb":33.7030,
"barbarian":43.1172,
"barbaric":29.1842,
"barbecue":76.6319,
"barbed":47.2595,
"barbell":6.0251,
"barber":24.8536,
"bard":10.9205,
"bare":467.3230,
"bareback":3.2008,
"bared":5.0837,
"barefoot":35.2093,
"barely":397.4693,
"bargain":287.3227,
"bargaining":250.4188,
"barge":115.2303,
"baring":2.2594,
"baritone":13.7448,
"barium":24.4770,
"bark":245.5234,
"barker":3.5774,
"barking":12.0502,
"barley":94.8956,
"barn":260.3979,
"barns":0.3766,
"barometer":26.7364,
"baron":84.9165,
"baroness":2.4477,
"baroque":76.2554,
"barracks":4.3306,
"barracuda":4.3306,
"barrage":75.3139,
"barred":0.1883,
"barrel":277.3436,
"barren":70.0420,
"barrie":0.1883,
"barrier":526.8210,
"barriers":0.3766,
"barring":1.5063,
"barrow":58.5566,
"bart":0.5649,
"bartender":7.7197,
"barter":33.5147,
"bartlett":0.1883,
"basal":85.6696,
"basalt":37.0921,
"base":6506.1827,
"baseball":69.2888,
"basel":0.7531,
"baseline":89.0587,
"baseman":0.9414,
"basement":151.5693,
"bash":79.8328,
"bashing":11.1088,
"basic":1949.5013,
"basically":557.3231,
"basics":0.7531,
"basil":19.5816,
"basilica":26.3599,
"basin":229.7075,
"basing":0.9414,
"basis":2819.9421,
"basket":317.6365,
"basketball":31.6319,
"basque":52.3432,
"bass":270.1887,
"basset":2.4477,
"bassist":18.8285,
"bassoon":9.7908,
"bastard":302.3855,
"bastille":0.1883,
"bat":294.4775,
"batch":175.4815,
"bath":615.8797,
"bathe":109.7701,
"bathed":0.1883,
"bathing":61.0043,
"bathroom":473.3481,
"bathtub":5.4603,
"batik":2.6360,
"batman":2.2594,
"baton":45.9415,
"bats":0.1883,
"battalion":86.9876,
"batter":110.1466,
"battered":98.4730,
"battery":382.0299,
"batting":60.2511,
"battle":1303.8725,
"battlefield":69.4771,
"battlefront":3.5774,
"battleground":21.6528,
"battles":0.7531,
"battleship":24.4770,
"battling":1.6946,
"baud":0.5649,
"bauhaus":1.3180,
"baum":0.1883,
"bavarian":14.4979,
"bay":310.6700,
"bayes":0.5649,
"bayesian":0.7531,
"bayou":0.5649,
"bazaar":30.6904,
"bbl":1.5063,
"bc":5.0837,
"be":661258.0591,
"beach":699.8548,
"beaches":0.3766,
"beachfront":2.0711,
"beacon":51.5900,
"bead":149.4982,
"beaded":10.5440,
"beading":9.7908,
"beads":0.1883,
"beagle":3.7657,
"beak":76.6319,
"beaked":2.4477,
"beam":426.0886,
"beamed":2.0711,
"beaming":3.0126,
"beams":0.3766,
"bean":281.4858,
"bear":3461.9934,
"beard":169.0798,
"bearded":56.8620,
"bearer":88.1173,
"bearing":248.3477,
"bears":0.1883,
"beast":219.3518,
"beat":1725.6306,
"beaten":1.3180,
"beating":78.3265,
"beatles":0.1883,
"beatrice":0.5649,
"beau":4.8954,
"beaumont":0.9414,
"beautiful":1477.4712,
"beautifully":221.9878,
"beauty":710.3987,
"beaver":25.4185,
"bebop":2.4477,
"became":208.2430,
"because":18283.5879,
"beck":20.8996,
"beckett":0.3766,
"become":11635.6267,
"becomes":57.0503,
"becoming":81.7156,
"bed":3208.1854,
"bedding":61.0043,
"bedlam":0.5649,
"bedrock":26.9247,
"bedroom":1044.0394,
"beds":0.1883,
"bedside":103.1801,
"bedtime":47.4478,
"bee":224.2472,
"beech":67.0294,
"beef":261.3394,
"beehive":12.8034,
"been":27.3013,
"beep":13.9331,
"beer":639.7919,
"bees":0.1883,
"beet":23.7239,
"beethoven":2.6360,
"beetle":97.7198,
"beetles":0.1883,
"before":15367.0557,
"beforehand":119.3726,
"beg":321.0257,
"began":1.8828,
"beggar":72.1131,
"begged":0.1883,
"begging":12.2385,
"begin":7314.3013,
"beginner":110.8998,
"beginning":1339.6466,
"begins":0.9414,
"begotten":1.1297,
"behalf":708.8924,
"behave":604.2061,
"behaved":7.7197,
"behaving":0.1883,
"behavior":15.6276,
"behavioral":2.0711,
"behaviour":2307.4307,
"behavioural":177.7409,
"beheld":0.3766,
"behind":4108.1870,
"behold":54.4143,
"beige":41.9875,
"beijing":0.3766,
"being":798.5160,
"beirut":0.1883,
"bel":0.5649,
"belated":26.1716,
"belfast":2.0711,
"belgian":119.1843,
"belgium":1.3180,
"belgrade":0.3766,
"belief":1368.4542,
"beliefs":0.5649,
"believable":17.5105,
"believe":6110.9728,
"believed":0.3766,
"believer":111.8412,
"believing":2.8243,
"belize":0.3766,
"bell":516.0888,
"belle":5.2720,
"bellied":7.5314,
"belling":0.1883,
"bells":0.1883,
"belly":181.1300,
"belmont":0.3766,
"belong":1108.4329,
"belonging":66.6528,
"belongs":0.1883,
"beloved":116.5483,
"below":2483.1005,
"belt":476.5489,
"belted":7.7197,
"belting":3.2008,
"beltway":0.1883,
"ben":0.1883,
"bench":396.3396,
"benchmark":46.6946,
"benchmarking":1.8828,
"benchmarks":0.1883,
"bend":583.1182,
"bender":7.9080,
"bending":16.9456,
"beneath":866.8634,
"benedictine":0.7531,
"beneficial":246.2766,
"beneficiary":165.1258,
"benefit":3503.6043,
"benefiting":0.5649,
"benefits":0.7531,
"benevolent":46.1298,
"bengal":3.7657,
"bengali":0.9414,
"benign":85.8579,
"bennett":1.3180,
"benny":3.3891,
"bent":216.7159,
"benzene":18.8285,
"bequest":45.9415,
"ber":0.5649,
"bereavement":65.8997,
"berg":0.9414,
"bergen":0.1883,
"bering":1.1297,
"berlin":0.1883,
"berliner":3.0126,
"bermuda":2.0711,
"bernstein":0.5649,
"berry":71.7365,
"berth":62.8871,
"beryl":0.5649,
"beset":53.2846,
"beside":982.6586,
"besides":447.7414,
"bespoke":11.2971,
"best":24.4770,
"bestiality":3.5774,
"bestow":77.5734,
"bestseller":19.5816,
"bestselling":5.4603,
"bet":568.2437,
"beta":266.4231,
"bethlehem":0.1883,
"betray":240.4397,
"betrayal":90.7533,
"betrayed":0.1883,
"better":44.8118,
"betterment":12.9917,
"betting":21.6528,
"between":16213.0194,
"beverage":37.8453,
"beware":96.0253,
"bewildered":71.9248,
"bewitched":2.4477,
"beyond":2040.6311,
"bezel":1.6946,
"bhutan":0.3766,
"bi":66.8411,
"bias":306.7160,
"biased":78.8913,
"biasing":0.9414,
"biathlon":0.7531,
"bib":19.9582,
"bible":45.7532,
"biblical":131.6111,
"bibliographic":31.2553,
"bibliographical":22.4059,
"bibliography":67.0294,
"bicarbonate":32.1967,
"bicentennial":1.6946,
"bicycle":206.7368,
"bicycled":0.1883,
"bicycling":3.0126,
"bid":898.6836,
"bidder":103.9332,
"bidding":58.3683,
"bidirectional":9.6025,
"biennial":16.3808,
"biennium":1.5063,
"bifurcation":11.1088,
"big":5812.1648,
"bigfoot":0.7531,
"bigger":0.3766,
"biggest":3.2008,
"biggish":7.3431,
"bigotry":15.0628,
"bike":405.5655,
"biker":29.3724,
"biking":11.6737,
"bikini":25.7950,
"bikinis":0.3766,
"bilateral":137.0714,
"bile":205.7953,
"biliary":65.5231,
"bilingual":64.2051,
"bill":1526.6135,
"billboard":15.6276,
"billed":2.0711,
"billet":33.1381,
"billiard":29.1842,
"billing":41.7992,
"billion":921.6543,
"billionaire":12.0502,
"billy":8.0962,
"bimbo":16.3808,
"bin":182.2597,
"binary":149.3099,
"bind":1481.6134,
"binder":41.9875,
"binding":163.0547,
"binge":38.9750,
"bingo":35.7741,
"binocular":115.4186,
"binomial":8.6611,
"bio":37.2804,
"biochemical":70.7951,
"biochemistry":35.9624,
"biodegradable":12.6151,
"biodiversity":15.8159,
"bioengineering":0.3766,
"biographical":56.2972,
"biography":160.2304,
"biological":347.3855,
"biologically":37.8453,
"biologist":87.9290,
"biology":161.9250,
"biomass":32.0084,
"biomedical":11.2971,
"biometric":1.1297,
"bionic":3.2008,
"biopsies":0.1883,
"biopsy":171.5275,
"biosphere":8.4728,
"biotechnology":53.6612,
"biotin":3.7657,
"bipartisan":9.7908,
"bipolar":14.1214,
"birch":53.4729,
"bird":1722.8063,
"birdhouse":0.1883,
"birdie":68.3474,
"birding":0.1883,
"birth":1062.8679,
"birthday":573.8922,
"birthplace":49.3306,
"births":0.3766,
"birthstone":0.9414,
"biscuit":270.9419,
"bisexual":16.1925,
"bishop":382.2182,
"bishops":0.1883,
"bison":5.4603,
"bisque":1.5063,
"bistro":11.1088,
"bit":5499.9885,
"bitch":181.5066,
"bitching":0.7531,
"bite":573.8922,
"biting":21.4645,
"bitmap":10.7322,
"bits":0.7531,
"bitten":0.1883,
"bitter":445.6702,
"bitterer":0.1883,
"bitterly":190.9208,
"bitterness":125.2094,
"bittersweet":4.3306,
"biweekly":0.3766,
"biz":7.7197,
"bizarre":179.4355,
"bk":0.3766,
"bl":3.3891,
"black":4137.1828,
"blackberry":21.0879,
"blackbird":33.3264,
"blackboard":49.3306,
"blackburn":0.1883,
"blacken":57.6152,
"blackened":2.2594,
"blacker":10.3557,
"blackfoot":0.3766,
"blackish":9.6025,
"blackjack":4.3306,
"blacklist":16.5691,
"blackly":3.3891,
"blackmail":84.5399,
"blackness":66.2763,
"blackout":37.0921,
"blackpool":1.5063,
"blacks":0.1883,
"blacksmith":32.3850,
"bladder":192.2388,
"blade":302.9503,
"blah":56.6737,
"blake":0.5649,
"blame":921.2777,
"blameless":14.1214,
"blames":0.1883,
"blaming":1.3180,
"bland":76.8202,
"blank":333.2642,
"blanket":306.7160,
"blasphemy":16.5691,
"blast":353.9755,
"blasted":6.4017,
"blaster":23.3473,
"blasting":5.4603,
"blatant":60.0629,
"blatantly":37.8453,
"blaze":265.8582,
"blazer":32.0084,
"blazing":16.9456,
"bleach":77.7616,
"bleached":11.2971,
"bleaching":16.0042,
"bleak":148.9333,
"bled":0.1883,
"bleed":217.2807,
"bleeding":89.2470,
"blend":257.9502,
"blended":6.2134,
"blender":14.6862,
"blending":12.8034,
"bless":216.1510,
"blessed":18.0753,
"blessing":184.1426,
"blew":0.7531,
"blight":48.5775,
"blind":677.4489,
"blinded":0.5649,
"blinding":10.5440,
"blindly":52.9080,
"blindness":54.7909,
"blink":187.3434,
"blinked":0.1883,
"blinking":1.5063,
"bliss":46.5064,
"blister":65.8997,
"blistering":7.7197,
"blitz":38.2218,
"blitzkrieg":3.9540,
"blizzard":27.6779,
"bloated":25.0419,
"blob":38.2218,
"bloc":86.2345,
"block":1539.7934,
"blockade":87.1759,
"blockage":42.9289,
"blockbuster":23.9122,
"blocked":0.5649,
"blocker":21.0879,
"blocking":12.6151,
"bloke":273.9544,
"blond":77.5734,
"blood":1889.0618,
"blooded":63.4520,
"bloodhound":5.2720,
"bloodshed":27.1130,
"bloodstream":33.3264,
"bloody":1190.7133,
"bloom":185.2723,
"bloomfield":0.1883,
"blooming":6.5900,
"bloomsbury":0.1883,
"blossom":110.8998,
"blot":103.9332,
"blotting":17.8871,
"blouse":106.5692,
"blow":1391.0484,
"blower":17.8871,
"blowing":9.7908,
"blown":2.2594,
"blowout":0.5649,
"blows":0.3766,
"blt":0.1883,
"blue":1935.0033,
"blueberry":3.3891,
"bluebird":2.0711,
"bluebonnet":0.1883,
"bluegrass":2.0711,
"blueness":7.3431,
"blueprint":72.4897,
"bluer":2.2594,
"blues":1.1297,
"bluest":0.9414,
"bluff":58.7449,
"blunt":99.2261,
"blur":139.1425,
"blurb":11.8619,
"blurred":30.1256,
"blurring":11.4854,
"blurry":5.2720,
"blush":129.9165,
"bm":0.9414,
"boa":5.8368,
"boar":54.2260,
"board":2387.2635,
"boarded":0.1883,
"boarding":113.3475,
"boardroom":48.7658,
"boards":0.3766,
"boardwalk":5.0837,
"boast":242.1343,
"boasted":0.1883,
"boastful":8.4728,
"boasting":4.7071,
"boat":1356.4040,
"boating":6.2134,
"bob":97.7198,
"bobble":12.4268,
"bobby":22.0293,
"bobcat":0.5649,
"bobs":3.5774,
"bock":0.5649,
"bod":5.2720,
"bode":17.5105,
"bodega":1.3180,
"bodied":68.5357,
"bodily":168.5149,
"body":5647.9804,
"bodybuilder":3.2008,
"bodybuilding":1.8828,
"bodywork":14.8745,
"boer":5.4603,
"bog":86.6110,
"bogged":0.3766,
"boggling":3.5774,
"bogota":1.8828,
"bogus":56.1089,
"bohemia":1.5063,
"bohemian":25.2302,
"boil":361.3186,
"boiled":3.3891,
"boiler":160.9835,
"boiling":84.9165,
"boils":0.1883,
"bola":0.5649,
"bold":242.3226,
"bolder":3.0126,
"boldly":63.4520,
"boldness":18.2636,
"bolivar":0.1883,
"bolivia":0.1883,
"bolivian":19.3933,
"boll":1.3180,
"bologna":0.3766,
"bolster":76.6319,
"bolt":319.3311,
"bolted":1.5063,
"bomb":861.4032,
"bombardier":2.2594,
"bombardment":52.7198,
"bombay":0.1883,
"bombed":0.1883,
"bomber":173.2221,
"bombing":213.8916,
"bonanza":23.9122,
"bond":737.1352,
"bondage":25.0419,
"bonding":56.4855,
"bone":895.4827,
"boned":3.7657,
"bones":0.1883,
"bonfire":67.0294,
"bong":2.6360,
"bongo":1.8828,
"boning":0.7531,
"bonn":0.3766,
"bonnet":80.5859,
"bonnie":0.3766,
"bonny":8.6611,
"bonsai":5.6485,
"bonus":303.3269,
"bony":55.5440,
"boo":55.7323,
"boob":14.8745,
"boogie":9.2260,
"book":6547.4171,
"bookcase":38.7867,
"booked":2.8243,
"booker":4.8954,
"booking":264.5402,
"bookkeeping":6.7783,
"booklet":217.4690,
"bookmaker":34.6444,
"bookmark":11.4854,
"bookmarks":0.1883,
"books":3.2008,
"bookseller":76.2554,
"booksellers":0.1883,
"bookshelf":25.2302,
"bookshop":113.5358,
"bookstore":8.2845,
"bookworm":3.5774,
"boolean":16.5691,
"boom":366.5906,
"boomer":3.9540,
"boomerang":3.2008,
"booming":32.3850,
"boon":24.1005,
"boost":512.5113,
"booster":29.3724,
"boosting":2.2594,
"boot":820.3571,
"booted":1.8828,
"booth":66.6528,
"booting":0.3766,
"bootleg":9.4142,
"boots":0.3766,
"bootstrap":3.7657,
"booty":21.8410,
"booze":60.0629,
"bop":16.0042,
"bordeaux":0.9414,
"border":966.4661,
"bordered":0.3766,
"bordering":0.7531,
"borderline":31.0670,
"bore":217.2807,
"bored":184.5191,
"boredom":101.1090,
"boring":268.8708,
"born":1.6946,
"borne":0.5649,
"boron":4.1423,
"borough":226.3184,
"borrow":558.0763,
"borrower":142.9082,
"borrowing":250.0423,
"bosch":0.1883,
"bosnian":109.5818,
"bosom":48.7658,
"boson":2.6360,
"boss":721.8841,
"boswell":0.1883,
"bot":9.0377,
"botanic":6.0251,
"botanical":42.7407,
"botany":27.6779,
"both":12154.9162,
"bother":761.0473,
"bothered":14.6862,
"bothering":0.3766,
"bothersome":3.2008,
"bottle":1095.0646,
"bottled":32.7616,
"bottleneck":22.9708,
"bottles":0.3766,
"bottling":3.3891,
"bottom":1403.0986,
"bough":20.5230,
"bought":1.8828,
"boulder":87.5525,
"boulevard":22.9708,
"bounce":272.8247,
"bouncing":2.2594,
"bouncy":17.8871,
"bound":211.6322,
"boundary":773.4741,
"bounded":0.9414,
"bounding":4.5188,
"boundless":15.4394,
"bountiful":7.7197,
"bounty":31.0670,
"bouquet":59.4980,
"bourbon":16.5691,
"bourgeois":180.9417,
"bourgeoisie":93.7659,
"bout":116.7366,
"boutique":36.5273,
"bovine":30.5021,
"bow":494.6243,
"bowed":4.8954,
"bowel":252.3017,
"bower":23.9122,
"bowing":1.6946,
"bowl":601.9466,
"bowler":177.5526,
"bowling":98.4730,
"bowls":0.7531,
"bowman":9.2260,
"box":1923.1414,
"boxed":7.3431,
"boxer":99.7910,
"boxes":0.3766,
"boxing":144.7910,
"boy":3514.3366,
"boycott":153.2639,
"boyfriend":235.3561,
"boyhood":17.1339,
"boyle":0.1883,
"boys":2.0711,
"bps":0.7531,
"br":14.6862,
"bra":64.0168,
"brace":157.0296,
"bracelet":53.6612,
"bracing":4.3306,
"bracken":27.1130,
"bracket":201.0882,
"brad":1.1297,
"bradbury":0.1883,
"bradley":0.3766,
"brag":14.4979,
"bragg":1.3180,
"bragging":2.0711,
"brahma":0.1883,
"brahms":0.9414,
"braid":35.2093,
"braided":9.7908,
"braille":13.3682,
"brain":1047.2403,
"brains":0.1883,
"brainstorm":10.1674,
"brainstorming":7.5314,
"brake":230.0841,
"brakes":0.7531,
"braking":28.6193,
"bran":25.6067,
"branch":1404.6049,
"branched":7.1548,
"branches":0.1883,
"branching":36.1507,
"brand":577.6579,
"branding":18.2636,
"brandy":146.8622,
"bras":2.4477,
"brass":255.5025,
"brasserie":5.4603,
"brat":25.2302,
"brave":325.7328,
"bravely":56.8620,
"bravery":46.3181,
"braving":0.1883,
"bravo":0.3766,
"bray":9.9791,
"brazil":0.7531,
"brazilian":91.1299,
"breach":691.1937,
"breaches":0.1883,
"bread":665.5869,
"breadcrumb":24.2887,
"breadth":108.2638,
"break":4485.5098,
"breakage":38.0335,
"breakaway":32.9498,
"breakdown":283.5570,
"breaker":57.0503,
"breakfast":755.2105,
"breakfasting":1.5063,
"breaking":102.9918,
"breakout":8.2845,
"breaks":0.3766,
"breakthrough":132.1760,
"breakthroughs":0.3766,
"breakup":7.5314,
"breast":560.7123,
"breasted":9.4142,
"breastfeeding":8.4728,
"breath":910.5455,
"breathable":10.1674,
"breathe":550.7332,
"breathed":0.1883,
"breathing":234.2263,
"breathless":81.5273,
"breathlessly":32.7616,
"breathtaking":59.1214,
"bred":1.5063,
"breed":701.7376,
"breeder":86.0462,
"breeding":311.7997,
"breeze":182.8246,
"breezy":16.1925,
"brent":2.4477,
"brest":0.1883,
"breton":1.1297,
"brevity":21.8410,
"brew":122.3851,
"brewed":0.3766,
"brewer":107.5106,
"brewery":129.1634,
"brewing":66.2763,
"bribe":109.2052,
"bribery":40.4812,
"bribing":0.7531,
"brick":519.2896,
"bridal":25.2302,
"bride":200.7116,
"bridesmaid":37.6570,
"bridge":973.9975,
"bridged":0.1883,
"bridging":8.4728,
"brie":1.1297,
"brief":1061.5499,
"briefcase":65.5231,
"briefing":131.2345,
"briefly":567.1139,
"brig":7.1548,
"brigade":111.0881,
"brigadier":12.2385,
"bright":1094.6881,
"brighten":70.0420,
"brightened":0.3766,
"brightening":5.4603,
"brighter":3.2008,
"brightest":0.3766,
"brightly":139.8956,
"brightness":65.8997,
"brill":4.5188,
"brilliance":64.3934,
"brilliant":581.9884,
"brilliantly":93.2010,
"brim":74.1842,
"brine":28.4310,
"bring":7684.6575,
"bringing":19.9582,
"brink":73.6194,
"brio":2.4477,
"brisbane":0.1883,
"brisk":83.4102,
"bristol":0.5649,
"brit":12.4268,
"britain":0.9414,
"british":4116.2832,
"briton":33.3264,
"britten":0.5649,
"brittle":77.9499,
"bro":3.7657,
"broad":1200.5042,
"broadband":5.0837,
"broadcast":371.4860,
"broadcaster":87.7407,
"broadcasting":199.0171,
"broaden":135.5651,
"broadening":9.4142,
"broader":3.3891,
"broadly":291.2767,
"broadway":1.3180,
"brocade":18.8285,
"broccoli":14.1214,
"brochure":228.0129,
"broil":3.0126,
"broke":19.9582,
"broken":358.6826,
"broker":187.7200,
"brokerage":16.5691,
"bromide":14.8745,
"bronchial":11.8619,
"bronchitis":29.7490,
"bronco":1.1297,
"bronze":258.8917,
"brooch":51.2135,
"brood":113.1592,
"brooding":8.6611,
"brook":28.0544,
"brooks":0.1883,
"broom":61.7574,
"bros":0.1883,
"broth":27.8662,
"brother":2048.1625,
"brotherhood":18.2636,
"brotherly":13.9331,
"brought":3.0126,
"brow":203.7242,
"brown":874.2065,
"brownie":23.1590,
"browning":2.8243,
"browse":73.8077,
"browser":10.7322,
"browsing":5.4603,
"bruce":0.3766,
"bruised":45.5649,
"bruising":25.2302,
"brunch":4.7071,
"brunette":13.1799,
"brush":662.9509,
"brushing":18.0753,
"brussels":0.1883,
"brut":0.7531,
"brutal":129.9165,
"brutality":60.0629,
"brutally":48.2009,
"brute":51.9666,
"bryan":0.1883,
"bs":4.1423,
"btu":3.3891,
"bubble":267.7410,
"bubbling":0.5649,
"bubbly":21.6528,
"buchanan":0.1883,
"bucharest":0.3766,
"buck":112.7826,
"bucket":254.3728,
"buckeye":1.3180,
"buckle":90.5650,
"bud":168.5149,
"buddha":2.6360,
"buddhism":0.1883,
"buddhist":43.8704,
"budding":5.4603,
"buddy":33.1381,
"budget":1568.4127,
"budgetary":75.5022,
"budgeted":0.1883,
"budgeting":52.1549,
"buff":53.4729,
"buffalo":28.0544,
"buffer":138.7659,
"buffering":5.0837,
"buffet":123.8914,
"bug":142.9082,
"buggy":38.2218,
"bugle":10.7322,
"build":4865.8452,
"builder":328.7453,
"building":3587.2028,
"builds":0.1883,
"buildup":6.2134,
"built":1.1297,
"bulb":186.0254,
"bulbs":0.3766,
"bulgarian":46.5064,
"bulge":118.9960,
"bulging":1.5063,
"bulk":385.2308,
"bulky":61.3809,
"bull":231.0255,
"bulldog":11.1088,
"bullet":229.7075,
"bulletin":92.4479,
"bulletproof":2.4477,
"bullied":0.3766,
"bullion":19.5816,
"bullish":18.2636,
"bullock":29.1842,
"bullshit":21.4645,
"bully":137.8245,
"bullying":33.7030,
"bum":99.2261,
"bumble":16.9456,
"bump":215.5861,
"bumper":59.8746,
"bumping":3.5774,
"bumpy":28.8076,
"bun":77.9499,
"bunch":230.0841,
"bundle":247.2180,
"bundled":0.1883,
"bundles":0.7531,
"bundling":2.8243,
"bungalow":123.8914,
"bunk":69.1005,
"bunker":67.7825,
"bunny":17.8871,
"bunting":19.3933,
"buoy":38.7867,
"buoyancy":26.9247,
"buoyant":64.0168,
"bur":1.8828,
"burden":565.2311,
"burdensome":11.2971,
"bureau":138.0128,
"bureaucracy":259.6448,
"bureaucratic":169.4564,
"bureaus":0.7531,
"burg":0.7531,
"burgeoning":5.8368,
"burger":35.5858,
"burgess":10.1674,
"burglar":103.9332,
"burglary":125.2094,
"burgundy":11.8619,
"burial":187.1551,
"buried":0.3766,
"burke":1.1297,
"burma":0.1883,
"burmese":27.6779,
"burn":1308.7679,
"burned":0.1883,
"burner":49.8955,
"burning":109.0169,
"burnout":2.4477,
"burns":0.3766,
"burnside":0.7531,
"burnt":2.4477,
"burr":16.0042,
"burst":624.7291,
"bursting":5.4603,
"burt":0.7531,
"burton":2.2594,
"bury":565.0428,
"burying":1.1297,
"bus":1217.8264,
"busby":0.3766,
"bush":241.0046,
"bushy":24.8536,
"busi":0.1883,
"busier":0.1883,
"busily":44.4352,
"business":6534.4254,
"businesslike":30.5021,
"businessman":341.7370,
"businesswoman":12.2385,
"bussed":0.1883,
"bussing":0.5649,
"bust":174.5400,
"busted":0.3766,
"buster":10.7322,
"busting":1.3180,
"bustle":80.7742,
"bustling":32.0084,
"busty":2.6360,
"busy":982.4703,
"but":80836.3311,
"butch":6.7783,
"butcher":151.7576,
"butler":56.4855,
"butt":109.0169,
"butte":0.5649,
"butter":374.3103,
"buttered":8.0962,
"butterfly":182.6363,
"buttering":0.9414,
"button":485.7749,
"buttoned":8.2845,
"buttoning":0.5649,
"buy":4736.1169,
"buyer":768.7670,
"buying":176.4229,
"buyout":34.4561,
"buys":0.5649,
"buzz":139.8956,
"buzzard":30.8787,
"buzzer":13.3682,
"buzzing":17.6988,
"by":91091.6416,
"bye":226.1301,
"bylaw":2.4477,
"byline":6.5900,
"bypass":155.5233,
"bypassing":0.9414,
"byproduct":7.1548,
"byrd":3.3891,
"byron":0.1883,
"byte":72.3014,
"byzantine":67.4060,
"c":1379.3748,
"ca":8.8494,
"cab":231.9669,
"cabana":0.9414,
"cabaret":48.3892,
"cabbage":82.4688,
"cabernet":3.0126,
"cabin":237.0506,
"cabinet":382.5948,
"cable":427.2183,
"cabling":20.8996,
"cabriolet":2.4477,
"cache":84.7282,
"caching":2.6360,
"cactus":14.3096,
"cad":21.2762,
"caddy":9.9791,
"cadence":12.2385,
"cadet":60.0629,
"cadmium":24.2887,
"cadre":40.8578,
"caesar":0.3766,
"cafe":130.4814,
"cafeteria":24.2887,
"caffeine":26.7364,
"cage":264.1636,
"caged":0.9414,
"caging":0.1883,
"cain":0.1883,
"cairn":27.8662,
"cairo":0.3766,
"cajun":2.2594,
"cake":679.5200,
"cakes":1.3180,
"cakewalk":1.3180,
"calamity":23.1590,
"calcium":230.0841,
"calculate":768.2022,
"calculated":19.2051,
"calculating":0.7531,
"calculation":401.4233,
"calculator":80.7742,
"calculus":20.5230,
"caldera":5.2720,
"calendar":209.1845,
"calender":3.0126,
"calf":192.6154,
"caliber":0.3766,
"calibrate":25.9833,
"calibrated":0.5649,
"calibration":31.0670,
"calibre":70.7951,
"calico":11.6737,
"californian":39.7281,
"caliper":4.7071,
"call":11609.6433,
"calla":0.5649,
"callback":0.1883,
"called":0.1883,
"caller":105.2512,
"calligraphy":13.3682,
"calling":59.8746,
"calls":0.1883,
"cally":1.3180,
"calm":606.0889,
"calming":32.7616,
"calmly":136.8831,
"calmness":14.3096,
"caloric":3.5774,
"calorie":215.7744,
"calvary":0.5649,
"calvin":0.1883,
"calypso":4.7071,
"cam":61.7574,
"camaraderie":18.4519,
"cambodian":37.2804,
"cambrian":28.0544,
"cambridge":3.2008,
"camcorder":57.2386,
"camden":0.3766,
"came":91.5064,
"camel":70.6068,
"cameo":25.0419,
"camera":695.7125,
"cameraman":42.3641,
"cameras":0.3766,
"cameroon":0.9414,
"camisole":4.3306,
"camouflage":71.3600,
"camp":835.2316,
"campaign":2004.2921,
"campaigning":85.2930,
"campanile":12.4268,
"campbell":1.8828,
"camper":17.5105,
"campfire":7.1548,
"campground":0.7531,
"camping":57.2386,
"camps":0.3766,
"campsite":26.1716,
"campus":123.5149,
"camus":0.5649,
"can":47649.4332,
"canada":0.5649,
"canadian":207.1133,
"canal":325.7328,
"canary":17.6988,
"cancel":414.6032,
"cancellation":105.4395,
"cancelled":0.5649,
"cancelling":2.0711,
"cancer":790.9846,
"cancerous":16.1925,
"candid":26.1716,
"candida":3.5774,
"candidacy":29.5607,
"candidate":1414.7723,
"candle":293.1595,
"candlelight":28.9959,
"candles":0.3766,
"candlestick":21.2762,
"candy":48.9541,
"cane":112.9709,
"canine":34.6444,
"canister":26.7364,
"cannabis":69.1005,
"canned":3.3891,
"cannibal":12.8034,
"canning":8.6611,
"cannon":121.6320,
"cannot":4.7071,
"canoe":91.3181,
"canon":96.9667,
"canonical":32.7616,
"canopy":109.2052,
"cant":4.7071,
"canteen":103.9332,
"canto":0.5649,
"canton":9.2260,
"cantonese":3.0126,
"cantor":3.2008,
"canvas":224.0590,
"canyon":20.8996,
"cap":552.6160,
"capability":319.8959,
"capable":865.1688,
"capacitance":28.6193,
"capacitor":52.5315,
"capacity":1137.4287,
"cape":31.2553,
"capella":0.5649,
"capillary":39.5398,
"capital":2352.8074,
"capitalism":342.6784,
"capitalist":489.5406,
"capitalization":7.3431,
"capitalize":29.5607,
"capitol":1.5063,
"capo":1.8828,
"capped":2.4477,
"capping":29.1842,
"cappuccino":6.5900,
"capri":0.1883,
"caprice":6.7783,
"capricious":20.8996,
"capricorn":0.7531,
"caps":0.1883,
"capstone":0.5649,
"capsule":67.9708,
"capt":0.5649,
"captain":645.2522,
"caption":74.7491,
"captivated":0.5649,
"captivating":3.3891,
"captive":99.2261,
"captivity":63.6403,
"capture":638.6622,
"captured":0.3766,
"capturing":3.3891,
"car":6235.6174,
"caramel":12.9917,
"carat":19.2051,
"caravan":207.6782,
"carbide":4.3306,
"carbohydrate":98.6613,
"carbon":474.4778,
"carbonate":98.6613,
"carcass":46.1298,
"carcinogen":19.0168,
"carcinogenic":16.7574,
"carcinoma":86.9876,
"carcinomas":0.7531,
"card":1726.7603,
"cardboard":125.3977,
"cardholder":8.0962,
"cardiac":78.5148,
"cardiff":2.4477,
"cardigan":55.3557,
"cardinal":70.4185,
"cardinality":1.1297,
"cardiology":2.8243,
"cardiovascular":42.1758,
"care":4871.4937,
"cared":0.1883,
"career":1670.0865,
"careers":1.5063,
"carefree":28.9959,
"careful":913.7463,
"carefully":1250.7762,
"caregiver":2.2594,
"careless":98.8495,
"carelessly":38.0335,
"carer":299.3729,
"cares":1.1297,
"caress":112.2178,
"caretaker":71.1717,
"cargo":171.3392,
"caribbean":114.4772,
"caribou":3.7657,
"caricature":55.5440,
"carina":0.7531,
"caring":163.6195,
"carlos":0.1883,
"carmine":3.5774,
"carnage":30.5021,
"carnal":15.2511,
"carnation":26.9247,
"carnival":44.0587,
"carol":27.1130,
"caroline":2.2594,
"carotene":4.7071,
"carotid":5.4603,
"carousel":10.7322,
"carp":77.7616,
"carpal":1.8828,
"carpenter":75.3139,
"carpentry":12.4268,
"carpet":590.6495,
"carpeting":18.0753,
"carriage":407.6367,
"carrier":344.3730,
"carrot":143.2848,
"carry":5508.0848,
"carrying":63.4520,
"carson":0.1883,
"cart":259.2682,
"cartel":61.7574,
"carter":9.6025,
"cartesian":18.2636,
"cartier":0.3766,
"cartilage":22.2176,
"carting":1.1297,
"cartography":7.5314,
"carton":49.1423,
"cartoon":126.9040,
"cartoonist":19.5816,
"cartridge":85.6696,
"cartwright":0.5649,
"carve":312.7411,
"carved":4.1423,
"carver":16.5691,
"carving":87.5525,
"cascade":86.0462,
"cascading":0.3766,
"case":11318.3667,
"caseload":10.1674,
"cash":1598.5383,
"cashier":30.6904,
"cashing":1.6946,
"cashmere":18.0753,
"casing":35.7741,
"casino":38.9750,
"casket":25.2302,
"caspian":1.5063,
"casserole":48.2009,
"cassette":192.6154,
"cassie":0.3766,
"cassiopeia":0.1883,
"cast":997.1565,
"caste":68.5357,
"caster":32.7616,
"casting":60.2511,
"castle":505.5448,
"castles":0.5649,
"castor":15.2511,
"castro":0.9414,
"casual":334.5822,
"casually":130.4814,
"casualty":294.1009,
"cat":929.5623,
"catalan":2.4477,
"catalog":3.5774,
"catalogue":543.2018,
"catalyst":92.8244,
"catalytic":45.9415,
"cataract":24.2887,
"catastrophe":81.1508,
"catastrophic":68.9123,
"catch":2796.0299,
"catcher":22.7825,
"catching":9.7908,
"catchment":55.5440,
"catchy":13.5565,
"catechism":16.5691,
"categorical":25.2302,
"categorically":29.7490,
"categorisation":21.0879,
"categorise":58.5566,
"categorising":1.1297,
"categorization":16.9456,
"categorize":35.7741,
"categorizing":1.1297,
"category":1184.8765,
"cater":233.2849,
"catered":0.1883,
"caterer":42.3641,
"catering":236.2975,
"caterpillar":55.3557,
"catfish":27.6779,
"cathedral":256.2557,
"catherine":1.3180,
"catheter":28.9959,
"cathode":16.9456,
"catholic":419.1221,
"catholicism":9.9791,
"cation":23.1590,
"cats":1.6946,
"cattle":469.9590,
"caucasian":13.7448,
"caucus":18.6402,
"caught":1.5063,
"cauldron":28.4310,
"cauliflower":17.6988,
"causal":217.6573,
"causality":21.4645,
"causation":52.1549,
"cause":5434.8420,
"caused":1.3180,
"causes":0.3766,
"causeway":24.2887,
"causing":2.8243,
"caustic":36.3390,
"caution":295.7955,
"cautionary":17.3222,
"cautioned":0.1883,
"cautioning":2.6360,
"cautious":207.6782,
"cautiously":122.3851,
"cavalier":22.7825,
"cavalry":83.9750,
"cave":270.0005,
"caveat":32.9498,
"cavern":43.6821,
"caviar":11.6737,
"caving":5.4603,
"cavity":97.7198,
"cay":0.5649,
"cayenne":5.2720,
"cayman":0.3766,
"cc":25.9833,
"cd":251.9251,
"ce":3.5774,
"cease":535.8587,
"ceasefire":135.7534,
"ceaseless":19.9582,
"ceasing":0.9414,
"cedar":23.3473,
"ceiling":475.4192,
"celeb":0.9414,
"celebrate":685.5451,
"celebrated":62.3223,
"celebrating":2.2594,
"celebration":362.2600,
"celebrity":115.2303,
"celebs":2.4477,
"celery":29.3724,
"celestial":25.7950,
"cell":2409.6694,
"cellar":152.3224,
"cello":27.1130,
"cellphone":5.8368,
"cellular":125.7743,
"cellulite":23.5356,
"cellulose":33.8913,
"celsius":19.3933,
"celtic":88.4939,
"cement":167.3852,
"cemented":0.1883,
"cemetery":142.7199,
"censor":51.2135,
"censored":0.1883,
"censorship":125.9626,
"censure":45.7532,
"census":147.2387,
"cent":6814.9698,
"centaur":5.4603,
"centenary":62.1340,
"centennial":3.2008,
"center":32.0084,
"centered":0.3766,
"centering":0.5649,
"centerpiece":0.1883,
"centimeter":0.7531,
"centimetre":99.9793,
"central":2563.6864,
"centralised":60.4394,
"centralization":28.4310,
"centralized":60.4394,
"centrally":125.3977,
"centre":4277.6433,
"centred":51.5900,
"centres":0.1883,
"centric":4.3306,
"centrifugal":12.2385,
"centrifuge":20.7113,
"centrist":22.4059,
"centurion":7.7197,
"century":4838.3556,
"ceo":10.1674,
"ceramic":117.4897,
"cereal":161.9250,
"cerebral":83.2219,
"ceremonial":84.3516,
"ceremony":379.3940,
"cert":18.0753,
"certain":3911.9942,
"certainly":3257.7043,
"certainty":270.7536,
"certificate":457.9087,
"certificated":3.0126,
"certification":62.5106,
"certified":4.5188,
"certify":81.9039,
"certifying":0.1883,
"cervical":54.2260,
"cervix":18.4519,
"cessation":41.4227,
"cf":57.8034,
"cfc":21.0879,
"cha":14.4979,
"chad":0.1883,
"chain":969.6669,
"chained":1.6946,
"chaining":3.3891,
"chainsaw":16.1925,
"chair":1699.0824,
"chairman":1511.3624,
"chairmen":0.1883,
"chairperson":20.3348,
"chairs":0.1883,
"chalet":38.0335,
"chalk":175.1049,
"challenge":1745.9653,
"challenger":67.0294,
"challenging":96.9667,
"chamber":476.3606,
"chamberlain":13.1799,
"chameleon":14.8745,
"chamomile":6.4017,
"champ":25.2302,
"champagne":219.9167,
"champion":724.7084,
"championship":466.5698,
"chance":2857.7873,
"chancellor":70.7951,
"chancery":18.6402,
"chances":0.9414,
"chandelier":36.5273,
"chandler":7.9080,
"chang":0.3766,
"change":12175.4393,
"changeable":13.3682,
"changed":9.6025,
"changeover":18.4519,
"changer":14.4979,
"changing":10.7322,
"channel":846.1521,
"channelled":0.3766,
"channelling":4.5188,
"chant":135.7534,
"chanting":12.0502,
"chaos":245.5234,
"chaotic":84.3516,
"chap":336.4650,
"chaparral":0.1883,
"chapel":300.1260,
"chaplain":79.8328,
"chaplin":0.3766,
"chapman":2.8243,
"chaps":0.7531,
"chapter":2695.6741,
"chapters":0.5649,
"char":26.9247,
"character":2203.4975,
"characterisation":45.3766,
"characterise":244.3937,
"characterised":2.4477,
"characteristic":1205.5878,
"characteristically":72.4897,
"characteristics":3.0126,
"characterization":35.0210,
"characterize":223.8707,
"characterized":1.8828,
"charcoal":93.9541,
"chard":3.7657,
"chardonnay":0.7531,
"charge":4097.6430,
"chargeable":36.7155,
"charged":1.3180,
"charger":23.9122,
"charging":19.3933,
"chariot":51.5900,
"charisma":37.0921,
"charismatic":56.4855,
"charitable":117.1132,
"charity":721.1309,
"charles":0.3766,
"charleston":0.1883,
"charlotte":0.3766,
"charm":313.3060,
"charmed":8.8494,
"charming":225.5652,
"chart":531.1515,
"charted":0.5649,
"charter":352.8458,
"chartered":40.2930,
"charting":3.5774,
"chase":462.0510,
"chased":0.1883,
"chaser":23.5356,
"chasing":11.1088,
"chassis":57.4269,
"chastity":22.2176,
"chat":407.6367,
"chateau":52.7198,
"chatter":127.2806,
"chatterbox":3.3891,
"chatting":4.8954,
"chaucer":2.4477,
"chauffeur":65.1466,
"cheap":1207.8473,
"cheaper":3.3891,
"cheapest":0.5649,
"cheaply":83.0336,
"cheapness":13.3682,
"cheat":193.3685,
"cheating":17.3222,
"check":2303.8533,
"checkbook":0.1883,
"checked":8.0962,
"checker":14.8745,
"checking":49.5189,
"checklist":72.6779,
"checkout":19.5816,
"checkpoint":25.6067,
"checks":0.1883,
"cheddar":6.7783,
"cheek":607.5952,
"cheeks":0.9414,
"cheeky":47.4478,
"cheer":358.1178,
"cheerful":200.7116,
"cheerfully":99.7910,
"cheering":13.1799,
"cheerleader":6.2134,
"cheery":34.4561,
"cheese":511.7582,
"cheesecake":12.2385,
"cheesy":4.7071,
"cheetah":14.3096,
"chef":122.3851,
"chem":0.9414,
"chemical":1073.9767,
"chemically":42.9289,
"chemicals":0.9414,
"chemist":199.7702,
"chemistry":293.7244,
"chemo":0.7531,
"chemotherapy":47.4478,
"chenille":7.5314,
"cheque":518.3482,
"cheques":0.1883,
"cherish":72.8662,
"cherished":19.2051,
"chernobyl":0.3766,
"cherry":128.7868,
"chess":94.3307,
"chest":681.4028,
"chester":0.7531,
"chesterfield":1.5063,
"chestnut":98.2847,
"chevalier":2.0711,
"chevron":4.3306,
"chew":195.6280,
"chewed":1.1297,
"chewing":9.6025,
"chews":0.1883,
"chi":9.7908,
"chianti":0.1883,
"chic":48.3892,
"chick":106.9458,
"chicken":416.4861,
"chief":1415.1489,
"chiefly":128.4103,
"chiffon":6.2134,
"chihuahua":0.5649,
"child":12291.7993,
"childbearing":38.4101,
"childbirth":59.3097,
"childcare":47.8243,
"childhood":490.8586,
"childish":81.5273,
"childlike":22.2176,
"children":15.2511,
"chile":0.1883,
"chilean":34.0796,
"chili":3.0126,
"chill":184.3309,
"chilled":34.6444,
"chiller":9.4142,
"chilling":55.7323,
"chilly":61.7574,
"chime":47.0712,
"chimera":7.9080,
"chimney":174.5400,
"chimp":31.8201,
"chin":258.1385,
"china":1.5063,
"chinese":551.6746,
"chino":1.6946,
"chinook":0.7531,
"chip":729.4155,
"chipping":17.8871,
"chips":0.1883,
"chiral":3.5774,
"chiropractic":5.0837,
"chiropractor":6.0251,
"chisel":58.3683,
"chit":16.5691,
"chlamydia":4.1423,
"chloride":68.7240,
"chlorine":76.2554,
"chlorophyll":13.1799,
"chock":11.8619,
"chocolate":399.1639,
"choice":2449.5858,
"choices":1.3180,
"choir":169.8329,
"choke":186.9668,
"choked":1.5063,
"choker":5.6485,
"choking":4.7071,
"cholera":62.6989,
"cholesterol":136.6948,
"chomsky":0.3766,
"choose":3175.2356,
"chooses":0.5649,
"choosing":24.4770,
"chop":315.0005,
"chopin":0.3766,
"chopped":0.7531,
"chopper":16.7574,
"chopping":14.1214,
"choral":39.7281,
"chorale":2.8243,
"chord":137.8245,
"chore":73.0545,
"choreographer":59.4980,
"choreography":18.8285,
"chorus":171.3392,
"chose":11.8619,
"chosen":2.0711,
"chow":1.5063,
"christ":0.5649,
"christening":19.0168,
"christian":719.4364,
"christianity":1.6946,
"christie":0.7531,
"christmas":21.4645,
"christopher":0.3766,
"chromatic":10.3557,
"chromatin":8.8494,
"chromatography":30.3139,
"chrome":36.3390,
"chromium":21.0879,
"chromosomal":19.9582,
"chromosome":153.8287,
"chronic":305.2097,
"chronically":32.0084,
"chronicle":56.4855,
"chronicles":0.1883,
"chronograph":1.1297,
"chronological":58.9332,
"chronologically":15.8159,
"chronology":47.0712,
"chubby":16.5691,
"chuck":115.7952,
"chuckle":124.4563,
"chuckled":0.1883,
"chunk":119.3726,
"chunky":41.0461,
"church":2723.5402,
"churches":1.1297,
"churchill":0.1883,
"churn":88.4939,
"churning":3.0126,
"chute":32.3850,
"ci":53.2846,
"cia":0.9414,
"ciao":1.3180,
"cid":1.3180,
"cider":77.0085,
"cigar":119.9374,
"cigarette":609.2897,
"cinderella":1.3180,
"cine":3.5774,
"cinema":354.9169,
"cinematic":24.6653,
"cinematographer":2.6360,
"cinematography":2.4477,
"cinnamon":25.6067,
"cipher":13.5565,
"circa":6.2134,
"circadian":6.5900,
"circle":933.3280,
"circles":0.1883,
"circling":3.0126,
"circuit":563.1600,
"circuitry":25.7950,
"circular":331.0048,
"circulate":269.8122,
"circulating":0.3766,
"circulation":275.4607,
"circulatory":15.8159,
"circumcision":24.2887,
"circumference":35.0210,
"circumstance":1939.8987,
"circumstances":0.3766,
"circumvent":39.7281,
"circus":94.3307,
"cirque":4.8954,
"cirrhosis":29.5607,
"cirrus":0.1883,
"citadel":6.2134,
"citation":98.4730,
"cite":443.4108,
"cites":0.1883,
"citing":1.8828,
"citizen":711.5284,
"citizenry":6.9665,
"citizens":0.9414,
"citizenship":155.1467,
"citrate":10.5440,
"citrus":25.2302,
"city":3413.4159,
"civic":97.1550,
"civil":1165.4832,
"civilian":384.6659,
"civilians":0.1883,
"civilisation":117.4897,
"civilise":11.2971,
"civilised":83.4102,
"civilising":1.3180,
"civility":16.0042,
"civilization":141.0253,
"civilize":9.6025,
"civilized":61.5691,
"civilizing":1.5063,
"cl":3.7657,
"clad":11.8619,
"cladding":22.2176,
"claim":5474.5701,
"claimant":129.5400,
"claimed":0.9414,
"claiming":2.4477,
"claims":0.9414,
"clam":16.5691,
"clamp":131.0462,
"clamping":12.8034,
"clams":9.6025,
"clan":90.5650,
"clandestine":32.1967,
"clap":113.7240,
"clapping":14.8745,
"clarence":4.8954,
"clarification":87.5525,
"clarified":0.9414,
"clarify":262.0925,
"clarifying":0.3766,
"clarinet":27.4896,
"clarion":0.5649,
"clarity":191.4857,
"clark":0.9414,
"clash":424.0175,
"clasp":130.1048,
"class":5100.0715,
"classic":622.4697,
"classical":594.7918,
"classically":25.0419,
"classics":2.4477,
"classification":309.9168,
"classified":31.8201,
"classifieds":0.1883,
"classifier":4.1423,
"classify":293.3478,
"classifying":2.2594,
"classing":0.1883,
"classmate":25.7950,
"classroom":504.7917,
"classy":32.5733,
"clause":870.6291,
"claw":164.1844,
"clay":270.3770,
"clean":1723.9360,
"cleaned":0.1883,
"cleaner":183.2012,
"cleanest":0.1883,
"cleaning":237.0506,
"cleanliness":53.6612,
"cleanly":24.8536,
"cleanness":3.0126,
"cleanse":54.6026,
"cleanser":14.4979,
"cleansing":48.3892,
"cleanup":4.1423,
"clear":5437.1014,
"clearance":169.6446,
"cleared":1.3180,
"clearer":2.8243,
"clearest":0.1883,
"clearing":174.5400,
"clearinghouse":22.5942,
"clearly":2714.5026,
"clearness":2.2594,
"cleavage":71.1717,
"cleaver":6.7783,
"cleft":34.2678,
"clement":8.8494,
"clergy":236.8623,
"cleric":45.9415,
"clerical":151.3810,
"clerk":369.9797,
"cleveland":2.6360,
"clever":412.7204,
"cleverer":11.4854,
"cleverest":0.3766,
"cleverly":48.3892,
"cleverness":17.8871,
"cliche":31.2553,
"click":225.3770,
"clicked":0.1883,
"clicking":16.3808,
"client":1998.0787,
"clientele":38.5984,
"cliff":327.9922,
"climate":516.6536,
"climatic":61.3809,
"climax":136.8831,
"climb":1099.2069,
"climbed":0.1883,
"climber":145.1676,
"climbing":150.4396,
"climbs":0.1883,
"cline":6.0251,
"cling":232.5318,
"clinging":1.3180,
"clinic":353.0341,
"clinical":530.7750,
"clinically":59.1214,
"clinician":50.0838,
"clinton":1.5063,
"clio":2.4477,
"clip":257.0088,
"clipboard":21.4645,
"clipped":0.3766,
"clipper":13.7448,
"clipping":17.6988,
"clique":18.0753,
"clitoris":15.2511,
"clive":2.0711,
"cloak":161.5484,
"clock":654.2898,
"clocked":6.4017,
"clocks":0.1883,
"clockwise":50.2721,
"clockwork":19.9582,
"clog":67.4060,
"clogged":6.2134,
"clogging":5.0837,
"clone":160.9835,
"cloned":0.1883,
"cloning":20.8996,
"close":6500.1576,
"closed":384.1011,
"closely":995.4620,
"closeness":59.6863,
"closer":1.8828,
"closes":0.1883,
"closest":0.1883,
"closet":48.2009,
"closeup":2.8243,
"closing":217.4690,
"closure":460.1682,
"closures":0.5649,
"clot":39.3515,
"cloth":401.6116,
"clothed":4.5188,
"clothes":0.3766,
"clothing":385.0425,
"clotting":8.0962,
"cloud":671.8003,
"clouded":13.7448,
"cloudy":49.1423,
"clout":41.9875,
"clove":38.4101,
"clover":38.5984,
"clovis":0.1883,
"clown":88.1173,
"clowns":0.3766,
"club":2599.0840,
"clubbed":0.3766,
"clubbing":3.3891,
"clubhouse":37.2804,
"clue":355.6701,
"clueless":4.7071,
"clues":0.7531,
"clumsy":84.9165,
"clung":48.2009,
"cluster":343.4316,
"clustered":6.0251,
"clustering":21.2762,
"clutch":306.7160,
"clutching":1.6946,
"clutter":35.7741,
"cluttered":27.4896,
"cm":467.8878,
"cns":0.1883,
"co":2265.4432,
"coach":823.5579,
"coaching":90.3767,
"coagulation":10.3557,
"coal":862.9094,
"coalition":398.0342,
"coarse":124.0797,
"coarsely":9.7908,
"coarseness":6.2134,
"coarser":3.7657,
"coast":682.7208,
"coastal":232.9083,
"coaster":20.1465,
"coastline":94.7073,
"coat":844.0809,
"coated":38.0335,
"coating":90.5650,
"coauthor":2.0711,
"coax":56.8620,
"coaxial":11.6737,
"cob":13.3682,
"cobalt":24.4770,
"cobol":0.9414,
"cobra":12.4268,
"coca":13.3682,
"cocaine":107.8872,
"cock":174.3518,
"cockpit":107.3224,
"cocktail":135.5651,
"coco":0.7531,
"cocoa":82.8453,
"coconut":63.8286,
"cocoon":28.0544,
"cod":58.5566,
"coda":7.5314,
"code":1079.8136,
"coded":2.8243,
"codeine":3.3891,
"codename":11.4854,
"coder":3.5774,
"codex":5.6485,
"codified":0.1883,
"coding":35.2093,
"cody":0.3766,
"coefficient":123.7031,
"coerce":30.8787,
"coercion":59.1214,
"coercive":34.8327,
"coexist":35.3976,
"coexistence":16.0042,
"coffee":1135.3576,
"coffin":273.7662,
"cog":22.2176,
"cognac":13.3682,
"cognition":25.6067,
"cognitive":206.5485,
"cognizant":0.9414,
"coherence":77.0085,
"coherent":192.6154,
"coherently":13.7448,
"cohesion":83.7868,
"cohesive":47.0712,
"cohort":79.2679,
"coil":163.6195,
"coiled":6.9665,
"coin":505.7331,
"coincide":287.3227,
"coincidence":170.2095,
"coincident":14.3096,
"coincidental":19.0168,
"coinciding":0.9414,
"coke":24.2887,
"col":19.9582,
"cola":8.4728,
"cold":2186.9284,
"colder":3.0126,
"coldly":96.2136,
"coldness":39.7281,
"cole":4.1423,
"colette":0.1883,
"coliseum":0.1883,
"colitis":179.2472,
"collaborate":103.9332,
"collaborating":0.3766,
"collaboration":248.3477,
"collaborative":82.6570,
"collaboratively":5.2720,
"collaborator":50.6486,
"collage":34.2678,
"collagen":29.7490,
"collapse":856.1312,
"collapsed":3.3891,
"collapsible":6.7783,
"collapsing":0.9414,
"collar":342.4901,
"collateral":38.4101,
"colleague":1271.2993,
"colleagues":0.7531,
"collect":1439.0610,
"collected":2.8243,
"collectible":1.5063,
"collectibles":0.1883,
"collecting":32.9498,
"collection":1535.8395,
"collective":446.2351,
"collectively":97.1550,
"collector":279.2264,
"collectors":1.3180,
"colleen":1.1297,
"college":1128.7676,
"colleges":0.5649,
"collegiate":12.8034,
"collide":106.9458,
"collie":12.8034,
"collier":12.8034,
"collision":146.6739,
"colloidal":4.5188,
"colloquium":3.7657,
"collusion":45.9415,
"cologne":7.9080,
"colombia":0.7531,
"colombian":28.4310,
"colombo":0.1883,
"colon":148.5567,
"colonel":71.7365,
"colonial":258.5151,
"colonialism":38.2218,
"colonising":0.1883,
"colonist":26.5482,
"colonization":17.5105,
"colonize":21.0879,
"colonized":0.3766,
"colony":363.2015,
"color":16.5691,
"colorado":0.5649,
"colored":1.1297,
"colorful":0.5649,
"coloring":0.1883,
"colorless":0.7531,
"colossal":40.4812,
"colosseum":0.1883,
"colossus":6.4017,
"colour":3198.2063,
"coloured":315.3771,
"colourful":198.4522,
"colouring":102.2387,
"colourless":30.5021,
"colours":3.3891,
"colt":34.4561,
"columbine":1.3180,
"columbus":0.9414,
"column":745.0431,
"columnist":38.2218,
"columns":0.1883,
"com":28.9959,
"coma":44.6235,
"comanche":0.3766,
"comb":140.8371,
"combat":316.6951,
"combatant":28.6193,
"combating":0.9414,
"combed":1.6946,
"combination":944.2485,
"combinatorial":8.2845,
"combine":1298.4123,
"combined":57.2386,
"combing":3.9540,
"combining":1.8828,
"combo":50.4603,
"combustible":10.3557,
"combustion":55.3557,
"come":26211.6977,
"comeback":95.8370,
"comedian":82.0922,
"comedic":1.3180,
"comedy":258.7034,
"comer":61.1926,
"comes":10.5440,
"comet":33.8913,
"comfort":662.3861,
"comfortable":702.1142,
"comfortably":162.8664,
"comforter":5.6485,
"comforting":63.0754,
"comfy":19.9582,
"comic":196.7577,
"comical":23.7239,
"coming":101.1090,
"comma":68.3474,
"command":1010.1482,
"commander":266.6113,
"commanding":22.7825,
"commandment":25.4185,
"commando":49.5189,
"commemorate":106.7575,
"commemoration":20.3348,
"commemorative":30.1256,
"commence":271.3185,
"commencement":57.2386,
"commencing":0.7531,
"commend":111.6529,
"commendable":27.6779,
"commended":2.0711,
"commensurate":25.2302,
"comment":2110.6731,
"commentary":159.8538,
"commentator":242.5109,
"commented":0.1883,
"commenting":0.3766,
"commerce":145.9208,
"commercial":1438.4962,
"commercialisation":9.0377,
"commercialization":7.7197,
"commercially":125.5860,
"commission":992.8260,
"commissioned":0.9414,
"commissioner":136.5065,
"commissioning":27.8662,
"commit":1138.5584,
"commitment":1250.2113,
"committed":182.6363,
"committee":2201.0498,
"committees":0.7531,
"committing":0.3766,
"commodity":271.3185,
"commodore":4.7071,
"common":3410.9682,
"commoner":46.5064,
"commonest":53.4729,
"commonly":459.9799,
"commonness":1.1297,
"commonplace":102.6152,
"commonsense":40.2930,
"commonwealth":12.8034,
"commotion":35.3976,
"communal":128.5985,
"commune":58.5566,
"communicable":7.1548,
"communicate":478.8084,
"communicating":19.3933,
"communication":1419.1029,
"communications":0.5649,
"communicative":84.9165,
"communicatively":1.6946,
"communicator":44.4352,
"communion":72.3014,
"communism":125.2094,
"communist":530.0218,
"community":3708.6465,
"commutative":2.6360,
"commute":50.2721,
"commuter":91.5064,
"commuting":18.0753,
"comp":18.4519,
"compact":231.9669,
"compacted":1.8828,
"compaction":18.0753,
"companion":423.0760,
"companionship":47.4478,
"company":9370.3717,
"comparability":19.2051,
"comparable":327.8039,
"comparative":245.5234,
"comparatively":210.5025,
"compare":2284.2717,
"comparing":0.3766,
"comparison":890.5873,
"compartment":148.3685,
"compass":92.2596,
"compassion":108.4521,
"compassionate":44.0587,
"compatibility":82.8453,
"compatible":254.5611,
"compel":192.9920,
"compelling":101.6738,
"compendium":15.6276,
"compensate":265.2933,
"compensated":0.3766,
"compensating":3.3891,
"compensation":539.6244,
"compensatory":34.8327,
"compete":718.4950,
"competence":286.5695,
"competency":27.6779,
"competent":216.5276,
"competing":3.2008,
"competition":1744.6473,
"competitive":687.4280,
"competitively":23.9122,
"competitiveness":101.8621,
"competitor":401.9881,
"competitors":0.7531,
"compilation":82.0922,
"compile":243.8289,
"compiled":0.5649,
"compiler":79.0796,
"compiling":1.3180,
"complacency":64.5817,
"complacent":55.3557,
"complain":772.9093,
"complainant":45.3766,
"complaining":5.8368,
"complaint":784.2064,
"complement":244.5820,
"complementary":150.2513,
"complementing":0.3766,
"complete":3489.2947,
"completely":1505.3373,
"completeness":32.5733,
"completing":0.3766,
"completion":448.8711,
"complex":1779.1035,
"complexion":68.7240,
"complexity":397.0927,
"compliance":239.6866,
"compliant":48.7658,
"complicate":134.6237,
"complicated":472.9715,
"complicating":0.1883,
"complication":214.2681,
"complicity":35.5858,
"compliment":154.3936,
"complimentary":56.1089,
"complimented":0.1883,
"comply":353.2224,
"component":1032.5541,
"componentry":0.3766,
"compose":418.1806,
"composed":11.6737,
"composer":230.4606,
"composing":4.7071,
"composite":141.2136,
"composition":476.1724,
"compositional":17.1339,
"compost":116.9249,
"composting":0.7531,
"composure":50.4603,
"compound":510.4402,
"compounding":3.5774,
"comprehend":83.7868,
"comprehensible":37.6570,
"comprehension":100.5441,
"comprehensive":598.3692,
"comprehensively":33.7030,
"compress":70.6068,
"compressed":39.1632,
"compression":110.3349,
"compressive":2.6360,
"compressor":20.5230,
"comprise":587.6370,
"comprised":2.6360,
"comprising":2.4477,
"compromise":499.1431,
"compromised":0.1883,
"compromising":2.0711,
"compton":0.7531,
"comptroller":5.4603,
"compulsion":75.5022,
"compulsive":45.5649,
"compulsory":295.4189,
"computable":0.5649,
"computation":45.9415,
"computational":57.2386,
"computationally":8.2845,
"compute":120.6906,
"computed":9.7908,
"computer":2835.3814,
"computerised":84.9165,
"computerized":24.1005,
"computing":188.6614,
"comrade":95.4604,
"con":147.0505,
"concatenation":4.8954,
"concave":18.4519,
"conceal":355.2935,
"concealing":0.1883,
"concealment":18.8285,
"concede":317.6365,
"conceivable":68.1591,
"conceivably":48.5775,
"conceive":331.0048,
"conceiving":0.5649,
"concentrate":1252.6591,
"concentrated":97.9081,
"concentration":1024.6461,
"concentrator":4.5188,
"concentric":31.2553,
"concept":1615.8605,
"conception":413.0969,
"conceptual":178.3057,
"conceptualisation":7.3431,
"conceptualise":18.4519,
"conceptually":24.1005,
"concern":5003.8580,
"concerned":912.6166,
"concerning":0.7531,
"concerns":0.1883,
"concert":438.3271,
"concerted":55.1675,
"concerto":43.1172,
"concertos":0.1883,
"concerts":1.1297,
"concession":318.3897,
"concierge":7.7197,
"conciliation":35.0210,
"concise":46.3181,
"conclude":1027.6587,
"concluded":0.3766,
"concluding":3.2008,
"conclusion":1181.6757,
"conclusive":78.5148,
"conclusively":30.5021,
"concomitant":43.4938,
"concord":8.2845,
"concordance":20.1465,
"concourse":24.4770,
"concrete":475.9841,
"concur":43.4938,
"concurrence":10.9205,
"concurrency":1.8828,
"concurrent":54.9792,
"concurrently":31.4436,
"concurring":0.3766,
"condemn":441.9045,
"condemnation":84.9165,
"condemned":0.1883,
"condensate":4.8954,
"condensation":62.5106,
"condensed":16.9456,
"condenser":6.4017,
"condensing":0.3766,
"condition":4336.1999,
"conditional":162.1132,
"conditionally":10.3557,
"conditioner":48.2009,
"conditioning":164.9375,
"condo":1.1297,
"condom":94.8956,
"condominium":2.8243,
"condone":47.2595,
"condor":4.8954,
"conducive":51.4018,
"conduct":1367.5128,
"conductance":17.6988,
"conducting":14.1214,
"conduction":15.2511,
"conductive":11.6737,
"conductivity":27.6779,
"conductor":156.4647,
"conduit":33.3264,
"cone":131.4228,
"confectionery":18.2636,
"confederacy":5.0837,
"confederate":7.3431,
"confederation":31.6319,
"confer":219.3518,
"conference":1590.2538,
"conferencing":8.4728,
"conferred":0.1883,
"conferring":2.4477,
"confess":298.8080,
"confessed":0.1883,
"confession":142.5316,
"confessional":21.2762,
"confetti":11.2971,
"confidence":1341.7178,
"confident":597.4278,
"confidential":182.2597,
"confidentiality":113.3475,
"confidently":96.2136,
"configurable":5.2720,
"configuration":223.3058,
"configure":44.8118,
"configured":0.3766,
"configuring":0.5649,
"confine":555.6286,
"confined":27.8662,
"confinement":57.8034,
"confining":0.3766,
"confirm":1558.8102,
"confirmation":200.1468,
"confirmed":1.5063,
"confirming":0.9414,
"confiscation":27.1130,
"conflict":1434.1656,
"conflicted":1.6946,
"conflicting":65.8997,
"confluence":14.3096,
"conform":219.1636,
"conformability":0.3766,
"conformable":2.4477,
"conformal":0.5649,
"conformance":13.7448,
"conformation":42.5524,
"conformational":9.4142,
"conforming":3.3891,
"conformist":23.1590,
"conformity":86.0462,
"confounding":9.2260,
"confront":426.0886,
"confrontation":216.1510,
"confronting":0.5649,
"confucius":0.1883,
"confuse":314.8123,
"confused":267.3645,
"confusing":123.7031,
"confusion":530.9633,
"congenital":43.6821,
"congested":25.4185,
"congestion":84.3516,
"congestive":6.2134,
"conglomerate":96.4018,
"congo":0.3766,
"congratulate":166.0672,
"congregate":33.7030,
"congregation":203.3476,
"congregational":15.2511,
"congress":71.1717,
"congressional":86.7993,
"congressman":26.1716,
"congruent":11.2971,
"conical":34.0796,
"conjecture":58.1800,
"conjugate":23.9122,
"conjugation":5.4603,
"conjunction":279.9796,
"conjure":101.4855,
"connect":864.4157,
"connected":30.6904,
"connecting":0.5649,
"connection":1225.5460,
"connective":23.7239,
"connectivity":19.5816,
"connector":50.6486,
"connexion":10.7322,
"connolly":0.7531,
"connors":0.9414,
"connotations":0.3766,
"conquer":135.5651,
"conquered":1.6946,
"conquering":3.7657,
"conqueror":24.1005,
"conquest":119.1843,
"conrad":1.3180,
"conscience":252.3017,
"conscientious":60.2511,
"conscious":647.8881,
"consciously":146.6739,
"consciousness":502.7205,
"consecrated":0.3766,
"consecutive":125.3977,
"consecutively":12.6151,
"consensual":35.5858,
"consensus":324.4148,
"consent":738.6414,
"consented":0.1883,
"consenting":1.3180,
"consequence":1405.9229,
"consequences":1.8828,
"consequent":135.9417,
"consequential":34.4561,
"consequently":446.7999,
"conservancy":1.6946,
"conservation":534.1641,
"conservatism":59.3097,
"conservative":1022.1984,
"conservatory":75.5022,
"conserve":113.3475,
"conserved":13.1799,
"conserving":0.7531,
"consider":5468.1684,
"considerable":1704.9192,
"considerably":510.2519,
"considerate":36.3390,
"consideration":1384.4584,
"considered":16.1925,
"considering":1.3180,
"consignment":60.6277,
"consist":1118.4120,
"consisted":1.3180,
"consistency":176.0463,
"consistent":561.0888,
"consistently":292.4064,
"consisting":1.3180,
"consists":0.1883,
"consolation":100.3558,
"console":99.6027,
"consolidate":155.1467,
"consolidated":38.9750,
"consolidation":82.8453,
"consonant":81.1508,
"consort":31.6319,
"consortia":2.6360,
"consortium":152.1342,
"conspicuous":133.8705,
"conspicuously":40.4812,
"conspiracy":194.8748,
"constable":224.6238,
"constance":3.3891,
"constancy":13.5565,
"constant":945.9430,
"constantine":0.1883,
"constantly":546.7792,
"constellation":45.3766,
"constipation":52.7198,
"constituency":485.3983,
"constituent":302.9503,
"constitute":706.8213,
"constituted":3.7657,
"constituting":0.7531,
"constitution":489.9172,
"constitutional":484.4569,
"constitutionality":8.2845,
"constitutionally":35.0210,
"constitutive":22.5942,
"constrain":169.2681,
"constrained":22.2176,
"constraining":1.1297,
"constraint":457.1556,
"construct":851.9889,
"constructed":1.1297,
"construction":1112.0103,
"constructive":172.8455,
"constructively":25.4185,
"constructor":14.1214,
"consul":26.1716,
"consular":19.9582,
"consulate":15.0628,
"consult":510.8168,
"consultancy":147.8036,
"consultant":551.8629,
"consultants":0.1883,
"consultation":542.2603,
"consultative":92.4479,
"consulting":45.5649,
"consumable":14.1214,
"consume":437.9505,
"consumer":1085.4621,
"consumerism":33.8913,
"consuming":3.3891,
"consummate":31.6319,
"consumption":587.2604,
"cont":6.2134,
"contact":2462.5774,
"contactable":1.8828,
"contacting":0.7531,
"contagious":22.7825,
"contain":3245.0892,
"contained":0.3766,
"container":276.2139,
"containing":1.3180,
"containment":47.4478,
"contains":1.3180,
"contaminant":19.2051,
"contaminate":112.9709,
"contaminated":32.1967,
"contamination":117.6780,
"contemplate":291.8415,
"contemplated":0.5649,
"contemplation":59.3097,
"contemplative":44.8118,
"contemporaneous":17.5105,
"contemporary":895.1061,
"contempt":217.2807,
"contend":166.6321,
"contender":106.9458,
"contending":0.1883,
"content":1623.9568,
"contented":29.5607,
"contenting":0.1883,
"contention":132.3642,
"contentious":90.3767,
"contentment":47.4478,
"contest":477.1138,
"contestant":49.3306,
"contested":0.7531,
"context":1753.6850,
"contexts":0.5649,
"contextual":73.2428,
"contextualise":3.5774,
"contextualising":0.1883,
"contextualize":2.6360,
"contextualized":0.3766,
"contextualizing":0.9414,
"contiguous":47.6361,
"continent":351.7161,
"continental":244.2054,
"contingency":112.4061,
"contingent":136.1299,
"continual":106.7575,
"continually":239.4983,
"continuance":31.4436,
"continuation":147.4270,
"continue":5790.7003,
"continued":146.8622,
"continues":2.0711,
"continuing":1.6946,
"continuity":239.3100,
"continuous":479.3732,
"continuously":157.7827,
"continuum":55.9206,
"contour":96.7784,
"contoured":1.8828,
"contours":0.3766,
"contra":15.8159,
"contraception":70.6068,
"contraceptive":72.3014,
"contract":3073.1852,
"contracting":98.8495,
"contraction":140.4605,
"contractor":330.0633,
"contractors":2.2594,
"contracts":0.1883,
"contractual":160.7953,
"contractually":10.1674,
"contradict":116.5483,
"contradiction":266.0465,
"contradictory":132.1760,
"contrarily":1.6946,
"contrary":517.2185,
"contrast":1513.6218,
"contrasted":0.3766,
"contrasting":0.7531,
"contrastive":7.1548,
"contrasts":0.3766,
"contravention":44.8118,
"contribute":1140.4413,
"contributed":0.1883,
"contributing":6.0251,
"contribution":1446.9690,
"contributor":123.8914,
"contributory":72.1131,
"contrived":15.8159,
"control":7022.8363,
"controllable":20.3348,
"controlled":6.0251,
"controller":164.9375,
"controlling":10.7322,
"controls":3.7657,
"controversial":389.3731,
"controversially":13.7448,
"controversy":379.9588,
"convection":37.6570,
"convective":3.9540,
"convene":98.0964,
"convener":27.3013,
"convenience":173.2221,
"convenient":355.2935,
"conveniently":112.0295,
"convening":7.5314,
"convent":83.2219,
"convention":480.3146,
"conventional":694.5828,
"conventionally":53.0963,
"converge":91.1299,
"convergence":92.8244,
"convergent":16.7574,
"conversation":1118.6002,
"conversational":73.0545,
"converse":61.9457,
"conversely":147.2387,
"conversion":420.2518,
"convert":761.0473,
"converted":23.9122,
"converter":43.4938,
"convertible":87.3642,
"convertibles":0.3766,
"converting":2.8243,
"converts":0.5649,
"convex":26.5482,
"convey":427.2183,
"conveyance":101.4855,
"conveyancing":13.5565,
"conveying":2.8243,
"conveyor":26.5482,
"conveys":0.1883,
"convict":324.7914,
"convicted":1.3180,
"conviction":488.4109,
"convince":704.1853,
"convinced":144.0379,
"convincing":205.0422,
"convincingly":52.5315,
"convocation":10.9205,
"convoluted":24.2887,
"convolution":4.3306,
"convoy":139.1425,
"coo":21.8410,
"cook":825.4407,
"cookbook":7.7197,
"cooke":0.1883,
"cooked":19.0168,
"cooker":120.1257,
"cookery":71.7365,
"cookie":24.1005,
"cooking":313.3060,
"cooks":0.3766,
"cookware":2.0711,
"cool":908.0978,
"coolant":10.5440,
"cooled":1.5063,
"cooler":6.7783,
"cooling":32.9498,
"coolly":72.1131,
"coolness":24.1005,
"coon":2.6360,
"coop":9.9791,
"cooper":12.6151,
"cooperate":78.3265,
"cooperating":0.1883,
"cooperation":215.3979,
"cooperative":104.6864,
"cooperatively":3.3891,
"coordinate":210.8790,
"coordinated":21.2762,
"coordinating":9.2260,
"coordination":79.2679,
"coordinator":66.4645,
"cop":138.5776,
"cope":947.0728,
"copied":0.1883,
"copier":12.8034,
"coping":3.0126,
"copious":33.5147,
"copper":353.2224,
"coptic":9.7908,
"copy":1852.9111,
"copying":45.1884,
"copyright":169.6446,
"cora":0.1883,
"coral":145.1676,
"corbett":0.7531,
"cord":178.1175,
"corded":1.3180,
"cordial":19.5816,
"cordless":25.9833,
"cordoba":1.1297,
"corduroy":22.4059,
"core":651.8421,
"cored":0.5649,
"corgi":3.7657,
"coriander":14.1214,
"coring":0.5649,
"cork":64.3934,
"corked":0.1883,
"corks":0.1883,
"corkscrew":19.5816,
"corn":228.5778,
"cornea":10.9205,
"corneal":4.7071,
"corner":1540.1700,
"cornered":13.7448,
"cornering":2.2594,
"cornerstone":35.0210,
"cornish":35.7741,
"corolla":1.1297,
"corollary":45.9415,
"corona":2.4477,
"coronal":6.2134,
"coronary":93.9541,
"coronation":70.6068,
"coroner":116.5483,
"corp":8.4728,
"corporal":65.1466,
"corporate":781.0055,
"corporation":417.9923,
"corps":56.2972,
"corpse":203.7242,
"corpus":105.0629,
"corral":8.0962,
"correct":1334.7512,
"correcting":3.9540,
"correction":145.9208,
"correctional":2.6360,
"corrective":42.7407,
"correctly":341.1721,
"correctness":31.0670,
"correlate":163.8078,
"correlated":4.7071,
"correlation":311.4231,
"correspond":507.8042,
"correspondence":261.7159,
"correspondent":192.6154,
"corresponding":130.6697,
"correspondingly":61.0043,
"corridor":469.0175,
"corrie":8.6611,
"corrosion":53.8495,
"corrosive":24.2887,
"corrugated":16.3808,
"corrupt":154.3936,
"corrupted":3.3891,
"corruption":256.0674,
"corsair":1.3180,
"corset":22.7825,
"cortex":69.4771,
"cortical":25.0419,
"cortisol":2.6360,
"corvette":3.5774,
"cos":2167.1585,
"cosmetic":102.2387,
"cosmetology":0.3766,
"cosmic":67.2177,
"cosmological":18.6402,
"cosmology":23.3473,
"cosmopolitan":45.0001,
"cosmos":6.0251,
"cost":6780.5137,
"costa":10.7322,
"costing":63.4520,
"costly":212.9502,
"costume":199.3936,
"cosy":126.7157,
"cot":98.8495,
"cote":1.8828,
"cotswold":2.8243,
"cottage":606.8420,
"cotter":0.7531,
"cotton":406.3187,
"cottonwood":0.5649,
"cou":0.7531,
"couch":128.0337,
"cougar":1.3180,
"cough":253.2431,
"coughing":21.8410,
"could":29082.4767,
"couldn":0.7531,
"coulomb":0.5649,
"council":2431.8870,
"councillor":523.8084,
"councillors":1.6946,
"councilman":0.5649,
"councilor":0.1883,
"counsel":239.1217,
"counseling":0.1883,
"counselling":232.5318,
"counsellor":165.8789,
"counselor":0.1883,
"count":1320.6299,
"countable":2.8243,
"countdown":15.6276,
"counted":0.1883,
"countenance":61.9457,
"counter":851.8006,
"counteract":64.7700,
"counterfeit":27.3013,
"counterpart":302.0089,
"counterparts":0.1883,
"counterpoint":20.5230,
"counterproductive":16.3808,
"countess":12.9917,
"counting":56.1089,
"countless":111.0881,
"country":8422.5458,
"countryside":617.9509,
"countrywide":8.0962,
"county":1237.9728,
"coup":316.1302,
"coupe":21.8410,
"couple":2670.6322,
"coupled":2.0711,
"coupler":5.6485,
"couples":0.1883,
"coupling":61.9457,
"coupon":138.7659,
"courage":340.2307,
"courageous":66.6528,
"courier":41.2344,
"course":9899.4521,
"courses":0.3766,
"coursework":30.8787,
"court":4063.3752,
"courteous":47.2595,
"courtesy":176.2346,
"courthouse":9.7908,
"courtroom":36.5273,
"courts":0.1883,
"courtship":48.0126,
"courtyard":160.0421,
"cousin":405.9421,
"couture":16.0042,
"covariance":12.0502,
"cove":39.3515,
"covenant":246.0883,
"coventry":2.8243,
"cover":4518.6479,
"coverage":402.1764,
"covered":19.3933,
"covering":93.3893,
"covers":0.1883,
"covert":73.8077,
"coveted":25.7950,
"covey":0.3766,
"cow":491.0469,
"coward":40.8578,
"cowardice":25.2302,
"cowardly":25.2302,
"cowboy":69.4771,
"cowgirl":2.0711,
"cox":4.7071,
"coy":24.2887,
"coyote":5.4603,
"cozy":1.6946,
"cpa":11.2971,
"cpr":2.8243,
"cpu":73.4311,
"cr":0.9414,
"crab":96.2136,
"crack":667.4698,
"crackdown":52.5315,
"cracked":22.5942,
"cracker":62.3223,
"cracking":20.7113,
"cradle":122.7617,
"craft":447.7414,
"crafting":1.5063,
"craftsman":152.5107,
"craftsmanship":33.3264,
"crafty":28.9959,
"cram":100.5441,
"crammed":1.8828,
"cramped":55.5440,
"cramps":0.1883,
"cranberry":16.9456,
"crane":119.1843,
"cranial":11.2971,
"crank":39.7281,
"cranky":8.8494,
"crap":145.9208,
"crappy":7.1548,
"crash":830.7127,
"crashed":0.3766,
"crashes":0.3766,
"crashing":6.5900,
"crate":80.7742,
"crater":79.2679,
"crave":51.9666,
"craven":6.2134,
"craving":34.8327,
"crawford":0.3766,
"crawl":225.5652,
"crawler":5.2720,
"crawling":2.2594,
"craze":60.2511,
"crazed":3.3891,
"crazy":293.7244,
"cream":652.9718,
"creamer":1.3180,
"creams":0.3766,
"creamy":71.1717,
"crease":75.6905,
"creased":11.8619,
"create":3913.5004,
"created":0.5649,
"creates":0.1883,
"creating":4.1423,
"creation":865.9220,
"creationism":1.6946,
"creative":438.7037,
"creatively":20.1465,
"creativity":146.1090,
"creator":102.4270,
"creature":700.4196,
"creatures":0.9414,
"cred":7.9080,
"credence":32.3850,
"credential":67.2177,
"credibility":175.8580,
"credible":79.6445,
"credit":1454.1238,
"creditable":20.3348,
"credited":0.1883,
"crediting":0.7531,
"creditor":338.3479,
"cree":2.0711,
"creed":54.9792,
"creek":24.6653,
"creep":330.6282,
"creeper":19.9582,
"creeping":0.9414,
"creepy":14.4979,
"cremation":27.3013,
"creme":4.8954,
"creole":17.6988,
"crepe":11.8619,
"crept":1.3180,
"crescent":16.0042,
"crest":104.4981,
"crested":11.8619,
"cretaceous":19.3933,
"crete":0.9414,
"crew":743.3486,
"crib":17.6988,
"cricket":507.0511,
"crime":1526.0486,
"crimea":0.1883,
"criminal":902.6375,
"criminally":14.1214,
"criminology":42.1758,
"crimson":63.8286,
"cringe":36.9038,
"cripple":55.3557,
"crippled":45.3766,
"crippling":37.6570,
"crisis":1122.9308,
"crisp":187.7200,
"crispy":9.6025,
"criteria":8.8494,
"criterion":915.8175,
"critic":649.9593,
"critical":1021.2570,
"critically":110.1466,
"criticise":373.5571,
"criticised":0.3766,
"criticism":1053.2654,
"criticisms":0.1883,
"criticize":307.4691,
"criticizing":0.7531,
"critique":163.8078,
"critter":1.8828,
"croatian":64.0168,
"crochet":21.6528,
"crock":12.2385,
"crockery":23.1590,
"crocodile":64.9583,
"croft":12.0502,
"crook":49.5189,
"crooked":53.6612,
"crop":643.3693,
"cropped":19.3933,
"cropping":18.6402,
"croquet":19.2051,
"crosby":0.1883,
"cross":2346.7823,
"crossed":10.7322,
"crossfire":8.2845,
"crossing":226.3184,
"crossover":25.0419,
"crossword":39.3515,
"crotch":15.0628,
"crouch":161.3601,
"croupier":2.2594,
"crow":94.1424,
"crowd":1116.5291,
"crowded":144.0379,
"crowding":7.5314,
"crowds":1.5063,
"crown":466.3816,
"crowned":0.9414,
"crowning":7.9080,
"crt":0.5649,
"crucial":799.0809,
"crucially":64.5817,
"crucible":13.3682,
"crucified":2.0711,
"crucifixion":21.0879,
"crude":252.4900,
"cruel":232.3435,
"crueller":1.8828,
"cruelly":43.8704,
"cruelty":133.1174,
"cruise":247.5946,
"cruiser":46.6946,
"cruising":19.2051,
"crumb":59.4980,
"crumble":153.8287,
"crumbled":2.6360,
"crumbling":7.3431,
"crunch":108.0755,
"crunchy":16.1925,
"crusade":104.6864,
"crusader":23.5356,
"crush":327.6156,
"crushed":6.4017,
"crusher":6.5900,
"crushing":10.9205,
"crust":139.3308,
"crusty":25.0419,
"crux":36.3390,
"cry":1468.8101,
"crying":31.2553,
"cryogenic":1.3180,
"crypt":57.0503,
"cryptic":31.6319,
"cryptographic":0.9414,
"cryptography":1.3180,
"crystal":321.4022,
"crystalline":48.5775,
"crystallization":18.2636,
"cs":0.5649,
"cst":0.9414,
"ct":2.4477,
"cu":9.4142,
"cub":43.8704,
"cuban":66.0880,
"cube":103.9332,
"cubes":0.3766,
"cubic":77.3851,
"cubicle":42.5524,
"cuckold":5.6485,
"cuckoo":84.3516,
"cucumber":40.8578,
"cuddly":28.0544,
"cue":163.6195,
"cuff":85.8579,
"cuisine":79.6445,
"culinary":32.9498,
"culmination":54.9792,
"culprit":61.1926,
"cult":188.0966,
"cultivate":189.4146,
"cultivated":0.9414,
"cultivating":0.1883,
"cultivation":114.2889,
"cultural":1175.4623,
"culturally":66.8411,
"culture":1750.8607,
"cultured":56.4855,
"cultures":1.6946,
"culvert":11.4854,
"cum":51.4018,
"cumberland":0.7531,
"cumbersome":53.4729,
"cumin":6.2134,
"cumulative":124.8329,
"cunning":80.0211,
"cunningham":0.1883,
"cunt":41.9875,
"cup":1088.4747,
"cupboard":334.3939,
"cupid":5.2720,
"cur":3.5774,
"curable":6.4017,
"curacao":0.1883,
"curative":18.8285,
"curator":84.7282,
"curb":154.3936,
"cure":400.1053,
"cured":1.1297,
"curfew":51.5900,
"curie":4.5188,
"curing":5.4603,
"curio":4.8954,
"curiosity":195.8162,
"curious":383.1597,
"curiously":159.6655,
"curl":334.2056,
"curled":7.3431,
"curling":37.2804,
"curls":0.1883,
"curly":78.8913,
"currency":773.8507,
"current":2697.9335,
"currently":1270.7344,
"curricula":35.7741,
"curricular":80.2093,
"curriculum":829.5830,
"curry":60.0629,
"curse":223.1175,
"cursed":6.7783,
"cursing":9.0377,
"cursor":65.1466,
"cursors":0.1883,
"cursory":29.1842,
"curt":24.1005,
"curtail":86.4227,
"curtain":590.6495,
"curvature":75.3139,
"curve":716.6121,
"curved":126.7157,
"curving":0.7531,
"cushion":186.5903,
"cushioned":13.5565,
"cushioning":13.9331,
"cusp":11.1088,
"custard":48.9541,
"custodial":49.7072,
"custodian":38.2218,
"custody":256.8205,
"custom":494.8126,
"customarily":14.8745,
"customary":144.0379,
"customer":2028.9575,
"customise":33.3264,
"customizable":0.5649,
"customization":1.3180,
"customize":5.2720,
"customized":0.1883,
"customs":10.9205,
"cut":4685.6566,
"cutaneous":3.9540,
"cute":54.6026,
"cutie":2.0711,
"cutlass":2.6360,
"cutler":4.5188,
"cutlery":53.0963,
"cutoff":5.4603,
"cuts":4.1423,
"cutter":108.6404,
"cutting":262.0925,
"cv":26.3599,
"cyan":3.3891,
"cyanide":17.6988,
"cyberspace":2.0711,
"cycle":810.0014,
"cycled":1.1297,
"cycles":0.3766,
"cyclic":41.0461,
"cyclical":36.9038,
"cycling":112.4061,
"cyclist":134.0588,
"cyclone":15.0628,
"cygnus":0.1883,
"cylinder":251.3603,
"cylindrical":32.0084,
"cymbal":9.0377,
"cynical":135.1885,
"cynicism":48.3892,
"cypress":17.3222,
"cypriot":26.7364,
"cyril":1.5063,
"cyst":18.0753,
"cysteine":5.6485,
"cystic":40.4812,
"cytochrome":13.1799,
"cytology":14.4979,
"cytoplasm":22.7825,
"cytoplasmic":31.2553,
"cytotoxic":8.0962,
"cz":0.1883,
"czech":78.8913,
"d":640.1685,
"da":65.1466,
"dab":65.7114,
"dachshund":2.4477,
"dad":642.0513,
"dada":2.2594,
"daddy":320.4608,
"daemon":21.4645,
"daft":112.5943,
"dag":0.7531,
"dagger":70.0420,
"dahlia":7.1548,
"dail":0.3766,
"daily":937.4702,
"daimler":0.7531,
"dairy":152.6990,
"daisy":52.5315,
"dakota":0.7531,
"dal":2.2594,
"dale":45.9415,
"dali":0.3766,
"dalian":0.3766,
"dallas":0.1883,
"dalmatian":5.8368,
"dalton":0.9414,
"dam":141.5902,
"damage":2437.7238,
"damaged":18.2636,
"damages":2.8243,
"damaging":191.4857,
"damascus":0.1883,
"dame":24.8536,
"dammit":14.1214,
"damn":340.7956,
"damned":157.0296,
"damon":0.1883,
"damp":375.8165,
"damper":21.2762,
"damping":11.2971,
"dampness":22.0293,
"dams":0.7531,
"dana":0.1883,
"dance":1180.3577,
"danced":2.2594,
"dancer":239.4983,
"dancing":233.2849,
"dandelion":24.4770,
"dandy":14.6862,
"dane":1.5063,
"dang":1.6946,
"danger":1340.5881,
"dangerous":1020.8804,
"dangerously":104.3098,
"dangle":96.5901,
"dangling":2.2594,
"daniel":0.5649,
"danish":115.2303,
"danube":0.1883,
"daphne":0.1883,
"dar":0.1883,
"dare":565.7959,
"dared":23.5356,
"daredevil":8.2845,
"dares":1.5063,
"dari":0.1883,
"daring":63.4520,
"dark":2454.1046,
"darkened":35.9624,
"darker":2.0711,
"darkest":2.2594,
"darkness":588.7667,
"darkroom":10.3557,
"darling":311.4231,
"darn":23.5356,
"dart":170.3978,
"darts":0.3766,
"darwin":0.1883,
"darwinian":33.7030,
"darwinism":5.4603,
"dash":300.1260,
"dashboard":29.5607,
"dashed":0.5649,
"dashing":4.1423,
"dat":3.3891,
"data":294.4775,
"database":736.9469,
"date":3458.2277,
"dateline":2.2594,
"dates":0.7531,
"dating":43.1172,
"datum":2683.0590,
"daughter":1947.6184,
"daunting":82.6570,
"dauphin":0.3766,
"davenport":0.9414,
"david":28.2427,
"davis":0.9414,
"davy":4.5188,
"dawn":368.4734,
"dawned":0.1883,
"day":17134.1089,
"daybreak":7.5314,
"daycare":1.8828,
"daylight":174.1635,
"days":0.5649,
"daytime":90.1884,
"dayton":0.3766,
"daze":42.5524,
"dazzle":67.2177,
"dazzling":72.3014,
"db":8.2845,
"dbms":15.4394,
"dc":3.0126,
"dd":16.9456,
"de":449.6242,
"deacon":30.3139,
"deactivate":4.5188,
"dead":2127.9953,
"deadline":201.2765,
"deadlock":49.5189,
"deadly":146.6739,
"deadwood":4.3306,
"deaf":416.2978,
"deafer":0.7531,
"deafness":31.0670,
"deal":5071.0756,
"dealer":621.3400,
"dealership":14.3096,
"dealing":248.9126,
"dealt":0.5649,
"dean":30.6904,
"dear":1087.3450,
"dearest":2.6360,
"dearly":63.4520,
"death":4006.7014,
"deb":0.9414,
"debacle":25.4185,
"debatable":36.1507,
"debate":1712.0741,
"debated":0.1883,
"debating":6.7783,
"debilitating":17.1339,
"debit":65.8997,
"debris":130.4814,
"debt":1316.1110,
"debtor":215.3979,
"debug":7.3431,
"debugger":6.5900,
"debugging":9.0377,
"debussy":0.7531,
"debut":286.5695,
"dec":0.9414,
"decade":1095.2529,
"decadent":16.7574,
"decal":0.7531,
"decay":266.0465,
"decayed":6.9665,
"decaying":0.3766,
"deceased":109.5818,
"deceit":38.2218,
"deceive":125.0211,
"deceiving":1.8828,
"december":0.1883,
"decency":62.3223,
"decent":331.3813,
"decentralization":44.6235,
"decentralized":12.4268,
"deception":141.5902,
"deceptive":40.8578,
"decide":4359.3589,
"decided":1.6946,
"decidedly":76.2554,
"deciding":0.3766,
"deciduous":16.1925,
"decimal":87.7407,
"decipher":31.4436,
"decision":4606.9535,
"decisive":213.8916,
"decisively":52.7198,
"deck":339.1010,
"decker":27.3013,
"decking":3.9540,
"declaration":334.0173,
"declarative":7.9080,
"declaratory":2.4477,
"declare":1127.6379,
"declared":7.3431,
"declares":0.3766,
"decline":1451.2996,
"declined":0.1883,
"declining":0.1883,
"deco":8.8494,
"decode":39.9164,
"decoder":16.3808,
"decoding":8.0962,
"decommissioning":11.8619,
"decompose":39.1632,
"decomposition":31.2553,
"decompression":20.3348,
"decontamination":6.0251,
"decor":59.6863,
"decorate":362.4483,
"decorating":13.5565,
"decoration":241.3812,
"decorative":157.0296,
"decorator":32.5733,
"decrease":500.0845,
"decreased":0.3766,
"decreasing":0.5649,
"decree":250.2306,
"decreed":0.7531,
"decrypt":1.5063,
"decryption":0.1883,
"dedicate":213.7033,
"dedicated":159.8538,
"dedication":118.4312,
"deduce":100.7324,
"deduced":0.3766,
"deducing":0.5649,
"deduct":101.8621,
"deductible":16.0042,
"deduction":110.7115,
"deed":219.5401,
"deem":270.9419,
"deemed":5.2720,
"deep":2324.5647,
"deepen":144.0379,
"deepened":0.5649,
"deepening":11.2971,
"deeper":2.4477,
"deepest":0.3766,
"deeply":738.2649,
"deer":157.2178,
"deere":0.1883,
"defamation":24.2887,
"defamatory":20.7113,
"default":201.0882,
"defaulted":0.1883,
"defeat":1025.5875,
"defeated":0.7531,
"defeating":2.0711,
"defect":310.8583,
"defective":129.7283,
"defence":1744.4591,
"defences":1.3180,
"defend":776.8633,
"defendant":825.2525,
"defended":0.3766,
"defender":289.5821,
"defending":6.9665,
"defends":0.1883,
"defense":8.4728,
"defensive":224.2472,
"defer":120.3140,
"deference":56.1089,
"deferral":7.1548,
"deferred":39.3515,
"defiance":91.6947,
"defiant":60.6277,
"deficiency":192.8037,
"deficient":50.4603,
"deficit":481.6326,
"defied":0.5649,
"definable":16.9456,
"define":1863.8316,
"defined":7.3431,
"defines":0.3766,
"defining":2.0711,
"definite":283.9335,
"definitely":528.7038,
"definition":1088.4747,
"definitive":105.0629,
"definitively":12.9917,
"deflation":22.4059,
"deflection":23.3473,
"deforestation":33.3264,
"deformation":42.7407,
"deformed":12.0502,
"defray":8.4728,
"defunct":32.1967,
"defy":155.8998,
"defying":0.3766,
"degas":0.9414,
"degenerate":87.1759,
"degeneration":24.2887,
"degenerative":10.3557,
"degradation":81.1508,
"degrade":50.0838,
"degraded":15.8159,
"degrading":19.9582,
"degree":2289.1671,
"degrees":0.3766,
"dehydrated":6.9665,
"dehydration":21.0879,
"deity":81.1508,
"del":0.7531,
"delay":1105.7969,
"delayed":13.9331,
"delaying":6.4017,
"delectable":17.8871,
"delegate":492.9297,
"delegated":4.5188,
"delegation":328.3688,
"delete":178.1175,
"deleted":0.1883,
"deleterious":21.8410,
"deleting":0.1883,
"deletion":84.3516,
"delft":0.1883,
"delhi":0.3766,
"deli":9.7908,
"deliberate":264.1636,
"deliberately":488.7874,
"deliberation":81.3391,
"delicacy":68.5357,
"delicate":305.5863,
"delicately":62.5106,
"delicatessen":10.9205,
"delicious":178.1175,
"delight":466.0050,
"delighted":445.2937,
"delightful":189.0380,
"delightfully":32.0084,
"delimited":3.0126,
"delineate":36.5273,
"delineation":10.3557,
"delinquency":31.8201,
"delinquent":48.2009,
"deliver":1143.2656,
"deliverable":5.0837,
"deliverance":30.1256,
"delivered":0.3766,
"deliveries":0.3766,
"delivering":0.7531,
"delivery":724.3318,
"dell":1.5063,
"delphi":0.3766,
"delta":49.3306,
"delusion":52.9080,
"deluxe":11.8619,
"delve":41.0461,
"demand":3949.6511,
"demanded":0.3766,
"demanding":144.0379,
"demeanor":0.1883,
"demented":27.3013,
"dementia":112.4061,
"demise":145.1676,
"demo":59.4980,
"democracy":755.0222,
"democrat":15.8159,
"democratic":662.9509,
"democratically":32.0084,
"democratization":18.4519,
"demographic":143.0965,
"demography":16.9456,
"demolish":183.2012,
"demolition":106.9458,
"demon":103.7449,
"demonic":18.6402,
"demonstrable":15.8159,
"demonstrably":19.0168,
"demonstrate":1203.7050,
"demonstrated":1.1297,
"demonstrating":3.3891,
"demonstration":595.7332,
"demonstrative":22.4059,
"demonstratively":2.6360,
"demonstrator":149.4982,
"demos":0.5649,
"den":49.3306,
"denali":0.3766,
"dengue":0.5649,
"deniable":0.9414,
"denial":166.4438,
"denier":1.3180,
"denim":36.3390,
"denmark":1.6946,
"denomination":71.7365,
"denominational":30.5021,
"denominator":38.0335,
"denotation":3.0126,
"denote":149.6864,
"denounce":157.9710,
"dense":187.9083,
"densely":48.0126,
"density":353.7872,
"dent":64.0168,
"dental":99.4144,
"dentist":147.8036,
"dentistry":10.3557,
"deny":1360.7346,
"denying":2.8243,
"deodorant":14.3096,
"depart":259.4565,
"departed":0.1883,
"departing":0.7531,
"department":1849.5220,
"departmental":161.1718,
"departure":465.6284,
"departures":1.3180,
"depend":2208.9578,
"dependability":7.3431,
"dependable":24.1005,
"dependant":73.4311,
"depended":0.3766,
"dependence":243.4523,
"dependency":153.2639,
"dependent":770.2733,
"depending":0.5649,
"depends":0.1883,
"depict":255.5025,
"depicted":0.5649,
"depiction":39.3515,
"depleted":15.2511,
"depletion":67.2177,
"deploy":169.8329,
"deployment":103.5567,
"deportation":42.3641,
"deposed":0.5649,
"deposit":844.6458,
"deposited":0.7531,
"depositing":1.6946,
"deposition":84.3516,
"depository":6.5900,
"depot":128.4103,
"depots":0.1883,
"depreciation":69.6654,
"depress":85.8579,
"depressants":0.1883,
"depressed":256.6322,
"depressing":106.7575,
"depression":397.8459,
"depressive":37.0921,
"deprivation":163.6195,
"deprive":299.9378,
"deprived":16.1925,
"depth":796.0683,
"deputy":562.4068,
"der":3.3891,
"derby":51.4018,
"deregister":0.3766,
"deregistering":0.3766,
"deregistration":1.5063,
"deregulated":4.8954,
"deregulation":78.3265,
"derivation":40.4812,
"derivative":112.0295,
"derive":964.3950,
"derived":2.2594,
"deriving":1.1297,
"dermal":2.6360,
"dermatitis":9.0377,
"dermatology":4.5188,
"derogatory":19.5816,
"derrick":2.0711,
"des":1.5063,
"descend":336.6533,
"descendant":135.9417,
"descended":0.1883,
"descending":3.0126,
"descent":186.4020,
"describe":4177.0992,
"described":0.5649,
"describing":1.1297,
"description":1118.6002,
"descriptive":121.2554,
"descriptor":25.0419,
"desert":491.0469,
"deserted":95.6487,
"deserve":582.7416,
"deserved":16.9456,
"deservedly":17.3222,
"deserves":0.1883,
"deserving":25.9833,
"design":4610.1544,
"designate":292.9712,
"designated":6.7783,
"designation":76.6319,
"designed":3.9540,
"designer":495.7540,
"designing":12.0502,
"designs":3.2008,
"desirability":45.9415,
"desirable":376.3814,
"desire":1432.0945,
"desired":0.5649,
"desiring":0.7531,
"desirous":7.9080,
"desist":19.7699,
"desk":813.9554,
"desktop":237.6155,
"desolate":49.5189,
"despair":283.7453,
"despairing":29.5607,
"despairingly":15.6276,
"desperate":442.2811,
"desperately":337.5947,
"desperation":98.6613,
"despicable":22.0293,
"despise":128.5985,
"despised":0.3766,
"despite":2610.9459,
"dessert":71.7365,
"destination":263.9753,
"destiny":117.3015,
"destitute":24.2887,
"destroy":1110.6923,
"destroyed":0.1883,
"destroyer":44.6235,
"destroying":0.3766,
"destruction":429.8543,
"destructive":157.9710,
"detach":104.1215,
"detachable":18.2636,
"detached":131.0462,
"detachment":95.0838,
"detail":3189.7335,
"detailed":1061.7382,
"detailing":6.5900,
"details":11.6737,
"detain":163.4312,
"detained":0.1883,
"detainee":51.4018,
"detect":604.9592,
"detectable":49.7072,
"detected":0.1883,
"detecting":5.0837,
"detection":157.4061,
"detective":378.4525,
"detectives":0.1883,
"detector":143.6613,
"detention":156.8413,
"deter":161.9250,
"detergent":74.3725,
"deteriorate":194.8748,
"deteriorated":1.6946,
"deteriorating":0.5649,
"deterioration":133.4940,
"determinant":113.9123,
"determinate":21.2762,
"determination":578.9759,
"determine":1919.7522,
"determined":547.5323,
"determines":0.3766,
"determining":12.9917,
"deterministic":19.5816,
"deterrence":46.1298,
"deterrent":117.3015,
"detour":44.4352,
"detox":2.0711,
"detoxification":9.0377,
"detract":55.9206,
"detriment":61.5691,
"detrimental":64.7700,
"detroit":0.1883,
"deuce":2.8243,
"deuteronomy":0.1883,
"devaluation":100.7324,
"devastated":14.3096,
"devastating":142.1551,
"devastation":48.7658,
"develop":5028.7116,
"developed":56.2972,
"developer":336.8416,
"developing":6.5900,
"development":5905.9306,
"developmental":104.3098,
"developmentally":6.9665,
"develops":0.1883,
"deviant":72.6779,
"deviate":46.1298,
"deviating":0.1883,
"deviation":142.5316,
"device":889.0810,
"devices":0.3766,
"devil":244.7703,
"devious":49.3306,
"devise":405.1890,
"devised":0.1883,
"devising":8.8494,
"devoid":70.7951,
"devolution":83.9750,
"devolved":0.9414,
"devon":0.3766,
"devote":419.1221,
"devoted":171.1509,
"devotedly":5.0837,
"devotion":114.8538,
"devotional":16.3808,
"devour":68.3474,
"devout":37.0921,
"dew":38.4101,
"dexter":2.0711,
"dexterity":20.8996,
"di":67.4060,
"diabetes":87.5525,
"diabetic":163.2430,
"diagnose":179.8120,
"diagnosing":0.1883,
"diagnosis":334.7704,
"diagnostic":142.9082,
"diagonal":86.4227,
"diagonally":29.5607,
"diagram":310.6700,
"dial":152.3224,
"dialect":133.4940,
"dialer":0.3766,
"dialog":7.5314,
"dialogue":318.2014,
"dialysis":19.9582,
"diamante":0.5649,
"diameter":232.9083,
"diamond":225.9418,
"diana":4.5188,
"diaper":6.2134,
"diaphragm":26.1716,
"diarrhea":0.1883,
"diarrhoea":127.8454,
"diary":373.7454,
"diaspora":7.5314,
"diastolic":7.5314,
"dice":82.2805,
"diced":4.7071,
"dichotomy":49.1423,
"dick":40.4812,
"dickens":0.1883,
"dickey":0.5649,
"dickie":3.0126,
"dict":0.3766,
"dictate":255.6908,
"dictation":16.9456,
"dictator":59.8746,
"dictators":0.1883,
"dictatorship":83.9750,
"dictionary":249.4774,
"did":4.7071,
"didactic":19.5816,
"didn":2.0711,
"die":4081.8271,
"died":2.0711,
"dielectric":12.0502,
"dies":0.3766,
"diesel":256.0674,
"diet":805.8591,
"dietary":127.2806,
"dieter":16.0042,
"dietetic":3.2008,
"dieting":36.3390,
"diff":10.5440,
"differ":746.9260,
"difference":3399.1062,
"differences":0.3766,
"different":8580.7051,
"differential":200.1468,
"differentially":10.3557,
"differentiate":231.4021,
"differentiated":12.2385,
"differentiating":0.1883,
"differentiation":174.3518,
"differently":277.1553,
"differing":1.8828,
"difficult":3926.3038,
"difficulty":2352.4308,
"diffraction":15.8159,
"diffuse":91.6947,
"diffused":10.7322,
"diffusion":58.9332,
"dig":571.2562,
"digest":115.2303,
"digested":2.2594,
"digestion":81.3391,
"digestive":52.9080,
"digger":43.8704,
"digging":28.6193,
"digit":93.3893,
"digital":203.1593,
"digitally":8.6611,
"digitized":0.3766,
"digits":0.5649,
"dignified":71.3600,
"dignity":227.6364,
"digress":13.7448,
"dilated":7.7197,
"dilation":4.8954,
"dildo":6.2134,
"dilemma":231.9669,
"dilemmas":0.1883,
"diligence":55.3557,
"diligent":25.6067,
"diligently":19.7699,
"dill":14.6862,
"dilute":112.7826,
"diluted":15.0628,
"dilution":52.3432,
"dim":162.4898,
"dime":7.3431,
"dimension":526.8210,
"dimensional":212.7619,
"dimensions":0.7531,
"dimer":13.9331,
"diminish":294.2892,
"diminished":28.9959,
"diminishing":1.5063,
"diminution":31.0670,
"din":20.7113,
"dinar":33.3264,
"dine":93.3893,
"diner":33.5147,
"ding":9.6025,
"dinghy":73.0545,
"dining":381.2768,
"dinner":1114.4580,
"dinnerware":0.3766,
"dinosaur":125.7743,
"dinosaurs":0.7531,
"diocesan":29.1842,
"diocese":92.6361,
"diode":28.9959,
"dioxide":253.4314,
"dioxin":33.5147,
"dip":275.0842,
"diploma":76.6319,
"diplomacy":100.1675,
"diplomat":154.9584,
"diplomatic":340.9838,
"dipole":23.9122,
"dipping":19.2051,
"dire":74.3725,
"direct":2858.7288,
"directed":1.8828,
"directing":4.3306,
"direction":1896.2166,
"directional":36.7155,
"directive":295.7955,
"directly":1557.6805,
"director":2297.2634,
"directorate":26.7364,
"directory":273.3896,
"dirk":3.9540,
"dirt":182.4480,
"dirty":500.0845,
"dis":8.2845,
"disability":376.1931,
"disable":73.6194,
"disabled":528.8921,
"disabling":0.9414,
"disadvantage":366.2140,
"disadvantaged":93.2010,
"disagree":233.8498,
"disagreeable":34.0796,
"disagreed":0.3766,
"disagreement":207.6782,
"disallow":33.1381,
"disallowed":0.3766,
"disambiguation":4.1423,
"disappear":995.8385,
"disappearance":126.9040,
"disappeared":5.4603,
"disappearing":0.7531,
"disappoint":242.5109,
"disappointed":190.5443,
"disappointing":169.8329,
"disappointment":299.5612,
"disapproval":92.2596,
"disapprove":105.6278,
"disapproving":1.3180,
"disarm":60.2511,
"disarmament":57.9917,
"disassociate":9.0377,
"disassociated":0.1883,
"disaster":591.5910,
"disastrous":201.8414,
"disbanded":0.1883,
"disbelief":108.2638,
"disbursement":22.9708,
"disc":400.1053,
"discard":203.9125,
"discarded":1.3180,
"discarding":1.1297,
"discern":101.4855,
"discernible":52.3432,
"discerning":17.6988,
"discernment":10.3557,
"discharge":522.3022,
"discharged":2.4477,
"discharging":1.3180,
"disciple":99.6027,
"discipleship":9.9791,
"disciplinary":210.6907,
"discipline":849.7295,
"disciplined":9.2260,
"disciplining":5.6485,
"disclaim":15.8159,
"disclaimer":32.3850,
"disclose":321.5905,
"disclosing":0.3766,
"disclosure":218.5987,
"disco":111.0881,
"discography":4.8954,
"discoloration":6.0251,
"discomfort":126.7157,
"disconnect":38.5984,
"disconnected":16.0042,
"disconnection":13.7448,
"discontent":125.0211,
"discontentment":1.1297,
"discontinuation":3.3891,
"discontinue":63.8286,
"discontinued":12.8034,
"discontinuity":42.1758,
"discontinuous":17.8871,
"discord":26.9247,
"discos":21.6528,
"discount":570.3148,
"discounted":2.4477,
"discounting":9.9791,
"discourage":214.4564,
"discouraged":3.2008,
"discouraging":9.9791,
"discourse":490.1054,
"discover":1867.0325,
"discovered":0.7531,
"discovering":1.5063,
"discovery":574.2688,
"discredit":93.5776,
"discredited":5.4603,
"discreet":96.0253,
"discreetly":57.0503,
"discrepancy":118.4312,
"discrete":90.7533,
"discretely":3.2008,
"discretion":327.9922,
"discretionary":105.2512,
"discriminate":157.4061,
"discriminated":0.3766,
"discriminating":8.8494,
"discrimination":363.2015,
"discriminatory":55.7323,
"discs":0.9414,
"discus":9.9791,
"discuss":2656.8874,
"discussing":0.1883,
"discussion":1980.0034,
"disdain":51.2135,
"disease":1892.6392,
"diseased":28.4310,
"disestablish":2.4477,
"disestablishment":5.0837,
"disgrace":119.5609,
"disgraceful":51.5900,
"disgruntled":20.7113,
"disguise":235.9209,
"disguised":7.7197,
"disgust":154.5819,
"disgusted":30.1256,
"disgusting":125.0211,
"dish":549.6035,
"dishonest":63.8286,
"dishonesty":43.8704,
"dishonour":17.3222,
"dishonourable":7.9080,
"dishwasher":44.8118,
"disillusioned":45.7532,
"disinfection":18.6402,
"disintegration":57.9917,
"disinterested":28.4310,
"disjoint":3.9540,
"disjointed":17.6988,
"disk":582.3650,
"diskette":8.8494,
"dislike":316.3185,
"disliked":3.0126,
"disliking":0.5649,
"dislocation":40.6695,
"dismal":73.6194,
"dismantle":130.4814,
"dismantling":22.2176,
"dismay":134.0588,
"dismayed":10.3557,
"dismiss":757.6582,
"dismissal":289.5821,
"dismissing":0.1883,
"dismissive":54.0377,
"dismissively":26.7364,
"disney":3.9540,
"disneyland":1.8828,
"disobedience":40.4812,
"disobey":29.7490,
"disorder":460.5447,
"disordered":8.0962,
"disorderly":31.0670,
"disparate":52.5315,
"disparity":71.7365,
"dispatch":112.0295,
"dispatcher":2.2594,
"dispatches":0.1883,
"dispatching":1.5063,
"dispel":77.3851,
"dispensation":28.9959,
"dispense":136.6948,
"dispenser":31.8201,
"dispensing":6.2134,
"dispersal":65.3348,
"disperse":181.1300,
"dispersed":3.9540,
"dispersion":31.8201,
"displace":152.5107,
"displaced":6.5900,
"displacement":81.7156,
"displacing":0.5649,
"display":1860.6308,
"displaying":3.3891,
"displays":0.1883,
"displease":16.5691,
"displeased":14.3096,
"displeasing":0.7531,
"displeasure":34.2678,
"disposable":74.9374,
"disposal":409.5195,
"dispose":278.8499,
"disposed":23.7239,
"disposing":0.1883,
"disposition":151.1927,
"disproportion":5.0837,
"disproportionate":48.2009,
"disproportionately":43.1172,
"dispute":947.0728,
"disputed":22.0293,
"disqualification":34.4561,
"disqualified":0.3766,
"disqualify":77.5734,
"disregard":147.4270,
"disregarded":3.5774,
"disrespect":21.4645,
"disrespectful":9.2260,
"disrupt":176.0463,
"disrupted":1.8828,
"disruption":169.2681,
"disruptive":69.1005,
"dissatisfaction":103.7449,
"dissatisfied":75.5022,
"dissatisfy":4.5188,
"dissatisfying":0.9414,
"dissection":17.3222,
"disseminate":64.2051,
"dissemination":57.9917,
"dissent":140.8371,
"dissenting":1.5063,
"dissertation":54.2260,
"dissident":121.6320,
"dissimilar":50.0838,
"dissipation":15.8159,
"dissociation":35.3976,
"dissolution":134.8119,
"dissolve":293.7244,
"dissolving":1.1297,
"distal":103.7449,
"distance":1451.4878,
"distanced":3.9540,
"distancing":10.9205,
"distant":506.4862,
"distillation":27.3013,
"distilled":14.3096,
"distinct":564.6662,
"distinction":854.0600,
"distinctive":384.4776,
"distinctively":23.9122,
"distinctly":141.9668,
"distinguish":771.0264,
"distinguishable":39.9164,
"distinguished":195.0631,
"distinguishing":4.1423,
"distort":178.1175,
"distorted":64.3934,
"distorting":1.6946,
"distortion":166.4438,
"distract":149.1216,
"distracted":19.2051,
"distracting":2.0711,
"distraction":93.0127,
"distress":291.8415,
"distressed":91.3181,
"distressing":56.4855,
"distribute":627.7417,
"distributed":0.9414,
"distributing":0.7531,
"distribution":1133.2865,
"distributional":11.1088,
"distributive":17.5105,
"distributor":147.4270,
"distributors":0.7531,
"district":1081.1316,
"distrust":82.4688,
"disturb":405.0007,
"disturbance":272.2599,
"disturbed":69.6654,
"disturbing":152.5107,
"ditch":208.2430,
"ditched":0.1883,
"ditching":2.4477,
"ditto":15.2511,
"diurnal":21.2762,
"diva":7.5314,
"dive":257.5737,
"diver":94.7073,
"divergence":60.0629,
"divergent":43.1172,
"diverse":237.8038,
"diversely":1.1297,
"diversification":68.7240,
"diversified":24.6653,
"diversify":68.5357,
"diversion":121.0672,
"diversity":252.6783,
"divert":220.2933,
"diverting":1.3180,
"divide":1230.6297,
"divided":71.7365,
"dividend":433.9966,
"divider":26.3599,
"dividing":5.2720,
"divination":7.5314,
"divine":231.7786,
"diving":94.3307,
"divinity":32.1967,
"divisible":11.2971,
"division":1353.9563,
"divisional":84.7282,
"divisive":36.1507,
"divisor":6.9665,
"divorce":528.7038,
"divorced":22.9708,
"divulge":27.8662,
"dizziness":16.5691,
"dizzy":55.9206,
"dj":37.2804,
"dna":381.2768,
"do":94854.3259,
"doberman":1.5063,
"doc":12.9917,
"dock":287.6992,
"docked":0.1883,
"docket":4.5188,
"docking":9.9791,
"docs":0.5649,
"doctor":2167.3468,
"doctoral":16.3808,
"doctorate":26.1716,
"doctors":1.8828,
"doctrinal":25.4185,
"doctrine":350.0215,
"document":1904.8777,
"documentary":181.8832,
"documentation":208.8079,
"documented":0.9414,
"documenting":0.5649,
"dod":0.5649,
"dodge":83.5985,
"dodger":11.8619,
"dodging":1.3180,
"dodgy":53.6612,
"doe":18.6402,
"doesn":1.1297,
"dog":2225.9034,
"dogged":0.7531,
"doggy":17.5105,
"dogma":57.8034,
"dogs":1.5063,
"dogwood":3.0126,
"doing":54.4143,
"dole":94.3307,
"doll":174.3518,
"dollar":681.0263,
"dolly":27.4896,
"dolor":0.3766,
"dolphin":248.1594,
"domain":395.0216,
"dome":154.2053,
"domestic":1235.5251,
"domestically":19.5816,
"domesticate":35.3976,
"domesticating":0.1883,
"domicile":47.6361,
"dominance":196.0045,
"dominant":538.3064,
"dominate":858.2023,
"dominating":7.1548,
"domination":158.1593,
"dominatrix":1.5063,
"dominican":9.6025,
"dominion":46.8829,
"domino":24.6653,
"don":89.2470,
"donate":192.0505,
"donating":0.7531,
"donation":239.4983,
"done":19.3933,
"dong":5.6485,
"dongle":1.6946,
"donkey":115.9835,
"donkeys":0.1883,
"donna":0.1883,
"donor":192.4271,
"donors":0.5649,
"dont":1.8828,
"donut":1.5063,
"doodle":14.4979,
"doom":151.7576,
"doomed":19.9582,
"door":5193.4608,
"doors":1.8828,
"doorstep":132.7408,
"doorway":306.5277,
"dopamine":8.6611,
"dope":50.0838,
"doped":0.1883,
"doping":9.4142,
"doppler":5.4603,
"dorian":4.3306,
"dork":0.9414,
"dorm":5.8368,
"dormant":47.8243,
"dormitory":43.4938,
"dorsal":70.4185,
"dos":51.9666,
"dosage":28.4310,
"dose":425.5237,
"dosing":6.5900,
"dossier":24.8536,
"dot":332.8876,
"doth":16.7574,
"dotted":35.7741,
"double":1972.6603,
"doubled":1.1297,
"doubles":0.1883,
"doubling":32.7616,
"doubly":63.2637,
"doubt":2675.7159,
"doubted":0.9414,
"doubtful":215.3979,
"doubting":2.0711,
"doubtless":152.8873,
"doubts":0.1883,
"douche":2.8243,
"dough":56.6737,
"douglas":0.9414,
"dove":55.9206,
"down":16957.6860,
"downed":0.1883,
"downer":6.7783,
"downfall":58.9332,
"downgrade":33.7030,
"downhill":79.6445,
"downing":2.0711,
"download":14.1214,
"downright":48.9541,
"downs":2.4477,
"downside":15.8159,
"downsizing":2.6360,
"downstairs":303.8917,
"downstream":76.2554,
"downtime":3.2008,
"downtown":30.5021,
"downturn":50.2721,
"downward":129.7283,
"downwards":107.3224,
"dozen":660.8798,
"dozens":0.5649,
"dp":8.0962,
"dr":0.5649,
"draco":0.1883,
"dracula":0.3766,
"draft":744.2900,
"drafted":0.3766,
"drafting":61.0043,
"drag":640.7333,
"dragging":3.3891,
"dragon":159.2890,
"dragonfly":21.2762,
"drain":519.6662,
"drainage":173.0338,
"drained":0.1883,
"draining":12.0502,
"drake":15.2511,
"dram":17.6988,
"drama":644.8756,
"dramas":2.4477,
"dramatic":690.8171,
"dramatically":275.0842,
"dramatisation":5.8368,
"dramatise":16.9456,
"dramatised":1.5063,
"dramatising":0.1883,
"dramatist":17.5105,
"dramatization":2.0711,
"dramatize":12.0502,
"dramatized":0.9414,
"drank":13.3682,
"draped":0.1883,
"draper":17.6988,
"drapery":14.3096,
"drastic":121.8203,
"drastically":75.1257,
"draught":117.8663,
"draw":4224.5470,
"drawback":105.0629,
"drawer":281.2976,
"drawing":881.5496,
"drawn":0.7531,
"draws":0.5649,
"drawstring":2.4477,
"dread":175.4815,
"dreaded":24.8536,
"dreadful":244.9586,
"dream":1505.1490,
"dreamed":1.5063,
"dreamer":15.4394,
"dreaming":14.3096,
"dreamland":2.8243,
"dreams":1.8828,
"dreamt":0.3766,
"dreamy":26.1716,
"dreary":50.6486,
"dredge":44.0587,
"dredging":12.2385,
"drenched":3.7657,
"dress":1732.7854,
"dressage":15.0628,
"dressed":88.6822,
"dresser":57.4269,
"dressing":358.6826,
"drew":0.1883,
"dried":4.8954,
"drier":6.0251,
"drift":546.0260,
"drifted":1.3180,
"drifting":2.6360,
"driftwood":13.9331,
"drill":343.9964,
"drilled":1.3180,
"drilling":91.1299,
"drills":0.1883,
"drink":2423.2259,
"drinker":84.1633,
"drinking":273.9544,
"drip":140.2722,
"dripping":56.8620,
"drive":3922.5381,
"driven":4.1423,
"driver":1416.0903,
"driveway":42.7407,
"driving":289.7704,
"drizzle":41.7992,
"drone":54.2260,
"drool":16.0042,
"drooling":1.5063,
"drop":2437.1590,
"droplet":36.1507,
"dropout":5.2720,
"dropped":1.3180,
"dropping":70.4185,
"drops":0.1883,
"drought":130.4814,
"drove":25.2302,
"drown":287.6992,
"drowned":5.0837,
"drowning":8.0962,
"drowns":0.1883,
"drowsiness":9.7908,
"drudge":3.9540,
"drug":1901.3003,
"drugs":4.1423,
"drugstore":2.2594,
"druid":6.4017,
"drum":315.1888,
"drummer":60.4394,
"drumming":20.3348,
"drums":0.3766,
"drunk":377.8877,
"drunken":103.9332,
"dry":1713.9569,
"dryden":0.1883,
"dryer":40.1047,
"drying":35.9624,
"dryly":13.9331,
"dryness":21.2762,
"drywall":0.1883,
"du":4.8954,
"dual":234.7912,
"duality":17.6988,
"dub":114.1006,
"dubious":127.6571,
"duchess":29.3724,
"duck":411.4024,
"ducked":0.1883,
"ducking":5.4603,
"ducky":2.2594,
"duct":75.3139,
"dude":16.1925,
"due":2821.2601,
"duel":46.1298,
"duet":35.9624,
"duff":2.6360,
"duffel":9.2260,
"dug":11.8619,
"duh":1.8828,
"duke":101.2972,
"dull":358.6826,
"duller":0.1883,
"dullness":10.7322,
"duly":170.3978,
"dumb":128.7868,
"dummy":94.1424,
"dump":373.1806,
"dumping":79.8328,
"dumps":0.1883,
"dun":4.8954,
"duncan":0.3766,
"dune":85.2930,
"dung":49.8955,
"dungeon":31.0670,
"dunk":6.0251,
"dunno":228.3895,
"duo":59.8746,
"duplex":23.3473,
"duplicate":111.2763,
"duplicating":0.7531,
"duplication":62.1340,
"duplicator":1.8828,
"dur":0.9414,
"durability":36.7155,
"durable":80.9625,
"duration":312.7411,
"durham":2.8243,
"during":7695.9546,
"dusk":105.2512,
"dust":581.4236,
"duster":22.4059,
"dusting":8.0962,
"dusty":119.7492,
"dutch":323.8499,
"dutchman":2.6360,
"duty":2105.2128,
"duvet":55.1675,
"dwarf":101.8621,
"dwarfs":1.6946,
"dwell":126.1508,
"dwelling":225.3770,
"dwelt":13.9331,
"dwindling":1.5063,
"dy":1.6946,
"dye":156.0881,
"dyed":3.0126,
"dyeing":19.2051,
"dyer":6.7783,
"dyes":2.0711,
"dying":20.3348,
"dylan":0.3766,
"dynamic":395.7747,
"dynamical":16.0042,
"dynamically":13.5565,
"dynamite":19.7699,
"dynamo":12.4268,
"dynasty":78.3265,
"dysfunction":26.5482,
"dysfunctional":11.1088,
"dyslexia":14.6862,
"dystrophy":14.3096,
"e":894.7296,
"ea":6.2134,
"each":10805.4788,
"eager":243.6406,
"eagerly":126.7157,
"eagerness":41.4227,
"eagle":185.2723,
"ear":1056.6545,
"eared":2.2594,
"earl":31.8201,
"earlier":0.5649,
"earliness":0.5649,
"early":9308.2377,
"earn":993.7674,
"earnest":111.2763,
"earnestly":43.4938,
"earning":609.1015,
"earring":71.3600,
"earth":1182.4288,
"earthly":49.5189,
"earthquake":116.3600,
"earthy":25.4185,
"ease":781.7587,
"easel":27.8662,
"easement":17.1339,
"easier":24.4770,
"easiest":9.7908,
"easily":1753.1202,
"easiness":1.8828,
"easing":18.8285,
"east":1045.9223,
"easter":9.2260,
"easterly":21.0879,
"eastern":599.1224,
"eastward":23.3473,
"easy":3775.4876,
"eat":2662.7242,
"eaten":3.3891,
"eater":54.0377,
"eating":140.2722,
"eats":0.1883,
"eavesdropping":7.9080,
"eb":3.3891,
"ebb":72.4897,
"ebony":24.8536,
"ec":10.3557,
"eccentric":114.1006,
"ecclesiastical":126.7157,
"ecg":0.7531,
"echelon":25.6067,
"echo":504.0385,
"echoed":0.1883,
"echoing":1.3180,
"eclectic":27.8662,
"eclipse":77.9499,
"ecological":122.9500,
"ecologically":24.8536,
"ecology":84.9165,
"econometric":35.2093,
"econometrics":0.1883,
"economic":4214.0030,
"economical":87.5525,
"economically":180.5652,
"economics":13.9331,
"economist":245.5234,
"economy":2111.6145,
"ecosystem":42.1758,
"ecstasy":74.7491,
"ecstatic":45.0001,
"ectopic":7.7197,
"ecuador":0.3766,
"ecuadorian":5.4603,
"ecumenical":48.2009,
"eczema":18.0753,
"ed":114.8538,
"eddy":30.3139,
"edema":0.5649,
"eden":1.1297,
"edgar":0.5649,
"edge":1807.1579,
"edged":3.9540,
"edging":23.3473,
"edgy":21.8410,
"edible":38.2218,
"edinburgh":0.1883,
"edit":306.3394,
"editable":1.5063,
"edited":0.5649,
"editing":96.2136,
"edition":507.9925,
"editor":627.5534,
"editorial":193.9334,
"editors":1.5063,
"eds":5.6485,
"educate":494.0594,
"educated":20.8996,
"educating":1.3180,
"education":3555.3827,
"educational":975.3155,
"educator":46.3181,
"edward":3.5774,
"edwardian":52.9080,
"ee":26.5482,
"eec":1.5063,
"eeg":0.7531,
"eek":0.5649,
"eel":61.9457,
"eerie":53.0963,
"eff":3.9540,
"effect":6284.0066,
"effected":0.5649,
"effective":1842.7437,
"effectively":904.8969,
"effectiveness":391.0676,
"effector":12.4268,
"efficacy":93.2010,
"efficiency":674.2480,
"efficient":744.6665,
"efficiently":199.7702,
"effluent":65.8997,
"effort":2368.9999,
"effortless":29.9373,
"effortlessly":42.1758,
"eft":0.7531,
"egg":1109.3743,
"eggplant":0.9414,
"eggs":1.6946,
"ego":208.6196,
"egos":1.1297,
"egregious":6.2134,
"egress":3.7657,
"egyptian":173.2221,
"eh":388.2433,
"eigenvalue":41.2344,
"eight":3357.6836,
"eighteen":536.8001,
"eighteenth":487.2812,
"eighth":197.6991,
"eightieth":7.1548,
"eighty":888.5162,
"einstein":0.3766,
"eire":2.6360,
"either":4873.3766,
"ejaculate":10.1674,
"ejaculating":0.1883,
"ejaculation":17.3222,
"eject":58.5566,
"ejection":16.5691,
"el":0.7531,
"elaborate":357.7412,
"elaboration":59.6863,
"elan":1.5063,
"elastic":110.3349,
"elasticity":66.0880,
"elbow":289.0172,
"elder":153.2639,
"elderly":891.5287,
"eldest":0.5649,
"elect":1161.9058,
"elected":0.3766,
"electing":0.3766,
"election":2841.9714,
"elective":50.4603,
"elector":81.5273,
"electoral":362.6366,
"electorate":205.4188,
"electors":0.3766,
"electra":0.5649,
"electric":561.2771,
"electrical":369.6031,
"electrically":37.4687,
"electrician":50.4603,
"electricity":608.9132,
"electrified":2.4477,
"electrochemical":7.9080,
"electrode":58.3683,
"electrolyte":33.7030,
"electromagnetic":58.1800,
"electron":296.5486,
"electronic":727.9092,
"electronically":45.3766,
"electronics":18.2636,
"electrophoresis":20.5230,
"electrostatic":21.2762,
"elegance":85.4813,
"elegant":309.7286,
"elegantly":45.0001,
"element":2139.1041,
"elemental":44.2469,
"elementary":116.1717,
"elephant":252.8665,
"elevate":76.8202,
"elevated":50.0838,
"elevation":94.5190,
"elevator":44.8118,
"eleven":652.9718,
"elevens":0.1883,
"eleventh":122.9500,
"elf":32.1967,
"elgar":0.1883,
"elicit":102.6152,
"elicited":0.1883,
"eligibility":49.3306,
"eligible":237.0506,
"eliminate":438.1388,
"elimination":96.9667,
"eliminator":6.4017,
"elisa":2.0711,
"elite":290.9001,
"elitist":36.9038,
"elixir":9.6025,
"elizabeth":1.3180,
"elizabethan":1.1297,
"elk":3.2008,
"ell":9.7908,
"ellipse":14.6862,
"elliptic":3.3891,
"elliptical":19.9582,
"elm":36.5273,
"elongated":41.7992,
"elongation":15.0628,
"eloquence":20.7113,
"eloquent":54.2260,
"eloquently":19.7699,
"else":3554.8178,
"elsewhere":1007.1356,
"elucidate":42.1758,
"elusive":110.5232,
"elvis":0.1883,
"em":85.2930,
"email":7.1548,
"emanating":0.3766,
"emancipation":73.2428,
"embankment":60.2511,
"embargo":76.4436,
"embark":242.3226,
"embarked":0.1883,
"embarrass":86.2345,
"embarrassed":225.5652,
"embarrassing":174.7283,
"embarrassment":234.6029,
"embassy":177.3643,
"embed":166.8204,
"embedded":0.7531,
"embedding":9.6025,
"embellished":1.6946,
"ember":25.2302,
"emblem":48.3892,
"embodied":0.9414,
"embodiment":39.5398,
"embody":214.2681,
"embossed":4.1423,
"embrace":389.5613,
"embraces":0.1883,
"embracing":3.2008,
"embroidered":2.0711,
"embroidery":53.2846,
"embryo":162.3015,
"embryonic":49.3306,
"emerald":25.7950,
"emerge":1501.3833,
"emerged":0.5649,
"emergence":229.7075,
"emergency":723.0138,
"emergent":26.3599,
"emerging":2.4477,
"emeritus":5.2720,
"emery":3.9540,
"emf":0.7531,
"emigration":59.8746,
"eminent":111.0881,
"eminently":45.9415,
"emir":7.3431,
"emission":380.1471,
"emit":124.8329,
"emitted":0.5649,
"emitter":14.3096,
"emitting":0.3766,
"emo":1.3180,
"emotion":614.5617,
"emotional":655.4195,
"emotionally":127.2806,
"empathy":48.7658,
"emperor":154.3936,
"emphasis":983.7883,
"emphasise":560.5240,
"emphasising":0.1883,
"emphasize":365.2726,
"emphasizing":0.3766,
"emphatic":49.7072,
"emphatically":49.8955,
"emphysema":8.6611,
"empire":349.8332,
"empirical":273.0130,
"empirically":36.3390,
"empiricism":20.5230,
"employ":1591.3835,
"employed":2.0711,
"employee":1604.3751,
"employer":1316.6759,
"employing":0.1883,
"employment":1740.3168,
"employs":0.1883,
"emporium":8.8494,
"empower":107.3224,
"empowered":0.5649,
"empowering":0.9414,
"empowerment":30.6904,
"empress":6.4017,
"emptiness":57.8034,
"empty":1165.4832,
"emptying":18.2636,
"emu":15.4394,
"emulate":88.8704,
"emulation":46.3181,
"emulator":13.9331,
"emulsion":27.3013,
"en":170.3978,
"enable":1824.6684,
"enabled":0.5649,
"enables":0.3766,
"enabling":1.8828,
"enact":154.7701,
"enactment":68.1591,
"enamel":68.5357,
"encapsulation":4.1423,
"encephalitis":5.0837,
"enchanted":23.3473,
"enchanting":31.6319,
"enchantment":32.3850,
"enclave":59.4980,
"enclose":381.6534,
"enclosed":1.8828,
"enclosing":2.0711,
"enclosure":141.5902,
"enclosures":0.3766,
"encode":103.9332,
"encoder":7.7197,
"encoding":20.8996,
"encompass":163.4312,
"encompassing":0.9414,
"encore":23.3473,
"encounter":735.8172,
"encountering":0.1883,
"encourage":2208.7695,
"encouraged":12.2385,
"encouragement":266.2348,
"encouraging":199.7702,
"encouragingly":22.0293,
"encroachment":35.2093,
"encrypt":3.9540,
"encrypted":0.9414,
"encryption":5.6485,
"encyclopedia":13.9331,
"end":10918.2614,
"endanger":111.8412,
"endangered":18.4519,
"endangering":0.1883,
"endearing":17.1339,
"endeavor":1.8828,
"endeavour":224.8121,
"ended":10.5440,
"endemic":56.4855,
"ending":165.8789,
"endings":0.1883,
"endless":277.9084,
"endlessly":69.4771,
"endocrine":22.4059,
"endocrinology":1.5063,
"endogenous":33.5147,
"endorse":294.6658,
"endorsement":107.1341,
"endoscopic":86.6110,
"endoscopy":62.6989,
"endowed":11.2971,
"endowment":105.0629,
"endpoint":6.2134,
"endurance":51.7783,
"endure":240.8163,
"endured":0.3766,
"enduring":26.5482,
"ene":0.1883,
"enema":32.9498,
"enemy":822.9930,
"energetic":130.8580,
"energetically":22.9708,
"energized":1.3180,
"energizer":0.1883,
"energy":2129.6898,
"enforce":425.7120,
"enforceable":48.3892,
"enforced":0.3766,
"enforcement":231.4021,
"enforcing":0.7531,
"engage":804.7294,
"engaged":30.5021,
"engagement":272.0716,
"engaging":19.7699,
"engine":1251.1528,
"engineer":759.3528,
"engineered":0.3766,
"engineering":650.9007,
"england":13.7448,
"english":1775.1495,
"englishman":60.6277,
"engraved":1.6946,
"engraving":38.9750,
"engrossed":16.0042,
"engulfed":0.1883,
"enhance":648.4530,
"enhanced":68.5357,
"enhancement":105.6278,
"enhancer":14.6862,
"enhances":1.3180,
"enhancing":3.5774,
"enigma":28.8076,
"enigmatic":46.1298,
"enjoy":2567.2638,
"enjoyable":164.7492,
"enjoyed":6.5900,
"enjoying":0.1883,
"enjoyment":185.4606,
"enjoys":0.1883,
"enlarge":179.0589,
"enlarged":30.1256,
"enlargement":47.2595,
"enlarging":0.7531,
"enlighten":65.5231,
"enlightened":47.8243,
"enlightening":16.0042,
"enlightenment":33.7030,
"enlist":92.4479,
"enlisted":0.3766,
"enormity":23.9122,
"enormous":738.0766,
"enormously":147.6153,
"enough":5650.6164,
"enquire":253.9963,
"enquirer":13.1799,
"enquiring":0.3766,
"enquiry":571.0679,
"enraged":16.0042,
"enrich":102.6152,
"enriched":11.8619,
"enriching":3.5774,
"enrichment":46.5064,
"enrol":94.1424,
"enroll":1.1297,
"enrolled":0.1883,
"enrolling":0.7531,
"enrollment":1.1297,
"enrolment":61.7574,
"ensemble":72.4897,
"ensign":12.0502,
"enslaved":3.2008,
"ensue":161.3601,
"ensuing":0.1883,
"ensure":2539.5859,
"ensured":0.3766,
"ensuring":0.9414,
"entail":241.1929,
"entailed":0.7531,
"entangled":13.9331,
"entanglement":16.9456,
"enter":2504.5650,
"entered":0.3766,
"entering":2.0711,
"enterprise":864.4157,
"enterprising":42.3641,
"entertain":262.8456,
"entertained":0.5649,
"entertainer":41.0461,
"entertaining":132.1760,
"entertainment":375.2517,
"enthusiasm":543.0135,
"enthusiast":183.7660,
"enthusiastic":261.9042,
"enthusiastically":80.5859,
"entice":49.7072,
"enticing":18.8285,
"entire":838.9973,
"entirely":1211.0481,
"entirety":40.6695,
"entitle":881.1731,
"entitled":25.6067,
"entitlement":148.1802,
"entity":330.0633,
"entomology":2.6360,
"entourage":39.1632,
"entrance":594.6035,
"entrant":112.4061,
"entrenched":44.4352,
"entrepreneur":132.9291,
"entrepreneurial":71.7365,
"entrepreneurship":17.3222,
"entropy":44.0587,
"entrust":92.6361,
"entry":1250.5879,
"enumerate":22.4059,
"enumeration":17.6988,
"envelope":303.5152,
"enviable":27.8662,
"envied":0.1883,
"envious":33.3264,
"environ":19.9582,
"environment":2065.2964,
"environmental":1275.0649,
"environmentalist":118.9960,
"environmentally":122.1969,
"environs":0.3766,
"envisage":330.4399,
"envisaged":0.3766,
"envision":7.3431,
"envoy":75.6905,
"envy":166.6321,
"enzymatic":12.4268,
"enzyme":220.2933,
"enzymes":0.5649,
"epa":0.1883,
"ephedrine":1.5063,
"ephemera":8.2845,
"ephemeral":25.9833,
"epi":1.8828,
"epic":108.4521,
"epidemic":116.7366,
"epidemiological":33.3264,
"epidemiology":20.7113,
"epidermal":14.3096,
"epidermis":13.9331,
"epidural":13.1799,
"epilepsy":32.9498,
"epilogue":8.4728,
"epiphany":6.0251,
"episcopal":33.3264,
"episode":369.6031,
"episodic":10.1674,
"epistemology":28.6193,
"epistle":11.1088,
"epithelial":79.6445,
"epithelium":54.0377,
"epitome":31.4436,
"epoch":38.4101,
"epoxy":12.6151,
"epsilon":28.4310,
"equal":1298.7888,
"equality":254.5611,
"equalization":6.4017,
"equalizer":4.1423,
"equalled":0.3766,
"equalling":0.3766,
"equally":1177.9100,
"equals":0.1883,
"equate":127.0923,
"equating":0.9414,
"equation":615.8797,
"equator":28.8076,
"equatorial":16.3808,
"equestrian":15.0628,
"equilibrium":296.7369,
"equine":13.5565,
"equinox":4.5188,
"equip":372.2391,
"equipment":1492.5339,
"equipped":32.5733,
"equipping":2.8243,
"equitable":87.7407,
"equity":372.4274,
"equivalence":58.1800,
"equivalency":0.1883,
"equivalent":839.7504,
"equivalently":3.9540,
"er":15739.4831,
"era":389.1848,
"eradicate":83.7868,
"eradication":43.3055,
"eras":0.1883,
"erase":65.5231,
"eraser":5.4603,
"erasmus":3.7657,
"ere":42.5524,
"erect":314.2474,
"erected":0.1883,
"erectile":0.9414,
"erection":64.3934,
"ergo":0.1883,
"ergonomic":18.4519,
"ergonomics":0.3766,
"erode":124.2680,
"eroded":5.8368,
"eros":0.5649,
"erosion":195.8162,
"erotic":80.5859,
"erotica":3.7657,
"err":40.6695,
"errata":0.7531,
"erratic":72.1131,
"erroneous":41.4227,
"erroneously":15.4394,
"error":981.3406,
"errors":3.0126,
"erupted":0.7531,
"eruption":133.1174,
"es":2.0711,
"escalate":95.4604,
"escalated":0.1883,
"escalation":37.0921,
"escape":1343.0358,
"escaped":4.1423,
"escaping":10.3557,
"escherichia":0.1883,
"escort":207.8665,
"escrow":3.0126,
"escudo":7.9080,
"ese":0.1883,
"eskimo":3.7657,
"esophageal":1.6946,
"esophagus":1.1297,
"esoteric":39.7281,
"esp":6.2134,
"especial":23.1590,
"especially":3142.4740,
"esperanto":0.3766,
"espionage":43.6821,
"esplanade":5.0837,
"espresso":4.3306,
"esprit":0.7531,
"esq":0.1883,
"esquire":9.0377,
"essay":392.3856,
"essen":0.3766,
"essence":342.1136,
"essential":1632.9944,
"essentially":643.1810,
"essex":3.3891,
"est":0.9414,
"esta":0.3766,
"establish":3635.0272,
"established":25.0419,
"establishing":6.4017,
"establishment":826.9470,
"estate":1159.0815,
"esteem":159.4773,
"esteemed":15.0628,
"ester":15.2511,
"esther":0.3766,
"estimate":1769.6892,
"estimated":15.4394,
"estimating":6.2134,
"estimation":70.7951,
"estimator":14.4979,
"estonian":19.9582,
"estranged":39.1632,
"estrogen":0.1883,
"estuarine":5.8368,
"estuary":110.1466,
"et":15.2511,
"eta":5.2720,
"etc":13.7448,
"etch":78.3265,
"etched":4.3306,
"etching":27.1130,
"eternal":142.9082,
"eternally":20.5230,
"eternity":72.3014,
"ethanol":71.1717,
"ether":27.8662,
"ethereal":17.8871,
"ethernet":32.1967,
"ethic":172.4689,
"ethical":199.0171,
"ethically":11.1088,
"ethiopia":0.5649,
"ethiopian":34.6444,
"ethnic":437.9505,
"ethnically":16.3808,
"ethnicity":46.8829,
"ethnographic":35.9624,
"ethos":77.0085,
"ethyl":7.5314,
"ethylene":16.0042,
"etiology":1.8828,
"etiquette":33.7030,
"etna":0.7531,
"eucalyptus":15.0628,
"eucharist":17.3222,
"euclidean":8.2845,
"euphoria":42.5524,
"eurasian":6.5900,
"euro":47.6361,
"europa":0.3766,
"europe":4.1423,
"european":2111.4262,
"euthanasia":22.7825,
"ev":11.1088,
"evacuate":109.0169,
"evacuation":79.8328,
"evade":94.1424,
"evaluate":452.6368,
"evaluated":0.1883,
"evaluating":1.1297,
"evaluation":549.9800,
"evaluative":26.3599,
"evaluator":13.5565,
"evanescence":0.7531,
"evangelical":76.8202,
"evangelism":26.5482,
"evangelist":30.3139,
"evaporate":90.1884,
"evaporated":1.1297,
"evaporation":32.0084,
"evasion":52.7198,
"eve":98.8495,
"even":16018.8978,
"evening":2437.3473,
"evenly":127.4688,
"event":3699.2323,
"events":0.1883,
"eventual":184.3309,
"eventuality":33.5147,
"eventually":1610.9651,
"ever":5078.2305,
"everest":1.1297,
"evergreen":40.4812,
"everlasting":20.8996,
"every":7103.2339,
"everybody":1067.0102,
"everyday":369.7914,
"everyman":2.0711,
"everyone":2337.5563,
"everything":3236.0516,
"everywhere":563.7248,
"eviction":46.8829,
"evidence":3800.3412,
"evident":511.3816,
"evidential":16.0042,
"evidently":266.9879,
"evil":536.2352,
"evilly":3.0126,
"evilness":0.1883,
"evocative":34.4561,
"evoke":184.3309,
"evoked":0.1883,
"evokes":0.1883,
"evolution":438.1388,
"evolutionary":196.5694,
"evolutionist":15.0628,
"evolve":403.1178,
"evolved":3.9540,
"ex":648.0764,
"exacerbate":115.4186,
"exact":454.3313,
"exacting":3.9540,
"exactly":1776.2792,
"exaggerated":122.7617,
"exaggeration":64.7700,
"exalted":18.0753,
"exam":286.3812,
"examination":1098.4538,
"examine":1744.8356,
"examined":0.3766,
"examiner":76.8202,
"examining":1.6946,
"example":7581.2892,
"examples":3.3891,
"excavated":0.1883,
"excavating":0.3766,
"excavation":150.2513,
"exceed":532.2812,
"exceedingly":72.1131,
"excel":58.5566,
"excellence":116.1717,
"excellency":7.7197,
"excellent":1168.6840,
"excelsior":1.1297,
"except":1849.5220,
"exception":772.3444,
"exceptional":309.5403,
"exceptionally":163.2430,
"excerpt":27.3013,
"excess":558.2646,
"excessive":313.4943,
"excessively":70.0420,
"exchange":1743.1411,
"exchanger":12.0502,
"exchanging":1.5063,
"exchequer":13.7448,
"excise":87.3642,
"excision":12.9917,
"excitation":64.2051,
"excite":118.8077,
"excited":272.2599,
"excitedly":51.4018,
"excitement":461.6744,
"exciting":586.1307,
"exclamation":44.2469,
"exclude":927.3028,
"excluded":0.1883,
"exclusion":279.7913,
"exclusionary":7.7197,
"exclusionist":1.8828,
"exclusive":372.6157,
"exclusively":294.6658,
"exclusivity":19.5816,
"excretion":48.9541,
"excursion":139.1425,
"excuse":662.5744,
"excused":0.3766,
"exec":9.4142,
"executable":8.0962,
"execute":332.5110,
"executing":0.5649,
"execution":269.2473,
"executive":1321.5713,
"executor":50.0838,
"exemplary":44.8118,
"exempt":183.3894,
"exemption":228.7661,
"exercisable":16.5691,
"exercise":2203.3092,
"exercised":0.3766,
"exercising":4.7071,
"exert":219.5401,
"exertion":42.9289,
"exhaust":258.3268,
"exhausted":124.0797,
"exhausting":39.1632,
"exhaustion":88.3056,
"exhaustive":61.0043,
"exhibit":413.8501,
"exhibiting":0.1883,
"exhibition":1037.2612,
"exhibitionism":4.7071,
"exhibitionist":6.7783,
"exhibitor":37.8453,
"exhilarating":31.8201,
"exile":280.9210,
"exiled":1.5063,
"exist":3719.1905,
"existed":0.3766,
"existence":1187.8891,
"existent":102.4270,
"existential":38.5984,
"existing":44.4352,
"exists":0.1883,
"exit":272.8247,
"exited":0.1883,
"exiting":1.1297,
"exodus":40.4812,
"exogenous":24.8536,
"exorcism":13.3682,
"exorcist":4.1423,
"exotic":203.7242,
"expand":977.0100,
"expandable":10.7322,
"expanded":3.3891,
"expander":2.2594,
"expanding":1.6946,
"expanse":71.7365,
"expansion":647.8881,
"expansionism":7.7197,
"expansive":34.4561,
"expat":4.3306,
"expatriate":67.2177,
"expect":5433.1474,
"expectancy":96.7784,
"expectant":29.5607,
"expectation":825.6290,
"expected":33.5147,
"expecting":0.1883,
"expedient":54.9792,
"expedite":14.4979,
"expedited":0.1883,
"expedition":242.3226,
"expeditionary":5.0837,
"expeditiously":6.2134,
"expel":154.9584,
"expend":60.2511,
"expended":0.1883,
"expenditure":988.4954,
"expense":828.8299,
"expensive":1053.8303,
"experience":5274.9881,
"experienced":357.3646,
"experiences":0.5649,
"experiencing":3.7657,
"experiential":25.9833,
"experiment":1150.9852,
"experimental":407.6367,
"experimentally":49.7072,
"experimentation":65.1466,
"experimenting":1.3180,
"expert":1318.1822,
"expertise":468.2644,
"expertly":34.0796,
"experts":0.3766,
"expiration":12.8034,
"expire":135.5651,
"expired":2.8243,
"expiring":0.5649,
"expiry":54.9792,
"explain":3383.4786,
"explained":0.1883,
"explaining":11.1088,
"explains":0.5649,
"explanation":1129.1442,
"explanatory":122.5734,
"explicit":337.4064,
"explicitly":226.3184,
"explode":305.9629,
"exploded":1.5063,
"exploding":0.5649,
"exploit":535.4821,
"exploitation":236.1092,
"exploited":0.7531,
"exploiting":0.1883,
"exploration":277.7201,
"exploratory":54.7909,
"explore":873.4534,
"explored":0.1883,
"explorer":57.2386,
"exploring":1.5063,
"explosion":385.0425,
"explosive":217.0924,
"expo":6.5900,
"exponent":67.4060,
"exponential":19.2051,
"exponentially":9.6025,
"export":1053.0771,
"exporter":115.2303,
"exporting":9.4142,
"exports":1.5063,
"expose":678.7669,
"exposed":7.7197,
"exposing":0.1883,
"exposition":59.8746,
"exposure":460.1682,
"express":2333.4140,
"expressed":0.1883,
"expression":1551.8437,
"expressive":90.5650,
"expressly":102.4270,
"expressway":4.8954,
"expulsion":76.6319,
"exquisite":93.0127,
"exquisitely":27.4896,
"extant":39.1632,
"extend":1711.5092,
"extended":259.8331,
"extender":2.0711,
"extending":0.5649,
"extensible":2.8243,
"extension":719.0598,
"extensive":734.6875,
"extensively":158.3476,
"extent":1772.5135,
"exterior":125.9626,
"extermination":12.8034,
"external":846.1521,
"externalisation":1.3180,
"externalise":1.3180,
"externalised":0.3766,
"externalising":0.3766,
"externality":36.3390,
"externalization":7.7197,
"externalize":6.0251,
"externalized":0.5649,
"externally":58.3683,
"extinct":80.2093,
"extinction":111.6529,
"extinguish":60.8160,
"extinguisher":19.0168,
"extortion":19.9582,
"extra":1873.4342,
"extracellular":23.9122,
"extract":567.8671,
"extracting":0.5649,
"extraction":105.2512,
"extractor":14.4979,
"extracurricular":2.4477,
"extradition":52.3432,
"extraneous":18.0753,
"extraordinarily":99.0378,
"extraordinary":501.5908,
"extrapolation":25.0419,
"extravagant":82.8453,
"extravaganza":23.9122,
"extreme":754.0808,
"extremely":1209.1653,
"extremism":17.3222,
"extremist":74.9374,
"extremity":39.1632,
"extrinsic":17.5105,
"extruded":3.9540,
"extrusion":8.6611,
"exuberant":35.2093,
"eye":6801.9782,
"eyebrow":222.7410,
"eyed":227.4481,
"eyelid":86.2345,
"eyepiece":6.9665,
"eyes":7.9080,
"eyesight":43.6821,
"eyewitness":24.8536,
"eyre":5.2720,
"f":76.6319,
"fa":19.9582,
"fab":9.7908,
"fabian":10.1674,
"fable":30.6904,
"fabric":501.4025,
"fabricate":37.6570,
"fabricated":1.3180,
"fabricating":0.3766,
"fabrication":35.5858,
"fabulous":117.4897,
"facade":57.6152,
"face":8562.8180,
"faced":80.2093,
"faceplate":5.6485,
"faces":4.1423,
"facet":97.5315,
"faceted":23.3473,
"facial":101.1090,
"facilitate":317.2600,
"facilitated":1.3180,
"facilitating":2.0711,
"facilitation":7.7197,
"facilitator":26.5482,
"facility":1689.4799,
"facing":15.6276,
"facsimile":47.4478,
"fact":7560.3895,
"faction":253.0548,
"factor":2661.7828,
"factored":0.1883,
"factoring":14.6862,
"factors":4.1423,
"factory":1072.0939,
"factual":138.7659,
"faculty":168.7032,
"fad":28.9959,
"fade":413.6618,
"faded":27.3013,
"fading":8.8494,
"faerie":0.7531,
"fag":61.1926,
"fahrenheit":3.5774,
"fail":2939.1264,
"failed":12.9917,
"failing":58.9332,
"fails":0.3766,
"failure":1567.2830,
"failures":0.1883,
"faint":387.8668,
"fainted":0.3766,
"fainter":16.1925,
"fainting":8.6611,
"faintly":128.9751,
"faintness":3.2008,
"fair":1504.0193,
"fairer":0.5649,
"fairest":0.3766,
"fairly":1185.0648,
"fairness":127.2806,
"fairs":0.1883,
"fairway":46.6946,
"fairy":167.1969,
"fairytale":17.8871,
"faith":889.2693,
"faithful":168.3266,
"faithfully":52.7198,
"faithfulness":10.7322,
"faithless":8.4728,
"fake":147.2387,
"faked":0.1883,
"fakes":0.1883,
"falcon":25.2302,
"falconer":5.4603,
"fall":5760.9513,
"fallacy":39.3515,
"fallback":1.8828,
"fallen":25.4185,
"falling":5.8368,
"fallout":15.6276,
"falls":0.1883,
"false":650.3358,
"falsehood":26.3599,
"falsely":39.9164,
"fame":219.5401,
"famed":16.0042,
"familial":50.6486,
"familiar":1027.2821,
"familiarity":96.0253,
"familiarize":9.6025,
"familiarly":9.7908,
"family":7289.0711,
"famine":118.2429,
"famous":1149.1024,
"famously":21.4645,
"fan":951.2150,
"fanatic":55.5440,
"fanatical":30.3139,
"fancied":3.2008,
"fancier":2.6360,
"fanciful":40.2930,
"fancily":0.3766,
"fanciness":0.1883,
"fancy":509.6871,
"fancying":0.3766,
"fandango":1.6946,
"fanfare":14.6862,
"fang":22.9708,
"fanned":0.9414,
"fanning":1.1297,
"fanny":8.4728,
"fantasia":3.3891,
"fantasies":0.1883,
"fantastic":197.3225,
"fantasy":307.8457,
"far":9725.2887,
"farce":57.6152,
"fare":352.8458,
"farewell":125.3977,
"farm":1369.2074,
"farmed":6.4017,
"farmer":1218.0146,
"farmers":0.1883,
"farmhouse":131.7994,
"farming":390.6910,
"farmland":66.8411,
"faro":0.9414,
"fart":42.1758,
"farther":4.8954,
"farthest":2.4477,
"fascia":12.6151,
"fascinated":62.3223,
"fascinating":291.6532,
"fascination":118.0546,
"fascism":95.4604,
"fascist":174.9166,
"fashion":918.4535,
"fashionable":206.1719,
"fashioned":271.3185,
"fashioning":1.6946,
"fast":2180.3385,
"fasten":118.9960,
"fastener":15.8159,
"fastening":20.8996,
"faster":2.0711,
"fasting":12.9917,
"fastness":6.7783,
"fat":874.7714,
"fatal":242.3226,
"fatality":35.5858,
"fatally":31.8201,
"fate":433.2434,
"fated":0.3766,
"fateful":33.7030,
"father":3841.7639,
"fathom":41.9875,
"fatigue":101.2972,
"fatten":41.0461,
"fatty":94.5190,
"faucet":1.8828,
"fault":802.0934,
"faulty":93.3893,
"fauna":74.3725,
"faust":0.5649,
"fave":6.4017,
"favor":11.1088,
"favorable":1.8828,
"favorably":0.5649,
"favorite":4.1423,
"favour":1725.0657,
"favourable":262.4691,
"favourably":79.4562,
"favoured":18.8285,
"favouring":1.6946,
"favourite":970.4201,
"fawn":26.1716,
"fax":228.7661,
"faxed":1.8828,
"faxing":2.8243,
"fay":0.3766,
"fbi":0.1883,
"fe":4.7071,
"fear":2650.4857,
"feared":6.9665,
"fearful":128.2220,
"fearing":0.5649,
"fearless":24.6653,
"feasibility":84.1633,
"feasible":150.6279,
"feast":156.8413,
"feasting":11.8619,
"feat":95.2721,
"feather":262.0925,
"feathered":0.7531,
"feathering":2.4477,
"feature":3051.9090,
"features":5.2720,
"featuring":0.9414,
"feb":0.7531,
"february":4.3306,
"fecal":0.3766,
"fed":11.4854,
"federal":422.3229,
"federalism":26.3599,
"federalist":21.0879,
"federally":9.2260,
"federated":0.3766,
"federation":88.8704,
"fedora":3.9540,
"fee":1036.1315,
"feeble":81.3391,
"feed":1468.4335,
"feedback":235.5443,
"feeder":68.3474,
"feeding":168.7032,
"feeds":0.3766,
"feel":10861.0228,
"feeling":2260.9244,
"feels":7.9080,
"fees":6.0251,
"feet":8.6611,
"felicity":11.2971,
"feline":29.5607,
"fell":106.9458,
"fella":50.2721,
"fellow":874.3948,
"fellowship":74.1842,
"felony":15.6276,
"felt":126.9040,
"fem":0.9414,
"female":1597.7852,
"females":0.7531,
"feminine":153.6404,
"feminism":120.8789,
"feminist":467.8878,
"femoral":3.0126,
"fen":18.8285,
"fence":461.2979,
"fenced":0.1883,
"fencing":61.0043,
"fend":53.2846,
"fender":52.7198,
"fer":3.5774,
"feral":21.6528,
"fermentation":34.6444,
"fermented":0.5649,
"fermi":0.5649,
"fern":74.5608,
"ferocious":57.9917,
"ferret":106.0044,
"ferrous":15.6276,
"ferry":255.5025,
"fertile":112.0295,
"fertiliser":92.4479,
"fertility":214.2681,
"fertilization":25.4185,
"fertilized":1.5063,
"fertilizer":61.1926,
"fervent":31.6319,
"fest":2.2594,
"festival":329.3102,
"festive":71.5482,
"fetal":59.1214,
"fetch":335.1470,
"fetched":6.5900,
"fetching":4.7071,
"fetish":18.6402,
"fetus":31.8201,
"feud":56.1089,
"feudal":111.2763,
"fever":199.0171,
"feverish":29.1842,
"few":8457.1902,
"fewer":4.1423,
"fey":1.6946,
"ff":9.7908,
"fiance":15.0628,
"fiancee":12.9917,
"fiasco":42.5524,
"fiat":13.5565,
"fiber":1.3180,
"fibre":461.8627,
"fibrillation":6.2134,
"fibroblast":17.8871,
"fibrosis":48.7658,
"fibrous":22.2176,
"fiction":378.2642,
"fictional":87.1759,
"fictitious":30.8787,
"fiddle":133.8705,
"fiddler":10.5440,
"fiddling":7.9080,
"fidelity":31.2553,
"fiduciary":53.0963,
"field":3471.5959,
"fielded":0.1883,
"fielder":17.6988,
"fielding":19.0168,
"fieldwork":54.4143,
"fiend":24.1005,
"fierce":289.3938,
"fiercely":151.0044,
"fierceness":6.9665,
"fiercer":11.1088,
"fiercest":0.5649,
"fiery":80.2093,
"fiesta":5.4603,
"fife":2.0711,
"fifo":1.3180,
"fifteen":940.6711,
"fifteenth":158.3476,
"fifth":664.0806,
"fifthly":6.7783,
"fifties":0.1883,
"fiftieth":19.2051,
"fifty":1805.8399,
"fig":293.7244,
"fight":2498.9164,
"fighter":276.5904,
"fighting":400.8584,
"fights":0.3766,
"figs":2.2594,
"figurative":23.3473,
"figure":5085.7619,
"figured":2.2594,
"figures":7.3431,
"figurine":21.4645,
"figuring":0.7531,
"filament":30.8787,
"file":1715.2749,
"filed":0.1883,
"filer":1.8828,
"files":0.1883,
"filibuster":4.3306,
"filing":94.1424,
"filipino":5.2720,
"fill":2112.3676,
"filled":0.3766,
"filler":49.1423,
"fillet":41.6110,
"filling":96.4018,
"film":2556.5316,
"filmed":3.2008,
"filming":42.9289,
"filmmaker":29.5607,
"films":0.3766,
"filmstrip":2.2594,
"filmy":5.0837,
"filter":512.6996,
"filtering":18.6402,
"filth":48.2009,
"filthy":120.1257,
"filtration":77.0085,
"fin":114.2889,
"final":3029.8797,
"finale":53.6612,
"finalise":75.8788,
"finalised":0.5649,
"finalising":0.3766,
"finalist":68.5357,
"finality":23.5356,
"finalize":24.4770,
"finally":2261.1127,
"finals":1.3180,
"finance":1310.2742,
"financed":0.5649,
"finances":0.5649,
"financial":2612.6405,
"financially":158.3476,
"financier":48.9541,
"financing":164.5610,
"finch":18.4519,
"find":17590.6996,
"finder":19.5816,
"finding":801.3403,
"finds":0.7531,
"fine":2884.9003,
"finely":121.2554,
"fineness":8.6611,
"finer":3.2008,
"fines":0.1883,
"finesse":24.2887,
"finest":0.1883,
"finger":1636.5718,
"fingered":8.8494,
"fingering":9.6025,
"fingerprint":49.8955,
"fingerprinting":7.1548,
"fingertips":53.0963,
"finish":2466.5314,
"finished":141.2136,
"finishes":0.3766,
"finishing":65.3348,
"finite":119.3726,
"finitely":2.4477,
"fink":10.9205,
"finn":0.3766,
"finnish":34.6444,
"fir":36.7155,
"fire":3161.1142,
"firearm":78.8913,
"fireball":14.8745,
"firebox":4.3306,
"fired":3.5774,
"firefighter":30.1256,
"firefighting":4.3306,
"firefly":15.8159,
"firehouse":0.5649,
"fireman":125.5860,
"fireplace":139.5191,
"firepower":15.2511,
"fires":1.3180,
"fireside":16.9456,
"firewall":1.5063,
"firewood":34.6444,
"fireworks":0.9414,
"firing":64.5817,
"firm":3623.3535,
"firmer":1.3180,
"firmly":694.0179,
"firmness":27.1130,
"firmware":3.5774,
"first":21610.2044,
"firsthand":4.1423,
"firstly":311.9880,
"firth":4.7071,
"fiscal":228.9544,
"fish":2111.6145,
"fisher":7.7197,
"fisherman":184.1426,
"fishery":84.9165,
"fishing":552.9926,
"fishnet":4.1423,
"fishy":20.1465,
"fission":16.0042,
"fissure":36.5273,
"fist":266.0465,
"fit":2533.3725,
"fitch":0.1883,
"fitness":268.8708,
"fits":0.1883,
"fitted":2.8243,
"fitter":70.6068,
"fitting":339.1010,
"five":8077.9846,
"fives":0.1883,
"fix":1529.8143,
"fixable":0.3766,
"fixation":46.3181,
"fixed":53.2846,
"fixing":45.7532,
"fixture":153.0756,
"fl":1.5063,
"flag":408.5781,
"flagging":6.0251,
"flagship":45.1884,
"flagstaff":1.8828,
"flair":63.4520,
"flake":95.0838,
"flaky":8.0962,
"flame":440.2100,
"flamenco":10.3557,
"flaming":9.4142,
"flamingo":12.8034,
"flammable":14.6862,
"flanders":0.1883,
"flange":13.1799,
"flank":213.5150,
"flanked":0.1883,
"flanking":10.3557,
"flannel":43.6821,
"flap":194.1217,
"flare":195.4397,
"flared":11.8619,
"flash":547.3440,
"flashback":18.2636,
"flashed":0.1883,
"flasher":6.2134,
"flashes":0.1883,
"flashing":14.1214,
"flashlight":14.6862,
"flashy":23.9122,
"flask":63.6403,
"flat":1877.1999,
"flatbed":2.4477,
"flathead":0.9414,
"flats":0.5649,
"flatten":106.1927,
"flattened":28.4310,
"flattening":5.8368,
"flatter":67.7825,
"flattering":49.7072,
"flatware":0.9414,
"flavor":1.1297,
"flavour":379.0174,
"flavoured":0.7531,
"flavouring":15.8159,
"flaw":96.9667,
"flawed":64.7700,
"flawless":17.8871,
"flawlessly":2.0711,
"flax":15.2511,
"flea":61.7574,
"fleck":28.9959,
"fled":0.1883,
"fledged":2.4477,
"fledgling":30.5021,
"flee":389.9379,
"fleece":42.3641,
"fleeing":1.8828,
"fleet":306.3394,
"fleeting":65.7114,
"fleming":2.6360,
"flemish":32.9498,
"flesh":455.6493,
"fleshy":32.5733,
"fletcher":0.7531,
"fleur":2.4477,
"flew":2.0711,
"flex":89.2470,
"flexibility":353.7872,
"flexible":425.5237,
"flick":229.7075,
"flicker":213.5150,
"flickering":8.4728,
"flight":1084.5207,
"flights":0.5649,
"flimsy":52.9080,
"fling":240.0632,
"flint":47.6361,
"flip":148.3685,
"flipper":9.9791,
"flipping":4.1423,
"flirt":64.3934,
"flirting":1.6946,
"float":599.8755,
"floating":6.9665,
"flock":251.1720,
"flood":532.2812,
"flooded":1.5063,
"flooding":75.3139,
"floodplain":4.5188,
"floor":2293.8742,
"flooring":37.0921,
"floors":0.1883,
"flop":106.3809,
"floppy":96.4018,
"flora":90.9416,
"floral":76.2554,
"florence":0.1883,
"florentine":2.2594,
"florin":6.4017,
"florist":25.0419,
"floss":11.6737,
"flotation":52.5315,
"flounder":48.0126,
"flour":184.5191,
"flourish":275.6490,
"flourishing":6.4017,
"flow":1505.3373,
"flower":1419.6677,
"flowered":8.6611,
"flowering":61.3809,
"flowing":9.7908,
"flown":0.1883,
"flows":0.5649,
"flu":105.0629,
"fluctuate":84.1633,
"fluctuating":0.7531,
"fluctuation":164.9375,
"flue":43.4938,
"fluency":34.2678,
"fluent":59.1214,
"fluff":29.1842,
"fluffy":41.4227,
"fluid":355.8584,
"fluke":27.6779,
"flung":7.7197,
"fluorescence":24.6653,
"fluorescent":53.4729,
"fluoride":21.4645,
"flurry":59.4980,
"flush":289.9587,
"flushed":26.1716,
"flute":74.5608,
"flutter":118.9960,
"flux":91.5064,
"fly":2265.8198,
"flycatcher":9.2260,
"flying":106.0044,
"fm":1.8828,
"fo":33.5147,
"foal":69.4771,
"foam":153.8287,
"fob":20.1465,
"focal":94.5190,
"focus":1549.7725,
"focused":59.3097,
"focusing":5.0837,
"focussed":2.0711,
"focussing":0.5649,
"fodder":40.2930,
"foe":58.7449,
"fog":154.2053,
"foggy":28.2427,
"foil":125.0211,
"fold":625.6705,
"folded":3.2008,
"folder":83.7868,
"folding":27.1130,
"foliage":120.6906,
"folio":19.2051,
"folk":441.9045,
"folklore":48.9541,
"follicle":13.3682,
"follow":9289.5975,
"follower":219.1636,
"following":967.2192,
"follows":0.3766,
"followup":0.5649,
"folly":98.2847,
"fond":199.9585,
"fonda":0.1883,
"fonder":5.0837,
"fondly":33.5147,
"fondness":28.2427,
"fondue":6.9665,
"font":128.2220,
"food":3561.0312,
"foods":0.9414,
"fool":463.9339,
"fooled":0.1883,
"fooling":1.5063,
"foolish":201.2765,
"foolishly":32.3850,
"foolishness":14.6862,
"fools":0.7531,
"foot":3820.6760,
"footage":42.1758,
"football":1000.7339,
"footed":37.0921,
"footer":17.5105,
"foothill":26.5482,
"foothold":35.7741,
"footing":76.2554,
"footnote":50.2721,
"footpath":119.9374,
"footprint":63.6403,
"footwear":39.1632,
"for":158100.5223,
"forage":39.1632,
"foraging":13.7448,
"foray":45.5649,
"forbid":299.9378,
"forbidden":2.8243,
"forbidding":14.4979,
"force":6109.0900,
"forced":17.6988,
"forceful":65.8997,
"forcefully":43.8704,
"forcibly":66.0880,
"forcing":8.0962,
"ford":23.5356,
"fore":104.1215,
"forearm":54.7909,
"forecast":457.1556,
"forecaster":19.2051,
"forecasting":59.6863,
"foreclosure":6.5900,
"forefront":90.1884,
"foregoing":19.9582,
"foreground":71.1717,
"forehead":223.6824,
"foreign":2019.9198,
"foreigner":218.7870,
"foreman":79.2679,
"foremost":106.9458,
"forensic":87.5525,
"foresee":136.1299,
"foreseeable":77.9499,
"foreseen":0.7531,
"foresight":35.2093,
"foreskin":12.4268,
"forest":1089.4161,
"forested":12.2385,
"forester":48.5775,
"forestry":100.1675,
"forever":311.9880,
"foreword":17.5105,
"forfeit":58.7449,
"forfeited":1.5063,
"forfeiture":25.9833,
"forgave":11.6737,
"forge":212.0087,
"forgery":52.9080,
"forget":2154.7317,
"forgetting":4.5188,
"forging":9.0377,
"forgive":346.0675,
"forgiven":0.3766,
"forgiveness":77.1968,
"forgiving":21.4645,
"forgot":35.3976,
"forgotten":11.4854,
"fork":214.4564,
"forklift":6.2134,
"form":9704.3890,
"formal":1129.3325,
"formaldehyde":20.8996,
"formalism":22.0293,
"formality":116.3600,
"formalized":1.1297,
"formally":386.1722,
"format":494.4360,
"formation":758.9762,
"formative":67.4060,
"formatted":2.8243,
"formatting":14.4979,
"formed":1.6946,
"former":3026.3023,
"formerly":349.0801,
"formidable":195.8162,
"forming":9.4142,
"formula":411.5907,
"formulae":77.1968,
"formulate":286.3812,
"formulating":0.1883,
"formulation":196.0045,
"forsake":30.5021,
"forsaken":1.1297,
"fort":95.6487,
"forte":14.4979,
"forth":317.2600,
"forthcoming":283.5570,
"forthwith":39.5398,
"fortieth":10.5440,
"fortified":14.4979,
"fortifying":0.1883,
"fortnight":249.4774,
"fortran":0.5649,
"fortress":102.4270,
"fortunate":228.9544,
"fortunately":295.6072,
"fortune":526.4444,
"forty":1539.0403,
"forum":164.3727,
"forward":2812.2224,
"forwarded":0.9414,
"forwarding":7.7197,
"forwards":145.1676,
"fossil":258.5151,
"foster":320.0842,
"fostering":14.6862,
"fought":0.3766,
"foul":224.2472,
"fouled":3.2008,
"found":582.3650,
"foundation":618.1391,
"foundational":2.4477,
"founded":1.5063,
"founder":318.7662,
"founding":42.7407,
"foundry":35.0210,
"fountain":134.4354,
"four":8848.2579,
"fourier":8.2845,
"fours":0.3766,
"foursome":21.4645,
"fourteen":478.9966,
"fourteenth":127.4688,
"fourth":1033.4955,
"fourthly":24.1005,
"fowl":34.0796,
"fowler":1.8828,
"fox":234.2263,
"foxy":4.1423,
"foyer":62.3223,
"fps":1.6946,
"fr":0.9414,
"fractal":11.8619,
"fraction":347.1972,
"fractional":26.1716,
"fracture":128.2220,
"fractured":47.2595,
"fragile":155.8998,
"fragment":435.3146,
"fragmentation":63.0754,
"fragmented":61.1926,
"fragrance":61.5691,
"fragrant":48.3892,
"frail":103.9332,
"frame":996.7800,
"framed":2.6360,
"framework":700.9845,
"framing":21.6528,
"franc":111.4646,
"france":4.7071,
"franchise":170.7744,
"franchisee":21.6528,
"franchising":23.1590,
"franciscan":13.1799,
"franco":1.5063,
"frank":81.5273,
"frankenstein":0.9414,
"frankfurt":0.5649,
"frankly":167.9501,
"frantic":97.1550,
"frantically":73.4311,
"frat":0.1883,
"fraternal":22.2176,
"fraternity":40.8578,
"frau":0.9414,
"fraud":306.1512,
"fraudulent":47.8243,
"fraught":60.6277,
"fray":66.0880,
"frazer":1.1297,
"freak":85.4813,
"freaky":3.3891,
"free":4284.4216,
"freebies":0.1883,
"freed":5.2720,
"freedman":3.2008,
"freedom":1060.4202,
"freehand":6.4017,
"freehold":53.2846,
"freeing":9.2260,
"freelance":70.0420,
"freely":280.9210,
"freeman":16.5691,
"freemasonry":7.9080,
"freephone":8.2845,
"freer":2.2594,
"freest":0.1883,
"freestanding":0.5649,
"freestyle":16.1925,
"freeware":0.1883,
"freeway":8.4728,
"freeze":511.7582,
"freezer":95.8370,
"freezing":51.4018,
"freight":149.8747,
"fremont":0.3766,
"french":2062.2839,
"frenchman":37.6570,
"frenzy":52.5315,
"frequency":661.0681,
"frequent":472.7832,
"frequented":0.9414,
"frequenting":1.6946,
"frequently":1035.3783,
"fresco":58.9332,
"fresh":1212.1778,
"fresher":17.1339,
"freshest":0.1883,
"freshly":106.1927,
"freshman":4.7071,
"freshmen":0.1883,
"freshness":36.1507,
"freshwater":48.5775,
"fret":104.1215,
"freud":0.1883,
"fri":1.8828,
"friction":91.6947,
"friday":15.8159,
"fridge":186.9668,
"fried":5.8368,
"friend":5124.1720,
"friendliness":40.4812,
"friendly":782.3235,
"friendship":404.4358,
"fright":74.5608,
"frighten":193.7451,
"frightened":364.5195,
"frightening":178.4940,
"frightful":28.0544,
"fringe":249.2891,
"frisbee":3.0126,
"frivolous":38.9750,
"fro":72.4897,
"frog":164.1844,
"from":76027.9129,
"front":3706.5754,
"frontage":41.4227,
"frontal":32.7616,
"fronted":3.3891,
"frontier":225.1887,
"frost":162.8664,
"frosted":15.8159,
"frosting":4.5188,
"frosty":38.9750,
"frown":351.9044,
"frowned":1.3180,
"froze":0.9414,
"frozen":230.8372,
"fructose":4.3306,
"frugal":14.1214,
"fruit":887.3865,
"fruitful":78.1382,
"fruition":32.7616,
"fruitless":40.8578,
"fruity":23.5356,
"frustrate":102.4270,
"frustrated":110.3349,
"frustrating":107.8872,
"frustration":291.6532,
"fry":234.9795,
"fryer":12.2385,
"frying":24.6653,
"ft":558.0763,
"ftp":0.7531,
"fuchsia":1.5063,
"fuck":421.1932,
"fucker":13.5565,
"fucking":380.3354,
"fudge":26.3599,
"fuel":980.3992,
"fugitive":36.7155,
"fuji":0.1883,
"fulfil":478.8084,
"fulfill":10.9205,
"fulfilled":0.5649,
"fulfilling":16.3808,
"fulfillment":3.9540,
"fulfilment":118.9960,
"full":5997.0605,
"fuller":3.7657,
"fullest":0.1883,
"fullness":41.9875,
"fully":1608.1408,
"fumble":83.7868,
"fume":155.3350,
"fun":879.2902,
"function":2590.9877,
"functional":361.6952,
"functionality":46.8829,
"functionally":32.3850,
"functioned":0.1883,
"functioning":100.1675,
"fund":2298.9579,
"fundamental":832.9721,
"fundamentalism":27.1130,
"fundamentalist":77.7616,
"fundamentally":156.2764,
"funded":2.4477,
"funder":8.4728,
"funding":678.3903,
"fundraiser":8.0962,
"funeral":412.7204,
"fungal":24.4770,
"fungi":0.7531,
"fungus":102.6152,
"funk":35.3976,
"funky":22.0293,
"funnel":42.5524,
"funnier":0.5649,
"funniest":0.9414,
"funny":795.6917,
"fur":234.7912,
"furious":222.1761,
"furiously":104.4981,
"furl":4.5188,
"furnace":81.5273,
"furnish":222.3644,
"furnished":21.0879,
"furnishing":86.2345,
"furniture":614.5617,
"furry":32.5733,
"further":3834.4208,
"furtherance":16.1925,
"furthering":0.9414,
"furthermore":526.6327,
"furthest":9.7908,
"fury":177.9292,
"fuse":143.0965,
"fused":8.6611,
"fuselage":48.2009,
"fusion":218.4104,
"fuss":189.4146,
"futile":63.4520,
"futility":29.7490,
"futon":2.2594,
"future":4233.7730,
"futures":0.1883,
"futuristic":20.3348,
"fuzzy":31.4436,
"g":623.5994,
"ga":1.8828,
"gab":2.2594,
"gable":54.2260,
"gabriel":1.5063,
"gadget":38.9750,
"gael":0.9414,
"gaelic":40.6695,
"gag":68.7240,
"gage":1.8828,
"gagging":0.9414,
"gaiety":20.3348,
"gaily":21.8410,
"gain":2222.5143,
"gained":0.7531,
"gaining":3.5774,
"gait":22.2176,
"gal":15.2511,
"gala":41.9875,
"galactic":14.6862,
"galaxy":147.0505,
"gale":88.1173,
"galena":5.2720,
"gall":204.8539,
"gallant":44.0587,
"galleria":0.5649,
"gallery":554.6871,
"galley":55.5440,
"gallon":149.4982,
"galloway":0.1883,
"gallup":0.3766,
"galore":7.5314,
"galvanized":2.8243,
"gambia":0.1883,
"gambian":3.7657,
"gambit":13.9331,
"gamble":102.8035,
"gambler":29.9373,
"gambling":72.8662,
"game":3543.1442,
"gamer":0.7531,
"games":0.3766,
"gaming":16.0042,
"gamma":106.7575,
"gamut":15.6276,
"gang":374.6868,
"ganglia":13.7448,
"gangster":44.2469,
"gap":804.5411,
"gaping":1.5063,
"gaps":0.1883,
"gar":1.6946,
"garage":403.3061,
"garb":17.5105,
"garbage":50.4603,
"garden":2148.5183,
"gardener":173.9752,
"gardening":140.8371,
"gardens":0.7531,
"gardiner":0.1883,
"gardner":0.7531,
"garland":28.0544,
"garlic":111.2763,
"garment":227.0715,
"garner":16.5691,
"garnet":12.4268,
"garnish":48.9541,
"garrison":93.5776,
"garter":18.8285,
"gary":5.4603,
"gas":1403.6635,
"gaseous":21.2762,
"gasket":13.5565,
"gasoline":11.8619,
"gasp":272.2599,
"gastric":186.9668,
"gastrointestinal":93.5776,
"gate":844.0809,
"gated":0.7531,
"gatekeeper":19.0168,
"gates":0.1883,
"gateway":121.0672,
"gather":959.1230,
"gathering":218.0338,
"gator":1.3180,
"gatt":0.5649,
"gauge":202.7828,
"gauntlet":29.5607,
"gauss":1.1297,
"gaussian":14.4979,
"gave":3.0126,
"gawk":3.0126,
"gay":295.6072,
"gayer":1.1297,
"gayest":0.1883,
"gayness":1.5063,
"gaze":776.2984,
"gazebo":9.0377,
"gazed":0.3766,
"gazette":5.0837,
"gazetteer":2.2594,
"gazing":0.5649,
"gb":1.8828,
"gd":1.5063,
"gdp":22.2176,
"ge":1.1297,
"gear":507.6159,
"gearbox":56.6737,
"geared":3.3891,
"gearing":34.6444,
"gecko":3.9540,
"gee":17.8871,
"geek":4.1423,
"geeky":0.3766,
"geese":8.6611,
"geiger":1.1297,
"geisha":1.8828,
"gel":136.3182,
"gelatin":2.8243,
"geld":3.2008,
"gem":87.1759,
"gemini":0.7531,
"gems":0.3766,
"gemstone":6.4017,
"gen":17.3222,
"gender":368.8500,
"gene":755.3988,
"genealogical":12.2385,
"genealogy":18.8285,
"genera":32.0084,
"general":5504.1308,
"generalisable":4.1423,
"generalisation":57.9917,
"generalise":38.9750,
"generalised":35.0210,
"generality":62.8871,
"generalization":83.2219,
"generalize":47.2595,
"generalized":48.2009,
"generally":2052.6813,
"generate":1070.9642,
"generated":0.3766,
"generating":28.9959,
"generation":1282.0315,
"generational":16.9456,
"generator":132.5525,
"generic":109.7701,
"generosity":111.2763,
"generous":417.4275,
"generously":81.1508,
"genesis":27.1130,
"genet":3.7657,
"genetic":380.1471,
"genetically":68.1591,
"genetics":0.3766,
"geneva":0.3766,
"genie":8.4728,
"genital":63.4520,
"genius":186.7786,
"genoa":5.0837,
"genocide":22.2176,
"genome":40.8578,
"genomic":23.9122,
"genotype":22.5942,
"genre":142.9082,
"gent":41.9875,
"gentile":16.0042,
"gentle":508.9339,
"gentleman":686.1100,
"gentlemen":1.5063,
"gently":681.4028,
"gentry":121.0672,
"genuine":590.8378,
"genuinely":250.9837,
"genus":58.3683,
"geochemistry":11.2971,
"geographic":43.6821,
"geographical":269.6239,
"geographically":62.8871,
"geography":178.1175,
"geologic":0.7531,
"geological":128.9751,
"geologist":61.9457,
"geology":94.3307,
"geometric":103.1801,
"geometrical":34.6444,
"geometry":84.5399,
"geophysical":27.1130,
"geophysics":0.1883,
"geopolitical":3.9540,
"georgian":109.0169,
"geothermal":21.0879,
"ger":0.9414,
"geranium":36.3390,
"geriatric":36.7155,
"geriatrics":0.1883,
"germ":59.8746,
"german":1714.3335,
"germanic":25.2302,
"germany":0.3766,
"germination":13.9331,
"geronimo":0.5649,
"gerontology":2.2594,
"gershwin":0.1883,
"gestation":37.4687,
"gestational":14.3096,
"gesture":554.8754,
"get":37587.8678,
"getaway":21.2762,
"gets":150.8162,
"getting":337.0299,
"ghana":0.3766,
"ghanaian":7.1548,
"ghent":1.3180,
"ghetto":59.1214,
"ghost":332.5110,
"ghostly":45.5649,
"gi":18.8285,
"gian":0.1883,
"giant":565.4194,
"gibbon":14.4979,
"gibson":2.4477,
"giddy":18.6402,
"gift":809.0600,
"gifted":78.8913,
"gifts":0.9414,
"gig":173.2221,
"gigabyte":1.8828,
"gigantic":72.1131,
"giggle":171.5275,
"giggling":3.5774,
"gigs":0.7531,
"gilbert":0.1883,
"gill":54.7909,
"gilt":134.8119,
"gimme":10.3557,
"gimmick":30.3139,
"gimp":1.6946,
"gin":98.8495,
"ginger":105.4395,
"gingerbread":10.7322,
"ginkgo":1.3180,
"ginseng":5.4603,
"giraffe":14.6862,
"girdle":25.6067,
"girl":4182.1829,
"girlfriend":251.7368,
"giro":2.2594,
"girth":19.9582,
"gist":25.0419,
"git":35.5858,
"give":23331.5045,
"giveaway":18.6402,
"given":2.8243,
"giver":27.8662,
"gives":3.3891,
"giving":97.3433,
"glacial":42.9289,
"glacier":57.9917,
"glad":678.5786,
"gladder":1.3180,
"glade":18.6402,
"gladiator":10.9205,
"gladly":52.3432,
"gladness":5.6485,
"gladstone":0.9414,
"glam":8.6611,
"glamorous":102.2387,
"glamour":84.1633,
"glance":1108.4329,
"glanced":0.1883,
"glancing":1.1297,
"gland":87.7407,
"glare":282.8038,
"glaring":10.3557,
"glasgow":0.5649,
"glass":2111.0496,
"glassware":9.9791,
"glaucoma":4.8954,
"glaze":64.9583,
"glazed":64.0168,
"glazing":74.9374,
"gleaming":4.8954,
"gleaned":0.1883,
"glee":28.2427,
"glen":19.5816,
"glib":11.8619,
"glide":89.0587,
"glider":116.3600,
"gliding":32.5733,
"glimmer":53.2846,
"glimpse":290.3352,
"glistening":3.0126,
"glitch":8.4728,
"glitter":192.6154,
"glittering":2.4477,
"global":546.4026,
"globalisation":4.5188,
"globalization":2.4477,
"globally":20.5230,
"globe":104.4981,
"globular":19.9582,
"gloom":165.6907,
"gloomy":122.7617,
"glorify":33.7030,
"glorious":185.0840,
"glory":312.9294,
"gloss":102.6152,
"glossary":26.3599,
"glossy":116.3600,
"gloucester":1.6946,
"glove":247.2180,
"glow":322.7202,
"glowing":51.0252,
"glucose":108.8286,
"glue":202.5945,
"glued":0.9414,
"glut":14.8745,
"glutamate":27.6779,
"gluten":31.8201,
"glycerol":4.5188,
"glycine":9.7908,
"glycogen":5.4603,
"glycol":7.9080,
"glyph":1.5063,
"gmt":1.3180,
"gnome":21.8410,
"gnp":4.8954,
"go":43871.8744,
"goa":0.1883,
"goal":1933.6853,
"goalie":11.8619,
"goalkeeper":152.3224,
"goat":169.0798,
"goblet":33.3264,
"goblin":21.0879,
"god":348.1387,
"goddamn":6.5900,
"goddess":103.5567,
"godfather":22.5942,
"godly":17.6988,
"goes":5.2720,
"goggle":42.7407,
"goggles":0.1883,
"going":110.8998,
"gold":1230.2532,
"golden":506.6745,
"goldfish":43.6821,
"golding":4.1423,
"goldsmith":21.6528,
"golf":482.9506,
"golfer":123.8914,
"golfing":43.8704,
"golgi":1.1297,
"goliath":0.9414,
"gone":22.0293,
"gong":19.7699,
"goo":9.7908,
"good":21047.2328,
"goodbye":197.8874,
"goodbyes":1.5063,
"goodman":0.1883,
"goodness":245.1469,
"goods":1.3180,
"goodwill":136.1299,
"goody":64.3934,
"goodyear":0.1883,
"goofy":3.5774,
"google":0.3766,
"goose":102.8035,
"gop":0.1883,
"gopher":1.6946,
"gorbachev":1.1297,
"gore":9.2260,
"gorge":57.9917,
"gorgeous":103.9332,
"gorilla":32.9498,
"gory":12.4268,
"gosh":37.6570,
"gosling":3.2008,
"gospel":119.3726,
"gossamer":7.9080,
"gossip":205.6070,
"got":887.0099,
"goth":4.5188,
"gothic":113.9123,
"gotta":0.5649,
"gotten":0.3766,
"gould":0.5649,
"gourmet":21.4645,
"gout":14.3096,
"govern":656.5492,
"governance":28.4310,
"governed":0.1883,
"governing":17.6988,
"government":9517.7988,
"governmental":151.9459,
"governor":473.3481,
"governors":0.1883,
"govt":4.3306,
"gown":222.9293,
"goya":0.1883,
"gp":102.8035,
"gpa":1.3180,
"grab":538.6829,
"grabbed":0.5649,
"grabber":4.8954,
"grabbing":1.3180,
"grabs":0.5649,
"grace":360.9420,
"graceful":76.4436,
"gracefully":38.9750,
"gracing":0.5649,
"gracious":72.6779,
"graciously":22.2176,
"grad":1.8828,
"grade":617.0094,
"graded":0.1883,
"grader":2.6360,
"gradient":116.9249,
"grading":49.1423,
"gradual":190.3560,
"gradually":649.9593,
"graduate":498.0134,
"graduated":3.0126,
"graduating":4.8954,
"graduation":31.2553,
"graffiti":19.7699,
"graft":83.4102,
"grafting":9.7908,
"graham":0.5649,
"grail":3.3891,
"grain":448.1179,
"grained":3.2008,
"gram":98.2847,
"grammar":389.7496,
"grammatical":182.4480,
"gran":12.0502,
"grand":505.5448,
"grandchild":111.8412,
"grandchildren":0.9414,
"granddaughter":48.0126,
"grandeur":60.0629,
"grandfather":279.4147,
"grandma":48.3892,
"grandmother":253.6197,
"grandpa":10.3557,
"grandparent":113.5358,
"grandson":103.5567,
"grange":4.5188,
"granger":0.1883,
"granite":108.2638,
"granny":50.2721,
"grant":2139.1041,
"granted":0.1883,
"grantee":4.3306,
"granting":42.5524,
"granular":13.1799,
"granularity":1.8828,
"grape":137.2596,
"grapefruit":19.3933,
"grapevine":19.0168,
"graph":261.7159,
"graphic":425.3355,
"graphical":108.6404,
"graphically":42.7407,
"graphing":2.2594,
"graphite":37.0921,
"grapple":54.0377,
"grappling":1.3180,
"grasp":452.0719,
"grasped":0.1883,
"grasping":2.2594,
"grass":828.0767,
"grasshopper":13.3682,
"grassland":77.7616,
"grassroots":19.7699,
"grassy":55.1675,
"grate":125.9626,
"grated":8.4728,
"grateful":473.1598,
"gratefully":64.0168,
"gratification":35.2093,
"gratifying":13.1799,
"grating":23.9122,
"gratis":1.1297,
"gratitude":136.5065,
"gratuitous":24.4770,
"grave":484.4569,
"gravel":225.5652,
"gravely":52.7198,
"graveyard":74.1842,
"gravitational":104.8747,
"gravity":220.1050,
"gravy":42.9289,
"gray":13.9331,
"grazing":111.4646,
"grease":99.0378,
"greased":3.7657,
"greasing":1.6946,
"greasy":74.7491,
"great":10868.7425,
"greater":29.1842,
"greatest":2.8243,
"greatly":597.6161,
"greatness":50.8369,
"greed":83.9750,
"greedily":18.2636,
"greedy":85.2930,
"greek":446.9882,
"green":1953.0787,
"greenbelt":85.6696,
"greene":0.1883,
"greener":2.4477,
"greenery":28.0544,
"greenhouse":185.6489,
"greening":7.1548,
"greenish":23.1590,
"greenland":0.7531,
"greenness":7.1548,
"greenpeace":18.6402,
"greens":0.9414,
"greenwood":0.3766,
"greet":388.6199,
"greeting":130.6697,
"gregorian":6.4017,
"grenade":64.0168,
"grep":0.3766,
"gresham":0.5649,
"grew":1.5063,
"grey":935.0225,
"greyhound":29.1842,
"grid":192.9920,
"grief":244.2054,
"grievance":117.6780,
"grieve":85.6696,
"grieving":9.6025,
"grievous":53.0963,
"griffin":3.9540,
"grill":123.8914,
"grille":35.3976,
"grilles":0.1883,
"grilling":7.3431,
"grim":185.4606,
"grin":578.0345,
"grind":168.5149,
"grinder":20.1465,
"grinding":16.9456,
"grinning":8.8494,
"grip":601.7584,
"gripe":15.8159,
"gripping":8.2845,
"gris":0.7531,
"grist":16.7574,
"grit":100.1675,
"gritty":32.9498,
"grizzly":10.5440,
"groan":195.2514,
"groaned":0.1883,
"grocery":66.4645,
"groin":65.8997,
"groom":148.9333,
"groomed":7.7197,
"grooming":11.1088,
"groove":127.8454,
"groovy":10.9205,
"gross":426.4652,
"grossly":70.7951,
"grotesque":54.2260,
"grotto":21.4645,
"ground":3982.0361,
"groundbreaking":0.9414,
"grounded":0.5649,
"groundhog":0.5649,
"grounding":32.7616,
"groundwater":51.2135,
"groundwork":21.2762,
"group":9625.8743,
"grouped":0.1883,
"grouping":202.9711,
"groups":0.1883,
"groupware":5.4603,
"grouse":28.8076,
"grout":9.9791,
"grove":51.7783,
"grow":4626.3468,
"grower":67.0294,
"growing":14.1214,
"grown":22.0293,
"growth":2321.7404,
"grub":46.8829,
"grudge":48.7658,
"gruesome":31.8201,
"grumpy":16.5691,
"grunge":15.0628,
"grunt":128.4103,
"gu":2.0711,
"guadeloupe":0.1883,
"guam":0.5649,
"guarani":0.1883,
"guarantee":1065.6922,
"guaranteed":1.8828,
"guaranteeing":1.3180,
"guarantees":0.3766,
"guarantor":35.3976,
"guaranty":0.1883,
"guard":836.5496,
"guarded":6.5900,
"guardian":164.9375,
"guardianship":12.0502,
"guarding":4.5188,
"guatemala":1.5063,
"gubernatorial":12.9917,
"guernsey":0.5649,
"guerrilla":206.7368,
"guess":820.5453,
"guessing":2.0711,
"guesswork":17.5105,
"guest":987.1774,
"guesthouse":7.5314,
"gui":8.0962,
"guidance":543.9549,
"guide":1359.0400,
"guidebook":45.5649,
"guided":1.5063,
"guideline":433.9966,
"guidelines":0.1883,
"guides":0.5649,
"guiding":6.5900,
"guild":61.1926,
"guilder":4.5188,
"guildhall":1.6946,
"guilds":0.5649,
"guile":12.8034,
"guilt":309.5403,
"guiltily":22.4059,
"guiltless":2.4477,
"guilty":723.3904,
"guinea":88.6822,
"guinness":2.0711,
"guise":74.7491,
"guitar":613.0554,
"guitarist":126.1508,
"gujarat":0.1883,
"gulch":0.5649,
"gulf":49.7072,
"gull":93.2010,
"gulliver":0.1883,
"gully":38.4101,
"gum":106.5692,
"gun":1037.8260,
"gunfire":34.2678,
"gunner":50.8369,
"guns":0.5649,
"gunshot":18.6402,
"gurney":0.1883,
"guru":44.8118,
"gushing":3.0126,
"gust":40.8578,
"gut":236.6740,
"guts":0.1883,
"gutted":4.8954,
"gutter":108.6404,
"guy":645.2522,
"guyana":0.1883,
"guyanese":4.3306,
"gym":72.4897,
"gymnasium":28.8076,
"gymnastics":1.8828,
"gypsum":8.4728,
"gypsy":93.9541,
"h":456.5907,
"ha":472.9715,
"habit":709.2690,
"habitat":211.2556,
"habitation":32.1967,
"habitual":52.3432,
"habitually":37.8453,
"hacienda":9.4142,
"hack":115.7952,
"hacker":20.8996,
"hacking":16.3808,
"hackney":1.6946,
"had":17.1339,
"hadn":0.1883,
"haggard":16.0042,
"haggis":4.3306,
"haha":0.7531,
"haiku":3.5774,
"hail":165.5024,
"hair":2607.3685,
"haircare":4.3306,
"haircut":54.7909,
"hairdressing":18.6402,
"hairdryer":20.8996,
"haired":178.8706,
"hairless":7.1548,
"hairy":73.0545,
"haitian":8.6611,
"hakim":2.0711,
"halcyon":8.8494,
"hale":7.7197,
"half":6831.3506,
"halftime":2.4477,
"halfway":189.9794,
"halibut":4.1423,
"halifax":0.5649,
"hall":1078.1190,
"hallelujah":0.7531,
"hallmark":60.4394,
"hallo":0.7531,
"halloween":0.9414,
"halls":0.1883,
"hallway":77.5734,
"halo":31.0670,
"halogen":13.1799,
"halt":465.2518,
"halter":13.9331,
"halting":10.1674,
"halved":0.9414,
"ham":121.4437,
"hamburger":30.8787,
"hamilton":5.0837,
"hamlet":89.8119,
"hammer":333.2642,
"hammered":0.1883,
"hammering":14.4979,
"hammock":14.6862,
"hamper":122.3851,
"hampton":0.9414,
"hamster":21.6528,
"han":0.3766,
"hancock":0.1883,
"hand":10626.4199,
"handbag":120.3140,
"handball":5.4603,
"handbook":68.3474,
"handbooks":0.1883,
"handcrafted":1.8828,
"handed":191.1091,
"handel":0.3766,
"handful":252.8665,
"handfuls":8.0962,
"handgun":18.4519,
"handheld":15.2511,
"handicap":264.1636,
"handicapped":247.4063,
"handicapping":3.5774,
"handicraft":16.1925,
"handing":17.6988,
"handkerchief":134.4354,
"handle":1350.9437,
"handled":0.1883,
"handler":41.0461,
"handling":289.2055,
"handmade":25.9833,
"handout":48.5775,
"handover":15.6276,
"handset":27.4896,
"handshake":39.3515,
"handsome":280.7327,
"handspring":0.3766,
"handwriting":99.2261,
"handwritten":35.7741,
"handy":148.1802,
"handyman":11.1088,
"hang":1718.2875,
"hangar":51.4018,
"hanged":0.1883,
"hanger":58.3683,
"hanging":36.1507,
"hangman":7.9080,
"hangout":1.3180,
"hangover":54.7909,
"hank":5.2720,
"hap":1.3180,
"hapless":33.1381,
"happen":5628.9636,
"happened":0.9414,
"happening":80.0211,
"happens":2.2594,
"happier":0.5649,
"happiest":0.5649,
"happily":312.9294,
"happiness":291.0884,
"happy":2212.9117,
"harass":79.4562,
"harassed":0.5649,
"harassing":0.1883,
"harassment":102.9918,
"harbor":0.5649,
"harbour":326.2976,
"hard":4903.8787,
"hardback":29.5607,
"hardcore":33.8913,
"hardcover":2.2594,
"harden":132.5525,
"hardened":21.6528,
"hardening":14.8745,
"hardens":0.1883,
"harder":0.9414,
"hardest":0.5649,
"hardly":1522.4712,
"hardness":53.8495,
"hardship":151.1927,
"hardware":365.4609,
"hardwood":44.8118,
"hardworking":14.6862,
"hardy":78.1382,
"hare":78.8913,
"harlequin":8.2845,
"harlow":0.1883,
"harm":584.2479,
"harmful":150.0630,
"harmless":115.2303,
"harmonic":50.0838,
"harmonica":7.7197,
"harmonious":51.4018,
"harmonisation":29.1842,
"harmonization":15.6276,
"harmonize":22.2176,
"harmony":179.6237,
"harness":156.8413,
"harp":34.6444,
"harper":2.8243,
"harrier":16.1925,
"harrison":1.8828,
"harrow":8.4728,
"harrowing":28.4310,
"harry":19.7699,
"harsh":300.6909,
"harshly":64.5817,
"hart":2.0711,
"harte":0.1883,
"hartford":0.3766,
"harvard":0.7531,
"harvest":247.9711,
"harvester":12.0502,
"harvesting":29.1842,
"harvey":2.0711,
"has":2.2594,
"hash":22.9708,
"hashing":5.2720,
"hasn":0.3766,
"hassle":77.1968,
"hast":9.9791,
"haste":78.8913,
"hasten":85.8579,
"hastening":1.1297,
"hastily":144.2262,
"hastings":0.1883,
"hasty":59.6863,
"hat":735.8172,
"hatch":190.9208,
"hatchback":16.9456,
"hatched":6.0251,
"hatchery":4.1423,
"hatchet":12.0502,
"hatching":6.2134,
"hate":952.5330,
"hated":1.6946,
"hateful":19.3933,
"hates":0.1883,
"hath":45.7532,
"hating":0.7531,
"hatred":177.9292,
"haul":282.9921,
"hauling":3.5774,
"haunt":201.0882,
"haunted":19.2051,
"haunting":31.4436,
"havana":0.1883,
"have":210248.2686,
"haven":100.1675,
"having":2470.4854,
"havoc":59.4980,
"haw":6.2134,
"hawaii":0.5649,
"hawaiian":26.1716,
"hawk":75.5022,
"hawker":6.5900,
"hawking":2.4477,
"hawkins":0.1883,
"hawthorn":22.7825,
"hawthorne":0.7531,
"hay":157.0296,
"haydn":0.1883,
"hayes":0.1883,
"hazard":281.8624,
"hazardous":127.8454,
"haze":67.4060,
"hazel":28.8076,
"hazy":42.1758,
"hdtv":20.3348,
"he":143480.2043,
"head":7997.7752,
"headache":200.8999,
"headaches":0.1883,
"headboard":17.5105,
"headed":38.5984,
"header":144.6028,
"heading":296.9252,
"headlamp":14.1214,
"headlight":58.9332,
"headlights":0.1883,
"headline":268.3059,
"headphone":48.9541,
"headphones":0.3766,
"headquarters":338.1596,
"headset":13.9331,
"heady":61.3809,
"heal":180.0003,
"healer":30.5021,
"healing":186.4020,
"heals":0.1883,
"health":3352.5999,
"healthcare":27.1130,
"healthful":2.6360,
"healthier":0.1883,
"healthily":12.9917,
"healthy":701.7376,
"heap":230.2724,
"heaped":1.8828,
"heaping":0.1883,
"hear":6229.0274,
"heard":4.3306,
"hearer":61.1926,
"hearing":614.9383,
"hearsay":25.0419,
"heart":2693.9795,
"heartbeat":47.6361,
"heartbreak":15.2511,
"heartbreaking":11.4854,
"heartburn":6.7783,
"hearted":133.8705,
"heartfelt":26.5482,
"hearth":77.3851,
"heartily":32.9498,
"heartland":34.8327,
"hearts":0.1883,
"heartwarming":2.2594,
"hearty":42.7407,
"heat":1220.0858,
"heated":114.2889,
"heater":144.2262,
"heath":58.7449,
"heathen":17.3222,
"heather":72.6779,
"heating":355.1052,
"heatwave":8.2845,
"heaven":135.3768,
"heavenly":52.7198,
"heavier":1.6946,
"heaviest":1.1297,
"heavily":729.0389,
"heavy":1914.1037,
"heavyweight":83.9750,
"hebrew":22.4059,
"heck":35.3976,
"hectare":170.9626,
"hectic":78.5148,
"hector":6.7783,
"hedge":306.7160,
"hedgehog":66.2763,
"hedging":13.3682,
"heed":80.3976,
"heel":361.5069,
"heels":0.1883,
"hefty":61.5691,
"hegemony":57.9917,
"height":794.5620,
"heighten":102.4270,
"heightened":23.3473,
"heinous":13.3682,
"heinz":0.3766,
"heir":238.3686,
"heirloom":13.3682,
"held":8.0962,
"helen":0.1883,
"heli":1.1297,
"helical":15.0628,
"helicopter":273.9544,
"helium":41.6110,
"helix":62.3223,
"hell":755.0222,
"hellenic":9.6025,
"hello":412.9087,
"helm":40.2930,
"helmet":170.5861,
"help":9364.9115,
"helped":31.2553,
"helper":120.1257,
"helpful":567.3022,
"helping":45.0001,
"helpless":145.3559,
"helplessly":73.9959,
"helpline":30.6904,
"helps":12.2385,
"hem":80.9625,
"hemingway":0.1883,
"hemisphere":162.4898,
"hemlock":3.5774,
"hemoglobin":0.1883,
"hemp":17.5105,
"hen":140.2722,
"hence":834.6667,
"henceforth":58.1800,
"hendrix":0.1883,
"henna":5.2720,
"hens":0.1883,
"hep":0.9414,
"heparin":39.5398,
"hepatic":56.6737,
"hepatitis":96.9667,
"her":36618.5775,
"herald":94.3307,
"heralded":1.3180,
"herb":217.0924,
"herbal":37.4687,
"herbicide":26.3599,
"herbs":0.7531,
"hercules":0.1883,
"herd":205.7953,
"here":12140.0417,
"hereafter":21.0879,
"hereby":40.4812,
"hereditary":82.2805,
"hereford":2.4477,
"herein":15.0628,
"hereinafter":11.4854,
"hereof":5.4603,
"heresy":45.9415,
"heretic":24.1005,
"hereto":11.4854,
"heretofore":2.8243,
"hereunder":6.4017,
"herewith":6.2134,
"heritage":200.5234,
"hermit":22.2176,
"hermitage":7.1548,
"hernia":34.4561,
"hero":587.0721,
"heroes":0.1883,
"heroic":117.8663,
"heroin":166.6321,
"heroine":83.9750,
"heroism":23.1590,
"heron":35.7741,
"herpes":0.3766,
"herr":0.3766,
"herring":63.0754,
"hers":402.1764,
"herself":2886.2183,
"hertz":9.0377,
"hesitant":45.1884,
"hesitate":336.6533,
"hesitated":0.1883,
"hesitating":0.1883,
"hesitation":123.8914,
"hess":3.3891,
"hetero":0.5649,
"heterogeneity":27.4896,
"heterogeneous":49.1423,
"heterosexual":81.5273,
"heuristic":22.0293,
"hex":5.8368,
"hexadecimal":3.0126,
"hexagonal":24.1005,
"hey":250.0423,
"heyday":42.5524,
"hf":0.7531,
"hg":4.1423,
"hi":254.3728,
"hiatus":16.7574,
"hibernate":8.8494,
"hibiscus":2.2594,
"hickey":0.3766,
"hickory":3.0126,
"hid":2.0711,
"hidden":98.6613,
"hide":1248.5168,
"hideaway":11.6737,
"hideous":76.6319,
"hiding":94.1424,
"hierarchical":118.4312,
"hierarchy":347.7621,
"high":10697.0267,
"higher":95.2721,
"highest":33.8913,
"highland":40.1047,
"highlander":1.5063,
"highlight":668.2229,
"highlighted":1.5063,
"highlighting":3.3891,
"highlights":0.1883,
"highly":1680.8188,
"highness":11.1088,
"highway":186.2137,
"hijack":44.8118,
"hijacking":10.7322,
"hike":46.1298,
"hiker":12.8034,
"hiking":13.3682,
"hilarious":44.4352,
"hilbert":0.1883,
"hill":918.0769,
"hills":0.1883,
"hillside":128.9751,
"hilltop":21.6528,
"hilly":20.1465,
"him":1.1297,
"himalayan":11.1088,
"himalayas":0.1883,
"himself":5242.4149,
"hind":58.5566,
"hinder":108.6404,
"hindering":0.1883,
"hindi":2.6360,
"hindrance":32.1967,
"hindsight":74.7491,
"hindu":6.0251,
"hinduism":3.7657,
"hinge":112.7826,
"hinged":13.3682,
"hint":498.2017,
"hip":352.4692,
"hippie":41.9875,
"hippo":3.0126,
"hips":0.1883,
"hire":607.7835,
"hired":0.1883,
"hires":0.1883,
"hiring":22.0293,
"hiroshima":0.1883,
"his":74017.0307,
"hispanic":15.0628,
"hist":1.1297,
"histamine":44.2469,
"histogram":18.8285,
"histological":70.0420,
"histology":22.7825,
"historian":522.1139,
"historic":364.3312,
"historical":949.7087,
"historically":146.8622,
"history":3390.4451,
"hit":2239.0833,
"hitch":79.6445,
"hitchcock":0.3766,
"hitchhiker":1.6946,
"hither":13.3682,
"hitherto":232.1552,
"hitler":1.8828,
"hits":0.1883,
"hitter":7.9080,
"hitting":4.1423,
"hiv":9.9791,
"hive":73.4311,
"hm":36.1507,
"hmo":0.1883,
"ho":17.5105,
"hoax":31.2553,
"hob":24.8536,
"hobbit":8.6611,
"hobby":160.9835,
"hobo":2.4477,
"hockey":77.5734,
"hodgkin":2.0711,
"hoe":24.4770,
"hog":34.8327,
"hogan":0.1883,
"hoist":73.4311,
"hold":9041.0615,
"holder":455.0845,
"holding":284.1218,
"holds":0.5649,
"hole":1423.2451,
"holes":0.7531,
"holiday":1746.7185,
"holier":0.5649,
"holiness":23.7239,
"holistic":45.3766,
"holland":2.8243,
"hollow":215.2096,
"hollowed":3.7657,
"hollowing":2.4477,
"holly":36.5273,
"hollywood":1.1297,
"holocaust":21.0879,
"hologram":12.2385,
"holographic":5.6485,
"holstein":0.1883,
"holster":23.1590,
"holy":185.0840,
"homage":77.0085,
"hombre":0.5649,
"home":9542.6524,
"homecoming":16.0042,
"homegrown":4.5188,
"homeland":89.0587,
"homeless":190.5443,
"homelessness":59.6863,
"homemade":16.0042,
"homemaker":4.5188,
"homeopathic":3.0126,
"homeopathy":3.0126,
"homeostasis":3.9540,
"homeowner":17.8871,
"homer":1.8828,
"homes":2.4477,
"homestead":9.7908,
"hometown":8.6611,
"homework":146.8622,
"homicide":28.6193,
"homo":20.5230,
"homogeneity":26.5482,
"homogeneous":87.1759,
"homologous":31.4436,
"homology":37.4687,
"homophobia":13.3682,
"homosexual":196.3811,
"homosexuality":109.5818,
"hon":150.8162,
"honduran":6.9665,
"hone":32.3850,
"honest":509.4988,
"honestly":242.8874,
"honesty":122.9500,
"honey":171.9041,
"honeymoon":94.7073,
"honky":2.4477,
"honor":8.0962,
"honorable":0.7531,
"honorably":0.1883,
"honorary":100.5441,
"honour":812.8257,
"honourable":140.2722,
"honourably":10.9205,
"honoured":5.8368,
"honours":0.7531,
"hood":122.0086,
"hooded":43.8704,
"hoodwinked":0.3766,
"hook":409.3312,
"hooked":28.2427,
"hooker":44.6235,
"hooking":3.9540,
"hoop":57.9917,
"hoops":0.3766,
"hooray":6.2134,
"hoot":45.9415,
"hoover":28.8076,
"hop":203.1593,
"hope":5206.4524,
"hoped":3.2008,
"hopeful":149.1216,
"hopefully":336.0884,
"hopeless":124.6446,
"hopelessly":75.3139,
"hopelessness":30.3139,
"hopes":0.1883,
"hoping":1.6946,
"hopkins":0.1883,
"hopper":32.5733,
"hopping":12.6151,
"hora":0.1883,
"horace":0.7531,
"horde":62.5106,
"horizon":281.2976,
"horizontal":211.6322,
"horizontally":44.8118,
"hormonal":29.5607,
"hormone":145.9208,
"horn":266.0465,
"horned":13.7448,
"hornet":9.2260,
"horns":0.1883,
"horny":16.3808,
"horoscope":22.7825,
"horrendous":55.3557,
"horrible":285.6281,
"horribly":59.4980,
"horrid":38.9750,
"horrific":81.3391,
"horrified":57.8034,
"horrifying":34.2678,
"horror":433.4317,
"horse":2286.3428,
"horseback":30.6904,
"horseman":67.9708,
"horsepower":14.4979,
"horseshoe":14.6862,
"horst":0.1883,
"hort":0.1883,
"horticultural":33.5147,
"horticulture":18.8285,
"hos":0.1883,
"hose":76.4436,
"hosiery":12.2385,
"hospice":52.5315,
"hospitable":21.6528,
"hospital":2600.7785,
"hospitality":138.9542,
"hospitalization":7.7197,
"host":784.9595,
"hostage":205.0422,
"hostel":141.5902,
"hostess":77.1968,
"hostile":294.6658,
"hostility":297.8666,
"hosting":2.4477,
"hot":1696.2581,
"hotel":1718.6640,
"hotly":45.1884,
"hotness":3.0126,
"hotter":1.3180,
"hottest":0.3766,
"hound":115.2303,
"hour":5541.9760,
"hourglass":2.0711,
"hourly":62.1340,
"house":8223.1522,
"housed":0.3766,
"household":965.5247,
"householder":65.3348,
"housekeeper":96.4018,
"housekeeping":52.1549,
"houses":0.1883,
"housewife":178.8706,
"housework":126.3391,
"housing":1464.1029,
"hover":169.2681,
"hovering":0.9414,
"how":17729.8421,
"howard":6.4017,
"howdy":0.9414,
"howe":0.3766,
"however":10803.0311,
"howl":127.2806,
"howling":9.9791,
"hp":3.7657,
"hq":6.0251,
"hr":40.8578,
"hs":0.7531,
"ht":0.3766,
"hub":59.1214,
"hubble":0.9414,
"hubby":10.1674,
"hubs":0.1883,
"hudson":1.3180,
"hue":54.6026,
"hues":0.1883,
"huff":14.4979,
"hug":193.3685,
"huge":1398.3915,
"hugely":65.3348,
"hugging":2.8243,
"hughes":0.5649,
"huh":48.3892,
"hula":2.2594,
"hulk":19.7699,
"hull":76.2554,
"hum":120.3140,
"human":3683.6046,
"humane":60.6277,
"humanist":44.4352,
"humanitarian":86.6110,
"humanity":275.2724,
"humankind":25.0419,
"humble":157.5944,
"humbled":0.7531,
"humbling":6.2134,
"humbly":21.6528,
"hume":0.1883,
"humid":32.7616,
"humidifier":2.4477,
"humidity":51.2135,
"humiliated":6.2134,
"humiliating":59.1214,
"humiliation":112.0295,
"humility":51.2135,
"hummer":0.1883,
"humming":10.5440,
"hummingbird":7.3431,
"humor":3.3891,
"humorous":77.0085,
"humour":418.7455,
"hump":71.5482,
"humping":0.9414,
"humps":0.3766,
"hun":0.1883,
"hundred":4059.2329,
"hundredth":35.3976,
"hung":41.7992,
"hungarian":151.7576,
"hungary":0.5649,
"hunger":205.4188,
"hungering":0.7531,
"hungrily":21.6528,
"hungry":342.1136,
"hunk":18.2636,
"hunt":545.2729,
"hunted":0.7531,
"hunter":178.4940,
"hunting":296.7369,
"huntsman":17.1339,
"hurdle":106.7575,
"hurdles":0.1883,
"hurrah":1.6946,
"hurricane":52.3432,
"hurried":20.3348,
"hurriedly":80.2093,
"hurry":560.1474,
"hurrying":1.5063,
"hurt":946.1313,
"hurtful":22.9708,
"hurting":1.1297,
"husband":2147.2003,
"husbandry":30.6904,
"hush":102.9918,
"husky":37.6570,
"hussein":0.5649,
"hustle":37.6570,
"hustler":7.5314,
"hut":253.6197,
"hutch":12.9917,
"hutchinson":0.3766,
"hutton":0.1883,
"hybrid":134.6237,
"hybridization":27.6779,
"hydra":0.5649,
"hydrate":3.0126,
"hydration":10.1674,
"hydraulic":51.0252,
"hydro":21.8410,
"hydrocarbon":57.9917,
"hydrochloride":2.0711,
"hydroelectric":16.3808,
"hydrogen":225.3770,
"hydrological":5.4603,
"hydrology":1.6946,
"hydrolysis":7.7197,
"hydrophobic":15.2511,
"hydroxide":22.9708,
"hygiene":113.5358,
"hygienic":24.6653,
"hymn":117.8663,
"hymns":0.1883,
"hype":72.4897,
"hyped":3.0126,
"hyper":33.1381,
"hyperactivity":8.6611,
"hyperbolic":7.3431,
"hypersensitivity":10.3557,
"hypertension":66.4645,
"hypertensive":15.6276,
"hypertext":27.6779,
"hypertrophy":6.7783,
"hyphen":12.6151,
"hypnosis":44.4352,
"hypnotherapy":8.4728,
"hypnotic":33.5147,
"hypnotize":13.3682,
"hypocrisy":64.2051,
"hypocritical":23.3473,
"hypoglycemia":0.3766,
"hypothesis":406.1304,
"hypothesise":14.3096,
"hypothesising":0.9414,
"hypothesize":16.1925,
"hypothesized":1.1297,
"hypothesizing":0.3766,
"hypothetical":87.5525,
"hypothetically":4.5188,
"hypothyroidism":3.7657,
"hypoxia":6.5900,
"hysterectomy":16.0042,
"hysteria":45.9415,
"hysterical":74.3725,
"hz":1.1297,
"i":178369.9503,
"ia":3.7657,
"iberian":7.9080,
"ibid":95.0838,
"ibis":2.0711,
"ibuprofen":0.5649,
"icc":0.1883,
"ice":879.2902,
"iceberg":44.0587,
"iced":27.8662,
"iceland":0.9414,
"icelandic":15.4394,
"icing":113.9123,
"icon":126.7157,
"iconic":6.7783,
"icu":2.2594,
"icy":117.3015,
"id":23.1590,
"ida":0.1883,
"idea":5754.7379,
"ideal":1095.6295,
"idealism":48.3892,
"idealistic":32.0084,
"idealized":20.7113,
"ideally":212.0087,
"ideas":0.5649,
"identical":385.2308,
"identically":13.7448,
"identifiable":99.0378,
"identification":393.1387,
"identifier":101.8621,
"identify":2417.5774,
"identifying":7.3431,
"identity":778.5578,
"ideograph":0.5649,
"ideological":304.0800,
"ideologically":36.9038,
"ideology":428.3480,
"idiom":66.6528,
"idiopathic":18.0753,
"idiosyncratic":48.5775,
"idiot":137.0714,
"idiotic":15.0628,
"idle":135.9417,
"idly":45.3766,
"idol":65.5231,
"idyllic":45.5649,
"ie":60.2511,
"if":46028.4890,
"ifs":0.1883,
"ignite":48.5775,
"ignited":0.1883,
"ignition":51.4018,
"ignorance":199.9585,
"ignorant":132.7408,
"ignore":1291.6340,
"ignored":0.1883,
"ignoring":0.3766,
"iguana":6.5900,
"ii":72.1131,
"iii":47.0712,
"il":0.9414,
"ilk":14.1214,
"ill":1305.3788,
"illegal":431.9254,
"illegality":25.0419,
"illegally":97.1550,
"illegitimate":65.1466,
"illicit":47.2595,
"illiteracy":19.3933,
"illiterate":48.2009,
"illness":684.0388,
"illogical":39.9164,
"illogically":6.0251,
"illuminate":172.6572,
"illuminated":25.4185,
"illuminating":17.1339,
"illumination":66.6528,
"illus":11.8619,
"illusion":218.4104,
"illustrate":999.2277,
"illustrated":21.4645,
"illustrating":0.1883,
"illustration":370.1680,
"illustrative":34.4561,
"illustrator":30.5021,
"illustrious":36.3390,
"image":2004.8570,
"imaged":0.7531,
"imagery":113.3475,
"imaginable":27.4896,
"imaginary":125.5860,
"imagination":467.6995,
"imaginative":187.1551,
"imagine":1482.9314,
"imagined":4.7071,
"imagines":0.5649,
"imaging":63.2637,
"imagining":16.1925,
"imam":3.7657,
"imbalance":109.0169,
"imf":0.3766,
"imitate":101.6738,
"imitation":122.1969,
"immaculate":76.8202,
"immaterial":35.0210,
"immature":78.5148,
"immaturity":12.4268,
"immediacy":29.5607,
"immediate":1071.9056,
"immediately":1824.8567,
"immense":255.3142,
"immensely":116.7366,
"immerse":65.8997,
"immersed":0.9414,
"immersion":40.4812,
"immigrant":211.6322,
"immigrate":1.6946,
"immigration":159.2890,
"imminent":142.9082,
"immoral":57.4269,
"immortal":49.7072,
"immortality":30.3139,
"immune":182.2597,
"immunity":124.8329,
"immunization":8.2845,
"immunodeficiency":8.8494,
"immunological":19.9582,
"immunology":8.4728,
"immutable":16.5691,
"imo":4.5188,
"imp":12.9917,
"impact":1382.0107,
"impair":90.7533,
"impaired":68.1591,
"impairment":85.2930,
"impala":1.6946,
"impart":67.2177,
"impartial":54.7909,
"impartiality":30.8787,
"impasse":29.5607,
"impatience":77.9499,
"impatient":119.9374,
"impeach":11.8619,
"impeachment":17.3222,
"impeccable":45.3766,
"impedance":55.3557,
"impede":64.9583,
"impediment":32.7616,
"impending":63.0754,
"imperative":143.8496,
"imperfect":63.8286,
"imperial":254.7494,
"imperialism":69.8537,
"imperialist":51.0252,
"impersonal":83.5985,
"impervious":26.1716,
"impetus":116.1717,
"implant":73.6194,
"implantation":18.0753,
"implement":797.0097,
"implementation":539.8126,
"implementing":0.5649,
"implicate":102.4270,
"implicated":1.5063,
"implicates":0.1883,
"implication":1048.5583,
"implicit":210.8790,
"implicitly":97.3433,
"implied":4.3306,
"implies":0.1883,
"imply":1095.2529,
"import":929.7505,
"importance":1724.5009,
"important":7051.2673,
"importantly":239.4983,
"importation":30.6904,
"importer":71.3600,
"importing":3.0126,
"imports":0.1883,
"impose":1245.6925,
"imposed":0.1883,
"imposing":5.2720,
"imposition":126.3391,
"impossibility":63.0754,
"impossible":1236.8431,
"impossibly":34.6444,
"impotence":31.6319,
"impoverished":54.7909,
"impractical":52.3432,
"imprecise":22.2176,
"impregnated":1.5063,
"impress":289.7704,
"impressed":272.8247,
"impression":873.6417,
"impressionism":3.5774,
"impressionist":24.6653,
"impressive":520.2310,
"imprint":77.1968,
"imprinted":0.9414,
"imprison":169.4564,
"imprisoned":0.3766,
"imprisonment":249.6657,
"improbable":68.9123,
"impromptu":29.9373,
"improper":66.6528,
"improperly":19.9582,
"improve":2331.1546,
"improved":205.7953,
"improvement":1168.8723,
"improving":2.2594,
"improvisation":36.5273,
"impulse":204.6656,
"impulsive":36.5273,
"impunity":18.0753,
"impure":12.2385,
"impurity":31.6319,
"imputation":11.4854,
"in":349080.2850,
"inability":198.8288,
"inaccessible":60.6277,
"inaccuracy":31.0670,
"inaccurate":83.5985,
"inaction":22.4059,
"inactivated":0.1883,
"inactivation":8.0962,
"inactive":55.9206,
"inactivity":28.0544,
"inadequacy":106.9458,
"inadequate":419.6869,
"inadequately":36.1507,
"inadvertent":13.5565,
"inadvertently":58.5566,
"inappropriacy":0.1883,
"inappropriate":224.8121,
"inappropriately":22.2176,
"inasmuch":19.2051,
"inaudible":15.6276,
"inaugural":61.0043,
"inauguration":31.6319,
"inbound":7.1548,
"inbred":9.2260,
"inc":0.3766,
"inca":3.9540,
"incandescent":18.0753,
"incapable":149.6864,
"incapacitate":24.4770,
"incapacitated":3.5774,
"incapacity":28.0544,
"incarcerated":0.3766,
"incarceration":12.4268,
"incarnation":38.5984,
"incense":64.3934,
"incentive":421.9463,
"inception":50.4603,
"incessant":25.6067,
"incest":54.0377,
"inch":841.2567,
"incidence":307.4691,
"incident":919.3949,
"incidental":69.4771,
"incidentally":190.1677,
"incineration":27.6779,
"incinerator":41.9875,
"incision":16.9456,
"incl":14.3096,
"inclement":6.2134,
"inclination":117.4897,
"incline":93.7659,
"inclined":209.9376,
"include":10231.7749,
"included":0.5649,
"includes":0.5649,
"inclusion":216.1510,
"inclusive":78.3265,
"incoherent":28.9959,
"incoherently":6.4017,
"income":2394.2300,
"incoming":88.6822,
"incomparable":18.0753,
"incompatibility":28.2427,
"incompatible":115.7952,
"incompetence":65.7114,
"incompetent":70.9834,
"incomplete":125.5860,
"incompletely":5.8368,
"incompleteness":7.5314,
"incomprehensible":62.5106,
"inconceivable":45.1884,
"inconceivably":2.2594,
"inconclusive":40.4812,
"inconclusively":3.9540,
"inconsistency":81.7156,
"inconsistent":111.6529,
"inconstancy":3.0126,
"incontinence":42.9289,
"inconvenience":87.7407,
"inconvenient":54.2260,
"incorporate":759.3528,
"incorporated":15.8159,
"incorporating":0.7531,
"incorporation":90.7533,
"incorrect":123.1383,
"incorrectly":46.8829,
"increase":7602.9419,
"increased":16.0042,
"increasing":1.5063,
"increasingly":1193.5376,
"incredible":211.8204,
"incredibly":143.4730,
"increment":37.2804,
"incremental":43.4938,
"incrementally":3.9540,
"incubation":42.9289,
"incubator":15.6276,
"incubus":4.1423,
"incumbent":98.8495,
"incur":300.8792,
"incurable":23.3473,
"incurred":0.3766,
"incurring":0.7531,
"indebted":41.0461,
"indebtedness":24.8536,
"indecent":69.6654,
"indeed":3274.8383,
"indefinite":55.7323,
"indefinitely":90.7533,
"indemnification":0.9414,
"indemnify":23.9122,
"indemnity":117.3015,
"indent":22.5942,
"indentation":16.1925,
"indented":15.4394,
"indenture":15.4394,
"independence":757.8465,
"independent":1657.8480,
"independently":248.1594,
"indeterminate":36.1507,
"index":927.6794,
"indexed":8.8494,
"indexes":0.1883,
"indexing":77.9499,
"india":1.6946,
"indian":559.2060,
"indiana":0.3766,
"indicate":2145.6941,
"indicated":0.1883,
"indicating":1.5063,
"indication":551.1097,
"indicative":93.7659,
"indicator":318.3897,
"indicators":0.3766,
"indictment":67.9708,
"indie":49.1423,
"indifference":105.4395,
"indifferent":108.0755,
"indigenous":168.7032,
"indigent":5.8368,
"indignation":73.6194,
"indigo":7.9080,
"indirect":268.1176,
"indirectly":187.1551,
"indiscretion":21.4645,
"indiscriminate":35.9624,
"indispensable":80.5859,
"indistinct":18.6402,
"indistinctly":3.0126,
"indistinguishable":53.8495,
"individual":4846.2635,
"individualised":16.0042,
"individualism":68.7240,
"individualist":41.7992,
"individualistic":38.5984,
"individuality":70.9834,
"individualized":9.0377,
"individually":199.3936,
"indonesian":57.6152,
"indoor":177.3643,
"indoors":40.6695,
"induce":474.1012,
"induced":11.4854,
"induction":125.9626,
"inductive":18.8285,
"indulge":183.7660,
"indulgence":64.0168,
"indulgent":42.1758,
"industrial":1927.4719,
"industrialization":60.8160,
"industrialized":15.2511,
"industrially":12.0502,
"industry":3933.4586,
"ineffective":118.9960,
"ineffectively":5.0837,
"inefficiency":63.0754,
"inefficient":106.1927,
"inelastic":14.4979,
"ineligible":25.4185,
"inept":31.0670,
"inequality":255.3142,
"inert":53.6612,
"inertia":62.3223,
"inertial":11.1088,
"inevitability":37.6570,
"inevitable":494.4360,
"inevitably":551.4863,
"inexpensive":57.8034,
"inexpensively":1.8828,
"inexperienced":89.8119,
"inexplicable":44.2469,
"infallible":26.9247,
"infamous":57.9917,
"infancy":72.8662,
"infant":424.9589,
"infantry":79.6445,
"infarction":51.7783,
"infect":206.9250,
"infected":61.5691,
"infection":623.7877,
"infectious":85.4813,
"infer":130.1048,
"inference":136.8831,
"inferior":154.7701,
"infernal":8.0962,
"inferno":16.1925,
"infertility":22.5942,
"infestation":22.9708,
"infested":2.8243,
"infidel":6.9665,
"infidelity":24.6653,
"infiltrate":57.0503,
"infiltration":36.7155,
"infinite":164.3727,
"infinitely":104.4981,
"infinity":52.5315,
"infirmary":30.8787,
"inflamed":15.2511,
"inflammation":83.9750,
"inflammatory":142.3433,
"inflatable":22.4059,
"inflate":65.5231,
"inflated":15.0628,
"inflation":847.0935,
"inflationary":78.3265,
"inflexibility":10.3557,
"inflexible":43.8704,
"inflict":205.6070,
"inflicted":0.1883,
"inflow":41.0461,
"influence":2699.2515,
"influencing":3.7657,
"influential":320.8374,
"influenza":24.8536,
"influx":74.9374,
"info":30.3139,
"inform":943.8719,
"informacion":0.1883,
"informal":426.8417,
"informally":53.8495,
"informant":86.4227,
"information":6496.0153,
"informational":18.0753,
"informative":98.6613,
"informed":167.7618,
"informer":34.4561,
"informing":1.1297,
"infra":45.1884,
"infraction":5.8368,
"infrared":37.4687,
"infrastructure":180.9417,
"infrequent":47.0712,
"infrequently":41.9875,
"infringe":67.9708,
"infringement":79.4562,
"infused":0.1883,
"infusion":82.4688,
"inge":0.1883,
"ingenious":80.0211,
"ingenuity":63.2637,
"ingested":0.5649,
"ingestion":33.8913,
"ingredient":324.7914,
"ingress":5.8368,
"inhabit":135.1885,
"inhabited":11.8619,
"inhalation":19.0168,
"inhale":52.7198,
"inhaled":1.1297,
"inhaler":13.1799,
"inherent":234.9795,
"inherently":76.6319,
"inherit":365.4609,
"inheritance":214.2681,
"inherited":2.4477,
"inherits":0.1883,
"inhibit":237.8038,
"inhibited":6.7783,
"inhibiting":1.3180,
"inhibition":170.5861,
"inhibitor":73.8077,
"inhibitory":40.1047,
"inhuman":33.1381,
"iniquity":16.1925,
"initial":1249.0816,
"initialization":0.5649,
"initialize":1.8828,
"initially":675.0012,
"initiate":389.3731,
"initiating":2.8243,
"initiation":78.1382,
"initiative":907.5329,
"initiator":15.2511,
"inject":192.0505,
"injecting":1.5063,
"injection":245.1469,
"injector":17.5105,
"injunction":184.5191,
"injure":626.8002,
"injured":22.9708,
"injures":0.1883,
"injuring":0.3766,
"injurious":16.3808,
"injury":1286.7386,
"injustice":131.2345,
"ink":169.6446,
"inky":11.1088,
"inland":151.0044,
"inlay":34.6444,
"inlet":45.0001,
"inmate":122.1969,
"inn":131.6111,
"innate":75.8788,
"inner":809.6248,
"innermost":20.8996,
"inning":30.5021,
"innings":91.8830,
"innocence":162.1132,
"innocent":396.5279,
"innocently":44.8118,
"innocuous":35.2093,
"innovate":25.4185,
"innovated":0.1883,
"innovation":419.8752,
"innovative":180.0003,
"innovator":29.3724,
"innumerable":56.6737,
"inoculation":15.8159,
"inoffensive":9.2260,
"inoffensively":0.1883,
"inorganic":36.1507,
"inpatient":29.3724,
"input":738.6414,
"inquire":93.7659,
"inquirer":4.7071,
"inquiring":0.1883,
"inquiry":739.2063,
"inquisition":10.5440,
"ins":0.9414,
"insane":65.1466,
"insanely":6.7783,
"insanity":37.0921,
"insatiable":28.6193,
"inscribed":0.5649,
"inscription":95.2721,
"insect":388.9965,
"insecticide":33.3264,
"insecure":60.4394,
"insecurity":75.5022,
"insensitive":58.7449,
"inseparable":50.6486,
"insert":389.1848,
"inserted":0.1883,
"inserting":1.1297,
"insertion":82.4688,
"inset":61.5691,
"inside":2505.8830,
"insider":197.1342,
"insidious":33.5147,
"insight":388.8082,
"insightful":5.0837,
"insignia":30.6904,
"insignificant":96.2136,
"insignificantly":2.2594,
"insist":1188.6422,
"insistence":147.8036,
"insisting":0.5649,
"insofar":50.4603,
"insole":3.0126,
"insoluble":34.4561,
"insolvency":57.8034,
"insolvent":35.9624,
"insomnia":17.1339,
"inspect":256.2557,
"inspecting":0.7531,
"inspection":408.0133,
"inspector":391.0676,
"inspectorate":61.3809,
"inspiration":244.5820,
"inspirational":29.5607,
"inspire":489.5406,
"inspired":16.1925,
"inspires":0.1883,
"inspiring":44.6235,
"inst":2.8243,
"instability":114.4772,
"install":147.8036,
"installation":311.4231,
"installed":1.3180,
"installer":10.9205,
"installing":0.7531,
"installment":1.1297,
"installs":0.1883,
"instalment":109.0169,
"instance":1932.1790,
"instant":363.3897,
"instantaneous":41.6110,
"instantaneously":20.7113,
"instantiate":6.9665,
"instantiation":3.3891,
"instantly":280.7327,
"instead":2580.2555,
"instill":31.8201,
"instinct":299.7495,
"instinctively":106.1927,
"institute":213.5150,
"instituted":0.1883,
"institutes":0.9414,
"institution":1570.6722,
"institutional":343.6198,
"institutionalise":23.1590,
"institutionalised":8.0962,
"institutionalized":8.8494,
"institutionalizing":0.5649,
"institutionally":6.4017,
"instruct":319.8959,
"instructing":0.1883,
"instruction":1038.3909,
"instructional":23.7239,
"instructive":51.9666,
"instructor":144.7910,
"instrument":872.3237,
"instrumental":163.6195,
"instrumentation":27.3013,
"insufficiency":12.9917,
"insufficient":236.6740,
"insufficiently":30.5021,
"insulated":16.7574,
"insulating":3.2008,
"insulation":98.6613,
"insulator":15.0628,
"insulin":146.2973,
"insult":215.7744,
"insulting":36.3390,
"insurance":1068.5165,
"insure":190.3560,
"insured":16.0042,
"insurer":119.3726,
"insurgency":18.4519,
"insurgent":21.2762,
"insuring":0.3766,
"int":117.1132,
"intact":217.2807,
"intake":214.6447,
"intangible":39.5398,
"integer":69.6654,
"integral":222.7410,
"integrate":578.0345,
"integrated":106.1927,
"integrating":1.8828,
"integration":412.7204,
"integrative":12.8034,
"integrator":24.6653,
"integrity":253.4314,
"intellect":82.6570,
"intellectual":660.5032,
"intellectually":57.9917,
"intelligence":541.5072,
"intelligent":334.0173,
"intelligently":25.9833,
"intelligible":42.9289,
"intend":1983.5808,
"intended":32.0084,
"intending":5.8368,
"intense":416.2978,
"intensely":100.3558,
"intenseness":0.1883,
"intensification":35.9624,
"intensified":1.1297,
"intensify":167.9501,
"intensifying":1.5063,
"intension":0.9414,
"intensity":310.8583,
"intensive":356.4232,
"intensively":33.1381,
"intent":353.9755,
"intention":1107.6797,
"intentional":47.6361,
"intentionally":41.6110,
"intently":73.6194,
"inter":400.8584,
"interact":176.6112,
"interacting":0.5649,
"interaction":602.5115,
"interactive":124.0797,
"interactively":8.4728,
"interactivity":6.7783,
"intercept":93.0127,
"interception":26.3599,
"interceptor":5.4603,
"interchange":71.9248,
"interchangeable":32.3850,
"interchangeably":8.8494,
"intercollegiate":0.1883,
"intercom":15.6276,
"interconnect":35.2093,
"interconnected":5.0837,
"interconnection":23.7239,
"intercontinental":10.3557,
"intercourse":163.4312,
"intercultural":0.5649,
"interdependence":35.7741,
"interdependent":31.8201,
"interdisciplinary":44.4352,
"interest":6877.2921,
"interested":1571.0487,
"interesting":1708.6849,
"interestingly":124.6446,
"interface":395.7747,
"interfaces":0.5649,
"interfacing":5.4603,
"interfaith":0.9414,
"interfere":312.9294,
"interference":252.3017,
"interfering":3.5774,
"interferon":30.5021,
"intergovernmental":28.9959,
"interim":317.6365,
"interior":415.5446,
"interleukin":8.6611,
"interlink":13.3682,
"interlock":43.6821,
"interlocking":4.3306,
"interlude":35.7741,
"intermediary":105.2512,
"intermediate":243.0757,
"interment":6.5900,
"intermittent":60.6277,
"intermittently":36.5273,
"intern":22.0293,
"internal":1128.9559,
"internalise":9.7908,
"internalised":2.0711,
"internalize":19.5816,
"internalized":2.4477,
"internally":111.2763,
"international":2532.4311,
"internationale":0.1883,
"internationalization":11.1088,
"internationally":131.2345,
"internet":12.9917,
"internship":1.1297,
"interoperability":25.2302,
"interoperable":5.2720,
"interpersonal":53.8495,
"interplay":41.6110,
"interpol":1.1297,
"interpolated":0.3766,
"interpolation":12.8034,
"interpret":753.1394,
"interpretation":943.3071,
"interpretative":32.9498,
"interpreter":114.1006,
"interpreting":22.5942,
"interpretive":17.1339,
"interracial":1.6946,
"interrelated":33.1381,
"interrogation":65.3348,
"interrupt":358.8709,
"interrupted":11.2971,
"interrupting":5.8368,
"interruption":102.6152,
"intersect":34.6444,
"intersecting":0.3766,
"intersection":54.2260,
"interspersed":0.5649,
"interstate":7.5314,
"interstellar":12.2385,
"interstitial":10.7322,
"interval":508.3691,
"intervene":356.7998,
"intervened":0.3766,
"intervening":9.7908,
"intervention":658.0555,
"interview":1592.1366,
"interviewer":142.9082,
"interviewing":26.3599,
"intestinal":151.0044,
"intestine":86.2345,
"intimacy":106.3809,
"intimate":235.7326,
"intimately":70.7951,
"intimidate":82.0922,
"intimidated":4.3306,
"intimidating":25.2302,
"intimidation":52.9080,
"into":28575.6139,
"intolerable":88.3056,
"intolerance":49.1423,
"intolerant":24.6653,
"intonation":79.0796,
"intoxicated":7.3431,
"intoxicating":13.7448,
"intoxication":13.5565,
"intracellular":35.3976,
"intractable":38.7867,
"intramural":3.9540,
"intravenous":63.8286,
"intrepid":21.6528,
"intricate":94.1424,
"intrigue":137.0714,
"intrigued":1.1297,
"intriguing":106.1927,
"intrinsic":117.3015,
"intrinsically":46.1298,
"intro":18.4519,
"introduce":2587.2220,
"introduced":0.5649,
"introduces":2.8243,
"introducing":0.5649,
"introduction":1045.3574,
"introductory":93.0127,
"introspection":23.1590,
"intruder":83.9750,
"intrusion":97.9081,
"intrusive":47.4478,
"intuit":2.8243,
"intuition":99.4144,
"intuitive":83.7868,
"intuitively":35.0210,
"inuit":0.1883,
"invade":203.5359,
"invader":52.1549,
"invading":3.0126,
"invalid":135.1885,
"invalidate":38.0335,
"invalidity":26.3599,
"invaluable":145.7325,
"invaluably":0.7531,
"invariable":16.1925,
"invariably":276.5904,
"invariance":4.5188,
"invariant":26.7364,
"invasion":366.9672,
"invasive":38.4101,
"invent":346.4441,
"invented":0.1883,
"inventing":0.9414,
"invention":225.0004,
"inventive":41.2344,
"inventor":60.8160,
"inventors":0.1883,
"inventory":114.6655,
"inverse":59.4980,
"inversely":21.2762,
"inversion":58.7449,
"invert":84.3516,
"invertebrate":61.9457,
"inverted":40.4812,
"inverter":4.5188,
"invest":665.0221,
"investigate":996.9682,
"investigation":1133.4747,
"investigations":0.1883,
"investigative":51.2135,
"investigator":190.5443,
"investing":12.8034,
"investment":2116.1333,
"investor":623.0345,
"invigorating":2.4477,
"invincible":19.9582,
"invisibility":18.0753,
"invisible":216.9041,
"invitation":389.1848,
"invitational":0.7531,
"invite":1186.7594,
"inviting":5.2720,
"invocation":16.5691,
"invoice":136.5065,
"invoicing":6.5900,
"invoke":178.1175,
"invoking":0.3766,
"involuntarily":38.7867,
"involuntary":66.6528,
"involve":5550.0723,
"involved":247.0297,
"involvement":755.0222,
"involves":0.3766,
"involving":0.5649,
"inward":134.4354,
"inwardly":45.7532,
"io":0.3766,
"iodine":15.8159,
"ion":174.3518,
"ionic":36.5273,
"ionization":8.4728,
"ip":57.6152,
"iq":38.9750,
"ir":30.3139,
"ira":2.0711,
"iran":0.3766,
"iranian":158.7241,
"iraq":4.5188,
"iraqi":313.1177,
"ire":7.5314,
"ireland":0.3766,
"iridium":3.5774,
"iris":29.1842,
"irish":707.7627,
"iron":963.8301,
"ironic":127.4688,
"ironically":174.1635,
"ironing":46.6946,
"irony":181.5066,
"iroquois":0.1883,
"irradiated":3.5774,
"irradiation":30.3139,
"irrational":91.5064,
"irreducible":23.7239,
"irregular":136.8831,
"irregularly":23.9122,
"irrelevance":24.6653,
"irrelevant":241.3812,
"irreplaceable":13.3682,
"irresistible":88.1173,
"irrespective":153.8287,
"irrespectively":0.3766,
"irresponsible":76.4436,
"irreverent":17.5105,
"irreversible":47.8243,
"irrevocable":24.2887,
"irrevocably":23.9122,
"irrigated":0.3766,
"irrigation":44.8118,
"irritability":18.8285,
"irritable":59.8746,
"irritate":138.7659,
"irritated":40.4812,
"irritating":25.4185,
"irritation":125.9626,
"is":744.8548,
"isaac":0.5649,
"isabella":0.1883,
"islamic":157.0296,
"island":1259.6256,
"islander":45.0001,
"islands":0.1883,
"isle":19.7699,
"ism":9.0377,
"isn":0.5649,
"isolate":419.4986,
"isolated":216.1510,
"isolation":339.1010,
"isolationism":9.4142,
"isolde":0.5649,
"isomorphic":3.9540,
"isomorphism":3.0126,
"isotope":63.8286,
"isotopic":16.1925,
"isotropic":14.3096,
"israel":1.6946,
"israeli":313.8708,
"issuance":21.2762,
"issue":6229.7806,
"issued":2.0711,
"issuer":41.2344,
"issues":1.3180,
"issuing":18.2636,
"it":189336.7892,
"italian":773.2858,
"italic":40.2930,
"italicized":1.3180,
"italy":2.2594,
"itch":48.2009,
"itching":14.1214,
"itchy":16.7574,
"item":1847.0743,
"itemisation":0.5649,
"itemise":13.3682,
"itemised":1.3180,
"itemized":0.9414,
"items":8.4728,
"iterate":9.7908,
"iteration":36.3390,
"iterative":10.9205,
"itinerary":45.5649,
"its":28885.3424,
"itself":4195.7394,
"iv":18.4519,
"iva":1.6946,
"ives":0.1883,
"ivory":113.5358,
"ivy":52.7198,
"ix":8.8494,
"j":24.4770,
"jab":60.6277,
"jabber":6.9665,
"jack":82.0922,
"jackass":1.1297,
"jacket":632.2605,
"jackets":0.1883,
"jacking":2.2594,
"jackpot":21.4645,
"jackson":2.2594,
"jacob":2.8243,
"jacquard":22.7825,
"jade":57.6152,
"jaded":19.9582,
"jag":6.2134,
"jagged":45.7532,
"jagger":4.1423,
"jaguar":7.7197,
"jail":394.2685,
"jailed":2.4477,
"jakarta":0.1883,
"jam":263.5988,
"jamaica":0.1883,
"jamaican":36.7155,
"jamboree":8.0962,
"jammed":24.8536,
"jamming":6.5900,
"jams":0.1883,
"janitorial":0.5649,
"january":3.3891,
"janus":0.1883,
"japan":0.3766,
"japanese":872.8885,
"jar":194.6865,
"jargon":90.9416,
"jasmine":15.0628,
"jason":5.0837,
"jasper":2.0711,
"javelin":12.6151,
"jaw":282.8038,
"jaws":0.5649,
"jay":6.5900,
"jazz":186.4020,
"jazzy":6.0251,
"jealous":163.8078,
"jealously":23.5356,
"jealousy":130.2931,
"jean":217.6573,
"jeans":0.1883,
"jeep":83.5985,
"jelly":97.3433,
"jenny":1.5063,
"jeopardize":31.8201,
"jeopardy":36.3390,
"jeremiah":0.9414,
"jerk":207.1133,
"jerked":0.3766,
"jerking":2.2594,
"jerky":15.0628,
"jerry":6.4017,
"jersey":30.5021,
"jest":16.7574,
"jester":9.9791,
"jesuit":7.1548,
"jet":336.2767,
"jetty":42.5524,
"jew":0.3766,
"jewel":140.4605,
"jeweller":45.3766,
"jewellery":208.9962,
"jewelry":1.3180,
"jewish":405.1890,
"jig":37.4687,
"jigsaw":51.9666,
"jihad":2.2594,
"jimmy":0.5649,
"jingle":23.1590,
"jinx":6.5900,
"jitter":13.7448,
"jive":3.9540,
"job":5788.2526,
"jobless":44.2469,
"jobs":9.9791,
"jock":10.1674,
"jockey":140.0839,
"jockeys":0.3766,
"jog":71.1717,
"jogger":18.8285,
"jogging":22.7825,
"john":0.1883,
"johnny":21.6528,
"johnson":1.1297,
"join":3105.5702,
"joined":2.0711,
"joiner":27.4896,
"joining":12.8034,
"joint":1312.3453,
"jointed":10.7322,
"jointly":201.6531,
"joke":737.7000,
"joker":25.2302,
"jokes":0.1883,
"joking":11.4854,
"jolly":122.9500,
"jolt":63.0754,
"jonathan":0.1883,
"jones":0.3766,
"jordan":0.9414,
"jordanian":41.0461,
"josh":1.5063,
"joshua":0.1883,
"journal":368.6617,
"journalism":100.1675,
"journalist":544.5198,
"journalistic":34.4561,
"journalists":0.5649,
"journey":999.0394,
"journeyed":0.1883,
"journeying":3.7657,
"journeyman":24.4770,
"joy":469.2058,
"joyful":37.2804,
"joyfully":14.4979,
"joyous":28.9959,
"joystick":21.0879,
"ju":9.2260,
"jubilee":4.8954,
"judaism":5.6485,
"judge":1935.3799,
"judgement":584.0596,
"judgemental":11.2971,
"judging":23.1590,
"judgment":643.1810,
"judicial":426.6535,
"judiciary":87.3642,
"judicious":31.0670,
"judo":17.3222,
"jug":113.9123,
"juggling":15.2511,
"juice":295.4189,
"juicer":0.5649,
"juicy":34.2678,
"jukebox":12.2385,
"julian":2.8243,
"july":2.8243,
"jumble":81.1508,
"jumbo":33.7030,
"jump":1112.5751,
"jumped":0.3766,
"jumper":131.0462,
"jumping":41.0461,
"junction":372.0508,
"juncture":31.2553,
"june":1.8828,
"jungle":168.3266,
"junior":425.5237,
"juniors":0.1883,
"juniper":13.5565,
"junk":120.8789,
"junkie":25.6067,
"junta":23.5356,
"jupiter":0.1883,
"jurassic":3.9540,
"jurisdiction":340.7956,
"jurisdictional":29.7490,
"jurisprudence":14.4979,
"juror":34.4561,
"jury":426.4652,
"just":23003.5123,
"justice":836.3613,
"justifiable":55.7323,
"justifiably":37.2804,
"justification":351.5278,
"justified":54.0377,
"justify":818.2859,
"justifying":0.7531,
"justly":35.2093,
"jute":9.9791,
"juvenile":148.7450,
"k":192.6154,
"ka":0.7531,
"kahuna":0.1883,
"kaiser":1.1297,
"kalahari":0.1883,
"kalamazoo":0.1883,
"kaleidoscope":18.2636,
"kali":0.3766,
"kampala":0.1883,
"kangaroo":13.1799,
"kant":0.1883,
"karaoke":9.0377,
"karate":28.2427,
"karen":1.5063,
"karma":1.1297,
"kart":9.0377,
"kat":0.1883,
"kata":0.3766,
"kayak":18.6402,
"kayaking":1.3180,
"kazakh":1.1297,
"kb":24.8536,
"kc":0.3766,
"keel":38.9750,
"keen":665.9635,
"keenly":57.0503,
"keep":8991.9192,
"keeper":288.0758,
"keeping":89.6236,
"keeps":2.4477,
"keepsake":7.7197,
"keller":0.1883,
"kelvin":1.3180,
"ken":1.3180,
"kendal":0.5649,
"kennedy":1.1297,
"kennel":48.0126,
"keno":0.1883,
"kenyan":26.3599,
"kepler":0.3766,
"kept":8.6611,
"kern":1.1297,
"kernel":48.0126,
"kerosene":8.6611,
"kestrel":14.6862,
"ketchup":15.2511,
"kettle":158.3476,
"key":2563.4981,
"keyboard":199.9585,
"keyed":0.1883,
"keying":0.7531,
"keynote":30.8787,
"keypad":8.2845,
"keyring":3.0126,
"keystone":10.7322,
"keystroke":8.0962,
"keyword":86.9876,
"kg":216.7159,
"kgb":0.1883,
"khaki":17.8871,
"khan":0.5649,
"khmer":0.3766,
"khz":6.5900,
"ki":0.1883,
"kick":979.6460,
"kickboxing":0.3766,
"kicked":0.5649,
"kicker":13.5565,
"kicking":32.7616,
"kickoff":1.1297,
"kid":1062.1148,
"kidding":3.9540,
"kidnap":115.4186,
"kidnapped":4.5188,
"kidnapping":44.0587,
"kidney":153.2639,
"kidneys":0.1883,
"kids":0.1883,
"kiev":0.9414,
"kill":2799.2307,
"killed":1.5063,
"killer":311.2348,
"killing":291.0884,
"kills":0.1883,
"kiln":50.0838,
"kilo":57.2386,
"kilogram":32.9498,
"kilometer":5.6485,
"kilometre":247.9711,
"kilowatt":12.8034,
"kilt":17.3222,
"kimono":7.7197,
"kin":91.6947,
"kind":5148.8373,
"kinda":24.1005,
"kinder":3.0126,
"kindergarten":17.8871,
"kindly":218.7870,
"kindness":126.5274,
"kindred":15.0628,
"kinematic":7.1548,
"kinetic":50.6486,
"king":1394.6258,
"kingdom":323.0968,
"kingfisher":17.5105,
"kings":0.9414,
"kinky":12.4268,
"kinsey":1.1297,
"kinship":97.1550,
"kiosk":42.3641,
"kip":13.1799,
"kipling":1.3180,
"kirk":1.6946,
"kirsch":0.1883,
"kiss":945.1899,
"kissed":0.1883,
"kissing":11.2971,
"kit":333.4525,
"kitchen":1467.3038,
"kitchener":0.1883,
"kitchenette":12.8034,
"kitchens":0.7531,
"kitchenware":3.3891,
"kite":158.7241,
"kitten":74.1842,
"kitty":12.4268,
"kiwi":13.1799,
"klan":0.3766,
"klein":0.1883,
"km":423.2643,
"knack":44.8118,
"knee":817.3445,
"kneel":173.9752,
"kneeling":11.8619,
"knelt":2.0711,
"knew":2.2594,
"knife":632.0722,
"knight":228.9544,
"knights":0.3766,
"knit":463.9339,
"knitted":11.4854,
"knitting":170.5861,
"knitwear":22.9708,
"knob":81.5273,
"knock":969.4787,
"knocked":0.5649,
"knocking":14.1214,
"knockout":28.0544,
"knoll":3.5774,
"knot":254.3728,
"knotted":14.6862,
"knotting":5.4603,
"know":31768.5482,
"knowing":25.2302,
"knowingly":53.2846,
"knowledge":2609.8162,
"knowledgeable":61.0043,
"known":142.5316,
"knows":1.3180,
"knuckle":86.0462,
"ko":0.7531,
"koala":3.0126,
"kohl":3.9540,
"korea":0.3766,
"korean":182.4480,
"kosher":6.7783,
"kph":0.7531,
"kraft":0.1883,
"kris":0.1883,
"krona":4.5188,
"krone":4.8954,
"kroner":7.1548,
"ks":0.1883,
"kt":0.7531,
"kurdish":91.6947,
"kuwaiti":0.7531,
"kw":10.3557,
"ky":0.1883,
"l":389.3731,
"la":24.8536,
"lab":122.7617,
"label":891.1522,
"labeling":1.1297,
"labelled":0.1883,
"labelling":81.3391,
"labia":3.5774,
"labor":15.2511,
"laboratory":504.4151,
"labored":0.1883,
"laborer":0.9414,
"labour":2391.7823,
"laboured":9.4142,
"labourer":167.9501,
"labouring":5.0837,
"labrador":15.2511,
"labs":1.1297,
"labyrinth":31.6319,
"lac":3.0126,
"lace":288.2641,
"laced":4.3306,
"lack":2346.4057,
"lacked":0.1883,
"lacking":54.6026,
"lacks":0.1883,
"lacquer":42.1758,
"lacrosse":3.2008,
"lactate":8.4728,
"lactation":8.8494,
"lactic":6.9665,
"lactose":11.6737,
"lacy":19.2051,
"lad":582.1767,
"ladder":279.7913,
"laden":93.3893,
"lady":1427.7640,
"lag":154.2053,
"lager":97.9081,
"lagged":1.3180,
"lagging":0.7531,
"lagoon":38.5984,
"laid":4.8954,
"lain":11.1088,
"lair":20.7113,
"laird":16.9456,
"lake":559.0177,
"lakeside":29.7490,
"lam":1.5063,
"lama":3.3891,
"lamb":204.6656,
"lambda":20.1465,
"lambert":1.8828,
"lame":47.2595,
"lament":77.7616,
"lamented":0.3766,
"laminate":23.7239,
"laminated":16.1925,
"laminating":0.1883,
"lamp":392.5739,
"lampoon":6.2134,
"lan":18.8285,
"lanai":0.1883,
"lancaster":1.1297,
"lance":52.7198,
"lancer":3.0126,
"lancet":5.0837,
"land":4305.1329,
"landau":1.3180,
"landed":3.5774,
"lander":4.3306,
"landfill":51.7783,
"landing":383.3479,
"landlord":530.0218,
"landmark":117.4897,
"landowner":194.8748,
"landscape":666.1518,
"landscaped":17.8871,
"landscaping":27.6779,
"landslide":33.5147,
"landslides":0.1883,
"lane":437.0091,
"language":3829.5254,
"lantern":61.5691,
"lanyard":2.2594,
"lao":0.1883,
"lap":323.8499,
"lapel":33.1381,
"laplace":0.7531,
"lapse":142.1551,
"lapsed":0.1883,
"laptop":17.3222,
"large":8856.3541,
"largely":1315.9228,
"larger":2.8243,
"largest":2.6360,
"largo":0.3766,
"lark":39.1632,
"larkspur":3.3891,
"larvae":86.0462,
"larval":27.1130,
"laser":226.8832,
"lash":167.5735,
"lashes":0.1883,
"lass":86.2345,
"last":14154.6896,
"lasted":0.3766,
"lasting":58.9332,
"lastly":76.2554,
"lat":1.3180,
"latch":71.9248,
"late":4799.0040,
"lately":149.3099,
"latency":19.5816,
"lateness":13.9331,
"latent":118.0546,
"later":6768.4635,
"lateral":116.5483,
"laterally":22.5942,
"latest":16.3808,
"latex":16.9456,
"lathe":28.4310,
"latin":172.8455,
"latino":6.4017,
"latitude":68.7240,
"latter":1373.3496,
"lattice":77.9499,
"latvia":0.3766,
"latvian":23.9122,
"lauded":0.1883,
"laugh":1883.4133,
"laughable":21.6528,
"laughing":12.9917,
"laughs":0.1883,
"laughter":369.4149,
"launch":1569.9190,
"launcher":29.1842,
"launches":0.1883,
"launching":19.5816,
"laundering":19.9582,
"laundry":87.9290,
"laureate":7.5314,
"laurel":21.6528,
"lava":81.9039,
"lavatory":130.4814,
"lavender":46.6946,
"lavish":102.2387,
"law":5251.0760,
"lawful":86.2345,
"lawfully":26.9247,
"lawless":11.4854,
"lawn":237.9920,
"laws":0.1883,
"lawsuit":34.4561,
"lawton":0.1883,
"lawyer":766.6959,
"lax":28.6193,
"lay":1966.2586,
"layer":696.0891,
"layered":17.5105,
"layering":15.8159,
"laying":22.7825,
"layman":59.1214,
"layoff":4.7071,
"layout":238.1803,
"layup":0.1883,
"lazily":41.0461,
"laziness":19.0168,
"lazy":147.8036,
"lb":341.5487,
"lcd":15.8159,
"le":2.8243,
"lea":72.6779,
"leach":24.2887,
"leaching":17.8871,
"lead":8069.1352,
"leaded":14.8745,
"leader":2713.9377,
"leadership":838.8090,
"leading":38.2218,
"leads":0.1883,
"leaf":331.9462,
"leaflet":339.2893,
"leafy":33.8913,
"league":465.0636,
"leak":305.0214,
"leakage":49.8955,
"leaking":5.0837,
"leaky":14.3096,
"lean":945.3782,
"leaned":0.1883,
"leaning":19.2051,
"leap":469.2058,
"leaped":0.1883,
"leapfrog":10.9205,
"leaping":3.3891,
"lear":1.5063,
"learn":3705.0691,
"learned":13.7448,
"learner":245.9000,
"learning":842.1981,
"learnt":0.3766,
"lease":538.6829,
"leasehold":35.5858,
"leash":34.2678,
"leasing":43.4938,
"least":5495.6580,
"leather":480.6912,
"leave":12886.4029,
"leaved":10.7322,
"leaving":16.9456,
"lebanese":87.5525,
"lebanon":0.1883,
"lecture":622.8463,
"lecturer":237.2389,
"lectures":0.7531,
"lecturing":8.6611,
"led":20.8996,
"ledge":87.3642,
"ledger":65.7114,
"lee":1.1297,
"leech":21.4645,
"leeds":3.0126,
"leek":29.5607,
"left":2003.1624,
"leftist":30.5021,
"leftover":20.5230,
"lefty":4.5188,
"leg":2008.9993,
"legacy":207.8665,
"legal":2126.1124,
"legality":47.2595,
"legalized":0.1883,
"legally":205.6070,
"legend":271.3185,
"legendary":119.1843,
"leger":3.7657,
"legged":93.0127,
"legible":17.1339,
"legion":47.6361,
"legislate":59.4980,
"legislating":0.3766,
"legislation":1261.3202,
"legislative":292.9712,
"legislator":60.4394,
"legislature":155.5233,
"legit":5.4603,
"legitimacy":125.9626,
"legitimate":298.6198,
"legitimately":48.5775,
"lego":1.1297,
"legs":1.1297,
"lei":1.8828,
"leicester":1.1297,
"leigh":0.9414,
"leipzig":0.3766,
"leisure":440.7748,
"leisurely":71.7365,
"lek":1.1297,
"lemma":5.0837,
"lemon":193.3685,
"lemonade":37.2804,
"lemony":3.7657,
"lend":484.2686,
"lender":181.6949,
"lending":167.5735,
"length":1681.3836,
"lengthen":71.7365,
"lengthening":4.7071,
"lengthy":210.1259,
"leningrad":0.5649,
"lens":124.0797,
"lent":2.6360,
"leonardo":0.1883,
"leone":0.1883,
"leopard":53.4729,
"leprosy":11.6737,
"les":2.0711,
"lesbian":179.8120,
"lesbianism":18.4519,
"lesion":143.4730,
"less":7302.8159,
"lessee":35.2093,
"lessen":90.5650,
"lessened":0.9414,
"lessening":12.2385,
"lesser":27.1130,
"lesson":818.8508,
"lessor":29.9373,
"lest":65.5231,
"let":6575.6598,
"lethal":113.3475,
"lets":23.3473,
"letter":3685.4875,
"letterhead":10.3557,
"lettering":35.7741,
"letterman":1.1297,
"letting":47.2595,
"lettuce":73.2428,
"leukemia":2.4477,
"lev":2.2594,
"levee":1.6946,
"level":7319.9498,
"levelled":0.1883,
"leveller":10.5440,
"levelling":10.1674,
"lever":149.6864,
"leverage":49.8955,
"leveraged":6.7783,
"leveraging":0.5649,
"leviathan":3.9540,
"levis":0.1883,
"levy":221.4230,
"lewis":0.5649,
"lexical":181.1300,
"lexicon":101.2972,
"lexis":8.2845,
"li":4.1423,
"liability":838.9973,
"liable":395.0216,
"liaison":151.7576,
"liar":74.7491,
"lib":41.0461,
"libel":147.6153,
"liberal":871.9471,
"liberalisation":40.2930,
"liberalise":16.1925,
"liberalised":0.7531,
"liberalising":0.3766,
"liberalism":76.8202,
"liberalization":43.3055,
"liberalize":14.1214,
"liberalized":0.7531,
"liberally":33.5147,
"liberate":93.5776,
"liberated":22.4059,
"liberating":16.7574,
"liberation":147.9919,
"liberator":8.2845,
"liberian":9.6025,
"libero":1.1297,
"libertarian":31.0670,
"liberty":262.6574,
"libido":19.7699,
"libra":0.5649,
"librarian":228.5778,
"library":1342.4709,
"libs":2.0711,
"libya":0.1883,
"libyan":78.3265,
"lice":32.3850,
"licence":829.7713,
"licences":0.1883,
"license":195.8162,
"licensed":76.2554,
"licensee":42.7407,
"licensing":178.4940,
"lick":186.5903,
"licked":0.5649,
"licking":3.2008,
"licorice":0.9414,
"lid":235.9209,
"lido":4.3306,
"lie":4025.9065,
"liechtenstein":0.3766,
"lieder":0.9414,
"lien":17.6988,
"lies":2.2594,
"lieu":32.5733,
"lieutenant":98.8495,
"life":11481.6097,
"lifeguard":15.0628,
"lifeless":46.3181,
"lifelike":9.9791,
"lifeline":38.5984,
"lifelong":66.0880,
"lifesize":3.5774,
"lifespan":29.5607,
"lifestyle":235.7326,
"lifestyles":0.1883,
"lifetime":342.3018,
"lift":1729.3963,
"lifted":0.1883,
"lifting":80.0211,
"lifts":0.1883,
"ligament":44.8118,
"ligand":42.7407,
"ligation":5.8368,
"light":5684.1311,
"lighted":24.2887,
"lighten":57.6152,
"lightening":4.3306,
"lighter":20.7113,
"lighthouse":56.6737,
"lighting":293.1595,
"lightly":345.3144,
"lightness":32.7616,
"lightning":141.9668,
"lights":0.9414,
"lightweight":113.7240,
"like":29010.5519,
"liked":4.7071,
"likelier":0.1883,
"likelihood":212.5736,
"likely":4143.5845,
"likeness":48.9541,
"likes":1.5063,
"likewise":208.2430,
"liking":56.8620,
"lilac":6.2134,
"lille":0.1883,
"lillie":0.3766,
"lilo":1.8828,
"lily":79.2679,
"limb":291.6532,
"limbo":28.2427,
"lime":125.2094,
"limerick":4.1423,
"limestone":141.5902,
"limit":2193.5184,
"limitation":455.4610,
"limited":1198.2447,
"limiter":4.1423,
"limiting":7.1548,
"limitless":32.9498,
"limo":6.5900,
"limousine":39.1632,
"limp":141.0253,
"lind":0.3766,
"linden":0.3766,
"lindy":1.1297,
"line":6704.6349,
"lineage":83.0336,
"linear":247.9711,
"linearity":12.0502,
"linearly":17.8871,
"linebacker":1.3180,
"lined":16.0042,
"linen":166.2555,
"liner":101.4855,
"lines":9.0377,
"lineup":6.4017,
"ling":8.4728,
"linger":187.3434,
"lingerie":12.9917,
"lingering":2.6360,
"lingo":6.5900,
"lingual":11.4854,
"linguistic":558.8294,
"linguistics":5.4603,
"lining":117.4897,
"link":2732.7662,
"linkage":90.7533,
"linked":1.5063,
"linking":33.5147,
"links":5.2720,
"linotype":0.7531,
"lint":7.3431,
"lion":239.3100,
"lip":1135.9225,
"lipid":61.9457,
"liposuction":0.5649,
"lips":1.8828,
"lipstick":68.5357,
"liquid":491.6117,
"liquidated":0.5649,
"liquidation":82.0922,
"liquidity":108.0755,
"liquids":0.1883,
"liquor":76.4436,
"lira":36.9038,
"lire":0.9414,
"lisle":0.1883,
"lisp":9.9791,
"list":3392.7046,
"listed":2.2594,
"listen":2058.7065,
"listener":194.1217,
"listening":107.8872,
"lister":2.2594,
"listeria":6.9665,
"listing":150.6279,
"liszt":0.1883,
"lit":28.9959,
"lite":5.4603,
"liter":0.3766,
"literacy":170.5861,
"literal":96.9667,
"literally":348.5152,
"literary":581.4236,
"literate":88.8704,
"literature":867.0517,
"lithium":14.4979,
"lithograph":10.7322,
"lithuania":0.3766,
"lithuanian":42.5524,
"litigation":144.4145,
"litre":230.6489,
"litter":210.5025,
"littered":4.1423,
"little":11188.2619,
"littler":1.5063,
"liturgical":38.7867,
"liturgy":40.2930,
"liv":0.3766,
"live":7110.3888,
"lived":3.5774,
"livelihood":66.2763,
"lively":273.9544,
"liver":303.5152,
"liverpool":1.1297,
"livery":55.3557,
"lives":1.1297,
"livestock":136.1299,
"living":1011.2779,
"livingston":0.3766,
"lizard":73.6194,
"ll":9.4142,
"llama":5.4603,
"llb":0.3766,
"lloyd":0.7531,
"lo":4.5188,
"load":1160.5878,
"loaded":11.6737,
"loader":10.3557,
"loading":95.6487,
"loaf":103.5567,
"loam":16.1925,
"loan":1154.7509,
"loathing":34.2678,
"lob":29.5607,
"lobby":280.5444,
"lobbying":49.3306,
"lobbyist":16.7574,
"lobe":51.4018,
"lobster":48.9541,
"local":8149.9094,
"locale":17.8871,
"localisation":11.8619,
"localised":5.6485,
"locality":204.8539,
"localization":11.1088,
"localized":6.0251,
"locally":333.0759,
"locate":667.2815,
"located":0.7531,
"locating":3.2008,
"location":951.5916,
"loch":65.1466,
"loci":16.3808,
"lock":1107.3032,
"locke":0.1883,
"locked":54.7909,
"locker":63.0754,
"locking":27.6779,
"lockout":3.3891,
"locksmith":8.4728,
"loco":39.9164,
"locomotive":191.4857,
"locus":64.2051,
"locust":15.4394,
"lodge":265.8582,
"lodging":101.4855,
"loft":109.7701,
"lofty":54.4143,
"log":384.1011,
"logarithm":24.2887,
"logarithmic":11.4854,
"logbook":9.4142,
"logged":1.6946,
"logger":14.8745,
"logging":51.7783,
"logic":367.1554,
"logical":417.8041,
"logically":101.4855,
"logician":3.3891,
"login":5.2720,
"logistic":48.3892,
"logistical":17.1339,
"logistics":1.3180,
"logo":108.0755,
"logos":0.5649,
"loin":25.2302,
"loire":0.1883,
"lolita":0.1883,
"london":2.8243,
"lone":151.5693,
"loneliness":104.1215,
"lonely":301.8206,
"lonesome":5.4603,
"long":14906.3226,
"longer":1.8828,
"longest":0.5649,
"longevity":33.7030,
"longfellow":0.1883,
"longhorn":2.4477,
"longing":140.2722,
"longitude":13.7448,
"longitudinal":56.1089,
"longstanding":35.2093,
"longtime":6.0251,
"loo":76.6319,
"look":22138.5317,
"looked":8.0962,
"looking":44.6235,
"lookout":33.7030,
"looks":31.8201,
"lookup":2.0711,
"loom":215.9627,
"looming":0.5649,
"loon":5.8368,
"loop":307.4691,
"loophole":40.1047,
"looping":3.9540,
"loose":610.9843,
"loosely":117.1132,
"loosen":104.3098,
"looser":0.3766,
"loosing":0.3766,
"loot":59.1214,
"looted":0.3766,
"looting":25.7950,
"lord":271.3185,
"lordship":122.9500,
"lore":25.6067,
"lorenz":0.3766,
"lorraine":0.3766,
"lose":5191.0131,
"loser":121.6320,
"losing":4.3306,
"loss":2784.7328,
"lost":116.5483,
"lot":5806.7045,
"lotion":39.7281,
"lottery":58.7449,
"lotto":1.5063,
"lotus":16.3808,
"loud":487.2812,
"louder":69.2888,
"loudest":0.1883,
"loudly":178.6823,
"loudness":11.1088,
"loudspeaker":41.9875,
"lough":8.6611,
"louis":1.5063,
"lounge":298.8080,
"lousy":41.7992,
"louvre":8.6611,
"lovable":27.3013,
"love":5198.1679,
"loved":42.3641,
"lovely":1035.9432,
"lover":494.8126,
"loves":5.4603,
"loving":59.3097,
"lovingly":51.5900,
"low":5788.0643,
"lowdown":3.3891,
"lower":542.0721,
"lowercase":0.3766,
"lowered":4.1423,
"lowering":27.3013,
"lowest":16.9456,
"lowing":0.9414,
"lowland":54.4143,
"lowly":41.9875,
"loyal":232.1552,
"loyally":13.9331,
"loyalty":348.7035,
"lp":58.7449,
"lr":0.3766,
"lsd":0.9414,
"lu":2.0711,
"lube":1.3180,
"lubricant":24.4770,
"lubrication":9.4142,
"luce":0.5649,
"lucid":33.5147,
"lucifer":0.5649,
"luck":531.9047,
"luckily":122.9500,
"lucky":700.2313,
"lucrative":93.9541,
"ludicrous":77.1968,
"lug":24.6653,
"luggage":109.9583,
"luke":3.7657,
"lukewarm":28.9959,
"lullaby":7.5314,
"lulu":0.3766,
"lumbar":10.5440,
"lumber":47.6361,
"lumen":30.8787,
"luminance":0.7531,
"luminosity":14.4979,
"luminous":53.6612,
"lump":306.5277,
"luna":0.1883,
"lunar":45.1884,
"lunatic":62.6989,
"lunch":1029.9181,
"luncheon":63.6403,
"lunches":0.3766,
"lunchtime":162.8664,
"lung":314.8123,
"lungs":0.1883,
"luo":0.1883,
"lupin":6.9665,
"lupus":2.6360,
"lure":123.1383,
"lures":0.1883,
"lurker":0.3766,
"lurking":2.8243,
"luscious":18.4519,
"lush":68.1591,
"lust":94.7073,
"luster":0.1883,
"lustre":28.9959,
"lustrous":12.4268,
"lusty":12.0502,
"lutheran":3.2008,
"luxembourg":0.1883,
"luxurious":90.3767,
"luxury":354.3521,
"lv":0.3766,
"ly":3.0126,
"lying":14.1214,
"lymph":33.8913,
"lymphatic":8.8494,
"lymphocyte":64.0168,
"lymphoid":12.9917,
"lymphoma":46.1298,
"lynch":11.1088,
"lynx":4.3306,
"lyon":0.5649,
"lyric":113.7240,
"lyrical":46.3181,
"lysine":7.7197,
"ma":8.6611,
"mac":6.5900,
"macaroni":2.4477,
"macbeth":0.1883,
"mace":14.3096,
"macedonia":0.1883,
"macedonian":19.7699,
"mach":1.6946,
"machine":2494.5859,
"machined":0.9414,
"machinery":428.3480,
"machines":1.1297,
"machining":12.2385,
"machinist":13.3682,
"macho":46.3181,
"macintosh":0.5649,
"mack":0.7531,
"mackenzie":0.3766,
"mackerel":21.0879,
"mackintosh":6.7783,
"macro":72.8662,
"macroeconomic":66.6528,
"macrophage":35.0210,
"macroscopic":18.4519,
"mad":530.9633,
"madagascar":0.5649,
"madam":13.3682,
"madame":1.1297,
"madden":8.4728,
"madder":3.5774,
"made":20.1465,
"madeira":7.5314,
"mademoiselle":0.1883,
"madison":0.1883,
"madly":32.7616,
"madman":32.0084,
"madness":130.2931,
"madonna":4.7071,
"maestro":5.6485,
"mafia":22.2176,
"mag":23.7239,
"magazine":998.8511,
"magenta":13.5565,
"magi":1.5063,
"magic":456.2142,
"magical":148.3685,
"magically":27.4896,
"magician":52.9080,
"magistrate":405.1890,
"magma":38.4101,
"magnesium":41.9875,
"magnet":78.5148,
"magnetic":280.1678,
"magnetism":30.1256,
"magnetization":4.7071,
"magneto":5.0837,
"magnetometer":3.5774,
"magnification":22.4059,
"magnificent":350.2098,
"magnified":4.3306,
"magnifier":3.5774,
"magnify":38.0335,
"magnifying":18.8285,
"magnitude":175.6698,
"magnolia":5.4603,
"magnum":6.4017,
"magyar":0.1883,
"mahler":0.3766,
"mahogany":103.3684,
"maid":194.4982,
"maiden":72.8662,
"maidenhead":1.5063,
"mail":501.9674,
"mailbag":1.5063,
"mailbox":7.3431,
"mailer":4.1423,
"mailing":53.2846,
"mailman":0.7531,
"main":4489.0872,
"mainframe":191.2974,
"mainland":179.6237,
"mainline":16.5691,
"mainly":1261.8850,
"mainstay":27.6779,
"mainstream":221.7995,
"mainstreaming":0.7531,
"maintain":2251.6984,
"maintained":1.8828,
"maintainer":1.6946,
"maintaining":3.0126,
"maintenance":679.8966,
"maize":53.8495,
"maj":1.3180,
"majestic":38.2218,
"majesty":17.5105,
"major":4342.2250,
"majordomo":1.8828,
"majority":1800.3797,
"majors":0.1883,
"make":38892.1169,
"makeover":1.8828,
"maker":659.9384,
"makes":2.4477,
"makeshift":47.0712,
"makeup":30.8787,
"making":740.7126,
"mala":2.4477,
"malacca":0.7531,
"malaria":50.6486,
"malay":5.0837,
"malaya":0.1883,
"malaysian":37.6570,
"male":1856.3003,
"malfunction":26.1716,
"mali":0.3766,
"malice":57.2386,
"malicious":61.0043,
"malignancy":26.3599,
"malignant":68.3474,
"mall":28.2427,
"mallard":5.4603,
"mallet":22.2176,
"malnutrition":33.8913,
"malpractice":28.8076,
"malt":67.2177,
"malta":0.3766,
"maltese":20.8996,
"mama":22.9708,
"mambo":0.5649,
"mammal":218.7870,
"mammalian":50.2721,
"mammary":2.6360,
"mammography":1.6946,
"mammoth":35.9624,
"man":17171.0127,
"manage":2664.2305,
"manageable":70.4185,
"managed":2.8243,
"management":3442.4118,
"manager":3093.1434,
"managerial":246.4649,
"managers":0.1883,
"managing":70.4185,
"manatee":1.8828,
"manchester":0.3766,
"mandarin":22.9708,
"mandate":131.7994,
"mandatory":139.1425,
"mandela":0.3766,
"mandolin":7.5314,
"mandrake":1.6946,
"mane":31.2553,
"maneuver":0.5649,
"manganese":16.5691,
"manger":15.0628,
"mangled":3.7657,
"mango":16.7574,
"mangrove":12.0502,
"manhattan":0.7531,
"manhood":34.8327,
"mania":29.9373,
"maniac":30.6904,
"manic":42.9289,
"manicure":24.2887,
"manifest":194.3100,
"manifestation":154.0170,
"manifested":0.9414,
"manifesto":120.5023,
"manifold":28.9959,
"manila":0.1883,
"manipulate":241.1929,
"manipulated":0.1883,
"manipulating":0.3766,
"manipulation":167.9501,
"manipulative":28.2427,
"mankind":138.9542,
"manliness":5.4603,
"manly":20.7113,
"mann":0.5649,
"manned":4.1423,
"manner":1176.2154,
"mannered":34.6444,
"manor":123.8914,
"manpower":119.1843,
"mansion":116.3600,
"manslaughter":87.3642,
"manta":1.3180,
"mantel":8.4728,
"mantis":5.2720,
"mantle":105.6278,
"mantra":14.3096,
"manual":485.2100,
"manually":45.7532,
"manufacture":726.7795,
"manufactured":5.6485,
"manufacturer":803.0349,
"manufacturing":568.8085,
"manure":62.5106,
"manuscript":221.7995,
"manx":9.7908,
"many":16200.2161,
"mao":0.7531,
"maori":7.9080,
"map":1008.4536,
"maple":57.8034,
"mapper":3.0126,
"mapping":110.5232,
"maps":0.3766,
"mar":53.2846,
"mara":0.1883,
"marathon":124.0797,
"marble":268.3059,
"march":405.5655,
"marches":0.3766,
"marching":32.9498,
"mare":127.8454,
"margarine":44.6235,
"margarita":0.3766,
"marge":3.7657,
"margin":475.9841,
"marginal":385.7956,
"marginalized":1.1297,
"marginally":77.9499,
"marguerite":1.8828,
"maria":0.3766,
"marian":6.0251,
"marigold":9.2260,
"marijuana":22.0293,
"marina":31.6319,
"marinade":14.4979,
"marinated":2.6360,
"marine":257.1971,
"mariner":24.2887,
"marital":146.6739,
"maritime":66.4645,
"mark":2603.0379,
"marked":225.9418,
"markedly":119.7492,
"marker":223.6824,
"market":6622.3545,
"marketable":36.7155,
"marketed":1.3180,
"marketer":22.0293,
"marketing":796.2566,
"marketplace":67.5943,
"marking":114.1006,
"marks":3.2008,
"markup":3.0126,
"marley":2.0711,
"marlin":0.7531,
"marmalade":40.2930,
"marmot":4.1423,
"maroon":35.0210,
"marque":9.0377,
"marquee":32.5733,
"marquis":9.0377,
"marquise":0.3766,
"marred":0.5649,
"marriage":1533.0152,
"married":703.8087,
"marrow":62.3223,
"marry":1662.5552,
"marrying":6.0251,
"marsh":86.7993,
"marshal":51.9666,
"marshall":3.7657,
"mart":5.8368,
"martial":79.0796,
"martian":12.6151,
"martin":13.5565,
"martingale":0.9414,
"martini":6.0251,
"martinique":0.1883,
"martyr":75.8788,
"martyrdom":21.2762,
"marvel":74.5608,
"marvellous":308.2223,
"marvelous":1.3180,
"marxism":2.8243,
"marxist":243.0757,
"mary":0.1883,
"mas":0.7531,
"mascara":22.9708,
"mascot":15.0628,
"masculine":127.4688,
"masculinity":66.2763,
"mash":61.3809,
"mashed":8.6611,
"mask":406.6953,
"masked":1.3180,
"masking":9.2260,
"mason":38.0335,
"masonic":12.9917,
"masonry":55.7323,
"masque":10.1674,
"masquerade":30.8787,
"mass":1227.9937,
"massacre":142.9082,
"massage":147.0505,
"massive":783.4532,
"massively":56.6737,
"mast":114.8538,
"master":1046.8637,
"masterful":16.5691,
"mastering":3.2008,
"mastermind":34.2678,
"masterpiece":95.6487,
"masters":2.8243,
"mastery":72.3014,
"masthead":8.0962,
"mastiff":5.6485,
"masturbate":15.0628,
"masturbation":29.5607,
"mat":147.9919,
"matador":3.2008,
"match":2680.7996,
"matchbox":14.6862,
"matched":0.1883,
"matches":0.3766,
"matching":103.7449,
"matchmaker":4.5188,
"matchmaking":3.0126,
"mate":598.5575,
"mated":0.7531,
"mater":6.9665,
"material":3545.2153,
"materialism":44.6235,
"materialistic":22.0293,
"materialistically":0.5649,
"materialize":26.7364,
"materialized":0.3766,
"materially":38.7867,
"materiel":1.6946,
"maternal":123.8914,
"maternity":107.8872,
"math":170.2095,
"mathematical":214.2681,
"mathematically":32.0084,
"mathematician":57.0503,
"mathematics":4.5188,
"maths":0.3766,
"mating":70.4185,
"matisse":0.5649,
"matrices":0.9414,
"matrimonial":41.6110,
"matrix":297.4901,
"matt":10.7322,
"matte":10.5440,
"matted":8.8494,
"matter":5584.7167,
"mattering":0.1883,
"matthew":0.5649,
"mattress":110.5232,
"maturation":32.7616,
"maturational":2.2594,
"mature":413.8501,
"matured":5.2720,
"matures":0.1883,
"maturity":260.2097,
"maven":0.5649,
"maverick":24.8536,
"max":3.7657,
"maxi":6.5900,
"maxim":61.0043,
"maximal":28.6193,
"maximisation":23.9122,
"maximise":136.6948,
"maximised":0.3766,
"maximising":0.1883,
"maximization":13.5565,
"maximize":82.6570,
"maximizing":0.7531,
"maximum":868.5580,
"maxwell":0.7531,
"may":20359.0517,
"mayan":6.9665,
"maybe":1792.6600,
"mayer":0.1883,
"mayhem":26.5482,
"mayo":0.5649,
"mayonnaise":31.0670,
"mayor":170.3978,
"maze":81.5273,
"mb":23.3473,
"mba":0.5649,
"mc":0.5649,
"mccarthy":0.5649,
"mccartney":0.1883,
"mccormick":0.1883,
"mcpherson":0.7531,
"md":3.5774,
"me":5.6485,
"mead":7.1548,
"meade":0.1883,
"meadow":152.5107,
"meager":0.3766,
"meal":1173.2028,
"mean":13972.0533,
"meandering":9.6025,
"meaner":0.3766,
"meanest":0.7531,
"meaning":1421.5506,
"meaningful":177.9292,
"meaningless":115.9835,
"meanly":2.0711,
"meanness":12.8034,
"means":578.2227,
"meant":3.3891,
"meantime":255.5025,
"meanwhile":850.2943,
"measles":15.2511,
"measurable":50.6486,
"measurably":3.2008,
"measure":3198.7712,
"measured":12.2385,
"measurement":529.6453,
"measures":1.1297,
"measuring":16.5691,
"meat":675.5660,
"mecca":6.2134,
"mechanic":193.1802,
"mechanical":340.2307,
"mechanically":47.2595,
"mechanism":877.2191,
"mechanistic":19.7699,
"med":3.5774,
"medal":265.2933,
"medallion":30.1256,
"media":118.9960,
"medial":9.9791,
"median":117.3015,
"mediate":175.4815,
"mediated":0.9414,
"mediation":52.5315,
"mediator":54.6026,
"medic":31.4436,
"medical":1459.5841,
"medically":28.2427,
"medicare":0.1883,
"medication":100.1675,
"medici":0.9414,
"medicinal":38.2218,
"medicine":520.2310,
"medieval":421.5698,
"mediocre":30.5021,
"mediocrity":17.5105,
"meditate":29.7490,
"meditation":99.9793,
"mediterranean":2.0711,
"medium":1984.8988,
"medley":19.0168,
"medusa":2.0711,
"meek":16.3808,
"meet":5663.0432,
"meeting":3918.2076,
"meets":0.1883,
"meg":1.3180,
"mega":42.5524,
"megabyte":19.9582,
"mei":0.1883,
"melancholy":66.8411,
"melanoma":15.8159,
"melatonin":2.8243,
"melee":10.1674,
"mellow":53.2846,
"melodic":30.3139,
"melody":86.9876,
"melon":48.9541,
"melt":302.1972,
"meltdown":7.1548,
"melted":1.1297,
"melting":50.8369,
"melville":0.1883,
"member":7894.7834,
"membership":915.8175,
"membrane":238.3686,
"meme":17.8871,
"memento":30.6904,
"memo":78.1382,
"memoir":91.1299,
"memorabilia":28.2427,
"memorable":149.8747,
"memorandum":156.4647,
"memorial":167.7618,
"memorise":22.7825,
"memorising":1.6946,
"memorize":20.3348,
"memorized":0.7531,
"memorizing":0.5649,
"memory":1757.2624,
"men":43.6821,
"menace":110.3349,
"menacing":55.5440,
"mend":121.0672,
"mended":0.5649,
"mending":4.8954,
"meningitis":28.9959,
"menopausal":7.9080,
"menopause":38.5984,
"menstrual":30.8787,
"menstruation":24.6653,
"menswear":9.9791,
"mental":993.9557,
"mentality":67.4060,
"mentally":353.4106,
"mention":2224.9620,
"mentioning":1.3180,
"mentor":55.1675,
"mentoring":0.3766,
"menu":344.9378,
"menus":0.3766,
"meow":4.8954,
"mercantile":22.9708,
"mercenary":55.1675,
"mercer":6.5900,
"merchandise":44.8118,
"merchandising":16.5691,
"merchant":428.3480,
"merchantability":6.0251,
"merciful":22.4059,
"mercilessly":20.5230,
"mercury":77.9499,
"mercy":180.3769,
"mere":608.3483,
"meredith":0.1883,
"merely":1337.3872,
"merest":0.5649,
"merge":233.2849,
"merged":8.6611,
"merger":343.8081,
"merging":18.2636,
"meridian":7.9080,
"merino":0.7531,
"merit":401.2350,
"merlin":1.6946,
"merlot":0.3766,
"mermaid":16.3808,
"merrier":4.5188,
"merrily":28.8076,
"merriness":0.1883,
"merry":66.2763,
"merton":0.5649,
"mes":0.7531,
"mesa":0.9414,
"mesh":93.3893,
"mesquite":0.5649,
"mess":481.2561,
"message":1525.2955,
"messaging":8.0962,
"messed":0.3766,
"messenger":110.1466,
"messiah":5.2720,
"messianic":16.5691,
"messing":3.2008,
"messy":62.8871,
"met":2.8243,
"meta":17.5105,
"metabolic":62.6989,
"metabolism":86.6110,
"metabolite":17.6988,
"metal":1018.0561,
"metallic":82.8453,
"metallurgy":8.8494,
"metalworking":8.2845,
"metamorphosis":21.0879,
"metaphor":221.4230,
"metaphorical":34.6444,
"metaphysical":67.4060,
"metaphysics":19.2051,
"metastasis":20.3348,
"metastatic":9.4142,
"meteor":9.7908,
"meteorite":33.8913,
"meteorological":23.3473,
"meteorology":8.2845,
"meter":136.1299,
"metered":3.2008,
"metering":12.4268,
"methadone":13.3682,
"methamphetamine":0.1883,
"methane":58.7449,
"methanol":23.5356,
"methionine":8.0962,
"method":3037.0345,
"methodical":25.6067,
"methodist":20.8996,
"methodological":81.5273,
"methodology":163.6195,
"methods":2.2594,
"methyl":34.0796,
"meticulous":51.7783,
"meticulously":33.7030,
"metre":793.4323,
"metres":0.1883,
"metric":69.6654,
"metro":9.0377,
"metropolis":21.6528,
"metropolitan":120.1257,
"mew":13.9331,
"mexican":91.3181,
"mezzanine":12.4268,
"mg":65.7114,
"mhz":11.8619,
"mi":13.7448,
"mica":9.2260,
"mice":2.0711,
"michelangelo":0.3766,
"mick":4.3306,
"mickey":10.3557,
"micro":149.8747,
"microbial":16.3808,
"microbiological":11.1088,
"microbiology":9.6025,
"microchip":16.7574,
"microeconomics":0.1883,
"microfiche":2.4477,
"microfilm":26.3599,
"micron":22.4059,
"microphone":170.9626,
"microprocessor":75.6905,
"microscope":120.3140,
"microscopic":44.8118,
"microscopy":31.4436,
"microwave":125.0211,
"mid":822.8048,
"midday":89.8119,
"middle":2162.8280,
"midfield":148.3685,
"midfielder":97.3433,
"midget":11.2971,
"midi":24.4770,
"midland":15.2511,
"midnight":277.5319,
"midpoint":3.3891,
"midst":116.3600,
"midsummer":12.2385,
"midterm":0.5649,
"midtown":1.3180,
"midway":51.0252,
"midwest":2.6360,
"midwestern":2.8243,
"midwife":85.2930,
"midwifery":14.3096,
"might":10809.2445,
"mighty":180.0003,
"migraine":18.2636,
"migrant":111.6529,
"migrate":122.1969,
"migrating":3.3891,
"migration":259.0799,
"migratory":21.2762,
"mike":7.9080,
"mil":8.6611,
"milan":1.6946,
"mild":317.0717,
"milder":0.3766,
"mildew":17.6988,
"mildly":108.6404,
"mildness":4.8954,
"mile":2399.8786,
"mileage":64.3934,
"miles":0.7531,
"milestone":49.8955,
"milieu":29.7490,
"militant":156.0881,
"military":1888.6852,
"militia":99.4144,
"milk":865.1688,
"milked":0.1883,
"milking":23.7239,
"milky":36.7155,
"mill":606.6538,
"milled":0.7531,
"millennium":45.7532,
"miller":28.6193,
"millet":9.7908,
"milligram":9.0377,
"millilitre":7.3431,
"millimeter":0.3766,
"millimetre":65.3348,
"milling":32.0084,
"million":4913.8578,
"millionaire":108.0755,
"millions":0.1883,
"millionth":13.3682,
"milt":1.3180,
"milton":2.4477,
"mime":50.8369,
"mimic":89.4353,
"min":175.8580,
"mina":0.1883,
"minced":3.3891,
"mind":5452.9173,
"minded":302.5737,
"mindful":31.6319,
"minding":3.2008,
"mindless":45.3766,
"mindset":2.2594,
"mine":1334.5630,
"mined":1.3180,
"miner":368.6617,
"mineral":363.9546,
"mines":0.1883,
"ming":0.7531,
"mingle":91.8830,
"mingled":0.1883,
"mini":269.0590,
"miniature":169.8329,
"minibar":8.6611,
"minibus":43.3055,
"minimal":246.2766,
"minimalise":0.1883,
"minimalist":17.3222,
"minimalistic":0.7531,
"minimalize":0.1883,
"minimalized":0.1883,
"minimally":10.7322,
"minimise":180.7534,
"minimised":0.1883,
"minimising":0.1883,
"minimization":3.2008,
"minimize":95.2721,
"minimized":0.1883,
"minimizing":0.9414,
"minimum":890.5873,
"mining":352.0927,
"minister":1651.0698,
"ministerial":167.3852,
"ministers":0.1883,
"ministry":295.6072,
"minivan":0.5649,
"mink":46.1298,
"minnesota":0.1883,
"minor":801.1520,
"minority":767.4490,
"minors":0.1883,
"minotaur":0.9414,
"minsk":0.1883,
"minster":9.6025,
"mint":136.8831,
"minus":295.9838,
"minute":4789.9664,
"minuteman":0.5649,
"miracle":272.0716,
"miracles":0.1883,
"miraculous":56.4855,
"miraculously":45.3766,
"mirage":18.2636,
"miro":0.1883,
"mirror":667.2815,
"mirrored":3.7657,
"mirroring":2.0711,
"mirrors":0.7531,
"miscarriage":47.2595,
"miscellaneous":33.8913,
"miscellany":8.0962,
"mischief":73.0545,
"mischievous":47.0712,
"misconception":45.0001,
"misconduct":56.6737,
"misdemeanor":0.9414,
"miserable":209.5610,
"miserably":53.6612,
"misery":229.7075,
"misfortune":81.1508,
"misguided":54.7909,
"misheard":3.9540,
"misinformation":10.7322,
"misinterpret":32.9498,
"misinterpretation":16.1925,
"misinterpreted":0.7531,
"mislead":143.8496,
"misleading":182.4480,
"mismanagement":30.5021,
"mismatch":34.6444,
"misplace":50.2721,
"misplaced":2.8243,
"misrepresentation":48.7658,
"misrepresented":0.5649,
"miss":1990.3591,
"missed":0.3766,
"missile":332.5110,
"missiles":0.1883,
"missing":169.2681,
"mission":503.8502,
"missionary":139.3308,
"mississippi":0.1883,
"misspelled":1.1297,
"misspelt":1.8828,
"missy":0.5649,
"mist":229.7075,
"mistake":1040.8386,
"mistaken":141.9668,
"mistakenly":41.6110,
"mistaking":11.8619,
"mister":6.4017,
"mistress":189.7911,
"mistrust":45.5649,
"misty":42.7407,
"misunderstanding":134.2471,
"misunderstood":13.9331,
"misuse":99.4144,
"misused":0.3766,
"mit":1.1297,
"mitchell":0.1883,
"mite":52.1549,
"mitigate":61.3809,
"mitigating":2.2594,
"mitigation":17.1339,
"mitochondria":12.6151,
"mitochondrial":19.3933,
"mitotic":12.2385,
"mitre":13.3682,
"mitt":5.8368,
"mix":870.2525,
"mixed":507.9925,
"mixer":52.7198,
"mixing":84.1633,
"mixture":612.6789,
"ml":144.2262,
"mm":1238.9143,
"mn":3.0126,
"mo":20.1465,
"moan":189.0380,
"moaning":9.4142,
"mob":126.9040,
"mobile":285.6281,
"mobility":257.0088,
"mobilization":36.3390,
"mobilize":64.2051,
"mobilizing":0.3766,
"mobs":0.1883,
"mocha":0.7531,
"mock":270.0005,
"mocked":0.1883,
"mockery":65.7114,
"mocking":17.8871,
"mockingbird":0.7531,
"mod":50.8369,
"modal":46.8829,
"modality":16.9456,
"mode":692.1351,
"model":3206.8674,
"modeling":0.5649,
"modelling":141.2136,
"modem":79.4562,
"moderate":295.7955,
"moderated":5.6485,
"moderately":73.2428,
"moderation":50.6486,
"moderator":30.3139,
"modern":2256.5938,
"modernisation":55.1675,
"modernise":57.6152,
"modernism":57.6152,
"modernist":70.9834,
"modernity":60.8160,
"modernization":49.1423,
"modernize":34.6444,
"modernized":4.8954,
"modest":405.7538,
"modestly":54.7909,
"modesty":47.8243,
"modification":324.4148,
"modified":6.9665,
"modifier":17.3222,
"modify":512.6996,
"modifying":0.3766,
"modular":63.2637,
"modulate":36.3390,
"modulation":25.0419,
"modulator":6.5900,
"module":894.9179,
"modules":0.7531,
"modulo":0.3766,
"modulus":54.6026,
"mogul":19.0168,
"moist":101.1090,
"moisture":124.4563,
"moisturizer":6.7783,
"moisturizing":0.5649,
"molar":75.8788,
"mold":5.8368,
"moldova":0.1883,
"moldovan":3.3891,
"mole":81.3391,
"molecular":227.8247,
"molecule":411.5907,
"moll":1.3180,
"mollie":1.1297,
"molly":9.2260,
"molten":46.3181,
"mom":35.3976,
"moment":4307.2040,
"momentarily":99.9793,
"momentary":51.7783,
"momentous":49.7072,
"momentum":168.3266,
"momma":0.9414,
"mommy":1.1297,
"mon":0.7531,
"monaco":0.1883,
"monarch":154.9584,
"monarchy":174.5400,
"monasteries":0.5649,
"monastery":152.1342,
"monastic":82.0922,
"monday":14.1214,
"monet":0.3766,
"monetary":420.4401,
"money":6740.5973,
"mongolian":15.8159,
"mongoose":5.6485,
"moniker":2.4477,
"monitor":789.6666,
"monitoring":313.3060,
"monitors":0.3766,
"monk":211.8204,
"monkey":188.0966,
"monkeys":0.1883,
"monks":1.8828,
"mono":12.6151,
"monochrome":29.9373,
"monoclonal":39.3515,
"monogram":8.2845,
"monograph":47.6361,
"monolithic":29.9373,
"monologue":34.6444,
"monomer":13.3682,
"monophonic":1.3180,
"monopoly":348.3270,
"monorail":3.9540,
"monotone":10.3557,
"monotonous":39.3515,
"monoxide":51.5900,
"monrovia":0.1883,
"monsieur":4.1423,
"monsoon":23.7239,
"monster":267.5528,
"monstrous":60.4394,
"montage":12.0502,
"montana":0.1883,
"montenegro":0.1883,
"montgomery":0.1883,
"month":7297.7322,
"monthly":353.7872,
"monument":196.1928,
"monumental":62.1340,
"moo":5.8368,
"mood":652.0304,
"moody":26.1716,
"moon":392.9505,
"moonlight":84.1633,
"moonstone":1.3180,
"moor":195.6280,
"mooring":41.0461,
"moors":0.7531,
"moose":8.2845,
"moot":48.2009,
"mop":98.4730,
"moral":1022.1984,
"morale":168.3266,
"morality":225.9418,
"morally":106.7575,
"moratorium":38.5984,
"moravian":4.1423,
"moray":0.9414,
"morbid":32.0084,
"morbidity":66.2763,
"more":37977.0526,
"morel":7.3431,
"moreover":765.1896,
"morley":0.3766,
"mormon":0.9414,
"morn":7.1548,
"morning":3690.0063,
"moroccan":32.5733,
"moron":12.8034,
"morph":3.5774,
"morphine":27.1130,
"morphological":51.0252,
"morphology":45.3766,
"morrison":1.8828,
"morrow":26.1716,
"morse":6.2134,
"mortal":116.3600,
"mortality":394.0802,
"mortar":135.0002,
"mortgage":604.2061,
"mortimer":0.7531,
"mortuary":40.8578,
"mosaic":169.8329,
"mosaics":0.1883,
"moscow":1.1297,
"mosque":62.6989,
"mosquito":72.4897,
"moss":93.7659,
"most":17773.9008,
"mostly":691.9468,
"mot":19.0168,
"motel":23.9122,
"moth":89.2470,
"mother":4666.4515,
"motherboard":33.1381,
"motherhood":54.7909,
"mothers":0.1883,
"moths":0.1883,
"motif":178.4940,
"motifs":0.1883,
"motility":57.0503,
"motion":964.9598,
"motionless":66.0880,
"motivate":236.4858,
"motivated":45.5649,
"motivating":3.2008,
"motivation":311.6114,
"motivational":19.9582,
"motive":360.5655,
"motley":22.0293,
"motocross":2.6360,
"motor":846.9052,
"motorbike":66.4645,
"motorcycle":62.1340,
"motorcycling":3.7657,
"motoring":61.5691,
"motorist":156.2764,
"motorized":4.1423,
"motorway":244.9586,
"motto":61.0043,
"mould":292.5946,
"moulded":7.9080,
"moulding":47.2595,
"mound":117.6780,
"mount":752.5745,
"mountable":1.8828,
"mountain":1017.1147,
"mountaineer":27.4896,
"mountaineering":25.4185,
"mountainous":39.7281,
"mountainside":21.2762,
"mounted":12.2385,
"mounting":15.2511,
"mourn":64.3934,
"mourning":61.1926,
"mouse":455.2727,
"mouser":2.6360,
"mousse":22.5942,
"mouth":1762.3461,
"mouthed":51.0252,
"mouthful":68.9123,
"mouthpiece":32.3850,
"movable":21.6528,
"move":8463.7802,
"moved":2.8243,
"movement":2807.1387,
"mover":47.0712,
"moves":1.6946,
"movie":524.1850,
"moving":33.3264,
"mower":39.7281,
"mowing":6.9665,
"mozambique":0.9414,
"mozzarella":3.2008,
"mp":478.2435,
"mpg":15.4394,
"mph":188.2848,
"mr":2.4477,
"mri":6.9665,
"mrs":0.3766,
"ms":50.0838,
"msg":0.1883,
"mu":21.4645,
"mubarak":0.1883,
"much":16320.3418,
"muck":87.9290,
"mucosa":147.6153,
"mucous":19.0168,
"mucus":41.9875,
"mud":362.2600,
"muddy":114.2889,
"muffin":11.6737,
"muffled":44.0587,
"muffler":3.7657,
"mug":219.7284,
"muir":0.9414,
"mulberry":19.0168,
"mulch":18.6402,
"mule":54.2260,
"mull":29.5607,
"mullet":3.7657,
"multi":677.6371,
"multichannel":1.1297,
"multicultural":32.9498,
"multiculturalism":10.9205,
"multidimensional":6.7783,
"multidisciplinary":33.8913,
"multifaceted":4.1423,
"multifunction":1.1297,
"multilateral":49.1423,
"multilevel":3.5774,
"multilingual":12.0502,
"multimedia":138.0128,
"multinational":145.7325,
"multiple":470.3355,
"multiples":0.1883,
"multiplex":6.4017,
"multiplexing":1.3180,
"multiplication":47.8243,
"multiplicity":48.2009,
"multiplied":2.4477,
"multiplier":32.3850,
"multiply":215.3979,
"multiplying":1.3180,
"multipurpose":2.8243,
"multitude":94.5190,
"multivariate":15.8159,
"mum":832.2190,
"mummy":193.1802,
"munch":34.6444,
"mundane":77.3851,
"munich":0.5649,
"municipal":133.1174,
"municipality":22.4059,
"munro":0.5649,
"mural":60.8160,
"murder":1471.6343,
"murdered":0.1883,
"murderer":187.5317,
"murdering":0.7531,
"murderous":40.8578,
"murdoch":0.1883,
"murine":4.7071,
"murky":43.4938,
"murmur":444.3522,
"murmured":1.1297,
"mus":3.2008,
"muscat":0.1883,
"muscle":700.0430,
"muscles":0.1883,
"muscular":111.0881,
"muse":110.3349,
"museum":685.7334,
"mushroom":159.1007,
"music":2444.6904,
"musical":533.4110,
"musically":28.8076,
"musician":312.1763,
"musicians":0.1883,
"musk":12.8034,
"muslim":144.4145,
"muss":2.2594,
"must":12649.3522,
"mustang":0.5649,
"mustard":84.7282,
"muster":87.9290,
"mutant":115.7952,
"mutated":0.7531,
"mutation":167.3852,
"mute":65.7114,
"muted":42.9289,
"mutilation":22.0293,
"mutiny":34.8327,
"mutt":1.6946,
"muttered":7.9080,
"mutual":374.6868,
"mutually":116.9249,
"muzzle":52.7198,
"my":26711.4057,
"mylar":9.4142,
"myocardial":43.4938,
"myriad":57.9917,
"myrtle":2.8243,
"myself":2190.5058,
"mysore":0.1883,
"mysterious":230.2724,
"mysteriously":51.0252,
"mystery":436.0677,
"mystic":62.3223,
"mystical":92.4479,
"mysticism":29.1842,
"mystique":26.3599,
"myth":353.5989,
"mythical":44.0587,
"mythological":21.8410,
"mythology":77.9499,
"na":62.1340,
"nab":7.3431,
"nae":0.7531,
"nafta":0.3766,
"nag":38.7867,
"nagging":39.3515,
"nahum":0.1883,
"nail":394.4567,
"nailing":0.5649,
"nails":0.1883,
"naive":135.0002,
"naked":353.9755,
"name":6832.6686,
"named":0.1883,
"nameless":25.6067,
"namely":373.1806,
"names":0.5649,
"namibia":0.9414,
"namibian":15.4394,
"naming":31.8201,
"nan":3.9540,
"nancy":2.4477,
"nanny":88.6822,
"nanotechnology":0.5649,
"nantucket":0.1883,
"nap":37.4687,
"napalm":4.7071,
"napier":0.9414,
"napkin":56.4855,
"naples":0.1883,
"napoleonic":18.4519,
"nappy":69.2888,
"narcotic":32.3850,
"narcotics":1.8828,
"narration":18.0753,
"narrative":324.7914,
"narrator":75.8788,
"narrow":1171.3200,
"narrowed":0.1883,
"narrower":0.9414,
"narrowing":19.9582,
"narrowly":127.0923,
"narrowness":17.8871,
"nasal":46.5064,
"nascent":16.7574,
"nash":0.9414,
"nashville":0.3766,
"nasser":0.3766,
"nasty":324.6031,
"natal":32.7616,
"nation":1216.1318,
"national":3573.2697,
"nationalism":175.8580,
"nationalist":297.4901,
"nationalists":0.1883,
"nationality":166.8204,
"nationally":163.6195,
"nationwide":141.9668,
"native":535.4821,
"nativity":9.0377,
"nato":0.7531,
"natural":2459.5649,
"naturalist":55.3557,
"naturalization":4.3306,
"naturally":742.9720,
"nature":3005.7792,
"natured":34.8327,
"naturist":5.0837,
"naughty":120.6906,
"nauru":0.1883,
"nausea":50.8369,
"nautical":21.0879,
"nautilus":3.0126,
"naval":201.6531,
"navel":24.1005,
"navigable":12.2385,
"navigate":43.4938,
"navigating":0.3766,
"navigation":91.6947,
"navigational":19.5816,
"navigator":41.6110,
"navy":122.9500,
"nay":20.3348,
"nazi":92.6361,
"nb":0.3766,
"nc":0.3766,
"nd":2.4477,
"ne":0.5649,
"near":3996.1575,
"nearby":633.2019,
"nearer":102.4270,
"nearest":24.4770,
"nearing":0.1883,
"nearly":2027.8277,
"nearness":20.7113,
"neat":313.4943,
"neater":3.9540,
"neath":1.5063,
"neatly":239.1217,
"neatness":13.1799,
"nebula":5.0837,
"necessarily":996.5917,
"necessary":3215.3402,
"necessitate":125.7743,
"necessity":365.2726,
"neck":1112.1986,
"necked":16.9456,
"necklace":67.7825,
"neckline":22.4059,
"necromancer":5.8368,
"necrosis":20.3348,
"nectar":23.7239,
"nee":5.4603,
"need":16795.9493,
"needed":3.3891,
"needing":0.3766,
"needle":424.2057,
"needled":0.9414,
"needlepoint":1.8828,
"needless":99.2261,
"needlessly":16.1925,
"needlework":13.1799,
"needling":2.4477,
"needs":6.7783,
"needy":45.5649,
"negate":41.2344,
"negation":32.3850,
"negative":903.7672,
"negatively":43.6821,
"negativity":9.6025,
"neglect":472.5950,
"neglected":6.0251,
"negligence":226.8832,
"negligent":64.5817,
"negligible":86.7993,
"negotiable":33.1381,
"negotiate":638.4739,
"negotiating":66.8411,
"negotiation":858.3906,
"negotiator":87.3642,
"negro":21.4645,
"neighbor":1.6946,
"neighborhood":2.0711,
"neighboring":1.5063,
"neighbour":912.9932,
"neighbourhood":261.7159,
"neighbouring":140.0839,
"neither":1442.8267,
"nelson":2.0711,
"nematode":21.0879,
"nemesis":6.0251,
"neolithic":21.6528,
"neon":38.5984,
"neonatal":23.9122,
"neoplasm":5.0837,
"neoprene":3.9540,
"nepal":0.1883,
"nepalese":11.6737,
"nepali":1.5063,
"nephew":140.6488,
"nephews":0.1883,
"neptune":0.1883,
"nerd":3.3891,
"nero":0.1883,
"nerve":493.3063,
"nervous":531.3398,
"nervously":118.0546,
"nervousness":57.9917,
"nest":397.2810,
"nested":3.5774,
"nesting":36.5273,
"nestle":42.7407,
"nestled":0.5649,
"net":1413.2660,
"netball":15.0628,
"nether":5.6485,
"nets":0.5649,
"netted":0.3766,
"netting":45.3766,
"network":1423.0568,
"networked":29.3724,
"networking":82.2805,
"networks":0.1883,
"neural":90.9416,
"neurobiology":1.3180,
"neurological":31.8201,
"neurology":6.4017,
"neuron":83.5985,
"neuronal":19.0168,
"neuroscience":5.2720,
"neurosurgery":1.5063,
"neurotic":54.2260,
"neurotransmitter":27.3013,
"neutral":284.1218,
"neutralisation":7.9080,
"neutralise":34.0796,
"neutralised":0.3766,
"neutralising":0.5649,
"neutrality":80.2093,
"neutralization":2.6360,
"neutralize":25.9833,
"neutrino":16.5691,
"neutrinos":12.9917,
"neutron":94.3307,
"never":9677.6526,
"nevertheless":1277.8892,
"nevis":0.5649,
"new":19195.8279,
"newborn":40.4812,
"newcastle":0.1883,
"newcomer":184.1426,
"newer":1.6946,
"newfoundland":0.3766,
"newly":620.0220,
"newness":11.4854,
"news":1976.8026,
"newsflash":3.2008,
"newsgroup":0.3766,
"newsletter":123.8914,
"newspaper":1384.0819,
"newsreader":12.8034,
"newsroom":15.8159,
"newsstand":2.4477,
"newt":6.5900,
"newton":4.8954,
"newtonian":19.2051,
"next":7999.4698,
"nexus":18.8285,
"nh":0.3766,
"ni":10.3557,
"niacin":0.1883,
"niagara":0.1883,
"nib":6.0251,
"nicaraguan":22.9708,
"nice":2250.0039,
"nicely":169.0798,
"niceness":6.5900,
"nicer":1.5063,
"nicest":0.1883,
"niche":101.8621,
"nick":105.4395,
"nickel":35.9624,
"nickelodeon":1.1297,
"nickname":122.1969,
"nicotine":34.8327,
"niece":95.6487,
"nieces":0.1883,
"nielsen":0.1883,
"nifty":9.6025,
"niger":0.5649,
"nigerian":29.7490,
"nigger":28.6193,
"nigh":25.9833,
"night":6824.7607,
"nightclub":71.7365,
"nightingale":13.3682,
"nightlife":22.9708,
"nightly":39.7281,
"nightmare":294.6658,
"nightmares":0.3766,
"nights":0.9414,
"nighttime":4.3306,
"nightwear":3.0126,
"nike":0.7531,
"nil":102.6152,
"nimbus":2.8243,
"nina":1.5063,
"nine":2613.3936,
"nineteen":858.0140,
"nineteenth":787.9721,
"ninetieth":3.7657,
"ninety":900.7547,
"ning":0.1883,
"ninja":2.0711,
"ninth":175.1049,
"nip":89.2470,
"nipple":68.9123,
"nirvana":1.5063,
"nit":11.6737,
"nitrate":119.9374,
"nitric":16.0042,
"nitrite":17.1339,
"nitrogen":144.9793,
"nitrous":12.4268,
"nix":1.5063,
"nm":28.4310,
"no":36748.3057,
"nob":5.0837,
"nobility":126.1508,
"noble":285.0633,
"nobler":4.7071,
"noblest":0.1883,
"nobly":12.0502,
"nobody":1047.0520,
"nocturnal":41.2344,
"nod":921.4660,
"nodding":2.2594,
"node":237.6155,
"noel":1.6946,
"noise":970.9849,
"noisily":44.0587,
"noisy":180.5652,
"nomad":21.2762,
"nomadic":49.1423,
"nome":81.5273,
"nomenclature":24.4770,
"nominal":149.6864,
"nominally":42.7407,
"nominate":189.9794,
"nominated":29.7490,
"nominating":0.7531,
"nomination":159.1007,
"nominee":59.4980,
"non":3774.9228,
"noncompliance":2.0711,
"nonconformist":18.2636,
"nonconformity":15.0628,
"none":1606.2580,
"nonetheless":233.4732,
"nonexistent":6.9665,
"nonfiction":0.9414,
"nongovernmental":0.1883,
"nonlinear":14.4979,
"nonprofit":3.3891,
"nonpublic":2.0711,
"nonresident":0.7531,
"nonsense":289.7704,
"nonsensical":16.0042,
"nonstick":2.0711,
"nonstop":5.6485,
"nonviolent":1.3180,
"noodle":20.3348,
"nook":20.5230,
"noon":124.2680,
"noone":3.5774,
"nor":2177.8908,
"nordic":26.1716,
"norfolk":1.1297,
"norm":326.4859,
"norma":0.1883,
"normal":2184.1042,
"normalisation":20.5230,
"normalise":19.0168,
"normalised":1.5063,
"normalising":1.1297,
"normality":61.9457,
"normalization":24.2887,
"normalize":21.2762,
"normalized":0.9414,
"normalizing":0.9414,
"normally":1461.8435,
"norman":17.1339,
"normandy":0.7531,
"normative":60.4394,
"norms":0.7531,
"norris":0.1883,
"norse":18.4519,
"north":1808.4759,
"northeast":20.8996,
"northeastern":5.2720,
"northerly":25.4185,
"northern":815.8382,
"northerner":8.2845,
"northward":24.4770,
"northwards":44.6235,
"northwest":19.2051,
"northwestern":6.9665,
"norwegian":101.1090,
"nos":0.9414,
"nose":850.8592,
"nosed":38.5984,
"nostalgia":87.1759,
"nostalgic":49.5189,
"not":81200.2857,
"notable":291.6532,
"notably":417.8041,
"notary":9.6025,
"notation":98.4730,
"notch":71.1717,
"notched":4.1423,
"note":4087.8522,
"notebook":173.4103,
"notebooks":0.1883,
"noted":3.9540,
"notepad":16.3808,
"noteworthy":48.5775,
"nothing":5705.2190,
"notice":2671.3853,
"noticeable":148.5567,
"noticeably":59.3097,
"noticeboard":15.8159,
"noticed":3.2008,
"notices":0.1883,
"noticing":2.2594,
"notification":71.9248,
"notify":174.1635,
"noting":1.1297,
"notion":818.2859,
"notional":44.4352,
"notorious":159.6655,
"notoriously":87.9290,
"notwithstanding":125.7743,
"noun":161.7367,
"nourish":48.5775,
"nourished":0.9414,
"nourishment":27.4896,
"nous":5.0837,
"nov":29.5607,
"nova":1.6946,
"novel":966.6544,
"novelist":156.0881,
"novelty":102.0504,
"novice":101.4855,
"now":25199.8549,
"nowadays":286.1930,
"nowhere":412.5321,
"noxious":32.1967,
"nozzle":43.8704,
"np":1.3180,
"nra":0.3766,
"nsf":1.3180,
"nt":3.5774,
"nth":4.3306,
"nu":1.5063,
"nuclear":1373.7262,
"nucleic":25.7950,
"nucleon":3.7657,
"nucleotide":57.0503,
"nucleus":172.8455,
"nude":85.4813,
"nudge":87.7407,
"nudism":0.1883,
"nudist":4.3306,
"nudity":13.1799,
"nugget":14.4979,
"nuisance":182.6363,
"nuke":3.9540,
"null":48.9541,
"numb":82.8453,
"number":10806.4202,
"numbered":27.3013,
"numbering":20.8996,
"numbness":17.1339,
"numeracy":21.0879,
"numeral":18.4519,
"numerator":9.2260,
"numeric":38.0335,
"numerical":123.5149,
"numerically":33.5147,
"numerology":2.0711,
"numerous":578.7876,
"nun":154.9584,
"nunavut":0.1883,
"nuns":0.1883,
"nurse":1051.9474,
"nursed":0.1883,
"nursery":335.9002,
"nursing":453.3899,
"nurture":91.6947,
"nurturing":7.1548,
"nut":266.0465,
"nutcracker":3.0126,
"nutmeg":11.1088,
"nutrient":134.0588,
"nutrition":76.4436,
"nutritional":69.1005,
"nutritious":29.3724,
"nuts":10.5440,
"nutshell":15.0628,
"nutty":21.0879,
"nw":1.3180,
"ny":1.1297,
"nylon":128.5985,
"nymph":23.1590,
"o":1071.9056,
"oahu":0.1883,
"oak":261.5276,
"oaks":0.3766,
"oar":36.9038,
"oars":0.5649,
"oasis":47.0712,
"oat":39.5398,
"oath":125.3977,
"oatmeal":11.1088,
"oats":14.6862,
"ob":3.2008,
"obedience":116.7366,
"obedient":36.7155,
"obediently":29.9373,
"obese":30.5021,
"obesity":38.9750,
"obey":237.9920,
"obeyed":0.3766,
"obi":0.1883,
"obit":2.8243,
"obituary":37.8453,
"object":2135.3384,
"objection":454.3313,
"objectionable":30.6904,
"objective":1569.1659,
"objectively":59.8746,
"objectivity":75.1257,
"obligated":0.9414,
"obligation":724.7084,
"obligatory":59.6863,
"oblige":426.0886,
"obliged":4.3306,
"oblique":37.6570,
"oblivion":41.4227,
"oblivious":59.3097,
"obnoxious":26.1716,
"oboe":19.3933,
"obscene":76.2554,
"obscenity":49.1423,
"obscure":324.7914,
"obscured":0.3766,
"obscurity":42.9289,
"observable":63.6403,
"observance":47.4478,
"observation":886.6333,
"observational":35.0210,
"observatory":27.4896,
"observe":1339.0818,
"observed":64.0168,
"observer":467.1347,
"observing":2.0711,
"obsessed":51.0252,
"obsession":138.3894,
"obsessive":57.9917,
"obsidian":8.0962,
"obsolete":63.4520,
"obstacle":247.2180,
"obstacles":0.3766,
"obstruct":69.8537,
"obstructed":0.9414,
"obstruction":103.7449,
"obstructive":29.7490,
"obtain":2237.9536,
"obtainable":42.5524,
"obtaining":17.3222,
"obvious":1505.9022,
"obviously":1934.6267,
"occasion":1676.6765,
"occasional":455.2727,
"occasionally":701.3610,
"occasioned":0.1883,
"occidental":1.8828,
"occlusion":15.2511,
"occult":41.6110,
"occupancy":54.0377,
"occupant":136.1299,
"occupation":576.3399,
"occupational":290.3352,
"occupied":57.0503,
"occupier":114.6655,
"occupy":887.7630,
"occupying":4.8954,
"occur":2748.0173,
"occurred":0.1883,
"occurrence":250.9837,
"occurring":4.5188,
"ocean":320.0842,
"oceanfront":0.1883,
"oceanic":65.5231,
"oceanographic":2.4477,
"oceanography":3.0126,
"oceans":0.3766,
"och":5.2720,
"oct":40.8578,
"octagon":8.4728,
"octane":11.2971,
"octave":30.6904,
"octet":0.7531,
"octopus":28.0544,
"ocular":7.7197,
"od":3.5774,
"odd":1113.7048,
"oddly":130.1048,
"odds":1.3180,
"ode":11.1088,
"oder":0.3766,
"odin":0.3766,
"odor":0.3766,
"odour":165.1258,
"odyssey":10.9205,
"oedipus":1.1297,
"of":545331.8351,
"off":13539.1864,
"offbeat":5.0837,
"offence":986.6126,
"offences":0.1883,
"offend":245.7117,
"offended":1.3180,
"offender":308.4106,
"offending":7.5314,
"offense":4.3306,
"offensive":259.4565,
"offensively":5.2720,
"offer":6487.5425,
"offering":227.6364,
"offers":0.1883,
"office":3770.2157,
"officer":2730.8833,
"official":2734.0842,
"officialdom":17.5105,
"officially":316.1302,
"officiating":0.7531,
"offline":71.9248,
"offset":224.4355,
"offsetting":0.7531,
"offshore":159.8538,
"offspring":172.4689,
"oft":25.6067,
"often":6779.3840,
"ogden":0.1883,
"ogre":9.0377,
"oh":8250.2652,
"ohm":17.3222,
"oil":1967.3883,
"oiled":0.3766,
"oiliness":2.0711,
"oils":0.5649,
"oily":51.7783,
"ointment":21.6528,
"ok":401.2350,
"okay":1351.8852,
"ola":0.1883,
"old":12321.1718,
"older":1.6946,
"oldest":2.8243,
"ole":15.4394,
"olfactory":13.7448,
"olive":170.2095,
"olivier":0.1883,
"olympia":1.1297,
"olympiad":0.1883,
"olympian":7.3431,
"olympic":124.0797,
"omaha":0.1883,
"oman":1.8828,
"omani":1.8828,
"omb":0.1883,
"ombudsman":26.5482,
"omega":14.4979,
"omen":42.7407,
"ominous":62.1340,
"omission":150.2513,
"omit":257.0088,
"omitting":0.1883,
"omnibus":15.6276,
"on":131887.3183,
"once":6780.8903,
"oncogene":14.4979,
"oncology":3.3891,
"one":56868.9888,
"oneness":11.2971,
"onerous":42.9289,
"ones":0.5649,
"oneself":127.4688,
"ongoing":124.4563,
"onion":194.3100,
"online":94.8956,
"only":26896.6779,
"ono":1.6946,
"onscreen":4.7071,
"onset":147.6153,
"onshore":24.8536,
"onslaught":58.1800,
"onstage":20.8996,
"ont":0.5649,
"ontario":0.3766,
"onto":1085.0855,
"ontological":49.7072,
"ontology":9.6025,
"onus":42.9289,
"onward":49.1423,
"onwards":238.9335,
"onyx":3.0126,
"ooh":496.3188,
"ooze":52.9080,
"op":86.0462,
"opacity":11.8619,
"opal":11.4854,
"opaque":59.3097,
"opec":1.8828,
"open":7847.5239,
"opened":2.2594,
"opener":76.2554,
"opening":949.3322,
"openly":214.6447,
"openness":85.2930,
"opens":4.1423,
"opera":311.0466,
"operable":3.0126,
"operand":32.7616,
"operas":0.3766,
"operate":2125.1710,
"operated":0.3766,
"operating":422.3229,
"operation":3320.2149,
"operational":287.5110,
"operative":386.7371,
"operator":524.1850,
"operators":0.9414,
"ophthalmic":8.8494,
"ophthalmology":4.3306,
"opiate":17.6988,
"opinion":1642.2204,
"opinionated":11.4854,
"opioid":32.3850,
"opium":39.9164,
"oppenheimer":0.1883,
"opponent":536.0469,
"opportunistic":19.2051,
"opportunity":2847.8082,
"oppose":1062.4914,
"opposed":54.4143,
"opposing":11.1088,
"opposite":1061.7382,
"opposition":1439.8142,
"oppressed":49.7072,
"oppression":130.4814,
"oppressive":79.6445,
"ops":2.8243,
"opt":382.2182,
"opted":0.5649,
"optic":67.4060,
"optical":164.5610,
"optically":8.6611,
"optimal":141.7785,
"optimally":6.0251,
"optimisation":11.8619,
"optimise":44.2469,
"optimism":153.6404,
"optimist":27.4896,
"optimistic":232.5318,
"optimization":8.2845,
"optimize":17.1339,
"optimizer":0.5649,
"optimizing":0.1883,
"optimum":103.7449,
"opting":11.2971,
"option":1606.2580,
"optional":136.5065,
"optionally":3.9540,
"optometry":0.7531,
"opus":4.1423,
"or":65526.1375,
"oracle":20.1465,
"oral":398.7873,
"orally":31.4436,
"orange":384.2894,
"orb":11.8619,
"orbit":194.6865,
"orbital":55.1675,
"orbiter":2.4477,
"orbiting":0.5649,
"orchard":91.5064,
"orchards":0.5649,
"orchestra":189.6028,
"orchestral":52.5315,
"orchestrated":4.5188,
"orchid":51.5900,
"ordained":2.0711,
"ordeal":109.0169,
"order":7779.5531,
"ordered":4.8954,
"ordering":71.3600,
"orderly":107.5106,
"ordinal":5.2720,
"ordinance":22.9708,
"ordinarily":58.5566,
"ordinary":1205.7761,
"ordinate":250.7954,
"ordinating":50.4603,
"ordination":175.6698,
"ordnance":16.1925,
"ore":103.3684,
"oregano":4.8954,
"ores":0.1883,
"org":2.2594,
"organ":417.0509,
"organic":376.1931,
"organically":20.8996,
"organisation":2191.0707,
"organisational":170.5861,
"organise":1067.5751,
"organised":92.6361,
"organiser":286.7578,
"organising":19.2051,
"organism":355.2935,
"organization":1472.5757,
"organizational":170.7744,
"organize":629.4362,
"organized":82.8453,
"organizer":66.8411,
"organizing":13.9331,
"organs":0.1883,
"organza":3.5774,
"orgasm":38.4101,
"orgy":35.7741,
"orient":278.8499,
"oriental":109.3935,
"orientate":80.3976,
"orientated":38.4101,
"orientating":0.1883,
"orientation":222.9293,
"oriented":6.9665,
"orienteering":5.8368,
"orienting":0.1883,
"orifice":15.0628,
"orig":0.1883,
"origami":3.7657,
"origin":798.8926,
"original":2030.8403,
"originality":55.1675,
"originally":794.5620,
"originate":256.4440,
"originated":2.2594,
"originating":17.3222,
"origination":4.3306,
"originator":41.6110,
"origins":0.1883,
"orion":1.1297,
"orlando":0.3766,
"ornament":122.1969,
"ornamental":67.0294,
"ornate":57.2386,
"orphan":75.6905,
"orphanage":40.4812,
"orphaned":5.6485,
"orr":0.1883,
"orthodox":150.0630,
"orthodoxy":66.0880,
"orthogonal":15.2511,
"orthopaedic":32.5733,
"orthopedic":0.1883,
"os":23.1590,
"osage":0.1883,
"osaka":0.1883,
"oscar":16.9456,
"oscillation":40.8578,
"oscillator":18.8285,
"osha":0.9414,
"osiris":0.1883,
"osprey":6.2134,
"ostensibly":74.5608,
"osteoarthritis":3.5774,
"osteopathic":0.3766,
"osteoporosis":14.3096,
"ostrich":25.7950,
"othello":0.3766,
"other":32676.4577,
"otherwise":1530.3792,
"ottawa":0.1883,
"otter":54.4143,
"ottoman":27.3013,
"ought":1058.1608,
"ounce":95.8370,
"our":17042.6025,
"ours":133.6822,
"ourselves":809.4365,
"out":36978.3898,
"outage":3.2008,
"outback":10.1674,
"outboard":17.6988,
"outbound":19.0168,
"outbreak":208.9962,
"outburst":86.7993,
"outcome":816.4031,
"outcry":52.5315,
"outdated":39.3515,
"outdoor":162.4898,
"outdoors":57.9917,
"outer":382.4065,
"outerwear":1.3180,
"outfit":197.6991,
"outfits":1.3180,
"outfitter":5.0837,
"outflow":45.1884,
"outgoing":125.7743,
"outing":125.9626,
"outlaw":88.3056,
"outlawed":0.9414,
"outlay":53.4729,
"outlet":250.6071,
"outline":855.0015,
"outlined":0.1883,
"outlines":0.9414,
"outlining":0.9414,
"outlook":205.6070,
"outlying":28.8076,
"outpatient":61.9457,
"outperform":19.5816,
"outpost":29.5607,
"output":1184.3117,
"outrage":149.8747,
"outraged":58.9332,
"outrageous":109.3935,
"outreach":19.2051,
"outrigger":3.7657,
"outright":130.2931,
"outset":178.6823,
"outside":3809.7555,
"outsider":225.5652,
"outsource":2.2594,
"outsourcing":2.6360,
"outspoken":53.6612,
"outstanding":523.0553,
"outta":5.8368,
"outward":124.6446,
"outwardly":31.2553,
"outwards":78.5148,
"outweigh":91.8830,
"oval":83.4102,
"ovarian":8.8494,
"ovary":25.2302,
"ovation":29.9373,
"oven":242.1343,
"over":23255.0608,
"overall":1413.8309,
"overarching":0.3766,
"overboard":37.6570,
"overcast":19.0168,
"overcome":612.3023,
"overcoming":3.3891,
"overcrowded":56.4855,
"overcrowding":50.2721,
"overdose":64.9583,
"overdraft":73.6194,
"overdrive":30.1256,
"overdue":66.6528,
"overestimate":31.8201,
"overestimated":5.2720,
"overflow":122.3851,
"overflowing":7.5314,
"overfull":2.0711,
"overhaul":79.0796,
"overhead":284.4984,
"overheard":1.6946,
"overheating":3.7657,
"overkill":12.4268,
"overlaid":2.8243,
"overland":16.0042,
"overlap":293.1595,
"overlapped":0.7531,
"overlapping":21.2762,
"overlaps":0.1883,
"overlay":57.4269,
"overload":57.6152,
"overloaded":14.3096,
"overloading":3.7657,
"overlook":371.8626,
"overlooked":3.2008,
"overlooking":0.3766,
"overly":33.1381,
"overnight":324.4148,
"overpayment":6.7783,
"overpriced":6.5900,
"overrated":6.4017,
"overridden":5.2720,
"override":152.6990,
"overriding":13.7448,
"overrun":51.4018,
"overseas":607.4069,
"oversee":118.4312,
"overseeing":1.6946,
"overshadowed":0.9414,
"oversight":28.6193,
"oversize":3.9540,
"overstated":0.9414,
"overstock":6.7783,
"overt":102.8035,
"overtake":161.3601,
"overthrow":140.0839,
"overtime":119.1843,
"overtly":44.8118,
"overture":41.6110,
"overturn":120.3140,
"overturned":3.3891,
"overuse":5.8368,
"overview":104.3098,
"overviews":0.5649,
"overweight":68.9123,
"overwhelm":100.9207,
"overwhelmed":49.1423,
"overwhelming":235.3561,
"overwhelmingly":95.4604,
"overwrite":8.2845,
"overwritten":1.5063,
"ovulation":17.1339,
"ow":42.3641,
"owe":795.5035,
"owen":2.0711,
"owens":0.1883,
"owes":0.1883,
"owing":1.6946,
"owl":219.3518,
"own":13609.4167,
"owned":0.1883,
"owner":1689.8565,
"ownership":575.5868,
"owning":4.7071,
"ox":35.7741,
"oxen":25.4185,
"oxford":0.9414,
"oxidation":34.0796,
"oxide":119.3726,
"oxidized":0.7531,
"oxygen":350.5864,
"oyster":53.6612,
"ozone":238.9335,
"p":1141.5710,
"pa":1.8828,
"pac":6.5900,
"pace":712.4698,
"paced":2.2594,
"pacemaker":12.4268,
"paces":0.1883,
"pacific":11.2971,
"pacing":14.1214,
"pack":1175.2740,
"package":1338.8935,
"packaged":4.1423,
"packager":1.5063,
"packaging":165.6907,
"packed":81.5273,
"packer":10.3557,
"packet":306.7160,
"packing":96.2136,
"pact":116.5483,
"pad":276.2139,
"padded":54.6026,
"padding":21.8410,
"paddle":116.1717,
"paddling":11.2971,
"paddock":47.4478,
"paddy":25.6067,
"padre":4.5188,
"paediatric":23.1590,
"pagan":91.1299,
"page":2562.9333,
"pageant":36.3390,
"pager":13.5565,
"paging":1.5063,
"pagoda":9.0377,
"paid":8.0962,
"pain":1489.5214,
"paine":0.5649,
"painful":342.8667,
"painfully":121.8203,
"painkiller":21.8410,
"painless":23.3473,
"pains":0.1883,
"paint":1393.4961,
"paintball":1.1297,
"painted":4.3306,
"painter":304.0800,
"painting":1143.2656,
"pair":1519.2704,
"paired":3.5774,
"pairing":30.3139,
"pairs":0.1883,
"paisley":2.4477,
"pajama":0.1883,
"pakistan":1.1297,
"pakistani":56.2972,
"pal":136.8831,
"palace":295.0423,
"paladin":5.0837,
"palatable":24.6653,
"palate":31.8201,
"palatine":3.5774,
"pale":681.2146,
"paleness":5.0837,
"paleontology":2.2594,
"palermo":0.1883,
"palestine":0.1883,
"palestinian":204.2891,
"palette":59.8746,
"paling":3.5774,
"pall":22.0293,
"palladium":14.6862,
"pallet":29.1842,
"palliative":16.7574,
"palm":310.2934,
"palmer":0.9414,
"palmetto":0.3766,
"palmyra":0.1883,
"palpable":23.7239,
"pals":0.1883,
"palsy":19.9582,
"pamper":31.6319,
"pampered":3.7657,
"pamphlet":128.9751,
"pan":346.6324,
"panache":19.9582,
"panama":1.5063,
"panamanian":23.3473,
"pancake":36.3390,
"pancreas":6.0251,
"pancreatic":86.6110,
"panda":24.4770,
"pandemic":3.3891,
"pane":58.7449,
"panel":776.4867,
"panelled":6.7783,
"panelling":35.0210,
"pang":43.3055,
"panhandle":1.1297,
"panic":431.7371,
"panorama":24.2887,
"panoramas":4.3306,
"panoramic":33.5147,
"pant":170.9626,
"pantheon":10.3557,
"panther":10.3557,
"pantie":12.0502,
"pantry":28.8076,
"pantyhose":0.5649,
"panzer":0.9414,
"pap":5.4603,
"papa":3.9540,
"papal":130.4814,
"papaya":1.8828,
"paper":3918.9607,
"paperback":92.6361,
"papering":0.5649,
"paperless":6.9665,
"paperwork":89.6236,
"papyrus":11.2971,
"par":195.8162,
"para":25.4185,
"parable":55.7323,
"parabolic":6.0251,
"parachute":93.5776,
"parade":235.5443,
"paradigm":108.6404,
"paradigms":13.5565,
"paradise":76.8202,
"paradox":122.0086,
"paradoxical":47.0712,
"paraffin":44.2469,
"paragliding":2.2594,
"paragon":13.1799,
"paragraph":577.0930,
"paragraphing":1.6946,
"paragraphs":1.1297,
"paraguay":0.3766,
"paralegal":0.7531,
"parallel":720.3778,
"parallelism":27.6779,
"parallelled":0.1883,
"paralysis":37.0921,
"paralyzed":0.1883,
"paramedic":17.6988,
"paramedics":0.3766,
"parameter":303.7034,
"parametric":15.6276,
"paramilitary":68.3474,
"paramount":87.5525,
"paranoia":37.0921,
"paranoid":53.4729,
"paranormal":7.7197,
"paraphernalia":23.3473,
"paraphrase":45.0001,
"parasite":135.5651,
"parasitic":44.4352,
"parcel":222.7410,
"parcelled":0.1883,
"parcels":0.5649,
"parchment":51.5900,
"pardon":138.3894,
"pardoning":0.5649,
"parent":3670.2364,
"parentage":18.0753,
"parental":241.5695,
"parenthesis":16.9456,
"parenthood":38.2218,
"parenting":39.1632,
"pareto":0.7531,
"paris":0.3766,
"parish":563.1600,
"parishes":0.1883,
"parisian":35.0210,
"parity":75.3139,
"park":1273.5587,
"parka":5.2720,
"parked":3.0126,
"parker":7.1548,
"parking":257.3854,
"parkland":32.5733,
"parks":2.2594,
"parkway":0.5649,
"parliament":658.6204,
"parliamentary":683.8505,
"parlor":1.3180,
"parlour":92.0713,
"parmesan":3.5774,
"parochial":42.1758,
"parody":74.7491,
"parole":34.0796,
"parr":0.1883,
"parrish":0.1883,
"parrot":84.3516,
"parrots":0.1883,
"parry":18.0753,
"parse":47.2595,
"parsed":0.3766,
"parser":17.5105,
"parsing":6.7783,
"parsley":57.9917,
"parson":42.7407,
"part":12107.2802,
"partake":22.4059,
"parted":11.2971,
"partial":311.2348,
"partially":237.0506,
"participant":506.4862,
"participate":581.0470,
"participating":1.3180,
"participation":475.2309,
"participatory":24.6653,
"particle":433.0551,
"particles":0.1883,
"particular":5304.9254,
"particularly":3902.9565,
"particulate":15.6276,
"parties":0.7531,
"parting":62.1340,
"partisan":93.5776,
"partition":116.5483,
"partitioned":3.7657,
"partitioning":6.9665,
"partly":1017.1147,
"partner":1561.2579,
"partnering":2.0711,
"partnership":657.1141,
"partridge":22.7825,
"parts":0.1883,
"party":7173.0876,
"partying":3.3891,
"pas":3.5774,
"pascal":0.7531,
"pasha":0.9414,
"pass":4276.1370,
"passage":849.1646,
"passe":1.8828,
"passed":0.9414,
"passenger":794.5620,
"passer":62.3223,
"passing":118.2429,
"passion":438.1388,
"passionate":163.2430,
"passionately":63.2637,
"passive":257.0088,
"passively":29.9373,
"passivity":28.9959,
"passover":0.5649,
"passport":183.3894,
"password":58.1800,
"past":4683.7737,
"pasta":97.7198,
"paste":112.7826,
"pasted":0.1883,
"pastel":80.2093,
"pasteur":0.1883,
"pastime":56.1089,
"pasting":4.8954,
"pastor":37.8453,
"pastoral":119.9374,
"pastry":100.9207,
"pasture":179.2472,
"pastures":0.5649,
"pat":170.2095,
"patch":482.7623,
"patched":3.0126,
"patches":0.1883,
"patching":1.5063,
"patchwork":39.1632,
"patchy":55.1675,
"pate":14.3096,
"patent":246.0883,
"patented":14.6862,
"patenting":4.1423,
"patently":38.0335,
"paternal":33.3264,
"paternity":11.2971,
"paterson":0.1883,
"path":1298.4123,
"pathetic":117.4897,
"pathfinder":10.5440,
"pathogen":28.9959,
"pathogenesis":42.5524,
"pathogenic":24.2887,
"pathological":54.9792,
"pathologist":53.4729,
"pathology":50.6486,
"pathway":138.2011,
"patience":206.1719,
"patient":4588.6899,
"patiently":91.1299,
"patients":0.1883,
"patio":86.7993,
"paton":0.1883,
"patriarch":14.3096,
"patriarchal":50.8369,
"patrick":2.0711,
"patriot":40.4812,
"patriotic":62.5106,
"patriotism":50.2721,
"patrol":262.8456,
"patrolling":8.2845,
"patrols":0.1883,
"patron":187.5317,
"patronage":153.0756,
"patsy":1.1297,
"patten":12.2385,
"pattern":2721.8457,
"patterned":8.2845,
"patterning":41.2344,
"patterns":3.2008,
"patty":2.2594,
"paul":4.1423,
"pauline":0.1883,
"pause":738.0766,
"paused":0.1883,
"pausing":0.9414,
"pave":124.2680,
"paved":22.9708,
"pavement":305.2097,
"pavilion":70.6068,
"paving":33.7030,
"paw":82.2805,
"pawn":42.5524,
"pawnee":0.3766,
"pay":7925.0973,
"payable":289.7704,
"payback":10.5440,
"paycheck":1.1297,
"payday":3.0126,
"payee":7.3431,
"payer":100.3558,
"paying":7.7197,
"payload":9.2260,
"payment":1794.1663,
"payoff":22.4059,
"payout":35.7741,
"payroll":69.4771,
"pays":0.1883,
"pb":0.3766,
"pc":364.7077,
"pcp":0.7531,
"pct":1.1297,
"pd":0.1883,
"pda":1.1297,
"pe":24.2887,
"pea":140.4605,
"peace":1430.0234,
"peaceful":292.4064,
"peacefully":68.5357,
"peacekeeping":51.4018,
"peach":64.3934,
"peacock":36.5273,
"peak":666.7166,
"peaked":14.3096,
"peaking":0.9414,
"peaks":0.3766,
"peanut":56.1089,
"pear":93.5776,
"pearl":121.8203,
"peasant":577.8462,
"peat":146.6739,
"pebble":92.0713,
"pecan":3.0126,
"peck":64.9583,
"peculiar":250.7954,
"peculiarity":39.9164,
"peculiarly":53.4729,
"pecuniary":32.5733,
"pedagogical":21.2762,
"pedagogy":29.3724,
"pedal":119.1843,
"pedantic":15.0628,
"pedestal":38.0335,
"pedestrian":156.4647,
"pediatric":2.2594,
"pediatrician":0.3766,
"pedicure":2.2594,
"pedigree":58.3683,
"pee":42.5524,
"peeing":0.3766,
"peek":25.4185,
"peel":185.8371,
"peeled":0.1883,
"peeling":10.1674,
"peep":69.6654,
"peeping":3.7657,
"peepshow":1.3180,
"peer":545.6495,
"peering":1.6946,
"peerless":5.4603,
"peg":172.4689,
"pegasus":0.3766,
"pegs":0.1883,
"pei":0.1883,
"peirce":0.5649,
"peking":1.1297,
"pelican":17.8871,
"pellet":99.6027,
"pelvic":34.6444,
"pelvis":29.1842,
"pen":496.8837,
"penal":112.2178,
"penalty":660.1267,
"pence":17.6988,
"penchant":29.9373,
"pencil":263.7871,
"pendant":42.5524,
"pending":3.5774,
"pendulum":40.8578,
"penelope":0.3766,
"penetrate":250.4188,
"penetrating":6.0251,
"penetration":101.8621,
"penguin":40.2930,
"penicillin":35.9624,
"penile":4.1423,
"peninsula":75.1257,
"penis":101.8621,
"penn":0.7531,
"pennant":13.5565,
"penny":489.9172,
"pension":1093.1818,
"pentagon":4.8954,
"pentecost":3.3891,
"pentecostal":4.3306,
"penthouse":17.1339,
"people":22070.3726,
"peoples":0.1883,
"pep":13.1799,
"pepper":142.9082,
"peppermint":12.9917,
"pepsi":0.1883,
"peptide":107.1341,
"per":9333.6562,
"perceive":656.3610,
"perceiving":0.9414,
"percent":523.0553,
"percentage":555.6286,
"percentile":6.5900,
"perception":599.8755,
"perceptive":49.1423,
"perceptual":63.6403,
"perch":166.8204,
"perched":0.3766,
"percussion":26.3599,
"percy":0.9414,
"peregrine":16.9456,
"perennial":73.4311,
"perfect":1035.0018,
"perfected":1.5063,
"perfecting":0.9414,
"perfection":123.3266,
"perfectly":788.5369,
"perforated":14.1214,
"perforce":12.4268,
"perform":1608.7057,
"performance":2605.1091,
"performances":0.5649,
"performed":0.9414,
"performer":197.1342,
"performing":8.8494,
"perfume":123.1383,
"perfusion":26.5482,
"perhaps":6054.6757,
"peri":3.0126,
"peril":72.6779,
"perilous":31.0670,
"perimeter":82.2805,
"perinatal":18.6402,
"period":4866.4100,
"periodic":98.2847,
"periodical":71.5482,
"periodically":70.9834,
"periodontal":9.9791,
"peripheral":194.3100,
"periphery":63.2637,
"perish":73.8077,
"perishable":21.6528,
"perished":1.1297,
"peritoneal":5.8368,
"perjury":12.8034,
"perky":10.5440,
"perm":72.6779,
"permanent":777.2398,
"permanently":218.9753,
"permeability":40.8578,
"permeable":14.4979,
"permian":11.4854,
"permissible":61.7574,
"permission":600.6286,
"permissive":42.3641,
"permit":919.2066,
"permitted":0.3766,
"permitting":14.8745,
"permutation":25.9833,
"peroxidase":12.8034,
"peroxide":31.8201,
"perpendicular":35.5858,
"perpetrator":35.3976,
"perpetrators":0.1883,
"perpetual":85.1047,
"perpetually":29.5607,
"perpetuate":83.9750,
"perplexed":19.7699,
"perry":1.5063,
"persecuted":0.1883,
"persecution":77.7616,
"perseverance":22.7825,
"pershing":0.3766,
"persian":73.9959,
"persist":319.8959,
"persisted":0.1883,
"persistence":81.9039,
"persistent":222.3644,
"persistently":45.0001,
"person":5068.6279,
"persona":50.6486,
"personal":3003.5198,
"personalised":26.5482,
"personality":657.4907,
"personalization":1.1297,
"personalize":8.0962,
"personalized":7.9080,
"personally":467.1347,
"personnel":534.7290,
"perspective":652.2187,
"perspiration":31.4436,
"persuade":907.7212,
"persuading":6.4017,
"persuasion":109.2052,
"persuasive":98.6613,
"persuasively":16.0042,
"pertain":43.4938,
"pertaining":0.1883,
"perth":0.1883,
"pertinent":69.2888,
"perturbation":20.3348,
"perturbed":5.6485,
"pertussis":3.5774,
"peru":1.3180,
"peruse":18.8285,
"peruvian":37.4687,
"pervasive":75.5022,
"perverse":75.8788,
"pervert":35.3976,
"perverted":12.4268,
"peseta":20.1465,
"pesky":1.5063,
"peso":21.2762,
"pessimistic":68.7240,
"pest":125.5860,
"pesticide":147.2387,
"pests":0.5649,
"pet":325.3562,
"petal":89.8119,
"peter":2.6360,
"petite":17.3222,
"petition":320.4608,
"petitioner":38.7867,
"petrochemical":32.7616,
"petrol":434.1848,
"petroleum":56.6737,
"pets":0.3766,
"petty":135.0002,
"pew":41.7992,
"pewter":27.1130,
"ph":185.8371,
"phage":12.0502,
"phantom":35.7741,
"pharaoh":4.3306,
"pharmaceutical":111.8412,
"pharmacist":36.7155,
"pharmacological":12.4268,
"pharmacology":9.6025,
"pharmacy":28.0544,
"phase":1100.7132,
"phased":5.6485,
"phasing":21.2762,
"phat":0.3766,
"phd":49.1423,
"pheasant":53.8495,
"phenol":15.6276,
"phenomena":25.0419,
"phenomenal":56.6737,
"phenomenon":593.2855,
"phenotype":36.3390,
"pheromone":29.3724,
"phi":7.1548,
"philanthropic":23.1590,
"philanthropy":17.8871,
"philharmonic":0.1883,
"philip":2.0711,
"philippine":20.3348,
"philippines":0.7531,
"philosopher":212.5736,
"philosophical":213.7033,
"philosophically":24.2887,
"philosophise":1.3180,
"philosophising":2.4477,
"philosophize":1.8828,
"philosophizing":1.1297,
"philosophy":611.9257,
"phobia":26.3599,
"phoebe":0.3766,
"phoenix":8.8494,
"phone":1785.5052,
"phoned":0.3766,
"phonetic":62.6989,
"phoning":0.7531,
"phonological":63.8286,
"phony":3.7657,
"phosphatase":21.0879,
"phosphate":89.0587,
"phosphorus":22.9708,
"photo":385.0425,
"photocopy":69.8537,
"photocopying":14.3096,
"photograph":1150.2321,
"photographed":0.5649,
"photographer":293.3478,
"photographic":144.7910,
"photographing":3.2008,
"photographs":0.7531,
"photography":174.3518,
"photometric":2.2594,
"photometry":1.3180,
"photon":46.8829,
"photos":0.3766,
"photosynthesis":27.1130,
"photovoltaic":5.8368,
"phrase":797.0097,
"phrasing":23.3473,
"phylogenetic":12.9917,
"physical":1623.5802,
"physically":353.7872,
"physician":135.5651,
"physicist":93.7659,
"physics":200.8999,
"physiological":113.3475,
"physiology":52.9080,
"physiotherapy":33.7030,
"physique":29.7490,
"phytoplankton":11.4854,
"pi":24.1005,
"pianist":67.7825,
"piano":316.1302,
"piazza":13.5565,
"pic":24.1005,
"picasso":1.8828,
"piccolo":1.8828,
"pick":2745.3813,
"picked":0.7531,
"picker":20.7113,
"picket":99.0378,
"picking":41.9875,
"pickle":42.7407,
"pickup":107.6989,
"picky":5.4603,
"picnic":136.6948,
"pictorial":58.3683,
"picture":2939.8795,
"pictures":2.4477,
"picturesque":105.0629,
"picturing":0.7531,
"pie":279.4147,
"piece":2715.4440,
"pieces":0.9414,
"pied":9.4142,
"piedmont":0.3766,
"pier":105.6278,
"pierce":138.2011,
"pierced":1.3180,
"piercing":5.0837,
"piety":44.4352,
"pig":436.4443,
"pigeon":165.8789,
"piggy":14.1214,
"piglet":22.4059,
"pigment":76.0671,
"pigs":4.8954,
"pike":40.1047,
"pile":602.3232,
"piled":0.5649,
"piles":0.5649,
"pilgrim":53.4729,
"pilgrimage":83.4102,
"piling":6.4017,
"pill":209.3727,
"pillar":170.5861,
"pillow":192.4271,
"pillows":0.1883,
"pilot":797.3863,
"piloting":4.7071,
"pilots":0.1883,
"pimp":22.0293,
"pin":551.1097,
"pinball":4.3306,
"pinch":186.5903,
"pinched":4.5188,
"pinching":3.2008,
"pine":218.5987,
"pineapple":49.7072,
"pines":0.1883,
"ping":19.9582,
"pink":576.1516,
"pinker":2.8243,
"pinkest":0.1883,
"pinkness":1.3180,
"pinnacle":38.5984,
"pinning":1.5063,
"pinpoint":75.1257,
"pins":0.3766,
"pint":289.3938,
"pinto":0.7531,
"pioneer":236.8623,
"pioneering":79.6445,
"pious":55.5440,
"pip":42.5524,
"pipe":685.5451,
"piped":6.2134,
"pipeline":112.7826,
"piper":22.0293,
"piping":51.7783,
"pippin":1.6946,
"pique":13.7448,
"piracy":24.6653,
"piranha":6.5900,
"pirate":101.6738,
"pirated":2.4477,
"pisa":0.1883,
"pisces":0.1883,
"piss":185.0840,
"pissed":12.9917,
"pissing":0.1883,
"pistol":130.8580,
"pistols":0.5649,
"piston":45.9415,
"pit":525.5030,
"pitch":755.0222,
"pitched":2.2594,
"pitcher":14.3096,
"pitches":0.1883,
"pitching":8.6611,
"pitiful":35.7741,
"pitt":0.9414,
"pitted":2.0711,
"pituitary":10.9205,
"pity":386.7371,
"pitying":4.5188,
"pivot":65.8997,
"pivotal":32.5733,
"pix":0.9414,
"pixel":63.0754,
"pixie":7.3431,
"pizza":88.3056,
"pizzeria":3.5774,
"place":12032.5311,
"placebo":67.2177,
"placed":0.1883,
"placeholder":0.1883,
"placement":199.3936,
"placenta":15.4394,
"placer":3.9540,
"places":5.4603,
"placid":34.2678,
"placing":70.6068,
"plagiarism":9.6025,
"plague":166.2555,
"plagued":0.3766,
"plaid":14.1214,
"plain":781.9469,
"plainly":125.5860,
"plains":0.3766,
"plaintiff":667.0932,
"plan":6179.5085,
"planar":11.2971,
"planck":0.7531,
"plane":820.9219,
"planes":0.3766,
"planet":405.7538,
"planetarium":2.4477,
"planetary":45.5649,
"plank":101.4855,
"plankton":20.1465,
"planned":53.0963,
"planner":209.5610,
"planning":1658.6012,
"plant":3063.5827,
"plantation":115.9835,
"planter":28.8076,
"planting":170.2095,
"plants":0.1883,
"plaque":103.9332,
"plasma":161.7367,
"plasmas":0.1883,
"plasmid":81.3391,
"plaster":213.5150,
"plastered":0.3766,
"plastering":5.8368,
"plastic":778.5578,
"plasticity":8.6611,
"plastics":0.1883,
"plat":3.0126,
"plate":1139.3116,
"plateau":74.1842,
"plated":4.3306,
"platelet":158.3476,
"platform":573.7039,
"plating":9.6025,
"platinum":48.2009,
"platoon":36.1507,
"platte":0.1883,
"platter":27.3013,
"platypus":5.0837,
"plausible":141.4019,
"play":8206.2065,
"playable":11.4854,
"playback":24.4770,
"playboy":10.7322,
"played":0.7531,
"player":2437.9121,
"playful":36.9038,
"playground":133.6822,
"playhouse":11.6737,
"playing":315.9420,
"playmate":11.1088,
"playoff":6.2134,
"playtime":6.9665,
"playwright":51.7783,
"plaza":4.5188,
"plea":257.1971,
"plead":313.6825,
"pleaded":0.5649,
"pleading":50.0838,
"pleas":0.3766,
"pleasant":471.2770,
"pleasantly":82.0922,
"pleasantness":4.1423,
"please":2465.7783,
"pleased":790.6081,
"pleasing":94.8956,
"pleasurable":47.4478,
"pleasure":1017.1147,
"pleasures":0.1883,
"pleated":20.5230,
"pledge":309.9168,
"pleistocene":0.5649,
"plenary":21.4645,
"plentiful":75.3139,
"plenty":865.7337,
"plenum":27.1130,
"plethora":36.5273,
"pleural":8.8494,
"plight":129.9165,
"plo":2.4477,
"plot":615.5031,
"plotter":36.3390,
"plotting":11.2971,
"plough":204.8539,
"ploughed":0.1883,
"ploughing":20.3348,
"plover":17.1339,
"plow":2.0711,
"ploy":62.6989,
"pluck":117.6780,
"plucked":0.1883,
"plug":296.5486,
"plugged":1.3180,
"plugging":1.5063,
"plum":69.2888,
"plumb":25.2302,
"plumber":50.2721,
"plumbing":57.2386,
"plume":59.8746,
"plump":112.9709,
"plumper":2.4477,
"plunder":57.9917,
"plunge":302.1972,
"plunging":0.9414,
"plural":71.9248,
"pluralism":65.8997,
"plurality":32.9498,
"plus":1417.9731,
"plush":30.3139,
"pluto":0.5649,
"plutonium":81.9039,
"ply":67.4060,
"plymouth":0.5649,
"plywood":29.9373,
"pm":515.5239,
"pms":0.5649,
"pneumatic":18.0753,
"pneumonia":81.3391,
"po":17.1339,
"pocket":919.7715,
"pod":62.3223,
"podiatry":0.5649,
"podium":20.5230,
"poem":691.3819,
"poems":1.6946,
"poet":490.6703,
"poetic":135.3768,
"poetry":460.9213,
"poi":0.7531,
"poignant":49.1423,
"point":11133.2827,
"pointed":86.9876,
"pointer":98.8495,
"pointing":47.0712,
"pointless":97.3433,
"pointy":8.8494,
"poised":8.0962,
"poison":297.1135,
"poisoned":0.1883,
"poisoning":98.8495,
"poisonous":82.2805,
"poke":138.0128,
"poker":42.9289,
"poking":1.8828,
"pol":7.5314,
"polar":111.2763,
"polarity":29.9373,
"polarization":35.2093,
"polarized":3.9540,
"polaroid":5.0837,
"pole":336.2767,
"poles":0.5649,
"police":4514.8822,
"policed":2.0711,
"policeman":546.7792,
"policing":131.4228,
"policy":6069.5502,
"polio":25.2302,
"polish":400.6701,
"polished":145.1676,
"polishing":19.7699,
"polite":199.9585,
"politely":128.2220,
"politeness":41.6110,
"politer":0.9414,
"politest":2.4477,
"politica":0.1883,
"political":5226.9755,
"politically":310.4817,
"politician":773.8507,
"politics":12.0502,
"polka":7.9080,
"poll":723.5786,
"pollack":3.3891,
"pollard":3.9540,
"pollen":55.9206,
"pollination":15.8159,
"polling":89.4353,
"pollock":2.6360,
"pollutant":75.1257,
"polluted":51.7783,
"polluting":8.6611,
"pollution":657.1141,
"polo":68.9123,
"polycarbonate":3.7657,
"polyester":51.5900,
"polyethylene":27.6779,
"polygon":32.1967,
"polymer":203.9125,
"polymerase":79.8328,
"polymeric":13.5565,
"polymerization":3.2008,
"polymorphic":6.4017,
"polymorphism":18.4519,
"polynesian":9.9791,
"polynomial":27.3013,
"polypeptide":32.7616,
"polyphonic":9.6025,
"polypropylene":17.1339,
"polystyrene":29.5607,
"polytechnic":165.3141,
"polyurethane":17.6988,
"pom":10.5440,
"pompano":0.1883,
"pompeii":0.5649,
"pompey":0.7531,
"ponce":5.8368,
"poncho":3.5774,
"pond":370.5446,
"ponder":115.6069,
"pondering":1.3180,
"pong":16.7574,
"pontiac":0.1883,
"pony":196.9459,
"poo":14.8745,
"poodle":19.0168,
"pool":951.2150,
"pooled":2.8243,
"pooling":14.8745,
"pools":1.6946,
"poolside":23.5356,
"poop":8.4728,
"poor":2783.0382,
"poorer":2.6360,
"poorest":0.3766,
"poorly":204.4773,
"pop":833.3487,
"popcorn":14.8745,
"pope":164.5610,
"poplar":15.4394,
"popper":7.7197,
"popping":5.2720,
"poppy":53.4729,
"populace":32.5733,
"popular":1777.7855,
"popularity":242.1343,
"popularly":44.6235,
"populate":62.1340,
"populated":29.7490,
"population":2550.1299,
"populist":53.4729,
"populous":20.1465,
"porcelain":61.0043,
"porch":97.9081,
"porcupine":10.1674,
"pore":118.4312,
"pork":98.4730,
"porn":50.8369,
"porno":9.6025,
"pornographic":33.7030,
"pornography":68.5357,
"porosity":37.8453,
"porous":29.3724,
"port":682.9091,
"portability":19.9582,
"portable":170.3978,
"portage":6.2134,
"portal":78.3265,
"portcullis":1.1297,
"porter":143.4730,
"portfolio":312.7411,
"porting":5.8368,
"portion":271.6950,
"portrait":420.4401,
"portray":217.0924,
"portrayal":51.2135,
"portsmouth":0.7531,
"portuguese":104.1215,
"pose":593.8504,
"poser":9.9791,
"posh":69.2888,
"posing":2.8243,
"position":4935.6988,
"positional":25.0419,
"positioned":5.0837,
"positioning":57.9917,
"positive":1514.7516,
"positively":238.7452,
"positron":4.1423,
"posse":18.2636,
"possess":745.2314,
"possessed":4.1423,
"possessing":0.5649,
"possession":707.9510,
"possibility":1687.4088,
"possible":6073.8807,
"possibly":1260.9436,
"possum":6.4017,
"post":2699.4398,
"postage":66.4645,
"postal":120.5023,
"postcard":154.9584,
"postcode":21.2762,
"postdoctoral":3.7657,
"poster":306.3394,
"posterior":37.0921,
"posterity":33.5147,
"postgraduate":124.8329,
"posting":45.5649,
"postman":52.7198,
"postmaster":10.3557,
"postmenopausal":3.7657,
"postmodern":28.6193,
"postnatal":11.2971,
"postoperative":19.0168,
"postpone":212.7619,
"postponed":1.6946,
"postponement":50.0838,
"postponing":0.1883,
"posts":0.1883,
"postscript":13.7448,
"posture":117.8663,
"postwar":74.9374,
"pot":593.6621,
"potable":6.0251,
"potassium":65.1466,
"potato":423.0760,
"potency":92.6361,
"potent":136.3182,
"potential":2036.4888,
"potentially":441.7162,
"potion":27.8662,
"potluck":0.1883,
"potpourri":5.2720,
"pots":0.5649,
"potted":10.7322,
"potter":64.7700,
"pottery":154.0170,
"potting":7.3431,
"potty":34.2678,
"pouch":84.7282,
"poultry":64.5817,
"pound":3343.5622,
"pounded":0.1883,
"pounding":14.3096,
"pour":674.2480,
"pouring":4.7071,
"poverty":549.0386,
"pow":14.1214,
"powder":272.4482,
"powdered":23.7239,
"powdery":11.4854,
"powell":2.0711,
"power":6920.5976,
"powered":14.6862,
"powerful":1302.9311,
"powerfully":79.8328,
"powerhouse":15.2511,
"powering":0.7531,
"powerless":83.2219,
"pox":17.3222,
"pr":169.0798,
"practicable":98.2847,
"practical":1358.6634,
"practicality":51.2135,
"practically":247.5946,
"practice":3714.4834,
"practices":0.3766,
"practise":659.1852,
"practised":0.5649,
"practising":3.5774,
"practitioner":527.9507,
"pragmatic":172.6572,
"prairie":23.5356,
"praise":498.9548,
"praised":0.9414,
"praising":0.5649,
"prank":18.8285,
"pray":463.1807,
"prayer":472.0301,
"praying":3.2008,
"pre":1522.0947,
"preach":184.8957,
"preacher":94.8956,
"preaching":43.6821,
"preamble":35.2093,
"preamp":28.8076,
"precarious":62.5106,
"precaution":154.9584,
"precautionary":24.4770,
"precede":409.8961,
"preceded":0.1883,
"precedence":65.8997,
"precedent":183.0129,
"preceding":0.3766,
"precepts":0.1883,
"precinct":42.1758,
"precious":316.8834,
"precipitate":110.7115,
"precipitated":0.3766,
"precipitation":35.3976,
"precise":516.2770,
"precisely":610.2312,
"precision":185.6489,
"preclude":114.2889,
"precondition":52.5315,
"precursor":73.0545,
"predation":26.7364,
"predator":250.9837,
"predators":0.3766,
"predatory":59.3097,
"predecessor":284.4984,
"predefined":4.5188,
"predetermined":8.2845,
"predicament":69.6654,
"predicate":72.6779,
"predict":714.5410,
"predictability":24.6653,
"predictable":167.5735,
"predictably":61.3809,
"predicted":0.9414,
"predicting":1.1297,
"prediction":276.7787,
"predictive":42.3641,
"predictor":30.1256,
"predisposition":27.4896,
"predominance":33.3264,
"predominant":73.8077,
"predominantly":223.3058,
"predominate":68.7240,
"predominately":4.5188,
"predominating":0.9414,
"preeminent":3.7657,
"preemption":0.3766,
"preemptive":1.8828,
"preexisting":0.1883,
"pref":2.0711,
"preface":95.8370,
"prefecture":5.6485,
"prefer":1213.1192,
"preferable":125.2094,
"preferably":139.3308,
"preference":568.2437,
"preferential":51.5900,
"preferentially":12.8034,
"preferred":182.6363,
"prefix":34.6444,
"pregnancy":318.2014,
"pregnant":385.4191,
"preheat":11.6737,
"prehistoric":66.0880,
"prejudice":323.0968,
"prejudiced":35.0210,
"prejudicial":23.5356,
"preliminary":320.8374,
"prelude":52.3432,
"premature":143.4730,
"prematurely":49.7072,
"premier":107.1341,
"premiere":46.5064,
"premiership":35.7741,
"premise":698.5368,
"premium":407.6367,
"premiums":0.3766,
"prenatal":15.4394,
"prentice":2.4477,
"preoccupation":148.5567,
"preoccupied":42.3641,
"preoperative":11.1088,
"prep":25.7950,
"prepaid":2.6360,
"preparation":759.1645,
"preparatory":66.2763,
"prepare":2023.4972,
"prepared":891.7170,
"preparedness":18.2636,
"prepares":0.9414,
"preparing":0.3766,
"prepay":1.8828,
"prepayment":7.3431,
"preponderance":26.9247,
"prerequisite":78.1382,
"prerequisites":0.1883,
"prerogative":75.8788,
"pres":0.1883,
"presbyterian":32.5733,
"preschool":10.3557,
"prescribe":253.2431,
"prescribed":71.1717,
"prescribing":14.3096,
"prescription":185.4606,
"prescriptive":31.8201,
"preseason":1.3180,
"presence":1397.8267,
"present":6631.7687,
"presentation":672.5535,
"presented":0.1883,
"presenter":107.1341,
"presenting":1.6946,
"presently":175.4815,
"preservation":179.2472,
"preservative":30.8787,
"preserve":779.8758,
"preserved":3.7657,
"preserving":2.8243,
"preset":21.6528,
"preside":139.7074,
"presidency":147.2387,
"president":1080.3784,
"presidential":343.2433,
"presiding":1.8828,
"presley":0.7531,
"press":2912.5782,
"pressed":12.6151,
"pressing":39.3515,
"pressure":2666.4899,
"pressured":5.0837,
"pressures":0.1883,
"pressuring":0.1883,
"pressurized":4.7071,
"prestige":167.9501,
"prestigious":133.8705,
"presto":2.8243,
"presumably":572.0093,
"presume":226.8832,
"presumed":0.9414,
"presuming":0.5649,
"presumption":95.0838,
"pretence":94.3307,
"pretend":486.9046,
"pretended":1.5063,
"pretending":4.8954,
"pretense":1.5063,
"pretentious":27.6779,
"pretext":38.9750,
"pretoria":0.1883,
"pretreatment":17.8871,
"pretrial":0.9414,
"prettily":15.2511,
"prettiness":9.2260,
"pretty":1407.0526,
"prevail":361.1303,
"prevailing":9.4142,
"prevalence":171.7158,
"prevalent":94.1424,
"prevent":1878.8944,
"preventable":15.8159,
"preventative":27.6779,
"preventing":0.9414,
"prevention":222.7410,
"preventive":74.1842,
"preview":84.9165,
"previews":0.9414,
"previous":2162.8280,
"previously":1217.4498,
"prey":311.9880,
"price":5270.2810,
"priced":0.3766,
"priceless":38.5984,
"prices":3.2008,
"pricey":13.5565,
"pricing":187.9083,
"prick":88.4939,
"pride":511.1933,
"priest":538.4946,
"priesthood":40.6695,
"primacy":69.1005,
"primal":42.9289,
"primarily":553.7457,
"primary":1290.6926,
"primate":65.1466,
"prime":632.0722,
"primed":0.7531,
"primer":63.6403,
"priming":13.1799,
"primitive":329.3102,
"primordial":24.2887,
"primrose":19.2051,
"prince":292.4064,
"princes":0.3766,
"princess":129.7283,
"principal":818.4742,
"principally":172.8455,
"principe":0.1883,
"principle":2391.2175,
"principled":23.5356,
"principles":2.2594,
"print":1369.2074,
"printable":7.5314,
"printed":12.9917,
"printer":395.2099,
"printing":256.6322,
"printmaking":4.8954,
"printout":25.2302,
"prior":800.0223,
"prioritisation":3.0126,
"prioritise":16.7574,
"prioritising":0.1883,
"prioritization":1.6946,
"prioritize":13.9331,
"prioritizing":0.5649,
"priority":954.4159,
"priory":47.2595,
"prism":17.8871,
"prison":1182.2405,
"prisoner":796.2566,
"pristine":35.0210,
"privacy":184.3309,
"private":3109.5242,
"privately":234.7912,
"privatisation":244.5820,
"privatization":152.1342,
"privatized":9.0377,
"privilege":437.1974,
"privileged":184.7074,
"privy":37.8453,
"prize":736.7586,
"prized":5.8368,
"prizes":0.7531,
"pro":527.3858,
"proactive":26.3599,
"proactively":1.5063,
"prob":7.7197,
"probabilistic":18.8285,
"probability":332.6993,
"probable":215.0213,
"probably":4747.6023,
"probate":25.2302,
"probation":109.2052,
"probationary":13.5565,
"probe":399.1639,
"probed":1.6946,
"probes":0.3766,
"probing":10.1674,
"problem":10108.8249,
"problematic":137.0714,
"problems":9.4142,
"procedural":129.5400,
"procedure":1909.9614,
"procedures":5.4603,
"proceed":911.6752,
"proceeding":720.1895,
"process":5172.9377,
"processed":0.3766,
"processing":600.2521,
"procession":136.1299,
"processor":439.2685,
"processors":0.9414,
"proclaim":239.8749,
"proclaiming":0.1883,
"proclaims":0.1883,
"proclamation":42.7407,
"proctor":16.1925,
"procure":75.8788,
"procurement":49.3306,
"procuring":2.0711,
"prod":65.3348,
"prodigy":17.8871,
"produce":5601.2858,
"produced":1.1297,
"producer":650.9007,
"producers":0.1883,
"produces":0.1883,
"producing":3.0126,
"product":3860.9690,
"production":2887.1598,
"productive":290.7118,
"productivity":340.0424,
"products":0.3766,
"prof":3.9540,
"profane":16.5691,
"profanity":4.1423,
"profess":68.5357,
"profession":693.0765,
"professional":2297.0751,
"professionalism":89.8119,
"professionally":96.4018,
"professor":239.4983,
"proficiency":28.2427,
"proficient":22.7825,
"profile":517.9716,
"profiling":9.9791,
"profit":2232.1168,
"profitability":155.8998,
"profitable":248.5360,
"profitably":34.8327,
"profits":2.8243,
"profound":258.8917,
"profoundly":109.5818,
"progenitor":12.4268,
"progeny":22.9708,
"progesterone":6.7783,
"prognosis":47.2595,
"prognostic":15.8159,
"program":1086.0270,
"programing":0.5649,
"programmable":15.4394,
"programmatic":6.5900,
"programme":4209.4842,
"programmed":24.8536,
"programmer":95.6487,
"programmes":4.1423,
"programming":222.1761,
"programs":0.3766,
"progress":1629.6053,
"progressing":1.6946,
"progression":136.6948,
"progressive":281.6741,
"progressively":134.4354,
"prohibit":214.2681,
"prohibited":0.1883,
"prohibiting":0.1883,
"prohibition":135.7534,
"prohibitive":25.4185,
"project":3642.9351,
"projected":4.3306,
"projectile":10.7322,
"projecting":1.1297,
"projection":191.2974,
"projective":5.4603,
"projector":41.7992,
"proletariat":69.8537,
"proliferation":146.4856,
"prolific":67.5943,
"prologue":18.6402,
"prolong":111.0881,
"prolonged":160.2304,
"prom":11.8619,
"promenade":49.5189,
"prometheus":0.1883,
"prominence":108.8286,
"prominent":407.8250,
"prominently":58.1800,
"promiscuous":21.2762,
"promise":1857.4300,
"promised":0.7531,
"promising":139.7074,
"promissory":10.3557,
"promo":9.2260,
"promos":1.3180,
"promote":1194.4790,
"promoted":0.5649,
"promoter":228.9544,
"promoting":1.5063,
"promotion":624.1643,
"promotional":91.1299,
"prompt":523.9967,
"prompting":12.9917,
"promptly":170.7744,
"promulgate":36.1507,
"prone":163.0547,
"prong":17.5105,
"pronoun":86.7993,
"pronounce":254.7494,
"pronounced":41.2344,
"pronto":0.3766,
"pronunciation":86.0462,
"proof":588.9550,
"proofing":16.3808,
"proofreading":2.2594,
"proofs":0.1883,
"prop":250.4188,
"propaganda":194.1217,
"propagate":70.0420,
"propagated":0.9414,
"propagating":0.1883,
"propagation":45.7532,
"propane":10.3557,
"propel":85.4813,
"propelled":0.5649,
"propeller":43.8704,
"propensity":61.0043,
"proper":1136.1107,
"properly":997.7214,
"property":2869.4610,
"prophecy":68.5357,
"prophet":89.6236,
"prophetic":32.0084,
"prophylactic":13.3682,
"prophylaxis":9.7908,
"proponent":55.3557,
"proportion":1442.2619,
"proportional":163.8078,
"proportionally":15.4394,
"proportionate":35.2093,
"proportionately":36.9038,
"proposal":1967.0117,
"proposals":0.1883,
"propose":2001.0913,
"proposed":4.5188,
"proposes":0.1883,
"proposing":0.5649,
"proposition":364.3312,
"propositional":9.6025,
"proprietary":99.0378,
"proprietor":138.2011,
"proprietors":0.1883,
"propriety":37.4687,
"propulsion":16.3808,
"pros":0.1883,
"prose":150.2513,
"prosecute":164.7492,
"prosecuted":0.1883,
"prosecuting":43.6821,
"prosecution":385.4191,
"prosecutor":74.9374,
"prospect":969.2904,
"prospecting":13.7448,
"prospective":238.7452,
"prospector":8.8494,
"prospectus":60.4394,
"prosper":81.1508,
"prosperity":200.1468,
"prosperous":124.0797,
"prostate":25.9833,
"prosthesis":4.1423,
"prosthetic":6.0251,
"prostitute":130.6697,
"prostitution":75.6905,
"protagonist":61.3809,
"protease":6.4017,
"protect":1657.4715,
"protected":3.7657,
"protecting":1.8828,
"protection":1213.1192,
"protective":230.6489,
"protector":58.9332,
"protectors":0.1883,
"protein":770.4616,
"proteins":0.3766,
"protest":1152.4915,
"protestant":250.2306,
"protested":0.1883,
"protesting":1.5063,
"protests":0.3766,
"protocol":181.8832,
"protocols":0.3766,
"proton":74.9374,
"prototype":147.0505,
"prototyping":1.5063,
"protracted":12.8034,
"protruding":4.7071,
"proud":570.3148,
"prouder":0.1883,
"proudest":0.5649,
"proudly":112.9709,
"prove":2695.6741,
"proved":5.8368,
"proven":17.6988,
"provenance":39.7281,
"provence":2.8243,
"proverb":27.1130,
"proverbial":28.8076,
"proves":0.3766,
"provide":9771.2302,
"provided":3.2008,
"providence":16.9456,
"provident":3.5774,
"provider":219.5401,
"providers":0.1883,
"providing":3.5774,
"province":502.5322,
"provincial":259.6448,
"proving":6.7783,
"provision":2234.7528,
"provisional":130.2931,
"provisioning":5.6485,
"provo":0.1883,
"provocation":67.7825,
"provocative":64.7700,
"provoke":373.7454,
"provoking":9.6025,
"provost":13.7448,
"prowess":50.6486,
"proximal":84.7282,
"proximate":7.9080,
"proximity":119.1843,
"proxy":70.4185,
"prudence":28.9959,
"prudent":86.4227,
"prudential":11.8619,
"prune":62.1340,
"pruning":45.7532,
"prussian":62.6989,
"ps":0.5649,
"psalm":37.6570,
"pseudo":79.0796,
"pseudonym":19.2051,
"psi":16.9456,
"psoriasis":6.2134,
"pst":0.7531,
"psych":3.2008,
"psyche":49.8955,
"psychedelic":28.0544,
"psychiatric":191.6740,
"psychiatrist":120.5023,
"psychiatry":31.8201,
"psychic":88.4939,
"psycho":42.3641,
"psychoanalysis":75.1257,
"psychological":494.8126,
"psychologically":53.0963,
"psychologist":251.3603,
"psychology":384.1011,
"psychosis":38.2218,
"psychosocial":14.1214,
"psychotherapy":22.0293,
"psychotic":42.3641,
"pt":14.3096,
"pto":2.0711,
"pu":52.9080,
"pub":881.7379,
"puberty":30.5021,
"pubic":20.8996,
"public":6591.6640,
"publication":932.7631,
"publicity":436.0677,
"publicize":51.0252,
"publicized":0.5649,
"publicly":291.8415,
"publish":2267.3261,
"published":4.1423,
"publisher":431.5489,
"publishes":0.1883,
"publishing":323.6616,
"pubs":1.1297,
"puccini":0.1883,
"puck":2.6360,
"pud":4.5188,
"pudding":183.5777,
"puddle":52.9080,
"pueblo":4.7071,
"puff":137.4479,
"puffin":15.8159,
"puffs":0.1883,
"puffy":16.9456,
"pug":8.0962,
"puke":11.1088,
"pula":0.7531,
"pull":2558.4144,
"pulley":25.7950,
"pulling":11.1088,
"pullman":0.5649,
"pullout":1.6946,
"pullover":30.3139,
"pulmonary":41.7992,
"pulp":53.0963,
"pulpit":52.5315,
"pulsar":13.7448,
"pulse":304.4566,
"pulsed":7.5314,
"puma":1.6946,
"pump":465.2518,
"pumped":0.1883,
"pumping":24.2887,
"pumpkin":18.2636,
"pun":40.4812,
"punch":362.0718,
"punched":1.5063,
"punching":12.4268,
"punctual":11.8619,
"punctuality":13.9331,
"punctually":5.0837,
"punctuation":52.9080,
"puncture":58.1800,
"pundit":37.4687,
"punish":262.8456,
"punishable":21.0879,
"punishing":0.5649,
"punishment":445.1054,
"punitive":54.2260,
"punjab":1.1297,
"punjabi":1.6946,
"punk":106.5692,
"punks":0.3766,
"punt":36.5273,
"puny":18.8285,
"pup":42.3641,
"pupil":1920.8820,
"puppet":99.2261,
"puppy":123.3266,
"purcell":1.1297,
"purchase":1361.1111,
"purchased":0.3766,
"purchaser":408.7664,
"purchasing":109.7701,
"pure":618.8923,
"purely":456.4025,
"purer":10.9205,
"purest":1.1297,
"purgatory":15.2511,
"purge":90.1884,
"purification":35.2093,
"purified":7.9080,
"purifier":2.0711,
"purify":81.3391,
"purifying":0.9414,
"puritan":26.9247,
"purity":131.2345,
"purple":231.9669,
"purplish":10.1674,
"purport":111.2763,
"purpose":2765.1512,
"purposeful":48.0126,
"purposefully":25.7950,
"purposely":20.3348,
"purse":181.5066,
"pursuance":24.1005,
"pursuant":70.6068,
"pursue":823.1813,
"pursuing":0.5649,
"pursuit":340.0424,
"purview":8.8494,
"pus":16.5691,
"push":1992.8068,
"pushed":0.1883,
"pushing":5.4603,
"pussy":32.1967,
"pussycat":3.7657,
"put":12363.1593,
"putative":44.2469,
"puts":0.3766,
"putt":84.3516,
"putter":35.7741,
"putting":21.8410,
"putty":20.3348,
"puzzle":288.6407,
"puzzled":96.2136,
"puzzles":0.1883,
"puzzling":29.1842,
"pvc":21.6528,
"px":1.8828,
"pylori":180.3769,
"pyramid":79.6445,
"pyramids":0.1883,
"pyrex":0.7531,
"python":12.2385,
"q":157.7827,
"qatar":0.1883,
"qi":0.7531,
"qr":0.1883,
"qua":13.7448,
"quad":11.6737,
"quadrangle":8.0962,
"quadrant":18.8285,
"quadratic":14.1214,
"quadruple":33.3264,
"quail":31.0670,
"quaint":43.6821,
"quake":22.7825,
"quaker":12.9917,
"qualification":620.0220,
"qualified":433.6200,
"qualifier":57.9917,
"qualify":391.0676,
"qualifying":129.5400,
"qualitative":105.2512,
"qualitatively":29.9373,
"quality":3327.7463,
"quantifiable":17.6988,
"quantification":34.4561,
"quantify":98.2847,
"quantifying":0.3766,
"quantitative":164.1844,
"quantitatively":17.3222,
"quantity":748.0557,
"quantization":0.7531,
"quantum":134.8119,
"quarantine":30.1256,
"quark":26.3599,
"quarrel":173.7869,
"quarrelling":2.6360,
"quarry":210.1259,
"quart":13.3682,
"quarter":1896.9698,
"quarterback":9.9791,
"quarterly":94.1424,
"quartet":63.8286,
"quartile":4.8954,
"quartz":45.1884,
"quasar":16.1925,
"quasi":110.7115,
"quaternary":5.4603,
"quay":57.4269,
"que":1.3180,
"quebec":0.1883,
"queen":266.7996,
"queer":61.1926,
"quench":19.7699,
"query":305.5863,
"querying":0.5649,
"quest":146.6739,
"question":7514.8246,
"questionable":82.8453,
"questioning":121.2554,
"questionnaire":298.4315,
"questionnaires":0.1883,
"queue":312.1763,
"queuing":1.5063,
"quibble":20.3348,
"quick":1274.8767,
"quicken":66.4645,
"quicker":3.2008,
"quickest":0.1883,
"quickie":8.2845,
"quickly":2148.7066,
"quickness":6.2134,
"quicksilver":4.7071,
"quid":274.1427,
"quiet":1147.7844,
"quieter":12.6151,
"quietly":707.7627,
"quietness":22.7825,
"quill":20.8996,
"quilt":52.9080,
"quilted":12.0502,
"quilting":4.3306,
"quintessential":11.6737,
"quintet":11.4854,
"quirky":21.8410,
"quit":207.3016,
"quite":7200.3889,
"quits":0.1883,
"quitting":1.1297,
"quiz":115.9835,
"quorum":15.0628,
"quota":256.2557,
"quotation":199.5819,
"quote":936.5288,
"quotes":0.1883,
"quotient":14.1214,
"quoting":1.3180,
"r":658.9969,
"ra":2.4477,
"rabbi":24.1005,
"rabbit":420.4401,
"rabble":19.5816,
"rabid":12.6151,
"rabies":4.7071,
"raccoon":1.8828,
"race":2004.4804,
"racecourse":40.1047,
"raced":0.1883,
"racer":38.0335,
"raceway":0.7531,
"rachel":2.8243,
"racial":257.3854,
"racially":19.3933,
"racing":326.8625,
"racism":203.1593,
"racist":164.1844,
"rack":231.4021,
"racket":88.8704,
"racking":14.8745,
"rad":4.5188,
"radar":121.4437,
"radial":73.4311,
"radiance":21.2762,
"radiant":39.9164,
"radiated":1.5063,
"radiating":0.3766,
"radiation":318.7662,
"radiative":5.8368,
"radiator":112.2178,
"radical":775.3570,
"radically":140.0839,
"radio":1288.9980,
"radioactive":144.2262,
"radioactivity":44.8118,
"radioed":4.7071,
"radiography":10.5440,
"radiological":21.4645,
"radiology":6.7783,
"radionuclide":16.3808,
"radiotherapy":37.2804,
"radius":119.1843,
"radon":26.9247,
"raf":2.2594,
"raffle":67.9708,
"raft":74.1842,
"rafting":9.7908,
"rag":173.5986,
"rage":352.4692,
"ragga":9.0377,
"ragged":83.4102,
"raging":1.3180,
"raglan":1.5063,
"ragtime":3.9540,
"raid":500.0845,
"raided":0.1883,
"raider":77.7616,
"rail":616.4446,
"railing":59.8746,
"railroad":22.5942,
"rails":0.1883,
"railway":1093.1818,
"rain":1287.3035,
"rainbow":57.4269,
"raindrop":17.3222,
"rainfall":72.3014,
"raining":4.3306,
"rainwater":28.8076,
"rainy":43.3055,
"raise":3713.5419,
"raised":1.6946,
"raiser":30.3139,
"raisin":30.8787,
"raising":105.4395,
"raj":2.0711,
"rake":116.3600,
"raked":2.8243,
"rakes":0.3766,
"raking":3.2008,
"rally":364.3312,
"rallying":13.9331,
"ram":196.1928,
"rama":0.1883,
"rambler":26.3599,
"rambling":21.6528,
"rammed":0.3766,
"ramp":109.9583,
"rampage":33.8913,
"rampant":44.4352,
"ramps":0.1883,
"ran":7.1548,
"ranch":30.6904,
"rancid":12.2385,
"rand":6.9665,
"random":394.8333,
"randomised":26.5482,
"randomized":3.5774,
"randomly":65.8997,
"randomness":11.2971,
"randy":3.7657,
"rang":3.0126,
"range":4253.3546,
"ranger":75.1257,
"ranges":0.5649,
"ranging":4.5188,
"rank":853.4952,
"ranked":1.1297,
"ranking":81.5273,
"ranks":0.3766,
"ransom":61.9457,
"rant":34.4561,
"ranting":4.5188,
"rap":118.6195,
"rape":535.1055,
"raped":0.7531,
"raphael":0.1883,
"rapid":642.2396,
"rapidity":22.5942,
"rapidly":813.5788,
"raping":1.3180,
"rapist":55.9206,
"rapper":22.5942,
"rapport":52.3432,
"rapporteur":2.8243,
"raptor":9.2260,
"rapture":23.1590,
"rare":878.1605,
"rarely":744.8548,
"rareness":0.9414,
"rarer":2.8243,
"rarest":0.1883,
"rarity":61.5691,
"rascal":11.2971,
"rash":90.5650,
"raspberry":45.3766,
"raster":9.2260,
"rat":428.1597,
"ratchet":17.6988,
"rate":5787.1229,
"rated":0.1883,
"rates":0.1883,
"rather":7563.5904,
"ratification":77.1968,
"ratify":112.7826,
"rating":322.3436,
"ratio":639.7919,
"ration":128.4103,
"rational":428.7246,
"rationale":102.8035,
"rationalisation":54.2260,
"rationalise":37.8453,
"rationalised":0.5649,
"rationalising":0.3766,
"rationalism":24.1005,
"rationality":111.6529,
"rationalization":31.8201,
"rationalize":35.0210,
"rationalized":0.3766,
"rationally":42.1758,
"rats":0.9414,
"rattan":6.2134,
"rattle":184.3309,
"rattling":8.2845,
"raunchy":10.3557,
"rave":112.9709,
"ravel":2.0711,
"raven":28.0544,
"raving":5.0837,
"raw":435.5028,
"rawer":0.1883,
"rawness":3.9540,
"ray":358.3061,
"rayon":10.5440,
"razor":87.7407,
"rb":4.1423,
"rbi":0.1883,
"reach":4378.1874,
"reachable":3.3891,
"reaching":3.2008,
"react":489.9172,
"reacted":0.9414,
"reacting":0.5649,
"reaction":1340.0232,
"reactionary":57.2386,
"reactions":0.1883,
"reactivate":15.6276,
"reactivation":4.5188,
"reactive":84.1633,
"reactivity":19.2051,
"reactor":231.7786,
"read":4242.4341,
"readability":24.4770,
"readable":78.7031,
"reader":1563.8939,
"readership":62.3223,
"readily":501.9674,
"readiness":104.6864,
"reading":999.4159,
"readjust":12.4268,
"readjustment":16.3808,
"readout":5.0837,
"ready":1892.4509,
"reaffirm":77.0085,
"reagan":0.3766,
"reagent":28.8076,
"real":4184.6306,
"realignment":37.0921,
"realisation":130.2931,
"realise":1740.6934,
"realism":149.3099,
"realist":72.1131,
"realistic":336.4650,
"realistically":64.3934,
"reality":1313.4751,
"realization":123.3266,
"realize":1001.1105,
"realized":1.1297,
"realizing":0.5649,
"reallocation":10.3557,
"really":8138.4240,
"realm":220.1050,
"realtor":0.5649,
"realty":2.0711,
"reap":88.3056,
"reaper":6.9665,
"rear":655.9844,
"rearing":21.8410,
"rearrange":71.7365,
"rearranged":0.9414,
"rearrangement":34.4561,
"reason":5274.6116,
"reasonable":1095.4412,
"reasonableness":70.2302,
"reasonably":538.6829,
"reasoned":21.4645,
"reasoning":189.4146,
"reassess":39.7281,
"reassessment":28.0544,
"reassign":5.0837,
"reassigning":0.1883,
"reassurance":108.6404,
"reassure":244.9586,
"reassured":0.7531,
"reassuring":73.2428,
"rebate":73.2428,
"rebekah":0.3766,
"rebel":427.2183,
"rebellion":174.3518,
"rebellious":40.6695,
"rebirth":29.3724,
"reboot":6.2134,
"rebooting":0.1883,
"reborn":20.3348,
"rebound":44.8118,
"rebounding":0.5649,
"rebuild":257.5737,
"rebuilding":55.9206,
"rebuilt":4.1423,
"rebuke":62.3223,
"rebuttal":12.0502,
"rec":7.5314,
"recall":1103.3492,
"recalling":0.7531,
"recap":13.7448,
"recapture":69.1005,
"receipt":358.4943,
"receipts":0.3766,
"receivable":10.9205,
"receivables":2.0711,
"receive":4429.7775,
"received":1.3180,
"receiver":317.8248,
"receives":0.1883,
"receiving":40.4812,
"recent":2822.5781,
"recently":2230.2340,
"receptacle":12.2385,
"reception":437.5740,
"receptionist":85.2930,
"receptive":63.2637,
"receptor":193.1802,
"recess":74.5608,
"recessed":10.7322,
"recession":725.0849,
"recessive":15.4394,
"recharge":35.5858,
"rechargeable":9.4142,
"recherche":0.1883,
"recipe":283.7453,
"recipes":0.3766,
"recipient":200.5234,
"reciprocal":96.7784,
"reciprocity":28.2427,
"recital":52.7198,
"recitation":11.6737,
"recite":81.9039,
"reciting":0.1883,
"reckless":100.1675,
"recklessly":30.8787,
"reckon":709.8339,
"reckoning":38.9750,
"reclaim":92.8244,
"reclaimed":8.0962,
"reclamation":30.3139,
"reclassification":4.5188,
"recliner":0.9414,
"reclining":1.5063,
"recognise":1818.0784,
"recognised":6.4017,
"recognising":0.5649,
"recognition":1014.4787,
"recognizable":47.4478,
"recognize":1081.3198,
"recognized":1.5063,
"recognizing":0.9414,
"recoil":49.3306,
"recollection":101.6738,
"recombinant":41.7992,
"recombination":14.6862,
"recommenced":0.1883,
"recommend":1140.2530,
"recommendation":697.2188,
"recommended":3.9540,
"recommending":0.1883,
"recon":0.9414,
"reconcile":183.3894,
"reconciled":0.1883,
"reconciliation":119.1843,
"reconciling":0.9414,
"reconditioned":0.1883,
"reconfiguration":2.2594,
"reconfigure":2.6360,
"reconnaissance":49.3306,
"reconnect":3.5774,
"reconsider":97.7198,
"reconsideration":16.9456,
"reconsidering":0.1883,
"reconstituted":0.1883,
"reconstruct":117.3015,
"reconstructed":0.3766,
"reconstruction":185.6489,
"reconstructive":0.9414,
"record":5235.0717,
"recordable":3.7657,
"recorded":29.5607,
"recorder":228.7661,
"recording":655.6078,
"recordings":0.1883,
"records":0.3766,
"recount":86.0462,
"recoup":42.5524,
"recourse":90.5650,
"recover":905.0852,
"recoverable":43.1172,
"recovered":0.5649,
"recovering":0.3766,
"recovery":676.1309,
"recreate":81.1508,
"recreation":143.6613,
"recreational":90.9416,
"recruit":515.5239,
"recruiter":9.4142,
"recruiting":32.0084,
"recruitment":270.3770,
"rectal":77.3851,
"rectangle":69.1005,
"rectangular":99.2261,
"rectified":1.1297,
"rectify":81.1508,
"rector":61.5691,
"rectum":31.2553,
"recur":121.0672,
"recurrence":103.9332,
"recurrent":127.0923,
"recurring":9.6025,
"recursion":3.3891,
"recursive":7.5314,
"recyclable":17.1339,
"recycle":128.2220,
"recycled":30.8787,
"recycling":122.0086,
"red":2409.4811,
"redden":24.1005,
"redder":6.2134,
"reddish":39.3515,
"redeem":92.8244,
"redeemable":15.0628,
"redeemed":0.7531,
"redeemer":2.8243,
"redeeming":2.2594,
"redefine":54.0377,
"redefined":0.5649,
"redefining":0.1883,
"redefinition":13.9331,
"redemption":104.6864,
"redesign":54.0377,
"redevelopment":68.5357,
"redhead":14.4979,
"redirect":32.1967,
"redirection":8.4728,
"redistribute":35.3976,
"redistribution":73.6194,
"redistricting":0.7531,
"redneck":3.0126,
"redness":18.4519,
"redo":7.3431,
"redraft":5.2720,
"redrafting":4.8954,
"redress":95.2721,
"redshift":8.8494,
"reduce":3426.9724,
"reduced":45.1884,
"reduces":0.7531,
"reducing":1.3180,
"reduction":1094.6881,
"redundancy":322.3436,
"redundant":214.4564,
"redwood":6.2134,
"reed":86.9876,
"reef":107.5106,
"reel":137.4479,
"reelection":2.4477,
"reeling":1.1297,
"reeve":7.1548,
"ref":106.5692,
"refer":2415.1297,
"referee":272.2599,
"refereed":1.6946,
"reference":1850.2751,
"referenced":1.3180,
"references":1.8828,
"referencing":14.1214,
"referendum":272.0716,
"referential":35.3976,
"referral":224.6238,
"referred":0.1883,
"referring":2.4477,
"refill":50.4603,
"refinance":9.4142,
"refinancing":6.4017,
"refine":109.7701,
"refined":76.6319,
"refinement":93.2010,
"refinery":46.3181,
"refining":30.8787,
"reflect":2033.4763,
"reflectance":36.3390,
"reflected":10.5440,
"reflecting":0.7531,
"reflection":439.6451,
"reflective":60.6277,
"reflectivity":2.6360,
"reflector":26.7364,
"reflex":92.4479,
"reflexive":16.5691,
"reflexology":6.2134,
"reflux":83.0336,
"refocus":8.2845,
"refocusing":2.4477,
"refocussing":0.3766,
"reform":1581.4044,
"reformat":4.1423,
"reformation":39.1632,
"reformed":11.8619,
"reforming":1.3180,
"reformulate":18.2636,
"reformulation":20.3348,
"refraction":8.6611,
"refractive":10.9205,
"refractory":11.1088,
"refrain":103.9332,
"refresh":50.4603,
"refreshed":12.6151,
"refresher":13.3682,
"refreshes":0.5649,
"refreshing":77.3851,
"refreshment":104.6864,
"refrigerant":4.7071,
"refrigerated":8.4728,
"refrigeration":23.3473,
"refrigerator":69.8537,
"refs":0.1883,
"refuge":164.5610,
"refugee":456.0259,
"refugees":0.3766,
"refund":89.4353,
"refundable":7.9080,
"refurbishment":71.3600,
"refusal":338.7244,
"refuse":1929.1665,
"refuses":0.1883,
"refusing":0.9414,
"refute":60.8160,
"regain":223.8707,
"regained":0.3766,
"regal":24.2887,
"regard":2990.3399,
"regarded":8.2845,
"regarding":0.9414,
"regardless":277.9084,
"regatta":20.1465,
"regency":7.5314,
"regenerate":42.5524,
"regenerated":0.1883,
"regeneration":109.9583,
"regent":22.5942,
"reggae":32.0084,
"regime":710.0221,
"regimen":32.9498,
"regiment":171.5275,
"regimes":0.1883,
"regina":0.5649,
"region":2277.3052,
"regional":1096.0061,
"regionally":18.0753,
"register":1149.6672,
"registered":60.2511,
"registering":3.2008,
"registrant":3.2008,
"registrar":66.6528,
"registration":376.0048,
"registry":42.1758,
"regress":36.3390,
"regression":127.6571,
"regret":452.2602,
"regretful":9.9791,
"regretted":0.5649,
"regular":1404.7932,
"regularity":75.3139,
"regularly":692.3234,
"regulate":346.2558,
"regulated":34.6444,
"regulating":8.8494,
"regulation":1036.5081,
"regulator":102.9918,
"regulatory":218.2221,
"rehab":0.7531,
"rehabilitate":30.8787,
"rehabilitated":0.5649,
"rehabilitation":134.0588,
"rehearsal":176.4229,
"reign":392.3856,
"reigning":2.6360,
"reimbursable":1.5063,
"reimburse":36.3390,
"reimbursement":28.2427,
"rein":139.7074,
"reincarnation":22.5942,
"reindeer":28.2427,
"reinforce":524.3733,
"reinforced":3.7657,
"reinforcement":106.9458,
"reinforcing":1.1297,
"reinstall":2.8243,
"reinstate":70.2302,
"reinstatement":32.7616,
"reinsurance":14.3096,
"reintegration":9.9791,
"reinterpret":21.4645,
"reinterpretation":13.3682,
"reinvent":12.2385,
"reinventing":0.1883,
"reinvest":6.9665,
"reinvestment":6.9665,
"reissue":43.4938,
"reit":0.3766,
"reiterate":117.6780,
"reject":1174.8974,
"rejecting":0.3766,
"rejection":266.7996,
"rejects":0.1883,
"rejoice":74.3725,
"rejoicing":11.4854,
"rejuvenation":7.7197,
"relapse":72.4897,
"relate":2728.4356,
"related":398.0342,
"relating":2.6360,
"relation":3101.4279,
"relational":107.1341,
"relationship":3381.4075,
"relative":1509.1030,
"relatively":1404.9815,
"relativistic":9.6025,
"relativity":54.7909,
"relax":531.9047,
"relaxation":228.9544,
"relaxed":306.5277,
"relaxing":38.2218,
"relay":113.5358,
"relaying":1.6946,
"release":2337.9329,
"released":0.5649,
"releasing":8.2845,
"relegated":0.5649,
"relentless":66.4645,
"relentlessly":48.9541,
"relevance":302.0089,
"relevancy":6.4017,
"relevant":1403.6635,
"reliability":142.3433,
"reliable":398.9756,
"reliably":49.8955,
"reliance":169.8329,
"reliant":36.7155,
"relic":103.5567,
"relief":1154.3744,
"relieve":417.2392,
"relieved":67.5943,
"reliever":0.9414,
"relieving":0.5649,
"religion":867.6166,
"religious":1145.5250,
"religiously":16.7574,
"relinquish":87.9290,
"relish":135.3768,
"relive":39.9164,
"reload":11.6737,
"reloading":0.9414,
"relocate":72.8662,
"relocating":0.3766,
"relocation":81.3391,
"reluctance":192.4271,
"reluctant":356.6115,
"reluctantly":167.1969,
"rely":962.7004,
"rem":43.4938,
"remain":5671.1394,
"remainder":303.5152,
"remained":17.5105,
"remaining":14.6862,
"remains":11.2971,
"remake":25.2302,
"remand":126.9040,
"remark":953.0979,
"remarkable":621.7165,
"remarkably":266.9879,
"remarking":0.7531,
"remarks":1.6946,
"remastered":0.1883,
"rembrandt":4.3306,
"remedial":60.4394,
"remediation":3.7657,
"remedied":1.1297,
"remedy":492.7414,
"remedying":1.3180,
"remember":4579.6522,
"remembered":6.9665,
"remembering":12.8034,
"remembrance":32.7616,
"remind":949.7087,
"reminded":0.1883,
"reminder":224.2472,
"reminding":6.2134,
"reminiscent":108.4521,
"remission":65.8997,
"remit":98.8495,
"remittance":25.7950,
"remix":12.9917,
"remixes":0.5649,
"remnant":95.8370,
"remodel":3.9540,
"remorse":41.7992,
"remortgage":9.0377,
"remote":521.9256,
"remotely":77.0085,
"removable":25.7950,
"removal":384.1011,
"remove":2051.1751,
"removed":0.5649,
"remover":16.3808,
"removing":1.8828,
"remuneration":80.3976,
"renaissance":41.2344,
"renal":83.0336,
"rename":90.9416,
"renaming":3.5774,
"render":381.6534,
"rendering":37.8453,
"rendezvous":44.6235,
"rendition":19.3933,
"renegade":17.6988,
"renew":401.9881,
"renewable":77.3851,
"renewal":172.6572,
"renewed":0.3766,
"renewing":3.3891,
"renews":0.1883,
"renminbi":0.7531,
"renoir":0.1883,
"renounce":66.2763,
"renovate":57.4269,
"renovating":0.1883,
"renovation":51.7783,
"renown":12.4268,
"renowned":74.9374,
"rent":938.2234,
"rental":92.4479,
"rentals":0.7531,
"rented":0.9414,
"renter":3.2008,
"renting":11.4854,
"reoccur":0.9414,
"reoccurring":0.1883,
"reopen":90.0002,
"reopening":19.7699,
"reorder":11.2971,
"reorganization":76.8202,
"reorganized":0.1883,
"reorient":1.8828,
"reorientation":9.9791,
"rep":50.8369,
"repaid":0.1883,
"repaint":20.1465,
"repair":779.4992,
"repaired":0.1883,
"repairing":4.8954,
"repatriation":62.1340,
"repay":201.6531,
"repayment":196.0045,
"repeal":96.0253,
"repealing":0.3766,
"repeat":1440.0025,
"repeatable":8.0962,
"repeated":0.5649,
"repeatedly":231.9669,
"repeater":9.4142,
"repeating":1.3180,
"repeats":0.5649,
"repel":57.4269,
"repellent":25.2302,
"repent":24.6653,
"repentance":23.7239,
"repertoire":102.6152,
"repertory":32.9498,
"repetition":173.7869,
"repetitive":81.3391,
"replace":1942.5347,
"replaceable":6.9665,
"replaced":0.1883,
"replacement":514.3942,
"replacing":6.5900,
"replay":113.1592,
"replaying":0.1883,
"replenish":32.1967,
"replenishment":9.0377,
"replete":15.6276,
"replica":73.9959,
"replicas":0.1883,
"replicate":73.2428,
"replicated":0.1883,
"replicating":0.5649,
"replication":52.7198,
"replicator":21.0879,
"reply":1829.7521,
"replying":1.3180,
"report":7740.2016,
"reportable":1.6946,
"reported":9.0377,
"reportedly":256.4440,
"reporter":314.4357,
"reporting":213.3267,
"reports":0.3766,
"repose":32.0084,
"repository":59.3097,
"represent":2790.1931,
"representation":882.3028,
"representational":23.1590,
"representative":1268.8515,
"represented":0.5649,
"representing":0.1883,
"represents":0.1883,
"repressed":26.3599,
"repression":127.6571,
"repressive":50.0838,
"reprint":58.7449,
"reprinting":1.6946,
"reprise":6.2134,
"reproach":58.3683,
"reprocessing":10.9205,
"reproduce":289.3938,
"reproduced":0.1883,
"reproducible":11.6737,
"reproducing":0.1883,
"reproduction":222.9293,
"reproductive":123.3266,
"reptile":76.6319,
"reptiles":0.1883,
"republic":462.9924,
"republican":214.2681,
"republicanism":10.3557,
"republication":1.3180,
"republish":8.6611,
"repulsive":23.5356,
"repurchase":12.8034,
"reputable":48.9541,
"reputation":699.6665,
"reputed":5.2720,
"request":1380.6927,
"requested":3.7657,
"requester":1.3180,
"requesting":0.5649,
"requests":0.9414,
"requiem":8.0962,
"require":5322.0593,
"required":7.7197,
"requirement":1597.0320,
"requires":1.1297,
"requiring":0.3766,
"requisite":66.0880,
"requisition":36.9038,
"reread":8.6611,
"rerun":8.0962,
"res":4.8954,
"resale":34.2678,
"reschedule":36.5273,
"rescheduling":13.3682,
"rescind":35.3976,
"rescue":576.7165,
"rescued":1.1297,
"rescues":0.1883,
"rescuing":1.6946,
"reseal":4.7071,
"research":4051.3249,
"researched":1.1297,
"researcher":621.1517,
"researching":0.7531,
"resection":35.0210,
"resell":19.5816,
"reseller":53.8495,
"reselling":0.7531,
"resemblance":135.9417,
"resemble":323.0968,
"resembling":0.5649,
"resent":167.9501,
"resentment":194.1217,
"reservation":281.6741,
"reserve":945.0016,
"reserved":34.8327,
"reserving":0.7531,
"reservoir":169.8329,
"reset":41.7992,
"resetting":2.2594,
"resettlement":27.4896,
"reshape":34.6444,
"reside":132.5525,
"residence":320.8374,
"residency":24.8536,
"resident":993.7674,
"residential":520.4193,
"residual":141.2136,
"residue":172.2806,
"resign":593.4738,
"resignation":414.4149,
"resigned":3.5774,
"resigning":0.3766,
"resilience":40.2930,
"resilient":39.5398,
"resin":75.5022,
"resist":619.8337,
"resistance":627.9299,
"resistant":157.4061,
"resistible":1.6946,
"resisting":1.8828,
"resistive":5.6485,
"resistivity":11.2971,
"resistor":37.6570,
"resold":9.2260,
"resolution":706.8213,
"resolve":768.0139,
"resolved":0.1883,
"resolver":1.8828,
"resolving":3.5774,
"resonance":76.0671,
"resonant":32.7616,
"resonate":16.1925,
"resort":544.5198,
"resounding":34.0796,
"resource":2199.7318,
"resourced":0.5649,
"resourceful":24.4770,
"resources":1.5063,
"resourcing":14.1214,
"respect":2274.8575,
"respectable":216.7159,
"respected":88.8704,
"respectful":40.1047,
"respectfully":28.4310,
"respecting":0.5649,
"respective":215.0213,
"respectively":533.2227,
"respiration":22.7825,
"respirator":10.9205,
"respiratory":90.0002,
"respite":69.2888,
"respond":1291.6340,
"respondent":291.0884,
"responder":18.2636,
"responding":0.3766,
"response":2602.6614,
"responsibility":2140.6104,
"responsible":1662.7434,
"responsibly":21.0879,
"responsive":115.6069,
"responsiveness":28.4310,
"rest":3383.1020,
"restart":50.0838,
"restated":0.1883,
"restaurant":834.6667,
"rested":3.3891,
"resting":6.4017,
"restitution":30.1256,
"restless":110.1466,
"restlessness":25.0419,
"restocking":0.9414,
"restoration":315.3771,
"restorative":23.3473,
"restore":795.1269,
"restored":0.7531,
"restoring":1.5063,
"restrain":170.0212,
"restrained":36.1507,
"restraining":19.5816,
"restraint":268.6825,
"restrict":763.8716,
"restricted":120.8789,
"restricting":1.3180,
"restriction":685.5451,
"restrictive":157.7827,
"restrictively":3.3891,
"restroom":0.7531,
"restructure":104.4981,
"restructured":0.1883,
"restructuring":172.8455,
"resubmit":2.6360,
"result":7685.2224,
"resultant":76.2554,
"resulted":0.3766,
"resulting":0.7531,
"resume":326.4859,
"resumed":0.7531,
"resumption":54.7909,
"resurfacing":6.2134,
"resurgence":45.7532,
"resurrection":74.5608,
"resuscitation":25.6067,
"retail":368.8500,
"retailer":247.4063,
"retailing":77.3851,
"retain":1180.3577,
"retained":0.5649,
"retainer":40.1047,
"retaining":0.9414,
"retaliation":52.9080,
"retard":24.2887,
"retardant":5.6485,
"retardation":26.9247,
"retarded":26.3599,
"retell":11.2971,
"retelling":4.8954,
"retention":149.3099,
"retentive":6.2134,
"rethink":57.6152,
"rethinking":9.6025,
"reticulum":6.5900,
"retina":59.4980,
"retinal":20.7113,
"retire":817.3445,
"retired":55.5440,
"retiree":4.1423,
"retirement":626.2354,
"retires":0.9414,
"retiring":4.1423,
"retract":34.6444,
"retractable":7.7197,
"retraining":10.5440,
"retransmission":0.9414,
"retreat":357.7412,
"retribution":54.6026,
"retrieval":121.0672,
"retrieve":173.0338,
"retrieved":0.3766,
"retriever":9.0377,
"retrieving":0.5649,
"retro":10.1674,
"retroactive":4.8954,
"retroactively":2.0711,
"retrofit":6.0251,
"retrograde":27.1130,
"retrospect":75.5022,
"retrospective":93.0127,
"retry":2.8243,
"return":5933.6085,
"returnable":9.2260,
"returned":0.1883,
"returning":2.6360,
"returns":0.5649,
"reuben":0.1883,
"reunification":46.3181,
"reunion":92.6361,
"reunite":56.8620,
"reusable":8.6611,
"reuse":22.7825,
"rev":29.9373,
"revaluation":38.7867,
"revamp":44.2469,
"revamped":0.1883,
"reveal":1890.9447,
"revealed":0.3766,
"revealing":34.4561,
"revel":57.2386,
"revelation":238.7452,
"revenge":183.2012,
"revenue":737.1352,
"revenues":0.1883,
"revere":37.2804,
"revered":4.5188,
"reverence":48.3892,
"reverend":5.4603,
"reversal":109.5818,
"reverse":696.6539,
"reversed":10.3557,
"reversible":36.3390,
"reversing":3.0126,
"reversion":43.8704,
"revert":148.1802,
"review":2025.0035,
"reviewed":0.7531,
"reviewer":68.5357,
"reviewing":9.4142,
"reviews":3.5774,
"revise":355.4818,
"revised":13.7448,
"revising":1.1297,
"revision":226.6949,
"revisit":36.5273,
"revisited":0.1883,
"revitalization":3.7657,
"revitalize":14.6862,
"revival":198.4522,
"revive":263.5988,
"revived":0.3766,
"reviving":0.3766,
"revocation":12.6151,
"revoke":59.3097,
"revolt":192.4271,
"revolution":659.9384,
"revolutionary":412.5321,
"revolutionise":29.3724,
"revolutionize":13.1799,
"revolve":113.1592,
"revolver":40.1047,
"revolving":6.7783,
"revue":13.7448,
"reward":753.3277,
"rewarded":0.3766,
"rewarding":110.7115,
"rewind":16.3808,
"rework":26.3599,
"rewrite":93.7659,
"rewriting":7.7197,
"rex":0.7531,
"rezoning":0.1883,
"rf":5.0837,
"rh":3.2008,
"rhapsody":8.4728,
"rhea":1.3180,
"rhetoric":169.0798,
"rhetorical":69.1005,
"rheumatoid":6.2134,
"rhine":4.1423,
"rhinestone":3.0126,
"rhino":46.3181,
"rho":4.5188,
"rhodium":4.1423,
"rhyme":106.1927,
"rhyming":3.9540,
"rhythm":350.7747,
"rhythmic":70.9834,
"rhythms":0.1883,
"rial":5.2720,
"rib":199.7702,
"ribbed":16.3808,
"ribbon":171.1509,
"ribs":0.5649,
"rica":0.1883,
"rice":244.5820,
"rich":1513.0570,
"richards":0.1883,
"richer":0.7531,
"riches":5.2720,
"richly":77.7616,
"richmond":0.1883,
"richness":73.2428,
"rick":8.2845,
"rid":475.7958,
"ridden":12.9917,
"ridding":0.5649,
"riddle":70.6068,
"riddled":2.2594,
"ride":1332.6801,
"rider":305.2097,
"ridge":227.0715,
"ridicule":77.0085,
"ridiculous":305.9629,
"ridiculously":34.0796,
"riding":105.2512,
"riel":0.5649,
"riemann":0.3766,
"riesling":0.9414,
"rife":40.6695,
"riff":32.9498,
"rifle":175.2932,
"rift":83.7868,
"rig":171.5275,
"rigged":1.5063,
"rigging":31.4436,
"right":16169.1491,
"righteous":46.1298,
"righteousness":39.7281,
"rightful":50.0838,
"rightfully":12.8034,
"rightist":12.8034,
"rightly":264.3519,
"rights":0.1883,
"rigid":261.5276,
"rigidity":45.0001,
"rigidly":52.9080,
"rigor":5.8368,
"rigorous":119.3726,
"rigorously":42.9289,
"rigs":1.1297,
"rim":131.2345,
"rimming":0.1883,
"ring":2197.4724,
"ringed":0.5649,
"ringer":13.9331,
"ringgit":4.7071,
"ringing":28.2427,
"rink":28.6193,
"rinse":101.2972,
"rinsed":0.5649,
"rio":0.7531,
"riot":343.0550,
"riots":0.7531,
"rip":258.1385,
"riparian":0.7531,
"ripe":119.3726,
"ripeness":5.6485,
"riper":1.3180,
"ripper":2.4477,
"ripping":1.1297,
"ripple":121.0672,
"rips":0.1883,
"rise":4593.9619,
"risen":2.4477,
"riser":16.3808,
"rising":10.3557,
"risk":2794.3353,
"risked":0.1883,
"risky":128.4103,
"risque":2.2594,
"rite":107.1341,
"ritual":354.9169,
"rival":763.8716,
"rivalry":119.3726,
"river":1508.9147,
"riverfront":0.9414,
"riverside":46.8829,
"rivet":55.3557,
"riveting":13.3682,
"riviera":2.6360,
"riyal":1.5063,
"rm":2.0711,
"rn":0.1883,
"rna":99.0378,
"roach":41.7992,
"road":3939.6720,
"roadrunner":0.3766,
"roads":0.1883,
"roadshow":16.7574,
"roadside":74.3725,
"roadster":3.3891,
"roadway":35.3976,
"roam":98.2847,
"roaming":4.1423,
"roar":293.3478,
"roaring":22.2176,
"roast":124.8329,
"roasted":12.8034,
"roasting":14.6862,
"roasts":0.1883,
"rob":178.3057,
"robbed":0.7531,
"robber":76.6319,
"robbery":156.2764,
"robbing":3.5774,
"robbins":0.1883,
"robe":129.9165,
"robert":0.1883,
"roberts":1.3180,
"robin":39.7281,
"robinson":1.8828,
"robot":146.4856,
"robotic":22.9708,
"robots":0.1883,
"robs":0.3766,
"robust":127.2806,
"robustness":12.4268,
"rock":1701.1535,
"rockabilly":4.7071,
"rocker":42.5524,
"rocket":176.7995,
"rocking":14.1214,
"rocky":104.8747,
"rod":266.4231,
"rode":2.8243,
"rodent":49.3306,
"rodeo":7.5314,
"rodin":0.1883,
"roe":9.7908,
"roebuck":0.3766,
"rogue":68.9123,
"roi":18.4519,
"role":3793.5630,
"roles":1.3180,
"roll":1373.1614,
"rollback":0.5649,
"rolled":0.3766,
"roller":145.7325,
"rolling":112.7826,
"rollover":4.8954,
"rolls":0.9414,
"rom":85.8579,
"roma":0.7531,
"roman":683.2857,
"romance":187.5317,
"romanian":95.4604,
"romantic":368.0969,
"romanticism":31.8201,
"romantics":0.3766,
"rome":0.3766,
"romeo":0.7531,
"romp":40.4812,
"ron":0.7531,
"roof":903.2024,
"roofing":37.4687,
"roofs":0.1883,
"rooftop":29.3724,
"rook":23.1590,
"rookie":11.2971,
"room":6547.6054,
"roommate":1.5063,
"roomy":19.2051,
"roost":36.3390,
"rooster":3.2008,
"root":1027.6587,
"rooted":30.5021,
"rooting":3.3891,
"roots":1.1297,
"rope":413.4735,
"roper":1.1297,
"rosary":12.4268,
"rose":361.5069,
"rosebud":5.0837,
"rosemary":10.1674,
"rosewood":23.9122,
"ross":0.1883,
"rossini":0.3766,
"roster":20.8996,
"rosy":54.2260,
"rot":182.6363,
"rota":30.8787,
"rotary":44.6235,
"rotate":156.2764,
"rotating":3.2008,
"rotation":160.0421,
"rotational":23.1590,
"rotor":102.8035,
"rotted":6.2134,
"rotten":136.8831,
"rotting":4.1423,
"rottweiler":8.2845,
"rouble":97.3433,
"rouge":10.1674,
"rough":655.7961,
"roughly":407.8250,
"roughness":14.6862,
"roulette":9.9791,
"round":6091.5795,
"roundabout":112.7826,
"rounded":112.4061,
"rounder":39.3515,
"roundest":0.1883,
"rounding":8.0962,
"roundly":18.2636,
"roundness":6.9665,
"roundup":8.8494,
"roundups":0.1883,
"rouse":92.4479,
"rousing":6.7783,
"rout":22.0293,
"route":1471.0695,
"routed":0.3766,
"router":31.0670,
"routine":682.7208,
"routinely":70.7951,
"routing":18.2636,
"roux":1.1297,
"rove":26.7364,
"rover":51.7783,
"roving":3.2008,
"row":1259.6256,
"rowan":1.8828,
"rowing":51.2135,
"rows":0.1883,
"royal":761.8005,
"royally":2.8243,
"royalties":0.3766,
"royalty":143.8496,
"rpm":32.7616,
"ru":1.3180,
"rub":408.2015,
"rubbed":1.1297,
"rubber":304.2683,
"rubbing":10.3557,
"rubbish":387.6785,
"rubble":68.1591,
"rubens":0.1883,
"rubicon":0.9414,
"rubric":11.8619,
"ruby":36.1507,
"rudd":1.5063,
"rudder":58.9332,
"rude":170.5861,
"rudely":22.7825,
"rudeness":19.0168,
"ruder":0.9414,
"rudimentary":47.6361,
"rue":13.3682,
"ruff":20.7113,
"ruffled":6.5900,
"rug":262.0925,
"rugby":382.9714,
"rugged":60.8160,
"ruin":503.2854,
"ruined":0.5649,
"ruining":0.3766,
"rule":4322.0785,
"ruled":0.1883,
"ruler":282.6155,
"rules":0.7531,
"ruling":197.6991,
"rum":63.0754,
"rumble":102.0504,
"rumor":1.5063,
"rumour":394.2685,
"run":8883.0906,
"runaway":46.6946,
"rundown":20.7113,
"rune":36.7155,
"rung":29.1842,
"runner":365.0843,
"running":341.5487,
"runny":16.1925,
"runoff":8.0962,
"runs":0.1883,
"runway":104.3098,
"rupee":26.7364,
"rupert":2.2594,
"rupiah":0.7531,
"rupture":52.9080,
"rural":1043.8512,
"rush":840.6918,
"rushed":1.1297,
"rushes":0.3766,
"rushing":4.1423,
"rusk":5.4603,
"ruskin":0.3766,
"russia":0.1883,
"russian":807.3654,
"rust":77.5734,
"rusted":10.7322,
"rustic":44.6235,
"rusting":14.3096,
"rusty":61.9457,
"rut":45.0001,
"ruth":2.2594,
"rutherford":0.7531,
"ruthless":116.7366,
"rwanda":0.1883,
"rwandan":5.4603,
"rye":41.6110,
"sa":0.3766,
"sabbath":8.4728,
"sabbatical":12.4268,
"saber":0.1883,
"sabine":0.1883,
"sable":8.8494,
"sabotage":68.9123,
"sabre":14.6862,
"sac":45.5649,
"sack":449.8125,
"sacked":0.7531,
"sacrament":48.9541,
"sacred":205.9836,
"sacredness":3.7657,
"sacrifice":371.1094,
"sacrificial":23.1590,
"sacrificing":0.1883,
"sad":617.5743,
"saddam":1.3180,
"sadden":39.1632,
"saddened":1.8828,
"sadder":1.6946,
"saddest":0.1883,
"saddle":193.1802,
"saddlery":5.6485,
"saddling":0.5649,
"sade":0.3766,
"sadism":10.5440,
"sadistic":27.4896,
"sadly":341.9253,
"sadness":140.8371,
"safari":13.9331,
"safe":1482.7431,
"safeguard":239.8749,
"safeguarding":6.4017,
"safely":305.9629,
"safeness":0.3766,
"safer":9.0377,
"safest":0.9414,
"safety":1364.8768,
"saffron":12.4268,
"sag":69.2888,
"saga":71.7365,
"sage":45.9415,
"sagittarius":0.5649,
"sahara":0.5649,
"saharan":16.7574,
"sai":0.1883,
"said":14.4979,
"sail":611.9257,
"sailboat":3.3891,
"sailed":0.1883,
"sailing":230.4606,
"sailor":193.1802,
"sailors":0.1883,
"saint":214.4564,
"saith":0.3766,
"sake":551.1097,
"salaam":0.1883,
"salad":228.7661,
"salamander":12.2385,
"salaried":34.6444,
"salary":519.8544,
"sale":3370.2987,
"sales":1.5063,
"salesman":124.4563,
"salespeople":4.7071,
"salesperson":53.6612,
"salient":57.9917,
"saline":56.2972,
"salinity":16.0042,
"saliva":40.2930,
"salivary":11.4854,
"sally":12.9917,
"salmon":192.6154,
"salmonella":27.3013,
"salon":104.6864,
"saloon":106.7575,
"salsa":2.2594,
"salt":564.4780,
"salted":4.8954,
"salter":1.1297,
"saltwater":2.2594,
"salty":32.1967,
"salute":104.4981,
"salvage":87.1759,
"salvation":119.1843,
"sam":2.6360,
"samara":0.1883,
"samaritan":4.7071,
"samba":2.6360,
"same":10985.4791,
"sameness":12.9917,
"samoan":0.5649,
"sample":1388.0359,
"sampled":2.8243,
"sampler":17.6988,
"samples":0.1883,
"sampling":136.1299,
"samuel":0.3766,
"samurai":6.5900,
"sanction":384.4776,
"sanctioned":3.0126,
"sanctity":29.3724,
"sanctuary":129.5400,
"sand":615.1266,
"sandal":53.6612,
"sandalwood":11.1088,
"sandbox":0.3766,
"sander":14.1214,
"sanding":10.9205,
"sandman":0.1883,
"sandpiper":8.0962,
"sandstone":74.9374,
"sandwich":343.9964,
"sandwiches":1.5063,
"sandy":117.4897,
"sane":53.4729,
"sang":3.2008,
"sanger":0.5649,
"sanitary":45.0001,
"sanitation":28.8076,
"sanity":45.1884,
"sank":0.3766,
"sans":1.3180,
"sanskrit":4.7071,
"santa":0.1883,
"santiago":0.1883,
"sap":56.2972,
"sapphire":32.7616,
"sarah":9.2260,
"sarajevo":0.1883,
"sarcasm":49.1423,
"sarcastic":35.5858,
"sarcoma":6.4017,
"sargent":0.3766,
"sari":6.0251,
"sartre":1.3180,
"sash":37.8453,
"sassy":3.0126,
"sat":16.9456,
"satanic":24.8536,
"satchel":1.5063,
"satellite":363.0132,
"satin":72.1131,
"satire":39.3515,
"satirical":33.3264,
"satisfaction":531.5281,
"satisfactorily":98.0964,
"satisfactory":384.6659,
"satisfied":558.4528,
"satisfy":525.6913,
"satisfying":105.2512,
"saturated":34.6444,
"saturation":50.6486,
"saturday":26.3599,
"saturn":0.3766,
"sauce":267.3645,
"saucepan":73.9959,
"saucer":84.3516,
"sauces":0.1883,
"saudi":58.3683,
"sauna":54.7909,
"sausage":171.7158,
"savage":186.4020,
"savanna":6.4017,
"savant":3.5774,
"save":2286.7194,
"saver":63.8286,
"saving":656.3610,
"savings":1.1297,
"savior":0.1883,
"saviour":40.1047,
"savor":0.7531,
"savory":6.5900,
"savoy":0.5649,
"savvy":5.8368,
"saw":122.1969,
"sawed":1.6946,
"sawing":7.3431,
"sawyer":3.0126,
"sax":2.4477,
"saxon":127.2806,
"saxony":0.5649,
"saxophone":16.1925,
"say":57591.2494,
"saying":95.4604,
"says":0.7531,
"sb":0.3766,
"sc":4.3306,
"scaffold":28.2427,
"scaffolding":30.8787,
"scalability":3.7657,
"scalable":20.1465,
"scalar":27.3013,
"scale":2011.0704,
"scaled":0.7531,
"scales":0.5649,
"scaling":18.8285,
"scalp":72.3014,
"scam":17.8871,
"scamp":5.0837,
"scan":278.0967,
"scandal":302.7620,
"scandalous":35.0210,
"scandinavia":0.7531,
"scandinavian":73.9959,
"scanned":0.7531,
"scanner":85.2930,
"scanning":35.9624,
"scant":50.2721,
"scar":138.0128,
"scarab":4.3306,
"scarce":130.6697,
"scarcely":286.5695,
"scarcer":6.4017,
"scarcest":0.3766,
"scarcity":43.1172,
"scare":171.7158,
"scarecrow":11.6737,
"scared":201.8414,
"scares":0.1883,
"scarf":123.7031,
"scarface":1.1297,
"scaring":0.1883,
"scarlet":118.2429,
"scarred":50.2721,
"scarring":6.5900,
"scary":39.9164,
"scat":13.5565,
"scatter":380.9002,
"scattered":19.0168,
"scattering":36.5273,
"scavenger":20.7113,
"scenario":168.5149,
"scene":1560.5048,
"scenery":134.8119,
"scenes":0.7531,
"scenic":46.6946,
"scent":258.7034,
"scented":41.0461,
"scenting":1.1297,
"sceptical":140.4605,
"schedule":797.1980,
"scheduled":16.3808,
"scheduler":3.5774,
"schedules":0.1883,
"scheduling":34.8327,
"schema":57.8034,
"schematic":32.1967,
"schematically":10.1674,
"scheme":2866.0719,
"scheming":12.6151,
"schiller":0.5649,
"schilling":3.0126,
"schizophrenia":65.7114,
"schizophrenic":37.0921,
"schmidt":0.1883,
"schnauzer":0.1883,
"scholar":305.3980,
"scholarly":83.0336,
"scholarship":182.8246,
"scholastic":18.6402,
"school":8377.3575,
"schoolchildren":74.3725,
"schooled":3.7657,
"schoolgirl":65.3348,
"schoolhouse":6.4017,
"schooling":144.6028,
"schools":3.2008,
"schubert":0.1883,
"schumann":0.1883,
"science":1677.4297,
"sciences":0.5649,
"scientific":990.0017,
"scientifically":42.5524,
"scientist":829.5830,
"scion":9.6025,
"scissor":86.9876,
"sclerosis":23.9122,
"scold":47.4478,
"scolding":2.0711,
"sconce":7.9080,
"scoop":130.4814,
"scooter":20.5230,
"scope":617.5743,
"scoping":0.3766,
"score":1625.2748,
"scoreboard":10.9205,
"scorecard":6.5900,
"scored":3.7657,
"scorer":100.5441,
"scores":0.1883,
"scoring":177.9292,
"scorn":92.8244,
"scorned":0.9414,
"scornful":23.7239,
"scornfully":28.8076,
"scorning":1.1297,
"scorpio":1.5063,
"scorpion":30.6904,
"scorsese":0.1883,
"scot":49.7072,
"scotch":36.1507,
"scotland":4.3306,
"scots":25.2302,
"scotsman":5.2720,
"scott":0.1883,
"scottish":938.5999,
"scourge":31.4436,
"scout":88.3056,
"scouting":7.1548,
"scouts":0.3766,
"scrabble":38.5984,
"scramble":203.3476,
"scrambled":6.4017,
"scrambling":3.2008,
"scrap":297.4901,
"scrapbook":9.6025,
"scrape":181.8832,
"scraped":0.3766,
"scraping":11.2971,
"scratch":341.3604,
"scratched":5.6485,
"scratching":17.1339,
"scream":628.3065,
"screamed":0.5649,
"screaming":31.6319,
"screen":1227.6172,
"screened":0.1883,
"screening":192.4271,
"screenplay":28.0544,
"screens":0.3766,
"screenwriter":6.7783,
"screenwriting":1.1297,
"screw":355.8584,
"screwdriver":48.5775,
"screwed":0.1883,
"screwing":1.8828,
"scribe":48.3892,
"script":303.8917,
"scripted":0.1883,
"scripting":3.5774,
"scripture":105.6278,
"scroll":67.2177,
"scrolling":3.0126,
"scrooge":2.2594,
"scrub":146.4856,
"scrubbed":7.7197,
"scrubbing":6.9665,
"scrutiny":210.1259,
"scsi":28.4310,
"scuba":15.0628,
"sculpted":4.3306,
"sculpting":0.9414,
"sculptor":93.0127,
"sculpture":323.0968,
"scum":77.9499,
"sd":34.0796,
"se":19.5816,
"sea":2028.2043,
"seacoast":1.8828,
"seafood":27.1130,
"seagull":29.7490,
"seal":579.3525,
"sealant":18.0753,
"sealed":2.4477,
"sealing":13.9331,
"seam":129.5400,
"seaman":101.1090,
"seamen":9.9791,
"seamless":23.5356,
"seamlessly":7.1548,
"seaport":9.0377,
"search":1922.3882,
"searched":0.1883,
"searcher":26.5482,
"searching":25.7950,
"seas":0.1883,
"seascape":8.0962,
"seashore":14.6862,
"seaside":92.2596,
"season":2206.8866,
"seasonal":168.5149,
"seasonally":17.5105,
"seasoned":23.9122,
"seasoning":35.2093,
"seat":2175.0665,
"seated":9.6025,
"seating":71.9248,
"seawater":10.1674,
"seaweed":41.2344,
"sec":45.7532,
"secluded":47.6361,
"seclusion":24.8536,
"second":7846.5825,
"secondary":841.4450,
"seconded":0.7531,
"secondhand":30.5021,
"secondly":510.0636,
"secrecy":119.3726,
"secret":1187.8891,
"secretarial":50.6486,
"secretariat":37.2804,
"secretary":1041.4035,
"secretion":169.8329,
"secretive":43.6821,
"secretly":126.1508,
"secretory":25.0419,
"secrets":0.5649,
"sect":68.7240,
"sectarian":60.4394,
"section":3803.3538,
"sectional":49.3306,
"sectioned":0.1883,
"sectioning":1.8828,
"sector":2033.0997,
"sectoral":22.5942,
"sectors":0.5649,
"secular":170.7744,
"secure":1320.6299,
"secured":12.2385,
"securely":62.6989,
"securing":8.2845,
"security":2152.8489,
"sedan":7.5314,
"sedation":16.7574,
"sedentary":25.9833,
"sediment":186.9668,
"sedimentary":33.5147,
"sedimentation":34.4561,
"seduce":77.5734,
"seduction":29.1842,
"seductive":42.9289,
"see":33112.5254,
"seed":619.4571,
"seeded":7.1548,
"seeding":10.7322,
"seedling":44.2469,
"seeing":17.1339,
"seek":3061.6998,
"seeker":72.4897,
"seeking":24.1005,
"seeks":1.5063,
"seem":10891.1484,
"seemed":10.1674,
"seeming":2.6360,
"seemingly":215.0213,
"seems":15.6276,
"seen":4.1423,
"seer":13.9331,
"sees":0.1883,
"segment":303.7034,
"segmentation":48.9541,
"segmented":1.5063,
"segregated":8.8494,
"segregation":76.8202,
"seine":4.3306,
"seismic":54.0377,
"seize":461.8627,
"seized":0.1883,
"seizing":1.1297,
"seizure":88.3056,
"seldom":267.5528,
"select":1378.9982,
"selectable":5.8368,
"selected":9.2260,
"selecting":3.7657,
"selection":1107.8680,
"selective":245.9000,
"selectively":43.3055,
"selectivity":26.3599,
"selector":104.4981,
"selenium":6.4017,
"self":3417.5582,
"selfish":119.1843,
"selfishly":6.9665,
"selfishness":37.0921,
"selfless":18.4519,
"selkirk":1.8828,
"sell":3917.4544,
"seller":450.9422,
"selling":221.0464,
"seltzer":0.3766,
"semantic":302.7620,
"semantically":24.8536,
"semaphore":14.4979,
"semblance":36.7155,
"semen":26.9247,
"semester":6.9665,
"semi":681.0263,
"semicolon":4.5188,
"semiconductor":58.5566,
"semiconductors":0.3766,
"seminal":37.4687,
"seminar":320.4608,
"seminars":0.1883,
"seminary":16.9456,
"semitic":32.3850,
"sen":1.3180,
"senate":2.0711,
"senator":96.0253,
"send":4410.1959,
"sender":48.0126,
"sending":27.1130,
"seneca":0.1883,
"senegal":0.1883,
"senior":1345.4835,
"seniority":31.4436,
"senna":0.5649,
"sens":0.1883,
"sensation":328.9336,
"sensational":78.8913,
"sense":4457.4553,
"sensed":4.1423,
"senseless":33.5147,
"senselessness":0.5649,
"sensibility":69.2888,
"sensible":489.1640,
"sensibly":78.8913,
"sensing":16.1925,
"sensitive":698.9133,
"sensitivity":304.2683,
"sensor":68.9123,
"sensors":0.3766,
"sensory":118.4312,
"sensual":60.8160,
"sensuality":26.3599,
"sensuous":35.5858,
"sent":1.5063,
"sentence":1714.8983,
"sentences":0.1883,
"sentencing":82.6570,
"sentient":9.2260,
"sentiment":190.5443,
"sentimental":90.7533,
"sentinel":7.1548,
"sentry":43.3055,
"sep":0.1883,
"separable":16.0042,
"separate":2194.2715,
"separated":6.4017,
"separately":313.1177,
"separating":0.9414,
"separation":345.6910,
"separatist":61.3809,
"separator":6.7783,
"sepia":14.6862,
"sepsis":15.4394,
"sept":0.1883,
"septic":15.0628,
"septuagint":0.1883,
"seq":3.9540,
"sequel":55.1675,
"sequence":1044.0394,
"sequenced":0.3766,
"sequencer":5.6485,
"sequencing":24.4770,
"sequential":70.0420,
"sequentially":16.9456,
"sequestration":10.1674,
"sequin":11.8619,
"sequoia":1.1297,
"serb":78.5148,
"serbia":0.1883,
"serbian":134.6237,
"serenade":14.1214,
"serendipity":3.5774,
"serene":38.4101,
"serengeti":0.1883,
"serenity":27.6779,
"serge":10.9205,
"sergeant":220.2933,
"serial":170.0212,
"serialization":1.6946,
"serialized":0.1883,
"series":2389.1464,
"serif":2.0711,
"serious":2169.4179,
"seriously":1006.3825,
"seriousness":102.2387,
"sermon":108.2638,
"serotonin":6.7783,
"serpent":43.8704,
"serpentine":15.2511,
"serum":200.8999,
"servant":783.6415,
"serve":2846.6785,
"served":0.3766,
"server":382.4065,
"service":8584.8474,
"serviceable":21.6528,
"serviced":1.8828,
"servicemen":8.4728,
"services":1.3180,
"servicing":64.0168,
"serving":15.4394,
"servitude":12.4268,
"servo":16.1925,
"sesame":15.2511,
"session":1095.8178,
"set":9929.3894,
"setback":106.3809,
"sets":0.1883,
"setter":22.4059,
"setting":712.2816,
"settle":1335.8810,
"settled":5.4603,
"settlement":977.7632,
"settler":98.2847,
"settling":17.1339,
"setup":32.3850,
"seven":3207.6206,
"sevenfold":2.8243,
"seventeen":305.9629,
"seventeenth":271.8833,
"seventh":257.0088,
"seventieth":3.9540,
"seventy":775.7335,
"sever":109.5818,
"several":4230.1955,
"severance":27.4896,
"severe":823.9345,
"severed":1.3180,
"severely":318.5780,
"severer":1.3180,
"severity":131.6111,
"severn":3.2008,
"seville":0.5649,
"sew":107.1341,
"sewage":140.0839,
"sewer":77.7616,
"sewerage":26.3599,
"sewing":101.1090,
"sewn":1.1297,
"sex":1603.4337,
"sexism":55.5440,
"sexist":76.8202,
"sexton":5.6485,
"sexual":1243.0565,
"sexuality":253.9963,
"sexually":188.0966,
"sexy":118.8077,
"sgml":2.8243,
"sh":106.9458,
"shabby":75.5022,
"shack":28.9959,
"shad":1.3180,
"shade":458.6619,
"shaded":30.8787,
"shades":0.1883,
"shading":19.5816,
"shadow":757.0933,
"shadowed":0.1883,
"shadowing":1.6946,
"shadowy":70.2302,
"shady":46.3181,
"shaft":234.6029,
"shag":32.1967,
"shaggy":26.9247,
"shah":5.8368,
"shake":1521.9064,
"shaken":4.3306,
"shaker":11.6737,
"shakespeare":1.8828,
"shakespearean":11.4854,
"shakily":26.7364,
"shaking":9.7908,
"shaky":83.9750,
"shale":41.4227,
"shall":3426.2193,
"shallow":284.6867,
"shallower":0.3766,
"shallowness":4.8954,
"shalt":18.4519,
"sham":39.7281,
"shaman":33.3264,
"shame":356.0466,
"shamed":0.7531,
"shameful":44.4352,
"shamefully":7.9080,
"shameless":14.6862,
"shaming":2.8243,
"shampoo":62.6989,
"shamrock":6.2134,
"shanghai":0.1883,
"shank":17.5105,
"shape":2129.8781,
"shaped":42.3641,
"shapeless":21.6528,
"shaping":38.9750,
"share":5043.5861,
"shared":29.5607,
"shareholder":686.4865,
"shares":16.0042,
"shareware":30.1256,
"sharing":160.9835,
"shark":91.3181,
"sharp":910.9221,
"sharpen":113.1592,
"sharpener":6.4017,
"sharpening":5.8368,
"sharper":1.1297,
"sharply":426.2769,
"sharpness":39.3515,
"shatter":209.3727,
"shattered":46.3181,
"shattering":11.4854,
"shave":135.9417,
"shaved":0.1883,
"shaver":7.3431,
"shaving":36.3390,
"shaw":1.5063,
"shawl":54.9792,
"shawn":0.1883,
"she":82345.9990,
"shear":68.1591,
"shearer":8.4728,
"shearing":13.5565,
"sheath":33.8913,
"shed":498.7665,
"shedding":11.8619,
"sheds":0.7531,
"sheen":28.4310,
"sheep":538.4946,
"sheepdog":12.8034,
"sheepskin":18.0753,
"sheer":371.4860,
"sheet":1154.7509,
"sheeting":22.2176,
"sheets":1.8828,
"sheik":1.8828,
"shekel":5.2720,
"shelf":478.2435,
"shell":545.0846,
"shelley":1.3180,
"shellfish":25.6067,
"shelling":26.3599,
"shelter":382.9714,
"sheltered":88.8704,
"sheltering":1.3180,
"shelves":0.1883,
"shelving":20.5230,
"shepherd":131.9877,
"sheraton":0.3766,
"sheriff":90.7533,
"sherlock":0.5649,
"sherman":0.1883,
"sherpa":1.5063,
"sherry":91.3181,
"shetland":4.7071,
"shew":9.4142,
"shiatsu":1.8828,
"shield":311.9880,
"shielded":1.3180,
"shielding":9.6025,
"shields":0.5649,
"shift":1374.8559,
"shifted":1.1297,
"shifter":3.5774,
"shifting":22.5942,
"shiite":8.0962,
"shilling":158.1593,
"shimmer":55.3557,
"shimmering":16.5691,
"shin":44.8118,
"shine":504.6034,
"shined":0.5649,
"shingle":44.6235,
"shingles":1.6946,
"shining":12.2385,
"shiny":128.0337,
"ship":1469.3749,
"shipbuilding":41.7992,
"shipment":112.2178,
"shipper":24.6653,
"shipping":151.9459,
"ships":0.1883,
"shipyard":47.4478,
"shire":36.9038,
"shirt":827.1353,
"shirtless":1.6946,
"shit":318.5780,
"shitting":0.7531,
"shitty":10.5440,
"shiver":244.5820,
"shivering":12.0502,
"shock":1045.9223,
"shocked":169.2681,
"shocking":90.3767,
"shoe":855.1898,
"shoebox":3.7657,
"shoed":0.5649,
"shoeing":7.1548,
"shoemaker":28.8076,
"shogun":1.6946,
"shone":2.0711,
"shook":0.7531,
"shoot":1505.9022,
"shooter":16.7574,
"shooting":230.8372,
"shootout":4.1423,
"shoots":0.7531,
"shop":2885.6535,
"shopper":112.5943,
"shopping":530.7750,
"shore":392.5739,
"shoreline":27.4896,
"short":4591.1376,
"shortage":390.3145,
"shortcake":0.9414,
"shortcut":9.9791,
"shorten":100.1675,
"shortened":5.2720,
"shortening":10.1674,
"shorter":8.4728,
"shortest":1.6946,
"shortfall":90.1884,
"shorthand":54.0377,
"shortlist":37.2804,
"shortly":675.1894,
"shortness":10.9205,
"shortstop":0.1883,
"shot":940.1062,
"shotgun":83.9750,
"shots":0.1883,
"should":19673.5066,
"shoulder":1610.5885,
"shouldn":0.1883,
"shout":1113.8931,
"shouted":1.8828,
"shouting":39.9164,
"shove":142.9082,
"shovel":65.5231,
"show":12202.9289,
"showbiz":30.3139,
"showcase":35.2093,
"showdown":38.7867,
"showed":0.1883,
"shower":426.8417,
"showering":0.5649,
"showing":88.3056,
"shown":1.1297,
"showroom":63.0754,
"shows":0.7531,
"showtime":1.8828,
"shred":66.8411,
"shredded":6.4017,
"shredder":5.2720,
"shredding":0.9414,
"shrewd":82.8453,
"shrimp":63.6403,
"shrine":108.4521,
"shrink":233.6615,
"shrinkage":21.6528,
"shrinking":5.4603,
"shroud":85.1047,
"shrub":149.4982,
"shrug":411.5907,
"shrugged":0.1883,
"shrunk":0.9414,
"shudder":171.9041,
"shuffle":147.2387,
"shuffling":6.9665,
"shun":43.8704,
"shunt":51.9666,
"shut":903.0141,
"shutdown":22.7825,
"shutter":107.6989,
"shutting":5.8368,
"shuttle":87.1759,
"shy":239.8749,
"si":7.3431,
"siam":0.5649,
"siamese":13.3682,
"sib":0.1883,
"siberian":40.2930,
"sibling":77.7616,
"sic":9.2260,
"sichuan":0.1883,
"sicilian":16.5691,
"sicily":0.7531,
"sick":774.9804,
"sickle":33.3264,
"sickly":40.4812,
"sickness":212.7619,
"side":7181.7487,
"sidebar":0.9414,
"sided":137.0714,
"sidekick":13.7448,
"sideline":64.7700,
"sideshow":12.9917,
"sidestep":18.4519,
"sidewalk":16.5691,
"sideways":164.5610,
"siding":35.0210,
"siege":155.3350,
"siegfried":0.1883,
"siemens":0.1883,
"sienna":3.7657,
"sierra":0.3766,
"siesta":10.9205,
"sieve":49.7072,
"sift":58.3683,
"sig":1.5063,
"sigh":535.1055,
"sighed":2.2594,
"sight":1339.2701,
"sighted":78.8913,
"sighting":46.6946,
"sightseeing":34.6444,
"sigma":8.6611,
"sign":3553.3115,
"signage":1.8828,
"signal":1130.6505,
"signalling":12.6151,
"signatory":65.3348,
"signature":266.0465,
"signed":3.5774,
"signer":13.3682,
"signet":10.1674,
"significance":828.8299,
"significant":2154.1669,
"significantly":734.4992,
"signified":25.0419,
"signify":134.6237,
"signifying":0.3766,
"signing":175.2932,
"sikh":22.7825,
"sikkim":0.1883,
"silence":1005.0645,
"silenced":0.1883,
"silencing":1.8828,
"silent":618.5157,
"silently":196.7577,
"silhouette":81.1508,
"silica":24.2887,
"silicate":18.2636,
"silicon":61.7574,
"silicone":32.7616,
"silk":369.4149,
"silky":44.2469,
"sill":66.4645,
"silly":474.1012,
"silo":14.3096,
"silos":0.1883,
"silt":48.0126,
"silva":0.3766,
"silver":799.6457,
"silverware":11.1088,
"silvery":52.1549,
"similar":3275.7797,
"similarity":305.9629,
"similarly":799.8340,
"simmer":69.8537,
"simon":0.5649,
"simple":2795.6533,
"simpleness":0.3766,
"simpler":0.9414,
"simplest":5.6485,
"simplex":10.3557,
"simplicity":167.9501,
"simplification":55.9206,
"simplified":66.6528,
"simplify":141.2136,
"simplifying":0.5649,
"simplistic":66.8411,
"simply":3152.0765,
"simulate":74.7491,
"simulated":26.1716,
"simulation":115.0420,
"simulator":30.8787,
"simultaneous":114.6655,
"simultaneously":306.1512,
"sin":343.6198,
"sinatra":0.3766,
"since":8825.8520,
"sincere":85.1047,
"sincerely":70.6068,
"sincerity":52.5315,
"sine":38.5984,
"sinful":29.9373,
"sing":723.9552,
"singaporean":1.3180,
"singer":388.8082,
"singing":215.2096,
"single":3699.9854,
"singles":0.9414,
"singleton":5.6485,
"singly":34.6444,
"sings":0.1883,
"singular":92.4479,
"singularity":76.0671,
"sinister":117.1132,
"sink":804.5411,
"sinking":26.3599,
"sinner":48.9541,
"sinus":21.6528,
"sip":210.8790,
"sipping":0.9414,
"sir":242.1343,
"sire":38.2218,
"siren":73.8077,
"sis":2.0711,
"sissy":2.2594,
"sister":1498.9356,
"sisterhood":4.7071,
"sisterly":6.2134,
"sisters":0.1883,
"sit":5207.3939,
"sitcom":18.2636,
"site":2963.7917,
"sited":0.3766,
"siting":28.2427,
"sits":0.7531,
"sitter":43.8704,
"sitting":175.6698,
"situate":353.2224,
"situated":8.0962,
"situation":3552.7467,
"situational":19.7699,
"six":5761.3279,
"sixteen":475.6075,
"sixteenth":218.7870,
"sixth":446.4234,
"sixthly":2.4477,
"sixths":0.3766,
"sixtieth":5.2720,
"sixty":1079.0604,
"sizable":14.3096,
"size":2625.2555,
"sized":281.6741,
"sizes":0.3766,
"sizing":6.0251,
"sizzling":16.1925,
"ska":2.4477,
"skate":61.1926,
"skateboard":15.2511,
"skateboarding":2.0711,
"skater":21.6528,
"skating":27.1130,
"skeletal":53.4729,
"skeleton":154.5819,
"skeptic":0.1883,
"skeptical":2.4477,
"skepticism":1.3180,
"sketch":285.2515,
"sketchy":22.5942,
"skew":18.4519,
"skewed":15.2511,
"ski":226.6949,
"skid":59.3097,
"skier":47.6361,
"skiing":122.5734,
"skilful":81.3391,
"skilfully":49.1423,
"skill":2271.8449,
"skilled":366.2140,
"skillet":2.8243,
"skillful":3.0126,
"skillfully":1.1297,
"skills":0.1883,
"skim":90.5650,
"skimpy":13.5565,
"skin":1399.5212,
"skincare":9.2260,
"skinned":50.0838,
"skinner":3.7657,
"skinning":2.6360,
"skinny":55.5440,
"skins":0.1883,
"skip":174.7283,
"skipper":118.9960,
"skipping":7.7197,
"skirt":406.6953,
"skit":3.3891,
"skull":225.5652,
"skunk":9.4142,
"sky":876.4659,
"skydiving":0.9414,
"skylight":20.3348,
"skyline":51.0252,
"slab":149.6864,
"slack":89.6236,
"slag":50.2721,
"slain":5.8368,
"slalom":30.5021,
"slam":240.0632,
"slammed":0.5649,
"slamming":6.9665,
"slams":0.1883,
"slander":27.8662,
"slang":40.8578,
"slant":60.4394,
"slap":223.3058,
"slapping":12.2385,
"slash":154.3936,
"slashed":0.5649,
"slashing":3.7657,
"slate":170.5861,
"slated":0.1883,
"slater":5.8368,
"slaughter":146.4856,
"slaughtered":0.1883,
"slave":327.4273,
"slavery":84.7282,
"slavic":6.4017,
"slay":54.4143,
"slayer":4.3306,
"slaying":6.7783,
"sleazy":12.8034,
"sled":6.0251,
"sledding":0.1883,
"sledge":44.8118,
"sleek":61.3809,
"sleep":2095.2337,
"sleeper":48.2009,
"sleeping":37.4687,
"sleepless":34.2678,
"sleepwear":0.1883,
"sleepy":73.2428,
"sleeve":311.0466,
"sleeved":4.3306,
"sleeveless":9.6025,
"sleigh":6.2134,
"slender":132.5525,
"slept":2.2594,
"slew":19.5816,
"slice":406.6953,
"sliced":16.9456,
"slicing":8.6611,
"slick":91.5064,
"slid":0.9414,
"slide":852.3655,
"slider":6.9665,
"sliding":8.0962,
"slight":680.4614,
"slighted":2.2594,
"slighter":2.8243,
"slightest":0.3766,
"slighting":1.1297,
"slightly":1541.4880,
"slim":238.7452,
"slime":28.8076,
"slimline":10.7322,
"slimming":7.3431,
"sling":94.7073,
"slinky":7.5314,
"slip":1135.7342,
"slipper":81.7156,
"slippery":77.9499,
"slipping":4.1423,
"slit":111.4646,
"slits":0.3766,
"slogan":145.9208,
"slope":521.9256,
"sloped":1.8828,
"sloping":10.3557,
"sloppy":37.8453,
"slot":279.9796,
"slots":0.1883,
"slough":11.4854,
"slovak":44.8118,
"slovenia":0.7531,
"slovenian":8.6611,
"slow":1543.1826,
"slowdown":26.1716,
"slowed":0.3766,
"slower":0.5649,
"slowest":0.5649,
"slowing":11.4854,
"slowly":1345.4835,
"sludge":40.6695,
"slug":71.1717,
"slugger":0.5649,
"sluggish":44.6235,
"slum":103.1801,
"slumber":32.5733,
"slump":255.8791,
"slurry":32.5733,
"slut":17.5105,
"slutty":0.1883,
"sly":41.4227,
"sm":2.0711,
"smack":139.8956,
"small":9365.8529,
"smaller":3.5774,
"smallest":1.5063,
"smallness":10.5440,
"smallpox":26.3599,
"smart":301.6323,
"smarter":0.5649,
"smartest":0.1883,
"smarty":1.1297,
"smash":351.1512,
"smashed":0.7531,
"smashing":17.8871,
"smear":121.8203,
"smell":976.8218,
"smelling":13.9331,
"smells":0.7531,
"smelly":46.6946,
"smelt":15.8159,
"smile":2999.7541,
"smiles":1.3180,
"smiley":2.4477,
"smiling":6.2134,
"smith":39.9164,
"smog":32.3850,
"smoke":1044.4160,
"smoked":1.6946,
"smokeless":6.4017,
"smoker":165.8789,
"smoking":401.6116,
"smoky":37.6570,
"smooth":684.4154,
"smoothed":14.6862,
"smoother":5.8368,
"smoothie":4.1423,
"smoothing":27.6779,
"smoothly":174.5400,
"smoothness":25.6067,
"smother":63.2637,
"smug":47.0712,
"smuggled":0.5649,
"smuggling":51.9666,
"smut":8.4728,
"sn":1.6946,
"snack":131.7994,
"snag":67.0294,
"snail":96.9667,
"snails":0.1883,
"snake":242.5109,
"snap":526.0678,
"snapped":0.1883,
"snapper":12.0502,
"snapping":5.0837,
"snaps":0.1883,
"snapshot":47.6361,
"snare":35.0210,
"snatch":234.7912,
"sneak":97.9081,
"sneaker":7.3431,
"sneaking":2.6360,
"sneaky":13.3682,
"sneezing":4.8954,
"sniff":203.7242,
"sniffer":9.9791,
"sniffing":11.2971,
"snip":41.0461,
"sniper":34.0796,
"snippet":22.4059,
"snooker":60.0629,
"snoop":12.0502,
"snooper":3.9540,
"snooping":1.6946,
"snoring":3.2008,
"snorkel":4.8954,
"snorkeling":0.1883,
"snort":96.0253,
"snorting":2.4477,
"snow":659.3735,
"snowball":29.5607,
"snowboard":0.5649,
"snowboarding":0.5649,
"snowfall":11.1088,
"snowflake":15.0628,
"snowing":0.3766,
"snowman":12.2385,
"snowmobile":1.1297,
"snowmobiling":0.1883,
"snowshoe":0.7531,
"snowshoeing":0.1883,
"snowy":29.7490,
"snuff":39.7281,
"snug":31.8201,
"so":43457.8361,
"soak":231.4021,
"soaked":1.8828,
"soaking":15.0628,
"soap":273.3896,
"soapbox":7.5314,
"soaps":0.3766,
"soar":215.7744,
"soaring":1.8828,
"sob":125.7743,
"sober":125.3977,
"soccer":218.9753,
"social":6646.4549,
"socialism":272.0716,
"socialist":479.9381,
"socialization":43.8704,
"socialize":20.8996,
"socializing":3.2008,
"socially":279.9796,
"societal":37.6570,
"society":3568.7509,
"socioeconomic":29.1842,
"sociological":143.8496,
"sociology":246.6531,
"sock":209.7493,
"socket":178.3057,
"sod":92.4479,
"soda":64.2051,
"sodium":146.8622,
"sodomy":7.3431,
"sofa":186.5903,
"sofas":3.7657,
"soft":1176.9685,
"softball":1.1297,
"soften":181.3183,
"softened":6.2134,
"softening":11.4854,
"softer":1.8828,
"softly":420.4401,
"softness":45.0001,
"software":1367.7011,
"soil":865.1688,
"soiled":19.9582,
"soiling":9.9791,
"soils":0.1883,
"sol":43.1172,
"solace":26.3599,
"solar":208.6196,
"solarium":22.7825,
"sold":2.6360,
"solder":38.5984,
"soldering":9.7908,
"soldier":952.9096,
"sole":405.1890,
"solely":294.4775,
"solemn":79.6445,
"solemnly":49.8955,
"solenoid":11.8619,
"soles":0.1883,
"solicit":43.3055,
"solicitation":7.7197,
"solicited":0.1883,
"soliciting":1.8828,
"solicitor":893.0350,
"solicitors":0.5649,
"solid":716.2355,
"solidarity":137.2596,
"solidify":24.2887,
"solidly":41.7992,
"solids":0.7531,
"solitaire":3.9540,
"solitary":149.4982,
"solitude":61.1926,
"solo":225.9418,
"soloist":50.0838,
"solomon":0.5649,
"solos":0.3766,
"solstice":6.0251,
"solubility":17.5105,
"soluble":62.6989,
"solute":20.1465,
"solution":1621.5091,
"solve":745.4197,
"solved":0.3766,
"solvency":12.9917,
"solvent":182.6363,
"solver":7.3431,
"solving":31.8201,
"somali":31.2553,
"somalia":0.1883,
"somatic":11.1088,
"some":30396.5166,
"somebody":1275.8181,
"someday":12.0502,
"somehow":776.8633,
"someone":3250.9261,
"someplace":3.3891,
"somerset":0.1883,
"something":9095.0993,
"sometime":124.4563,
"sometimes":3625.8012,
"somewhat":814.7085,
"somewhere":1206.9058,
"son":2570.0881,
"sonar":28.8076,
"sonata":26.5482,
"sonatas":0.3766,
"song":1169.4372,
"songbook":2.2594,
"songwriter":38.5984,
"songwriting":11.8619,
"sonic":25.0419,
"sonnet":59.4980,
"soon":3925.1741,
"soonest":0.9414,
"soot":37.0921,
"soothe":102.2387,
"soothing":32.9498,
"sop":6.9665,
"sophisticated":442.2811,
"sophistication":95.8370,
"sophomore":0.1883,
"soprano":36.3390,
"sorcerer":19.7699,
"sorcery":19.0168,
"sore":183.3894,
"sorely":30.6904,
"sorghum":7.3431,
"sorority":1.1297,
"sorrier":2.8243,
"sorriest":0.3766,
"sorrow":121.4437,
"sorry":1608.5174,
"sort":5763.2107,
"sorta":0.3766,
"sorted":1.1297,
"sorter":5.6485,
"sorting":22.9708,
"sos":1.5063,
"sot":2.0711,
"sought":2.0711,
"soul":655.2312,
"soulful":7.1548,
"sound":4159.5887,
"sounded":1.3180,
"sounding":23.1590,
"soundly":32.0084,
"soundness":16.1925,
"sounds":1.6946,
"soundtrack":38.4101,
"soup":242.6992,
"sour":139.1425,
"source":2797.5362,
"sourced":0.1883,
"sourcing":6.5900,
"soured":0.7531,
"souring":0.9414,
"sourly":24.1005,
"sous":4.1423,
"sousa":0.1883,
"south":1902.4300,
"southbound":13.1799,
"southeast":20.5230,
"southeastern":5.0837,
"southerly":17.3222,
"southern":716.8004,
"southward":16.7574,
"southwards":30.6904,
"southwest":19.3933,
"southwestern":6.4017,
"souvenir":79.2679,
"sovereign":173.9752,
"sovereignty":212.3853,
"soviet":979.2695,
"sow":157.9710,
"sowing":14.8745,
"sown":2.6360,
"soy":15.0628,
"soybean":3.5774,
"spa":33.7030,
"space":2593.4354,
"spacecraft":29.7490,
"spaced":3.5774,
"spacer":7.9080,
"spaces":0.3766,
"spaceship":37.8453,
"spacing":45.9415,
"spacious":117.3015,
"spade":85.1047,
"spaghetti":44.2469,
"spain":1.3180,
"spake":3.7657,
"spam":8.8494,
"span":261.1511,
"spandex":0.3766,
"spaniel":7.7197,
"spanish":472.7832,
"spank":11.8619,
"spanked":0.1883,
"spanking":9.4142,
"spanning":0.3766,
"spare":667.4698,
"sparing":3.2008,
"sparingly":25.2302,
"spark":256.0674,
"sparked":0.1883,
"sparking":3.0126,
"sparkle":133.8705,
"sparkling":78.8913,
"sparrow":37.8453,
"sparse":63.2637,
"sparsely":27.3013,
"spartan":32.1967,
"spat":53.2846,
"spatial":225.0004,
"spatially":22.4059,
"spawn":87.5525,
"spawning":32.3850,
"speak":4840.6150,
"speakeasy":1.3180,
"speaker":933.3280,
"speakerphone":0.1883,
"speaking":38.4101,
"speaks":0.3766,
"spear":107.1341,
"spec":38.0335,
"special":3660.0690,
"specialisation":49.1423,
"specialise":199.0171,
"specialised":162.1132,
"specialist":991.8845,
"speciality":122.1969,
"specialization":60.8160,
"specialize":76.8202,
"specialized":119.1843,
"specializing":0.1883,
"specially":372.2391,
"specials":1.1297,
"specialty":41.4227,
"species":48.2009,
"specifiable":3.0126,
"specific":2160.0037,
"specifically":666.3401,
"specification":367.9086,
"specificity":108.6404,
"specified":104.6864,
"specify":787.9721,
"specifying":0.5649,
"specimen":430.9840,
"specimens":0.1883,
"speck":32.1967,
"spectacle":212.3853,
"spectacles":0.3766,
"spectacular":344.7495,
"spectator":189.7911,
"specter":0.3766,
"spectral":33.8913,
"spectre":47.4478,
"spectrometer":17.1339,
"spectrometry":10.1674,
"spectroscopic":4.3306,
"spectroscopy":29.7490,
"spectrum":276.2139,
"speculate":143.4730,
"speculation":332.8876,
"speculative":122.0086,
"sped":0.1883,
"speech":1531.1323,
"speechless":34.4561,
"speed":1772.8901,
"speedily":39.9164,
"speeding":20.1465,
"speedup":0.1883,
"speedway":11.8619,
"speedy":88.6822,
"spell":669.5409,
"spelling":191.1091,
"spelt":10.7322,
"spencer":2.0711,
"spend":3985.9901,
"spending":784.3947,
"spent":1.5063,
"sperm":83.5985,
"spf":0.3766,
"sphere":309.3520,
"spheres":0.1883,
"spherical":33.1381,
"spherically":2.8243,
"sphinx":3.2008,
"spice":122.9500,
"spiced":10.3557,
"spicy":33.8913,
"spider":176.6112,
"spiel":5.8368,
"spielberg":0.5649,
"spike":106.0044,
"spiked":5.4603,
"spill":267.9293,
"spilling":4.1423,
"spin":463.5573,
"spinach":31.6319,
"spinal":67.7825,
"spindle":32.3850,
"spine":259.2682,
"spinner":83.5985,
"spinning":55.5440,
"spiral":184.1426,
"spire":74.1842,
"spires":0.1883,
"spirit":1101.2780,
"spirited":70.4185,
"spirits":0.3766,
"spiritual":414.4149,
"spirituality":40.1047,
"spiritually":31.4436,
"spit":175.4815,
"spite":527.5741,
"spitfire":20.5230,
"spitting":12.4268,
"splash":213.7033,
"splashed":0.1883,
"splashing":10.9205,
"spleen":26.7364,
"splendid":288.2641,
"splendidly":31.4436,
"splendor":0.9414,
"splendour":64.9583,
"splice":28.0544,
"splicing":13.5565,
"spline":3.0126,
"splinter":67.0294,
"split":827.8884,
"splits":0.1883,
"splitter":6.0251,
"splitting":47.4478,
"spoil":256.8205,
"spoiled":21.2762,
"spoiler":8.4728,
"spoiling":2.2594,
"spoke":21.8410,
"spoken":14.8745,
"spokesman":761.2356,
"spokesperson":49.1423,
"spokeswoman":112.2178,
"sponge":122.0086,
"sponsor":639.4153,
"sponsored":3.5774,
"sponsoring":1.6946,
"sponsors":1.1297,
"sponsorship":213.8916,
"spontaneous":177.7409,
"spontaneously":81.3391,
"spoof":13.1799,
"spooky":22.2176,
"spool":16.5691,
"spoon":197.6991,
"spoonful":27.3013,
"sporadic":61.7574,
"spore":37.2804,
"sport":1272.4290,
"sporting":196.9459,
"sports":1.6946,
"sportsman":80.7742,
"sportswear":11.4854,
"sporty":15.8159,
"spot":1454.8770,
"spotlight":88.4939,
"spots":0.7531,
"spotted":0.9414,
"spotting":5.4603,
"spousal":0.7531,
"spouse":154.2053,
"spout":39.7281,
"sprang":0.1883,
"sprawl":99.6027,
"sprawling":5.0837,
"spray":325.1679,
"spraying":12.6151,
"spread":1434.7305,
"spreading":16.9456,
"spreadsheet":148.9333,
"spree":35.5858,
"spring":1254.3536,
"springer":3.0126,
"springing":4.8954,
"springs":0.1883,
"springtime":15.4394,
"sprinkle":94.7073,
"sprinkled":2.4477,
"sprinkler":23.5356,
"sprint":80.5859,
"sprite":12.0502,
"spruce":39.7281,
"sprung":10.3557,
"spun":4.7071,
"spur":214.6447,
"spurious":48.7658,
"spurred":0.9414,
"spy":233.6615,
"spying":9.6025,
"squad":439.0803,
"squadron":110.8998,
"squamous":13.9331,
"square":1180.9225,
"squared":11.4854,
"squarely":45.3766,
"squareness":0.9414,
"squarer":2.6360,
"squash":111.8412,
"squat":142.5316,
"squaw":3.7657,
"squeak":63.2637,
"squeeze":409.5195,
"squeezing":4.1423,
"squid":30.6904,
"squire":55.3557,
"squirrel":58.5566,
"squirt":36.9038,
"squirting":0.1883,
"squish":1.6946,
"sr":0.3766,
"ss":8.8494,
"ssa":0.5649,
"sse":0.5649,
"sss":0.1883,
"stab":251.9251,
"stabbing":18.2636,
"stabilisation":17.6988,
"stabilise":75.6905,
"stabilised":1.6946,
"stabilising":0.5649,
"stability":373.9337,
"stabilization":24.1005,
"stabilize":56.2972,
"stabilized":1.5063,
"stabilizer":6.7783,
"stabilizing":0.1883,
"stable":746.1728,
"stack":278.4733,
"stacked":0.1883,
"stacker":3.5774,
"stacking":11.8619,
"stadium":104.8747,
"staff":3949.6511,
"staffing":129.7283,
"stag":51.2135,
"stage":3928.7515,
"staged":1.5063,
"staggered":8.2845,
"staggering":88.3056,
"staging":53.0963,
"stagnant":39.5398,
"stagnation":30.6904,
"stain":407.6367,
"stained":5.8368,
"staining":70.6068,
"stainless":56.6737,
"stair":654.4781,
"staircase":181.1300,
"stairs":0.9414,
"stairway":43.8704,
"stake":514.0176,
"stakeholder":14.3096,
"stale":70.7951,
"stalin":0.9414,
"stalk":160.6070,
"stalker":7.1548,
"stalking":2.8243,
"stall":321.7788,
"stalled":0.9414,
"stallion":57.0503,
"stamina":64.5817,
"stamp":518.3482,
"stamped":3.2008,
"stampede":15.4394,
"stamping":16.1925,
"stance":302.0089,
"stand":6425.0319,
"standalone":6.2134,
"standard":3638.2280,
"standardisation":31.2553,
"standardised":61.7574,
"standardization":20.1465,
"standardize":19.9582,
"standardized":27.4896,
"standby":57.6152,
"standing":302.3855,
"standish":1.3180,
"standoff":2.0711,
"standout":0.7531,
"standpoint":61.5691,
"stands":2.2594,
"standstill":45.3766,
"stanford":0.3766,
"stanley":0.1883,
"stanton":0.1883,
"stanza":31.4436,
"staphylococcus":0.9414,
"staple":80.5859,
"star":1809.6056,
"starboard":31.2553,
"starch":36.9038,
"stardom":24.6653,
"stardust":2.6360,
"stare":1467.3038,
"starfish":16.7574,
"staring":1.6946,
"stark":119.1843,
"starlight":8.4728,
"starling":29.7490,
"starring":1.5063,
"starry":18.2636,
"stars":0.5649,
"start":8923.9484,
"started":3.3891,
"starter":126.9040,
"starting":272.0716,
"startled":96.2136,
"startling":108.6404,
"starts":0.1883,
"starvation":84.3516,
"starve":235.7326,
"starved":0.3766,
"starving":7.3431,
"stash":17.1339,
"stat":19.2051,
"state":7925.6621,
"stated":4.7071,
"stately":67.4060,
"statement":2419.8368,
"states":0.1883,
"statesman":57.0503,
"statewide":1.1297,
"static":214.8330,
"statically":2.2594,
"stating":1.1297,
"station":2219.1251,
"stationary":72.4897,
"stationery":57.4269,
"statistic":539.2478,
"statistical":319.3311,
"statistically":89.8119,
"statistician":26.1716,
"statistics":1.8828,
"statue":239.4983,
"stature":72.4897,
"status":1633.9359,
"statute":350.0215,
"statutory":643.5576,
"staunch":46.1298,
"stay":3631.8263,
"stayed":3.5774,
"staying":17.8871,
"stays":1.5063,
"std":4.3306,
"stead":32.0084,
"steadfast":9.2260,
"steadied":0.1883,
"steadily":292.2181,
"steady":560.7123,
"steadying":6.7783,
"steak":109.0169,
"steakhouse":0.7531,
"steal":979.4577,
"stealing":20.8996,
"stealth":18.6402,
"steam":577.2813,
"steamboat":5.0837,
"steamed":7.5314,
"steamer":55.7323,
"steaming":32.1967,
"steamy":21.4645,
"steed":13.1799,
"steel":649.3944,
"steele":0.1883,
"steely":25.4185,
"steep":340.7956,
"steeped":3.3891,
"steeper":0.5649,
"steepness":5.2720,
"steer":193.9334,
"steering":158.5358,
"stein":3.0126,
"steiner":0.1883,
"stellar":16.7574,
"stem":518.1599,
"stemmed":1.6946,
"stemming":2.8243,
"stems":0.3766,
"stench":48.5775,
"stencil":25.6067,
"step":3468.7716,
"stephen":3.2008,
"stephenson":1.3180,
"stepped":1.5063,
"stepping":65.3348,
"steps":1.8828,
"stereo":95.0838,
"stereotype":116.1717,
"stereotypical":21.6528,
"sterile":69.6654,
"sterilization":6.7783,
"sterling":277.1553,
"stern":122.9500,
"steroid":67.4060,
"stetson":2.2594,
"stevenson":0.1883,
"stew":81.3391,
"steward":195.8162,
"stewardship":22.4059,
"stewart":1.3180,
"stick":1721.4883,
"sticker":72.8662,
"sticking":13.7448,
"sticky":148.3685,
"stiff":304.8332,
"stiffen":86.7993,
"stiffened":2.0711,
"stiffening":8.8494,
"stiffer":3.0126,
"stiffness":41.6110,
"stifle":110.5232,
"stigma":50.0838,
"still":13160.1690,
"stiller":0.9414,
"stillest":0.3766,
"stillness":63.6403,
"stimulant":28.0544,
"stimulate":478.6201,
"stimulated":0.9414,
"stimulating":40.2930,
"stimulation":149.1216,
"stimuli":0.7531,
"stimulus":431.9254,
"sting":182.6363,
"stinger":1.1297,
"stinging":21.6528,
"stingray":1.8828,
"stink":87.5525,
"stint":48.0126,
"stipend":16.1925,
"stipulate":102.9918,
"stipulation":32.0084,
"stir":488.0343,
"stirred":0.1883,
"stirring":35.9624,
"stitch":389.5613,
"stitched":2.4477,
"stitches":0.3766,
"stitching":28.8076,
"stochastic":14.6862,
"stock":1699.8356,
"stocked":5.8368,
"stockholder":7.5314,
"stocking":168.5149,
"stockpile":34.2678,
"stoke":24.2887,
"stoker":3.9540,
"stole":4.3306,
"stolen":5.6485,
"stomach":562.5951,
"stomp":22.9708,
"stomping":1.5063,
"stone":1923.3297,
"stoned":2.0711,
"stonehenge":0.3766,
"stones":1.8828,
"stonewall":3.2008,
"stoneware":4.3306,
"stoning":1.3180,
"stony":54.9792,
"stood":4.1423,
"stool":199.2054,
"stop":4939.8411,
"stopped":0.7531,
"stopper":25.7950,
"stopping":19.7699,
"stops":0.3766,
"storage":504.4151,
"store":1630.9233,
"stored":0.9414,
"storefront":1.3180,
"stores":0.1883,
"storey":189.9794,
"storing":6.9665,
"stork":12.4268,
"storm":600.2521,
"storming":17.6988,
"storms":0.9414,
"stormy":59.8746,
"story":3189.9218,
"storybook":3.3891,
"storyline":21.2762,
"storyteller":16.9456,
"storytelling":9.4142,
"stout":93.3893,
"stove":137.6362,
"stow":31.0670,
"straight":1795.2960,
"straighten":164.3727,
"straightened":0.9414,
"straightening":4.8954,
"straightens":0.1883,
"straighter":7.1548,
"straightforward":357.3646,
"strain":715.6707,
"strained":77.0085,
"straining":6.4017,
"strains":0.5649,
"strait":37.8453,
"strand":358.3061,
"stranded":3.5774,
"strange":1179.2280,
"strangely":177.3643,
"strangeness":24.6653,
"stranger":400.1053,
"strangest":0.3766,
"strap":207.3016,
"strapless":4.3306,
"strapped":28.4310,
"strapping":3.5774,
"strasbourg":0.1883,
"strata":68.1591,
"strategic":501.0260,
"strategically":47.6361,
"strategist":25.6067,
"strategy":1545.2537,
"stratification":65.8997,
"stratified":14.8745,
"stratosphere":31.0670,
"stratum":29.7490,
"stratus":1.3180,
"strauss":0.3766,
"straw":254.7494,
"strawberry":95.6487,
"stray":158.3476,
"streak":136.8831,
"stream":664.6455,
"streaming":29.1842,
"streamline":36.7155,
"streamlined":28.6193,
"streamlining":4.5188,
"streams":0.1883,
"street":2301.4056,
"streisand":0.1883,
"strength":1460.7138,
"strengthen":527.1976,
"strengthening":41.9875,
"strengthens":0.3766,
"strenuous":55.7323,
"strep":0.1883,
"streptococcus":1.8828,
"stress":1549.5842,
"stressed":28.0544,
"stressful":63.0754,
"stressing":1.8828,
"stretch":1059.8554,
"stretched":7.5314,
"stretcher":42.3641,
"stretching":35.2093,
"strewn":0.1883,
"stricken":98.0964,
"strict":426.6535,
"stricter":0.3766,
"strictest":0.9414,
"strictly":346.6324,
"strictness":3.5774,
"stride":324.7914,
"strider":3.0126,
"strides":0.1883,
"strife":53.4729,
"strike":2191.4473,
"striker":304.4566,
"strikes":1.3180,
"striking":276.7787,
"strikingly":60.6277,
"string":833.3487,
"stringed":5.6485,
"stringent":88.6822,
"stringer":8.2845,
"stringing":2.2594,
"strip":702.3025,
"stripe":171.9041,
"striped":63.4520,
"striping":4.3306,
"stripped":0.9414,
"stripper":24.8536,
"stripping":12.4268,
"strive":150.6279,
"striving":10.1674,
"strobe":8.0962,
"stroke":583.1182,
"stroked":1.1297,
"stroking":3.2008,
"stroll":195.6280,
"stroller":3.7657,
"strolling":0.5649,
"strong":3629.1903,
"stronger":0.3766,
"strongest":0.1883,
"stronghold":59.4980,
"strongly":827.7002,
"struck":0.1883,
"structural":477.3021,
"structurally":35.0210,
"structure":3386.1146,
"structured":146.4856,
"structures":3.5774,
"structuring":27.1130,
"struggle":1467.8686,
"struggling":2.8243,
"strung":0.9414,
"strut":50.8369,
"stuart":1.8828,
"stub":45.1884,
"stubborn":72.6779,
"stucco":18.8285,
"stuck":80.9625,
"stud":132.7408,
"studded":12.2385,
"student":3763.4374,
"studied":0.9414,
"studio":513.6410,
"studios":0.1883,
"study":6924.3633,
"studying":2.6360,
"stuff":1425.3163,
"stuffed":27.8662,
"stuffing":32.3850,
"stumble":226.3184,
"stumbling":3.5774,
"stump":112.7826,
"stumped":0.5649,
"stumps":0.1883,
"stun":98.0964,
"stung":3.0126,
"stunned":63.4520,
"stunning":166.0672,
"stunt":70.9834,
"stupendous":18.6402,
"stupid":557.5114,
"stupider":0.1883,
"stupidity":53.6612,
"stupidly":25.6067,
"sturdy":80.7742,
"sturgeon":3.7657,
"stuttgart":0.1883,
"style":2607.1802,
"styled":0.1883,
"styles":1.8828,
"styling":62.3223,
"stylise":2.0711,
"stylised":13.5565,
"stylish":90.7533,
"stylist":30.1256,
"stylistic":113.3475,
"stylize":3.2008,
"stylized":10.1674,
"stylus":13.5565,
"styrene":3.7657,
"styx":0.1883,
"su":0.5649,
"sub":962.1355,
"subcategory":0.5649,
"subclass":16.7574,
"subcommittee":33.3264,
"subconscious":53.6612,
"subcontract":21.2762,
"subcontracting":9.4142,
"subcontractor":34.4561,
"subcutaneous":14.4979,
"subdivision":45.3766,
"subdued":39.1632,
"subfamily":7.7197,
"subgroup":47.0712,
"subheading":4.3306,
"subject":5334.1096,
"subjective":208.2430,
"subjectivity":65.5231,
"sublime":41.2344,
"subliminal":10.3557,
"submarine":138.9542,
"submerged":25.4185,
"submission":274.3310,
"submissive":25.2302,
"submit":684.9803,
"submitter":2.4477,
"submitting":0.3766,
"subordinate":253.4314,
"subordinated":12.9917,
"subordination":45.1884,
"subpoena":13.9331,
"subroutine":19.7699,
"subs":16.7574,
"subscribe":133.8705,
"subscribed":2.6360,
"subscriber":100.7324,
"subscribing":0.1883,
"subscript":10.9205,
"subscription":199.2054,
"subsection":106.1927,
"subsequent":771.4030,
"subsequently":638.4739,
"subset":58.1800,
"subsidiary":411.0258,
"subsidise":77.9499,
"subsidised":22.5942,
"subsidising":0.7531,
"subsidize":40.2930,
"subsidized":10.3557,
"subsidizing":0.5649,
"subsidy":333.8290,
"subsistence":83.7868,
"subspace":0.3766,
"substance":633.2019,
"substances":0.5649,
"substandard":11.4854,
"substantial":1112.9517,
"substantially":305.9629,
"substantiate":57.4269,
"substantiated":0.3766,
"substantive":100.9207,
"substitute":524.9381,
"substituted":4.5188,
"substituting":0.7531,
"substitution":134.6237,
"substrate":75.1257,
"subsurface":12.9917,
"subsystem":34.4561,
"subsystems":0.1883,
"subterranean":26.7364,
"subtitle":32.1967,
"subtitled":0.7531,
"subtle":326.2976,
"subtlety":65.3348,
"subtly":64.3934,
"subtotal":3.7657,
"subtract":57.8034,
"subtracted":0.1883,
"subtracting":1.1297,
"subtraction":20.1465,
"subtropical":6.9665,
"subtype":15.6276,
"subunit":57.8034,
"suburb":191.1091,
"suburban":108.2638,
"subversion":41.4227,
"subversive":62.8871,
"subway":28.0544,
"succeed":1001.2988,
"succeeding":1.3180,
"success":2554.2722,
"successful":1931.4259,
"successfully":601.7584,
"succession":319.1428,
"successive":327.4273,
"successively":29.5607,
"successor":337.0299,
"successors":0.1883,
"succinct":18.2636,
"succulent":22.4059,
"succumb":94.8956,
"such":19259.8448,
"suck":288.0758,
"sucked":0.1883,
"sucker":38.7867,
"sucking":9.7908,
"sucre":2.0711,
"sucrose":9.4142,
"suction":22.7825,
"sudanese":29.3724,
"sudden":760.1059,
"suddenly":2010.5055,
"suddenness":13.1799,
"sue":287.6992,
"suede":39.1632,
"suez":0.3766,
"suffer":2243.2256,
"suffered":0.1883,
"suffering":273.5779,
"suffice":115.4186,
"sufficiency":57.8034,
"sufficient":1095.8178,
"sufficiently":446.6116,
"suffix":39.5398,
"suffrage":63.4520,
"sufi":0.1883,
"sugar":644.6873,
"sugary":18.6402,
"suggest":5147.5193,
"suggested":26.7364,
"suggesting":2.2594,
"suggestion":928.9974,
"suggestive":54.0377,
"suggests":0.3766,
"suicidal":43.8704,
"suicide":325.7328,
"suing":0.1883,
"suit":1338.7052,
"suitability":64.7700,
"suitable":1083.9558,
"suitably":129.1634,
"suitcase":131.2345,
"suite":286.1930,
"suited":123.3266,
"suiting":1.5063,
"suits":0.1883,
"sulfate":2.2594,
"sulfide":0.5649,
"sulfur":1.3180,
"sully":9.4142,
"sulphate":77.0085,
"sulphur":140.6488,
"sultan":19.5816,
"sultry":20.3348,
"sum":1242.4917,
"summarily":21.6528,
"summarisation":0.1883,
"summarise":189.9794,
"summarised":0.1883,
"summarising":2.0711,
"summarize":131.9877,
"summarizing":2.8243,
"summary":403.6827,
"summation":17.3222,
"summed":0.5649,
"summer":1938.7690,
"summertime":14.4979,
"summing":20.5230,
"summit":424.7706,
"summon":366.2140,
"summoned":0.1883,
"summons":28.2427,
"sumo":4.3306,
"sump":13.5565,
"sumptuous":39.1632,
"sun":1314.7931,
"sunbeam":7.9080,
"sunbelt":0.3766,
"sunburst":25.2302,
"sunday":26.7364,
"sundays":0.1883,
"sundry":27.8662,
"sunflower":27.4896,
"sunflowers":0.1883,
"sung":1.5063,
"sunk":3.0126,
"sunken":33.8913,
"sunless":6.2134,
"sunlight":212.5736,
"sunni":6.4017,
"sunny":181.1300,
"sunrise":36.7155,
"sunroof":11.1088,
"sunscreen":13.7448,
"sunset":84.3516,
"sunshine":210.5025,
"sup":18.6402,
"super":279.7913,
"superannuation":15.6276,
"superb":362.4483,
"superbly":68.9123,
"supercomputer":28.2427,
"supercomputing":6.7783,
"superconducting":1.5063,
"superficial":136.8831,
"superfluous":40.8578,
"superfund":0.1883,
"superhero":3.9540,
"superimposed":0.7531,
"superintendent":81.9039,
"superior":424.7706,
"superiority":137.6362,
"superiors":0.1883,
"superman":7.9080,
"supermarket":288.4524,
"supermodel":11.1088,
"supernatural":63.4520,
"supernova":11.1088,
"superpower":46.3181,
"supersede":85.4813,
"superstar":50.8369,
"superstition":53.8495,
"superstore":36.7155,
"supervise":249.8540,
"supervised":12.8034,
"supervising":1.6946,
"supervision":294.1009,
"supervisor":180.9417,
"supervisory":70.4185,
"supper":253.4314,
"supple":31.6319,
"supplement":442.0928,
"supplemental":12.0502,
"supplementary":160.0421,
"supplementation":27.6779,
"supplemented":0.5649,
"supplementing":0.1883,
"supplements":0.1883,
"supplier":567.1139,
"supply":3019.7123,
"supplying":6.9665,
"support":7264.0292,
"supported":2.6360,
"supporter":775.3570,
"supporting":2.6360,
"supportive":144.6028,
"supports":0.1883,
"suppose":3053.7918,
"supposed":3.9540,
"supposedly":170.2095,
"supposing":4.3306,
"supposition":30.8787,
"suppress":275.6490,
"suppressant":3.3891,
"suppressed":3.3891,
"suppresses":0.3766,
"suppressing":0.1883,
"suppression":86.0462,
"suppressor":15.2511,
"supra":12.8034,
"supremacy":75.5022,
"supreme":120.8789,
"surcharge":30.3139,
"sure":4186.1369,
"surely":1094.8764,
"sureness":5.4603,
"surer":8.2845,
"surest":0.3766,
"surety":44.0587,
"surf":60.6277,
"surface":1912.7857,
"surfaced":0.5649,
"surfacing":7.9080,
"surfactant":10.3557,
"surfer":33.1381,
"surfing":33.5147,
"surge":231.9669,
"surgeon":261.7159,
"surgery":499.1431,
"surgical":142.1551,
"surgically":13.1799,
"surging":1.6946,
"surname":76.6319,
"surpass":59.4980,
"surplus":451.8836,
"surprise":1148.7258,
"surprised":748.9971,
"surprising":624.3525,
"surprisingly":462.4276,
"surreal":21.6528,
"surrender":308.0340,
"surrendered":1.5063,
"surrey":0.7531,
"surrogate":32.3850,
"surround":1119.1651,
"surrounded":0.1883,
"surrounding":228.0129,
"surveillance":133.4940,
"survey":1753.4967,
"surveying":20.5230,
"surveyor":162.6781,
"surveyors":0.1883,
"surveys":0.5649,
"survival":545.6495,
"survive":1474.4586,
"survived":0.3766,
"survives":0.1883,
"surviving":6.5900,
"survivor":192.6154,
"susceptibility":42.9289,
"susceptible":122.5734,
"sushi":3.0126,
"suspect":1010.5247,
"suspected":2.6360,
"suspecting":1.1297,
"suspend":518.5365,
"suspended":1.1297,
"suspending":0.9414,
"suspense":36.7155,
"suspension":266.0465,
"suspicion":390.6910,
"suspicious":240.8163,
"suspiciously":64.0168,
"sussex":2.6360,
"sustain":570.5031,
"sustainability":19.5816,
"sustainable":117.4897,
"sustained":116.9249,
"sustaining":4.8954,
"sustenance":22.2176,
"suture":28.4310,
"sw":0.3766,
"swahili":2.6360,
"swain":3.7657,
"swallow":434.1848,
"swallowing":5.0837,
"swam":15.0628,
"swami":0.1883,
"swamp":119.1843,
"swamps":0.9414,
"swan":82.6570,
"swank":1.1297,
"swansea":0.7531,
"swap":215.3979,
"swapping":5.6485,
"swarm":70.4185,
"swat":12.2385,
"swatch":13.5565,
"swath":3.9540,
"sway":188.8497,
"swaying":3.9540,
"swaziland":0.1883,
"swear":420.2518,
"swearing":19.5816,
"sweat":324.7914,
"sweated":0.7531,
"sweater":129.3517,
"sweating":28.2427,
"sweatshirt":29.1842,
"sweaty":37.2804,
"sweden":0.9414,
"swedish":145.7325,
"sweep":687.9928,
"sweeper":36.3390,
"sweeping":96.7784,
"sweet":765.9427,
"sweetened":2.4477,
"sweeter":0.7531,
"sweetest":2.2594,
"sweetheart":61.7574,
"sweetie":22.2176,
"sweetly":56.8620,
"sweetness":53.6612,
"swell":201.8414,
"swelled":0.1883,
"swelling":47.8243,
"swift":159.2890,
"swiftly":214.6447,
"swim":465.6284,
"swimmer":55.1675,
"swimming":365.4609,
"swims":6.7783,
"swimsuit":22.0293,
"swimwear":4.1423,
"swine":41.4227,
"swing":721.1309,
"swinger":6.4017,
"swinging":10.5440,
"swipe":26.1716,
"swirl":115.4186,
"swirling":2.0711,
"swish":32.7616,
"swiss":172.4689,
"switch":1223.6632,
"switchboard":45.5649,
"switcher":1.3180,
"switches":0.5649,
"switching":60.6277,
"switzerland":0.3766,
"swivel":75.3139,
"swollen":123.5149,
"swoop":97.1550,
"sword":293.5361,
"swore":0.1883,
"sworn":0.3766,
"swot":9.7908,
"swum":8.2845,
"swung":0.9414,
"sycamore":19.5816,
"syllable":167.5735,
"syllabus":144.4145,
"symbol":550.7332,
"symbolic":246.8414,
"symbolically":32.9498,
"symbolise":59.1214,
"symbolising":0.3766,
"symbolism":68.1591,
"symbolize":59.1214,
"symmetric":64.7700,
"symmetrical":60.4394,
"symmetry":146.8622,
"sympathetic":270.7536,
"sympathetically":50.8369,
"sympathy":419.6869,
"symphonic":9.7908,
"symphony":69.2888,
"symposium":35.0210,
"symptom":665.7752,
"symptomatic":64.7700,
"synagogue":26.7364,
"synapse":15.6276,
"synaptic":20.7113,
"sync":4.3306,
"synchronisation":5.8368,
"synchronization":5.6485,
"synchronize":13.9331,
"synchronizing":0.3766,
"synchronous":16.3808,
"synchrotron":5.4603,
"syndicate":74.9374,
"syndication":3.9540,
"syndrome":203.5359,
"synergistic":5.4603,
"synergy":19.7699,
"synod":9.9791,
"synonym":62.1340,
"synonymous":68.3474,
"synonyms":0.1883,
"synopsis":15.2511,
"syntactic":143.6613,
"syntax":93.9541,
"synthesis":211.2556,
"synthesize":34.0796,
"synthesized":0.1883,
"synthesizer":8.2845,
"synthetic":139.8956,
"syphilis":2.2594,
"syrian":91.3181,
"syringe":35.0210,
"syrup":43.8704,
"system":10126.1471,
"systematic":304.4566,
"systematically":132.9291,
"systemic":54.2260,
"systems":17.5105,
"systolic":9.6025,
"t":1083.2027,
"ta":80.5859,
"tab":76.8202,
"tabernacle":12.0502,
"table":3422.0770,
"tableau":35.0210,
"tablecloth":44.2469,
"tabled":0.1883,
"tables":2.6360,
"tablespoon":46.3181,
"tablet":222.5527,
"tabletop":5.8368,
"tablets":1.1297,
"tableware":14.4979,
"tabloid":115.4186,
"taboo":76.6319,
"tabor":0.7531,
"tabs":0.1883,
"tabular":18.6402,
"tabulation":12.9917,
"tacit":49.5189,
"tack":141.7785,
"tackle":674.2480,
"tackled":1.5063,
"tackles":0.1883,
"tackling":9.4142,
"tacky":20.5230,
"taco":6.0251,
"tact":41.7992,
"tactic":321.4022,
"tactical":115.0420,
"tactile":25.6067,
"tad":7.5314,
"tag":212.5736,
"tagalog":0.1883,
"tagged":0.3766,
"tagging":6.5900,
"tags":0.9414,
"tahiti":0.1883,
"tahitian":1.5063,
"tai":0.1883,
"tail":712.6581,
"tailed":6.7783,
"tailgate":2.6360,
"tailor":220.6698,
"tailored":0.9414,
"tailoring":12.9917,
"tails":0.1883,
"tainted":0.7531,
"taiwan":0.1883,
"taiwanese":26.3599,
"tajikistan":0.1883,
"take":31718.4645,
"taken":4.7071,
"takeoff":4.1423,
"takeover":251.5485,
"taker":55.9206,
"takes":4.1423,
"taking":208.2430,
"tala":0.1883,
"tale":569.5616,
"talent":531.9047,
"talented":147.4270,
"tales":3.7657,
"talisman":10.7322,
"talk":7217.3346,
"talked":0.7531,
"talking":56.8620,
"talks":0.3766,
"tall":909.0392,
"taller":0.7531,
"tallest":0.5649,
"tally":66.2763,
"talon":28.2427,
"tam":1.8828,
"tame":92.4479,
"tamed":0.3766,
"tamil":12.0502,
"taming":3.3891,
"tammy":0.3766,
"tamoxifen":0.7531,
"tamper":44.2469,
"tampering":6.7783,
"tampon":15.6276,
"tan":110.7115,
"tandem":35.0210,
"tandy":1.5063,
"tang":15.8159,
"tangent":22.2176,
"tangerine":9.9791,
"tangible":108.0755,
"tangle":148.9333,
"tangled":4.8954,
"tango":7.1548,
"tank":853.6835,
"tanker":107.5106,
"tanned":26.9247,
"tanner":10.3557,
"tanning":14.3096,
"tanzanian":7.5314,
"tap":654.2898,
"tapas":3.2008,
"tape":1301.8014,
"taped":0.1883,
"taper":54.9792,
"tapered":12.8034,
"tapestry":69.2888,
"taping":6.7783,
"tapping":26.1716,
"tar":64.3934,
"tara":0.3766,
"target":1795.8608,
"targeted":4.3306,
"targeting":18.4519,
"targets":4.1423,
"tariff":207.8665,
"tarot":8.4728,
"tarpon":0.3766,
"tart":70.9834,
"tartan":43.3055,
"task":2207.4515,
"tasking":6.7783,
"tasman":0.3766,
"tasmanian":3.3891,
"taste":1015.6084,
"tasteful":20.7113,
"tastefully":19.3933,
"tasteless":19.7699,
"tastes":0.1883,
"tasting":22.9708,
"tasty":70.0420,
"tat":22.2176,
"tate":2.0711,
"tattoo":56.6737,
"tattooed":3.3891,
"tau":8.8494,
"taught":0.3766,
"taupe":1.5063,
"taurus":0.9414,
"tavern":56.4855,
"tawny":24.6653,
"tax":3246.5955,
"taxable":68.5357,
"taxation":424.9589,
"taxed":0.1883,
"taxi":391.6325,
"taxing":21.4645,
"taxis":475.9841,
"taxonomic":31.2553,
"taxonomy":26.1716,
"taxpayer":258.7034,
"taylor":6.9665,
"tb":20.7113,
"tbilisi":0.5649,
"tc":5.4603,
"tchaikovsky":1.3180,
"te":5.4603,
"tea":1551.4671,
"teach":1737.1160,
"teacher":3648.9602,
"teachers":0.1883,
"teaches":0.1883,
"teaching":1224.6046,
"teak":21.2762,
"teal":6.9665,
"team":4109.5050,
"teaming":0.9414,
"teammate":11.1088,
"teams":0.7531,
"teamwork":42.5524,
"teapot":47.6361,
"tear":1371.6551,
"tearing":4.8954,
"tears":0.1883,
"teas":0.1883,
"tease":205.4188,
"teaser":9.7908,
"teasing":16.7574,
"teaspoon":41.4227,
"tech":140.8371,
"techie":2.2594,
"technical":1130.0856,
"technically":178.8706,
"technician":133.3057,
"technique":1812.0533,
"techniques":2.6360,
"techno":33.7030,
"technological":294.2892,
"technologically":20.1465,
"technologist":23.3473,
"technology":1933.1205,
"tectonic":49.3306,
"ted":1.1297,
"teddy":28.8076,
"tedious":92.0713,
"tee":126.1508,
"teen":90.3767,
"teenage":182.2597,
"teenager":319.7077,
"teenagers":0.1883,
"teens":0.7531,
"teeny":9.6025,
"tees":0.1883,
"teeth":2.6360,
"teflon":2.6360,
"tehran":0.3766,
"telecom":8.2845,
"telecommunication":124.0797,
"telecommunications":38.9750,
"telecoms":3.9540,
"teleconference":0.7531,
"telegram":66.2763,
"telegraph":47.4478,
"telegraphing":0.3766,
"telegraphs":1.3180,
"telemarketing":4.7071,
"telemetry":3.0126,
"telephone":1603.4337,
"telephoned":0.3766,
"telephoning":4.3306,
"telephony":8.2845,
"telephoto":6.7783,
"telescope":105.8161,
"telescopic":13.1799,
"teletext":19.9582,
"televised":0.7531,
"television":1657.6597,
"telex":35.2093,
"tell":13405.1276,
"teller":46.6946,
"telling":71.3600,
"tells":0.1883,
"telnet":0.1883,
"temp":15.2511,
"temper":354.7286,
"temperament":114.2889,
"temperate":69.2888,
"temperature":906.0267,
"tempered":1.5063,
"tempest":8.8494,
"templar":6.5900,
"template":82.0922,
"temple":307.6574,
"temples":0.5649,
"tempo":63.6403,
"temporal":108.0755,
"temporarily":226.5067,
"temporary":680.4614,
"temps":0.1883,
"tempt":291.0884,
"temptation":221.4230,
"tempting":97.7198,
"ten":3728.9813,
"tenacious":20.1465,
"tenancy":137.4479,
"tenant":738.0766,
"tend":2111.8028,
"tendency":638.8505,
"tender":389.5613,
"tendering":34.0796,
"tenderloin":0.5649,
"tenderly":36.9038,
"tenderness":67.4060,
"tending":1.5063,
"tendon":21.0879,
"tends":0.3766,
"tenet":41.6110,
"tennis":419.8752,
"tenor":67.0294,
"tens":0.7531,
"tense":278.8499,
"tensely":8.4728,
"tenser":0.3766,
"tensile":19.2051,
"tension":756.9051,
"tensor":44.4352,
"tent":275.6490,
"tentacle":106.7575,
"tentative":103.1801,
"tentatively":63.0754,
"tented":4.7071,
"tenth":248.3477,
"tenuous":43.4938,
"tenure":128.4103,
"tenured":1.3180,
"tequila":3.2008,
"term":8311.4578,
"termed":0.3766,
"terminal":487.0929,
"terminally":29.5607,
"terminate":207.8665,
"terminated":0.5649,
"terminating":4.3306,
"termination":96.7784,
"terminator":5.4603,
"terminology":122.0086,
"terminus":52.5315,
"termite":30.8787,
"termites":0.3766,
"terms":0.1883,
"tern":29.7490,
"terrace":398.7873,
"terraced":0.7531,
"terrain":112.9709,
"terrestrial":54.7909,
"terrible":779.4992,
"terribly":212.5736,
"terrier":46.6946,
"terrific":110.7115,
"terrified":139.1425,
"terrifying":105.2512,
"territorial":168.7032,
"territory":736.3820,
"terror":272.2599,
"terrorism":120.5023,
"terrorist":296.3603,
"terry":3.2008,
"tertiary":44.0587,
"tesla":0.1883,
"test":3825.3831,
"testament":34.6444,
"tested":0.7531,
"tester":32.0084,
"testicular":6.5900,
"testify":95.8370,
"testimonial":30.6904,
"testimony":139.1425,
"testing":462.0510,
"testis":15.2511,
"testosterone":10.7322,
"tet":0.7531,
"tetanus":25.4185,
"tetra":7.5314,
"texan":1.6946,
"texas":3.0126,
"text":1761.5930,
"textbook":157.4061,
"textile":216.3393,
"textiles":0.9414,
"texts":0.9414,
"textual":69.6654,
"texture":211.4439,
"textured":34.8327,
"th":134.0588,
"thai":17.8871,
"thames":0.1883,
"than":26150.8817,
"thane":2.4477,
"thang":0.1883,
"thank":2623.1844,
"thankful":66.6528,
"thankfully":90.5650,
"thanking":0.1883,
"thanks":2.8243,
"thanksgiving":21.2762,
"that":200411.7036,
"thatcher":7.3431,
"thaw":53.2846,
"thc":0.9414,
"the":1086902.8687,
"theater":1.1297,
"theatre":806.9888,
"theatrical":109.9583,
"thee":87.9290,
"theft":321.4022,
"their":46193.6148,
"theirs":153.6404,
"them":3.7657,
"thematic":60.6277,
"thematically":5.0837,
"theme":961.7590,
"themed":7.5314,
"themes":0.9414,
"themselves":4185.3837,
"then":27748.6668,
"thence":45.1884,
"theologian":62.1340,
"theological":124.2680,
"theology":178.4940,
"theorem":58.3683,
"theorems":0.3766,
"theoretic":5.0837,
"theoretical":533.9758,
"theoretically":104.8747,
"theorist":171.9041,
"theory":2913.1431,
"therapeutic":127.0923,
"therapist":165.6907,
"therapy":349.0801,
"there":57604.9942,
"thereafter":233.8498,
"thereby":471.0887,
"therefor":2.6360,
"therefore":4142.0782,
"therefrom":11.4854,
"therein":56.4855,
"thereof":65.1466,
"thereon":0.5649,
"thereto":23.1590,
"thereunder":5.8368,
"thereupon":16.7574,
"therewith":4.3306,
"therm":0.9414,
"thermal":128.4103,
"thermally":6.5900,
"thermodynamic":30.3139,
"thermometer":29.7490,
"thermoplastic":4.5188,
"thermostat":28.4310,
"thesauri":0.1883,
"thesaurus":33.7030,
"these":22354.4944,
"theses":3.3891,
"thesis":304.6449,
"theta":37.4687,
"they":106701.9613,
"thick":921.4660,
"thickened":5.4603,
"thickening":18.6402,
"thicker":2.6360,
"thickest":0.3766,
"thickly":69.4771,
"thickness":137.0714,
"thief":294.6658,
"thigh":239.6866,
"thighs":2.4477,
"thin":1048.5583,
"thine":9.2260,
"thing":13607.7221,
"thingy":22.2176,
"think":26471.5308,
"thinker":88.4939,
"thinking":743.3486,
"thinks":0.1883,
"thinly":74.9374,
"thinned":2.0711,
"thinner":4.5188,
"thinness":12.2385,
"thinning":32.5733,
"third":3809.5672,
"thirdly":140.6488,
"thirst":68.7240,
"thirsty":51.0252,
"thirteen":370.1680,
"thirteenth":123.3266,
"thirtieth":27.4896,
"thirty":2126.8656,
"this":81936.8560,
"thistle":26.1716,
"thither":10.1674,
"tho":8.4728,
"thomas":0.5649,
"thompson":4.3306,
"thomson":4.3306,
"thong":8.6611,
"thor":1.5063,
"thoracic":11.6737,
"thorn":77.5734,
"thornton":0.3766,
"thorough":201.2765,
"thoroughbred":13.7448,
"thoroughly":368.6617,
"thoroughness":20.5230,
"thorpe":0.3766,
"those":15714.0646,
"thou":91.3181,
"though":7997.2104,
"thought":2334.9203,
"thoughtful":108.8286,
"thoughtfully":119.9374,
"thoughtfulness":7.5314,
"thoughts":0.9414,
"thousand":2791.3228,
"thousandth":16.7574,
"thrash":90.7533,
"thrasher":0.9414,
"thread":305.5863,
"threaded":3.9540,
"threading":4.5188,
"threat":1249.0816,
"threaten":1275.4415,
"threatened":12.2385,
"threatening":60.0629,
"threatens":0.1883,
"three":15034.3563,
"threes":0.1883,
"threesome":7.1548,
"threshold":193.1802,
"threw":0.3766,
"thrice":6.4017,
"thrift":37.4687,
"thrifty":14.1214,
"thrill":159.8538,
"thrilled":53.8495,
"thriller":75.8788,
"thrilling":46.6946,
"thrive":198.0757,
"thriving":10.1674,
"throat":605.1475,
"throbbing":35.3976,
"thrombosis":20.8996,
"throne":216.5276,
"throttle":69.4771,
"through":14782.9961,
"throughout":2210.6523,
"throughput":23.9122,
"throw":2097.8697,
"throwback":9.7908,
"throwing":20.5230,
"thrown":0.1883,
"thrush":36.1507,
"thrust":421.1932,
"thrusting":10.5440,
"thug":54.0377,
"thule":0.3766,
"thumb":273.9544,
"thumbnail":13.9331,
"thumbs":1.1297,
"thunder":180.9417,
"thundering":1.8828,
"thunderstorm":23.3473,
"thursday":5.8368,
"thus":3594.5459,
"thwart":81.5273,
"thwarted":1.1297,
"thy":96.4018,
"thyme":26.9247,
"thymus":13.5565,
"thyroid":26.1716,
"thyself":9.4142,
"ti":46.5064,
"tiara":8.4728,
"tibet":0.3766,
"tibetan":28.2427,
"tibia":3.9540,
"tic":9.9791,
"tick":227.6364,
"ticked":0.1883,
"ticker":6.2134,
"ticket":863.6626,
"ticketing":2.4477,
"ticking":12.8034,
"tickle":57.4269,
"tickling":5.4603,
"tidal":78.8913,
"tide":372.8040,
"tidy":256.2557,
"tidying":3.5774,
"tie":1407.4292,
"tied":9.2260,
"tier":166.2555,
"tiered":4.5188,
"tiff":12.8034,
"tiger":145.3559,
"tight":809.2483,
"tighten":274.3310,
"tightened":0.1883,
"tightening":29.3724,
"tightens":0.1883,
"tighter":2.6360,
"tightly":306.9043,
"tightness":21.6528,
"tigris":0.1883,
"til":10.3557,
"tile":340.6073,
"tiled":13.7448,
"tiles":2.8243,
"tiling":10.3557,
"till":1000.1691,
"tillage":5.0837,
"tilt":166.6321,
"tilted":7.9080,
"tilting":6.2134,
"timber":477.1138,
"timberland":0.3766,
"timbers":0.1883,
"time":33680.7691,
"timed":2.2594,
"timeless":45.7532,
"timeliness":6.2134,
"timely":69.1005,
"timeout":0.1883,
"timer":86.9876,
"times":13.9331,
"timescale":48.3892,
"timeshare":17.6988,
"timetable":241.0046,
"timid":50.2721,
"timing":316.3185,
"timothy":0.1883,
"tin":480.3146,
"ting":3.0126,
"tinged":6.4017,
"tingling":24.2887,
"tinker":51.5900,
"tinkering":5.8368,
"tint":63.4520,
"tinted":10.5440,
"tinting":1.8828,
"tiny":959.4996,
"tip":885.5036,
"tipped":1.3180,
"tipping":15.4394,
"tips":10.5440,
"tire":48.0126,
"tired":681.5911,
"tiredness":52.7198,
"tireless":26.5482,
"tirelessly":18.6402,
"tiresome":41.0461,
"tiring":51.0252,
"tissue":529.2687,
"tissues":0.1883,
"tit":68.3474,
"titan":3.5774,
"titanic":11.6737,
"titanium":15.8159,
"title":1844.8149,
"titled":0.3766,
"titles":0.3766,
"tito":0.9414,
"titre":11.4854,
"titty":2.4477,
"titus":0.1883,
"tl":0.1883,
"tlc":0.9414,
"to":473070.1839,
"toad":74.7491,
"toast":235.3561,
"toasted":6.9665,
"toaster":18.2636,
"tobacco":253.4314,
"tobaccos":0.3766,
"tobago":0.1883,
"tod":0.1883,
"today":4479.2964,
"todd":0.9414,
"toddler":104.1215,
"toe":335.9002,
"tofu":3.5774,
"together":5431.6411,
"toggle":18.4519,
"togo":0.1883,
"toil":57.8034,
"toilet":373.5571,
"toilets":0.1883,
"toilette":0.7531,
"token":194.4982,
"tokyo":0.1883,
"told":1.1297,
"tolerable":36.5273,
"tolerance":140.0839,
"tolerant":90.9416,
"tolerate":205.9836,
"tolkien":0.1883,
"toll":189.6028,
"tolstoy":0.1883,
"toluene":3.0126,
"tom":4.8954,
"tomahawk":1.6946,
"tomato":237.0506,
"tomb":146.1090,
"tombstone":25.0419,
"tomcat":4.1423,
"tome":25.6067,
"tomography":22.2176,
"tomorrow":1565.4002,
"ton":298.2432,
"tonal":28.6193,
"tone":976.2569,
"toned":13.7448,
"toner":12.2385,
"tones":0.5649,
"tonga":0.5649,
"tongue":521.3607,
"tonic":106.0044,
"tonight":1153.8095,
"toning":6.0251,
"tonnage":19.9582,
"tonne":402.5530,
"tonnes":0.1883,
"too":12232.3013,
"took":4.7071,
"tool":952.3447,
"toolbar":4.8954,
"toolbox":4.8954,
"tooling":5.8368,
"toolkit":27.6779,
"tools":9.9791,
"tooth":954.6041,
"toothbrush":33.8913,
"toothless":15.4394,
"toothpaste":38.0335,
"top":5136.4105,
"topaz":6.2134,
"topic":800.7754,
"topical":45.5649,
"topless":21.6528,
"topographic":8.0962,
"topography":38.5984,
"topological":5.6485,
"topology":13.1799,
"topped":2.0711,
"topper":14.6862,
"topping":12.4268,
"tops":6.5900,
"tor":11.1088,
"torch":198.8288,
"tore":1.5063,
"torment":119.1843,
"torn":41.0461,
"tornado":17.6988,
"torpedo":39.9164,
"torque":127.2806,
"torrent":51.5900,
"tors":0.1883,
"torsion":14.4979,
"torso":43.8704,
"tort":85.2930,
"tortilla":8.4728,
"tortoise":45.3766,
"torture":264.1636,
"tortured":0.3766,
"torturing":0.1883,
"torus":6.0251,
"tory":467.6995,
"toss":262.0925,
"tossed":0.3766,
"tossing":5.2720,
"tot":46.6946,
"total":3224.7545,
"totalitarian":28.9959,
"totality":61.0043,
"totalling":25.2302,
"totally":1040.4620,
"tote":16.7574,
"totem":18.8285,
"tots":0.1883,
"tou":0.3766,
"touch":2235.6942,
"touchdown":20.7113,
"touchdowns":0.1883,
"touched":0.1883,
"touches":0.7531,
"touching":66.2763,
"touchscreen":0.3766,
"touchstone":14.3096,
"touchy":18.2636,
"tough":734.3109,
"tougher":1.3180,
"toughness":30.8787,
"toulouse":0.1883,
"tour":1271.8641,
"touring":76.0671,
"tourism":189.4146,
"tourist":555.2520,
"tourmaline":2.4477,
"tournament":340.2307,
"tourney":2.0711,
"tours":0.3766,
"tout":46.5064,
"tow":135.3768,
"toward":215.3979,
"towards":4917.6235,
"towel":243.6406,
"tower":624.5408,
"towering":2.6360,
"towing":5.2720,
"town":3369.1690,
"townhouse":3.0126,
"towns":0.3766,
"township":91.3181,
"toxic":234.2263,
"toxicity":33.8913,
"toxicology":5.6485,
"toxin":79.4562,
"toy":409.5195,
"toying":0.5649,
"toyota":0.7531,
"toys":1.6946,
"trace":784.3947,
"traceability":0.5649,
"traceable":12.9917,
"tracer":18.2636,
"traces":0.3766,
"tracing":8.2845,
"track":1603.2454,
"tracked":1.3180,
"tracker":12.8034,
"tracking":32.7616,
"tract":162.3015,
"traction":39.1632,
"tractor":132.9291,
"tractors":0.3766,
"trad":8.8494,
"trade":3529.3994,
"traded":2.4477,
"trademark":38.4101,
"trademarked":0.1883,
"trader":313.1177,
"trading":721.6958,
"tradition":1183.7468,
"traditional":1763.6641,
"traditionalist":31.6319,
"traditionally":369.4149,
"traditions":0.3766,
"traffic":1165.6715,
"trafficked":1.1297,
"trafficking":41.4227,
"tragedy":343.0550,
"tragic":216.3393,
"tragically":40.6695,
"trail":450.5656,
"trailer":115.7952,
"trailing":7.9080,
"train":2708.1009,
"trained":3.7657,
"trainee":224.6238,
"trainees":0.7531,
"trainer":311.2348,
"training":3297.2442,
"trait":152.8873,
"traitor":65.3348,
"trajectory":51.5900,
"tram":128.5985,
"tramp":104.4981,
"trample":56.1089,
"trampling":5.2720,
"trampoline":10.5440,
"trance":42.9289,
"tranquil":52.3432,
"tranquility":8.0962,
"tranquillity":53.8495,
"trans":49.3306,
"transact":19.3933,
"transaction":741.4657,
"transactional":14.6862,
"transatlantic":38.2218,
"transceiver":8.8494,
"transcend":73.6194,
"transcendent":44.6235,
"transcendental":19.2051,
"transcript":88.4939,
"transcription":146.8622,
"transcriptional":25.7950,
"transducer":18.2636,
"transduction":5.8368,
"transfer":2022.5558,
"transferable":39.9164,
"transferee":17.1339,
"transference":18.6402,
"transferred":0.1883,
"transferring":3.3891,
"transform":560.3357,
"transformation":361.5069,
"transformed":1.6946,
"transformer":52.7198,
"transforming":0.5649,
"transfusion":63.0754,
"transgenic":33.7030,
"transient":80.5859,
"transistor":66.6528,
"transit":137.6362,
"transition":482.3858,
"transitional":118.4312,
"transitive":9.7908,
"transitory":23.7239,
"translate":389.7496,
"translating":1.5063,
"translation":308.4106,
"translational":7.3431,
"translator":55.5440,
"translucent":38.5984,
"transmission":287.5110,
"transmit":302.3855,
"transmittal":6.2134,
"transmitter":74.9374,
"transmitting":0.9414,
"transnational":70.7951,
"transparency":47.0712,
"transparent":128.7868,
"transparently":11.2971,
"transplant":141.7785,
"transplantation":42.5524,
"transplanted":0.1883,
"transponder":5.6485,
"transport":1235.1486,
"transportation":81.1508,
"transporter":28.4310,
"transporting":2.6360,
"transpose":28.9959,
"transposition":13.3682,
"transsexual":18.8285,
"transverse":40.2930,
"transvestite":22.7825,
"trap":714.9175,
"trapped":4.3306,
"trapping":44.4352,
"traps":0.3766,
"trash":46.1298,
"trashy":4.1423,
"trauma":116.3600,
"traumatic":83.0336,
"travail":9.6025,
"travel":2341.6986,
"traveler":1.1297,
"travelled":0.9414,
"traveller":413.4735,
"travelling":18.8285,
"traversal":5.4603,
"traverse":76.0671,
"traversing":0.3766,
"trawl":24.1005,
"tray":324.0382,
"treacherous":66.0880,
"treachery":35.9624,
"tread":173.9752,
"treadmill":20.8996,
"treason":57.0503,
"treasure":266.7996,
"treasured":16.3808,
"treasurer":93.3893,
"treasuring":0.1883,
"treasury":50.2721,
"treat":2270.3386,
"treated":0.5649,
"treating":3.0126,
"treatise":44.2469,
"treatment":2330.0249,
"treaty":668.5995,
"treble":98.0964,
"tree":2595.1300,
"trees":2.0711,
"trek":66.2763,
"trekking":15.0628,
"tremble":270.3770,
"trembling":14.8745,
"tremendous":354.1638,
"tremendously":54.4143,
"tremor":53.2846,
"tren":0.1883,
"trench":160.0421,
"trend":833.5370,
"trendy":46.3181,
"trent":4.3306,
"trespass":70.4185,
"triad":16.1925,
"trial":1500.4419,
"triangle":164.7492,
"triangular":72.4897,
"triangulation":6.9665,
"triathlon":6.2134,
"tribal":127.6571,
"tribe":230.4606,
"tribes":0.1883,
"tribunal":298.0549,
"tribune":3.7657,
"tributary":37.4687,
"tribute":299.9378,
"trick":542.6369,
"trickle":124.2680,
"trickster":12.0502,
"tricky":122.9500,
"trident":6.7783,
"tried":2.0711,
"trier":4.5188,
"tries":1.1297,
"trig":3.5774,
"trigger":344.5613,
"triggered":0.1883,
"triggering":2.8243,
"trillion":27.3013,
"trillium":0.1883,
"trilogy":20.3348,
"trim":241.3812,
"trimester":6.2134,
"trimmed":0.3766,
"trimmer":12.8034,
"trimming":50.6486,
"trinidad":0.5649,
"trinity":15.4394,
"trio":110.3349,
"trip":1146.4664,
"triple":148.7450,
"triplet":24.6653,
"tripod":32.7616,
"tripped":0.1883,
"tripping":2.4477,
"triton":1.8828,
"triumph":361.8835,
"triumphant":89.2470,
"triumphs":0.9414,
"trivia":3.5774,
"trivial":160.0421,
"trivium":16.3808,
"trojan":0.9414,
"troll":21.4645,
"trolley":157.2178,
"trolling":0.9414,
"trombone":12.0502,
"trondheim":0.1883,
"troop":957.9933,
"trooper":46.6946,
"troopers":0.1883,
"trophy":174.9166,
"tropic":40.6695,
"tropical":262.2808,
"trot":126.1508,
"trotter":6.5900,
"trouble":1926.9071,
"troubled":147.4270,
"troubles":0.5649,
"troubleshoot":1.6946,
"troubleshooting":1.5063,
"troublesome":73.8077,
"troubling":13.7448,
"trough":75.3139,
"troupe":34.8327,
"trouser":448.3062,
"trout":124.4563,
"trove":9.2260,
"troy":2.2594,
"truce":72.3014,
"truck":312.1763,
"trucker":10.5440,
"trucking":4.3306,
"true":3105.9468,
"truer":3.3891,
"truest":0.3766,
"truly":558.2646,
"trump":39.3515,
"trumpet":92.8244,
"truncate":13.9331,
"truncated":18.6402,
"truncation":3.2008,
"trunk":208.0548,
"truss":43.1172,
"trust":1626.7810,
"trusted":19.0168,
"trustee":301.2557,
"trustees":0.1883,
"trusting":14.4979,
"trustworthy":27.1130,
"trusty":17.1339,
"truth":1503.2662,
"truthful":35.7741,
"truthfully":32.1967,
"truthfulness":7.1548,
"truths":0.1883,
"try":10003.9502,
"trying":6.5900,
"tsunami":3.5774,
"tub":94.1424,
"tuba":1.8828,
"tubal":3.2008,
"tube":532.6578,
"tuberculosis":61.1926,
"tubing":19.9582,
"tubular":46.1298,
"tuck":276.7787,
"tucked":0.5649,
"tucker":1.5063,
"tudor":0.5649,
"tuesday":15.2511,
"tug":185.4606,
"tuition":78.3265,
"tulip":30.5021,
"tully":0.1883,
"tumble":200.7116,
"tumbled":0.5649,
"tumbler":27.8662,
"tumbling":10.5440,
"tummy":64.7700,
"tumor":4.1423,
"tumour":291.2767,
"tumultuous":16.0042,
"tuna":60.2511,
"tundra":37.6570,
"tune":460.5447,
"tuned":9.6025,
"tuner":20.3348,
"tungsten":19.2051,
"tunic":60.0629,
"tuning":45.7532,
"tunis":0.1883,
"tunisia":0.3766,
"tunisian":11.4854,
"tunnel":426.6535,
"turbidity":4.8954,
"turbine":64.2051,
"turbo":48.2009,
"turbulence":74.7491,
"turbulent":94.7073,
"turf":105.2512,
"turing":2.0711,
"turk":3.3891,
"turkey":104.1215,
"turkish":233.6615,
"turkmenistan":0.3766,
"turmoil":95.6487,
"turn":9683.4894,
"turnaround":22.5942,
"turner":10.9205,
"turning":162.6781,
"turnkey":12.4268,
"turnout":70.6068,
"turnover":527.1976,
"turnpike":19.2051,
"turns":1.3180,
"turntable":22.4059,
"turquoise":38.2218,
"turret":40.1047,
"turtle":57.0503,
"turtles":0.1883,
"tuscan":16.0042,
"tuscany":0.3766,
"tut":3.9540,
"tutor":346.4441,
"tutorial":89.4353,
"tutoring":11.8619,
"tutors":0.9414,
"tux":0.5649,
"tuxedo":5.0837,
"tv":1148.1610,
"twain":2.6360,
"twat":14.3096,
"tweak":25.0419,
"tweaked":0.1883,
"tweaking":2.0711,
"tweed":90.5650,
"tween":3.3891,
"tweeter":2.2594,
"twelfth":205.0422,
"twelve":1162.2823,
"twentieth":408.0133,
"twenty":3733.3118,
"twice":1096.0061,
"twigs":4.3306,
"twilight":58.9332,
"twill":6.9665,
"twin":526.8210,
"twink":0.1883,
"twinkle":56.6737,
"twist":454.7079,
"twisted":103.3684,
"twister":2.8243,
"twisting":39.9164,
"twitch":109.2052,
"two":28756.5556,
"twofold":38.2218,
"tycoon":39.9164,
"tying":5.6485,
"tyler":2.2594,
"tyne":0.3766,
"type":4734.4223,
"typed":0.3766,
"typeface":34.8327,
"types":0.9414,
"typewriter":100.5441,
"typhoon":9.7908,
"typical":856.5077,
"typically":370.7329,
"typing":35.9624,
"typist":38.7867,
"typo":3.0126,
"typographical":9.4142,
"typography":16.5691,
"tyranny":51.7783,
"tyrant":45.9415,
"tyre":192.6154,
"tyrosine":20.5230,
"tyson":0.7531,
"u":328.5570,
"uber":0.1883,
"ubiquitous":65.1466,
"ufo":7.5314,
"ugandan":1.6946,
"ugh":16.3808,
"uglier":0.1883,
"ugliest":0.1883,
"ugliness":22.2176,
"ugly":239.8749,
"uh":40.6695,
"uk":17.1339,
"ukrainian":69.4771,
"ulcer":265.6699,
"ulster":15.0628,
"ultimate":420.8166,
"ultimately":510.0636,
"ultra":141.9668,
"ultrasonic":18.0753,
"ultrasound":35.7741,
"ultraviolet":33.3264,
"um":103.7449,
"umbilical":23.1590,
"umbrella":154.9584,
"umpire":82.4688,
"un":58.1800,
"una":0.7531,
"unable":1112.9517,
"unabridged":1.6946,
"unacceptable":218.7870,
"unaccompanied":16.0042,
"unaffected":93.0127,
"unaided":19.2051,
"unalterable":7.3431,
"unaltered":25.9833,
"unambiguous":56.8620,
"unambiguously":32.0084,
"unanimous":85.2930,
"unanimously":90.5650,
"unanswered":42.1758,
"unanticipated":18.6402,
"unappreciated":5.4603,
"unapproachable":6.7783,
"unarmed":35.9624,
"unassessed":0.1883,
"unassigned":1.3180,
"unassisted":7.9080,
"unattached":12.6151,
"unattainable":18.0753,
"unattended":25.7950,
"unattractive":61.3809,
"unaudited":3.2008,
"unauthorised":59.1214,
"unauthorized":20.7113,
"unavailable":69.8537,
"unavoidable":72.1131,
"unaware":213.3267,
"unbalanced":36.9038,
"unbearable":62.3223,
"unbeatable":19.0168,
"unbeaten":86.6110,
"unbelievable":91.1299,
"unbelievably":30.5021,
"unbiased":21.8410,
"unborn":36.1507,
"unbound":7.9080,
"unbounded":14.6862,
"unbranded":2.2594,
"unbreakable":9.7908,
"unbroken":50.2721,
"unbusinesslike":1.5063,
"unbuttoned":4.5188,
"uncanny":39.5398,
"uncensored":2.8243,
"uncertain":348.7035,
"uncertainty":465.4401,
"unchangeable":5.4603,
"unchanged":193.3685,
"unchanging":29.5607,
"uncharted":13.7448,
"unchecked":27.4896,
"unclaimed":8.0962,
"unclassified":7.3431,
"uncle":349.4567,
"unclean":26.1716,
"unclear":169.0798,
"uncomfortable":243.6406,
"uncommon":117.4897,
"uncommonly":11.8619,
"uncommunicative":4.5188,
"uncomplicated":31.8201,
"uncompressed":3.0126,
"uncompromising":52.9080,
"unconcerned":29.7490,
"unconditional":62.8871,
"unconditionally":20.3348,
"unconfined":3.9540,
"unconfirmed":12.9917,
"unconscious":247.2180,
"unconsciously":63.2637,
"unconstitutional":30.8787,
"unconstrained":8.4728,
"uncontextualised":0.1883,
"uncontextualized":0.1883,
"uncontrollable":39.5398,
"uncontrollably":21.4645,
"uncontrolled":49.5189,
"uncontroversial":16.3808,
"unconventional":29.5607,
"unconvinced":25.0419,
"uncountable":1.8828,
"uncover":186.0254,
"uncovering":4.7071,
"uncredited":0.5649,
"uncrowned":1.8828,
"uncultured":1.3180,
"uncut":12.0502,
"undamaged":19.5816,
"undated":12.0502,
"undead":3.5774,
"undecided":36.9038,
"undeclared":8.6611,
"undefeated":13.9331,
"undefined":19.7699,
"undelivered":0.9414,
"undeniable":37.2804,
"undeniably":28.9959,
"under":11084.1404,
"underage":3.3891,
"undercover":40.2930,
"undercut":37.6570,
"underdeveloped":20.7113,
"underdog":10.7322,
"underestimate":151.5693,
"underestimated":1.3180,
"underestimating":0.5649,
"undergo":437.5740,
"undergoing":0.1883,
"undergone":1.5063,
"undergrad":0.3766,
"undergraduate":163.8078,
"underground":326.4859,
"underlay":21.8410,
"underlie":432.8669,
"underline":231.0255,
"underlined":2.6360,
"underlining":2.6360,
"underlying":154.2053,
"undermine":364.5195,
"undermined":1.5063,
"undermining":8.0962,
"underneath":327.4273,
"underpin":104.4981,
"underpinning":18.0753,
"underrated":11.6737,
"underrepresented":1.6946,
"underscore":16.3808,
"underscored":0.5649,
"underside":67.4060,
"undersigned":2.0711,
"understand":4069.9651,
"understandable":152.1342,
"understandably":88.6822,
"understanding":1434.9188,
"understated":11.2971,
"understatement":34.6444,
"understood":2.4477,
"undertake":1050.6294,
"undertaking":282.2390,
"underwater":80.3976,
"underway":105.4395,
"underwear":85.8579,
"underwent":0.7531,
"underwood":1.6946,
"underworld":27.4896,
"underwriter":43.6821,
"underwriting":43.8704,
"undesirable":116.1717,
"undetectable":7.9080,
"undetected":22.9708,
"undetermined":7.5314,
"undeveloped":23.3473,
"undifferentiated":19.3933,
"undiminished":11.4854,
"undisclosed":41.7992,
"undiscovered":17.1339,
"undisputed":30.1256,
"undisturbed":47.0712,
"undivided":20.7113,
"undo":122.3851,
"undocumented":5.6485,
"undone":12.2385,
"undoubtedly":420.8166,
"undress":54.6026,
"undressed":15.8159,
"undressing":1.8828,
"undue":88.8704,
"unduly":83.0336,
"undying":8.6611,
"unearned":6.9665,
"unearthed":0.1883,
"unease":75.8788,
"uneasy":167.3852,
"uneconomical":9.2260,
"unedited":2.4477,
"uneducated":21.0879,
"unemployed":475.6075,
"unemployment":1154.7509,
"unenforceable":23.5356,
"unequal":74.3725,
"unequivocal":45.1884,
"unequivocally":36.3390,
"unethical":17.3222,
"uneven":119.9374,
"unexpected":359.8123,
"unexpectedly":159.8538,
"unexplained":45.9415,
"unfair":319.8959,
"unfairly":55.7323,
"unfamiliar":142.3433,
"unfamiliarity":8.0962,
"unfavorable":0.3766,
"unfettered":26.3599,
"unfinished":65.5231,
"unfit":72.4897,
"unfold":110.1466,
"unfolded":0.3766,
"unfolding":14.8745,
"unforeseen":42.3641,
"unforgettable":32.0084,
"unfortunate":288.8289,
"unfortunately":832.9721,
"unfounded":37.6570,
"unframed":0.7531,
"unfriendly":33.7030,
"unfunded":3.0126,
"unhappiness":58.3683,
"unhappy":335.1470,
"unhealthy":49.5189,
"unheard":43.6821,
"unhelpful":45.1884,
"unholy":17.6988,
"uni":9.6025,
"unicef":1.8828,
"unicorn":16.7574,
"unidentifiable":7.7197,
"unidentified":43.4938,
"unidirectional":7.1548,
"unification":120.8789,
"unified":120.5023,
"uniform":530.9633,
"uniformed":65.1466,
"uniformity":64.9583,
"uniformly":52.5315,
"unify":73.4311,
"unifying":13.3682,
"unilateral":60.2511,
"unilaterally":32.1967,
"unimaginable":23.3473,
"unimportance":4.3306,
"unimportant":72.1131,
"unincorporated":8.2845,
"uninformed":17.8871,
"uninjured":8.6611,
"uninsured":7.7197,
"unintelligent":5.8368,
"unintended":25.9833,
"unintentional":18.0753,
"unintentionally":16.0042,
"uninterrupted":32.7616,
"uninvolved":4.8954,
"union":2221.7611,
"unique":769.5201,
"uniquely":96.5901,
"uniqueness":44.4352,
"unisex":3.9540,
"unison":35.3976,
"unit":2903.5405,
"unitarian":11.6737,
"unitary":75.3139,
"unite":220.6698,
"united":86.0462,
"uniting":0.7531,
"units":1.6946,
"unity":417.2392,
"universal":416.4861,
"universality":28.4310,
"universally":106.9458,
"universe":403.6827,
"university":1241.5502,
"unix":16.3808,
"unjust":69.4771,
"unjustified":37.0921,
"unjustly":14.3096,
"unknown":567.4905,
"unlabeled":0.1883,
"unlawful":155.1467,
"unlawfully":30.1256,
"unleaded":34.8327,
"unleash":66.0880,
"unleashed":0.5649,
"unless":1943.4761,
"unlicensed":13.7448,
"unlike":829.0182,
"unlikely":1000.7339,
"unlimited":121.8203,
"unlisted":9.9791,
"unload":82.6570,
"unloaded":2.2594,
"unloading":16.0042,
"unlock":114.6655,
"unlocked":5.0837,
"unlocking":1.3180,
"unluckily":5.0837,
"unlucky":85.2930,
"unmanned":10.7322,
"unmarked":54.6026,
"unmarried":95.6487,
"unmask":9.4142,
"unmatched":12.9917,
"unmentioned":0.5649,
"unmet":19.3933,
"unmistakable":73.2428,
"unmistakably":27.3013,
"unmodified":11.1088,
"unmonitored":0.5649,
"unmotivated":2.8243,
"unnamed":40.8578,
"unnatural":84.5399,
"unnecessarily":80.3976,
"unnecessary":326.8625,
"unneeded":2.0711,
"unnoticed":70.9834,
"unobtainable":11.4854,
"unobtrusive":24.6653,
"unoccupied":36.5273,
"unofficial":110.5232,
"unopened":14.3096,
"unpack":49.8955,
"unpacking":3.2008,
"unpaid":96.2136,
"unparalleled":27.1130,
"unpardonable":3.2008,
"unplanned":24.6653,
"unpleasant":229.5192,
"unpleasantly":17.6988,
"unplug":7.9080,
"unplugged":2.6360,
"unpopular":115.0420,
"unprecedented":160.9835,
"unpredictability":22.9708,
"unpredictable":123.3266,
"unprejudiced":3.3891,
"unprepared":38.5984,
"unprincipled":10.7322,
"unproductive":41.0461,
"unprofessional":12.0502,
"unprotected":31.8201,
"unproven":16.1925,
"unpublished":76.0671,
"unqualified":53.8495,
"unquestionably":39.5398,
"unrated":0.5649,
"unravel":66.6528,
"unreachable":3.9540,
"unread":9.2260,
"unreadable":22.7825,
"unreal":52.1549,
"unrealistic":103.5567,
"unrealized":6.5900,
"unreasonable":174.1635,
"unreasonably":45.5649,
"unrecognized":13.3682,
"unregistered":34.4561,
"unregulated":15.8159,
"unrelated":100.1675,
"unreleased":6.4017,
"unreliable":87.5525,
"unreported":22.4059,
"unresolved":59.6863,
"unresourceful":0.1883,
"unresponsive":18.8285,
"unrest":161.9250,
"unrestrained":15.2511,
"unrestricted":36.3390,
"unrestrictive":0.1883,
"unrivalled":34.2678,
"unruly":32.5733,
"unsafe":70.9834,
"unsatisfactory":135.7534,
"unsatisfied":16.3808,
"unsaturated":13.7448,
"unscheduled":10.7322,
"unscrupulous":42.7407,
"unsecured":25.9833,
"unseen":87.3642,
"unset":0.5649,
"unsettled":24.6653,
"unsettling":35.0210,
"unsigned":14.8745,
"unskilled":84.9165,
"unsolicited":23.1590,
"unsolved":22.5942,
"unsorted":1.5063,
"unspecified":52.1549,
"unspoken":55.1675,
"unstable":125.7743,
"unsteadily":21.4645,
"unsteady":30.6904,
"unstoppable":23.1590,
"unstressed":16.7574,
"unstructured":22.2176,
"unstrung":1.1297,
"unsuccessful":169.8329,
"unsuccessfully":62.6989,
"unsuitable":126.5274,
"unsupervised":9.9791,
"unsupported":20.5230,
"unsure":109.9583,
"unsurpassed":5.8368,
"unsuspecting":29.7490,
"unsustainable":12.8034,
"untapped":16.0042,
"untested":12.2385,
"unthinkable":63.4520,
"untie":26.1716,
"untied":0.9414,
"until":7140.7026,
"untimely":17.8871,
"untitled":7.1548,
"unto":69.2888,
"untold":24.4770,
"untouched":83.0336,
"untranslated":5.0837,
"untreated":39.7281,
"untrue":51.5900,
"unusable":15.8159,
"unused":85.4813,
"unusual":726.9678,
"unusually":176.7995,
"unveil":150.8162,
"unveiled":0.3766,
"unveiling":12.2385,
"unveils":0.5649,
"unwaged":2.6360,
"unwanted":144.2262,
"unwarranted":30.3139,
"unwelcome":80.5859,
"unwilling":174.7283,
"unwillingly":19.9582,
"unwillingness":48.5775,
"unwind":28.4310,
"unwise":72.3014,
"unwittingly":55.1675,
"unworthy":28.4310,
"unwrap":21.2762,
"unwritten":28.0544,
"unzip":14.3096,
"up":40166.0522,
"upbeat":17.5105,
"upbringing":80.5859,
"upcoming":15.0628,
"update":447.3648,
"updater":0.1883,
"updating":29.5607,
"upfront":10.9205,
"upgrade":236.4858,
"upgrading":38.2218,
"upheaval":83.7868,
"uphill":62.3223,
"uphold":193.3685,
"upholding":2.2594,
"upholstered":14.3096,
"upholstery":33.8913,
"upkeep":28.9959,
"upland":94.8956,
"uplift":65.8997,
"uplifted":10.1674,
"uplifting":18.0753,
"upload":1.8828,
"upon":4076.9317,
"upper":840.3152,
"uppercase":0.1883,
"upright":229.3309,
"uprising":68.5357,
"uproar":42.3641,
"upscale":1.1297,
"upset":614.5617,
"upsetting":28.2427,
"upside":109.5818,
"upsilon":0.7531,
"upstairs":443.4108,
"upstate":3.7657,
"upstream":72.6779,
"uptake":66.4645,
"uptown":5.2720,
"upward":143.2848,
"upwards":287.3227,
"ur":2.4477,
"uranium":93.0127,
"urban":874.2065,
"urbanization":21.0879,
"urdu":0.5649,
"urea":15.4394,
"urge":842.5747,
"urgency":153.8287,
"urgent":370.3563,
"urgently":147.0505,
"urging":9.4142,
"urinary":48.0126,
"urination":4.3306,
"urine":141.2136,
"urn":40.2930,
"urology":2.8243,
"uruguayan":4.5188,
"us":14.6862,
"usa":0.1883,
"usability":10.5440,
"usable":61.7574,
"usage":232.3435,
"use":28409.9232,
"used":82.6570,
"useful":1800.7562,
"usefully":76.6319,
"usefulness":92.6361,
"useless":231.4021,
"user":2264.3135,
"username":7.9080,
"users":0.1883,
"uses":1.6946,
"usher":89.4353,
"ushered":0.1883,
"using":1.6946,
"ussr":0.7531,
"usual":1321.3830,
"usually":3403.2485,
"ut":0.9414,
"uterine":10.5440,
"uterus":27.8662,
"utilisation":37.8453,
"utilise":147.4270,
"utilised":0.1883,
"utilising":0.3766,
"utilitarian":51.7783,
"utilities":0.1883,
"utility":267.3645,
"utilization":16.5691,
"utilize":61.3809,
"utilizing":0.1883,
"utmost":90.5650,
"utopia":14.8745,
"utopian":41.7992,
"utter":236.1092,
"utterance":233.8498,
"uttered":0.3766,
"utterly":228.7661,
"uv":46.8829,
"uzbek":3.5774,
"uzbekistan":0.3766,
"v":1333.9981,
"vac":4.8954,
"vacancy":144.7910,
"vacant":142.5316,
"vacate":45.1884,
"vacated":0.1883,
"vacation":68.7240,
"vaccinated":1.5063,
"vaccination":46.8829,
"vaccine":97.3433,
"vacuum":182.6363,
"vagabond":11.2971,
"vagina":49.5189,
"vaginal":49.8955,
"vague":272.0716,
"vaguely":168.5149,
"vain":144.7910,
"vainly":17.5105,
"valance":12.8034,
"valdez":0.1883,
"vale":4.7071,
"valence":13.5565,
"valentine":6.4017,
"valet":17.3222,
"valhalla":0.1883,
"valiant":19.0168,
"valid":391.6325,
"validate":95.4604,
"validated":0.3766,
"validating":0.1883,
"validation":89.2470,
"validity":240.0632,
"validly":13.1799,
"valium":9.2260,
"valley":537.9298,
"valor":0.5649,
"valuable":733.9343,
"valuables":0.5649,
"valuation":252.6783,
"value":4903.1256,
"valueless":9.9791,
"valuer":36.9038,
"values":3.2008,
"valuing":2.2594,
"valve":231.5904,
"vampire":25.7950,
"van":232.5318,
"vancouver":0.1883,
"vandalism":62.6989,
"vanguard":32.1967,
"vanilla":26.5482,
"vanish":298.8080,
"vanished":9.0377,
"vanishing":4.8954,
"vanity":59.3097,
"vantage":44.6235,
"vanuatu":0.1883,
"vapor":0.7531,
"vapour":98.4730,
"var":12.0502,
"variability":74.5608,
"variable":909.9806,
"variables":1.3180,
"variably":4.5188,
"variance":122.5734,
"variant":202.9711,
"variation":920.3363,
"varied":415.9212,
"variety":1798.3085,
"various":2732.7662,
"variously":67.4060,
"varnish":84.9165,
"varsity":5.0837,
"vary":1156.8221,
"varying":3.2008,
"vascular":54.0377,
"vase":136.5065,
"vast":826.9470,
"vastly":90.9416,
"vat":430.7957,
"vatican":2.2594,
"vaughan":0.3766,
"vault":147.0505,
"vaulted":15.8159,
"vcr":12.2385,
"ve":43.8704,
"veal":22.0293,
"vector":172.2806,
"vectors":0.3766,
"veg":28.9959,
"vegan":7.3431,
"vegetable":473.7247,
"vegetables":2.6360,
"vegetarian":100.7324,
"vegetation":176.2346,
"vegetative":9.6025,
"veggie":3.9540,
"vehemently":39.7281,
"vehicle":1269.0398,
"vehicles":0.3766,
"vehicular":8.2845,
"veil":142.7199,
"veiled":13.3682,
"veiling":2.8243,
"vein":271.3185,
"velcro":10.7322,
"vellum":16.0042,
"velocity":185.0840,
"velour":4.8954,
"velvet":144.6028,
"vendetta":17.6988,
"vending":9.7908,
"vendor":406.1304,
"vendors":0.9414,
"veneer":47.4478,
"venerable":28.8076,
"venetian":53.2846,
"venezuela":0.1883,
"venezuelan":11.4854,
"vengeance":70.2302,
"venice":0.1883,
"venom":49.1423,
"venous":35.9624,
"vent":113.1592,
"ventilated":3.2008,
"ventilation":101.1090,
"ventilator":34.8327,
"venting":3.3891,
"ventral":63.0754,
"ventricle":6.7783,
"ventricular":41.0461,
"venture":626.4237,
"ventures":0.7531,
"venue":298.4315,
"venues":0.5649,
"venus":0.3766,
"veracity":11.2971,
"verb":248.5360,
"verbal":330.0633,
"verbally":41.2344,
"verbatim":17.5105,
"verbose":5.6485,
"verbs":0.9414,
"verdi":1.3180,
"verdict":265.2933,
"verge":156.0881,
"verifiable":14.3096,
"verification":57.9917,
"verifier":14.4979,
"verify":104.4981,
"verifying":1.1297,
"verily":4.5188,
"veritable":33.7030,
"verity":12.2385,
"vermilion":4.5188,
"vernacular":56.1089,
"verona":0.1883,
"versatile":93.7659,
"versatility":43.1172,
"verse":340.7956,
"versed":1.1297,
"verses":1.1297,
"version":1782.4926,
"verso":4.7071,
"versus":168.7032,
"vertebrae":9.7908,
"vertebral":6.0251,
"vertebrate":53.0963,
"vertex":11.2971,
"vertical":322.3436,
"vertically":71.9248,
"vertigo":8.0962,
"verve":17.1339,
"very":21424.9322,
"vesicle":23.7239,
"vesicles":0.1883,
"vessel":525.6913,
"vest":176.7995,
"vesta":0.7531,
"vestal":2.6360,
"vested":31.8201,
"vesting":3.9540,
"vet":174.7283,
"veteran":219.9167,
"veterinarian":5.8368,
"veterinary":96.4018,
"veto":135.9417,
"vhf":0.1883,
"vi":25.2302,
"via":774.0390,
"viability":82.4688,
"viable":175.8580,
"vial":10.9205,
"vibe":32.5733,
"vibrant":61.0043,
"vibrate":59.3097,
"vibrating":2.8243,
"vibration":140.6488,
"vibrational":25.9833,
"vibrations":0.1883,
"vibrator":11.4854,
"vicar":140.0839,
"vice":522.1139,
"vices":0.1883,
"vicinity":101.4855,
"vicious":154.0170,
"victim":1179.0397,
"victor":45.3766,
"victoria":2.4477,
"victorian":430.0426,
"victorious":52.3432,
"victory":1053.0771,
"video":1294.0817,
"videoconferencing":12.6151,
"videotape":29.3724,
"videotapes":0.1883,
"vie":40.4812,
"vietnam":2.0711,
"vietnamese":102.6152,
"view":6335.4084,
"viewable":2.6360,
"viewer":242.5109,
"viewfinder":13.7448,
"viewing":53.6612,
"viewpoint":201.4648,
"views":4.7071,
"vigil":41.4227,
"vigilance":35.3976,
"vigilant":32.5733,
"vignette":11.6737,
"vigor":0.1883,
"vigorous":173.4103,
"vigorously":132.1760,
"vii":10.1674,
"viii":15.4394,
"viking":29.3724,
"vila":0.1883,
"vile":46.8829,
"villa":199.5819,
"village":2328.8952,
"villager":167.0087,
"villain":90.5650,
"vim":1.5063,
"vine":127.4688,
"vinegar":71.3600,
"vines":0.1883,
"vineyard":77.9499,
"vino":3.5774,
"vintage":121.0672,
"vinyl":56.1089,
"viola":12.9917,
"violate":121.8203,
"violated":0.1883,
"violating":0.1883,
"violation":160.0421,
"violence":989.8134,
"violent":514.0176,
"violently":134.8119,
"violet":85.2930,
"violin":98.8495,
"violinist":23.1590,
"vip":37.0921,
"viper":16.9456,
"viral":78.1382,
"virgin":105.8161,
"virginian":1.6946,
"virginity":28.6193,
"virgo":0.1883,
"virology":1.5063,
"virtual":151.0044,
"virtually":781.0055,
"virtue":446.2351,
"virtuoso":22.0293,
"virtuous":31.0670,
"virulence":9.0377,
"virulent":22.9708,
"virus":361.6952,
"visa":79.6445,
"visceral":25.9833,
"viscosity":32.9498,
"viscount":3.5774,
"viscous":33.7030,
"visibility":86.6110,
"visible":521.3607,
"visibly":70.2302,
"vision":799.8340,
"visionary":58.1800,
"visit":4048.5007,
"visitation":19.5816,
"visited":1.1297,
"visiting":6.2134,
"visitor":1184.1234,
"visitors":3.3891,
"visits":0.9414,
"visor":21.6528,
"vista":32.3850,
"visual":626.0471,
"visualisation":19.9582,
"visualise":53.8495,
"visualised":0.1883,
"visualising":0.1883,
"visualization":17.3222,
"visualize":46.8829,
"visually":106.1927,
"vitae":6.9665,
"vital":911.2986,
"vitality":79.2679,
"vitally":48.0126,
"vitamin":235.9209,
"viva":0.5649,
"vivid":177.9292,
"vividly":86.7993,
"vixen":8.0962,
"vocabulary":223.6824,
"vocal":176.0463,
"vocalist":26.3599,
"vocation":50.2721,
"vocational":155.7116,
"vodka":51.5900,
"vogue":35.9624,
"voice":3471.0311,
"voiced":3.0126,
"voiceless":15.6276,
"voices":1.1297,
"voicing":6.5900,
"void":162.1132,
"voids":6.4017,
"vol":106.7575,
"volatile":114.8538,
"volatility":69.2888,
"volcanic":123.7031,
"volcano":123.8914,
"volga":3.3891,
"volley":65.5231,
"volleyball":10.7322,
"volt":64.2051,
"voltage":210.6907,
"volume":1232.5126,
"volumetric":3.2008,
"voluntarily":87.1759,
"voluntary":679.1434,
"volunteer":545.4612,
"volunteering":9.0377,
"vomit":78.1382,
"vomiting":35.7741,
"von":0.5649,
"voodoo":9.7908,
"vortex":32.3850,
"vote":2390.0878,
"voter":415.3564,
"voting":280.3561,
"votive":11.6737,
"vouch":20.7113,
"voucher":156.4647,
"vow":174.5400,
"vowel":130.6697,
"voyage":144.2262,
"voyager":3.7657,
"voyaging":0.7531,
"voyeur":8.8494,
"vs":44.8118,
"vt":0.1883,
"vulcan":0.3766,
"vulgar":60.8160,
"vulnerability":98.4730,
"vulnerable":439.2685,
"vulture":50.2721,
"vulva":8.4728,
"w":1529.8143,
"wa":2.8243,
"wac":0.1883,
"wacky":19.5816,
"waco":0.7531,
"wad":31.6319,
"wade":59.8746,
"wafer":25.9833,
"waffle":23.5356,
"wage":1351.5086,
"waged":0.1883,
"wager":27.6779,
"wages":0.3766,
"waging":1.6946,
"wagner":0.3766,
"wagon":146.1090,
"wai":0.3766,
"wailing":6.2134,
"wainwright":0.3766,
"waist":263.5988,
"waistband":22.7825,
"wait":3744.6089,
"waite":0.7531,
"waited":0.1883,
"waiter":158.9124,
"waiting":195.8162,
"waitress":65.7114,
"waive":60.0629,
"waived":0.1883,
"waiver":32.7616,
"wake":929.7505,
"waken":25.7950,
"waking":7.3431,
"wales":1.3180,
"walk":4746.0960,
"walked":0.7531,
"walker":149.6864,
"walking":103.7449,
"walkman":6.0251,
"walks":0.1883,
"walkway":38.2218,
"wall":2950.2352,
"wallace":0.9414,
"walled":61.9457,
"waller":0.7531,
"wallet":121.6320,
"wallpaper":97.3433,
"walls":0.1883,
"wally":7.3431,
"walnut":70.4185,
"walnuts":1.6946,
"walter":1.5063,
"walton":0.1883,
"waltz":39.7281,
"wan":9.4142,
"wand":30.6904,
"wander":439.6451,
"wandered":0.1883,
"wanderer":14.1214,
"wandering":27.3013,
"waning":3.9540,
"wank":11.6737,
"wanna":459.6033,
"wannabe":4.5188,
"want":16041.4920,
"wanted":18.8285,
"wanting":11.4854,
"wanton":23.5356,
"wants":4.7071,
"war":4392.1205,
"warbler":26.1716,
"ward":504.4151,
"warden":122.1969,
"wardrobe":184.7074,
"ware":75.1257,
"warehouse":221.7995,
"warehousing":22.4059,
"warfare":132.1760,
"warhol":0.1883,
"warlock":3.9540,
"warlord":21.2762,
"warm":1559.9399,
"warmed":3.0126,
"warmer":5.0837,
"warmest":0.3766,
"warming":121.6320,
"warmly":103.7449,
"warmth":359.2475,
"warn":1220.6506,
"warned":0.1883,
"warner":6.9665,
"warning":726.4029,
"warp":64.5817,
"warped":17.1339,
"warrant":316.8834,
"warranted":1.3180,
"warranty":154.9584,
"warren":30.6904,
"warring":0.7531,
"warrior":169.0798,
"wars":0.1883,
"wartime":177.3643,
"warts":0.1883,
"wary":145.7325,
"was":10.5440,
"wash":1005.0645,
"washable":17.5105,
"washed":9.7908,
"washer":50.6486,
"washing":382.5948,
"washington":0.3766,
"wasn":0.9414,
"wasp":77.5734,
"waste":1648.6221,
"wasted":3.3891,
"wasteful":51.5900,
"wastefully":3.0126,
"wasteland":33.3264,
"wasting":6.4017,
"wat":0.7531,
"watch":3916.8896,
"watchdog":64.0168,
"watched":0.7531,
"watcher":69.4771,
"watches":0.1883,
"watchful":51.2135,
"watching":44.4352,
"watchtower":3.9540,
"water":6527.6472,
"watercolor":0.1883,
"watercolour":104.8747,
"watercraft":0.5649,
"watered":0.3766,
"waterfall":94.1424,
"waterfowl":11.2971,
"waterfront":28.9959,
"watergate":0.7531,
"watering":44.6235,
"waterman":5.8368,
"watermark":7.3431,
"watermelon":4.7071,
"waterproof":79.6445,
"waterproofing":6.4017,
"waters":0.1883,
"watershed":39.3515,
"watersheds":0.5649,
"waterside":12.9917,
"waterway":62.5106,
"watery":52.7198,
"watson":0.3766,
"watt":86.7993,
"watts":0.3766,
"waugh":0.1883,
"wave":1520.7767,
"waved":0.1883,
"waveform":30.6904,
"waveguide":1.6946,
"wavelength":100.7324,
"wavelet":2.4477,
"waving":5.0837,
"wavy":25.7950,
"wax":165.8789,
"waxed":5.6485,
"waxing":2.0711,
"way":20179.0514,
"wayne":0.5649,
"wayside":20.3348,
"wayward":37.4687,
"we":74654.9398,
"weak":812.0725,
"weaken":247.0297,
"weakened":11.6737,
"weakening":33.5147,
"weaker":1.1297,
"weakest":0.1883,
"weakly":73.6194,
"weakness":480.8795,
"wealth":682.3443,
"wealthiest":0.1883,
"wealthy":278.0967,
"weaning":12.9917,
"weapon":1051.7591,
"weaponry":33.1381,
"wear":2711.4900,
"wearable":5.6485,
"wearer":26.3599,
"wearing":21.2762,
"weary":140.6488,
"weasel":19.5816,
"weather":1117.8471,
"weathered":5.0837,
"weathering":48.0126,
"weave":227.6364,
"weaver":78.5148,
"weaving":96.4018,
"web":113.7240,
"webb":0.3766,
"webbing":14.6862,
"webs":24.2887,
"wed":29.7490,
"wedding":650.9007,
"wedge":146.1090,
"wedgwood":0.7531,
"wednesday":16.1925,
"wee":259.6448,
"weed":225.1887,
"weeded":0.3766,
"weeding":11.1088,
"week":8485.9978,
"weekday":51.4018,
"weekend":1244.9394,
"weekender":2.0711,
"weekly":428.1597,
"weeks":2.8243,
"weep":219.9167,
"weeping":51.2135,
"weigh":442.2811,
"weighed":0.3766,
"weighing":14.6862,
"weight":1756.8859,
"weighted":33.1381,
"weighting":45.3766,
"weightlifting":2.2594,
"weights":0.5649,
"weir":19.2051,
"weird":199.0171,
"weirdness":4.3306,
"welcome":1693.4339,
"welcoming":35.9624,
"weld":66.2763,
"welder":10.9205,
"welding":31.4436,
"welfare":760.4825,
"well":34328.2806,
"wellington":19.0168,
"wellness":1.6946,
"welsh":358.3061,
"welt":21.2762,
"wen":0.1883,
"went":12.0502,
"were":0.1883,
"weren":0.5649,
"werewolf":5.8368,
"wesleyan":0.3766,
"wessex":0.3766,
"west":1136.1107,
"westerly":29.5607,
"western":1384.6467,
"westminster":0.3766,
"weston":0.3766,
"westward":31.8201,
"westwards":27.6779,
"wet":748.9971,
"wetland":58.7449,
"wetting":9.7908,
"whack":42.9289,
"whale":236.8623,
"whaling":38.2218,
"wharf":35.7741,
"what":41202.7485,
"whatever":2315.1504,
"whatnot":9.4142,
"whatsoever":169.4564,
"wheat":177.9292,
"wheel":887.0099,
"wheelchair":145.1676,
"wheeled":30.5021,
"wheeler":14.4979,
"wheeling":9.6025,
"wheels":0.1883,
"when":38051.9900,
"whence":41.7992,
"whenever":556.5700,
"where":18741.1200,
"whereabouts":63.6403,
"whereas":1093.5584,
"whereby":339.8541,
"wherefore":12.6151,
"wherein":28.2427,
"whereof":6.4017,
"whereupon":46.8829,
"wherever":401.4233,
"whether":6366.2871,
"whey":13.1799,
"which":65538.9409,
"whichever":148.3685,
"while":9871.7743,
"whilst":1041.5917,
"whim":59.6863,
"whimsical":15.0628,
"whine":77.5734,
"whining":3.2008,
"whip":276.5904,
"whiplash":12.6151,
"whipping":10.9205,
"whirl":80.9625,
"whirlpool":23.1590,
"whirlwind":26.7364,
"whisk":79.8328,
"whiskey":23.1590,
"whisky":289.3938,
"whisper":661.8212,
"whispered":0.7531,
"whispering":28.8076,
"whistle":258.5151,
"whistler":1.8828,
"whistling":16.1925,
"whit":6.2134,
"white":3757.2240,
"whiteboard":1.8828,
"whitefish":0.7531,
"whitehall":1.5063,
"whitehead":0.5649,
"whiteness":28.4310,
"whitening":0.5649,
"whiter":5.6485,
"whitewater":1.8828,
"whither":7.5314,
"whiting":11.4854,
"whitish":12.2385,
"whittle":19.2051,
"whiz":22.7825,
"who":35929.8315,
"whoever":253.2431,
"whole":5463.8378,
"wholeheartedly":33.1381,
"wholeness":22.5942,
"wholesale":126.5274,
"wholesaler":48.0126,
"wholesome":35.7741,
"wholly":412.9087,
"whom":2244.7319,
"whomever":3.9540,
"whopping":6.0251,
"whore":66.8411,
"whose":3449.0017,
"why":8165.1605,
"wi":3.3891,
"wicca":0.1883,
"wick":15.6276,
"wicked":178.3057,
"wickeder":0.5649,
"wickedly":19.9582,
"wickedness":28.6193,
"wicker":33.1381,
"wicket":271.5067,
"wide":3396.0937,
"widely":1033.4955,
"widen":292.4064,
"widened":3.5774,
"wideness":0.9414,
"widening":36.3390,
"wider":26.1716,
"widespread":584.6244,
"widest":1.5063,
"widget":16.7574,
"widow":388.9965,
"widowed":0.5649,
"widower":35.0210,
"width":237.2389,
"wield":94.5190,
"wielding":1.8828,
"wiener":0.7531,
"wife":3229.0850,
"wig":82.4688,
"wiggle":21.0879,
"wight":6.0251,
"wigs":0.5649,
"wild":1020.1273,
"wildcat":10.9205,
"wilde":2.0711,
"wilder":0.5649,
"wilderness":114.6655,
"wildfire":6.2134,
"wildflower":9.4142,
"wildlife":263.4105,
"wildly":141.4019,
"wildness":12.6151,
"wilkinson":0.3766,
"will":48246.2962,
"willed":20.5230,
"willful":0.7531,
"willfully":0.5649,
"williams":1.3180,
"willing":703.6205,
"willingly":82.4688,
"willingness":212.7619,
"willow":76.2554,
"willows":0.1883,
"wilson":5.6485,
"wilt":30.6904,
"wimbledon":0.5649,
"win":4877.1423,
"wince":77.1968,
"winch":44.0587,
"winchester":0.3766,
"wind":1932.3673,
"windchill":0.5649,
"winded":9.0377,
"winder":7.7197,
"windfall":33.3264,
"windhoek":0.1883,
"winding":69.1005,
"windmill":44.4352,
"window":2783.4148,
"windows":7.3431,
"windscreen":86.0462,
"windshield":5.8368,
"windsor":5.2720,
"windsurfing":40.1047,
"windward":12.9917,
"windy":67.5943,
"wine":1225.1695,
"winery":4.5188,
"wines":0.3766,
"wing":1277.5127,
"winged":46.1298,
"winger":121.2554,
"winging":0.3766,
"wining":2.0711,
"wink":104.8747,
"winner":905.6501,
"winning":46.1298,
"winter":1242.8682,
"wintry":21.8410,
"wipe":438.1388,
"wiped":0.1883,
"wiper":35.9624,
"wiping":2.0711,
"wire":620.7751,
"wired":4.1423,
"wireless":71.7365,
"wires":0.5649,
"wiring":65.3348,
"wisdom":269.8122,
"wise":455.6493,
"wisely":67.5943,
"wiser":0.1883,
"wisest":0.7531,
"wish":3493.2487,
"wished":1.3180,
"wishes":0.1883,
"wishful":30.8787,
"wishing":3.2008,
"wisp":25.7950,
"wit":209.5610,
"witch":154.9584,
"witchcraft":51.2135,
"with":118591.9608,
"withdraw":829.9596,
"withdrawal":388.0551,
"withdrawing":1.6946,
"withdrawn":2.4477,
"withhold":137.0714,
"within":8189.2609,
"without":8097.5662,
"withstand":103.9332,
"witness":941.6125,
"witnessed":0.1883,
"witnessing":2.6360,
"witty":75.3139,
"wizard":61.3809,
"wm":0.1883,
"wo":4.5188,
"woe":45.0001,
"wok":7.7197,
"woke":9.9791,
"wolf":163.4312,
"wolfram":0.9414,
"wolverine":1.3180,
"woman":10506.6707,
"womb":73.2428,
"women":7.1548,
"won":15.6276,
"wonder":2449.3975,
"wondered":0.1883,
"wonderful":825.0642,
"wonderfully":90.7533,
"wondering":2.2594,
"wonderland":5.0837,
"wonders":0.1883,
"wondrous":19.0168,
"woo":47.4478,
"wood":1255.4833,
"woodcock":2.2594,
"wooded":65.8997,
"wooden":613.8086,
"woodland":207.8665,
"woodman":3.3891,
"woodpecker":19.7699,
"woods":0.9414,
"woodward":2.8243,
"woodwind":10.3557,
"woodwork":52.7198,
"woodworking":7.5314,
"woody":16.0042,
"woof":3.3891,
"woofer":2.0711,
"wool":326.1093,
"woollen":80.5859,
"woolly":44.8118,
"wop":2.6360,
"worcester":0.3766,
"word":7678.8207,
"worded":0.1883,
"wording":154.2053,
"wordsworth":14.8745,
"wore":2.2594,
"work":25508.6421,
"workable":43.4938,
"workaround":0.1883,
"workbench":12.0502,
"workbook":13.5565,
"workday":2.0711,
"worked":1.5063,
"worker":3202.7252,
"workforce":286.1930,
"working":980.9640,
"workload":94.1424,
"workman":116.1717,
"workmanship":35.3976,
"workout":21.6528,
"workplace":156.0881,
"works":13.5565,
"worksheet":33.8913,
"workshop":519.4779,
"workspace":7.7197,
"workstation":256.0674,
"world":8331.4160,
"worldly":54.4143,
"worldview":3.0126,
"worldwide":356.4232,
"worm":230.6489,
"worming":0.5649,
"worn":68.1591,
"worried":610.6077,
"worry":1511.3624,
"worrying":85.4813,
"worse":49.7072,
"worsen":119.5609,
"worsened":0.1883,
"worsening":9.0377,
"worship":360.0006,
"worshipped":0.1883,
"worshipping":2.2594,
"worst":47.8243,
"wort":8.6611,
"worth":2202.7444,
"worthless":63.6403,
"worthwhile":266.2348,
"worthy":260.0214,
"wot":4.1423,
"would":44638.9469,
"wouldn":0.9414,
"wound":741.6540,
"wounded":25.2302,
"wounding":17.8871,
"wove":11.2971,
"woven":33.8913,
"wow":60.6277,
"wrangler":2.6360,
"wrap":510.8168,
"wrapper":32.7616,
"wrapping":36.3390,
"wrath":53.2846,
"wreath":44.4352,
"wreck":221.6113,
"wreckage":67.0294,
"wrecked":8.2845,
"wrecking":6.2134,
"wren":11.6737,
"wrench":95.8370,
"wrenching":1.5063,
"wrestle":68.1591,
"wrestler":19.7699,
"wrestling":42.1758,
"wretch":17.6988,
"wretched":99.2261,
"wright":3.2008,
"wrinkle":82.4688,
"wrinkled":23.3473,
"wrist":260.5862,
"writ":124.4563,
"writable":0.5649,
"write":7736.8124,
"writer":1279.2072,
"writing":1176.2154,
"writings":0.1883,
"written":10.9205,
"wrong":2825.4023,
"wrongdoing":14.8745,
"wronged":0.7531,
"wrongful":36.5273,
"wrongly":115.4186,
"wrote":0.5649,
"wrought":33.1381,
"wy":0.1883,
"wye":1.3180,
"wylie":0.1883,
"wysiwyg":10.7322,
"x":905.8384,
"xe":0.3766,
"xenon":5.4603,
"xerox":2.6360,
"xi":13.9331,
"xian":0.3766,
"xii":4.1423,
"xiii":1.5063,
"xinjiang":0.1883,
"xix":0.5649,
"xl":2.8243,
"xv":0.9414,
"xvi":0.7531,
"xvii":0.5649,
"xviii":0.7531,
"xx":4.5188,
"xxii":0.1883,
"xxiii":0.1883,
"xxx":7.9080,
"y":170.2095,
"ya":151.5693,
"yacht":220.4815,
"yachting":21.0879,
"yachts":1.5063,
"yahoo":0.9414,
"yak":9.4142,
"yale":0.1883,
"yam":6.5900,
"yang":0.5649,
"yank":32.1967,
"yankee":0.7531,
"yap":4.5188,
"yard":1170.7551,
"yarn":205.0422,
"yarns":0.1883,
"yawn":89.4353,
"ye":123.5149,
"yea":9.2260,
"yeah":6062.5836,
"year":31353.3801,
"yearbook":8.4728,
"yearly":92.6361,
"yearning":48.3892,
"years":1.1297,
"yeast":76.0671,
"yell":226.1301,
"yelling":3.0126,
"yellow":810.7545,
"yellowish":17.1339,
"yellowstone":0.1883,
"yen":76.4436,
"yer":210.3142,
"yes":6219.0483,
"yesterday":3535.9893,
"yet":6138.8390,
"yeti":0.3766,
"yew":37.0921,
"yi":0.1883,
"yiddish":8.2845,
"yield":705.5033,
"yielding":2.0711,
"yin":3.2008,
"ying":0.7531,
"yip":0.3766,
"yoga":37.0921,
"yogi":1.3180,
"yogurt":29.1842,
"yoke":35.2093,
"yolk":38.2218,
"yonder":11.1088,
"york":2.6360,
"yorkshire":5.8368,
"you":118633.1951,
"young":6486.2245,
"younger":2.4477,
"youngest":1.3180,
"youngster":403.8710,
"your":24622.0088,
"yours":289.2055,
"yourself":1993.1833,
"yourselves":11.4854,
"youth":903.3907,
"youthful":92.2596,
"yr":32.9498,
"yuan":16.1925,
"yucca":4.1423,
"yugoslav":98.6613,
"yugoslavia":0.9414,
"yule":1.3180,
"yum":7.9080,
"yummy":6.7783,
"z":190.9208,
"zambia":0.7531,
"zambian":14.1214,
"zanzibar":1.1297,
"zap":10.3557,
"zeal":58.7449,
"zealand":0.3766,
"zealous":32.1967,
"zebra":36.5273,
"zed":0.7531,
"zeitgeist":1.6946,
"zen":2.6360,
"zenith":15.6276,
"zephyr":2.6360,
"zeppelin":3.5774,
"zero":478.6201,
"zest":30.6904,
"zeta":5.8368,
"zillion":1.5063,
"zimbabwe":4.7071,
"zimbabwean":13.5565,
"zinc":76.8202,
"zine":0.5649,
"zion":0.3766,
"zionism":3.2008,
"zionist":16.7574,
"zip":98.4730,
"zipped":10.5440,
"zipper":11.6737,
"zippered":1.5063,
"zips":12.0502,
"zloty":10.1674,
"zn":0.7531,
"zodiac":12.4268,
"zombie":19.0168,
"zone":597.9927,
"zoning":9.2260,
"zoo":90.1884,
"zoological":12.6151,
"zoology":10.9205,
"zoom":61.9457,
"zooming":1.1297,
"zoos":0.3766,
"zu":0.7531,
"zucchini":0.3766,
"zulu":0.3766,
}

if __name__ == '__main__':
	print (len(lemma_mf), lemma_mf['open'], lemma_mf['niche'])