#  Copyright 2021 Data Spree GmbH
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#       http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

from requests.auth import AuthBase


class HTTPTokenAuth(AuthBase):
    """Attaches Token Authentication to the given Request object."""

    def __init__(self, token):
        self.token = token

    def __call__(self, r):
        # add authentication header with token
        r.headers['Authorization'] = 'Token {}'.format(self.token)
        return r
