# Fhircraft modules
import fhircraft
from fhircraft.utils import model_rebuild_all
from fhircraft.fhir.resources.datatypes.primitives import *
from fhircraft.fhir.resources.base import FHIRBaseModel
import fhircraft.fhir.resources.validators as fhir_validators

# Pydantic modules
from pydantic import Field, field_validator, model_validator, BaseModel
from pydantic.fields import FieldInfo

# Standard modules
from typing import Optional, Literal, Union
from enum import Enum

NoneType = type(None)

# Dynamic modules

from fhircraft.fhir.resources.base import FHIRBaseModel

from typing import Optional, List, Literal

from fhircraft.fhir.resources.datatypes.primitives import (
    String,
    Uri,
    Code,
    Canonical,
    DateTime,
    PositiveInt,
    Base64Binary,
    Boolean,
    Date,
    Decimal,
    Id,
    Instant,
    Integer,
    Integer64,
    Markdown,
    Oid,
    Time,
    UnsignedInt,
    Url,
    Uuid,
)

from fhircraft.fhir.resources.datatypes.R5.complex import (
    Element,
    Meta,
    Narrative,
    Resource,
    Extension,
    Identifier,
    Reference,
    CodeableConcept,
    Annotation,
    BackboneElement,
    Period,
    Address,
    Age,
    Attachment,
    CodeableReference,
    Coding,
    ContactPoint,
    Count,
    Distance,
    Duration,
    HumanName,
    Money,
    Quantity,
    Range,
    Ratio,
    RatioRange,
    SampledData,
    Signature,
    Timing,
    ContactDetail,
    DataRequirement,
    Expression,
    ParameterDefinition,
    RelatedArtifact,
    TriggerDefinition,
    UsageContext,
    Availability,
    ExtendedContactDetail,
    Dosage,
    DomainResource,
)


class TransportRestriction(BackboneElement):
    """
    If the Transport.focus is a request resource and the transport is seeking fulfillment (i.e. is asking for the request to be actioned), this element identifies any limitations on what parts of the referenced request should be actioned.
    """

    repetitions: Optional[PositiveInt] = Field(
        description="How many times to repeat",
        default=None,
    )
    repetitions_ext: Optional[Element] = Field(
        description="Placeholder element for repetitions extensions",
        default=None,
        alias="_repetitions",
    )
    period: Optional[Period] = Field(
        description="When fulfillment sought",
        default=None,
    )
    recipient: Optional[List[Reference]] = Field(
        description="For whom is fulfillment sought?",
        default=None,
    )

    @field_validator(
        *(
            "recipient",
            "period",
            "repetitions",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )


class TransportInput(BackboneElement):
    """
    Additional information that may be needed in the execution of the transport.
    """

    type: Optional[CodeableConcept] = Field(
        description="Label for the input",
        default=None,
    )
    valueBase64Binary: Optional[Base64Binary] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueBase64Binary_ext: Optional[Element] = Field(
        description="Placeholder element for valueBase64Binary extensions",
        default=None,
        alias="_valueBase64Binary",
    )
    valueBoolean: Optional[Boolean] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueBoolean_ext: Optional[Element] = Field(
        description="Placeholder element for valueBoolean extensions",
        default=None,
        alias="_valueBoolean",
    )
    valueCanonical: Optional[Canonical] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueCanonical_ext: Optional[Element] = Field(
        description="Placeholder element for valueCanonical extensions",
        default=None,
        alias="_valueCanonical",
    )
    valueCode: Optional[Code] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueCode_ext: Optional[Element] = Field(
        description="Placeholder element for valueCode extensions",
        default=None,
        alias="_valueCode",
    )
    valueDate: Optional[Date] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueDate_ext: Optional[Element] = Field(
        description="Placeholder element for valueDate extensions",
        default=None,
        alias="_valueDate",
    )
    valueDateTime: Optional[DateTime] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueDateTime_ext: Optional[Element] = Field(
        description="Placeholder element for valueDateTime extensions",
        default=None,
        alias="_valueDateTime",
    )
    valueDecimal: Optional[Decimal] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueDecimal_ext: Optional[Element] = Field(
        description="Placeholder element for valueDecimal extensions",
        default=None,
        alias="_valueDecimal",
    )
    valueId: Optional[Id] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueId_ext: Optional[Element] = Field(
        description="Placeholder element for valueId extensions",
        default=None,
        alias="_valueId",
    )
    valueInstant: Optional[Instant] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueInstant_ext: Optional[Element] = Field(
        description="Placeholder element for valueInstant extensions",
        default=None,
        alias="_valueInstant",
    )
    valueInteger: Optional[Integer] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueInteger_ext: Optional[Element] = Field(
        description="Placeholder element for valueInteger extensions",
        default=None,
        alias="_valueInteger",
    )
    valueInteger64: Optional[Integer64] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueMarkdown: Optional[Markdown] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueMarkdown_ext: Optional[Element] = Field(
        description="Placeholder element for valueMarkdown extensions",
        default=None,
        alias="_valueMarkdown",
    )
    valueOid: Optional[Oid] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueOid_ext: Optional[Element] = Field(
        description="Placeholder element for valueOid extensions",
        default=None,
        alias="_valueOid",
    )
    valuePositiveInt: Optional[PositiveInt] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valuePositiveInt_ext: Optional[Element] = Field(
        description="Placeholder element for valuePositiveInt extensions",
        default=None,
        alias="_valuePositiveInt",
    )
    valueString: Optional[String] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueString_ext: Optional[Element] = Field(
        description="Placeholder element for valueString extensions",
        default=None,
        alias="_valueString",
    )
    valueTime: Optional[Time] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueTime_ext: Optional[Element] = Field(
        description="Placeholder element for valueTime extensions",
        default=None,
        alias="_valueTime",
    )
    valueUnsignedInt: Optional[UnsignedInt] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueUnsignedInt_ext: Optional[Element] = Field(
        description="Placeholder element for valueUnsignedInt extensions",
        default=None,
        alias="_valueUnsignedInt",
    )
    valueUri: Optional[Uri] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueUri_ext: Optional[Element] = Field(
        description="Placeholder element for valueUri extensions",
        default=None,
        alias="_valueUri",
    )
    valueUrl: Optional[Url] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueUrl_ext: Optional[Element] = Field(
        description="Placeholder element for valueUrl extensions",
        default=None,
        alias="_valueUrl",
    )
    valueUuid: Optional[Uuid] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueUuid_ext: Optional[Element] = Field(
        description="Placeholder element for valueUuid extensions",
        default=None,
        alias="_valueUuid",
    )
    valueAddress: Optional[Address] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueAge: Optional[Age] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueAnnotation: Optional[Annotation] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueAttachment: Optional[Attachment] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueCodeableConcept: Optional[CodeableConcept] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueCodeableReference: Optional[CodeableReference] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueCoding: Optional[Coding] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueContactPoint: Optional[ContactPoint] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueCount: Optional[Count] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueDistance: Optional[Distance] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueDuration: Optional[Duration] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueHumanName: Optional[HumanName] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueIdentifier: Optional[Identifier] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueMoney: Optional[Money] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valuePeriod: Optional[Period] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueQuantity: Optional[Quantity] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueRange: Optional[Range] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueRatio: Optional[Ratio] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueRatioRange: Optional[RatioRange] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueReference: Optional[Reference] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueSampledData: Optional[SampledData] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueSignature: Optional[Signature] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueTiming: Optional[Timing] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueContactDetail: Optional[ContactDetail] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueDataRequirement: Optional[DataRequirement] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueExpression: Optional[Expression] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueParameterDefinition: Optional[ParameterDefinition] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueRelatedArtifact: Optional[RelatedArtifact] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueTriggerDefinition: Optional[TriggerDefinition] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueUsageContext: Optional[UsageContext] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueAvailability: Optional[Availability] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueExtendedContactDetail: Optional[ExtendedContactDetail] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueDosage: Optional[Dosage] = Field(
        description="Content to use in performing the transport",
        default=None,
    )
    valueMeta: Optional[Meta] = Field(
        description="Content to use in performing the transport",
        default=None,
    )

    @property
    def value(self):
        return fhir_validators.get_type_choice_value_by_base(
            self,
            base="value",
        )

    @field_validator(
        *("type", "modifierExtension", "extension"), mode="after", check_fields=None
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )

    @model_validator(mode="after")
    def value_type_choice_validator(self):
        return fhir_validators.validate_type_choice_element(
            self,
            field_types=[
                Base64Binary,
                Boolean,
                Canonical,
                Code,
                Date,
                DateTime,
                Decimal,
                Id,
                Instant,
                Integer,
                Integer64,
                Markdown,
                Oid,
                PositiveInt,
                String,
                Time,
                UnsignedInt,
                Uri,
                Url,
                Uuid,
                Address,
                Age,
                Annotation,
                Attachment,
                CodeableConcept,
                CodeableReference,
                Coding,
                ContactPoint,
                Count,
                Distance,
                Duration,
                HumanName,
                Identifier,
                Money,
                Period,
                Quantity,
                Range,
                Ratio,
                RatioRange,
                Reference,
                SampledData,
                Signature,
                Timing,
                ContactDetail,
                DataRequirement,
                Expression,
                ParameterDefinition,
                RelatedArtifact,
                TriggerDefinition,
                UsageContext,
                Availability,
                ExtendedContactDetail,
                Dosage,
                Meta,
            ],
            field_name_base="value",
            required=True,
        )


class TransportOutput(BackboneElement):
    """
    Outputs produced by the Transport.
    """

    type: Optional[CodeableConcept] = Field(
        description="Label for output",
        default=None,
    )
    valueBase64Binary: Optional[Base64Binary] = Field(
        description="Result of output",
        default=None,
    )
    valueBase64Binary_ext: Optional[Element] = Field(
        description="Placeholder element for valueBase64Binary extensions",
        default=None,
        alias="_valueBase64Binary",
    )
    valueBoolean: Optional[Boolean] = Field(
        description="Result of output",
        default=None,
    )
    valueBoolean_ext: Optional[Element] = Field(
        description="Placeholder element for valueBoolean extensions",
        default=None,
        alias="_valueBoolean",
    )
    valueCanonical: Optional[Canonical] = Field(
        description="Result of output",
        default=None,
    )
    valueCanonical_ext: Optional[Element] = Field(
        description="Placeholder element for valueCanonical extensions",
        default=None,
        alias="_valueCanonical",
    )
    valueCode: Optional[Code] = Field(
        description="Result of output",
        default=None,
    )
    valueCode_ext: Optional[Element] = Field(
        description="Placeholder element for valueCode extensions",
        default=None,
        alias="_valueCode",
    )
    valueDate: Optional[Date] = Field(
        description="Result of output",
        default=None,
    )
    valueDate_ext: Optional[Element] = Field(
        description="Placeholder element for valueDate extensions",
        default=None,
        alias="_valueDate",
    )
    valueDateTime: Optional[DateTime] = Field(
        description="Result of output",
        default=None,
    )
    valueDateTime_ext: Optional[Element] = Field(
        description="Placeholder element for valueDateTime extensions",
        default=None,
        alias="_valueDateTime",
    )
    valueDecimal: Optional[Decimal] = Field(
        description="Result of output",
        default=None,
    )
    valueDecimal_ext: Optional[Element] = Field(
        description="Placeholder element for valueDecimal extensions",
        default=None,
        alias="_valueDecimal",
    )
    valueId: Optional[Id] = Field(
        description="Result of output",
        default=None,
    )
    valueId_ext: Optional[Element] = Field(
        description="Placeholder element for valueId extensions",
        default=None,
        alias="_valueId",
    )
    valueInstant: Optional[Instant] = Field(
        description="Result of output",
        default=None,
    )
    valueInstant_ext: Optional[Element] = Field(
        description="Placeholder element for valueInstant extensions",
        default=None,
        alias="_valueInstant",
    )
    valueInteger: Optional[Integer] = Field(
        description="Result of output",
        default=None,
    )
    valueInteger_ext: Optional[Element] = Field(
        description="Placeholder element for valueInteger extensions",
        default=None,
        alias="_valueInteger",
    )
    valueInteger64: Optional[Integer64] = Field(
        description="Result of output",
        default=None,
    )
    valueMarkdown: Optional[Markdown] = Field(
        description="Result of output",
        default=None,
    )
    valueMarkdown_ext: Optional[Element] = Field(
        description="Placeholder element for valueMarkdown extensions",
        default=None,
        alias="_valueMarkdown",
    )
    valueOid: Optional[Oid] = Field(
        description="Result of output",
        default=None,
    )
    valueOid_ext: Optional[Element] = Field(
        description="Placeholder element for valueOid extensions",
        default=None,
        alias="_valueOid",
    )
    valuePositiveInt: Optional[PositiveInt] = Field(
        description="Result of output",
        default=None,
    )
    valuePositiveInt_ext: Optional[Element] = Field(
        description="Placeholder element for valuePositiveInt extensions",
        default=None,
        alias="_valuePositiveInt",
    )
    valueString: Optional[String] = Field(
        description="Result of output",
        default=None,
    )
    valueString_ext: Optional[Element] = Field(
        description="Placeholder element for valueString extensions",
        default=None,
        alias="_valueString",
    )
    valueTime: Optional[Time] = Field(
        description="Result of output",
        default=None,
    )
    valueTime_ext: Optional[Element] = Field(
        description="Placeholder element for valueTime extensions",
        default=None,
        alias="_valueTime",
    )
    valueUnsignedInt: Optional[UnsignedInt] = Field(
        description="Result of output",
        default=None,
    )
    valueUnsignedInt_ext: Optional[Element] = Field(
        description="Placeholder element for valueUnsignedInt extensions",
        default=None,
        alias="_valueUnsignedInt",
    )
    valueUri: Optional[Uri] = Field(
        description="Result of output",
        default=None,
    )
    valueUri_ext: Optional[Element] = Field(
        description="Placeholder element for valueUri extensions",
        default=None,
        alias="_valueUri",
    )
    valueUrl: Optional[Url] = Field(
        description="Result of output",
        default=None,
    )
    valueUrl_ext: Optional[Element] = Field(
        description="Placeholder element for valueUrl extensions",
        default=None,
        alias="_valueUrl",
    )
    valueUuid: Optional[Uuid] = Field(
        description="Result of output",
        default=None,
    )
    valueUuid_ext: Optional[Element] = Field(
        description="Placeholder element for valueUuid extensions",
        default=None,
        alias="_valueUuid",
    )
    valueAddress: Optional[Address] = Field(
        description="Result of output",
        default=None,
    )
    valueAge: Optional[Age] = Field(
        description="Result of output",
        default=None,
    )
    valueAnnotation: Optional[Annotation] = Field(
        description="Result of output",
        default=None,
    )
    valueAttachment: Optional[Attachment] = Field(
        description="Result of output",
        default=None,
    )
    valueCodeableConcept: Optional[CodeableConcept] = Field(
        description="Result of output",
        default=None,
    )
    valueCodeableReference: Optional[CodeableReference] = Field(
        description="Result of output",
        default=None,
    )
    valueCoding: Optional[Coding] = Field(
        description="Result of output",
        default=None,
    )
    valueContactPoint: Optional[ContactPoint] = Field(
        description="Result of output",
        default=None,
    )
    valueCount: Optional[Count] = Field(
        description="Result of output",
        default=None,
    )
    valueDistance: Optional[Distance] = Field(
        description="Result of output",
        default=None,
    )
    valueDuration: Optional[Duration] = Field(
        description="Result of output",
        default=None,
    )
    valueHumanName: Optional[HumanName] = Field(
        description="Result of output",
        default=None,
    )
    valueIdentifier: Optional[Identifier] = Field(
        description="Result of output",
        default=None,
    )
    valueMoney: Optional[Money] = Field(
        description="Result of output",
        default=None,
    )
    valuePeriod: Optional[Period] = Field(
        description="Result of output",
        default=None,
    )
    valueQuantity: Optional[Quantity] = Field(
        description="Result of output",
        default=None,
    )
    valueRange: Optional[Range] = Field(
        description="Result of output",
        default=None,
    )
    valueRatio: Optional[Ratio] = Field(
        description="Result of output",
        default=None,
    )
    valueRatioRange: Optional[RatioRange] = Field(
        description="Result of output",
        default=None,
    )
    valueReference: Optional[Reference] = Field(
        description="Result of output",
        default=None,
    )
    valueSampledData: Optional[SampledData] = Field(
        description="Result of output",
        default=None,
    )
    valueSignature: Optional[Signature] = Field(
        description="Result of output",
        default=None,
    )
    valueTiming: Optional[Timing] = Field(
        description="Result of output",
        default=None,
    )
    valueContactDetail: Optional[ContactDetail] = Field(
        description="Result of output",
        default=None,
    )
    valueDataRequirement: Optional[DataRequirement] = Field(
        description="Result of output",
        default=None,
    )
    valueExpression: Optional[Expression] = Field(
        description="Result of output",
        default=None,
    )
    valueParameterDefinition: Optional[ParameterDefinition] = Field(
        description="Result of output",
        default=None,
    )
    valueRelatedArtifact: Optional[RelatedArtifact] = Field(
        description="Result of output",
        default=None,
    )
    valueTriggerDefinition: Optional[TriggerDefinition] = Field(
        description="Result of output",
        default=None,
    )
    valueUsageContext: Optional[UsageContext] = Field(
        description="Result of output",
        default=None,
    )
    valueAvailability: Optional[Availability] = Field(
        description="Result of output",
        default=None,
    )
    valueExtendedContactDetail: Optional[ExtendedContactDetail] = Field(
        description="Result of output",
        default=None,
    )
    valueDosage: Optional[Dosage] = Field(
        description="Result of output",
        default=None,
    )
    valueMeta: Optional[Meta] = Field(
        description="Result of output",
        default=None,
    )

    @property
    def value(self):
        return fhir_validators.get_type_choice_value_by_base(
            self,
            base="value",
        )

    @field_validator(
        *("type", "modifierExtension", "extension"), mode="after", check_fields=None
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )

    @model_validator(mode="after")
    def value_type_choice_validator(self):
        return fhir_validators.validate_type_choice_element(
            self,
            field_types=[
                Base64Binary,
                Boolean,
                Canonical,
                Code,
                Date,
                DateTime,
                Decimal,
                Id,
                Instant,
                Integer,
                Integer64,
                Markdown,
                Oid,
                PositiveInt,
                String,
                Time,
                UnsignedInt,
                Uri,
                Url,
                Uuid,
                Address,
                Age,
                Annotation,
                Attachment,
                CodeableConcept,
                CodeableReference,
                Coding,
                ContactPoint,
                Count,
                Distance,
                Duration,
                HumanName,
                Identifier,
                Money,
                Period,
                Quantity,
                Range,
                Ratio,
                RatioRange,
                Reference,
                SampledData,
                Signature,
                Timing,
                ContactDetail,
                DataRequirement,
                Expression,
                ParameterDefinition,
                RelatedArtifact,
                TriggerDefinition,
                UsageContext,
                Availability,
                ExtendedContactDetail,
                Dosage,
                Meta,
            ],
            field_name_base="value",
            required=True,
        )


class Transport(DomainResource):
    """
    Record of transport.
    """

    id: Optional[String] = Field(
        description="Logical id of this artifact",
        default=None,
    )
    id_ext: Optional[Element] = Field(
        description="Placeholder element for id extensions",
        default=None,
        alias="_id",
    )
    meta: Optional[Meta] = Field(
        description="Metadata about the resource.",
        default_factory=lambda: Meta(
            profile=["http://hl7.org/fhir/StructureDefinition/Transport"]
        ),
    )
    implicitRules: Optional[Uri] = Field(
        description="A set of rules under which this content was created",
        default=None,
    )
    implicitRules_ext: Optional[Element] = Field(
        description="Placeholder element for implicitRules extensions",
        default=None,
        alias="_implicitRules",
    )
    language: Optional[Code] = Field(
        description="Language of the resource content",
        default=None,
    )
    language_ext: Optional[Element] = Field(
        description="Placeholder element for language extensions",
        default=None,
        alias="_language",
    )
    text: Optional[Narrative] = Field(
        description="Text summary of the resource, for human interpretation",
        default=None,
    )
    contained: Optional[List[Resource]] = Field(
        description="Contained, inline Resources",
        default=None,
    )
    extension: Optional[List[Extension]] = Field(
        description="Additional content defined by implementations",
        default=None,
    )
    modifierExtension: Optional[List[Extension]] = Field(
        description="Extensions that cannot be ignored",
        default=None,
    )
    identifier: Optional[List[Identifier]] = Field(
        description="External identifier",
        default=None,
    )
    instantiatesCanonical: Optional[Canonical] = Field(
        description="Formal definition of transport",
        default=None,
    )
    instantiatesCanonical_ext: Optional[Element] = Field(
        description="Placeholder element for instantiatesCanonical extensions",
        default=None,
        alias="_instantiatesCanonical",
    )
    instantiatesUri: Optional[Uri] = Field(
        description="Formal definition of transport",
        default=None,
    )
    instantiatesUri_ext: Optional[Element] = Field(
        description="Placeholder element for instantiatesUri extensions",
        default=None,
        alias="_instantiatesUri",
    )
    basedOn: Optional[List[Reference]] = Field(
        description="Request fulfilled by this transport",
        default=None,
    )
    groupIdentifier: Optional[Identifier] = Field(
        description="Requisition or grouper id",
        default=None,
    )
    partOf: Optional[List[Reference]] = Field(
        description="Part of referenced event",
        default=None,
    )
    status: Optional[Code] = Field(
        description="in-progress | completed | abandoned | cancelled | planned | entered-in-error",
        default=None,
    )
    status_ext: Optional[Element] = Field(
        description="Placeholder element for status extensions",
        default=None,
        alias="_status",
    )
    statusReason: Optional[CodeableConcept] = Field(
        description="Reason for current status",
        default=None,
    )
    intent: Optional[Code] = Field(
        description="unknown | proposal | plan | order | original-order | reflex-order | filler-order | instance-order | option",
        default=None,
    )
    intent_ext: Optional[Element] = Field(
        description="Placeholder element for intent extensions",
        default=None,
        alias="_intent",
    )
    priority: Optional[Code] = Field(
        description="routine | urgent | asap | stat",
        default=None,
    )
    priority_ext: Optional[Element] = Field(
        description="Placeholder element for priority extensions",
        default=None,
        alias="_priority",
    )
    code: Optional[CodeableConcept] = Field(
        description="Transport Type",
        default=None,
    )
    description: Optional[String] = Field(
        description="Human-readable explanation of transport",
        default=None,
    )
    description_ext: Optional[Element] = Field(
        description="Placeholder element for description extensions",
        default=None,
        alias="_description",
    )
    focus: Optional[Reference] = Field(
        description="What transport is acting on",
        default=None,
    )
    for_: Optional[Reference] = Field(
        description="Beneficiary of the Transport",
        default=None,
    )
    encounter: Optional[Reference] = Field(
        description="Healthcare event during which this transport originated",
        default=None,
    )
    completionTime: Optional[DateTime] = Field(
        description="Completion time of the event (the occurrence)",
        default=None,
    )
    completionTime_ext: Optional[Element] = Field(
        description="Placeholder element for completionTime extensions",
        default=None,
        alias="_completionTime",
    )
    authoredOn: Optional[DateTime] = Field(
        description="Transport Creation Date",
        default=None,
    )
    authoredOn_ext: Optional[Element] = Field(
        description="Placeholder element for authoredOn extensions",
        default=None,
        alias="_authoredOn",
    )
    lastModified: Optional[DateTime] = Field(
        description="Transport Last Modified Date",
        default=None,
    )
    lastModified_ext: Optional[Element] = Field(
        description="Placeholder element for lastModified extensions",
        default=None,
        alias="_lastModified",
    )
    requester: Optional[Reference] = Field(
        description="Who is asking for transport to be done",
        default=None,
    )
    performerType: Optional[List[CodeableConcept]] = Field(
        description="Requested performer",
        default=None,
    )
    owner: Optional[Reference] = Field(
        description="Responsible individual",
        default=None,
    )
    location: Optional[Reference] = Field(
        description="Where transport occurs",
        default=None,
    )
    insurance: Optional[List[Reference]] = Field(
        description="Associated insurance coverage",
        default=None,
    )
    note: Optional[List[Annotation]] = Field(
        description="Comments made about the transport",
        default=None,
    )
    relevantHistory: Optional[List[Reference]] = Field(
        description="Key events in history of the Transport",
        default=None,
    )
    restriction: Optional[TransportRestriction] = Field(
        description="Constraints on fulfillment transports",
        default=None,
    )
    input: Optional[List[TransportInput]] = Field(
        description="Information used to perform transport",
        default=None,
    )
    output: Optional[List[TransportOutput]] = Field(
        description="Information produced as part of transport",
        default=None,
    )
    requestedLocation: Optional[Reference] = Field(
        description="The desired location",
        default=None,
    )
    currentLocation: Optional[Reference] = Field(
        description="The entity current location",
        default=None,
    )
    reason: Optional[CodeableReference] = Field(
        description="Why transport is needed",
        default=None,
    )
    history: Optional[Reference] = Field(
        description="Parent (or preceding) transport",
        default=None,
    )
    resourceType: Literal["Transport"] = Field(
        description=None,
        default="Transport",
    )

    @field_validator(
        *(
            "history",
            "reason",
            "currentLocation",
            "requestedLocation",
            "output",
            "input",
            "restriction",
            "relevantHistory",
            "note",
            "insurance",
            "location",
            "owner",
            "performerType",
            "requester",
            "lastModified",
            "authoredOn",
            "completionTime",
            "encounter",
            "for_",
            "focus",
            "description",
            "code",
            "priority",
            "intent",
            "statusReason",
            "status",
            "partOf",
            "groupIdentifier",
            "basedOn",
            "instantiatesUri",
            "instantiatesCanonical",
            "identifier",
            "modifierExtension",
            "extension",
            "text",
            "language",
            "implicitRules",
            "meta",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )

    @field_validator(
        *("modifierExtension", "extension"), mode="after", check_fields=None
    )
    @classmethod
    def FHIR_ext_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="extension.exists() != value.exists()",
            human="Must have either extensions or value[x], not both",
            key="ext-1",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_2_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.contained.empty()",
            human="If the resource is contained in another resource, it SHALL NOT contain nested Resources",
            key="dom-2",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_3_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.where((('#'+id in (%resource.descendants().reference | %resource.descendants().ofType(canonical) | %resource.descendants().ofType(uri) | %resource.descendants().ofType(url))) or descendants().where(reference = '#').exists() or descendants().where(ofType(canonical) = '#').exists() or descendants().where(ofType(canonical) = '#').exists()).not()).trace('unmatched', id).empty()",
            human="If the resource is contained in another resource, it SHALL be referred to from elsewhere in the resource or SHALL refer to the containing resource",
            key="dom-3",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_4_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.meta.versionId.empty() and contained.meta.lastUpdated.empty()",
            human="If a resource is contained in another resource, it SHALL NOT have a meta.versionId or a meta.lastUpdated",
            key="dom-4",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_5_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.meta.security.empty()",
            human="If a resource is contained in another resource, it SHALL NOT have a security label",
            key="dom-5",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_6_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="text.`div`.exists()",
            human="A resource should have narrative for robust management",
            key="dom-6",
            severity="warning",
        )
