# Fhircraft modules
import fhircraft
from fhircraft.utils import model_rebuild_all
from fhircraft.fhir.resources.datatypes.primitives import *
from fhircraft.fhir.resources.base import FHIRBaseModel
import fhircraft.fhir.resources.validators as fhir_validators

# Pydantic modules
from pydantic import Field, field_validator, model_validator, BaseModel
from pydantic.fields import FieldInfo

# Standard modules
from typing import Optional, Literal, Union
from enum import Enum

NoneType = type(None)

# Dynamic modules

from fhircraft.fhir.resources.base import FHIRBaseModel

from typing import Optional, List, Literal

from fhircraft.fhir.resources.datatypes.primitives import (
    String,
    Uri,
    Code,
    Boolean,
    DateTime,
    Markdown,
    Date,
    Canonical,
)

from fhircraft.fhir.resources.datatypes.R5.complex import (
    Element,
    Meta,
    Narrative,
    Resource,
    Extension,
    Identifier,
    Coding,
    ContactDetail,
    UsageContext,
    CodeableConcept,
    Period,
    Reference,
    BackboneElement,
    Range,
    DomainResource,
)


class ObservationDefinitionQualifiedValue(BackboneElement):
    """
    A set of qualified values associated with a context and a set of conditions -  provides a range for quantitative and ordinal observations and a collection of value sets for qualitative observations.
    """

    context: Optional[CodeableConcept] = Field(
        description="Context qualifier for the set of qualified values",
        default=None,
    )
    appliesTo: Optional[List[CodeableConcept]] = Field(
        description="Targetted population for the set of qualified values",
        default=None,
    )
    gender: Optional[Code] = Field(
        description="male | female | other | unknown",
        default=None,
    )
    gender_ext: Optional[Element] = Field(
        description="Placeholder element for gender extensions",
        default=None,
        alias="_gender",
    )
    age: Optional[Range] = Field(
        description="Applicable age range for the set of qualified values",
        default=None,
    )
    gestationalAge: Optional[Range] = Field(
        description="Applicable gestational age range for the set of qualified values",
        default=None,
    )
    condition: Optional[String] = Field(
        description="Condition associated with the set of qualified values",
        default=None,
    )
    condition_ext: Optional[Element] = Field(
        description="Placeholder element for condition extensions",
        default=None,
        alias="_condition",
    )
    rangeCategory: Optional[Code] = Field(
        description="reference | critical | absolute",
        default=None,
    )
    rangeCategory_ext: Optional[Element] = Field(
        description="Placeholder element for rangeCategory extensions",
        default=None,
        alias="_rangeCategory",
    )
    range: Optional[Range] = Field(
        description="The range for continuous or ordinal observations",
        default=None,
    )
    validCodedValueSet: Optional[Canonical] = Field(
        description="Value set of valid coded values as part of this set of qualified values",
        default=None,
    )
    validCodedValueSet_ext: Optional[Element] = Field(
        description="Placeholder element for validCodedValueSet extensions",
        default=None,
        alias="_validCodedValueSet",
    )
    normalCodedValueSet: Optional[Canonical] = Field(
        description="Value set of normal coded values as part of this set of qualified values",
        default=None,
    )
    normalCodedValueSet_ext: Optional[Element] = Field(
        description="Placeholder element for normalCodedValueSet extensions",
        default=None,
        alias="_normalCodedValueSet",
    )
    abnormalCodedValueSet: Optional[Canonical] = Field(
        description="Value set of abnormal coded values as part of this set of qualified values",
        default=None,
    )
    abnormalCodedValueSet_ext: Optional[Element] = Field(
        description="Placeholder element for abnormalCodedValueSet extensions",
        default=None,
        alias="_abnormalCodedValueSet",
    )
    criticalCodedValueSet: Optional[Canonical] = Field(
        description="Value set of critical coded values as part of this set of qualified values",
        default=None,
    )
    criticalCodedValueSet_ext: Optional[Element] = Field(
        description="Placeholder element for criticalCodedValueSet extensions",
        default=None,
        alias="_criticalCodedValueSet",
    )

    @field_validator(
        *(
            "criticalCodedValueSet",
            "abnormalCodedValueSet",
            "normalCodedValueSet",
            "validCodedValueSet",
            "range",
            "rangeCategory",
            "condition",
            "gestationalAge",
            "age",
            "gender",
            "appliesTo",
            "context",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )


class ObservationDefinitionComponentQualifiedValue(BackboneElement):
    """
    A set of qualified values associated with a context and a set of conditions -  provides a range for quantitative and ordinal observations and a collection of value sets for qualitative observations.
    """

    context: Optional[CodeableConcept] = Field(
        description="Context qualifier for the set of qualified values",
        default=None,
    )
    appliesTo: Optional[List[CodeableConcept]] = Field(
        description="Targetted population for the set of qualified values",
        default=None,
    )
    gender: Optional[Code] = Field(
        description="male | female | other | unknown",
        default=None,
    )
    gender_ext: Optional[Element] = Field(
        description="Placeholder element for gender extensions",
        default=None,
        alias="_gender",
    )
    age: Optional[Range] = Field(
        description="Applicable age range for the set of qualified values",
        default=None,
    )
    gestationalAge: Optional[Range] = Field(
        description="Applicable gestational age range for the set of qualified values",
        default=None,
    )
    condition: Optional[String] = Field(
        description="Condition associated with the set of qualified values",
        default=None,
    )
    condition_ext: Optional[Element] = Field(
        description="Placeholder element for condition extensions",
        default=None,
        alias="_condition",
    )
    rangeCategory: Optional[Code] = Field(
        description="reference | critical | absolute",
        default=None,
    )
    rangeCategory_ext: Optional[Element] = Field(
        description="Placeholder element for rangeCategory extensions",
        default=None,
        alias="_rangeCategory",
    )
    range: Optional[Range] = Field(
        description="The range for continuous or ordinal observations",
        default=None,
    )
    validCodedValueSet: Optional[Canonical] = Field(
        description="Value set of valid coded values as part of this set of qualified values",
        default=None,
    )
    validCodedValueSet_ext: Optional[Element] = Field(
        description="Placeholder element for validCodedValueSet extensions",
        default=None,
        alias="_validCodedValueSet",
    )
    normalCodedValueSet: Optional[Canonical] = Field(
        description="Value set of normal coded values as part of this set of qualified values",
        default=None,
    )
    normalCodedValueSet_ext: Optional[Element] = Field(
        description="Placeholder element for normalCodedValueSet extensions",
        default=None,
        alias="_normalCodedValueSet",
    )
    abnormalCodedValueSet: Optional[Canonical] = Field(
        description="Value set of abnormal coded values as part of this set of qualified values",
        default=None,
    )
    abnormalCodedValueSet_ext: Optional[Element] = Field(
        description="Placeholder element for abnormalCodedValueSet extensions",
        default=None,
        alias="_abnormalCodedValueSet",
    )
    criticalCodedValueSet: Optional[Canonical] = Field(
        description="Value set of critical coded values as part of this set of qualified values",
        default=None,
    )
    criticalCodedValueSet_ext: Optional[Element] = Field(
        description="Placeholder element for criticalCodedValueSet extensions",
        default=None,
        alias="_criticalCodedValueSet",
    )

    @field_validator(
        *(
            "criticalCodedValueSet",
            "abnormalCodedValueSet",
            "normalCodedValueSet",
            "validCodedValueSet",
            "range",
            "rangeCategory",
            "condition",
            "gestationalAge",
            "age",
            "gender",
            "appliesTo",
            "context",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )


class ObservationDefinitionComponent(BackboneElement):
    """
    Some observations have multiple component observations, expressed as separate code value pairs.
    """

    code: Optional[CodeableConcept] = Field(
        description="Type of observation",
        default=None,
    )
    permittedDataType: Optional[List[Code]] = Field(
        description="Quantity | CodeableConcept | string | boolean | integer | Range | Ratio | SampledData | time | dateTime | Period",
        default=None,
    )
    permittedDataType_ext: Optional[Element] = Field(
        description="Placeholder element for permittedDataType extensions",
        default=None,
        alias="_permittedDataType",
    )
    permittedUnit: Optional[List[Coding]] = Field(
        description="Unit for quantitative results",
        default=None,
    )
    qualifiedValue: Optional[List[ObservationDefinitionComponentQualifiedValue]] = (
        Field(
            description="Set of qualified values for observation results",
            default=None,
        )
    )

    @field_validator(
        *(
            "qualifiedValue",
            "permittedUnit",
            "permittedDataType",
            "code",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )


class ObservationDefinition(DomainResource):
    """
    Set of definitional characteristics for a kind of observation or measurement produced or consumed by an orderable health care service.
    """

    id: Optional[String] = Field(
        description="Logical id of this artifact",
        default=None,
    )
    id_ext: Optional[Element] = Field(
        description="Placeholder element for id extensions",
        default=None,
        alias="_id",
    )
    meta: Optional[Meta] = Field(
        description="Metadata about the resource.",
        default_factory=lambda: Meta(
            profile=["http://hl7.org/fhir/StructureDefinition/ObservationDefinition"]
        ),
    )
    implicitRules: Optional[Uri] = Field(
        description="A set of rules under which this content was created",
        default=None,
    )
    implicitRules_ext: Optional[Element] = Field(
        description="Placeholder element for implicitRules extensions",
        default=None,
        alias="_implicitRules",
    )
    language: Optional[Code] = Field(
        description="Language of the resource content",
        default=None,
    )
    language_ext: Optional[Element] = Field(
        description="Placeholder element for language extensions",
        default=None,
        alias="_language",
    )
    text: Optional[Narrative] = Field(
        description="Text summary of the resource, for human interpretation",
        default=None,
    )
    contained: Optional[List[Resource]] = Field(
        description="Contained, inline Resources",
        default=None,
    )
    extension: Optional[List[Extension]] = Field(
        description="Additional content defined by implementations",
        default=None,
    )
    modifierExtension: Optional[List[Extension]] = Field(
        description="Extensions that cannot be ignored",
        default=None,
    )
    url: Optional[Uri] = Field(
        description="Logical canonical URL to reference this ObservationDefinition (globally unique)",
        default=None,
    )
    url_ext: Optional[Element] = Field(
        description="Placeholder element for url extensions",
        default=None,
        alias="_url",
    )
    identifier: Optional[Identifier] = Field(
        description="Business identifier of the ObservationDefinition",
        default=None,
    )
    version: Optional[String] = Field(
        description="Business version of the ObservationDefinition",
        default=None,
    )
    version_ext: Optional[Element] = Field(
        description="Placeholder element for version extensions",
        default=None,
        alias="_version",
    )
    versionAlgorithmString: Optional[String] = Field(
        description="How to compare versions",
        default=None,
    )
    versionAlgorithmString_ext: Optional[Element] = Field(
        description="Placeholder element for versionAlgorithmString extensions",
        default=None,
        alias="_versionAlgorithmString",
    )
    versionAlgorithmCoding: Optional[Coding] = Field(
        description="How to compare versions",
        default=None,
    )
    name: Optional[String] = Field(
        description="Name for this ObservationDefinition (computer friendly)",
        default=None,
    )
    name_ext: Optional[Element] = Field(
        description="Placeholder element for name extensions",
        default=None,
        alias="_name",
    )
    title: Optional[String] = Field(
        description="Name for this ObservationDefinition (human friendly)",
        default=None,
    )
    title_ext: Optional[Element] = Field(
        description="Placeholder element for title extensions",
        default=None,
        alias="_title",
    )
    status: Optional[Code] = Field(
        description="draft | active | retired | unknown",
        default=None,
    )
    status_ext: Optional[Element] = Field(
        description="Placeholder element for status extensions",
        default=None,
        alias="_status",
    )
    experimental: Optional[Boolean] = Field(
        description="If for testing purposes, not real usage",
        default=None,
    )
    experimental_ext: Optional[Element] = Field(
        description="Placeholder element for experimental extensions",
        default=None,
        alias="_experimental",
    )
    date: Optional[DateTime] = Field(
        description="Date last changed",
        default=None,
    )
    date_ext: Optional[Element] = Field(
        description="Placeholder element for date extensions",
        default=None,
        alias="_date",
    )
    publisher: Optional[String] = Field(
        description="The name of the individual or organization that published the ObservationDefinition",
        default=None,
    )
    publisher_ext: Optional[Element] = Field(
        description="Placeholder element for publisher extensions",
        default=None,
        alias="_publisher",
    )
    contact: Optional[List[ContactDetail]] = Field(
        description="Contact details for the publisher",
        default=None,
    )
    description: Optional[Markdown] = Field(
        description="Natural language description of the ObservationDefinition",
        default=None,
    )
    description_ext: Optional[Element] = Field(
        description="Placeholder element for description extensions",
        default=None,
        alias="_description",
    )
    useContext: Optional[List[UsageContext]] = Field(
        description="Content intends to support these contexts",
        default=None,
    )
    jurisdiction: Optional[List[CodeableConcept]] = Field(
        description="Intended jurisdiction for this ObservationDefinition (if applicable)",
        default=None,
    )
    purpose: Optional[Markdown] = Field(
        description="Why this ObservationDefinition is defined",
        default=None,
    )
    purpose_ext: Optional[Element] = Field(
        description="Placeholder element for purpose extensions",
        default=None,
        alias="_purpose",
    )
    copyright: Optional[Markdown] = Field(
        description="Use and/or publishing restrictions",
        default=None,
    )
    copyright_ext: Optional[Element] = Field(
        description="Placeholder element for copyright extensions",
        default=None,
        alias="_copyright",
    )
    copyrightLabel: Optional[String] = Field(
        description="Copyright holder and year(s)",
        default=None,
    )
    copyrightLabel_ext: Optional[Element] = Field(
        description="Placeholder element for copyrightLabel extensions",
        default=None,
        alias="_copyrightLabel",
    )
    approvalDate: Optional[Date] = Field(
        description="When ObservationDefinition was approved by publisher",
        default=None,
    )
    approvalDate_ext: Optional[Element] = Field(
        description="Placeholder element for approvalDate extensions",
        default=None,
        alias="_approvalDate",
    )
    lastReviewDate: Optional[Date] = Field(
        description="Date on which the asset content was last reviewed by the publisher",
        default=None,
    )
    lastReviewDate_ext: Optional[Element] = Field(
        description="Placeholder element for lastReviewDate extensions",
        default=None,
        alias="_lastReviewDate",
    )
    effectivePeriod: Optional[Period] = Field(
        description="The effective date range for the ObservationDefinition",
        default=None,
    )
    derivedFromCanonical: Optional[List[Canonical]] = Field(
        description="Based on FHIR definition of another observation",
        default=None,
    )
    derivedFromCanonical_ext: Optional[Element] = Field(
        description="Placeholder element for derivedFromCanonical extensions",
        default=None,
        alias="_derivedFromCanonical",
    )
    derivedFromUri: Optional[List[Uri]] = Field(
        description="Based on external definition",
        default=None,
    )
    derivedFromUri_ext: Optional[Element] = Field(
        description="Placeholder element for derivedFromUri extensions",
        default=None,
        alias="_derivedFromUri",
    )
    subject: Optional[List[CodeableConcept]] = Field(
        description="Type of subject for the defined observation",
        default=None,
    )
    performerType: Optional[CodeableConcept] = Field(
        description="Desired kind of performer for such kind of observation",
        default=None,
    )
    category: Optional[List[CodeableConcept]] = Field(
        description="General type of observation",
        default=None,
    )
    code: Optional[CodeableConcept] = Field(
        description="Type of observation",
        default=None,
    )
    permittedDataType: Optional[List[Code]] = Field(
        description="Quantity | CodeableConcept | string | boolean | integer | Range | Ratio | SampledData | time | dateTime | Period",
        default=None,
    )
    permittedDataType_ext: Optional[Element] = Field(
        description="Placeholder element for permittedDataType extensions",
        default=None,
        alias="_permittedDataType",
    )
    multipleResultsAllowed: Optional[Boolean] = Field(
        description="Multiple results allowed for conforming observations",
        default=None,
    )
    multipleResultsAllowed_ext: Optional[Element] = Field(
        description="Placeholder element for multipleResultsAllowed extensions",
        default=None,
        alias="_multipleResultsAllowed",
    )
    bodySite: Optional[CodeableConcept] = Field(
        description="Body part to be observed",
        default=None,
    )
    method: Optional[CodeableConcept] = Field(
        description="Method used to produce the observation",
        default=None,
    )
    specimen: Optional[List[Reference]] = Field(
        description="Kind of specimen used by this type of observation",
        default=None,
    )
    device: Optional[List[Reference]] = Field(
        description="Measurement device or model of device",
        default=None,
    )
    preferredReportName: Optional[String] = Field(
        description="The preferred name to be used when reporting the observation results",
        default=None,
    )
    preferredReportName_ext: Optional[Element] = Field(
        description="Placeholder element for preferredReportName extensions",
        default=None,
        alias="_preferredReportName",
    )
    permittedUnit: Optional[List[Coding]] = Field(
        description="Unit for quantitative results",
        default=None,
    )
    qualifiedValue: Optional[List[ObservationDefinitionQualifiedValue]] = Field(
        description="Set of qualified values for observation results",
        default=None,
    )
    hasMember: Optional[List[Reference]] = Field(
        description="Definitions of related resources belonging to this kind of observation group",
        default=None,
    )
    component: Optional[List[ObservationDefinitionComponent]] = Field(
        description="Component results",
        default=None,
    )
    resourceType: Literal["ObservationDefinition"] = Field(
        description=None,
        default="ObservationDefinition",
    )

    @property
    def versionAlgorithm(self):
        return fhir_validators.get_type_choice_value_by_base(
            self,
            base="versionAlgorithm",
        )

    @field_validator(
        *(
            "component",
            "hasMember",
            "qualifiedValue",
            "permittedUnit",
            "preferredReportName",
            "device",
            "specimen",
            "method",
            "bodySite",
            "multipleResultsAllowed",
            "permittedDataType",
            "code",
            "category",
            "performerType",
            "subject",
            "derivedFromUri",
            "derivedFromCanonical",
            "effectivePeriod",
            "lastReviewDate",
            "approvalDate",
            "copyrightLabel",
            "copyright",
            "purpose",
            "jurisdiction",
            "useContext",
            "description",
            "contact",
            "publisher",
            "date",
            "experimental",
            "status",
            "title",
            "name",
            "version",
            "identifier",
            "url",
            "modifierExtension",
            "extension",
            "text",
            "language",
            "implicitRules",
            "meta",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )

    @field_validator(
        *("modifierExtension", "extension"), mode="after", check_fields=None
    )
    @classmethod
    def FHIR_ext_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="extension.exists() != value.exists()",
            human="Must have either extensions or value[x], not both",
            key="ext-1",
            severity="error",
        )

    @field_validator(*("component",), mode="after", check_fields=None)
    @classmethod
    def FHIR_obd_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="permittedUnit.exists() implies (permittedDataType = 'Quantity').exists()",
            human="If permittedUnit exists, then permittedDataType=Quantity must exist.",
            key="obd-1",
            severity="error",
        )

    @model_validator(mode="after")
    def versionAlgorithm_type_choice_validator(self):
        return fhir_validators.validate_type_choice_element(
            self,
            field_types=[String, Coding],
            field_name_base="versionAlgorithm",
            required=False,
        )

    @model_validator(mode="after")
    def FHIR_cnl_0_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="name.exists() implies name.matches('^[A-Z]([A-Za-z0-9_]){1,254}$')",
            human="Name should be usable as an identifier for the module by machine processing applications such as code generation",
            key="cnl-0",
            severity="warning",
        )

    @model_validator(mode="after")
    def FHIR_obd_0_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="permittedUnit.exists() implies (permittedDataType = 'Quantity').exists()",
            human="If permittedUnit exists, then permittedDataType=Quantity must exist.",
            key="obd-0",
            severity="error",
        )
