# Fhircraft modules
import fhircraft
from fhircraft.utils import model_rebuild_all
from fhircraft.fhir.resources.datatypes.primitives import *
from fhircraft.fhir.resources.base import FHIRBaseModel
import fhircraft.fhir.resources.validators as fhir_validators

# Pydantic modules
from pydantic import Field, field_validator, model_validator, BaseModel
from pydantic.fields import FieldInfo

# Standard modules
from typing import Optional, Literal, Union
from enum import Enum

NoneType = type(None)

# Dynamic modules

from fhircraft.fhir.resources.base import FHIRBaseModel

from typing import Optional, List, Literal

from fhircraft.fhir.resources.datatypes.primitives import (
    String,
    Uri,
    Code,
    Boolean,
    DateTime,
    Markdown,
    Date,
    Canonical,
)

from fhircraft.fhir.resources.datatypes.R4B.complex import (
    Element,
    Meta,
    Narrative,
    Resource,
    Extension,
    Identifier,
    CodeableConcept,
    Reference,
    ContactDetail,
    UsageContext,
    Period,
    RelatedArtifact,
    BackboneElement,
    Expression,
    DataRequirement,
    Duration,
    Timing,
    DomainResource,
)


class ResearchElementDefinitionCharacteristic(BackboneElement):
    """
    A characteristic that defines the members of the research element. Multiple characteristics are applied with "and" semantics.
    """

    definitionCodeableConcept: Optional[CodeableConcept] = Field(
        description="What code or expression defines members?",
        default=None,
    )
    definitionCanonical: Optional[Canonical] = Field(
        description="What code or expression defines members?",
        default=None,
    )
    definitionCanonical_ext: Optional[Element] = Field(
        description="Placeholder element for definitionCanonical extensions",
        default=None,
        alias="_definitionCanonical",
    )
    definitionExpression: Optional[Expression] = Field(
        description="What code or expression defines members?",
        default=None,
    )
    definitionDataRequirement: Optional[DataRequirement] = Field(
        description="What code or expression defines members?",
        default=None,
    )
    usageContext: Optional[List[UsageContext]] = Field(
        description="What code/value pairs define members?",
        default=None,
    )
    exclude: Optional[Boolean] = Field(
        description="Whether the characteristic includes or excludes members",
        default=None,
    )
    exclude_ext: Optional[Element] = Field(
        description="Placeholder element for exclude extensions",
        default=None,
        alias="_exclude",
    )
    unitOfMeasure: Optional[CodeableConcept] = Field(
        description="What unit is the outcome described in?",
        default=None,
    )
    studyEffectiveDescription: Optional[String] = Field(
        description="What time period does the study cover",
        default=None,
    )
    studyEffectiveDescription_ext: Optional[Element] = Field(
        description="Placeholder element for studyEffectiveDescription extensions",
        default=None,
        alias="_studyEffectiveDescription",
    )
    studyEffectiveDateTime: Optional[DateTime] = Field(
        description="What time period does the study cover",
        default=None,
    )
    studyEffectiveDateTime_ext: Optional[Element] = Field(
        description="Placeholder element for studyEffectiveDateTime extensions",
        default=None,
        alias="_studyEffectiveDateTime",
    )
    studyEffectivePeriod: Optional[Period] = Field(
        description="What time period does the study cover",
        default=None,
    )
    studyEffectiveDuration: Optional[Duration] = Field(
        description="What time period does the study cover",
        default=None,
    )
    studyEffectiveTiming: Optional[Timing] = Field(
        description="What time period does the study cover",
        default=None,
    )
    studyEffectiveTimeFromStart: Optional[Duration] = Field(
        description="Observation time from study start",
        default=None,
    )
    studyEffectiveGroupMeasure: Optional[Code] = Field(
        description="mean | median | mean-of-mean | mean-of-median | median-of-mean | median-of-median",
        default=None,
    )
    studyEffectiveGroupMeasure_ext: Optional[Element] = Field(
        description="Placeholder element for studyEffectiveGroupMeasure extensions",
        default=None,
        alias="_studyEffectiveGroupMeasure",
    )
    participantEffectiveDescription: Optional[String] = Field(
        description="What time period do participants cover",
        default=None,
    )
    participantEffectiveDescription_ext: Optional[Element] = Field(
        description="Placeholder element for participantEffectiveDescription extensions",
        default=None,
        alias="_participantEffectiveDescription",
    )
    participantEffectiveDateTime: Optional[DateTime] = Field(
        description="What time period do participants cover",
        default=None,
    )
    participantEffectiveDateTime_ext: Optional[Element] = Field(
        description="Placeholder element for participantEffectiveDateTime extensions",
        default=None,
        alias="_participantEffectiveDateTime",
    )
    participantEffectivePeriod: Optional[Period] = Field(
        description="What time period do participants cover",
        default=None,
    )
    participantEffectiveDuration: Optional[Duration] = Field(
        description="What time period do participants cover",
        default=None,
    )
    participantEffectiveTiming: Optional[Timing] = Field(
        description="What time period do participants cover",
        default=None,
    )
    participantEffectiveTimeFromStart: Optional[Duration] = Field(
        description="Observation time from study start",
        default=None,
    )
    participantEffectiveGroupMeasure: Optional[Code] = Field(
        description="mean | median | mean-of-mean | mean-of-median | median-of-mean | median-of-median",
        default=None,
    )
    participantEffectiveGroupMeasure_ext: Optional[Element] = Field(
        description="Placeholder element for participantEffectiveGroupMeasure extensions",
        default=None,
        alias="_participantEffectiveGroupMeasure",
    )

    @property
    def definition(self):
        return fhir_validators.get_type_choice_value_by_base(
            self,
            base="definition",
        )

    @property
    def studyEffective(self):
        return fhir_validators.get_type_choice_value_by_base(
            self,
            base="studyEffective",
        )

    @property
    def participantEffective(self):
        return fhir_validators.get_type_choice_value_by_base(
            self,
            base="participantEffective",
        )

    @field_validator(
        *(
            "participantEffectiveGroupMeasure",
            "participantEffectiveTimeFromStart",
            "participantEffectiveDescription",
            "studyEffectiveGroupMeasure",
            "studyEffectiveTimeFromStart",
            "studyEffectiveDescription",
            "unitOfMeasure",
            "exclude",
            "usageContext",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )

    @model_validator(mode="after")
    def definition_type_choice_validator(self):
        return fhir_validators.validate_type_choice_element(
            self,
            field_types=[CodeableConcept, Canonical, Expression, DataRequirement],
            field_name_base="definition",
            required=True,
        )

    @model_validator(mode="after")
    def studyEffective_type_choice_validator(self):
        return fhir_validators.validate_type_choice_element(
            self,
            field_types=[DateTime, Period, Duration, Timing],
            field_name_base="studyEffective",
            required=False,
        )

    @model_validator(mode="after")
    def participantEffective_type_choice_validator(self):
        return fhir_validators.validate_type_choice_element(
            self,
            field_types=[DateTime, Period, Duration, Timing],
            field_name_base="participantEffective",
            required=False,
        )


class ResearchElementDefinition(DomainResource):
    """
    The ResearchElementDefinition resource describes a "PICO" element that knowledge (evidence, assertion, recommendation) is about.
    """

    id: Optional[String] = Field(
        description="Logical id of this artifact",
        default=None,
    )
    id_ext: Optional[Element] = Field(
        description="Placeholder element for id extensions",
        default=None,
        alias="_id",
    )
    meta: Optional[Meta] = Field(
        description="Metadata about the resource.",
        default_factory=lambda: Meta(
            profile=[
                "http://hl7.org/fhir/StructureDefinition/ResearchElementDefinition"
            ]
        ),
    )
    implicitRules: Optional[Uri] = Field(
        description="A set of rules under which this content was created",
        default=None,
    )
    implicitRules_ext: Optional[Element] = Field(
        description="Placeholder element for implicitRules extensions",
        default=None,
        alias="_implicitRules",
    )
    language: Optional[Code] = Field(
        description="Language of the resource content",
        default=None,
    )
    language_ext: Optional[Element] = Field(
        description="Placeholder element for language extensions",
        default=None,
        alias="_language",
    )
    text: Optional[Narrative] = Field(
        description="Text summary of the resource, for human interpretation",
        default=None,
    )
    contained: Optional[List[Resource]] = Field(
        description="Contained, inline Resources",
        default=None,
    )
    extension: Optional[List[Extension]] = Field(
        description="Additional content defined by implementations",
        default=None,
    )
    modifierExtension: Optional[List[Extension]] = Field(
        description="Extensions that cannot be ignored",
        default=None,
    )
    url: Optional[Uri] = Field(
        description="Canonical identifier for this research element definition, represented as a URI (globally unique)",
        default=None,
    )
    url_ext: Optional[Element] = Field(
        description="Placeholder element for url extensions",
        default=None,
        alias="_url",
    )
    identifier: Optional[List[Identifier]] = Field(
        description="Additional identifier for the research element definition",
        default=None,
    )
    version: Optional[String] = Field(
        description="Business version of the research element definition",
        default=None,
    )
    version_ext: Optional[Element] = Field(
        description="Placeholder element for version extensions",
        default=None,
        alias="_version",
    )
    name: Optional[String] = Field(
        description="Name for this research element definition (computer friendly)",
        default=None,
    )
    name_ext: Optional[Element] = Field(
        description="Placeholder element for name extensions",
        default=None,
        alias="_name",
    )
    title: Optional[String] = Field(
        description="Name for this research element definition (human friendly)",
        default=None,
    )
    title_ext: Optional[Element] = Field(
        description="Placeholder element for title extensions",
        default=None,
        alias="_title",
    )
    shortTitle: Optional[String] = Field(
        description="Title for use in informal contexts",
        default=None,
    )
    shortTitle_ext: Optional[Element] = Field(
        description="Placeholder element for shortTitle extensions",
        default=None,
        alias="_shortTitle",
    )
    subtitle: Optional[String] = Field(
        description="Subordinate title of the ResearchElementDefinition",
        default=None,
    )
    subtitle_ext: Optional[Element] = Field(
        description="Placeholder element for subtitle extensions",
        default=None,
        alias="_subtitle",
    )
    status: Optional[Code] = Field(
        description="draft | active | retired | unknown",
        default=None,
    )
    status_ext: Optional[Element] = Field(
        description="Placeholder element for status extensions",
        default=None,
        alias="_status",
    )
    experimental: Optional[Boolean] = Field(
        description="For testing purposes, not real usage",
        default=None,
    )
    experimental_ext: Optional[Element] = Field(
        description="Placeholder element for experimental extensions",
        default=None,
        alias="_experimental",
    )
    subjectCodeableConcept: Optional[CodeableConcept] = Field(
        description="E.g. Patient, Practitioner, RelatedPerson, Organization, Location, Device",
        default=None,
    )
    subjectReference: Optional[Reference] = Field(
        description="E.g. Patient, Practitioner, RelatedPerson, Organization, Location, Device",
        default=None,
    )
    date: Optional[DateTime] = Field(
        description="Date last changed",
        default=None,
    )
    date_ext: Optional[Element] = Field(
        description="Placeholder element for date extensions",
        default=None,
        alias="_date",
    )
    publisher: Optional[String] = Field(
        description="Name of the publisher (organization or individual)",
        default=None,
    )
    publisher_ext: Optional[Element] = Field(
        description="Placeholder element for publisher extensions",
        default=None,
        alias="_publisher",
    )
    contact: Optional[List[ContactDetail]] = Field(
        description="Contact details for the publisher",
        default=None,
    )
    description: Optional[Markdown] = Field(
        description="Natural language description of the research element definition",
        default=None,
    )
    description_ext: Optional[Element] = Field(
        description="Placeholder element for description extensions",
        default=None,
        alias="_description",
    )
    comment: Optional[List[String]] = Field(
        description="Used for footnotes or explanatory notes",
        default=None,
    )
    comment_ext: Optional[Element] = Field(
        description="Placeholder element for comment extensions",
        default=None,
        alias="_comment",
    )
    useContext: Optional[List[UsageContext]] = Field(
        description="The context that the content is intended to support",
        default=None,
    )
    jurisdiction: Optional[List[CodeableConcept]] = Field(
        description="Intended jurisdiction for research element definition (if applicable)",
        default=None,
    )
    purpose: Optional[Markdown] = Field(
        description="Why this research element definition is defined",
        default=None,
    )
    purpose_ext: Optional[Element] = Field(
        description="Placeholder element for purpose extensions",
        default=None,
        alias="_purpose",
    )
    usage: Optional[String] = Field(
        description="Describes the clinical usage of the ResearchElementDefinition",
        default=None,
    )
    usage_ext: Optional[Element] = Field(
        description="Placeholder element for usage extensions",
        default=None,
        alias="_usage",
    )
    copyright: Optional[Markdown] = Field(
        description="Use and/or publishing restrictions",
        default=None,
    )
    copyright_ext: Optional[Element] = Field(
        description="Placeholder element for copyright extensions",
        default=None,
        alias="_copyright",
    )
    approvalDate: Optional[Date] = Field(
        description="When the research element definition was approved by publisher",
        default=None,
    )
    approvalDate_ext: Optional[Element] = Field(
        description="Placeholder element for approvalDate extensions",
        default=None,
        alias="_approvalDate",
    )
    lastReviewDate: Optional[Date] = Field(
        description="When the research element definition was last reviewed",
        default=None,
    )
    lastReviewDate_ext: Optional[Element] = Field(
        description="Placeholder element for lastReviewDate extensions",
        default=None,
        alias="_lastReviewDate",
    )
    effectivePeriod: Optional[Period] = Field(
        description="When the research element definition is expected to be used",
        default=None,
    )
    topic: Optional[List[CodeableConcept]] = Field(
        description="The category of the ResearchElementDefinition, such as Education, Treatment, Assessment, etc.",
        default=None,
    )
    author: Optional[List[ContactDetail]] = Field(
        description="Who authored the content",
        default=None,
    )
    editor: Optional[List[ContactDetail]] = Field(
        description="Who edited the content",
        default=None,
    )
    reviewer: Optional[List[ContactDetail]] = Field(
        description="Who reviewed the content",
        default=None,
    )
    endorser: Optional[List[ContactDetail]] = Field(
        description="Who endorsed the content",
        default=None,
    )
    relatedArtifact: Optional[List[RelatedArtifact]] = Field(
        description="Additional documentation, citations, etc.",
        default=None,
    )
    library: Optional[List[Canonical]] = Field(
        description="Logic used by the ResearchElementDefinition",
        default=None,
    )
    library_ext: Optional[Element] = Field(
        description="Placeholder element for library extensions",
        default=None,
        alias="_library",
    )
    type: Optional[Code] = Field(
        description="population | exposure | outcome",
        default=None,
    )
    type_ext: Optional[Element] = Field(
        description="Placeholder element for type extensions",
        default=None,
        alias="_type",
    )
    variableType: Optional[Code] = Field(
        description="dichotomous | continuous | descriptive",
        default=None,
    )
    variableType_ext: Optional[Element] = Field(
        description="Placeholder element for variableType extensions",
        default=None,
        alias="_variableType",
    )
    characteristic: Optional[List[ResearchElementDefinitionCharacteristic]] = Field(
        description="What defines the members of the research element",
        default=None,
    )
    resourceType: Literal["ResearchElementDefinition"] = Field(
        description=None,
        default="ResearchElementDefinition",
    )

    @property
    def subject(self):
        return fhir_validators.get_type_choice_value_by_base(
            self,
            base="subject",
        )

    @field_validator(
        *(
            "characteristic",
            "variableType",
            "type",
            "library",
            "relatedArtifact",
            "endorser",
            "reviewer",
            "editor",
            "author",
            "topic",
            "effectivePeriod",
            "lastReviewDate",
            "approvalDate",
            "copyright",
            "usage",
            "purpose",
            "jurisdiction",
            "useContext",
            "comment",
            "description",
            "contact",
            "publisher",
            "date",
            "experimental",
            "status",
            "subtitle",
            "shortTitle",
            "title",
            "name",
            "version",
            "identifier",
            "url",
            "modifierExtension",
            "extension",
            "text",
            "language",
            "implicitRules",
            "meta",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count()) or $this is Parameters",
            human="All FHIR elements must have a @value or children unless an empty Parameters resource",
            key="ele-1",
            severity="error",
        )

    @field_validator(*("contained",), mode="after", check_fields=None)
    @classmethod
    def FHIR_dom_r4b_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="($this is Citation or $this is Evidence or $this is EvidenceReport or $this is EvidenceVariable or $this is MedicinalProductDefinition or $this is PackagedProductDefinition or $this is AdministrableProductDefinition or $this is Ingredient or $this is ClinicalUseDefinition or $this is RegulatedAuthorization or $this is SubstanceDefinition or $this is SubscriptionStatus or $this is SubscriptionTopic) implies (%resource is Citation or %resource is Evidence or %resource is EvidenceReport or %resource is EvidenceVariable or %resource is MedicinalProductDefinition or %resource is PackagedProductDefinition or %resource is AdministrableProductDefinition or %resource is Ingredient or %resource is ClinicalUseDefinition or %resource is RegulatedAuthorization or %resource is SubstanceDefinition or %resource is SubscriptionStatus or %resource is SubscriptionTopic)",
            human="Containing new R4B resources within R4 resources may cause interoperability issues if instances are shared with R4 systems",
            key="dom-r4b",
            severity="warning",
        )

    @field_validator(
        *("modifierExtension", "extension"), mode="after", check_fields=None
    )
    @classmethod
    def FHIR_ext_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="extension.exists() != value.exists()",
            human="Must have either extensions or value[x], not both",
            key="ext-1",
            severity="error",
        )

    @model_validator(mode="after")
    def subject_type_choice_validator(self):
        return fhir_validators.validate_type_choice_element(
            self,
            field_types=[CodeableConcept, Reference],
            field_name_base="subject",
            required=False,
        )

    @model_validator(mode="after")
    def FHIR_dom_2_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.contained.empty()",
            human="If the resource is contained in another resource, it SHALL NOT contain nested Resources",
            key="dom-2",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_3_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.where(((id.exists() and ('#'+id in (%resource.descendants().reference | %resource.descendants().ofType(canonical) | %resource.descendants().ofType(uri) | %resource.descendants().ofType(url)))) or descendants().where(reference = '#').exists() or descendants().where(as(canonical) = '#').exists() or descendants().where(as(uri) = '#').exists()).not()).trace('unmatched', id).empty()",
            human="If the resource is contained in another resource, it SHALL be referred to from elsewhere in the resource or SHALL refer to the containing resource",
            key="dom-3",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_4_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.meta.versionId.empty() and contained.meta.lastUpdated.empty()",
            human="If a resource is contained in another resource, it SHALL NOT have a meta.versionId or a meta.lastUpdated",
            key="dom-4",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_5_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.meta.security.empty()",
            human="If a resource is contained in another resource, it SHALL NOT have a security label",
            key="dom-5",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_6_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="text.`div`.exists()",
            human="A resource should have narrative for robust management",
            key="dom-6",
            severity="warning",
        )

    @model_validator(mode="after")
    def FHIR_red_0_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="name.exists() implies name.matches('[A-Z]([A-Za-z0-9_]){0,254}')",
            human="Name should be usable as an identifier for the module by machine processing applications such as code generation",
            key="red-0",
            severity="warning",
        )
