# Fhircraft modules
from enum import Enum

# Standard modules
from typing import Literal, Optional, Union

# Pydantic modules
from pydantic import BaseModel, Field, field_validator, model_validator
from pydantic.fields import FieldInfo

import fhircraft
import fhircraft.fhir.resources.validators as fhir_validators
from fhircraft.fhir.resources.base import FHIRBaseModel
from fhircraft.fhir.resources.datatypes.primitives import *
from fhircraft.utils import model_rebuild_all

NoneType = type(None)

# Dynamic modules

from typing import List, Literal, Optional

from fhircraft.fhir.resources.base import FHIRBaseModel
from fhircraft.fhir.resources.datatypes.primitives import (
    Base64Binary,
    Boolean,
    Canonical,
    Code,
    Date,
    DateTime,
    Decimal,
    Id,
    Instant,
    Integer,
    Markdown,
    Oid,
    PositiveInt,
    String,
    Time,
    UnsignedInt,
    Uri,
    Url,
    Uuid,
)
from fhircraft.fhir.resources.datatypes.R4B.complex import (
    Address,
    Age,
    Annotation,
    Attachment,
    BackboneElement,
    CodeableConcept,
    Coding,
    ContactDetail,
    ContactPoint,
    Contributor,
    Count,
    DataRequirement,
    Distance,
    Dosage,
    Duration,
    Element,
    Expression,
    Extension,
    HumanName,
    Identifier,
    Meta,
    Money,
    ParameterDefinition,
    Period,
    Quantity,
    Range,
    Ratio,
    Reference,
    RelatedArtifact,
    Resource,
    SampledData,
    Signature,
    Timing,
    TriggerDefinition,
    UsageContext,
)


class ParametersParameter(BackboneElement):
    """
    A parameter passed to or received from the operation.
    """

    name: Optional[String] = Field(
        description="Name from the definition",
        default=None,
    )
    name_ext: Optional[Element] = Field(
        description="Placeholder element for name extensions",
        default=None,
        alias="_name",
    )
    valueBase64Binary: Optional[Base64Binary] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueBase64Binary_ext: Optional[Element] = Field(
        description="Placeholder element for valueBase64Binary extensions",
        default=None,
        alias="_valueBase64Binary",
    )
    valueBoolean: Optional[Boolean] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueBoolean_ext: Optional[Element] = Field(
        description="Placeholder element for valueBoolean extensions",
        default=None,
        alias="_valueBoolean",
    )
    valueCanonical: Optional[Canonical] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueCanonical_ext: Optional[Element] = Field(
        description="Placeholder element for valueCanonical extensions",
        default=None,
        alias="_valueCanonical",
    )
    valueCode: Optional[Code] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueCode_ext: Optional[Element] = Field(
        description="Placeholder element for valueCode extensions",
        default=None,
        alias="_valueCode",
    )
    valueDate: Optional[Date] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueDate_ext: Optional[Element] = Field(
        description="Placeholder element for valueDate extensions",
        default=None,
        alias="_valueDate",
    )
    valueDateTime: Optional[DateTime] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueDateTime_ext: Optional[Element] = Field(
        description="Placeholder element for valueDateTime extensions",
        default=None,
        alias="_valueDateTime",
    )
    valueDecimal: Optional[Decimal] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueDecimal_ext: Optional[Element] = Field(
        description="Placeholder element for valueDecimal extensions",
        default=None,
        alias="_valueDecimal",
    )
    valueId: Optional[Id] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueId_ext: Optional[Element] = Field(
        description="Placeholder element for valueId extensions",
        default=None,
        alias="_valueId",
    )
    valueInstant: Optional[Instant] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueInstant_ext: Optional[Element] = Field(
        description="Placeholder element for valueInstant extensions",
        default=None,
        alias="_valueInstant",
    )
    valueInteger: Optional[Integer] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueInteger_ext: Optional[Element] = Field(
        description="Placeholder element for valueInteger extensions",
        default=None,
        alias="_valueInteger",
    )
    valueMarkdown: Optional[Markdown] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueMarkdown_ext: Optional[Element] = Field(
        description="Placeholder element for valueMarkdown extensions",
        default=None,
        alias="_valueMarkdown",
    )
    valueOid: Optional[Oid] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueOid_ext: Optional[Element] = Field(
        description="Placeholder element for valueOid extensions",
        default=None,
        alias="_valueOid",
    )
    valuePositiveInt: Optional[PositiveInt] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valuePositiveInt_ext: Optional[Element] = Field(
        description="Placeholder element for valuePositiveInt extensions",
        default=None,
        alias="_valuePositiveInt",
    )
    valueString: Optional[String] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueString_ext: Optional[Element] = Field(
        description="Placeholder element for valueString extensions",
        default=None,
        alias="_valueString",
    )
    valueTime: Optional[Time] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueTime_ext: Optional[Element] = Field(
        description="Placeholder element for valueTime extensions",
        default=None,
        alias="_valueTime",
    )
    valueUnsignedInt: Optional[UnsignedInt] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueUnsignedInt_ext: Optional[Element] = Field(
        description="Placeholder element for valueUnsignedInt extensions",
        default=None,
        alias="_valueUnsignedInt",
    )
    valueUri: Optional[Uri] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueUri_ext: Optional[Element] = Field(
        description="Placeholder element for valueUri extensions",
        default=None,
        alias="_valueUri",
    )
    valueUrl: Optional[Url] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueUrl_ext: Optional[Element] = Field(
        description="Placeholder element for valueUrl extensions",
        default=None,
        alias="_valueUrl",
    )
    valueUuid: Optional[Uuid] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueUuid_ext: Optional[Element] = Field(
        description="Placeholder element for valueUuid extensions",
        default=None,
        alias="_valueUuid",
    )
    valueAddress: Optional[Address] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueAge: Optional[Age] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueAnnotation: Optional[Annotation] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueAttachment: Optional[Attachment] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueCodeableConcept: Optional[CodeableConcept] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueCoding: Optional[Coding] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueContactPoint: Optional[ContactPoint] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueCount: Optional[Count] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueDistance: Optional[Distance] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueDuration: Optional[Duration] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueHumanName: Optional[HumanName] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueIdentifier: Optional[Identifier] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueMoney: Optional[Money] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valuePeriod: Optional[Period] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueQuantity: Optional[Quantity] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueRange: Optional[Range] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueRatio: Optional[Ratio] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueReference: Optional[Reference] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueSampledData: Optional[SampledData] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueSignature: Optional[Signature] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueTiming: Optional[Timing] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueContactDetail: Optional[ContactDetail] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueContributor: Optional[Contributor] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueDataRequirement: Optional[DataRequirement] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueExpression: Optional[Expression] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueParameterDefinition: Optional[ParameterDefinition] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueRelatedArtifact: Optional[RelatedArtifact] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueTriggerDefinition: Optional[TriggerDefinition] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueUsageContext: Optional[UsageContext] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueDosage: Optional[Dosage] = Field(
        description="If parameter is a data type",
        default=None,
    )
    valueMeta: Optional[Meta] = Field(
        description="If parameter is a data type",
        default=None,
    )
    resource: Optional[Resource] = Field(
        description="If parameter is a whole resource",
        default=None,
    )
    part: Optional[List["ParametersParameter"]] = Field(
        description="Named part of a multi-part parameter",
        default=None,
    )

    @property
    def value(self):
        return fhir_validators.get_type_choice_value_by_base(
            self,
            base="value",
        )

    @field_validator(
        *(
            "part",
            "name",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )

    @model_validator(mode="after")
    def value_type_choice_validator(self):
        return fhir_validators.validate_type_choice_element(
            self,
            field_types=[
                Base64Binary,
                Boolean,
                Canonical,
                Code,
                Date,
                DateTime,
                Decimal,
                Id,
                Instant,
                Integer,
                Markdown,
                Oid,
                PositiveInt,
                String,
                Time,
                UnsignedInt,
                Uri,
                Url,
                Uuid,
                Address,
                Age,
                Annotation,
                Attachment,
                CodeableConcept,
                Coding,
                ContactPoint,
                Count,
                Distance,
                Duration,
                HumanName,
                Identifier,
                Money,
                Period,
                Quantity,
                Range,
                Ratio,
                Reference,
                SampledData,
                Signature,
                Timing,
                ContactDetail,
                Contributor,
                DataRequirement,
                Expression,
                ParameterDefinition,
                RelatedArtifact,
                TriggerDefinition,
                UsageContext,
                Dosage,
                Meta,
            ],
            field_name_base="value",
            required=False,
        )


class Parameters(Resource):
    """
    This resource is a non-persisted resource used to pass information into and back from an [operation](operations.html). It has no other use, and there is no RESTful endpoint associated with it.
    """

    id: Optional[String] = Field(
        description="Logical id of this artifact",
        default=None,
    )
    id_ext: Optional[Element] = Field(
        description="Placeholder element for id extensions",
        default=None,
        alias="_id",
    )
    meta: Optional[Meta] = Field(
        description="Metadata about the resource.",
        default_factory=lambda: Meta(profile=["http://hl7.org/fhir/StructureDefinition/Parameters"]),
    )
    implicitRules: Optional[Uri] = Field(
        description="A set of rules under which this content was created",
        default=None,
    )
    implicitRules_ext: Optional[Element] = Field(
        description="Placeholder element for implicitRules extensions",
        default=None,
        alias="_implicitRules",
    )
    language: Optional[Code] = Field(
        description="Language of the resource content",
        default=None,
    )
    language_ext: Optional[Element] = Field(
        description="Placeholder element for language extensions",
        default=None,
        alias="_language",
    )
    parameter: Optional[List[ParametersParameter]] = Field(
        description="Operation Parameter",
        default=None,
    )
    resourceType: Literal["Parameters"] = Field(
        description=None,
        default="Parameters",
    )

    @field_validator(
        *("parameter", "language", "implicitRules", "meta"),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count()) or $this is Parameters",
            human="All FHIR elements must have a @value or children unless an empty Parameters resource",
            key="ele-1",
            severity="error",
        )

    @field_validator(*("parameter",), mode="after", check_fields=None)
    @classmethod
    def FHIR_inv_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="(part.exists() and value.empty() and resource.empty()) or (part.empty() and (value.exists() xor resource.exists()))",
            human="A parameter must have one and only one of (value, resource, part)",
            key="inv-1",
            severity="error",
        )
