# Fhircraft modules
import fhircraft
from fhircraft.utils import model_rebuild_all
from fhircraft.fhir.resources.datatypes.primitives import *
from fhircraft.fhir.resources.base import FHIRBaseModel
import fhircraft.fhir.resources.validators as fhir_validators

# Pydantic modules
from pydantic import Field, field_validator, model_validator, BaseModel
from pydantic.fields import FieldInfo

# Standard modules
from typing import Optional, Literal, Union
from enum import Enum

NoneType = type(None)

# Dynamic modules

from fhircraft.fhir.resources.base import FHIRBaseModel

from typing import Optional, List, Literal

from fhircraft.fhir.resources.datatypes.primitives import (
    String,
    Uri,
    Code,
    Boolean,
    Integer,
)

from fhircraft.fhir.resources.datatypes.R4.complex import (
    Element,
    Meta,
    Narrative,
    Resource,
    Extension,
    CodeableConcept,
    BackboneElement,
    SubstanceAmount,
    Attachment,
    DomainResource,
)


class SubstancePolymerMonomerSetStartingMaterial(BackboneElement):
    """
    Todo.
    """

    material: Optional[CodeableConcept] = Field(
        description="Todo",
        default=None,
    )
    type: Optional[CodeableConcept] = Field(
        description="Todo",
        default=None,
    )
    isDefining: Optional[Boolean] = Field(
        description="Todo",
        default=None,
    )
    isDefining_ext: Optional[Element] = Field(
        description="Placeholder element for isDefining extensions",
        default=None,
        alias="_isDefining",
    )
    amount: Optional[SubstanceAmount] = Field(
        description="Todo",
        default=None,
    )

    @field_validator(
        *(
            "amount",
            "isDefining",
            "type",
            "material",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )


class SubstancePolymerMonomerSet(BackboneElement):
    """
    Todo.
    """

    ratioType: Optional[CodeableConcept] = Field(
        description="Todo",
        default=None,
    )
    startingMaterial: Optional[List[SubstancePolymerMonomerSetStartingMaterial]] = (
        Field(
            description="Todo",
            default=None,
        )
    )

    @field_validator(
        *(
            "startingMaterial",
            "ratioType",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )


class SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisation(BackboneElement):
    """
    Todo.
    """

    degree: Optional[CodeableConcept] = Field(
        description="Todo",
        default=None,
    )
    amount: Optional[SubstanceAmount] = Field(
        description="Todo",
        default=None,
    )

    @field_validator(
        *(
            "amount",
            "degree",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )


class SubstancePolymerRepeatRepeatUnitStructuralRepresentation(BackboneElement):
    """
    Todo.
    """

    type: Optional[CodeableConcept] = Field(
        description="Todo",
        default=None,
    )
    representation: Optional[String] = Field(
        description="Todo",
        default=None,
    )
    representation_ext: Optional[Element] = Field(
        description="Placeholder element for representation extensions",
        default=None,
        alias="_representation",
    )
    attachment: Optional[Attachment] = Field(
        description="Todo",
        default=None,
    )

    @field_validator(
        *(
            "attachment",
            "representation",
            "type",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )


class SubstancePolymerRepeatRepeatUnit(BackboneElement):
    """
    Todo.
    """

    orientationOfPolymerisation: Optional[CodeableConcept] = Field(
        description="Todo",
        default=None,
    )
    repeatUnit: Optional[String] = Field(
        description="Todo",
        default=None,
    )
    repeatUnit_ext: Optional[Element] = Field(
        description="Placeholder element for repeatUnit extensions",
        default=None,
        alias="_repeatUnit",
    )
    amount: Optional[SubstanceAmount] = Field(
        description="Todo",
        default=None,
    )
    degreeOfPolymerisation: Optional[
        List[SubstancePolymerRepeatRepeatUnitDegreeOfPolymerisation]
    ] = Field(
        description="Todo",
        default=None,
    )
    structuralRepresentation: Optional[
        List[SubstancePolymerRepeatRepeatUnitStructuralRepresentation]
    ] = Field(
        description="Todo",
        default=None,
    )

    @field_validator(
        *(
            "structuralRepresentation",
            "degreeOfPolymerisation",
            "amount",
            "repeatUnit",
            "orientationOfPolymerisation",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )


class SubstancePolymerRepeat(BackboneElement):
    """
    Todo.
    """

    numberOfUnits: Optional[Integer] = Field(
        description="Todo",
        default=None,
    )
    numberOfUnits_ext: Optional[Element] = Field(
        description="Placeholder element for numberOfUnits extensions",
        default=None,
        alias="_numberOfUnits",
    )
    averageMolecularFormula: Optional[String] = Field(
        description="Todo",
        default=None,
    )
    averageMolecularFormula_ext: Optional[Element] = Field(
        description="Placeholder element for averageMolecularFormula extensions",
        default=None,
        alias="_averageMolecularFormula",
    )
    repeatUnitAmountType: Optional[CodeableConcept] = Field(
        description="Todo",
        default=None,
    )
    repeatUnit: Optional[List[SubstancePolymerRepeatRepeatUnit]] = Field(
        description="Todo",
        default=None,
    )

    @field_validator(
        *(
            "repeatUnit",
            "repeatUnitAmountType",
            "averageMolecularFormula",
            "numberOfUnits",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
            "modifierExtension",
            "extension",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )


class SubstancePolymer(DomainResource):
    """
    Todo.
    """

    id: Optional[String] = Field(
        description="Logical id of this artifact",
        default=None,
    )
    id_ext: Optional[Element] = Field(
        description="Placeholder element for id extensions",
        default=None,
        alias="_id",
    )
    meta: Optional[Meta] = Field(
        description="Metadata about the resource.",
        default_factory=lambda: Meta(
            profile=["http://hl7.org/fhir/StructureDefinition/SubstancePolymer"]
        ),
    )
    implicitRules: Optional[Uri] = Field(
        description="A set of rules under which this content was created",
        default=None,
    )
    implicitRules_ext: Optional[Element] = Field(
        description="Placeholder element for implicitRules extensions",
        default=None,
        alias="_implicitRules",
    )
    language: Optional[Code] = Field(
        description="Language of the resource content",
        default=None,
    )
    language_ext: Optional[Element] = Field(
        description="Placeholder element for language extensions",
        default=None,
        alias="_language",
    )
    text: Optional[Narrative] = Field(
        description="Text summary of the resource, for human interpretation",
        default=None,
    )
    contained: Optional[List[Resource]] = Field(
        description="Contained, inline Resources",
        default=None,
    )
    extension: Optional[List[Extension]] = Field(
        description="Additional content defined by implementations",
        default=None,
    )
    modifierExtension: Optional[List[Extension]] = Field(
        description="Extensions that cannot be ignored",
        default=None,
    )
    class_: Optional[CodeableConcept] = Field(
        description="Todo",
        default=None,
    )
    geometry: Optional[CodeableConcept] = Field(
        description="Todo",
        default=None,
    )
    copolymerConnectivity: Optional[List[CodeableConcept]] = Field(
        description="Todo",
        default=None,
    )
    modification: Optional[List[String]] = Field(
        description="Todo",
        default=None,
    )
    modification_ext: Optional[Element] = Field(
        description="Placeholder element for modification extensions",
        default=None,
        alias="_modification",
    )
    monomerSet: Optional[List[SubstancePolymerMonomerSet]] = Field(
        description="Todo",
        default=None,
    )
    repeat: Optional[List[SubstancePolymerRepeat]] = Field(
        description="Todo",
        default=None,
    )
    resourceType: Literal["SubstancePolymer"] = Field(
        description=None,
        default="SubstancePolymer",
    )

    @field_validator(
        *(
            "repeat",
            "monomerSet",
            "modification",
            "copolymerConnectivity",
            "geometry",
            "class_",
            "modifierExtension",
            "extension",
            "text",
            "language",
            "implicitRules",
            "meta",
        ),
        mode="after",
        check_fields=None,
    )
    @classmethod
    def FHIR_ele_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="hasValue() or (children().count() > id.count())",
            human="All FHIR elements must have a @value or children",
            key="ele-1",
            severity="error",
        )

    @field_validator(
        *("modifierExtension", "extension"), mode="after", check_fields=None
    )
    @classmethod
    def FHIR_ext_1_constraint_validator(cls, value):
        return fhir_validators.validate_element_constraint(
            cls,
            value,
            expression="extension.exists() != value.exists()",
            human="Must have either extensions or value[x], not both",
            key="ext-1",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_2_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.contained.empty()",
            human="If the resource is contained in another resource, it SHALL NOT contain nested Resources",
            key="dom-2",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_3_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.where((('#'+id in (%resource.descendants().reference | %resource.descendants().ofType(canonical) | %resource.descendants().ofType(uri) | %resource.descendants().ofType(url))) or descendants().where(reference = '#').exists() or descendants().where(as(canonical) = '#').exists() or descendants().where(as(canonical) = '#').exists()).not()).trace('unmatched', id).empty()",
            human="If the resource is contained in another resource, it SHALL be referred to from elsewhere in the resource or SHALL refer to the containing resource",
            key="dom-3",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_4_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.meta.versionId.empty() and contained.meta.lastUpdated.empty()",
            human="If a resource is contained in another resource, it SHALL NOT have a meta.versionId or a meta.lastUpdated",
            key="dom-4",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_5_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="contained.meta.security.empty()",
            human="If a resource is contained in another resource, it SHALL NOT have a security label",
            key="dom-5",
            severity="error",
        )

    @model_validator(mode="after")
    def FHIR_dom_6_constraint_model_validator(self):
        return fhir_validators.validate_model_constraint(
            self,
            expression="text.`div`.exists()",
            human="A resource should have narrative for robust management",
            key="dom-6",
            severity="warning",
        )
