# PdPy

A Pure Data (Pd) scripting language written in Python.

The documentation exists here: [pdpy-org.github.io/doc](https://pdpy-org.github.io/doc)

## Installation

From console or better, a [virtual environment](https://pdpy-org.github.io/doc/virtual_env.html)

```console
pip install pdpy-lib
```

Then, from python

```python
import pdpy_lib as pdpy
```

## References

This project is inspired by many discussions and projects:

- Pure Data to XML: see [this discussion](https://lists.puredata.info/pipermail/pd-dev/2004-12/003316.html) on the pd-list archives.
- Pure Data to JSON: see [this other one](https://lists.puredata.info/pipermail/pd-dev/2012-06/018434.html) on the pd-list archives.
- Pure Data file format specifications were expained [here](http://puredata.info/docs/developer/PdFileFormat)
- *New* Pd file format [discussion](https://lists.puredata.info/pipermail/pd-dev/2007-09/009483.html) on the pd-list archives.
- `sebpiq`\'s repostirories: [WebPd_pd-parser](https://github.com/sebpiq/WebPd_pd-parser), as well as [pd-fileutils](https://github.com/sebpiq/pd-fileutils)
- `dylanburati`\'s [puredata-compiler](https://github.com/dylanburati/puredata-compiler)

## Copyright

- [libpd](https://github.com/libpd/libpd): Copyright (c) Peter Brinkmann & the libpd team 2010-2021
- [Pure Data](https://github.com/pure-data/pure-data): Copyright (c) 1997-2021 Miller Puckette and others.
- [pyaudio](https://people.csail.mit.edu/hubert/pyaudio): Copyright (c) 2006 Hubert Pham
