/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import Jama.Matrix;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class WalkCountDescriptor
implements IMolecularDescriptor {
    private static final int maxLength = 10;
    public String[] names = new String[20];

    public WalkCountDescriptor() {
        int n;
        int n2 = 0;
        for (n = 2; n <= 10; ++n) {
            this.names[n2++] = "MWC" + n;
        }
        this.names[n2++] = "TWC";
        for (n = 2; n <= 10; ++n) {
            this.names[n2++] = "SRW" + n;
        }
        this.names[n2++] = "TSRW";
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("Walk count", this.getClass().getName(), "$Id: WalkCountDescriptor.java 1 2014-06-06 15:00:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        int n2 = iAtomContainer2.getAtomCount();
        int[][] nArray = AdjacencyMatrix.getMatrix(iAtomContainer2);
        Matrix matrix = new Matrix(n2, n2);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix.set(i, j, nArray[i][j]);
            }
        }
        Matrix matrix2 = matrix;
        double[] dArray = new double[10];
        double[] dArray2 = new double[10];
        double d = n2;
        double d2 = n2;
        for (int i = 0; i < 10; ++i) {
            dArray[i] = 0.0;
            dArray2[i] = 0.0;
            for (n = 0; n < n2; ++n) {
                for (int j = 0; j < n2; ++j) {
                    int n3 = i;
                    dArray[n3] = dArray[n3] + matrix2.get(n, j);
                }
                int n4 = i;
                dArray2[n4] = dArray2[n4] + matrix2.get(n, n);
            }
            if (i == 0) {
                int n5 = i;
                dArray[n5] = dArray[n5] * 0.5;
            } else {
                dArray[i] = Math.log(1.0 + dArray[i]);
            }
            d += dArray[i];
            d2 += dArray2[i];
            dArray2[i] = Math.log(1.0 + dArray2[i]);
            matrix2 = matrix2.times(matrix);
        }
        d2 = Math.log(1.0 + d2);
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (n = 1; n < 10; ++n) {
            doubleArrayResult.add(dArray[n]);
        }
        doubleArrayResult.add(d);
        for (n = 1; n < 10; ++n) {
            doubleArrayResult.add(dArray2[n]);
        }
        doubleArrayResult.add(d2);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }
}

