/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import javax.vecmath.Point3d;
import libpadeldescriptor.AtomConstants;
import libpadeldescriptor.IntrinsicStateDescriptor;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;

public class PaDELWHIMDescriptor
implements IMolecularDescriptor {
    public String[] names = new String[wtypes.length * 13];
    private static final String[] wtypes = new String[]{"u", "m", "v", "e", "p", "i", "s"};

    public PaDELWHIMDescriptor() {
        int n = 0;
        for (String string : wtypes) {
            int n2;
            for (n2 = 1; n2 <= 3; ++n2) {
                this.names[n++] = "L" + n2 + string;
            }
            for (n2 = 1; n2 <= 2; ++n2) {
                this.names[n++] = "P" + n2 + string;
            }
            for (n2 = 1; n2 <= 3; ++n2) {
                this.names[n++] = "E" + n2 + string;
            }
            this.names[n++] = "T" + string;
            this.names[n++] = "A" + string;
            this.names[n++] = "V" + string;
            this.names[n++] = "K" + string;
            this.names[n++] = "D" + string;
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("WHIM", this.getClass().getName(), "$Id: PaDELWHIMDescriptor.java 1 2014-06-12 16:30:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        Object object;
        int n = iAtomContainer.getAtomCount();
        double[][] dArray = new double[wtypes.length][n];
        IntrinsicStateDescriptor intrinsicStateDescriptor = new IntrinsicStateDescriptor();
        int n2 = 0;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            int n3 = iAtomContainer.getAtom(i).getAtomicNumber();
            dArray[0][i] = 1.0;
            dArray[1][i] = n3 < AtomConstants.masses.length ? AtomConstants.masses[n3] / AtomConstants.masses[6] : Double.NaN;
            dArray[2][i] = n3 < AtomConstants.volumes.length ? AtomConstants.volumes[n3] / AtomConstants.volumes[6] : Double.NaN;
            dArray[3][i] = n3 < AtomConstants.sandersonelnegativities.length ? AtomConstants.sandersonelnegativities[n3] / AtomConstants.sandersonelnegativities[6] : Double.NaN;
            dArray[4][i] = n3 < AtomConstants.polarizabilities.length ? AtomConstants.polarizabilities[n3] / AtomConstants.polarizabilities[6] : Double.NaN;
            dArray[5][i] = n3 < AtomConstants.ionpotentials.length ? AtomConstants.ionpotentials[n3] / AtomConstants.ionpotentials[6] : Double.NaN;
            IAtom iAtom = iAtomContainer.getAtom(i);
            if (n3 == 1) {
                dArray[6][i] = 1.0;
                continue;
            }
            DoubleArrayResult doubleArrayResult = (DoubleArrayResult)intrinsicStateDescriptor.calculate(iAtom, iAtomContainer).getValue();
            dArray[6][i] = doubleArrayResult.get(0);
            if (n3 != 6) continue;
            ++n2;
            d += doubleArrayResult.get(0);
        }
        double d2 = d / (double)n2;
        for (int i = 0; i < n; ++i) {
            dArray[6][i] = dArray[6][i] / d2 + 7.0;
        }
        double[][] dArray2 = new double[iAtomContainer.getAtomCount()][3];
        for (int i = 0; i < n; ++i) {
            object = iAtomContainer.getAtom(i).getPoint3d();
            dArray2[i][0] = ((Point3d)object).x;
            dArray2[i][1] = ((Point3d)object).y;
            dArray2[i][2] = ((Point3d)object).z;
        }
        double[][] dArray3 = new double[3][wtypes.length];
        object = new double[3][wtypes.length];
        double[][] dArray4 = new double[3][wtypes.length];
        double[] dArray5 = new double[wtypes.length];
        double[] dArray6 = new double[wtypes.length];
        double[] dArray7 = new double[wtypes.length];
        double[] dArray8 = new double[wtypes.length];
        double[] dArray9 = new double[wtypes.length];
        for (int i = 0; i < wtypes.length; ++i) {
            int n4;
            int n5;
            int n6;
            PCA pCA = new PCA(dArray2, dArray[i]);
            double[] dArray10 = pCA.getEigenvalues();
            int[] nArray = new int[]{dArray10[0] > dArray10[1] && dArray10[0] > dArray10[2] ? 0 : (dArray10[1] > dArray10[0] && dArray10[1] > dArray10[2] ? 1 : 2), dArray10[0] < dArray10[1] && dArray10[0] > dArray10[2] || dArray10[0] < dArray10[2] && dArray10[0] > dArray10[1] ? 0 : (dArray10[1] < dArray10[0] && dArray10[1] > dArray10[2] || dArray10[1] < dArray10[2] && dArray10[1] > dArray10[0] ? 1 : 2), dArray10[0] < dArray10[1] && dArray10[0] < dArray10[2] ? 0 : (dArray10[1] < dArray10[0] && dArray10[1] < dArray10[2] ? 1 : 2)};
            double[] dArray11 = new double[3];
            for (int j = 0; j < 3; ++j) {
                dArray11[j] = dArray10[nArray[j]];
            }
            double d3 = 0.0;
            for (n6 = 0; n6 < 3; ++n6) {
                dArray3[n6][i] = dArray11[n6];
                d3 += dArray11[n6];
            }
            for (n6 = 0; n6 < 3; ++n6) {
                object[n6][i] = dArray11[n6] / d3;
            }
            double[][] dArray12 = pCA.getScores();
            double[][] dArray13 = new double[n][3];
            for (n5 = 0; n5 < 3; ++n5) {
                for (n4 = 0; n4 < n; ++n4) {
                    dArray13[n4][n5] = dArray12[n4][nArray[n5]];
                }
            }
            for (n5 = 0; n5 < 3; ++n5) {
                d3 = 0.0;
                for (n4 = 0; n4 < n; ++n4) {
                    d3 += dArray13[n4][n5] * dArray13[n4][n5] * dArray13[n4][n5] * dArray13[n4][n5];
                }
                dArray4[n5][i] = 1.0 / (d3 /= dArray11[n5] * dArray11[n5] * (double)n);
            }
            dArray5[i] = dArray11[0] + dArray11[1] + dArray11[2];
            dArray6[i] = dArray11[0] * dArray11[1] + dArray11[0] * dArray11[2] + dArray11[1] * dArray11[2];
            dArray7[i] = dArray5[i] + dArray6[i] + dArray11[0] * dArray11[1] * dArray11[2];
            dArray8[i] = 0.0;
            d3 = 0.0;
            for (n5 = 0; n5 < 3; ++n5) {
                d3 += dArray11[n5];
            }
            for (n5 = 0; n5 < 3; ++n5) {
                int n7 = i;
                dArray8[n7] = dArray8[n7] + Math.abs(dArray11[n5] / d3 - 0.3333333333333333);
            }
            int n8 = i;
            dArray8[n8] = dArray8[n8] / 1.3333333333333333;
            dArray9[i] = dArray4[0][i] + dArray4[1][i] + dArray4[2][i];
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (int i = 0; i < wtypes.length; ++i) {
            int n9;
            for (n9 = 0; n9 < 3; ++n9) {
                doubleArrayResult.add(dArray3[n9][i]);
            }
            for (n9 = 0; n9 < 2; ++n9) {
                doubleArrayResult.add((double)object[n9][i]);
            }
            for (n9 = 0; n9 < 3; ++n9) {
                doubleArrayResult.add(dArray4[n9][i]);
            }
            doubleArrayResult.add(dArray5[i]);
            doubleArrayResult.add(dArray6[i]);
            doubleArrayResult.add(dArray7[i]);
            doubleArrayResult.add(dArray8[i]);
            doubleArrayResult.add(dArray9[i]);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }

    private class PCA {
        Matrix evec;
        Matrix t;
        double[] eval;

        public PCA(double[][] dArray, double[] dArray2) {
            int n;
            int n2;
            int n3 = 3;
            int n4 = dArray2.length;
            double[][] dArray3 = new double[n4][n3];
            for (n2 = 0; n2 < n4; ++n2) {
                for (int i = 0; i < n3; ++i) {
                    dArray3[n2][i] = dArray[n2][i];
                }
            }
            for (n2 = 0; n2 < n3; ++n2) {
                double d = 0.0;
                for (n = 0; n < n4; ++n) {
                    d += dArray3[n][n2];
                }
                d /= (double)n4;
                for (n = 0; n < n4; ++n) {
                    dArray3[n][n2] = dArray3[n][n2] - d;
                }
            }
            double[][] dArray4 = new double[n3][n3];
            double d = 0.0;
            for (n = 0; n < n4; ++n) {
                d += dArray2[n];
            }
            for (n = 0; n < n3; ++n) {
                int n5;
                double d2 = 0.0;
                for (n5 = 0; n5 < n4; ++n5) {
                    d2 += dArray3[n5][n];
                }
                d2 /= (double)n4;
                for (n5 = 0; n5 < n3; ++n5) {
                    double d3 = 0.0;
                    for (int i = 0; i < n4; ++i) {
                        d3 += dArray3[i][n5];
                    }
                    d3 /= (double)n4;
                    double d4 = 0.0;
                    for (int i = 0; i < n4; ++i) {
                        d4 += dArray2[i] * (dArray3[i][n] - d2) * (dArray3[i][n5] - d3);
                    }
                    dArray4[n][n5] = d4 / d;
                }
            }
            Matrix matrix = new Matrix(dArray4);
            EigenvalueDecomposition eigenvalueDecomposition = matrix.eig();
            this.eval = eigenvalueDecomposition.getRealEigenvalues();
            this.evec = eigenvalueDecomposition.getV();
            Matrix matrix2 = new Matrix(dArray3);
            this.t = matrix2.times(this.evec);
        }

        double[] getEigenvalues() {
            return this.eval;
        }

        double[][] getScores() {
            return this.t.getArray();
        }
    }
}

