/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import libpadeldescriptor.AtomConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AtomValenceTool;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.atomic.IntrinsicStateDescriptorTest")
public class IntrinsicStateDescriptor
implements IAtomicDescriptor {
    private static final String[] names = new String[]{"IntrinsicState", "IntrinsicState2"};

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("intrinsicState", this.getClass().getName(), "$Id: IntrinsicStateDescriptor.java 1 2008-06-10 10:12:38Z yapchunwei $", "PaDEL");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtom iAtom, IAtomContainer iAtomContainer) {
        try {
            double d = 0.0;
            double d2 = 0.0;
            int n = iAtom.getAtomicNumber();
            if (n != 1) {
                int n2 = AtomContainerManipulator.countHydrogens(iAtomContainer, iAtom);
                double d3 = iAtomContainer.getConnectedBondsCount(iAtom) - n2;
                int n3 = AtomValenceTool.getValence(iAtom);
                double d4 = n3 - n2;
                double d5 = (double)(n3 - n2) / (double)(n - n3 - 1);
                int n4 = AtomConstants.period[n];
                d = (4.0 / (double)(n4 * n4) * d5 + 1.0) / d3;
                d2 = (4.0 / (double)(n4 * n4) * d4 + 1.0) / d3;
            }
            DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
            doubleArrayResult.add(d);
            doubleArrayResult.add(d2);
            return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, names);
        }
        catch (Exception exception) {
            return this.getDummyDescriptorValue(new CDKException("Error in ElementPTFactory: " + exception.getMessage()));
        }
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String string) {
        return null;
    }
}

