/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import libpadeldescriptor.AtomConstants;
import libpadeldescriptor.IntrinsicStateDescriptor;
import libpadeldescriptor.ShortestPaths;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class BaryszMatrixDescriptor
implements IMolecularDescriptor {
    public String[] names = new String[wtypes.length * dtypes.length];
    private static final String[] dtypes = new String[]{"SpAbs", "SpMax", "SpDiam", "SpAD", "SpMAD", "EE", "SM1", "VE1", "VE2", "VE3", "VR1", "VR2", "VR3"};
    private static final String[] wtypes = new String[]{"Z", "m", "v", "e", "p", "i", "s"};

    public BaryszMatrixDescriptor() {
        int n = 0;
        for (String string : wtypes) {
            for (String string2 : dtypes) {
                this.names[n++] = string2 + "_Dz" + string;
            }
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("Barysz matrix", this.getClass().getName(), "$Id: BaryszMatrixDescriptor.java 1 2014-06-12 11:00:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception exception) {
        int n = this.getDescriptorNames().length;
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult(n);
        for (int i = 0; i < n; ++i) {
            doubleArrayResult.add(Double.NaN);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames(), exception);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2;
        int n3;
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        int n4 = iAtomContainer2.getAtomCount();
        double[][] dArray = new double[wtypes.length][n4 + 1];
        for (n3 = 0; n3 < n4; ++n3) {
            n2 = iAtomContainer2.getAtom(n3).getAtomicNumber();
            dArray[0][n3] = n2;
            dArray[1][n3] = n2 < AtomConstants.masses.length ? AtomConstants.masses[n2] : Double.NaN;
            dArray[2][n3] = n2 < AtomConstants.volumes.length ? AtomConstants.volumes[n2] : Double.NaN;
            dArray[3][n3] = n2 < AtomConstants.sandersonelnegativities.length ? AtomConstants.sandersonelnegativities[n2] : Double.NaN;
            dArray[4][n3] = n2 < AtomConstants.polarizabilities.length ? AtomConstants.polarizabilities[n2] : Double.NaN;
            dArray[5][n3] = n2 < AtomConstants.ionpotentials.length ? AtomConstants.ionpotentials[n2] : Double.NaN;
        }
        n3 = 0;
        n2 = 0;
        double d = 0.0;
        IntrinsicStateDescriptor intrinsicStateDescriptor = new IntrinsicStateDescriptor();
        for (int i = 0; i < iAtomContainer.getAtomCount(); ++i) {
            IAtom iAtom = iAtomContainer.getAtom(i);
            n = iAtom.getAtomicNumber();
            if (n == 1) continue;
            DoubleArrayResult doubleArrayResult = (DoubleArrayResult)intrinsicStateDescriptor.calculate(iAtom, iAtomContainer).getValue();
            dArray[6][n3++] = doubleArrayResult.get(0);
            if (n != 6) continue;
            ++n2;
            d += doubleArrayResult.get(0);
        }
        double d2 = d / (double)n2;
        dArray[0][n4] = 6.0;
        dArray[1][n4] = AtomConstants.masses[6];
        dArray[2][n4] = AtomConstants.volumes[6];
        dArray[3][n4] = AtomConstants.sandersonelnegativities[6];
        dArray[4][n4] = AtomConstants.polarizabilities[6];
        dArray[5][n4] = AtomConstants.ionpotentials[6];
        dArray[6][n4] = d2;
        for (n = 0; n < wtypes.length; ++n) {
            for (int i = 0; i < n4 + 1; ++i) {
                if (!Double.isNaN(dArray[n][i])) continue;
                return this.getDummyDescriptorValue(new CDKException("Atom in molecule is not recognized"));
            }
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (int i = 0; i < wtypes.length; ++i) {
            int n5;
            double[][] dArray2 = this.getBaryszMatrix(iAtomContainer2, dArray[i]);
            Matrix matrix = new Matrix(dArray2);
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix);
            double[] dArray3 = eigenvalueDecomposition.getRealEigenvalues();
            double[][] dArray4 = eigenvalueDecomposition.getV().getArray();
            double d3 = 0.0;
            double d4 = dArray3[n4 - 1];
            double d5 = d4 - dArray3[0];
            double d6 = 0.0;
            double d7 = 0.0;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            double d12 = 0.0;
            double d13 = 0.0;
            double d14 = 0.0;
            double d15 = 0.0;
            for (int j = 0; j < n4; ++j) {
                d9 += dArray3[j];
                d3 += Math.abs(dArray3[j]);
                d10 += dArray4[j][0];
                d8 += Math.exp(dArray3[j]);
            }
            d8 = Double.isInfinite(d8) ? Math.log(Double.MAX_VALUE) : Math.log(1.0 + d8);
            d10 = Math.abs(d10);
            d11 = d10 / (double)n4;
            d12 = d10 == 0.0 ? 0.0 : 0.1 * (double)n4 * Math.log(d10);
            double d16 = Math.pow(1.0E-12, -0.5);
            for (IBond iBond : iAtomContainer2.bonds()) {
                int n6;
                n5 = iAtomContainer2.getAtomNumber(iBond.getAtom(0));
                d13 += Math.abs(dArray4[n5][0] * dArray4[n6 = iAtomContainer2.getAtomNumber(iBond.getAtom(1))][0]) < 1.0E-12 ? d16 : Math.pow(Math.abs(dArray4[n5][0] * dArray4[n6][0]), -0.5);
            }
            d14 = d13 / (double)n4;
            d15 = 0.1 * (double)n4 * Math.log(d13);
            double d17 = d9 / (double)n4;
            for (n5 = 0; n5 < n4; ++n5) {
                double d18 = Math.abs(dArray3[n5] - d17);
                d6 += d18;
                d7 += d18 / (double)n4;
            }
            doubleArrayResult.add(d3);
            doubleArrayResult.add(d4);
            doubleArrayResult.add(d5);
            doubleArrayResult.add(d6);
            doubleArrayResult.add(d7);
            doubleArrayResult.add(d8);
            doubleArrayResult.add(d9);
            doubleArrayResult.add(d10);
            doubleArrayResult.add(d11);
            doubleArrayResult.add(d12);
            doubleArrayResult.add(d13);
            doubleArrayResult.add(d14);
            doubleArrayResult.add(d15);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    private double[][] getBaryszMatrix(IAtomContainer iAtomContainer, double[] dArray) {
        int n = iAtomContainer.getAtomCount();
        double[][] dArray2 = new double[n][n];
        for (int i = 0; i < n; ++i) {
            dArray2[i][i] = 1.0 - dArray[n] / dArray[i];
        }
        double d = dArray[n] * dArray[n];
        for (int i = 0; i < n; ++i) {
            ShortestPaths shortestPaths = new ShortestPaths(iAtomContainer, iAtomContainer.getAtom(i));
            for (int j = i + 1; j < n; ++j) {
                int[] nArray = shortestPaths.pathTo(iAtomContainer.getAtom(j));
                for (int k = 0; k < nArray.length - 1; ++k) {
                    IAtom iAtom = iAtomContainer.getAtom(nArray[k]);
                    IAtom iAtom2 = iAtomContainer.getAtom(nArray[k + 1]);
                    IBond iBond = iAtomContainer.getBond(iAtom, iAtom2);
                    double d2 = d / (dArray[iAtomContainer.getAtomNumber(iAtom)] * dArray[iAtomContainer.getAtomNumber(iAtom2)]);
                    IBond.Order order = iBond.getOrder();
                    if (iBond.getFlag(5)) {
                        double[] dArray3 = dArray2[i];
                        int n2 = j;
                        dArray3[n2] = dArray3[n2] + d2 / 1.5;
                        continue;
                    }
                    if (order == IBond.Order.SINGLE) {
                        double[] dArray4 = dArray2[i];
                        int n3 = j;
                        dArray4[n3] = dArray4[n3] + d2;
                        continue;
                    }
                    if (order == IBond.Order.DOUBLE) {
                        double[] dArray5 = dArray2[i];
                        int n4 = j;
                        dArray5[n4] = dArray5[n4] + 0.5 * d2;
                        continue;
                    }
                    if (order != IBond.Order.TRIPLE) continue;
                    double[] dArray6 = dArray2[i];
                    int n5 = j;
                    dArray6[n5] = dArray6[n5] + d2 / 3.0;
                }
                dArray2[j][i] = dArray2[i][j];
            }
        }
        return dArray2;
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }
}

