/*
 * Decompiled with CFR 0.152.
 */
package libpadeldescriptor;

import java.util.ArrayList;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.matrix.TopologicalMatrix;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.DoubleArrayResult;
import org.openscience.cdk.qsar.result.DoubleArrayResultType;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class AtomPairs2DFingerprintCount
implements IMolecularDescriptor {
    private static final int maxDistance = 10;
    public String[] names;
    private static final String[] atypes = new String[]{"C", "N", "O", "S", "P", "F", "Cl", "Br", "I", "B", "Si", "X"};
    private ArrayList<Integer[]> atypesInt = new ArrayList();
    private Pair[] atomPairs;

    public AtomPairs2DFingerprintCount() {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 < atypes.length - 1; ++n3) {
            this.atypesInt.add(new Integer[1]);
        }
        this.atypesInt.add(new Integer[4]);
        this.atypesInt.get((int)0)[0] = 6;
        this.atypesInt.get((int)1)[0] = 7;
        this.atypesInt.get((int)2)[0] = 8;
        this.atypesInt.get((int)3)[0] = 16;
        this.atypesInt.get((int)4)[0] = 15;
        this.atypesInt.get((int)5)[0] = 9;
        this.atypesInt.get((int)6)[0] = 17;
        this.atypesInt.get((int)7)[0] = 35;
        this.atypesInt.get((int)8)[0] = 53;
        this.atypesInt.get((int)9)[0] = 5;
        this.atypesInt.get((int)10)[0] = 14;
        this.atypesInt.get((int)11)[0] = 9;
        this.atypesInt.get((int)11)[1] = 17;
        this.atypesInt.get((int)11)[2] = 35;
        this.atypesInt.get((int)11)[3] = 53;
        this.atomPairs = new Pair[atypes.length * atypes.length / 2 + atypes.length / 2];
        n3 = 0;
        for (n2 = 0; n2 < atypes.length; ++n2) {
            for (n = n2; n < atypes.length; ++n) {
                this.atomPairs[n3++] = new Pair(this.atypesInt.get(n2), this.atypesInt.get(n));
            }
        }
        n3 = 0;
        this.names = new String[10 * this.atomPairs.length];
        for (n2 = 1; n2 <= 10; ++n2) {
            for (n = 0; n < atypes.length; ++n) {
                for (int i = n; i < atypes.length; ++i) {
                    this.names[n3++] = "APC2D" + n2 + "_" + atypes[n] + "_" + atypes[i];
                }
            }
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("2D atom pairs count", this.getClass().getName(), "$Id: AtomPairs2DFingerprintCount.java 1 2014-06-13 09:00:00Z yapchunwei $", "PaDEL");
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String string) {
        return null;
    }

    @Override
    public void setParameters(Object[] objectArray) throws CDKException {
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return this.names;
    }

    private boolean isInArray(Integer[] integerArray, int n) {
        for (int i = 0; i < integerArray.length; ++i) {
            if (integerArray[i] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public DescriptorValue calculate(IAtomContainer iAtomContainer) {
        int n;
        int n2;
        IAtomContainer iAtomContainer2 = AtomContainerManipulator.removeHydrogens(iAtomContainer);
        int n3 = iAtomContainer2.getAtomCount();
        int[][] nArray = TopologicalMatrix.getMatrix(iAtomContainer2);
        double[][] dArray = new double[10][this.atomPairs.length];
        for (int i = 0; i < n3; ++i) {
            n2 = iAtomContainer2.getAtom(i).getAtomicNumber();
            for (n = i + 1; n < n3; ++n) {
                int n4 = iAtomContainer2.getAtom(n).getAtomicNumber();
                if (nArray[i][n] > 10) continue;
                for (int j = 0; j < this.atomPairs.length; ++j) {
                    if ((!this.isInArray(this.atomPairs[j].first, n2) || !this.isInArray(this.atomPairs[j].second, n4)) && (!this.isInArray(this.atomPairs[j].first, n4) || !this.isInArray(this.atomPairs[j].second, n2))) continue;
                    double[] dArray2 = dArray[nArray[i][n] - 1];
                    int n5 = j;
                    dArray2[n5] = dArray2[n5] + 1.0;
                }
            }
        }
        DoubleArrayResult doubleArrayResult = new DoubleArrayResult();
        for (n2 = 0; n2 < 10; ++n2) {
            for (n = 0; n < this.atomPairs.length; ++n) {
                doubleArrayResult.add(dArray[n2][n]);
            }
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), doubleArrayResult, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new DoubleArrayResultType(this.names.length);
    }

    private class Pair {
        public Integer[] first;
        public Integer[] second;

        public Pair() {
        }

        public Pair(Integer[] integerArray, Integer[] integerArray2) {
            this.first = integerArray;
            this.second = integerArray2;
        }
    }
}

