/*
 * Decompiled with CFR 0.152.
 */
package com.rapidminer.operator.chemistry;

import com.rapidminer.operator.IOObject;
import com.rapidminer.operator.OperatorDescription;
import com.rapidminer.operator.OperatorException;
import com.rapidminer.operator.chemistry.CompoundAbstractProcessing;
import com.rapidminer.operator.chemistry.Compounds;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class CompoundAddHydrogens
extends CompoundAbstractProcessing {
    public CompoundAddHydrogens(OperatorDescription operatorDescription) {
        super(operatorDescription);
    }

    public void doWork() throws OperatorException {
        Compounds compounds = (Compounds)this.molInput.getData();
        Compounds compounds2 = new Compounds();
        int n = compounds.size();
        for (int i = 0; i < n; ++i) {
            IAtomContainer iAtomContainer = compounds.getMolecule(i);
            try {
                compounds2.addMolecule(iAtomContainer.clone());
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)iAtomContainer);
                CDKHydrogenAdder cDKHydrogenAdder = CDKHydrogenAdder.getInstance((IChemObjectBuilder)DefaultChemObjectBuilder.getInstance());
                cDKHydrogenAdder.addImplicitHydrogens(iAtomContainer);
                AtomContainerManipulator.convertImplicitToExplicitHydrogens((IAtomContainer)iAtomContainer);
                AtomContainerManipulator.percieveAtomTypesAndConfigureAtoms((IAtomContainer)iAtomContainer);
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger("global").log(Level.FINE, null, exception);
            }
        }
        compounds.recalculateStatistics();
        this.molOriginal.deliver((IOObject)compounds2);
        this.molOutput.deliver((IOObject)compounds);
    }
}

