/*
 * Decompiled with CFR 0.152.
 */
package ambit2.base.data;

import ambit2.base.data.LiteratureEntry;
import ambit2.base.data.Property;
import ambit2.base.interfaces.IStructureRecord;
import java.util.Hashtable;
import java.util.Map;

public class StructureRecord
implements IStructureRecord {
    private static final long serialVersionUID = -650816773926953033L;
    protected boolean preferedStructure = true;
    protected int dataEntryID = -1;
    protected int id_srcdataset = -1;
    protected String inchiKey;
    protected String formula;
    protected String smiles;
    protected String inchi;
    protected int idchemical;
    protected int idstructure;
    protected String content;
    protected String format;
    protected LiteratureEntry reference = null;
    protected Map<Property, Object> properties;
    protected IStructureRecord.STRUC_TYPE type = IStructureRecord.STRUC_TYPE.NA;
    protected boolean selected = true;

    @Override
    public int getDataEntryID() {
        return this.dataEntryID;
    }

    @Override
    public void setDataEntryID(int n) {
        this.dataEntryID = n;
    }

    @Override
    public IStructureRecord.STRUC_TYPE getType() {
        return this.type;
    }

    @Override
    public void setType(IStructureRecord.STRUC_TYPE sTRUC_TYPE) {
        this.type = sTRUC_TYPE;
    }

    public Map<Property, Object> getMap() {
        return this.properties;
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    @Override
    public void setFormula(String string) {
        this.formula = string;
    }

    @Override
    public void setInchiKey(String string) {
        this.inchiKey = string;
    }

    @Override
    public String getInchiKey() {
        return this.inchiKey;
    }

    @Override
    public String getSmiles() {
        return this.smiles;
    }

    @Override
    public void setSmiles(String string) {
        this.smiles = string;
    }

    @Override
    public String getInchi() {
        return this.inchi;
    }

    @Override
    public void setInchi(String string) {
        this.inchi = string;
    }

    public StructureRecord() {
        this(-1, -1, "", "");
    }

    public StructureRecord(int n, int n2, String string, String string2) {
        this.setIdchemical(n);
        this.setIdstructure(n2);
        this.setContent(string);
        this.setFormat(string2);
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String string) {
        this.format = string;
    }

    @Override
    public int getIdchemical() {
        return this.idchemical;
    }

    @Override
    public void setIdchemical(int n) {
        this.idchemical = n;
    }

    @Override
    public int getIdstructure() {
        return this.idstructure;
    }

    @Override
    public void setIdstructure(int n) {
        this.idstructure = n;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getWritableContent() {
        int n;
        if (IStructureRecord.MOL_TYPE.SDF.toString().equals(this.getFormat()) && (n = this.getContent().indexOf("M  END")) > 0) {
            return this.getContent().substring(0, n + 6);
        }
        return this.getContent();
    }

    @Override
    public void setContent(String string) {
        this.content = string;
        this.setSmiles(null);
        this.setInchi(null);
        this.setInchiKey(null);
    }

    @Override
    public Object getProperty(Property property) {
        if (this.properties != null) {
            return this.properties.get(property);
        }
        return null;
    }

    @Override
    public void setProperty(Property property, Object object) {
        if (property == null) {
            return;
        }
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        if (object == null) {
            this.properties.remove(property);
        } else {
            this.properties.put(property, object);
        }
    }

    protected Map<Property, Object> createProperties() {
        return new Hashtable<Property, Object>();
    }

    @Override
    public Iterable<Property> getProperties() {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        return this.properties.keySet();
    }

    @Override
    public void clear() {
        this.setSmiles(null);
        this.setInchi(null);
        this.setInchiKey(null);
        this.setFormula(null);
        this.setContent(null);
        this.setIdchemical(-1);
        this.setIdstructure(-1);
        this.setReference(null);
        if (this.properties != null) {
            this.properties.clear();
        }
        this.setFormat(null);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("idchemical=");
        stringBuilder.append(this.getIdchemical());
        stringBuilder.append("\tidstructure=");
        stringBuilder.append(this.getIdstructure());
        return stringBuilder.toString();
    }

    @Override
    public int getNumberOfProperties() {
        if (this.properties == null) {
            return 0;
        }
        return this.properties.size();
    }

    @Override
    public Object removeProperty(Property property) {
        if (this.properties != null) {
            return this.properties.remove(property);
        }
        return null;
    }

    @Override
    public void clearProperties() {
        if (this.properties != null) {
            this.properties.clear();
        }
    }

    @Override
    public void addProperties(Map map) {
        for (Object k : map.keySet()) {
            if (k instanceof Property) {
                this.setProperty((Property)k, map.get(k));
                continue;
            }
            this.setProperty(Property.getInstance(k.toString(), this.getReference()), map.get(k));
        }
    }

    @Override
    public LiteratureEntry getReference() {
        return this.reference;
    }

    @Override
    public void setReference(LiteratureEntry literatureEntry) {
        this.reference = literatureEntry;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        StructureRecord structureRecord = new StructureRecord();
        structureRecord.setContent(this.getContent());
        structureRecord.setFormat(this.getFormat());
        structureRecord.setFormula(this.getFormula());
        structureRecord.setIdchemical(this.getIdchemical());
        structureRecord.setIdstructure(this.getIdstructure());
        structureRecord.setSmiles(this.getSmiles());
        structureRecord.setInchi(this.getInchi());
        for (Property property : this.getProperties()) {
            structureRecord.setProperty(property, this.getProperty(property));
        }
        return structureRecord;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean bl) {
        this.selected = true;
    }

    @Override
    public boolean usePreferedStructure() {
        return this.preferedStructure;
    }

    @Override
    public void setUsePreferedStructure(boolean bl) {
        this.preferedStructure = bl;
    }

    @Override
    public int getDatasetID() {
        return this.id_srcdataset;
    }

    @Override
    public void setDatasetID(int n) {
        this.id_srcdataset = n;
    }
}

